// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Status of the connection between an endpoint and a replication instance, including
/// Amazon Resource Names (ARNs) and the last error message issued.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Connection {
    /// <p>The ARN of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The ARN string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The connection status. This parameter can return one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"successful"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"testing"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The error message when the connection last failed.</p>
    pub last_failure_message: std::option::Option<std::string::String>,
    /// <p>The identifier of the endpoint. Identifiers must begin with a letter and must contain only
    /// ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
    /// consecutive hyphens.</p>
    pub endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The replication instance identifier. This parameter is stored as a lowercase
    /// string.</p>
    pub replication_instance_identifier: std::option::Option<std::string::String>,
}
impl Connection {
    /// <p>The ARN of the replication instance.</p>
    pub fn replication_instance_arn(&self) -> std::option::Option<&str> {
        self.replication_instance_arn.as_deref()
    }
    /// <p>The ARN string that uniquely identifies the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
    /// <p>The connection status. This parameter can return one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"successful"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"testing"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The error message when the connection last failed.</p>
    pub fn last_failure_message(&self) -> std::option::Option<&str> {
        self.last_failure_message.as_deref()
    }
    /// <p>The identifier of the endpoint. Identifiers must begin with a letter and must contain only
    /// ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
    /// consecutive hyphens.</p>
    pub fn endpoint_identifier(&self) -> std::option::Option<&str> {
        self.endpoint_identifier.as_deref()
    }
    /// <p>The replication instance identifier. This parameter is stored as a lowercase
    /// string.</p>
    pub fn replication_instance_identifier(&self) -> std::option::Option<&str> {
        self.replication_instance_identifier.as_deref()
    }
}
impl std::fmt::Debug for Connection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Connection");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("status", &self.status);
        formatter.field("last_failure_message", &self.last_failure_message);
        formatter.field("endpoint_identifier", &self.endpoint_identifier);
        formatter.field(
            "replication_instance_identifier",
            &self.replication_instance_identifier,
        );
        formatter.finish()
    }
}
/// See [`Connection`](crate::model::Connection)
pub mod connection {
    /// A builder for [`Connection`](crate::model::Connection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) last_failure_message: std::option::Option<std::string::String>,
        pub(crate) endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) replication_instance_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The ARN string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The ARN string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The connection status. This parameter can return one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"successful"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"testing"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The connection status. This parameter can return one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"successful"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"testing"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The error message when the connection last failed.</p>
        pub fn last_failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_failure_message = Some(input.into());
            self
        }
        /// <p>The error message when the connection last failed.</p>
        pub fn set_last_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_failure_message = input;
            self
        }
        /// <p>The identifier of the endpoint. Identifiers must begin with a letter and must contain only
        /// ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the endpoint. Identifiers must begin with a letter and must contain only
        /// ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_identifier = input;
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        pub fn replication_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = Some(input.into());
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`Connection`](crate::model::Connection)
        pub fn build(self) -> crate::model::Connection {
            crate::model::Connection {
                replication_instance_arn: self.replication_instance_arn,
                endpoint_arn: self.endpoint_arn,
                status: self.status,
                last_failure_message: self.last_failure_message,
                endpoint_identifier: self.endpoint_identifier,
                replication_instance_identifier: self.replication_instance_identifier,
            }
        }
    }
}
impl Connection {
    /// Creates a new builder-style object to manufacture [`Connection`](crate::model::Connection)
    pub fn builder() -> crate::model::connection::Builder {
        crate::model::connection::Builder::default()
    }
}

/// <p>Provides information that describes a replication task created by the
/// <code>CreateReplicationTask</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTask {
    /// <p>The user-assigned replication task identifier or name.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub replication_task_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the endpoint.</p>
    pub source_endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The ARN that uniquely identifies the endpoint.</p>
    pub target_endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The type of migration.</p>
    pub migration_type: std::option::Option<crate::model::MigrationTypeValue>,
    /// <p>Table mappings specified in the task.</p>
    pub table_mappings: std::option::Option<std::string::String>,
    /// <p>The settings for the replication task.</p>
    pub replication_task_settings: std::option::Option<std::string::String>,
    /// <p>The status of the replication task. This response parameter can return one of
    /// the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"moving"</code> – The task is being moved in response to running the
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
    /// <code>MoveReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"creating"</code> – The task is being created in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">
    /// <code>CreateReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code> – The task is being deleted in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
    /// <code>DeleteReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code> – The task failed to successfully complete the database
    /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed-move"</code> – The task failed to move in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
    /// <code>MoveReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"modifying"</code> – The task definition is being modified in response
    /// to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">
    /// <code>ModifyReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"ready"</code> – The task is in a <code>ready</code> state where it can
    /// respond to other task operations, such as <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> or <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
    /// <code>DeleteReplicationTask</code>
    /// </a>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"running"</code> – The task is performing a database migration in
    /// response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"starting"</code> – The task is preparing to perform a database
    /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"stopped"</code> – The task has stopped in response to running the
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
    /// <code>StopReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"stopping"</code> – The task is preparing to stop in response to
    /// running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
    /// <code>StopReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"testing"</code> – The database migration specified for this task is
    /// being tested in response to running either the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
    /// <code>StartReplicationTaskAssessmentRun</code>
    /// </a> or the
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
    /// <code>StartReplicationTaskAssessment</code>
    /// </a>
    /// operation.</p>
    /// <note>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
    /// <code>StartReplicationTaskAssessmentRun</code>
    /// </a> is
    /// an improved premigration task assessment operation. The <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
    /// <code>StartReplicationTaskAssessment</code>
    /// </a>
    /// operation assesses data type compatibility only between the source and target
    /// database of a given migration task. In contrast, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
    /// <code>StartReplicationTaskAssessmentRun</code>
    /// </a>
    /// enables you to specify a variety of premigration task assessments in addition to
    /// data type compatibility. These assessments include ones for the validity of primary key definitions and
    /// likely issues with database migration performance, among others.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The last error (failure) message generated for the replication task.</p>
    pub last_failure_message: std::option::Option<std::string::String>,
    /// <p>The reason the replication task was stopped. This response parameter can return one of
    /// the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_FULL_LOAD_COMPLETED"</code> – Full-load migration
    /// completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_CACHED_CHANGES_APPLIED"</code> – Change data capture (CDC)
    /// load completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_CACHED_CHANGES_NOT_APPLIED"</code> – In a
    /// full-load and CDC migration, the full load stopped as specified before starting the
    /// CDC migration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_SERVER_TIME"</code> – The migration stopped at the
    /// specified server time.</p>
    /// </li>
    /// </ul>
    pub stop_reason: std::option::Option<std::string::String>,
    /// <p>The date the replication task was created.</p>
    pub replication_task_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the replication task is scheduled to start.</p>
    pub replication_task_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
    /// <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p>The value can be in date, checkpoint, or LSN/SCN format.</p>
    /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
    /// <p>Checkpoint Example: --cdc-start-position
    /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
    /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
    pub cdc_start_position: std::option::Option<std::string::String>,
    /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
    /// either server time or commit time.</p>
    /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
    /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    pub cdc_stop_position: std::option::Option<std::string::String>,
    /// <p>Indicates the last checkpoint that occurred during a change data capture (CDC)
    /// operation. You can provide this value to the <code>CdcStartPosition</code> parameter to
    /// start a CDC operation that begins at that checkpoint.</p>
    pub recovery_checkpoint: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>The statistics for the task, including elapsed time, tables loaded, and table
    /// errors.</p>
    pub replication_task_stats: std::option::Option<crate::model::ReplicationTaskStats>,
    /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub task_data: std::option::Option<std::string::String>,
    /// <p>The ARN of the replication instance to which this task is moved in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
    /// <code>MoveReplicationTask</code>
    /// </a> operation. Otherwise, this response
    /// parameter isn't a member of the <code>ReplicationTask</code> object.</p>
    pub target_replication_instance_arn: std::option::Option<std::string::String>,
}
impl ReplicationTask {
    /// <p>The user-assigned replication task identifier or name.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub fn replication_task_identifier(&self) -> std::option::Option<&str> {
        self.replication_task_identifier.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) that uniquely identifies the endpoint.</p>
    pub fn source_endpoint_arn(&self) -> std::option::Option<&str> {
        self.source_endpoint_arn.as_deref()
    }
    /// <p>The ARN that uniquely identifies the endpoint.</p>
    pub fn target_endpoint_arn(&self) -> std::option::Option<&str> {
        self.target_endpoint_arn.as_deref()
    }
    /// <p>The ARN of the replication instance.</p>
    pub fn replication_instance_arn(&self) -> std::option::Option<&str> {
        self.replication_instance_arn.as_deref()
    }
    /// <p>The type of migration.</p>
    pub fn migration_type(&self) -> std::option::Option<&crate::model::MigrationTypeValue> {
        self.migration_type.as_ref()
    }
    /// <p>Table mappings specified in the task.</p>
    pub fn table_mappings(&self) -> std::option::Option<&str> {
        self.table_mappings.as_deref()
    }
    /// <p>The settings for the replication task.</p>
    pub fn replication_task_settings(&self) -> std::option::Option<&str> {
        self.replication_task_settings.as_deref()
    }
    /// <p>The status of the replication task. This response parameter can return one of
    /// the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"moving"</code> – The task is being moved in response to running the
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
    /// <code>MoveReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"creating"</code> – The task is being created in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">
    /// <code>CreateReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code> – The task is being deleted in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
    /// <code>DeleteReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code> – The task failed to successfully complete the database
    /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed-move"</code> – The task failed to move in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
    /// <code>MoveReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"modifying"</code> – The task definition is being modified in response
    /// to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">
    /// <code>ModifyReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"ready"</code> – The task is in a <code>ready</code> state where it can
    /// respond to other task operations, such as <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> or <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
    /// <code>DeleteReplicationTask</code>
    /// </a>. </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"running"</code> – The task is performing a database migration in
    /// response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"starting"</code> – The task is preparing to perform a database
    /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
    /// <code>StartReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"stopped"</code> – The task has stopped in response to running the
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
    /// <code>StopReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"stopping"</code> – The task is preparing to stop in response to
    /// running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
    /// <code>StopReplicationTask</code>
    /// </a> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"testing"</code> – The database migration specified for this task is
    /// being tested in response to running either the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
    /// <code>StartReplicationTaskAssessmentRun</code>
    /// </a> or the
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
    /// <code>StartReplicationTaskAssessment</code>
    /// </a>
    /// operation.</p>
    /// <note>
    /// <p>
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
    /// <code>StartReplicationTaskAssessmentRun</code>
    /// </a> is
    /// an improved premigration task assessment operation. The <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
    /// <code>StartReplicationTaskAssessment</code>
    /// </a>
    /// operation assesses data type compatibility only between the source and target
    /// database of a given migration task. In contrast, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
    /// <code>StartReplicationTaskAssessmentRun</code>
    /// </a>
    /// enables you to specify a variety of premigration task assessments in addition to
    /// data type compatibility. These assessments include ones for the validity of primary key definitions and
    /// likely issues with database migration performance, among others.</p>
    /// </note>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The last error (failure) message generated for the replication task.</p>
    pub fn last_failure_message(&self) -> std::option::Option<&str> {
        self.last_failure_message.as_deref()
    }
    /// <p>The reason the replication task was stopped. This response parameter can return one of
    /// the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_FULL_LOAD_COMPLETED"</code> – Full-load migration
    /// completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_CACHED_CHANGES_APPLIED"</code> – Change data capture (CDC)
    /// load completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_CACHED_CHANGES_NOT_APPLIED"</code> – In a
    /// full-load and CDC migration, the full load stopped as specified before starting the
    /// CDC migration.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"STOP_REASON_SERVER_TIME"</code> – The migration stopped at the
    /// specified server time.</p>
    /// </li>
    /// </ul>
    pub fn stop_reason(&self) -> std::option::Option<&str> {
        self.stop_reason.as_deref()
    }
    /// <p>The date the replication task was created.</p>
    pub fn replication_task_creation_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.replication_task_creation_date.as_ref()
    }
    /// <p>The date the replication task is scheduled to start.</p>
    pub fn replication_task_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.replication_task_start_date.as_ref()
    }
    /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
    /// <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p>The value can be in date, checkpoint, or LSN/SCN format.</p>
    /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
    /// <p>Checkpoint Example: --cdc-start-position
    /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
    /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
    pub fn cdc_start_position(&self) -> std::option::Option<&str> {
        self.cdc_start_position.as_deref()
    }
    /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
    /// either server time or commit time.</p>
    /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
    /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    pub fn cdc_stop_position(&self) -> std::option::Option<&str> {
        self.cdc_stop_position.as_deref()
    }
    /// <p>Indicates the last checkpoint that occurred during a change data capture (CDC)
    /// operation. You can provide this value to the <code>CdcStartPosition</code> parameter to
    /// start a CDC operation that begins at that checkpoint.</p>
    pub fn recovery_checkpoint(&self) -> std::option::Option<&str> {
        self.recovery_checkpoint.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
    pub fn replication_task_arn(&self) -> std::option::Option<&str> {
        self.replication_task_arn.as_deref()
    }
    /// <p>The statistics for the task, including elapsed time, tables loaded, and table
    /// errors.</p>
    pub fn replication_task_stats(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationTaskStats> {
        self.replication_task_stats.as_ref()
    }
    /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub fn task_data(&self) -> std::option::Option<&str> {
        self.task_data.as_deref()
    }
    /// <p>The ARN of the replication instance to which this task is moved in response to running
    /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
    /// <code>MoveReplicationTask</code>
    /// </a> operation. Otherwise, this response
    /// parameter isn't a member of the <code>ReplicationTask</code> object.</p>
    pub fn target_replication_instance_arn(&self) -> std::option::Option<&str> {
        self.target_replication_instance_arn.as_deref()
    }
}
impl std::fmt::Debug for ReplicationTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTask");
        formatter.field(
            "replication_task_identifier",
            &self.replication_task_identifier,
        );
        formatter.field("source_endpoint_arn", &self.source_endpoint_arn);
        formatter.field("target_endpoint_arn", &self.target_endpoint_arn);
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("migration_type", &self.migration_type);
        formatter.field("table_mappings", &self.table_mappings);
        formatter.field("replication_task_settings", &self.replication_task_settings);
        formatter.field("status", &self.status);
        formatter.field("last_failure_message", &self.last_failure_message);
        formatter.field("stop_reason", &self.stop_reason);
        formatter.field(
            "replication_task_creation_date",
            &self.replication_task_creation_date,
        );
        formatter.field(
            "replication_task_start_date",
            &self.replication_task_start_date,
        );
        formatter.field("cdc_start_position", &self.cdc_start_position);
        formatter.field("cdc_stop_position", &self.cdc_stop_position);
        formatter.field("recovery_checkpoint", &self.recovery_checkpoint);
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field("replication_task_stats", &self.replication_task_stats);
        formatter.field("task_data", &self.task_data);
        formatter.field(
            "target_replication_instance_arn",
            &self.target_replication_instance_arn,
        );
        formatter.finish()
    }
}
/// See [`ReplicationTask`](crate::model::ReplicationTask)
pub mod replication_task {
    /// A builder for [`ReplicationTask`](crate::model::ReplicationTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_identifier: std::option::Option<std::string::String>,
        pub(crate) source_endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) target_endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) migration_type: std::option::Option<crate::model::MigrationTypeValue>,
        pub(crate) table_mappings: std::option::Option<std::string::String>,
        pub(crate) replication_task_settings: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) last_failure_message: std::option::Option<std::string::String>,
        pub(crate) stop_reason: std::option::Option<std::string::String>,
        pub(crate) replication_task_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) replication_task_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) cdc_start_position: std::option::Option<std::string::String>,
        pub(crate) cdc_stop_position: std::option::Option<std::string::String>,
        pub(crate) recovery_checkpoint: std::option::Option<std::string::String>,
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) replication_task_stats: std::option::Option<crate::model::ReplicationTaskStats>,
        pub(crate) task_data: std::option::Option<std::string::String>,
        pub(crate) target_replication_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-assigned replication task identifier or name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn replication_task_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = Some(input.into());
            self
        }
        /// <p>The user-assigned replication task identifier or name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the endpoint.</p>
        pub fn source_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) that uniquely identifies the endpoint.</p>
        pub fn set_source_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_endpoint_arn = input;
            self
        }
        /// <p>The ARN that uniquely identifies the endpoint.</p>
        pub fn target_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The ARN that uniquely identifies the endpoint.</p>
        pub fn set_target_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_endpoint_arn = input;
            self
        }
        /// <p>The ARN of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The type of migration.</p>
        pub fn migration_type(mut self, input: crate::model::MigrationTypeValue) -> Self {
            self.migration_type = Some(input);
            self
        }
        /// <p>The type of migration.</p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.migration_type = input;
            self
        }
        /// <p>Table mappings specified in the task.</p>
        pub fn table_mappings(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_mappings = Some(input.into());
            self
        }
        /// <p>Table mappings specified in the task.</p>
        pub fn set_table_mappings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_mappings = input;
            self
        }
        /// <p>The settings for the replication task.</p>
        pub fn replication_task_settings(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_settings = Some(input.into());
            self
        }
        /// <p>The settings for the replication task.</p>
        pub fn set_replication_task_settings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_settings = input;
            self
        }
        /// <p>The status of the replication task. This response parameter can return one of
        /// the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"moving"</code> – The task is being moved in response to running the
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
        /// <code>MoveReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"creating"</code> – The task is being created in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">
        /// <code>CreateReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code> – The task is being deleted in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
        /// <code>DeleteReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code> – The task failed to successfully complete the database
        /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed-move"</code> – The task failed to move in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
        /// <code>MoveReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"modifying"</code> – The task definition is being modified in response
        /// to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">
        /// <code>ModifyReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"ready"</code> – The task is in a <code>ready</code> state where it can
        /// respond to other task operations, such as <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> or <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
        /// <code>DeleteReplicationTask</code>
        /// </a>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"running"</code> – The task is performing a database migration in
        /// response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"starting"</code> – The task is preparing to perform a database
        /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"stopped"</code> – The task has stopped in response to running the
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
        /// <code>StopReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"stopping"</code> – The task is preparing to stop in response to
        /// running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
        /// <code>StopReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"testing"</code> – The database migration specified for this task is
        /// being tested in response to running either the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
        /// <code>StartReplicationTaskAssessmentRun</code>
        /// </a> or the
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
        /// <code>StartReplicationTaskAssessment</code>
        /// </a>
        /// operation.</p>
        /// <note>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
        /// <code>StartReplicationTaskAssessmentRun</code>
        /// </a> is
        /// an improved premigration task assessment operation. The <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
        /// <code>StartReplicationTaskAssessment</code>
        /// </a>
        /// operation assesses data type compatibility only between the source and target
        /// database of a given migration task. In contrast, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
        /// <code>StartReplicationTaskAssessmentRun</code>
        /// </a>
        /// enables you to specify a variety of premigration task assessments in addition to
        /// data type compatibility. These assessments include ones for the validity of primary key definitions and
        /// likely issues with database migration performance, among others.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the replication task. This response parameter can return one of
        /// the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"moving"</code> – The task is being moved in response to running the
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
        /// <code>MoveReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"creating"</code> – The task is being created in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">
        /// <code>CreateReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code> – The task is being deleted in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
        /// <code>DeleteReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code> – The task failed to successfully complete the database
        /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed-move"</code> – The task failed to move in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
        /// <code>MoveReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"modifying"</code> – The task definition is being modified in response
        /// to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">
        /// <code>ModifyReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"ready"</code> – The task is in a <code>ready</code> state where it can
        /// respond to other task operations, such as <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> or <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html">
        /// <code>DeleteReplicationTask</code>
        /// </a>. </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"running"</code> – The task is performing a database migration in
        /// response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"starting"</code> – The task is preparing to perform a database
        /// migration in response to running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">
        /// <code>StartReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"stopped"</code> – The task has stopped in response to running the
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
        /// <code>StopReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"stopping"</code> – The task is preparing to stop in response to
        /// running the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html">
        /// <code>StopReplicationTask</code>
        /// </a> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"testing"</code> – The database migration specified for this task is
        /// being tested in response to running either the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
        /// <code>StartReplicationTaskAssessmentRun</code>
        /// </a> or the
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
        /// <code>StartReplicationTaskAssessment</code>
        /// </a>
        /// operation.</p>
        /// <note>
        /// <p>
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
        /// <code>StartReplicationTaskAssessmentRun</code>
        /// </a> is
        /// an improved premigration task assessment operation. The <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html">
        /// <code>StartReplicationTaskAssessment</code>
        /// </a>
        /// operation assesses data type compatibility only between the source and target
        /// database of a given migration task. In contrast, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html">
        /// <code>StartReplicationTaskAssessmentRun</code>
        /// </a>
        /// enables you to specify a variety of premigration task assessments in addition to
        /// data type compatibility. These assessments include ones for the validity of primary key definitions and
        /// likely issues with database migration performance, among others.</p>
        /// </note>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The last error (failure) message generated for the replication task.</p>
        pub fn last_failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_failure_message = Some(input.into());
            self
        }
        /// <p>The last error (failure) message generated for the replication task.</p>
        pub fn set_last_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_failure_message = input;
            self
        }
        /// <p>The reason the replication task was stopped. This response parameter can return one of
        /// the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_FULL_LOAD_COMPLETED"</code> – Full-load migration
        /// completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_CACHED_CHANGES_APPLIED"</code> – Change data capture (CDC)
        /// load completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_CACHED_CHANGES_NOT_APPLIED"</code> – In a
        /// full-load and CDC migration, the full load stopped as specified before starting the
        /// CDC migration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_SERVER_TIME"</code> – The migration stopped at the
        /// specified server time.</p>
        /// </li>
        /// </ul>
        pub fn stop_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.stop_reason = Some(input.into());
            self
        }
        /// <p>The reason the replication task was stopped. This response parameter can return one of
        /// the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_FULL_LOAD_COMPLETED"</code> – Full-load migration
        /// completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_CACHED_CHANGES_APPLIED"</code> – Change data capture (CDC)
        /// load completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_CACHED_CHANGES_NOT_APPLIED"</code> – In a
        /// full-load and CDC migration, the full load stopped as specified before starting the
        /// CDC migration.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"STOP_REASON_SERVER_TIME"</code> – The migration stopped at the
        /// specified server time.</p>
        /// </li>
        /// </ul>
        pub fn set_stop_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stop_reason = input;
            self
        }
        /// <p>The date the replication task was created.</p>
        pub fn replication_task_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.replication_task_creation_date = Some(input);
            self
        }
        /// <p>The date the replication task was created.</p>
        pub fn set_replication_task_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.replication_task_creation_date = input;
            self
        }
        /// <p>The date the replication task is scheduled to start.</p>
        pub fn replication_task_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.replication_task_start_date = Some(input);
            self
        }
        /// <p>The date the replication task is scheduled to start.</p>
        pub fn set_replication_task_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.replication_task_start_date = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        pub fn cdc_start_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_start_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// <code>CdcStartPosition</code> or <code>CdcStartTime</code> to specify when you want the CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_start_position = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_stop_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_stop_position = input;
            self
        }
        /// <p>Indicates the last checkpoint that occurred during a change data capture (CDC)
        /// operation. You can provide this value to the <code>CdcStartPosition</code> parameter to
        /// start a CDC operation that begins at that checkpoint.</p>
        pub fn recovery_checkpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.recovery_checkpoint = Some(input.into());
            self
        }
        /// <p>Indicates the last checkpoint that occurred during a change data capture (CDC)
        /// operation. You can provide this value to the <code>CdcStartPosition</code> parameter to
        /// start a CDC operation that begins at that checkpoint.</p>
        pub fn set_recovery_checkpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recovery_checkpoint = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>The statistics for the task, including elapsed time, tables loaded, and table
        /// errors.</p>
        pub fn replication_task_stats(mut self, input: crate::model::ReplicationTaskStats) -> Self {
            self.replication_task_stats = Some(input);
            self
        }
        /// <p>The statistics for the task, including elapsed time, tables loaded, and table
        /// errors.</p>
        pub fn set_replication_task_stats(
            mut self,
            input: std::option::Option<crate::model::ReplicationTaskStats>,
        ) -> Self {
            self.replication_task_stats = input;
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn task_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_data = Some(input.into());
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_task_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_data = input;
            self
        }
        /// <p>The ARN of the replication instance to which this task is moved in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
        /// <code>MoveReplicationTask</code>
        /// </a> operation. Otherwise, this response
        /// parameter isn't a member of the <code>ReplicationTask</code> object.</p>
        pub fn target_replication_instance_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the replication instance to which this task is moved in response to running
        /// the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html">
        /// <code>MoveReplicationTask</code>
        /// </a> operation. Otherwise, this response
        /// parameter isn't a member of the <code>ReplicationTask</code> object.</p>
        pub fn set_target_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_replication_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTask`](crate::model::ReplicationTask)
        pub fn build(self) -> crate::model::ReplicationTask {
            crate::model::ReplicationTask {
                replication_task_identifier: self.replication_task_identifier,
                source_endpoint_arn: self.source_endpoint_arn,
                target_endpoint_arn: self.target_endpoint_arn,
                replication_instance_arn: self.replication_instance_arn,
                migration_type: self.migration_type,
                table_mappings: self.table_mappings,
                replication_task_settings: self.replication_task_settings,
                status: self.status,
                last_failure_message: self.last_failure_message,
                stop_reason: self.stop_reason,
                replication_task_creation_date: self.replication_task_creation_date,
                replication_task_start_date: self.replication_task_start_date,
                cdc_start_position: self.cdc_start_position,
                cdc_stop_position: self.cdc_stop_position,
                recovery_checkpoint: self.recovery_checkpoint,
                replication_task_arn: self.replication_task_arn,
                replication_task_stats: self.replication_task_stats,
                task_data: self.task_data,
                target_replication_instance_arn: self.target_replication_instance_arn,
            }
        }
    }
}
impl ReplicationTask {
    /// Creates a new builder-style object to manufacture [`ReplicationTask`](crate::model::ReplicationTask)
    pub fn builder() -> crate::model::replication_task::Builder {
        crate::model::replication_task::Builder::default()
    }
}

/// <p>In response to a request by the <code>DescribeReplicationTasks</code> operation, this object provides
/// a collection of statistics about a replication task.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTaskStats {
    /// <p>The percent complete for the full load migration task.</p>
    pub full_load_progress_percent: i32,
    /// <p>The elapsed time of the task, in milliseconds.</p>
    pub elapsed_time_millis: i64,
    /// <p>The number of tables loaded for this task.</p>
    pub tables_loaded: i32,
    /// <p>The number of tables currently loading for this task.</p>
    pub tables_loading: i32,
    /// <p>The number of tables queued for this task.</p>
    pub tables_queued: i32,
    /// <p>The number of errors that have occurred during this task.</p>
    pub tables_errored: i32,
    /// <p>The date the replication task was started either with a fresh start or a target reload.</p>
    pub fresh_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the replication task was started either with a fresh start or a resume. For more information, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType">StartReplicationTaskType</a>.</p>
    pub start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the replication task was stopped.</p>
    pub stop_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the replication task full load was started.</p>
    pub full_load_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date the replication task full load was completed.</p>
    pub full_load_finish_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl ReplicationTaskStats {
    /// <p>The percent complete for the full load migration task.</p>
    pub fn full_load_progress_percent(&self) -> i32 {
        self.full_load_progress_percent
    }
    /// <p>The elapsed time of the task, in milliseconds.</p>
    pub fn elapsed_time_millis(&self) -> i64 {
        self.elapsed_time_millis
    }
    /// <p>The number of tables loaded for this task.</p>
    pub fn tables_loaded(&self) -> i32 {
        self.tables_loaded
    }
    /// <p>The number of tables currently loading for this task.</p>
    pub fn tables_loading(&self) -> i32 {
        self.tables_loading
    }
    /// <p>The number of tables queued for this task.</p>
    pub fn tables_queued(&self) -> i32 {
        self.tables_queued
    }
    /// <p>The number of errors that have occurred during this task.</p>
    pub fn tables_errored(&self) -> i32 {
        self.tables_errored
    }
    /// <p>The date the replication task was started either with a fresh start or a target reload.</p>
    pub fn fresh_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.fresh_start_date.as_ref()
    }
    /// <p>The date the replication task was started either with a fresh start or a resume. For more information, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType">StartReplicationTaskType</a>.</p>
    pub fn start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_date.as_ref()
    }
    /// <p>The date the replication task was stopped.</p>
    pub fn stop_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.stop_date.as_ref()
    }
    /// <p>The date the replication task full load was started.</p>
    pub fn full_load_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.full_load_start_date.as_ref()
    }
    /// <p>The date the replication task full load was completed.</p>
    pub fn full_load_finish_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.full_load_finish_date.as_ref()
    }
}
impl std::fmt::Debug for ReplicationTaskStats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTaskStats");
        formatter.field(
            "full_load_progress_percent",
            &self.full_load_progress_percent,
        );
        formatter.field("elapsed_time_millis", &self.elapsed_time_millis);
        formatter.field("tables_loaded", &self.tables_loaded);
        formatter.field("tables_loading", &self.tables_loading);
        formatter.field("tables_queued", &self.tables_queued);
        formatter.field("tables_errored", &self.tables_errored);
        formatter.field("fresh_start_date", &self.fresh_start_date);
        formatter.field("start_date", &self.start_date);
        formatter.field("stop_date", &self.stop_date);
        formatter.field("full_load_start_date", &self.full_load_start_date);
        formatter.field("full_load_finish_date", &self.full_load_finish_date);
        formatter.finish()
    }
}
/// See [`ReplicationTaskStats`](crate::model::ReplicationTaskStats)
pub mod replication_task_stats {
    /// A builder for [`ReplicationTaskStats`](crate::model::ReplicationTaskStats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) full_load_progress_percent: std::option::Option<i32>,
        pub(crate) elapsed_time_millis: std::option::Option<i64>,
        pub(crate) tables_loaded: std::option::Option<i32>,
        pub(crate) tables_loading: std::option::Option<i32>,
        pub(crate) tables_queued: std::option::Option<i32>,
        pub(crate) tables_errored: std::option::Option<i32>,
        pub(crate) fresh_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) stop_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) full_load_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) full_load_finish_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The percent complete for the full load migration task.</p>
        pub fn full_load_progress_percent(mut self, input: i32) -> Self {
            self.full_load_progress_percent = Some(input);
            self
        }
        /// <p>The percent complete for the full load migration task.</p>
        pub fn set_full_load_progress_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.full_load_progress_percent = input;
            self
        }
        /// <p>The elapsed time of the task, in milliseconds.</p>
        pub fn elapsed_time_millis(mut self, input: i64) -> Self {
            self.elapsed_time_millis = Some(input);
            self
        }
        /// <p>The elapsed time of the task, in milliseconds.</p>
        pub fn set_elapsed_time_millis(mut self, input: std::option::Option<i64>) -> Self {
            self.elapsed_time_millis = input;
            self
        }
        /// <p>The number of tables loaded for this task.</p>
        pub fn tables_loaded(mut self, input: i32) -> Self {
            self.tables_loaded = Some(input);
            self
        }
        /// <p>The number of tables loaded for this task.</p>
        pub fn set_tables_loaded(mut self, input: std::option::Option<i32>) -> Self {
            self.tables_loaded = input;
            self
        }
        /// <p>The number of tables currently loading for this task.</p>
        pub fn tables_loading(mut self, input: i32) -> Self {
            self.tables_loading = Some(input);
            self
        }
        /// <p>The number of tables currently loading for this task.</p>
        pub fn set_tables_loading(mut self, input: std::option::Option<i32>) -> Self {
            self.tables_loading = input;
            self
        }
        /// <p>The number of tables queued for this task.</p>
        pub fn tables_queued(mut self, input: i32) -> Self {
            self.tables_queued = Some(input);
            self
        }
        /// <p>The number of tables queued for this task.</p>
        pub fn set_tables_queued(mut self, input: std::option::Option<i32>) -> Self {
            self.tables_queued = input;
            self
        }
        /// <p>The number of errors that have occurred during this task.</p>
        pub fn tables_errored(mut self, input: i32) -> Self {
            self.tables_errored = Some(input);
            self
        }
        /// <p>The number of errors that have occurred during this task.</p>
        pub fn set_tables_errored(mut self, input: std::option::Option<i32>) -> Self {
            self.tables_errored = input;
            self
        }
        /// <p>The date the replication task was started either with a fresh start or a target reload.</p>
        pub fn fresh_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.fresh_start_date = Some(input);
            self
        }
        /// <p>The date the replication task was started either with a fresh start or a target reload.</p>
        pub fn set_fresh_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.fresh_start_date = input;
            self
        }
        /// <p>The date the replication task was started either with a fresh start or a resume. For more information, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType">StartReplicationTaskType</a>.</p>
        pub fn start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_date = Some(input);
            self
        }
        /// <p>The date the replication task was started either with a fresh start or a resume. For more information, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType">StartReplicationTaskType</a>.</p>
        pub fn set_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The date the replication task was stopped.</p>
        pub fn stop_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.stop_date = Some(input);
            self
        }
        /// <p>The date the replication task was stopped.</p>
        pub fn set_stop_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.stop_date = input;
            self
        }
        /// <p>The date the replication task full load was started.</p>
        pub fn full_load_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.full_load_start_date = Some(input);
            self
        }
        /// <p>The date the replication task full load was started.</p>
        pub fn set_full_load_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.full_load_start_date = input;
            self
        }
        /// <p>The date the replication task full load was completed.</p>
        pub fn full_load_finish_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.full_load_finish_date = Some(input);
            self
        }
        /// <p>The date the replication task full load was completed.</p>
        pub fn set_full_load_finish_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.full_load_finish_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTaskStats`](crate::model::ReplicationTaskStats)
        pub fn build(self) -> crate::model::ReplicationTaskStats {
            crate::model::ReplicationTaskStats {
                full_load_progress_percent: self.full_load_progress_percent.unwrap_or_default(),
                elapsed_time_millis: self.elapsed_time_millis.unwrap_or_default(),
                tables_loaded: self.tables_loaded.unwrap_or_default(),
                tables_loading: self.tables_loading.unwrap_or_default(),
                tables_queued: self.tables_queued.unwrap_or_default(),
                tables_errored: self.tables_errored.unwrap_or_default(),
                fresh_start_date: self.fresh_start_date,
                start_date: self.start_date,
                stop_date: self.stop_date,
                full_load_start_date: self.full_load_start_date,
                full_load_finish_date: self.full_load_finish_date,
            }
        }
    }
}
impl ReplicationTaskStats {
    /// Creates a new builder-style object to manufacture [`ReplicationTaskStats`](crate::model::ReplicationTaskStats)
    pub fn builder() -> crate::model::replication_task_stats::Builder {
        crate::model::replication_task_stats::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MigrationTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    Cdc,
    #[allow(missing_docs)] // documentation missing in model
    FullLoad,
    #[allow(missing_docs)] // documentation missing in model
    FullLoadAndCdc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MigrationTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "cdc" => MigrationTypeValue::Cdc,
            "full-load" => MigrationTypeValue::FullLoad,
            "full-load-and-cdc" => MigrationTypeValue::FullLoadAndCdc,
            other => MigrationTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MigrationTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MigrationTypeValue::from(s))
    }
}
impl MigrationTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MigrationTypeValue::Cdc => "cdc",
            MigrationTypeValue::FullLoad => "full-load",
            MigrationTypeValue::FullLoadAndCdc => "full-load-and-cdc",
            MigrationTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cdc", "full-load", "full-load-and-cdc"]
    }
}
impl AsRef<str> for MigrationTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that describes a premigration assessment run that you have started
/// using the <code>StartReplicationTaskAssessmentRun</code> operation.</p>
/// <p>Some of the information appears based on other operations that can return the
/// <code>ReplicationTaskAssessmentRun</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTaskAssessmentRun {
    /// <p>Amazon Resource Name (ARN) of this assessment run.</p>
    pub replication_task_assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the migration task associated with this premigration
    /// assessment run.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>Assessment run status. </p>
    /// <p>This status can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"cancelling"</code> – The assessment run was canceled by the
    /// <code>CancelReplicationTaskAssessmentRun</code> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code> – The assessment run was deleted by the
    /// <code>DeleteReplicationTaskAssessmentRun</code> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code> – At least one individual assessment completed with a
    /// <code>failed</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"error-provisioning"</code> – An internal error occurred while
    /// resources were provisioned (during <code>provisioning</code> status).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"error-executing"</code> – An internal error occurred while
    /// individual assessments ran (during <code>running</code> status).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"invalid state"</code> – The assessment run is in an unknown state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"passed"</code> – All individual assessments have completed, and none
    /// has a <code>failed</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"provisioning"</code> – Resources required to run individual
    /// assessments are being provisioned.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"running"</code> – Individual assessments are being run.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"starting"</code> – The assessment run is starting, but resources are not yet
    /// being provisioned for individual assessments.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>Date on which the assessment run was created using the
    /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
    pub replication_task_assessment_run_creation_date:
        std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indication of the completion progress for the individual assessments specified to
    /// run.</p>
    pub assessment_progress:
        std::option::Option<crate::model::ReplicationTaskAssessmentRunProgress>,
    /// <p>Last message generated by an individual assessment failure.</p>
    pub last_failure_message: std::option::Option<std::string::String>,
    /// <p>ARN of the service role used to start the assessment run using the
    /// <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Amazon S3 bucket where DMS stores the results of this assessment run.</p>
    pub result_location_bucket: std::option::Option<std::string::String>,
    /// <p>Folder in an Amazon S3 bucket where DMS stores the results of this assessment
    /// run.</p>
    pub result_location_folder: std::option::Option<std::string::String>,
    /// <p>Encryption mode used to encrypt the assessment run results.</p>
    pub result_encryption_mode: std::option::Option<std::string::String>,
    /// <p>ARN of the KMS encryption key used to encrypt the assessment run results.</p>
    pub result_kms_key_arn: std::option::Option<std::string::String>,
    /// <p>Unique name of the assessment run.</p>
    pub assessment_run_name: std::option::Option<std::string::String>,
}
impl ReplicationTaskAssessmentRun {
    /// <p>Amazon Resource Name (ARN) of this assessment run.</p>
    pub fn replication_task_assessment_run_arn(&self) -> std::option::Option<&str> {
        self.replication_task_assessment_run_arn.as_deref()
    }
    /// <p>ARN of the migration task associated with this premigration
    /// assessment run.</p>
    pub fn replication_task_arn(&self) -> std::option::Option<&str> {
        self.replication_task_arn.as_deref()
    }
    /// <p>Assessment run status. </p>
    /// <p>This status can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"cancelling"</code> – The assessment run was canceled by the
    /// <code>CancelReplicationTaskAssessmentRun</code> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code> – The assessment run was deleted by the
    /// <code>DeleteReplicationTaskAssessmentRun</code> operation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code> – At least one individual assessment completed with a
    /// <code>failed</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"error-provisioning"</code> – An internal error occurred while
    /// resources were provisioned (during <code>provisioning</code> status).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"error-executing"</code> – An internal error occurred while
    /// individual assessments ran (during <code>running</code> status).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"invalid state"</code> – The assessment run is in an unknown state.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"passed"</code> – All individual assessments have completed, and none
    /// has a <code>failed</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"provisioning"</code> – Resources required to run individual
    /// assessments are being provisioned.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"running"</code> – Individual assessments are being run.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"starting"</code> – The assessment run is starting, but resources are not yet
    /// being provisioned for individual assessments.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Date on which the assessment run was created using the
    /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
    pub fn replication_task_assessment_run_creation_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.replication_task_assessment_run_creation_date.as_ref()
    }
    /// <p>Indication of the completion progress for the individual assessments specified to
    /// run.</p>
    pub fn assessment_progress(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationTaskAssessmentRunProgress> {
        self.assessment_progress.as_ref()
    }
    /// <p>Last message generated by an individual assessment failure.</p>
    pub fn last_failure_message(&self) -> std::option::Option<&str> {
        self.last_failure_message.as_deref()
    }
    /// <p>ARN of the service role used to start the assessment run using the
    /// <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the <code>iam:PassRole</code> action.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p>Amazon S3 bucket where DMS stores the results of this assessment run.</p>
    pub fn result_location_bucket(&self) -> std::option::Option<&str> {
        self.result_location_bucket.as_deref()
    }
    /// <p>Folder in an Amazon S3 bucket where DMS stores the results of this assessment
    /// run.</p>
    pub fn result_location_folder(&self) -> std::option::Option<&str> {
        self.result_location_folder.as_deref()
    }
    /// <p>Encryption mode used to encrypt the assessment run results.</p>
    pub fn result_encryption_mode(&self) -> std::option::Option<&str> {
        self.result_encryption_mode.as_deref()
    }
    /// <p>ARN of the KMS encryption key used to encrypt the assessment run results.</p>
    pub fn result_kms_key_arn(&self) -> std::option::Option<&str> {
        self.result_kms_key_arn.as_deref()
    }
    /// <p>Unique name of the assessment run.</p>
    pub fn assessment_run_name(&self) -> std::option::Option<&str> {
        self.assessment_run_name.as_deref()
    }
}
impl std::fmt::Debug for ReplicationTaskAssessmentRun {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTaskAssessmentRun");
        formatter.field(
            "replication_task_assessment_run_arn",
            &self.replication_task_assessment_run_arn,
        );
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field("status", &self.status);
        formatter.field(
            "replication_task_assessment_run_creation_date",
            &self.replication_task_assessment_run_creation_date,
        );
        formatter.field("assessment_progress", &self.assessment_progress);
        formatter.field("last_failure_message", &self.last_failure_message);
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("result_location_bucket", &self.result_location_bucket);
        formatter.field("result_location_folder", &self.result_location_folder);
        formatter.field("result_encryption_mode", &self.result_encryption_mode);
        formatter.field("result_kms_key_arn", &self.result_kms_key_arn);
        formatter.field("assessment_run_name", &self.assessment_run_name);
        formatter.finish()
    }
}
/// See [`ReplicationTaskAssessmentRun`](crate::model::ReplicationTaskAssessmentRun)
pub mod replication_task_assessment_run {
    /// A builder for [`ReplicationTaskAssessmentRun`](crate::model::ReplicationTaskAssessmentRun)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) replication_task_assessment_run_creation_date:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) assessment_progress:
            std::option::Option<crate::model::ReplicationTaskAssessmentRunProgress>,
        pub(crate) last_failure_message: std::option::Option<std::string::String>,
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) result_location_bucket: std::option::Option<std::string::String>,
        pub(crate) result_location_folder: std::option::Option<std::string::String>,
        pub(crate) result_encryption_mode: std::option::Option<std::string::String>,
        pub(crate) result_kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_run_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of this assessment run.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of this assessment run.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = input;
            self
        }
        /// <p>ARN of the migration task associated with this premigration
        /// assessment run.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>ARN of the migration task associated with this premigration
        /// assessment run.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>Assessment run status. </p>
        /// <p>This status can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"cancelling"</code> – The assessment run was canceled by the
        /// <code>CancelReplicationTaskAssessmentRun</code> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code> – The assessment run was deleted by the
        /// <code>DeleteReplicationTaskAssessmentRun</code> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code> – At least one individual assessment completed with a
        /// <code>failed</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"error-provisioning"</code> – An internal error occurred while
        /// resources were provisioned (during <code>provisioning</code> status).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"error-executing"</code> – An internal error occurred while
        /// individual assessments ran (during <code>running</code> status).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"invalid state"</code> – The assessment run is in an unknown state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"passed"</code> – All individual assessments have completed, and none
        /// has a <code>failed</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"provisioning"</code> – Resources required to run individual
        /// assessments are being provisioned.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"running"</code> – Individual assessments are being run.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"starting"</code> – The assessment run is starting, but resources are not yet
        /// being provisioned for individual assessments.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Assessment run status. </p>
        /// <p>This status can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"cancelling"</code> – The assessment run was canceled by the
        /// <code>CancelReplicationTaskAssessmentRun</code> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code> – The assessment run was deleted by the
        /// <code>DeleteReplicationTaskAssessmentRun</code> operation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code> – At least one individual assessment completed with a
        /// <code>failed</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"error-provisioning"</code> – An internal error occurred while
        /// resources were provisioned (during <code>provisioning</code> status).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"error-executing"</code> – An internal error occurred while
        /// individual assessments ran (during <code>running</code> status).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"invalid state"</code> – The assessment run is in an unknown state.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"passed"</code> – All individual assessments have completed, and none
        /// has a <code>failed</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"provisioning"</code> – Resources required to run individual
        /// assessments are being provisioned.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"running"</code> – Individual assessments are being run.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"starting"</code> – The assessment run is starting, but resources are not yet
        /// being provisioned for individual assessments.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Date on which the assessment run was created using the
        /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
        pub fn replication_task_assessment_run_creation_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.replication_task_assessment_run_creation_date = Some(input);
            self
        }
        /// <p>Date on which the assessment run was created using the
        /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
        pub fn set_replication_task_assessment_run_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.replication_task_assessment_run_creation_date = input;
            self
        }
        /// <p>Indication of the completion progress for the individual assessments specified to
        /// run.</p>
        pub fn assessment_progress(
            mut self,
            input: crate::model::ReplicationTaskAssessmentRunProgress,
        ) -> Self {
            self.assessment_progress = Some(input);
            self
        }
        /// <p>Indication of the completion progress for the individual assessments specified to
        /// run.</p>
        pub fn set_assessment_progress(
            mut self,
            input: std::option::Option<crate::model::ReplicationTaskAssessmentRunProgress>,
        ) -> Self {
            self.assessment_progress = input;
            self
        }
        /// <p>Last message generated by an individual assessment failure.</p>
        pub fn last_failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_failure_message = Some(input.into());
            self
        }
        /// <p>Last message generated by an individual assessment failure.</p>
        pub fn set_last_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_failure_message = input;
            self
        }
        /// <p>ARN of the service role used to start the assessment run using the
        /// <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the service role used to start the assessment run using the
        /// <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>Amazon S3 bucket where DMS stores the results of this assessment run.</p>
        pub fn result_location_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_location_bucket = Some(input.into());
            self
        }
        /// <p>Amazon S3 bucket where DMS stores the results of this assessment run.</p>
        pub fn set_result_location_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_location_bucket = input;
            self
        }
        /// <p>Folder in an Amazon S3 bucket where DMS stores the results of this assessment
        /// run.</p>
        pub fn result_location_folder(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_location_folder = Some(input.into());
            self
        }
        /// <p>Folder in an Amazon S3 bucket where DMS stores the results of this assessment
        /// run.</p>
        pub fn set_result_location_folder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_location_folder = input;
            self
        }
        /// <p>Encryption mode used to encrypt the assessment run results.</p>
        pub fn result_encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_encryption_mode = Some(input.into());
            self
        }
        /// <p>Encryption mode used to encrypt the assessment run results.</p>
        pub fn set_result_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_encryption_mode = input;
            self
        }
        /// <p>ARN of the KMS encryption key used to encrypt the assessment run results.</p>
        pub fn result_kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_kms_key_arn = Some(input.into());
            self
        }
        /// <p>ARN of the KMS encryption key used to encrypt the assessment run results.</p>
        pub fn set_result_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_kms_key_arn = input;
            self
        }
        /// <p>Unique name of the assessment run.</p>
        pub fn assessment_run_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_name = Some(input.into());
            self
        }
        /// <p>Unique name of the assessment run.</p>
        pub fn set_assessment_run_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTaskAssessmentRun`](crate::model::ReplicationTaskAssessmentRun)
        pub fn build(self) -> crate::model::ReplicationTaskAssessmentRun {
            crate::model::ReplicationTaskAssessmentRun {
                replication_task_assessment_run_arn: self.replication_task_assessment_run_arn,
                replication_task_arn: self.replication_task_arn,
                status: self.status,
                replication_task_assessment_run_creation_date: self
                    .replication_task_assessment_run_creation_date,
                assessment_progress: self.assessment_progress,
                last_failure_message: self.last_failure_message,
                service_access_role_arn: self.service_access_role_arn,
                result_location_bucket: self.result_location_bucket,
                result_location_folder: self.result_location_folder,
                result_encryption_mode: self.result_encryption_mode,
                result_kms_key_arn: self.result_kms_key_arn,
                assessment_run_name: self.assessment_run_name,
            }
        }
    }
}
impl ReplicationTaskAssessmentRun {
    /// Creates a new builder-style object to manufacture [`ReplicationTaskAssessmentRun`](crate::model::ReplicationTaskAssessmentRun)
    pub fn builder() -> crate::model::replication_task_assessment_run::Builder {
        crate::model::replication_task_assessment_run::Builder::default()
    }
}

/// <p>The progress values reported by the <code>AssessmentProgress</code> response
/// element.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTaskAssessmentRunProgress {
    /// <p>The number of individual assessments that are specified to run.</p>
    pub individual_assessment_count: i32,
    /// <p>The number of individual assessments that have completed, successfully or not.</p>
    pub individual_assessment_completed_count: i32,
}
impl ReplicationTaskAssessmentRunProgress {
    /// <p>The number of individual assessments that are specified to run.</p>
    pub fn individual_assessment_count(&self) -> i32 {
        self.individual_assessment_count
    }
    /// <p>The number of individual assessments that have completed, successfully or not.</p>
    pub fn individual_assessment_completed_count(&self) -> i32 {
        self.individual_assessment_completed_count
    }
}
impl std::fmt::Debug for ReplicationTaskAssessmentRunProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTaskAssessmentRunProgress");
        formatter.field(
            "individual_assessment_count",
            &self.individual_assessment_count,
        );
        formatter.field(
            "individual_assessment_completed_count",
            &self.individual_assessment_completed_count,
        );
        formatter.finish()
    }
}
/// See [`ReplicationTaskAssessmentRunProgress`](crate::model::ReplicationTaskAssessmentRunProgress)
pub mod replication_task_assessment_run_progress {
    /// A builder for [`ReplicationTaskAssessmentRunProgress`](crate::model::ReplicationTaskAssessmentRunProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) individual_assessment_count: std::option::Option<i32>,
        pub(crate) individual_assessment_completed_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The number of individual assessments that are specified to run.</p>
        pub fn individual_assessment_count(mut self, input: i32) -> Self {
            self.individual_assessment_count = Some(input);
            self
        }
        /// <p>The number of individual assessments that are specified to run.</p>
        pub fn set_individual_assessment_count(mut self, input: std::option::Option<i32>) -> Self {
            self.individual_assessment_count = input;
            self
        }
        /// <p>The number of individual assessments that have completed, successfully or not.</p>
        pub fn individual_assessment_completed_count(mut self, input: i32) -> Self {
            self.individual_assessment_completed_count = Some(input);
            self
        }
        /// <p>The number of individual assessments that have completed, successfully or not.</p>
        pub fn set_individual_assessment_completed_count(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.individual_assessment_completed_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTaskAssessmentRunProgress`](crate::model::ReplicationTaskAssessmentRunProgress)
        pub fn build(self) -> crate::model::ReplicationTaskAssessmentRunProgress {
            crate::model::ReplicationTaskAssessmentRunProgress {
                individual_assessment_count: self.individual_assessment_count.unwrap_or_default(),
                individual_assessment_completed_count: self
                    .individual_assessment_completed_count
                    .unwrap_or_default(),
            }
        }
    }
}
impl ReplicationTaskAssessmentRunProgress {
    /// Creates a new builder-style object to manufacture [`ReplicationTaskAssessmentRunProgress`](crate::model::ReplicationTaskAssessmentRunProgress)
    pub fn builder() -> crate::model::replication_task_assessment_run_progress::Builder {
        crate::model::replication_task_assessment_run_progress::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StartReplicationTaskTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    ReloadTarget,
    #[allow(missing_docs)] // documentation missing in model
    ResumeProcessing,
    #[allow(missing_docs)] // documentation missing in model
    StartReplication,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StartReplicationTaskTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "reload-target" => StartReplicationTaskTypeValue::ReloadTarget,
            "resume-processing" => StartReplicationTaskTypeValue::ResumeProcessing,
            "start-replication" => StartReplicationTaskTypeValue::StartReplication,
            other => StartReplicationTaskTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StartReplicationTaskTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StartReplicationTaskTypeValue::from(s))
    }
}
impl StartReplicationTaskTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StartReplicationTaskTypeValue::ReloadTarget => "reload-target",
            StartReplicationTaskTypeValue::ResumeProcessing => "resume-processing",
            StartReplicationTaskTypeValue::StartReplication => "start-replication",
            StartReplicationTaskTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["reload-target", "resume-processing", "start-replication"]
    }
}
impl AsRef<str> for StartReplicationTaskTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReloadOptionValue {
    #[allow(missing_docs)] // documentation missing in model
    DataReload,
    #[allow(missing_docs)] // documentation missing in model
    ValidateOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReloadOptionValue {
    fn from(s: &str) -> Self {
        match s {
            "data-reload" => ReloadOptionValue::DataReload,
            "validate-only" => ReloadOptionValue::ValidateOnly,
            other => ReloadOptionValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReloadOptionValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReloadOptionValue::from(s))
    }
}
impl ReloadOptionValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReloadOptionValue::DataReload => "data-reload",
            ReloadOptionValue::ValidateOnly => "validate-only",
            ReloadOptionValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["data-reload", "validate-only"]
    }
}
impl AsRef<str> for ReloadOptionValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the name of the schema and table to be reloaded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableToReload {
    /// <p>The schema name of the table to be reloaded.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The table name of the table to be reloaded.</p>
    pub table_name: std::option::Option<std::string::String>,
}
impl TableToReload {
    /// <p>The schema name of the table to be reloaded.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The table name of the table to be reloaded.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
}
impl std::fmt::Debug for TableToReload {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableToReload");
        formatter.field("schema_name", &self.schema_name);
        formatter.field("table_name", &self.table_name);
        formatter.finish()
    }
}
/// See [`TableToReload`](crate::model::TableToReload)
pub mod table_to_reload {
    /// A builder for [`TableToReload`](crate::model::TableToReload)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The schema name of the table to be reloaded.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The schema name of the table to be reloaded.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The table name of the table to be reloaded.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The table name of the table to be reloaded.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TableToReload`](crate::model::TableToReload)
        pub fn build(self) -> crate::model::TableToReload {
            crate::model::TableToReload {
                schema_name: self.schema_name,
                table_name: self.table_name,
            }
        }
    }
}
impl TableToReload {
    /// Creates a new builder-style object to manufacture [`TableToReload`](crate::model::TableToReload)
    pub fn builder() -> crate::model::table_to_reload::Builder {
        crate::model::table_to_reload::Builder::default()
    }
}

/// <p>Provides information that describes status of a schema at an endpoint specified by the
/// <code>DescribeRefreshSchemaStatus</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshSchemasStatus {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The status of the schema.</p>
    pub status: std::option::Option<crate::model::RefreshSchemasStatusTypeValue>,
    /// <p>The date the schema was last refreshed.</p>
    pub last_refresh_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last failure message for the schema.</p>
    pub last_failure_message: std::option::Option<std::string::String>,
}
impl RefreshSchemasStatus {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub fn replication_instance_arn(&self) -> std::option::Option<&str> {
        self.replication_instance_arn.as_deref()
    }
    /// <p>The status of the schema.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::RefreshSchemasStatusTypeValue> {
        self.status.as_ref()
    }
    /// <p>The date the schema was last refreshed.</p>
    pub fn last_refresh_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_refresh_date.as_ref()
    }
    /// <p>The last failure message for the schema.</p>
    pub fn last_failure_message(&self) -> std::option::Option<&str> {
        self.last_failure_message.as_deref()
    }
}
impl std::fmt::Debug for RefreshSchemasStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshSchemasStatus");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("status", &self.status);
        formatter.field("last_refresh_date", &self.last_refresh_date);
        formatter.field("last_failure_message", &self.last_failure_message);
        formatter.finish()
    }
}
/// See [`RefreshSchemasStatus`](crate::model::RefreshSchemasStatus)
pub mod refresh_schemas_status {
    /// A builder for [`RefreshSchemasStatus`](crate::model::RefreshSchemasStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::RefreshSchemasStatusTypeValue>,
        pub(crate) last_refresh_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failure_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The status of the schema.</p>
        pub fn status(mut self, input: crate::model::RefreshSchemasStatusTypeValue) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the schema.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::RefreshSchemasStatusTypeValue>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date the schema was last refreshed.</p>
        pub fn last_refresh_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_refresh_date = Some(input);
            self
        }
        /// <p>The date the schema was last refreshed.</p>
        pub fn set_last_refresh_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_refresh_date = input;
            self
        }
        /// <p>The last failure message for the schema.</p>
        pub fn last_failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_failure_message = Some(input.into());
            self
        }
        /// <p>The last failure message for the schema.</p>
        pub fn set_last_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_failure_message = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshSchemasStatus`](crate::model::RefreshSchemasStatus)
        pub fn build(self) -> crate::model::RefreshSchemasStatus {
            crate::model::RefreshSchemasStatus {
                endpoint_arn: self.endpoint_arn,
                replication_instance_arn: self.replication_instance_arn,
                status: self.status,
                last_refresh_date: self.last_refresh_date,
                last_failure_message: self.last_failure_message,
            }
        }
    }
}
impl RefreshSchemasStatus {
    /// Creates a new builder-style object to manufacture [`RefreshSchemasStatus`](crate::model::RefreshSchemasStatus)
    pub fn builder() -> crate::model::refresh_schemas_status::Builder {
        crate::model::refresh_schemas_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RefreshSchemasStatusTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Refreshing,
    #[allow(missing_docs)] // documentation missing in model
    Successful,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RefreshSchemasStatusTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "failed" => RefreshSchemasStatusTypeValue::Failed,
            "refreshing" => RefreshSchemasStatusTypeValue::Refreshing,
            "successful" => RefreshSchemasStatusTypeValue::Successful,
            other => RefreshSchemasStatusTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RefreshSchemasStatusTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RefreshSchemasStatusTypeValue::from(s))
    }
}
impl RefreshSchemasStatusTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RefreshSchemasStatusTypeValue::Failed => "failed",
            RefreshSchemasStatusTypeValue::Refreshing => "refreshing",
            RefreshSchemasStatusTypeValue::Successful => "successful",
            RefreshSchemasStatusTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["failed", "refreshing", "successful"]
    }
}
impl AsRef<str> for RefreshSchemasStatusTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines a replication instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationInstance {
    /// <p>The replication instance identifier is a required parameter. This parameter is stored as
    /// a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>myrepinstance</code>
    /// </p>
    pub replication_instance_identifier: std::option::Option<std::string::String>,
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class. It is a required parameter, although a default value is
    /// pre-selected in the DMS console.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub replication_instance_class: std::option::Option<std::string::String>,
    /// <p>The status of the replication instance. The possible return values include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"available"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"creating"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleted"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"modifying"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"upgrading"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"rebooting"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"resetting-master-credentials"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"storage-full"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"incompatible-credentials"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"incompatible-network"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"maintenance"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub replication_instance_status: std::option::Option<std::string::String>,
    /// <p>The amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub allocated_storage: i32,
    /// <p>The time the replication instance was created.</p>
    pub instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The VPC security group for the instance.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>The Availability Zone for the instance.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The subnet group for the replication instance.</p>
    pub replication_subnet_group: std::option::Option<crate::model::ReplicationSubnetGroup>,
    /// <p>The maintenance window times for the replication instance. Any pending upgrades to the
    /// replication instance are performed during this time.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>The pending modification values.</p>
    pub pending_modified_values:
        std::option::Option<crate::model::ReplicationPendingModifiedValues>,
    /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
    /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
    /// <code>true</code>. </p>
    pub multi_az: bool,
    /// <p>The engine version number of the replication instance.</p>
    /// <p>If an engine version number is not specified when a replication
    /// instance is created, the default is the latest engine version available.</p>
    /// <p>When modifying a major engine version of an instance, also set  
    /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Boolean value indicating if minor version upgrades will be automatically applied to the
    /// instance.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>An KMS key identifier that is used to encrypt the data on the replication
    /// instance.</p>
    /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key.</p>
    /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
    /// different default encryption key for each Amazon Web Services Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The public IP address of the replication instance.</p>
    pub replication_instance_public_ip_address: std::option::Option<std::string::String>,
    /// <p>The private IP address of the replication instance.</p>
    pub replication_instance_private_ip_address: std::option::Option<std::string::String>,
    /// <p>One or more public IP addresses for the replication instance.</p>
    pub replication_instance_public_ip_addresses:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more private IP addresses for the replication instance.</p>
    pub replication_instance_private_ip_addresses:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Specifies the accessibility options for the replication instance. A value of
    /// <code>true</code> represents an instance with a public IP address. A value of
    /// <code>false</code> represents an instance with a private IP address. The default value
    /// is <code>true</code>. </p>
    pub publicly_accessible: bool,
    /// <p>The Availability Zone of the standby replication instance in a Multi-AZ
    /// deployment.</p>
    pub secondary_availability_zone: std::option::Option<std::string::String>,
    /// <p> The expiration date of the free replication instance that is part of the Free DMS
    /// program. </p>
    pub free_until: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The DNS name servers supported for the replication instance to access your on-premise source or target database.</p>
    pub dns_name_servers: std::option::Option<std::string::String>,
}
impl ReplicationInstance {
    /// <p>The replication instance identifier is a required parameter. This parameter is stored as
    /// a lowercase string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>myrepinstance</code>
    /// </p>
    pub fn replication_instance_identifier(&self) -> std::option::Option<&str> {
        self.replication_instance_identifier.as_deref()
    }
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class. It is a required parameter, although a default value is
    /// pre-selected in the DMS console.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub fn replication_instance_class(&self) -> std::option::Option<&str> {
        self.replication_instance_class.as_deref()
    }
    /// <p>The status of the replication instance. The possible return values include:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"available"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"creating"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleted"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"deleting"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"modifying"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"upgrading"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"rebooting"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"resetting-master-credentials"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"storage-full"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"incompatible-credentials"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"incompatible-network"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"maintenance"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn replication_instance_status(&self) -> std::option::Option<&str> {
        self.replication_instance_status.as_deref()
    }
    /// <p>The amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub fn allocated_storage(&self) -> i32 {
        self.allocated_storage
    }
    /// <p>The time the replication instance was created.</p>
    pub fn instance_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.instance_create_time.as_ref()
    }
    /// <p>The VPC security group for the instance.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>The Availability Zone for the instance.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The subnet group for the replication instance.</p>
    pub fn replication_subnet_group(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationSubnetGroup> {
        self.replication_subnet_group.as_ref()
    }
    /// <p>The maintenance window times for the replication instance. Any pending upgrades to the
    /// replication instance are performed during this time.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>The pending modification values.</p>
    pub fn pending_modified_values(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationPendingModifiedValues> {
        self.pending_modified_values.as_ref()
    }
    /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
    /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
    /// <code>true</code>. </p>
    pub fn multi_az(&self) -> bool {
        self.multi_az
    }
    /// <p>The engine version number of the replication instance.</p>
    /// <p>If an engine version number is not specified when a replication
    /// instance is created, the default is the latest engine version available.</p>
    /// <p>When modifying a major engine version of an instance, also set  
    /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Boolean value indicating if minor version upgrades will be automatically applied to the
    /// instance.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>An KMS key identifier that is used to encrypt the data on the replication
    /// instance.</p>
    /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key.</p>
    /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
    /// different default encryption key for each Amazon Web Services Region.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub fn replication_instance_arn(&self) -> std::option::Option<&str> {
        self.replication_instance_arn.as_deref()
    }
    /// <p>The public IP address of the replication instance.</p>
    pub fn replication_instance_public_ip_address(&self) -> std::option::Option<&str> {
        self.replication_instance_public_ip_address.as_deref()
    }
    /// <p>The private IP address of the replication instance.</p>
    pub fn replication_instance_private_ip_address(&self) -> std::option::Option<&str> {
        self.replication_instance_private_ip_address.as_deref()
    }
    /// <p>One or more public IP addresses for the replication instance.</p>
    pub fn replication_instance_public_ip_addresses(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_instance_public_ip_addresses.as_deref()
    }
    /// <p>One or more private IP addresses for the replication instance.</p>
    pub fn replication_instance_private_ip_addresses(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.replication_instance_private_ip_addresses.as_deref()
    }
    /// <p> Specifies the accessibility options for the replication instance. A value of
    /// <code>true</code> represents an instance with a public IP address. A value of
    /// <code>false</code> represents an instance with a private IP address. The default value
    /// is <code>true</code>. </p>
    pub fn publicly_accessible(&self) -> bool {
        self.publicly_accessible
    }
    /// <p>The Availability Zone of the standby replication instance in a Multi-AZ
    /// deployment.</p>
    pub fn secondary_availability_zone(&self) -> std::option::Option<&str> {
        self.secondary_availability_zone.as_deref()
    }
    /// <p> The expiration date of the free replication instance that is part of the Free DMS
    /// program. </p>
    pub fn free_until(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.free_until.as_ref()
    }
    /// <p>The DNS name servers supported for the replication instance to access your on-premise source or target database.</p>
    pub fn dns_name_servers(&self) -> std::option::Option<&str> {
        self.dns_name_servers.as_deref()
    }
}
impl std::fmt::Debug for ReplicationInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationInstance");
        formatter.field(
            "replication_instance_identifier",
            &self.replication_instance_identifier,
        );
        formatter.field(
            "replication_instance_class",
            &self.replication_instance_class,
        );
        formatter.field(
            "replication_instance_status",
            &self.replication_instance_status,
        );
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("instance_create_time", &self.instance_create_time);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("replication_subnet_group", &self.replication_subnet_group);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field(
            "replication_instance_public_ip_address",
            &self.replication_instance_public_ip_address,
        );
        formatter.field(
            "replication_instance_private_ip_address",
            &self.replication_instance_private_ip_address,
        );
        formatter.field(
            "replication_instance_public_ip_addresses",
            &self.replication_instance_public_ip_addresses,
        );
        formatter.field(
            "replication_instance_private_ip_addresses",
            &self.replication_instance_private_ip_addresses,
        );
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field(
            "secondary_availability_zone",
            &self.secondary_availability_zone,
        );
        formatter.field("free_until", &self.free_until);
        formatter.field("dns_name_servers", &self.dns_name_servers);
        formatter.finish()
    }
}
/// See [`ReplicationInstance`](crate::model::ReplicationInstance)
pub mod replication_instance {
    /// A builder for [`ReplicationInstance`](crate::model::ReplicationInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) replication_instance_class: std::option::Option<std::string::String>,
        pub(crate) replication_instance_status: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) replication_subnet_group:
            std::option::Option<crate::model::ReplicationSubnetGroup>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::ReplicationPendingModifiedValues>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_public_ip_address: std::option::Option<std::string::String>,
        pub(crate) replication_instance_private_ip_address:
            std::option::Option<std::string::String>,
        pub(crate) replication_instance_public_ip_addresses:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replication_instance_private_ip_addresses:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) secondary_availability_zone: std::option::Option<std::string::String>,
        pub(crate) free_until: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) dns_name_servers: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The replication instance identifier is a required parameter. This parameter is stored as
        /// a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code>
        /// </p>
        pub fn replication_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = Some(input.into());
            self
        }
        /// <p>The replication instance identifier is a required parameter. This parameter is stored as
        /// a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code>
        /// </p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = input;
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. It is a required parameter, although a default value is
        /// pre-selected in the DMS console.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn replication_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. It is a required parameter, although a default value is
        /// pre-selected in the DMS console.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_class = input;
            self
        }
        /// <p>The status of the replication instance. The possible return values include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"available"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"creating"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleted"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"modifying"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"upgrading"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"rebooting"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"resetting-master-credentials"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"storage-full"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"incompatible-credentials"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"incompatible-network"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"maintenance"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn replication_instance_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_instance_status = Some(input.into());
            self
        }
        /// <p>The status of the replication instance. The possible return values include:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"available"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"creating"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleted"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"deleting"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"modifying"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"upgrading"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"rebooting"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"resetting-master-credentials"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"storage-full"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"incompatible-credentials"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"incompatible-network"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"maintenance"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_replication_instance_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_status = input;
            self
        }
        /// <p>The amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>The time the replication instance was created.</p>
        pub fn instance_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.instance_create_time = Some(input);
            self
        }
        /// <p>The time the replication instance was created.</p>
        pub fn set_instance_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.instance_create_time = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>The VPC security group for the instance.</p>
        pub fn vpc_security_groups(
            mut self,
            input: impl Into<crate::model::VpcSecurityGroupMembership>,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>The VPC security group for the instance.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>The Availability Zone for the instance.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone for the instance.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The subnet group for the replication instance.</p>
        pub fn replication_subnet_group(
            mut self,
            input: crate::model::ReplicationSubnetGroup,
        ) -> Self {
            self.replication_subnet_group = Some(input);
            self
        }
        /// <p>The subnet group for the replication instance.</p>
        pub fn set_replication_subnet_group(
            mut self,
            input: std::option::Option<crate::model::ReplicationSubnetGroup>,
        ) -> Self {
            self.replication_subnet_group = input;
            self
        }
        /// <p>The maintenance window times for the replication instance. Any pending upgrades to the
        /// replication instance are performed during this time.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The maintenance window times for the replication instance. Any pending upgrades to the
        /// replication instance are performed during this time.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The pending modification values.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::ReplicationPendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>The pending modification values.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::ReplicationPendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication
        /// instance is created, the default is the latest engine version available.</p>
        /// <p>When modifying a major engine version of an instance, also set  
        /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication
        /// instance is created, the default is the latest engine version available.</p>
        /// <p>When modifying a major engine version of an instance, also set  
        /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Boolean value indicating if minor version upgrades will be automatically applied to the
        /// instance.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>Boolean value indicating if minor version upgrades will be automatically applied to the
        /// instance.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication
        /// instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication
        /// instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The public IP address of the replication instance.</p>
        pub fn replication_instance_public_ip_address(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_instance_public_ip_address = Some(input.into());
            self
        }
        /// <p>The public IP address of the replication instance.</p>
        pub fn set_replication_instance_public_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_public_ip_address = input;
            self
        }
        /// <p>The private IP address of the replication instance.</p>
        pub fn replication_instance_private_ip_address(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_instance_private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address of the replication instance.</p>
        pub fn set_replication_instance_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_private_ip_address = input;
            self
        }
        /// Appends an item to `replication_instance_public_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_replication_instance_public_ip_addresses`](Self::set_replication_instance_public_ip_addresses).
        ///
        /// <p>One or more public IP addresses for the replication instance.</p>
        pub fn replication_instance_public_ip_addresses(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_instance_public_ip_addresses
                .unwrap_or_default();
            v.push(input.into());
            self.replication_instance_public_ip_addresses = Some(v);
            self
        }
        /// <p>One or more public IP addresses for the replication instance.</p>
        pub fn set_replication_instance_public_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_instance_public_ip_addresses = input;
            self
        }
        /// Appends an item to `replication_instance_private_ip_addresses`.
        ///
        /// To override the contents of this collection use [`set_replication_instance_private_ip_addresses`](Self::set_replication_instance_private_ip_addresses).
        ///
        /// <p>One or more private IP addresses for the replication instance.</p>
        pub fn replication_instance_private_ip_addresses(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .replication_instance_private_ip_addresses
                .unwrap_or_default();
            v.push(input.into());
            self.replication_instance_private_ip_addresses = Some(v);
            self
        }
        /// <p>One or more private IP addresses for the replication instance.</p>
        pub fn set_replication_instance_private_ip_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_instance_private_ip_addresses = input;
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of
        /// <code>true</code> represents an instance with a public IP address. A value of
        /// <code>false</code> represents an instance with a private IP address. The default value
        /// is <code>true</code>. </p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of
        /// <code>true</code> represents an instance with a public IP address. A value of
        /// <code>false</code> represents an instance with a private IP address. The default value
        /// is <code>true</code>. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>The Availability Zone of the standby replication instance in a Multi-AZ
        /// deployment.</p>
        pub fn secondary_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone of the standby replication instance in a Multi-AZ
        /// deployment.</p>
        pub fn set_secondary_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = input;
            self
        }
        /// <p> The expiration date of the free replication instance that is part of the Free DMS
        /// program. </p>
        pub fn free_until(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.free_until = Some(input);
            self
        }
        /// <p> The expiration date of the free replication instance that is part of the Free DMS
        /// program. </p>
        pub fn set_free_until(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.free_until = input;
            self
        }
        /// <p>The DNS name servers supported for the replication instance to access your on-premise source or target database.</p>
        pub fn dns_name_servers(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name_servers = Some(input.into());
            self
        }
        /// <p>The DNS name servers supported for the replication instance to access your on-premise source or target database.</p>
        pub fn set_dns_name_servers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dns_name_servers = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationInstance`](crate::model::ReplicationInstance)
        pub fn build(self) -> crate::model::ReplicationInstance {
            crate::model::ReplicationInstance {
                replication_instance_identifier: self.replication_instance_identifier,
                replication_instance_class: self.replication_instance_class,
                replication_instance_status: self.replication_instance_status,
                allocated_storage: self.allocated_storage.unwrap_or_default(),
                instance_create_time: self.instance_create_time,
                vpc_security_groups: self.vpc_security_groups,
                availability_zone: self.availability_zone,
                replication_subnet_group: self.replication_subnet_group,
                preferred_maintenance_window: self.preferred_maintenance_window,
                pending_modified_values: self.pending_modified_values,
                multi_az: self.multi_az.unwrap_or_default(),
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                replication_instance_arn: self.replication_instance_arn,
                replication_instance_public_ip_address: self.replication_instance_public_ip_address,
                replication_instance_private_ip_address: self
                    .replication_instance_private_ip_address,
                replication_instance_public_ip_addresses: self
                    .replication_instance_public_ip_addresses,
                replication_instance_private_ip_addresses: self
                    .replication_instance_private_ip_addresses,
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                secondary_availability_zone: self.secondary_availability_zone,
                free_until: self.free_until,
                dns_name_servers: self.dns_name_servers,
            }
        }
    }
}
impl ReplicationInstance {
    /// Creates a new builder-style object to manufacture [`ReplicationInstance`](crate::model::ReplicationInstance)
    pub fn builder() -> crate::model::replication_instance::Builder {
        crate::model::replication_instance::Builder::default()
    }
}

/// <p>Provides information about the values of pending modifications to a replication
/// instance. This data type is an object of the
/// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ReplicationInstance.html">
/// <code>ReplicationInstance</code>
/// </a> user-defined
/// data type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationPendingModifiedValues {
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub replication_instance_class: std::option::Option<std::string::String>,
    /// <p>The amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
    /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
    /// <code>true</code>. </p>
    pub multi_az: std::option::Option<bool>,
    /// <p>The engine version number of the replication instance.</p>
    pub engine_version: std::option::Option<std::string::String>,
}
impl ReplicationPendingModifiedValues {
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub fn replication_instance_class(&self) -> std::option::Option<&str> {
        self.replication_instance_class.as_deref()
    }
    /// <p>The amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub fn allocated_storage(&self) -> std::option::Option<i32> {
        self.allocated_storage
    }
    /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
    /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
    /// <code>true</code>. </p>
    pub fn multi_az(&self) -> std::option::Option<bool> {
        self.multi_az
    }
    /// <p>The engine version number of the replication instance.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
}
impl std::fmt::Debug for ReplicationPendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationPendingModifiedValues");
        formatter.field(
            "replication_instance_class",
            &self.replication_instance_class,
        );
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.finish()
    }
}
/// See [`ReplicationPendingModifiedValues`](crate::model::ReplicationPendingModifiedValues)
pub mod replication_pending_modified_values {
    /// A builder for [`ReplicationPendingModifiedValues`](crate::model::ReplicationPendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_class: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn replication_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_class = input;
            self
        }
        /// <p>The amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationPendingModifiedValues`](crate::model::ReplicationPendingModifiedValues)
        pub fn build(self) -> crate::model::ReplicationPendingModifiedValues {
            crate::model::ReplicationPendingModifiedValues {
                replication_instance_class: self.replication_instance_class,
                allocated_storage: self.allocated_storage,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
            }
        }
    }
}
impl ReplicationPendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`ReplicationPendingModifiedValues`](crate::model::ReplicationPendingModifiedValues)
    pub fn builder() -> crate::model::replication_pending_modified_values::Builder {
        crate::model::replication_pending_modified_values::Builder::default()
    }
}

/// <p>Describes a subnet group in response to a request by the
/// <code>DescribeReplicationSubnetGroups</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationSubnetGroup {
    /// <p>The identifier of the replication instance subnet group.</p>
    pub replication_subnet_group_identifier: std::option::Option<std::string::String>,
    /// <p>A description for the replication subnet group.</p>
    pub replication_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>The ID of the VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The status of the subnet group.</p>
    pub subnet_group_status: std::option::Option<std::string::String>,
    /// <p>The subnets that are in the subnet group.</p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
}
impl ReplicationSubnetGroup {
    /// <p>The identifier of the replication instance subnet group.</p>
    pub fn replication_subnet_group_identifier(&self) -> std::option::Option<&str> {
        self.replication_subnet_group_identifier.as_deref()
    }
    /// <p>A description for the replication subnet group.</p>
    pub fn replication_subnet_group_description(&self) -> std::option::Option<&str> {
        self.replication_subnet_group_description.as_deref()
    }
    /// <p>The ID of the VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The status of the subnet group.</p>
    pub fn subnet_group_status(&self) -> std::option::Option<&str> {
        self.subnet_group_status.as_deref()
    }
    /// <p>The subnets that are in the subnet group.</p>
    pub fn subnets(&self) -> std::option::Option<&[crate::model::Subnet]> {
        self.subnets.as_deref()
    }
}
impl std::fmt::Debug for ReplicationSubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationSubnetGroup");
        formatter.field(
            "replication_subnet_group_identifier",
            &self.replication_subnet_group_identifier,
        );
        formatter.field(
            "replication_subnet_group_description",
            &self.replication_subnet_group_description,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_group_status", &self.subnet_group_status);
        formatter.field("subnets", &self.subnets);
        formatter.finish()
    }
}
/// See [`ReplicationSubnetGroup`](crate::model::ReplicationSubnetGroup)
pub mod replication_subnet_group {
    /// A builder for [`ReplicationSubnetGroup`](crate::model::ReplicationSubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_subnet_group_identifier: std::option::Option<std::string::String>,
        pub(crate) replication_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_group_status: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    }
    impl Builder {
        /// <p>The identifier of the replication instance subnet group.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the replication instance subnet group.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = input;
            self
        }
        /// <p>A description for the replication subnet group.</p>
        pub fn replication_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_description = Some(input.into());
            self
        }
        /// <p>A description for the replication subnet group.</p>
        pub fn set_replication_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_description = input;
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The ID of the VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The status of the subnet group.</p>
        pub fn subnet_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_status = Some(input.into());
            self
        }
        /// <p>The status of the subnet group.</p>
        pub fn set_subnet_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_status = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>The subnets that are in the subnet group.</p>
        pub fn subnets(mut self, input: impl Into<crate::model::Subnet>) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input.into());
            self.subnets = Some(v);
            self
        }
        /// <p>The subnets that are in the subnet group.</p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationSubnetGroup`](crate::model::ReplicationSubnetGroup)
        pub fn build(self) -> crate::model::ReplicationSubnetGroup {
            crate::model::ReplicationSubnetGroup {
                replication_subnet_group_identifier: self.replication_subnet_group_identifier,
                replication_subnet_group_description: self.replication_subnet_group_description,
                vpc_id: self.vpc_id,
                subnet_group_status: self.subnet_group_status,
                subnets: self.subnets,
            }
        }
    }
}
impl ReplicationSubnetGroup {
    /// Creates a new builder-style object to manufacture [`ReplicationSubnetGroup`](crate::model::ReplicationSubnetGroup)
    pub fn builder() -> crate::model::replication_subnet_group::Builder {
        crate::model::replication_subnet_group::Builder::default()
    }
}

/// <p>In response to a request by the <code>DescribeReplicationSubnetGroups</code> operation,
/// this object identifies a subnet by its given Availability Zone, subnet identifier, and
/// status.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>The subnet identifier.</p>
    pub subnet_identifier: std::option::Option<std::string::String>,
    /// <p>The Availability Zone of the subnet.</p>
    pub subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
    /// <p>The status of the subnet.</p>
    pub subnet_status: std::option::Option<std::string::String>,
}
impl Subnet {
    /// <p>The subnet identifier.</p>
    pub fn subnet_identifier(&self) -> std::option::Option<&str> {
        self.subnet_identifier.as_deref()
    }
    /// <p>The Availability Zone of the subnet.</p>
    pub fn subnet_availability_zone(&self) -> std::option::Option<&crate::model::AvailabilityZone> {
        self.subnet_availability_zone.as_ref()
    }
    /// <p>The status of the subnet.</p>
    pub fn subnet_status(&self) -> std::option::Option<&str> {
        self.subnet_status.as_deref()
    }
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("subnet_identifier", &self.subnet_identifier);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.field("subnet_status", &self.subnet_status);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_identifier: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
        pub(crate) subnet_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subnet identifier.</p>
        pub fn subnet_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_identifier = Some(input.into());
            self
        }
        /// <p>The subnet identifier.</p>
        pub fn set_subnet_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_identifier = input;
            self
        }
        /// <p>The Availability Zone of the subnet.</p>
        pub fn subnet_availability_zone(mut self, input: crate::model::AvailabilityZone) -> Self {
            self.subnet_availability_zone = Some(input);
            self
        }
        /// <p>The Availability Zone of the subnet.</p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<crate::model::AvailabilityZone>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// <p>The status of the subnet.</p>
        pub fn subnet_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_status = Some(input.into());
            self
        }
        /// <p>The status of the subnet.</p>
        pub fn set_subnet_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                subnet_identifier: self.subnet_identifier,
                subnet_availability_zone: self.subnet_availability_zone,
                subnet_status: self.subnet_status,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>The name of an Availability Zone for use during database migration.
/// <code>AvailabilityZone</code> is an optional parameter to the <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationInstance.html">
/// <code>CreateReplicationInstance</code>
/// </a> operation, and it’s value relates to
/// the Amazon Web Services Region of an endpoint. For example, the availability zone of an endpoint in the
/// us-east-1 region might be us-east-1a, us-east-1b, us-east-1c, or us-east-1d.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Availability Zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone { name: self.name }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>Describes the status of a security group associated with the virtual private cloud (VPC)
/// hosting your replication and DB instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcSecurityGroupMembership {
    /// <p>The VPC security group ID.</p>
    pub vpc_security_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl VpcSecurityGroupMembership {
    /// <p>The VPC security group ID.</p>
    pub fn vpc_security_group_id(&self) -> std::option::Option<&str> {
        self.vpc_security_group_id.as_deref()
    }
    /// <p>The status of the VPC security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for VpcSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcSecurityGroupMembership");
        formatter.field("vpc_security_group_id", &self.vpc_security_group_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
pub mod vpc_security_group_membership {
    /// A builder for [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_security_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The VPC security group ID.</p>
        pub fn vpc_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_security_group_id = Some(input.into());
            self
        }
        /// <p>The VPC security group ID.</p>
        pub fn set_vpc_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_security_group_id = input;
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
        pub fn build(self) -> crate::model::VpcSecurityGroupMembership {
            crate::model::VpcSecurityGroupMembership {
                vpc_security_group_id: self.vpc_security_group_id,
                status: self.status,
            }
        }
    }
}
impl VpcSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    pub fn builder() -> crate::model::vpc_security_group_membership::Builder {
        crate::model::vpc_security_group_membership::Builder::default()
    }
}

/// <p>Describes an event notification subscription created by the <code>CreateEventSubscription</code>
/// operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscription {
    /// <p>The Amazon Web Services customer account associated with the DMS event notification
    /// subscription.</p>
    pub customer_aws_id: std::option::Option<std::string::String>,
    /// <p>The DMS event notification subscription Id.</p>
    pub cust_subscription_id: std::option::Option<std::string::String>,
    /// <p>The topic ARN of the DMS event notification subscription.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The status of the DMS event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission |
    /// topic-not-exist</p>
    /// <p>The status "no-permission" indicates that DMS no longer has permission to post to
    /// the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
    /// subscription was created.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time the DMS event notification subscription was created.</p>
    pub subscription_creation_time: std::option::Option<std::string::String>,
    /// <p> The type of DMS resource that generates events. </p>
    /// <p>Valid values: replication-instance | replication-server | security-group |
    /// replication-task</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>A list of source Ids for the event subscription.</p>
    pub source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A lists of event categories.</p>
    pub event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Boolean value that indicates if the event subscription is enabled.</p>
    pub enabled: bool,
}
impl EventSubscription {
    /// <p>The Amazon Web Services customer account associated with the DMS event notification
    /// subscription.</p>
    pub fn customer_aws_id(&self) -> std::option::Option<&str> {
        self.customer_aws_id.as_deref()
    }
    /// <p>The DMS event notification subscription Id.</p>
    pub fn cust_subscription_id(&self) -> std::option::Option<&str> {
        self.cust_subscription_id.as_deref()
    }
    /// <p>The topic ARN of the DMS event notification subscription.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The status of the DMS event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission |
    /// topic-not-exist</p>
    /// <p>The status "no-permission" indicates that DMS no longer has permission to post to
    /// the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
    /// subscription was created.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time the DMS event notification subscription was created.</p>
    pub fn subscription_creation_time(&self) -> std::option::Option<&str> {
        self.subscription_creation_time.as_deref()
    }
    /// <p> The type of DMS resource that generates events. </p>
    /// <p>Valid values: replication-instance | replication-server | security-group |
    /// replication-task</p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>A list of source Ids for the event subscription.</p>
    pub fn source_ids_list(&self) -> std::option::Option<&[std::string::String]> {
        self.source_ids_list.as_deref()
    }
    /// <p>A lists of event categories.</p>
    pub fn event_categories_list(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories_list.as_deref()
    }
    /// <p>Boolean value that indicates if the event subscription is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl std::fmt::Debug for EventSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscription");
        formatter.field("customer_aws_id", &self.customer_aws_id);
        formatter.field("cust_subscription_id", &self.cust_subscription_id);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("status", &self.status);
        formatter.field(
            "subscription_creation_time",
            &self.subscription_creation_time,
        );
        formatter.field("source_type", &self.source_type);
        formatter.field("source_ids_list", &self.source_ids_list);
        formatter.field("event_categories_list", &self.event_categories_list);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`EventSubscription`](crate::model::EventSubscription)
pub mod event_subscription {
    /// A builder for [`EventSubscription`](crate::model::EventSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_aws_id: std::option::Option<std::string::String>,
        pub(crate) cust_subscription_id: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) subscription_creation_time: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Web Services customer account associated with the DMS event notification
        /// subscription.</p>
        pub fn customer_aws_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_aws_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services customer account associated with the DMS event notification
        /// subscription.</p>
        pub fn set_customer_aws_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_aws_id = input;
            self
        }
        /// <p>The DMS event notification subscription Id.</p>
        pub fn cust_subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cust_subscription_id = Some(input.into());
            self
        }
        /// <p>The DMS event notification subscription Id.</p>
        pub fn set_cust_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cust_subscription_id = input;
            self
        }
        /// <p>The topic ARN of the DMS event notification subscription.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The topic ARN of the DMS event notification subscription.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The status of the DMS event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission |
        /// topic-not-exist</p>
        /// <p>The status "no-permission" indicates that DMS no longer has permission to post to
        /// the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
        /// subscription was created.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DMS event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission |
        /// topic-not-exist</p>
        /// <p>The status "no-permission" indicates that DMS no longer has permission to post to
        /// the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the
        /// subscription was created.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time the DMS event notification subscription was created.</p>
        pub fn subscription_creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_creation_time = Some(input.into());
            self
        }
        /// <p>The time the DMS event notification subscription was created.</p>
        pub fn set_subscription_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_creation_time = input;
            self
        }
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-server | security-group |
        /// replication-task</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-server | security-group |
        /// replication-task</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `source_ids_list`.
        ///
        /// To override the contents of this collection use [`set_source_ids_list`](Self::set_source_ids_list).
        ///
        /// <p>A list of source Ids for the event subscription.</p>
        pub fn source_ids_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids_list.unwrap_or_default();
            v.push(input.into());
            self.source_ids_list = Some(v);
            self
        }
        /// <p>A list of source Ids for the event subscription.</p>
        pub fn set_source_ids_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids_list = input;
            self
        }
        /// Appends an item to `event_categories_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_list`](Self::set_event_categories_list).
        ///
        /// <p>A lists of event categories.</p>
        pub fn event_categories_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories_list.unwrap_or_default();
            v.push(input.into());
            self.event_categories_list = Some(v);
            self
        }
        /// <p>A lists of event categories.</p>
        pub fn set_event_categories_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories_list = input;
            self
        }
        /// <p>Boolean value that indicates if the event subscription is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Boolean value that indicates if the event subscription is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscription`](crate::model::EventSubscription)
        pub fn build(self) -> crate::model::EventSubscription {
            crate::model::EventSubscription {
                customer_aws_id: self.customer_aws_id,
                cust_subscription_id: self.cust_subscription_id,
                sns_topic_arn: self.sns_topic_arn,
                status: self.status,
                subscription_creation_time: self.subscription_creation_time,
                source_type: self.source_type,
                source_ids_list: self.source_ids_list,
                event_categories_list: self.event_categories_list,
                enabled: self.enabled.unwrap_or_default(),
            }
        }
    }
}
impl EventSubscription {
    /// Creates a new builder-style object to manufacture [`EventSubscription`](crate::model::EventSubscription)
    pub fn builder() -> crate::model::event_subscription::Builder {
        crate::model::event_subscription::Builder::default()
    }
}

/// <p>Describes an endpoint of a database instance in response to operations such as the
/// following:</p>
/// <ul>
/// <li>
/// <p>
/// <code>CreateEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DescribeEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ModifyEndpoint</code>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
    /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
    /// consecutive hyphens.</p>
    pub endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
    pub endpoint_type: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
    /// <p>The database engine name. Valid values, depending on the EndpointType, include
    /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
    /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>,
    /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
    /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
    /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
    /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
    pub engine_name: std::option::Option<std::string::String>,
    /// <p>The expanded name for the engine name. For example, if the <code>EngineName</code>
    /// parameter is "aurora," this value would be "Amazon Aurora MySQL."</p>
    pub engine_display_name: std::option::Option<std::string::String>,
    /// <p>The user name used to connect to the endpoint.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The name of the server at the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>The port value used to access the endpoint.</p>
    pub port: std::option::Option<i32>,
    /// <p>The name of the database at the endpoint.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Additional connection attributes used to connect to the endpoint.</p>
    pub extra_connection_attributes: std::option::Option<std::string::String>,
    /// <p>The status of the endpoint.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
    /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key.</p>
    /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
    /// different default encryption key for each Amazon Web Services Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) used for SSL connection to the endpoint.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>
    pub ssl_mode: std::option::Option<crate::model::DmsSslModeValue>,
    /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
    /// The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The external table definition.</p>
    pub external_table_definition: std::option::Option<std::string::String>,
    /// <p> Value returned by a call to CreateEndpoint that can be used for cross-account
    /// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a
    /// cross-account. </p>
    pub external_id: std::option::Option<std::string::String>,
    /// <p>The settings for the DynamoDB target endpoint. For more information, see the
    /// <code>DynamoDBSettings</code> structure.</p>
    pub dynamo_db_settings: std::option::Option<crate::model::DynamoDbSettings>,
    /// <p>The settings for the S3 target endpoint. For more information, see the
    /// <code>S3Settings</code> structure.</p>
    pub s3_settings: std::option::Option<crate::model::S3Settings>,
    /// <p>The settings for the DMS Transfer type source. For more information, see the DmsTransferSettings structure.  </p>
    pub dms_transfer_settings: std::option::Option<crate::model::DmsTransferSettings>,
    /// <p>The settings for the MongoDB source endpoint. For more information, see the
    /// <code>MongoDbSettings</code> structure.</p>
    pub mongo_db_settings: std::option::Option<crate::model::MongoDbSettings>,
    /// <p>The settings for the Amazon Kinesis target endpoint. For more information, see the
    /// <code>KinesisSettings</code> structure.</p>
    pub kinesis_settings: std::option::Option<crate::model::KinesisSettings>,
    /// <p>The settings for the Apache Kafka target endpoint. For more information, see the
    /// <code>KafkaSettings</code> structure.</p>
    pub kafka_settings: std::option::Option<crate::model::KafkaSettings>,
    /// <p>The settings for the OpenSearch source endpoint. For more information, see the
    /// <code>ElasticsearchSettings</code> structure.</p>
    pub elasticsearch_settings: std::option::Option<crate::model::ElasticsearchSettings>,
    /// <p>The settings for the Amazon Neptune target endpoint. For more information, see the
    /// <code>NeptuneSettings</code> structure.</p>
    pub neptune_settings: std::option::Option<crate::model::NeptuneSettings>,
    /// <p>Settings for the Amazon Redshift endpoint.</p>
    pub redshift_settings: std::option::Option<crate::model::RedshiftSettings>,
    /// <p>The settings for the PostgreSQL source and target endpoint. For more information, see
    /// the <code>PostgreSQLSettings</code> structure.</p>
    pub postgre_sql_settings: std::option::Option<crate::model::PostgreSqlSettings>,
    /// <p>The settings for the MySQL source and target endpoint. For more information, see the
    /// <code>MySQLSettings</code> structure.</p>
    pub my_sql_settings: std::option::Option<crate::model::MySqlSettings>,
    /// <p>The settings for the Oracle source and target endpoint. For more information, see the
    /// <code>OracleSettings</code> structure.</p>
    pub oracle_settings: std::option::Option<crate::model::OracleSettings>,
    /// <p>The settings for the SAP ASE source and target endpoint. For more information, see the
    /// <code>SybaseSettings</code> structure.</p>
    pub sybase_settings: std::option::Option<crate::model::SybaseSettings>,
    /// <p>The settings for the Microsoft SQL Server source and target endpoint. For more
    /// information, see the <code>MicrosoftSQLServerSettings</code> structure.</p>
    pub microsoft_sql_server_settings:
        std::option::Option<crate::model::MicrosoftSqlServerSettings>,
    /// <p>The settings for the IBM Db2 LUW source endpoint. For more information, see the
    /// <code>IBMDb2Settings</code> structure.
    /// </p>
    pub ibm_db2_settings: std::option::Option<crate::model::IbmDb2Settings>,
    /// <p>Provides information that defines a DocumentDB endpoint.</p>
    pub doc_db_settings: std::option::Option<crate::model::DocDbSettings>,
    /// <p>The settings for the Redis target endpoint. For more information, see the
    /// <code>RedisSettings</code> structure.</p>
    pub redis_settings: std::option::Option<crate::model::RedisSettings>,
    /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
    pub gcp_my_sql_settings: std::option::Option<crate::model::GcpMySqlSettings>,
}
impl Endpoint {
    /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
    /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
    /// consecutive hyphens.</p>
    pub fn endpoint_identifier(&self) -> std::option::Option<&str> {
        self.endpoint_identifier.as_deref()
    }
    /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
    pub fn endpoint_type(
        &self,
    ) -> std::option::Option<&crate::model::ReplicationEndpointTypeValue> {
        self.endpoint_type.as_ref()
    }
    /// <p>The database engine name. Valid values, depending on the EndpointType, include
    /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
    /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>,
    /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
    /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
    /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
    /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
    pub fn engine_name(&self) -> std::option::Option<&str> {
        self.engine_name.as_deref()
    }
    /// <p>The expanded name for the engine name. For example, if the <code>EngineName</code>
    /// parameter is "aurora," this value would be "Amazon Aurora MySQL."</p>
    pub fn engine_display_name(&self) -> std::option::Option<&str> {
        self.engine_display_name.as_deref()
    }
    /// <p>The user name used to connect to the endpoint.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The name of the server at the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>The port value used to access the endpoint.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The name of the database at the endpoint.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Additional connection attributes used to connect to the endpoint.</p>
    pub fn extra_connection_attributes(&self) -> std::option::Option<&str> {
        self.extra_connection_attributes.as_deref()
    }
    /// <p>The status of the endpoint.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
    /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key.</p>
    /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
    /// different default encryption key for each Amazon Web Services Region.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub fn endpoint_arn(&self) -> std::option::Option<&str> {
        self.endpoint_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) used for SSL connection to the endpoint.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>
    pub fn ssl_mode(&self) -> std::option::Option<&crate::model::DmsSslModeValue> {
        self.ssl_mode.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
    /// The role must allow the <code>iam:PassRole</code> action.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p>The external table definition.</p>
    pub fn external_table_definition(&self) -> std::option::Option<&str> {
        self.external_table_definition.as_deref()
    }
    /// <p> Value returned by a call to CreateEndpoint that can be used for cross-account
    /// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a
    /// cross-account. </p>
    pub fn external_id(&self) -> std::option::Option<&str> {
        self.external_id.as_deref()
    }
    /// <p>The settings for the DynamoDB target endpoint. For more information, see the
    /// <code>DynamoDBSettings</code> structure.</p>
    pub fn dynamo_db_settings(&self) -> std::option::Option<&crate::model::DynamoDbSettings> {
        self.dynamo_db_settings.as_ref()
    }
    /// <p>The settings for the S3 target endpoint. For more information, see the
    /// <code>S3Settings</code> structure.</p>
    pub fn s3_settings(&self) -> std::option::Option<&crate::model::S3Settings> {
        self.s3_settings.as_ref()
    }
    /// <p>The settings for the DMS Transfer type source. For more information, see the DmsTransferSettings structure.  </p>
    pub fn dms_transfer_settings(&self) -> std::option::Option<&crate::model::DmsTransferSettings> {
        self.dms_transfer_settings.as_ref()
    }
    /// <p>The settings for the MongoDB source endpoint. For more information, see the
    /// <code>MongoDbSettings</code> structure.</p>
    pub fn mongo_db_settings(&self) -> std::option::Option<&crate::model::MongoDbSettings> {
        self.mongo_db_settings.as_ref()
    }
    /// <p>The settings for the Amazon Kinesis target endpoint. For more information, see the
    /// <code>KinesisSettings</code> structure.</p>
    pub fn kinesis_settings(&self) -> std::option::Option<&crate::model::KinesisSettings> {
        self.kinesis_settings.as_ref()
    }
    /// <p>The settings for the Apache Kafka target endpoint. For more information, see the
    /// <code>KafkaSettings</code> structure.</p>
    pub fn kafka_settings(&self) -> std::option::Option<&crate::model::KafkaSettings> {
        self.kafka_settings.as_ref()
    }
    /// <p>The settings for the OpenSearch source endpoint. For more information, see the
    /// <code>ElasticsearchSettings</code> structure.</p>
    pub fn elasticsearch_settings(
        &self,
    ) -> std::option::Option<&crate::model::ElasticsearchSettings> {
        self.elasticsearch_settings.as_ref()
    }
    /// <p>The settings for the Amazon Neptune target endpoint. For more information, see the
    /// <code>NeptuneSettings</code> structure.</p>
    pub fn neptune_settings(&self) -> std::option::Option<&crate::model::NeptuneSettings> {
        self.neptune_settings.as_ref()
    }
    /// <p>Settings for the Amazon Redshift endpoint.</p>
    pub fn redshift_settings(&self) -> std::option::Option<&crate::model::RedshiftSettings> {
        self.redshift_settings.as_ref()
    }
    /// <p>The settings for the PostgreSQL source and target endpoint. For more information, see
    /// the <code>PostgreSQLSettings</code> structure.</p>
    pub fn postgre_sql_settings(&self) -> std::option::Option<&crate::model::PostgreSqlSettings> {
        self.postgre_sql_settings.as_ref()
    }
    /// <p>The settings for the MySQL source and target endpoint. For more information, see the
    /// <code>MySQLSettings</code> structure.</p>
    pub fn my_sql_settings(&self) -> std::option::Option<&crate::model::MySqlSettings> {
        self.my_sql_settings.as_ref()
    }
    /// <p>The settings for the Oracle source and target endpoint. For more information, see the
    /// <code>OracleSettings</code> structure.</p>
    pub fn oracle_settings(&self) -> std::option::Option<&crate::model::OracleSettings> {
        self.oracle_settings.as_ref()
    }
    /// <p>The settings for the SAP ASE source and target endpoint. For more information, see the
    /// <code>SybaseSettings</code> structure.</p>
    pub fn sybase_settings(&self) -> std::option::Option<&crate::model::SybaseSettings> {
        self.sybase_settings.as_ref()
    }
    /// <p>The settings for the Microsoft SQL Server source and target endpoint. For more
    /// information, see the <code>MicrosoftSQLServerSettings</code> structure.</p>
    pub fn microsoft_sql_server_settings(
        &self,
    ) -> std::option::Option<&crate::model::MicrosoftSqlServerSettings> {
        self.microsoft_sql_server_settings.as_ref()
    }
    /// <p>The settings for the IBM Db2 LUW source endpoint. For more information, see the
    /// <code>IBMDb2Settings</code> structure.
    /// </p>
    pub fn ibm_db2_settings(&self) -> std::option::Option<&crate::model::IbmDb2Settings> {
        self.ibm_db2_settings.as_ref()
    }
    /// <p>Provides information that defines a DocumentDB endpoint.</p>
    pub fn doc_db_settings(&self) -> std::option::Option<&crate::model::DocDbSettings> {
        self.doc_db_settings.as_ref()
    }
    /// <p>The settings for the Redis target endpoint. For more information, see the
    /// <code>RedisSettings</code> structure.</p>
    pub fn redis_settings(&self) -> std::option::Option<&crate::model::RedisSettings> {
        self.redis_settings.as_ref()
    }
    /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
    pub fn gcp_my_sql_settings(&self) -> std::option::Option<&crate::model::GcpMySqlSettings> {
        self.gcp_my_sql_settings.as_ref()
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("endpoint_identifier", &self.endpoint_identifier);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("engine_name", &self.engine_name);
        formatter.field("engine_display_name", &self.engine_display_name);
        formatter.field("username", &self.username);
        formatter.field("server_name", &self.server_name);
        formatter.field("port", &self.port);
        formatter.field("database_name", &self.database_name);
        formatter.field(
            "extra_connection_attributes",
            &self.extra_connection_attributes,
        );
        formatter.field("status", &self.status);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("ssl_mode", &self.ssl_mode);
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("external_table_definition", &self.external_table_definition);
        formatter.field("external_id", &self.external_id);
        formatter.field("dynamo_db_settings", &self.dynamo_db_settings);
        formatter.field("s3_settings", &self.s3_settings);
        formatter.field("dms_transfer_settings", &self.dms_transfer_settings);
        formatter.field("mongo_db_settings", &self.mongo_db_settings);
        formatter.field("kinesis_settings", &self.kinesis_settings);
        formatter.field("kafka_settings", &self.kafka_settings);
        formatter.field("elasticsearch_settings", &self.elasticsearch_settings);
        formatter.field("neptune_settings", &self.neptune_settings);
        formatter.field("redshift_settings", &self.redshift_settings);
        formatter.field("postgre_sql_settings", &self.postgre_sql_settings);
        formatter.field("my_sql_settings", &self.my_sql_settings);
        formatter.field("oracle_settings", &self.oracle_settings);
        formatter.field("sybase_settings", &self.sybase_settings);
        formatter.field(
            "microsoft_sql_server_settings",
            &self.microsoft_sql_server_settings,
        );
        formatter.field("ibm_db2_settings", &self.ibm_db2_settings);
        formatter.field("doc_db_settings", &self.doc_db_settings);
        formatter.field("redis_settings", &self.redis_settings);
        formatter.field("gcp_my_sql_settings", &self.gcp_my_sql_settings);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        pub(crate) engine_name: std::option::Option<std::string::String>,
        pub(crate) engine_display_name: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) extra_connection_attributes: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) ssl_mode: std::option::Option<crate::model::DmsSslModeValue>,
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) external_table_definition: std::option::Option<std::string::String>,
        pub(crate) external_id: std::option::Option<std::string::String>,
        pub(crate) dynamo_db_settings: std::option::Option<crate::model::DynamoDbSettings>,
        pub(crate) s3_settings: std::option::Option<crate::model::S3Settings>,
        pub(crate) dms_transfer_settings: std::option::Option<crate::model::DmsTransferSettings>,
        pub(crate) mongo_db_settings: std::option::Option<crate::model::MongoDbSettings>,
        pub(crate) kinesis_settings: std::option::Option<crate::model::KinesisSettings>,
        pub(crate) kafka_settings: std::option::Option<crate::model::KafkaSettings>,
        pub(crate) elasticsearch_settings: std::option::Option<crate::model::ElasticsearchSettings>,
        pub(crate) neptune_settings: std::option::Option<crate::model::NeptuneSettings>,
        pub(crate) redshift_settings: std::option::Option<crate::model::RedshiftSettings>,
        pub(crate) postgre_sql_settings: std::option::Option<crate::model::PostgreSqlSettings>,
        pub(crate) my_sql_settings: std::option::Option<crate::model::MySqlSettings>,
        pub(crate) oracle_settings: std::option::Option<crate::model::OracleSettings>,
        pub(crate) sybase_settings: std::option::Option<crate::model::SybaseSettings>,
        pub(crate) microsoft_sql_server_settings:
            std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        pub(crate) ibm_db2_settings: std::option::Option<crate::model::IbmDb2Settings>,
        pub(crate) doc_db_settings: std::option::Option<crate::model::DocDbSettings>,
        pub(crate) redis_settings: std::option::Option<crate::model::RedisSettings>,
        pub(crate) gcp_my_sql_settings: std::option::Option<crate::model::GcpMySqlSettings>,
    }
    impl Builder {
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_identifier = input;
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn endpoint_type(mut self, input: crate::model::ReplicationEndpointTypeValue) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The database engine name. Valid values, depending on the EndpointType, include
        /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
        /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>,
        /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
        /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
        /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_name = Some(input.into());
            self
        }
        /// <p>The database engine name. Valid values, depending on the EndpointType, include
        /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
        /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>, <code>"opensearch"</code>,
        /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
        /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
        /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_name = input;
            self
        }
        /// <p>The expanded name for the engine name. For example, if the <code>EngineName</code>
        /// parameter is "aurora," this value would be "Amazon Aurora MySQL."</p>
        pub fn engine_display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_display_name = Some(input.into());
            self
        }
        /// <p>The expanded name for the engine name. For example, if the <code>EngineName</code>
        /// parameter is "aurora," this value would be "Amazon Aurora MySQL."</p>
        pub fn set_engine_display_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_display_name = input;
            self
        }
        /// <p>The user name used to connect to the endpoint.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name used to connect to the endpoint.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The name of the server at the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The name of the server at the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>The port value used to access the endpoint.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port value used to access the endpoint.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of the database at the endpoint.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database at the endpoint.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Additional connection attributes used to connect to the endpoint.</p>
        pub fn extra_connection_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.extra_connection_attributes = Some(input.into());
            self
        }
        /// <p>Additional connection attributes used to connect to the endpoint.</p>
        pub fn set_extra_connection_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_connection_attributes = input;
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) used for SSL connection to the endpoint.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) used for SSL connection to the endpoint.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>
        pub fn ssl_mode(mut self, input: crate::model::DmsSslModeValue) -> Self {
            self.ssl_mode = Some(input);
            self
        }
        /// <p>The SSL mode used to connect to the endpoint. The default value is <code>none</code>.</p>
        pub fn set_ssl_mode(
            mut self,
            input: std::option::Option<crate::model::DmsSslModeValue>,
        ) -> Self {
            self.ssl_mode = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>The external table definition.</p>
        pub fn external_table_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_table_definition = Some(input.into());
            self
        }
        /// <p>The external table definition.</p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_table_definition = input;
            self
        }
        /// <p> Value returned by a call to CreateEndpoint that can be used for cross-account
        /// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a
        /// cross-account. </p>
        pub fn external_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_id = Some(input.into());
            self
        }
        /// <p> Value returned by a call to CreateEndpoint that can be used for cross-account
        /// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint with a
        /// cross-account. </p>
        pub fn set_external_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.external_id = input;
            self
        }
        /// <p>The settings for the DynamoDB target endpoint. For more information, see the
        /// <code>DynamoDBSettings</code> structure.</p>
        pub fn dynamo_db_settings(mut self, input: crate::model::DynamoDbSettings) -> Self {
            self.dynamo_db_settings = Some(input);
            self
        }
        /// <p>The settings for the DynamoDB target endpoint. For more information, see the
        /// <code>DynamoDBSettings</code> structure.</p>
        pub fn set_dynamo_db_settings(
            mut self,
            input: std::option::Option<crate::model::DynamoDbSettings>,
        ) -> Self {
            self.dynamo_db_settings = input;
            self
        }
        /// <p>The settings for the S3 target endpoint. For more information, see the
        /// <code>S3Settings</code> structure.</p>
        pub fn s3_settings(mut self, input: crate::model::S3Settings) -> Self {
            self.s3_settings = Some(input);
            self
        }
        /// <p>The settings for the S3 target endpoint. For more information, see the
        /// <code>S3Settings</code> structure.</p>
        pub fn set_s3_settings(
            mut self,
            input: std::option::Option<crate::model::S3Settings>,
        ) -> Self {
            self.s3_settings = input;
            self
        }
        /// <p>The settings for the DMS Transfer type source. For more information, see the DmsTransferSettings structure.  </p>
        pub fn dms_transfer_settings(mut self, input: crate::model::DmsTransferSettings) -> Self {
            self.dms_transfer_settings = Some(input);
            self
        }
        /// <p>The settings for the DMS Transfer type source. For more information, see the DmsTransferSettings structure.  </p>
        pub fn set_dms_transfer_settings(
            mut self,
            input: std::option::Option<crate::model::DmsTransferSettings>,
        ) -> Self {
            self.dms_transfer_settings = input;
            self
        }
        /// <p>The settings for the MongoDB source endpoint. For more information, see the
        /// <code>MongoDbSettings</code> structure.</p>
        pub fn mongo_db_settings(mut self, input: crate::model::MongoDbSettings) -> Self {
            self.mongo_db_settings = Some(input);
            self
        }
        /// <p>The settings for the MongoDB source endpoint. For more information, see the
        /// <code>MongoDbSettings</code> structure.</p>
        pub fn set_mongo_db_settings(
            mut self,
            input: std::option::Option<crate::model::MongoDbSettings>,
        ) -> Self {
            self.mongo_db_settings = input;
            self
        }
        /// <p>The settings for the Amazon Kinesis target endpoint. For more information, see the
        /// <code>KinesisSettings</code> structure.</p>
        pub fn kinesis_settings(mut self, input: crate::model::KinesisSettings) -> Self {
            self.kinesis_settings = Some(input);
            self
        }
        /// <p>The settings for the Amazon Kinesis target endpoint. For more information, see the
        /// <code>KinesisSettings</code> structure.</p>
        pub fn set_kinesis_settings(
            mut self,
            input: std::option::Option<crate::model::KinesisSettings>,
        ) -> Self {
            self.kinesis_settings = input;
            self
        }
        /// <p>The settings for the Apache Kafka target endpoint. For more information, see the
        /// <code>KafkaSettings</code> structure.</p>
        pub fn kafka_settings(mut self, input: crate::model::KafkaSettings) -> Self {
            self.kafka_settings = Some(input);
            self
        }
        /// <p>The settings for the Apache Kafka target endpoint. For more information, see the
        /// <code>KafkaSettings</code> structure.</p>
        pub fn set_kafka_settings(
            mut self,
            input: std::option::Option<crate::model::KafkaSettings>,
        ) -> Self {
            self.kafka_settings = input;
            self
        }
        /// <p>The settings for the OpenSearch source endpoint. For more information, see the
        /// <code>ElasticsearchSettings</code> structure.</p>
        pub fn elasticsearch_settings(
            mut self,
            input: crate::model::ElasticsearchSettings,
        ) -> Self {
            self.elasticsearch_settings = Some(input);
            self
        }
        /// <p>The settings for the OpenSearch source endpoint. For more information, see the
        /// <code>ElasticsearchSettings</code> structure.</p>
        pub fn set_elasticsearch_settings(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchSettings>,
        ) -> Self {
            self.elasticsearch_settings = input;
            self
        }
        /// <p>The settings for the Amazon Neptune target endpoint. For more information, see the
        /// <code>NeptuneSettings</code> structure.</p>
        pub fn neptune_settings(mut self, input: crate::model::NeptuneSettings) -> Self {
            self.neptune_settings = Some(input);
            self
        }
        /// <p>The settings for the Amazon Neptune target endpoint. For more information, see the
        /// <code>NeptuneSettings</code> structure.</p>
        pub fn set_neptune_settings(
            mut self,
            input: std::option::Option<crate::model::NeptuneSettings>,
        ) -> Self {
            self.neptune_settings = input;
            self
        }
        /// <p>Settings for the Amazon Redshift endpoint.</p>
        pub fn redshift_settings(mut self, input: crate::model::RedshiftSettings) -> Self {
            self.redshift_settings = Some(input);
            self
        }
        /// <p>Settings for the Amazon Redshift endpoint.</p>
        pub fn set_redshift_settings(
            mut self,
            input: std::option::Option<crate::model::RedshiftSettings>,
        ) -> Self {
            self.redshift_settings = input;
            self
        }
        /// <p>The settings for the PostgreSQL source and target endpoint. For more information, see
        /// the <code>PostgreSQLSettings</code> structure.</p>
        pub fn postgre_sql_settings(mut self, input: crate::model::PostgreSqlSettings) -> Self {
            self.postgre_sql_settings = Some(input);
            self
        }
        /// <p>The settings for the PostgreSQL source and target endpoint. For more information, see
        /// the <code>PostgreSQLSettings</code> structure.</p>
        pub fn set_postgre_sql_settings(
            mut self,
            input: std::option::Option<crate::model::PostgreSqlSettings>,
        ) -> Self {
            self.postgre_sql_settings = input;
            self
        }
        /// <p>The settings for the MySQL source and target endpoint. For more information, see the
        /// <code>MySQLSettings</code> structure.</p>
        pub fn my_sql_settings(mut self, input: crate::model::MySqlSettings) -> Self {
            self.my_sql_settings = Some(input);
            self
        }
        /// <p>The settings for the MySQL source and target endpoint. For more information, see the
        /// <code>MySQLSettings</code> structure.</p>
        pub fn set_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::MySqlSettings>,
        ) -> Self {
            self.my_sql_settings = input;
            self
        }
        /// <p>The settings for the Oracle source and target endpoint. For more information, see the
        /// <code>OracleSettings</code> structure.</p>
        pub fn oracle_settings(mut self, input: crate::model::OracleSettings) -> Self {
            self.oracle_settings = Some(input);
            self
        }
        /// <p>The settings for the Oracle source and target endpoint. For more information, see the
        /// <code>OracleSettings</code> structure.</p>
        pub fn set_oracle_settings(
            mut self,
            input: std::option::Option<crate::model::OracleSettings>,
        ) -> Self {
            self.oracle_settings = input;
            self
        }
        /// <p>The settings for the SAP ASE source and target endpoint. For more information, see the
        /// <code>SybaseSettings</code> structure.</p>
        pub fn sybase_settings(mut self, input: crate::model::SybaseSettings) -> Self {
            self.sybase_settings = Some(input);
            self
        }
        /// <p>The settings for the SAP ASE source and target endpoint. For more information, see the
        /// <code>SybaseSettings</code> structure.</p>
        pub fn set_sybase_settings(
            mut self,
            input: std::option::Option<crate::model::SybaseSettings>,
        ) -> Self {
            self.sybase_settings = input;
            self
        }
        /// <p>The settings for the Microsoft SQL Server source and target endpoint. For more
        /// information, see the <code>MicrosoftSQLServerSettings</code> structure.</p>
        pub fn microsoft_sql_server_settings(
            mut self,
            input: crate::model::MicrosoftSqlServerSettings,
        ) -> Self {
            self.microsoft_sql_server_settings = Some(input);
            self
        }
        /// <p>The settings for the Microsoft SQL Server source and target endpoint. For more
        /// information, see the <code>MicrosoftSQLServerSettings</code> structure.</p>
        pub fn set_microsoft_sql_server_settings(
            mut self,
            input: std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        ) -> Self {
            self.microsoft_sql_server_settings = input;
            self
        }
        /// <p>The settings for the IBM Db2 LUW source endpoint. For more information, see the
        /// <code>IBMDb2Settings</code> structure.
        /// </p>
        pub fn ibm_db2_settings(mut self, input: crate::model::IbmDb2Settings) -> Self {
            self.ibm_db2_settings = Some(input);
            self
        }
        /// <p>The settings for the IBM Db2 LUW source endpoint. For more information, see the
        /// <code>IBMDb2Settings</code> structure.
        /// </p>
        pub fn set_ibm_db2_settings(
            mut self,
            input: std::option::Option<crate::model::IbmDb2Settings>,
        ) -> Self {
            self.ibm_db2_settings = input;
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn doc_db_settings(mut self, input: crate::model::DocDbSettings) -> Self {
            self.doc_db_settings = Some(input);
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn set_doc_db_settings(
            mut self,
            input: std::option::Option<crate::model::DocDbSettings>,
        ) -> Self {
            self.doc_db_settings = input;
            self
        }
        /// <p>The settings for the Redis target endpoint. For more information, see the
        /// <code>RedisSettings</code> structure.</p>
        pub fn redis_settings(mut self, input: crate::model::RedisSettings) -> Self {
            self.redis_settings = Some(input);
            self
        }
        /// <p>The settings for the Redis target endpoint. For more information, see the
        /// <code>RedisSettings</code> structure.</p>
        pub fn set_redis_settings(
            mut self,
            input: std::option::Option<crate::model::RedisSettings>,
        ) -> Self {
            self.redis_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
        pub fn gcp_my_sql_settings(mut self, input: crate::model::GcpMySqlSettings) -> Self {
            self.gcp_my_sql_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
        pub fn set_gcp_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::GcpMySqlSettings>,
        ) -> Self {
            self.gcp_my_sql_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                endpoint_identifier: self.endpoint_identifier,
                endpoint_type: self.endpoint_type,
                engine_name: self.engine_name,
                engine_display_name: self.engine_display_name,
                username: self.username,
                server_name: self.server_name,
                port: self.port,
                database_name: self.database_name,
                extra_connection_attributes: self.extra_connection_attributes,
                status: self.status,
                kms_key_id: self.kms_key_id,
                endpoint_arn: self.endpoint_arn,
                certificate_arn: self.certificate_arn,
                ssl_mode: self.ssl_mode,
                service_access_role_arn: self.service_access_role_arn,
                external_table_definition: self.external_table_definition,
                external_id: self.external_id,
                dynamo_db_settings: self.dynamo_db_settings,
                s3_settings: self.s3_settings,
                dms_transfer_settings: self.dms_transfer_settings,
                mongo_db_settings: self.mongo_db_settings,
                kinesis_settings: self.kinesis_settings,
                kafka_settings: self.kafka_settings,
                elasticsearch_settings: self.elasticsearch_settings,
                neptune_settings: self.neptune_settings,
                redshift_settings: self.redshift_settings,
                postgre_sql_settings: self.postgre_sql_settings,
                my_sql_settings: self.my_sql_settings,
                oracle_settings: self.oracle_settings,
                sybase_settings: self.sybase_settings,
                microsoft_sql_server_settings: self.microsoft_sql_server_settings,
                ibm_db2_settings: self.ibm_db2_settings,
                doc_db_settings: self.doc_db_settings,
                redis_settings: self.redis_settings,
                gcp_my_sql_settings: self.gcp_my_sql_settings,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>Settings in JSON format for the source GCP MySQL endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GcpMySqlSettings {
    /// <p>Specifies a script to run immediately after DMS connects to the endpoint.
    /// The migration task continues running regardless if the SQL statement succeeds or fails.</p>
    ///
    /// <p>For this parameter, provide the code of the script itself, not the name of a file containing the script. </p>
    pub after_connect_script: std::option::Option<std::string::String>,
    /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
    /// that is hosted as part of an Always On availability group cluster. If you need DMS
    /// to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code>. </p>
    pub clean_source_metadata_on_mismatch: std::option::Option<bool>,
    /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly specify
    /// the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code>
    /// or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a
    /// MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
    /// the database only when you specify the schema in the table-mapping rules of the DMS task. </p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Specifies how often to check the binary log for new changes/events when the database is idle. The default is five seconds.</p>
    /// <p>Example: <code>eventsPollInterval=5;</code>
    /// </p>
    /// <p>In the example, DMS checks for changes in the binary logs every five seconds. </p>
    pub events_poll_interval: std::option::Option<i32>,
    /// <p>Specifies where to migrate source tables on the target, either to a single database or multiple databases.</p>
    /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
    /// </p>
    pub target_db_type: std::option::Option<crate::model::TargetDbType>,
    /// <p>Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.</p>
    /// <p>Example: <code>maxFileSize=512</code>
    /// </p>
    pub max_file_size: std::option::Option<i32>,
    /// <p>Improves performance when loading data into the MySQL-compatible target database. Specifies how many
    /// threads to use to load the data into the MySQL-compatible target database. Setting a large number of
    /// threads can have an adverse effect on database performance, because a separate connection is required
    /// for each thread. The default is one.</p>
    ///
    /// <p>Example: <code>parallelLoadThreads=1</code>
    /// </p>
    pub parallel_load_threads: std::option::Option<i32>,
    /// <p>Endpoint connection password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p></p>
    pub port: std::option::Option<i32>,
    /// <p>Endpoint TCP port.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Specifies the time zone for the source MySQL database.</p>
    ///
    /// <p>Example: <code>serverTimezone=US/Pacific;</code>
    /// </p>
    ///
    /// <p>Note: Do not enclose time zones in single quotes.</p>
    pub server_timezone: std::option::Option<std::string::String>,
    /// <p>Endpoint connection user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS
    /// as the trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret.</code> The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret
    /// that allows access to the MySQL endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify
    /// the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text
    /// values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>.
    /// You can't specify both. For more information on creating this <code>SecretsManagerSecret</code>
    /// and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to
    /// access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the
    /// Database Migration Service User Guide.
    ///
    /// </p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
    /// that contains the MySQL endpoint connection details. </p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl GcpMySqlSettings {
    /// <p>Specifies a script to run immediately after DMS connects to the endpoint.
    /// The migration task continues running regardless if the SQL statement succeeds or fails.</p>
    ///
    /// <p>For this parameter, provide the code of the script itself, not the name of a file containing the script. </p>
    pub fn after_connect_script(&self) -> std::option::Option<&str> {
        self.after_connect_script.as_deref()
    }
    /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
    /// that is hosted as part of an Always On availability group cluster. If you need DMS
    /// to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code>. </p>
    pub fn clean_source_metadata_on_mismatch(&self) -> std::option::Option<bool> {
        self.clean_source_metadata_on_mismatch
    }
    /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly specify
    /// the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code>
    /// or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a
    /// MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
    /// the database only when you specify the schema in the table-mapping rules of the DMS task. </p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Specifies how often to check the binary log for new changes/events when the database is idle. The default is five seconds.</p>
    /// <p>Example: <code>eventsPollInterval=5;</code>
    /// </p>
    /// <p>In the example, DMS checks for changes in the binary logs every five seconds. </p>
    pub fn events_poll_interval(&self) -> std::option::Option<i32> {
        self.events_poll_interval
    }
    /// <p>Specifies where to migrate source tables on the target, either to a single database or multiple databases.</p>
    /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
    /// </p>
    pub fn target_db_type(&self) -> std::option::Option<&crate::model::TargetDbType> {
        self.target_db_type.as_ref()
    }
    /// <p>Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.</p>
    /// <p>Example: <code>maxFileSize=512</code>
    /// </p>
    pub fn max_file_size(&self) -> std::option::Option<i32> {
        self.max_file_size
    }
    /// <p>Improves performance when loading data into the MySQL-compatible target database. Specifies how many
    /// threads to use to load the data into the MySQL-compatible target database. Setting a large number of
    /// threads can have an adverse effect on database performance, because a separate connection is required
    /// for each thread. The default is one.</p>
    ///
    /// <p>Example: <code>parallelLoadThreads=1</code>
    /// </p>
    pub fn parallel_load_threads(&self) -> std::option::Option<i32> {
        self.parallel_load_threads
    }
    /// <p>Endpoint connection password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p></p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Endpoint TCP port.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Specifies the time zone for the source MySQL database.</p>
    ///
    /// <p>Example: <code>serverTimezone=US/Pacific;</code>
    /// </p>
    ///
    /// <p>Note: Do not enclose time zones in single quotes.</p>
    pub fn server_timezone(&self) -> std::option::Option<&str> {
        self.server_timezone.as_deref()
    }
    /// <p>Endpoint connection user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS
    /// as the trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret.</code> The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret
    /// that allows access to the MySQL endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify
    /// the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text
    /// values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>.
    /// You can't specify both. For more information on creating this <code>SecretsManagerSecret</code>
    /// and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to
    /// access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the
    /// Database Migration Service User Guide.
    ///
    /// </p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
    /// that contains the MySQL endpoint connection details. </p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for GcpMySqlSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GcpMySqlSettings");
        formatter.field("after_connect_script", &self.after_connect_script);
        formatter.field(
            "clean_source_metadata_on_mismatch",
            &self.clean_source_metadata_on_mismatch,
        );
        formatter.field("database_name", &self.database_name);
        formatter.field("events_poll_interval", &self.events_poll_interval);
        formatter.field("target_db_type", &self.target_db_type);
        formatter.field("max_file_size", &self.max_file_size);
        formatter.field("parallel_load_threads", &self.parallel_load_threads);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field("server_name", &self.server_name);
        formatter.field("server_timezone", &self.server_timezone);
        formatter.field("username", &self.username);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`GcpMySqlSettings`](crate::model::GcpMySqlSettings)
pub mod gcp_my_sql_settings {
    /// A builder for [`GcpMySqlSettings`](crate::model::GcpMySqlSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) after_connect_script: std::option::Option<std::string::String>,
        pub(crate) clean_source_metadata_on_mismatch: std::option::Option<bool>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) events_poll_interval: std::option::Option<i32>,
        pub(crate) target_db_type: std::option::Option<crate::model::TargetDbType>,
        pub(crate) max_file_size: std::option::Option<i32>,
        pub(crate) parallel_load_threads: std::option::Option<i32>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) server_timezone: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies a script to run immediately after DMS connects to the endpoint.
        /// The migration task continues running regardless if the SQL statement succeeds or fails.</p>
        ///
        /// <p>For this parameter, provide the code of the script itself, not the name of a file containing the script. </p>
        pub fn after_connect_script(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_connect_script = Some(input.into());
            self
        }
        /// <p>Specifies a script to run immediately after DMS connects to the endpoint.
        /// The migration task continues running regardless if the SQL statement succeeds or fails.</p>
        ///
        /// <p>For this parameter, provide the code of the script itself, not the name of a file containing the script. </p>
        pub fn set_after_connect_script(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_connect_script = input;
            self
        }
        /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
        /// that is hosted as part of an Always On availability group cluster. If you need DMS
        /// to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code>. </p>
        pub fn clean_source_metadata_on_mismatch(mut self, input: bool) -> Self {
            self.clean_source_metadata_on_mismatch = Some(input);
            self
        }
        /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
        /// that is hosted as part of an Always On availability group cluster. If you need DMS
        /// to poll all the nodes in the Always On cluster for transaction backups, set this attribute to <code>false</code>. </p>
        pub fn set_clean_source_metadata_on_mismatch(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.clean_source_metadata_on_mismatch = input;
            self
        }
        /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly specify
        /// the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code>
        /// or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a
        /// MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
        /// the database only when you specify the schema in the table-mapping rules of the DMS task. </p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly specify
        /// the database using the <code>DatabaseName</code> request parameter on either the <code>CreateEndpoint</code>
        /// or <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you create or modify a
        /// MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
        /// the database only when you specify the schema in the table-mapping rules of the DMS task. </p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Specifies how often to check the binary log for new changes/events when the database is idle. The default is five seconds.</p>
        /// <p>Example: <code>eventsPollInterval=5;</code>
        /// </p>
        /// <p>In the example, DMS checks for changes in the binary logs every five seconds. </p>
        pub fn events_poll_interval(mut self, input: i32) -> Self {
            self.events_poll_interval = Some(input);
            self
        }
        /// <p>Specifies how often to check the binary log for new changes/events when the database is idle. The default is five seconds.</p>
        /// <p>Example: <code>eventsPollInterval=5;</code>
        /// </p>
        /// <p>In the example, DMS checks for changes in the binary logs every five seconds. </p>
        pub fn set_events_poll_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.events_poll_interval = input;
            self
        }
        /// <p>Specifies where to migrate source tables on the target, either to a single database or multiple databases.</p>
        /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
        /// </p>
        pub fn target_db_type(mut self, input: crate::model::TargetDbType) -> Self {
            self.target_db_type = Some(input);
            self
        }
        /// <p>Specifies where to migrate source tables on the target, either to a single database or multiple databases.</p>
        /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
        /// </p>
        pub fn set_target_db_type(
            mut self,
            input: std::option::Option<crate::model::TargetDbType>,
        ) -> Self {
            self.target_db_type = input;
            self
        }
        /// <p>Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.</p>
        /// <p>Example: <code>maxFileSize=512</code>
        /// </p>
        pub fn max_file_size(mut self, input: i32) -> Self {
            self.max_file_size = Some(input);
            self
        }
        /// <p>Specifies the maximum size (in KB) of any .csv file used to transfer data to a MySQL-compatible database.</p>
        /// <p>Example: <code>maxFileSize=512</code>
        /// </p>
        pub fn set_max_file_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_file_size = input;
            self
        }
        /// <p>Improves performance when loading data into the MySQL-compatible target database. Specifies how many
        /// threads to use to load the data into the MySQL-compatible target database. Setting a large number of
        /// threads can have an adverse effect on database performance, because a separate connection is required
        /// for each thread. The default is one.</p>
        ///
        /// <p>Example: <code>parallelLoadThreads=1</code>
        /// </p>
        pub fn parallel_load_threads(mut self, input: i32) -> Self {
            self.parallel_load_threads = Some(input);
            self
        }
        /// <p>Improves performance when loading data into the MySQL-compatible target database. Specifies how many
        /// threads to use to load the data into the MySQL-compatible target database. Setting a large number of
        /// threads can have an adverse effect on database performance, because a separate connection is required
        /// for each thread. The default is one.</p>
        ///
        /// <p>Example: <code>parallelLoadThreads=1</code>
        /// </p>
        pub fn set_parallel_load_threads(mut self, input: std::option::Option<i32>) -> Self {
            self.parallel_load_threads = input;
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p></p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p></p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Endpoint TCP port.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Endpoint TCP port.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Specifies the time zone for the source MySQL database.</p>
        ///
        /// <p>Example: <code>serverTimezone=US/Pacific;</code>
        /// </p>
        ///
        /// <p>Note: Do not enclose time zones in single quotes.</p>
        pub fn server_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_timezone = Some(input.into());
            self
        }
        /// <p>Specifies the time zone for the source MySQL database.</p>
        ///
        /// <p>Example: <code>serverTimezone=US/Pacific;</code>
        /// </p>
        ///
        /// <p>Note: Do not enclose time zones in single quotes.</p>
        pub fn set_server_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_timezone = input;
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS
        /// as the trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret.</code> The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret
        /// that allows access to the MySQL endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify
        /// the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text
        /// values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>.
        /// You can't specify both. For more information on creating this <code>SecretsManagerSecret</code>
        /// and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to
        /// access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the
        /// Database Migration Service User Guide.
        ///
        /// </p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS
        /// as the trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret.</code> The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret
        /// that allows access to the MySQL endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify
        /// the values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify clear-text
        /// values for <code>UserName</code>, <code>Password</code>, <code>ServerName</code>, and <code>Port</code>.
        /// You can't specify both. For more information on creating this <code>SecretsManagerSecret</code>
        /// and the <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code> required to
        /// access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service resources</a> in the
        /// Database Migration Service User Guide.
        ///
        /// </p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
        /// that contains the MySQL endpoint connection details. </p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
        /// that contains the MySQL endpoint connection details. </p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GcpMySqlSettings`](crate::model::GcpMySqlSettings)
        pub fn build(self) -> crate::model::GcpMySqlSettings {
            crate::model::GcpMySqlSettings {
                after_connect_script: self.after_connect_script,
                clean_source_metadata_on_mismatch: self.clean_source_metadata_on_mismatch,
                database_name: self.database_name,
                events_poll_interval: self.events_poll_interval,
                target_db_type: self.target_db_type,
                max_file_size: self.max_file_size,
                parallel_load_threads: self.parallel_load_threads,
                password: self.password,
                port: self.port,
                server_name: self.server_name,
                server_timezone: self.server_timezone,
                username: self.username,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl GcpMySqlSettings {
    /// Creates a new builder-style object to manufacture [`GcpMySqlSettings`](crate::model::GcpMySqlSettings)
    pub fn builder() -> crate::model::gcp_my_sql_settings::Builder {
        crate::model::gcp_my_sql_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetDbType {
    #[allow(missing_docs)] // documentation missing in model
    MultipleDatabases,
    #[allow(missing_docs)] // documentation missing in model
    SpecificDatabase,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetDbType {
    fn from(s: &str) -> Self {
        match s {
            "multiple-databases" => TargetDbType::MultipleDatabases,
            "specific-database" => TargetDbType::SpecificDatabase,
            other => TargetDbType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetDbType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetDbType::from(s))
    }
}
impl TargetDbType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetDbType::MultipleDatabases => "multiple-databases",
            TargetDbType::SpecificDatabase => "specific-database",
            TargetDbType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["multiple-databases", "specific-database"]
    }
}
impl AsRef<str> for TargetDbType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines a Redis target endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedisSettings {
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Transmission Control Protocol (TCP) port for the endpoint.</p>
    pub port: i32,
    /// <p>The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid
    /// values include <code>plaintext</code> and <code>ssl-encryption</code>. The default is
    /// <code>ssl-encryption</code>. The <code>ssl-encryption</code> option makes an encrypted
    /// connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA)
    /// using the <code>SslCaCertificateArn </code>setting. If an ARN isn't given for a CA, DMS
    /// uses the Amazon root CA.</p>
    /// <p>The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS)
    /// encryption for traffic between endpoint and database.</p>
    pub ssl_security_protocol: std::option::Option<crate::model::SslSecurityProtocolValue>,
    /// <p>The type of authentication to perform when connecting to a Redis target. Options include
    /// <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The
    /// <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The
    /// <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values
    /// to be provided.</p>
    pub auth_type: std::option::Option<crate::model::RedisAuthTypeValue>,
    /// <p>The user name provided with the <code>auth-role</code> option of the
    /// <code>AuthType</code> setting for a Redis target endpoint.</p>
    pub auth_user_name: std::option::Option<std::string::String>,
    /// <p>The password provided with the <code>auth-role</code> and
    /// <code>auth-token</code> options of the <code>AuthType</code> setting for a Redis
    /// target endpoint.</p>
    pub auth_password: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to
    /// connect to your Redis target endpoint.</p>
    pub ssl_ca_certificate_arn: std::option::Option<std::string::String>,
}
impl RedisSettings {
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Transmission Control Protocol (TCP) port for the endpoint.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid
    /// values include <code>plaintext</code> and <code>ssl-encryption</code>. The default is
    /// <code>ssl-encryption</code>. The <code>ssl-encryption</code> option makes an encrypted
    /// connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA)
    /// using the <code>SslCaCertificateArn </code>setting. If an ARN isn't given for a CA, DMS
    /// uses the Amazon root CA.</p>
    /// <p>The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS)
    /// encryption for traffic between endpoint and database.</p>
    pub fn ssl_security_protocol(
        &self,
    ) -> std::option::Option<&crate::model::SslSecurityProtocolValue> {
        self.ssl_security_protocol.as_ref()
    }
    /// <p>The type of authentication to perform when connecting to a Redis target. Options include
    /// <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The
    /// <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The
    /// <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values
    /// to be provided.</p>
    pub fn auth_type(&self) -> std::option::Option<&crate::model::RedisAuthTypeValue> {
        self.auth_type.as_ref()
    }
    /// <p>The user name provided with the <code>auth-role</code> option of the
    /// <code>AuthType</code> setting for a Redis target endpoint.</p>
    pub fn auth_user_name(&self) -> std::option::Option<&str> {
        self.auth_user_name.as_deref()
    }
    /// <p>The password provided with the <code>auth-role</code> and
    /// <code>auth-token</code> options of the <code>AuthType</code> setting for a Redis
    /// target endpoint.</p>
    pub fn auth_password(&self) -> std::option::Option<&str> {
        self.auth_password.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to
    /// connect to your Redis target endpoint.</p>
    pub fn ssl_ca_certificate_arn(&self) -> std::option::Option<&str> {
        self.ssl_ca_certificate_arn.as_deref()
    }
}
impl std::fmt::Debug for RedisSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedisSettings");
        formatter.field("server_name", &self.server_name);
        formatter.field("port", &self.port);
        formatter.field("ssl_security_protocol", &self.ssl_security_protocol);
        formatter.field("auth_type", &self.auth_type);
        formatter.field("auth_user_name", &self.auth_user_name);
        formatter.field("auth_password", &"*** Sensitive Data Redacted ***");
        formatter.field("ssl_ca_certificate_arn", &self.ssl_ca_certificate_arn);
        formatter.finish()
    }
}
/// See [`RedisSettings`](crate::model::RedisSettings)
pub mod redis_settings {
    /// A builder for [`RedisSettings`](crate::model::RedisSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) ssl_security_protocol:
            std::option::Option<crate::model::SslSecurityProtocolValue>,
        pub(crate) auth_type: std::option::Option<crate::model::RedisAuthTypeValue>,
        pub(crate) auth_user_name: std::option::Option<std::string::String>,
        pub(crate) auth_password: std::option::Option<std::string::String>,
        pub(crate) ssl_ca_certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Transmission Control Protocol (TCP) port for the endpoint.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Transmission Control Protocol (TCP) port for the endpoint.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid
        /// values include <code>plaintext</code> and <code>ssl-encryption</code>. The default is
        /// <code>ssl-encryption</code>. The <code>ssl-encryption</code> option makes an encrypted
        /// connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA)
        /// using the <code>SslCaCertificateArn </code>setting. If an ARN isn't given for a CA, DMS
        /// uses the Amazon root CA.</p>
        /// <p>The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS)
        /// encryption for traffic between endpoint and database.</p>
        pub fn ssl_security_protocol(
            mut self,
            input: crate::model::SslSecurityProtocolValue,
        ) -> Self {
            self.ssl_security_protocol = Some(input);
            self
        }
        /// <p>The connection to a Redis target endpoint using Transport Layer Security (TLS). Valid
        /// values include <code>plaintext</code> and <code>ssl-encryption</code>. The default is
        /// <code>ssl-encryption</code>. The <code>ssl-encryption</code> option makes an encrypted
        /// connection. Optionally, you can identify an Amazon Resource Name (ARN) for an SSL certificate authority (CA)
        /// using the <code>SslCaCertificateArn </code>setting. If an ARN isn't given for a CA, DMS
        /// uses the Amazon root CA.</p>
        /// <p>The <code>plaintext</code> option doesn't provide Transport Layer Security (TLS)
        /// encryption for traffic between endpoint and database.</p>
        pub fn set_ssl_security_protocol(
            mut self,
            input: std::option::Option<crate::model::SslSecurityProtocolValue>,
        ) -> Self {
            self.ssl_security_protocol = input;
            self
        }
        /// <p>The type of authentication to perform when connecting to a Redis target. Options include
        /// <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The
        /// <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The
        /// <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values
        /// to be provided.</p>
        pub fn auth_type(mut self, input: crate::model::RedisAuthTypeValue) -> Self {
            self.auth_type = Some(input);
            self
        }
        /// <p>The type of authentication to perform when connecting to a Redis target. Options include
        /// <code>none</code>, <code>auth-token</code>, and <code>auth-role</code>. The
        /// <code>auth-token</code> option requires an <code>AuthPassword</code> value to be provided. The
        /// <code>auth-role</code> option requires <code>AuthUserName</code> and <code>AuthPassword</code> values
        /// to be provided.</p>
        pub fn set_auth_type(
            mut self,
            input: std::option::Option<crate::model::RedisAuthTypeValue>,
        ) -> Self {
            self.auth_type = input;
            self
        }
        /// <p>The user name provided with the <code>auth-role</code> option of the
        /// <code>AuthType</code> setting for a Redis target endpoint.</p>
        pub fn auth_user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_user_name = Some(input.into());
            self
        }
        /// <p>The user name provided with the <code>auth-role</code> option of the
        /// <code>AuthType</code> setting for a Redis target endpoint.</p>
        pub fn set_auth_user_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auth_user_name = input;
            self
        }
        /// <p>The password provided with the <code>auth-role</code> and
        /// <code>auth-token</code> options of the <code>AuthType</code> setting for a Redis
        /// target endpoint.</p>
        pub fn auth_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_password = Some(input.into());
            self
        }
        /// <p>The password provided with the <code>auth-role</code> and
        /// <code>auth-token</code> options of the <code>AuthType</code> setting for a Redis
        /// target endpoint.</p>
        pub fn set_auth_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.auth_password = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to
        /// connect to your Redis target endpoint.</p>
        pub fn ssl_ca_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_ca_certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate authority (CA) that DMS uses to
        /// connect to your Redis target endpoint.</p>
        pub fn set_ssl_ca_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssl_ca_certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RedisSettings`](crate::model::RedisSettings)
        pub fn build(self) -> crate::model::RedisSettings {
            crate::model::RedisSettings {
                server_name: self.server_name,
                port: self.port.unwrap_or_default(),
                ssl_security_protocol: self.ssl_security_protocol,
                auth_type: self.auth_type,
                auth_user_name: self.auth_user_name,
                auth_password: self.auth_password,
                ssl_ca_certificate_arn: self.ssl_ca_certificate_arn,
            }
        }
    }
}
impl RedisSettings {
    /// Creates a new builder-style object to manufacture [`RedisSettings`](crate::model::RedisSettings)
    pub fn builder() -> crate::model::redis_settings::Builder {
        crate::model::redis_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RedisAuthTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    AuthRole,
    #[allow(missing_docs)] // documentation missing in model
    AuthToken,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RedisAuthTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "auth-role" => RedisAuthTypeValue::AuthRole,
            "auth-token" => RedisAuthTypeValue::AuthToken,
            "none" => RedisAuthTypeValue::None,
            other => RedisAuthTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RedisAuthTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RedisAuthTypeValue::from(s))
    }
}
impl RedisAuthTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RedisAuthTypeValue::AuthRole => "auth-role",
            RedisAuthTypeValue::AuthToken => "auth-token",
            RedisAuthTypeValue::None => "none",
            RedisAuthTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["auth-role", "auth-token", "none"]
    }
}
impl AsRef<str> for RedisAuthTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SslSecurityProtocolValue {
    #[allow(missing_docs)] // documentation missing in model
    Plaintext,
    #[allow(missing_docs)] // documentation missing in model
    SslEncryption,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SslSecurityProtocolValue {
    fn from(s: &str) -> Self {
        match s {
            "plaintext" => SslSecurityProtocolValue::Plaintext,
            "ssl-encryption" => SslSecurityProtocolValue::SslEncryption,
            other => SslSecurityProtocolValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SslSecurityProtocolValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SslSecurityProtocolValue::from(s))
    }
}
impl SslSecurityProtocolValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SslSecurityProtocolValue::Plaintext => "plaintext",
            SslSecurityProtocolValue::SslEncryption => "ssl-encryption",
            SslSecurityProtocolValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["plaintext", "ssl-encryption"]
    }
}
impl AsRef<str> for SslSecurityProtocolValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines a DocumentDB endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DocDbSettings {
    /// <p>The user name you use to access the DocumentDB source endpoint. </p>
    pub username: std::option::Option<std::string::String>,
    /// <p> The password for the user account you use to access the DocumentDB source endpoint.
    /// </p>
    pub password: std::option::Option<std::string::String>,
    /// <p> The name of the server on the DocumentDB source endpoint. </p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p> The port value for the DocumentDB source endpoint. </p>
    pub port: std::option::Option<i32>,
    /// <p> The database name on the DocumentDB source endpoint. </p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p> Specifies either document or table mode. </p>
    /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
    /// Specify <code>"one"</code> to use table mode.</p>
    pub nesting_level: std::option::Option<crate::model::NestingLevelValue>,
    /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
    /// <code>"none"</code>. </p>
    /// <p>Default value is <code>"false"</code>. </p>
    pub extract_doc_id: std::option::Option<bool>,
    /// <p> Indicates the number of documents to preview to determine the document organization.
    /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
    /// <p>Must be a positive value greater than <code>0</code>. Default value is
    /// <code>1000</code>.</p>
    pub docs_to_investigate: std::option::Option<i32>,
    /// <p>The KMS key identifier that is used to encrypt the content on the replication
    /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key. KMS creates the default encryption key for
    /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the DocumentDB endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
    /// that contains the DocumentDB endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl DocDbSettings {
    /// <p>The user name you use to access the DocumentDB source endpoint. </p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p> The password for the user account you use to access the DocumentDB source endpoint.
    /// </p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p> The name of the server on the DocumentDB source endpoint. </p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p> The port value for the DocumentDB source endpoint. </p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p> The database name on the DocumentDB source endpoint. </p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p> Specifies either document or table mode. </p>
    /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
    /// Specify <code>"one"</code> to use table mode.</p>
    pub fn nesting_level(&self) -> std::option::Option<&crate::model::NestingLevelValue> {
        self.nesting_level.as_ref()
    }
    /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
    /// <code>"none"</code>. </p>
    /// <p>Default value is <code>"false"</code>. </p>
    pub fn extract_doc_id(&self) -> std::option::Option<bool> {
        self.extract_doc_id
    }
    /// <p> Indicates the number of documents to preview to determine the document organization.
    /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
    /// <p>Must be a positive value greater than <code>0</code>. Default value is
    /// <code>1000</code>.</p>
    pub fn docs_to_investigate(&self) -> std::option::Option<i32> {
        self.docs_to_investigate
    }
    /// <p>The KMS key identifier that is used to encrypt the content on the replication
    /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key. KMS creates the default encryption key for
    /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the DocumentDB endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
    /// that contains the DocumentDB endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for DocDbSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DocDbSettings");
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("server_name", &self.server_name);
        formatter.field("port", &self.port);
        formatter.field("database_name", &self.database_name);
        formatter.field("nesting_level", &self.nesting_level);
        formatter.field("extract_doc_id", &self.extract_doc_id);
        formatter.field("docs_to_investigate", &self.docs_to_investigate);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`DocDbSettings`](crate::model::DocDbSettings)
pub mod doc_db_settings {
    /// A builder for [`DocDbSettings`](crate::model::DocDbSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) nesting_level: std::option::Option<crate::model::NestingLevelValue>,
        pub(crate) extract_doc_id: std::option::Option<bool>,
        pub(crate) docs_to_investigate: std::option::Option<i32>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name you use to access the DocumentDB source endpoint. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name you use to access the DocumentDB source endpoint. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p> The password for the user account you use to access the DocumentDB source endpoint.
        /// </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p> The password for the user account you use to access the DocumentDB source endpoint.
        /// </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p> The name of the server on the DocumentDB source endpoint. </p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p> The name of the server on the DocumentDB source endpoint. </p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p> The port value for the DocumentDB source endpoint. </p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p> The port value for the DocumentDB source endpoint. </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p> The database name on the DocumentDB source endpoint. </p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p> The database name on the DocumentDB source endpoint. </p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p> Specifies either document or table mode. </p>
        /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
        /// Specify <code>"one"</code> to use table mode.</p>
        pub fn nesting_level(mut self, input: crate::model::NestingLevelValue) -> Self {
            self.nesting_level = Some(input);
            self
        }
        /// <p> Specifies either document or table mode. </p>
        /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
        /// Specify <code>"one"</code> to use table mode.</p>
        pub fn set_nesting_level(
            mut self,
            input: std::option::Option<crate::model::NestingLevelValue>,
        ) -> Self {
            self.nesting_level = input;
            self
        }
        /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
        /// <code>"none"</code>. </p>
        /// <p>Default value is <code>"false"</code>. </p>
        pub fn extract_doc_id(mut self, input: bool) -> Self {
            self.extract_doc_id = Some(input);
            self
        }
        /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
        /// <code>"none"</code>. </p>
        /// <p>Default value is <code>"false"</code>. </p>
        pub fn set_extract_doc_id(mut self, input: std::option::Option<bool>) -> Self {
            self.extract_doc_id = input;
            self
        }
        /// <p> Indicates the number of documents to preview to determine the document organization.
        /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
        /// <p>Must be a positive value greater than <code>0</code>. Default value is
        /// <code>1000</code>.</p>
        pub fn docs_to_investigate(mut self, input: i32) -> Self {
            self.docs_to_investigate = Some(input);
            self
        }
        /// <p> Indicates the number of documents to preview to determine the document organization.
        /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
        /// <p>Must be a positive value greater than <code>0</code>. Default value is
        /// <code>1000</code>.</p>
        pub fn set_docs_to_investigate(mut self, input: std::option::Option<i32>) -> Self {
            self.docs_to_investigate = input;
            self
        }
        /// <p>The KMS key identifier that is used to encrypt the content on the replication
        /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key. KMS creates the default encryption key for
        /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key identifier that is used to encrypt the content on the replication
        /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key. KMS creates the default encryption key for
        /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the DocumentDB endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the DocumentDB endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
        /// that contains the DocumentDB endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code>
        /// that contains the DocumentDB endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DocDbSettings`](crate::model::DocDbSettings)
        pub fn build(self) -> crate::model::DocDbSettings {
            crate::model::DocDbSettings {
                username: self.username,
                password: self.password,
                server_name: self.server_name,
                port: self.port,
                database_name: self.database_name,
                nesting_level: self.nesting_level,
                extract_doc_id: self.extract_doc_id,
                docs_to_investigate: self.docs_to_investigate,
                kms_key_id: self.kms_key_id,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl DocDbSettings {
    /// Creates a new builder-style object to manufacture [`DocDbSettings`](crate::model::DocDbSettings)
    pub fn builder() -> crate::model::doc_db_settings::Builder {
        crate::model::doc_db_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NestingLevelValue {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    One,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NestingLevelValue {
    fn from(s: &str) -> Self {
        match s {
            "none" => NestingLevelValue::None,
            "one" => NestingLevelValue::One,
            other => NestingLevelValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NestingLevelValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NestingLevelValue::from(s))
    }
}
impl NestingLevelValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NestingLevelValue::None => "none",
            NestingLevelValue::One => "one",
            NestingLevelValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["none", "one"]
    }
}
impl AsRef<str> for NestingLevelValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines an IBM Db2 LUW endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IbmDb2Settings {
    /// <p>Database name for the endpoint.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Endpoint connection password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>Endpoint TCP port. The default value is 50000.</p>
    pub port: std::option::Option<i32>,
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Enables ongoing replication (CDC) as a BOOLEAN value. The
    /// default is true.</p>
    pub set_data_capture_changes: std::option::Option<bool>,
    /// <p>For ongoing replication (CDC), use CurrentLSN to specify a
    /// log sequence number (LSN) where you want the replication
    /// to start.</p>
    pub current_lsn: std::option::Option<std::string::String>,
    /// <p>Maximum number of bytes per read, as a NUMBER value.
    /// The default is 64 KB.</p>
    pub max_k_bytes_per_read: std::option::Option<i32>,
    /// <p>Endpoint connection user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of
    /// the Amazon Web Services Secrets Manager secret that allows access to the Db2 LUW endpoint. </p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Db2 LUW endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl IbmDb2Settings {
    /// <p>Database name for the endpoint.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Endpoint connection password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>Endpoint TCP port. The default value is 50000.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Enables ongoing replication (CDC) as a BOOLEAN value. The
    /// default is true.</p>
    pub fn set_data_capture_changes(&self) -> std::option::Option<bool> {
        self.set_data_capture_changes
    }
    /// <p>For ongoing replication (CDC), use CurrentLSN to specify a
    /// log sequence number (LSN) where you want the replication
    /// to start.</p>
    pub fn current_lsn(&self) -> std::option::Option<&str> {
        self.current_lsn.as_deref()
    }
    /// <p>Maximum number of bytes per read, as a NUMBER value.
    /// The default is 64 KB.</p>
    pub fn max_k_bytes_per_read(&self) -> std::option::Option<i32> {
        self.max_k_bytes_per_read
    }
    /// <p>Endpoint connection user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of
    /// the Amazon Web Services Secrets Manager secret that allows access to the Db2 LUW endpoint. </p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Db2 LUW endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for IbmDb2Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IbmDb2Settings");
        formatter.field("database_name", &self.database_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field("server_name", &self.server_name);
        formatter.field("set_data_capture_changes", &self.set_data_capture_changes);
        formatter.field("current_lsn", &self.current_lsn);
        formatter.field("max_k_bytes_per_read", &self.max_k_bytes_per_read);
        formatter.field("username", &self.username);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`IbmDb2Settings`](crate::model::IbmDb2Settings)
pub mod ibm_db2_settings {
    /// A builder for [`IbmDb2Settings`](crate::model::IbmDb2Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) set_data_capture_changes: std::option::Option<bool>,
        pub(crate) current_lsn: std::option::Option<std::string::String>,
        pub(crate) max_k_bytes_per_read: std::option::Option<i32>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Database name for the endpoint.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>Endpoint TCP port. The default value is 50000.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Endpoint TCP port. The default value is 50000.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Enables ongoing replication (CDC) as a BOOLEAN value. The
        /// default is true.</p>
        pub fn set_data_capture_changes(mut self, input: bool) -> Self {
            self.set_data_capture_changes = Some(input);
            self
        }
        /// <p>Enables ongoing replication (CDC) as a BOOLEAN value. The
        /// default is true.</p>
        pub fn set_set_data_capture_changes(mut self, input: std::option::Option<bool>) -> Self {
            self.set_data_capture_changes = input;
            self
        }
        /// <p>For ongoing replication (CDC), use CurrentLSN to specify a
        /// log sequence number (LSN) where you want the replication
        /// to start.</p>
        pub fn current_lsn(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_lsn = Some(input.into());
            self
        }
        /// <p>For ongoing replication (CDC), use CurrentLSN to specify a
        /// log sequence number (LSN) where you want the replication
        /// to start.</p>
        pub fn set_current_lsn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.current_lsn = input;
            self
        }
        /// <p>Maximum number of bytes per read, as a NUMBER value.
        /// The default is 64 KB.</p>
        pub fn max_k_bytes_per_read(mut self, input: i32) -> Self {
            self.max_k_bytes_per_read = Some(input);
            self
        }
        /// <p>Maximum number of bytes per read, as a NUMBER value.
        /// The default is 64 KB.</p>
        pub fn set_max_k_bytes_per_read(mut self, input: std::option::Option<i32>) -> Self {
            self.max_k_bytes_per_read = input;
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of
        /// the Amazon Web Services Secrets Manager secret that allows access to the Db2 LUW endpoint. </p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of
        /// the Amazon Web Services Secrets Manager secret that allows access to the Db2 LUW endpoint. </p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Db2 LUW endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Db2 LUW endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`IbmDb2Settings`](crate::model::IbmDb2Settings)
        pub fn build(self) -> crate::model::IbmDb2Settings {
            crate::model::IbmDb2Settings {
                database_name: self.database_name,
                password: self.password,
                port: self.port,
                server_name: self.server_name,
                set_data_capture_changes: self.set_data_capture_changes,
                current_lsn: self.current_lsn,
                max_k_bytes_per_read: self.max_k_bytes_per_read,
                username: self.username,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl IbmDb2Settings {
    /// Creates a new builder-style object to manufacture [`IbmDb2Settings`](crate::model::IbmDb2Settings)
    pub fn builder() -> crate::model::ibm_db2_settings::Builder {
        crate::model::ibm_db2_settings::Builder::default()
    }
}

/// <p>Provides information that defines a Microsoft SQL Server endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MicrosoftSqlServerSettings {
    /// <p>Endpoint TCP port.</p>
    pub port: std::option::Option<i32>,
    /// <p>The maximum size of the packets (in bytes) used to transfer
    /// data using BCP.</p>
    pub bcp_packet_size: std::option::Option<i32>,
    /// <p>Database name for the endpoint.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Specifies a file group for the DMS internal tables. When the replication task
    /// starts, all the internal DMS control tables (awsdms_ apply_exception, awsdms_apply,
    /// awsdms_changes) are created for the specified file group.</p>
    pub control_tables_file_group: std::option::Option<std::string::String>,
    /// <p>Endpoint connection password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>Cleans and recreates table metadata information on the replication instance when
    /// a mismatch occurs. An example is a situation where running an alter DDL statement on
    /// a table might result in different information about the table cached in the replication
    /// instance.</p>
    pub query_single_always_on_node: std::option::Option<bool>,
    /// <p>When this attribute is set to <code>Y</code>, DMS only reads changes
    /// from transaction log backups and doesn't read from the
    /// active transaction log file during ongoing replication. Setting
    /// this parameter to <code>Y</code> enables you to control active transaction
    /// log file growth during full load and ongoing replication
    /// tasks. However, it can add some source latency to ongoing
    /// replication.</p>
    pub read_backup_only: std::option::Option<bool>,
    /// <p>Use this attribute to minimize the need to access the
    /// backup log and enable DMS to prevent truncation using one of the
    /// following two methods.</p>
    /// <p>
    /// <i>Start transactions in the database:</i> This is the default
    /// method. When this method is used, DMS prevents
    /// TLOG truncation by mimicking a transaction in the database.
    /// As long as such a transaction is open, changes that appear
    /// after the transaction started aren't truncated. If you need
    /// Microsoft Replication to be enabled in your database, then
    /// you must choose this method.</p>
    /// <p>
    /// <i>Exclusively use sp_repldone within a single task</i>: When
    /// this method is used, DMS reads the changes and then
    /// uses sp_repldone to mark the TLOG transactions as ready
    /// for truncation. Although this method doesn't involve any
    /// transactional activities, it can only be used when Microsoft
    /// Replication isn't running. Also, when using this method, only
    /// one DMS task can access the database at any given
    /// time. Therefore, if you need to run parallel DMS tasks
    /// against the same database, use the default method.</p>
    pub safeguard_policy: std::option::Option<crate::model::SafeguardPolicy>,
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Endpoint connection user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>Use this to attribute to transfer data for full-load operations
    /// using BCP. When the target table contains an identity
    /// column that does not exist in the source table, you must
    /// disable the use BCP for loading table option.</p>
    pub use_bcp_full_load: std::option::Option<bool>,
    /// <p>When this attribute is set to <code>Y</code>, DMS processes third-party
    /// transaction log backups if they are created in native format.</p>
    pub use_third_party_backup_device: std::option::Option<bool>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the SQL Server endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL Server endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl MicrosoftSqlServerSettings {
    /// <p>Endpoint TCP port.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The maximum size of the packets (in bytes) used to transfer
    /// data using BCP.</p>
    pub fn bcp_packet_size(&self) -> std::option::Option<i32> {
        self.bcp_packet_size
    }
    /// <p>Database name for the endpoint.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Specifies a file group for the DMS internal tables. When the replication task
    /// starts, all the internal DMS control tables (awsdms_ apply_exception, awsdms_apply,
    /// awsdms_changes) are created for the specified file group.</p>
    pub fn control_tables_file_group(&self) -> std::option::Option<&str> {
        self.control_tables_file_group.as_deref()
    }
    /// <p>Endpoint connection password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>Cleans and recreates table metadata information on the replication instance when
    /// a mismatch occurs. An example is a situation where running an alter DDL statement on
    /// a table might result in different information about the table cached in the replication
    /// instance.</p>
    pub fn query_single_always_on_node(&self) -> std::option::Option<bool> {
        self.query_single_always_on_node
    }
    /// <p>When this attribute is set to <code>Y</code>, DMS only reads changes
    /// from transaction log backups and doesn't read from the
    /// active transaction log file during ongoing replication. Setting
    /// this parameter to <code>Y</code> enables you to control active transaction
    /// log file growth during full load and ongoing replication
    /// tasks. However, it can add some source latency to ongoing
    /// replication.</p>
    pub fn read_backup_only(&self) -> std::option::Option<bool> {
        self.read_backup_only
    }
    /// <p>Use this attribute to minimize the need to access the
    /// backup log and enable DMS to prevent truncation using one of the
    /// following two methods.</p>
    /// <p>
    /// <i>Start transactions in the database:</i> This is the default
    /// method. When this method is used, DMS prevents
    /// TLOG truncation by mimicking a transaction in the database.
    /// As long as such a transaction is open, changes that appear
    /// after the transaction started aren't truncated. If you need
    /// Microsoft Replication to be enabled in your database, then
    /// you must choose this method.</p>
    /// <p>
    /// <i>Exclusively use sp_repldone within a single task</i>: When
    /// this method is used, DMS reads the changes and then
    /// uses sp_repldone to mark the TLOG transactions as ready
    /// for truncation. Although this method doesn't involve any
    /// transactional activities, it can only be used when Microsoft
    /// Replication isn't running. Also, when using this method, only
    /// one DMS task can access the database at any given
    /// time. Therefore, if you need to run parallel DMS tasks
    /// against the same database, use the default method.</p>
    pub fn safeguard_policy(&self) -> std::option::Option<&crate::model::SafeguardPolicy> {
        self.safeguard_policy.as_ref()
    }
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Endpoint connection user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>Use this to attribute to transfer data for full-load operations
    /// using BCP. When the target table contains an identity
    /// column that does not exist in the source table, you must
    /// disable the use BCP for loading table option.</p>
    pub fn use_bcp_full_load(&self) -> std::option::Option<bool> {
        self.use_bcp_full_load
    }
    /// <p>When this attribute is set to <code>Y</code>, DMS processes third-party
    /// transaction log backups if they are created in native format.</p>
    pub fn use_third_party_backup_device(&self) -> std::option::Option<bool> {
        self.use_third_party_backup_device
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the SQL Server endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL Server endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for MicrosoftSqlServerSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MicrosoftSqlServerSettings");
        formatter.field("port", &self.port);
        formatter.field("bcp_packet_size", &self.bcp_packet_size);
        formatter.field("database_name", &self.database_name);
        formatter.field("control_tables_file_group", &self.control_tables_file_group);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "query_single_always_on_node",
            &self.query_single_always_on_node,
        );
        formatter.field("read_backup_only", &self.read_backup_only);
        formatter.field("safeguard_policy", &self.safeguard_policy);
        formatter.field("server_name", &self.server_name);
        formatter.field("username", &self.username);
        formatter.field("use_bcp_full_load", &self.use_bcp_full_load);
        formatter.field(
            "use_third_party_backup_device",
            &self.use_third_party_backup_device,
        );
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`MicrosoftSqlServerSettings`](crate::model::MicrosoftSqlServerSettings)
pub mod microsoft_sql_server_settings {
    /// A builder for [`MicrosoftSqlServerSettings`](crate::model::MicrosoftSqlServerSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) port: std::option::Option<i32>,
        pub(crate) bcp_packet_size: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) control_tables_file_group: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) query_single_always_on_node: std::option::Option<bool>,
        pub(crate) read_backup_only: std::option::Option<bool>,
        pub(crate) safeguard_policy: std::option::Option<crate::model::SafeguardPolicy>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) use_bcp_full_load: std::option::Option<bool>,
        pub(crate) use_third_party_backup_device: std::option::Option<bool>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Endpoint TCP port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Endpoint TCP port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The maximum size of the packets (in bytes) used to transfer
        /// data using BCP.</p>
        pub fn bcp_packet_size(mut self, input: i32) -> Self {
            self.bcp_packet_size = Some(input);
            self
        }
        /// <p>The maximum size of the packets (in bytes) used to transfer
        /// data using BCP.</p>
        pub fn set_bcp_packet_size(mut self, input: std::option::Option<i32>) -> Self {
            self.bcp_packet_size = input;
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Specifies a file group for the DMS internal tables. When the replication task
        /// starts, all the internal DMS control tables (awsdms_ apply_exception, awsdms_apply,
        /// awsdms_changes) are created for the specified file group.</p>
        pub fn control_tables_file_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.control_tables_file_group = Some(input.into());
            self
        }
        /// <p>Specifies a file group for the DMS internal tables. When the replication task
        /// starts, all the internal DMS control tables (awsdms_ apply_exception, awsdms_apply,
        /// awsdms_changes) are created for the specified file group.</p>
        pub fn set_control_tables_file_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.control_tables_file_group = input;
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>Cleans and recreates table metadata information on the replication instance when
        /// a mismatch occurs. An example is a situation where running an alter DDL statement on
        /// a table might result in different information about the table cached in the replication
        /// instance.</p>
        pub fn query_single_always_on_node(mut self, input: bool) -> Self {
            self.query_single_always_on_node = Some(input);
            self
        }
        /// <p>Cleans and recreates table metadata information on the replication instance when
        /// a mismatch occurs. An example is a situation where running an alter DDL statement on
        /// a table might result in different information about the table cached in the replication
        /// instance.</p>
        pub fn set_query_single_always_on_node(mut self, input: std::option::Option<bool>) -> Self {
            self.query_single_always_on_node = input;
            self
        }
        /// <p>When this attribute is set to <code>Y</code>, DMS only reads changes
        /// from transaction log backups and doesn't read from the
        /// active transaction log file during ongoing replication. Setting
        /// this parameter to <code>Y</code> enables you to control active transaction
        /// log file growth during full load and ongoing replication
        /// tasks. However, it can add some source latency to ongoing
        /// replication.</p>
        pub fn read_backup_only(mut self, input: bool) -> Self {
            self.read_backup_only = Some(input);
            self
        }
        /// <p>When this attribute is set to <code>Y</code>, DMS only reads changes
        /// from transaction log backups and doesn't read from the
        /// active transaction log file during ongoing replication. Setting
        /// this parameter to <code>Y</code> enables you to control active transaction
        /// log file growth during full load and ongoing replication
        /// tasks. However, it can add some source latency to ongoing
        /// replication.</p>
        pub fn set_read_backup_only(mut self, input: std::option::Option<bool>) -> Self {
            self.read_backup_only = input;
            self
        }
        /// <p>Use this attribute to minimize the need to access the
        /// backup log and enable DMS to prevent truncation using one of the
        /// following two methods.</p>
        /// <p>
        /// <i>Start transactions in the database:</i> This is the default
        /// method. When this method is used, DMS prevents
        /// TLOG truncation by mimicking a transaction in the database.
        /// As long as such a transaction is open, changes that appear
        /// after the transaction started aren't truncated. If you need
        /// Microsoft Replication to be enabled in your database, then
        /// you must choose this method.</p>
        /// <p>
        /// <i>Exclusively use sp_repldone within a single task</i>: When
        /// this method is used, DMS reads the changes and then
        /// uses sp_repldone to mark the TLOG transactions as ready
        /// for truncation. Although this method doesn't involve any
        /// transactional activities, it can only be used when Microsoft
        /// Replication isn't running. Also, when using this method, only
        /// one DMS task can access the database at any given
        /// time. Therefore, if you need to run parallel DMS tasks
        /// against the same database, use the default method.</p>
        pub fn safeguard_policy(mut self, input: crate::model::SafeguardPolicy) -> Self {
            self.safeguard_policy = Some(input);
            self
        }
        /// <p>Use this attribute to minimize the need to access the
        /// backup log and enable DMS to prevent truncation using one of the
        /// following two methods.</p>
        /// <p>
        /// <i>Start transactions in the database:</i> This is the default
        /// method. When this method is used, DMS prevents
        /// TLOG truncation by mimicking a transaction in the database.
        /// As long as such a transaction is open, changes that appear
        /// after the transaction started aren't truncated. If you need
        /// Microsoft Replication to be enabled in your database, then
        /// you must choose this method.</p>
        /// <p>
        /// <i>Exclusively use sp_repldone within a single task</i>: When
        /// this method is used, DMS reads the changes and then
        /// uses sp_repldone to mark the TLOG transactions as ready
        /// for truncation. Although this method doesn't involve any
        /// transactional activities, it can only be used when Microsoft
        /// Replication isn't running. Also, when using this method, only
        /// one DMS task can access the database at any given
        /// time. Therefore, if you need to run parallel DMS tasks
        /// against the same database, use the default method.</p>
        pub fn set_safeguard_policy(
            mut self,
            input: std::option::Option<crate::model::SafeguardPolicy>,
        ) -> Self {
            self.safeguard_policy = input;
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>Use this to attribute to transfer data for full-load operations
        /// using BCP. When the target table contains an identity
        /// column that does not exist in the source table, you must
        /// disable the use BCP for loading table option.</p>
        pub fn use_bcp_full_load(mut self, input: bool) -> Self {
            self.use_bcp_full_load = Some(input);
            self
        }
        /// <p>Use this to attribute to transfer data for full-load operations
        /// using BCP. When the target table contains an identity
        /// column that does not exist in the source table, you must
        /// disable the use BCP for loading table option.</p>
        pub fn set_use_bcp_full_load(mut self, input: std::option::Option<bool>) -> Self {
            self.use_bcp_full_load = input;
            self
        }
        /// <p>When this attribute is set to <code>Y</code>, DMS processes third-party
        /// transaction log backups if they are created in native format.</p>
        pub fn use_third_party_backup_device(mut self, input: bool) -> Self {
            self.use_third_party_backup_device = Some(input);
            self
        }
        /// <p>When this attribute is set to <code>Y</code>, DMS processes third-party
        /// transaction log backups if they are created in native format.</p>
        pub fn set_use_third_party_backup_device(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_third_party_backup_device = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the SQL Server endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the SQL Server endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL Server endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SQL Server endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MicrosoftSqlServerSettings`](crate::model::MicrosoftSqlServerSettings)
        pub fn build(self) -> crate::model::MicrosoftSqlServerSettings {
            crate::model::MicrosoftSqlServerSettings {
                port: self.port,
                bcp_packet_size: self.bcp_packet_size,
                database_name: self.database_name,
                control_tables_file_group: self.control_tables_file_group,
                password: self.password,
                query_single_always_on_node: self.query_single_always_on_node,
                read_backup_only: self.read_backup_only,
                safeguard_policy: self.safeguard_policy,
                server_name: self.server_name,
                username: self.username,
                use_bcp_full_load: self.use_bcp_full_load,
                use_third_party_backup_device: self.use_third_party_backup_device,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl MicrosoftSqlServerSettings {
    /// Creates a new builder-style object to manufacture [`MicrosoftSqlServerSettings`](crate::model::MicrosoftSqlServerSettings)
    pub fn builder() -> crate::model::microsoft_sql_server_settings::Builder {
        crate::model::microsoft_sql_server_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SafeguardPolicy {
    #[allow(missing_docs)] // documentation missing in model
    ExclusiveAutomaticTruncation,
    #[allow(missing_docs)] // documentation missing in model
    RelyOnSqlServerReplicationAgent,
    #[allow(missing_docs)] // documentation missing in model
    SharedAutomaticTruncation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SafeguardPolicy {
    fn from(s: &str) -> Self {
        match s {
            "exclusive-automatic-truncation" => SafeguardPolicy::ExclusiveAutomaticTruncation,
            "rely-on-sql-server-replication-agent" => {
                SafeguardPolicy::RelyOnSqlServerReplicationAgent
            }
            "shared-automatic-truncation" => SafeguardPolicy::SharedAutomaticTruncation,
            other => SafeguardPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SafeguardPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SafeguardPolicy::from(s))
    }
}
impl SafeguardPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SafeguardPolicy::ExclusiveAutomaticTruncation => "exclusive-automatic-truncation",
            SafeguardPolicy::RelyOnSqlServerReplicationAgent => {
                "rely-on-sql-server-replication-agent"
            }
            SafeguardPolicy::SharedAutomaticTruncation => "shared-automatic-truncation",
            SafeguardPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "exclusive-automatic-truncation",
            "rely-on-sql-server-replication-agent",
            "shared-automatic-truncation",
        ]
    }
}
impl AsRef<str> for SafeguardPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines a SAP ASE endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SybaseSettings {
    /// <p>Database name for the endpoint.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Endpoint connection password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>Endpoint TCP port. The default is 5000.</p>
    pub port: std::option::Option<i32>,
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Endpoint connection user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the SAP ASE endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SAP SAE endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl SybaseSettings {
    /// <p>Database name for the endpoint.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Endpoint connection password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>Endpoint TCP port. The default is 5000.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Endpoint connection user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the SAP ASE endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SAP SAE endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for SybaseSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SybaseSettings");
        formatter.field("database_name", &self.database_name);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field("server_name", &self.server_name);
        formatter.field("username", &self.username);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`SybaseSettings`](crate::model::SybaseSettings)
pub mod sybase_settings {
    /// A builder for [`SybaseSettings`](crate::model::SybaseSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Database name for the endpoint.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>Endpoint TCP port. The default is 5000.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Endpoint TCP port. The default is 5000.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the SAP ASE endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the SAP ASE endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SAP SAE endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the SAP SAE endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SybaseSettings`](crate::model::SybaseSettings)
        pub fn build(self) -> crate::model::SybaseSettings {
            crate::model::SybaseSettings {
                database_name: self.database_name,
                password: self.password,
                port: self.port,
                server_name: self.server_name,
                username: self.username,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl SybaseSettings {
    /// Creates a new builder-style object to manufacture [`SybaseSettings`](crate::model::SybaseSettings)
    pub fn builder() -> crate::model::sybase_settings::Builder {
        crate::model::sybase_settings::Builder::default()
    }
}

/// <p>Provides information that defines an Oracle endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OracleSettings {
    /// <p>Set this attribute to set up table-level supplemental logging
    /// for the Oracle database. This attribute enables PRIMARY KEY
    /// supplemental logging on all tables selected for a migration
    /// task.</p>
    /// <p>If you use this option, you still need to enable
    /// database-level supplemental logging.</p>
    pub add_supplemental_logging: std::option::Option<bool>,
    /// <p>Specifies the ID of the destination for the archived redo logs. This value
    /// should be the same as a number in the dest_id column of the v$archived_log
    /// view. If you work with an additional redo log destination, use the
    /// <code>AdditionalArchivedLogDestId</code> option to specify the additional
    /// destination ID. Doing this improves performance by ensuring that the correct
    /// logs are accessed from the outset.</p>
    pub archived_log_dest_id: std::option::Option<i32>,
    /// <p>Set this attribute with <code>ArchivedLogDestId</code> in a primary/
    /// standby setup. This attribute is useful in the case of a
    /// switchover. In this case, DMS needs to know which
    /// destination to get archive redo logs from to read changes.
    /// This need arises because the previous primary instance is
    /// now a standby instance after switchover.</p>
    /// <p>Although DMS supports the use of the Oracle
    /// <code>RESETLOGS</code> option to open the database, never
    /// use <code>RESETLOGS</code> unless necessary. For additional
    /// information about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the
    /// <i>Oracle Database Backup and Recovery User's Guide</i>.</p>
    pub additional_archived_log_dest_id: std::option::Option<i32>,
    /// <p>Specifies the IDs of one more destinations for one or more archived redo logs. These IDs
    /// are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view.
    /// Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a
    /// primary-to-single setup or a primary-to-multiple-standby setup. </p>
    /// <p>This setting is useful in a switchover when you use an Oracle Data Guard database as a
    /// source. In this case, DMS needs information about what destination to get archive redo
    /// logs from to read changes. DMS needs this because after the switchover the previous
    /// primary is a standby instance. For example, in a primary-to-single standby setup you might
    /// apply the following settings. </p>
    /// <p>
    /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
    /// </p>
    /// <p>In a primary-to-multiple-standby setup, you might apply the following settings.</p>
    /// <p>
    /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
    /// </p>
    /// <p>Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the
    /// database, never use <code>RESETLOGS</code> unless it's necessary. For more information
    /// about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"> RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery
    /// User's Guide</i>.</p>
    pub extra_archived_log_dest_ids: std::option::Option<std::vec::Vec<i32>>,
    /// <p>Set this attribute to <code>true</code> to enable replication of Oracle
    /// tables containing columns that are nested tables or defined
    /// types.</p>
    pub allow_select_nested_tables: std::option::Option<bool>,
    /// <p>Set this attribute to change the number of threads that DMS configures to perform a
    /// change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can
    /// specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute
    /// together with the <code>readAheadBlocks</code> attribute.</p>
    pub parallel_asm_read_threads: std::option::Option<i32>,
    /// <p>Set this attribute to change the number of read-ahead blocks that DMS configures to
    /// perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
    /// You can specify an integer value between 1000 (the default) and 200,000 (the
    /// maximum).</p>
    pub read_ahead_blocks: std::option::Option<i32>,
    /// <p>Set this attribute to <code>false</code> in order to use the Binary Reader
    /// to capture change data for an Amazon RDS for Oracle as the
    /// source. This tells the DMS instance to not access redo logs
    /// through any specified path prefix replacement using direct
    /// file access.</p>
    pub access_alternate_directly: std::option::Option<bool>,
    /// <p>Set this attribute to <code>true</code> in order to use the Binary Reader
    /// to capture change data for an Amazon RDS for Oracle as
    /// the source. This tells the DMS instance to use any specified
    /// prefix replacement to access all online redo logs.</p>
    pub use_alternate_folder_for_online: std::option::Option<bool>,
    /// <p>Set this string attribute to the required value in order to use
    /// the Binary Reader to capture change data for an Amazon
    /// RDS for Oracle as the source. This value specifies the
    /// default Oracle root used to access the redo logs.</p>
    pub oracle_path_prefix: std::option::Option<std::string::String>,
    /// <p>Set this string attribute to the required value in order to use
    /// the Binary Reader to capture change data for an Amazon
    /// RDS for Oracle as the source. This value specifies the path
    /// prefix used to replace the default Oracle root to access the
    /// redo logs.</p>
    pub use_path_prefix: std::option::Option<std::string::String>,
    /// <p>Set this attribute to true in order to use the Binary Reader
    /// to capture change data for an Amazon RDS for Oracle as the
    /// source. This setting tells DMS instance to replace the default
    /// Oracle root with the specified <code>usePathPrefix</code> setting to
    /// access the redo logs.</p>
    pub replace_path_prefix: std::option::Option<bool>,
    /// <p>Set this attribute to enable homogenous tablespace
    /// replication and create existing tables or indexes under the
    /// same tablespace on the target.</p>
    pub enable_homogenous_tablespace: std::option::Option<bool>,
    /// <p>When set to <code>true</code>, this attribute helps to increase the
    /// commit rate on the Oracle target database by writing
    /// directly to tables and not writing a trail to database logs.</p>
    pub direct_path_no_log: std::option::Option<bool>,
    /// <p>When this field is set to <code>Y</code>, DMS only accesses the
    /// archived redo logs. If the archived redo logs are stored on
    /// Oracle ASM only, the DMS user account needs to be
    /// granted ASM privileges.</p>
    pub archived_logs_only: std::option::Option<bool>,
    /// <p>For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password.
    /// You can set this value from the <code>
    /// <i>asm_user_password</i>
    /// </code> value.
    /// You set this value as part of the comma-separated value that you set to the
    /// <code>Password</code> request parameter when you create the endpoint to access
    /// transaction logs using Binary Reader. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
    /// database</a>.</p>
    pub asm_password: std::option::Option<std::string::String>,
    /// <p>For an Oracle source endpoint, your ASM server address. You can set this value from the
    /// <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra
    /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
    /// database</a>.</p>
    pub asm_server: std::option::Option<std::string::String>,
    /// <p>For an Oracle source endpoint, your ASM user name. You can set this value from the
    /// <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra
    /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
    /// database</a>.</p>
    pub asm_user: std::option::Option<std::string::String>,
    /// <p>Specifies whether the length of a character column is in
    /// bytes or in characters. To indicate that the character column
    /// length is in characters, set this attribute to <code>CHAR</code>. Otherwise,
    /// the character column length is in bytes.</p>
    /// <p>Example: <code>charLengthSemantics=CHAR;</code>
    /// </p>
    pub char_length_semantics: std::option::Option<crate::model::CharLengthSemantics>,
    /// <p>Database name for the endpoint.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>When set to <code>true</code>, this attribute specifies a parallel load
    /// when <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute
    /// also only applies when you use the DMS parallel load
    /// feature.  Note that the target table cannot have any constraints or indexes.</p>
    pub direct_path_parallel_load: std::option::Option<bool>,
    /// <p>When set to <code>true</code>, this attribute causes a task to fail if the
    /// actual size of an LOB column is greater than the specified
    /// <code>LobMaxSize</code>.</p>
    /// <p>If a task is set to limited LOB mode and this option is set to
    /// <code>true</code>, the task fails instead of truncating the LOB data.</p>
    pub fail_tasks_on_lob_truncation: std::option::Option<bool>,
    /// <p>Specifies the number scale. You can select a scale up to 38,
    /// or you can select FLOAT. By default, the NUMBER data type
    /// is converted to precision 38, scale 10.</p>
    /// <p>Example: <code>numberDataTypeScale=12</code>
    /// </p>
    pub number_datatype_scale: std::option::Option<i32>,
    /// <p>Endpoint connection password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>Endpoint TCP port.</p>
    pub port: std::option::Option<i32>,
    /// <p>When set to <code>true</code>, this attribute supports tablespace
    /// replication.</p>
    pub read_table_space_name: std::option::Option<bool>,
    /// <p>Specifies the number of seconds that the system waits
    /// before resending a query.</p>
    /// <p>Example: <code>retryInterval=6;</code>
    /// </p>
    pub retry_interval: std::option::Option<i32>,
    /// <p>For an Oracle source endpoint, the transparent data encryption (TDE) password required
    /// by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader. It is also the
    /// <code>
    /// <i>TDE_Password</i>
    /// </code> part of the comma-separated value you
    /// set to the <code>Password</code> request parameter when you create the endpoint. The
    /// <code>SecurityDbEncryptian</code> setting is related to this
    /// <code>SecurityDbEncryptionName</code> setting. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
    /// </a> in the <i>Database Migration Service User Guide</i>. </p>
    pub security_db_encryption: std::option::Option<std::string::String>,
    /// <p>For an Oracle source endpoint, the name of a key used for the transparent data
    /// encryption (TDE) of the columns and tablespaces in an Oracle source database that is
    /// encrypted using TDE. The key value is the value of the <code>SecurityDbEncryption</code>
    /// setting. For more information on setting the key name value of
    /// <code>SecurityDbEncryptionName</code>, see the information and example for setting the
    /// <code>securityDbEncryptionName</code> extra connection attribute in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
    /// </a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    pub security_db_encryption_name: std::option::Option<std::string::String>,
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Use this attribute to convert <code>SDO_GEOMETRY</code> to
    /// <code>GEOJSON</code> format. By default, DMS calls the
    /// <code>SDO2GEOJSON</code> custom function if present and accessible.
    /// Or you can create your own custom function that mimics the operation of
    /// <code>SDOGEOJSON</code> and set
    /// <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead. </p>
    pub spatial_data_option_to_geo_json_function_name: std::option::Option<std::string::String>,
    /// <p>Use this attribute to specify a time in minutes for the delay in standby sync. If the
    /// source is an Oracle Active Data Guard standby database, use this attribute to specify the
    /// time lag between primary and standby databases.</p>
    /// <p>In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby
    /// instance as a source for replicating ongoing changes. Doing this eliminates the need to connect
    /// to an active database that might be in production.</p>
    pub standby_delay_time: std::option::Option<i32>,
    /// <p>Endpoint connection user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>Set this attribute to Y to capture change data using the Binary Reader utility. Set
    /// <code>UseLogminerReader</code> to N to set this attribute to Y. To use Binary Reader
    /// with Amazon RDS for Oracle as the source, you set additional attributes. For more information
    /// about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for
    /// CDC</a>.</p>
    pub use_b_file: std::option::Option<bool>,
    /// <p>Set this attribute to Y to have DMS use a direct path full load.
    /// Specify this value to use the direct path protocol in the Oracle Call Interface (OCI).
    /// By using this OCI protocol, you can bulk-load Oracle target tables during a full load.</p>
    pub use_direct_path_full_load: std::option::Option<bool>,
    /// <p>Set this attribute to Y to capture change data using the Oracle LogMiner utility (the
    /// default). Set this attribute to N if you want to access the redo logs as a binary file.
    /// When you set <code>UseLogminerReader</code> to N, also set <code>UseBfile</code> to Y. For
    /// more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for CDC</a> in
    /// the <i>DMS User Guide</i>.</p>
    pub use_logminer_reader: std::option::Option<bool>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the Oracle endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Oracle endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
    /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN
    /// of the IAM role that specifies DMS as the trusted entity and grants the required
    /// permissions to access the <code>SecretsManagerOracleAsmSecret</code>. This
    /// <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to
    /// the Oracle ASM of the endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerOracleAsmSecretId</code>. Or you can
    /// specify clear-text values for <code>AsmUserName</code>, <code>AsmPassword</code>, and
    /// <code>AsmServerName</code>. You can't specify both. For more information on
    /// creating this <code>SecretsManagerOracleAsmSecret</code> and the
    /// <code>SecretsManagerOracleAsmAccessRoleArn</code> and
    /// <code>SecretsManagerOracleAsmSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_oracle_asm_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN, partial ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code>
    /// that contains the Oracle ASM connection details for the Oracle endpoint.</p>
    pub secrets_manager_oracle_asm_secret_id: std::option::Option<std::string::String>,
}
impl OracleSettings {
    /// <p>Set this attribute to set up table-level supplemental logging
    /// for the Oracle database. This attribute enables PRIMARY KEY
    /// supplemental logging on all tables selected for a migration
    /// task.</p>
    /// <p>If you use this option, you still need to enable
    /// database-level supplemental logging.</p>
    pub fn add_supplemental_logging(&self) -> std::option::Option<bool> {
        self.add_supplemental_logging
    }
    /// <p>Specifies the ID of the destination for the archived redo logs. This value
    /// should be the same as a number in the dest_id column of the v$archived_log
    /// view. If you work with an additional redo log destination, use the
    /// <code>AdditionalArchivedLogDestId</code> option to specify the additional
    /// destination ID. Doing this improves performance by ensuring that the correct
    /// logs are accessed from the outset.</p>
    pub fn archived_log_dest_id(&self) -> std::option::Option<i32> {
        self.archived_log_dest_id
    }
    /// <p>Set this attribute with <code>ArchivedLogDestId</code> in a primary/
    /// standby setup. This attribute is useful in the case of a
    /// switchover. In this case, DMS needs to know which
    /// destination to get archive redo logs from to read changes.
    /// This need arises because the previous primary instance is
    /// now a standby instance after switchover.</p>
    /// <p>Although DMS supports the use of the Oracle
    /// <code>RESETLOGS</code> option to open the database, never
    /// use <code>RESETLOGS</code> unless necessary. For additional
    /// information about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the
    /// <i>Oracle Database Backup and Recovery User's Guide</i>.</p>
    pub fn additional_archived_log_dest_id(&self) -> std::option::Option<i32> {
        self.additional_archived_log_dest_id
    }
    /// <p>Specifies the IDs of one more destinations for one or more archived redo logs. These IDs
    /// are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view.
    /// Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a
    /// primary-to-single setup or a primary-to-multiple-standby setup. </p>
    /// <p>This setting is useful in a switchover when you use an Oracle Data Guard database as a
    /// source. In this case, DMS needs information about what destination to get archive redo
    /// logs from to read changes. DMS needs this because after the switchover the previous
    /// primary is a standby instance. For example, in a primary-to-single standby setup you might
    /// apply the following settings. </p>
    /// <p>
    /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
    /// </p>
    /// <p>In a primary-to-multiple-standby setup, you might apply the following settings.</p>
    /// <p>
    /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
    /// </p>
    /// <p>Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the
    /// database, never use <code>RESETLOGS</code> unless it's necessary. For more information
    /// about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"> RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery
    /// User's Guide</i>.</p>
    pub fn extra_archived_log_dest_ids(&self) -> std::option::Option<&[i32]> {
        self.extra_archived_log_dest_ids.as_deref()
    }
    /// <p>Set this attribute to <code>true</code> to enable replication of Oracle
    /// tables containing columns that are nested tables or defined
    /// types.</p>
    pub fn allow_select_nested_tables(&self) -> std::option::Option<bool> {
        self.allow_select_nested_tables
    }
    /// <p>Set this attribute to change the number of threads that DMS configures to perform a
    /// change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can
    /// specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute
    /// together with the <code>readAheadBlocks</code> attribute.</p>
    pub fn parallel_asm_read_threads(&self) -> std::option::Option<i32> {
        self.parallel_asm_read_threads
    }
    /// <p>Set this attribute to change the number of read-ahead blocks that DMS configures to
    /// perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
    /// You can specify an integer value between 1000 (the default) and 200,000 (the
    /// maximum).</p>
    pub fn read_ahead_blocks(&self) -> std::option::Option<i32> {
        self.read_ahead_blocks
    }
    /// <p>Set this attribute to <code>false</code> in order to use the Binary Reader
    /// to capture change data for an Amazon RDS for Oracle as the
    /// source. This tells the DMS instance to not access redo logs
    /// through any specified path prefix replacement using direct
    /// file access.</p>
    pub fn access_alternate_directly(&self) -> std::option::Option<bool> {
        self.access_alternate_directly
    }
    /// <p>Set this attribute to <code>true</code> in order to use the Binary Reader
    /// to capture change data for an Amazon RDS for Oracle as
    /// the source. This tells the DMS instance to use any specified
    /// prefix replacement to access all online redo logs.</p>
    pub fn use_alternate_folder_for_online(&self) -> std::option::Option<bool> {
        self.use_alternate_folder_for_online
    }
    /// <p>Set this string attribute to the required value in order to use
    /// the Binary Reader to capture change data for an Amazon
    /// RDS for Oracle as the source. This value specifies the
    /// default Oracle root used to access the redo logs.</p>
    pub fn oracle_path_prefix(&self) -> std::option::Option<&str> {
        self.oracle_path_prefix.as_deref()
    }
    /// <p>Set this string attribute to the required value in order to use
    /// the Binary Reader to capture change data for an Amazon
    /// RDS for Oracle as the source. This value specifies the path
    /// prefix used to replace the default Oracle root to access the
    /// redo logs.</p>
    pub fn use_path_prefix(&self) -> std::option::Option<&str> {
        self.use_path_prefix.as_deref()
    }
    /// <p>Set this attribute to true in order to use the Binary Reader
    /// to capture change data for an Amazon RDS for Oracle as the
    /// source. This setting tells DMS instance to replace the default
    /// Oracle root with the specified <code>usePathPrefix</code> setting to
    /// access the redo logs.</p>
    pub fn replace_path_prefix(&self) -> std::option::Option<bool> {
        self.replace_path_prefix
    }
    /// <p>Set this attribute to enable homogenous tablespace
    /// replication and create existing tables or indexes under the
    /// same tablespace on the target.</p>
    pub fn enable_homogenous_tablespace(&self) -> std::option::Option<bool> {
        self.enable_homogenous_tablespace
    }
    /// <p>When set to <code>true</code>, this attribute helps to increase the
    /// commit rate on the Oracle target database by writing
    /// directly to tables and not writing a trail to database logs.</p>
    pub fn direct_path_no_log(&self) -> std::option::Option<bool> {
        self.direct_path_no_log
    }
    /// <p>When this field is set to <code>Y</code>, DMS only accesses the
    /// archived redo logs. If the archived redo logs are stored on
    /// Oracle ASM only, the DMS user account needs to be
    /// granted ASM privileges.</p>
    pub fn archived_logs_only(&self) -> std::option::Option<bool> {
        self.archived_logs_only
    }
    /// <p>For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password.
    /// You can set this value from the <code>
    /// <i>asm_user_password</i>
    /// </code> value.
    /// You set this value as part of the comma-separated value that you set to the
    /// <code>Password</code> request parameter when you create the endpoint to access
    /// transaction logs using Binary Reader. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
    /// database</a>.</p>
    pub fn asm_password(&self) -> std::option::Option<&str> {
        self.asm_password.as_deref()
    }
    /// <p>For an Oracle source endpoint, your ASM server address. You can set this value from the
    /// <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra
    /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
    /// database</a>.</p>
    pub fn asm_server(&self) -> std::option::Option<&str> {
        self.asm_server.as_deref()
    }
    /// <p>For an Oracle source endpoint, your ASM user name. You can set this value from the
    /// <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra
    /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
    /// database</a>.</p>
    pub fn asm_user(&self) -> std::option::Option<&str> {
        self.asm_user.as_deref()
    }
    /// <p>Specifies whether the length of a character column is in
    /// bytes or in characters. To indicate that the character column
    /// length is in characters, set this attribute to <code>CHAR</code>. Otherwise,
    /// the character column length is in bytes.</p>
    /// <p>Example: <code>charLengthSemantics=CHAR;</code>
    /// </p>
    pub fn char_length_semantics(&self) -> std::option::Option<&crate::model::CharLengthSemantics> {
        self.char_length_semantics.as_ref()
    }
    /// <p>Database name for the endpoint.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>When set to <code>true</code>, this attribute specifies a parallel load
    /// when <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute
    /// also only applies when you use the DMS parallel load
    /// feature.  Note that the target table cannot have any constraints or indexes.</p>
    pub fn direct_path_parallel_load(&self) -> std::option::Option<bool> {
        self.direct_path_parallel_load
    }
    /// <p>When set to <code>true</code>, this attribute causes a task to fail if the
    /// actual size of an LOB column is greater than the specified
    /// <code>LobMaxSize</code>.</p>
    /// <p>If a task is set to limited LOB mode and this option is set to
    /// <code>true</code>, the task fails instead of truncating the LOB data.</p>
    pub fn fail_tasks_on_lob_truncation(&self) -> std::option::Option<bool> {
        self.fail_tasks_on_lob_truncation
    }
    /// <p>Specifies the number scale. You can select a scale up to 38,
    /// or you can select FLOAT. By default, the NUMBER data type
    /// is converted to precision 38, scale 10.</p>
    /// <p>Example: <code>numberDataTypeScale=12</code>
    /// </p>
    pub fn number_datatype_scale(&self) -> std::option::Option<i32> {
        self.number_datatype_scale
    }
    /// <p>Endpoint connection password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>Endpoint TCP port.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>When set to <code>true</code>, this attribute supports tablespace
    /// replication.</p>
    pub fn read_table_space_name(&self) -> std::option::Option<bool> {
        self.read_table_space_name
    }
    /// <p>Specifies the number of seconds that the system waits
    /// before resending a query.</p>
    /// <p>Example: <code>retryInterval=6;</code>
    /// </p>
    pub fn retry_interval(&self) -> std::option::Option<i32> {
        self.retry_interval
    }
    /// <p>For an Oracle source endpoint, the transparent data encryption (TDE) password required
    /// by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader. It is also the
    /// <code>
    /// <i>TDE_Password</i>
    /// </code> part of the comma-separated value you
    /// set to the <code>Password</code> request parameter when you create the endpoint. The
    /// <code>SecurityDbEncryptian</code> setting is related to this
    /// <code>SecurityDbEncryptionName</code> setting. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
    /// </a> in the <i>Database Migration Service User Guide</i>. </p>
    pub fn security_db_encryption(&self) -> std::option::Option<&str> {
        self.security_db_encryption.as_deref()
    }
    /// <p>For an Oracle source endpoint, the name of a key used for the transparent data
    /// encryption (TDE) of the columns and tablespaces in an Oracle source database that is
    /// encrypted using TDE. The key value is the value of the <code>SecurityDbEncryption</code>
    /// setting. For more information on setting the key name value of
    /// <code>SecurityDbEncryptionName</code>, see the information and example for setting the
    /// <code>securityDbEncryptionName</code> extra connection attribute in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
    /// </a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    pub fn security_db_encryption_name(&self) -> std::option::Option<&str> {
        self.security_db_encryption_name.as_deref()
    }
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Use this attribute to convert <code>SDO_GEOMETRY</code> to
    /// <code>GEOJSON</code> format. By default, DMS calls the
    /// <code>SDO2GEOJSON</code> custom function if present and accessible.
    /// Or you can create your own custom function that mimics the operation of
    /// <code>SDOGEOJSON</code> and set
    /// <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead. </p>
    pub fn spatial_data_option_to_geo_json_function_name(&self) -> std::option::Option<&str> {
        self.spatial_data_option_to_geo_json_function_name
            .as_deref()
    }
    /// <p>Use this attribute to specify a time in minutes for the delay in standby sync. If the
    /// source is an Oracle Active Data Guard standby database, use this attribute to specify the
    /// time lag between primary and standby databases.</p>
    /// <p>In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby
    /// instance as a source for replicating ongoing changes. Doing this eliminates the need to connect
    /// to an active database that might be in production.</p>
    pub fn standby_delay_time(&self) -> std::option::Option<i32> {
        self.standby_delay_time
    }
    /// <p>Endpoint connection user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>Set this attribute to Y to capture change data using the Binary Reader utility. Set
    /// <code>UseLogminerReader</code> to N to set this attribute to Y. To use Binary Reader
    /// with Amazon RDS for Oracle as the source, you set additional attributes. For more information
    /// about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for
    /// CDC</a>.</p>
    pub fn use_b_file(&self) -> std::option::Option<bool> {
        self.use_b_file
    }
    /// <p>Set this attribute to Y to have DMS use a direct path full load.
    /// Specify this value to use the direct path protocol in the Oracle Call Interface (OCI).
    /// By using this OCI protocol, you can bulk-load Oracle target tables during a full load.</p>
    pub fn use_direct_path_full_load(&self) -> std::option::Option<bool> {
        self.use_direct_path_full_load
    }
    /// <p>Set this attribute to Y to capture change data using the Oracle LogMiner utility (the
    /// default). Set this attribute to N if you want to access the redo logs as a binary file.
    /// When you set <code>UseLogminerReader</code> to N, also set <code>UseBfile</code> to Y. For
    /// more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for CDC</a> in
    /// the <i>DMS User Guide</i>.</p>
    pub fn use_logminer_reader(&self) -> std::option::Option<bool> {
        self.use_logminer_reader
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the Oracle endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Oracle endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
    /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN
    /// of the IAM role that specifies DMS as the trusted entity and grants the required
    /// permissions to access the <code>SecretsManagerOracleAsmSecret</code>. This
    /// <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to
    /// the Oracle ASM of the endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerOracleAsmSecretId</code>. Or you can
    /// specify clear-text values for <code>AsmUserName</code>, <code>AsmPassword</code>, and
    /// <code>AsmServerName</code>. You can't specify both. For more information on
    /// creating this <code>SecretsManagerOracleAsmSecret</code> and the
    /// <code>SecretsManagerOracleAsmAccessRoleArn</code> and
    /// <code>SecretsManagerOracleAsmSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_oracle_asm_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_oracle_asm_access_role_arn.as_deref()
    }
    /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN, partial ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code>
    /// that contains the Oracle ASM connection details for the Oracle endpoint.</p>
    pub fn secrets_manager_oracle_asm_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_oracle_asm_secret_id.as_deref()
    }
}
impl std::fmt::Debug for OracleSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OracleSettings");
        formatter.field("add_supplemental_logging", &self.add_supplemental_logging);
        formatter.field("archived_log_dest_id", &self.archived_log_dest_id);
        formatter.field(
            "additional_archived_log_dest_id",
            &self.additional_archived_log_dest_id,
        );
        formatter.field(
            "extra_archived_log_dest_ids",
            &self.extra_archived_log_dest_ids,
        );
        formatter.field(
            "allow_select_nested_tables",
            &self.allow_select_nested_tables,
        );
        formatter.field("parallel_asm_read_threads", &self.parallel_asm_read_threads);
        formatter.field("read_ahead_blocks", &self.read_ahead_blocks);
        formatter.field("access_alternate_directly", &self.access_alternate_directly);
        formatter.field(
            "use_alternate_folder_for_online",
            &self.use_alternate_folder_for_online,
        );
        formatter.field("oracle_path_prefix", &self.oracle_path_prefix);
        formatter.field("use_path_prefix", &self.use_path_prefix);
        formatter.field("replace_path_prefix", &self.replace_path_prefix);
        formatter.field(
            "enable_homogenous_tablespace",
            &self.enable_homogenous_tablespace,
        );
        formatter.field("direct_path_no_log", &self.direct_path_no_log);
        formatter.field("archived_logs_only", &self.archived_logs_only);
        formatter.field("asm_password", &"*** Sensitive Data Redacted ***");
        formatter.field("asm_server", &self.asm_server);
        formatter.field("asm_user", &self.asm_user);
        formatter.field("char_length_semantics", &self.char_length_semantics);
        formatter.field("database_name", &self.database_name);
        formatter.field("direct_path_parallel_load", &self.direct_path_parallel_load);
        formatter.field(
            "fail_tasks_on_lob_truncation",
            &self.fail_tasks_on_lob_truncation,
        );
        formatter.field("number_datatype_scale", &self.number_datatype_scale);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field("read_table_space_name", &self.read_table_space_name);
        formatter.field("retry_interval", &self.retry_interval);
        formatter.field("security_db_encryption", &"*** Sensitive Data Redacted ***");
        formatter.field(
            "security_db_encryption_name",
            &self.security_db_encryption_name,
        );
        formatter.field("server_name", &self.server_name);
        formatter.field(
            "spatial_data_option_to_geo_json_function_name",
            &self.spatial_data_option_to_geo_json_function_name,
        );
        formatter.field("standby_delay_time", &self.standby_delay_time);
        formatter.field("username", &self.username);
        formatter.field("use_b_file", &self.use_b_file);
        formatter.field("use_direct_path_full_load", &self.use_direct_path_full_load);
        formatter.field("use_logminer_reader", &self.use_logminer_reader);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.field(
            "secrets_manager_oracle_asm_access_role_arn",
            &self.secrets_manager_oracle_asm_access_role_arn,
        );
        formatter.field(
            "secrets_manager_oracle_asm_secret_id",
            &self.secrets_manager_oracle_asm_secret_id,
        );
        formatter.finish()
    }
}
/// See [`OracleSettings`](crate::model::OracleSettings)
pub mod oracle_settings {
    /// A builder for [`OracleSettings`](crate::model::OracleSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) add_supplemental_logging: std::option::Option<bool>,
        pub(crate) archived_log_dest_id: std::option::Option<i32>,
        pub(crate) additional_archived_log_dest_id: std::option::Option<i32>,
        pub(crate) extra_archived_log_dest_ids: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) allow_select_nested_tables: std::option::Option<bool>,
        pub(crate) parallel_asm_read_threads: std::option::Option<i32>,
        pub(crate) read_ahead_blocks: std::option::Option<i32>,
        pub(crate) access_alternate_directly: std::option::Option<bool>,
        pub(crate) use_alternate_folder_for_online: std::option::Option<bool>,
        pub(crate) oracle_path_prefix: std::option::Option<std::string::String>,
        pub(crate) use_path_prefix: std::option::Option<std::string::String>,
        pub(crate) replace_path_prefix: std::option::Option<bool>,
        pub(crate) enable_homogenous_tablespace: std::option::Option<bool>,
        pub(crate) direct_path_no_log: std::option::Option<bool>,
        pub(crate) archived_logs_only: std::option::Option<bool>,
        pub(crate) asm_password: std::option::Option<std::string::String>,
        pub(crate) asm_server: std::option::Option<std::string::String>,
        pub(crate) asm_user: std::option::Option<std::string::String>,
        pub(crate) char_length_semantics: std::option::Option<crate::model::CharLengthSemantics>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) direct_path_parallel_load: std::option::Option<bool>,
        pub(crate) fail_tasks_on_lob_truncation: std::option::Option<bool>,
        pub(crate) number_datatype_scale: std::option::Option<i32>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) read_table_space_name: std::option::Option<bool>,
        pub(crate) retry_interval: std::option::Option<i32>,
        pub(crate) security_db_encryption: std::option::Option<std::string::String>,
        pub(crate) security_db_encryption_name: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) spatial_data_option_to_geo_json_function_name:
            std::option::Option<std::string::String>,
        pub(crate) standby_delay_time: std::option::Option<i32>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) use_b_file: std::option::Option<bool>,
        pub(crate) use_direct_path_full_load: std::option::Option<bool>,
        pub(crate) use_logminer_reader: std::option::Option<bool>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_oracle_asm_access_role_arn:
            std::option::Option<std::string::String>,
        pub(crate) secrets_manager_oracle_asm_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Set this attribute to set up table-level supplemental logging
        /// for the Oracle database. This attribute enables PRIMARY KEY
        /// supplemental logging on all tables selected for a migration
        /// task.</p>
        /// <p>If you use this option, you still need to enable
        /// database-level supplemental logging.</p>
        pub fn add_supplemental_logging(mut self, input: bool) -> Self {
            self.add_supplemental_logging = Some(input);
            self
        }
        /// <p>Set this attribute to set up table-level supplemental logging
        /// for the Oracle database. This attribute enables PRIMARY KEY
        /// supplemental logging on all tables selected for a migration
        /// task.</p>
        /// <p>If you use this option, you still need to enable
        /// database-level supplemental logging.</p>
        pub fn set_add_supplemental_logging(mut self, input: std::option::Option<bool>) -> Self {
            self.add_supplemental_logging = input;
            self
        }
        /// <p>Specifies the ID of the destination for the archived redo logs. This value
        /// should be the same as a number in the dest_id column of the v$archived_log
        /// view. If you work with an additional redo log destination, use the
        /// <code>AdditionalArchivedLogDestId</code> option to specify the additional
        /// destination ID. Doing this improves performance by ensuring that the correct
        /// logs are accessed from the outset.</p>
        pub fn archived_log_dest_id(mut self, input: i32) -> Self {
            self.archived_log_dest_id = Some(input);
            self
        }
        /// <p>Specifies the ID of the destination for the archived redo logs. This value
        /// should be the same as a number in the dest_id column of the v$archived_log
        /// view. If you work with an additional redo log destination, use the
        /// <code>AdditionalArchivedLogDestId</code> option to specify the additional
        /// destination ID. Doing this improves performance by ensuring that the correct
        /// logs are accessed from the outset.</p>
        pub fn set_archived_log_dest_id(mut self, input: std::option::Option<i32>) -> Self {
            self.archived_log_dest_id = input;
            self
        }
        /// <p>Set this attribute with <code>ArchivedLogDestId</code> in a primary/
        /// standby setup. This attribute is useful in the case of a
        /// switchover. In this case, DMS needs to know which
        /// destination to get archive redo logs from to read changes.
        /// This need arises because the previous primary instance is
        /// now a standby instance after switchover.</p>
        /// <p>Although DMS supports the use of the Oracle
        /// <code>RESETLOGS</code> option to open the database, never
        /// use <code>RESETLOGS</code> unless necessary. For additional
        /// information about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the
        /// <i>Oracle Database Backup and Recovery User's Guide</i>.</p>
        pub fn additional_archived_log_dest_id(mut self, input: i32) -> Self {
            self.additional_archived_log_dest_id = Some(input);
            self
        }
        /// <p>Set this attribute with <code>ArchivedLogDestId</code> in a primary/
        /// standby setup. This attribute is useful in the case of a
        /// switchover. In this case, DMS needs to know which
        /// destination to get archive redo logs from to read changes.
        /// This need arises because the previous primary instance is
        /// now a standby instance after switchover.</p>
        /// <p>Although DMS supports the use of the Oracle
        /// <code>RESETLOGS</code> option to open the database, never
        /// use <code>RESETLOGS</code> unless necessary. For additional
        /// information about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B">RMAN Data Repair Concepts</a> in the
        /// <i>Oracle Database Backup and Recovery User's Guide</i>.</p>
        pub fn set_additional_archived_log_dest_id(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.additional_archived_log_dest_id = input;
            self
        }
        /// Appends an item to `extra_archived_log_dest_ids`.
        ///
        /// To override the contents of this collection use [`set_extra_archived_log_dest_ids`](Self::set_extra_archived_log_dest_ids).
        ///
        /// <p>Specifies the IDs of one more destinations for one or more archived redo logs. These IDs
        /// are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view.
        /// Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a
        /// primary-to-single setup or a primary-to-multiple-standby setup. </p>
        /// <p>This setting is useful in a switchover when you use an Oracle Data Guard database as a
        /// source. In this case, DMS needs information about what destination to get archive redo
        /// logs from to read changes. DMS needs this because after the switchover the previous
        /// primary is a standby instance. For example, in a primary-to-single standby setup you might
        /// apply the following settings. </p>
        /// <p>
        /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
        /// </p>
        /// <p>In a primary-to-multiple-standby setup, you might apply the following settings.</p>
        /// <p>
        /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
        /// </p>
        /// <p>Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the
        /// database, never use <code>RESETLOGS</code> unless it's necessary. For more information
        /// about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"> RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery
        /// User's Guide</i>.</p>
        pub fn extra_archived_log_dest_ids(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.extra_archived_log_dest_ids.unwrap_or_default();
            v.push(input.into());
            self.extra_archived_log_dest_ids = Some(v);
            self
        }
        /// <p>Specifies the IDs of one more destinations for one or more archived redo logs. These IDs
        /// are the values of the <code>dest_id</code> column in the <code>v$archived_log</code> view.
        /// Use this setting with the <code>archivedLogDestId</code> extra connection attribute in a
        /// primary-to-single setup or a primary-to-multiple-standby setup. </p>
        /// <p>This setting is useful in a switchover when you use an Oracle Data Guard database as a
        /// source. In this case, DMS needs information about what destination to get archive redo
        /// logs from to read changes. DMS needs this because after the switchover the previous
        /// primary is a standby instance. For example, in a primary-to-single standby setup you might
        /// apply the following settings. </p>
        /// <p>
        /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2]</code>
        /// </p>
        /// <p>In a primary-to-multiple-standby setup, you might apply the following settings.</p>
        /// <p>
        /// <code>archivedLogDestId=1; ExtraArchivedLogDestIds=[2,3,4]</code>
        /// </p>
        /// <p>Although DMS supports the use of the Oracle <code>RESETLOGS</code> option to open the
        /// database, never use <code>RESETLOGS</code> unless it's necessary. For more information
        /// about <code>RESETLOGS</code>, see <a href="https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B"> RMAN Data Repair Concepts</a> in the <i>Oracle Database Backup and Recovery
        /// User's Guide</i>.</p>
        pub fn set_extra_archived_log_dest_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<i32>>,
        ) -> Self {
            self.extra_archived_log_dest_ids = input;
            self
        }
        /// <p>Set this attribute to <code>true</code> to enable replication of Oracle
        /// tables containing columns that are nested tables or defined
        /// types.</p>
        pub fn allow_select_nested_tables(mut self, input: bool) -> Self {
            self.allow_select_nested_tables = Some(input);
            self
        }
        /// <p>Set this attribute to <code>true</code> to enable replication of Oracle
        /// tables containing columns that are nested tables or defined
        /// types.</p>
        pub fn set_allow_select_nested_tables(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_select_nested_tables = input;
            self
        }
        /// <p>Set this attribute to change the number of threads that DMS configures to perform a
        /// change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can
        /// specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute
        /// together with the <code>readAheadBlocks</code> attribute.</p>
        pub fn parallel_asm_read_threads(mut self, input: i32) -> Self {
            self.parallel_asm_read_threads = Some(input);
            self
        }
        /// <p>Set this attribute to change the number of threads that DMS configures to perform a
        /// change data capture (CDC) load using Oracle Automatic Storage Management (ASM). You can
        /// specify an integer value between 2 (the default) and 8 (the maximum). Use this attribute
        /// together with the <code>readAheadBlocks</code> attribute.</p>
        pub fn set_parallel_asm_read_threads(mut self, input: std::option::Option<i32>) -> Self {
            self.parallel_asm_read_threads = input;
            self
        }
        /// <p>Set this attribute to change the number of read-ahead blocks that DMS configures to
        /// perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
        /// You can specify an integer value between 1000 (the default) and 200,000 (the
        /// maximum).</p>
        pub fn read_ahead_blocks(mut self, input: i32) -> Self {
            self.read_ahead_blocks = Some(input);
            self
        }
        /// <p>Set this attribute to change the number of read-ahead blocks that DMS configures to
        /// perform a change data capture (CDC) load using Oracle Automatic Storage Management (ASM).
        /// You can specify an integer value between 1000 (the default) and 200,000 (the
        /// maximum).</p>
        pub fn set_read_ahead_blocks(mut self, input: std::option::Option<i32>) -> Self {
            self.read_ahead_blocks = input;
            self
        }
        /// <p>Set this attribute to <code>false</code> in order to use the Binary Reader
        /// to capture change data for an Amazon RDS for Oracle as the
        /// source. This tells the DMS instance to not access redo logs
        /// through any specified path prefix replacement using direct
        /// file access.</p>
        pub fn access_alternate_directly(mut self, input: bool) -> Self {
            self.access_alternate_directly = Some(input);
            self
        }
        /// <p>Set this attribute to <code>false</code> in order to use the Binary Reader
        /// to capture change data for an Amazon RDS for Oracle as the
        /// source. This tells the DMS instance to not access redo logs
        /// through any specified path prefix replacement using direct
        /// file access.</p>
        pub fn set_access_alternate_directly(mut self, input: std::option::Option<bool>) -> Self {
            self.access_alternate_directly = input;
            self
        }
        /// <p>Set this attribute to <code>true</code> in order to use the Binary Reader
        /// to capture change data for an Amazon RDS for Oracle as
        /// the source. This tells the DMS instance to use any specified
        /// prefix replacement to access all online redo logs.</p>
        pub fn use_alternate_folder_for_online(mut self, input: bool) -> Self {
            self.use_alternate_folder_for_online = Some(input);
            self
        }
        /// <p>Set this attribute to <code>true</code> in order to use the Binary Reader
        /// to capture change data for an Amazon RDS for Oracle as
        /// the source. This tells the DMS instance to use any specified
        /// prefix replacement to access all online redo logs.</p>
        pub fn set_use_alternate_folder_for_online(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_alternate_folder_for_online = input;
            self
        }
        /// <p>Set this string attribute to the required value in order to use
        /// the Binary Reader to capture change data for an Amazon
        /// RDS for Oracle as the source. This value specifies the
        /// default Oracle root used to access the redo logs.</p>
        pub fn oracle_path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.oracle_path_prefix = Some(input.into());
            self
        }
        /// <p>Set this string attribute to the required value in order to use
        /// the Binary Reader to capture change data for an Amazon
        /// RDS for Oracle as the source. This value specifies the
        /// default Oracle root used to access the redo logs.</p>
        pub fn set_oracle_path_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.oracle_path_prefix = input;
            self
        }
        /// <p>Set this string attribute to the required value in order to use
        /// the Binary Reader to capture change data for an Amazon
        /// RDS for Oracle as the source. This value specifies the path
        /// prefix used to replace the default Oracle root to access the
        /// redo logs.</p>
        pub fn use_path_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.use_path_prefix = Some(input.into());
            self
        }
        /// <p>Set this string attribute to the required value in order to use
        /// the Binary Reader to capture change data for an Amazon
        /// RDS for Oracle as the source. This value specifies the path
        /// prefix used to replace the default Oracle root to access the
        /// redo logs.</p>
        pub fn set_use_path_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.use_path_prefix = input;
            self
        }
        /// <p>Set this attribute to true in order to use the Binary Reader
        /// to capture change data for an Amazon RDS for Oracle as the
        /// source. This setting tells DMS instance to replace the default
        /// Oracle root with the specified <code>usePathPrefix</code> setting to
        /// access the redo logs.</p>
        pub fn replace_path_prefix(mut self, input: bool) -> Self {
            self.replace_path_prefix = Some(input);
            self
        }
        /// <p>Set this attribute to true in order to use the Binary Reader
        /// to capture change data for an Amazon RDS for Oracle as the
        /// source. This setting tells DMS instance to replace the default
        /// Oracle root with the specified <code>usePathPrefix</code> setting to
        /// access the redo logs.</p>
        pub fn set_replace_path_prefix(mut self, input: std::option::Option<bool>) -> Self {
            self.replace_path_prefix = input;
            self
        }
        /// <p>Set this attribute to enable homogenous tablespace
        /// replication and create existing tables or indexes under the
        /// same tablespace on the target.</p>
        pub fn enable_homogenous_tablespace(mut self, input: bool) -> Self {
            self.enable_homogenous_tablespace = Some(input);
            self
        }
        /// <p>Set this attribute to enable homogenous tablespace
        /// replication and create existing tables or indexes under the
        /// same tablespace on the target.</p>
        pub fn set_enable_homogenous_tablespace(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_homogenous_tablespace = input;
            self
        }
        /// <p>When set to <code>true</code>, this attribute helps to increase the
        /// commit rate on the Oracle target database by writing
        /// directly to tables and not writing a trail to database logs.</p>
        pub fn direct_path_no_log(mut self, input: bool) -> Self {
            self.direct_path_no_log = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, this attribute helps to increase the
        /// commit rate on the Oracle target database by writing
        /// directly to tables and not writing a trail to database logs.</p>
        pub fn set_direct_path_no_log(mut self, input: std::option::Option<bool>) -> Self {
            self.direct_path_no_log = input;
            self
        }
        /// <p>When this field is set to <code>Y</code>, DMS only accesses the
        /// archived redo logs. If the archived redo logs are stored on
        /// Oracle ASM only, the DMS user account needs to be
        /// granted ASM privileges.</p>
        pub fn archived_logs_only(mut self, input: bool) -> Self {
            self.archived_logs_only = Some(input);
            self
        }
        /// <p>When this field is set to <code>Y</code>, DMS only accesses the
        /// archived redo logs. If the archived redo logs are stored on
        /// Oracle ASM only, the DMS user account needs to be
        /// granted ASM privileges.</p>
        pub fn set_archived_logs_only(mut self, input: std::option::Option<bool>) -> Self {
            self.archived_logs_only = input;
            self
        }
        /// <p>For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password.
        /// You can set this value from the <code>
        /// <i>asm_user_password</i>
        /// </code> value.
        /// You set this value as part of the comma-separated value that you set to the
        /// <code>Password</code> request parameter when you create the endpoint to access
        /// transaction logs using Binary Reader. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
        /// database</a>.</p>
        pub fn asm_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.asm_password = Some(input.into());
            self
        }
        /// <p>For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM) password.
        /// You can set this value from the <code>
        /// <i>asm_user_password</i>
        /// </code> value.
        /// You set this value as part of the comma-separated value that you set to the
        /// <code>Password</code> request parameter when you create the endpoint to access
        /// transaction logs using Binary Reader. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
        /// database</a>.</p>
        pub fn set_asm_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asm_password = input;
            self
        }
        /// <p>For an Oracle source endpoint, your ASM server address. You can set this value from the
        /// <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra
        /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
        /// database</a>.</p>
        pub fn asm_server(mut self, input: impl Into<std::string::String>) -> Self {
            self.asm_server = Some(input.into());
            self
        }
        /// <p>For an Oracle source endpoint, your ASM server address. You can set this value from the
        /// <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra
        /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
        /// database</a>.</p>
        pub fn set_asm_server(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asm_server = input;
            self
        }
        /// <p>For an Oracle source endpoint, your ASM user name. You can set this value from the
        /// <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra
        /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
        /// database</a>.</p>
        pub fn asm_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.asm_user = Some(input.into());
            self
        }
        /// <p>For an Oracle source endpoint, your ASM user name. You can set this value from the
        /// <code>asm_user</code> value. You set <code>asm_user</code> as part of the extra
        /// connection attribute string to access an Oracle server with Binary Reader that uses ASM.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration">Configuration for change data capture (CDC) on an Oracle source
        /// database</a>.</p>
        pub fn set_asm_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asm_user = input;
            self
        }
        /// <p>Specifies whether the length of a character column is in
        /// bytes or in characters. To indicate that the character column
        /// length is in characters, set this attribute to <code>CHAR</code>. Otherwise,
        /// the character column length is in bytes.</p>
        /// <p>Example: <code>charLengthSemantics=CHAR;</code>
        /// </p>
        pub fn char_length_semantics(mut self, input: crate::model::CharLengthSemantics) -> Self {
            self.char_length_semantics = Some(input);
            self
        }
        /// <p>Specifies whether the length of a character column is in
        /// bytes or in characters. To indicate that the character column
        /// length is in characters, set this attribute to <code>CHAR</code>. Otherwise,
        /// the character column length is in bytes.</p>
        /// <p>Example: <code>charLengthSemantics=CHAR;</code>
        /// </p>
        pub fn set_char_length_semantics(
            mut self,
            input: std::option::Option<crate::model::CharLengthSemantics>,
        ) -> Self {
            self.char_length_semantics = input;
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>When set to <code>true</code>, this attribute specifies a parallel load
        /// when <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute
        /// also only applies when you use the DMS parallel load
        /// feature.  Note that the target table cannot have any constraints or indexes.</p>
        pub fn direct_path_parallel_load(mut self, input: bool) -> Self {
            self.direct_path_parallel_load = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, this attribute specifies a parallel load
        /// when <code>useDirectPathFullLoad</code> is set to <code>Y</code>. This attribute
        /// also only applies when you use the DMS parallel load
        /// feature.  Note that the target table cannot have any constraints or indexes.</p>
        pub fn set_direct_path_parallel_load(mut self, input: std::option::Option<bool>) -> Self {
            self.direct_path_parallel_load = input;
            self
        }
        /// <p>When set to <code>true</code>, this attribute causes a task to fail if the
        /// actual size of an LOB column is greater than the specified
        /// <code>LobMaxSize</code>.</p>
        /// <p>If a task is set to limited LOB mode and this option is set to
        /// <code>true</code>, the task fails instead of truncating the LOB data.</p>
        pub fn fail_tasks_on_lob_truncation(mut self, input: bool) -> Self {
            self.fail_tasks_on_lob_truncation = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, this attribute causes a task to fail if the
        /// actual size of an LOB column is greater than the specified
        /// <code>LobMaxSize</code>.</p>
        /// <p>If a task is set to limited LOB mode and this option is set to
        /// <code>true</code>, the task fails instead of truncating the LOB data.</p>
        pub fn set_fail_tasks_on_lob_truncation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.fail_tasks_on_lob_truncation = input;
            self
        }
        /// <p>Specifies the number scale. You can select a scale up to 38,
        /// or you can select FLOAT. By default, the NUMBER data type
        /// is converted to precision 38, scale 10.</p>
        /// <p>Example: <code>numberDataTypeScale=12</code>
        /// </p>
        pub fn number_datatype_scale(mut self, input: i32) -> Self {
            self.number_datatype_scale = Some(input);
            self
        }
        /// <p>Specifies the number scale. You can select a scale up to 38,
        /// or you can select FLOAT. By default, the NUMBER data type
        /// is converted to precision 38, scale 10.</p>
        /// <p>Example: <code>numberDataTypeScale=12</code>
        /// </p>
        pub fn set_number_datatype_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.number_datatype_scale = input;
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>Endpoint TCP port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Endpoint TCP port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>When set to <code>true</code>, this attribute supports tablespace
        /// replication.</p>
        pub fn read_table_space_name(mut self, input: bool) -> Self {
            self.read_table_space_name = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, this attribute supports tablespace
        /// replication.</p>
        pub fn set_read_table_space_name(mut self, input: std::option::Option<bool>) -> Self {
            self.read_table_space_name = input;
            self
        }
        /// <p>Specifies the number of seconds that the system waits
        /// before resending a query.</p>
        /// <p>Example: <code>retryInterval=6;</code>
        /// </p>
        pub fn retry_interval(mut self, input: i32) -> Self {
            self.retry_interval = Some(input);
            self
        }
        /// <p>Specifies the number of seconds that the system waits
        /// before resending a query.</p>
        /// <p>Example: <code>retryInterval=6;</code>
        /// </p>
        pub fn set_retry_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_interval = input;
            self
        }
        /// <p>For an Oracle source endpoint, the transparent data encryption (TDE) password required
        /// by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader. It is also the
        /// <code>
        /// <i>TDE_Password</i>
        /// </code> part of the comma-separated value you
        /// set to the <code>Password</code> request parameter when you create the endpoint. The
        /// <code>SecurityDbEncryptian</code> setting is related to this
        /// <code>SecurityDbEncryptionName</code> setting. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
        /// </a> in the <i>Database Migration Service User Guide</i>. </p>
        pub fn security_db_encryption(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_db_encryption = Some(input.into());
            self
        }
        /// <p>For an Oracle source endpoint, the transparent data encryption (TDE) password required
        /// by AWM DMS to access Oracle redo logs encrypted by TDE using Binary Reader. It is also the
        /// <code>
        /// <i>TDE_Password</i>
        /// </code> part of the comma-separated value you
        /// set to the <code>Password</code> request parameter when you create the endpoint. The
        /// <code>SecurityDbEncryptian</code> setting is related to this
        /// <code>SecurityDbEncryptionName</code> setting. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
        /// </a> in the <i>Database Migration Service User Guide</i>. </p>
        pub fn set_security_db_encryption(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_db_encryption = input;
            self
        }
        /// <p>For an Oracle source endpoint, the name of a key used for the transparent data
        /// encryption (TDE) of the columns and tablespaces in an Oracle source database that is
        /// encrypted using TDE. The key value is the value of the <code>SecurityDbEncryption</code>
        /// setting. For more information on setting the key name value of
        /// <code>SecurityDbEncryptionName</code>, see the information and example for setting the
        /// <code>securityDbEncryptionName</code> extra connection attribute in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
        /// </a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        pub fn security_db_encryption_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.security_db_encryption_name = Some(input.into());
            self
        }
        /// <p>For an Oracle source endpoint, the name of a key used for the transparent data
        /// encryption (TDE) of the columns and tablespaces in an Oracle source database that is
        /// encrypted using TDE. The key value is the value of the <code>SecurityDbEncryption</code>
        /// setting. For more information on setting the key name value of
        /// <code>SecurityDbEncryptionName</code>, see the information and example for setting the
        /// <code>securityDbEncryptionName</code> extra connection attribute in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption"> Supported encryption methods for using Oracle as a source for DMS
        /// </a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        pub fn set_security_db_encryption_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_db_encryption_name = input;
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Use this attribute to convert <code>SDO_GEOMETRY</code> to
        /// <code>GEOJSON</code> format. By default, DMS calls the
        /// <code>SDO2GEOJSON</code> custom function if present and accessible.
        /// Or you can create your own custom function that mimics the operation of
        /// <code>SDOGEOJSON</code> and set
        /// <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead. </p>
        pub fn spatial_data_option_to_geo_json_function_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.spatial_data_option_to_geo_json_function_name = Some(input.into());
            self
        }
        /// <p>Use this attribute to convert <code>SDO_GEOMETRY</code> to
        /// <code>GEOJSON</code> format. By default, DMS calls the
        /// <code>SDO2GEOJSON</code> custom function if present and accessible.
        /// Or you can create your own custom function that mimics the operation of
        /// <code>SDOGEOJSON</code> and set
        /// <code>SpatialDataOptionToGeoJsonFunctionName</code> to call it instead. </p>
        pub fn set_spatial_data_option_to_geo_json_function_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spatial_data_option_to_geo_json_function_name = input;
            self
        }
        /// <p>Use this attribute to specify a time in minutes for the delay in standby sync. If the
        /// source is an Oracle Active Data Guard standby database, use this attribute to specify the
        /// time lag between primary and standby databases.</p>
        /// <p>In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby
        /// instance as a source for replicating ongoing changes. Doing this eliminates the need to connect
        /// to an active database that might be in production.</p>
        pub fn standby_delay_time(mut self, input: i32) -> Self {
            self.standby_delay_time = Some(input);
            self
        }
        /// <p>Use this attribute to specify a time in minutes for the delay in standby sync. If the
        /// source is an Oracle Active Data Guard standby database, use this attribute to specify the
        /// time lag between primary and standby databases.</p>
        /// <p>In DMS, you can create an Oracle CDC task that uses an Active Data Guard standby
        /// instance as a source for replicating ongoing changes. Doing this eliminates the need to connect
        /// to an active database that might be in production.</p>
        pub fn set_standby_delay_time(mut self, input: std::option::Option<i32>) -> Self {
            self.standby_delay_time = input;
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>Set this attribute to Y to capture change data using the Binary Reader utility. Set
        /// <code>UseLogminerReader</code> to N to set this attribute to Y. To use Binary Reader
        /// with Amazon RDS for Oracle as the source, you set additional attributes. For more information
        /// about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for
        /// CDC</a>.</p>
        pub fn use_b_file(mut self, input: bool) -> Self {
            self.use_b_file = Some(input);
            self
        }
        /// <p>Set this attribute to Y to capture change data using the Binary Reader utility. Set
        /// <code>UseLogminerReader</code> to N to set this attribute to Y. To use Binary Reader
        /// with Amazon RDS for Oracle as the source, you set additional attributes. For more information
        /// about using this setting with Oracle Automatic Storage Management (ASM), see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for
        /// CDC</a>.</p>
        pub fn set_use_b_file(mut self, input: std::option::Option<bool>) -> Self {
            self.use_b_file = input;
            self
        }
        /// <p>Set this attribute to Y to have DMS use a direct path full load.
        /// Specify this value to use the direct path protocol in the Oracle Call Interface (OCI).
        /// By using this OCI protocol, you can bulk-load Oracle target tables during a full load.</p>
        pub fn use_direct_path_full_load(mut self, input: bool) -> Self {
            self.use_direct_path_full_load = Some(input);
            self
        }
        /// <p>Set this attribute to Y to have DMS use a direct path full load.
        /// Specify this value to use the direct path protocol in the Oracle Call Interface (OCI).
        /// By using this OCI protocol, you can bulk-load Oracle target tables during a full load.</p>
        pub fn set_use_direct_path_full_load(mut self, input: std::option::Option<bool>) -> Self {
            self.use_direct_path_full_load = input;
            self
        }
        /// <p>Set this attribute to Y to capture change data using the Oracle LogMiner utility (the
        /// default). Set this attribute to N if you want to access the redo logs as a binary file.
        /// When you set <code>UseLogminerReader</code> to N, also set <code>UseBfile</code> to Y. For
        /// more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for CDC</a> in
        /// the <i>DMS User Guide</i>.</p>
        pub fn use_logminer_reader(mut self, input: bool) -> Self {
            self.use_logminer_reader = Some(input);
            self
        }
        /// <p>Set this attribute to Y to capture change data using the Oracle LogMiner utility (the
        /// default). Set this attribute to N if you want to access the redo logs as a binary file.
        /// When you set <code>UseLogminerReader</code> to N, also set <code>UseBfile</code> to Y. For
        /// more information on this setting and using Oracle ASM, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC"> Using Oracle LogMiner or DMS Binary Reader for CDC</a> in
        /// the <i>DMS User Guide</i>.</p>
        pub fn set_use_logminer_reader(mut self, input: std::option::Option<bool>) -> Self {
            self.use_logminer_reader = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the Oracle endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the Oracle endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Oracle endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Oracle endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN
        /// of the IAM role that specifies DMS as the trusted entity and grants the required
        /// permissions to access the <code>SecretsManagerOracleAsmSecret</code>. This
        /// <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to
        /// the Oracle ASM of the endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerOracleAsmSecretId</code>. Or you can
        /// specify clear-text values for <code>AsmUserName</code>, <code>AsmPassword</code>, and
        /// <code>AsmServerName</code>. You can't specify both. For more information on
        /// creating this <code>SecretsManagerOracleAsmSecret</code> and the
        /// <code>SecretsManagerOracleAsmAccessRoleArn</code> and
        /// <code>SecretsManagerOracleAsmSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_oracle_asm_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_oracle_asm_access_role_arn = Some(input.into());
            self
        }
        /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN
        /// of the IAM role that specifies DMS as the trusted entity and grants the required
        /// permissions to access the <code>SecretsManagerOracleAsmSecret</code>. This
        /// <code>SecretsManagerOracleAsmSecret</code> has the secret value that allows access to
        /// the Oracle ASM of the endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerOracleAsmSecretId</code>. Or you can
        /// specify clear-text values for <code>AsmUserName</code>, <code>AsmPassword</code>, and
        /// <code>AsmServerName</code>. You can't specify both. For more information on
        /// creating this <code>SecretsManagerOracleAsmSecret</code> and the
        /// <code>SecretsManagerOracleAsmAccessRoleArn</code> and
        /// <code>SecretsManagerOracleAsmSecretId</code> required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_oracle_asm_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_oracle_asm_access_role_arn = input;
            self
        }
        /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN, partial ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code>
        /// that contains the Oracle ASM connection details for the Oracle endpoint.</p>
        pub fn secrets_manager_oracle_asm_secret_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_oracle_asm_secret_id = Some(input.into());
            self
        }
        /// <p>Required only if your Oracle endpoint uses Advanced Storage Manager (ASM). The full ARN, partial ARN, or friendly name of the <code>SecretsManagerOracleAsmSecret</code>
        /// that contains the Oracle ASM connection details for the Oracle endpoint.</p>
        pub fn set_secrets_manager_oracle_asm_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_oracle_asm_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OracleSettings`](crate::model::OracleSettings)
        pub fn build(self) -> crate::model::OracleSettings {
            crate::model::OracleSettings {
                add_supplemental_logging: self.add_supplemental_logging,
                archived_log_dest_id: self.archived_log_dest_id,
                additional_archived_log_dest_id: self.additional_archived_log_dest_id,
                extra_archived_log_dest_ids: self.extra_archived_log_dest_ids,
                allow_select_nested_tables: self.allow_select_nested_tables,
                parallel_asm_read_threads: self.parallel_asm_read_threads,
                read_ahead_blocks: self.read_ahead_blocks,
                access_alternate_directly: self.access_alternate_directly,
                use_alternate_folder_for_online: self.use_alternate_folder_for_online,
                oracle_path_prefix: self.oracle_path_prefix,
                use_path_prefix: self.use_path_prefix,
                replace_path_prefix: self.replace_path_prefix,
                enable_homogenous_tablespace: self.enable_homogenous_tablespace,
                direct_path_no_log: self.direct_path_no_log,
                archived_logs_only: self.archived_logs_only,
                asm_password: self.asm_password,
                asm_server: self.asm_server,
                asm_user: self.asm_user,
                char_length_semantics: self.char_length_semantics,
                database_name: self.database_name,
                direct_path_parallel_load: self.direct_path_parallel_load,
                fail_tasks_on_lob_truncation: self.fail_tasks_on_lob_truncation,
                number_datatype_scale: self.number_datatype_scale,
                password: self.password,
                port: self.port,
                read_table_space_name: self.read_table_space_name,
                retry_interval: self.retry_interval,
                security_db_encryption: self.security_db_encryption,
                security_db_encryption_name: self.security_db_encryption_name,
                server_name: self.server_name,
                spatial_data_option_to_geo_json_function_name: self
                    .spatial_data_option_to_geo_json_function_name,
                standby_delay_time: self.standby_delay_time,
                username: self.username,
                use_b_file: self.use_b_file,
                use_direct_path_full_load: self.use_direct_path_full_load,
                use_logminer_reader: self.use_logminer_reader,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
                secrets_manager_oracle_asm_access_role_arn: self
                    .secrets_manager_oracle_asm_access_role_arn,
                secrets_manager_oracle_asm_secret_id: self.secrets_manager_oracle_asm_secret_id,
            }
        }
    }
}
impl OracleSettings {
    /// Creates a new builder-style object to manufacture [`OracleSettings`](crate::model::OracleSettings)
    pub fn builder() -> crate::model::oracle_settings::Builder {
        crate::model::oracle_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CharLengthSemantics {
    #[allow(missing_docs)] // documentation missing in model
    Byte,
    #[allow(missing_docs)] // documentation missing in model
    Char,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CharLengthSemantics {
    fn from(s: &str) -> Self {
        match s {
            "byte" => CharLengthSemantics::Byte,
            "char" => CharLengthSemantics::Char,
            "default" => CharLengthSemantics::Default,
            other => CharLengthSemantics::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CharLengthSemantics {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CharLengthSemantics::from(s))
    }
}
impl CharLengthSemantics {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CharLengthSemantics::Byte => "byte",
            CharLengthSemantics::Char => "char",
            CharLengthSemantics::Default => "default",
            CharLengthSemantics::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["byte", "char", "default"]
    }
}
impl AsRef<str> for CharLengthSemantics {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines a MySQL endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MySqlSettings {
    /// <p>Specifies a script to run immediately after DMS
    /// connects to the endpoint. The migration task continues
    /// running regardless if the SQL statement succeeds or fails.</p>
    /// <p>For this parameter, provide the code of the script itself, not the name of a file
    /// containing the script.</p>
    pub after_connect_script: std::option::Option<std::string::String>,
    /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
    /// that is hosted as part of an Always On availability group cluster.  If you need DMS to poll
    /// all the nodes in the Always On cluster for transaction backups, set this attribute to
    /// <code>false</code>.</p>
    pub clean_source_metadata_on_mismatch: std::option::Option<bool>,
    /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly
    /// specify the database using the <code>DatabaseName</code> request parameter on either the
    /// <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying
    /// <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the
    /// task tables to this single database. For MySQL endpoints, you specify the database only when
    /// you specify the schema in the table-mapping rules of the DMS task.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Specifies how often to check the binary log for new
    /// changes/events when the database is idle. The default is five seconds.</p>
    /// <p>Example: <code>eventsPollInterval=5;</code>
    /// </p>
    /// <p>In the example, DMS checks for changes in the binary
    /// logs every five seconds.</p>
    pub events_poll_interval: std::option::Option<i32>,
    /// <p>Specifies where to migrate source tables on the target, either
    /// to a single database or multiple databases.</p>
    /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
    /// </p>
    pub target_db_type: std::option::Option<crate::model::TargetDbType>,
    /// <p>Specifies the maximum size (in KB) of any .csv file used to
    /// transfer data to a MySQL-compatible database.</p>
    /// <p>Example: <code>maxFileSize=512</code>
    /// </p>
    pub max_file_size: std::option::Option<i32>,
    /// <p>Improves performance when loading data into the MySQL-compatible target database.
    /// Specifies how many threads to use to load the data into the MySQL-compatible target
    /// database. Setting a large number of threads can have an adverse effect on database
    /// performance, because a separate connection is required for each thread. The default is one.</p>
    /// <p>Example: <code>parallelLoadThreads=1</code>
    /// </p>
    pub parallel_load_threads: std::option::Option<i32>,
    /// <p>Endpoint connection password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>Endpoint TCP port.</p>
    pub port: std::option::Option<i32>,
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Specifies the time zone for the source MySQL database.</p>
    /// <p>Example: <code>serverTimezone=US/Pacific;</code>
    /// </p>
    /// <p>Note: Do not enclose time zones in single quotes.</p>
    pub server_timezone: std::option::Option<std::string::String>,
    /// <p>Endpoint connection user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the MySQL endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl MySqlSettings {
    /// <p>Specifies a script to run immediately after DMS
    /// connects to the endpoint. The migration task continues
    /// running regardless if the SQL statement succeeds or fails.</p>
    /// <p>For this parameter, provide the code of the script itself, not the name of a file
    /// containing the script.</p>
    pub fn after_connect_script(&self) -> std::option::Option<&str> {
        self.after_connect_script.as_deref()
    }
    /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
    /// that is hosted as part of an Always On availability group cluster.  If you need DMS to poll
    /// all the nodes in the Always On cluster for transaction backups, set this attribute to
    /// <code>false</code>.</p>
    pub fn clean_source_metadata_on_mismatch(&self) -> std::option::Option<bool> {
        self.clean_source_metadata_on_mismatch
    }
    /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly
    /// specify the database using the <code>DatabaseName</code> request parameter on either the
    /// <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying
    /// <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the
    /// task tables to this single database. For MySQL endpoints, you specify the database only when
    /// you specify the schema in the table-mapping rules of the DMS task.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Specifies how often to check the binary log for new
    /// changes/events when the database is idle. The default is five seconds.</p>
    /// <p>Example: <code>eventsPollInterval=5;</code>
    /// </p>
    /// <p>In the example, DMS checks for changes in the binary
    /// logs every five seconds.</p>
    pub fn events_poll_interval(&self) -> std::option::Option<i32> {
        self.events_poll_interval
    }
    /// <p>Specifies where to migrate source tables on the target, either
    /// to a single database or multiple databases.</p>
    /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
    /// </p>
    pub fn target_db_type(&self) -> std::option::Option<&crate::model::TargetDbType> {
        self.target_db_type.as_ref()
    }
    /// <p>Specifies the maximum size (in KB) of any .csv file used to
    /// transfer data to a MySQL-compatible database.</p>
    /// <p>Example: <code>maxFileSize=512</code>
    /// </p>
    pub fn max_file_size(&self) -> std::option::Option<i32> {
        self.max_file_size
    }
    /// <p>Improves performance when loading data into the MySQL-compatible target database.
    /// Specifies how many threads to use to load the data into the MySQL-compatible target
    /// database. Setting a large number of threads can have an adverse effect on database
    /// performance, because a separate connection is required for each thread. The default is one.</p>
    /// <p>Example: <code>parallelLoadThreads=1</code>
    /// </p>
    pub fn parallel_load_threads(&self) -> std::option::Option<i32> {
        self.parallel_load_threads
    }
    /// <p>Endpoint connection password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>Endpoint TCP port.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Specifies the time zone for the source MySQL database.</p>
    /// <p>Example: <code>serverTimezone=US/Pacific;</code>
    /// </p>
    /// <p>Note: Do not enclose time zones in single quotes.</p>
    pub fn server_timezone(&self) -> std::option::Option<&str> {
        self.server_timezone.as_deref()
    }
    /// <p>Endpoint connection user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the MySQL endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for MySqlSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MySqlSettings");
        formatter.field("after_connect_script", &self.after_connect_script);
        formatter.field(
            "clean_source_metadata_on_mismatch",
            &self.clean_source_metadata_on_mismatch,
        );
        formatter.field("database_name", &self.database_name);
        formatter.field("events_poll_interval", &self.events_poll_interval);
        formatter.field("target_db_type", &self.target_db_type);
        formatter.field("max_file_size", &self.max_file_size);
        formatter.field("parallel_load_threads", &self.parallel_load_threads);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field("server_name", &self.server_name);
        formatter.field("server_timezone", &self.server_timezone);
        formatter.field("username", &self.username);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`MySqlSettings`](crate::model::MySqlSettings)
pub mod my_sql_settings {
    /// A builder for [`MySqlSettings`](crate::model::MySqlSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) after_connect_script: std::option::Option<std::string::String>,
        pub(crate) clean_source_metadata_on_mismatch: std::option::Option<bool>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) events_poll_interval: std::option::Option<i32>,
        pub(crate) target_db_type: std::option::Option<crate::model::TargetDbType>,
        pub(crate) max_file_size: std::option::Option<i32>,
        pub(crate) parallel_load_threads: std::option::Option<i32>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) server_timezone: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies a script to run immediately after DMS
        /// connects to the endpoint. The migration task continues
        /// running regardless if the SQL statement succeeds or fails.</p>
        /// <p>For this parameter, provide the code of the script itself, not the name of a file
        /// containing the script.</p>
        pub fn after_connect_script(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_connect_script = Some(input.into());
            self
        }
        /// <p>Specifies a script to run immediately after DMS
        /// connects to the endpoint. The migration task continues
        /// running regardless if the SQL statement succeeds or fails.</p>
        /// <p>For this parameter, provide the code of the script itself, not the name of a file
        /// containing the script.</p>
        pub fn set_after_connect_script(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_connect_script = input;
            self
        }
        /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
        /// that is hosted as part of an Always On availability group cluster.  If you need DMS to poll
        /// all the nodes in the Always On cluster for transaction backups, set this attribute to
        /// <code>false</code>.</p>
        pub fn clean_source_metadata_on_mismatch(mut self, input: bool) -> Self {
            self.clean_source_metadata_on_mismatch = Some(input);
            self
        }
        /// <p>Adjusts the behavior of DMS when migrating from an SQL Server source database
        /// that is hosted as part of an Always On availability group cluster.  If you need DMS to poll
        /// all the nodes in the Always On cluster for transaction backups, set this attribute to
        /// <code>false</code>.</p>
        pub fn set_clean_source_metadata_on_mismatch(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.clean_source_metadata_on_mismatch = input;
            self
        }
        /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly
        /// specify the database using the <code>DatabaseName</code> request parameter on either the
        /// <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying
        /// <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the
        /// task tables to this single database. For MySQL endpoints, you specify the database only when
        /// you specify the schema in the table-mapping rules of the DMS task.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Database name for the endpoint. For a MySQL source or target endpoint, don't explicitly
        /// specify the database using the <code>DatabaseName</code> request parameter on either the
        /// <code>CreateEndpoint</code> or <code>ModifyEndpoint</code> API call. Specifying
        /// <code>DatabaseName</code> when you create or modify a MySQL endpoint replicates all the
        /// task tables to this single database. For MySQL endpoints, you specify the database only when
        /// you specify the schema in the table-mapping rules of the DMS task.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Specifies how often to check the binary log for new
        /// changes/events when the database is idle. The default is five seconds.</p>
        /// <p>Example: <code>eventsPollInterval=5;</code>
        /// </p>
        /// <p>In the example, DMS checks for changes in the binary
        /// logs every five seconds.</p>
        pub fn events_poll_interval(mut self, input: i32) -> Self {
            self.events_poll_interval = Some(input);
            self
        }
        /// <p>Specifies how often to check the binary log for new
        /// changes/events when the database is idle. The default is five seconds.</p>
        /// <p>Example: <code>eventsPollInterval=5;</code>
        /// </p>
        /// <p>In the example, DMS checks for changes in the binary
        /// logs every five seconds.</p>
        pub fn set_events_poll_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.events_poll_interval = input;
            self
        }
        /// <p>Specifies where to migrate source tables on the target, either
        /// to a single database or multiple databases.</p>
        /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
        /// </p>
        pub fn target_db_type(mut self, input: crate::model::TargetDbType) -> Self {
            self.target_db_type = Some(input);
            self
        }
        /// <p>Specifies where to migrate source tables on the target, either
        /// to a single database or multiple databases.</p>
        /// <p>Example: <code>targetDbType=MULTIPLE_DATABASES</code>
        /// </p>
        pub fn set_target_db_type(
            mut self,
            input: std::option::Option<crate::model::TargetDbType>,
        ) -> Self {
            self.target_db_type = input;
            self
        }
        /// <p>Specifies the maximum size (in KB) of any .csv file used to
        /// transfer data to a MySQL-compatible database.</p>
        /// <p>Example: <code>maxFileSize=512</code>
        /// </p>
        pub fn max_file_size(mut self, input: i32) -> Self {
            self.max_file_size = Some(input);
            self
        }
        /// <p>Specifies the maximum size (in KB) of any .csv file used to
        /// transfer data to a MySQL-compatible database.</p>
        /// <p>Example: <code>maxFileSize=512</code>
        /// </p>
        pub fn set_max_file_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_file_size = input;
            self
        }
        /// <p>Improves performance when loading data into the MySQL-compatible target database.
        /// Specifies how many threads to use to load the data into the MySQL-compatible target
        /// database. Setting a large number of threads can have an adverse effect on database
        /// performance, because a separate connection is required for each thread. The default is one.</p>
        /// <p>Example: <code>parallelLoadThreads=1</code>
        /// </p>
        pub fn parallel_load_threads(mut self, input: i32) -> Self {
            self.parallel_load_threads = Some(input);
            self
        }
        /// <p>Improves performance when loading data into the MySQL-compatible target database.
        /// Specifies how many threads to use to load the data into the MySQL-compatible target
        /// database. Setting a large number of threads can have an adverse effect on database
        /// performance, because a separate connection is required for each thread. The default is one.</p>
        /// <p>Example: <code>parallelLoadThreads=1</code>
        /// </p>
        pub fn set_parallel_load_threads(mut self, input: std::option::Option<i32>) -> Self {
            self.parallel_load_threads = input;
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>Endpoint TCP port.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Endpoint TCP port.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Specifies the time zone for the source MySQL database.</p>
        /// <p>Example: <code>serverTimezone=US/Pacific;</code>
        /// </p>
        /// <p>Note: Do not enclose time zones in single quotes.</p>
        pub fn server_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_timezone = Some(input.into());
            self
        }
        /// <p>Specifies the time zone for the source MySQL database.</p>
        /// <p>Example: <code>serverTimezone=US/Pacific;</code>
        /// </p>
        /// <p>Note: Do not enclose time zones in single quotes.</p>
        pub fn set_server_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_timezone = input;
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the MySQL endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the MySQL endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MySQL endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MySqlSettings`](crate::model::MySqlSettings)
        pub fn build(self) -> crate::model::MySqlSettings {
            crate::model::MySqlSettings {
                after_connect_script: self.after_connect_script,
                clean_source_metadata_on_mismatch: self.clean_source_metadata_on_mismatch,
                database_name: self.database_name,
                events_poll_interval: self.events_poll_interval,
                target_db_type: self.target_db_type,
                max_file_size: self.max_file_size,
                parallel_load_threads: self.parallel_load_threads,
                password: self.password,
                port: self.port,
                server_name: self.server_name,
                server_timezone: self.server_timezone,
                username: self.username,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl MySqlSettings {
    /// Creates a new builder-style object to manufacture [`MySqlSettings`](crate::model::MySqlSettings)
    pub fn builder() -> crate::model::my_sql_settings::Builder {
        crate::model::my_sql_settings::Builder::default()
    }
}

/// <p>Provides information that defines a PostgreSQL endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PostgreSqlSettings {
    /// <p>For use with change data capture (CDC) only, this attribute
    /// has DMS bypass foreign keys and user triggers to
    /// reduce the time it takes to bulk load data.</p>
    /// <p>Example: <code>afterConnectScript=SET
    /// session_replication_role='replica'</code>
    /// </p>
    pub after_connect_script: std::option::Option<std::string::String>,
    /// <p>To capture DDL events, DMS creates various artifacts in
    /// the PostgreSQL database when the task starts. You can later
    /// remove these artifacts.</p>
    /// <p>If this value is set to <code>N</code>, you don't have to create tables or
    /// triggers on the source database.</p>
    pub capture_ddls: std::option::Option<bool>,
    /// <p>Specifies the maximum size (in KB) of any .csv file used to
    /// transfer data to PostgreSQL.</p>
    /// <p>Example: <code>maxFileSize=512</code>
    /// </p>
    pub max_file_size: std::option::Option<i32>,
    /// <p>Database name for the endpoint.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The schema in which the operational DDL database artifacts
    /// are created.</p>
    /// <p>Example: <code>ddlArtifactsSchema=xyzddlschema;</code>
    /// </p>
    pub ddl_artifacts_schema: std::option::Option<std::string::String>,
    /// <p>Sets the client statement timeout for the PostgreSQL
    /// instance, in seconds. The default value is 60 seconds.</p>
    /// <p>Example: <code>executeTimeout=100;</code>
    /// </p>
    pub execute_timeout: std::option::Option<i32>,
    /// <p>When set to <code>true</code>, this value causes a task to fail if the
    /// actual size of a LOB column is greater than the specified
    /// <code>LobMaxSize</code>.</p>
    /// <p>If task is set to Limited LOB mode and this option is set to
    /// true, the task fails instead of truncating the LOB data.</p>
    pub fail_tasks_on_lob_truncation: std::option::Option<bool>,
    /// <p>The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this,
    /// it prevents idle logical replication slots from holding onto old WAL logs, which can result in
    /// storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving
    /// and prevents storage full scenarios.</p>
    pub heartbeat_enable: std::option::Option<bool>,
    /// <p>Sets the schema in which the heartbeat artifacts are created.</p>
    pub heartbeat_schema: std::option::Option<std::string::String>,
    /// <p>Sets the WAL heartbeat frequency (in minutes).</p>
    pub heartbeat_frequency: std::option::Option<i32>,
    /// <p>Endpoint connection password.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>Endpoint TCP port. The default is 5432.</p>
    pub port: std::option::Option<i32>,
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>Endpoint connection user name.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>Sets the name of a previously created logical replication slot
    /// for a change data capture (CDC) load of the PostgreSQL source instance. </p>
    /// <p>When used with the <code>CdcStartPosition</code>
    /// request parameter for the DMS API , this attribute also makes it possible to use native CDC
    /// start points. DMS verifies that the specified logical
    /// replication slot exists before starting the CDC load task. It
    /// also verifies that the task was created with a valid setting of
    /// <code>CdcStartPosition</code>. If the specified slot
    /// doesn't exist or the task doesn't have a valid
    /// <code>CdcStartPosition</code> setting, DMS raises an
    /// error.</p>
    /// <p>For more information about setting the <code>CdcStartPosition</code> request parameter,
    /// see <a href="dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native">Determining a CDC native start point</a> in the <i>Database Migration Service User
    /// Guide</i>. For more information about using <code>CdcStartPosition</code>, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">CreateReplicationTask</a>, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">StartReplicationTask</a>, and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">ModifyReplicationTask</a>.</p>
    pub slot_name: std::option::Option<std::string::String>,
    /// <p>Specifies the plugin to use to create a replication slot.</p>
    pub plugin_name: std::option::Option<crate::model::PluginNameValue>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the PostgreSQL endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the PostgreSQL endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl PostgreSqlSettings {
    /// <p>For use with change data capture (CDC) only, this attribute
    /// has DMS bypass foreign keys and user triggers to
    /// reduce the time it takes to bulk load data.</p>
    /// <p>Example: <code>afterConnectScript=SET
    /// session_replication_role='replica'</code>
    /// </p>
    pub fn after_connect_script(&self) -> std::option::Option<&str> {
        self.after_connect_script.as_deref()
    }
    /// <p>To capture DDL events, DMS creates various artifacts in
    /// the PostgreSQL database when the task starts. You can later
    /// remove these artifacts.</p>
    /// <p>If this value is set to <code>N</code>, you don't have to create tables or
    /// triggers on the source database.</p>
    pub fn capture_ddls(&self) -> std::option::Option<bool> {
        self.capture_ddls
    }
    /// <p>Specifies the maximum size (in KB) of any .csv file used to
    /// transfer data to PostgreSQL.</p>
    /// <p>Example: <code>maxFileSize=512</code>
    /// </p>
    pub fn max_file_size(&self) -> std::option::Option<i32> {
        self.max_file_size
    }
    /// <p>Database name for the endpoint.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The schema in which the operational DDL database artifacts
    /// are created.</p>
    /// <p>Example: <code>ddlArtifactsSchema=xyzddlschema;</code>
    /// </p>
    pub fn ddl_artifacts_schema(&self) -> std::option::Option<&str> {
        self.ddl_artifacts_schema.as_deref()
    }
    /// <p>Sets the client statement timeout for the PostgreSQL
    /// instance, in seconds. The default value is 60 seconds.</p>
    /// <p>Example: <code>executeTimeout=100;</code>
    /// </p>
    pub fn execute_timeout(&self) -> std::option::Option<i32> {
        self.execute_timeout
    }
    /// <p>When set to <code>true</code>, this value causes a task to fail if the
    /// actual size of a LOB column is greater than the specified
    /// <code>LobMaxSize</code>.</p>
    /// <p>If task is set to Limited LOB mode and this option is set to
    /// true, the task fails instead of truncating the LOB data.</p>
    pub fn fail_tasks_on_lob_truncation(&self) -> std::option::Option<bool> {
        self.fail_tasks_on_lob_truncation
    }
    /// <p>The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this,
    /// it prevents idle logical replication slots from holding onto old WAL logs, which can result in
    /// storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving
    /// and prevents storage full scenarios.</p>
    pub fn heartbeat_enable(&self) -> std::option::Option<bool> {
        self.heartbeat_enable
    }
    /// <p>Sets the schema in which the heartbeat artifacts are created.</p>
    pub fn heartbeat_schema(&self) -> std::option::Option<&str> {
        self.heartbeat_schema.as_deref()
    }
    /// <p>Sets the WAL heartbeat frequency (in minutes).</p>
    pub fn heartbeat_frequency(&self) -> std::option::Option<i32> {
        self.heartbeat_frequency
    }
    /// <p>Endpoint connection password.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>Endpoint TCP port. The default is 5432.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Fully qualified domain name of the endpoint.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>Endpoint connection user name.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>Sets the name of a previously created logical replication slot
    /// for a change data capture (CDC) load of the PostgreSQL source instance. </p>
    /// <p>When used with the <code>CdcStartPosition</code>
    /// request parameter for the DMS API , this attribute also makes it possible to use native CDC
    /// start points. DMS verifies that the specified logical
    /// replication slot exists before starting the CDC load task. It
    /// also verifies that the task was created with a valid setting of
    /// <code>CdcStartPosition</code>. If the specified slot
    /// doesn't exist or the task doesn't have a valid
    /// <code>CdcStartPosition</code> setting, DMS raises an
    /// error.</p>
    /// <p>For more information about setting the <code>CdcStartPosition</code> request parameter,
    /// see <a href="dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native">Determining a CDC native start point</a> in the <i>Database Migration Service User
    /// Guide</i>. For more information about using <code>CdcStartPosition</code>, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">CreateReplicationTask</a>, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">StartReplicationTask</a>, and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">ModifyReplicationTask</a>.</p>
    pub fn slot_name(&self) -> std::option::Option<&str> {
        self.slot_name.as_deref()
    }
    /// <p>Specifies the plugin to use to create a replication slot.</p>
    pub fn plugin_name(&self) -> std::option::Option<&crate::model::PluginNameValue> {
        self.plugin_name.as_ref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
    /// secret that allows access to the PostgreSQL endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the PostgreSQL endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for PostgreSqlSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PostgreSqlSettings");
        formatter.field("after_connect_script", &self.after_connect_script);
        formatter.field("capture_ddls", &self.capture_ddls);
        formatter.field("max_file_size", &self.max_file_size);
        formatter.field("database_name", &self.database_name);
        formatter.field("ddl_artifacts_schema", &self.ddl_artifacts_schema);
        formatter.field("execute_timeout", &self.execute_timeout);
        formatter.field(
            "fail_tasks_on_lob_truncation",
            &self.fail_tasks_on_lob_truncation,
        );
        formatter.field("heartbeat_enable", &self.heartbeat_enable);
        formatter.field("heartbeat_schema", &self.heartbeat_schema);
        formatter.field("heartbeat_frequency", &self.heartbeat_frequency);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field("server_name", &self.server_name);
        formatter.field("username", &self.username);
        formatter.field("slot_name", &self.slot_name);
        formatter.field("plugin_name", &self.plugin_name);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`PostgreSqlSettings`](crate::model::PostgreSqlSettings)
pub mod postgre_sql_settings {
    /// A builder for [`PostgreSqlSettings`](crate::model::PostgreSqlSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) after_connect_script: std::option::Option<std::string::String>,
        pub(crate) capture_ddls: std::option::Option<bool>,
        pub(crate) max_file_size: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) ddl_artifacts_schema: std::option::Option<std::string::String>,
        pub(crate) execute_timeout: std::option::Option<i32>,
        pub(crate) fail_tasks_on_lob_truncation: std::option::Option<bool>,
        pub(crate) heartbeat_enable: std::option::Option<bool>,
        pub(crate) heartbeat_schema: std::option::Option<std::string::String>,
        pub(crate) heartbeat_frequency: std::option::Option<i32>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) slot_name: std::option::Option<std::string::String>,
        pub(crate) plugin_name: std::option::Option<crate::model::PluginNameValue>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>For use with change data capture (CDC) only, this attribute
        /// has DMS bypass foreign keys and user triggers to
        /// reduce the time it takes to bulk load data.</p>
        /// <p>Example: <code>afterConnectScript=SET
        /// session_replication_role='replica'</code>
        /// </p>
        pub fn after_connect_script(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_connect_script = Some(input.into());
            self
        }
        /// <p>For use with change data capture (CDC) only, this attribute
        /// has DMS bypass foreign keys and user triggers to
        /// reduce the time it takes to bulk load data.</p>
        /// <p>Example: <code>afterConnectScript=SET
        /// session_replication_role='replica'</code>
        /// </p>
        pub fn set_after_connect_script(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_connect_script = input;
            self
        }
        /// <p>To capture DDL events, DMS creates various artifacts in
        /// the PostgreSQL database when the task starts. You can later
        /// remove these artifacts.</p>
        /// <p>If this value is set to <code>N</code>, you don't have to create tables or
        /// triggers on the source database.</p>
        pub fn capture_ddls(mut self, input: bool) -> Self {
            self.capture_ddls = Some(input);
            self
        }
        /// <p>To capture DDL events, DMS creates various artifacts in
        /// the PostgreSQL database when the task starts. You can later
        /// remove these artifacts.</p>
        /// <p>If this value is set to <code>N</code>, you don't have to create tables or
        /// triggers on the source database.</p>
        pub fn set_capture_ddls(mut self, input: std::option::Option<bool>) -> Self {
            self.capture_ddls = input;
            self
        }
        /// <p>Specifies the maximum size (in KB) of any .csv file used to
        /// transfer data to PostgreSQL.</p>
        /// <p>Example: <code>maxFileSize=512</code>
        /// </p>
        pub fn max_file_size(mut self, input: i32) -> Self {
            self.max_file_size = Some(input);
            self
        }
        /// <p>Specifies the maximum size (in KB) of any .csv file used to
        /// transfer data to PostgreSQL.</p>
        /// <p>Example: <code>maxFileSize=512</code>
        /// </p>
        pub fn set_max_file_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_file_size = input;
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Database name for the endpoint.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The schema in which the operational DDL database artifacts
        /// are created.</p>
        /// <p>Example: <code>ddlArtifactsSchema=xyzddlschema;</code>
        /// </p>
        pub fn ddl_artifacts_schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.ddl_artifacts_schema = Some(input.into());
            self
        }
        /// <p>The schema in which the operational DDL database artifacts
        /// are created.</p>
        /// <p>Example: <code>ddlArtifactsSchema=xyzddlschema;</code>
        /// </p>
        pub fn set_ddl_artifacts_schema(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ddl_artifacts_schema = input;
            self
        }
        /// <p>Sets the client statement timeout for the PostgreSQL
        /// instance, in seconds. The default value is 60 seconds.</p>
        /// <p>Example: <code>executeTimeout=100;</code>
        /// </p>
        pub fn execute_timeout(mut self, input: i32) -> Self {
            self.execute_timeout = Some(input);
            self
        }
        /// <p>Sets the client statement timeout for the PostgreSQL
        /// instance, in seconds. The default value is 60 seconds.</p>
        /// <p>Example: <code>executeTimeout=100;</code>
        /// </p>
        pub fn set_execute_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.execute_timeout = input;
            self
        }
        /// <p>When set to <code>true</code>, this value causes a task to fail if the
        /// actual size of a LOB column is greater than the specified
        /// <code>LobMaxSize</code>.</p>
        /// <p>If task is set to Limited LOB mode and this option is set to
        /// true, the task fails instead of truncating the LOB data.</p>
        pub fn fail_tasks_on_lob_truncation(mut self, input: bool) -> Self {
            self.fail_tasks_on_lob_truncation = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, this value causes a task to fail if the
        /// actual size of a LOB column is greater than the specified
        /// <code>LobMaxSize</code>.</p>
        /// <p>If task is set to Limited LOB mode and this option is set to
        /// true, the task fails instead of truncating the LOB data.</p>
        pub fn set_fail_tasks_on_lob_truncation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.fail_tasks_on_lob_truncation = input;
            self
        }
        /// <p>The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this,
        /// it prevents idle logical replication slots from holding onto old WAL logs, which can result in
        /// storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving
        /// and prevents storage full scenarios.</p>
        pub fn heartbeat_enable(mut self, input: bool) -> Self {
            self.heartbeat_enable = Some(input);
            self
        }
        /// <p>The write-ahead log (WAL) heartbeat feature mimics a dummy transaction. By doing this,
        /// it prevents idle logical replication slots from holding onto old WAL logs, which can result in
        /// storage full situations on the source. This heartbeat keeps <code>restart_lsn</code> moving
        /// and prevents storage full scenarios.</p>
        pub fn set_heartbeat_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.heartbeat_enable = input;
            self
        }
        /// <p>Sets the schema in which the heartbeat artifacts are created.</p>
        pub fn heartbeat_schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.heartbeat_schema = Some(input.into());
            self
        }
        /// <p>Sets the schema in which the heartbeat artifacts are created.</p>
        pub fn set_heartbeat_schema(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.heartbeat_schema = input;
            self
        }
        /// <p>Sets the WAL heartbeat frequency (in minutes).</p>
        pub fn heartbeat_frequency(mut self, input: i32) -> Self {
            self.heartbeat_frequency = Some(input);
            self
        }
        /// <p>Sets the WAL heartbeat frequency (in minutes).</p>
        pub fn set_heartbeat_frequency(mut self, input: std::option::Option<i32>) -> Self {
            self.heartbeat_frequency = input;
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>Endpoint connection password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>Endpoint TCP port. The default is 5432.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Endpoint TCP port. The default is 5432.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>Fully qualified domain name of the endpoint.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>Endpoint connection user name.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>Sets the name of a previously created logical replication slot
        /// for a change data capture (CDC) load of the PostgreSQL source instance. </p>
        /// <p>When used with the <code>CdcStartPosition</code>
        /// request parameter for the DMS API , this attribute also makes it possible to use native CDC
        /// start points. DMS verifies that the specified logical
        /// replication slot exists before starting the CDC load task. It
        /// also verifies that the task was created with a valid setting of
        /// <code>CdcStartPosition</code>. If the specified slot
        /// doesn't exist or the task doesn't have a valid
        /// <code>CdcStartPosition</code> setting, DMS raises an
        /// error.</p>
        /// <p>For more information about setting the <code>CdcStartPosition</code> request parameter,
        /// see <a href="dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native">Determining a CDC native start point</a> in the <i>Database Migration Service User
        /// Guide</i>. For more information about using <code>CdcStartPosition</code>, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">CreateReplicationTask</a>, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">StartReplicationTask</a>, and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">ModifyReplicationTask</a>.</p>
        pub fn slot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.slot_name = Some(input.into());
            self
        }
        /// <p>Sets the name of a previously created logical replication slot
        /// for a change data capture (CDC) load of the PostgreSQL source instance. </p>
        /// <p>When used with the <code>CdcStartPosition</code>
        /// request parameter for the DMS API , this attribute also makes it possible to use native CDC
        /// start points. DMS verifies that the specified logical
        /// replication slot exists before starting the CDC load task. It
        /// also verifies that the task was created with a valid setting of
        /// <code>CdcStartPosition</code>. If the specified slot
        /// doesn't exist or the task doesn't have a valid
        /// <code>CdcStartPosition</code> setting, DMS raises an
        /// error.</p>
        /// <p>For more information about setting the <code>CdcStartPosition</code> request parameter,
        /// see <a href="dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native">Determining a CDC native start point</a> in the <i>Database Migration Service User
        /// Guide</i>. For more information about using <code>CdcStartPosition</code>, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html">CreateReplicationTask</a>, <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html">StartReplicationTask</a>, and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html">ModifyReplicationTask</a>.</p>
        pub fn set_slot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.slot_name = input;
            self
        }
        /// <p>Specifies the plugin to use to create a replication slot.</p>
        pub fn plugin_name(mut self, input: crate::model::PluginNameValue) -> Self {
            self.plugin_name = Some(input);
            self
        }
        /// <p>Specifies the plugin to use to create a replication slot.</p>
        pub fn set_plugin_name(
            mut self,
            input: std::option::Option<crate::model::PluginNameValue>,
        ) -> Self {
            self.plugin_name = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the PostgreSQL endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager
        /// secret that allows access to the PostgreSQL endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the PostgreSQL endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the PostgreSQL endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PostgreSqlSettings`](crate::model::PostgreSqlSettings)
        pub fn build(self) -> crate::model::PostgreSqlSettings {
            crate::model::PostgreSqlSettings {
                after_connect_script: self.after_connect_script,
                capture_ddls: self.capture_ddls,
                max_file_size: self.max_file_size,
                database_name: self.database_name,
                ddl_artifacts_schema: self.ddl_artifacts_schema,
                execute_timeout: self.execute_timeout,
                fail_tasks_on_lob_truncation: self.fail_tasks_on_lob_truncation,
                heartbeat_enable: self.heartbeat_enable,
                heartbeat_schema: self.heartbeat_schema,
                heartbeat_frequency: self.heartbeat_frequency,
                password: self.password,
                port: self.port,
                server_name: self.server_name,
                username: self.username,
                slot_name: self.slot_name,
                plugin_name: self.plugin_name,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl PostgreSqlSettings {
    /// Creates a new builder-style object to manufacture [`PostgreSqlSettings`](crate::model::PostgreSqlSettings)
    pub fn builder() -> crate::model::postgre_sql_settings::Builder {
        crate::model::postgre_sql_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PluginNameValue {
    #[allow(missing_docs)] // documentation missing in model
    NoPreference,
    #[allow(missing_docs)] // documentation missing in model
    Pglogical,
    #[allow(missing_docs)] // documentation missing in model
    TestDecoding,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PluginNameValue {
    fn from(s: &str) -> Self {
        match s {
            "no-preference" => PluginNameValue::NoPreference,
            "pglogical" => PluginNameValue::Pglogical,
            "test-decoding" => PluginNameValue::TestDecoding,
            other => PluginNameValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PluginNameValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PluginNameValue::from(s))
    }
}
impl PluginNameValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PluginNameValue::NoPreference => "no-preference",
            PluginNameValue::Pglogical => "pglogical",
            PluginNameValue::TestDecoding => "test-decoding",
            PluginNameValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["no-preference", "pglogical", "test-decoding"]
    }
}
impl AsRef<str> for PluginNameValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines an Amazon Redshift endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftSettings {
    /// <p>A value that indicates to allow any date format, including invalid formats such as
    /// 00/00/00 00:00:00, to be loaded without generating an error. You can choose
    /// <code>true</code> or <code>false</code> (the default).</p>
    /// <p>This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with
    /// the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT
    /// specification, Amazon Redshift inserts a NULL value into that field. </p>
    pub accept_any_date: std::option::Option<bool>,
    /// <p>Code to run after connecting. This parameter should contain the code itself, not the
    /// name of a file containing the code.</p>
    pub after_connect_script: std::option::Option<std::string::String>,
    /// <p>An S3 folder where the comma-separated-value (.csv) files are stored before being
    /// uploaded to the target Redshift cluster. </p>
    /// <p>For full load mode, DMS converts source records into .csv files and loads them to
    /// the <i>BucketFolder/TableID</i> path. DMS uses the Redshift
    /// <code>COPY</code> command to upload the .csv files to the target table. The files are
    /// deleted once the <code>COPY</code> operation has finished. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the
    /// <i>Amazon Redshift Database Developer Guide</i>.</p>
    /// <p>For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table,
    /// and loads the .csv files to this <i>BucketFolder/NetChangesTableID</i> path.</p>
    pub bucket_folder: std::option::Option<std::string::String>,
    /// <p>The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>If Amazon Redshift is configured to support case sensitive schema names, set
    /// <code>CaseSensitiveNames</code> to <code>true</code>. The default is
    /// <code>false</code>.</p>
    pub case_sensitive_names: std::option::Option<bool>,
    /// <p>If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies
    /// automatic compression if the table is empty. This applies even if the table columns already
    /// have encodings other than <code>RAW</code>. If you set <code>CompUpdate</code> to
    /// <code>false</code>, automatic compression is disabled and existing column encodings
    /// aren't changed. The default is <code>true</code>.</p>
    pub comp_update: std::option::Option<bool>,
    /// <p>A value that sets the amount of time to wait (in milliseconds) before timing out,
    /// beginning from when you initially establish a connection.</p>
    pub connection_timeout: std::option::Option<i32>,
    /// <p>The name of the Amazon Redshift data warehouse (service) that you are working
    /// with.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The date format that you are using. Valid values are <code>auto</code> (case-sensitive),
    /// your date format string enclosed in quotes, or NULL. If this parameter is left unset
    /// (NULL), it defaults to a format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most
    /// strings, even some that aren't supported when you use a date format string. </p>
    /// <p>If your date and time values use formats different from each other, set this to
    /// <code>auto</code>. </p>
    pub date_format: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as
    /// NULL. A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default
    /// is <code>false</code>.</p>
    pub empty_as_null: std::option::Option<bool>,
    /// <p>The type of server-side encryption that you want to use for your data. This encryption
    /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
    /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
    /// <note>
    /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
    /// <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
    /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
    /// to <code>SSE_KMS</code>.</p>
    /// </note>
    /// <p>To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with
    /// a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions:
    /// <code>"s3:PutObject", "s3:ListBucket"</code>
    /// </p>
    pub encryption_mode: std::option::Option<crate::model::EncryptionModeValue>,
    /// <p>This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code>
    /// to <code>true</code> to have tables with <code>IDENTITY</code> columns override their
    /// auto-generated values with explicit values loaded from the source data files used to
    /// populate the tables. The default is <code>false</code>.</p>
    pub explicit_ids: std::option::Option<bool>,
    /// <p>The number of threads used to upload a single file. This parameter accepts a value from
    /// 1 through 64. It defaults to 10.</p>
    /// <p>The number of parallel streams used to upload a single .csv file to an S3 bucket using
    /// S3 Multipart Upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload
    /// overview</a>. </p>
    /// <p>
    /// <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It
    /// defaults to 10.</p>
    pub file_transfer_upload_streams: std::option::Option<i32>,
    /// <p>The amount of time to wait (in milliseconds) before timing out of operations performed
    /// by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.</p>
    pub load_timeout: std::option::Option<i32>,
    /// <p>The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer
    /// data to Amazon Redshift. It defaults to 1048576KB (1 GB).</p>
    pub max_file_size: std::option::Option<i32>,
    /// <p>The password for the user named in the <code>username</code> property.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The port number for Amazon Redshift. The default value is 5439.</p>
    pub port: std::option::Option<i32>,
    /// <p>A value that specifies to remove surrounding quotation marks from strings in the
    /// incoming data. All characters within the quotation marks, including delimiters, are
    /// retained. Choose <code>true</code> to remove quotation marks. The default is
    /// <code>false</code>.</p>
    pub remove_quotes: std::option::Option<bool>,
    /// <p>A list of characters that you want to replace. Use with
    /// <code>ReplaceChars</code>.</p>
    pub replace_invalid_chars: std::option::Option<std::string::String>,
    /// <p>A value that specifies to replaces the invalid characters specified in
    /// <code>ReplaceInvalidChars</code>, substituting the specified characters instead. The
    /// default is <code>"?"</code>.</p>
    pub replace_chars: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Redshift cluster you are using.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift
    /// service. The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>,
    /// provide this key ID. The key that you use needs an attached policy that enables IAM user
    /// permissions and allows use of the key.</p>
    pub server_side_encryption_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The time format that you want to use. Valid values are <code>auto</code>
    /// (case-sensitive), <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or
    /// <code>'epochmillisecs'</code>. It defaults to 10. Using <code>auto</code> recognizes
    /// most strings, even some that aren't supported when you use a time format string. </p>
    /// <p>If your date and time values use formats different from each other, set this parameter
    /// to <code>auto</code>. </p>
    pub time_format: std::option::Option<std::string::String>,
    /// <p>A value that specifies to remove the trailing white space characters from a VARCHAR
    /// string. This parameter applies only to columns with a VARCHAR data type. Choose
    /// <code>true</code> to remove unneeded white space. The default is
    /// <code>false</code>.</p>
    pub trim_blanks: std::option::Option<bool>,
    /// <p>A value that specifies to truncate data in columns to the appropriate number of
    /// characters, so that the data fits in the column. This parameter applies only to columns
    /// with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose
    /// <code>true</code> to truncate data. The default is <code>false</code>.</p>
    pub truncate_columns: std::option::Option<bool>,
    /// <p>An Amazon Redshift user name for a registered user.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The size (in KB) of the in-memory file write buffer used when generating .csv files
    /// on the local disk at the DMS replication instance. The default value is 1000
    /// (buffer size is 1000KB).</p>
    pub write_buffer_size: std::option::Option<i32>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Amazon Redshift endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl RedshiftSettings {
    /// <p>A value that indicates to allow any date format, including invalid formats such as
    /// 00/00/00 00:00:00, to be loaded without generating an error. You can choose
    /// <code>true</code> or <code>false</code> (the default).</p>
    /// <p>This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with
    /// the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT
    /// specification, Amazon Redshift inserts a NULL value into that field. </p>
    pub fn accept_any_date(&self) -> std::option::Option<bool> {
        self.accept_any_date
    }
    /// <p>Code to run after connecting. This parameter should contain the code itself, not the
    /// name of a file containing the code.</p>
    pub fn after_connect_script(&self) -> std::option::Option<&str> {
        self.after_connect_script.as_deref()
    }
    /// <p>An S3 folder where the comma-separated-value (.csv) files are stored before being
    /// uploaded to the target Redshift cluster. </p>
    /// <p>For full load mode, DMS converts source records into .csv files and loads them to
    /// the <i>BucketFolder/TableID</i> path. DMS uses the Redshift
    /// <code>COPY</code> command to upload the .csv files to the target table. The files are
    /// deleted once the <code>COPY</code> operation has finished. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the
    /// <i>Amazon Redshift Database Developer Guide</i>.</p>
    /// <p>For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table,
    /// and loads the .csv files to this <i>BucketFolder/NetChangesTableID</i> path.</p>
    pub fn bucket_folder(&self) -> std::option::Option<&str> {
        self.bucket_folder.as_deref()
    }
    /// <p>The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>If Amazon Redshift is configured to support case sensitive schema names, set
    /// <code>CaseSensitiveNames</code> to <code>true</code>. The default is
    /// <code>false</code>.</p>
    pub fn case_sensitive_names(&self) -> std::option::Option<bool> {
        self.case_sensitive_names
    }
    /// <p>If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies
    /// automatic compression if the table is empty. This applies even if the table columns already
    /// have encodings other than <code>RAW</code>. If you set <code>CompUpdate</code> to
    /// <code>false</code>, automatic compression is disabled and existing column encodings
    /// aren't changed. The default is <code>true</code>.</p>
    pub fn comp_update(&self) -> std::option::Option<bool> {
        self.comp_update
    }
    /// <p>A value that sets the amount of time to wait (in milliseconds) before timing out,
    /// beginning from when you initially establish a connection.</p>
    pub fn connection_timeout(&self) -> std::option::Option<i32> {
        self.connection_timeout
    }
    /// <p>The name of the Amazon Redshift data warehouse (service) that you are working
    /// with.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The date format that you are using. Valid values are <code>auto</code> (case-sensitive),
    /// your date format string enclosed in quotes, or NULL. If this parameter is left unset
    /// (NULL), it defaults to a format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most
    /// strings, even some that aren't supported when you use a date format string. </p>
    /// <p>If your date and time values use formats different from each other, set this to
    /// <code>auto</code>. </p>
    pub fn date_format(&self) -> std::option::Option<&str> {
        self.date_format.as_deref()
    }
    /// <p>A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as
    /// NULL. A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default
    /// is <code>false</code>.</p>
    pub fn empty_as_null(&self) -> std::option::Option<bool> {
        self.empty_as_null
    }
    /// <p>The type of server-side encryption that you want to use for your data. This encryption
    /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
    /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
    /// <note>
    /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
    /// <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
    /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
    /// to <code>SSE_KMS</code>.</p>
    /// </note>
    /// <p>To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with
    /// a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions:
    /// <code>"s3:PutObject", "s3:ListBucket"</code>
    /// </p>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionModeValue> {
        self.encryption_mode.as_ref()
    }
    /// <p>This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code>
    /// to <code>true</code> to have tables with <code>IDENTITY</code> columns override their
    /// auto-generated values with explicit values loaded from the source data files used to
    /// populate the tables. The default is <code>false</code>.</p>
    pub fn explicit_ids(&self) -> std::option::Option<bool> {
        self.explicit_ids
    }
    /// <p>The number of threads used to upload a single file. This parameter accepts a value from
    /// 1 through 64. It defaults to 10.</p>
    /// <p>The number of parallel streams used to upload a single .csv file to an S3 bucket using
    /// S3 Multipart Upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload
    /// overview</a>. </p>
    /// <p>
    /// <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It
    /// defaults to 10.</p>
    pub fn file_transfer_upload_streams(&self) -> std::option::Option<i32> {
        self.file_transfer_upload_streams
    }
    /// <p>The amount of time to wait (in milliseconds) before timing out of operations performed
    /// by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.</p>
    pub fn load_timeout(&self) -> std::option::Option<i32> {
        self.load_timeout
    }
    /// <p>The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer
    /// data to Amazon Redshift. It defaults to 1048576KB (1 GB).</p>
    pub fn max_file_size(&self) -> std::option::Option<i32> {
        self.max_file_size
    }
    /// <p>The password for the user named in the <code>username</code> property.</p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p>The port number for Amazon Redshift. The default value is 5439.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>A value that specifies to remove surrounding quotation marks from strings in the
    /// incoming data. All characters within the quotation marks, including delimiters, are
    /// retained. Choose <code>true</code> to remove quotation marks. The default is
    /// <code>false</code>.</p>
    pub fn remove_quotes(&self) -> std::option::Option<bool> {
        self.remove_quotes
    }
    /// <p>A list of characters that you want to replace. Use with
    /// <code>ReplaceChars</code>.</p>
    pub fn replace_invalid_chars(&self) -> std::option::Option<&str> {
        self.replace_invalid_chars.as_deref()
    }
    /// <p>A value that specifies to replaces the invalid characters specified in
    /// <code>ReplaceInvalidChars</code>, substituting the specified characters instead. The
    /// default is <code>"?"</code>.</p>
    pub fn replace_chars(&self) -> std::option::Option<&str> {
        self.replace_chars.as_deref()
    }
    /// <p>The name of the Amazon Redshift cluster you are using.</p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift
    /// service. The role must allow the <code>iam:PassRole</code> action.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p>The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>,
    /// provide this key ID. The key that you use needs an attached policy that enables IAM user
    /// permissions and allows use of the key.</p>
    pub fn server_side_encryption_kms_key_id(&self) -> std::option::Option<&str> {
        self.server_side_encryption_kms_key_id.as_deref()
    }
    /// <p>The time format that you want to use. Valid values are <code>auto</code>
    /// (case-sensitive), <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or
    /// <code>'epochmillisecs'</code>. It defaults to 10. Using <code>auto</code> recognizes
    /// most strings, even some that aren't supported when you use a time format string. </p>
    /// <p>If your date and time values use formats different from each other, set this parameter
    /// to <code>auto</code>. </p>
    pub fn time_format(&self) -> std::option::Option<&str> {
        self.time_format.as_deref()
    }
    /// <p>A value that specifies to remove the trailing white space characters from a VARCHAR
    /// string. This parameter applies only to columns with a VARCHAR data type. Choose
    /// <code>true</code> to remove unneeded white space. The default is
    /// <code>false</code>.</p>
    pub fn trim_blanks(&self) -> std::option::Option<bool> {
        self.trim_blanks
    }
    /// <p>A value that specifies to truncate data in columns to the appropriate number of
    /// characters, so that the data fits in the column. This parameter applies only to columns
    /// with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose
    /// <code>true</code> to truncate data. The default is <code>false</code>.</p>
    pub fn truncate_columns(&self) -> std::option::Option<bool> {
        self.truncate_columns
    }
    /// <p>An Amazon Redshift user name for a registered user.</p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p>The size (in KB) of the in-memory file write buffer used when generating .csv files
    /// on the local disk at the DMS replication instance. The default value is 1000
    /// (buffer size is 1000KB).</p>
    pub fn write_buffer_size(&self) -> std::option::Option<i32> {
        self.write_buffer_size
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Amazon Redshift endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for RedshiftSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftSettings");
        formatter.field("accept_any_date", &self.accept_any_date);
        formatter.field("after_connect_script", &self.after_connect_script);
        formatter.field("bucket_folder", &self.bucket_folder);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("case_sensitive_names", &self.case_sensitive_names);
        formatter.field("comp_update", &self.comp_update);
        formatter.field("connection_timeout", &self.connection_timeout);
        formatter.field("database_name", &self.database_name);
        formatter.field("date_format", &self.date_format);
        formatter.field("empty_as_null", &self.empty_as_null);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field("explicit_ids", &self.explicit_ids);
        formatter.field(
            "file_transfer_upload_streams",
            &self.file_transfer_upload_streams,
        );
        formatter.field("load_timeout", &self.load_timeout);
        formatter.field("max_file_size", &self.max_file_size);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("port", &self.port);
        formatter.field("remove_quotes", &self.remove_quotes);
        formatter.field("replace_invalid_chars", &self.replace_invalid_chars);
        formatter.field("replace_chars", &self.replace_chars);
        formatter.field("server_name", &self.server_name);
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field(
            "server_side_encryption_kms_key_id",
            &self.server_side_encryption_kms_key_id,
        );
        formatter.field("time_format", &self.time_format);
        formatter.field("trim_blanks", &self.trim_blanks);
        formatter.field("truncate_columns", &self.truncate_columns);
        formatter.field("username", &self.username);
        formatter.field("write_buffer_size", &self.write_buffer_size);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`RedshiftSettings`](crate::model::RedshiftSettings)
pub mod redshift_settings {
    /// A builder for [`RedshiftSettings`](crate::model::RedshiftSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) accept_any_date: std::option::Option<bool>,
        pub(crate) after_connect_script: std::option::Option<std::string::String>,
        pub(crate) bucket_folder: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) case_sensitive_names: std::option::Option<bool>,
        pub(crate) comp_update: std::option::Option<bool>,
        pub(crate) connection_timeout: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) date_format: std::option::Option<std::string::String>,
        pub(crate) empty_as_null: std::option::Option<bool>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionModeValue>,
        pub(crate) explicit_ids: std::option::Option<bool>,
        pub(crate) file_transfer_upload_streams: std::option::Option<i32>,
        pub(crate) load_timeout: std::option::Option<i32>,
        pub(crate) max_file_size: std::option::Option<i32>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) remove_quotes: std::option::Option<bool>,
        pub(crate) replace_invalid_chars: std::option::Option<std::string::String>,
        pub(crate) replace_chars: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) server_side_encryption_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) time_format: std::option::Option<std::string::String>,
        pub(crate) trim_blanks: std::option::Option<bool>,
        pub(crate) truncate_columns: std::option::Option<bool>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) write_buffer_size: std::option::Option<i32>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A value that indicates to allow any date format, including invalid formats such as
        /// 00/00/00 00:00:00, to be loaded without generating an error. You can choose
        /// <code>true</code> or <code>false</code> (the default).</p>
        /// <p>This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with
        /// the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT
        /// specification, Amazon Redshift inserts a NULL value into that field. </p>
        pub fn accept_any_date(mut self, input: bool) -> Self {
            self.accept_any_date = Some(input);
            self
        }
        /// <p>A value that indicates to allow any date format, including invalid formats such as
        /// 00/00/00 00:00:00, to be loaded without generating an error. You can choose
        /// <code>true</code> or <code>false</code> (the default).</p>
        /// <p>This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE with
        /// the DATEFORMAT parameter. If the date format for the data doesn't match the DATEFORMAT
        /// specification, Amazon Redshift inserts a NULL value into that field. </p>
        pub fn set_accept_any_date(mut self, input: std::option::Option<bool>) -> Self {
            self.accept_any_date = input;
            self
        }
        /// <p>Code to run after connecting. This parameter should contain the code itself, not the
        /// name of a file containing the code.</p>
        pub fn after_connect_script(mut self, input: impl Into<std::string::String>) -> Self {
            self.after_connect_script = Some(input.into());
            self
        }
        /// <p>Code to run after connecting. This parameter should contain the code itself, not the
        /// name of a file containing the code.</p>
        pub fn set_after_connect_script(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.after_connect_script = input;
            self
        }
        /// <p>An S3 folder where the comma-separated-value (.csv) files are stored before being
        /// uploaded to the target Redshift cluster. </p>
        /// <p>For full load mode, DMS converts source records into .csv files and loads them to
        /// the <i>BucketFolder/TableID</i> path. DMS uses the Redshift
        /// <code>COPY</code> command to upload the .csv files to the target table. The files are
        /// deleted once the <code>COPY</code> operation has finished. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the
        /// <i>Amazon Redshift Database Developer Guide</i>.</p>
        /// <p>For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table,
        /// and loads the .csv files to this <i>BucketFolder/NetChangesTableID</i> path.</p>
        pub fn bucket_folder(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_folder = Some(input.into());
            self
        }
        /// <p>An S3 folder where the comma-separated-value (.csv) files are stored before being
        /// uploaded to the target Redshift cluster. </p>
        /// <p>For full load mode, DMS converts source records into .csv files and loads them to
        /// the <i>BucketFolder/TableID</i> path. DMS uses the Redshift
        /// <code>COPY</code> command to upload the .csv files to the target table. The files are
        /// deleted once the <code>COPY</code> operation has finished. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">COPY</a> in the
        /// <i>Amazon Redshift Database Developer Guide</i>.</p>
        /// <p>For change-data-capture (CDC) mode, DMS creates a <i>NetChanges</i> table,
        /// and loads the .csv files to this <i>BucketFolder/NetChangesTableID</i> path.</p>
        pub fn set_bucket_folder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_folder = input;
            self
        }
        /// <p>The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the intermediate S3 bucket used to store .csv files before uploading data to Redshift.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>If Amazon Redshift is configured to support case sensitive schema names, set
        /// <code>CaseSensitiveNames</code> to <code>true</code>. The default is
        /// <code>false</code>.</p>
        pub fn case_sensitive_names(mut self, input: bool) -> Self {
            self.case_sensitive_names = Some(input);
            self
        }
        /// <p>If Amazon Redshift is configured to support case sensitive schema names, set
        /// <code>CaseSensitiveNames</code> to <code>true</code>. The default is
        /// <code>false</code>.</p>
        pub fn set_case_sensitive_names(mut self, input: std::option::Option<bool>) -> Self {
            self.case_sensitive_names = input;
            self
        }
        /// <p>If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies
        /// automatic compression if the table is empty. This applies even if the table columns already
        /// have encodings other than <code>RAW</code>. If you set <code>CompUpdate</code> to
        /// <code>false</code>, automatic compression is disabled and existing column encodings
        /// aren't changed. The default is <code>true</code>.</p>
        pub fn comp_update(mut self, input: bool) -> Self {
            self.comp_update = Some(input);
            self
        }
        /// <p>If you set <code>CompUpdate</code> to <code>true</code> Amazon Redshift applies
        /// automatic compression if the table is empty. This applies even if the table columns already
        /// have encodings other than <code>RAW</code>. If you set <code>CompUpdate</code> to
        /// <code>false</code>, automatic compression is disabled and existing column encodings
        /// aren't changed. The default is <code>true</code>.</p>
        pub fn set_comp_update(mut self, input: std::option::Option<bool>) -> Self {
            self.comp_update = input;
            self
        }
        /// <p>A value that sets the amount of time to wait (in milliseconds) before timing out,
        /// beginning from when you initially establish a connection.</p>
        pub fn connection_timeout(mut self, input: i32) -> Self {
            self.connection_timeout = Some(input);
            self
        }
        /// <p>A value that sets the amount of time to wait (in milliseconds) before timing out,
        /// beginning from when you initially establish a connection.</p>
        pub fn set_connection_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_timeout = input;
            self
        }
        /// <p>The name of the Amazon Redshift data warehouse (service) that you are working
        /// with.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift data warehouse (service) that you are working
        /// with.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The date format that you are using. Valid values are <code>auto</code> (case-sensitive),
        /// your date format string enclosed in quotes, or NULL. If this parameter is left unset
        /// (NULL), it defaults to a format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most
        /// strings, even some that aren't supported when you use a date format string. </p>
        /// <p>If your date and time values use formats different from each other, set this to
        /// <code>auto</code>. </p>
        pub fn date_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_format = Some(input.into());
            self
        }
        /// <p>The date format that you are using. Valid values are <code>auto</code> (case-sensitive),
        /// your date format string enclosed in quotes, or NULL. If this parameter is left unset
        /// (NULL), it defaults to a format of 'YYYY-MM-DD'. Using <code>auto</code> recognizes most
        /// strings, even some that aren't supported when you use a date format string. </p>
        /// <p>If your date and time values use formats different from each other, set this to
        /// <code>auto</code>. </p>
        pub fn set_date_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.date_format = input;
            self
        }
        /// <p>A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as
        /// NULL. A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default
        /// is <code>false</code>.</p>
        pub fn empty_as_null(mut self, input: bool) -> Self {
            self.empty_as_null = Some(input);
            self
        }
        /// <p>A value that specifies whether DMS should migrate empty CHAR and VARCHAR fields as
        /// NULL. A value of <code>true</code> sets empty CHAR and VARCHAR fields to null. The default
        /// is <code>false</code>.</p>
        pub fn set_empty_as_null(mut self, input: std::option::Option<bool>) -> Self {
            self.empty_as_null = input;
            self
        }
        /// <p>The type of server-side encryption that you want to use for your data. This encryption
        /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
        /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
        /// <note>
        /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
        /// <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
        /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
        /// to <code>SSE_KMS</code>.</p>
        /// </note>
        /// <p>To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with
        /// a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions:
        /// <code>"s3:PutObject", "s3:ListBucket"</code>
        /// </p>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionModeValue) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The type of server-side encryption that you want to use for your data. This encryption
        /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
        /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
        /// <note>
        /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of the
        /// <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
        /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
        /// to <code>SSE_KMS</code>.</p>
        /// </note>
        /// <p>To use <code>SSE_S3</code>, create an Identity and Access Management (IAM) role with
        /// a policy that allows <code>"arn:aws:s3:::*"</code> to use the following actions:
        /// <code>"s3:PutObject", "s3:ListBucket"</code>
        /// </p>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionModeValue>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code>
        /// to <code>true</code> to have tables with <code>IDENTITY</code> columns override their
        /// auto-generated values with explicit values loaded from the source data files used to
        /// populate the tables. The default is <code>false</code>.</p>
        pub fn explicit_ids(mut self, input: bool) -> Self {
            self.explicit_ids = Some(input);
            self
        }
        /// <p>This setting is only valid for a full-load migration task. Set <code>ExplicitIds</code>
        /// to <code>true</code> to have tables with <code>IDENTITY</code> columns override their
        /// auto-generated values with explicit values loaded from the source data files used to
        /// populate the tables. The default is <code>false</code>.</p>
        pub fn set_explicit_ids(mut self, input: std::option::Option<bool>) -> Self {
            self.explicit_ids = input;
            self
        }
        /// <p>The number of threads used to upload a single file. This parameter accepts a value from
        /// 1 through 64. It defaults to 10.</p>
        /// <p>The number of parallel streams used to upload a single .csv file to an S3 bucket using
        /// S3 Multipart Upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload
        /// overview</a>. </p>
        /// <p>
        /// <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It
        /// defaults to 10.</p>
        pub fn file_transfer_upload_streams(mut self, input: i32) -> Self {
            self.file_transfer_upload_streams = Some(input);
            self
        }
        /// <p>The number of threads used to upload a single file. This parameter accepts a value from
        /// 1 through 64. It defaults to 10.</p>
        /// <p>The number of parallel streams used to upload a single .csv file to an S3 bucket using
        /// S3 Multipart Upload. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html">Multipart upload
        /// overview</a>. </p>
        /// <p>
        /// <code>FileTransferUploadStreams</code> accepts a value from 1 through 64. It
        /// defaults to 10.</p>
        pub fn set_file_transfer_upload_streams(mut self, input: std::option::Option<i32>) -> Self {
            self.file_transfer_upload_streams = input;
            self
        }
        /// <p>The amount of time to wait (in milliseconds) before timing out of operations performed
        /// by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.</p>
        pub fn load_timeout(mut self, input: i32) -> Self {
            self.load_timeout = Some(input);
            self
        }
        /// <p>The amount of time to wait (in milliseconds) before timing out of operations performed
        /// by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE, and UPDATE.</p>
        pub fn set_load_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.load_timeout = input;
            self
        }
        /// <p>The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer
        /// data to Amazon Redshift. It defaults to 1048576KB (1 GB).</p>
        pub fn max_file_size(mut self, input: i32) -> Self {
            self.max_file_size = Some(input);
            self
        }
        /// <p>The maximum size (in KB) of any .csv file used to load data on an S3 bucket and transfer
        /// data to Amazon Redshift. It defaults to 1048576KB (1 GB).</p>
        pub fn set_max_file_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_file_size = input;
            self
        }
        /// <p>The password for the user named in the <code>username</code> property.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the user named in the <code>username</code> property.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The port number for Amazon Redshift. The default value is 5439.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number for Amazon Redshift. The default value is 5439.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>A value that specifies to remove surrounding quotation marks from strings in the
        /// incoming data. All characters within the quotation marks, including delimiters, are
        /// retained. Choose <code>true</code> to remove quotation marks. The default is
        /// <code>false</code>.</p>
        pub fn remove_quotes(mut self, input: bool) -> Self {
            self.remove_quotes = Some(input);
            self
        }
        /// <p>A value that specifies to remove surrounding quotation marks from strings in the
        /// incoming data. All characters within the quotation marks, including delimiters, are
        /// retained. Choose <code>true</code> to remove quotation marks. The default is
        /// <code>false</code>.</p>
        pub fn set_remove_quotes(mut self, input: std::option::Option<bool>) -> Self {
            self.remove_quotes = input;
            self
        }
        /// <p>A list of characters that you want to replace. Use with
        /// <code>ReplaceChars</code>.</p>
        pub fn replace_invalid_chars(mut self, input: impl Into<std::string::String>) -> Self {
            self.replace_invalid_chars = Some(input.into());
            self
        }
        /// <p>A list of characters that you want to replace. Use with
        /// <code>ReplaceChars</code>.</p>
        pub fn set_replace_invalid_chars(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replace_invalid_chars = input;
            self
        }
        /// <p>A value that specifies to replaces the invalid characters specified in
        /// <code>ReplaceInvalidChars</code>, substituting the specified characters instead. The
        /// default is <code>"?"</code>.</p>
        pub fn replace_chars(mut self, input: impl Into<std::string::String>) -> Self {
            self.replace_chars = Some(input.into());
            self
        }
        /// <p>A value that specifies to replaces the invalid characters specified in
        /// <code>ReplaceInvalidChars</code>, substituting the specified characters instead. The
        /// default is <code>"?"</code>.</p>
        pub fn set_replace_chars(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replace_chars = input;
            self
        }
        /// <p>The name of the Amazon Redshift cluster you are using.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift cluster you are using.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift
        /// service. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon Redshift
        /// service. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>,
        /// provide this key ID. The key that you use needs an attached policy that enables IAM user
        /// permissions and allows use of the key.</p>
        pub fn server_side_encryption_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.server_side_encryption_kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key ID. If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>,
        /// provide this key ID. The key that you use needs an attached policy that enables IAM user
        /// permissions and allows use of the key.</p>
        pub fn set_server_side_encryption_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_side_encryption_kms_key_id = input;
            self
        }
        /// <p>The time format that you want to use. Valid values are <code>auto</code>
        /// (case-sensitive), <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or
        /// <code>'epochmillisecs'</code>. It defaults to 10. Using <code>auto</code> recognizes
        /// most strings, even some that aren't supported when you use a time format string. </p>
        /// <p>If your date and time values use formats different from each other, set this parameter
        /// to <code>auto</code>. </p>
        pub fn time_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_format = Some(input.into());
            self
        }
        /// <p>The time format that you want to use. Valid values are <code>auto</code>
        /// (case-sensitive), <code>'timeformat_string'</code>, <code>'epochsecs'</code>, or
        /// <code>'epochmillisecs'</code>. It defaults to 10. Using <code>auto</code> recognizes
        /// most strings, even some that aren't supported when you use a time format string. </p>
        /// <p>If your date and time values use formats different from each other, set this parameter
        /// to <code>auto</code>. </p>
        pub fn set_time_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_format = input;
            self
        }
        /// <p>A value that specifies to remove the trailing white space characters from a VARCHAR
        /// string. This parameter applies only to columns with a VARCHAR data type. Choose
        /// <code>true</code> to remove unneeded white space. The default is
        /// <code>false</code>.</p>
        pub fn trim_blanks(mut self, input: bool) -> Self {
            self.trim_blanks = Some(input);
            self
        }
        /// <p>A value that specifies to remove the trailing white space characters from a VARCHAR
        /// string. This parameter applies only to columns with a VARCHAR data type. Choose
        /// <code>true</code> to remove unneeded white space. The default is
        /// <code>false</code>.</p>
        pub fn set_trim_blanks(mut self, input: std::option::Option<bool>) -> Self {
            self.trim_blanks = input;
            self
        }
        /// <p>A value that specifies to truncate data in columns to the appropriate number of
        /// characters, so that the data fits in the column. This parameter applies only to columns
        /// with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose
        /// <code>true</code> to truncate data. The default is <code>false</code>.</p>
        pub fn truncate_columns(mut self, input: bool) -> Self {
            self.truncate_columns = Some(input);
            self
        }
        /// <p>A value that specifies to truncate data in columns to the appropriate number of
        /// characters, so that the data fits in the column. This parameter applies only to columns
        /// with a VARCHAR or CHAR data type, and rows with a size of 4 MB or less. Choose
        /// <code>true</code> to truncate data. The default is <code>false</code>.</p>
        pub fn set_truncate_columns(mut self, input: std::option::Option<bool>) -> Self {
            self.truncate_columns = input;
            self
        }
        /// <p>An Amazon Redshift user name for a registered user.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>An Amazon Redshift user name for a registered user.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The size (in KB) of the in-memory file write buffer used when generating .csv files
        /// on the local disk at the DMS replication instance. The default value is 1000
        /// (buffer size is 1000KB).</p>
        pub fn write_buffer_size(mut self, input: i32) -> Self {
            self.write_buffer_size = Some(input);
            self
        }
        /// <p>The size (in KB) of the in-memory file write buffer used when generating .csv files
        /// on the local disk at the DMS replication instance. The default value is 1000
        /// (buffer size is 1000KB).</p>
        pub fn set_write_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.write_buffer_size = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the Amazon Redshift endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Amazon Redshift endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the Amazon Redshift endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftSettings`](crate::model::RedshiftSettings)
        pub fn build(self) -> crate::model::RedshiftSettings {
            crate::model::RedshiftSettings {
                accept_any_date: self.accept_any_date,
                after_connect_script: self.after_connect_script,
                bucket_folder: self.bucket_folder,
                bucket_name: self.bucket_name,
                case_sensitive_names: self.case_sensitive_names,
                comp_update: self.comp_update,
                connection_timeout: self.connection_timeout,
                database_name: self.database_name,
                date_format: self.date_format,
                empty_as_null: self.empty_as_null,
                encryption_mode: self.encryption_mode,
                explicit_ids: self.explicit_ids,
                file_transfer_upload_streams: self.file_transfer_upload_streams,
                load_timeout: self.load_timeout,
                max_file_size: self.max_file_size,
                password: self.password,
                port: self.port,
                remove_quotes: self.remove_quotes,
                replace_invalid_chars: self.replace_invalid_chars,
                replace_chars: self.replace_chars,
                server_name: self.server_name,
                service_access_role_arn: self.service_access_role_arn,
                server_side_encryption_kms_key_id: self.server_side_encryption_kms_key_id,
                time_format: self.time_format,
                trim_blanks: self.trim_blanks,
                truncate_columns: self.truncate_columns,
                username: self.username,
                write_buffer_size: self.write_buffer_size,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl RedshiftSettings {
    /// Creates a new builder-style object to manufacture [`RedshiftSettings`](crate::model::RedshiftSettings)
    pub fn builder() -> crate::model::redshift_settings::Builder {
        crate::model::redshift_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionModeValue {
    #[allow(missing_docs)] // documentation missing in model
    SseKms,
    #[allow(missing_docs)] // documentation missing in model
    SseS3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionModeValue {
    fn from(s: &str) -> Self {
        match s {
            "sse-kms" => EncryptionModeValue::SseKms,
            "sse-s3" => EncryptionModeValue::SseS3,
            other => EncryptionModeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionModeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionModeValue::from(s))
    }
}
impl EncryptionModeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionModeValue::SseKms => "sse-kms",
            EncryptionModeValue::SseS3 => "sse-s3",
            EncryptionModeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["sse-kms", "sse-s3"]
    }
}
impl AsRef<str> for EncryptionModeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that defines an Amazon Neptune endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NeptuneSettings {
    /// <p>The Amazon Resource Name (ARN) of the service role that you created for the Neptune
    /// target endpoint. The role must allow the <code>iam:PassRole</code> action.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <i>Database Migration Service User
    /// Guide. </i>
    /// </p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket where DMS can temporarily store migrated graph data
    /// in .csv files before bulk-loading it to the Neptune target database. DMS maps the SQL
    /// source data to graph data before storing it in these .csv files.</p>
    pub s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>A folder path where you want DMS to store migrated graph data in the S3 bucket
    /// specified by <code>S3BucketName</code>
    /// </p>
    pub s3_bucket_folder: std::option::Option<std::string::String>,
    /// <p>The number of milliseconds for DMS to wait to retry a bulk-load of migrated graph
    /// data to the Neptune target database before raising an error. The default is 250.</p>
    pub error_retry_duration: std::option::Option<i32>,
    /// <p>The maximum size in kilobytes of migrated graph data stored in a .csv file before DMS
    /// bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the
    /// bulk load is successful, DMS clears the bucket, ready to store the next batch of
    /// migrated graph data.</p>
    pub max_file_size: std::option::Option<i32>,
    /// <p>The number of times for DMS to retry a bulk load of migrated graph data to the
    /// Neptune target database before raising an error. The default is 5.</p>
    pub max_retry_count: std::option::Option<i32>,
    /// <p>If you want Identity and Access Management (IAM) authorization enabled for this
    /// endpoint, set this parameter to <code>true</code>. Then attach the appropriate IAM policy
    /// document to your service role specified by <code>ServiceAccessRoleArn</code>. The default
    /// is <code>false</code>.</p>
    pub iam_auth_enabled: std::option::Option<bool>,
}
impl NeptuneSettings {
    /// <p>The Amazon Resource Name (ARN) of the service role that you created for the Neptune
    /// target endpoint. The role must allow the <code>iam:PassRole</code> action.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <i>Database Migration Service User
    /// Guide. </i>
    /// </p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket where DMS can temporarily store migrated graph data
    /// in .csv files before bulk-loading it to the Neptune target database. DMS maps the SQL
    /// source data to graph data before storing it in these .csv files.</p>
    pub fn s3_bucket_name(&self) -> std::option::Option<&str> {
        self.s3_bucket_name.as_deref()
    }
    /// <p>A folder path where you want DMS to store migrated graph data in the S3 bucket
    /// specified by <code>S3BucketName</code>
    /// </p>
    pub fn s3_bucket_folder(&self) -> std::option::Option<&str> {
        self.s3_bucket_folder.as_deref()
    }
    /// <p>The number of milliseconds for DMS to wait to retry a bulk-load of migrated graph
    /// data to the Neptune target database before raising an error. The default is 250.</p>
    pub fn error_retry_duration(&self) -> std::option::Option<i32> {
        self.error_retry_duration
    }
    /// <p>The maximum size in kilobytes of migrated graph data stored in a .csv file before DMS
    /// bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the
    /// bulk load is successful, DMS clears the bucket, ready to store the next batch of
    /// migrated graph data.</p>
    pub fn max_file_size(&self) -> std::option::Option<i32> {
        self.max_file_size
    }
    /// <p>The number of times for DMS to retry a bulk load of migrated graph data to the
    /// Neptune target database before raising an error. The default is 5.</p>
    pub fn max_retry_count(&self) -> std::option::Option<i32> {
        self.max_retry_count
    }
    /// <p>If you want Identity and Access Management (IAM) authorization enabled for this
    /// endpoint, set this parameter to <code>true</code>. Then attach the appropriate IAM policy
    /// document to your service role specified by <code>ServiceAccessRoleArn</code>. The default
    /// is <code>false</code>.</p>
    pub fn iam_auth_enabled(&self) -> std::option::Option<bool> {
        self.iam_auth_enabled
    }
}
impl std::fmt::Debug for NeptuneSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NeptuneSettings");
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("s3_bucket_name", &self.s3_bucket_name);
        formatter.field("s3_bucket_folder", &self.s3_bucket_folder);
        formatter.field("error_retry_duration", &self.error_retry_duration);
        formatter.field("max_file_size", &self.max_file_size);
        formatter.field("max_retry_count", &self.max_retry_count);
        formatter.field("iam_auth_enabled", &self.iam_auth_enabled);
        formatter.finish()
    }
}
/// See [`NeptuneSettings`](crate::model::NeptuneSettings)
pub mod neptune_settings {
    /// A builder for [`NeptuneSettings`](crate::model::NeptuneSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_bucket_folder: std::option::Option<std::string::String>,
        pub(crate) error_retry_duration: std::option::Option<i32>,
        pub(crate) max_file_size: std::option::Option<i32>,
        pub(crate) max_retry_count: std::option::Option<i32>,
        pub(crate) iam_auth_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the service role that you created for the Neptune
        /// target endpoint. The role must allow the <code>iam:PassRole</code> action.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <i>Database Migration Service User
        /// Guide. </i>
        /// </p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the service role that you created for the Neptune
        /// target endpoint. The role must allow the <code>iam:PassRole</code> action.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole">Creating an IAM Service Role for Accessing Amazon Neptune as a Target</a> in the <i>Database Migration Service User
        /// Guide. </i>
        /// </p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket where DMS can temporarily store migrated graph data
        /// in .csv files before bulk-loading it to the Neptune target database. DMS maps the SQL
        /// source data to graph data before storing it in these .csv files.</p>
        pub fn s3_bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket where DMS can temporarily store migrated graph data
        /// in .csv files before bulk-loading it to the Neptune target database. DMS maps the SQL
        /// source data to graph data before storing it in these .csv files.</p>
        pub fn set_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_name = input;
            self
        }
        /// <p>A folder path where you want DMS to store migrated graph data in the S3 bucket
        /// specified by <code>S3BucketName</code>
        /// </p>
        pub fn s3_bucket_folder(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket_folder = Some(input.into());
            self
        }
        /// <p>A folder path where you want DMS to store migrated graph data in the S3 bucket
        /// specified by <code>S3BucketName</code>
        /// </p>
        pub fn set_s3_bucket_folder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_bucket_folder = input;
            self
        }
        /// <p>The number of milliseconds for DMS to wait to retry a bulk-load of migrated graph
        /// data to the Neptune target database before raising an error. The default is 250.</p>
        pub fn error_retry_duration(mut self, input: i32) -> Self {
            self.error_retry_duration = Some(input);
            self
        }
        /// <p>The number of milliseconds for DMS to wait to retry a bulk-load of migrated graph
        /// data to the Neptune target database before raising an error. The default is 250.</p>
        pub fn set_error_retry_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.error_retry_duration = input;
            self
        }
        /// <p>The maximum size in kilobytes of migrated graph data stored in a .csv file before DMS
        /// bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the
        /// bulk load is successful, DMS clears the bucket, ready to store the next batch of
        /// migrated graph data.</p>
        pub fn max_file_size(mut self, input: i32) -> Self {
            self.max_file_size = Some(input);
            self
        }
        /// <p>The maximum size in kilobytes of migrated graph data stored in a .csv file before DMS
        /// bulk-loads the data to the Neptune target database. The default is 1,048,576 KB. If the
        /// bulk load is successful, DMS clears the bucket, ready to store the next batch of
        /// migrated graph data.</p>
        pub fn set_max_file_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_file_size = input;
            self
        }
        /// <p>The number of times for DMS to retry a bulk load of migrated graph data to the
        /// Neptune target database before raising an error. The default is 5.</p>
        pub fn max_retry_count(mut self, input: i32) -> Self {
            self.max_retry_count = Some(input);
            self
        }
        /// <p>The number of times for DMS to retry a bulk load of migrated graph data to the
        /// Neptune target database before raising an error. The default is 5.</p>
        pub fn set_max_retry_count(mut self, input: std::option::Option<i32>) -> Self {
            self.max_retry_count = input;
            self
        }
        /// <p>If you want Identity and Access Management (IAM) authorization enabled for this
        /// endpoint, set this parameter to <code>true</code>. Then attach the appropriate IAM policy
        /// document to your service role specified by <code>ServiceAccessRoleArn</code>. The default
        /// is <code>false</code>.</p>
        pub fn iam_auth_enabled(mut self, input: bool) -> Self {
            self.iam_auth_enabled = Some(input);
            self
        }
        /// <p>If you want Identity and Access Management (IAM) authorization enabled for this
        /// endpoint, set this parameter to <code>true</code>. Then attach the appropriate IAM policy
        /// document to your service role specified by <code>ServiceAccessRoleArn</code>. The default
        /// is <code>false</code>.</p>
        pub fn set_iam_auth_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.iam_auth_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`NeptuneSettings`](crate::model::NeptuneSettings)
        pub fn build(self) -> crate::model::NeptuneSettings {
            crate::model::NeptuneSettings {
                service_access_role_arn: self.service_access_role_arn,
                s3_bucket_name: self.s3_bucket_name,
                s3_bucket_folder: self.s3_bucket_folder,
                error_retry_duration: self.error_retry_duration,
                max_file_size: self.max_file_size,
                max_retry_count: self.max_retry_count,
                iam_auth_enabled: self.iam_auth_enabled,
            }
        }
    }
}
impl NeptuneSettings {
    /// Creates a new builder-style object to manufacture [`NeptuneSettings`](crate::model::NeptuneSettings)
    pub fn builder() -> crate::model::neptune_settings::Builder {
        crate::model::neptune_settings::Builder::default()
    }
}

/// <p>Provides information that defines an OpenSearch endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticsearchSettings {
    /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
    /// The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport
    /// protocol (http/https) is not specified.</p>
    pub endpoint_uri: std::option::Option<std::string::String>,
    /// <p>The maximum percentage of records that can fail to be written before a full load
    /// operation stops.</p>
    /// <p>To avoid early failure, this counter is only effective after 1000 records
    /// are transferred. OpenSearch also has the concept of error monitoring during the
    /// last 10 minutes of an Observation Window. If transfer of all records fail in the
    /// last 10 minutes, the full load operation stops. </p>
    pub full_load_error_percentage: std::option::Option<i32>,
    /// <p>The maximum number of seconds for which DMS retries failed API requests to the
    /// OpenSearch cluster.</p>
    pub error_retry_duration: std::option::Option<i32>,
}
impl ElasticsearchSettings {
    /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
    /// The role must allow the <code>iam:PassRole</code> action.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p>The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport
    /// protocol (http/https) is not specified.</p>
    pub fn endpoint_uri(&self) -> std::option::Option<&str> {
        self.endpoint_uri.as_deref()
    }
    /// <p>The maximum percentage of records that can fail to be written before a full load
    /// operation stops.</p>
    /// <p>To avoid early failure, this counter is only effective after 1000 records
    /// are transferred. OpenSearch also has the concept of error monitoring during the
    /// last 10 minutes of an Observation Window. If transfer of all records fail in the
    /// last 10 minutes, the full load operation stops. </p>
    pub fn full_load_error_percentage(&self) -> std::option::Option<i32> {
        self.full_load_error_percentage
    }
    /// <p>The maximum number of seconds for which DMS retries failed API requests to the
    /// OpenSearch cluster.</p>
    pub fn error_retry_duration(&self) -> std::option::Option<i32> {
        self.error_retry_duration
    }
}
impl std::fmt::Debug for ElasticsearchSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticsearchSettings");
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("endpoint_uri", &self.endpoint_uri);
        formatter.field(
            "full_load_error_percentage",
            &self.full_load_error_percentage,
        );
        formatter.field("error_retry_duration", &self.error_retry_duration);
        formatter.finish()
    }
}
/// See [`ElasticsearchSettings`](crate::model::ElasticsearchSettings)
pub mod elasticsearch_settings {
    /// A builder for [`ElasticsearchSettings`](crate::model::ElasticsearchSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_uri: std::option::Option<std::string::String>,
        pub(crate) full_load_error_percentage: std::option::Option<i32>,
        pub(crate) error_retry_duration: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) used by the service to access the IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport
        /// protocol (http/https) is not specified.</p>
        pub fn endpoint_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_uri = Some(input.into());
            self
        }
        /// <p>The endpoint for the OpenSearch cluster. DMS uses HTTPS if a transport
        /// protocol (http/https) is not specified.</p>
        pub fn set_endpoint_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_uri = input;
            self
        }
        /// <p>The maximum percentage of records that can fail to be written before a full load
        /// operation stops.</p>
        /// <p>To avoid early failure, this counter is only effective after 1000 records
        /// are transferred. OpenSearch also has the concept of error monitoring during the
        /// last 10 minutes of an Observation Window. If transfer of all records fail in the
        /// last 10 minutes, the full load operation stops. </p>
        pub fn full_load_error_percentage(mut self, input: i32) -> Self {
            self.full_load_error_percentage = Some(input);
            self
        }
        /// <p>The maximum percentage of records that can fail to be written before a full load
        /// operation stops.</p>
        /// <p>To avoid early failure, this counter is only effective after 1000 records
        /// are transferred. OpenSearch also has the concept of error monitoring during the
        /// last 10 minutes of an Observation Window. If transfer of all records fail in the
        /// last 10 minutes, the full load operation stops. </p>
        pub fn set_full_load_error_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.full_load_error_percentage = input;
            self
        }
        /// <p>The maximum number of seconds for which DMS retries failed API requests to the
        /// OpenSearch cluster.</p>
        pub fn error_retry_duration(mut self, input: i32) -> Self {
            self.error_retry_duration = Some(input);
            self
        }
        /// <p>The maximum number of seconds for which DMS retries failed API requests to the
        /// OpenSearch cluster.</p>
        pub fn set_error_retry_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.error_retry_duration = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticsearchSettings`](crate::model::ElasticsearchSettings)
        pub fn build(self) -> crate::model::ElasticsearchSettings {
            crate::model::ElasticsearchSettings {
                service_access_role_arn: self.service_access_role_arn,
                endpoint_uri: self.endpoint_uri,
                full_load_error_percentage: self.full_load_error_percentage,
                error_retry_duration: self.error_retry_duration,
            }
        }
    }
}
impl ElasticsearchSettings {
    /// Creates a new builder-style object to manufacture [`ElasticsearchSettings`](crate::model::ElasticsearchSettings)
    pub fn builder() -> crate::model::elasticsearch_settings::Builder {
        crate::model::elasticsearch_settings::Builder::default()
    }
}

/// <p>Provides information that describes an Apache Kafka endpoint. This
/// information includes the output format of records applied to the endpoint and details of
/// transaction and control table data information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KafkaSettings {
    /// <p>A comma-separated list of one or more broker locations in your Kafka cluster that host your Kafka instance. Specify each broker location
    /// in the form <code>
    /// <i>broker-hostname-or-ip</i>:<i>port</i>
    /// </code>. For example, <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
    /// For more information and examples of specifying a list of broker locations,
    /// see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a target for Database Migration Service</a>
    /// in the <i>Database Migration Service User Guide</i>.
    /// </p>
    pub broker: std::option::Option<std::string::String>,
    /// <p>The topic to which you migrate the data. If you don't specify a topic, DMS
    /// specifies <code>"kafka-default-topic"</code> as the migration topic.</p>
    pub topic: std::option::Option<std::string::String>,
    /// <p>The output format for the records created on the endpoint. The message format is
    /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no
    /// tab).</p>
    pub message_format: std::option::Option<crate::model::MessageFormatValue>,
    /// <p>Provides detailed transaction information from the source database. This information
    /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
    /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
    /// offset within a transaction). The default is <code>false</code>.</p>
    pub include_transaction_details: std::option::Option<bool>,
    /// <p>Shows the partition value within the Kafka message output unless the partition type is
    /// <code>schema-table-type</code>. The default is <code>false</code>.</p>
    pub include_partition_value: std::option::Option<bool>,
    /// <p>Prefixes schema and table names to partition values, when the partition type is
    /// <code>primary-key-type</code>. Doing this increases data distribution among Kafka
    /// partitions. For example, suppose that a SysBench schema has thousands of tables and each
    /// table has only limited range for a primary key. In this case, the same primary key is sent
    /// from thousands of tables to the same partition, which causes throttling. The default is
    /// <code>false</code>.</p>
    pub partition_include_schema_table: std::option::Option<bool>,
    /// <p>Includes any data definition language (DDL) operations that change the table in the
    /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
    /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
    /// default is <code>false</code>.</p>
    pub include_table_alter_operations: std::option::Option<bool>,
    /// <p>Shows detailed control information for table definition, column definition, and table
    /// and column changes in the Kafka message output. The default is <code>false</code>.</p>
    pub include_control_details: std::option::Option<bool>,
    /// <p>The maximum size in bytes for records created on the endpoint The default is 1,000,000.</p>
    pub message_max_bytes: std::option::Option<i32>,
    /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
    pub include_null_and_empty: std::option::Option<bool>,
    /// <p>Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include
    /// <code>ssl-encryption</code>, <code>ssl-authentication</code>, and <code>sasl-ssl</code>.
    /// <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code>.</p>
    pub security_protocol: std::option::Option<crate::model::KafkaSecurityProtocol>,
    /// <p>The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.</p>
    pub ssl_client_certificate_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.</p>
    pub ssl_client_key_arn: std::option::Option<std::string::String>,
    /// <p> The password for the client private key used to securely connect to a Kafka target endpoint.</p>
    pub ssl_client_key_password: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that DMS uses
    /// to securely connect to your Kafka target endpoint.</p>
    pub ssl_ca_certificate_arn: std::option::Option<std::string::String>,
    /// <p> The secure user name you created when you first set up your MSK cluster to validate a
    /// client identity and make an encrypted connection between server and client using SASL-SSL
    /// authentication.</p>
    pub sasl_username: std::option::Option<std::string::String>,
    /// <p>The secure password you created when you first set up your MSK cluster to validate a client identity and
    /// make an encrypted connection between server and client using SASL-SSL authentication.</p>
    pub sasl_password: std::option::Option<std::string::String>,
    /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
    /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
    /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka
    /// target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data
    /// type columns without adding the '0x' prefix.</p>
    pub no_hex_prefix: std::option::Option<bool>,
}
impl KafkaSettings {
    /// <p>A comma-separated list of one or more broker locations in your Kafka cluster that host your Kafka instance. Specify each broker location
    /// in the form <code>
    /// <i>broker-hostname-or-ip</i>:<i>port</i>
    /// </code>. For example, <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
    /// For more information and examples of specifying a list of broker locations,
    /// see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a target for Database Migration Service</a>
    /// in the <i>Database Migration Service User Guide</i>.
    /// </p>
    pub fn broker(&self) -> std::option::Option<&str> {
        self.broker.as_deref()
    }
    /// <p>The topic to which you migrate the data. If you don't specify a topic, DMS
    /// specifies <code>"kafka-default-topic"</code> as the migration topic.</p>
    pub fn topic(&self) -> std::option::Option<&str> {
        self.topic.as_deref()
    }
    /// <p>The output format for the records created on the endpoint. The message format is
    /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no
    /// tab).</p>
    pub fn message_format(&self) -> std::option::Option<&crate::model::MessageFormatValue> {
        self.message_format.as_ref()
    }
    /// <p>Provides detailed transaction information from the source database. This information
    /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
    /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
    /// offset within a transaction). The default is <code>false</code>.</p>
    pub fn include_transaction_details(&self) -> std::option::Option<bool> {
        self.include_transaction_details
    }
    /// <p>Shows the partition value within the Kafka message output unless the partition type is
    /// <code>schema-table-type</code>. The default is <code>false</code>.</p>
    pub fn include_partition_value(&self) -> std::option::Option<bool> {
        self.include_partition_value
    }
    /// <p>Prefixes schema and table names to partition values, when the partition type is
    /// <code>primary-key-type</code>. Doing this increases data distribution among Kafka
    /// partitions. For example, suppose that a SysBench schema has thousands of tables and each
    /// table has only limited range for a primary key. In this case, the same primary key is sent
    /// from thousands of tables to the same partition, which causes throttling. The default is
    /// <code>false</code>.</p>
    pub fn partition_include_schema_table(&self) -> std::option::Option<bool> {
        self.partition_include_schema_table
    }
    /// <p>Includes any data definition language (DDL) operations that change the table in the
    /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
    /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
    /// default is <code>false</code>.</p>
    pub fn include_table_alter_operations(&self) -> std::option::Option<bool> {
        self.include_table_alter_operations
    }
    /// <p>Shows detailed control information for table definition, column definition, and table
    /// and column changes in the Kafka message output. The default is <code>false</code>.</p>
    pub fn include_control_details(&self) -> std::option::Option<bool> {
        self.include_control_details
    }
    /// <p>The maximum size in bytes for records created on the endpoint The default is 1,000,000.</p>
    pub fn message_max_bytes(&self) -> std::option::Option<i32> {
        self.message_max_bytes
    }
    /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
    pub fn include_null_and_empty(&self) -> std::option::Option<bool> {
        self.include_null_and_empty
    }
    /// <p>Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include
    /// <code>ssl-encryption</code>, <code>ssl-authentication</code>, and <code>sasl-ssl</code>.
    /// <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code>.</p>
    pub fn security_protocol(&self) -> std::option::Option<&crate::model::KafkaSecurityProtocol> {
        self.security_protocol.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.</p>
    pub fn ssl_client_certificate_arn(&self) -> std::option::Option<&str> {
        self.ssl_client_certificate_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.</p>
    pub fn ssl_client_key_arn(&self) -> std::option::Option<&str> {
        self.ssl_client_key_arn.as_deref()
    }
    /// <p> The password for the client private key used to securely connect to a Kafka target endpoint.</p>
    pub fn ssl_client_key_password(&self) -> std::option::Option<&str> {
        self.ssl_client_key_password.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that DMS uses
    /// to securely connect to your Kafka target endpoint.</p>
    pub fn ssl_ca_certificate_arn(&self) -> std::option::Option<&str> {
        self.ssl_ca_certificate_arn.as_deref()
    }
    /// <p> The secure user name you created when you first set up your MSK cluster to validate a
    /// client identity and make an encrypted connection between server and client using SASL-SSL
    /// authentication.</p>
    pub fn sasl_username(&self) -> std::option::Option<&str> {
        self.sasl_username.as_deref()
    }
    /// <p>The secure password you created when you first set up your MSK cluster to validate a client identity and
    /// make an encrypted connection between server and client using SASL-SSL authentication.</p>
    pub fn sasl_password(&self) -> std::option::Option<&str> {
        self.sasl_password.as_deref()
    }
    /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
    /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
    /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka
    /// target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data
    /// type columns without adding the '0x' prefix.</p>
    pub fn no_hex_prefix(&self) -> std::option::Option<bool> {
        self.no_hex_prefix
    }
}
impl std::fmt::Debug for KafkaSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KafkaSettings");
        formatter.field("broker", &self.broker);
        formatter.field("topic", &self.topic);
        formatter.field("message_format", &self.message_format);
        formatter.field(
            "include_transaction_details",
            &self.include_transaction_details,
        );
        formatter.field("include_partition_value", &self.include_partition_value);
        formatter.field(
            "partition_include_schema_table",
            &self.partition_include_schema_table,
        );
        formatter.field(
            "include_table_alter_operations",
            &self.include_table_alter_operations,
        );
        formatter.field("include_control_details", &self.include_control_details);
        formatter.field("message_max_bytes", &self.message_max_bytes);
        formatter.field("include_null_and_empty", &self.include_null_and_empty);
        formatter.field("security_protocol", &self.security_protocol);
        formatter.field(
            "ssl_client_certificate_arn",
            &self.ssl_client_certificate_arn,
        );
        formatter.field("ssl_client_key_arn", &self.ssl_client_key_arn);
        formatter.field(
            "ssl_client_key_password",
            &"*** Sensitive Data Redacted ***",
        );
        formatter.field("ssl_ca_certificate_arn", &self.ssl_ca_certificate_arn);
        formatter.field("sasl_username", &self.sasl_username);
        formatter.field("sasl_password", &"*** Sensitive Data Redacted ***");
        formatter.field("no_hex_prefix", &self.no_hex_prefix);
        formatter.finish()
    }
}
/// See [`KafkaSettings`](crate::model::KafkaSettings)
pub mod kafka_settings {
    /// A builder for [`KafkaSettings`](crate::model::KafkaSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) broker: std::option::Option<std::string::String>,
        pub(crate) topic: std::option::Option<std::string::String>,
        pub(crate) message_format: std::option::Option<crate::model::MessageFormatValue>,
        pub(crate) include_transaction_details: std::option::Option<bool>,
        pub(crate) include_partition_value: std::option::Option<bool>,
        pub(crate) partition_include_schema_table: std::option::Option<bool>,
        pub(crate) include_table_alter_operations: std::option::Option<bool>,
        pub(crate) include_control_details: std::option::Option<bool>,
        pub(crate) message_max_bytes: std::option::Option<i32>,
        pub(crate) include_null_and_empty: std::option::Option<bool>,
        pub(crate) security_protocol: std::option::Option<crate::model::KafkaSecurityProtocol>,
        pub(crate) ssl_client_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) ssl_client_key_arn: std::option::Option<std::string::String>,
        pub(crate) ssl_client_key_password: std::option::Option<std::string::String>,
        pub(crate) ssl_ca_certificate_arn: std::option::Option<std::string::String>,
        pub(crate) sasl_username: std::option::Option<std::string::String>,
        pub(crate) sasl_password: std::option::Option<std::string::String>,
        pub(crate) no_hex_prefix: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A comma-separated list of one or more broker locations in your Kafka cluster that host your Kafka instance. Specify each broker location
        /// in the form <code>
        /// <i>broker-hostname-or-ip</i>:<i>port</i>
        /// </code>. For example, <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
        /// For more information and examples of specifying a list of broker locations,
        /// see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a target for Database Migration Service</a>
        /// in the <i>Database Migration Service User Guide</i>.
        /// </p>
        pub fn broker(mut self, input: impl Into<std::string::String>) -> Self {
            self.broker = Some(input.into());
            self
        }
        /// <p>A comma-separated list of one or more broker locations in your Kafka cluster that host your Kafka instance. Specify each broker location
        /// in the form <code>
        /// <i>broker-hostname-or-ip</i>:<i>port</i>
        /// </code>. For example, <code>"ec2-12-345-678-901.compute-1.amazonaws.com:2345"</code>.
        /// For more information and examples of specifying a list of broker locations,
        /// see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html">Using Apache Kafka as a target for Database Migration Service</a>
        /// in the <i>Database Migration Service User Guide</i>.
        /// </p>
        pub fn set_broker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.broker = input;
            self
        }
        /// <p>The topic to which you migrate the data. If you don't specify a topic, DMS
        /// specifies <code>"kafka-default-topic"</code> as the migration topic.</p>
        pub fn topic(mut self, input: impl Into<std::string::String>) -> Self {
            self.topic = Some(input.into());
            self
        }
        /// <p>The topic to which you migrate the data. If you don't specify a topic, DMS
        /// specifies <code>"kafka-default-topic"</code> as the migration topic.</p>
        pub fn set_topic(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.topic = input;
            self
        }
        /// <p>The output format for the records created on the endpoint. The message format is
        /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no
        /// tab).</p>
        pub fn message_format(mut self, input: crate::model::MessageFormatValue) -> Self {
            self.message_format = Some(input);
            self
        }
        /// <p>The output format for the records created on the endpoint. The message format is
        /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no
        /// tab).</p>
        pub fn set_message_format(
            mut self,
            input: std::option::Option<crate::model::MessageFormatValue>,
        ) -> Self {
            self.message_format = input;
            self
        }
        /// <p>Provides detailed transaction information from the source database. This information
        /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
        /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
        /// offset within a transaction). The default is <code>false</code>.</p>
        pub fn include_transaction_details(mut self, input: bool) -> Self {
            self.include_transaction_details = Some(input);
            self
        }
        /// <p>Provides detailed transaction information from the source database. This information
        /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
        /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
        /// offset within a transaction). The default is <code>false</code>.</p>
        pub fn set_include_transaction_details(mut self, input: std::option::Option<bool>) -> Self {
            self.include_transaction_details = input;
            self
        }
        /// <p>Shows the partition value within the Kafka message output unless the partition type is
        /// <code>schema-table-type</code>. The default is <code>false</code>.</p>
        pub fn include_partition_value(mut self, input: bool) -> Self {
            self.include_partition_value = Some(input);
            self
        }
        /// <p>Shows the partition value within the Kafka message output unless the partition type is
        /// <code>schema-table-type</code>. The default is <code>false</code>.</p>
        pub fn set_include_partition_value(mut self, input: std::option::Option<bool>) -> Self {
            self.include_partition_value = input;
            self
        }
        /// <p>Prefixes schema and table names to partition values, when the partition type is
        /// <code>primary-key-type</code>. Doing this increases data distribution among Kafka
        /// partitions. For example, suppose that a SysBench schema has thousands of tables and each
        /// table has only limited range for a primary key. In this case, the same primary key is sent
        /// from thousands of tables to the same partition, which causes throttling. The default is
        /// <code>false</code>.</p>
        pub fn partition_include_schema_table(mut self, input: bool) -> Self {
            self.partition_include_schema_table = Some(input);
            self
        }
        /// <p>Prefixes schema and table names to partition values, when the partition type is
        /// <code>primary-key-type</code>. Doing this increases data distribution among Kafka
        /// partitions. For example, suppose that a SysBench schema has thousands of tables and each
        /// table has only limited range for a primary key. In this case, the same primary key is sent
        /// from thousands of tables to the same partition, which causes throttling. The default is
        /// <code>false</code>.</p>
        pub fn set_partition_include_schema_table(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.partition_include_schema_table = input;
            self
        }
        /// <p>Includes any data definition language (DDL) operations that change the table in the
        /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
        /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
        /// default is <code>false</code>.</p>
        pub fn include_table_alter_operations(mut self, input: bool) -> Self {
            self.include_table_alter_operations = Some(input);
            self
        }
        /// <p>Includes any data definition language (DDL) operations that change the table in the
        /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
        /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
        /// default is <code>false</code>.</p>
        pub fn set_include_table_alter_operations(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_table_alter_operations = input;
            self
        }
        /// <p>Shows detailed control information for table definition, column definition, and table
        /// and column changes in the Kafka message output. The default is <code>false</code>.</p>
        pub fn include_control_details(mut self, input: bool) -> Self {
            self.include_control_details = Some(input);
            self
        }
        /// <p>Shows detailed control information for table definition, column definition, and table
        /// and column changes in the Kafka message output. The default is <code>false</code>.</p>
        pub fn set_include_control_details(mut self, input: std::option::Option<bool>) -> Self {
            self.include_control_details = input;
            self
        }
        /// <p>The maximum size in bytes for records created on the endpoint The default is 1,000,000.</p>
        pub fn message_max_bytes(mut self, input: i32) -> Self {
            self.message_max_bytes = Some(input);
            self
        }
        /// <p>The maximum size in bytes for records created on the endpoint The default is 1,000,000.</p>
        pub fn set_message_max_bytes(mut self, input: std::option::Option<i32>) -> Self {
            self.message_max_bytes = input;
            self
        }
        /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
        pub fn include_null_and_empty(mut self, input: bool) -> Self {
            self.include_null_and_empty = Some(input);
            self
        }
        /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
        pub fn set_include_null_and_empty(mut self, input: std::option::Option<bool>) -> Self {
            self.include_null_and_empty = input;
            self
        }
        /// <p>Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include
        /// <code>ssl-encryption</code>, <code>ssl-authentication</code>, and <code>sasl-ssl</code>.
        /// <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code>.</p>
        pub fn security_protocol(mut self, input: crate::model::KafkaSecurityProtocol) -> Self {
            self.security_protocol = Some(input);
            self
        }
        /// <p>Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include
        /// <code>ssl-encryption</code>, <code>ssl-authentication</code>, and <code>sasl-ssl</code>.
        /// <code>sasl-ssl</code> requires <code>SaslUsername</code> and <code>SaslPassword</code>.</p>
        pub fn set_security_protocol(
            mut self,
            input: std::option::Option<crate::model::KafkaSecurityProtocol>,
        ) -> Self {
            self.security_protocol = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.</p>
        pub fn ssl_client_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_client_certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the client certificate used to securely connect to a Kafka target endpoint.</p>
        pub fn set_ssl_client_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssl_client_certificate_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.</p>
        pub fn ssl_client_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_client_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the client private key used to securely connect to a Kafka target endpoint.</p>
        pub fn set_ssl_client_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssl_client_key_arn = input;
            self
        }
        /// <p> The password for the client private key used to securely connect to a Kafka target endpoint.</p>
        pub fn ssl_client_key_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_client_key_password = Some(input.into());
            self
        }
        /// <p> The password for the client private key used to securely connect to a Kafka target endpoint.</p>
        pub fn set_ssl_client_key_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssl_client_key_password = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that DMS uses
        /// to securely connect to your Kafka target endpoint.</p>
        pub fn ssl_ca_certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.ssl_ca_certificate_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the private certificate authority (CA) cert that DMS uses
        /// to securely connect to your Kafka target endpoint.</p>
        pub fn set_ssl_ca_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ssl_ca_certificate_arn = input;
            self
        }
        /// <p> The secure user name you created when you first set up your MSK cluster to validate a
        /// client identity and make an encrypted connection between server and client using SASL-SSL
        /// authentication.</p>
        pub fn sasl_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.sasl_username = Some(input.into());
            self
        }
        /// <p> The secure user name you created when you first set up your MSK cluster to validate a
        /// client identity and make an encrypted connection between server and client using SASL-SSL
        /// authentication.</p>
        pub fn set_sasl_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sasl_username = input;
            self
        }
        /// <p>The secure password you created when you first set up your MSK cluster to validate a client identity and
        /// make an encrypted connection between server and client using SASL-SSL authentication.</p>
        pub fn sasl_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.sasl_password = Some(input.into());
            self
        }
        /// <p>The secure password you created when you first set up your MSK cluster to validate a client identity and
        /// make an encrypted connection between server and client using SASL-SSL authentication.</p>
        pub fn set_sasl_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sasl_password = input;
            self
        }
        /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
        /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
        /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka
        /// target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data
        /// type columns without adding the '0x' prefix.</p>
        pub fn no_hex_prefix(mut self, input: bool) -> Self {
            self.no_hex_prefix = Some(input);
            self
        }
        /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
        /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
        /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka
        /// target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data
        /// type columns without adding the '0x' prefix.</p>
        pub fn set_no_hex_prefix(mut self, input: std::option::Option<bool>) -> Self {
            self.no_hex_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`KafkaSettings`](crate::model::KafkaSettings)
        pub fn build(self) -> crate::model::KafkaSettings {
            crate::model::KafkaSettings {
                broker: self.broker,
                topic: self.topic,
                message_format: self.message_format,
                include_transaction_details: self.include_transaction_details,
                include_partition_value: self.include_partition_value,
                partition_include_schema_table: self.partition_include_schema_table,
                include_table_alter_operations: self.include_table_alter_operations,
                include_control_details: self.include_control_details,
                message_max_bytes: self.message_max_bytes,
                include_null_and_empty: self.include_null_and_empty,
                security_protocol: self.security_protocol,
                ssl_client_certificate_arn: self.ssl_client_certificate_arn,
                ssl_client_key_arn: self.ssl_client_key_arn,
                ssl_client_key_password: self.ssl_client_key_password,
                ssl_ca_certificate_arn: self.ssl_ca_certificate_arn,
                sasl_username: self.sasl_username,
                sasl_password: self.sasl_password,
                no_hex_prefix: self.no_hex_prefix,
            }
        }
    }
}
impl KafkaSettings {
    /// Creates a new builder-style object to manufacture [`KafkaSettings`](crate::model::KafkaSettings)
    pub fn builder() -> crate::model::kafka_settings::Builder {
        crate::model::kafka_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KafkaSecurityProtocol {
    #[allow(missing_docs)] // documentation missing in model
    Plaintext,
    #[allow(missing_docs)] // documentation missing in model
    SaslSsl,
    #[allow(missing_docs)] // documentation missing in model
    SslAuthentication,
    #[allow(missing_docs)] // documentation missing in model
    SslEncryption,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KafkaSecurityProtocol {
    fn from(s: &str) -> Self {
        match s {
            "plaintext" => KafkaSecurityProtocol::Plaintext,
            "sasl-ssl" => KafkaSecurityProtocol::SaslSsl,
            "ssl-authentication" => KafkaSecurityProtocol::SslAuthentication,
            "ssl-encryption" => KafkaSecurityProtocol::SslEncryption,
            other => KafkaSecurityProtocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KafkaSecurityProtocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KafkaSecurityProtocol::from(s))
    }
}
impl KafkaSecurityProtocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KafkaSecurityProtocol::Plaintext => "plaintext",
            KafkaSecurityProtocol::SaslSsl => "sasl-ssl",
            KafkaSecurityProtocol::SslAuthentication => "ssl-authentication",
            KafkaSecurityProtocol::SslEncryption => "ssl-encryption",
            KafkaSecurityProtocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "plaintext",
            "sasl-ssl",
            "ssl-authentication",
            "ssl-encryption",
        ]
    }
}
impl AsRef<str> for KafkaSecurityProtocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MessageFormatValue {
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    JsonUnformatted,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MessageFormatValue {
    fn from(s: &str) -> Self {
        match s {
            "json" => MessageFormatValue::Json,
            "json-unformatted" => MessageFormatValue::JsonUnformatted,
            other => MessageFormatValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MessageFormatValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MessageFormatValue::from(s))
    }
}
impl MessageFormatValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MessageFormatValue::Json => "json",
            MessageFormatValue::JsonUnformatted => "json-unformatted",
            MessageFormatValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["json", "json-unformatted"]
    }
}
impl AsRef<str> for MessageFormatValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information that describes an Amazon Kinesis Data Stream endpoint. This
/// information includes the output format of records applied to the endpoint and details of
/// transaction and control table data information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KinesisSettings {
    /// <p>The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.</p>
    pub stream_arn: std::option::Option<std::string::String>,
    /// <p>The output format for the records created on the endpoint. The message format is
    /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).</p>
    pub message_format: std::option::Option<crate::model::MessageFormatValue>,
    /// <p>The Amazon Resource Name (ARN) for the IAM role
    /// that DMS uses to write to the Kinesis data stream.
    /// The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Provides detailed transaction information from the source database. This information
    /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
    /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
    /// offset within a transaction). The default is <code>false</code>.</p>
    pub include_transaction_details: std::option::Option<bool>,
    /// <p>Shows the partition value within the Kinesis message output, unless the partition type
    /// is <code>schema-table-type</code>. The default is <code>false</code>.</p>
    pub include_partition_value: std::option::Option<bool>,
    /// <p>Prefixes schema and table names to partition values, when the partition type is
    /// <code>primary-key-type</code>. Doing this increases data distribution among Kinesis
    /// shards. For example, suppose that a SysBench schema has thousands of tables and each table
    /// has only limited range for a primary key. In this case, the same primary key is sent from
    /// thousands of tables to the same shard, which causes throttling. The default is <code>false</code>.</p>
    pub partition_include_schema_table: std::option::Option<bool>,
    /// <p>Includes any data definition language (DDL) operations that change the table in the
    /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
    /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
    /// default is <code>false</code>.</p>
    pub include_table_alter_operations: std::option::Option<bool>,
    /// <p>Shows detailed control information for table definition, column definition, and table
    /// and column changes in the Kinesis message output. The default is <code>false</code>.</p>
    pub include_control_details: std::option::Option<bool>,
    /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
    pub include_null_and_empty: std::option::Option<bool>,
    /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
    /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
    /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to an
    /// Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable
    /// migration of RAW data type columns without adding the '0x' prefix.</p>
    pub no_hex_prefix: std::option::Option<bool>,
}
impl KinesisSettings {
    /// <p>The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.</p>
    pub fn stream_arn(&self) -> std::option::Option<&str> {
        self.stream_arn.as_deref()
    }
    /// <p>The output format for the records created on the endpoint. The message format is
    /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).</p>
    pub fn message_format(&self) -> std::option::Option<&crate::model::MessageFormatValue> {
        self.message_format.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the IAM role
    /// that DMS uses to write to the Kinesis data stream.
    /// The role must allow the <code>iam:PassRole</code> action.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p>Provides detailed transaction information from the source database. This information
    /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
    /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
    /// offset within a transaction). The default is <code>false</code>.</p>
    pub fn include_transaction_details(&self) -> std::option::Option<bool> {
        self.include_transaction_details
    }
    /// <p>Shows the partition value within the Kinesis message output, unless the partition type
    /// is <code>schema-table-type</code>. The default is <code>false</code>.</p>
    pub fn include_partition_value(&self) -> std::option::Option<bool> {
        self.include_partition_value
    }
    /// <p>Prefixes schema and table names to partition values, when the partition type is
    /// <code>primary-key-type</code>. Doing this increases data distribution among Kinesis
    /// shards. For example, suppose that a SysBench schema has thousands of tables and each table
    /// has only limited range for a primary key. In this case, the same primary key is sent from
    /// thousands of tables to the same shard, which causes throttling. The default is <code>false</code>.</p>
    pub fn partition_include_schema_table(&self) -> std::option::Option<bool> {
        self.partition_include_schema_table
    }
    /// <p>Includes any data definition language (DDL) operations that change the table in the
    /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
    /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
    /// default is <code>false</code>.</p>
    pub fn include_table_alter_operations(&self) -> std::option::Option<bool> {
        self.include_table_alter_operations
    }
    /// <p>Shows detailed control information for table definition, column definition, and table
    /// and column changes in the Kinesis message output. The default is <code>false</code>.</p>
    pub fn include_control_details(&self) -> std::option::Option<bool> {
        self.include_control_details
    }
    /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
    pub fn include_null_and_empty(&self) -> std::option::Option<bool> {
        self.include_null_and_empty
    }
    /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
    /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
    /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to an
    /// Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable
    /// migration of RAW data type columns without adding the '0x' prefix.</p>
    pub fn no_hex_prefix(&self) -> std::option::Option<bool> {
        self.no_hex_prefix
    }
}
impl std::fmt::Debug for KinesisSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KinesisSettings");
        formatter.field("stream_arn", &self.stream_arn);
        formatter.field("message_format", &self.message_format);
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field(
            "include_transaction_details",
            &self.include_transaction_details,
        );
        formatter.field("include_partition_value", &self.include_partition_value);
        formatter.field(
            "partition_include_schema_table",
            &self.partition_include_schema_table,
        );
        formatter.field(
            "include_table_alter_operations",
            &self.include_table_alter_operations,
        );
        formatter.field("include_control_details", &self.include_control_details);
        formatter.field("include_null_and_empty", &self.include_null_and_empty);
        formatter.field("no_hex_prefix", &self.no_hex_prefix);
        formatter.finish()
    }
}
/// See [`KinesisSettings`](crate::model::KinesisSettings)
pub mod kinesis_settings {
    /// A builder for [`KinesisSettings`](crate::model::KinesisSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_arn: std::option::Option<std::string::String>,
        pub(crate) message_format: std::option::Option<crate::model::MessageFormatValue>,
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) include_transaction_details: std::option::Option<bool>,
        pub(crate) include_partition_value: std::option::Option<bool>,
        pub(crate) partition_include_schema_table: std::option::Option<bool>,
        pub(crate) include_table_alter_operations: std::option::Option<bool>,
        pub(crate) include_control_details: std::option::Option<bool>,
        pub(crate) include_null_and_empty: std::option::Option<bool>,
        pub(crate) no_hex_prefix: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.</p>
        pub fn stream_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.</p>
        pub fn set_stream_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_arn = input;
            self
        }
        /// <p>The output format for the records created on the endpoint. The message format is
        /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).</p>
        pub fn message_format(mut self, input: crate::model::MessageFormatValue) -> Self {
            self.message_format = Some(input);
            self
        }
        /// <p>The output format for the records created on the endpoint. The message format is
        /// <code>JSON</code> (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).</p>
        pub fn set_message_format(
            mut self,
            input: std::option::Option<crate::model::MessageFormatValue>,
        ) -> Self {
            self.message_format = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role
        /// that DMS uses to write to the Kinesis data stream.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role
        /// that DMS uses to write to the Kinesis data stream.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>Provides detailed transaction information from the source database. This information
        /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
        /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
        /// offset within a transaction). The default is <code>false</code>.</p>
        pub fn include_transaction_details(mut self, input: bool) -> Self {
            self.include_transaction_details = Some(input);
            self
        }
        /// <p>Provides detailed transaction information from the source database. This information
        /// includes a commit timestamp, a log position, and values for <code>transaction_id</code>,
        /// previous <code>transaction_id</code>, and <code>transaction_record_id</code> (the record
        /// offset within a transaction). The default is <code>false</code>.</p>
        pub fn set_include_transaction_details(mut self, input: std::option::Option<bool>) -> Self {
            self.include_transaction_details = input;
            self
        }
        /// <p>Shows the partition value within the Kinesis message output, unless the partition type
        /// is <code>schema-table-type</code>. The default is <code>false</code>.</p>
        pub fn include_partition_value(mut self, input: bool) -> Self {
            self.include_partition_value = Some(input);
            self
        }
        /// <p>Shows the partition value within the Kinesis message output, unless the partition type
        /// is <code>schema-table-type</code>. The default is <code>false</code>.</p>
        pub fn set_include_partition_value(mut self, input: std::option::Option<bool>) -> Self {
            self.include_partition_value = input;
            self
        }
        /// <p>Prefixes schema and table names to partition values, when the partition type is
        /// <code>primary-key-type</code>. Doing this increases data distribution among Kinesis
        /// shards. For example, suppose that a SysBench schema has thousands of tables and each table
        /// has only limited range for a primary key. In this case, the same primary key is sent from
        /// thousands of tables to the same shard, which causes throttling. The default is <code>false</code>.</p>
        pub fn partition_include_schema_table(mut self, input: bool) -> Self {
            self.partition_include_schema_table = Some(input);
            self
        }
        /// <p>Prefixes schema and table names to partition values, when the partition type is
        /// <code>primary-key-type</code>. Doing this increases data distribution among Kinesis
        /// shards. For example, suppose that a SysBench schema has thousands of tables and each table
        /// has only limited range for a primary key. In this case, the same primary key is sent from
        /// thousands of tables to the same shard, which causes throttling. The default is <code>false</code>.</p>
        pub fn set_partition_include_schema_table(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.partition_include_schema_table = input;
            self
        }
        /// <p>Includes any data definition language (DDL) operations that change the table in the
        /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
        /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
        /// default is <code>false</code>.</p>
        pub fn include_table_alter_operations(mut self, input: bool) -> Self {
            self.include_table_alter_operations = Some(input);
            self
        }
        /// <p>Includes any data definition language (DDL) operations that change the table in the
        /// control data, such as <code>rename-table</code>, <code>drop-table</code>,
        /// <code>add-column</code>, <code>drop-column</code>, and <code>rename-column</code>. The
        /// default is <code>false</code>.</p>
        pub fn set_include_table_alter_operations(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.include_table_alter_operations = input;
            self
        }
        /// <p>Shows detailed control information for table definition, column definition, and table
        /// and column changes in the Kinesis message output. The default is <code>false</code>.</p>
        pub fn include_control_details(mut self, input: bool) -> Self {
            self.include_control_details = Some(input);
            self
        }
        /// <p>Shows detailed control information for table definition, column definition, and table
        /// and column changes in the Kinesis message output. The default is <code>false</code>.</p>
        pub fn set_include_control_details(mut self, input: std::option::Option<bool>) -> Self {
            self.include_control_details = input;
            self
        }
        /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
        pub fn include_null_and_empty(mut self, input: bool) -> Self {
            self.include_null_and_empty = Some(input);
            self
        }
        /// <p>Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.</p>
        pub fn set_include_null_and_empty(mut self, input: std::option::Option<bool>) -> Self {
            self.include_null_and_empty = input;
            self
        }
        /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
        /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
        /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to an
        /// Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable
        /// migration of RAW data type columns without adding the '0x' prefix.</p>
        pub fn no_hex_prefix(mut self, input: bool) -> Self {
            self.no_hex_prefix = Some(input);
            self
        }
        /// <p>Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix
        /// to raw data in hexadecimal format. For example, by default, DMS adds a '0x'
        /// prefix to the LOB column type in hexadecimal format moving from an Oracle source to an
        /// Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable
        /// migration of RAW data type columns without adding the '0x' prefix.</p>
        pub fn set_no_hex_prefix(mut self, input: std::option::Option<bool>) -> Self {
            self.no_hex_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`KinesisSettings`](crate::model::KinesisSettings)
        pub fn build(self) -> crate::model::KinesisSettings {
            crate::model::KinesisSettings {
                stream_arn: self.stream_arn,
                message_format: self.message_format,
                service_access_role_arn: self.service_access_role_arn,
                include_transaction_details: self.include_transaction_details,
                include_partition_value: self.include_partition_value,
                partition_include_schema_table: self.partition_include_schema_table,
                include_table_alter_operations: self.include_table_alter_operations,
                include_control_details: self.include_control_details,
                include_null_and_empty: self.include_null_and_empty,
                no_hex_prefix: self.no_hex_prefix,
            }
        }
    }
}
impl KinesisSettings {
    /// Creates a new builder-style object to manufacture [`KinesisSettings`](crate::model::KinesisSettings)
    pub fn builder() -> crate::model::kinesis_settings::Builder {
        crate::model::kinesis_settings::Builder::default()
    }
}

/// <p>Provides information that defines a MongoDB endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MongoDbSettings {
    /// <p>The user name you use to access the MongoDB source endpoint. </p>
    pub username: std::option::Option<std::string::String>,
    /// <p> The password for the user account you use to access the MongoDB source endpoint.
    /// </p>
    pub password: std::option::Option<std::string::String>,
    /// <p> The name of the server on the MongoDB source endpoint. </p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p> The port value for the MongoDB source endpoint. </p>
    pub port: std::option::Option<i32>,
    /// <p> The database name on the MongoDB source endpoint. </p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p> The authentication type you use to access the MongoDB source endpoint.</p>
    /// <p>When when set to <code>"no"</code>, user name and password parameters are not used and
    /// can be empty. </p>
    pub auth_type: std::option::Option<crate::model::AuthTypeValue>,
    /// <p> The authentication mechanism you use to access the MongoDB source endpoint.</p>
    /// <p>For the default value, in MongoDB version 2.x, <code>"default"</code> is
    /// <code>"mongodb_cr"</code>. For MongoDB version 3.x or later, <code>"default"</code> is
    /// <code>"scram_sha_1"</code>. This setting isn't used when <code>AuthType</code> is
    /// set to <code>"no"</code>.</p>
    pub auth_mechanism: std::option::Option<crate::model::AuthMechanismValue>,
    /// <p> Specifies either document or table mode. </p>
    /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
    /// Specify <code>"one"</code> to use table mode.</p>
    pub nesting_level: std::option::Option<crate::model::NestingLevelValue>,
    /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
    /// <code>"none"</code>. </p>
    /// <p>Default value is <code>"false"</code>. </p>
    pub extract_doc_id: std::option::Option<std::string::String>,
    /// <p> Indicates the number of documents to preview to determine the document organization.
    /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
    /// <p>Must be a positive value greater than <code>0</code>. Default value is
    /// <code>1000</code>.</p>
    pub docs_to_investigate: std::option::Option<std::string::String>,
    /// <p> The MongoDB database name. This setting isn't used when <code>AuthType</code> is
    /// set to <code>"no"</code>. </p>
    /// <p>The default is <code>"admin"</code>.</p>
    pub auth_source: std::option::Option<std::string::String>,
    /// <p>The KMS key identifier that is used to encrypt the content on the replication
    /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key. KMS creates the default encryption key for
    /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the MongoDB endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub secrets_manager_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MongoDB endpoint connection details.</p>
    pub secrets_manager_secret_id: std::option::Option<std::string::String>,
}
impl MongoDbSettings {
    /// <p>The user name you use to access the MongoDB source endpoint. </p>
    pub fn username(&self) -> std::option::Option<&str> {
        self.username.as_deref()
    }
    /// <p> The password for the user account you use to access the MongoDB source endpoint.
    /// </p>
    pub fn password(&self) -> std::option::Option<&str> {
        self.password.as_deref()
    }
    /// <p> The name of the server on the MongoDB source endpoint. </p>
    pub fn server_name(&self) -> std::option::Option<&str> {
        self.server_name.as_deref()
    }
    /// <p> The port value for the MongoDB source endpoint. </p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p> The database name on the MongoDB source endpoint. </p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p> The authentication type you use to access the MongoDB source endpoint.</p>
    /// <p>When when set to <code>"no"</code>, user name and password parameters are not used and
    /// can be empty. </p>
    pub fn auth_type(&self) -> std::option::Option<&crate::model::AuthTypeValue> {
        self.auth_type.as_ref()
    }
    /// <p> The authentication mechanism you use to access the MongoDB source endpoint.</p>
    /// <p>For the default value, in MongoDB version 2.x, <code>"default"</code> is
    /// <code>"mongodb_cr"</code>. For MongoDB version 3.x or later, <code>"default"</code> is
    /// <code>"scram_sha_1"</code>. This setting isn't used when <code>AuthType</code> is
    /// set to <code>"no"</code>.</p>
    pub fn auth_mechanism(&self) -> std::option::Option<&crate::model::AuthMechanismValue> {
        self.auth_mechanism.as_ref()
    }
    /// <p> Specifies either document or table mode. </p>
    /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
    /// Specify <code>"one"</code> to use table mode.</p>
    pub fn nesting_level(&self) -> std::option::Option<&crate::model::NestingLevelValue> {
        self.nesting_level.as_ref()
    }
    /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
    /// <code>"none"</code>. </p>
    /// <p>Default value is <code>"false"</code>. </p>
    pub fn extract_doc_id(&self) -> std::option::Option<&str> {
        self.extract_doc_id.as_deref()
    }
    /// <p> Indicates the number of documents to preview to determine the document organization.
    /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
    /// <p>Must be a positive value greater than <code>0</code>. Default value is
    /// <code>1000</code>.</p>
    pub fn docs_to_investigate(&self) -> std::option::Option<&str> {
        self.docs_to_investigate.as_deref()
    }
    /// <p> The MongoDB database name. This setting isn't used when <code>AuthType</code> is
    /// set to <code>"no"</code>. </p>
    /// <p>The default is <code>"admin"</code>.</p>
    pub fn auth_source(&self) -> std::option::Option<&str> {
        self.auth_source.as_deref()
    }
    /// <p>The KMS key identifier that is used to encrypt the content on the replication
    /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key. KMS creates the default encryption key for
    /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
    /// trusted entity and grants the required permissions to access the value in
    /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
    /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the MongoDB endpoint.</p>
    /// <note>
    /// <p>You can specify one of two sets of values for these permissions. You can specify the
    /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
    /// clear-text values for <code>UserName</code>, <code>Password</code>,
    /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
    /// information on creating this <code>SecretsManagerSecret</code> and the
    /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
    /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
    /// resources</a> in the <i>Database Migration Service User
    /// Guide</i>.</p>
    /// </note>
    pub fn secrets_manager_access_role_arn(&self) -> std::option::Option<&str> {
        self.secrets_manager_access_role_arn.as_deref()
    }
    /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MongoDB endpoint connection details.</p>
    pub fn secrets_manager_secret_id(&self) -> std::option::Option<&str> {
        self.secrets_manager_secret_id.as_deref()
    }
}
impl std::fmt::Debug for MongoDbSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MongoDbSettings");
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("server_name", &self.server_name);
        formatter.field("port", &self.port);
        formatter.field("database_name", &self.database_name);
        formatter.field("auth_type", &self.auth_type);
        formatter.field("auth_mechanism", &self.auth_mechanism);
        formatter.field("nesting_level", &self.nesting_level);
        formatter.field("extract_doc_id", &self.extract_doc_id);
        formatter.field("docs_to_investigate", &self.docs_to_investigate);
        formatter.field("auth_source", &self.auth_source);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field(
            "secrets_manager_access_role_arn",
            &self.secrets_manager_access_role_arn,
        );
        formatter.field("secrets_manager_secret_id", &self.secrets_manager_secret_id);
        formatter.finish()
    }
}
/// See [`MongoDbSettings`](crate::model::MongoDbSettings)
pub mod mongo_db_settings {
    /// A builder for [`MongoDbSettings`](crate::model::MongoDbSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) auth_type: std::option::Option<crate::model::AuthTypeValue>,
        pub(crate) auth_mechanism: std::option::Option<crate::model::AuthMechanismValue>,
        pub(crate) nesting_level: std::option::Option<crate::model::NestingLevelValue>,
        pub(crate) extract_doc_id: std::option::Option<std::string::String>,
        pub(crate) docs_to_investigate: std::option::Option<std::string::String>,
        pub(crate) auth_source: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) secrets_manager_secret_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name you use to access the MongoDB source endpoint. </p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name you use to access the MongoDB source endpoint. </p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p> The password for the user account you use to access the MongoDB source endpoint.
        /// </p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p> The password for the user account you use to access the MongoDB source endpoint.
        /// </p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p> The name of the server on the MongoDB source endpoint. </p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p> The name of the server on the MongoDB source endpoint. </p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p> The port value for the MongoDB source endpoint. </p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p> The port value for the MongoDB source endpoint. </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p> The database name on the MongoDB source endpoint. </p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p> The database name on the MongoDB source endpoint. </p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p> The authentication type you use to access the MongoDB source endpoint.</p>
        /// <p>When when set to <code>"no"</code>, user name and password parameters are not used and
        /// can be empty. </p>
        pub fn auth_type(mut self, input: crate::model::AuthTypeValue) -> Self {
            self.auth_type = Some(input);
            self
        }
        /// <p> The authentication type you use to access the MongoDB source endpoint.</p>
        /// <p>When when set to <code>"no"</code>, user name and password parameters are not used and
        /// can be empty. </p>
        pub fn set_auth_type(
            mut self,
            input: std::option::Option<crate::model::AuthTypeValue>,
        ) -> Self {
            self.auth_type = input;
            self
        }
        /// <p> The authentication mechanism you use to access the MongoDB source endpoint.</p>
        /// <p>For the default value, in MongoDB version 2.x, <code>"default"</code> is
        /// <code>"mongodb_cr"</code>. For MongoDB version 3.x or later, <code>"default"</code> is
        /// <code>"scram_sha_1"</code>. This setting isn't used when <code>AuthType</code> is
        /// set to <code>"no"</code>.</p>
        pub fn auth_mechanism(mut self, input: crate::model::AuthMechanismValue) -> Self {
            self.auth_mechanism = Some(input);
            self
        }
        /// <p> The authentication mechanism you use to access the MongoDB source endpoint.</p>
        /// <p>For the default value, in MongoDB version 2.x, <code>"default"</code> is
        /// <code>"mongodb_cr"</code>. For MongoDB version 3.x or later, <code>"default"</code> is
        /// <code>"scram_sha_1"</code>. This setting isn't used when <code>AuthType</code> is
        /// set to <code>"no"</code>.</p>
        pub fn set_auth_mechanism(
            mut self,
            input: std::option::Option<crate::model::AuthMechanismValue>,
        ) -> Self {
            self.auth_mechanism = input;
            self
        }
        /// <p> Specifies either document or table mode. </p>
        /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
        /// Specify <code>"one"</code> to use table mode.</p>
        pub fn nesting_level(mut self, input: crate::model::NestingLevelValue) -> Self {
            self.nesting_level = Some(input);
            self
        }
        /// <p> Specifies either document or table mode. </p>
        /// <p>Default value is <code>"none"</code>. Specify <code>"none"</code> to use document mode.
        /// Specify <code>"one"</code> to use table mode.</p>
        pub fn set_nesting_level(
            mut self,
            input: std::option::Option<crate::model::NestingLevelValue>,
        ) -> Self {
            self.nesting_level = input;
            self
        }
        /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
        /// <code>"none"</code>. </p>
        /// <p>Default value is <code>"false"</code>. </p>
        pub fn extract_doc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.extract_doc_id = Some(input.into());
            self
        }
        /// <p> Specifies the document ID. Use this setting when <code>NestingLevel</code> is set to
        /// <code>"none"</code>. </p>
        /// <p>Default value is <code>"false"</code>. </p>
        pub fn set_extract_doc_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extract_doc_id = input;
            self
        }
        /// <p> Indicates the number of documents to preview to determine the document organization.
        /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
        /// <p>Must be a positive value greater than <code>0</code>. Default value is
        /// <code>1000</code>.</p>
        pub fn docs_to_investigate(mut self, input: impl Into<std::string::String>) -> Self {
            self.docs_to_investigate = Some(input.into());
            self
        }
        /// <p> Indicates the number of documents to preview to determine the document organization.
        /// Use this setting when <code>NestingLevel</code> is set to <code>"one"</code>. </p>
        /// <p>Must be a positive value greater than <code>0</code>. Default value is
        /// <code>1000</code>.</p>
        pub fn set_docs_to_investigate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.docs_to_investigate = input;
            self
        }
        /// <p> The MongoDB database name. This setting isn't used when <code>AuthType</code> is
        /// set to <code>"no"</code>. </p>
        /// <p>The default is <code>"admin"</code>.</p>
        pub fn auth_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.auth_source = Some(input.into());
            self
        }
        /// <p> The MongoDB database name. This setting isn't used when <code>AuthType</code> is
        /// set to <code>"no"</code>. </p>
        /// <p>The default is <code>"admin"</code>.</p>
        pub fn set_auth_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.auth_source = input;
            self
        }
        /// <p>The KMS key identifier that is used to encrypt the content on the replication
        /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key. KMS creates the default encryption key for
        /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The KMS key identifier that is used to encrypt the content on the replication
        /// instance. If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key. KMS creates the default encryption key for
        /// your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the MongoDB endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn secrets_manager_access_role_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = Some(input.into());
            self
        }
        /// <p>The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as the
        /// trusted entity and grants the required permissions to access the value in
        /// <code>SecretsManagerSecret</code>. The role must allow the <code>iam:PassRole</code> action.
        /// <code>SecretsManagerSecret</code> has the value of the Amazon Web Services Secrets Manager secret that allows access to the MongoDB endpoint.</p>
        /// <note>
        /// <p>You can specify one of two sets of values for these permissions. You can specify the
        /// values for this setting and <code>SecretsManagerSecretId</code>. Or you can specify
        /// clear-text values for <code>UserName</code>, <code>Password</code>,
        /// <code>ServerName</code>, and <code>Port</code>. You can't specify both. For more
        /// information on creating this <code>SecretsManagerSecret</code> and the
        /// <code>SecretsManagerAccessRoleArn</code> and <code>SecretsManagerSecretId</code>
        /// required to access it, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager">Using secrets to access Database Migration Service
        /// resources</a> in the <i>Database Migration Service User
        /// Guide</i>.</p>
        /// </note>
        pub fn set_secrets_manager_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_access_role_arn = input;
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MongoDB endpoint connection details.</p>
        pub fn secrets_manager_secret_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secrets_manager_secret_id = Some(input.into());
            self
        }
        /// <p>The full ARN, partial ARN, or friendly name of the <code>SecretsManagerSecret</code> that contains the MongoDB endpoint connection details.</p>
        pub fn set_secrets_manager_secret_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secrets_manager_secret_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MongoDbSettings`](crate::model::MongoDbSettings)
        pub fn build(self) -> crate::model::MongoDbSettings {
            crate::model::MongoDbSettings {
                username: self.username,
                password: self.password,
                server_name: self.server_name,
                port: self.port,
                database_name: self.database_name,
                auth_type: self.auth_type,
                auth_mechanism: self.auth_mechanism,
                nesting_level: self.nesting_level,
                extract_doc_id: self.extract_doc_id,
                docs_to_investigate: self.docs_to_investigate,
                auth_source: self.auth_source,
                kms_key_id: self.kms_key_id,
                secrets_manager_access_role_arn: self.secrets_manager_access_role_arn,
                secrets_manager_secret_id: self.secrets_manager_secret_id,
            }
        }
    }
}
impl MongoDbSettings {
    /// Creates a new builder-style object to manufacture [`MongoDbSettings`](crate::model::MongoDbSettings)
    pub fn builder() -> crate::model::mongo_db_settings::Builder {
        crate::model::mongo_db_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthMechanismValue {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    MongodbCr,
    #[allow(missing_docs)] // documentation missing in model
    ScramSha1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthMechanismValue {
    fn from(s: &str) -> Self {
        match s {
            "default" => AuthMechanismValue::Default,
            "mongodb_cr" => AuthMechanismValue::MongodbCr,
            "scram_sha_1" => AuthMechanismValue::ScramSha1,
            other => AuthMechanismValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthMechanismValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthMechanismValue::from(s))
    }
}
impl AuthMechanismValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthMechanismValue::Default => "default",
            AuthMechanismValue::MongodbCr => "mongodb_cr",
            AuthMechanismValue::ScramSha1 => "scram_sha_1",
            AuthMechanismValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["default", "mongodb_cr", "scram_sha_1"]
    }
}
impl AsRef<str> for AuthMechanismValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Password,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "no" => AuthTypeValue::No,
            "password" => AuthTypeValue::Password,
            other => AuthTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthTypeValue::from(s))
    }
}
impl AuthTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthTypeValue::No => "no",
            AuthTypeValue::Password => "password",
            AuthTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["no", "password"]
    }
}
impl AsRef<str> for AuthTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> The settings in JSON format for the DMS Transfer type source endpoint. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DmsTransferSettings {
    /// <p>The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p> The name of the S3 bucket to use. </p>
    pub bucket_name: std::option::Option<std::string::String>,
}
impl DmsTransferSettings {
    /// <p>The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p> The name of the S3 bucket to use. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
}
impl std::fmt::Debug for DmsTransferSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DmsTransferSettings");
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.finish()
    }
}
/// See [`DmsTransferSettings`](crate::model::DmsTransferSettings)
pub mod dms_transfer_settings {
    /// A builder for [`DmsTransferSettings`](crate::model::DmsTransferSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p> The name of the S3 bucket to use. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> The name of the S3 bucket to use. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DmsTransferSettings`](crate::model::DmsTransferSettings)
        pub fn build(self) -> crate::model::DmsTransferSettings {
            crate::model::DmsTransferSettings {
                service_access_role_arn: self.service_access_role_arn,
                bucket_name: self.bucket_name,
            }
        }
    }
}
impl DmsTransferSettings {
    /// Creates a new builder-style object to manufacture [`DmsTransferSettings`](crate::model::DmsTransferSettings)
    pub fn builder() -> crate::model::dms_transfer_settings::Builder {
        crate::model::dms_transfer_settings::Builder::default()
    }
}

/// <p>Settings for exporting data to Amazon S3. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Settings {
    /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role.
    /// The role must allow the <code>iam:PassRole</code> action. It is a required
    /// parameter that enables DMS to write and read objects from an S3 bucket.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p> Specifies how tables are defined in the S3 source files only. </p>
    pub external_table_definition: std::option::Option<std::string::String>,
    /// <p> The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage
    /// return (<code>\n</code>). </p>
    pub csv_row_delimiter: std::option::Option<std::string::String>,
    /// <p> The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
    /// </p>
    pub csv_delimiter: std::option::Option<std::string::String>,
    /// <p> An optional parameter to set a folder name in the S3 bucket. If provided, tables are
    /// created in the path
    /// <code>
    /// <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>.
    /// If this parameter isn't specified, then the path used is
    /// <code>
    /// <i>schema_name</i>/<i>table_name</i>/</code>. </p>
    pub bucket_folder: std::option::Option<std::string::String>,
    /// <p> The name of the S3 bucket. </p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>An optional parameter to use GZIP to compress the target files. Set to GZIP to compress
    /// the target files. Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed.
    /// This parameter applies to both .csv and .parquet file formats. </p>
    pub compression_type: std::option::Option<crate::model::CompressionTypeValue>,
    /// <p>The type of server-side encryption that you want to use for your data. This encryption
    /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
    /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
    /// <note>
    /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of
    /// the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
    /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
    /// to <code>SSE_KMS</code>.</p>
    /// </note>
    /// <p>To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role
    /// with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following
    /// actions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>s3:CreateBucket</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:ListBucket</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:DeleteBucket</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketLocation</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:PutObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:DeleteObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetObjectVersion</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketPolicy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:PutBucketPolicy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:DeleteBucketPolicy</code>
    /// </p>
    /// </li>
    /// </ul>
    pub encryption_mode: std::option::Option<crate::model::EncryptionModeValue>,
    /// <p>If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the
    /// KMS key ID. The key that you use needs an attached policy that enables Identity and Access Management
    /// (IAM) user permissions and allows use of the key.</p>
    /// <p>Here is a CLI example: <code>aws dms create-endpoint --endpoint-identifier
    /// <i>value</i> --endpoint-type target --engine-name s3 --s3-settings
    /// ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i>
    /// </code>
    /// </p>
    pub server_side_encryption_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The format of the data that you want to use for output. You can choose one of the
    /// following: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>csv</code> : This is a row-based file format with comma-separated values
    /// (.csv). </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format
    /// that features efficient compression and provides faster query response. </p>
    /// </li>
    /// </ul>
    pub data_format: std::option::Option<crate::model::DataFormatValue>,
    /// <p>The type of encoding you are using: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length
    /// encoding to store repeated values more efficiently. This is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAIN</code> doesn't use encoding at all. Values are stored as they
    /// are.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a
    /// given column. The dictionary is stored in a dictionary page for each column
    /// chunk.</p>
    /// </li>
    /// </ul>
    pub encoding_type: std::option::Option<crate::model::EncodingTypeValue>,
    /// <p>The maximum size of an encoded dictionary page of a column. If the dictionary page
    /// exceeds this, this column is stored using an encoding type of <code>PLAIN</code>. This
    /// parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page
    /// before it reverts to <code>PLAIN</code> encoding. This size is used for
    /// .parquet file format only. </p>
    pub dict_page_size_limit: std::option::Option<i32>,
    /// <p>The number of rows in a row group. A smaller row group size provides faster reads. But
    /// as the number of row groups grows, the slower writes become. This parameter defaults to
    /// 10,000 rows. This number is used for .parquet file format only. </p>
    /// <p>If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the
    /// max row group length in bytes (64 * 1024 * 1024). </p>
    pub row_group_length: std::option::Option<i32>,
    /// <p>The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB).
    /// This number is used for .parquet file format only. </p>
    pub data_page_size: std::option::Option<i32>,
    /// <p>The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code>
    /// (the default) or <code>parquet_2_0</code>.</p>
    pub parquet_version: std::option::Option<crate::model::ParquetVersionValue>,
    /// <p>A value that enables statistics for Parquet pages and row groups. Choose
    /// <code>true</code> to enable statistics, <code>false</code> to disable. Statistics
    /// include <code>NULL</code>, <code>DISTINCT</code>, <code>MAX</code>, and <code>MIN</code>
    /// values. This parameter defaults to <code>true</code>. This value is used for
    /// .parquet file format only.</p>
    pub enable_statistics: std::option::Option<bool>,
    /// <p>A value that enables a full load to write INSERT operations to the comma-separated value
    /// (.csv) output files only to indicate how the rows were added to the source database.</p>
    /// <note>
    /// <p>DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and
    /// later.</p>
    /// </note>
    /// <p>For full load, records can only be inserted. By default (the <code>false</code>
    /// setting), no information is recorded in these output files for a full load to indicate that
    /// the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set
    /// to <code>true</code> or <code>y</code>, the INSERT is recorded as an I annotation in the
    /// first field of the .csv file. This allows the format of your target records from a full
    /// load to be consistent with the target records from a CDC load.</p>
    /// <note>
    /// <p>This setting works together with the <code>CdcInsertsOnly</code> and the
    /// <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more
    /// information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service
    /// User Guide.</i>.</p>
    /// </note>
    pub include_op_for_full_load: std::option::Option<bool>,
    /// <p>A value that enables a change data capture (CDC) load to write only INSERT operations to
    /// .csv or columnar storage (.parquet) output files. By default (the
    /// <code>false</code> setting), the first field in a .csv or .parquet record contains the
    /// letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was
    /// inserted, updated, or deleted at the source database for a CDC load to the target.</p>
    /// <p>If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only
    /// INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format
    /// only, how these INSERTs are recorded depends on the value of
    /// <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
    /// <code>true</code>, the first field of every CDC record is set to I to indicate the
    /// INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to
    /// <code>false</code>, every CDC record is written without a first field to indicate the
    /// INSERT operation at the source. For more information about how these settings work
    /// together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
    ///
    /// <note>
    ///
    /// <p>DMS supports the interaction described preceding between the
    /// <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in
    /// versions 3.1.4 and later. </p>
    ///
    /// <p>
    /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
    /// both be set to <code>true</code> for the same endpoint. Set either
    /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
    /// for the same endpoint, but not both.</p>
    ///
    /// </note>
    pub cdc_inserts_only: std::option::Option<bool>,
    /// <p>A value that when nonblank causes DMS to add a column with timestamp information to
    /// the endpoint data for an Amazon S3 target.</p>
    /// <note>
    /// <p>DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.</p>
    /// </note>
    /// <p>DMS includes an additional <code>STRING</code> column in the
    /// .csv or .parquet object files of your migrated data when you set
    /// <code>TimestampColumnName</code> to a nonblank value.</p>
    /// <p>For a full load, each row of this timestamp column contains a
    /// timestamp for when the data was transferred from the source to
    /// the target by DMS. </p>
    /// <p>For a change data capture (CDC) load, each row of the timestamp column contains the
    /// timestamp for the commit of that row in the source
    /// database.</p>
    /// <p>The string format for this timestamp column value is
    /// <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
    /// precision of this value is in microseconds. For a CDC load, the
    /// rounding of the precision depends on the commit timestamp
    /// supported by DMS for the source database.</p>
    /// <p>When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also
    /// includes a name for the timestamp column that you set with
    /// <code>TimestampColumnName</code>.</p>
    pub timestamp_column_name: std::option::Option<std::string::String>,
    /// <p>A value that specifies the precision of any <code>TIMESTAMP</code> column values that
    /// are written to an Amazon S3 object file in .parquet format.</p>
    /// <note>
    /// <p>DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions
    /// 3.1.4 and later.</p>
    /// </note>
    /// <p>When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or
    /// <code>y</code>, DMS writes all <code>TIMESTAMP</code> columns in a .parquet
    /// formatted file with millisecond precision. Otherwise, DMS writes them with microsecond
    /// precision.</p>
    /// <p>Currently, Amazon Athena and Glue can handle only
    /// millisecond precision for <code>TIMESTAMP</code> values. Set
    /// this parameter to <code>true</code> for S3 endpoint object
    /// files that are .parquet formatted only if you plan to query or process the data with Athena or Glue.</p>
    /// <note>
    /// <p>DMS writes any <code>TIMESTAMP</code> column
    /// values written to an S3 file in .csv format with
    /// microsecond precision.</p>
    ///
    /// <p>Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string
    /// format of the timestamp column value that is inserted by setting the
    /// <code>TimestampColumnName</code> parameter.</p>
    /// </note>
    pub parquet_timestamp_in_millisecond: std::option::Option<bool>,
    /// <p>A value that enables a change data capture (CDC) load to write INSERT and UPDATE
    /// operations to .csv or .parquet (columnar storage) output files. The default setting is
    /// <code>false</code>, but when <code>CdcInsertsAndUpdates</code> is set to
    /// <code>true</code> or <code>y</code>, only INSERTs and UPDATEs from the source database
    /// are migrated to the .csv or .parquet file. </p>      
    /// <p>For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the
    /// value of the <code>IncludeOpForFullLoad</code> parameter. If
    /// <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every
    /// CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE
    /// operations at the source. But if <code>IncludeOpForFullLoad</code> is set to
    /// <code>false</code>, CDC records are written without an indication of INSERT or UPDATE
    /// operations at the source. For more information about how these settings work together, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
    /// <note>
    ///
    /// <p>DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in
    /// versions 3.3.1 and later.</p>
    ///
    /// <p>
    /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
    /// both be set to <code>true</code> for the same endpoint. Set either
    /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
    /// for the same endpoint, but not both.</p>
    ///
    /// </note>
    pub cdc_inserts_and_updates: std::option::Option<bool>,
    /// <p>When set to <code>true</code>, this parameter partitions S3 bucket folders based on
    /// transaction commit dates. The default value is <code>false</code>. For more information
    /// about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a>.</p>
    pub date_partition_enabled: std::option::Option<bool>,
    /// <p>Identifies the sequence of the date format to use during folder partitioning. The default value is
    /// <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
    pub date_partition_sequence: std::option::Option<crate::model::DatePartitionSequenceValue>,
    /// <p>Specifies a date separating delimiter to use during folder partitioning. The default value is
    /// <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
    pub date_partition_delimiter: std::option::Option<crate::model::DatePartitionDelimiterValue>,
    /// <p>This setting applies if the S3 output files during a change data capture (CDC) load are
    /// written in .csv format. If set to <code>true</code> for columns not included in the
    /// supplemental log, DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue">
    /// <code>CsvNoSupValue</code>
    /// </a>. If not set or set to
    /// <code>false</code>, DMS uses the null value for these columns.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
    /// </note>
    pub use_csv_no_sup_value: std::option::Option<bool>,
    /// <p>This setting only applies if your Amazon S3 output files during a change data capture
    /// (CDC) load are written in .csv format. If <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue">
    /// <code>UseCsvNoSupValue</code>
    /// </a> is set to true, specify a
    /// string value that you want DMS to use for all columns not included in the supplemental
    /// log. If you do not specify a string value, DMS uses the null value for these columns
    /// regardless of the <code>UseCsvNoSupValue</code> setting.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
    /// </note>
    pub csv_no_sup_value: std::option::Option<std::string::String>,
    /// <p>If set to <code>true</code>, DMS saves the transaction order for a change data
    /// capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
    /// <code>CdcPath</code>
    /// </a>. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
    /// target</a>.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
    /// </note>
    pub preserve_transactions: std::option::Option<bool>,
    /// <p>Specifies the folder path of CDC files. For an S3 source, this setting is required if a
    /// task captures change data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS
    /// reads CDC files from this path and replicates the data changes to the target endpoint.
    /// For an S3 target if you set <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions">
    /// <code>PreserveTransactions</code>
    /// </a> to <code>true</code>, DMS
    /// verifies that you have set this parameter to a folder path on your S3 target where DMS
    /// can save the transaction order for the CDC load. DMS creates this CDC folder path
    /// in either your S3 target working directory or the S3 target location specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder">
    /// <code>BucketFolder</code>
    /// </a> and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName">
    /// <code>BucketName</code>
    /// </a>.</p>
    /// <p>For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you
    /// specify <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify
    /// <code>BucketFolder</code>, DMS creates the CDC folder path following:
    /// <code>MyTargetBucket/MyChangedData</code>.</p>
    /// <p>If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
    /// <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>,
    /// DMS creates the CDC folder path following:
    /// <code>MyTargetBucket/MyTargetData/MyChangedData</code>.</p>
    /// <p>For more information on CDC including transaction order on an S3 target, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
    /// target</a>.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
    /// </note>
    pub cdc_path: std::option::Option<std::string::String>,
    /// <p>When set to true, this parameter uses the task start time as the timestamp column value instead of
    /// the time data is written to target. For full load, when <code>useTaskStartTimeForFullLoadTimestamp</code>
    /// is set to <code>true</code>, each row of the timestamp column contains the task start time. For CDC loads,
    /// each row of the timestamp column contains the transaction commit time.</p>
    ///
    /// <p>When <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>false</code>, the full load timestamp
    /// in the timestamp column increments with the time data arrives at the target. </p>
    pub use_task_start_time_for_full_load_timestamp: std::option::Option<bool>,
    /// <p>A value that enables DMS to specify a predefined (canned) access control list for
    /// objects created in an Amazon S3 bucket as .csv or .parquet files. For more information
    /// about Amazon S3 canned ACLs, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned
    /// ACL</a> in the <i>Amazon S3 Developer Guide.</i>
    /// </p>
    /// <p>The default value is NONE. Valid values include NONE, PRIVATE,
    /// PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ,
    /// AWS_EXEC_READ, BUCKET_OWNER_READ, and
    /// BUCKET_OWNER_FULL_CONTROL.</p>
    pub canned_acl_for_objects: std::option::Option<crate::model::CannedAclForObjectsValue>,
    /// <p>An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use
    /// to add column name information to the .csv output file.</p>
    /// <p>The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>,
    /// <code>y</code>, and <code>n</code>.</p>
    pub add_column_name: std::option::Option<bool>,
    /// <p>Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.</p>
    /// <p>When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the
    /// file write is triggered by whichever parameter condition is met first within an DMS
    /// CloudFormation template.</p>
    /// <p>The default value is 60 seconds.</p>
    pub cdc_max_batch_interval: std::option::Option<i32>,
    /// <p>Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.</p>
    /// <p>When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file
    /// write is triggered by whichever parameter condition is met first within an DMS
    /// CloudFormation template.</p>
    /// <p>The default value is 32 MB.</p>
    pub cdc_min_file_size: std::option::Option<i32>,
    /// <p>An optional parameter that specifies how DMS treats null
    /// values. While handling the null value, you can use this
    /// parameter to pass a user-defined string as null when writing to
    /// the target. For example, when target columns are not nullable,
    /// you can use this option to differentiate between the empty
    /// string value and the null value. So, if you set this parameter
    /// value to the empty string ("" or ''), DMS treats the empty
    /// string as the null value instead of <code>NULL</code>.</p>
    /// <p>The default value is <code>NULL</code>. Valid values include any valid string.</p>
    pub csv_null_value: std::option::Option<std::string::String>,
    /// <p>When this value is set to 1, DMS ignores the first row header in a .csv file. A value
    /// of 1 turns on the feature; a value of 0 turns off the feature.</p>
    /// <p>The default is 0.</p>
    pub ignore_header_rows: std::option::Option<i32>,
    /// <p>A value that specifies the maximum size (in KB) of any .csv
    /// file to be created while migrating to an S3 target during full
    /// load.</p>
    /// <p>The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.</p>
    pub max_file_size: std::option::Option<i32>,
    /// <p>For an S3 source, when this value is set to <code>true</code> or <code>y</code>,
    /// each leading double quotation mark has to be followed by an
    /// ending double quotation mark. This formatting complies with RFC
    /// 4180. When this value is set to <code>false</code> or
    /// <code>n</code>, string literals are copied to the target as
    /// is. In this case, a delimiter (row or column) signals the end of
    /// the field. Thus, you can't use a delimiter as part of the
    /// string, because it signals the end of the value.</p>
    /// <p>For an S3 target, an optional parameter used to set behavior to comply with RFC
    /// 4180 for data migrated to Amazon S3 using .csv file format only. When this
    /// value is set to <code>true</code> or <code>y</code> using Amazon
    /// S3 as a target, if the data has quotation marks or newline
    /// characters in it, DMS encloses the entire column with an
    /// additional pair of double quotation marks ("). Every quotation
    /// mark within the data is repeated twice.</p>
    /// <p>The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
    /// <code>y</code>, and <code>n</code>.</p>
    pub rfc4180: std::option::Option<bool>,
    /// <p>When creating an S3 target endpoint, set <code>DatePartitionTimezone</code> to convert
    /// the current UTC time into a specified time zone. The conversion occurs when a date
    /// partition folder is created and a CDC filename is generated. The time zone format is Area/Location.
    /// Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>, as shown in the
    /// following example.</p>
    /// <p>
    /// <code>s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH",
    /// "DatePartitionDelimiter": "SLASH",
    /// "DatePartitionTimezone":"<i>Asia/Seoul</i>", "BucketName":
    /// "dms-nattarat-test"}'</code>
    /// </p>
    pub date_partition_timezone: std::option::Option<std::string::String>,
}
impl S3Settings {
    /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role.
    /// The role must allow the <code>iam:PassRole</code> action. It is a required
    /// parameter that enables DMS to write and read objects from an S3 bucket.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
    /// <p> Specifies how tables are defined in the S3 source files only. </p>
    pub fn external_table_definition(&self) -> std::option::Option<&str> {
        self.external_table_definition.as_deref()
    }
    /// <p> The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage
    /// return (<code>\n</code>). </p>
    pub fn csv_row_delimiter(&self) -> std::option::Option<&str> {
        self.csv_row_delimiter.as_deref()
    }
    /// <p> The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
    /// </p>
    pub fn csv_delimiter(&self) -> std::option::Option<&str> {
        self.csv_delimiter.as_deref()
    }
    /// <p> An optional parameter to set a folder name in the S3 bucket. If provided, tables are
    /// created in the path
    /// <code>
    /// <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>.
    /// If this parameter isn't specified, then the path used is
    /// <code>
    /// <i>schema_name</i>/<i>table_name</i>/</code>. </p>
    pub fn bucket_folder(&self) -> std::option::Option<&str> {
        self.bucket_folder.as_deref()
    }
    /// <p> The name of the S3 bucket. </p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>An optional parameter to use GZIP to compress the target files. Set to GZIP to compress
    /// the target files. Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed.
    /// This parameter applies to both .csv and .parquet file formats. </p>
    pub fn compression_type(&self) -> std::option::Option<&crate::model::CompressionTypeValue> {
        self.compression_type.as_ref()
    }
    /// <p>The type of server-side encryption that you want to use for your data. This encryption
    /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
    /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
    /// <note>
    /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of
    /// the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
    /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
    /// to <code>SSE_KMS</code>.</p>
    /// </note>
    /// <p>To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role
    /// with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following
    /// actions:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>s3:CreateBucket</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:ListBucket</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:DeleteBucket</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketLocation</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:PutObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:DeleteObject</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetObjectVersion</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:GetBucketPolicy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:PutBucketPolicy</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>s3:DeleteBucketPolicy</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn encryption_mode(&self) -> std::option::Option<&crate::model::EncryptionModeValue> {
        self.encryption_mode.as_ref()
    }
    /// <p>If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the
    /// KMS key ID. The key that you use needs an attached policy that enables Identity and Access Management
    /// (IAM) user permissions and allows use of the key.</p>
    /// <p>Here is a CLI example: <code>aws dms create-endpoint --endpoint-identifier
    /// <i>value</i> --endpoint-type target --engine-name s3 --s3-settings
    /// ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i>
    /// </code>
    /// </p>
    pub fn server_side_encryption_kms_key_id(&self) -> std::option::Option<&str> {
        self.server_side_encryption_kms_key_id.as_deref()
    }
    /// <p>The format of the data that you want to use for output. You can choose one of the
    /// following: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>csv</code> : This is a row-based file format with comma-separated values
    /// (.csv). </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format
    /// that features efficient compression and provides faster query response. </p>
    /// </li>
    /// </ul>
    pub fn data_format(&self) -> std::option::Option<&crate::model::DataFormatValue> {
        self.data_format.as_ref()
    }
    /// <p>The type of encoding you are using: </p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length
    /// encoding to store repeated values more efficiently. This is the default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAIN</code> doesn't use encoding at all. Values are stored as they
    /// are.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a
    /// given column. The dictionary is stored in a dictionary page for each column
    /// chunk.</p>
    /// </li>
    /// </ul>
    pub fn encoding_type(&self) -> std::option::Option<&crate::model::EncodingTypeValue> {
        self.encoding_type.as_ref()
    }
    /// <p>The maximum size of an encoded dictionary page of a column. If the dictionary page
    /// exceeds this, this column is stored using an encoding type of <code>PLAIN</code>. This
    /// parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page
    /// before it reverts to <code>PLAIN</code> encoding. This size is used for
    /// .parquet file format only. </p>
    pub fn dict_page_size_limit(&self) -> std::option::Option<i32> {
        self.dict_page_size_limit
    }
    /// <p>The number of rows in a row group. A smaller row group size provides faster reads. But
    /// as the number of row groups grows, the slower writes become. This parameter defaults to
    /// 10,000 rows. This number is used for .parquet file format only. </p>
    /// <p>If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the
    /// max row group length in bytes (64 * 1024 * 1024). </p>
    pub fn row_group_length(&self) -> std::option::Option<i32> {
        self.row_group_length
    }
    /// <p>The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB).
    /// This number is used for .parquet file format only. </p>
    pub fn data_page_size(&self) -> std::option::Option<i32> {
        self.data_page_size
    }
    /// <p>The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code>
    /// (the default) or <code>parquet_2_0</code>.</p>
    pub fn parquet_version(&self) -> std::option::Option<&crate::model::ParquetVersionValue> {
        self.parquet_version.as_ref()
    }
    /// <p>A value that enables statistics for Parquet pages and row groups. Choose
    /// <code>true</code> to enable statistics, <code>false</code> to disable. Statistics
    /// include <code>NULL</code>, <code>DISTINCT</code>, <code>MAX</code>, and <code>MIN</code>
    /// values. This parameter defaults to <code>true</code>. This value is used for
    /// .parquet file format only.</p>
    pub fn enable_statistics(&self) -> std::option::Option<bool> {
        self.enable_statistics
    }
    /// <p>A value that enables a full load to write INSERT operations to the comma-separated value
    /// (.csv) output files only to indicate how the rows were added to the source database.</p>
    /// <note>
    /// <p>DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and
    /// later.</p>
    /// </note>
    /// <p>For full load, records can only be inserted. By default (the <code>false</code>
    /// setting), no information is recorded in these output files for a full load to indicate that
    /// the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set
    /// to <code>true</code> or <code>y</code>, the INSERT is recorded as an I annotation in the
    /// first field of the .csv file. This allows the format of your target records from a full
    /// load to be consistent with the target records from a CDC load.</p>
    /// <note>
    /// <p>This setting works together with the <code>CdcInsertsOnly</code> and the
    /// <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more
    /// information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service
    /// User Guide.</i>.</p>
    /// </note>
    pub fn include_op_for_full_load(&self) -> std::option::Option<bool> {
        self.include_op_for_full_load
    }
    /// <p>A value that enables a change data capture (CDC) load to write only INSERT operations to
    /// .csv or columnar storage (.parquet) output files. By default (the
    /// <code>false</code> setting), the first field in a .csv or .parquet record contains the
    /// letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was
    /// inserted, updated, or deleted at the source database for a CDC load to the target.</p>
    /// <p>If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only
    /// INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format
    /// only, how these INSERTs are recorded depends on the value of
    /// <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
    /// <code>true</code>, the first field of every CDC record is set to I to indicate the
    /// INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to
    /// <code>false</code>, every CDC record is written without a first field to indicate the
    /// INSERT operation at the source. For more information about how these settings work
    /// together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
    ///
    /// <note>
    ///
    /// <p>DMS supports the interaction described preceding between the
    /// <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in
    /// versions 3.1.4 and later. </p>
    ///
    /// <p>
    /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
    /// both be set to <code>true</code> for the same endpoint. Set either
    /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
    /// for the same endpoint, but not both.</p>
    ///
    /// </note>
    pub fn cdc_inserts_only(&self) -> std::option::Option<bool> {
        self.cdc_inserts_only
    }
    /// <p>A value that when nonblank causes DMS to add a column with timestamp information to
    /// the endpoint data for an Amazon S3 target.</p>
    /// <note>
    /// <p>DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.</p>
    /// </note>
    /// <p>DMS includes an additional <code>STRING</code> column in the
    /// .csv or .parquet object files of your migrated data when you set
    /// <code>TimestampColumnName</code> to a nonblank value.</p>
    /// <p>For a full load, each row of this timestamp column contains a
    /// timestamp for when the data was transferred from the source to
    /// the target by DMS. </p>
    /// <p>For a change data capture (CDC) load, each row of the timestamp column contains the
    /// timestamp for the commit of that row in the source
    /// database.</p>
    /// <p>The string format for this timestamp column value is
    /// <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
    /// precision of this value is in microseconds. For a CDC load, the
    /// rounding of the precision depends on the commit timestamp
    /// supported by DMS for the source database.</p>
    /// <p>When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also
    /// includes a name for the timestamp column that you set with
    /// <code>TimestampColumnName</code>.</p>
    pub fn timestamp_column_name(&self) -> std::option::Option<&str> {
        self.timestamp_column_name.as_deref()
    }
    /// <p>A value that specifies the precision of any <code>TIMESTAMP</code> column values that
    /// are written to an Amazon S3 object file in .parquet format.</p>
    /// <note>
    /// <p>DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions
    /// 3.1.4 and later.</p>
    /// </note>
    /// <p>When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or
    /// <code>y</code>, DMS writes all <code>TIMESTAMP</code> columns in a .parquet
    /// formatted file with millisecond precision. Otherwise, DMS writes them with microsecond
    /// precision.</p>
    /// <p>Currently, Amazon Athena and Glue can handle only
    /// millisecond precision for <code>TIMESTAMP</code> values. Set
    /// this parameter to <code>true</code> for S3 endpoint object
    /// files that are .parquet formatted only if you plan to query or process the data with Athena or Glue.</p>
    /// <note>
    /// <p>DMS writes any <code>TIMESTAMP</code> column
    /// values written to an S3 file in .csv format with
    /// microsecond precision.</p>
    ///
    /// <p>Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string
    /// format of the timestamp column value that is inserted by setting the
    /// <code>TimestampColumnName</code> parameter.</p>
    /// </note>
    pub fn parquet_timestamp_in_millisecond(&self) -> std::option::Option<bool> {
        self.parquet_timestamp_in_millisecond
    }
    /// <p>A value that enables a change data capture (CDC) load to write INSERT and UPDATE
    /// operations to .csv or .parquet (columnar storage) output files. The default setting is
    /// <code>false</code>, but when <code>CdcInsertsAndUpdates</code> is set to
    /// <code>true</code> or <code>y</code>, only INSERTs and UPDATEs from the source database
    /// are migrated to the .csv or .parquet file. </p>      
    /// <p>For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the
    /// value of the <code>IncludeOpForFullLoad</code> parameter. If
    /// <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every
    /// CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE
    /// operations at the source. But if <code>IncludeOpForFullLoad</code> is set to
    /// <code>false</code>, CDC records are written without an indication of INSERT or UPDATE
    /// operations at the source. For more information about how these settings work together, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
    /// <note>
    ///
    /// <p>DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in
    /// versions 3.3.1 and later.</p>
    ///
    /// <p>
    /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
    /// both be set to <code>true</code> for the same endpoint. Set either
    /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
    /// for the same endpoint, but not both.</p>
    ///
    /// </note>
    pub fn cdc_inserts_and_updates(&self) -> std::option::Option<bool> {
        self.cdc_inserts_and_updates
    }
    /// <p>When set to <code>true</code>, this parameter partitions S3 bucket folders based on
    /// transaction commit dates. The default value is <code>false</code>. For more information
    /// about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a>.</p>
    pub fn date_partition_enabled(&self) -> std::option::Option<bool> {
        self.date_partition_enabled
    }
    /// <p>Identifies the sequence of the date format to use during folder partitioning. The default value is
    /// <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
    pub fn date_partition_sequence(
        &self,
    ) -> std::option::Option<&crate::model::DatePartitionSequenceValue> {
        self.date_partition_sequence.as_ref()
    }
    /// <p>Specifies a date separating delimiter to use during folder partitioning. The default value is
    /// <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
    pub fn date_partition_delimiter(
        &self,
    ) -> std::option::Option<&crate::model::DatePartitionDelimiterValue> {
        self.date_partition_delimiter.as_ref()
    }
    /// <p>This setting applies if the S3 output files during a change data capture (CDC) load are
    /// written in .csv format. If set to <code>true</code> for columns not included in the
    /// supplemental log, DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue">
    /// <code>CsvNoSupValue</code>
    /// </a>. If not set or set to
    /// <code>false</code>, DMS uses the null value for these columns.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
    /// </note>
    pub fn use_csv_no_sup_value(&self) -> std::option::Option<bool> {
        self.use_csv_no_sup_value
    }
    /// <p>This setting only applies if your Amazon S3 output files during a change data capture
    /// (CDC) load are written in .csv format. If <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue">
    /// <code>UseCsvNoSupValue</code>
    /// </a> is set to true, specify a
    /// string value that you want DMS to use for all columns not included in the supplemental
    /// log. If you do not specify a string value, DMS uses the null value for these columns
    /// regardless of the <code>UseCsvNoSupValue</code> setting.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
    /// </note>
    pub fn csv_no_sup_value(&self) -> std::option::Option<&str> {
        self.csv_no_sup_value.as_deref()
    }
    /// <p>If set to <code>true</code>, DMS saves the transaction order for a change data
    /// capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
    /// <code>CdcPath</code>
    /// </a>. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
    /// target</a>.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
    /// </note>
    pub fn preserve_transactions(&self) -> std::option::Option<bool> {
        self.preserve_transactions
    }
    /// <p>Specifies the folder path of CDC files. For an S3 source, this setting is required if a
    /// task captures change data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS
    /// reads CDC files from this path and replicates the data changes to the target endpoint.
    /// For an S3 target if you set <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions">
    /// <code>PreserveTransactions</code>
    /// </a> to <code>true</code>, DMS
    /// verifies that you have set this parameter to a folder path on your S3 target where DMS
    /// can save the transaction order for the CDC load. DMS creates this CDC folder path
    /// in either your S3 target working directory or the S3 target location specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder">
    /// <code>BucketFolder</code>
    /// </a> and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName">
    /// <code>BucketName</code>
    /// </a>.</p>
    /// <p>For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you
    /// specify <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify
    /// <code>BucketFolder</code>, DMS creates the CDC folder path following:
    /// <code>MyTargetBucket/MyChangedData</code>.</p>
    /// <p>If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
    /// <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>,
    /// DMS creates the CDC folder path following:
    /// <code>MyTargetBucket/MyTargetData/MyChangedData</code>.</p>
    /// <p>For more information on CDC including transaction order on an S3 target, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
    /// target</a>.</p>
    /// <note>
    /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
    /// </note>
    pub fn cdc_path(&self) -> std::option::Option<&str> {
        self.cdc_path.as_deref()
    }
    /// <p>When set to true, this parameter uses the task start time as the timestamp column value instead of
    /// the time data is written to target. For full load, when <code>useTaskStartTimeForFullLoadTimestamp</code>
    /// is set to <code>true</code>, each row of the timestamp column contains the task start time. For CDC loads,
    /// each row of the timestamp column contains the transaction commit time.</p>
    ///
    /// <p>When <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>false</code>, the full load timestamp
    /// in the timestamp column increments with the time data arrives at the target. </p>
    pub fn use_task_start_time_for_full_load_timestamp(&self) -> std::option::Option<bool> {
        self.use_task_start_time_for_full_load_timestamp
    }
    /// <p>A value that enables DMS to specify a predefined (canned) access control list for
    /// objects created in an Amazon S3 bucket as .csv or .parquet files. For more information
    /// about Amazon S3 canned ACLs, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned
    /// ACL</a> in the <i>Amazon S3 Developer Guide.</i>
    /// </p>
    /// <p>The default value is NONE. Valid values include NONE, PRIVATE,
    /// PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ,
    /// AWS_EXEC_READ, BUCKET_OWNER_READ, and
    /// BUCKET_OWNER_FULL_CONTROL.</p>
    pub fn canned_acl_for_objects(
        &self,
    ) -> std::option::Option<&crate::model::CannedAclForObjectsValue> {
        self.canned_acl_for_objects.as_ref()
    }
    /// <p>An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use
    /// to add column name information to the .csv output file.</p>
    /// <p>The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>,
    /// <code>y</code>, and <code>n</code>.</p>
    pub fn add_column_name(&self) -> std::option::Option<bool> {
        self.add_column_name
    }
    /// <p>Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.</p>
    /// <p>When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the
    /// file write is triggered by whichever parameter condition is met first within an DMS
    /// CloudFormation template.</p>
    /// <p>The default value is 60 seconds.</p>
    pub fn cdc_max_batch_interval(&self) -> std::option::Option<i32> {
        self.cdc_max_batch_interval
    }
    /// <p>Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.</p>
    /// <p>When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file
    /// write is triggered by whichever parameter condition is met first within an DMS
    /// CloudFormation template.</p>
    /// <p>The default value is 32 MB.</p>
    pub fn cdc_min_file_size(&self) -> std::option::Option<i32> {
        self.cdc_min_file_size
    }
    /// <p>An optional parameter that specifies how DMS treats null
    /// values. While handling the null value, you can use this
    /// parameter to pass a user-defined string as null when writing to
    /// the target. For example, when target columns are not nullable,
    /// you can use this option to differentiate between the empty
    /// string value and the null value. So, if you set this parameter
    /// value to the empty string ("" or ''), DMS treats the empty
    /// string as the null value instead of <code>NULL</code>.</p>
    /// <p>The default value is <code>NULL</code>. Valid values include any valid string.</p>
    pub fn csv_null_value(&self) -> std::option::Option<&str> {
        self.csv_null_value.as_deref()
    }
    /// <p>When this value is set to 1, DMS ignores the first row header in a .csv file. A value
    /// of 1 turns on the feature; a value of 0 turns off the feature.</p>
    /// <p>The default is 0.</p>
    pub fn ignore_header_rows(&self) -> std::option::Option<i32> {
        self.ignore_header_rows
    }
    /// <p>A value that specifies the maximum size (in KB) of any .csv
    /// file to be created while migrating to an S3 target during full
    /// load.</p>
    /// <p>The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.</p>
    pub fn max_file_size(&self) -> std::option::Option<i32> {
        self.max_file_size
    }
    /// <p>For an S3 source, when this value is set to <code>true</code> or <code>y</code>,
    /// each leading double quotation mark has to be followed by an
    /// ending double quotation mark. This formatting complies with RFC
    /// 4180. When this value is set to <code>false</code> or
    /// <code>n</code>, string literals are copied to the target as
    /// is. In this case, a delimiter (row or column) signals the end of
    /// the field. Thus, you can't use a delimiter as part of the
    /// string, because it signals the end of the value.</p>
    /// <p>For an S3 target, an optional parameter used to set behavior to comply with RFC
    /// 4180 for data migrated to Amazon S3 using .csv file format only. When this
    /// value is set to <code>true</code> or <code>y</code> using Amazon
    /// S3 as a target, if the data has quotation marks or newline
    /// characters in it, DMS encloses the entire column with an
    /// additional pair of double quotation marks ("). Every quotation
    /// mark within the data is repeated twice.</p>
    /// <p>The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
    /// <code>y</code>, and <code>n</code>.</p>
    pub fn rfc4180(&self) -> std::option::Option<bool> {
        self.rfc4180
    }
    /// <p>When creating an S3 target endpoint, set <code>DatePartitionTimezone</code> to convert
    /// the current UTC time into a specified time zone. The conversion occurs when a date
    /// partition folder is created and a CDC filename is generated. The time zone format is Area/Location.
    /// Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>, as shown in the
    /// following example.</p>
    /// <p>
    /// <code>s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH",
    /// "DatePartitionDelimiter": "SLASH",
    /// "DatePartitionTimezone":"<i>Asia/Seoul</i>", "BucketName":
    /// "dms-nattarat-test"}'</code>
    /// </p>
    pub fn date_partition_timezone(&self) -> std::option::Option<&str> {
        self.date_partition_timezone.as_deref()
    }
}
impl std::fmt::Debug for S3Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Settings");
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("external_table_definition", &self.external_table_definition);
        formatter.field("csv_row_delimiter", &self.csv_row_delimiter);
        formatter.field("csv_delimiter", &self.csv_delimiter);
        formatter.field("bucket_folder", &self.bucket_folder);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("compression_type", &self.compression_type);
        formatter.field("encryption_mode", &self.encryption_mode);
        formatter.field(
            "server_side_encryption_kms_key_id",
            &self.server_side_encryption_kms_key_id,
        );
        formatter.field("data_format", &self.data_format);
        formatter.field("encoding_type", &self.encoding_type);
        formatter.field("dict_page_size_limit", &self.dict_page_size_limit);
        formatter.field("row_group_length", &self.row_group_length);
        formatter.field("data_page_size", &self.data_page_size);
        formatter.field("parquet_version", &self.parquet_version);
        formatter.field("enable_statistics", &self.enable_statistics);
        formatter.field("include_op_for_full_load", &self.include_op_for_full_load);
        formatter.field("cdc_inserts_only", &self.cdc_inserts_only);
        formatter.field("timestamp_column_name", &self.timestamp_column_name);
        formatter.field(
            "parquet_timestamp_in_millisecond",
            &self.parquet_timestamp_in_millisecond,
        );
        formatter.field("cdc_inserts_and_updates", &self.cdc_inserts_and_updates);
        formatter.field("date_partition_enabled", &self.date_partition_enabled);
        formatter.field("date_partition_sequence", &self.date_partition_sequence);
        formatter.field("date_partition_delimiter", &self.date_partition_delimiter);
        formatter.field("use_csv_no_sup_value", &self.use_csv_no_sup_value);
        formatter.field("csv_no_sup_value", &self.csv_no_sup_value);
        formatter.field("preserve_transactions", &self.preserve_transactions);
        formatter.field("cdc_path", &self.cdc_path);
        formatter.field(
            "use_task_start_time_for_full_load_timestamp",
            &self.use_task_start_time_for_full_load_timestamp,
        );
        formatter.field("canned_acl_for_objects", &self.canned_acl_for_objects);
        formatter.field("add_column_name", &self.add_column_name);
        formatter.field("cdc_max_batch_interval", &self.cdc_max_batch_interval);
        formatter.field("cdc_min_file_size", &self.cdc_min_file_size);
        formatter.field("csv_null_value", &self.csv_null_value);
        formatter.field("ignore_header_rows", &self.ignore_header_rows);
        formatter.field("max_file_size", &self.max_file_size);
        formatter.field("rfc4180", &self.rfc4180);
        formatter.field("date_partition_timezone", &self.date_partition_timezone);
        formatter.finish()
    }
}
/// See [`S3Settings`](crate::model::S3Settings)
pub mod s3_settings {
    /// A builder for [`S3Settings`](crate::model::S3Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) external_table_definition: std::option::Option<std::string::String>,
        pub(crate) csv_row_delimiter: std::option::Option<std::string::String>,
        pub(crate) csv_delimiter: std::option::Option<std::string::String>,
        pub(crate) bucket_folder: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) compression_type: std::option::Option<crate::model::CompressionTypeValue>,
        pub(crate) encryption_mode: std::option::Option<crate::model::EncryptionModeValue>,
        pub(crate) server_side_encryption_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) data_format: std::option::Option<crate::model::DataFormatValue>,
        pub(crate) encoding_type: std::option::Option<crate::model::EncodingTypeValue>,
        pub(crate) dict_page_size_limit: std::option::Option<i32>,
        pub(crate) row_group_length: std::option::Option<i32>,
        pub(crate) data_page_size: std::option::Option<i32>,
        pub(crate) parquet_version: std::option::Option<crate::model::ParquetVersionValue>,
        pub(crate) enable_statistics: std::option::Option<bool>,
        pub(crate) include_op_for_full_load: std::option::Option<bool>,
        pub(crate) cdc_inserts_only: std::option::Option<bool>,
        pub(crate) timestamp_column_name: std::option::Option<std::string::String>,
        pub(crate) parquet_timestamp_in_millisecond: std::option::Option<bool>,
        pub(crate) cdc_inserts_and_updates: std::option::Option<bool>,
        pub(crate) date_partition_enabled: std::option::Option<bool>,
        pub(crate) date_partition_sequence:
            std::option::Option<crate::model::DatePartitionSequenceValue>,
        pub(crate) date_partition_delimiter:
            std::option::Option<crate::model::DatePartitionDelimiterValue>,
        pub(crate) use_csv_no_sup_value: std::option::Option<bool>,
        pub(crate) csv_no_sup_value: std::option::Option<std::string::String>,
        pub(crate) preserve_transactions: std::option::Option<bool>,
        pub(crate) cdc_path: std::option::Option<std::string::String>,
        pub(crate) use_task_start_time_for_full_load_timestamp: std::option::Option<bool>,
        pub(crate) canned_acl_for_objects:
            std::option::Option<crate::model::CannedAclForObjectsValue>,
        pub(crate) add_column_name: std::option::Option<bool>,
        pub(crate) cdc_max_batch_interval: std::option::Option<i32>,
        pub(crate) cdc_min_file_size: std::option::Option<i32>,
        pub(crate) csv_null_value: std::option::Option<std::string::String>,
        pub(crate) ignore_header_rows: std::option::Option<i32>,
        pub(crate) max_file_size: std::option::Option<i32>,
        pub(crate) rfc4180: std::option::Option<bool>,
        pub(crate) date_partition_timezone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role.
        /// The role must allow the <code>iam:PassRole</code> action. It is a required
        /// parameter that enables DMS to write and read objects from an S3 bucket.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role.
        /// The role must allow the <code>iam:PassRole</code> action. It is a required
        /// parameter that enables DMS to write and read objects from an S3 bucket.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p> Specifies how tables are defined in the S3 source files only. </p>
        pub fn external_table_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_table_definition = Some(input.into());
            self
        }
        /// <p> Specifies how tables are defined in the S3 source files only. </p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_table_definition = input;
            self
        }
        /// <p> The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage
        /// return (<code>\n</code>). </p>
        pub fn csv_row_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.csv_row_delimiter = Some(input.into());
            self
        }
        /// <p> The delimiter used to separate rows in the .csv file for both source and target. The default is a carriage
        /// return (<code>\n</code>). </p>
        pub fn set_csv_row_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.csv_row_delimiter = input;
            self
        }
        /// <p> The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
        /// </p>
        pub fn csv_delimiter(mut self, input: impl Into<std::string::String>) -> Self {
            self.csv_delimiter = Some(input.into());
            self
        }
        /// <p> The delimiter used to separate columns in the .csv file for both source and target. The default is a comma.
        /// </p>
        pub fn set_csv_delimiter(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.csv_delimiter = input;
            self
        }
        /// <p> An optional parameter to set a folder name in the S3 bucket. If provided, tables are
        /// created in the path
        /// <code>
        /// <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>.
        /// If this parameter isn't specified, then the path used is
        /// <code>
        /// <i>schema_name</i>/<i>table_name</i>/</code>. </p>
        pub fn bucket_folder(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_folder = Some(input.into());
            self
        }
        /// <p> An optional parameter to set a folder name in the S3 bucket. If provided, tables are
        /// created in the path
        /// <code>
        /// <i>bucketFolder</i>/<i>schema_name</i>/<i>table_name</i>/</code>.
        /// If this parameter isn't specified, then the path used is
        /// <code>
        /// <i>schema_name</i>/<i>table_name</i>/</code>. </p>
        pub fn set_bucket_folder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_folder = input;
            self
        }
        /// <p> The name of the S3 bucket. </p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p> The name of the S3 bucket. </p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>An optional parameter to use GZIP to compress the target files. Set to GZIP to compress
        /// the target files. Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed.
        /// This parameter applies to both .csv and .parquet file formats. </p>
        pub fn compression_type(mut self, input: crate::model::CompressionTypeValue) -> Self {
            self.compression_type = Some(input);
            self
        }
        /// <p>An optional parameter to use GZIP to compress the target files. Set to GZIP to compress
        /// the target files. Either set this parameter to NONE (the default) or don't use it to leave the files uncompressed.
        /// This parameter applies to both .csv and .parquet file formats. </p>
        pub fn set_compression_type(
            mut self,
            input: std::option::Option<crate::model::CompressionTypeValue>,
        ) -> Self {
            self.compression_type = input;
            self
        }
        /// <p>The type of server-side encryption that you want to use for your data. This encryption
        /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
        /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
        /// <note>
        /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of
        /// the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
        /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
        /// to <code>SSE_KMS</code>.</p>
        /// </note>
        /// <p>To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role
        /// with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following
        /// actions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:CreateBucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListBucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:DeleteBucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:DeleteObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetObjectVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketPolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:PutBucketPolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:DeleteBucketPolicy</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn encryption_mode(mut self, input: crate::model::EncryptionModeValue) -> Self {
            self.encryption_mode = Some(input);
            self
        }
        /// <p>The type of server-side encryption that you want to use for your data. This encryption
        /// type is part of the endpoint settings or the extra connections attributes for Amazon S3.
        /// You can choose either <code>SSE_S3</code> (the default) or <code>SSE_KMS</code>. </p>
        /// <note>
        /// <p>For the <code>ModifyEndpoint</code> operation, you can change the existing value of
        /// the <code>EncryptionMode</code> parameter from <code>SSE_KMS</code> to
        /// <code>SSE_S3</code>. But you can’t change the existing value from <code>SSE_S3</code>
        /// to <code>SSE_KMS</code>.</p>
        /// </note>
        /// <p>To use <code>SSE_S3</code>, you need an Identity and Access Management (IAM) role
        /// with permission to allow <code>"arn:aws:s3:::dms-*"</code> to use the following
        /// actions:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>s3:CreateBucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:ListBucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:DeleteBucket</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketLocation</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:PutObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:DeleteObject</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetObjectVersion</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:GetBucketPolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:PutBucketPolicy</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>s3:DeleteBucketPolicy</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_encryption_mode(
            mut self,
            input: std::option::Option<crate::model::EncryptionModeValue>,
        ) -> Self {
            self.encryption_mode = input;
            self
        }
        /// <p>If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the
        /// KMS key ID. The key that you use needs an attached policy that enables Identity and Access Management
        /// (IAM) user permissions and allows use of the key.</p>
        /// <p>Here is a CLI example: <code>aws dms create-endpoint --endpoint-identifier
        /// <i>value</i> --endpoint-type target --engine-name s3 --s3-settings
        /// ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i>
        /// </code>
        /// </p>
        pub fn server_side_encryption_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.server_side_encryption_kms_key_id = Some(input.into());
            self
        }
        /// <p>If you are using <code>SSE_KMS</code> for the <code>EncryptionMode</code>, provide the
        /// KMS key ID. The key that you use needs an attached policy that enables Identity and Access Management
        /// (IAM) user permissions and allows use of the key.</p>
        /// <p>Here is a CLI example: <code>aws dms create-endpoint --endpoint-identifier
        /// <i>value</i> --endpoint-type target --engine-name s3 --s3-settings
        /// ServiceAccessRoleArn=<i>value</i>,BucketFolder=<i>value</i>,BucketName=<i>value</i>,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=<i>value</i>
        /// </code>
        /// </p>
        pub fn set_server_side_encryption_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.server_side_encryption_kms_key_id = input;
            self
        }
        /// <p>The format of the data that you want to use for output. You can choose one of the
        /// following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>csv</code> : This is a row-based file format with comma-separated values
        /// (.csv). </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format
        /// that features efficient compression and provides faster query response. </p>
        /// </li>
        /// </ul>
        pub fn data_format(mut self, input: crate::model::DataFormatValue) -> Self {
            self.data_format = Some(input);
            self
        }
        /// <p>The format of the data that you want to use for output. You can choose one of the
        /// following: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>csv</code> : This is a row-based file format with comma-separated values
        /// (.csv). </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>parquet</code> : Apache Parquet (.parquet) is a columnar storage file format
        /// that features efficient compression and provides faster query response. </p>
        /// </li>
        /// </ul>
        pub fn set_data_format(
            mut self,
            input: std::option::Option<crate::model::DataFormatValue>,
        ) -> Self {
            self.data_format = input;
            self
        }
        /// <p>The type of encoding you are using: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length
        /// encoding to store repeated values more efficiently. This is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAIN</code> doesn't use encoding at all. Values are stored as they
        /// are.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a
        /// given column. The dictionary is stored in a dictionary page for each column
        /// chunk.</p>
        /// </li>
        /// </ul>
        pub fn encoding_type(mut self, input: crate::model::EncodingTypeValue) -> Self {
            self.encoding_type = Some(input);
            self
        }
        /// <p>The type of encoding you are using: </p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>RLE_DICTIONARY</code> uses a combination of bit-packing and run-length
        /// encoding to store repeated values more efficiently. This is the default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAIN</code> doesn't use encoding at all. Values are stored as they
        /// are.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PLAIN_DICTIONARY</code> builds a dictionary of the values encountered in a
        /// given column. The dictionary is stored in a dictionary page for each column
        /// chunk.</p>
        /// </li>
        /// </ul>
        pub fn set_encoding_type(
            mut self,
            input: std::option::Option<crate::model::EncodingTypeValue>,
        ) -> Self {
            self.encoding_type = input;
            self
        }
        /// <p>The maximum size of an encoded dictionary page of a column. If the dictionary page
        /// exceeds this, this column is stored using an encoding type of <code>PLAIN</code>. This
        /// parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page
        /// before it reverts to <code>PLAIN</code> encoding. This size is used for
        /// .parquet file format only. </p>
        pub fn dict_page_size_limit(mut self, input: i32) -> Self {
            self.dict_page_size_limit = Some(input);
            self
        }
        /// <p>The maximum size of an encoded dictionary page of a column. If the dictionary page
        /// exceeds this, this column is stored using an encoding type of <code>PLAIN</code>. This
        /// parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of a dictionary page
        /// before it reverts to <code>PLAIN</code> encoding. This size is used for
        /// .parquet file format only. </p>
        pub fn set_dict_page_size_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.dict_page_size_limit = input;
            self
        }
        /// <p>The number of rows in a row group. A smaller row group size provides faster reads. But
        /// as the number of row groups grows, the slower writes become. This parameter defaults to
        /// 10,000 rows. This number is used for .parquet file format only. </p>
        /// <p>If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the
        /// max row group length in bytes (64 * 1024 * 1024). </p>
        pub fn row_group_length(mut self, input: i32) -> Self {
            self.row_group_length = Some(input);
            self
        }
        /// <p>The number of rows in a row group. A smaller row group size provides faster reads. But
        /// as the number of row groups grows, the slower writes become. This parameter defaults to
        /// 10,000 rows. This number is used for .parquet file format only. </p>
        /// <p>If you choose a value larger than the maximum, <code>RowGroupLength</code> is set to the
        /// max row group length in bytes (64 * 1024 * 1024). </p>
        pub fn set_row_group_length(mut self, input: std::option::Option<i32>) -> Self {
            self.row_group_length = input;
            self
        }
        /// <p>The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB).
        /// This number is used for .parquet file format only. </p>
        pub fn data_page_size(mut self, input: i32) -> Self {
            self.data_page_size = Some(input);
            self
        }
        /// <p>The size of one data page in bytes. This parameter defaults to 1024 * 1024 bytes (1 MiB).
        /// This number is used for .parquet file format only. </p>
        pub fn set_data_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.data_page_size = input;
            self
        }
        /// <p>The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code>
        /// (the default) or <code>parquet_2_0</code>.</p>
        pub fn parquet_version(mut self, input: crate::model::ParquetVersionValue) -> Self {
            self.parquet_version = Some(input);
            self
        }
        /// <p>The version of the Apache Parquet format that you want to use: <code>parquet_1_0</code>
        /// (the default) or <code>parquet_2_0</code>.</p>
        pub fn set_parquet_version(
            mut self,
            input: std::option::Option<crate::model::ParquetVersionValue>,
        ) -> Self {
            self.parquet_version = input;
            self
        }
        /// <p>A value that enables statistics for Parquet pages and row groups. Choose
        /// <code>true</code> to enable statistics, <code>false</code> to disable. Statistics
        /// include <code>NULL</code>, <code>DISTINCT</code>, <code>MAX</code>, and <code>MIN</code>
        /// values. This parameter defaults to <code>true</code>. This value is used for
        /// .parquet file format only.</p>
        pub fn enable_statistics(mut self, input: bool) -> Self {
            self.enable_statistics = Some(input);
            self
        }
        /// <p>A value that enables statistics for Parquet pages and row groups. Choose
        /// <code>true</code> to enable statistics, <code>false</code> to disable. Statistics
        /// include <code>NULL</code>, <code>DISTINCT</code>, <code>MAX</code>, and <code>MIN</code>
        /// values. This parameter defaults to <code>true</code>. This value is used for
        /// .parquet file format only.</p>
        pub fn set_enable_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_statistics = input;
            self
        }
        /// <p>A value that enables a full load to write INSERT operations to the comma-separated value
        /// (.csv) output files only to indicate how the rows were added to the source database.</p>
        /// <note>
        /// <p>DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and
        /// later.</p>
        /// </note>
        /// <p>For full load, records can only be inserted. By default (the <code>false</code>
        /// setting), no information is recorded in these output files for a full load to indicate that
        /// the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set
        /// to <code>true</code> or <code>y</code>, the INSERT is recorded as an I annotation in the
        /// first field of the .csv file. This allows the format of your target records from a full
        /// load to be consistent with the target records from a CDC load.</p>
        /// <note>
        /// <p>This setting works together with the <code>CdcInsertsOnly</code> and the
        /// <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more
        /// information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service
        /// User Guide.</i>.</p>
        /// </note>
        pub fn include_op_for_full_load(mut self, input: bool) -> Self {
            self.include_op_for_full_load = Some(input);
            self
        }
        /// <p>A value that enables a full load to write INSERT operations to the comma-separated value
        /// (.csv) output files only to indicate how the rows were added to the source database.</p>
        /// <note>
        /// <p>DMS supports the <code>IncludeOpForFullLoad</code> parameter in versions 3.1.4 and
        /// later.</p>
        /// </note>
        /// <p>For full load, records can only be inserted. By default (the <code>false</code>
        /// setting), no information is recorded in these output files for a full load to indicate that
        /// the rows were inserted at the source database. If <code>IncludeOpForFullLoad</code> is set
        /// to <code>true</code> or <code>y</code>, the INSERT is recorded as an I annotation in the
        /// first field of the .csv file. This allows the format of your target records from a full
        /// load to be consistent with the target records from a CDC load.</p>
        /// <note>
        /// <p>This setting works together with the <code>CdcInsertsOnly</code> and the
        /// <code>CdcInsertsAndUpdates</code> parameters for output to .csv files only. For more
        /// information about how these settings work together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service
        /// User Guide.</i>.</p>
        /// </note>
        pub fn set_include_op_for_full_load(mut self, input: std::option::Option<bool>) -> Self {
            self.include_op_for_full_load = input;
            self
        }
        /// <p>A value that enables a change data capture (CDC) load to write only INSERT operations to
        /// .csv or columnar storage (.parquet) output files. By default (the
        /// <code>false</code> setting), the first field in a .csv or .parquet record contains the
        /// letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was
        /// inserted, updated, or deleted at the source database for a CDC load to the target.</p>
        /// <p>If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only
        /// INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format
        /// only, how these INSERTs are recorded depends on the value of
        /// <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
        /// <code>true</code>, the first field of every CDC record is set to I to indicate the
        /// INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to
        /// <code>false</code>, every CDC record is written without a first field to indicate the
        /// INSERT operation at the source. For more information about how these settings work
        /// together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
        ///
        /// <note>
        ///
        /// <p>DMS supports the interaction described preceding between the
        /// <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in
        /// versions 3.1.4 and later. </p>
        ///
        /// <p>
        /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
        /// both be set to <code>true</code> for the same endpoint. Set either
        /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
        /// for the same endpoint, but not both.</p>
        ///
        /// </note>
        pub fn cdc_inserts_only(mut self, input: bool) -> Self {
            self.cdc_inserts_only = Some(input);
            self
        }
        /// <p>A value that enables a change data capture (CDC) load to write only INSERT operations to
        /// .csv or columnar storage (.parquet) output files. By default (the
        /// <code>false</code> setting), the first field in a .csv or .parquet record contains the
        /// letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether the row was
        /// inserted, updated, or deleted at the source database for a CDC load to the target.</p>
        /// <p>If <code>CdcInsertsOnly</code> is set to <code>true</code> or <code>y</code>, only
        /// INSERTs from the source database are migrated to the .csv or .parquet file. For .csv format
        /// only, how these INSERTs are recorded depends on the value of
        /// <code>IncludeOpForFullLoad</code>. If <code>IncludeOpForFullLoad</code> is set to
        /// <code>true</code>, the first field of every CDC record is set to I to indicate the
        /// INSERT operation at the source. If <code>IncludeOpForFullLoad</code> is set to
        /// <code>false</code>, every CDC record is written without a first field to indicate the
        /// INSERT operation at the source. For more information about how these settings work
        /// together, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
        ///
        /// <note>
        ///
        /// <p>DMS supports the interaction described preceding between the
        /// <code>CdcInsertsOnly</code> and <code>IncludeOpForFullLoad</code> parameters in
        /// versions 3.1.4 and later. </p>
        ///
        /// <p>
        /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
        /// both be set to <code>true</code> for the same endpoint. Set either
        /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
        /// for the same endpoint, but not both.</p>
        ///
        /// </note>
        pub fn set_cdc_inserts_only(mut self, input: std::option::Option<bool>) -> Self {
            self.cdc_inserts_only = input;
            self
        }
        /// <p>A value that when nonblank causes DMS to add a column with timestamp information to
        /// the endpoint data for an Amazon S3 target.</p>
        /// <note>
        /// <p>DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.</p>
        /// </note>
        /// <p>DMS includes an additional <code>STRING</code> column in the
        /// .csv or .parquet object files of your migrated data when you set
        /// <code>TimestampColumnName</code> to a nonblank value.</p>
        /// <p>For a full load, each row of this timestamp column contains a
        /// timestamp for when the data was transferred from the source to
        /// the target by DMS. </p>
        /// <p>For a change data capture (CDC) load, each row of the timestamp column contains the
        /// timestamp for the commit of that row in the source
        /// database.</p>
        /// <p>The string format for this timestamp column value is
        /// <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
        /// precision of this value is in microseconds. For a CDC load, the
        /// rounding of the precision depends on the commit timestamp
        /// supported by DMS for the source database.</p>
        /// <p>When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also
        /// includes a name for the timestamp column that you set with
        /// <code>TimestampColumnName</code>.</p>
        pub fn timestamp_column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp_column_name = Some(input.into());
            self
        }
        /// <p>A value that when nonblank causes DMS to add a column with timestamp information to
        /// the endpoint data for an Amazon S3 target.</p>
        /// <note>
        /// <p>DMS supports the <code>TimestampColumnName</code> parameter in versions 3.1.4 and later.</p>
        /// </note>
        /// <p>DMS includes an additional <code>STRING</code> column in the
        /// .csv or .parquet object files of your migrated data when you set
        /// <code>TimestampColumnName</code> to a nonblank value.</p>
        /// <p>For a full load, each row of this timestamp column contains a
        /// timestamp for when the data was transferred from the source to
        /// the target by DMS. </p>
        /// <p>For a change data capture (CDC) load, each row of the timestamp column contains the
        /// timestamp for the commit of that row in the source
        /// database.</p>
        /// <p>The string format for this timestamp column value is
        /// <code>yyyy-MM-dd HH:mm:ss.SSSSSS</code>. By default, the
        /// precision of this value is in microseconds. For a CDC load, the
        /// rounding of the precision depends on the commit timestamp
        /// supported by DMS for the source database.</p>
        /// <p>When the <code>AddColumnName</code> parameter is set to <code>true</code>, DMS also
        /// includes a name for the timestamp column that you set with
        /// <code>TimestampColumnName</code>.</p>
        pub fn set_timestamp_column_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timestamp_column_name = input;
            self
        }
        /// <p>A value that specifies the precision of any <code>TIMESTAMP</code> column values that
        /// are written to an Amazon S3 object file in .parquet format.</p>
        /// <note>
        /// <p>DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions
        /// 3.1.4 and later.</p>
        /// </note>
        /// <p>When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or
        /// <code>y</code>, DMS writes all <code>TIMESTAMP</code> columns in a .parquet
        /// formatted file with millisecond precision. Otherwise, DMS writes them with microsecond
        /// precision.</p>
        /// <p>Currently, Amazon Athena and Glue can handle only
        /// millisecond precision for <code>TIMESTAMP</code> values. Set
        /// this parameter to <code>true</code> for S3 endpoint object
        /// files that are .parquet formatted only if you plan to query or process the data with Athena or Glue.</p>
        /// <note>
        /// <p>DMS writes any <code>TIMESTAMP</code> column
        /// values written to an S3 file in .csv format with
        /// microsecond precision.</p>
        ///
        /// <p>Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string
        /// format of the timestamp column value that is inserted by setting the
        /// <code>TimestampColumnName</code> parameter.</p>
        /// </note>
        pub fn parquet_timestamp_in_millisecond(mut self, input: bool) -> Self {
            self.parquet_timestamp_in_millisecond = Some(input);
            self
        }
        /// <p>A value that specifies the precision of any <code>TIMESTAMP</code> column values that
        /// are written to an Amazon S3 object file in .parquet format.</p>
        /// <note>
        /// <p>DMS supports the <code>ParquetTimestampInMillisecond</code> parameter in versions
        /// 3.1.4 and later.</p>
        /// </note>
        /// <p>When <code>ParquetTimestampInMillisecond</code> is set to <code>true</code> or
        /// <code>y</code>, DMS writes all <code>TIMESTAMP</code> columns in a .parquet
        /// formatted file with millisecond precision. Otherwise, DMS writes them with microsecond
        /// precision.</p>
        /// <p>Currently, Amazon Athena and Glue can handle only
        /// millisecond precision for <code>TIMESTAMP</code> values. Set
        /// this parameter to <code>true</code> for S3 endpoint object
        /// files that are .parquet formatted only if you plan to query or process the data with Athena or Glue.</p>
        /// <note>
        /// <p>DMS writes any <code>TIMESTAMP</code> column
        /// values written to an S3 file in .csv format with
        /// microsecond precision.</p>
        ///
        /// <p>Setting <code>ParquetTimestampInMillisecond</code> has no effect on the string
        /// format of the timestamp column value that is inserted by setting the
        /// <code>TimestampColumnName</code> parameter.</p>
        /// </note>
        pub fn set_parquet_timestamp_in_millisecond(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.parquet_timestamp_in_millisecond = input;
            self
        }
        /// <p>A value that enables a change data capture (CDC) load to write INSERT and UPDATE
        /// operations to .csv or .parquet (columnar storage) output files. The default setting is
        /// <code>false</code>, but when <code>CdcInsertsAndUpdates</code> is set to
        /// <code>true</code> or <code>y</code>, only INSERTs and UPDATEs from the source database
        /// are migrated to the .csv or .parquet file. </p>      
        /// <p>For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the
        /// value of the <code>IncludeOpForFullLoad</code> parameter. If
        /// <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every
        /// CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE
        /// operations at the source. But if <code>IncludeOpForFullLoad</code> is set to
        /// <code>false</code>, CDC records are written without an indication of INSERT or UPDATE
        /// operations at the source. For more information about how these settings work together, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
        /// <note>
        ///
        /// <p>DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in
        /// versions 3.3.1 and later.</p>
        ///
        /// <p>
        /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
        /// both be set to <code>true</code> for the same endpoint. Set either
        /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
        /// for the same endpoint, but not both.</p>
        ///
        /// </note>
        pub fn cdc_inserts_and_updates(mut self, input: bool) -> Self {
            self.cdc_inserts_and_updates = Some(input);
            self
        }
        /// <p>A value that enables a change data capture (CDC) load to write INSERT and UPDATE
        /// operations to .csv or .parquet (columnar storage) output files. The default setting is
        /// <code>false</code>, but when <code>CdcInsertsAndUpdates</code> is set to
        /// <code>true</code> or <code>y</code>, only INSERTs and UPDATEs from the source database
        /// are migrated to the .csv or .parquet file. </p>      
        /// <p>For .csv file format only, how these INSERTs and UPDATEs are recorded depends on the
        /// value of the <code>IncludeOpForFullLoad</code> parameter. If
        /// <code>IncludeOpForFullLoad</code> is set to <code>true</code>, the first field of every
        /// CDC record is set to either <code>I</code> or <code>U</code> to indicate INSERT and UPDATE
        /// operations at the source. But if <code>IncludeOpForFullLoad</code> is set to
        /// <code>false</code>, CDC records are written without an indication of INSERT or UPDATE
        /// operations at the source. For more information about how these settings work together, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps">Indicating Source DB Operations in Migrated S3 Data</a> in the <i>Database Migration Service User Guide.</i>.</p>
        /// <note>
        ///
        /// <p>DMS supports the use of the <code>CdcInsertsAndUpdates</code> parameter in
        /// versions 3.3.1 and later.</p>
        ///
        /// <p>
        /// <code>CdcInsertsOnly</code> and <code>CdcInsertsAndUpdates</code> can't
        /// both be set to <code>true</code> for the same endpoint. Set either
        /// <code>CdcInsertsOnly</code> or <code>CdcInsertsAndUpdates</code> to <code>true</code>
        /// for the same endpoint, but not both.</p>
        ///
        /// </note>
        pub fn set_cdc_inserts_and_updates(mut self, input: std::option::Option<bool>) -> Self {
            self.cdc_inserts_and_updates = input;
            self
        }
        /// <p>When set to <code>true</code>, this parameter partitions S3 bucket folders based on
        /// transaction commit dates. The default value is <code>false</code>. For more information
        /// about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a>.</p>
        pub fn date_partition_enabled(mut self, input: bool) -> Self {
            self.date_partition_enabled = Some(input);
            self
        }
        /// <p>When set to <code>true</code>, this parameter partitions S3 bucket folders based on
        /// transaction commit dates. The default value is <code>false</code>. For more information
        /// about date-based folder partitioning, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning">Using date-based folder partitioning</a>.</p>
        pub fn set_date_partition_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.date_partition_enabled = input;
            self
        }
        /// <p>Identifies the sequence of the date format to use during folder partitioning. The default value is
        /// <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
        pub fn date_partition_sequence(
            mut self,
            input: crate::model::DatePartitionSequenceValue,
        ) -> Self {
            self.date_partition_sequence = Some(input);
            self
        }
        /// <p>Identifies the sequence of the date format to use during folder partitioning. The default value is
        /// <code>YYYYMMDD</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
        pub fn set_date_partition_sequence(
            mut self,
            input: std::option::Option<crate::model::DatePartitionSequenceValue>,
        ) -> Self {
            self.date_partition_sequence = input;
            self
        }
        /// <p>Specifies a date separating delimiter to use during folder partitioning. The default value is
        /// <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
        pub fn date_partition_delimiter(
            mut self,
            input: crate::model::DatePartitionDelimiterValue,
        ) -> Self {
            self.date_partition_delimiter = Some(input);
            self
        }
        /// <p>Specifies a date separating delimiter to use during folder partitioning. The default value is
        /// <code>SLASH</code>. Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>.</p>
        pub fn set_date_partition_delimiter(
            mut self,
            input: std::option::Option<crate::model::DatePartitionDelimiterValue>,
        ) -> Self {
            self.date_partition_delimiter = input;
            self
        }
        /// <p>This setting applies if the S3 output files during a change data capture (CDC) load are
        /// written in .csv format. If set to <code>true</code> for columns not included in the
        /// supplemental log, DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue">
        /// <code>CsvNoSupValue</code>
        /// </a>. If not set or set to
        /// <code>false</code>, DMS uses the null value for these columns.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
        /// </note>
        pub fn use_csv_no_sup_value(mut self, input: bool) -> Self {
            self.use_csv_no_sup_value = Some(input);
            self
        }
        /// <p>This setting applies if the S3 output files during a change data capture (CDC) load are
        /// written in .csv format. If set to <code>true</code> for columns not included in the
        /// supplemental log, DMS uses the value specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue">
        /// <code>CsvNoSupValue</code>
        /// </a>. If not set or set to
        /// <code>false</code>, DMS uses the null value for these columns.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
        /// </note>
        pub fn set_use_csv_no_sup_value(mut self, input: std::option::Option<bool>) -> Self {
            self.use_csv_no_sup_value = input;
            self
        }
        /// <p>This setting only applies if your Amazon S3 output files during a change data capture
        /// (CDC) load are written in .csv format. If <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue">
        /// <code>UseCsvNoSupValue</code>
        /// </a> is set to true, specify a
        /// string value that you want DMS to use for all columns not included in the supplemental
        /// log. If you do not specify a string value, DMS uses the null value for these columns
        /// regardless of the <code>UseCsvNoSupValue</code> setting.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
        /// </note>
        pub fn csv_no_sup_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.csv_no_sup_value = Some(input.into());
            self
        }
        /// <p>This setting only applies if your Amazon S3 output files during a change data capture
        /// (CDC) load are written in .csv format. If <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue">
        /// <code>UseCsvNoSupValue</code>
        /// </a> is set to true, specify a
        /// string value that you want DMS to use for all columns not included in the supplemental
        /// log. If you do not specify a string value, DMS uses the null value for these columns
        /// regardless of the <code>UseCsvNoSupValue</code> setting.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.1 and later.</p>
        /// </note>
        pub fn set_csv_no_sup_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.csv_no_sup_value = input;
            self
        }
        /// <p>If set to <code>true</code>, DMS saves the transaction order for a change data
        /// capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
        /// <code>CdcPath</code>
        /// </a>. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
        /// target</a>.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
        /// </note>
        pub fn preserve_transactions(mut self, input: bool) -> Self {
            self.preserve_transactions = Some(input);
            self
        }
        /// <p>If set to <code>true</code>, DMS saves the transaction order for a change data
        /// capture (CDC) load on the Amazon S3 target specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath">
        /// <code>CdcPath</code>
        /// </a>. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
        /// target</a>.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
        /// </note>
        pub fn set_preserve_transactions(mut self, input: std::option::Option<bool>) -> Self {
            self.preserve_transactions = input;
            self
        }
        /// <p>Specifies the folder path of CDC files. For an S3 source, this setting is required if a
        /// task captures change data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS
        /// reads CDC files from this path and replicates the data changes to the target endpoint.
        /// For an S3 target if you set <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions">
        /// <code>PreserveTransactions</code>
        /// </a> to <code>true</code>, DMS
        /// verifies that you have set this parameter to a folder path on your S3 target where DMS
        /// can save the transaction order for the CDC load. DMS creates this CDC folder path
        /// in either your S3 target working directory or the S3 target location specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder">
        /// <code>BucketFolder</code>
        /// </a> and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName">
        /// <code>BucketName</code>
        /// </a>.</p>
        /// <p>For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you
        /// specify <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify
        /// <code>BucketFolder</code>, DMS creates the CDC folder path following:
        /// <code>MyTargetBucket/MyChangedData</code>.</p>
        /// <p>If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
        /// <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>,
        /// DMS creates the CDC folder path following:
        /// <code>MyTargetBucket/MyTargetData/MyChangedData</code>.</p>
        /// <p>For more information on CDC including transaction order on an S3 target, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
        /// target</a>.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
        /// </note>
        pub fn cdc_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_path = Some(input.into());
            self
        }
        /// <p>Specifies the folder path of CDC files. For an S3 source, this setting is required if a
        /// task captures change data; otherwise, it's optional. If <code>CdcPath</code> is set, DMS
        /// reads CDC files from this path and replicates the data changes to the target endpoint.
        /// For an S3 target if you set <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions">
        /// <code>PreserveTransactions</code>
        /// </a> to <code>true</code>, DMS
        /// verifies that you have set this parameter to a folder path on your S3 target where DMS
        /// can save the transaction order for the CDC load. DMS creates this CDC folder path
        /// in either your S3 target working directory or the S3 target location specified by <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder">
        /// <code>BucketFolder</code>
        /// </a> and <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName">
        /// <code>BucketName</code>
        /// </a>.</p>
        /// <p>For example, if you specify <code>CdcPath</code> as <code>MyChangedData</code>, and you
        /// specify <code>BucketName</code> as <code>MyTargetBucket</code> but do not specify
        /// <code>BucketFolder</code>, DMS creates the CDC folder path following:
        /// <code>MyTargetBucket/MyChangedData</code>.</p>
        /// <p>If you specify the same <code>CdcPath</code>, and you specify <code>BucketName</code> as
        /// <code>MyTargetBucket</code> and <code>BucketFolder</code> as <code>MyTargetData</code>,
        /// DMS creates the CDC folder path following:
        /// <code>MyTargetBucket/MyTargetData/MyChangedData</code>.</p>
        /// <p>For more information on CDC including transaction order on an S3 target, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath">Capturing data changes (CDC) including transaction order on the S3
        /// target</a>.</p>
        /// <note>
        /// <p>This setting is supported in DMS versions 3.4.2 and later.</p>
        /// </note>
        pub fn set_cdc_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cdc_path = input;
            self
        }
        /// <p>When set to true, this parameter uses the task start time as the timestamp column value instead of
        /// the time data is written to target. For full load, when <code>useTaskStartTimeForFullLoadTimestamp</code>
        /// is set to <code>true</code>, each row of the timestamp column contains the task start time. For CDC loads,
        /// each row of the timestamp column contains the transaction commit time.</p>
        ///
        /// <p>When <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>false</code>, the full load timestamp
        /// in the timestamp column increments with the time data arrives at the target. </p>
        pub fn use_task_start_time_for_full_load_timestamp(mut self, input: bool) -> Self {
            self.use_task_start_time_for_full_load_timestamp = Some(input);
            self
        }
        /// <p>When set to true, this parameter uses the task start time as the timestamp column value instead of
        /// the time data is written to target. For full load, when <code>useTaskStartTimeForFullLoadTimestamp</code>
        /// is set to <code>true</code>, each row of the timestamp column contains the task start time. For CDC loads,
        /// each row of the timestamp column contains the transaction commit time.</p>
        ///
        /// <p>When <code>useTaskStartTimeForFullLoadTimestamp</code> is set to <code>false</code>, the full load timestamp
        /// in the timestamp column increments with the time data arrives at the target. </p>
        pub fn set_use_task_start_time_for_full_load_timestamp(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_task_start_time_for_full_load_timestamp = input;
            self
        }
        /// <p>A value that enables DMS to specify a predefined (canned) access control list for
        /// objects created in an Amazon S3 bucket as .csv or .parquet files. For more information
        /// about Amazon S3 canned ACLs, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned
        /// ACL</a> in the <i>Amazon S3 Developer Guide.</i>
        /// </p>
        /// <p>The default value is NONE. Valid values include NONE, PRIVATE,
        /// PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ,
        /// AWS_EXEC_READ, BUCKET_OWNER_READ, and
        /// BUCKET_OWNER_FULL_CONTROL.</p>
        pub fn canned_acl_for_objects(
            mut self,
            input: crate::model::CannedAclForObjectsValue,
        ) -> Self {
            self.canned_acl_for_objects = Some(input);
            self
        }
        /// <p>A value that enables DMS to specify a predefined (canned) access control list for
        /// objects created in an Amazon S3 bucket as .csv or .parquet files. For more information
        /// about Amazon S3 canned ACLs, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">Canned
        /// ACL</a> in the <i>Amazon S3 Developer Guide.</i>
        /// </p>
        /// <p>The default value is NONE. Valid values include NONE, PRIVATE,
        /// PUBLIC_READ, PUBLIC_READ_WRITE, AUTHENTICATED_READ,
        /// AWS_EXEC_READ, BUCKET_OWNER_READ, and
        /// BUCKET_OWNER_FULL_CONTROL.</p>
        pub fn set_canned_acl_for_objects(
            mut self,
            input: std::option::Option<crate::model::CannedAclForObjectsValue>,
        ) -> Self {
            self.canned_acl_for_objects = input;
            self
        }
        /// <p>An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use
        /// to add column name information to the .csv output file.</p>
        /// <p>The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>,
        /// <code>y</code>, and <code>n</code>.</p>
        pub fn add_column_name(mut self, input: bool) -> Self {
            self.add_column_name = Some(input);
            self
        }
        /// <p>An optional parameter that, when set to <code>true</code> or <code>y</code>, you can use
        /// to add column name information to the .csv output file.</p>
        /// <p>The default value is <code>false</code>. Valid values are <code>true</code>, <code>false</code>,
        /// <code>y</code>, and <code>n</code>.</p>
        pub fn set_add_column_name(mut self, input: std::option::Option<bool>) -> Self {
            self.add_column_name = input;
            self
        }
        /// <p>Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.</p>
        /// <p>When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the
        /// file write is triggered by whichever parameter condition is met first within an DMS
        /// CloudFormation template.</p>
        /// <p>The default value is 60 seconds.</p>
        pub fn cdc_max_batch_interval(mut self, input: i32) -> Self {
            self.cdc_max_batch_interval = Some(input);
            self
        }
        /// <p>Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3.</p>
        /// <p>When <code>CdcMaxBatchInterval</code> and <code>CdcMinFileSize</code> are both specified, the
        /// file write is triggered by whichever parameter condition is met first within an DMS
        /// CloudFormation template.</p>
        /// <p>The default value is 60 seconds.</p>
        pub fn set_cdc_max_batch_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.cdc_max_batch_interval = input;
            self
        }
        /// <p>Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.</p>
        /// <p>When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file
        /// write is triggered by whichever parameter condition is met first within an DMS
        /// CloudFormation template.</p>
        /// <p>The default value is 32 MB.</p>
        pub fn cdc_min_file_size(mut self, input: i32) -> Self {
            self.cdc_min_file_size = Some(input);
            self
        }
        /// <p>Minimum file size, defined in megabytes, to reach for a file output to Amazon S3.</p>
        /// <p>When <code>CdcMinFileSize</code> and <code>CdcMaxBatchInterval</code> are both specified, the file
        /// write is triggered by whichever parameter condition is met first within an DMS
        /// CloudFormation template.</p>
        /// <p>The default value is 32 MB.</p>
        pub fn set_cdc_min_file_size(mut self, input: std::option::Option<i32>) -> Self {
            self.cdc_min_file_size = input;
            self
        }
        /// <p>An optional parameter that specifies how DMS treats null
        /// values. While handling the null value, you can use this
        /// parameter to pass a user-defined string as null when writing to
        /// the target. For example, when target columns are not nullable,
        /// you can use this option to differentiate between the empty
        /// string value and the null value. So, if you set this parameter
        /// value to the empty string ("" or ''), DMS treats the empty
        /// string as the null value instead of <code>NULL</code>.</p>
        /// <p>The default value is <code>NULL</code>. Valid values include any valid string.</p>
        pub fn csv_null_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.csv_null_value = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies how DMS treats null
        /// values. While handling the null value, you can use this
        /// parameter to pass a user-defined string as null when writing to
        /// the target. For example, when target columns are not nullable,
        /// you can use this option to differentiate between the empty
        /// string value and the null value. So, if you set this parameter
        /// value to the empty string ("" or ''), DMS treats the empty
        /// string as the null value instead of <code>NULL</code>.</p>
        /// <p>The default value is <code>NULL</code>. Valid values include any valid string.</p>
        pub fn set_csv_null_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.csv_null_value = input;
            self
        }
        /// <p>When this value is set to 1, DMS ignores the first row header in a .csv file. A value
        /// of 1 turns on the feature; a value of 0 turns off the feature.</p>
        /// <p>The default is 0.</p>
        pub fn ignore_header_rows(mut self, input: i32) -> Self {
            self.ignore_header_rows = Some(input);
            self
        }
        /// <p>When this value is set to 1, DMS ignores the first row header in a .csv file. A value
        /// of 1 turns on the feature; a value of 0 turns off the feature.</p>
        /// <p>The default is 0.</p>
        pub fn set_ignore_header_rows(mut self, input: std::option::Option<i32>) -> Self {
            self.ignore_header_rows = input;
            self
        }
        /// <p>A value that specifies the maximum size (in KB) of any .csv
        /// file to be created while migrating to an S3 target during full
        /// load.</p>
        /// <p>The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.</p>
        pub fn max_file_size(mut self, input: i32) -> Self {
            self.max_file_size = Some(input);
            self
        }
        /// <p>A value that specifies the maximum size (in KB) of any .csv
        /// file to be created while migrating to an S3 target during full
        /// load.</p>
        /// <p>The default value is 1,048,576 KB (1 GB). Valid values include 1 to 1,048,576.</p>
        pub fn set_max_file_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_file_size = input;
            self
        }
        /// <p>For an S3 source, when this value is set to <code>true</code> or <code>y</code>,
        /// each leading double quotation mark has to be followed by an
        /// ending double quotation mark. This formatting complies with RFC
        /// 4180. When this value is set to <code>false</code> or
        /// <code>n</code>, string literals are copied to the target as
        /// is. In this case, a delimiter (row or column) signals the end of
        /// the field. Thus, you can't use a delimiter as part of the
        /// string, because it signals the end of the value.</p>
        /// <p>For an S3 target, an optional parameter used to set behavior to comply with RFC
        /// 4180 for data migrated to Amazon S3 using .csv file format only. When this
        /// value is set to <code>true</code> or <code>y</code> using Amazon
        /// S3 as a target, if the data has quotation marks or newline
        /// characters in it, DMS encloses the entire column with an
        /// additional pair of double quotation marks ("). Every quotation
        /// mark within the data is repeated twice.</p>
        /// <p>The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
        /// <code>y</code>, and <code>n</code>.</p>
        pub fn rfc4180(mut self, input: bool) -> Self {
            self.rfc4180 = Some(input);
            self
        }
        /// <p>For an S3 source, when this value is set to <code>true</code> or <code>y</code>,
        /// each leading double quotation mark has to be followed by an
        /// ending double quotation mark. This formatting complies with RFC
        /// 4180. When this value is set to <code>false</code> or
        /// <code>n</code>, string literals are copied to the target as
        /// is. In this case, a delimiter (row or column) signals the end of
        /// the field. Thus, you can't use a delimiter as part of the
        /// string, because it signals the end of the value.</p>
        /// <p>For an S3 target, an optional parameter used to set behavior to comply with RFC
        /// 4180 for data migrated to Amazon S3 using .csv file format only. When this
        /// value is set to <code>true</code> or <code>y</code> using Amazon
        /// S3 as a target, if the data has quotation marks or newline
        /// characters in it, DMS encloses the entire column with an
        /// additional pair of double quotation marks ("). Every quotation
        /// mark within the data is repeated twice.</p>
        /// <p>The default value is <code>true</code>. Valid values include <code>true</code>, <code>false</code>,
        /// <code>y</code>, and <code>n</code>.</p>
        pub fn set_rfc4180(mut self, input: std::option::Option<bool>) -> Self {
            self.rfc4180 = input;
            self
        }
        /// <p>When creating an S3 target endpoint, set <code>DatePartitionTimezone</code> to convert
        /// the current UTC time into a specified time zone. The conversion occurs when a date
        /// partition folder is created and a CDC filename is generated. The time zone format is Area/Location.
        /// Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>, as shown in the
        /// following example.</p>
        /// <p>
        /// <code>s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH",
        /// "DatePartitionDelimiter": "SLASH",
        /// "DatePartitionTimezone":"<i>Asia/Seoul</i>", "BucketName":
        /// "dms-nattarat-test"}'</code>
        /// </p>
        pub fn date_partition_timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.date_partition_timezone = Some(input.into());
            self
        }
        /// <p>When creating an S3 target endpoint, set <code>DatePartitionTimezone</code> to convert
        /// the current UTC time into a specified time zone. The conversion occurs when a date
        /// partition folder is created and a CDC filename is generated. The time zone format is Area/Location.
        /// Use this parameter when <code>DatePartitionedEnabled</code> is set to <code>true</code>, as shown in the
        /// following example.</p>
        /// <p>
        /// <code>s3-settings='{"DatePartitionEnabled": true, "DatePartitionSequence": "YYYYMMDDHH",
        /// "DatePartitionDelimiter": "SLASH",
        /// "DatePartitionTimezone":"<i>Asia/Seoul</i>", "BucketName":
        /// "dms-nattarat-test"}'</code>
        /// </p>
        pub fn set_date_partition_timezone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.date_partition_timezone = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Settings`](crate::model::S3Settings)
        pub fn build(self) -> crate::model::S3Settings {
            crate::model::S3Settings {
                service_access_role_arn: self.service_access_role_arn,
                external_table_definition: self.external_table_definition,
                csv_row_delimiter: self.csv_row_delimiter,
                csv_delimiter: self.csv_delimiter,
                bucket_folder: self.bucket_folder,
                bucket_name: self.bucket_name,
                compression_type: self.compression_type,
                encryption_mode: self.encryption_mode,
                server_side_encryption_kms_key_id: self.server_side_encryption_kms_key_id,
                data_format: self.data_format,
                encoding_type: self.encoding_type,
                dict_page_size_limit: self.dict_page_size_limit,
                row_group_length: self.row_group_length,
                data_page_size: self.data_page_size,
                parquet_version: self.parquet_version,
                enable_statistics: self.enable_statistics,
                include_op_for_full_load: self.include_op_for_full_load,
                cdc_inserts_only: self.cdc_inserts_only,
                timestamp_column_name: self.timestamp_column_name,
                parquet_timestamp_in_millisecond: self.parquet_timestamp_in_millisecond,
                cdc_inserts_and_updates: self.cdc_inserts_and_updates,
                date_partition_enabled: self.date_partition_enabled,
                date_partition_sequence: self.date_partition_sequence,
                date_partition_delimiter: self.date_partition_delimiter,
                use_csv_no_sup_value: self.use_csv_no_sup_value,
                csv_no_sup_value: self.csv_no_sup_value,
                preserve_transactions: self.preserve_transactions,
                cdc_path: self.cdc_path,
                use_task_start_time_for_full_load_timestamp: self
                    .use_task_start_time_for_full_load_timestamp,
                canned_acl_for_objects: self.canned_acl_for_objects,
                add_column_name: self.add_column_name,
                cdc_max_batch_interval: self.cdc_max_batch_interval,
                cdc_min_file_size: self.cdc_min_file_size,
                csv_null_value: self.csv_null_value,
                ignore_header_rows: self.ignore_header_rows,
                max_file_size: self.max_file_size,
                rfc4180: self.rfc4180,
                date_partition_timezone: self.date_partition_timezone,
            }
        }
    }
}
impl S3Settings {
    /// Creates a new builder-style object to manufacture [`S3Settings`](crate::model::S3Settings)
    pub fn builder() -> crate::model::s3_settings::Builder {
        crate::model::s3_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CannedAclForObjectsValue {
    #[allow(missing_docs)] // documentation missing in model
    AuthenticatedRead,
    #[allow(missing_docs)] // documentation missing in model
    AwsExecRead,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerFullControl,
    #[allow(missing_docs)] // documentation missing in model
    BucketOwnerRead,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Private,
    #[allow(missing_docs)] // documentation missing in model
    PublicRead,
    #[allow(missing_docs)] // documentation missing in model
    PublicReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CannedAclForObjectsValue {
    fn from(s: &str) -> Self {
        match s {
            "authenticated-read" => CannedAclForObjectsValue::AuthenticatedRead,
            "aws-exec-read" => CannedAclForObjectsValue::AwsExecRead,
            "bucket-owner-full-control" => CannedAclForObjectsValue::BucketOwnerFullControl,
            "bucket-owner-read" => CannedAclForObjectsValue::BucketOwnerRead,
            "none" => CannedAclForObjectsValue::None,
            "private" => CannedAclForObjectsValue::Private,
            "public-read" => CannedAclForObjectsValue::PublicRead,
            "public-read-write" => CannedAclForObjectsValue::PublicReadWrite,
            other => CannedAclForObjectsValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CannedAclForObjectsValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CannedAclForObjectsValue::from(s))
    }
}
impl CannedAclForObjectsValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CannedAclForObjectsValue::AuthenticatedRead => "authenticated-read",
            CannedAclForObjectsValue::AwsExecRead => "aws-exec-read",
            CannedAclForObjectsValue::BucketOwnerFullControl => "bucket-owner-full-control",
            CannedAclForObjectsValue::BucketOwnerRead => "bucket-owner-read",
            CannedAclForObjectsValue::None => "none",
            CannedAclForObjectsValue::Private => "private",
            CannedAclForObjectsValue::PublicRead => "public-read",
            CannedAclForObjectsValue::PublicReadWrite => "public-read-write",
            CannedAclForObjectsValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "authenticated-read",
            "aws-exec-read",
            "bucket-owner-full-control",
            "bucket-owner-read",
            "none",
            "private",
            "public-read",
            "public-read-write",
        ]
    }
}
impl AsRef<str> for CannedAclForObjectsValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatePartitionDelimiterValue {
    #[allow(missing_docs)] // documentation missing in model
    Dash,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Slash,
    #[allow(missing_docs)] // documentation missing in model
    Underscore,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatePartitionDelimiterValue {
    fn from(s: &str) -> Self {
        match s {
            "DASH" => DatePartitionDelimiterValue::Dash,
            "NONE" => DatePartitionDelimiterValue::None,
            "SLASH" => DatePartitionDelimiterValue::Slash,
            "UNDERSCORE" => DatePartitionDelimiterValue::Underscore,
            other => DatePartitionDelimiterValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatePartitionDelimiterValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatePartitionDelimiterValue::from(s))
    }
}
impl DatePartitionDelimiterValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatePartitionDelimiterValue::Dash => "DASH",
            DatePartitionDelimiterValue::None => "NONE",
            DatePartitionDelimiterValue::Slash => "SLASH",
            DatePartitionDelimiterValue::Underscore => "UNDERSCORE",
            DatePartitionDelimiterValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DASH", "NONE", "SLASH", "UNDERSCORE"]
    }
}
impl AsRef<str> for DatePartitionDelimiterValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DatePartitionSequenceValue {
    #[allow(missing_docs)] // documentation missing in model
    Ddmmyyyy,
    #[allow(missing_docs)] // documentation missing in model
    Mmyyyydd,
    #[allow(missing_docs)] // documentation missing in model
    Yyyymm,
    #[allow(missing_docs)] // documentation missing in model
    Yyyymmdd,
    #[allow(missing_docs)] // documentation missing in model
    Yyyymmddhh,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DatePartitionSequenceValue {
    fn from(s: &str) -> Self {
        match s {
            "DDMMYYYY" => DatePartitionSequenceValue::Ddmmyyyy,
            "MMYYYYDD" => DatePartitionSequenceValue::Mmyyyydd,
            "YYYYMM" => DatePartitionSequenceValue::Yyyymm,
            "YYYYMMDD" => DatePartitionSequenceValue::Yyyymmdd,
            "YYYYMMDDHH" => DatePartitionSequenceValue::Yyyymmddhh,
            other => DatePartitionSequenceValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DatePartitionSequenceValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DatePartitionSequenceValue::from(s))
    }
}
impl DatePartitionSequenceValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DatePartitionSequenceValue::Ddmmyyyy => "DDMMYYYY",
            DatePartitionSequenceValue::Mmyyyydd => "MMYYYYDD",
            DatePartitionSequenceValue::Yyyymm => "YYYYMM",
            DatePartitionSequenceValue::Yyyymmdd => "YYYYMMDD",
            DatePartitionSequenceValue::Yyyymmddhh => "YYYYMMDDHH",
            DatePartitionSequenceValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DDMMYYYY", "MMYYYYDD", "YYYYMM", "YYYYMMDD", "YYYYMMDDHH"]
    }
}
impl AsRef<str> for DatePartitionSequenceValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParquetVersionValue {
    #[allow(missing_docs)] // documentation missing in model
    Parquet10,
    #[allow(missing_docs)] // documentation missing in model
    Parquet20,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParquetVersionValue {
    fn from(s: &str) -> Self {
        match s {
            "parquet-1-0" => ParquetVersionValue::Parquet10,
            "parquet-2-0" => ParquetVersionValue::Parquet20,
            other => ParquetVersionValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParquetVersionValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParquetVersionValue::from(s))
    }
}
impl ParquetVersionValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParquetVersionValue::Parquet10 => "parquet-1-0",
            ParquetVersionValue::Parquet20 => "parquet-2-0",
            ParquetVersionValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["parquet-1-0", "parquet-2-0"]
    }
}
impl AsRef<str> for ParquetVersionValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncodingTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    Plain,
    #[allow(missing_docs)] // documentation missing in model
    PlainDictionary,
    #[allow(missing_docs)] // documentation missing in model
    RleDictionary,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncodingTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "plain" => EncodingTypeValue::Plain,
            "plain-dictionary" => EncodingTypeValue::PlainDictionary,
            "rle-dictionary" => EncodingTypeValue::RleDictionary,
            other => EncodingTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncodingTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncodingTypeValue::from(s))
    }
}
impl EncodingTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncodingTypeValue::Plain => "plain",
            EncodingTypeValue::PlainDictionary => "plain-dictionary",
            EncodingTypeValue::RleDictionary => "rle-dictionary",
            EncodingTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["plain", "plain-dictionary", "rle-dictionary"]
    }
}
impl AsRef<str> for EncodingTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataFormatValue {
    #[allow(missing_docs)] // documentation missing in model
    Csv,
    #[allow(missing_docs)] // documentation missing in model
    Parquet,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataFormatValue {
    fn from(s: &str) -> Self {
        match s {
            "csv" => DataFormatValue::Csv,
            "parquet" => DataFormatValue::Parquet,
            other => DataFormatValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataFormatValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataFormatValue::from(s))
    }
}
impl DataFormatValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataFormatValue::Csv => "csv",
            DataFormatValue::Parquet => "parquet",
            DataFormatValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["csv", "parquet"]
    }
}
impl AsRef<str> for DataFormatValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CompressionTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    Gzip,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CompressionTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "gzip" => CompressionTypeValue::Gzip,
            "none" => CompressionTypeValue::None,
            other => CompressionTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CompressionTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CompressionTypeValue::from(s))
    }
}
impl CompressionTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CompressionTypeValue::Gzip => "gzip",
            CompressionTypeValue::None => "none",
            CompressionTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["gzip", "none"]
    }
}
impl AsRef<str> for CompressionTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the Amazon Resource Name (ARN) of the Identity and Access Management (IAM)
/// role used to define an Amazon DynamoDB target endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DynamoDbSettings {
    /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
}
impl DynamoDbSettings {
    /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
    pub fn service_access_role_arn(&self) -> std::option::Option<&str> {
        self.service_access_role_arn.as_deref()
    }
}
impl std::fmt::Debug for DynamoDbSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DynamoDbSettings");
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.finish()
    }
}
/// See [`DynamoDbSettings`](crate::model::DynamoDbSettings)
pub mod dynamo_db_settings {
    /// A builder for [`DynamoDbSettings`](crate::model::DynamoDbSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) used by the service to access the IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DynamoDbSettings`](crate::model::DynamoDbSettings)
        pub fn build(self) -> crate::model::DynamoDbSettings {
            crate::model::DynamoDbSettings {
                service_access_role_arn: self.service_access_role_arn,
            }
        }
    }
}
impl DynamoDbSettings {
    /// Creates a new builder-style object to manufacture [`DynamoDbSettings`](crate::model::DynamoDbSettings)
    pub fn builder() -> crate::model::dynamo_db_settings::Builder {
        crate::model::dynamo_db_settings::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DmsSslModeValue {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Require,
    #[allow(missing_docs)] // documentation missing in model
    VerifyCa,
    #[allow(missing_docs)] // documentation missing in model
    VerifyFull,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DmsSslModeValue {
    fn from(s: &str) -> Self {
        match s {
            "none" => DmsSslModeValue::None,
            "require" => DmsSslModeValue::Require,
            "verify-ca" => DmsSslModeValue::VerifyCa,
            "verify-full" => DmsSslModeValue::VerifyFull,
            other => DmsSslModeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DmsSslModeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DmsSslModeValue::from(s))
    }
}
impl DmsSslModeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DmsSslModeValue::None => "none",
            DmsSslModeValue::Require => "require",
            DmsSslModeValue::VerifyCa => "verify-ca",
            DmsSslModeValue::VerifyFull => "verify-full",
            DmsSslModeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["none", "require", "verify-ca", "verify-full"]
    }
}
impl AsRef<str> for DmsSslModeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicationEndpointTypeValue {
    #[allow(missing_docs)] // documentation missing in model
    Source,
    #[allow(missing_docs)] // documentation missing in model
    Target,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicationEndpointTypeValue {
    fn from(s: &str) -> Self {
        match s {
            "source" => ReplicationEndpointTypeValue::Source,
            "target" => ReplicationEndpointTypeValue::Target,
            other => ReplicationEndpointTypeValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicationEndpointTypeValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicationEndpointTypeValue::from(s))
    }
}
impl ReplicationEndpointTypeValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicationEndpointTypeValue::Source => "source",
            ReplicationEndpointTypeValue::Target => "target",
            ReplicationEndpointTypeValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["source", "target"]
    }
}
impl AsRef<str> for ReplicationEndpointTypeValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A user-defined key-value pair that describes metadata added to an DMS resource and
/// that is used by operations such as the following:</p>
/// <ul>
/// <li>
/// <p>
/// <code>AddTagsToResource</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ListTagsForResource</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>RemoveTagsFromResource</code>
/// </p>
/// </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A key is the required name of the tag. The string value can be 1-128 Unicode characters
    /// in length and can't be prefixed with "aws:" or "dms:". The string can only contain
    /// only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java
    /// regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value is the optional value of the tag. The string value can be 1-256 Unicode
    /// characters in length and can't be prefixed with "aws:" or "dms:". The string can only
    /// contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
    /// (Java regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the resource for which the tag is created.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A key is the required name of the tag. The string value can be 1-128 Unicode characters
    /// in length and can't be prefixed with "aws:" or "dms:". The string can only contain
    /// only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java
    /// regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A value is the optional value of the tag. The string value can be 1-256 Unicode
    /// characters in length and can't be prefixed with "aws:" or "dms:". The string can only
    /// contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
    /// (Java regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the resource for which the tag is created.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A key is the required name of the tag. The string value can be 1-128 Unicode characters
        /// in length and can't be prefixed with "aws:" or "dms:". The string can only contain
        /// only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java
        /// regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A key is the required name of the tag. The string value can be 1-128 Unicode characters
        /// in length and can't be prefixed with "aws:" or "dms:". The string can only contain
        /// only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java
        /// regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value is the optional value of the tag. The string value can be 1-256 Unicode
        /// characters in length and can't be prefixed with "aws:" or "dms:". The string can only
        /// contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
        /// (Java regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value is the optional value of the tag. The string value can be 1-256 Unicode
        /// characters in length and can't be prefixed with "aws:" or "dms:". The string can only
        /// contain only the set of Unicode letters, digits, white-space, '_', '.', '/', '=', '+', '-'
        /// (Java regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the resource for which the tag is created.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the resource for which the tag is created.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>The SSL certificate that can be used to encrypt connections between the endpoints and
/// the replication instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
    /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
    /// contain two consecutive hyphens.</p>
    pub certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The date that the certificate was created.</p>
    pub certificate_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
    pub certificate_pem: std::option::Option<std::string::String>,
    /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Example: <code>filebase64("${path.root}/rds-ca-2019-root.sso")</code>
    /// </p>
    pub certificate_wallet: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The owner of the certificate.</p>
    pub certificate_owner: std::option::Option<std::string::String>,
    /// <p>The beginning date that the certificate is valid.</p>
    pub valid_from_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The final date that the certificate is valid.</p>
    pub valid_to_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The signing algorithm for the certificate.</p>
    pub signing_algorithm: std::option::Option<std::string::String>,
    /// <p>The key length of the cryptographic algorithm being used.</p>
    pub key_length: std::option::Option<i32>,
}
impl Certificate {
    /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
    /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
    /// contain two consecutive hyphens.</p>
    pub fn certificate_identifier(&self) -> std::option::Option<&str> {
        self.certificate_identifier.as_deref()
    }
    /// <p>The date that the certificate was created.</p>
    pub fn certificate_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.certificate_creation_date.as_ref()
    }
    /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
    pub fn certificate_pem(&self) -> std::option::Option<&str> {
        self.certificate_pem.as_deref()
    }
    /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Example: <code>filebase64("${path.root}/rds-ca-2019-root.sso")</code>
    /// </p>
    pub fn certificate_wallet(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.certificate_wallet.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>The owner of the certificate.</p>
    pub fn certificate_owner(&self) -> std::option::Option<&str> {
        self.certificate_owner.as_deref()
    }
    /// <p>The beginning date that the certificate is valid.</p>
    pub fn valid_from_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_from_date.as_ref()
    }
    /// <p>The final date that the certificate is valid.</p>
    pub fn valid_to_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_to_date.as_ref()
    }
    /// <p>The signing algorithm for the certificate.</p>
    pub fn signing_algorithm(&self) -> std::option::Option<&str> {
        self.signing_algorithm.as_deref()
    }
    /// <p>The key length of the cryptographic algorithm being used.</p>
    pub fn key_length(&self) -> std::option::Option<i32> {
        self.key_length
    }
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("certificate_identifier", &self.certificate_identifier);
        formatter.field("certificate_creation_date", &self.certificate_creation_date);
        formatter.field("certificate_pem", &self.certificate_pem);
        formatter.field("certificate_wallet", &self.certificate_wallet);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("certificate_owner", &self.certificate_owner);
        formatter.field("valid_from_date", &self.valid_from_date);
        formatter.field("valid_to_date", &self.valid_to_date);
        formatter.field("signing_algorithm", &self.signing_algorithm);
        formatter.field("key_length", &self.key_length);
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) certificate_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) certificate_pem: std::option::Option<std::string::String>,
        pub(crate) certificate_wallet: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) certificate_owner: std::option::Option<std::string::String>,
        pub(crate) valid_from_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) valid_to_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) signing_algorithm: std::option::Option<std::string::String>,
        pub(crate) key_length: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
        /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        pub fn certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_identifier = Some(input.into());
            self
        }
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
        /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_identifier = input;
            self
        }
        /// <p>The date that the certificate was created.</p>
        pub fn certificate_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.certificate_creation_date = Some(input);
            self
        }
        /// <p>The date that the certificate was created.</p>
        pub fn set_certificate_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.certificate_creation_date = input;
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_pem = Some(input.into());
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_pem = input;
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Example: <code>filebase64("${path.root}/rds-ca-2019-root.sso")</code>
        /// </p>
        pub fn certificate_wallet(mut self, input: aws_smithy_types::Blob) -> Self {
            self.certificate_wallet = Some(input);
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Example: <code>filebase64("${path.root}/rds-ca-2019-root.sso")</code>
        /// </p>
        pub fn set_certificate_wallet(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.certificate_wallet = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The owner of the certificate.</p>
        pub fn certificate_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_owner = Some(input.into());
            self
        }
        /// <p>The owner of the certificate.</p>
        pub fn set_certificate_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_owner = input;
            self
        }
        /// <p>The beginning date that the certificate is valid.</p>
        pub fn valid_from_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_from_date = Some(input);
            self
        }
        /// <p>The beginning date that the certificate is valid.</p>
        pub fn set_valid_from_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_from_date = input;
            self
        }
        /// <p>The final date that the certificate is valid.</p>
        pub fn valid_to_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_to_date = Some(input);
            self
        }
        /// <p>The final date that the certificate is valid.</p>
        pub fn set_valid_to_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_to_date = input;
            self
        }
        /// <p>The signing algorithm for the certificate.</p>
        pub fn signing_algorithm(mut self, input: impl Into<std::string::String>) -> Self {
            self.signing_algorithm = Some(input.into());
            self
        }
        /// <p>The signing algorithm for the certificate.</p>
        pub fn set_signing_algorithm(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.signing_algorithm = input;
            self
        }
        /// <p>The key length of the cryptographic algorithm being used.</p>
        pub fn key_length(mut self, input: i32) -> Self {
            self.key_length = Some(input);
            self
        }
        /// <p>The key length of the cryptographic algorithm being used.</p>
        pub fn set_key_length(mut self, input: std::option::Option<i32>) -> Self {
            self.key_length = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate {
                certificate_identifier: self.certificate_identifier,
                certificate_creation_date: self.certificate_creation_date,
                certificate_pem: self.certificate_pem,
                certificate_wallet: self.certificate_wallet,
                certificate_arn: self.certificate_arn,
                certificate_owner: self.certificate_owner,
                valid_from_date: self.valid_from_date,
                valid_to_date: self.valid_to_date,
                signing_algorithm: self.signing_algorithm,
                key_length: self.key_length,
            }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}

/// <p>Provides a collection of table statistics in response to a request by the
/// <code>DescribeTableStatistics</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableStatistics {
    /// <p>The schema name.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the table.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>The number of insert actions performed on a table.</p>
    pub inserts: i64,
    /// <p>The number of delete actions performed on a table.</p>
    pub deletes: i64,
    /// <p>The number of update actions performed on a table.</p>
    pub updates: i64,
    /// <p>The data definition language (DDL) used to build and modify the structure of your tables.</p>
    pub ddls: i64,
    /// <p>The number of rows added during the full load operation.</p>
    pub full_load_rows: i64,
    /// <p>The number of rows that failed conditional checks during the full load operation (valid
    /// only for migrations where DynamoDB is the target).</p>
    pub full_load_condtnl_chk_failed_rows: i64,
    /// <p>The number of rows that failed to load during the full load operation (valid only for
    /// migrations where DynamoDB is the target).</p>
    pub full_load_error_rows: i64,
    /// <p>The time when the full load operation started.</p>
    pub full_load_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time when the full load operation completed.</p>
    pub full_load_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A value that indicates if the table was reloaded (<code>true</code>)
    /// or loaded as part of a new full load operation (<code>false</code>).</p>
    pub full_load_reloaded: std::option::Option<bool>,
    /// <p>The last time a table was updated.</p>
    pub last_update_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The state of the tables described.</p>
    /// <p>Valid states: Table does not exist | Before load | Full load | Table completed | Table
    /// cancelled | Table error | Table all | Table updates | Table is being reloaded</p>
    pub table_state: std::option::Option<std::string::String>,
    /// <p>The number of records that have yet to be validated.</p>
    pub validation_pending_records: i64,
    /// <p>The number of records that failed validation.</p>
    pub validation_failed_records: i64,
    /// <p>The number of records that couldn't be validated.</p>
    pub validation_suspended_records: i64,
    /// <p>The validation state of the table.</p>
    /// <p>This parameter can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>Not enabled – Validation isn't enabled for the table in the migration
    /// task.</p>
    /// </li>
    /// <li>
    /// <p>Pending records – Some records in the table are waiting for validation.</p>
    /// </li>
    /// <li>
    /// <p>Mismatched records – Some records in the table don't match between the source
    /// and target.</p>
    /// </li>
    /// <li>
    /// <p>Suspended records – Some records in the table couldn't be validated.</p>
    /// </li>
    /// <li>
    /// <p>No primary key  –The table couldn't be validated because it has no primary
    /// key.</p>
    /// </li>
    /// <li>
    /// <p>Table error – The table wasn't validated because it's in an error state
    /// and some data wasn't migrated.</p>
    /// </li>
    /// <li>
    /// <p>Validated – All rows in the table are validated. If the table is updated, the
    /// status can change from Validated.</p>
    /// </li>
    /// <li>
    /// <p>Error – The table couldn't be validated because of an unexpected
    /// error.</p>
    /// </li>
    /// <li>
    /// <p>Pending validation – The table is waiting validation.</p>
    /// </li>
    /// <li>
    /// <p>Preparing table – Preparing the table enabled in the migration task for validation.</p>
    /// </li>
    /// <li>
    /// <p>Pending revalidation – All rows in the table are pending validation after the table was updated.</p>
    /// </li>
    /// </ul>
    pub validation_state: std::option::Option<std::string::String>,
    /// <p>Additional details about the state of validation.</p>
    pub validation_state_details: std::option::Option<std::string::String>,
}
impl TableStatistics {
    /// <p>The schema name.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The name of the table.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>The number of insert actions performed on a table.</p>
    pub fn inserts(&self) -> i64 {
        self.inserts
    }
    /// <p>The number of delete actions performed on a table.</p>
    pub fn deletes(&self) -> i64 {
        self.deletes
    }
    /// <p>The number of update actions performed on a table.</p>
    pub fn updates(&self) -> i64 {
        self.updates
    }
    /// <p>The data definition language (DDL) used to build and modify the structure of your tables.</p>
    pub fn ddls(&self) -> i64 {
        self.ddls
    }
    /// <p>The number of rows added during the full load operation.</p>
    pub fn full_load_rows(&self) -> i64 {
        self.full_load_rows
    }
    /// <p>The number of rows that failed conditional checks during the full load operation (valid
    /// only for migrations where DynamoDB is the target).</p>
    pub fn full_load_condtnl_chk_failed_rows(&self) -> i64 {
        self.full_load_condtnl_chk_failed_rows
    }
    /// <p>The number of rows that failed to load during the full load operation (valid only for
    /// migrations where DynamoDB is the target).</p>
    pub fn full_load_error_rows(&self) -> i64 {
        self.full_load_error_rows
    }
    /// <p>The time when the full load operation started.</p>
    pub fn full_load_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.full_load_start_time.as_ref()
    }
    /// <p>The time when the full load operation completed.</p>
    pub fn full_load_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.full_load_end_time.as_ref()
    }
    /// <p>A value that indicates if the table was reloaded (<code>true</code>)
    /// or loaded as part of a new full load operation (<code>false</code>).</p>
    pub fn full_load_reloaded(&self) -> std::option::Option<bool> {
        self.full_load_reloaded
    }
    /// <p>The last time a table was updated.</p>
    pub fn last_update_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_update_time.as_ref()
    }
    /// <p>The state of the tables described.</p>
    /// <p>Valid states: Table does not exist | Before load | Full load | Table completed | Table
    /// cancelled | Table error | Table all | Table updates | Table is being reloaded</p>
    pub fn table_state(&self) -> std::option::Option<&str> {
        self.table_state.as_deref()
    }
    /// <p>The number of records that have yet to be validated.</p>
    pub fn validation_pending_records(&self) -> i64 {
        self.validation_pending_records
    }
    /// <p>The number of records that failed validation.</p>
    pub fn validation_failed_records(&self) -> i64 {
        self.validation_failed_records
    }
    /// <p>The number of records that couldn't be validated.</p>
    pub fn validation_suspended_records(&self) -> i64 {
        self.validation_suspended_records
    }
    /// <p>The validation state of the table.</p>
    /// <p>This parameter can have the following values:</p>
    /// <ul>
    /// <li>
    /// <p>Not enabled – Validation isn't enabled for the table in the migration
    /// task.</p>
    /// </li>
    /// <li>
    /// <p>Pending records – Some records in the table are waiting for validation.</p>
    /// </li>
    /// <li>
    /// <p>Mismatched records – Some records in the table don't match between the source
    /// and target.</p>
    /// </li>
    /// <li>
    /// <p>Suspended records – Some records in the table couldn't be validated.</p>
    /// </li>
    /// <li>
    /// <p>No primary key  –The table couldn't be validated because it has no primary
    /// key.</p>
    /// </li>
    /// <li>
    /// <p>Table error – The table wasn't validated because it's in an error state
    /// and some data wasn't migrated.</p>
    /// </li>
    /// <li>
    /// <p>Validated – All rows in the table are validated. If the table is updated, the
    /// status can change from Validated.</p>
    /// </li>
    /// <li>
    /// <p>Error – The table couldn't be validated because of an unexpected
    /// error.</p>
    /// </li>
    /// <li>
    /// <p>Pending validation – The table is waiting validation.</p>
    /// </li>
    /// <li>
    /// <p>Preparing table – Preparing the table enabled in the migration task for validation.</p>
    /// </li>
    /// <li>
    /// <p>Pending revalidation – All rows in the table are pending validation after the table was updated.</p>
    /// </li>
    /// </ul>
    pub fn validation_state(&self) -> std::option::Option<&str> {
        self.validation_state.as_deref()
    }
    /// <p>Additional details about the state of validation.</p>
    pub fn validation_state_details(&self) -> std::option::Option<&str> {
        self.validation_state_details.as_deref()
    }
}
impl std::fmt::Debug for TableStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableStatistics");
        formatter.field("schema_name", &self.schema_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("inserts", &self.inserts);
        formatter.field("deletes", &self.deletes);
        formatter.field("updates", &self.updates);
        formatter.field("ddls", &self.ddls);
        formatter.field("full_load_rows", &self.full_load_rows);
        formatter.field(
            "full_load_condtnl_chk_failed_rows",
            &self.full_load_condtnl_chk_failed_rows,
        );
        formatter.field("full_load_error_rows", &self.full_load_error_rows);
        formatter.field("full_load_start_time", &self.full_load_start_time);
        formatter.field("full_load_end_time", &self.full_load_end_time);
        formatter.field("full_load_reloaded", &self.full_load_reloaded);
        formatter.field("last_update_time", &self.last_update_time);
        formatter.field("table_state", &self.table_state);
        formatter.field(
            "validation_pending_records",
            &self.validation_pending_records,
        );
        formatter.field("validation_failed_records", &self.validation_failed_records);
        formatter.field(
            "validation_suspended_records",
            &self.validation_suspended_records,
        );
        formatter.field("validation_state", &self.validation_state);
        formatter.field("validation_state_details", &self.validation_state_details);
        formatter.finish()
    }
}
/// See [`TableStatistics`](crate::model::TableStatistics)
pub mod table_statistics {
    /// A builder for [`TableStatistics`](crate::model::TableStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) inserts: std::option::Option<i64>,
        pub(crate) deletes: std::option::Option<i64>,
        pub(crate) updates: std::option::Option<i64>,
        pub(crate) ddls: std::option::Option<i64>,
        pub(crate) full_load_rows: std::option::Option<i64>,
        pub(crate) full_load_condtnl_chk_failed_rows: std::option::Option<i64>,
        pub(crate) full_load_error_rows: std::option::Option<i64>,
        pub(crate) full_load_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) full_load_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) full_load_reloaded: std::option::Option<bool>,
        pub(crate) last_update_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) table_state: std::option::Option<std::string::String>,
        pub(crate) validation_pending_records: std::option::Option<i64>,
        pub(crate) validation_failed_records: std::option::Option<i64>,
        pub(crate) validation_suspended_records: std::option::Option<i64>,
        pub(crate) validation_state: std::option::Option<std::string::String>,
        pub(crate) validation_state_details: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The schema name.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The schema name.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The name of the table.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>The number of insert actions performed on a table.</p>
        pub fn inserts(mut self, input: i64) -> Self {
            self.inserts = Some(input);
            self
        }
        /// <p>The number of insert actions performed on a table.</p>
        pub fn set_inserts(mut self, input: std::option::Option<i64>) -> Self {
            self.inserts = input;
            self
        }
        /// <p>The number of delete actions performed on a table.</p>
        pub fn deletes(mut self, input: i64) -> Self {
            self.deletes = Some(input);
            self
        }
        /// <p>The number of delete actions performed on a table.</p>
        pub fn set_deletes(mut self, input: std::option::Option<i64>) -> Self {
            self.deletes = input;
            self
        }
        /// <p>The number of update actions performed on a table.</p>
        pub fn updates(mut self, input: i64) -> Self {
            self.updates = Some(input);
            self
        }
        /// <p>The number of update actions performed on a table.</p>
        pub fn set_updates(mut self, input: std::option::Option<i64>) -> Self {
            self.updates = input;
            self
        }
        /// <p>The data definition language (DDL) used to build and modify the structure of your tables.</p>
        pub fn ddls(mut self, input: i64) -> Self {
            self.ddls = Some(input);
            self
        }
        /// <p>The data definition language (DDL) used to build and modify the structure of your tables.</p>
        pub fn set_ddls(mut self, input: std::option::Option<i64>) -> Self {
            self.ddls = input;
            self
        }
        /// <p>The number of rows added during the full load operation.</p>
        pub fn full_load_rows(mut self, input: i64) -> Self {
            self.full_load_rows = Some(input);
            self
        }
        /// <p>The number of rows added during the full load operation.</p>
        pub fn set_full_load_rows(mut self, input: std::option::Option<i64>) -> Self {
            self.full_load_rows = input;
            self
        }
        /// <p>The number of rows that failed conditional checks during the full load operation (valid
        /// only for migrations where DynamoDB is the target).</p>
        pub fn full_load_condtnl_chk_failed_rows(mut self, input: i64) -> Self {
            self.full_load_condtnl_chk_failed_rows = Some(input);
            self
        }
        /// <p>The number of rows that failed conditional checks during the full load operation (valid
        /// only for migrations where DynamoDB is the target).</p>
        pub fn set_full_load_condtnl_chk_failed_rows(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.full_load_condtnl_chk_failed_rows = input;
            self
        }
        /// <p>The number of rows that failed to load during the full load operation (valid only for
        /// migrations where DynamoDB is the target).</p>
        pub fn full_load_error_rows(mut self, input: i64) -> Self {
            self.full_load_error_rows = Some(input);
            self
        }
        /// <p>The number of rows that failed to load during the full load operation (valid only for
        /// migrations where DynamoDB is the target).</p>
        pub fn set_full_load_error_rows(mut self, input: std::option::Option<i64>) -> Self {
            self.full_load_error_rows = input;
            self
        }
        /// <p>The time when the full load operation started.</p>
        pub fn full_load_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.full_load_start_time = Some(input);
            self
        }
        /// <p>The time when the full load operation started.</p>
        pub fn set_full_load_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.full_load_start_time = input;
            self
        }
        /// <p>The time when the full load operation completed.</p>
        pub fn full_load_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.full_load_end_time = Some(input);
            self
        }
        /// <p>The time when the full load operation completed.</p>
        pub fn set_full_load_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.full_load_end_time = input;
            self
        }
        /// <p>A value that indicates if the table was reloaded (<code>true</code>)
        /// or loaded as part of a new full load operation (<code>false</code>).</p>
        pub fn full_load_reloaded(mut self, input: bool) -> Self {
            self.full_load_reloaded = Some(input);
            self
        }
        /// <p>A value that indicates if the table was reloaded (<code>true</code>)
        /// or loaded as part of a new full load operation (<code>false</code>).</p>
        pub fn set_full_load_reloaded(mut self, input: std::option::Option<bool>) -> Self {
            self.full_load_reloaded = input;
            self
        }
        /// <p>The last time a table was updated.</p>
        pub fn last_update_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_update_time = Some(input);
            self
        }
        /// <p>The last time a table was updated.</p>
        pub fn set_last_update_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_update_time = input;
            self
        }
        /// <p>The state of the tables described.</p>
        /// <p>Valid states: Table does not exist | Before load | Full load | Table completed | Table
        /// cancelled | Table error | Table all | Table updates | Table is being reloaded</p>
        pub fn table_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_state = Some(input.into());
            self
        }
        /// <p>The state of the tables described.</p>
        /// <p>Valid states: Table does not exist | Before load | Full load | Table completed | Table
        /// cancelled | Table error | Table all | Table updates | Table is being reloaded</p>
        pub fn set_table_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_state = input;
            self
        }
        /// <p>The number of records that have yet to be validated.</p>
        pub fn validation_pending_records(mut self, input: i64) -> Self {
            self.validation_pending_records = Some(input);
            self
        }
        /// <p>The number of records that have yet to be validated.</p>
        pub fn set_validation_pending_records(mut self, input: std::option::Option<i64>) -> Self {
            self.validation_pending_records = input;
            self
        }
        /// <p>The number of records that failed validation.</p>
        pub fn validation_failed_records(mut self, input: i64) -> Self {
            self.validation_failed_records = Some(input);
            self
        }
        /// <p>The number of records that failed validation.</p>
        pub fn set_validation_failed_records(mut self, input: std::option::Option<i64>) -> Self {
            self.validation_failed_records = input;
            self
        }
        /// <p>The number of records that couldn't be validated.</p>
        pub fn validation_suspended_records(mut self, input: i64) -> Self {
            self.validation_suspended_records = Some(input);
            self
        }
        /// <p>The number of records that couldn't be validated.</p>
        pub fn set_validation_suspended_records(mut self, input: std::option::Option<i64>) -> Self {
            self.validation_suspended_records = input;
            self
        }
        /// <p>The validation state of the table.</p>
        /// <p>This parameter can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>Not enabled – Validation isn't enabled for the table in the migration
        /// task.</p>
        /// </li>
        /// <li>
        /// <p>Pending records – Some records in the table are waiting for validation.</p>
        /// </li>
        /// <li>
        /// <p>Mismatched records – Some records in the table don't match between the source
        /// and target.</p>
        /// </li>
        /// <li>
        /// <p>Suspended records – Some records in the table couldn't be validated.</p>
        /// </li>
        /// <li>
        /// <p>No primary key  –The table couldn't be validated because it has no primary
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>Table error – The table wasn't validated because it's in an error state
        /// and some data wasn't migrated.</p>
        /// </li>
        /// <li>
        /// <p>Validated – All rows in the table are validated. If the table is updated, the
        /// status can change from Validated.</p>
        /// </li>
        /// <li>
        /// <p>Error – The table couldn't be validated because of an unexpected
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>Pending validation – The table is waiting validation.</p>
        /// </li>
        /// <li>
        /// <p>Preparing table – Preparing the table enabled in the migration task for validation.</p>
        /// </li>
        /// <li>
        /// <p>Pending revalidation – All rows in the table are pending validation after the table was updated.</p>
        /// </li>
        /// </ul>
        pub fn validation_state(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_state = Some(input.into());
            self
        }
        /// <p>The validation state of the table.</p>
        /// <p>This parameter can have the following values:</p>
        /// <ul>
        /// <li>
        /// <p>Not enabled – Validation isn't enabled for the table in the migration
        /// task.</p>
        /// </li>
        /// <li>
        /// <p>Pending records – Some records in the table are waiting for validation.</p>
        /// </li>
        /// <li>
        /// <p>Mismatched records – Some records in the table don't match between the source
        /// and target.</p>
        /// </li>
        /// <li>
        /// <p>Suspended records – Some records in the table couldn't be validated.</p>
        /// </li>
        /// <li>
        /// <p>No primary key  –The table couldn't be validated because it has no primary
        /// key.</p>
        /// </li>
        /// <li>
        /// <p>Table error – The table wasn't validated because it's in an error state
        /// and some data wasn't migrated.</p>
        /// </li>
        /// <li>
        /// <p>Validated – All rows in the table are validated. If the table is updated, the
        /// status can change from Validated.</p>
        /// </li>
        /// <li>
        /// <p>Error – The table couldn't be validated because of an unexpected
        /// error.</p>
        /// </li>
        /// <li>
        /// <p>Pending validation – The table is waiting validation.</p>
        /// </li>
        /// <li>
        /// <p>Preparing table – Preparing the table enabled in the migration task for validation.</p>
        /// </li>
        /// <li>
        /// <p>Pending revalidation – All rows in the table are pending validation after the table was updated.</p>
        /// </li>
        /// </ul>
        pub fn set_validation_state(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_state = input;
            self
        }
        /// <p>Additional details about the state of validation.</p>
        pub fn validation_state_details(mut self, input: impl Into<std::string::String>) -> Self {
            self.validation_state_details = Some(input.into());
            self
        }
        /// <p>Additional details about the state of validation.</p>
        pub fn set_validation_state_details(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.validation_state_details = input;
            self
        }
        /// Consumes the builder and constructs a [`TableStatistics`](crate::model::TableStatistics)
        pub fn build(self) -> crate::model::TableStatistics {
            crate::model::TableStatistics {
                schema_name: self.schema_name,
                table_name: self.table_name,
                inserts: self.inserts.unwrap_or_default(),
                deletes: self.deletes.unwrap_or_default(),
                updates: self.updates.unwrap_or_default(),
                ddls: self.ddls.unwrap_or_default(),
                full_load_rows: self.full_load_rows.unwrap_or_default(),
                full_load_condtnl_chk_failed_rows: self
                    .full_load_condtnl_chk_failed_rows
                    .unwrap_or_default(),
                full_load_error_rows: self.full_load_error_rows.unwrap_or_default(),
                full_load_start_time: self.full_load_start_time,
                full_load_end_time: self.full_load_end_time,
                full_load_reloaded: self.full_load_reloaded,
                last_update_time: self.last_update_time,
                table_state: self.table_state,
                validation_pending_records: self.validation_pending_records.unwrap_or_default(),
                validation_failed_records: self.validation_failed_records.unwrap_or_default(),
                validation_suspended_records: self.validation_suspended_records.unwrap_or_default(),
                validation_state: self.validation_state,
                validation_state_details: self.validation_state_details,
            }
        }
    }
}
impl TableStatistics {
    /// Creates a new builder-style object to manufacture [`TableStatistics`](crate::model::TableStatistics)
    pub fn builder() -> crate::model::table_statistics::Builder {
        crate::model::table_statistics::Builder::default()
    }
}

/// <p>Identifies the name and value of a filter object. This filter is used to limit the
/// number and type of DMS objects that are returned for a particular
/// <code>Describe*</code> call or similar operation. Filters are used as an optional
/// parameter for certain API operations. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter as specified for a <code>Describe*</code> or similar
    /// operation.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The filter value, which can specify one or more values used to narrow the returned results.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name of the filter as specified for a <code>Describe*</code> or similar
    /// operation.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The filter value, which can specify one or more values used to narrow the returned results.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter as specified for a <code>Describe*</code> or similar
        /// operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter as specified for a <code>Describe*</code> or similar
        /// operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The filter value, which can specify one or more values used to narrow the returned results.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The filter value, which can specify one or more values used to narrow the returned results.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Provides information that describes an individual assessment from a premigration
/// assessment run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTaskIndividualAssessment {
    /// <p>Amazon Resource Name (ARN) of this individual assessment.</p>
    pub replication_task_individual_assessment_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the premigration assessment run that is created to run this individual
    /// assessment.</p>
    pub replication_task_assessment_run_arn: std::option::Option<std::string::String>,
    /// <p>Name of this individual assessment.</p>
    pub individual_assessment_name: std::option::Option<std::string::String>,
    /// <p>Individual assessment status.</p>
    /// <p>This status can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"cancelled"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"error"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"passed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"pending"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"running"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>Date when this individual assessment was started as part of running the
    /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
    pub replication_task_individual_assessment_start_date:
        std::option::Option<aws_smithy_types::DateTime>,
}
impl ReplicationTaskIndividualAssessment {
    /// <p>Amazon Resource Name (ARN) of this individual assessment.</p>
    pub fn replication_task_individual_assessment_arn(&self) -> std::option::Option<&str> {
        self.replication_task_individual_assessment_arn.as_deref()
    }
    /// <p>ARN of the premigration assessment run that is created to run this individual
    /// assessment.</p>
    pub fn replication_task_assessment_run_arn(&self) -> std::option::Option<&str> {
        self.replication_task_assessment_run_arn.as_deref()
    }
    /// <p>Name of this individual assessment.</p>
    pub fn individual_assessment_name(&self) -> std::option::Option<&str> {
        self.individual_assessment_name.as_deref()
    }
    /// <p>Individual assessment status.</p>
    /// <p>This status can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"cancelled"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"error"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"failed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"passed"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"pending"</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"running"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Date when this individual assessment was started as part of running the
    /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
    pub fn replication_task_individual_assessment_start_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.replication_task_individual_assessment_start_date
            .as_ref()
    }
}
impl std::fmt::Debug for ReplicationTaskIndividualAssessment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTaskIndividualAssessment");
        formatter.field(
            "replication_task_individual_assessment_arn",
            &self.replication_task_individual_assessment_arn,
        );
        formatter.field(
            "replication_task_assessment_run_arn",
            &self.replication_task_assessment_run_arn,
        );
        formatter.field(
            "individual_assessment_name",
            &self.individual_assessment_name,
        );
        formatter.field("status", &self.status);
        formatter.field(
            "replication_task_individual_assessment_start_date",
            &self.replication_task_individual_assessment_start_date,
        );
        formatter.finish()
    }
}
/// See [`ReplicationTaskIndividualAssessment`](crate::model::ReplicationTaskIndividualAssessment)
pub mod replication_task_individual_assessment {
    /// A builder for [`ReplicationTaskIndividualAssessment`](crate::model::ReplicationTaskIndividualAssessment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_individual_assessment_arn:
            std::option::Option<std::string::String>,
        pub(crate) replication_task_assessment_run_arn: std::option::Option<std::string::String>,
        pub(crate) individual_assessment_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) replication_task_individual_assessment_start_date:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of this individual assessment.</p>
        pub fn replication_task_individual_assessment_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_individual_assessment_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of this individual assessment.</p>
        pub fn set_replication_task_individual_assessment_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_individual_assessment_arn = input;
            self
        }
        /// <p>ARN of the premigration assessment run that is created to run this individual
        /// assessment.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = Some(input.into());
            self
        }
        /// <p>ARN of the premigration assessment run that is created to run this individual
        /// assessment.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = input;
            self
        }
        /// <p>Name of this individual assessment.</p>
        pub fn individual_assessment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.individual_assessment_name = Some(input.into());
            self
        }
        /// <p>Name of this individual assessment.</p>
        pub fn set_individual_assessment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.individual_assessment_name = input;
            self
        }
        /// <p>Individual assessment status.</p>
        /// <p>This status can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"cancelled"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"error"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"passed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"pending"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"running"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Individual assessment status.</p>
        /// <p>This status can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"cancelled"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"error"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"failed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"passed"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"pending"</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"running"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Date when this individual assessment was started as part of running the
        /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
        pub fn replication_task_individual_assessment_start_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.replication_task_individual_assessment_start_date = Some(input);
            self
        }
        /// <p>Date when this individual assessment was started as part of running the
        /// <code>StartReplicationTaskAssessmentRun</code> operation.</p>
        pub fn set_replication_task_individual_assessment_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.replication_task_individual_assessment_start_date = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTaskIndividualAssessment`](crate::model::ReplicationTaskIndividualAssessment)
        pub fn build(self) -> crate::model::ReplicationTaskIndividualAssessment {
            crate::model::ReplicationTaskIndividualAssessment {
                replication_task_individual_assessment_arn: self
                    .replication_task_individual_assessment_arn,
                replication_task_assessment_run_arn: self.replication_task_assessment_run_arn,
                individual_assessment_name: self.individual_assessment_name,
                status: self.status,
                replication_task_individual_assessment_start_date: self
                    .replication_task_individual_assessment_start_date,
            }
        }
    }
}
impl ReplicationTaskIndividualAssessment {
    /// Creates a new builder-style object to manufacture [`ReplicationTaskIndividualAssessment`](crate::model::ReplicationTaskIndividualAssessment)
    pub fn builder() -> crate::model::replication_task_individual_assessment::Builder {
        crate::model::replication_task_individual_assessment::Builder::default()
    }
}

/// <p> The task assessment report in JSON format. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationTaskAssessmentResult {
    /// <p> The replication task identifier of the task on which the task assessment was run.
    /// </p>
    pub replication_task_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>The date the task assessment was completed. </p>
    pub replication_task_last_assessment_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The status of the task assessment. </p>
    pub assessment_status: std::option::Option<std::string::String>,
    /// <p> The file containing the results of the task assessment. </p>
    pub assessment_results_file: std::option::Option<std::string::String>,
    /// <p> The task assessment results in JSON format. </p>
    /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
    /// in the request.</p>
    pub assessment_results: std::option::Option<std::string::String>,
    /// <p> The URL of the S3 object containing the task assessment results. </p>
    /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
    /// in the request.</p>
    pub s3_object_url: std::option::Option<std::string::String>,
}
impl ReplicationTaskAssessmentResult {
    /// <p> The replication task identifier of the task on which the task assessment was run.
    /// </p>
    pub fn replication_task_identifier(&self) -> std::option::Option<&str> {
        self.replication_task_identifier.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
    pub fn replication_task_arn(&self) -> std::option::Option<&str> {
        self.replication_task_arn.as_deref()
    }
    /// <p>The date the task assessment was completed. </p>
    pub fn replication_task_last_assessment_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.replication_task_last_assessment_date.as_ref()
    }
    /// <p> The status of the task assessment. </p>
    pub fn assessment_status(&self) -> std::option::Option<&str> {
        self.assessment_status.as_deref()
    }
    /// <p> The file containing the results of the task assessment. </p>
    pub fn assessment_results_file(&self) -> std::option::Option<&str> {
        self.assessment_results_file.as_deref()
    }
    /// <p> The task assessment results in JSON format. </p>
    /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
    /// in the request.</p>
    pub fn assessment_results(&self) -> std::option::Option<&str> {
        self.assessment_results.as_deref()
    }
    /// <p> The URL of the S3 object containing the task assessment results. </p>
    /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
    /// in the request.</p>
    pub fn s3_object_url(&self) -> std::option::Option<&str> {
        self.s3_object_url.as_deref()
    }
}
impl std::fmt::Debug for ReplicationTaskAssessmentResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationTaskAssessmentResult");
        formatter.field(
            "replication_task_identifier",
            &self.replication_task_identifier,
        );
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field(
            "replication_task_last_assessment_date",
            &self.replication_task_last_assessment_date,
        );
        formatter.field("assessment_status", &self.assessment_status);
        formatter.field("assessment_results_file", &self.assessment_results_file);
        formatter.field("assessment_results", &self.assessment_results);
        formatter.field("s3_object_url", &self.s3_object_url);
        formatter.finish()
    }
}
/// See [`ReplicationTaskAssessmentResult`](crate::model::ReplicationTaskAssessmentResult)
pub mod replication_task_assessment_result {
    /// A builder for [`ReplicationTaskAssessmentResult`](crate::model::ReplicationTaskAssessmentResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_identifier: std::option::Option<std::string::String>,
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) replication_task_last_assessment_date:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) assessment_status: std::option::Option<std::string::String>,
        pub(crate) assessment_results_file: std::option::Option<std::string::String>,
        pub(crate) assessment_results: std::option::Option<std::string::String>,
        pub(crate) s3_object_url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The replication task identifier of the task on which the task assessment was run.
        /// </p>
        pub fn replication_task_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = Some(input.into());
            self
        }
        /// <p> The replication task identifier of the task on which the task assessment was run.
        /// </p>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>The date the task assessment was completed. </p>
        pub fn replication_task_last_assessment_date(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.replication_task_last_assessment_date = Some(input);
            self
        }
        /// <p>The date the task assessment was completed. </p>
        pub fn set_replication_task_last_assessment_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.replication_task_last_assessment_date = input;
            self
        }
        /// <p> The status of the task assessment. </p>
        pub fn assessment_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_status = Some(input.into());
            self
        }
        /// <p> The status of the task assessment. </p>
        pub fn set_assessment_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_status = input;
            self
        }
        /// <p> The file containing the results of the task assessment. </p>
        pub fn assessment_results_file(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_results_file = Some(input.into());
            self
        }
        /// <p> The file containing the results of the task assessment. </p>
        pub fn set_assessment_results_file(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_results_file = input;
            self
        }
        /// <p> The task assessment results in JSON format. </p>
        /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
        /// in the request.</p>
        pub fn assessment_results(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_results = Some(input.into());
            self
        }
        /// <p> The task assessment results in JSON format. </p>
        /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
        /// in the request.</p>
        pub fn set_assessment_results(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_results = input;
            self
        }
        /// <p> The URL of the S3 object containing the task assessment results. </p>
        /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
        /// in the request.</p>
        pub fn s3_object_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_object_url = Some(input.into());
            self
        }
        /// <p> The URL of the S3 object containing the task assessment results. </p>
        /// <p>The response object only contains this field if you provide <a>DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn</a>
        /// in the request.</p>
        pub fn set_s3_object_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_object_url = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationTaskAssessmentResult`](crate::model::ReplicationTaskAssessmentResult)
        pub fn build(self) -> crate::model::ReplicationTaskAssessmentResult {
            crate::model::ReplicationTaskAssessmentResult {
                replication_task_identifier: self.replication_task_identifier,
                replication_task_arn: self.replication_task_arn,
                replication_task_last_assessment_date: self.replication_task_last_assessment_date,
                assessment_status: self.assessment_status,
                assessment_results_file: self.assessment_results_file,
                assessment_results: self.assessment_results,
                s3_object_url: self.s3_object_url,
            }
        }
    }
}
impl ReplicationTaskAssessmentResult {
    /// Creates a new builder-style object to manufacture [`ReplicationTaskAssessmentResult`](crate::model::ReplicationTaskAssessmentResult)
    pub fn builder() -> crate::model::replication_task_assessment_result::Builder {
        crate::model::replication_task_assessment_result::Builder::default()
    }
}

/// <p>Contains metadata for a replication instance task log.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationInstanceTaskLog {
    /// <p>The name of the replication task.</p>
    pub replication_task_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>The size, in bytes, of the replication task log.</p>
    pub replication_instance_task_log_size: i64,
}
impl ReplicationInstanceTaskLog {
    /// <p>The name of the replication task.</p>
    pub fn replication_task_name(&self) -> std::option::Option<&str> {
        self.replication_task_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
    pub fn replication_task_arn(&self) -> std::option::Option<&str> {
        self.replication_task_arn.as_deref()
    }
    /// <p>The size, in bytes, of the replication task log.</p>
    pub fn replication_instance_task_log_size(&self) -> i64 {
        self.replication_instance_task_log_size
    }
}
impl std::fmt::Debug for ReplicationInstanceTaskLog {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationInstanceTaskLog");
        formatter.field("replication_task_name", &self.replication_task_name);
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field(
            "replication_instance_task_log_size",
            &self.replication_instance_task_log_size,
        );
        formatter.finish()
    }
}
/// See [`ReplicationInstanceTaskLog`](crate::model::ReplicationInstanceTaskLog)
pub mod replication_instance_task_log {
    /// A builder for [`ReplicationInstanceTaskLog`](crate::model::ReplicationInstanceTaskLog)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_name: std::option::Option<std::string::String>,
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_task_log_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the replication task.</p>
        pub fn replication_task_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_name = Some(input.into());
            self
        }
        /// <p>The name of the replication task.</p>
        pub fn set_replication_task_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>The size, in bytes, of the replication task log.</p>
        pub fn replication_instance_task_log_size(mut self, input: i64) -> Self {
            self.replication_instance_task_log_size = Some(input);
            self
        }
        /// <p>The size, in bytes, of the replication task log.</p>
        pub fn set_replication_instance_task_log_size(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.replication_instance_task_log_size = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationInstanceTaskLog`](crate::model::ReplicationInstanceTaskLog)
        pub fn build(self) -> crate::model::ReplicationInstanceTaskLog {
            crate::model::ReplicationInstanceTaskLog {
                replication_task_name: self.replication_task_name,
                replication_task_arn: self.replication_task_arn,
                replication_instance_task_log_size: self
                    .replication_instance_task_log_size
                    .unwrap_or_default(),
            }
        }
    }
}
impl ReplicationInstanceTaskLog {
    /// Creates a new builder-style object to manufacture [`ReplicationInstanceTaskLog`](crate::model::ReplicationInstanceTaskLog)
    pub fn builder() -> crate::model::replication_instance_task_log::Builder {
        crate::model::replication_instance_task_log::Builder::default()
    }
}

/// <p>Identifies an DMS resource and any pending actions for it.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePendingMaintenanceActions {
    /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action
    /// applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html"> Constructing an Amazon
    /// Resource Name (ARN) for DMS</a> in the DMS documentation.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>Detailed information about the pending maintenance action.</p>
    pub pending_maintenance_action_details:
        std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
}
impl ResourcePendingMaintenanceActions {
    /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action
    /// applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html"> Constructing an Amazon
    /// Resource Name (ARN) for DMS</a> in the DMS documentation.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>Detailed information about the pending maintenance action.</p>
    pub fn pending_maintenance_action_details(
        &self,
    ) -> std::option::Option<&[crate::model::PendingMaintenanceAction]> {
        self.pending_maintenance_action_details.as_deref()
    }
}
impl std::fmt::Debug for ResourcePendingMaintenanceActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePendingMaintenanceActions");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field(
            "pending_maintenance_action_details",
            &self.pending_maintenance_action_details,
        );
        formatter.finish()
    }
}
/// See [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
pub mod resource_pending_maintenance_actions {
    /// A builder for [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) pending_maintenance_action_details:
            std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action
        /// applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html"> Constructing an Amazon
        /// Resource Name (ARN) for DMS</a> in the DMS documentation.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance action
        /// applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html"> Constructing an Amazon
        /// Resource Name (ARN) for DMS</a> in the DMS documentation.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Appends an item to `pending_maintenance_action_details`.
        ///
        /// To override the contents of this collection use [`set_pending_maintenance_action_details`](Self::set_pending_maintenance_action_details).
        ///
        /// <p>Detailed information about the pending maintenance action.</p>
        pub fn pending_maintenance_action_details(
            mut self,
            input: impl Into<crate::model::PendingMaintenanceAction>,
        ) -> Self {
            let mut v = self.pending_maintenance_action_details.unwrap_or_default();
            v.push(input.into());
            self.pending_maintenance_action_details = Some(v);
            self
        }
        /// <p>Detailed information about the pending maintenance action.</p>
        pub fn set_pending_maintenance_action_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
        ) -> Self {
            self.pending_maintenance_action_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
        pub fn build(self) -> crate::model::ResourcePendingMaintenanceActions {
            crate::model::ResourcePendingMaintenanceActions {
                resource_identifier: self.resource_identifier,
                pending_maintenance_action_details: self.pending_maintenance_action_details,
            }
        }
    }
}
impl ResourcePendingMaintenanceActions {
    /// Creates a new builder-style object to manufacture [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    pub fn builder() -> crate::model::resource_pending_maintenance_actions::Builder {
        crate::model::resource_pending_maintenance_actions::Builder::default()
    }
}

/// <p>Describes a maintenance action pending for an DMS resource, including when and how
/// it will be applied. This data type is a response element to the
/// <code>DescribePendingMaintenanceActions</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The date of the maintenance window when the action is to be applied. The maintenance
    /// action is applied to the resource during its first maintenance window after this date. If
    /// this date is specified, any <code>next-maintenance</code> opt-in requests are
    /// ignored.</p>
    pub auto_applied_after_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the maintenance action will be automatically applied. The maintenance
    /// action is applied to the resource on this date regardless of the maintenance window for the
    /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
    /// ignored.</p>
    pub forced_apply_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of opt-in request that has been received for the resource.</p>
    pub opt_in_status: std::option::Option<std::string::String>,
    /// <p>The effective date when the pending maintenance action will be applied to the resource.
    /// This date takes into account opt-in requests received from the
    /// <code>ApplyPendingMaintenanceAction</code> API operation, and also the
    /// <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values.
    /// This value is blank if an opt-in request has not been received and nothing has been
    /// specified for <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
    pub current_apply_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A description providing more detail about the maintenance action.</p>
    pub description: std::option::Option<std::string::String>,
}
impl PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The date of the maintenance window when the action is to be applied. The maintenance
    /// action is applied to the resource during its first maintenance window after this date. If
    /// this date is specified, any <code>next-maintenance</code> opt-in requests are
    /// ignored.</p>
    pub fn auto_applied_after_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.auto_applied_after_date.as_ref()
    }
    /// <p>The date when the maintenance action will be automatically applied. The maintenance
    /// action is applied to the resource on this date regardless of the maintenance window for the
    /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
    /// ignored.</p>
    pub fn forced_apply_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.forced_apply_date.as_ref()
    }
    /// <p>The type of opt-in request that has been received for the resource.</p>
    pub fn opt_in_status(&self) -> std::option::Option<&str> {
        self.opt_in_status.as_deref()
    }
    /// <p>The effective date when the pending maintenance action will be applied to the resource.
    /// This date takes into account opt-in requests received from the
    /// <code>ApplyPendingMaintenanceAction</code> API operation, and also the
    /// <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values.
    /// This value is blank if an opt-in request has not been received and nothing has been
    /// specified for <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
    pub fn current_apply_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.current_apply_date.as_ref()
    }
    /// <p>A description providing more detail about the maintenance action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for PendingMaintenanceAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingMaintenanceAction");
        formatter.field("action", &self.action);
        formatter.field("auto_applied_after_date", &self.auto_applied_after_date);
        formatter.field("forced_apply_date", &self.forced_apply_date);
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.field("current_apply_date", &self.current_apply_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
pub mod pending_maintenance_action {
    /// A builder for [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) auto_applied_after_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) forced_apply_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) opt_in_status: std::option::Option<std::string::String>,
        pub(crate) current_apply_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of pending maintenance action that is available for the resource.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The type of pending maintenance action that is available for the resource.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The date of the maintenance window when the action is to be applied. The maintenance
        /// action is applied to the resource during its first maintenance window after this date. If
        /// this date is specified, any <code>next-maintenance</code> opt-in requests are
        /// ignored.</p>
        pub fn auto_applied_after_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.auto_applied_after_date = Some(input);
            self
        }
        /// <p>The date of the maintenance window when the action is to be applied. The maintenance
        /// action is applied to the resource during its first maintenance window after this date. If
        /// this date is specified, any <code>next-maintenance</code> opt-in requests are
        /// ignored.</p>
        pub fn set_auto_applied_after_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.auto_applied_after_date = input;
            self
        }
        /// <p>The date when the maintenance action will be automatically applied. The maintenance
        /// action is applied to the resource on this date regardless of the maintenance window for the
        /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
        /// ignored.</p>
        pub fn forced_apply_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.forced_apply_date = Some(input);
            self
        }
        /// <p>The date when the maintenance action will be automatically applied. The maintenance
        /// action is applied to the resource on this date regardless of the maintenance window for the
        /// resource. If this date is specified, any <code>immediate</code> opt-in requests are
        /// ignored.</p>
        pub fn set_forced_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.forced_apply_date = input;
            self
        }
        /// <p>The type of opt-in request that has been received for the resource.</p>
        pub fn opt_in_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_status = Some(input.into());
            self
        }
        /// <p>The type of opt-in request that has been received for the resource.</p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// <p>The effective date when the pending maintenance action will be applied to the resource.
        /// This date takes into account opt-in requests received from the
        /// <code>ApplyPendingMaintenanceAction</code> API operation, and also the
        /// <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values.
        /// This value is blank if an opt-in request has not been received and nothing has been
        /// specified for <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
        pub fn current_apply_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.current_apply_date = Some(input);
            self
        }
        /// <p>The effective date when the pending maintenance action will be applied to the resource.
        /// This date takes into account opt-in requests received from the
        /// <code>ApplyPendingMaintenanceAction</code> API operation, and also the
        /// <code>AutoAppliedAfterDate</code> and <code>ForcedApplyDate</code> parameter values.
        /// This value is blank if an opt-in request has not been received and nothing has been
        /// specified for <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
        pub fn set_current_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.current_apply_date = input;
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
        pub fn build(self) -> crate::model::PendingMaintenanceAction {
            crate::model::PendingMaintenanceAction {
                action: self.action,
                auto_applied_after_date: self.auto_applied_after_date,
                forced_apply_date: self.forced_apply_date,
                opt_in_status: self.opt_in_status,
                current_apply_date: self.current_apply_date,
                description: self.description,
            }
        }
    }
}
impl PendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    pub fn builder() -> crate::model::pending_maintenance_action::Builder {
        crate::model::pending_maintenance_action::Builder::default()
    }
}

/// <p>In response to the <code>DescribeOrderableReplicationInstances</code> operation, this
/// object describes an available replication instance. This description includes the
/// replication instance's type, engine version, and allocated storage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderableReplicationInstance {
    /// <p>The version of the replication engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub replication_instance_class: std::option::Option<std::string::String>,
    /// <p>The type of storage used by the replication instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
    /// instance.</p>
    pub min_allocated_storage: i32,
    /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
    /// instance.</p>
    pub max_allocated_storage: i32,
    /// <p>The default amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub default_allocated_storage: i32,
    /// <p>The amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub included_allocated_storage: i32,
    /// <p>List of Availability Zones for this replication instance.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The value returned when the specified <code>EngineVersion</code> of the replication
    /// instance is in Beta or test mode. This indicates some features might not work as expected.</p>
    /// <note>
    /// <p>DMS supports the <code>ReleaseStatus</code> parameter in versions 3.1.4 and later.</p>
    /// </note>
    pub release_status: std::option::Option<crate::model::ReleaseStatusValues>,
}
impl OrderableReplicationInstance {
    /// <p>The version of the replication engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub fn replication_instance_class(&self) -> std::option::Option<&str> {
        self.replication_instance_class.as_deref()
    }
    /// <p>The type of storage used by the replication instance.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
    /// instance.</p>
    pub fn min_allocated_storage(&self) -> i32 {
        self.min_allocated_storage
    }
    /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
    /// instance.</p>
    pub fn max_allocated_storage(&self) -> i32 {
        self.max_allocated_storage
    }
    /// <p>The default amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub fn default_allocated_storage(&self) -> i32 {
        self.default_allocated_storage
    }
    /// <p>The amount of storage (in gigabytes) that is allocated for the replication
    /// instance.</p>
    pub fn included_allocated_storage(&self) -> i32 {
        self.included_allocated_storage
    }
    /// <p>List of Availability Zones for this replication instance.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>The value returned when the specified <code>EngineVersion</code> of the replication
    /// instance is in Beta or test mode. This indicates some features might not work as expected.</p>
    /// <note>
    /// <p>DMS supports the <code>ReleaseStatus</code> parameter in versions 3.1.4 and later.</p>
    /// </note>
    pub fn release_status(&self) -> std::option::Option<&crate::model::ReleaseStatusValues> {
        self.release_status.as_ref()
    }
}
impl std::fmt::Debug for OrderableReplicationInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderableReplicationInstance");
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "replication_instance_class",
            &self.replication_instance_class,
        );
        formatter.field("storage_type", &self.storage_type);
        formatter.field("min_allocated_storage", &self.min_allocated_storage);
        formatter.field("max_allocated_storage", &self.max_allocated_storage);
        formatter.field("default_allocated_storage", &self.default_allocated_storage);
        formatter.field(
            "included_allocated_storage",
            &self.included_allocated_storage,
        );
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("release_status", &self.release_status);
        formatter.finish()
    }
}
/// See [`OrderableReplicationInstance`](crate::model::OrderableReplicationInstance)
pub mod orderable_replication_instance {
    /// A builder for [`OrderableReplicationInstance`](crate::model::OrderableReplicationInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) replication_instance_class: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) min_allocated_storage: std::option::Option<i32>,
        pub(crate) max_allocated_storage: std::option::Option<i32>,
        pub(crate) default_allocated_storage: std::option::Option<i32>,
        pub(crate) included_allocated_storage: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) release_status: std::option::Option<crate::model::ReleaseStatusValues>,
    }
    impl Builder {
        /// <p>The version of the replication engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version of the replication engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn replication_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_class = input;
            self
        }
        /// <p>The type of storage used by the replication instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>The type of storage used by the replication instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
        /// instance.</p>
        pub fn min_allocated_storage(mut self, input: i32) -> Self {
            self.min_allocated_storage = Some(input);
            self
        }
        /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
        /// instance.</p>
        pub fn set_min_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.min_allocated_storage = input;
            self
        }
        /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
        /// instance.</p>
        pub fn max_allocated_storage(mut self, input: i32) -> Self {
            self.max_allocated_storage = Some(input);
            self
        }
        /// <p>The minimum amount of storage (in gigabytes) that can be allocated for the replication
        /// instance.</p>
        pub fn set_max_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.max_allocated_storage = input;
            self
        }
        /// <p>The default amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn default_allocated_storage(mut self, input: i32) -> Self {
            self.default_allocated_storage = Some(input);
            self
        }
        /// <p>The default amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn set_default_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.default_allocated_storage = input;
            self
        }
        /// <p>The amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn included_allocated_storage(mut self, input: i32) -> Self {
            self.included_allocated_storage = Some(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) that is allocated for the replication
        /// instance.</p>
        pub fn set_included_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.included_allocated_storage = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>List of Availability Zones for this replication instance.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>List of Availability Zones for this replication instance.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The value returned when the specified <code>EngineVersion</code> of the replication
        /// instance is in Beta or test mode. This indicates some features might not work as expected.</p>
        /// <note>
        /// <p>DMS supports the <code>ReleaseStatus</code> parameter in versions 3.1.4 and later.</p>
        /// </note>
        pub fn release_status(mut self, input: crate::model::ReleaseStatusValues) -> Self {
            self.release_status = Some(input);
            self
        }
        /// <p>The value returned when the specified <code>EngineVersion</code> of the replication
        /// instance is in Beta or test mode. This indicates some features might not work as expected.</p>
        /// <note>
        /// <p>DMS supports the <code>ReleaseStatus</code> parameter in versions 3.1.4 and later.</p>
        /// </note>
        pub fn set_release_status(
            mut self,
            input: std::option::Option<crate::model::ReleaseStatusValues>,
        ) -> Self {
            self.release_status = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderableReplicationInstance`](crate::model::OrderableReplicationInstance)
        pub fn build(self) -> crate::model::OrderableReplicationInstance {
            crate::model::OrderableReplicationInstance {
                engine_version: self.engine_version,
                replication_instance_class: self.replication_instance_class,
                storage_type: self.storage_type,
                min_allocated_storage: self.min_allocated_storage.unwrap_or_default(),
                max_allocated_storage: self.max_allocated_storage.unwrap_or_default(),
                default_allocated_storage: self.default_allocated_storage.unwrap_or_default(),
                included_allocated_storage: self.included_allocated_storage.unwrap_or_default(),
                availability_zones: self.availability_zones,
                release_status: self.release_status,
            }
        }
    }
}
impl OrderableReplicationInstance {
    /// Creates a new builder-style object to manufacture [`OrderableReplicationInstance`](crate::model::OrderableReplicationInstance)
    pub fn builder() -> crate::model::orderable_replication_instance::Builder {
        crate::model::orderable_replication_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReleaseStatusValues {
    #[allow(missing_docs)] // documentation missing in model
    Beta,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReleaseStatusValues {
    fn from(s: &str) -> Self {
        match s {
            "beta" => ReleaseStatusValues::Beta,
            other => ReleaseStatusValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReleaseStatusValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReleaseStatusValues::from(s))
    }
}
impl ReleaseStatusValues {
    /// Returns the `&str` value of the e