// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>DMS was denied access to the endpoint. Check that the role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>There are not enough resources allocated to the database migration.</p>
    InsufficientResourceCapacityFault(crate::error::InsufficientResourceCapacityFault),
    /// <p>The certificate was not valid.</p>
    InvalidCertificateFault(crate::error::InvalidCertificateFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The subnet provided is invalid.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.</p>
    KmsAccessDeniedFault(crate::error::KmsAccessDeniedFault),
    /// <p>The specified KMS key isn't enabled.</p>
    KmsDisabledFault(crate::error::KmsDisabledFault),
    /// <p>An Key Management Service (KMS) error is preventing access to KMS.</p>
    KmsFault(crate::error::KmsFault),
    /// <p>The state of the specified KMS resource isn't valid for this request.</p>
    KmsInvalidStateFault(crate::error::KmsInvalidStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified KMS entity or resource can't be found.</p>
    KmsNotFoundFault(crate::error::KmsNotFoundFault),
    /// <p>This request triggered KMS request throttling.</p>
    KmsThrottlingFault(crate::error::KmsThrottlingFault),
    /// <p>The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</p>
    ReplicationSubnetGroupDoesNotCoverEnoughAZs(
        crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs,
    ),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// <p>Insufficient privileges are preventing access to an Amazon S3 object.</p>
    S3AccessDeniedFault(crate::error::S3AccessDeniedFault),
    /// <p>A specified Amazon S3 bucket, bucket folder, or other object can't be found.</p>
    S3ResourceNotFoundFault(crate::error::S3ResourceNotFoundFault),
    /// <p>The SNS topic is invalid.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You are not authorized for the SNS subscription.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The storage quota has been exceeded.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>The specified subnet is already in use.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// <p>An upgrade dependency is preventing the database migration.</p>
    UpgradeDependencyFailureFault(crate::error::UpgradeDependencyFailureFault),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AccessDeniedFault(inner) => inner.fmt(f),
            Error::InsufficientResourceCapacityFault(inner) => inner.fmt(f),
            Error::InvalidCertificateFault(inner) => inner.fmt(f),
            Error::InvalidResourceStateFault(inner) => inner.fmt(f),
            Error::InvalidSubnet(inner) => inner.fmt(f),
            Error::KmsAccessDeniedFault(inner) => inner.fmt(f),
            Error::KmsDisabledFault(inner) => inner.fmt(f),
            Error::KmsFault(inner) => inner.fmt(f),
            Error::KmsInvalidStateFault(inner) => inner.fmt(f),
            Error::KmsKeyNotAccessibleFault(inner) => inner.fmt(f),
            Error::KmsNotFoundFault(inner) => inner.fmt(f),
            Error::KmsThrottlingFault(inner) => inner.fmt(f),
            Error::ReplicationSubnetGroupDoesNotCoverEnoughAZs(inner) => inner.fmt(f),
            Error::ResourceAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ResourceNotFoundFault(inner) => inner.fmt(f),
            Error::ResourceQuotaExceededFault(inner) => inner.fmt(f),
            Error::S3AccessDeniedFault(inner) => inner.fmt(f),
            Error::S3ResourceNotFoundFault(inner) => inner.fmt(f),
            Error::SnsInvalidTopicFault(inner) => inner.fmt(f),
            Error::SnsNoAuthorizationFault(inner) => inner.fmt(f),
            Error::StorageQuotaExceededFault(inner) => inner.fmt(f),
            Error::SubnetAlreadyInUse(inner) => inner.fmt(f),
            Error::UpgradeDependencyFailureFault(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::CancelReplicationTaskAssessmentRunError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::CancelReplicationTaskAssessmentRunError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CancelReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::CancelReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::CancelReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::CancelReplicationTaskAssessmentRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateEndpointErrorKind::AccessDeniedFault(inner) => {
                    Error::AccessDeniedFault(inner)
                }
                crate::error::CreateEndpointErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::CreateEndpointErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateEndpointErrorKind::ResourceAlreadyExistsFault(inner) => {
                    Error::ResourceAlreadyExistsFault(inner)
                }
                crate::error::CreateEndpointErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::CreateEndpointErrorKind::ResourceQuotaExceededFault(inner) => {
                    Error::ResourceQuotaExceededFault(inner)
                }
                crate::error::CreateEndpointErrorKind::S3AccessDeniedFault(inner) => {
                    Error::S3AccessDeniedFault(inner)
                }
                crate::error::CreateEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateEventSubscriptionErrorKind::KmsAccessDeniedFault(inner) => {
                    Error::KmsAccessDeniedFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::KmsDisabledFault(inner) => {
                    Error::KmsDisabledFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::KmsInvalidStateFault(inner) => {
                    Error::KmsInvalidStateFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::KmsNotFoundFault(inner) => {
                    Error::KmsNotFoundFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::KmsThrottlingFault(inner) => {
                    Error::KmsThrottlingFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::ResourceAlreadyExistsFault(
                    inner,
                ) => Error::ResourceAlreadyExistsFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::ResourceQuotaExceededFault(
                    inner,
                ) => Error::ResourceQuotaExceededFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => {
                    Error::SnsInvalidTopicFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => {
                    Error::SnsNoAuthorizationFault(inner)
                }
                crate::error::CreateEventSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateReplicationInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateReplicationInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateReplicationInstanceErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::InsufficientResourceCapacityFault(inner) => Error::InsufficientResourceCapacityFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::CreateReplicationInstanceErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(inner) => Error::ReplicationSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateReplicationInstanceErrorKind::ResourceAlreadyExistsFault(inner) => Error::ResourceAlreadyExistsFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::ResourceQuotaExceededFault(inner) => Error::ResourceQuotaExceededFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::CreateReplicationInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateReplicationSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateReplicationSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateReplicationSubnetGroupErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::CreateReplicationSubnetGroupErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::CreateReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(inner) => Error::ReplicationSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateReplicationSubnetGroupErrorKind::ResourceAlreadyExistsFault(inner) => Error::ResourceAlreadyExistsFault(inner),
                crate::error::CreateReplicationSubnetGroupErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::CreateReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(inner) => Error::ResourceQuotaExceededFault(inner),
                crate::error::CreateReplicationSubnetGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateReplicationTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateReplicationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateReplicationTaskErrorKind::AccessDeniedFault(inner) => {
                    Error::AccessDeniedFault(inner)
                }
                crate::error::CreateReplicationTaskErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::CreateReplicationTaskErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateReplicationTaskErrorKind::ResourceAlreadyExistsFault(inner) => {
                    Error::ResourceAlreadyExistsFault(inner)
                }
                crate::error::CreateReplicationTaskErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::CreateReplicationTaskErrorKind::ResourceQuotaExceededFault(inner) => {
                    Error::ResourceQuotaExceededFault(inner)
                }
                crate::error::CreateReplicationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteCertificateErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::DeleteCertificateErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DeleteCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteConnectionErrorKind::AccessDeniedFault(inner) => {
                    Error::AccessDeniedFault(inner)
                }
                crate::error::DeleteConnectionErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::DeleteConnectionErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DeleteConnectionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEndpointErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::DeleteEndpointErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DeleteEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteEventSubscriptionErrorKind::InvalidResourceStateFault(
                    inner,
                ) => Error::InvalidResourceStateFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DeleteEventSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteReplicationInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteReplicationInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteReplicationInstanceErrorKind::InvalidResourceStateFault(
                    inner,
                ) => Error::InvalidResourceStateFault(inner),
                crate::error::DeleteReplicationInstanceErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DeleteReplicationInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteReplicationSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteReplicationSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteReplicationSubnetGroupErrorKind::InvalidResourceStateFault(
                    inner,
                ) => Error::InvalidResourceStateFault(inner),
                crate::error::DeleteReplicationSubnetGroupErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DeleteReplicationSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteReplicationTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteReplicationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteReplicationTaskErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::DeleteReplicationTaskErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DeleteReplicationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DeleteReplicationTaskAssessmentRunError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteReplicationTaskAssessmentRunError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::DeleteReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::DeleteReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::DeleteReplicationTaskAssessmentRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeApplicableIndividualAssessmentsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeApplicableIndividualAssessmentsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeApplicableIndividualAssessmentsErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::DescribeApplicableIndividualAssessmentsErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::DescribeApplicableIndividualAssessmentsErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeApplicableIndividualAssessmentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCertificatesErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeCertificatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeConnectionsErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeConnectionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEndpointsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEndpointsErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeEndpointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEndpointSettingsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEndpointSettingsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEndpointSettingsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEndpointTypesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEndpointTypesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEndpointTypesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventCategoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventSubscriptionsErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeEventSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeOrderableReplicationInstancesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrderableReplicationInstancesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOrderableReplicationInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribePendingMaintenanceActionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribePendingMaintenanceActionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeRefreshSchemasStatusError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeRefreshSchemasStatusError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeRefreshSchemasStatusErrorKind::InvalidResourceStateFault(
                    inner,
                ) => Error::InvalidResourceStateFault(inner),
                crate::error::DescribeRefreshSchemasStatusErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeRefreshSchemasStatusErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeReplicationInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeReplicationInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeReplicationInstancesErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeReplicationInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationInstanceTaskLogsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationInstanceTaskLogsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReplicationInstanceTaskLogsErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::DescribeReplicationInstanceTaskLogsErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeReplicationInstanceTaskLogsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeReplicationSubnetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationSubnetGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeReplicationSubnetGroupsErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeReplicationSubnetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationTaskAssessmentResultsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationTaskAssessmentResultsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReplicationTaskAssessmentResultsErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeReplicationTaskAssessmentResultsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationTaskAssessmentRunsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationTaskAssessmentRunsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReplicationTaskAssessmentRunsErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeReplicationTaskAssessmentRunsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationTaskIndividualAssessmentsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReplicationTaskIndividualAssessmentsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReplicationTaskIndividualAssessmentsErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribeReplicationTaskIndividualAssessmentsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeReplicationTasksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeReplicationTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeReplicationTasksErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeReplicationTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSchemasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeSchemasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSchemasErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::DescribeSchemasErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeSchemasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeTableStatisticsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeTableStatisticsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeTableStatisticsErrorKind::InvalidResourceStateFault(
                    inner,
                ) => Error::InvalidResourceStateFault(inner),
                crate::error::DescribeTableStatisticsErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::DescribeTableStatisticsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportCertificateError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportCertificateError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ImportCertificateErrorKind::InvalidCertificateFault(inner) => {
                    Error::InvalidCertificateFault(inner)
                }
                crate::error::ImportCertificateErrorKind::ResourceAlreadyExistsFault(inner) => {
                    Error::ResourceAlreadyExistsFault(inner)
                }
                crate::error::ImportCertificateErrorKind::ResourceQuotaExceededFault(inner) => {
                    Error::ResourceQuotaExceededFault(inner)
                }
                crate::error::ImportCertificateErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyEndpointError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyEndpointError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyEndpointErrorKind::AccessDeniedFault(inner) => {
                    Error::AccessDeniedFault(inner)
                }
                crate::error::ModifyEndpointErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::ModifyEndpointErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::ModifyEndpointErrorKind::ResourceAlreadyExistsFault(inner) => {
                    Error::ResourceAlreadyExistsFault(inner)
                }
                crate::error::ModifyEndpointErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::ModifyEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyEventSubscriptionErrorKind::KmsAccessDeniedFault(inner) => {
                    Error::KmsAccessDeniedFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::KmsDisabledFault(inner) => {
                    Error::KmsDisabledFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::KmsInvalidStateFault(inner) => {
                    Error::KmsInvalidStateFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::KmsNotFoundFault(inner) => {
                    Error::KmsNotFoundFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::KmsThrottlingFault(inner) => {
                    Error::KmsThrottlingFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::ResourceQuotaExceededFault(
                    inner,
                ) => Error::ResourceQuotaExceededFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => {
                    Error::SnsInvalidTopicFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => {
                    Error::SnsNoAuthorizationFault(inner)
                }
                crate::error::ModifyEventSubscriptionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyReplicationInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyReplicationInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyReplicationInstanceErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::ModifyReplicationInstanceErrorKind::InsufficientResourceCapacityFault(inner) => Error::InsufficientResourceCapacityFault(inner),
                crate::error::ModifyReplicationInstanceErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::ModifyReplicationInstanceErrorKind::ResourceAlreadyExistsFault(inner) => Error::ResourceAlreadyExistsFault(inner),
                crate::error::ModifyReplicationInstanceErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::ModifyReplicationInstanceErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::ModifyReplicationInstanceErrorKind::UpgradeDependencyFailureFault(inner) => Error::UpgradeDependencyFailureFault(inner),
                crate::error::ModifyReplicationInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyReplicationSubnetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyReplicationSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyReplicationSubnetGroupErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::ModifyReplicationSubnetGroupErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::ModifyReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(inner) => Error::ReplicationSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::ModifyReplicationSubnetGroupErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::ModifyReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(inner) => Error::ResourceQuotaExceededFault(inner),
                crate::error::ModifyReplicationSubnetGroupErrorKind::SubnetAlreadyInUse(inner) => Error::SubnetAlreadyInUse(inner),
                crate::error::ModifyReplicationSubnetGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyReplicationTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyReplicationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyReplicationTaskErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::ModifyReplicationTaskErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::ModifyReplicationTaskErrorKind::ResourceAlreadyExistsFault(inner) => {
                    Error::ResourceAlreadyExistsFault(inner)
                }
                crate::error::ModifyReplicationTaskErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::ModifyReplicationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::MoveReplicationTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::MoveReplicationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::MoveReplicationTaskErrorKind::AccessDeniedFault(inner) => {
                    Error::AccessDeniedFault(inner)
                }
                crate::error::MoveReplicationTaskErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::MoveReplicationTaskErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::MoveReplicationTaskErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::MoveReplicationTaskErrorKind::ResourceQuotaExceededFault(inner) => {
                    Error::ResourceQuotaExceededFault(inner)
                }
                crate::error::MoveReplicationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootReplicationInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebootReplicationInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootReplicationInstanceErrorKind::InvalidResourceStateFault(
                    inner,
                ) => Error::InvalidResourceStateFault(inner),
                crate::error::RebootReplicationInstanceErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::RebootReplicationInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RefreshSchemasError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::RefreshSchemasError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RefreshSchemasErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::RefreshSchemasErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::RefreshSchemasErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::RefreshSchemasErrorKind::ResourceQuotaExceededFault(inner) => {
                    Error::ResourceQuotaExceededFault(inner)
                }
                crate::error::RefreshSchemasErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ReloadTablesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ReloadTablesError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ReloadTablesErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::ReloadTablesErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::ReloadTablesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartReplicationTaskErrorKind::AccessDeniedFault(inner) => {
                    Error::AccessDeniedFault(inner)
                }
                crate::error::StartReplicationTaskErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::StartReplicationTaskErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::StartReplicationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskAssessmentError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartReplicationTaskAssessmentError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartReplicationTaskAssessmentErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::StartReplicationTaskAssessmentErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::StartReplicationTaskAssessmentErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskAssessmentRunError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartReplicationTaskAssessmentRunError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(inner) => Error::AccessDeniedFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(inner) => Error::InvalidResourceStateFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsAccessDeniedFault(inner) => Error::KmsAccessDeniedFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsDisabledFault(inner) => Error::KmsDisabledFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsFault(inner) => Error::KmsFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsInvalidStateFault(inner) => Error::KmsInvalidStateFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::KmsNotFoundFault(inner) => Error::KmsNotFoundFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::ResourceAlreadyExistsFault(inner) => Error::ResourceAlreadyExistsFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::S3AccessDeniedFault(inner) => Error::S3AccessDeniedFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::S3ResourceNotFoundFault(inner) => Error::S3ResourceNotFoundFault(inner),
                crate::error::StartReplicationTaskAssessmentRunErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopReplicationTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopReplicationTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopReplicationTaskErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::StopReplicationTaskErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::StopReplicationTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::TestConnectionError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::TestConnectionError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::TestConnectionErrorKind::AccessDeniedFault(inner) => {
                    Error::AccessDeniedFault(inner)
                }
                crate::error::TestConnectionErrorKind::InvalidResourceStateFault(inner) => {
                    Error::InvalidResourceStateFault(inner)
                }
                crate::error::TestConnectionErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::TestConnectionErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::TestConnectionErrorKind::ResourceQuotaExceededFault(inner) => {
                    Error::ResourceQuotaExceededFault(inner)
                }
                crate::error::TestConnectionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
