// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToResourceErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToResourceErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToResourceError {
    /// Creates a new `AddTagsToResourceError`.
    pub fn new(kind: AddTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for AddTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToResourceErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ApplyPendingMaintenanceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApplyPendingMaintenanceActionError {
    /// Kind of error that occurred.
    pub kind: ApplyPendingMaintenanceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApplyPendingMaintenanceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApplyPendingMaintenanceActionErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApplyPendingMaintenanceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ApplyPendingMaintenanceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApplyPendingMaintenanceActionError {
    fn code(&self) -> Option<&str> {
        ApplyPendingMaintenanceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApplyPendingMaintenanceActionError {
    /// Creates a new `ApplyPendingMaintenanceActionError`.
    pub fn new(
        kind: ApplyPendingMaintenanceActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApplyPendingMaintenanceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApplyPendingMaintenanceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApplyPendingMaintenanceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApplyPendingMaintenanceActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for ApplyPendingMaintenanceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ApplyPendingMaintenanceActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelReplicationTaskAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelReplicationTaskAssessmentRunError {
    /// Kind of error that occurred.
    pub kind: CancelReplicationTaskAssessmentRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelReplicationTaskAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelReplicationTaskAssessmentRunErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelReplicationTaskAssessmentRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            CancelReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            CancelReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CancelReplicationTaskAssessmentRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelReplicationTaskAssessmentRunError {
    fn code(&self) -> Option<&str> {
        CancelReplicationTaskAssessmentRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelReplicationTaskAssessmentRunError {
    /// Creates a new `CancelReplicationTaskAssessmentRunError`.
    pub fn new(
        kind: CancelReplicationTaskAssessmentRunErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelReplicationTaskAssessmentRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelReplicationTaskAssessmentRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelReplicationTaskAssessmentRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelReplicationTaskAssessmentRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelReplicationTaskAssessmentRunErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CancelReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CancelReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for CancelReplicationTaskAssessmentRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            CancelReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            CancelReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            CancelReplicationTaskAssessmentRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEndpointError {
    /// Kind of error that occurred.
    pub kind: CreateEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEndpointErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// <p>Insufficient privileges are preventing access to an Amazon S3 object.</p>
    S3AccessDeniedFault(crate::error::S3AccessDeniedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEndpointErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::S3AccessDeniedFault(_inner) => _inner.fmt(f),
            CreateEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEndpointError {
    fn code(&self) -> Option<&str> {
        CreateEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEndpointError {
    /// Creates a new `CreateEndpointError`.
    pub fn new(kind: CreateEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(&self.kind, CreateEndpointErrorKind::AccessDeniedFault(_))
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointErrorKind::ResourceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointErrorKind::S3AccessDeniedFault`.
    pub fn is_s3_access_denied_fault(&self) -> bool {
        matches!(&self.kind, CreateEndpointErrorKind::S3AccessDeniedFault(_))
    }
}
impl std::error::Error for CreateEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEndpointErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            CreateEndpointErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            CreateEndpointErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateEndpointErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            CreateEndpointErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            CreateEndpointErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            CreateEndpointErrorKind::S3AccessDeniedFault(_inner) => Some(_inner),
            CreateEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventSubscriptionErrorKind {
    /// <p>The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.</p>
    KmsAccessDeniedFault(crate::error::KmsAccessDeniedFault),
    /// <p>The specified KMS key isn't enabled.</p>
    KmsDisabledFault(crate::error::KmsDisabledFault),
    /// <p>The state of the specified KMS resource isn't valid for this request.</p>
    KmsInvalidStateFault(crate::error::KmsInvalidStateFault),
    /// <p>The specified KMS entity or resource can't be found.</p>
    KmsNotFoundFault(crate::error::KmsNotFoundFault),
    /// <p>This request triggered KMS request throttling.</p>
    KmsThrottlingFault(crate::error::KmsThrottlingFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// <p>The SNS topic is invalid.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You are not authorized for the SNS subscription.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventSubscriptionErrorKind::KmsAccessDeniedFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::KmsDisabledFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::KmsInvalidStateFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::KmsNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::KmsThrottlingFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventSubscriptionError {
    /// Creates a new `CreateEventSubscriptionError`.
    pub fn new(kind: CreateEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::KmsAccessDeniedFault`.
    pub fn is_kms_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::KmsAccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::KmsDisabledFault`.
    pub fn is_kms_disabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::KmsDisabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::KmsInvalidStateFault`.
    pub fn is_kms_invalid_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::KmsInvalidStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::KmsNotFoundFault`.
    pub fn is_kms_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::KmsNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::KmsThrottlingFault`.
    pub fn is_kms_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::KmsThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::ResourceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
}
impl std::error::Error for CreateEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventSubscriptionErrorKind::KmsAccessDeniedFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::KmsDisabledFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::KmsInvalidStateFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::KmsNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::KmsThrottlingFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationInstanceError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationInstanceErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>There are not enough resources allocated to the database migration.</p>
    InsufficientResourceCapacityFault(crate::error::InsufficientResourceCapacityFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The subnet provided is invalid.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</p>
    ReplicationSubnetGroupDoesNotCoverEnoughAZs(
        crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs,
    ),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// <p>The storage quota has been exceeded.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationInstanceErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::InsufficientResourceCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateReplicationInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationInstanceError {
    fn code(&self) -> Option<&str> {
        CreateReplicationInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationInstanceError {
    /// Creates a new `CreateReplicationInstanceError`.
    pub fn new(kind: CreateReplicationInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::InsufficientResourceCapacityFault`.
    pub fn is_insufficient_resource_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::InsufficientResourceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_replication_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::ResourceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationInstanceErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationInstanceErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateReplicationInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationInstanceErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::InsufficientResourceCapacityFault(_inner) => {
                Some(_inner)
            }
            CreateReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => Some(_inner),
            CreateReplicationInstanceErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            CreateReplicationInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReplicationSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationSubnetGroupErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The subnet provided is invalid.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</p>
    ReplicationSubnetGroupDoesNotCoverEnoughAZs(
        crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs,
    ),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationSubnetGroupErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            CreateReplicationSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => _inner.fmt(f),
            CreateReplicationSubnetGroupErrorKind::ResourceAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateReplicationSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationSubnetGroupError {
    fn code(&self) -> Option<&str> {
        CreateReplicationSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationSubnetGroupError {
    /// Creates a new `CreateReplicationSubnetGroupError`.
    pub fn new(kind: CreateReplicationSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReplicationSubnetGroupErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSubnetGroupErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSubnetGroupErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_replication_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSubnetGroupErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSubnetGroupErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSubnetGroupErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateReplicationSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationSubnetGroupErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            CreateReplicationSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => Some(_inner),
            CreateReplicationSubnetGroupErrorKind::ResourceAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            CreateReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateReplicationSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateReplicationTaskError {
    /// Kind of error that occurred.
    pub kind: CreateReplicationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateReplicationTaskErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateReplicationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateReplicationTaskErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            CreateReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            CreateReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateReplicationTaskErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateReplicationTaskErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateReplicationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateReplicationTaskError {
    fn code(&self) -> Option<&str> {
        CreateReplicationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateReplicationTaskError {
    /// Creates a new `CreateReplicationTaskError`.
    pub fn new(kind: CreateReplicationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateReplicationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateReplicationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateReplicationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateReplicationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateReplicationTaskErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationTaskErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationTaskErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationTaskErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationTaskErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationTaskErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationTaskErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationTaskErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationTaskErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateReplicationTaskErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateReplicationTaskErrorKind::ResourceQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateReplicationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateReplicationTaskErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            CreateReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            CreateReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateReplicationTaskErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            CreateReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            CreateReplicationTaskErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            CreateReplicationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCertificateErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCertificateErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCertificateError {
    /// Creates a new `DeleteCertificateError`.
    pub fn new(kind: DeleteCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCertificateErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCertificateErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCertificateErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DeleteCertificateErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteConnectionError {
    /// Kind of error that occurred.
    pub kind: DeleteConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteConnectionErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteConnectionErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteConnectionError {
    fn code(&self) -> Option<&str> {
        DeleteConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteConnectionError {
    /// Creates a new `DeleteConnectionError`.
    pub fn new(kind: DeleteConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(&self.kind, DeleteConnectionErrorKind::AccessDeniedFault(_))
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteConnectionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteConnectionErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteConnectionErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            DeleteConnectionErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DeleteConnectionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEndpointErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEndpointErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEndpointError {
    /// Creates a new `DeleteEndpointError`.
    pub fn new(kind: DeleteEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEndpointErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DeleteEndpointErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventSubscriptionErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DeleteEventSubscriptionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventSubscriptionError {
    /// Creates a new `DeleteEventSubscriptionError`.
    pub fn new(kind: DeleteEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DeleteEventSubscriptionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationInstanceErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DeleteReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteReplicationInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationInstanceError {
    /// Creates a new `DeleteReplicationInstanceError`.
    pub fn new(kind: DeleteReplicationInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationInstanceErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationInstanceErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationInstanceErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationInstanceErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteReplicationInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DeleteReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteReplicationInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationSubnetGroupErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationSubnetGroupErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteReplicationSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationSubnetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationSubnetGroupError {
    /// Creates a new `DeleteReplicationSubnetGroupError`.
    pub fn new(kind: DeleteReplicationSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationSubnetGroupErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationSubnetGroupErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationSubnetGroupErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteReplicationSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationSubnetGroupErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            DeleteReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteReplicationSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationTaskError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationTaskErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DeleteReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteReplicationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationTaskError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationTaskError {
    /// Creates a new `DeleteReplicationTaskError`.
    pub fn new(kind: DeleteReplicationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationTaskErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationTaskErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationTaskErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationTaskErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteReplicationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DeleteReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteReplicationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteReplicationTaskAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteReplicationTaskAssessmentRunError {
    /// Kind of error that occurred.
    pub kind: DeleteReplicationTaskAssessmentRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteReplicationTaskAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteReplicationTaskAssessmentRunErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteReplicationTaskAssessmentRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            DeleteReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteReplicationTaskAssessmentRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteReplicationTaskAssessmentRunError {
    fn code(&self) -> Option<&str> {
        DeleteReplicationTaskAssessmentRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteReplicationTaskAssessmentRunError {
    /// Creates a new `DeleteReplicationTaskAssessmentRunError`.
    pub fn new(
        kind: DeleteReplicationTaskAssessmentRunErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteReplicationTaskAssessmentRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteReplicationTaskAssessmentRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteReplicationTaskAssessmentRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteReplicationTaskAssessmentRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteReplicationTaskAssessmentRunErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteReplicationTaskAssessmentRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            DeleteReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            DeleteReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteReplicationTaskAssessmentRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAttributesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAttributesError {
    /// Creates a new `DescribeAccountAttributesError`.
    pub fn new(kind: DescribeAccountAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAccountAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeApplicableIndividualAssessments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeApplicableIndividualAssessmentsError {
    /// Kind of error that occurred.
    pub kind: DescribeApplicableIndividualAssessmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeApplicableIndividualAssessments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeApplicableIndividualAssessmentsErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeApplicableIndividualAssessmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeApplicableIndividualAssessmentsErrorKind::AccessDeniedFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicableIndividualAssessmentsErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicableIndividualAssessmentsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeApplicableIndividualAssessmentsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeApplicableIndividualAssessmentsError {
    fn code(&self) -> Option<&str> {
        DescribeApplicableIndividualAssessmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeApplicableIndividualAssessmentsError {
    /// Creates a new `DescribeApplicableIndividualAssessmentsError`.
    pub fn new(
        kind: DescribeApplicableIndividualAssessmentsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeApplicableIndividualAssessmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeApplicableIndividualAssessmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeApplicableIndividualAssessmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeApplicableIndividualAssessmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeApplicableIndividualAssessmentsErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicableIndividualAssessmentsErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicableIndividualAssessmentsErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicableIndividualAssessmentsErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeApplicableIndividualAssessmentsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeApplicableIndividualAssessmentsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeApplicableIndividualAssessmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeApplicableIndividualAssessmentsErrorKind::AccessDeniedFault(_inner) => {
                Some(_inner)
            }
            DescribeApplicableIndividualAssessmentsErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            DescribeApplicableIndividualAssessmentsErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeApplicableIndividualAssessmentsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCertificatesError {
    /// Kind of error that occurred.
    pub kind: DescribeCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCertificatesErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCertificatesErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCertificatesError {
    fn code(&self) -> Option<&str> {
        DescribeCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCertificatesError {
    /// Creates a new `DescribeCertificatesError`.
    pub fn new(kind: DescribeCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCertificatesErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificatesErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCertificatesErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeConnectionsError {
    /// Kind of error that occurred.
    pub kind: DescribeConnectionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeConnections` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeConnectionsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeConnectionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeConnectionsErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeConnectionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeConnectionsError {
    fn code(&self) -> Option<&str> {
        DescribeConnectionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeConnectionsError {
    /// Creates a new `DescribeConnectionsError`.
    pub fn new(kind: DescribeConnectionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeConnectionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeConnectionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeConnectionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeConnectionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeConnectionsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeConnectionsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeConnectionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeConnectionsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeConnectionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointsError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointsErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointsError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointsError {
    /// Creates a new `DescribeEndpointsError`.
    pub fn new(kind: DescribeEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEndpointsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpointSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointSettingsError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointSettingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpointSettings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointSettingsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointSettingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointSettingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointSettingsError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointSettingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointSettingsError {
    /// Creates a new `DescribeEndpointSettingsError`.
    pub fn new(kind: DescribeEndpointSettingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointSettingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointSettingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointSettingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointSettingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEndpointSettingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointSettingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpointTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointTypesError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpointTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointTypesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointTypesError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointTypesError {
    /// Creates a new `DescribeEndpointTypesError`.
    pub fn new(kind: DescribeEndpointTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEndpointTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventCategoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeEventCategoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventCategoriesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventCategoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventCategoriesError {
    fn code(&self) -> Option<&str> {
        DescribeEventCategoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventCategoriesError {
    /// Creates a new `DescribeEventCategoriesError`.
    pub fn new(kind: DescribeEventCategoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventCategoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventSubscriptionsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventSubscriptionsError {
    fn code(&self) -> Option<&str> {
        DescribeEventSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventSubscriptionsError {
    /// Creates a new `DescribeEventSubscriptionsError`.
    pub fn new(kind: DescribeEventSubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventSubscriptionsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSubscriptionsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEventSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrderableReplicationInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrderableReplicationInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeOrderableReplicationInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrderableReplicationInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrderableReplicationInstancesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrderableReplicationInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrderableReplicationInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrderableReplicationInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeOrderableReplicationInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrderableReplicationInstancesError {
    /// Creates a new `DescribeOrderableReplicationInstancesError`.
    pub fn new(
        kind: DescribeOrderableReplicationInstancesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrderableReplicationInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrderableReplicationInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrderableReplicationInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrderableReplicationInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeOrderableReplicationInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrderableReplicationInstancesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribePendingMaintenanceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePendingMaintenanceActionsError {
    /// Kind of error that occurred.
    pub kind: DescribePendingMaintenanceActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePendingMaintenanceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePendingMaintenanceActionsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePendingMaintenanceActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribePendingMaintenanceActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePendingMaintenanceActionsError {
    fn code(&self) -> Option<&str> {
        DescribePendingMaintenanceActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePendingMaintenanceActionsError {
    /// Creates a new `DescribePendingMaintenanceActionsError`.
    pub fn new(
        kind: DescribePendingMaintenanceActionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePendingMaintenanceActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePendingMaintenanceActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePendingMaintenanceActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePendingMaintenanceActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribePendingMaintenanceActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribePendingMaintenanceActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRefreshSchemasStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRefreshSchemasStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeRefreshSchemasStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRefreshSchemasStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRefreshSchemasStatusErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRefreshSchemasStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRefreshSchemasStatusErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeRefreshSchemasStatusErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeRefreshSchemasStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRefreshSchemasStatusError {
    fn code(&self) -> Option<&str> {
        DescribeRefreshSchemasStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRefreshSchemasStatusError {
    /// Creates a new `DescribeRefreshSchemasStatusError`.
    pub fn new(kind: DescribeRefreshSchemasStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRefreshSchemasStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRefreshSchemasStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRefreshSchemasStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRefreshSchemasStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRefreshSchemasStatusErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRefreshSchemasStatusErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRefreshSchemasStatusErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRefreshSchemasStatusErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeRefreshSchemasStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRefreshSchemasStatusErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            DescribeRefreshSchemasStatusErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeRefreshSchemasStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReplicationInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationInstancesErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationInstancesErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeReplicationInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationInstancesError {
    /// Creates a new `DescribeReplicationInstancesError`.
    pub fn new(kind: DescribeReplicationInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationInstancesErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationInstancesErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReplicationInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationInstancesErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeReplicationInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReplicationInstanceTaskLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationInstanceTaskLogsError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationInstanceTaskLogsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationInstanceTaskLogs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationInstanceTaskLogsErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationInstanceTaskLogsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationInstanceTaskLogsErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationInstanceTaskLogsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationInstanceTaskLogsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationInstanceTaskLogsError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationInstanceTaskLogsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationInstanceTaskLogsError {
    /// Creates a new `DescribeReplicationInstanceTaskLogsError`.
    pub fn new(
        kind: DescribeReplicationInstanceTaskLogsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationInstanceTaskLogsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationInstanceTaskLogsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationInstanceTaskLogsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationInstanceTaskLogsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationInstanceTaskLogsErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationInstanceTaskLogsErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReplicationInstanceTaskLogsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationInstanceTaskLogsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReplicationInstanceTaskLogsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationInstanceTaskLogsErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            DescribeReplicationInstanceTaskLogsErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeReplicationInstanceTaskLogsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeReplicationSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationSubnetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationSubnetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationSubnetGroupsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationSubnetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationSubnetGroupsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationSubnetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationSubnetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationSubnetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationSubnetGroupsError {
    /// Creates a new `DescribeReplicationSubnetGroupsError`.
    pub fn new(
        kind: DescribeReplicationSubnetGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationSubnetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationSubnetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationSubnetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationSubnetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationSubnetGroupsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationSubnetGroupsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReplicationSubnetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationSubnetGroupsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeReplicationSubnetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReplicationTaskAssessmentResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationTaskAssessmentResultsError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationTaskAssessmentResultsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationTaskAssessmentResults` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationTaskAssessmentResultsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationTaskAssessmentResultsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationTaskAssessmentResultsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationTaskAssessmentResultsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationTaskAssessmentResultsError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationTaskAssessmentResultsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationTaskAssessmentResultsError {
    /// Creates a new `DescribeReplicationTaskAssessmentResultsError`.
    pub fn new(
        kind: DescribeReplicationTaskAssessmentResultsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationTaskAssessmentResultsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationTaskAssessmentResultsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationTaskAssessmentResultsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationTaskAssessmentResultsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationTaskAssessmentResultsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationTaskAssessmentResultsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReplicationTaskAssessmentResultsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationTaskAssessmentResultsErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeReplicationTaskAssessmentResultsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeReplicationTaskAssessmentRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationTaskAssessmentRunsError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationTaskAssessmentRunsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationTaskAssessmentRuns` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationTaskAssessmentRunsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationTaskAssessmentRunsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationTaskAssessmentRunsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReplicationTaskAssessmentRunsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationTaskAssessmentRunsError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationTaskAssessmentRunsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationTaskAssessmentRunsError {
    /// Creates a new `DescribeReplicationTaskAssessmentRunsError`.
    pub fn new(
        kind: DescribeReplicationTaskAssessmentRunsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationTaskAssessmentRunsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationTaskAssessmentRunsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationTaskAssessmentRunsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationTaskAssessmentRunsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationTaskAssessmentRunsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationTaskAssessmentRunsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReplicationTaskAssessmentRunsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationTaskAssessmentRunsErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeReplicationTaskAssessmentRunsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeReplicationTaskIndividualAssessments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationTaskIndividualAssessmentsError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationTaskIndividualAssessmentsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationTaskIndividualAssessments` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationTaskIndividualAssessmentsErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationTaskIndividualAssessmentsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationTaskIndividualAssessmentsErrorKind::ResourceNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            DescribeReplicationTaskIndividualAssessmentsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind
    for DescribeReplicationTaskIndividualAssessmentsError
{
    fn code(&self) -> Option<&str> {
        DescribeReplicationTaskIndividualAssessmentsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationTaskIndividualAssessmentsError {
    /// Creates a new `DescribeReplicationTaskIndividualAssessmentsError`.
    pub fn new(
        kind: DescribeReplicationTaskIndividualAssessmentsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationTaskIndividualAssessmentsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationTaskIndividualAssessmentsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationTaskIndividualAssessmentsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationTaskIndividualAssessmentsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationTaskIndividualAssessmentsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationTaskIndividualAssessmentsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReplicationTaskIndividualAssessmentsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationTaskIndividualAssessmentsErrorKind::ResourceNotFoundFault(
                _inner,
            ) => Some(_inner),
            DescribeReplicationTaskIndividualAssessmentsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeReplicationTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReplicationTasksError {
    /// Kind of error that occurred.
    pub kind: DescribeReplicationTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReplicationTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReplicationTasksErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReplicationTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReplicationTasksErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeReplicationTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReplicationTasksError {
    fn code(&self) -> Option<&str> {
        DescribeReplicationTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReplicationTasksError {
    /// Creates a new `DescribeReplicationTasksError`.
    pub fn new(kind: DescribeReplicationTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReplicationTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReplicationTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReplicationTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReplicationTasksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReplicationTasksErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReplicationTasksErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReplicationTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReplicationTasksErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeReplicationTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSchemasError {
    /// Kind of error that occurred.
    pub kind: DescribeSchemasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSchemasErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSchemasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSchemasErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DescribeSchemasErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeSchemasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSchemasError {
    fn code(&self) -> Option<&str> {
        DescribeSchemasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSchemasError {
    /// Creates a new `DescribeSchemasError`.
    pub fn new(kind: DescribeSchemasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSchemasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSchemasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSchemasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSchemasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSchemasErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSchemasErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSchemasErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSchemasErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeSchemasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSchemasErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DescribeSchemasErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeSchemasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTableStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTableStatisticsError {
    /// Kind of error that occurred.
    pub kind: DescribeTableStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTableStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTableStatisticsErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTableStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTableStatisticsErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            DescribeTableStatisticsErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeTableStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTableStatisticsError {
    fn code(&self) -> Option<&str> {
        DescribeTableStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTableStatisticsError {
    /// Creates a new `DescribeTableStatisticsError`.
    pub fn new(kind: DescribeTableStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTableStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTableStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTableStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTableStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTableStatisticsErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableStatisticsErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTableStatisticsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableStatisticsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeTableStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTableStatisticsErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            DescribeTableStatisticsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeTableStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportCertificateError {
    /// Kind of error that occurred.
    pub kind: ImportCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportCertificateErrorKind {
    /// <p>The certificate was not valid.</p>
    InvalidCertificateFault(crate::error::InvalidCertificateFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportCertificateErrorKind::InvalidCertificateFault(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            ImportCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportCertificateError {
    fn code(&self) -> Option<&str> {
        ImportCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportCertificateError {
    /// Creates a new `ImportCertificateError`.
    pub fn new(kind: ImportCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportCertificateErrorKind::InvalidCertificateFault`.
    pub fn is_invalid_certificate_fault(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::InvalidCertificateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ImportCertificateErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ImportCertificateErrorKind::ResourceQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for ImportCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportCertificateErrorKind::InvalidCertificateFault(_inner) => Some(_inner),
            ImportCertificateErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            ImportCertificateErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            ImportCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyEndpointError {
    /// Kind of error that occurred.
    pub kind: ModifyEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyEndpointErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyEndpointErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            ModifyEndpointErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            ModifyEndpointErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            ModifyEndpointErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyEndpointErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyEndpointError {
    fn code(&self) -> Option<&str> {
        ModifyEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyEndpointError {
    /// Creates a new `ModifyEndpointError`.
    pub fn new(kind: ModifyEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyEndpointErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyEndpointErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(&self.kind, ModifyEndpointErrorKind::AccessDeniedFault(_))
    }
    /// Returns `true` if the error kind is `ModifyEndpointErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyEndpointErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            ModifyEndpointErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            ModifyEndpointErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            ModifyEndpointErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            ModifyEndpointErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ModifyEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: ModifyEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyEventSubscriptionErrorKind {
    /// <p>The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.</p>
    KmsAccessDeniedFault(crate::error::KmsAccessDeniedFault),
    /// <p>The specified KMS key isn't enabled.</p>
    KmsDisabledFault(crate::error::KmsDisabledFault),
    /// <p>The state of the specified KMS resource isn't valid for this request.</p>
    KmsInvalidStateFault(crate::error::KmsInvalidStateFault),
    /// <p>The specified KMS entity or resource can't be found.</p>
    KmsNotFoundFault(crate::error::KmsNotFoundFault),
    /// <p>This request triggered KMS request throttling.</p>
    KmsThrottlingFault(crate::error::KmsThrottlingFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// <p>The SNS topic is invalid.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You are not authorized for the SNS subscription.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::KmsAccessDeniedFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::KmsDisabledFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::KmsInvalidStateFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::KmsNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::KmsThrottlingFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        ModifyEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyEventSubscriptionError {
    /// Creates a new `ModifyEventSubscriptionError`.
    pub fn new(kind: ModifyEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::KmsAccessDeniedFault`.
    pub fn is_kms_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::KmsAccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::KmsDisabledFault`.
    pub fn is_kms_disabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::KmsDisabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::KmsInvalidStateFault`.
    pub fn is_kms_invalid_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::KmsInvalidStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::KmsNotFoundFault`.
    pub fn is_kms_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::KmsNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::KmsThrottlingFault`.
    pub fn is_kms_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::KmsThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::ResourceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
}
impl std::error::Error for ModifyEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::KmsAccessDeniedFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::KmsDisabledFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::KmsInvalidStateFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::KmsNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::KmsThrottlingFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyReplicationInstanceError {
    /// Kind of error that occurred.
    pub kind: ModifyReplicationInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyReplicationInstanceErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>There are not enough resources allocated to the database migration.</p>
    InsufficientResourceCapacityFault(crate::error::InsufficientResourceCapacityFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The storage quota has been exceeded.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>An upgrade dependency is preventing the database migration.</p>
    UpgradeDependencyFailureFault(crate::error::UpgradeDependencyFailureFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyReplicationInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyReplicationInstanceErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            ModifyReplicationInstanceErrorKind::InsufficientResourceCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            ModifyReplicationInstanceErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyReplicationInstanceErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyReplicationInstanceErrorKind::UpgradeDependencyFailureFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyReplicationInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyReplicationInstanceError {
    fn code(&self) -> Option<&str> {
        ModifyReplicationInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyReplicationInstanceError {
    /// Creates a new `ModifyReplicationInstanceError`.
    pub fn new(kind: ModifyReplicationInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyReplicationInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyReplicationInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyReplicationInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyReplicationInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyReplicationInstanceErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationInstanceErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationInstanceErrorKind::InsufficientResourceCapacityFault`.
    pub fn is_insufficient_resource_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationInstanceErrorKind::InsufficientResourceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationInstanceErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationInstanceErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationInstanceErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationInstanceErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationInstanceErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationInstanceErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationInstanceErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationInstanceErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationInstanceErrorKind::UpgradeDependencyFailureFault`.
    pub fn is_upgrade_dependency_failure_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationInstanceErrorKind::UpgradeDependencyFailureFault(_)
        )
    }
}
impl std::error::Error for ModifyReplicationInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyReplicationInstanceErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            ModifyReplicationInstanceErrorKind::InsufficientResourceCapacityFault(_inner) => {
                Some(_inner)
            }
            ModifyReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            ModifyReplicationInstanceErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            ModifyReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ModifyReplicationInstanceErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            ModifyReplicationInstanceErrorKind::UpgradeDependencyFailureFault(_inner) => {
                Some(_inner)
            }
            ModifyReplicationInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyReplicationSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyReplicationSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyReplicationSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyReplicationSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyReplicationSubnetGroupErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The subnet provided is invalid.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</p>
    ReplicationSubnetGroupDoesNotCoverEnoughAZs(
        crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs,
    ),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// <p>The specified subnet is already in use.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyReplicationSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyReplicationSubnetGroupErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            ModifyReplicationSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            ModifyReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => _inner.fmt(f),
            ModifyReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyReplicationSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => _inner.fmt(f),
            ModifyReplicationSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyReplicationSubnetGroupError {
    fn code(&self) -> Option<&str> {
        ModifyReplicationSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyReplicationSubnetGroupError {
    /// Creates a new `ModifyReplicationSubnetGroupError`.
    pub fn new(kind: ModifyReplicationSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyReplicationSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyReplicationSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyReplicationSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyReplicationSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyReplicationSubnetGroupErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationSubnetGroupErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationSubnetGroupErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_replication_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationSubnetGroupErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationSubnetGroupErrorKind::SubnetAlreadyInUse`.
    pub fn is_subnet_already_in_use(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationSubnetGroupErrorKind::SubnetAlreadyInUse(_)
        )
    }
}
impl std::error::Error for ModifyReplicationSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyReplicationSubnetGroupErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            ModifyReplicationSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            ModifyReplicationSubnetGroupErrorKind::ReplicationSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => Some(_inner),
            ModifyReplicationSubnetGroupErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ModifyReplicationSubnetGroupErrorKind::ResourceQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyReplicationSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => Some(_inner),
            ModifyReplicationSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyReplicationTaskError {
    /// Kind of error that occurred.
    pub kind: ModifyReplicationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyReplicationTaskErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyReplicationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            ModifyReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            ModifyReplicationTaskErrorKind::ResourceAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyReplicationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyReplicationTaskError {
    fn code(&self) -> Option<&str> {
        ModifyReplicationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyReplicationTaskError {
    /// Creates a new `ModifyReplicationTaskError`.
    pub fn new(kind: ModifyReplicationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyReplicationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyReplicationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyReplicationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyReplicationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyReplicationTaskErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationTaskErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationTaskErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationTaskErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationTaskErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyReplicationTaskErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyReplicationTaskErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyReplicationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            ModifyReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            ModifyReplicationTaskErrorKind::ResourceAlreadyExistsFault(_inner) => Some(_inner),
            ModifyReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ModifyReplicationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MoveReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MoveReplicationTaskError {
    /// Kind of error that occurred.
    pub kind: MoveReplicationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MoveReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MoveReplicationTaskErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MoveReplicationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MoveReplicationTaskErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            MoveReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            MoveReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            MoveReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            MoveReplicationTaskErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            MoveReplicationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MoveReplicationTaskError {
    fn code(&self) -> Option<&str> {
        MoveReplicationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MoveReplicationTaskError {
    /// Creates a new `MoveReplicationTaskError`.
    pub fn new(kind: MoveReplicationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MoveReplicationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MoveReplicationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MoveReplicationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MoveReplicationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `MoveReplicationTaskErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            MoveReplicationTaskErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `MoveReplicationTaskErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            MoveReplicationTaskErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `MoveReplicationTaskErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            MoveReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `MoveReplicationTaskErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            MoveReplicationTaskErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `MoveReplicationTaskErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            MoveReplicationTaskErrorKind::ResourceQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for MoveReplicationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MoveReplicationTaskErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            MoveReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            MoveReplicationTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            MoveReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            MoveReplicationTaskErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            MoveReplicationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootReplicationInstanceError {
    /// Kind of error that occurred.
    pub kind: RebootReplicationInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootReplicationInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootReplicationInstanceErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootReplicationInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            RebootReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            RebootReplicationInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootReplicationInstanceError {
    fn code(&self) -> Option<&str> {
        RebootReplicationInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootReplicationInstanceError {
    /// Creates a new `RebootReplicationInstanceError`.
    pub fn new(kind: RebootReplicationInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootReplicationInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootReplicationInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootReplicationInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootReplicationInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootReplicationInstanceErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootReplicationInstanceErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RebootReplicationInstanceErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootReplicationInstanceErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for RebootReplicationInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootReplicationInstanceErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            RebootReplicationInstanceErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            RebootReplicationInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RefreshSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RefreshSchemasError {
    /// Kind of error that occurred.
    pub kind: RefreshSchemasErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RefreshSchemas` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RefreshSchemasErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RefreshSchemasError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RefreshSchemasErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            RefreshSchemasErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            RefreshSchemasErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            RefreshSchemasErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            RefreshSchemasErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RefreshSchemasError {
    fn code(&self) -> Option<&str> {
        RefreshSchemasError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RefreshSchemasError {
    /// Creates a new `RefreshSchemasError`.
    pub fn new(kind: RefreshSchemasErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RefreshSchemasError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RefreshSchemasErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RefreshSchemasError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RefreshSchemasErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RefreshSchemasErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RefreshSchemasErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RefreshSchemasErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RefreshSchemasErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RefreshSchemasErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RefreshSchemasErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RefreshSchemasErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RefreshSchemasErrorKind::ResourceQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for RefreshSchemasError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RefreshSchemasErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            RefreshSchemasErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            RefreshSchemasErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            RefreshSchemasErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            RefreshSchemasErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ReloadTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ReloadTablesError {
    /// Kind of error that occurred.
    pub kind: ReloadTablesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ReloadTables` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ReloadTablesErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ReloadTablesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ReloadTablesErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            ReloadTablesErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ReloadTablesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ReloadTablesError {
    fn code(&self) -> Option<&str> {
        ReloadTablesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ReloadTablesError {
    /// Creates a new `ReloadTablesError`.
    pub fn new(kind: ReloadTablesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ReloadTablesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ReloadTablesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ReloadTablesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ReloadTablesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ReloadTablesErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ReloadTablesErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ReloadTablesErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(&self.kind, ReloadTablesErrorKind::ResourceNotFoundFault(_))
    }
}
impl std::error::Error for ReloadTablesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ReloadTablesErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            ReloadTablesErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ReloadTablesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromResourceErrorKind {
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromResourceError {
    /// Creates a new `RemoveTagsFromResourceError`.
    pub fn new(kind: RemoveTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartReplicationTaskError {
    /// Kind of error that occurred.
    pub kind: StartReplicationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartReplicationTaskErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartReplicationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartReplicationTaskErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            StartReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            StartReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            StartReplicationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartReplicationTaskError {
    fn code(&self) -> Option<&str> {
        StartReplicationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartReplicationTaskError {
    /// Creates a new `StartReplicationTaskError`.
    pub fn new(kind: StartReplicationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartReplicationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartReplicationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartReplicationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartReplicationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartReplicationTaskErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for StartReplicationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartReplicationTaskErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            StartReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            StartReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            StartReplicationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartReplicationTaskAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartReplicationTaskAssessmentError {
    /// Kind of error that occurred.
    pub kind: StartReplicationTaskAssessmentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartReplicationTaskAssessment` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartReplicationTaskAssessmentErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartReplicationTaskAssessmentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartReplicationTaskAssessmentErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            StartReplicationTaskAssessmentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartReplicationTaskAssessmentError {
    fn code(&self) -> Option<&str> {
        StartReplicationTaskAssessmentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartReplicationTaskAssessmentError {
    /// Creates a new `StartReplicationTaskAssessmentError`.
    pub fn new(
        kind: StartReplicationTaskAssessmentErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartReplicationTaskAssessmentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartReplicationTaskAssessmentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartReplicationTaskAssessmentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartReplicationTaskAssessmentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for StartReplicationTaskAssessmentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartReplicationTaskAssessmentErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            StartReplicationTaskAssessmentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartReplicationTaskAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartReplicationTaskAssessmentRunError {
    /// Kind of error that occurred.
    pub kind: StartReplicationTaskAssessmentRunErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartReplicationTaskAssessmentRun` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartReplicationTaskAssessmentRunErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.</p>
    KmsAccessDeniedFault(crate::error::KmsAccessDeniedFault),
    /// <p>The specified KMS key isn't enabled.</p>
    KmsDisabledFault(crate::error::KmsDisabledFault),
    /// <p>An Key Management Service (KMS) error is preventing access to KMS.</p>
    KmsFault(crate::error::KmsFault),
    /// <p>The state of the specified KMS resource isn't valid for this request.</p>
    KmsInvalidStateFault(crate::error::KmsInvalidStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified KMS entity or resource can't be found.</p>
    KmsNotFoundFault(crate::error::KmsNotFoundFault),
    /// <p>The resource you are attempting to create already exists.</p>
    ResourceAlreadyExistsFault(crate::error::ResourceAlreadyExistsFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>Insufficient privileges are preventing access to an Amazon S3 object.</p>
    S3AccessDeniedFault(crate::error::S3AccessDeniedFault),
    /// <p>A specified Amazon S3 bucket, bucket folder, or other object can't be
    /// found.</p>
    S3ResourceNotFoundFault(crate::error::S3ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartReplicationTaskAssessmentRunError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            StartReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsAccessDeniedFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsDisabledFault(_inner) => _inner.fmt(f),
            StartReplicationTaskAssessmentRunErrorKind::KmsFault(_inner) => _inner.fmt(f),
            StartReplicationTaskAssessmentRunErrorKind::KmsInvalidStateFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsNotFoundFault(_inner) => _inner.fmt(f),
            StartReplicationTaskAssessmentRunErrorKind::ResourceAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::S3AccessDeniedFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::S3ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            StartReplicationTaskAssessmentRunErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartReplicationTaskAssessmentRunError {
    fn code(&self) -> Option<&str> {
        StartReplicationTaskAssessmentRunError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartReplicationTaskAssessmentRunError {
    /// Creates a new `StartReplicationTaskAssessmentRunError`.
    pub fn new(
        kind: StartReplicationTaskAssessmentRunErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartReplicationTaskAssessmentRunError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartReplicationTaskAssessmentRunErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartReplicationTaskAssessmentRunError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartReplicationTaskAssessmentRunErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::KmsAccessDeniedFault`.
    pub fn is_kms_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::KmsAccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::KmsDisabledFault`.
    pub fn is_kms_disabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::KmsDisabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::KmsFault`.
    pub fn is_kms_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::KmsFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::KmsInvalidStateFault`.
    pub fn is_kms_invalid_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::KmsInvalidStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::KmsNotFoundFault`.
    pub fn is_kms_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::KmsNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::ResourceAlreadyExistsFault`.
    pub fn is_resource_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::ResourceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::S3AccessDeniedFault`.
    pub fn is_s3_access_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::S3AccessDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartReplicationTaskAssessmentRunErrorKind::S3ResourceNotFoundFault`.
    pub fn is_s3_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartReplicationTaskAssessmentRunErrorKind::S3ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for StartReplicationTaskAssessmentRunError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartReplicationTaskAssessmentRunErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            StartReplicationTaskAssessmentRunErrorKind::InvalidResourceStateFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsAccessDeniedFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsDisabledFault(_inner) => Some(_inner),
            StartReplicationTaskAssessmentRunErrorKind::KmsFault(_inner) => Some(_inner),
            StartReplicationTaskAssessmentRunErrorKind::KmsInvalidStateFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentRunErrorKind::KmsNotFoundFault(_inner) => Some(_inner),
            StartReplicationTaskAssessmentRunErrorKind::ResourceAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentRunErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentRunErrorKind::S3AccessDeniedFault(_inner) => Some(_inner),
            StartReplicationTaskAssessmentRunErrorKind::S3ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            StartReplicationTaskAssessmentRunErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopReplicationTaskError {
    /// Kind of error that occurred.
    pub kind: StopReplicationTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopReplicationTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopReplicationTaskErrorKind {
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopReplicationTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            StopReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            StopReplicationTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopReplicationTaskError {
    fn code(&self) -> Option<&str> {
        StopReplicationTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopReplicationTaskError {
    /// Creates a new `StopReplicationTaskError`.
    pub fn new(kind: StopReplicationTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopReplicationTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopReplicationTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopReplicationTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopReplicationTaskErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopReplicationTaskErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopReplicationTaskErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopReplicationTaskErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopReplicationTaskErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for StopReplicationTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopReplicationTaskErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            StopReplicationTaskErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            StopReplicationTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestConnectionError {
    /// Kind of error that occurred.
    pub kind: TestConnectionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestConnection` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestConnectionErrorKind {
    /// <p>DMS was denied access to the endpoint. Check that the
    /// role is correctly configured.</p>
    AccessDeniedFault(crate::error::AccessDeniedFault),
    /// <p>The resource is in a state that prevents it from being used for database migration.</p>
    InvalidResourceStateFault(crate::error::InvalidResourceStateFault),
    /// <p>DMS cannot access the KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>The quota for this resource quota has been exceeded.</p>
    ResourceQuotaExceededFault(crate::error::ResourceQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestConnectionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestConnectionErrorKind::AccessDeniedFault(_inner) => _inner.fmt(f),
            TestConnectionErrorKind::InvalidResourceStateFault(_inner) => _inner.fmt(f),
            TestConnectionErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            TestConnectionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            TestConnectionErrorKind::ResourceQuotaExceededFault(_inner) => _inner.fmt(f),
            TestConnectionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestConnectionError {
    fn code(&self) -> Option<&str> {
        TestConnectionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestConnectionError {
    /// Creates a new `TestConnectionError`.
    pub fn new(kind: TestConnectionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestConnectionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestConnectionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestConnectionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestConnectionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestConnectionErrorKind::AccessDeniedFault`.
    pub fn is_access_denied_fault(&self) -> bool {
        matches!(&self.kind, TestConnectionErrorKind::AccessDeniedFault(_))
    }
    /// Returns `true` if the error kind is `TestConnectionErrorKind::InvalidResourceStateFault`.
    pub fn is_invalid_resource_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            TestConnectionErrorKind::InvalidResourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `TestConnectionErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            TestConnectionErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `TestConnectionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            TestConnectionErrorKind::ResourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `TestConnectionErrorKind::ResourceQuotaExceededFault`.
    pub fn is_resource_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            TestConnectionErrorKind::ResourceQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for TestConnectionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestConnectionErrorKind::AccessDeniedFault(_inner) => Some(_inner),
            TestConnectionErrorKind::InvalidResourceStateFault(_inner) => Some(_inner),
            TestConnectionErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            TestConnectionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            TestConnectionErrorKind::ResourceQuotaExceededFault(_inner) => Some(_inner),
            TestConnectionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The quota for this resource quota has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceQuotaExceededFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceQuotaExceededFault")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceQuotaExceededFault {}
/// See [`ResourceQuotaExceededFault`](crate::error::ResourceQuotaExceededFault)
pub mod resource_quota_exceeded_fault {
    /// A builder for [`ResourceQuotaExceededFault`](crate::error::ResourceQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceQuotaExceededFault`](crate::error::ResourceQuotaExceededFault)
        pub fn build(self) -> crate::error::ResourceQuotaExceededFault {
            crate::error::ResourceQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ResourceQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ResourceQuotaExceededFault`](crate::error::ResourceQuotaExceededFault)
    pub fn builder() -> crate::error::resource_quota_exceeded_fault::Builder {
        crate::error::resource_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundFault")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundFault {}
/// See [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
pub mod resource_not_found_fault {
    /// A builder for [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
        pub fn build(self) -> crate::error::ResourceNotFoundFault {
            crate::error::ResourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    pub fn builder() -> crate::error::resource_not_found_fault::Builder {
        crate::error::resource_not_found_fault::Builder::default()
    }
}

/// <p>DMS cannot access the KMS key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyNotAccessibleFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsKeyNotAccessibleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyNotAccessibleFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsKeyNotAccessibleFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsKeyNotAccessibleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsKeyNotAccessibleFault [KMSKeyNotAccessibleFault]")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsKeyNotAccessibleFault {}
/// See [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
pub mod kms_key_not_accessible_fault {
    /// A builder for [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
        pub fn build(self) -> crate::error::KmsKeyNotAccessibleFault {
            crate::error::KmsKeyNotAccessibleFault {
                message: self.message,
            }
        }
    }
}
impl KmsKeyNotAccessibleFault {
    /// Creates a new builder-style object to manufacture [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
    pub fn builder() -> crate::error::kms_key_not_accessible_fault::Builder {
        crate::error::kms_key_not_accessible_fault::Builder::default()
    }
}

/// <p>The resource is in a state that prevents it from being used for database migration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidResourceStateFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidResourceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidResourceStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidResourceStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidResourceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidResourceStateFault")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidResourceStateFault {}
/// See [`InvalidResourceStateFault`](crate::error::InvalidResourceStateFault)
pub mod invalid_resource_state_fault {
    /// A builder for [`InvalidResourceStateFault`](crate::error::InvalidResourceStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidResourceStateFault`](crate::error::InvalidResourceStateFault)
        pub fn build(self) -> crate::error::InvalidResourceStateFault {
            crate::error::InvalidResourceStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidResourceStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidResourceStateFault`](crate::error::InvalidResourceStateFault)
    pub fn builder() -> crate::error::invalid_resource_state_fault::Builder {
        crate::error::invalid_resource_state_fault::Builder::default()
    }
}

/// <p>DMS was denied access to the endpoint. Check that the
/// role is correctly configured.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedFault")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedFault {}
/// See [`AccessDeniedFault`](crate::error::AccessDeniedFault)
pub mod access_denied_fault {
    /// A builder for [`AccessDeniedFault`](crate::error::AccessDeniedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedFault`](crate::error::AccessDeniedFault)
        pub fn build(self) -> crate::error::AccessDeniedFault {
            crate::error::AccessDeniedFault {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedFault {
    /// Creates a new builder-style object to manufacture [`AccessDeniedFault`](crate::error::AccessDeniedFault)
    pub fn builder() -> crate::error::access_denied_fault::Builder {
        crate::error::access_denied_fault::Builder::default()
    }
}

/// <p>A specified Amazon S3 bucket, bucket folder, or other object can't be
/// found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ResourceNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ResourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl S3ResourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for S3ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "S3ResourceNotFoundFault")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for S3ResourceNotFoundFault {}
/// See [`S3ResourceNotFoundFault`](crate::error::S3ResourceNotFoundFault)
pub mod s3_resource_not_found_fault {
    /// A builder for [`S3ResourceNotFoundFault`](crate::error::S3ResourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ResourceNotFoundFault`](crate::error::S3ResourceNotFoundFault)
        pub fn build(self) -> crate::error::S3ResourceNotFoundFault {
            crate::error::S3ResourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl S3ResourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`S3ResourceNotFoundFault`](crate::error::S3ResourceNotFoundFault)
    pub fn builder() -> crate::error::s3_resource_not_found_fault::Builder {
        crate::error::s3_resource_not_found_fault::Builder::default()
    }
}

/// <p>Insufficient privileges are preventing access to an Amazon S3 object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3AccessDeniedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3AccessDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3AccessDeniedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl S3AccessDeniedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for S3AccessDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "S3AccessDeniedFault")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for S3AccessDeniedFault {}
/// See [`S3AccessDeniedFault`](crate::error::S3AccessDeniedFault)
pub mod s3_access_denied_fault {
    /// A builder for [`S3AccessDeniedFault`](crate::error::S3AccessDeniedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`S3AccessDeniedFault`](crate::error::S3AccessDeniedFault)
        pub fn build(self) -> crate::error::S3AccessDeniedFault {
            crate::error::S3AccessDeniedFault {
                message: self.message,
            }
        }
    }
}
impl S3AccessDeniedFault {
    /// Creates a new builder-style object to manufacture [`S3AccessDeniedFault`](crate::error::S3AccessDeniedFault)
    pub fn builder() -> crate::error::s3_access_denied_fault::Builder {
        crate::error::s3_access_denied_fault::Builder::default()
    }
}

/// <p>The resource you are attempting to create already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ResourceAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ResourceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsFault")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsFault {}
/// See [`ResourceAlreadyExistsFault`](crate::error::ResourceAlreadyExistsFault)
pub mod resource_already_exists_fault {
    /// A builder for [`ResourceAlreadyExistsFault`](crate::error::ResourceAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsFault`](crate::error::ResourceAlreadyExistsFault)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsFault {
            crate::error::ResourceAlreadyExistsFault {
                message: self.message,
                resource_arn: self.resource_arn,
            }
        }
    }
}
impl ResourceAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsFault`](crate::error::ResourceAlreadyExistsFault)
    pub fn builder() -> crate::error::resource_already_exists_fault::Builder {
        crate::error::resource_already_exists_fault::Builder::default()
    }
}

/// <p>The specified KMS entity or resource can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsNotFoundFault [KMSNotFoundFault]")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsNotFoundFault {}
/// See [`KmsNotFoundFault`](crate::error::KmsNotFoundFault)
pub mod kms_not_found_fault {
    /// A builder for [`KmsNotFoundFault`](crate::error::KmsNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsNotFoundFault`](crate::error::KmsNotFoundFault)
        pub fn build(self) -> crate::error::KmsNotFoundFault {
            crate::error::KmsNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl KmsNotFoundFault {
    /// Creates a new builder-style object to manufacture [`KmsNotFoundFault`](crate::error::KmsNotFoundFault)
    pub fn builder() -> crate::error::kms_not_found_fault::Builder {
        crate::error::kms_not_found_fault::Builder::default()
    }
}

/// <p>The state of the specified KMS resource isn't valid for this request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsInvalidStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsInvalidStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsInvalidStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsInvalidStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsInvalidStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsInvalidStateFault [KMSInvalidStateFault]")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsInvalidStateFault {}
/// See [`KmsInvalidStateFault`](crate::error::KmsInvalidStateFault)
pub mod kms_invalid_state_fault {
    /// A builder for [`KmsInvalidStateFault`](crate::error::KmsInvalidStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsInvalidStateFault`](crate::error::KmsInvalidStateFault)
        pub fn build(self) -> crate::error::KmsInvalidStateFault {
            crate::error::KmsInvalidStateFault {
                message: self.message,
            }
        }
    }
}
impl KmsInvalidStateFault {
    /// Creates a new builder-style object to manufacture [`KmsInvalidStateFault`](crate::error::KmsInvalidStateFault)
    pub fn builder() -> crate::error::kms_invalid_state_fault::Builder {
        crate::error::kms_invalid_state_fault::Builder::default()
    }
}

/// <p>An Key Management Service (KMS) error is preventing access to KMS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsFault [KMSFault]")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsFault {}
/// See [`KmsFault`](crate::error::KmsFault)
pub mod kms_fault {
    /// A builder for [`KmsFault`](crate::error::KmsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsFault`](crate::error::KmsFault)
        pub fn build(self) -> crate::error::KmsFault {
            crate::error::KmsFault {
                message: self.message,
            }
        }
    }
}
impl KmsFault {
    /// Creates a new builder-style object to manufacture [`KmsFault`](crate::error::KmsFault)
    pub fn builder() -> crate::error::kms_fault::Builder {
        crate::error::kms_fault::Builder::default()
    }
}

/// <p>The specified KMS key isn't enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsDisabledFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsDisabledFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsDisabledFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsDisabledFault [KMSDisabledFault]")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsDisabledFault {}
/// See [`KmsDisabledFault`](crate::error::KmsDisabledFault)
pub mod kms_disabled_fault {
    /// A builder for [`KmsDisabledFault`](crate::error::KmsDisabledFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsDisabledFault`](crate::error::KmsDisabledFault)
        pub fn build(self) -> crate::error::KmsDisabledFault {
            crate::error::KmsDisabledFault {
                message: self.message,
            }
        }
    }
}
impl KmsDisabledFault {
    /// Creates a new builder-style object to manufacture [`KmsDisabledFault`](crate::error::KmsDisabledFault)
    pub fn builder() -> crate::error::kms_disabled_fault::Builder {
        crate::error::kms_disabled_fault::Builder::default()
    }
}

/// <p>The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsAccessDeniedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsAccessDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsAccessDeniedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsAccessDeniedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsAccessDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsAccessDeniedFault [KMSAccessDeniedFault]")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsAccessDeniedFault {}
/// See [`KmsAccessDeniedFault`](crate::error::KmsAccessDeniedFault)
pub mod kms_access_denied_fault {
    /// A builder for [`KmsAccessDeniedFault`](crate::error::KmsAccessDeniedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsAccessDeniedFault`](crate::error::KmsAccessDeniedFault)
        pub fn build(self) -> crate::error::KmsAccessDeniedFault {
            crate::error::KmsAccessDeniedFault {
                message: self.message,
            }
        }
    }
}
impl KmsAccessDeniedFault {
    /// Creates a new builder-style object to manufacture [`KmsAccessDeniedFault`](crate::error::KmsAccessDeniedFault)
    pub fn builder() -> crate::error::kms_access_denied_fault::Builder {
        crate::error::kms_access_denied_fault::Builder::default()
    }
}

/// <p>The specified subnet is already in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetAlreadyInUse {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetAlreadyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetAlreadyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetAlreadyInUse")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetAlreadyInUse {}
/// See [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
pub mod subnet_already_in_use {
    /// A builder for [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
        pub fn build(self) -> crate::error::SubnetAlreadyInUse {
            crate::error::SubnetAlreadyInUse {
                message: self.message,
            }
        }
    }
}
impl SubnetAlreadyInUse {
    /// Creates a new builder-style object to manufacture [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    pub fn builder() -> crate::error::subnet_already_in_use::Builder {
        crate::error::subnet_already_in_use::Builder::default()
    }
}

/// <p>The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationSubnetGroupDoesNotCoverEnoughAZs {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReplicationSubnetGroupDoesNotCoverEnoughAZs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationSubnetGroupDoesNotCoverEnoughAZs");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReplicationSubnetGroupDoesNotCoverEnoughAZs {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReplicationSubnetGroupDoesNotCoverEnoughAZs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReplicationSubnetGroupDoesNotCoverEnoughAZs")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReplicationSubnetGroupDoesNotCoverEnoughAZs {}
/// See [`ReplicationSubnetGroupDoesNotCoverEnoughAZs`](crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs)
pub mod replication_subnet_group_does_not_cover_enough_a_zs {
    /// A builder for [`ReplicationSubnetGroupDoesNotCoverEnoughAZs`](crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationSubnetGroupDoesNotCoverEnoughAZs`](crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs)
        pub fn build(self) -> crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs {
            crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs {
                message: self.message,
            }
        }
    }
}
impl ReplicationSubnetGroupDoesNotCoverEnoughAZs {
    /// Creates a new builder-style object to manufacture [`ReplicationSubnetGroupDoesNotCoverEnoughAZs`](crate::error::ReplicationSubnetGroupDoesNotCoverEnoughAZs)
    pub fn builder() -> crate::error::replication_subnet_group_does_not_cover_enough_a_zs::Builder {
        crate::error::replication_subnet_group_does_not_cover_enough_a_zs::Builder::default()
    }
}

/// <p>The subnet provided is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnet {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnet");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnet")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnet {}
/// See [`InvalidSubnet`](crate::error::InvalidSubnet)
pub mod invalid_subnet {
    /// A builder for [`InvalidSubnet`](crate::error::InvalidSubnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnet`](crate::error::InvalidSubnet)
        pub fn build(self) -> crate::error::InvalidSubnet {
            crate::error::InvalidSubnet {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnet {
    /// Creates a new builder-style object to manufacture [`InvalidSubnet`](crate::error::InvalidSubnet)
    pub fn builder() -> crate::error::invalid_subnet::Builder {
        crate::error::invalid_subnet::Builder::default()
    }
}

/// <p>An upgrade dependency is preventing the database migration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeDependencyFailureFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpgradeDependencyFailureFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeDependencyFailureFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UpgradeDependencyFailureFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UpgradeDependencyFailureFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UpgradeDependencyFailureFault")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for UpgradeDependencyFailureFault {}
/// See [`UpgradeDependencyFailureFault`](crate::error::UpgradeDependencyFailureFault)
pub mod upgrade_dependency_failure_fault {
    /// A builder for [`UpgradeDependencyFailureFault`](crate::error::UpgradeDependencyFailureFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeDependencyFailureFault`](crate::error::UpgradeDependencyFailureFault)
        pub fn build(self) -> crate::error::UpgradeDependencyFailureFault {
            crate::error::UpgradeDependencyFailureFault {
                message: self.message,
            }
        }
    }
}
impl UpgradeDependencyFailureFault {
    /// Creates a new builder-style object to manufacture [`UpgradeDependencyFailureFault`](crate::error::UpgradeDependencyFailureFault)
    pub fn builder() -> crate::error::upgrade_dependency_failure_fault::Builder {
        crate::error::upgrade_dependency_failure_fault::Builder::default()
    }
}

/// <p>The storage quota has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageQuotaExceededFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StorageQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StorageQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StorageQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StorageQuotaExceededFault")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for StorageQuotaExceededFault {}
/// See [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
pub mod storage_quota_exceeded_fault {
    /// A builder for [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
        pub fn build(self) -> crate::error::StorageQuotaExceededFault {
            crate::error::StorageQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl StorageQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
    pub fn builder() -> crate::error::storage_quota_exceeded_fault::Builder {
        crate::error::storage_quota_exceeded_fault::Builder::default()
    }
}

/// <p>There are not enough resources allocated to the database migration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientResourceCapacityFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientResourceCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientResourceCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientResourceCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientResourceCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientResourceCapacityFault")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientResourceCapacityFault {}
/// See [`InsufficientResourceCapacityFault`](crate::error::InsufficientResourceCapacityFault)
pub mod insufficient_resource_capacity_fault {
    /// A builder for [`InsufficientResourceCapacityFault`](crate::error::InsufficientResourceCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientResourceCapacityFault`](crate::error::InsufficientResourceCapacityFault)
        pub fn build(self) -> crate::error::InsufficientResourceCapacityFault {
            crate::error::InsufficientResourceCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientResourceCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientResourceCapacityFault`](crate::error::InsufficientResourceCapacityFault)
    pub fn builder() -> crate::error::insufficient_resource_capacity_fault::Builder {
        crate::error::insufficient_resource_capacity_fault::Builder::default()
    }
}

/// <p>You are not authorized for the SNS subscription.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsNoAuthorizationFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsNoAuthorizationFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsNoAuthorizationFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsNoAuthorizationFault [SNSNoAuthorizationFault]")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsNoAuthorizationFault {}
/// See [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
pub mod sns_no_authorization_fault {
    /// A builder for [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
        pub fn build(self) -> crate::error::SnsNoAuthorizationFault {
            crate::error::SnsNoAuthorizationFault {
                message: self.message,
            }
        }
    }
}
impl SnsNoAuthorizationFault {
    /// Creates a new builder-style object to manufacture [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    pub fn builder() -> crate::error::sns_no_authorization_fault::Builder {
        crate::error::sns_no_authorization_fault::Builder::default()
    }
}

/// <p>The SNS topic is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsInvalidTopicFault {
    /// <p></p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsInvalidTopicFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsInvalidTopicFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsInvalidTopicFault [SNSInvalidTopicFault]")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsInvalidTopicFault {}
/// See [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
pub mod sns_invalid_topic_fault {
    /// A builder for [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
        pub fn build(self) -> crate::error::SnsInvalidTopicFault {
            crate::error::SnsInvalidTopicFault {
                message: self.message,
            }
        }
    }
}
impl SnsInvalidTopicFault {
    /// Creates a new builder-style object to manufacture [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    pub fn builder() -> crate::error::sns_invalid_topic_fault::Builder {
        crate::error::sns_invalid_topic_fault::Builder::default()
    }
}

/// <p>This request triggered KMS request throttling.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsThrottlingFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsThrottlingFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsThrottlingFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsThrottlingFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsThrottlingFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsThrottlingFault [KMSThrottlingFault]")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsThrottlingFault {}
/// See [`KmsThrottlingFault`](crate::error::KmsThrottlingFault)
pub mod kms_throttling_fault {
    /// A builder for [`KmsThrottlingFault`](crate::error::KmsThrottlingFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsThrottlingFault`](crate::error::KmsThrottlingFault)
        pub fn build(self) -> crate::error::KmsThrottlingFault {
            crate::error::KmsThrottlingFault {
                message: self.message,
            }
        }
    }
}
impl KmsThrottlingFault {
    /// Creates a new builder-style object to manufacture [`KmsThrottlingFault`](crate::error::KmsThrottlingFault)
    pub fn builder() -> crate::error::kms_throttling_fault::Builder {
        crate::error::kms_throttling_fault::Builder::default()
    }
}

/// <p>The certificate was not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidCertificateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidCertificateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidCertificateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidCertificateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidCertificateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidCertificateFault")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidCertificateFault {}
/// See [`InvalidCertificateFault`](crate::error::InvalidCertificateFault)
pub mod invalid_certificate_fault {
    /// A builder for [`InvalidCertificateFault`](crate::error::InvalidCertificateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidCertificateFault`](crate::error::InvalidCertificateFault)
        pub fn build(self) -> crate::error::InvalidCertificateFault {
            crate::error::InvalidCertificateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidCertificateFault {
    /// Creates a new builder-style object to manufacture [`InvalidCertificateFault`](crate::error::InvalidCertificateFault)
    pub fn builder() -> crate::error::invalid_certificate_fault::Builder {
        crate::error::invalid_certificate_fault::Builder::default()
    }
}
