// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>
        /// <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>
        /// <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsToResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsToResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsToResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.AddTagsToResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
pub mod apply_pending_maintenance_action_input {
    /// A builder for [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) apply_action: std::option::Option<std::string::String>,
        pub(crate) opt_in_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
        /// action applies to.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
        /// action applies to.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn apply_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_action = Some(input.into());
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_action = input;
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an
        /// opt-in request of type <code>immediate</code>.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn opt_in_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_type = Some(input.into());
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an
        /// opt-in request of type <code>immediate</code>.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opt_in_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplyPendingMaintenanceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplyPendingMaintenanceActionInput {
                replication_instance_arn: self.replication_instance_arn,
                apply_action: self.apply_action,
                opt_in_type: self.opt_in_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationOutputAlias =
    crate::operation::ApplyPendingMaintenanceAction;
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ApplyPendingMaintenanceActionInput {
    /// Consumes the builder and constructs an Operation<[`ApplyPendingMaintenanceAction`](crate::operation::ApplyPendingMaintenanceAction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplyPendingMaintenanceAction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ApplyPendingMaintenanceActionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ApplyPendingMaintenanceActionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ApplyPendingMaintenanceActionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ApplyPendingMaintenanceAction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_apply_pending_maintenance_action(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplyPendingMaintenanceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplyPendingMaintenanceAction",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    pub fn builder() -> crate::input::apply_pending_maintenance_action_input::Builder {
        crate::input::apply_pending_maintenance_action_input::Builder::default()
    }
}

/// See [`CancelReplicationTaskAssessmentRunInput`](crate::input::CancelReplicationTaskAssessmentRunInput)
pub mod cancel_replication_task_assessment_run_input {
    /// A builder for [`CancelReplicationTaskAssessmentRunInput`](crate::input::CancelReplicationTaskAssessmentRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_assessment_run_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelReplicationTaskAssessmentRunInput`](crate::input::CancelReplicationTaskAssessmentRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelReplicationTaskAssessmentRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelReplicationTaskAssessmentRunInput {
                replication_task_assessment_run_arn: self.replication_task_assessment_run_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelReplicationTaskAssessmentRunInputOperationOutputAlias =
    crate::operation::CancelReplicationTaskAssessmentRun;
#[doc(hidden)]
pub type CancelReplicationTaskAssessmentRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelReplicationTaskAssessmentRunInput {
    /// Consumes the builder and constructs an Operation<[`CancelReplicationTaskAssessmentRun`](crate::operation::CancelReplicationTaskAssessmentRun)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelReplicationTaskAssessmentRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelReplicationTaskAssessmentRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelReplicationTaskAssessmentRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelReplicationTaskAssessmentRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.CancelReplicationTaskAssessmentRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_cancel_replication_task_assessment_run(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelReplicationTaskAssessmentRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelReplicationTaskAssessmentRun",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelReplicationTaskAssessmentRunInput`](crate::input::CancelReplicationTaskAssessmentRunInput)
    pub fn builder() -> crate::input::cancel_replication_task_assessment_run_input::Builder {
        crate::input::cancel_replication_task_assessment_run_input::Builder::default()
    }
}

/// See [`CreateEndpointInput`](crate::input::CreateEndpointInput)
pub mod create_endpoint_input {
    /// A builder for [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        pub(crate) engine_name: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) extra_connection_attributes: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) ssl_mode: std::option::Option<crate::model::DmsSslModeValue>,
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) external_table_definition: std::option::Option<std::string::String>,
        pub(crate) dynamo_db_settings: std::option::Option<crate::model::DynamoDbSettings>,
        pub(crate) s3_settings: std::option::Option<crate::model::S3Settings>,
        pub(crate) dms_transfer_settings: std::option::Option<crate::model::DmsTransferSettings>,
        pub(crate) mongo_db_settings: std::option::Option<crate::model::MongoDbSettings>,
        pub(crate) kinesis_settings: std::option::Option<crate::model::KinesisSettings>,
        pub(crate) kafka_settings: std::option::Option<crate::model::KafkaSettings>,
        pub(crate) elasticsearch_settings: std::option::Option<crate::model::ElasticsearchSettings>,
        pub(crate) neptune_settings: std::option::Option<crate::model::NeptuneSettings>,
        pub(crate) redshift_settings: std::option::Option<crate::model::RedshiftSettings>,
        pub(crate) postgre_sql_settings: std::option::Option<crate::model::PostgreSqlSettings>,
        pub(crate) my_sql_settings: std::option::Option<crate::model::MySqlSettings>,
        pub(crate) oracle_settings: std::option::Option<crate::model::OracleSettings>,
        pub(crate) sybase_settings: std::option::Option<crate::model::SybaseSettings>,
        pub(crate) microsoft_sql_server_settings:
            std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        pub(crate) ibm_db2_settings: std::option::Option<crate::model::IbmDb2Settings>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) doc_db_settings: std::option::Option<crate::model::DocDbSettings>,
        pub(crate) redis_settings: std::option::Option<crate::model::RedisSettings>,
    }
    impl Builder {
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two
        /// consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two
        /// consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_identifier = input;
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn endpoint_type(mut self, input: crate::model::ReplicationEndpointTypeValue) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the
        /// <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>,
        /// <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
        /// <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
        /// <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>,
        /// <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_name = Some(input.into());
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the
        /// <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>,
        /// <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
        /// <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
        /// <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>,
        /// <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_name = input;
            self
        }
        /// <p>The user name to be used to log in to the endpoint database.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name to be used to log in to the endpoint database.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password to be used to log in to the endpoint database.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password to be used to log in to the endpoint database.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Additional attributes associated with the connection. Each attribute is specified as a
        /// name-value pair associated by an equal sign (=). Multiple attributes are separated by a
        /// semicolon (;) with no additional white space. For information on the attributes available
        /// for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with
        /// DMS Endpoints</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn extra_connection_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.extra_connection_attributes = Some(input.into());
            self
        }
        /// <p>Additional attributes associated with the connection. Each attribute is specified as a
        /// name-value pair associated by an equal sign (=). Multiple attributes are separated by a
        /// semicolon (;) with no additional white space. For information on the attributes available
        /// for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with
        /// DMS Endpoints</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_extra_connection_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_connection_attributes = input;
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the endpoint.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags to be assigned to the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code>
        /// </p>
        pub fn ssl_mode(mut self, input: crate::model::DmsSslModeValue) -> Self {
            self.ssl_mode = Some(input);
            self
        }
        /// <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code>
        /// </p>
        pub fn set_ssl_mode(
            mut self,
            input: std::option::Option<crate::model::DmsSslModeValue>,
        ) -> Self {
            self.ssl_mode = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the service access role that you want to use to
        /// create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the service access role that you want to use to
        /// create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>The external table definition. </p>
        pub fn external_table_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_table_definition = Some(input.into());
            self
        }
        /// <p>The external table definition. </p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_table_definition = input;
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn dynamo_db_settings(mut self, input: crate::model::DynamoDbSettings) -> Self {
            self.dynamo_db_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_dynamo_db_settings(
            mut self,
            input: std::option::Option<crate::model::DynamoDbSettings>,
        ) -> Self {
            self.dynamo_db_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn s3_settings(mut self, input: crate::model::S3Settings) -> Self {
            self.s3_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_s3_settings(
            mut self,
            input: std::option::Option<crate::model::S3Settings>,
        ) -> Self {
            self.s3_settings = input;
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Possible settings include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BucketName</code> - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows:
        /// <code>ServiceAccessRoleArn=string,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn":
        /// "string", "BucketName": "string", } </code>
        /// </p>
        pub fn dms_transfer_settings(mut self, input: crate::model::DmsTransferSettings) -> Self {
            self.dms_transfer_settings = Some(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Possible settings include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BucketName</code> - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows:
        /// <code>ServiceAccessRoleArn=string,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn":
        /// "string", "BucketName": "string", } </code>
        /// </p>
        pub fn set_dms_transfer_settings(
            mut self,
            input: std::option::Option<crate::model::DmsTransferSettings>,
        ) -> Self {
            self.dms_transfer_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn mongo_db_settings(mut self, input: crate::model::MongoDbSettings) -> Self {
            self.mongo_db_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_mongo_db_settings(
            mut self,
            input: std::option::Option<crate::model::MongoDbSettings>,
        ) -> Self {
            self.mongo_db_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn kinesis_settings(mut self, input: crate::model::KinesisSettings) -> Self {
            self.kinesis_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_kinesis_settings(
            mut self,
            input: std::option::Option<crate::model::KinesisSettings>,
        ) -> Self {
            self.kinesis_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn kafka_settings(mut self, input: crate::model::KafkaSettings) -> Self {
            self.kafka_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_kafka_settings(
            mut self,
            input: std::option::Option<crate::model::KafkaSettings>,
        ) -> Self {
            self.kafka_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide</i>.</p>
        pub fn elasticsearch_settings(
            mut self,
            input: crate::model::ElasticsearchSettings,
        ) -> Self {
            self.elasticsearch_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide</i>.</p>
        pub fn set_elasticsearch_settings(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchSettings>,
        ) -> Self {
            self.elasticsearch_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint.
        /// For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn neptune_settings(mut self, input: crate::model::NeptuneSettings) -> Self {
            self.neptune_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint.
        /// For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_neptune_settings(
            mut self,
            input: std::option::Option<crate::model::NeptuneSettings>,
        ) -> Self {
            self.neptune_settings = input;
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn redshift_settings(mut self, input: crate::model::RedshiftSettings) -> Self {
            self.redshift_settings = Some(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn set_redshift_settings(
            mut self,
            input: std::option::Option<crate::model::RedshiftSettings>,
        ) -> Self {
            self.redshift_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn postgre_sql_settings(mut self, input: crate::model::PostgreSqlSettings) -> Self {
            self.postgre_sql_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_postgre_sql_settings(
            mut self,
            input: std::option::Option<crate::model::PostgreSqlSettings>,
        ) -> Self {
            self.postgre_sql_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes
        /// when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn my_sql_settings(mut self, input: crate::model::MySqlSettings) -> Self {
            self.my_sql_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes
        /// when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::MySqlSettings>,
        ) -> Self {
            self.my_sql_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes
        /// when using Oracle as a source for DMS</a> and
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn oracle_settings(mut self, input: crate::model::OracleSettings) -> Self {
            self.oracle_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes
        /// when using Oracle as a source for DMS</a> and
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_oracle_settings(
            mut self,
            input: std::option::Option<crate::model::OracleSettings>,
        ) -> Self {
            self.oracle_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn sybase_settings(mut self, input: crate::model::SybaseSettings) -> Self {
            self.sybase_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_sybase_settings(
            mut self,
            input: std::option::Option<crate::model::SybaseSettings>,
        ) -> Self {
            self.sybase_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn microsoft_sql_server_settings(
            mut self,
            input: crate::model::MicrosoftSqlServerSettings,
        ) -> Self {
            self.microsoft_sql_server_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_microsoft_sql_server_settings(
            mut self,
            input: std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        ) -> Self {
            self.microsoft_sql_server_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn ibm_db2_settings(mut self, input: crate::model::IbmDb2Settings) -> Self {
            self.ibm_db2_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_ibm_db2_settings(
            mut self,
            input: std::option::Option<crate::model::IbmDb2Settings>,
        ) -> Self {
            self.ibm_db2_settings = input;
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn doc_db_settings(mut self, input: crate::model::DocDbSettings) -> Self {
            self.doc_db_settings = Some(input);
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn set_doc_db_settings(
            mut self,
            input: std::option::Option<crate::model::DocDbSettings>,
        ) -> Self {
            self.doc_db_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Redis endpoint.</p>
        pub fn redis_settings(mut self, input: crate::model::RedisSettings) -> Self {
            self.redis_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Redis endpoint.</p>
        pub fn set_redis_settings(
            mut self,
            input: std::option::Option<crate::model::RedisSettings>,
        ) -> Self {
            self.redis_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointInput`](crate::input::CreateEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEndpointInput {
                endpoint_identifier: self.endpoint_identifier,
                endpoint_type: self.endpoint_type,
                engine_name: self.engine_name,
                username: self.username,
                password: self.password,
                server_name: self.server_name,
                port: self.port,
                database_name: self.database_name,
                extra_connection_attributes: self.extra_connection_attributes,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
                certificate_arn: self.certificate_arn,
                ssl_mode: self.ssl_mode,
                service_access_role_arn: self.service_access_role_arn,
                external_table_definition: self.external_table_definition,
                dynamo_db_settings: self.dynamo_db_settings,
                s3_settings: self.s3_settings,
                dms_transfer_settings: self.dms_transfer_settings,
                mongo_db_settings: self.mongo_db_settings,
                kinesis_settings: self.kinesis_settings,
                kafka_settings: self.kafka_settings,
                elasticsearch_settings: self.elasticsearch_settings,
                neptune_settings: self.neptune_settings,
                redshift_settings: self.redshift_settings,
                postgre_sql_settings: self.postgre_sql_settings,
                my_sql_settings: self.my_sql_settings,
                oracle_settings: self.oracle_settings,
                sybase_settings: self.sybase_settings,
                microsoft_sql_server_settings: self.microsoft_sql_server_settings,
                ibm_db2_settings: self.ibm_db2_settings,
                resource_identifier: self.resource_identifier,
                doc_db_settings: self.doc_db_settings,
                redis_settings: self.redis_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEndpointInputOperationOutputAlias = crate::operation::CreateEndpoint;
#[doc(hidden)]
pub type CreateEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateEndpoint`](crate::operation::CreateEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.CreateEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_endpoint(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEndpoint",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEndpointInput`](crate::input::CreateEndpointInput)
    pub fn builder() -> crate::input::create_endpoint_input::Builder {
        crate::input::create_endpoint_input::Builder::default()
    }
}

/// See [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
pub mod create_event_subscription_input {
    /// A builder for [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p> The type of DMS resource that generates the events. For example, if you want to be
        /// notified of events generated by a replication instance, you set this parameter to
        /// <code>replication-instance</code>. If this value isn't specified, all events are
        /// returned. </p>
        /// <p>Valid values: <code>replication-instance</code> | <code>replication-task</code>
        /// </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p> The type of DMS resource that generates the events. For example, if you want to be
        /// notified of events generated by a replication instance, you set this parameter to
        /// <code>replication-instance</code>. If this value isn't specified, all events are
        /// returned. </p>
        /// <p>Valid values: <code>replication-instance</code> | <code>replication-task</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories for a source type that you want to subscribe to. For more
        /// information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
        /// Notifications</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>A list of event categories for a source type that you want to subscribe to. For more
        /// information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
        /// Notifications</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `source_ids`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of identifiers for which DMS provides notification events.</p>
        /// <p>If you don't specify a value, notifications are provided for all sources.</p>
        /// <p>If you specify multiple values, they must be of the same type. For example, if you
        /// specify a database instance ID, then all of the other values must be database instance
        /// IDs.</p>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids.unwrap_or_default();
            v.push(input.into());
            self.source_ids = Some(v);
            self
        }
        /// <p>A list of identifiers for which DMS provides notification events.</p>
        /// <p>If you don't specify a value, notifications are provided for all sources.</p>
        /// <p>If you specify multiple values, they must be of the same type. For example, if you
        /// specify a database instance ID, then all of the other values must be database instance
        /// IDs.</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids = input;
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the event subscription.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags to be assigned to the event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                event_categories: self.event_categories,
                source_ids: self.source_ids,
                enabled: self.enabled,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationOutputAlias =
    crate::operation::CreateEventSubscription;
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventSubscription`](crate::operation::CreateEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.CreateEventSubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_event_subscription(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventSubscription",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
}

/// See [`CreateReplicationInstanceInput`](crate::input::CreateReplicationInstanceInput)
pub mod create_replication_instance_input {
    /// A builder for [`CreateReplicationInstanceInput`](crate::input::CreateReplicationInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) replication_instance_class: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) replication_subnet_group_identifier: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) dns_name_servers: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code>
        /// </p>
        pub fn replication_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = Some(input.into());
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code>
        /// </p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = input;
            self
        }
        /// <p>The amount of storage (in gigabytes) to be initially allocated for the replication
        /// instance.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be initially allocated for the replication
        /// instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn replication_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_class = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>The Availability Zone where the replication instance will be created. The default
        /// value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for
        /// example: <code>us-east-1d</code>
        /// </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone where the replication instance will be created. The default
        /// value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for
        /// example: <code>us-east-1d</code>
        /// </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>A subnet group to associate with the replication instance.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = Some(input.into());
            self
        }
        /// <p>A subnet group to associate with the replication instance.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region,
        /// occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region,
        /// occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication
        /// instance is created, the default is the latest engine version available.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication
        /// instance is created, the default is the latest engine version available.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the
        /// replication instance during the maintenance window. This parameter defaults to
        /// <code>true</code>.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the
        /// replication instance during the maintenance window. This parameter defaults to
        /// <code>true</code>.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the replication instance.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags to be assigned to the replication instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication
        /// instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication
        /// instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of
        /// <code>true</code> represents an instance with a public IP address. A value of
        /// <code>false</code> represents an instance with a private IP address. The default value
        /// is <code>true</code>. </p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of
        /// <code>true</code> represents an instance with a public IP address. A value of
        /// <code>false</code> represents an instance with a private IP address. The default value
        /// is <code>true</code>. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>A list of custom DNS name servers supported for the replication instance to access your
        /// on-premise source or target database. This list overrides the default name servers
        /// supported by the replication instance. You can specify a comma-separated list of internet
        /// addresses for up to four on-premise DNS name servers. For example:
        /// <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
        /// </p>
        pub fn dns_name_servers(mut self, input: impl Into<std::string::String>) -> Self {
            self.dns_name_servers = Some(input.into());
            self
        }
        /// <p>A list of custom DNS name servers supported for the replication instance to access your
        /// on-premise source or target database. This list overrides the default name servers
        /// supported by the replication instance. You can specify a comma-separated list of internet
        /// addresses for up to four on-premise DNS name servers. For example:
        /// <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
        /// </p>
        pub fn set_dns_name_servers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dns_name_servers = input;
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationInstanceInput`](crate::input::CreateReplicationInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplicationInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplicationInstanceInput {
                replication_instance_identifier: self.replication_instance_identifier,
                allocated_storage: self.allocated_storage,
                replication_instance_class: self.replication_instance_class,
                vpc_security_group_ids: self.vpc_security_group_ids,
                availability_zone: self.availability_zone,
                replication_subnet_group_identifier: self.replication_subnet_group_identifier,
                preferred_maintenance_window: self.preferred_maintenance_window,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                publicly_accessible: self.publicly_accessible,
                dns_name_servers: self.dns_name_servers,
                resource_identifier: self.resource_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplicationInstanceInputOperationOutputAlias =
    crate::operation::CreateReplicationInstance;
#[doc(hidden)]
pub type CreateReplicationInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReplicationInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplicationInstance`](crate::operation::CreateReplicationInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplicationInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReplicationInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReplicationInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReplicationInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.CreateReplicationInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_replication_instance(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplicationInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplicationInstance",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReplicationInstanceInput`](crate::input::CreateReplicationInstanceInput)
    pub fn builder() -> crate::input::create_replication_instance_input::Builder {
        crate::input::create_replication_instance_input::Builder::default()
    }
}

/// See [`CreateReplicationSubnetGroupInput`](crate::input::CreateReplicationSubnetGroupInput)
pub mod create_replication_subnet_group_input {
    /// A builder for [`CreateReplicationSubnetGroupInput`](crate::input::CreateReplicationSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_subnet_group_identifier: std::option::Option<std::string::String>,
        pub(crate) replication_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the replication subnet group. This value is stored as a lowercase
        /// string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces,
        /// underscores, or hyphens. Must not be "default".</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = Some(input.into());
            self
        }
        /// <p>The name for the replication subnet group. This value is stored as a lowercase
        /// string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces,
        /// underscores, or hyphens. Must not be "default".</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = input;
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn replication_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_description = Some(input.into());
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn set_replication_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>One or more subnet IDs to be assigned to the subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>One or more subnet IDs to be assigned to the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the subnet group.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags to be assigned to the subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationSubnetGroupInput`](crate::input::CreateReplicationSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplicationSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplicationSubnetGroupInput {
                replication_subnet_group_identifier: self.replication_subnet_group_identifier,
                replication_subnet_group_description: self.replication_subnet_group_description,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplicationSubnetGroupInputOperationOutputAlias =
    crate::operation::CreateReplicationSubnetGroup;
#[doc(hidden)]
pub type CreateReplicationSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReplicationSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplicationSubnetGroup`](crate::operation::CreateReplicationSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplicationSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReplicationSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReplicationSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReplicationSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.CreateReplicationSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_replication_subnet_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplicationSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplicationSubnetGroup",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReplicationSubnetGroupInput`](crate::input::CreateReplicationSubnetGroupInput)
    pub fn builder() -> crate::input::create_replication_subnet_group_input::Builder {
        crate::input::create_replication_subnet_group_input::Builder::default()
    }
}

/// See [`CreateReplicationTaskInput`](crate::input::CreateReplicationTaskInput)
pub mod create_replication_task_input {
    /// A builder for [`CreateReplicationTaskInput`](crate::input::CreateReplicationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_identifier: std::option::Option<std::string::String>,
        pub(crate) source_endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) target_endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) migration_type: std::option::Option<crate::model::MigrationTypeValue>,
        pub(crate) table_mappings: std::option::Option<std::string::String>,
        pub(crate) replication_task_settings: std::option::Option<std::string::String>,
        pub(crate) cdc_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cdc_start_position: std::option::Option<std::string::String>,
        pub(crate) cdc_stop_position: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) task_data: std::option::Option<std::string::String>,
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An identifier for the replication task.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn replication_task_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = Some(input.into());
            self
        }
        /// <p>An identifier for the replication task.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
        pub fn source_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_endpoint_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
        pub fn set_source_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_endpoint_arn = input;
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
        pub fn target_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_endpoint_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
        pub fn set_target_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_endpoint_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn migration_type(mut self, input: crate::model::MigrationTypeValue) -> Self {
            self.migration_type = Some(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.migration_type = input;
            self
        }
        /// <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table
        /// Mapping to Specify Task Settings</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn table_mappings(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_mappings = Some(input.into());
            self
        }
        /// <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table
        /// Mapping to Specify Task Settings</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_table_mappings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_mappings = input;
            self
        }
        /// <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task
        /// Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn replication_task_settings(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_settings = Some(input.into());
            self
        }
        /// <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task
        /// Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_replication_task_settings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_settings = input;
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.cdc_start_time = Some(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.cdc_start_time = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_start_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_start_position = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_stop_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_stop_position = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the replication task.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>One or more tags to be assigned to the replication task.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn task_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_data = Some(input.into());
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_task_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_data = input;
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateReplicationTaskInput`](crate::input::CreateReplicationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateReplicationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateReplicationTaskInput {
                replication_task_identifier: self.replication_task_identifier,
                source_endpoint_arn: self.source_endpoint_arn,
                target_endpoint_arn: self.target_endpoint_arn,
                replication_instance_arn: self.replication_instance_arn,
                migration_type: self.migration_type,
                table_mappings: self.table_mappings,
                replication_task_settings: self.replication_task_settings,
                cdc_start_time: self.cdc_start_time,
                cdc_start_position: self.cdc_start_position,
                cdc_stop_position: self.cdc_stop_position,
                tags: self.tags,
                task_data: self.task_data,
                resource_identifier: self.resource_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateReplicationTaskInputOperationOutputAlias = crate::operation::CreateReplicationTask;
#[doc(hidden)]
pub type CreateReplicationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateReplicationTaskInput {
    /// Consumes the builder and constructs an Operation<[`CreateReplicationTask`](crate::operation::CreateReplicationTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateReplicationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateReplicationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateReplicationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateReplicationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.CreateReplicationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_replication_task(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateReplicationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateReplicationTask",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateReplicationTaskInput`](crate::input::CreateReplicationTaskInput)
    pub fn builder() -> crate::input::create_replication_task_input::Builder {
        crate::input::create_replication_task_input::Builder::default()
    }
}

/// See [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
pub mod delete_certificate_input {
    /// A builder for [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the deleted certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCertificateInput {
                certificate_arn: self.certificate_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCertificateInputOperationOutputAlias = crate::operation::DeleteCertificate;
#[doc(hidden)]
pub type DeleteCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCertificateInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCertificate`](crate::operation::DeleteCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_certificate(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCertificate",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCertificateInput`](crate::input::DeleteCertificateInput)
    pub fn builder() -> crate::input::delete_certificate_input::Builder {
        crate::input::delete_certificate_input::Builder::default()
    }
}

/// See [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
pub mod delete_connection_input {
    /// A builder for [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteConnectionInput {
                endpoint_arn: self.endpoint_arn,
                replication_instance_arn: self.replication_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteConnectionInputOperationOutputAlias = crate::operation::DeleteConnection;
#[doc(hidden)]
pub type DeleteConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteConnectionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteConnection`](crate::operation::DeleteConnection)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_connection(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteConnection",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteConnectionInput`](crate::input::DeleteConnectionInput)
    pub fn builder() -> crate::input::delete_connection_input::Builder {
        crate::input::delete_connection_input::Builder::default()
    }
}

/// See [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
pub mod delete_endpoint_input {
    /// A builder for [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEndpointInput {
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEndpointInputOperationOutputAlias = crate::operation::DeleteEndpoint;
#[doc(hidden)]
pub type DeleteEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEndpoint`](crate::operation::DeleteEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_endpoint(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEndpoint",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEndpointInput`](crate::input::DeleteEndpointInput)
    pub fn builder() -> crate::input::delete_endpoint_input::Builder {
        crate::input::delete_endpoint_input::Builder::default()
    }
}

/// See [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
pub mod delete_event_subscription_input {
    /// A builder for [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DMS event notification subscription to be deleted.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the DMS event notification subscription to be deleted.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventSubscriptionInput {
                subscription_name: self.subscription_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteEventSubscription;
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventSubscription`](crate::operation::DeleteEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteEventSubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_event_subscription(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventSubscription",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
}

/// See [`DeleteReplicationInstanceInput`](crate::input::DeleteReplicationInstanceInput)
pub mod delete_replication_instance_input {
    /// A builder for [`DeleteReplicationInstanceInput`](crate::input::DeleteReplicationInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationInstanceInput`](crate::input::DeleteReplicationInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationInstanceInput {
                replication_instance_arn: self.replication_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationInstanceInputOperationOutputAlias =
    crate::operation::DeleteReplicationInstance;
#[doc(hidden)]
pub type DeleteReplicationInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReplicationInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationInstance`](crate::operation::DeleteReplicationInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteReplicationInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_replication_instance(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationInstance",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationInstanceInput`](crate::input::DeleteReplicationInstanceInput)
    pub fn builder() -> crate::input::delete_replication_instance_input::Builder {
        crate::input::delete_replication_instance_input::Builder::default()
    }
}

/// See [`DeleteReplicationSubnetGroupInput`](crate::input::DeleteReplicationSubnetGroupInput)
pub mod delete_replication_subnet_group_input {
    /// A builder for [`DeleteReplicationSubnetGroupInput`](crate::input::DeleteReplicationSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_subnet_group_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The subnet group name of the replication instance.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = Some(input.into());
            self
        }
        /// <p>The subnet group name of the replication instance.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationSubnetGroupInput`](crate::input::DeleteReplicationSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationSubnetGroupInput {
                replication_subnet_group_identifier: self.replication_subnet_group_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationSubnetGroupInputOperationOutputAlias =
    crate::operation::DeleteReplicationSubnetGroup;
#[doc(hidden)]
pub type DeleteReplicationSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReplicationSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationSubnetGroup`](crate::operation::DeleteReplicationSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteReplicationSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_replication_subnet_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationSubnetGroup",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationSubnetGroupInput`](crate::input::DeleteReplicationSubnetGroupInput)
    pub fn builder() -> crate::input::delete_replication_subnet_group_input::Builder {
        crate::input::delete_replication_subnet_group_input::Builder::default()
    }
}

/// See [`DeleteReplicationTaskInput`](crate::input::DeleteReplicationTaskInput)
pub mod delete_replication_task_input {
    /// A builder for [`DeleteReplicationTaskInput`](crate::input::DeleteReplicationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationTaskInput`](crate::input::DeleteReplicationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationTaskInput {
                replication_task_arn: self.replication_task_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationTaskInputOperationOutputAlias = crate::operation::DeleteReplicationTask;
#[doc(hidden)]
pub type DeleteReplicationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReplicationTaskInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationTask`](crate::operation::DeleteReplicationTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteReplicationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_replication_task(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationTask",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationTaskInput`](crate::input::DeleteReplicationTaskInput)
    pub fn builder() -> crate::input::delete_replication_task_input::Builder {
        crate::input::delete_replication_task_input::Builder::default()
    }
}

/// See [`DeleteReplicationTaskAssessmentRunInput`](crate::input::DeleteReplicationTaskAssessmentRunInput)
pub mod delete_replication_task_assessment_run_input {
    /// A builder for [`DeleteReplicationTaskAssessmentRunInput`](crate::input::DeleteReplicationTaskAssessmentRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_assessment_run_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_assessment_run_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteReplicationTaskAssessmentRunInput`](crate::input::DeleteReplicationTaskAssessmentRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteReplicationTaskAssessmentRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteReplicationTaskAssessmentRunInput {
                replication_task_assessment_run_arn: self.replication_task_assessment_run_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteReplicationTaskAssessmentRunInputOperationOutputAlias =
    crate::operation::DeleteReplicationTaskAssessmentRun;
#[doc(hidden)]
pub type DeleteReplicationTaskAssessmentRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteReplicationTaskAssessmentRunInput {
    /// Consumes the builder and constructs an Operation<[`DeleteReplicationTaskAssessmentRun`](crate::operation::DeleteReplicationTaskAssessmentRun)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteReplicationTaskAssessmentRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteReplicationTaskAssessmentRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteReplicationTaskAssessmentRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteReplicationTaskAssessmentRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DeleteReplicationTaskAssessmentRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_replication_task_assessment_run(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteReplicationTaskAssessmentRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteReplicationTaskAssessmentRun",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteReplicationTaskAssessmentRunInput`](crate::input::DeleteReplicationTaskAssessmentRunInput)
    pub fn builder() -> crate::input::delete_replication_task_assessment_run_input::Builder {
        crate::input::delete_replication_task_assessment_run_input::Builder::default()
    }
}

/// See [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
pub mod describe_account_attributes_input {
    /// A builder for [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAttributesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationOutputAlias =
    crate::operation::DescribeAccountAttributes;
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeAccountAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAttributes`](crate::operation::DescribeAccountAttributes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAttributes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAccountAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAccountAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAccountAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeAccountAttributes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_account_attributes(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAttributes",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
}

/// See [`DescribeApplicableIndividualAssessmentsInput`](crate::input::DescribeApplicableIndividualAssessmentsInput)
pub mod describe_applicable_individual_assessments_input {
    /// A builder for [`DescribeApplicableIndividualAssessmentsInput`](crate::input::DescribeApplicableIndividualAssessmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) source_engine_name: std::option::Option<std::string::String>,
        pub(crate) target_engine_name: std::option::Option<std::string::String>,
        pub(crate) migration_type: std::option::Option<crate::model::MigrationTypeValue>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of a migration task on which you want to base
        /// the default list of individual assessments.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of a migration task on which you want to base
        /// the default list of individual assessments.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>ARN of a replication instance on which you want to base the default list of individual
        /// assessments.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>ARN of a replication instance on which you want to base the default list of individual
        /// assessments.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a source.</p>
        pub fn source_engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_engine_name = Some(input.into());
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a source.</p>
        pub fn set_source_engine_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_engine_name = input;
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a target.</p>
        pub fn target_engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_engine_name = Some(input.into());
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a target.</p>
        pub fn set_target_engine_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_engine_name = input;
            self
        }
        /// <p>Name of the migration type that each provided individual assessment must support.</p>
        pub fn migration_type(mut self, input: crate::model::MigrationTypeValue) -> Self {
            self.migration_type = Some(input);
            self
        }
        /// <p>Name of the migration type that each provided individual assessment must support.</p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.migration_type = input;
            self
        }
        /// <p>Maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>Maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>Optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>Optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeApplicableIndividualAssessmentsInput`](crate::input::DescribeApplicableIndividualAssessmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeApplicableIndividualAssessmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeApplicableIndividualAssessmentsInput {
                replication_task_arn: self.replication_task_arn,
                replication_instance_arn: self.replication_instance_arn,
                source_engine_name: self.source_engine_name,
                target_engine_name: self.target_engine_name,
                migration_type: self.migration_type,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeApplicableIndividualAssessmentsInputOperationOutputAlias =
    crate::operation::DescribeApplicableIndividualAssessments;
#[doc(hidden)]
pub type DescribeApplicableIndividualAssessmentsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeApplicableIndividualAssessmentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeApplicableIndividualAssessments`](crate::operation::DescribeApplicableIndividualAssessments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeApplicableIndividualAssessments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeApplicableIndividualAssessmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeApplicableIndividualAssessmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeApplicableIndividualAssessmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeApplicableIndividualAssessments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_applicable_individual_assessments(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeApplicableIndividualAssessments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeApplicableIndividualAssessments",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeApplicableIndividualAssessmentsInput`](crate::input::DescribeApplicableIndividualAssessmentsInput)
    pub fn builder() -> crate::input::describe_applicable_individual_assessments_input::Builder {
        crate::input::describe_applicable_individual_assessments_input::Builder::default()
    }
}

/// See [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
pub mod describe_certificates_input {
    /// A builder for [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the certificates described in the form of key-value pairs.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to the certificates described in the form of key-value pairs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 10</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 10</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCertificatesInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCertificatesInputOperationOutputAlias = crate::operation::DescribeCertificates;
#[doc(hidden)]
pub type DescribeCertificatesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCertificates`](crate::operation::DescribeCertificates)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCertificates,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCertificatesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCertificatesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCertificatesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeCertificates",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_certificates(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCertificates",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    pub fn builder() -> crate::input::describe_certificates_input::Builder {
        crate::input::describe_certificates_input::Builder::default()
    }
}

/// See [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
pub mod describe_connections_input {
    /// A builder for [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters applied to the connection.</p>
        /// <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>The filters applied to the connection.</p>
        /// <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeConnectionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeConnectionsInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeConnectionsInputOperationOutputAlias = crate::operation::DescribeConnections;
#[doc(hidden)]
pub type DescribeConnectionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeConnectionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeConnections`](crate::operation::DescribeConnections)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeConnections,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeConnectionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeConnectionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeConnectionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeConnections",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_connections(&self)
                .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeConnections::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeConnections",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeConnectionsInput`](crate::input::DescribeConnectionsInput)
    pub fn builder() -> crate::input::describe_connections_input::Builder {
        crate::input::describe_connections_input::Builder::default()
    }
}

/// See [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
pub mod describe_endpoints_input {
    /// A builder for [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the endpoints.</p>
        /// <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to the endpoints.</p>
        /// <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointsInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointsInputOperationOutputAlias = crate::operation::DescribeEndpoints;
#[doc(hidden)]
pub type DescribeEndpointsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpoints`](crate::operation::DescribeEndpoints)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpoints,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeEndpoints",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoints(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpoints",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
    pub fn builder() -> crate::input::describe_endpoints_input::Builder {
        crate::input::describe_endpoints_input::Builder::default()
    }
}

/// See [`DescribeEndpointSettingsInput`](crate::input::DescribeEndpointSettingsInput)
pub mod describe_endpoint_settings_input {
    /// A builder for [`DescribeEndpointSettingsInput`](crate::input::DescribeEndpointSettingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_name: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The databse engine used for your source or target endpoint.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_name = Some(input.into());
            self
        }
        /// <p>The databse engine used for your source or target endpoint.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_name = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response
        /// so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response
        /// so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointSettingsInput`](crate::input::DescribeEndpointSettingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointSettingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointSettingsInput {
                engine_name: self.engine_name,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointSettingsInputOperationOutputAlias =
    crate::operation::DescribeEndpointSettings;
#[doc(hidden)]
pub type DescribeEndpointSettingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointSettingsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpointSettings`](crate::operation::DescribeEndpointSettings)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpointSettings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointSettingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointSettingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointSettingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeEndpointSettings",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint_settings(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpointSettings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpointSettings",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointSettingsInput`](crate::input::DescribeEndpointSettingsInput)
    pub fn builder() -> crate::input::describe_endpoint_settings_input::Builder {
        crate::input::describe_endpoint_settings_input::Builder::default()
    }
}

/// See [`DescribeEndpointTypesInput`](crate::input::DescribeEndpointTypesInput)
pub mod describe_endpoint_types_input {
    /// A builder for [`DescribeEndpointTypesInput`](crate::input::DescribeEndpointTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the endpoint types.</p>
        /// <p>Valid filter names: engine-name | endpoint-type</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to the endpoint types.</p>
        /// <p>Valid filter names: engine-name | endpoint-type</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointTypesInput`](crate::input::DescribeEndpointTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEndpointTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEndpointTypesInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEndpointTypesInputOperationOutputAlias = crate::operation::DescribeEndpointTypes;
#[doc(hidden)]
pub type DescribeEndpointTypesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEndpointTypesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEndpointTypes`](crate::operation::DescribeEndpointTypes)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEndpointTypes,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEndpointTypesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEndpointTypesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEndpointTypesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeEndpointTypes",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_endpoint_types(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEndpointTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEndpointTypes",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEndpointTypesInput`](crate::input::DescribeEndpointTypesInput)
    pub fn builder() -> crate::input::describe_endpoint_types_input::Builder {
        crate::input::describe_endpoint_types_input::Builder::default()
    }
}

/// See [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
pub mod describe_event_categories_input {
    /// A builder for [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the event categories.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to the event categories.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventCategoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventCategoriesInput {
                source_type: self.source_type,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationOutputAlias =
    crate::operation::DescribeEventCategories;
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventCategoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventCategories`](crate::operation::DescribeEventCategories)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventCategories,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventCategoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventCategoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventCategoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeEventCategories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_categories(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventCategories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventCategories",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The identifier of an event source.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p> The identifier of an event source.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The type of DMS resource that generates events.</p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The type of DMS resource that generates events.</p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The start time for the events to be listed.</p>
        pub fn start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time for the events to be listed.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time for the events to be listed.</p>
        pub fn end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time for the events to be listed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The duration of the events to be listed.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the events to be listed.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories for the source type that you've chosen.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>A list of event categories for the source type that you've chosen.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to events.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to events.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                event_categories: self.event_categories,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeEvents",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
pub mod describe_event_subscriptions_input {
    /// A builder for [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DMS event subscription to be described.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the DMS event subscription to be described.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to event subscriptions.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to event subscriptions.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventSubscriptionsInput {
                subscription_name: self.subscription_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeEventSubscriptions;
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEventSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventSubscriptions`](crate::operation::DescribeEventSubscriptions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventSubscriptions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEventSubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEventSubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEventSubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeEventSubscriptions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_event_subscriptions(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventSubscriptions",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeOrderableReplicationInstancesInput`](crate::input::DescribeOrderableReplicationInstancesInput)
pub mod describe_orderable_replication_instances_input {
    /// A builder for [`DescribeOrderableReplicationInstancesInput`](crate::input::DescribeOrderableReplicationInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrderableReplicationInstancesInput`](crate::input::DescribeOrderableReplicationInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrderableReplicationInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrderableReplicationInstancesInput {
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOrderableReplicationInstancesInputOperationOutputAlias =
    crate::operation::DescribeOrderableReplicationInstances;
#[doc(hidden)]
pub type DescribeOrderableReplicationInstancesInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeOrderableReplicationInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrderableReplicationInstances`](crate::operation::DescribeOrderableReplicationInstances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrderableReplicationInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrderableReplicationInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrderableReplicationInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrderableReplicationInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeOrderableReplicationInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_orderable_replication_instances(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrderableReplicationInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrderableReplicationInstances",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrderableReplicationInstancesInput`](crate::input::DescribeOrderableReplicationInstancesInput)
    pub fn builder() -> crate::input::describe_orderable_replication_instances_input::Builder {
        crate::input::describe_orderable_replication_instances_input::Builder::default()
    }
}

/// See [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
pub mod describe_pending_maintenance_actions_input {
    /// A builder for [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p></p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribePendingMaintenanceActionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribePendingMaintenanceActionsInput {
                replication_instance_arn: self.replication_instance_arn,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribePendingMaintenanceActionsInputOperationOutputAlias =
    crate::operation::DescribePendingMaintenanceActions;
#[doc(hidden)]
pub type DescribePendingMaintenanceActionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribePendingMaintenanceActionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribePendingMaintenanceActions`](crate::operation::DescribePendingMaintenanceActions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribePendingMaintenanceActions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribePendingMaintenanceActionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribePendingMaintenanceActionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribePendingMaintenanceActionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribePendingMaintenanceActions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_pending_maintenance_actions(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribePendingMaintenanceActions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribePendingMaintenanceActions",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsInput`](crate::input::DescribePendingMaintenanceActionsInput)
    pub fn builder() -> crate::input::describe_pending_maintenance_actions_input::Builder {
        crate::input::describe_pending_maintenance_actions_input::Builder::default()
    }
}

/// See [`DescribeRefreshSchemasStatusInput`](crate::input::DescribeRefreshSchemasStatusInput)
pub mod describe_refresh_schemas_status_input {
    /// A builder for [`DescribeRefreshSchemasStatusInput`](crate::input::DescribeRefreshSchemasStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRefreshSchemasStatusInput`](crate::input::DescribeRefreshSchemasStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRefreshSchemasStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRefreshSchemasStatusInput {
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRefreshSchemasStatusInputOperationOutputAlias =
    crate::operation::DescribeRefreshSchemasStatus;
#[doc(hidden)]
pub type DescribeRefreshSchemasStatusInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeRefreshSchemasStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRefreshSchemasStatus`](crate::operation::DescribeRefreshSchemasStatus)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRefreshSchemasStatus,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRefreshSchemasStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRefreshSchemasStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRefreshSchemasStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeRefreshSchemasStatus",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_refresh_schemas_status(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRefreshSchemasStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRefreshSchemasStatus",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRefreshSchemasStatusInput`](crate::input::DescribeRefreshSchemasStatusInput)
    pub fn builder() -> crate::input::describe_refresh_schemas_status_input::Builder {
        crate::input::describe_refresh_schemas_status_input::Builder::default()
    }
}

/// See [`DescribeReplicationInstancesInput`](crate::input::DescribeReplicationInstancesInput)
pub mod describe_replication_instances_input {
    /// A builder for [`DescribeReplicationInstancesInput`](crate::input::DescribeReplicationInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication instances.</p>
        /// <p>Valid filter names: replication-instance-arn | replication-instance-id |
        /// replication-instance-class | engine-version</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to replication instances.</p>
        /// <p>Valid filter names: replication-instance-arn | replication-instance-id |
        /// replication-instance-class | engine-version</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationInstancesInput`](crate::input::DescribeReplicationInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReplicationInstancesInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationInstancesInputOperationOutputAlias =
    crate::operation::DescribeReplicationInstances;
#[doc(hidden)]
pub type DescribeReplicationInstancesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReplicationInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationInstances`](crate::operation::DescribeReplicationInstances)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationInstances,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeReplicationInstances",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_instances(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationInstances",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationInstancesInput`](crate::input::DescribeReplicationInstancesInput)
    pub fn builder() -> crate::input::describe_replication_instances_input::Builder {
        crate::input::describe_replication_instances_input::Builder::default()
    }
}

/// See [`DescribeReplicationInstanceTaskLogsInput`](crate::input::DescribeReplicationInstanceTaskLogsInput)
pub mod describe_replication_instance_task_logs_input {
    /// A builder for [`DescribeReplicationInstanceTaskLogsInput`](crate::input::DescribeReplicationInstanceTaskLogsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationInstanceTaskLogsInput`](crate::input::DescribeReplicationInstanceTaskLogsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationInstanceTaskLogsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReplicationInstanceTaskLogsInput {
                replication_instance_arn: self.replication_instance_arn,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationInstanceTaskLogsInputOperationOutputAlias =
    crate::operation::DescribeReplicationInstanceTaskLogs;
#[doc(hidden)]
pub type DescribeReplicationInstanceTaskLogsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeReplicationInstanceTaskLogsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationInstanceTaskLogs`](crate::operation::DescribeReplicationInstanceTaskLogs)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationInstanceTaskLogs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationInstanceTaskLogsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationInstanceTaskLogsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationInstanceTaskLogsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeReplicationInstanceTaskLogs",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_instance_task_logs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationInstanceTaskLogs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationInstanceTaskLogs",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationInstanceTaskLogsInput`](crate::input::DescribeReplicationInstanceTaskLogsInput)
    pub fn builder() -> crate::input::describe_replication_instance_task_logs_input::Builder {
        crate::input::describe_replication_instance_task_logs_input::Builder::default()
    }
}

/// See [`DescribeReplicationSubnetGroupsInput`](crate::input::DescribeReplicationSubnetGroupsInput)
pub mod describe_replication_subnet_groups_input {
    /// A builder for [`DescribeReplicationSubnetGroupsInput`](crate::input::DescribeReplicationSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication subnet groups.</p>
        /// <p>Valid filter names: replication-subnet-group-id</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to replication subnet groups.</p>
        /// <p>Valid filter names: replication-subnet-group-id</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationSubnetGroupsInput`](crate::input::DescribeReplicationSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReplicationSubnetGroupsInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationSubnetGroupsInputOperationOutputAlias =
    crate::operation::DescribeReplicationSubnetGroups;
#[doc(hidden)]
pub type DescribeReplicationSubnetGroupsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReplicationSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationSubnetGroups`](crate::operation::DescribeReplicationSubnetGroups)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationSubnetGroups,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationSubnetGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationSubnetGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationSubnetGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeReplicationSubnetGroups",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_subnet_groups(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationSubnetGroups",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationSubnetGroupsInput`](crate::input::DescribeReplicationSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_replication_subnet_groups_input::Builder {
        crate::input::describe_replication_subnet_groups_input::Builder::default()
    }
}

/// See [`DescribeReplicationTaskAssessmentResultsInput`](crate::input::DescribeReplicationTaskAssessmentResultsInput)
pub mod describe_replication_task_assessment_results_input {
    /// A builder for [`DescribeReplicationTaskAssessmentResultsInput`](crate::input::DescribeReplicationTaskAssessmentResultsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input
        /// parameter is specified, the API returns only one result and ignore the values of the
        /// <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input
        /// parameter is specified, the API returns only one result and ignore the values of the
        /// <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationTaskAssessmentResultsInput`](crate::input::DescribeReplicationTaskAssessmentResultsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationTaskAssessmentResultsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeReplicationTaskAssessmentResultsInput {
                    replication_task_arn: self.replication_task_arn,
                    max_records: self.max_records,
                    marker: self.marker,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationTaskAssessmentResultsInputOperationOutputAlias =
    crate::operation::DescribeReplicationTaskAssessmentResults;
#[doc(hidden)]
pub type DescribeReplicationTaskAssessmentResultsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeReplicationTaskAssessmentResultsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationTaskAssessmentResults`](crate::operation::DescribeReplicationTaskAssessmentResults)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationTaskAssessmentResults,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationTaskAssessmentResultsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationTaskAssessmentResultsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationTaskAssessmentResultsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeReplicationTaskAssessmentResults",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_task_assessment_results(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationTaskAssessmentResults::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationTaskAssessmentResults",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTaskAssessmentResultsInput`](crate::input::DescribeReplicationTaskAssessmentResultsInput)
    pub fn builder() -> crate::input::describe_replication_task_assessment_results_input::Builder {
        crate::input::describe_replication_task_assessment_results_input::Builder::default()
    }
}

/// See [`DescribeReplicationTaskAssessmentRunsInput`](crate::input::DescribeReplicationTaskAssessmentRunsInput)
pub mod describe_replication_task_assessment_runs_input {
    /// A builder for [`DescribeReplicationTaskAssessmentRunsInput`](crate::input::DescribeReplicationTaskAssessmentRunsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>,
        /// <code>replication-instance-arn</code>, <code>status</code>
        /// </p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>,
        /// <code>replication-instance-arn</code>, <code>status</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationTaskAssessmentRunsInput`](crate::input::DescribeReplicationTaskAssessmentRunsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationTaskAssessmentRunsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReplicationTaskAssessmentRunsInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationTaskAssessmentRunsInputOperationOutputAlias =
    crate::operation::DescribeReplicationTaskAssessmentRuns;
#[doc(hidden)]
pub type DescribeReplicationTaskAssessmentRunsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeReplicationTaskAssessmentRunsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationTaskAssessmentRuns`](crate::operation::DescribeReplicationTaskAssessmentRuns)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationTaskAssessmentRuns,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationTaskAssessmentRunsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationTaskAssessmentRunsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationTaskAssessmentRunsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeReplicationTaskAssessmentRuns",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_task_assessment_runs(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationTaskAssessmentRuns::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationTaskAssessmentRuns",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTaskAssessmentRunsInput`](crate::input::DescribeReplicationTaskAssessmentRunsInput)
    pub fn builder() -> crate::input::describe_replication_task_assessment_runs_input::Builder {
        crate::input::describe_replication_task_assessment_runs_input::Builder::default()
    }
}

/// See [`DescribeReplicationTaskIndividualAssessmentsInput`](crate::input::DescribeReplicationTaskIndividualAssessmentsInput)
pub mod describe_replication_task_individual_assessments_input {
    /// A builder for [`DescribeReplicationTaskIndividualAssessmentsInput`](crate::input::DescribeReplicationTaskIndividualAssessmentsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the individual assessments described in the form of key-value
        /// pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>,
        /// <code>replication-task-arn</code>, <code>status</code>
        /// </p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to the individual assessments described in the form of key-value
        /// pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>,
        /// <code>replication-task-arn</code>, <code>status</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationTaskIndividualAssessmentsInput`](crate::input::DescribeReplicationTaskIndividualAssessmentsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationTaskIndividualAssessmentsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(
                crate::input::DescribeReplicationTaskIndividualAssessmentsInput {
                    filters: self.filters,
                    max_records: self.max_records,
                    marker: self.marker,
                },
            )
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationTaskIndividualAssessmentsInputOperationOutputAlias =
    crate::operation::DescribeReplicationTaskIndividualAssessments;
#[doc(hidden)]
pub type DescribeReplicationTaskIndividualAssessmentsInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DescribeReplicationTaskIndividualAssessmentsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationTaskIndividualAssessments`](crate::operation::DescribeReplicationTaskIndividualAssessments)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationTaskIndividualAssessments,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationTaskIndividualAssessmentsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationTaskIndividualAssessmentsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationTaskIndividualAssessmentsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeReplicationTaskIndividualAssessments",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_task_individual_assessments(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationTaskIndividualAssessments::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationTaskIndividualAssessments",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTaskIndividualAssessmentsInput`](crate::input::DescribeReplicationTaskIndividualAssessmentsInput)
    pub fn builder() -> crate::input::describe_replication_task_individual_assessments_input::Builder
    {
        crate::input::describe_replication_task_individual_assessments_input::Builder::default()
    }
}

/// See [`DescribeReplicationTasksInput`](crate::input::DescribeReplicationTasksInput)
pub mod describe_replication_tasks_input {
    /// A builder for [`DescribeReplicationTasksInput`](crate::input::DescribeReplicationTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) without_settings: std::option::Option<bool>,
    }
    impl Builder {
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication tasks.</p>
        /// <p>Valid filter names: replication-task-arn | replication-task-id | migration-type |
        /// endpoint-arn | replication-instance-arn</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to replication tasks.</p>
        /// <p>Valid filter names: replication-task-arn | replication-task-id | migration-type |
        /// endpoint-arn | replication-instance-arn</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>An option to set to avoid returning information about settings. Use this to reduce
        /// overhead when setting information is too large. To use this option, choose
        /// <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
        pub fn without_settings(mut self, input: bool) -> Self {
            self.without_settings = Some(input);
            self
        }
        /// <p>An option to set to avoid returning information about settings. Use this to reduce
        /// overhead when setting information is too large. To use this option, choose
        /// <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
        pub fn set_without_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.without_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReplicationTasksInput`](crate::input::DescribeReplicationTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReplicationTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReplicationTasksInput {
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                without_settings: self.without_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReplicationTasksInputOperationOutputAlias =
    crate::operation::DescribeReplicationTasks;
#[doc(hidden)]
pub type DescribeReplicationTasksInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReplicationTasksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReplicationTasks`](crate::operation::DescribeReplicationTasks)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReplicationTasks,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReplicationTasksInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReplicationTasksInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReplicationTasksInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeReplicationTasks",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_replication_tasks(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReplicationTasks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReplicationTasks",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReplicationTasksInput`](crate::input::DescribeReplicationTasksInput)
    pub fn builder() -> crate::input::describe_replication_tasks_input::Builder {
        crate::input::describe_replication_tasks_input::Builder::default()
    }
}

/// See [`DescribeSchemasInput`](crate::input::DescribeSchemasInput)
pub mod describe_schemas_input {
    /// A builder for [`DescribeSchemasInput`](crate::input::DescribeSchemasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSchemasInput`](crate::input::DescribeSchemasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSchemasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSchemasInput {
                endpoint_arn: self.endpoint_arn,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSchemasInputOperationOutputAlias = crate::operation::DescribeSchemas;
#[doc(hidden)]
pub type DescribeSchemasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeSchemasInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSchemas`](crate::operation::DescribeSchemas)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSchemas,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSchemasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSchemasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSchemasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeSchemas",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_schemas(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSchemas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSchemas",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSchemasInput`](crate::input::DescribeSchemasInput)
    pub fn builder() -> crate::input::describe_schemas_input::Builder {
        crate::input::describe_schemas_input::Builder::default()
    }
}

/// See [`DescribeTableStatisticsInput`](crate::input::DescribeTableStatisticsInput)
pub mod describe_table_statistics_input {
    /// A builder for [`DescribeTableStatisticsInput`](crate::input::DescribeTableStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 500.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 500.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to table statistics.</p>
        /// <p>Valid filter names: schema-name | table-name | table-state</p>
        /// <p>A combination of filters creates an AND condition where each record matches all
        /// specified filters.</p>
        pub fn filters(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input.into());
            self.filters = Some(v);
            self
        }
        /// <p>Filters applied to table statistics.</p>
        /// <p>Valid filter names: schema-name | table-name | table-state</p>
        /// <p>A combination of filters creates an AND condition where each record matches all
        /// specified filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableStatisticsInput`](crate::input::DescribeTableStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTableStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTableStatisticsInput {
                replication_task_arn: self.replication_task_arn,
                max_records: self.max_records,
                marker: self.marker,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTableStatisticsInputOperationOutputAlias =
    crate::operation::DescribeTableStatistics;
#[doc(hidden)]
pub type DescribeTableStatisticsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTableStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTableStatistics`](crate::operation::DescribeTableStatistics)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTableStatistics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTableStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTableStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTableStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.DescribeTableStatistics",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_table_statistics(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTableStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTableStatistics",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTableStatisticsInput`](crate::input::DescribeTableStatisticsInput)
    pub fn builder() -> crate::input::describe_table_statistics_input::Builder {
        crate::input::describe_table_statistics_input::Builder::default()
    }
}

/// See [`ImportCertificateInput`](crate::input::ImportCertificateInput)
pub mod import_certificate_input {
    /// A builder for [`ImportCertificateInput`](crate::input::ImportCertificateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) certificate_pem: std::option::Option<std::string::String>,
        pub(crate) certificate_wallet: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
        /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        pub fn certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_identifier = Some(input.into());
            self
        }
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
        /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_identifier = input;
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn certificate_pem(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_pem = Some(input.into());
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_pem = input;
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file
        /// using the <code>fileb://</code> prefix. You can't provide the certificate inline.
        /// </p>
        pub fn certificate_wallet(mut self, input: aws_smithy_types::Blob) -> Self {
            self.certificate_wallet = Some(input);
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file
        /// using the <code>fileb://</code> prefix. You can't provide the certificate inline.
        /// </p>
        pub fn set_certificate_wallet(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.certificate_wallet = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the certificate.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags associated with the certificate.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportCertificateInput`](crate::input::ImportCertificateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ImportCertificateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ImportCertificateInput {
                certificate_identifier: self.certificate_identifier,
                certificate_pem: self.certificate_pem,
                certificate_wallet: self.certificate_wallet,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type ImportCertificateInputOperationOutputAlias = crate::operation::ImportCertificate;
#[doc(hidden)]
pub type ImportCertificateInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ImportCertificateInput {
    /// Consumes the builder and constructs an Operation<[`ImportCertificate`](crate::operation::ImportCertificate)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ImportCertificate,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ImportCertificateInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ImportCertificateInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ImportCertificateInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ImportCertificate",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_import_certificate(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ImportCertificate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ImportCertificate",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ImportCertificateInput`](crate::input::ImportCertificateInput)
    pub fn builder() -> crate::input::import_certificate_input::Builder {
        crate::input::import_certificate_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) resource_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to
        /// list tags for. This returns a list of keys (names of tags) created for the resource and
        /// their associated tag values.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to
        /// list tags for. This returns a list of keys (names of tags) created for the resource and
        /// their associated tag values.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `resource_arn_list`.
        ///
        /// To override the contents of this collection use [`set_resource_arn_list`](Self::set_resource_arn_list).
        ///
        /// <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This
        /// returns a list of keys (tag names) and their associated tag values. It also returns each
        /// tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which
        /// each listed tag is created. </p>
        pub fn resource_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resource_arn_list.unwrap_or_default();
            v.push(input.into());
            self.resource_arn_list = Some(v);
            self
        }
        /// <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This
        /// returns a list of keys (tag names) and their associated tag values. It also returns each
        /// tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which
        /// each listed tag is created. </p>
        pub fn set_resource_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resource_arn_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
                resource_arn_list: self.resource_arn_list,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ListTagsForResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_tags_for_resource(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ModifyEndpointInput`](crate::input::ModifyEndpointInput)
pub mod modify_endpoint_input {
    /// A builder for [`ModifyEndpointInput`](crate::input::ModifyEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        pub(crate) engine_name: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) server_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) extra_connection_attributes: std::option::Option<std::string::String>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) ssl_mode: std::option::Option<crate::model::DmsSslModeValue>,
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) external_table_definition: std::option::Option<std::string::String>,
        pub(crate) dynamo_db_settings: std::option::Option<crate::model::DynamoDbSettings>,
        pub(crate) s3_settings: std::option::Option<crate::model::S3Settings>,
        pub(crate) dms_transfer_settings: std::option::Option<crate::model::DmsTransferSettings>,
        pub(crate) mongo_db_settings: std::option::Option<crate::model::MongoDbSettings>,
        pub(crate) kinesis_settings: std::option::Option<crate::model::KinesisSettings>,
        pub(crate) kafka_settings: std::option::Option<crate::model::KafkaSettings>,
        pub(crate) elasticsearch_settings: std::option::Option<crate::model::ElasticsearchSettings>,
        pub(crate) neptune_settings: std::option::Option<crate::model::NeptuneSettings>,
        pub(crate) redshift_settings: std::option::Option<crate::model::RedshiftSettings>,
        pub(crate) postgre_sql_settings: std::option::Option<crate::model::PostgreSqlSettings>,
        pub(crate) my_sql_settings: std::option::Option<crate::model::MySqlSettings>,
        pub(crate) oracle_settings: std::option::Option<crate::model::OracleSettings>,
        pub(crate) sybase_settings: std::option::Option<crate::model::SybaseSettings>,
        pub(crate) microsoft_sql_server_settings:
            std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        pub(crate) ibm_db2_settings: std::option::Option<crate::model::IbmDb2Settings>,
        pub(crate) doc_db_settings: std::option::Option<crate::model::DocDbSettings>,
        pub(crate) redis_settings: std::option::Option<crate::model::RedisSettings>,
        pub(crate) exact_settings: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_identifier = input;
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn endpoint_type(mut self, input: crate::model::ReplicationEndpointTypeValue) -> Self {
            self.endpoint_type = Some(input);
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the EndpointType,
        /// include
        /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
        /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>,
        /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
        /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
        /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_name = Some(input.into());
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the EndpointType,
        /// include
        /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
        /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>,
        /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
        /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
        /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_name = input;
            self
        }
        /// <p>The user name to be used to login to the endpoint database.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name to be used to login to the endpoint database.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password to be used to login to the endpoint database.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password to be used to login to the endpoint database.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn server_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.server_name = Some(input.into());
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.server_name = input;
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Additional attributes associated with the connection. To reset this parameter, pass the
        /// empty string ("") as an argument.</p>
        pub fn extra_connection_attributes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.extra_connection_attributes = Some(input.into());
            self
        }
        /// <p>Additional attributes associated with the connection. To reset this parameter, pass the
        /// empty string ("") as an argument.</p>
        pub fn set_extra_connection_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.extra_connection_attributes = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>The SSL mode used to connect to the endpoint.  The default value is <code>none</code>.</p>
        pub fn ssl_mode(mut self, input: crate::model::DmsSslModeValue) -> Self {
            self.ssl_mode = Some(input);
            self
        }
        /// <p>The SSL mode used to connect to the endpoint.  The default value is <code>none</code>.</p>
        pub fn set_ssl_mode(
            mut self,
            input: std::option::Option<crate::model::DmsSslModeValue>,
        ) -> Self {
            self.ssl_mode = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify
        /// the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify
        /// the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>The external table definition.</p>
        pub fn external_table_definition(mut self, input: impl Into<std::string::String>) -> Self {
            self.external_table_definition = Some(input.into());
            self
        }
        /// <p>The external table definition.</p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.external_table_definition = input;
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn dynamo_db_settings(mut self, input: crate::model::DynamoDbSettings) -> Self {
            self.dynamo_db_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_dynamo_db_settings(
            mut self,
            input: std::option::Option<crate::model::DynamoDbSettings>,
        ) -> Self {
            self.dynamo_db_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn s3_settings(mut self, input: crate::model::S3Settings) -> Self {
            self.s3_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_s3_settings(
            mut self,
            input: std::option::Option<crate::model::S3Settings>,
        ) -> Self {
            self.s3_settings = input;
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Attributes include the following:</p>
        /// <ul>
        /// <li>
        /// <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>BucketName - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string
        /// ,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string",
        /// "BucketName": "string"} </code>
        /// </p>
        pub fn dms_transfer_settings(mut self, input: crate::model::DmsTransferSettings) -> Self {
            self.dms_transfer_settings = Some(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Attributes include the following:</p>
        /// <ul>
        /// <li>
        /// <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>BucketName - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string
        /// ,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string",
        /// "BucketName": "string"} </code>
        /// </p>
        pub fn set_dms_transfer_settings(
            mut self,
            input: std::option::Option<crate::model::DmsTransferSettings>,
        ) -> Self {
            self.dms_transfer_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn mongo_db_settings(mut self, input: crate::model::MongoDbSettings) -> Self {
            self.mongo_db_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_mongo_db_settings(
            mut self,
            input: std::option::Option<crate::model::MongoDbSettings>,
        ) -> Self {
            self.mongo_db_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn kinesis_settings(mut self, input: crate::model::KinesisSettings) -> Self {
            self.kinesis_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_kinesis_settings(
            mut self,
            input: std::option::Option<crate::model::KinesisSettings>,
        ) -> Self {
            self.kinesis_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn kafka_settings(mut self, input: crate::model::KafkaSettings) -> Self {
            self.kafka_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_kafka_settings(
            mut self,
            input: std::option::Option<crate::model::KafkaSettings>,
        ) -> Self {
            self.kafka_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn elasticsearch_settings(
            mut self,
            input: crate::model::ElasticsearchSettings,
        ) -> Self {
            self.elasticsearch_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_elasticsearch_settings(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchSettings>,
        ) -> Self {
            self.elasticsearch_settings = input;
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn neptune_settings(mut self, input: crate::model::NeptuneSettings) -> Self {
            self.neptune_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_neptune_settings(
            mut self,
            input: std::option::Option<crate::model::NeptuneSettings>,
        ) -> Self {
            self.neptune_settings = input;
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn redshift_settings(mut self, input: crate::model::RedshiftSettings) -> Self {
            self.redshift_settings = Some(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn set_redshift_settings(
            mut self,
            input: std::option::Option<crate::model::RedshiftSettings>,
        ) -> Self {
            self.redshift_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn postgre_sql_settings(mut self, input: crate::model::PostgreSqlSettings) -> Self {
            self.postgre_sql_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_postgre_sql_settings(
            mut self,
            input: std::option::Option<crate::model::PostgreSqlSettings>,
        ) -> Self {
            self.postgre_sql_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection
        /// attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra
        /// connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn my_sql_settings(mut self, input: crate::model::MySqlSettings) -> Self {
            self.my_sql_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection
        /// attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra
        /// connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::MySqlSettings>,
        ) -> Self {
            self.my_sql_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection
        /// attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn oracle_settings(mut self, input: crate::model::OracleSettings) -> Self {
            self.oracle_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection
        /// attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_oracle_settings(
            mut self,
            input: std::option::Option<crate::model::OracleSettings>,
        ) -> Self {
            self.oracle_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn sybase_settings(mut self, input: crate::model::SybaseSettings) -> Self {
            self.sybase_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_sybase_settings(
            mut self,
            input: std::option::Option<crate::model::SybaseSettings>,
        ) -> Self {
            self.sybase_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn microsoft_sql_server_settings(
            mut self,
            input: crate::model::MicrosoftSqlServerSettings,
        ) -> Self {
            self.microsoft_sql_server_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_microsoft_sql_server_settings(
            mut self,
            input: std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        ) -> Self {
            self.microsoft_sql_server_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn ibm_db2_settings(mut self, input: crate::model::IbmDb2Settings) -> Self {
            self.ibm_db2_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_ibm_db2_settings(
            mut self,
            input: std::option::Option<crate::model::IbmDb2Settings>,
        ) -> Self {
            self.ibm_db2_settings = input;
            self
        }
        /// <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service
        /// </a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn doc_db_settings(mut self, input: crate::model::DocDbSettings) -> Self {
            self.doc_db_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service
        /// </a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_doc_db_settings(
            mut self,
            input: std::option::Option<crate::model::DocDbSettings>,
        ) -> Self {
            self.doc_db_settings = input;
            self
        }
        /// <p>Settings in JSON format for the Redis target endpoint.</p>
        pub fn redis_settings(mut self, input: crate::model::RedisSettings) -> Self {
            self.redis_settings = Some(input);
            self
        }
        /// <p>Settings in JSON format for the Redis target endpoint.</p>
        pub fn set_redis_settings(
            mut self,
            input: std::option::Option<crate::model::RedisSettings>,
        ) -> Self {
            self.redis_settings = input;
            self
        }
        /// <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all
        /// existing endpoint settings with the exact settings that you specify in this call. If this
        /// attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>
        /// <ul>
        /// <li>
        /// <p>It replaces any endpoint settings that already exist with new values, for settings with the
        /// same names.</p>
        /// </li>
        /// <li>
        /// <p>It creates new endpoint settings that you specify in the call, for settings with different
        /// names. </p>
        /// </li>
        /// </ul>
        /// <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}'
        /// ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If
        /// you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the
        /// same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>
        /// <p>However, suppose that you follow this with a call to <code>modify-endpoint ...
        /// --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again.
        /// Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings
        /// are replaced with the exact settings that you specify. </p>
        pub fn exact_settings(mut self, input: bool) -> Self {
            self.exact_settings = Some(input);
            self
        }
        /// <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all
        /// existing endpoint settings with the exact settings that you specify in this call. If this
        /// attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>
        /// <ul>
        /// <li>
        /// <p>It replaces any endpoint settings that already exist with new values, for settings with the
        /// same names.</p>
        /// </li>
        /// <li>
        /// <p>It creates new endpoint settings that you specify in the call, for settings with different
        /// names. </p>
        /// </li>
        /// </ul>
        /// <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}'
        /// ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If
        /// you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the
        /// same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>
        /// <p>However, suppose that you follow this with a call to <code>modify-endpoint ...
        /// --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again.
        /// Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings
        /// are replaced with the exact settings that you specify. </p>
        pub fn set_exact_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.exact_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEndpointInput`](crate::input::ModifyEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyEndpointInput {
                endpoint_arn: self.endpoint_arn,
                endpoint_identifier: self.endpoint_identifier,
                endpoint_type: self.endpoint_type,
                engine_name: self.engine_name,
                username: self.username,
                password: self.password,
                server_name: self.server_name,
                port: self.port,
                database_name: self.database_name,
                extra_connection_attributes: self.extra_connection_attributes,
                certificate_arn: self.certificate_arn,
                ssl_mode: self.ssl_mode,
                service_access_role_arn: self.service_access_role_arn,
                external_table_definition: self.external_table_definition,
                dynamo_db_settings: self.dynamo_db_settings,
                s3_settings: self.s3_settings,
                dms_transfer_settings: self.dms_transfer_settings,
                mongo_db_settings: self.mongo_db_settings,
                kinesis_settings: self.kinesis_settings,
                kafka_settings: self.kafka_settings,
                elasticsearch_settings: self.elasticsearch_settings,
                neptune_settings: self.neptune_settings,
                redshift_settings: self.redshift_settings,
                postgre_sql_settings: self.postgre_sql_settings,
                my_sql_settings: self.my_sql_settings,
                oracle_settings: self.oracle_settings,
                sybase_settings: self.sybase_settings,
                microsoft_sql_server_settings: self.microsoft_sql_server_settings,
                ibm_db2_settings: self.ibm_db2_settings,
                doc_db_settings: self.doc_db_settings,
                redis_settings: self.redis_settings,
                exact_settings: self.exact_settings,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyEndpointInputOperationOutputAlias = crate::operation::ModifyEndpoint;
#[doc(hidden)]
pub type ModifyEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyEndpointInput {
    /// Consumes the builder and constructs an Operation<[`ModifyEndpoint`](crate::operation::ModifyEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ModifyEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_modify_endpoint(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyEndpoint",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyEndpointInput`](crate::input::ModifyEndpointInput)
    pub fn builder() -> crate::input::modify_endpoint_input::Builder {
        crate::input::modify_endpoint_input::Builder::default()
    }
}

/// See [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
pub mod modify_event_subscription_input {
    /// A builder for [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the DMS event notification subscription to be modified.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the DMS event notification subscription to be modified.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p> The type of DMS resource that generates the events you want to subscribe to. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p> The type of DMS resource that generates the events you want to subscribe to. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a source type that you want to subscribe to. Use the
        /// <code>DescribeEventCategories</code> action to see a list of event categories. </p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p> A list of event categories for a source type that you want to subscribe to. Use the
        /// <code>DescribeEventCategories</code> action to see a list of event categories. </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                event_categories: self.event_categories,
                enabled: self.enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyEventSubscriptionInputOperationOutputAlias =
    crate::operation::ModifyEventSubscription;
#[doc(hidden)]
pub type ModifyEventSubscriptionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`ModifyEventSubscription`](crate::operation::ModifyEventSubscription)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyEventSubscription,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyEventSubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyEventSubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyEventSubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ModifyEventSubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_event_subscription(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyEventSubscription",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionInput`](crate::input::ModifyEventSubscriptionInput)
    pub fn builder() -> crate::input::modify_event_subscription_input::Builder {
        crate::input::modify_event_subscription_input::Builder::default()
    }
}

/// See [`ModifyReplicationInstanceInput`](crate::input::ModifyReplicationInstanceInput)
pub mod modify_replication_instance_input {
    /// A builder for [`ModifyReplicationInstanceInput`](crate::input::ModifyReplicationInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) replication_instance_class: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) allow_major_version_upgrade: std::option::Option<bool>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) replication_instance_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The amount of storage (in gigabytes) to be allocated for the replication
        /// instance.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be allocated for the replication
        /// instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Indicates whether the changes should be applied immediately or during the next
        /// maintenance window.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>Indicates whether the changes should be applied immediately or during the next
        /// maintenance window.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn replication_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_class = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter does not result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// moving this window to the current time, there must be at least 30 minutes between the
        /// current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter does not result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// moving this window to the current time, there must be at least 30 minutes between the
        /// current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>When modifying a major engine version of an instance, also set
        /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>When modifying a major engine version of an instance, also set
        /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter does not
        /// result in an outage, and the change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter must be set to <code>true</code> when specifying a value for the
        /// <code>EngineVersion</code> parameter that is a different major version than the
        /// replication instance's current version.</p>
        pub fn allow_major_version_upgrade(mut self, input: bool) -> Self {
            self.allow_major_version_upgrade = Some(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter does not
        /// result in an outage, and the change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter must be set to <code>true</code> when specifying a value for the
        /// <code>EngineVersion</code> parameter that is a different major version than the
        /// replication instance's current version.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_major_version_upgrade = input;
            self
        }
        /// <p>A value that indicates that minor version upgrades are applied automatically to the
        /// replication instance during the maintenance window. Changing this parameter doesn't result
        /// in an outage, except in the case described following. The change is asynchronously applied
        /// as soon as possible. </p>
        /// <p>An outage does result if these factors apply: </p>
        /// <ul>
        /// <li>
        /// <p>This parameter is set to <code>true</code> during the maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>A newer minor version is available. </p>
        /// </li>
        /// <li>
        /// <p>DMS has enabled automatic patching for the given engine version. </p>
        /// </li>
        /// </ul>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates that minor version upgrades are applied automatically to the
        /// replication instance during the maintenance window. Changing this parameter doesn't result
        /// in an outage, except in the case described following. The change is asynchronously applied
        /// as soon as possible. </p>
        /// <p>An outage does result if these factors apply: </p>
        /// <ul>
        /// <li>
        /// <p>This parameter is set to <code>true</code> during the maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>A newer minor version is available. </p>
        /// </li>
        /// <li>
        /// <p>DMS has enabled automatic patching for the given engine version. </p>
        /// </li>
        /// </ul>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        pub fn replication_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = Some(input.into());
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyReplicationInstanceInput`](crate::input::ModifyReplicationInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyReplicationInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyReplicationInstanceInput {
                replication_instance_arn: self.replication_instance_arn,
                allocated_storage: self.allocated_storage,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                replication_instance_class: self.replication_instance_class,
                vpc_security_group_ids: self.vpc_security_group_ids,
                preferred_maintenance_window: self.preferred_maintenance_window,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                allow_major_version_upgrade: self.allow_major_version_upgrade.unwrap_or_default(),
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                replication_instance_identifier: self.replication_instance_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyReplicationInstanceInputOperationOutputAlias =
    crate::operation::ModifyReplicationInstance;
#[doc(hidden)]
pub type ModifyReplicationInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyReplicationInstanceInput {
    /// Consumes the builder and constructs an Operation<[`ModifyReplicationInstance`](crate::operation::ModifyReplicationInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyReplicationInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyReplicationInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyReplicationInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyReplicationInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ModifyReplicationInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_replication_instance(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyReplicationInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyReplicationInstance",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyReplicationInstanceInput`](crate::input::ModifyReplicationInstanceInput)
    pub fn builder() -> crate::input::modify_replication_instance_input::Builder {
        crate::input::modify_replication_instance_input::Builder::default()
    }
}

/// See [`ModifyReplicationSubnetGroupInput`](crate::input::ModifyReplicationSubnetGroupInput)
pub mod modify_replication_subnet_group_input {
    /// A builder for [`ModifyReplicationSubnetGroupInput`](crate::input::ModifyReplicationSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_subnet_group_identifier: std::option::Option<std::string::String>,
        pub(crate) replication_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the replication instance subnet group.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = Some(input.into());
            self
        }
        /// <p>The name of the replication instance subnet group.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_identifier = input;
            self
        }
        /// <p>A description for the replication instance subnet group.</p>
        pub fn replication_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_description = Some(input.into());
            self
        }
        /// <p>A description for the replication instance subnet group.</p>
        pub fn set_replication_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>A list of subnet IDs.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyReplicationSubnetGroupInput`](crate::input::ModifyReplicationSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyReplicationSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyReplicationSubnetGroupInput {
                replication_subnet_group_identifier: self.replication_subnet_group_identifier,
                replication_subnet_group_description: self.replication_subnet_group_description,
                subnet_ids: self.subnet_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyReplicationSubnetGroupInputOperationOutputAlias =
    crate::operation::ModifyReplicationSubnetGroup;
#[doc(hidden)]
pub type ModifyReplicationSubnetGroupInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyReplicationSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`ModifyReplicationSubnetGroup`](crate::operation::ModifyReplicationSubnetGroup)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyReplicationSubnetGroup,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyReplicationSubnetGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyReplicationSubnetGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyReplicationSubnetGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ModifyReplicationSubnetGroup",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_replication_subnet_group(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyReplicationSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyReplicationSubnetGroup",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyReplicationSubnetGroupInput`](crate::input::ModifyReplicationSubnetGroupInput)
    pub fn builder() -> crate::input::modify_replication_subnet_group_input::Builder {
        crate::input::modify_replication_subnet_group_input::Builder::default()
    }
}

/// See [`ModifyReplicationTaskInput`](crate::input::ModifyReplicationTaskInput)
pub mod modify_replication_task_input {
    /// A builder for [`ModifyReplicationTaskInput`](crate::input::ModifyReplicationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) replication_task_identifier: std::option::Option<std::string::String>,
        pub(crate) migration_type: std::option::Option<crate::model::MigrationTypeValue>,
        pub(crate) table_mappings: std::option::Option<std::string::String>,
        pub(crate) replication_task_settings: std::option::Option<std::string::String>,
        pub(crate) cdc_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cdc_start_position: std::option::Option<std::string::String>,
        pub(crate) cdc_stop_position: std::option::Option<std::string::String>,
        pub(crate) task_data: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>The replication task identifier.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn replication_task_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = Some(input.into());
            self
        }
        /// <p>The replication task identifier.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_identifier = input;
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn migration_type(mut self, input: crate::model::MigrationTypeValue) -> Self {
            self.migration_type = Some(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.migration_type = input;
            self
        }
        /// <p>When using the CLI or boto3, provide the path of the JSON file that contains the
        /// table mappings. Precede the path with <code>file://</code>.  For example,
        /// <code>--table-mappings file://mappingfile.json</code>. When working with the DMS  API,
        /// provide the JSON as the parameter value.
        /// </p>
        pub fn table_mappings(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_mappings = Some(input.into());
            self
        }
        /// <p>When using the CLI or boto3, provide the path of the JSON file that contains the
        /// table mappings. Precede the path with <code>file://</code>.  For example,
        /// <code>--table-mappings file://mappingfile.json</code>. When working with the DMS  API,
        /// provide the JSON as the parameter value.
        /// </p>
        pub fn set_table_mappings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_mappings = input;
            self
        }
        /// <p>JSON file that contains settings for the task, such as task metadata settings.</p>
        pub fn replication_task_settings(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_settings = Some(input.into());
            self
        }
        /// <p>JSON file that contains settings for the task, such as task metadata settings.</p>
        pub fn set_replication_task_settings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_settings = input;
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.cdc_start_time = Some(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.cdc_start_time = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_start_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_start_position = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_stop_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_stop_position = input;
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn task_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.task_data = Some(input.into());
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_task_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.task_data = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyReplicationTaskInput`](crate::input::ModifyReplicationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ModifyReplicationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ModifyReplicationTaskInput {
                replication_task_arn: self.replication_task_arn,
                replication_task_identifier: self.replication_task_identifier,
                migration_type: self.migration_type,
                table_mappings: self.table_mappings,
                replication_task_settings: self.replication_task_settings,
                cdc_start_time: self.cdc_start_time,
                cdc_start_position: self.cdc_start_position,
                cdc_stop_position: self.cdc_stop_position,
                task_data: self.task_data,
            })
        }
    }
}
#[doc(hidden)]
pub type ModifyReplicationTaskInputOperationOutputAlias = crate::operation::ModifyReplicationTask;
#[doc(hidden)]
pub type ModifyReplicationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ModifyReplicationTaskInput {
    /// Consumes the builder and constructs an Operation<[`ModifyReplicationTask`](crate::operation::ModifyReplicationTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ModifyReplicationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ModifyReplicationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ModifyReplicationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ModifyReplicationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ModifyReplicationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_modify_replication_task(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ModifyReplicationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ModifyReplicationTask",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ModifyReplicationTaskInput`](crate::input::ModifyReplicationTaskInput)
    pub fn builder() -> crate::input::modify_replication_task_input::Builder {
        crate::input::modify_replication_task_input::Builder::default()
    }
}

/// See [`MoveReplicationTaskInput`](crate::input::MoveReplicationTaskInput)
pub mod move_replication_task_input {
    /// A builder for [`MoveReplicationTaskInput`](crate::input::MoveReplicationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) target_replication_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>The ARN of the replication instance where you want to move the task to.</p>
        pub fn target_replication_instance_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the replication instance where you want to move the task to.</p>
        pub fn set_target_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_replication_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MoveReplicationTaskInput`](crate::input::MoveReplicationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MoveReplicationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MoveReplicationTaskInput {
                replication_task_arn: self.replication_task_arn,
                target_replication_instance_arn: self.target_replication_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type MoveReplicationTaskInputOperationOutputAlias = crate::operation::MoveReplicationTask;
#[doc(hidden)]
pub type MoveReplicationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl MoveReplicationTaskInput {
    /// Consumes the builder and constructs an Operation<[`MoveReplicationTask`](crate::operation::MoveReplicationTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MoveReplicationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MoveReplicationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MoveReplicationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MoveReplicationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.MoveReplicationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_move_replication_task(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MoveReplicationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MoveReplicationTask",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MoveReplicationTaskInput`](crate::input::MoveReplicationTaskInput)
    pub fn builder() -> crate::input::move_replication_task_input::Builder {
        crate::input::move_replication_task_input::Builder::default()
    }
}

/// See [`RebootReplicationInstanceInput`](crate::input::RebootReplicationInstanceInput)
pub mod reboot_replication_instance_input {
    /// A builder for [`RebootReplicationInstanceInput`](crate::input::RebootReplicationInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) force_failover: std::option::Option<bool>,
        pub(crate) force_planned_failover: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ
        /// failover. If the instance isn't configured for Multi-AZ, then you can't specify
        /// <code>true</code>.  ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn force_failover(mut self, input: bool) -> Self {
            self.force_failover = Some(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ
        /// failover. If the instance isn't configured for Multi-AZ, then you can't specify
        /// <code>true</code>.  ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.force_failover = input;
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover
        /// where resources are released and cleaned up prior to conducting the failover.
        /// If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>.
        /// ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn force_planned_failover(mut self, input: bool) -> Self {
            self.force_planned_failover = Some(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover
        /// where resources are released and cleaned up prior to conducting the failover.
        /// If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>.
        /// ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn set_force_planned_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.force_planned_failover = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootReplicationInstanceInput`](crate::input::RebootReplicationInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RebootReplicationInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RebootReplicationInstanceInput {
                replication_instance_arn: self.replication_instance_arn,
                force_failover: self.force_failover,
                force_planned_failover: self.force_planned_failover,
            })
        }
    }
}
#[doc(hidden)]
pub type RebootReplicationInstanceInputOperationOutputAlias =
    crate::operation::RebootReplicationInstance;
#[doc(hidden)]
pub type RebootReplicationInstanceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RebootReplicationInstanceInput {
    /// Consumes the builder and constructs an Operation<[`RebootReplicationInstance`](crate::operation::RebootReplicationInstance)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RebootReplicationInstance,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RebootReplicationInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RebootReplicationInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RebootReplicationInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.RebootReplicationInstance",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_reboot_replication_instance(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RebootReplicationInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RebootReplicationInstance",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RebootReplicationInstanceInput`](crate::input::RebootReplicationInstanceInput)
    pub fn builder() -> crate::input::reboot_replication_instance_input::Builder {
        crate::input::reboot_replication_instance_input::Builder::default()
    }
}

/// See [`RefreshSchemasInput`](crate::input::RefreshSchemasInput)
pub mod refresh_schemas_input {
    /// A builder for [`RefreshSchemasInput`](crate::input::RefreshSchemasInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RefreshSchemasInput`](crate::input::RefreshSchemasInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RefreshSchemasInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RefreshSchemasInput {
                endpoint_arn: self.endpoint_arn,
                replication_instance_arn: self.replication_instance_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RefreshSchemasInputOperationOutputAlias = crate::operation::RefreshSchemas;
#[doc(hidden)]
pub type RefreshSchemasInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RefreshSchemasInput {
    /// Consumes the builder and constructs an Operation<[`RefreshSchemas`](crate::operation::RefreshSchemas)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RefreshSchemas,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RefreshSchemasInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RefreshSchemasInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RefreshSchemasInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.RefreshSchemas",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_refresh_schemas(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RefreshSchemas::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RefreshSchemas",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RefreshSchemasInput`](crate::input::RefreshSchemasInput)
    pub fn builder() -> crate::input::refresh_schemas_input::Builder {
        crate::input::refresh_schemas_input::Builder::default()
    }
}

/// See [`ReloadTablesInput`](crate::input::ReloadTablesInput)
pub mod reload_tables_input {
    /// A builder for [`ReloadTablesInput`](crate::input::ReloadTablesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) tables_to_reload:
            std::option::Option<std::vec::Vec<crate::model::TableToReload>>,
        pub(crate) reload_option: std::option::Option<crate::model::ReloadOptionValue>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// Appends an item to `tables_to_reload`.
        ///
        /// To override the contents of this collection use [`set_tables_to_reload`](Self::set_tables_to_reload).
        ///
        /// <p>The name and schema of the table to be reloaded. </p>
        pub fn tables_to_reload(mut self, input: impl Into<crate::model::TableToReload>) -> Self {
            let mut v = self.tables_to_reload.unwrap_or_default();
            v.push(input.into());
            self.tables_to_reload = Some(v);
            self
        }
        /// <p>The name and schema of the table to be reloaded. </p>
        pub fn set_tables_to_reload(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableToReload>>,
        ) -> Self {
            self.tables_to_reload = input;
            self
        }
        /// <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate
        /// it if validation is enabled. Specify <code>validate-only</code> to re-validate the table.
        /// This option applies only when validation is enabled for the task. </p>
        /// <p>Valid values: data-reload, validate-only</p>
        /// <p>Default value is data-reload.</p>
        pub fn reload_option(mut self, input: crate::model::ReloadOptionValue) -> Self {
            self.reload_option = Some(input);
            self
        }
        /// <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate
        /// it if validation is enabled. Specify <code>validate-only</code> to re-validate the table.
        /// This option applies only when validation is enabled for the task. </p>
        /// <p>Valid values: data-reload, validate-only</p>
        /// <p>Default value is data-reload.</p>
        pub fn set_reload_option(
            mut self,
            input: std::option::Option<crate::model::ReloadOptionValue>,
        ) -> Self {
            self.reload_option = input;
            self
        }
        /// Consumes the builder and constructs a [`ReloadTablesInput`](crate::input::ReloadTablesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ReloadTablesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ReloadTablesInput {
                replication_task_arn: self.replication_task_arn,
                tables_to_reload: self.tables_to_reload,
                reload_option: self.reload_option,
            })
        }
    }
}
#[doc(hidden)]
pub type ReloadTablesInputOperationOutputAlias = crate::operation::ReloadTables;
#[doc(hidden)]
pub type ReloadTablesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ReloadTablesInput {
    /// Consumes the builder and constructs an Operation<[`ReloadTables`](crate::operation::ReloadTables)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ReloadTables,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ReloadTablesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ReloadTablesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ReloadTablesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.ReloadTables",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_reload_tables(&self)
            .map_err(|err| {
            aws_smithy_http::operation::BuildError::SerializationError(err.into())
        })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ReloadTables::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ReloadTables",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ReloadTablesInput`](crate::input::ReloadTablesInput)
    pub fn builder() -> crate::input::reload_tables_input::Builder {
        crate::input::reload_tables_input::Builder::default()
    }
}

/// See [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
pub mod remove_tags_from_resource_input {
    /// A builder for [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveTagsFromResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveTagsFromResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationOutputAlias = crate::operation::RemoveTagsFromResource;
#[doc(hidden)]
pub type RemoveTagsFromResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveTagsFromResourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveTagsFromResource`](crate::operation::RemoveTagsFromResource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveTagsFromResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveTagsFromResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveTagsFromResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveTagsFromResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.RemoveTagsFromResource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_remove_tags_from_resource(
                &self,
            )
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveTagsFromResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveTagsFromResource",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceInput`](crate::input::RemoveTagsFromResourceInput)
    pub fn builder() -> crate::input::remove_tags_from_resource_input::Builder {
        crate::input::remove_tags_from_resource_input::Builder::default()
    }
}

/// See [`StartReplicationTaskInput`](crate::input::StartReplicationTaskInput)
pub mod start_replication_task_input {
    /// A builder for [`StartReplicationTaskInput`](crate::input::StartReplicationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) start_replication_task_type:
            std::option::Option<crate::model::StartReplicationTaskTypeValue>,
        pub(crate) cdc_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) cdc_start_position: std::option::Option<std::string::String>,
        pub(crate) cdc_stop_position: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>A type of replication task.</p>
        pub fn start_replication_task_type(
            mut self,
            input: crate::model::StartReplicationTaskTypeValue,
        ) -> Self {
            self.start_replication_task_type = Some(input);
            self
        }
        /// <p>A type of replication task.</p>
        pub fn set_start_replication_task_type(
            mut self,
            input: std::option::Option<crate::model::StartReplicationTaskTypeValue>,
        ) -> Self {
            self.start_replication_task_type = input;
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.cdc_start_time = Some(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.cdc_start_time = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_start_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_start_position = input;
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, input: impl Into<std::string::String>) -> Self {
            self.cdc_stop_position = Some(input.into());
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cdc_stop_position = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReplicationTaskInput`](crate::input::StartReplicationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartReplicationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartReplicationTaskInput {
                replication_task_arn: self.replication_task_arn,
                start_replication_task_type: self.start_replication_task_type,
                cdc_start_time: self.cdc_start_time,
                cdc_start_position: self.cdc_start_position,
                cdc_stop_position: self.cdc_stop_position,
            })
        }
    }
}
#[doc(hidden)]
pub type StartReplicationTaskInputOperationOutputAlias = crate::operation::StartReplicationTask;
#[doc(hidden)]
pub type StartReplicationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartReplicationTaskInput {
    /// Consumes the builder and constructs an Operation<[`StartReplicationTask`](crate::operation::StartReplicationTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartReplicationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartReplicationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartReplicationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartReplicationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.StartReplicationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_replication_task(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartReplicationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartReplicationTask",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartReplicationTaskInput`](crate::input::StartReplicationTaskInput)
    pub fn builder() -> crate::input::start_replication_task_input::Builder {
        crate::input::start_replication_task_input::Builder::default()
    }
}

/// See [`StartReplicationTaskAssessmentInput`](crate::input::StartReplicationTaskAssessmentInput)
pub mod start_replication_task_assessment_input {
    /// A builder for [`StartReplicationTaskAssessmentInput`](crate::input::StartReplicationTaskAssessmentInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReplicationTaskAssessmentInput`](crate::input::StartReplicationTaskAssessmentInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartReplicationTaskAssessmentInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartReplicationTaskAssessmentInput {
                replication_task_arn: self.replication_task_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StartReplicationTaskAssessmentInputOperationOutputAlias =
    crate::operation::StartReplicationTaskAssessment;
#[doc(hidden)]
pub type StartReplicationTaskAssessmentInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartReplicationTaskAssessmentInput {
    /// Consumes the builder and constructs an Operation<[`StartReplicationTaskAssessment`](crate::operation::StartReplicationTaskAssessment)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartReplicationTaskAssessment,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartReplicationTaskAssessmentInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartReplicationTaskAssessmentInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartReplicationTaskAssessmentInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.StartReplicationTaskAssessment",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_replication_task_assessment(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartReplicationTaskAssessment::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartReplicationTaskAssessment",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartReplicationTaskAssessmentInput`](crate::input::StartReplicationTaskAssessmentInput)
    pub fn builder() -> crate::input::start_replication_task_assessment_input::Builder {
        crate::input::start_replication_task_assessment_input::Builder::default()
    }
}

/// See [`StartReplicationTaskAssessmentRunInput`](crate::input::StartReplicationTaskAssessmentRunInput)
pub mod start_replication_task_assessment_run_input {
    /// A builder for [`StartReplicationTaskAssessmentRunInput`](crate::input::StartReplicationTaskAssessmentRunInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
        pub(crate) service_access_role_arn: std::option::Option<std::string::String>,
        pub(crate) result_location_bucket: std::option::Option<std::string::String>,
        pub(crate) result_location_folder: std::option::Option<std::string::String>,
        pub(crate) result_encryption_mode: std::option::Option<std::string::String>,
        pub(crate) result_kms_key_arn: std::option::Option<std::string::String>,
        pub(crate) assessment_run_name: std::option::Option<std::string::String>,
        pub(crate) include_only: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) exclude: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Amazon Resource Name (ARN) of the migration task associated with the premigration
        /// assessment run that you want to start.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>Amazon Resource Name (ARN) of the migration task associated with the premigration
        /// assessment run that you want to start.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_access_role_arn = Some(input.into());
            self
        }
        /// <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_access_role_arn = input;
            self
        }
        /// <p>Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn result_location_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_location_bucket = Some(input.into());
            self
        }
        /// <p>Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn set_result_location_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_location_bucket = input;
            self
        }
        /// <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn result_location_folder(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_location_folder = Some(input.into());
            self
        }
        /// <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn set_result_location_folder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_location_folder = input;
            self
        }
        /// <p>Encryption mode that you can specify to encrypt the results of this assessment run. If
        /// you don't specify this request parameter, DMS stores the assessment run results
        /// without encryption. You can specify one of the options following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"SSE_S3"</code> – The server-side encryption provided as a default by
        /// Amazon S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption.
        /// This encryption can use either a custom KMS encryption key that you specify or the
        /// default KMS encryption key that DMS provides.</p>
        /// </li>
        /// </ul>
        pub fn result_encryption_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_encryption_mode = Some(input.into());
            self
        }
        /// <p>Encryption mode that you can specify to encrypt the results of this assessment run. If
        /// you don't specify this request parameter, DMS stores the assessment run results
        /// without encryption. You can specify one of the options following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"SSE_S3"</code> – The server-side encryption provided as a default by
        /// Amazon S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption.
        /// This encryption can use either a custom KMS encryption key that you specify or the
        /// default KMS encryption key that DMS provides.</p>
        /// </li>
        /// </ul>
        pub fn set_result_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_encryption_mode = input;
            self
        }
        /// <p>ARN of a custom KMS encryption key that you specify when you set
        /// <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
        pub fn result_kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.result_kms_key_arn = Some(input.into());
            self
        }
        /// <p>ARN of a custom KMS encryption key that you specify when you set
        /// <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
        pub fn set_result_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.result_kms_key_arn = input;
            self
        }
        /// <p>Unique name to identify the assessment run.</p>
        pub fn assessment_run_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.assessment_run_name = Some(input.into());
            self
        }
        /// <p>Unique name to identify the assessment run.</p>
        pub fn set_assessment_run_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.assessment_run_name = input;
            self
        }
        /// Appends an item to `include_only`.
        ///
        /// To override the contents of this collection use [`set_include_only`](Self::set_include_only).
        ///
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// include. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for
        /// <code>Exclude</code> in the API operation. </p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn include_only(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.include_only.unwrap_or_default();
            v.push(input.into());
            self.include_only = Some(v);
            self
        }
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// include. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for
        /// <code>Exclude</code> in the API operation. </p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn set_include_only(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.include_only = input;
            self
        }
        /// Appends an item to `exclude`.
        ///
        /// To override the contents of this collection use [`set_exclude`](Self::set_exclude).
        ///
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// exclude. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>Exclude</code> if you also set a value for
        /// <code>IncludeOnly</code> in the API operation.</p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn exclude(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exclude.unwrap_or_default();
            v.push(input.into());
            self.exclude = Some(v);
            self
        }
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// exclude. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>Exclude</code> if you also set a value for
        /// <code>IncludeOnly</code> in the API operation.</p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn set_exclude(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exclude = input;
            self
        }
        /// Consumes the builder and constructs a [`StartReplicationTaskAssessmentRunInput`](crate::input::StartReplicationTaskAssessmentRunInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartReplicationTaskAssessmentRunInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartReplicationTaskAssessmentRunInput {
                replication_task_arn: self.replication_task_arn,
                service_access_role_arn: self.service_access_role_arn,
                result_location_bucket: self.result_location_bucket,
                result_location_folder: self.result_location_folder,
                result_encryption_mode: self.result_encryption_mode,
                result_kms_key_arn: self.result_kms_key_arn,
                assessment_run_name: self.assessment_run_name,
                include_only: self.include_only,
                exclude: self.exclude,
            })
        }
    }
}
#[doc(hidden)]
pub type StartReplicationTaskAssessmentRunInputOperationOutputAlias =
    crate::operation::StartReplicationTaskAssessmentRun;
#[doc(hidden)]
pub type StartReplicationTaskAssessmentRunInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartReplicationTaskAssessmentRunInput {
    /// Consumes the builder and constructs an Operation<[`StartReplicationTaskAssessmentRun`](crate::operation::StartReplicationTaskAssessmentRun)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartReplicationTaskAssessmentRun,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartReplicationTaskAssessmentRunInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartReplicationTaskAssessmentRunInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartReplicationTaskAssessmentRunInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.StartReplicationTaskAssessmentRun",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_replication_task_assessment_run(&self).map_err(|err|aws_smithy_http::operation::BuildError::SerializationError(err.into()))?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartReplicationTaskAssessmentRun::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartReplicationTaskAssessmentRun",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartReplicationTaskAssessmentRunInput`](crate::input::StartReplicationTaskAssessmentRunInput)
    pub fn builder() -> crate::input::start_replication_task_assessment_run_input::Builder {
        crate::input::start_replication_task_assessment_run_input::Builder::default()
    }
}

/// See [`StopReplicationTaskInput`](crate::input::StopReplicationTaskInput)
pub mod stop_replication_task_input {
    /// A builder for [`StopReplicationTaskInput`](crate::input::StopReplicationTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_task_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
        pub fn replication_task_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_task_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_task_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopReplicationTaskInput`](crate::input::StopReplicationTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopReplicationTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopReplicationTaskInput {
                replication_task_arn: self.replication_task_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StopReplicationTaskInputOperationOutputAlias = crate::operation::StopReplicationTask;
#[doc(hidden)]
pub type StopReplicationTaskInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopReplicationTaskInput {
    /// Consumes the builder and constructs an Operation<[`StopReplicationTask`](crate::operation::StopReplicationTask)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopReplicationTask,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopReplicationTaskInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopReplicationTaskInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopReplicationTaskInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.StopReplicationTask",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_replication_task(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopReplicationTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopReplicationTask",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopReplicationTaskInput`](crate::input::StopReplicationTaskInput)
    pub fn builder() -> crate::input::stop_replication_task_input::Builder {
        crate::input::stop_replication_task_input::Builder::default()
    }
}

/// See [`TestConnectionInput`](crate::input::TestConnectionInput)
pub mod test_connection_input {
    /// A builder for [`TestConnectionInput`](crate::input::TestConnectionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replication_instance_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.replication_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_instance_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`TestConnectionInput`](crate::input::TestConnectionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestConnectionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestConnectionInput {
                replication_instance_arn: self.replication_instance_arn,
                endpoint_arn: self.endpoint_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type TestConnectionInputOperationOutputAlias = crate::operation::TestConnection;
#[doc(hidden)]
pub type TestConnectionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestConnectionInput {
    /// Consumes the builder and constructs an Operation<[`TestConnection`](crate::operation::TestConnection)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestConnection,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestConnectionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestConnectionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestConnectionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonDMSv20160101.TestConnection",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_test_connection(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestConnection::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestConnection",
            "databasemigrationservice",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestConnectionInput`](crate::input::TestConnectionInput)
    pub fn builder() -> crate::input::test_connection_input::Builder {
        crate::input::test_connection_input::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestConnectionInput {
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TestConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestConnectionInput");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopReplicationTaskInput {
    /// <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StopReplicationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopReplicationTaskInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReplicationTaskAssessmentRunInput {
    /// <p>Amazon Resource Name (ARN) of the migration task associated with the premigration
    /// assessment run that you want to start.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>Amazon S3 bucket where you want DMS to store the results of this assessment
    /// run.</p>
    pub result_location_bucket: std::option::Option<std::string::String>,
    /// <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment
    /// run.</p>
    pub result_location_folder: std::option::Option<std::string::String>,
    /// <p>Encryption mode that you can specify to encrypt the results of this assessment run. If
    /// you don't specify this request parameter, DMS stores the assessment run results
    /// without encryption. You can specify one of the options following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>"SSE_S3"</code> – The server-side encryption provided as a default by
    /// Amazon S3.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption.
    /// This encryption can use either a custom KMS encryption key that you specify or the
    /// default KMS encryption key that DMS provides.</p>
    /// </li>
    /// </ul>
    pub result_encryption_mode: std::option::Option<std::string::String>,
    /// <p>ARN of a custom KMS encryption key that you specify when you set
    /// <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
    pub result_kms_key_arn: std::option::Option<std::string::String>,
    /// <p>Unique name to identify the assessment run.</p>
    pub assessment_run_name: std::option::Option<std::string::String>,
    /// <p>Space-separated list of names for specific individual assessments that you want to
    /// include. These names come from the default list of individual assessments that DMS
    /// supports for the associated migration task. This task is specified by
    /// <code>ReplicationTaskArn</code>.</p>
    /// <note>
    /// <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for
    /// <code>Exclude</code> in the API operation. </p>
    /// <p>To identify the names of the default individual assessments that DMS
    /// supports for the associated migration task, run the
    /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
    /// <code>ReplicationTaskArn</code> request parameter.</p>
    /// </note>
    pub include_only: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Space-separated list of names for specific individual assessments that you want to
    /// exclude. These names come from the default list of individual assessments that DMS
    /// supports for the associated migration task. This task is specified by
    /// <code>ReplicationTaskArn</code>.</p>
    /// <note>
    /// <p>You can't set a value for <code>Exclude</code> if you also set a value for
    /// <code>IncludeOnly</code> in the API operation.</p>
    /// <p>To identify the names of the default individual assessments that DMS
    /// supports for the associated migration task, run the
    /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
    /// <code>ReplicationTaskArn</code> request parameter.</p>
    /// </note>
    pub exclude: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for StartReplicationTaskAssessmentRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReplicationTaskAssessmentRunInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("result_location_bucket", &self.result_location_bucket);
        formatter.field("result_location_folder", &self.result_location_folder);
        formatter.field("result_encryption_mode", &self.result_encryption_mode);
        formatter.field("result_kms_key_arn", &self.result_kms_key_arn);
        formatter.field("assessment_run_name", &self.assessment_run_name);
        formatter.field("include_only", &self.include_only);
        formatter.field("exclude", &self.exclude);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReplicationTaskAssessmentInput {
    /// <p> The Amazon Resource Name (ARN) of the replication task. </p>
    pub replication_task_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartReplicationTaskAssessmentInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReplicationTaskAssessmentInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartReplicationTaskInput {
    /// <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>A type of replication task.</p>
    pub start_replication_task_type:
        std::option::Option<crate::model::StartReplicationTaskTypeValue>,
    /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
    /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
    pub cdc_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
    /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
    /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
    /// <p>Checkpoint Example: --cdc-start-position
    /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
    /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
    /// <note>
    /// <p>When you use this task setting with a source PostgreSQL database, a logical
    /// replication slot should already be created and associated with the source endpoint. You
    /// can verify this by setting the <code>slotName</code> extra connection attribute to the
    /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
    /// for DMS</a>.</p>
    /// </note>
    pub cdc_start_position: std::option::Option<std::string::String>,
    /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
    /// either server time or commit time.</p>
    /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
    /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    pub cdc_stop_position: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StartReplicationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartReplicationTaskInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field(
            "start_replication_task_type",
            &self.start_replication_task_type,
        );
        formatter.field("cdc_start_time", &self.cdc_start_time);
        formatter.field("cdc_start_position", &self.cdc_start_position);
        formatter.field("cdc_stop_position", &self.cdc_stop_position);
        formatter.finish()
    }
}

/// <p>Removes one or more tags from an DMS resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceInput {
    /// <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag key (name) of the tag to be removed.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for RemoveTagsFromResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReloadTablesInput {
    /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>The name and schema of the table to be reloaded. </p>
    pub tables_to_reload: std::option::Option<std::vec::Vec<crate::model::TableToReload>>,
    /// <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate
    /// it if validation is enabled. Specify <code>validate-only</code> to re-validate the table.
    /// This option applies only when validation is enabled for the task. </p>
    /// <p>Valid values: data-reload, validate-only</p>
    /// <p>Default value is data-reload.</p>
    pub reload_option: std::option::Option<crate::model::ReloadOptionValue>,
}
impl std::fmt::Debug for ReloadTablesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReloadTablesInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field("tables_to_reload", &self.tables_to_reload);
        formatter.field("reload_option", &self.reload_option);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RefreshSchemasInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RefreshSchemasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RefreshSchemasInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootReplicationInstanceInput {
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ
    /// failover. If the instance isn't configured for Multi-AZ, then you can't specify
    /// <code>true</code>.  ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
    pub force_failover: std::option::Option<bool>,
    /// <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover
    /// where resources are released and cleaned up prior to conducting the failover.
    /// If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>.
    /// ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
    pub force_planned_failover: std::option::Option<bool>,
}
impl std::fmt::Debug for RebootReplicationInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootReplicationInstanceInput");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("force_failover", &self.force_failover);
        formatter.field("force_planned_failover", &self.force_planned_failover);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MoveReplicationTaskInput {
    /// <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>The ARN of the replication instance where you want to move the task to.</p>
    pub target_replication_instance_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MoveReplicationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MoveReplicationTaskInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field(
            "target_replication_instance_arn",
            &self.target_replication_instance_arn,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyReplicationTaskInput {
    /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>The replication task identifier.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub replication_task_identifier: std::option::Option<std::string::String>,
    /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
    /// </p>
    pub migration_type: std::option::Option<crate::model::MigrationTypeValue>,
    /// <p>When using the CLI or boto3, provide the path of the JSON file that contains the
    /// table mappings. Precede the path with <code>file://</code>.  For example,
    /// <code>--table-mappings file://mappingfile.json</code>. When working with the DMS  API,
    /// provide the JSON as the parameter value.
    /// </p>
    pub table_mappings: std::option::Option<std::string::String>,
    /// <p>JSON file that contains settings for the task, such as task metadata settings.</p>
    pub replication_task_settings: std::option::Option<std::string::String>,
    /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
    /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
    pub cdc_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
    /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
    /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
    /// <p>Checkpoint Example: --cdc-start-position
    /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
    /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
    /// <note>
    /// <p>When you use this task setting with a source PostgreSQL database, a logical
    /// replication slot should already be created and associated with the source endpoint. You
    /// can verify this by setting the <code>slotName</code> extra connection attribute to the
    /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
    /// for DMS</a>.</p>
    /// </note>
    pub cdc_start_position: std::option::Option<std::string::String>,
    /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
    /// either server time or commit time.</p>
    /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
    /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    pub cdc_stop_position: std::option::Option<std::string::String>,
    /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub task_data: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ModifyReplicationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyReplicationTaskInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field(
            "replication_task_identifier",
            &self.replication_task_identifier,
        );
        formatter.field("migration_type", &self.migration_type);
        formatter.field("table_mappings", &self.table_mappings);
        formatter.field("replication_task_settings", &self.replication_task_settings);
        formatter.field("cdc_start_time", &self.cdc_start_time);
        formatter.field("cdc_start_position", &self.cdc_start_position);
        formatter.field("cdc_stop_position", &self.cdc_stop_position);
        formatter.field("task_data", &self.task_data);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyReplicationSubnetGroupInput {
    /// <p>The name of the replication instance subnet group.</p>
    pub replication_subnet_group_identifier: std::option::Option<std::string::String>,
    /// <p>A description for the replication instance subnet group.</p>
    pub replication_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>A list of subnet IDs.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ModifyReplicationSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyReplicationSubnetGroupInput");
        formatter.field(
            "replication_subnet_group_identifier",
            &self.replication_subnet_group_identifier,
        );
        formatter.field(
            "replication_subnet_group_description",
            &self.replication_subnet_group_description,
        );
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyReplicationInstanceInput {
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The amount of storage (in gigabytes) to be allocated for the replication
    /// instance.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>Indicates whether the changes should be applied immediately or during the next
    /// maintenance window.</p>
    pub apply_immediately: bool,
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub replication_instance_class: std::option::Option<std::string::String>,
    /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
    /// security group must work with the VPC containing the replication instance. </p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
    /// result in an outage. Changing this parameter does not result in an outage, except in the
    /// following situation, and the change is asynchronously applied as soon as possible. If
    /// moving this window to the current time, there must be at least 30 minutes between the
    /// current time and end of the window to ensure pending changes are applied.</p>
    /// <p>Default: Uses existing setting</p>
    /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
    /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
    /// <p>Constraints: Must be at least 30 minutes</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
    /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
    /// <code>true</code>. </p>
    pub multi_az: std::option::Option<bool>,
    /// <p>The engine version number of the replication instance.</p>
    /// <p>When modifying a major engine version of an instance, also set
    /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates that major version upgrades are allowed. Changing this parameter does not
    /// result in an outage, and the change is asynchronously applied as soon as possible.</p>
    /// <p>This parameter must be set to <code>true</code> when specifying a value for the
    /// <code>EngineVersion</code> parameter that is a different major version than the
    /// replication instance's current version.</p>
    pub allow_major_version_upgrade: bool,
    /// <p>A value that indicates that minor version upgrades are applied automatically to the
    /// replication instance during the maintenance window. Changing this parameter doesn't result
    /// in an outage, except in the case described following. The change is asynchronously applied
    /// as soon as possible. </p>
    /// <p>An outage does result if these factors apply: </p>
    /// <ul>
    /// <li>
    /// <p>This parameter is set to <code>true</code> during the maintenance window.</p>
    /// </li>
    /// <li>
    /// <p>A newer minor version is available. </p>
    /// </li>
    /// <li>
    /// <p>DMS has enabled automatic patching for the given engine version. </p>
    /// </li>
    /// </ul>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>The replication instance identifier. This parameter is stored as a lowercase
    /// string.</p>
    pub replication_instance_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ModifyReplicationInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyReplicationInstanceInput");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field(
            "replication_instance_class",
            &self.replication_instance_class,
        );
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "allow_major_version_upgrade",
            &self.allow_major_version_upgrade,
        );
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field(
            "replication_instance_identifier",
            &self.replication_instance_identifier,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEventSubscriptionInput {
    /// <p>The name of the DMS event notification subscription to be modified.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
    /// The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p> The type of DMS resource that generates the events you want to subscribe to. </p>
    /// <p>Valid values: replication-instance | replication-task</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p> A list of event categories for a source type that you want to subscribe to. Use the
    /// <code>DescribeEventCategories</code> action to see a list of event categories. </p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A Boolean value; set to <b>true</b> to activate the
    /// subscription. </p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for ModifyEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEndpointInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
    /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
    /// consecutive hyphens.</p>
    pub endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
    pub endpoint_type: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
    /// <p>The type of engine for the endpoint. Valid values, depending on the EndpointType,
    /// include
    /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
    /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>,
    /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
    /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
    /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
    /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
    pub engine_name: std::option::Option<std::string::String>,
    /// <p>The user name to be used to login to the endpoint database.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The password to be used to login to the endpoint database.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The name of the server where the endpoint database resides.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>The port used by the endpoint database.</p>
    pub port: std::option::Option<i32>,
    /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Additional attributes associated with the connection. To reset this parameter, pass the
    /// empty string ("") as an argument.</p>
    pub extra_connection_attributes: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The SSL mode used to connect to the endpoint.  The default value is <code>none</code>.</p>
    pub ssl_mode: std::option::Option<crate::model::DmsSslModeValue>,
    /// <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify
    /// the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The external table definition.</p>
    pub external_table_definition: std::option::Option<std::string::String>,
    /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
    /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
    /// Data to DynamoDB</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub dynamo_db_settings: std::option::Option<crate::model::DynamoDbSettings>,
    /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
    /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
    /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub s3_settings: std::option::Option<crate::model::S3Settings>,
    /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
    /// <p>Attributes include the following:</p>
    /// <ul>
    /// <li>
    /// <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
    /// </li>
    /// <li>
    /// <p>BucketName - The name of the S3 bucket to use.</p>
    /// </li>
    /// </ul>
    /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string
    /// ,BucketName=string</code>
    /// </p>
    /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string",
    /// "BucketName": "string"} </code>
    /// </p>
    pub dms_transfer_settings: std::option::Option<crate::model::DmsTransferSettings>,
    /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
    /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
    /// when using MongoDB as a source for Database Migration Service</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub mongo_db_settings: std::option::Option<crate::model::MongoDbSettings>,
    /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
    /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
    /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub kinesis_settings: std::option::Option<crate::model::KinesisSettings>,
    /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
    /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
    /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub kafka_settings: std::option::Option<crate::model::KafkaSettings>,
    /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
    /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
    /// the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub elasticsearch_settings: std::option::Option<crate::model::ElasticsearchSettings>,
    /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information
    /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
    /// in the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub neptune_settings: std::option::Option<crate::model::NeptuneSettings>,
    /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
    pub redshift_settings: std::option::Option<crate::model::RedshiftSettings>,
    /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
    /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
    /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
    /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub postgre_sql_settings: std::option::Option<crate::model::PostgreSqlSettings>,
    /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
    /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection
    /// attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra
    /// connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub my_sql_settings: std::option::Option<crate::model::MySqlSettings>,
    /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
    /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection
    /// attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
    /// Extra connection attributes when using Oracle as a target for DMS</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub oracle_settings: std::option::Option<crate::model::OracleSettings>,
    /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
    /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
    /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
    /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
    /// User Guide.</i>
    /// </p>
    pub sybase_settings: std::option::Option<crate::model::SybaseSettings>,
    /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
    /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
    /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
    /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub microsoft_sql_server_settings:
        std::option::Option<crate::model::MicrosoftSqlServerSettings>,
    /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
    /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
    /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
    /// User Guide.</i>
    /// </p>
    pub ibm_db2_settings: std::option::Option<crate::model::IbmDb2Settings>,
    /// <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the
    /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service
    /// </a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub doc_db_settings: std::option::Option<crate::model::DocDbSettings>,
    /// <p>Settings in JSON format for the Redis target endpoint.</p>
    pub redis_settings: std::option::Option<crate::model::RedisSettings>,
    /// <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all
    /// existing endpoint settings with the exact settings that you specify in this call. If this
    /// attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>
    /// <ul>
    /// <li>
    /// <p>It replaces any endpoint settings that already exist with new values, for settings with the
    /// same names.</p>
    /// </li>
    /// <li>
    /// <p>It creates new endpoint settings that you specify in the call, for settings with different
    /// names. </p>
    /// </li>
    /// </ul>
    /// <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}'
    /// ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If
    /// you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the
    /// same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>
    /// <p>However, suppose that you follow this with a call to <code>modify-endpoint ...
    /// --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again.
    /// Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings
    /// are replaced with the exact settings that you specify. </p>
    pub exact_settings: std::option::Option<bool>,
}
impl std::fmt::Debug for ModifyEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEndpointInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("endpoint_identifier", &self.endpoint_identifier);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("engine_name", &self.engine_name);
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("server_name", &self.server_name);
        formatter.field("port", &self.port);
        formatter.field("database_name", &self.database_name);
        formatter.field(
            "extra_connection_attributes",
            &self.extra_connection_attributes,
        );
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("ssl_mode", &self.ssl_mode);
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("external_table_definition", &self.external_table_definition);
        formatter.field("dynamo_db_settings", &self.dynamo_db_settings);
        formatter.field("s3_settings", &self.s3_settings);
        formatter.field("dms_transfer_settings", &self.dms_transfer_settings);
        formatter.field("mongo_db_settings", &self.mongo_db_settings);
        formatter.field("kinesis_settings", &self.kinesis_settings);
        formatter.field("kafka_settings", &self.kafka_settings);
        formatter.field("elasticsearch_settings", &self.elasticsearch_settings);
        formatter.field("neptune_settings", &self.neptune_settings);
        formatter.field("redshift_settings", &self.redshift_settings);
        formatter.field("postgre_sql_settings", &self.postgre_sql_settings);
        formatter.field("my_sql_settings", &self.my_sql_settings);
        formatter.field("oracle_settings", &self.oracle_settings);
        formatter.field("sybase_settings", &self.sybase_settings);
        formatter.field(
            "microsoft_sql_server_settings",
            &self.microsoft_sql_server_settings,
        );
        formatter.field("ibm_db2_settings", &self.ibm_db2_settings);
        formatter.field("doc_db_settings", &self.doc_db_settings);
        formatter.field("redis_settings", &self.redis_settings);
        formatter.field("exact_settings", &self.exact_settings);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to
    /// list tags for. This returns a list of keys (names of tags) created for the resource and
    /// their associated tag values.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This
    /// returns a list of keys (tag names) and their associated tag values. It also returns each
    /// tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which
    /// each listed tag is created. </p>
    pub resource_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("resource_arn_list", &self.resource_arn_list);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportCertificateInput {
    /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
    /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
    /// contain two consecutive hyphens.</p>
    pub certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
    pub certificate_pem: std::option::Option<std::string::String>,
    /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file
    /// using the <code>fileb://</code> prefix. You can't provide the certificate inline.
    /// </p>
    pub certificate_wallet: std::option::Option<aws_smithy_types::Blob>,
    /// <p>The tags associated with the certificate.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for ImportCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportCertificateInput");
        formatter.field("certificate_identifier", &self.certificate_identifier);
        formatter.field("certificate_pem", &"*** Sensitive Data Redacted ***");
        formatter.field("certificate_wallet", &self.certificate_wallet);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableStatisticsInput {
    /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 500.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Filters applied to table statistics.</p>
    /// <p>Valid filter names: schema-name | table-name | table-state</p>
    /// <p>A combination of filters creates an AND condition where each record matches all
    /// specified filters.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl std::fmt::Debug for DescribeTableStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableStatisticsInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSchemasInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeSchemasInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSchemasInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationTasksInput {
    /// <p>Filters applied to replication tasks.</p>
    /// <p>Valid filter names: replication-task-arn | replication-task-id | migration-type |
    /// endpoint-arn | replication-instance-arn</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>An option to set to avoid returning information about settings. Use this to reduce
    /// overhead when setting information is too large. To use this option, choose
    /// <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
    pub without_settings: std::option::Option<bool>,
}
impl std::fmt::Debug for DescribeReplicationTasksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationTasksInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.field("without_settings", &self.without_settings);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationTaskIndividualAssessmentsInput {
    /// <p>Filters applied to the individual assessments described in the form of key-value
    /// pairs.</p>
    /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>,
    /// <code>replication-task-arn</code>, <code>status</code>
    /// </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
    /// the response so that the remaining results can be retrieved.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeReplicationTaskIndividualAssessmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationTaskIndividualAssessmentsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationTaskAssessmentRunsInput {
    /// <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>
    /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>,
    /// <code>replication-instance-arn</code>, <code>status</code>
    /// </p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>The maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
    /// the response so that the remaining results can be retrieved.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeReplicationTaskAssessmentRunsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationTaskAssessmentRunsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationTaskAssessmentResultsInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input
    /// parameter is specified, the API returns only one result and ignore the values of the
    /// <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeReplicationTaskAssessmentResultsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationTaskAssessmentResultsInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationSubnetGroupsInput {
    /// <p>Filters applied to replication subnet groups.</p>
    /// <p>Valid filter names: replication-subnet-group-id</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeReplicationSubnetGroupsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationSubnetGroupsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationInstanceTaskLogsInput {
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeReplicationInstanceTaskLogsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationInstanceTaskLogsInput");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReplicationInstancesInput {
    /// <p>Filters applied to replication instances.</p>
    /// <p>Valid filter names: replication-instance-arn | replication-instance-id |
    /// replication-instance-class | engine-version</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeReplicationInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReplicationInstancesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeRefreshSchemasStatusInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeRefreshSchemasStatusInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeRefreshSchemasStatusInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePendingMaintenanceActionsInput {
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p></p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
}
impl std::fmt::Debug for DescribePendingMaintenanceActionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePendingMaintenanceActionsInput");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("filters", &self.filters);
        formatter.field("marker", &self.marker);
        formatter.field("max_records", &self.max_records);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrderableReplicationInstancesInput {
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeOrderableReplicationInstancesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrderableReplicationInstancesInput");
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSubscriptionsInput {
    /// <p>The name of the DMS event subscription to be described.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p>Filters applied to event subscriptions.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEventSubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSubscriptionsInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsInput {
    /// <p> The identifier of an event source.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>The type of DMS resource that generates events.</p>
    /// <p>Valid values: replication-instance | replication-task</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>The start time for the events to be listed.</p>
    pub start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The end time for the events to be listed.</p>
    pub end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The duration of the events to be listed.</p>
    pub duration: std::option::Option<i32>,
    /// <p>A list of event categories for the source type that you've chosen.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Filters applied to events.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEventsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsInput");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("duration", &self.duration);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventCategoriesInput {
    /// <p> The type of DMS resource that generates events. </p>
    /// <p>Valid values: replication-instance | replication-task</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>Filters applied to the event categories.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
}
impl std::fmt::Debug for DescribeEventCategoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventCategoriesInput");
        formatter.field("source_type", &self.source_type);
        formatter.field("filters", &self.filters);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointTypesInput {
    /// <p>Filters applied to the endpoint types.</p>
    /// <p>Valid filter names: engine-name | endpoint-type</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEndpointTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointTypesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointSettingsInput {
    /// <p>The databse engine used for your source or target endpoint.</p>
    pub engine_name: std::option::Option<std::string::String>,
    /// <p>The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response
    /// so that the remaining results can be retrieved.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>An optional pagination token provided by a previous request. If this parameter is specified,
    /// the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEndpointSettingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointSettingsInput");
        formatter.field("engine_name", &self.engine_name);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointsInput {
    /// <p>Filters applied to the endpoints.</p>
    /// <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeEndpointsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeConnectionsInput {
    /// <p>The filters applied to the connection.</p>
    /// <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 100</p>
    /// <p>Constraints: Minimum 20, maximum 100.</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeConnectionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeConnectionsInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificatesInput {
    /// <p>Filters applied to the certificates described in the form of key-value pairs.</p>
    pub filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p> The maximum number of records to include in the response. If more records exist than
    /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
    /// in the response so that the remaining results can be retrieved. </p>
    /// <p>Default: 10</p>
    pub max_records: std::option::Option<i32>,
    /// <p> An optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeCertificatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificatesInput");
        formatter.field("filters", &self.filters);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeApplicableIndividualAssessmentsInput {
    /// <p>Amazon Resource Name (ARN) of a migration task on which you want to base
    /// the default list of individual assessments.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
    /// <p>ARN of a replication instance on which you want to base the default list of individual
    /// assessments.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>Name of a database engine that the specified replication instance supports as a source.</p>
    pub source_engine_name: std::option::Option<std::string::String>,
    /// <p>Name of a database engine that the specified replication instance supports as a target.</p>
    pub target_engine_name: std::option::Option<std::string::String>,
    /// <p>Name of the migration type that each provided individual assessment must support.</p>
    pub migration_type: std::option::Option<crate::model::MigrationTypeValue>,
    /// <p>Maximum number of records to include in the response. If more records exist than the
    /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
    /// the response so that the remaining results can be retrieved.</p>
    pub max_records: std::option::Option<i32>,
    /// <p>Optional pagination token provided by a previous request. If this parameter is
    /// specified, the response includes only records beyond the marker, up to the value specified
    /// by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DescribeApplicableIndividualAssessmentsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeApplicableIndividualAssessmentsInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("source_engine_name", &self.source_engine_name);
        formatter.field("target_engine_name", &self.target_engine_name);
        formatter.field("migration_type", &self.migration_type);
        formatter.field("max_records", &self.max_records);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesInput {}
impl std::fmt::Debug for DescribeAccountAttributesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesInput");
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationTaskAssessmentRunInput {
    /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
    pub replication_task_assessment_run_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteReplicationTaskAssessmentRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationTaskAssessmentRunInput");
        formatter.field(
            "replication_task_assessment_run_arn",
            &self.replication_task_assessment_run_arn,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationTaskInput {
    /// <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
    pub replication_task_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteReplicationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationTaskInput");
        formatter.field("replication_task_arn", &self.replication_task_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationSubnetGroupInput {
    /// <p>The subnet group name of the replication instance.</p>
    pub replication_subnet_group_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteReplicationSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationSubnetGroupInput");
        formatter.field(
            "replication_subnet_group_identifier",
            &self.replication_subnet_group_identifier,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteReplicationInstanceInput {
    /// <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteReplicationInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteReplicationInstanceInput");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSubscriptionInput {
    /// <p>The name of the DMS event notification subscription to be deleted.</p>
    pub subscription_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEndpointInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEndpointInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteConnectionInput {
    /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
    pub endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteConnectionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteConnectionInput");
        formatter.field("endpoint_arn", &self.endpoint_arn);
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCertificateInput {
    /// <p>The Amazon Resource Name (ARN) of the deleted certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteCertificateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCertificateInput");
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationTaskInput {
    /// <p>An identifier for the replication task.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    pub replication_task_identifier: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
    pub source_endpoint_arn: std::option::Option<std::string::String>,
    /// <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
    pub target_endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of a replication instance.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
    /// </p>
    pub migration_type: std::option::Option<crate::model::MigrationTypeValue>,
    /// <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table
    /// Mapping to Specify Task Settings</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub table_mappings: std::option::Option<std::string::String>,
    /// <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task
    /// Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub replication_task_settings: std::option::Option<std::string::String>,
    /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
    /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
    pub cdc_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
    /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
    /// Specifying both values results in an error.</p>
    /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
    /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
    /// <p>Checkpoint Example: --cdc-start-position
    /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
    /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
    /// <note>
    /// <p>When you use this task setting with a source PostgreSQL database, a logical
    /// replication slot should already be created and associated with the source endpoint. You
    /// can verify this by setting the <code>slotName</code> extra connection attribute to the
    /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
    /// for DMS</a>.</p>
    /// </note>
    pub cdc_start_position: std::option::Option<std::string::String>,
    /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
    /// either server time or commit time.</p>
    /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
    /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
    pub cdc_stop_position: std::option::Option<std::string::String>,
    /// <p>One or more tags to be assigned to the replication task.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub task_data: std::option::Option<std::string::String>,
    /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
    /// response parameter that is returned in the created <code>Endpoint</code> object. The value
    /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
    /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
    /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
    /// value might result in the <code>EndpointArn</code> value
    /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
    /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
    /// value for the end of <code>EndpointArn</code>.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateReplicationTaskInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationTaskInput");
        formatter.field(
            "replication_task_identifier",
            &self.replication_task_identifier,
        );
        formatter.field("source_endpoint_arn", &self.source_endpoint_arn);
        formatter.field("target_endpoint_arn", &self.target_endpoint_arn);
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("migration_type", &self.migration_type);
        formatter.field("table_mappings", &self.table_mappings);
        formatter.field("replication_task_settings", &self.replication_task_settings);
        formatter.field("cdc_start_time", &self.cdc_start_time);
        formatter.field("cdc_start_position", &self.cdc_start_position);
        formatter.field("cdc_stop_position", &self.cdc_stop_position);
        formatter.field("tags", &self.tags);
        formatter.field("task_data", &self.task_data);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationSubnetGroupInput {
    /// <p>The name for the replication subnet group. This value is stored as a lowercase
    /// string.</p>
    /// <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces,
    /// underscores, or hyphens. Must not be "default".</p>
    /// <p>Example: <code>mySubnetgroup</code>
    /// </p>
    pub replication_subnet_group_identifier: std::option::Option<std::string::String>,
    /// <p>The description for the subnet group.</p>
    pub replication_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>One or more subnet IDs to be assigned to the subnet group.</p>
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more tags to be assigned to the subnet group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateReplicationSubnetGroupInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationSubnetGroupInput");
        formatter.field(
            "replication_subnet_group_identifier",
            &self.replication_subnet_group_identifier,
        );
        formatter.field(
            "replication_subnet_group_description",
            &self.replication_subnet_group_description,
        );
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateReplicationInstanceInput {
    /// <p>The replication instance identifier. This parameter is stored as a lowercase
    /// string.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter.</p>
    /// </li>
    /// <li>
    /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
    /// </li>
    /// </ul>
    /// <p>Example: <code>myrepinstance</code>
    /// </p>
    pub replication_instance_identifier: std::option::Option<std::string::String>,
    /// <p>The amount of storage (in gigabytes) to be initially allocated for the replication
    /// instance.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>The compute and memory capacity of the replication instance as defined for the specified
    /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
    /// <p>For more information on the settings and capacities for the available replication instance classes, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
    /// Selecting the right DMS replication instance for your migration</a>.
    /// </p>
    pub replication_instance_class: std::option::Option<std::string::String>,
    /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
    /// security group must work with the VPC containing the replication instance. </p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Availability Zone where the replication instance will be created. The default
    /// value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for
    /// example: <code>us-east-1d</code>
    /// </p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>A subnet group to associate with the replication instance.</p>
    pub replication_subnet_group_identifier: std::option::Option<std::string::String>,
    /// <p>The weekly time range during which system maintenance can occur, in Universal
    /// Coordinated Time (UTC).</p>
    /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
    /// </p>
    /// <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region,
    /// occurring on a random day of the week.</p>
    /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
    /// <p>Constraints: Minimum 30-minute window.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
    /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
    /// <code>true</code>. </p>
    pub multi_az: std::option::Option<bool>,
    /// <p>The engine version number of the replication instance.</p>
    /// <p>If an engine version number is not specified when a replication
    /// instance is created, the default is the latest engine version available.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether minor engine upgrades are applied automatically to the
    /// replication instance during the maintenance window. This parameter defaults to
    /// <code>true</code>.</p>
    /// <p>Default: <code>true</code>
    /// </p>
    pub auto_minor_version_upgrade: std::option::Option<bool>,
    /// <p>One or more tags to be assigned to the replication instance.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>An KMS key identifier that is used to encrypt the data on the replication
    /// instance.</p>
    /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key.</p>
    /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
    /// different default encryption key for each Amazon Web Services Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p> Specifies the accessibility options for the replication instance. A value of
    /// <code>true</code> represents an instance with a public IP address. A value of
    /// <code>false</code> represents an instance with a private IP address. The default value
    /// is <code>true</code>. </p>
    pub publicly_accessible: std::option::Option<bool>,
    /// <p>A list of custom DNS name servers supported for the replication instance to access your
    /// on-premise source or target database. This list overrides the default name servers
    /// supported by the replication instance. You can specify a comma-separated list of internet
    /// addresses for up to four on-premise DNS name servers. For example:
    /// <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
    /// </p>
    pub dns_name_servers: std::option::Option<std::string::String>,
    /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
    /// response parameter that is returned in the created <code>Endpoint</code> object. The value
    /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
    /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
    /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
    /// value might result in the <code>EndpointArn</code> value
    /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
    /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
    /// value for the end of <code>EndpointArn</code>.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateReplicationInstanceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateReplicationInstanceInput");
        formatter.field(
            "replication_instance_identifier",
            &self.replication_instance_identifier,
        );
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field(
            "replication_instance_class",
            &self.replication_instance_class,
        );
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field(
            "replication_subnet_group_identifier",
            &self.replication_subnet_group_identifier,
        );
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("dns_name_servers", &self.dns_name_servers);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSubscriptionInput {
    /// <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
    pub subscription_name: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
    /// The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p> The type of DMS resource that generates the events. For example, if you want to be
    /// notified of events generated by a replication instance, you set this parameter to
    /// <code>replication-instance</code>. If this value isn't specified, all events are
    /// returned. </p>
    /// <p>Valid values: <code>replication-instance</code> | <code>replication-task</code>
    /// </p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>A list of event categories for a source type that you want to subscribe to. For more
    /// information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
    /// Notifications</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of identifiers for which DMS provides notification events.</p>
    /// <p>If you don't specify a value, notifications are provided for all sources.</p>
    /// <p>If you specify multiple values, they must be of the same type. For example, if you
    /// specify a database instance ID, then all of the other values must be database instance
    /// IDs.</p>
    pub source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to
    /// <code>false</code> to create the subscription but not activate it. </p>
    pub enabled: std::option::Option<bool>,
    /// <p>One or more tags to be assigned to the event subscription.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for CreateEventSubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSubscriptionInput");
        formatter.field("subscription_name", &self.subscription_name);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("source_ids", &self.source_ids);
        formatter.field("enabled", &self.enabled);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEndpointInput {
    /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
    /// only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two
    /// consecutive hyphens.</p>
    pub endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
    pub endpoint_type: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
    /// <p>The type of engine for the endpoint. Valid values, depending on the
    /// <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>,
    /// <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
    /// <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
    /// <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
    /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>,
    /// <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
    pub engine_name: std::option::Option<std::string::String>,
    /// <p>The user name to be used to log in to the endpoint database.</p>
    pub username: std::option::Option<std::string::String>,
    /// <p>The password to be used to log in to the endpoint database.</p>
    pub password: std::option::Option<std::string::String>,
    /// <p>The name of the server where the endpoint database resides.</p>
    pub server_name: std::option::Option<std::string::String>,
    /// <p>The port used by the endpoint database.</p>
    pub port: std::option::Option<i32>,
    /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Additional attributes associated with the connection. Each attribute is specified as a
    /// name-value pair associated by an equal sign (=). Multiple attributes are separated by a
    /// semicolon (;) with no additional white space. For information on the attributes available
    /// for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with
    /// DMS Endpoints</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub extra_connection_attributes: std::option::Option<std::string::String>,
    /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
    /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
    /// DMS uses your default encryption key.</p>
    /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
    /// different default encryption key for each Amazon Web Services Region.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>One or more tags to be assigned to the endpoint.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code>
    /// </p>
    pub ssl_mode: std::option::Option<crate::model::DmsSslModeValue>,
    /// <p> The Amazon Resource Name (ARN) for the service access role that you want to use to
    /// create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
    pub service_access_role_arn: std::option::Option<std::string::String>,
    /// <p>The external table definition. </p>
    pub external_table_definition: std::option::Option<std::string::String>,
    /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
    /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
    /// Data to DynamoDB</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub dynamo_db_settings: std::option::Option<crate::model::DynamoDbSettings>,
    /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
    /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
    /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub s3_settings: std::option::Option<crate::model::S3Settings>,
    /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
    /// <p>Possible settings include the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role.
    /// The role must allow the <code>iam:PassRole</code> action.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BucketName</code> - The name of the S3 bucket to use.</p>
    /// </li>
    /// </ul>
    /// <p>Shorthand syntax for these settings is as follows:
    /// <code>ServiceAccessRoleArn=string,BucketName=string</code>
    /// </p>
    /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn":
    /// "string", "BucketName": "string", } </code>
    /// </p>
    pub dms_transfer_settings: std::option::Option<crate::model::DmsTransferSettings>,
    /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
    /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
    /// when using MongoDB as a source for Database Migration Service</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub mongo_db_settings: std::option::Option<crate::model::MongoDbSettings>,
    /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
    /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
    /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub kinesis_settings: std::option::Option<crate::model::KinesisSettings>,
    /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
    /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
    /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    pub kafka_settings: std::option::Option<crate::model::KafkaSettings>,
    /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
    /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
    /// the <i>Database Migration Service User Guide</i>.</p>
    pub elasticsearch_settings: std::option::Option<crate::model::ElasticsearchSettings>,
    /// <p>Settings in JSON format for the target Amazon Neptune endpoint.
    /// For more information
    /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
    /// in the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub neptune_settings: std::option::Option<crate::model::NeptuneSettings>,
    /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
    pub redshift_settings: std::option::Option<crate::model::RedshiftSettings>,
    /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
    /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
    /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
    /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub postgre_sql_settings: std::option::Option<crate::model::PostgreSqlSettings>,
    /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
    /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes
    /// when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in
    /// the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub my_sql_settings: std::option::Option<crate::model::MySqlSettings>,
    /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
    /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes
    /// when using Oracle as a source for DMS</a> and
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
    /// Extra connection attributes when using Oracle as a target for DMS</a>
    /// in the <i>Database Migration Service User Guide.</i>
    /// </p>
    pub oracle_settings: std::option::Option<crate::model::OracleSettings>,
    /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
    /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
    /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
    /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
    /// User Guide.</i>
    /// </p>
    pub sybase_settings: std::option::Option<crate::model::SybaseSettings>,
    /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
    /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
    /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
    /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    pub microsoft_sql_server_settings:
        std::option::Option<crate::model::MicrosoftSqlServerSettings>,
    /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
    /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
    /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
    /// User Guide.</i>
    /// </p>
    pub ibm_db2_settings: std::option::Option<crate::model::IbmDb2Settings>,
    /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
    /// response parameter that is returned in the created <code>Endpoint</code> object. The value
    /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
    /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
    /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
    /// value might result in the <code>EndpointArn</code> value
    /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
    /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
    /// value for the end of <code>EndpointArn</code>.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>Provides information that defines a DocumentDB endpoint.</p>
    pub doc_db_settings: std::option::Option<crate::model::DocDbSettings>,
    /// <p>Settings in JSON format for the target Redis endpoint.</p>
    pub redis_settings: std::option::Option<crate::model::RedisSettings>,
}
impl std::fmt::Debug for CreateEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEndpointInput");
        formatter.field("endpoint_identifier", &self.endpoint_identifier);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("engine_name", &self.engine_name);
        formatter.field("username", &self.username);
        formatter.field("password", &"*** Sensitive Data Redacted ***");
        formatter.field("server_name", &self.server_name);
        formatter.field("port", &self.port);
        formatter.field("database_name", &self.database_name);
        formatter.field(
            "extra_connection_attributes",
            &self.extra_connection_attributes,
        );
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("ssl_mode", &self.ssl_mode);
        formatter.field("service_access_role_arn", &self.service_access_role_arn);
        formatter.field("external_table_definition", &self.external_table_definition);
        formatter.field("dynamo_db_settings", &self.dynamo_db_settings);
        formatter.field("s3_settings", &self.s3_settings);
        formatter.field("dms_transfer_settings", &self.dms_transfer_settings);
        formatter.field("mongo_db_settings", &self.mongo_db_settings);
        formatter.field("kinesis_settings", &self.kinesis_settings);
        formatter.field("kafka_settings", &self.kafka_settings);
        formatter.field("elasticsearch_settings", &self.elasticsearch_settings);
        formatter.field("neptune_settings", &self.neptune_settings);
        formatter.field("redshift_settings", &self.redshift_settings);
        formatter.field("postgre_sql_settings", &self.postgre_sql_settings);
        formatter.field("my_sql_settings", &self.my_sql_settings);
        formatter.field("oracle_settings", &self.oracle_settings);
        formatter.field("sybase_settings", &self.sybase_settings);
        formatter.field(
            "microsoft_sql_server_settings",
            &self.microsoft_sql_server_settings,
        );
        formatter.field("ibm_db2_settings", &self.ibm_db2_settings);
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field("doc_db_settings", &self.doc_db_settings);
        formatter.field("redis_settings", &self.redis_settings);
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelReplicationTaskAssessmentRunInput {
    /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
    pub replication_task_assessment_run_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CancelReplicationTaskAssessmentRunInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelReplicationTaskAssessmentRunInput");
        formatter.field(
            "replication_task_assessment_run_arn",
            &self.replication_task_assessment_run_arn,
        );
        formatter.finish()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyPendingMaintenanceActionInput {
    /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
    /// action applies to.</p>
    pub replication_instance_arn: std::option::Option<std::string::String>,
    /// <p>The pending maintenance action to apply to this resource.</p>
    /// <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code>
    /// </p>
    pub apply_action: std::option::Option<std::string::String>,
    /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an
    /// opt-in request of type <code>immediate</code>.</p>
    /// <p>Valid values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>immediate</code> - Apply the maintenance action immediately.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>next-maintenance</code> - Apply the maintenance action during the next
    /// maintenance window for the resource.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
    /// requests.</p>
    /// </li>
    /// </ul>
    pub opt_in_type: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ApplyPendingMaintenanceActionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyPendingMaintenanceActionInput");
        formatter.field("replication_instance_arn", &self.replication_instance_arn);
        formatter.field("apply_action", &self.apply_action);
        formatter.field("opt_in_type", &self.opt_in_type);
        formatter.finish()
    }
}

/// <p>Associates a set of tags with an DMS resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceInput {
    /// <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>
    /// <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>One or more tags to be assigned to the resource.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl std::fmt::Debug for AddTagsToResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
