// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonDMSv20160101`.
///
/// This client allows ergonomic access to a `AmazonDMSv20160101`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddTagsToResource` operation.
    ///
    /// See [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) for more information about the
    /// operation and its arguments.
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource<C, M, R> {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ApplyPendingMaintenanceAction` operation.
    ///
    /// See [`ApplyPendingMaintenanceAction`](crate::client::fluent_builders::ApplyPendingMaintenanceAction) for more information about the
    /// operation and its arguments.
    pub fn apply_pending_maintenance_action(
        &self,
    ) -> fluent_builders::ApplyPendingMaintenanceAction<C, M, R> {
        fluent_builders::ApplyPendingMaintenanceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelReplicationTaskAssessmentRun` operation.
    ///
    /// See [`CancelReplicationTaskAssessmentRun`](crate::client::fluent_builders::CancelReplicationTaskAssessmentRun) for more information about the
    /// operation and its arguments.
    pub fn cancel_replication_task_assessment_run(
        &self,
    ) -> fluent_builders::CancelReplicationTaskAssessmentRun<C, M, R> {
        fluent_builders::CancelReplicationTaskAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEndpoint` operation.
    ///
    /// See [`CreateEndpoint`](crate::client::fluent_builders::CreateEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_endpoint(&self) -> fluent_builders::CreateEndpoint<C, M, R> {
        fluent_builders::CreateEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventSubscription` operation.
    ///
    /// See [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription<C, M, R> {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReplicationInstance` operation.
    ///
    /// See [`CreateReplicationInstance`](crate::client::fluent_builders::CreateReplicationInstance) for more information about the
    /// operation and its arguments.
    pub fn create_replication_instance(
        &self,
    ) -> fluent_builders::CreateReplicationInstance<C, M, R> {
        fluent_builders::CreateReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReplicationSubnetGroup` operation.
    ///
    /// See [`CreateReplicationSubnetGroup`](crate::client::fluent_builders::CreateReplicationSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_replication_subnet_group(
        &self,
    ) -> fluent_builders::CreateReplicationSubnetGroup<C, M, R> {
        fluent_builders::CreateReplicationSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateReplicationTask` operation.
    ///
    /// See [`CreateReplicationTask`](crate::client::fluent_builders::CreateReplicationTask) for more information about the
    /// operation and its arguments.
    pub fn create_replication_task(&self) -> fluent_builders::CreateReplicationTask<C, M, R> {
        fluent_builders::CreateReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCertificate` operation.
    ///
    /// See [`DeleteCertificate`](crate::client::fluent_builders::DeleteCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_certificate(&self) -> fluent_builders::DeleteCertificate<C, M, R> {
        fluent_builders::DeleteCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteConnection` operation.
    ///
    /// See [`DeleteConnection`](crate::client::fluent_builders::DeleteConnection) for more information about the
    /// operation and its arguments.
    pub fn delete_connection(&self) -> fluent_builders::DeleteConnection<C, M, R> {
        fluent_builders::DeleteConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEndpoint` operation.
    ///
    /// See [`DeleteEndpoint`](crate::client::fluent_builders::DeleteEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_endpoint(&self) -> fluent_builders::DeleteEndpoint<C, M, R> {
        fluent_builders::DeleteEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventSubscription` operation.
    ///
    /// See [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription<C, M, R> {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationInstance` operation.
    ///
    /// See [`DeleteReplicationInstance`](crate::client::fluent_builders::DeleteReplicationInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_instance(
        &self,
    ) -> fluent_builders::DeleteReplicationInstance<C, M, R> {
        fluent_builders::DeleteReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationSubnetGroup` operation.
    ///
    /// See [`DeleteReplicationSubnetGroup`](crate::client::fluent_builders::DeleteReplicationSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_subnet_group(
        &self,
    ) -> fluent_builders::DeleteReplicationSubnetGroup<C, M, R> {
        fluent_builders::DeleteReplicationSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationTask` operation.
    ///
    /// See [`DeleteReplicationTask`](crate::client::fluent_builders::DeleteReplicationTask) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_task(&self) -> fluent_builders::DeleteReplicationTask<C, M, R> {
        fluent_builders::DeleteReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteReplicationTaskAssessmentRun` operation.
    ///
    /// See [`DeleteReplicationTaskAssessmentRun`](crate::client::fluent_builders::DeleteReplicationTaskAssessmentRun) for more information about the
    /// operation and its arguments.
    pub fn delete_replication_task_assessment_run(
        &self,
    ) -> fluent_builders::DeleteReplicationTaskAssessmentRun<C, M, R> {
        fluent_builders::DeleteReplicationTaskAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAttributes` operation.
    ///
    /// See [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_account_attributes(
        &self,
    ) -> fluent_builders::DescribeAccountAttributes<C, M, R> {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeApplicableIndividualAssessments` operation.
    ///
    /// See [`DescribeApplicableIndividualAssessments`](crate::client::fluent_builders::DescribeApplicableIndividualAssessments) for more information about the
    /// operation and its arguments.
    pub fn describe_applicable_individual_assessments(
        &self,
    ) -> fluent_builders::DescribeApplicableIndividualAssessments<C, M, R> {
        fluent_builders::DescribeApplicableIndividualAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeCertificates` operation.
    ///
    /// See [`DescribeCertificates`](crate::client::fluent_builders::DescribeCertificates) for more information about the
    /// operation and its arguments.
    pub fn describe_certificates(&self) -> fluent_builders::DescribeCertificates<C, M, R> {
        fluent_builders::DescribeCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeConnections` operation.
    ///
    /// See [`DescribeConnections`](crate::client::fluent_builders::DescribeConnections) for more information about the
    /// operation and its arguments.
    pub fn describe_connections(&self) -> fluent_builders::DescribeConnections<C, M, R> {
        fluent_builders::DescribeConnections::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpoints` operation.
    ///
    /// See [`DescribeEndpoints`](crate::client::fluent_builders::DescribeEndpoints) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoints(&self) -> fluent_builders::DescribeEndpoints<C, M, R> {
        fluent_builders::DescribeEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpointSettings` operation.
    ///
    /// See [`DescribeEndpointSettings`](crate::client::fluent_builders::DescribeEndpointSettings) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint_settings(&self) -> fluent_builders::DescribeEndpointSettings<C, M, R> {
        fluent_builders::DescribeEndpointSettings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpointTypes` operation.
    ///
    /// See [`DescribeEndpointTypes`](crate::client::fluent_builders::DescribeEndpointTypes) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint_types(&self) -> fluent_builders::DescribeEndpointTypes<C, M, R> {
        fluent_builders::DescribeEndpointTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventCategories` operation.
    ///
    /// See [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) for more information about the
    /// operation and its arguments.
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories<C, M, R> {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventSubscriptions` operation.
    ///
    /// See [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn describe_event_subscriptions(
        &self,
    ) -> fluent_builders::DescribeEventSubscriptions<C, M, R> {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrderableReplicationInstances` operation.
    ///
    /// See [`DescribeOrderableReplicationInstances`](crate::client::fluent_builders::DescribeOrderableReplicationInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_orderable_replication_instances(
        &self,
    ) -> fluent_builders::DescribeOrderableReplicationInstances<C, M, R> {
        fluent_builders::DescribeOrderableReplicationInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePendingMaintenanceActions` operation.
    ///
    /// See [`DescribePendingMaintenanceActions`](crate::client::fluent_builders::DescribePendingMaintenanceActions) for more information about the
    /// operation and its arguments.
    pub fn describe_pending_maintenance_actions(
        &self,
    ) -> fluent_builders::DescribePendingMaintenanceActions<C, M, R> {
        fluent_builders::DescribePendingMaintenanceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRefreshSchemasStatus` operation.
    ///
    /// See [`DescribeRefreshSchemasStatus`](crate::client::fluent_builders::DescribeRefreshSchemasStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_refresh_schemas_status(
        &self,
    ) -> fluent_builders::DescribeRefreshSchemasStatus<C, M, R> {
        fluent_builders::DescribeRefreshSchemasStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationInstances` operation.
    ///
    /// See [`DescribeReplicationInstances`](crate::client::fluent_builders::DescribeReplicationInstances) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_instances(
        &self,
    ) -> fluent_builders::DescribeReplicationInstances<C, M, R> {
        fluent_builders::DescribeReplicationInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationInstanceTaskLogs` operation.
    ///
    /// See [`DescribeReplicationInstanceTaskLogs`](crate::client::fluent_builders::DescribeReplicationInstanceTaskLogs) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_instance_task_logs(
        &self,
    ) -> fluent_builders::DescribeReplicationInstanceTaskLogs<C, M, R> {
        fluent_builders::DescribeReplicationInstanceTaskLogs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationSubnetGroups` operation.
    ///
    /// See [`DescribeReplicationSubnetGroups`](crate::client::fluent_builders::DescribeReplicationSubnetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_subnet_groups(
        &self,
    ) -> fluent_builders::DescribeReplicationSubnetGroups<C, M, R> {
        fluent_builders::DescribeReplicationSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationTaskAssessmentResults` operation.
    ///
    /// See [`DescribeReplicationTaskAssessmentResults`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentResults) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_task_assessment_results(
        &self,
    ) -> fluent_builders::DescribeReplicationTaskAssessmentResults<C, M, R> {
        fluent_builders::DescribeReplicationTaskAssessmentResults::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationTaskAssessmentRuns` operation.
    ///
    /// See [`DescribeReplicationTaskAssessmentRuns`](crate::client::fluent_builders::DescribeReplicationTaskAssessmentRuns) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_task_assessment_runs(
        &self,
    ) -> fluent_builders::DescribeReplicationTaskAssessmentRuns<C, M, R> {
        fluent_builders::DescribeReplicationTaskAssessmentRuns::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationTaskIndividualAssessments` operation.
    ///
    /// See [`DescribeReplicationTaskIndividualAssessments`](crate::client::fluent_builders::DescribeReplicationTaskIndividualAssessments) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_task_individual_assessments(
        &self,
    ) -> fluent_builders::DescribeReplicationTaskIndividualAssessments<C, M, R> {
        fluent_builders::DescribeReplicationTaskIndividualAssessments::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReplicationTasks` operation.
    ///
    /// See [`DescribeReplicationTasks`](crate::client::fluent_builders::DescribeReplicationTasks) for more information about the
    /// operation and its arguments.
    pub fn describe_replication_tasks(&self) -> fluent_builders::DescribeReplicationTasks<C, M, R> {
        fluent_builders::DescribeReplicationTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSchemas` operation.
    ///
    /// See [`DescribeSchemas`](crate::client::fluent_builders::DescribeSchemas) for more information about the
    /// operation and its arguments.
    pub fn describe_schemas(&self) -> fluent_builders::DescribeSchemas<C, M, R> {
        fluent_builders::DescribeSchemas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTableStatistics` operation.
    ///
    /// See [`DescribeTableStatistics`](crate::client::fluent_builders::DescribeTableStatistics) for more information about the
    /// operation and its arguments.
    pub fn describe_table_statistics(&self) -> fluent_builders::DescribeTableStatistics<C, M, R> {
        fluent_builders::DescribeTableStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ImportCertificate` operation.
    ///
    /// See [`ImportCertificate`](crate::client::fluent_builders::ImportCertificate) for more information about the
    /// operation and its arguments.
    pub fn import_certificate(&self) -> fluent_builders::ImportCertificate<C, M, R> {
        fluent_builders::ImportCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEndpoint` operation.
    ///
    /// See [`ModifyEndpoint`](crate::client::fluent_builders::ModifyEndpoint) for more information about the
    /// operation and its arguments.
    pub fn modify_endpoint(&self) -> fluent_builders::ModifyEndpoint<C, M, R> {
        fluent_builders::ModifyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEventSubscription` operation.
    ///
    /// See [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription<C, M, R> {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyReplicationInstance` operation.
    ///
    /// See [`ModifyReplicationInstance`](crate::client::fluent_builders::ModifyReplicationInstance) for more information about the
    /// operation and its arguments.
    pub fn modify_replication_instance(
        &self,
    ) -> fluent_builders::ModifyReplicationInstance<C, M, R> {
        fluent_builders::ModifyReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyReplicationSubnetGroup` operation.
    ///
    /// See [`ModifyReplicationSubnetGroup`](crate::client::fluent_builders::ModifyReplicationSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_replication_subnet_group(
        &self,
    ) -> fluent_builders::ModifyReplicationSubnetGroup<C, M, R> {
        fluent_builders::ModifyReplicationSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyReplicationTask` operation.
    ///
    /// See [`ModifyReplicationTask`](crate::client::fluent_builders::ModifyReplicationTask) for more information about the
    /// operation and its arguments.
    pub fn modify_replication_task(&self) -> fluent_builders::ModifyReplicationTask<C, M, R> {
        fluent_builders::ModifyReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MoveReplicationTask` operation.
    ///
    /// See [`MoveReplicationTask`](crate::client::fluent_builders::MoveReplicationTask) for more information about the
    /// operation and its arguments.
    pub fn move_replication_task(&self) -> fluent_builders::MoveReplicationTask<C, M, R> {
        fluent_builders::MoveReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootReplicationInstance` operation.
    ///
    /// See [`RebootReplicationInstance`](crate::client::fluent_builders::RebootReplicationInstance) for more information about the
    /// operation and its arguments.
    pub fn reboot_replication_instance(
        &self,
    ) -> fluent_builders::RebootReplicationInstance<C, M, R> {
        fluent_builders::RebootReplicationInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RefreshSchemas` operation.
    ///
    /// See [`RefreshSchemas`](crate::client::fluent_builders::RefreshSchemas) for more information about the
    /// operation and its arguments.
    pub fn refresh_schemas(&self) -> fluent_builders::RefreshSchemas<C, M, R> {
        fluent_builders::RefreshSchemas::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ReloadTables` operation.
    ///
    /// See [`ReloadTables`](crate::client::fluent_builders::ReloadTables) for more information about the
    /// operation and its arguments.
    pub fn reload_tables(&self) -> fluent_builders::ReloadTables<C, M, R> {
        fluent_builders::ReloadTables::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveTagsFromResource` operation.
    ///
    /// See [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) for more information about the
    /// operation and its arguments.
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource<C, M, R> {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartReplicationTask` operation.
    ///
    /// See [`StartReplicationTask`](crate::client::fluent_builders::StartReplicationTask) for more information about the
    /// operation and its arguments.
    pub fn start_replication_task(&self) -> fluent_builders::StartReplicationTask<C, M, R> {
        fluent_builders::StartReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartReplicationTaskAssessment` operation.
    ///
    /// See [`StartReplicationTaskAssessment`](crate::client::fluent_builders::StartReplicationTaskAssessment) for more information about the
    /// operation and its arguments.
    pub fn start_replication_task_assessment(
        &self,
    ) -> fluent_builders::StartReplicationTaskAssessment<C, M, R> {
        fluent_builders::StartReplicationTaskAssessment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartReplicationTaskAssessmentRun` operation.
    ///
    /// See [`StartReplicationTaskAssessmentRun`](crate::client::fluent_builders::StartReplicationTaskAssessmentRun) for more information about the
    /// operation and its arguments.
    pub fn start_replication_task_assessment_run(
        &self,
    ) -> fluent_builders::StartReplicationTaskAssessmentRun<C, M, R> {
        fluent_builders::StartReplicationTaskAssessmentRun::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopReplicationTask` operation.
    ///
    /// See [`StopReplicationTask`](crate::client::fluent_builders::StopReplicationTask) for more information about the
    /// operation and its arguments.
    pub fn stop_replication_task(&self) -> fluent_builders::StopReplicationTask<C, M, R> {
        fluent_builders::StopReplicationTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestConnection` operation.
    ///
    /// See [`TestConnection`](crate::client::fluent_builders::TestConnection) for more information about the
    /// operation and its arguments.
    pub fn test_connection(&self) -> fluent_builders::TestConnection<C, M, R> {
        fluent_builders::TestConnection::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds metadata tags to an DMS resource, including replication instance, endpoint,
    /// security group, and migration task. These tags can also be used with cost allocation
    /// reporting to track cost associated with DMS resources, or used in a Condition statement in
    /// an IAM policy for DMS. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
    /// <code>Tag</code>
    /// </a> data type description.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTagsToResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl<C, M, R> AddTagsToResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsToResourceInputOperationOutputAlias,
                crate::output::AddTagsToResourceOutput,
                crate::error::AddTagsToResourceError,
                crate::input::AddTagsToResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>
        /// <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>Identifies the DMS resource to which tags should be added. The value for this parameter is an Amazon Resource Name (ARN).</p>
        /// <p>For DMS, you can tag a replication instance, an endpoint, or a replication task.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags to be assigned to the resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyPendingMaintenanceAction`.
    ///
    /// <p>Applies a pending maintenance action to a resource (for example, to a replication instance).</p>
    #[derive(std::fmt::Debug)]
    pub struct ApplyPendingMaintenanceAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::apply_pending_maintenance_action_input::Builder,
    }
    impl<C, M, R> ApplyPendingMaintenanceAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ApplyPendingMaintenanceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyPendingMaintenanceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ApplyPendingMaintenanceActionInputOperationOutputAlias,
                crate::output::ApplyPendingMaintenanceActionOutput,
                crate::error::ApplyPendingMaintenanceActionError,
                crate::input::ApplyPendingMaintenanceActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
        /// action applies to.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
        /// action applies to.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn apply_action(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.apply_action(inp);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>os-upgrade</code>, <code>system-update</code>, <code>db-upgrade</code>
        /// </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_apply_action(input);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an
        /// opt-in request of type <code>immediate</code>.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn opt_in_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_in_type(inp);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. You can't undo an
        /// opt-in request of type <code>immediate</code>.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>immediate</code> - Apply the maintenance action immediately.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>next-maintenance</code> - Apply the maintenance action during the next
        /// maintenance window for the resource.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in
        /// requests.</p>
        /// </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_opt_in_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelReplicationTaskAssessmentRun`.
    ///
    /// <p>Cancels a single premigration assessment run.</p>
    /// <p>This operation prevents any individual assessments from running if they haven't started
    /// running. It also attempts to cancel any individual assessments that are currently
    /// running.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelReplicationTaskAssessmentRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_replication_task_assessment_run_input::Builder,
    }
    impl<C, M, R> CancelReplicationTaskAssessmentRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelReplicationTaskAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelReplicationTaskAssessmentRunOutput,
            aws_smithy_http::result::SdkError<
                crate::error::CancelReplicationTaskAssessmentRunError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelReplicationTaskAssessmentRunInputOperationOutputAlias,
                crate::output::CancelReplicationTaskAssessmentRunOutput,
                crate::error::CancelReplicationTaskAssessmentRunError,
                crate::input::CancelReplicationTaskAssessmentRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_task_assessment_run_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be canceled.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpoint`.
    ///
    /// <p>Creates an endpoint using the provided settings.</p>
    /// <note>
    /// <p>For a MySQL source or target endpoint, don't explicitly specify the database using
    /// the <code>DatabaseName</code> request parameter on the <code>CreateEndpoint</code> API call.
    /// Specifying <code>DatabaseName</code> when you create a MySQL endpoint replicates all the
    /// task tables to this single database. For MySQL endpoints, you specify the database only when
    /// you specify the schema in the table-mapping rules of the DMS task.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_endpoint_input::Builder,
    }
    impl<C, M, R> CreateEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEndpointInputOperationOutputAlias,
                crate::output::CreateEndpointOutput,
                crate::error::CreateEndpointError,
                crate::input::CreateEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two
        /// consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_identifier(inp);
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen, or contain two
        /// consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_identifier(input);
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn endpoint_type(mut self, inp: crate::model::ReplicationEndpointTypeValue) -> Self {
            self.inner = self.inner.endpoint_type(inp);
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the
        /// <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>,
        /// <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
        /// <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
        /// <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>,
        /// <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(inp);
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the
        /// <code>EndpointType</code> value, include <code>"mysql"</code>, <code>"oracle"</code>,
        /// <code>"postgres"</code>, <code>"mariadb"</code>, <code>"aurora"</code>,
        /// <code>"aurora-postgresql"</code>, <code>"redshift"</code>, <code>"s3"</code>,
        /// <code>"db2"</code>, <code>"azuredb"</code>, <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>, <code>"docdb"</code>,
        /// <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>The user name to be used to log in to the endpoint database.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The user name to be used to log in to the endpoint database.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password to be used to log in to the endpoint database.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password to be used to log in to the endpoint database.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn server_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_name(inp);
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_name(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Additional attributes associated with the connection. Each attribute is specified as a
        /// name-value pair associated by an equal sign (=). Multiple attributes are separated by a
        /// semicolon (;) with no additional white space. For information on the attributes available
        /// for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with
        /// DMS Endpoints</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn extra_connection_attributes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extra_connection_attributes(inp);
            self
        }
        /// <p>Additional attributes associated with the connection. Each attribute is specified as a
        /// name-value pair associated by an equal sign (=). Multiple attributes are separated by a
        /// semicolon (;) with no additional white space. For information on the attributes available
        /// for connecting your source or target endpoint, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html">Working with
        /// DMS Endpoints</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_extra_connection_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_extra_connection_attributes(input);
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the connection parameters for the endpoint.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the endpoint.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags to be assigned to the endpoint.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn certificate_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code>
        /// </p>
        pub fn ssl_mode(mut self, inp: crate::model::DmsSslModeValue) -> Self {
            self.inner = self.inner.ssl_mode(inp);
            self
        }
        /// <p>The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default is <code>none</code>
        /// </p>
        pub fn set_ssl_mode(
            mut self,
            input: std::option::Option<crate::model::DmsSslModeValue>,
        ) -> Self {
            self.inner = self.inner.set_ssl_mode(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the service access role that you want to use to
        /// create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_access_role_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the service access role that you want to use to
        /// create the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_access_role_arn(input);
            self
        }
        /// <p>The external table definition. </p>
        pub fn external_table_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_table_definition(inp);
            self
        }
        /// <p>The external table definition. </p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_table_definition(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn dynamo_db_settings(mut self, inp: crate::model::DynamoDbSettings) -> Self {
            self.inner = self.inner.dynamo_db_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_dynamo_db_settings(
            mut self,
            input: std::option::Option<crate::model::DynamoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_dynamo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn s3_settings(mut self, inp: crate::model::S3Settings) -> Self {
            self.inner = self.inner.s3_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_s3_settings(
            mut self,
            input: std::option::Option<crate::model::S3Settings>,
        ) -> Self {
            self.inner = self.inner.set_s3_settings(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Possible settings include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BucketName</code> - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows:
        /// <code>ServiceAccessRoleArn=string,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn":
        /// "string", "BucketName": "string", } </code>
        /// </p>
        pub fn dms_transfer_settings(mut self, inp: crate::model::DmsTransferSettings) -> Self {
            self.inner = self.inner.dms_transfer_settings(inp);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Possible settings include the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ServiceAccessRoleArn</code> - The Amazon Resource Name (ARN) used by the service access IAM role.
        /// The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BucketName</code> - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows:
        /// <code>ServiceAccessRoleArn=string,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn":
        /// "string", "BucketName": "string", } </code>
        /// </p>
        pub fn set_dms_transfer_settings(
            mut self,
            input: std::option::Option<crate::model::DmsTransferSettings>,
        ) -> Self {
            self.inner = self.inner.set_dms_transfer_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn mongo_db_settings(mut self, inp: crate::model::MongoDbSettings) -> Self {
            self.inner = self.inner.mongo_db_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_mongo_db_settings(
            mut self,
            input: std::option::Option<crate::model::MongoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_mongo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn kinesis_settings(mut self, inp: crate::model::KinesisSettings) -> Self {
            self.inner = self.inner.kinesis_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_kinesis_settings(
            mut self,
            input: std::option::Option<crate::model::KinesisSettings>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn kafka_settings(mut self, inp: crate::model::KafkaSettings) -> Self {
            self.inner = self.inner.kafka_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_kafka_settings(
            mut self,
            input: std::option::Option<crate::model::KafkaSettings>,
        ) -> Self {
            self.inner = self.inner.set_kafka_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide</i>.</p>
        pub fn elasticsearch_settings(mut self, inp: crate::model::ElasticsearchSettings) -> Self {
            self.inner = self.inner.elasticsearch_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide</i>.</p>
        pub fn set_elasticsearch_settings(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchSettings>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint.
        /// For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn neptune_settings(mut self, inp: crate::model::NeptuneSettings) -> Self {
            self.inner = self.inner.neptune_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint.
        /// For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_neptune_settings(
            mut self,
            input: std::option::Option<crate::model::NeptuneSettings>,
        ) -> Self {
            self.inner = self.inner.set_neptune_settings(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn redshift_settings(mut self, inp: crate::model::RedshiftSettings) -> Self {
            self.inner = self.inner.redshift_settings(inp);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn set_redshift_settings(
            mut self,
            input: std::option::Option<crate::model::RedshiftSettings>,
        ) -> Self {
            self.inner = self.inner.set_redshift_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn postgre_sql_settings(mut self, inp: crate::model::PostgreSqlSettings) -> Self {
            self.inner = self.inner.postgre_sql_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_postgre_sql_settings(
            mut self,
            input: std::option::Option<crate::model::PostgreSqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_postgre_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes
        /// when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn my_sql_settings(mut self, inp: crate::model::MySqlSettings) -> Self {
            self.inner = self.inner.my_sql_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection attributes
        /// when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra connection attributes when using a MySQL-compatible database as a target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::MySqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes
        /// when using Oracle as a source for DMS</a> and
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn oracle_settings(mut self, inp: crate::model::OracleSettings) -> Self {
            self.inner = self.inner.oracle_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection attributes
        /// when using Oracle as a source for DMS</a> and
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_oracle_settings(
            mut self,
            input: std::option::Option<crate::model::OracleSettings>,
        ) -> Self {
            self.inner = self.inner.set_oracle_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn sybase_settings(mut self, inp: crate::model::SybaseSettings) -> Self {
            self.inner = self.inner.sybase_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_sybase_settings(
            mut self,
            input: std::option::Option<crate::model::SybaseSettings>,
        ) -> Self {
            self.inner = self.inner.set_sybase_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn microsoft_sql_server_settings(
            mut self,
            inp: crate::model::MicrosoftSqlServerSettings,
        ) -> Self {
            self.inner = self.inner.microsoft_sql_server_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_microsoft_sql_server_settings(
            mut self,
            input: std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        ) -> Self {
            self.inner = self.inner.set_microsoft_sql_server_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn ibm_db2_settings(mut self, inp: crate::model::IbmDb2Settings) -> Self {
            self.inner = self.inner.ibm_db2_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_ibm_db2_settings(
            mut self,
            input: std::option::Option<crate::model::IbmDb2Settings>,
        ) -> Self {
            self.inner = self.inner.set_ibm_db2_settings(input);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn doc_db_settings(mut self, inp: crate::model::DocDbSettings) -> Self {
            self.inner = self.inner.doc_db_settings(inp);
            self
        }
        /// <p>Provides information that defines a DocumentDB endpoint.</p>
        pub fn set_doc_db_settings(
            mut self,
            input: std::option::Option<crate::model::DocDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_doc_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Redis endpoint.</p>
        pub fn redis_settings(mut self, inp: crate::model::RedisSettings) -> Self {
            self.inner = self.inner.redis_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Redis endpoint.</p>
        pub fn set_redis_settings(
            mut self,
            input: std::option::Option<crate::model::RedisSettings>,
        ) -> Self {
            self.inner = self.inner.set_redis_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p> Creates an DMS event notification subscription. </p>
    /// <p>You can specify the type of source (<code>SourceType</code>) you want to be notified of,
    /// provide a list of DMS source IDs (<code>SourceIds</code>) that triggers the events, and
    /// provide a list of event categories (<code>EventCategories</code>) for events you want to be
    /// notified of. If you specify both the <code>SourceType</code> and <code>SourceIds</code>,
    /// such as <code>SourceType = replication-instance</code> and <code>SourceIdentifier =
    /// my-replinstance</code>, you will be notified of all the replication instance events for
    /// the specified source. If you specify a <code>SourceType</code> but don't specify a
    /// <code>SourceIdentifier</code>, you receive notice of the events for that source type for
    /// all your DMS sources. If you don't specify either <code>SourceType</code> nor
    /// <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
    /// sources belonging to your customer account.</p>
    /// <p>For more information about DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
    /// Notifications</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl<C, M, R> CreateEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventSubscriptionInputOperationOutputAlias,
                crate::output::CreateEventSubscriptionOutput,
                crate::error::CreateEventSubscriptionError,
                crate::input::CreateEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the DMS event notification subscription. This name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it. </p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p> The type of DMS resource that generates the events. For example, if you want to be
        /// notified of events generated by a replication instance, you set this parameter to
        /// <code>replication-instance</code>. If this value isn't specified, all events are
        /// returned. </p>
        /// <p>Valid values: <code>replication-instance</code> | <code>replication-task</code>
        /// </p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p> The type of DMS resource that generates the events. For example, if you want to be
        /// notified of events generated by a replication instance, you set this parameter to
        /// <code>replication-instance</code>. If this value isn't specified, all events are
        /// returned. </p>
        /// <p>Valid values: <code>replication-instance</code> | <code>replication-task</code>
        /// </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories for a source type that you want to subscribe to. For more
        /// information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
        /// Notifications</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p>A list of event categories for a source type that you want to subscribe to. For more
        /// information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
        /// Notifications</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of identifiers for which DMS provides notification events.</p>
        /// <p>If you don't specify a value, notifications are provided for all sources.</p>
        /// <p>If you specify multiple values, they must be of the same type. For example, if you
        /// specify a database instance ID, then all of the other values must be database instance
        /// IDs.</p>
        pub fn source_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(inp);
            self
        }
        /// <p>A list of identifiers for which DMS provides notification events.</p>
        /// <p>If you don't specify a value, notifications are provided for all sources.</p>
        /// <p>If you specify multiple values, they must be of the same type. For example, if you
        /// specify a database instance ID, then all of the other values must be database instance
        /// IDs.</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p> A Boolean value; set to <code>true</code> to activate the subscription, or set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the event subscription.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags to be assigned to the event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationInstance`.
    ///
    /// <p>Creates the replication instance using the specified parameters.</p>
    /// <p>DMS requires that your account have certain roles with appropriate permissions
    /// before you can create a replication instance. For information on the required roles, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM Roles to Use With the CLI and DMS API</a>. For
    /// information on the required permissions, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM Permissions Needed to Use DMS</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReplicationInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replication_instance_input::Builder,
    }
    impl<C, M, R> CreateReplicationInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplicationInstanceInputOperationOutputAlias,
                crate::output::CreateReplicationInstanceOutput,
                crate::error::CreateReplicationInstanceError,
                crate::input::CreateReplicationInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code>
        /// </p>
        pub fn replication_instance_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_instance_identifier(inp);
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>myrepinstance</code>
        /// </p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_identifier(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be initially allocated for the replication
        /// instance.</p>
        pub fn allocated_storage(mut self, inp: i32) -> Self {
            self.inner = self.inner.allocated_storage(inp);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be initially allocated for the replication
        /// instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn replication_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_class(inp);
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_class(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The Availability Zone where the replication instance will be created. The default
        /// value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for
        /// example: <code>us-east-1d</code>
        /// </p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Availability Zone where the replication instance will be created. The default
        /// value is a random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region, for
        /// example: <code>us-east-1d</code>
        /// </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>A subnet group to associate with the replication instance.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(inp);
            self
        }
        /// <p>A subnet group to associate with the replication instance.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region,
        /// occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal
        /// Coordinated Time (UTC).</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p>Default: A 30-minute window selected at random from an 8-hour block of time per Amazon Web Services Region,
        /// occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication
        /// instance is created, the default is the latest engine version available.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>If an engine version number is not specified when a replication
        /// instance is created, the default is the latest engine version available.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the
        /// replication instance during the maintenance window. This parameter defaults to
        /// <code>true</code>.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the
        /// replication instance during the maintenance window. This parameter defaults to
        /// <code>true</code>.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the replication instance.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags to be assigned to the replication instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication
        /// instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>An KMS key identifier that is used to encrypt the data on the replication
        /// instance.</p>
        /// <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then
        /// DMS uses your default encryption key.</p>
        /// <p>KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
        /// different default encryption key for each Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of
        /// <code>true</code> represents an instance with a public IP address. A value of
        /// <code>false</code> represents an instance with a private IP address. The default value
        /// is <code>true</code>. </p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p> Specifies the accessibility options for the replication instance. A value of
        /// <code>true</code> represents an instance with a public IP address. A value of
        /// <code>false</code> represents an instance with a private IP address. The default value
        /// is <code>true</code>. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>A list of custom DNS name servers supported for the replication instance to access your
        /// on-premise source or target database. This list overrides the default name servers
        /// supported by the replication instance. You can specify a comma-separated list of internet
        /// addresses for up to four on-premise DNS name servers. For example:
        /// <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
        /// </p>
        pub fn dns_name_servers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dns_name_servers(inp);
            self
        }
        /// <p>A list of custom DNS name servers supported for the replication instance to access your
        /// on-premise source or target database. This list overrides the default name servers
        /// supported by the replication instance. You can specify a comma-separated list of internet
        /// addresses for up to four on-premise DNS name servers. For example:
        /// <code>"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"</code>
        /// </p>
        pub fn set_dns_name_servers(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dns_name_servers(input);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationSubnetGroup`.
    ///
    /// <p>Creates a replication subnet group given a list of the subnet IDs in a VPC.</p>
    /// <p>The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region, otherwise the
    /// service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReplicationSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replication_subnet_group_input::Builder,
    }
    impl<C, M, R> CreateReplicationSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplicationSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplicationSubnetGroupInputOperationOutputAlias,
                crate::output::CreateReplicationSubnetGroupOutput,
                crate::error::CreateReplicationSubnetGroupError,
                crate::input::CreateReplicationSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the replication subnet group. This value is stored as a lowercase
        /// string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces,
        /// underscores, or hyphens. Must not be "default".</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn replication_subnet_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(inp);
            self
        }
        /// <p>The name for the replication subnet group. This value is stored as a lowercase
        /// string.</p>
        /// <p>Constraints: Must contain no more than 255 alphanumeric characters, periods, spaces,
        /// underscores, or hyphens. Must not be "default".</p>
        /// <p>Example: <code>mySubnetgroup</code>
        /// </p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn replication_subnet_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_description(inp);
            self
        }
        /// <p>The description for the subnet group.</p>
        pub fn set_replication_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>One or more subnet IDs to be assigned to the subnet group.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>One or more subnet IDs to be assigned to the subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the subnet group.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags to be assigned to the subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateReplicationTask`.
    ///
    /// <p>Creates a replication task using the specified parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateReplicationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_replication_task_input::Builder,
    }
    impl<C, M, R> CreateReplicationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateReplicationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateReplicationTaskInputOperationOutputAlias,
                crate::output::CreateReplicationTaskOutput,
                crate::error::CreateReplicationTaskError,
                crate::input::CreateReplicationTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An identifier for the replication task.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn replication_task_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_identifier(inp);
            self
        }
        /// <p>An identifier for the replication task.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_identifier(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
        pub fn source_endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_endpoint_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.</p>
        pub fn set_source_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_endpoint_arn(input);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
        pub fn target_endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_endpoint_arn(inp);
            self
        }
        /// <p>An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.</p>
        pub fn set_target_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_endpoint_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of a replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn migration_type(mut self, inp: crate::model::MigrationTypeValue) -> Self {
            self.inner = self.inner.migration_type(inp);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_migration_type(input);
            self
        }
        /// <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table
        /// Mapping to Specify Task Settings</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn table_mappings(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_mappings(inp);
            self
        }
        /// <p>The table mappings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html">Using Table
        /// Mapping to Specify Task Settings</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_table_mappings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_mappings(input);
            self
        }
        /// <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task
        /// Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn replication_task_settings(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_settings(inp);
            self
        }
        /// <p>Overall settings for the task, in JSON format. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html">Specifying Task
        /// Settings for Database Migration Service Tasks</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_replication_task_settings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_settings(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.cdc_start_time(inp);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_time(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_start_position(inp);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_position(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_stop_position(inp);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_stop_position(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags to be assigned to the replication task.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more tags to be assigned to the replication task.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn task_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_data(inp);
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_task_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_data(input);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn resource_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(inp);
            self
        }
        /// <p>A friendly name for the resource identifier at the end of the <code>EndpointArn</code>
        /// response parameter that is returned in the created <code>Endpoint</code> object. The value
        /// for this parameter can have up to 31 characters. It can contain only ASCII letters, digits,
        /// and hyphen ('-'). Also, it can't end with a hyphen or contain two consecutive hyphens,
        /// and can only begin with a letter, such as <code>Example-App-ARN1</code>. For example, this
        /// value might result in the <code>EndpointArn</code> value
        /// <code>arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1</code>. If you don't
        /// specify a <code>ResourceIdentifier</code> value, DMS generates a default identifier
        /// value for the end of <code>EndpointArn</code>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCertificate`.
    ///
    /// <p>Deletes the specified certificate. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_certificate_input::Builder,
    }
    impl<C, M, R> DeleteCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCertificateInputOperationOutputAlias,
                crate::output::DeleteCertificateOutput,
                crate::error::DeleteCertificateError,
                crate::input::DeleteCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted certificate.</p>
        pub fn certificate_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the deleted certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteConnection`.
    ///
    /// <p>Deletes the connection between a replication instance and an endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_connection_input::Builder,
    }
    impl<C, M, R> DeleteConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteConnectionInputOperationOutputAlias,
                crate::output::DeleteConnectionOutput,
                crate::error::DeleteConnectionError,
                crate::input::DeleteConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpoint`.
    ///
    /// <p>Deletes the specified endpoint.</p>
    /// <note>
    /// <p>All tasks associated with the endpoint must be deleted before you can delete the
    /// endpoint.</p>
    /// </note>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointInputOperationOutputAlias,
                crate::output::DeleteEndpointOutput,
                crate::error::DeleteEndpointError,
                crate::input::DeleteEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p> Deletes an DMS event subscription. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl<C, M, R> DeleteEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventSubscriptionInputOperationOutputAlias,
                crate::output::DeleteEventSubscriptionOutput,
                crate::error::DeleteEventSubscriptionError,
                crate::input::DeleteEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DMS event notification subscription to be deleted.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the DMS event notification subscription to be deleted.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationInstance`.
    ///
    /// <p>Deletes the specified replication instance.</p>
    /// <note>
    /// <p>You must delete any migration tasks that are associated with the replication instance
    /// before you can delete it.</p>
    /// </note>
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReplicationInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_instance_input::Builder,
    }
    impl<C, M, R> DeleteReplicationInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationInstanceInputOperationOutputAlias,
                crate::output::DeleteReplicationInstanceOutput,
                crate::error::DeleteReplicationInstanceError,
                crate::input::DeleteReplicationInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance to be deleted.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationSubnetGroup`.
    ///
    /// <p>Deletes a subnet group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReplicationSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_subnet_group_input::Builder,
    }
    impl<C, M, R> DeleteReplicationSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationSubnetGroupInputOperationOutputAlias,
                crate::output::DeleteReplicationSubnetGroupOutput,
                crate::error::DeleteReplicationSubnetGroupError,
                crate::input::DeleteReplicationSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The subnet group name of the replication instance.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(inp);
            self
        }
        /// <p>The subnet group name of the replication instance.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationTask`.
    ///
    /// <p>Deletes the specified replication task.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReplicationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_task_input::Builder,
    }
    impl<C, M, R> DeleteReplicationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteReplicationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationTaskInputOperationOutputAlias,
                crate::output::DeleteReplicationTaskOutput,
                crate::error::DeleteReplicationTaskError,
                crate::input::DeleteReplicationTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be deleted.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteReplicationTaskAssessmentRun`.
    ///
    /// <p>Deletes the record of a single premigration assessment run.</p>
    /// <p>This operation removes all metadata that DMS maintains about this assessment run.
    /// However, the operation leaves untouched all information about this assessment run that is
    /// stored in your Amazon S3 bucket.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteReplicationTaskAssessmentRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_replication_task_assessment_run_input::Builder,
    }
    impl<C, M, R> DeleteReplicationTaskAssessmentRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteReplicationTaskAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteReplicationTaskAssessmentRunOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DeleteReplicationTaskAssessmentRunError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteReplicationTaskAssessmentRunInputOperationOutputAlias,
                crate::output::DeleteReplicationTaskAssessmentRunOutput,
                crate::error::DeleteReplicationTaskAssessmentRunError,
                crate::input::DeleteReplicationTaskAssessmentRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
        pub fn replication_task_assessment_run_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_task_assessment_run_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the premigration assessment run to be deleted.</p>
        pub fn set_replication_task_assessment_run_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_assessment_run_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Lists all of the DMS attributes for a customer account. These attributes include DMS
    /// quotas for the account and a unique account identifier in a particular DMS region. DMS
    /// quotas include a list of resource quotas supported by the account, such as the number of
    /// replication instances allowed. The description for each resource quota, includes the quota
    /// name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
    /// account identifier to name each artifact used by DMS in the given region.</p>
    /// <p>This command does not take any parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl<C, M, R> DescribeAccountAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAttributesInputOperationOutputAlias,
                crate::output::DescribeAccountAttributesOutput,
                crate::error::DescribeAccountAttributesError,
                crate::input::DescribeAccountAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeApplicableIndividualAssessments`.
    ///
    /// <p>Provides a list of individual assessments that you can specify for a new premigration
    /// assessment run, given one or more parameters.</p>
    /// <p>If you specify an existing migration task, this operation provides the default individual
    /// assessments you can specify for that task. Otherwise, the specified parameters model elements
    /// of a possible migration task on which to base a premigration assessment run.</p>
    /// <p>To use these migration task modeling parameters, you must specify an existing replication instance,
    /// a source database engine, a target database engine, and a migration type. This combination of
    /// parameters potentially limits the default individual assessments available for an assessment run
    /// created for a corresponding migration task.</p>
    /// <p>If you specify no parameters, this operation provides a list of all possible individual assessments
    /// that you can specify for an assessment run. If you specify any one of the task modeling parameters, you must
    /// specify all of them or the operation cannot provide a list of individual assessments.
    /// The only parameter that you can specify alone is for an existing migration task. The specified task
    /// definition then determines the default list of individual assessments that you can specify in an
    /// assessment run for the task.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeApplicableIndividualAssessments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_applicable_individual_assessments_input::Builder,
    }
    impl<C, M, R> DescribeApplicableIndividualAssessments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeApplicableIndividualAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeApplicableIndividualAssessmentsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeApplicableIndividualAssessmentsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeApplicableIndividualAssessmentsInputOperationOutputAlias,
                crate::output::DescribeApplicableIndividualAssessmentsOutput,
                crate::error::DescribeApplicableIndividualAssessmentsError,
                crate::input::DescribeApplicableIndividualAssessmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of a migration task on which you want to base
        /// the default list of individual assessments.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of a migration task on which you want to base
        /// the default list of individual assessments.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>ARN of a replication instance on which you want to base the default list of individual
        /// assessments.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>ARN of a replication instance on which you want to base the default list of individual
        /// assessments.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a source.</p>
        pub fn source_engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_engine_name(inp);
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a source.</p>
        pub fn set_source_engine_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_engine_name(input);
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a target.</p>
        pub fn target_engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_engine_name(inp);
            self
        }
        /// <p>Name of a database engine that the specified replication instance supports as a target.</p>
        pub fn set_target_engine_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_engine_name(input);
            self
        }
        /// <p>Name of the migration type that each provided individual assessment must support.</p>
        pub fn migration_type(mut self, inp: crate::model::MigrationTypeValue) -> Self {
            self.inner = self.inner.migration_type(inp);
            self
        }
        /// <p>Name of the migration type that each provided individual assessment must support.</p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_migration_type(input);
            self
        }
        /// <p>Maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>Maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>Optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>Optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCertificates`.
    ///
    /// <p>Provides a description of the certificate.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_certificates_input::Builder,
    }
    impl<C, M, R> DescribeCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCertificatesInputOperationOutputAlias,
                crate::output::DescribeCertificatesOutput,
                crate::error::DescribeCertificatesError,
                crate::input::DescribeCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the certificates described in the form of key-value pairs.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to the certificates described in the form of key-value pairs.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 10</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 10</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeConnections`.
    ///
    /// <p>Describes the status of the connections that have been made between the replication
    /// instance and an endpoint. Connections are created when you test an endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeConnections<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_connections_input::Builder,
    }
    impl<C, M, R> DescribeConnections<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeConnections`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeConnectionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeConnectionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeConnectionsInputOperationOutputAlias,
                crate::output::DescribeConnectionsOutput,
                crate::error::DescribeConnectionsError,
                crate::input::DescribeConnectionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>The filters applied to the connection.</p>
        /// <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The filters applied to the connection.</p>
        /// <p>Valid filter names: endpoint-arn | replication-instance-arn</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoints`.
    ///
    /// <p>Returns information about the endpoints for your account in the current region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoints_input::Builder,
    }
    impl<C, M, R> DescribeEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointsInputOperationOutputAlias,
                crate::output::DescribeEndpointsOutput,
                crate::error::DescribeEndpointsError,
                crate::input::DescribeEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the endpoints.</p>
        /// <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to the endpoints.</p>
        /// <p>Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointSettings`.
    ///
    /// <p>Returns information about the possible endpoint settings available
    /// when you create an endpoint for a specific database engine.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpointSettings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_settings_input::Builder,
    }
    impl<C, M, R> DescribeEndpointSettings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpointSettings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointSettingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointSettingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointSettingsInputOperationOutputAlias,
                crate::output::DescribeEndpointSettingsOutput,
                crate::error::DescribeEndpointSettingsError,
                crate::input::DescribeEndpointSettingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The databse engine used for your source or target endpoint.</p>
        pub fn engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(inp);
            self
        }
        /// <p>The databse engine used for your source or target endpoint.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response
        /// so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response
        /// so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified,
        /// the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointTypes`.
    ///
    /// <p>Returns information about the type of endpoints available.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpointTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_types_input::Builder,
    }
    impl<C, M, R> DescribeEndpointTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpointTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointTypesInputOperationOutputAlias,
                crate::output::DescribeEndpointTypesOutput,
                crate::error::DescribeEndpointTypesError,
                crate::input::DescribeEndpointTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the endpoint types.</p>
        /// <p>Valid filter names: engine-name | endpoint-type</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to the endpoint types.</p>
        /// <p>Valid filter names: engine-name | endpoint-type</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Lists categories for all event source types, or, if specified, for a specified source
    /// type. You can see a list of the event categories and source types in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events
    /// and Notifications</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventCategories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl<C, M, R> DescribeEventCategories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventCategoriesInputOperationOutputAlias,
                crate::output::DescribeEventCategoriesOutput,
                crate::error::DescribeEventCategoriesError,
                crate::input::DescribeEventCategoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p> The type of DMS resource that generates events. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the event categories.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to the event categories.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p> Lists events for a given source identifier and source type. You can also specify a
    /// start and end time. For more information on DMS events, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
    /// Notifications</a> in the <i>Database Migration Service User
    /// Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p> The identifier of an event source.</p>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p> The identifier of an event source.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The type of DMS resource that generates events.</p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of DMS resource that generates events.</p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The start time for the events to be listed.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time for the events to be listed.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time for the events to be listed.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time for the events to be listed.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The duration of the events to be listed.</p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The duration of the events to be listed.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories for the source type that you've chosen.</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p>A list of event categories for the source type that you've chosen.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to events.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to events.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists all the event subscriptions for a customer account. The description of a
    /// subscription includes <code>SubscriptionName</code>, <code>SNSTopicARN</code>,
    /// <code>CustomerID</code>, <code>SourceType</code>, <code>SourceID</code>,
    /// <code>CreationTime</code>, and <code>Status</code>. </p>
    /// <p>If you specify <code>SubscriptionName</code>, this action lists the description for that
    /// subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeEventSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeEventSubscriptionsOutput,
                crate::error::DescribeEventSubscriptionsError,
                crate::input::DescribeEventSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DMS event subscription to be described.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the DMS event subscription to be described.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to event subscriptions.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to event subscriptions.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableReplicationInstances`.
    ///
    /// <p>Returns information about the replication instance types that can be created in the
    /// specified region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrderableReplicationInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_orderable_replication_instances_input::Builder,
    }
    impl<C, M, R> DescribeOrderableReplicationInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrderableReplicationInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableReplicationInstancesOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeOrderableReplicationInstancesError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrderableReplicationInstancesInputOperationOutputAlias,
                crate::output::DescribeOrderableReplicationInstancesOutput,
                crate::error::DescribeOrderableReplicationInstancesError,
                crate::input::DescribeOrderableReplicationInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePendingMaintenanceActions`.
    ///
    /// <p>For internal use only</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePendingMaintenanceActions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_pending_maintenance_actions_input::Builder,
    }
    impl<C, M, R> DescribePendingMaintenanceActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePendingMaintenanceActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePendingMaintenanceActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePendingMaintenanceActionsInputOperationOutputAlias,
                crate::output::DescribePendingMaintenanceActionsOutput,
                crate::error::DescribePendingMaintenanceActionsError,
                crate::input::DescribePendingMaintenanceActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p></p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p></p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRefreshSchemasStatus`.
    ///
    /// <p>Returns the status of the RefreshSchemas operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRefreshSchemasStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_refresh_schemas_status_input::Builder,
    }
    impl<C, M, R> DescribeRefreshSchemasStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRefreshSchemasStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRefreshSchemasStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRefreshSchemasStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRefreshSchemasStatusInputOperationOutputAlias,
                crate::output::DescribeRefreshSchemasStatusOutput,
                crate::error::DescribeRefreshSchemasStatusError,
                crate::input::DescribeRefreshSchemasStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationInstances`.
    ///
    /// <p>Returns information about replication instances for your account in the current
    /// region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_instances_input::Builder,
    }
    impl<C, M, R> DescribeReplicationInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationInstancesInputOperationOutputAlias,
                crate::output::DescribeReplicationInstancesOutput,
                crate::error::DescribeReplicationInstancesError,
                crate::input::DescribeReplicationInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication instances.</p>
        /// <p>Valid filter names: replication-instance-arn | replication-instance-id |
        /// replication-instance-class | engine-version</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to replication instances.</p>
        /// <p>Valid filter names: replication-instance-arn | replication-instance-id |
        /// replication-instance-class | engine-version</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationInstanceTaskLogs`.
    ///
    /// <p>Returns information about the task logs for the specified task.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationInstanceTaskLogs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_instance_task_logs_input::Builder,
    }
    impl<C, M, R> DescribeReplicationInstanceTaskLogs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationInstanceTaskLogs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationInstanceTaskLogsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationInstanceTaskLogsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationInstanceTaskLogsInputOperationOutputAlias,
                crate::output::DescribeReplicationInstanceTaskLogsOutput,
                crate::error::DescribeReplicationInstanceTaskLogsError,
                crate::input::DescribeReplicationInstanceTaskLogsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationSubnetGroups`.
    ///
    /// <p>Returns information about the replication subnet groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationSubnetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_subnet_groups_input::Builder,
    }
    impl<C, M, R> DescribeReplicationSubnetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationSubnetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationSubnetGroupsInputOperationOutputAlias,
                crate::output::DescribeReplicationSubnetGroupsOutput,
                crate::error::DescribeReplicationSubnetGroupsError,
                crate::input::DescribeReplicationSubnetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication subnet groups.</p>
        /// <p>Valid filter names: replication-subnet-group-id</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to replication subnet groups.</p>
        /// <p>Valid filter names: replication-subnet-group-id</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTaskAssessmentResults`.
    ///
    /// <p>Returns the task assessment results from the Amazon S3 bucket that DMS creates in your
    /// Amazon Web Services account.  This action always returns the
    /// latest results.</p>
    /// <p>For more information about DMS task assessments, see  
    /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task assessment report</a>
    /// in the <a href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html">
    /// Database Migration Service User Guide</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationTaskAssessmentResults<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_task_assessment_results_input::Builder,
    }
    impl<C, M, R> DescribeReplicationTaskAssessmentResults<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationTaskAssessmentResults`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTaskAssessmentResultsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationTaskAssessmentResultsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationTaskAssessmentResultsInputOperationOutputAlias,
                crate::output::DescribeReplicationTaskAssessmentResultsOutput,
                crate::error::DescribeReplicationTaskAssessmentResultsError,
                crate::input::DescribeReplicationTaskAssessmentResultsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input
        /// parameter is specified, the API returns only one result and ignore the values of the
        /// <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the task. When this input
        /// parameter is specified, the API returns only one result and ignore the values of the
        /// <code>MaxRecords</code> and <code>Marker</code> parameters. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTaskAssessmentRuns`.
    ///
    /// <p>Returns a paginated list of premigration assessment runs based on filter
    /// settings.</p>
    /// <p>These filter settings can specify a combination of premigration assessment runs,
    /// migration tasks, replication instances, and assessment run status values.</p>
    /// <note>
    /// <p>This operation doesn't return information about individual assessments. For this
    /// information, see the <code>DescribeReplicationTaskIndividualAssessments</code>
    /// operation. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationTaskAssessmentRuns<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_task_assessment_runs_input::Builder,
    }
    impl<C, M, R> DescribeReplicationTaskAssessmentRuns<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationTaskAssessmentRuns`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTaskAssessmentRunsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationTaskAssessmentRunsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationTaskAssessmentRunsInputOperationOutputAlias,
                crate::output::DescribeReplicationTaskAssessmentRunsOutput,
                crate::error::DescribeReplicationTaskAssessmentRunsError,
                crate::input::DescribeReplicationTaskAssessmentRunsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>,
        /// <code>replication-instance-arn</code>, <code>status</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to the premigration assessment runs described in the form of key-value pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>, <code>replication-task-arn</code>,
        /// <code>replication-instance-arn</code>, <code>status</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTaskIndividualAssessments`.
    ///
    /// <p>Returns a paginated list of individual assessments based on filter settings.</p>
    /// <p>These filter settings can specify a combination of premigration assessment runs,
    /// migration tasks, and assessment status values.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationTaskIndividualAssessments<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_task_individual_assessments_input::Builder,
    }
    impl<C, M, R> DescribeReplicationTaskIndividualAssessments<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationTaskIndividualAssessments`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTaskIndividualAssessmentsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReplicationTaskIndividualAssessmentsError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationTaskIndividualAssessmentsInputOperationOutputAlias,
                crate::output::DescribeReplicationTaskIndividualAssessmentsOutput,
                crate::error::DescribeReplicationTaskIndividualAssessmentsError,
                crate::input::DescribeReplicationTaskIndividualAssessmentsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to the individual assessments described in the form of key-value
        /// pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>,
        /// <code>replication-task-arn</code>, <code>status</code>
        /// </p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to the individual assessments described in the form of key-value
        /// pairs.</p>
        /// <p>Valid filter names: <code>replication-task-assessment-run-arn</code>,
        /// <code>replication-task-arn</code>, <code>status</code>
        /// </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the
        /// specified <code>MaxRecords</code> value, a pagination token called a marker is included in
        /// the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReplicationTasks`.
    ///
    /// <p>Returns information about replication tasks for your account in the current
    /// region.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReplicationTasks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_replication_tasks_input::Builder,
    }
    impl<C, M, R> DescribeReplicationTasks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReplicationTasks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReplicationTasksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReplicationTasksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReplicationTasksInputOperationOutputAlias,
                crate::output::DescribeReplicationTasksOutput,
                crate::error::DescribeReplicationTasksError,
                crate::input::DescribeReplicationTasksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to replication tasks.</p>
        /// <p>Valid filter names: replication-task-arn | replication-task-id | migration-type |
        /// endpoint-arn | replication-instance-arn</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to replication tasks.</p>
        /// <p>Valid filter names: replication-task-arn | replication-task-id | migration-type |
        /// endpoint-arn | replication-instance-arn</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>An option to set to avoid returning information about settings. Use this to reduce
        /// overhead when setting information is too large. To use this option, choose
        /// <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
        pub fn without_settings(mut self, inp: bool) -> Self {
            self.inner = self.inner.without_settings(inp);
            self
        }
        /// <p>An option to set to avoid returning information about settings. Use this to reduce
        /// overhead when setting information is too large. To use this option, choose
        /// <code>true</code>; otherwise, choose <code>false</code> (the default).</p>
        pub fn set_without_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_without_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSchemas`.
    ///
    /// <p>Returns information about the schema for the specified endpoint.</p>
    ///
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSchemas<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_schemas_input::Builder,
    }
    impl<C, M, R> DescribeSchemas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSchemas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSchemasOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSchemasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSchemasInputOperationOutputAlias,
                crate::output::DescribeSchemasOutput,
                crate::error::DescribeSchemasError,
                crate::input::DescribeSchemasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTableStatistics`.
    ///
    /// <p>Returns table statistics on the database migration task, including table name, rows
    /// inserted, rows updated, and rows deleted.</p>
    /// <p>Note that the "last updated" column the DMS console only indicates the time that DMS
    /// last updated the table statistics record for a table. It does not indicate the time of the
    /// last update to the table.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTableStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_table_statistics_input::Builder,
    }
    impl<C, M, R> DescribeTableStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTableStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTableStatisticsInputOperationOutputAlias,
                crate::output::DescribeTableStatisticsOutput,
                crate::error::DescribeTableStatisticsError,
                crate::input::DescribeTableStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 500.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p> The maximum number of records to include in the response. If more records exist than
        /// the specified <code>MaxRecords</code> value, a pagination token called a marker is included
        /// in the response so that the remaining results can be retrieved. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 500.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p> An optional pagination token provided by a previous request. If this parameter is
        /// specified, the response includes only records beyond the marker, up to the value specified
        /// by <code>MaxRecords</code>. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters applied to table statistics.</p>
        /// <p>Valid filter names: schema-name | table-name | table-state</p>
        /// <p>A combination of filters creates an AND condition where each record matches all
        /// specified filters.</p>
        pub fn filters(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>Filters applied to table statistics.</p>
        /// <p>Valid filter names: schema-name | table-name | table-state</p>
        /// <p>A combination of filters creates an AND condition where each record matches all
        /// specified filters.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ImportCertificate`.
    ///
    /// <p>Uploads the specified certificate.</p>
    #[derive(std::fmt::Debug)]
    pub struct ImportCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::import_certificate_input::Builder,
    }
    impl<C, M, R> ImportCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ImportCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ImportCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::ImportCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ImportCertificateInputOperationOutputAlias,
                crate::output::ImportCertificateOutput,
                crate::error::ImportCertificateError,
                crate::input::ImportCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
        /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        pub fn certificate_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_identifier(inp);
            self
        }
        /// <p>A customer-assigned name for the certificate. Identifiers must begin with a letter and
        /// must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or
        /// contain two consecutive hyphens.</p>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_identifier(input);
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn certificate_pem(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_pem(inp);
            self
        }
        /// <p>The contents of a <code>.pem</code> file, which contains an X.509 certificate.</p>
        pub fn set_certificate_pem(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_pem(input);
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file
        /// using the <code>fileb://</code> prefix. You can't provide the certificate inline.
        /// </p>
        pub fn certificate_wallet(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.certificate_wallet(inp);
            self
        }
        /// <p>The location of an imported Oracle Wallet certificate for use with SSL. Provide the name of a <code>.sso</code> file
        /// using the <code>fileb://</code> prefix. You can't provide the certificate inline.
        /// </p>
        pub fn set_certificate_wallet(
            mut self,
            input: std::option::Option<aws_smithy_types::Blob>,
        ) -> Self {
            self.inner = self.inner.set_certificate_wallet(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags associated with the certificate.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The tags associated with the certificate.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists all metadata tags attached to an DMS resource, including
    /// replication instance, endpoint, security group, and migration task.
    /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
    /// <code>Tag</code>
    /// </a> data type description.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to
        /// list tags for. This returns a list of keys (names of tags) created for the resource and
        /// their associated tag values.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to
        /// list tags for. This returns a list of keys (names of tags) created for the resource and
        /// their associated tag values.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `ResourceArnList`.
        ///
        /// To override the contents of this collection use [`set_resource_arn_list`](Self::set_resource_arn_list).
        ///
        /// <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This
        /// returns a list of keys (tag names) and their associated tag values. It also returns each
        /// tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which
        /// each listed tag is created. </p>
        pub fn resource_arn_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn_list(inp);
            self
        }
        /// <p>List of ARNs that identify multiple DMS resources that you want to list tags for. This
        /// returns a list of keys (tag names) and their associated tag values. It also returns each
        /// tag's associated <code>ResourceArn</code> value, which is the ARN of the resource for which
        /// each listed tag is created. </p>
        pub fn set_resource_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_resource_arn_list(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEndpoint`.
    ///
    /// <p>Modifies the specified endpoint.</p>
    /// <note>
    /// <p>For a MySQL source or target endpoint, don't explicitly specify the database using
    /// the <code>DatabaseName</code> request parameter on the <code>ModifyEndpoint</code> API call.
    /// Specifying <code>DatabaseName</code> when you modify a MySQL endpoint replicates all the
    /// task tables to this single database. For MySQL endpoints, you specify the database only when
    /// you specify the schema in the table-mapping rules of the DMS task.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct ModifyEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_endpoint_input::Builder,
    }
    impl<C, M, R> ModifyEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyEndpointInputOperationOutputAlias,
                crate::output::ModifyEndpointOutput,
                crate::error::ModifyEndpointError,
                crate::input::ModifyEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn endpoint_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_identifier(inp);
            self
        }
        /// <p>The database endpoint identifier. Identifiers must begin with a letter and must contain
        /// only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two
        /// consecutive hyphens.</p>
        pub fn set_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_identifier(input);
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn endpoint_type(mut self, inp: crate::model::ReplicationEndpointTypeValue) -> Self {
            self.inner = self.inner.endpoint_type(inp);
            self
        }
        /// <p>The type of endpoint.  Valid values are <code>source</code> and <code>target</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<crate::model::ReplicationEndpointTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the EndpointType,
        /// include
        /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
        /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>,
        /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
        /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
        /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn engine_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_name(inp);
            self
        }
        /// <p>The type of engine for the endpoint. Valid values, depending on the EndpointType,
        /// include
        /// <code>"mysql"</code>, <code>"oracle"</code>, <code>"postgres"</code>,
        /// <code>"mariadb"</code>, <code>"aurora"</code>, <code>"aurora-postgresql"</code>,
        /// <code>"redshift"</code>, <code>"s3"</code>, <code>"db2"</code>, <code>"azuredb"</code>,
        /// <code>"sybase"</code>, <code>"dynamodb"</code>, <code>"mongodb"</code>,
        /// <code>"kinesis"</code>, <code>"kafka"</code>, <code>"elasticsearch"</code>,
        /// <code>"documentdb"</code>, <code>"sqlserver"</code>, and <code>"neptune"</code>.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_name(input);
            self
        }
        /// <p>The user name to be used to login to the endpoint database.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The user name to be used to login to the endpoint database.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password to be used to login to the endpoint database.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password to be used to login to the endpoint database.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn server_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.server_name(inp);
            self
        }
        /// <p>The name of the server where the endpoint database resides.</p>
        pub fn set_server_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_server_name(input);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port used by the endpoint database.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the endpoint database. For a MySQL source or target endpoint, do not specify DatabaseName.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>Additional attributes associated with the connection. To reset this parameter, pass the
        /// empty string ("") as an argument.</p>
        pub fn extra_connection_attributes(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.extra_connection_attributes(inp);
            self
        }
        /// <p>Additional attributes associated with the connection. To reset this parameter, pass the
        /// empty string ("") as an argument.</p>
        pub fn set_extra_connection_attributes(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_extra_connection_attributes(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
        pub fn certificate_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.certificate_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the certificate used for SSL connection.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_certificate_arn(input);
            self
        }
        /// <p>The SSL mode used to connect to the endpoint.  The default value is <code>none</code>.</p>
        pub fn ssl_mode(mut self, inp: crate::model::DmsSslModeValue) -> Self {
            self.inner = self.inner.ssl_mode(inp);
            self
        }
        /// <p>The SSL mode used to connect to the endpoint.  The default value is <code>none</code>.</p>
        pub fn set_ssl_mode(
            mut self,
            input: std::option::Option<crate::model::DmsSslModeValue>,
        ) -> Self {
            self.inner = self.inner.set_ssl_mode(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify
        /// the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_access_role_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for the IAM role you want to use to modify
        /// the endpoint. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_access_role_arn(input);
            self
        }
        /// <p>The external table definition.</p>
        pub fn external_table_definition(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.external_table_definition(inp);
            self
        }
        /// <p>The external table definition.</p>
        pub fn set_external_table_definition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_external_table_definition(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn dynamo_db_settings(mut self, inp: crate::model::DynamoDbSettings) -> Self {
            self.inner = self.inner.dynamo_db_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Amazon DynamoDB endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping">Using Object Mapping to Migrate
        /// Data to DynamoDB</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_dynamo_db_settings(
            mut self,
            input: std::option::Option<crate::model::DynamoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_dynamo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn s3_settings(mut self, inp: crate::model::S3Settings) -> Self {
            self.inner = self.inner.s3_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Amazon S3 endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring">Extra
        /// Connection Attributes When Using Amazon S3 as a Target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_s3_settings(
            mut self,
            input: std::option::Option<crate::model::S3Settings>,
        ) -> Self {
            self.inner = self.inner.set_s3_settings(input);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Attributes include the following:</p>
        /// <ul>
        /// <li>
        /// <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>BucketName - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string
        /// ,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string",
        /// "BucketName": "string"} </code>
        /// </p>
        pub fn dms_transfer_settings(mut self, inp: crate::model::DmsTransferSettings) -> Self {
            self.inner = self.inner.dms_transfer_settings(inp);
            self
        }
        /// <p>The settings in JSON format for the DMS transfer type of source endpoint. </p>
        /// <p>Attributes include the following:</p>
        /// <ul>
        /// <li>
        /// <p>serviceAccessRoleArn - The Amazon Resource Name (ARN) used by the service access IAM role. The role must allow the <code>iam:PassRole</code> action.</p>
        /// </li>
        /// <li>
        /// <p>BucketName - The name of the S3 bucket to use.</p>
        /// </li>
        /// </ul>
        /// <p>Shorthand syntax for these settings is as follows: <code>ServiceAccessRoleArn=string
        /// ,BucketName=string</code>
        /// </p>
        /// <p>JSON syntax for these settings is as follows: <code>{ "ServiceAccessRoleArn": "string",
        /// "BucketName": "string"} </code>
        /// </p>
        pub fn set_dms_transfer_settings(
            mut self,
            input: std::option::Option<crate::model::DmsTransferSettings>,
        ) -> Self {
            self.inner = self.inner.set_dms_transfer_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn mongo_db_settings(mut self, inp: crate::model::MongoDbSettings) -> Self {
            self.inner = self.inner.mongo_db_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source MongoDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration">Endpoint configuration settings
        /// when using MongoDB as a source for Database Migration Service</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_mongo_db_settings(
            mut self,
            input: std::option::Option<crate::model::MongoDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_mongo_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn kinesis_settings(mut self, inp: crate::model::KinesisSettings) -> Self {
            self.inner = self.inner.kinesis_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams. For
        /// more information about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping">Using object mapping to
        /// migrate data to a Kinesis data stream</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_kinesis_settings(
            mut self,
            input: std::option::Option<crate::model::KinesisSettings>,
        ) -> Self {
            self.inner = self.inner.set_kinesis_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn kafka_settings(mut self, inp: crate::model::KafkaSettings) -> Self {
            self.inner = self.inner.kafka_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Apache Kafka endpoint. For more information about
        /// the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping">Using object mapping
        /// to migrate data to a Kafka topic</a> in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_kafka_settings(
            mut self,
            input: std::option::Option<crate::model::KafkaSettings>,
        ) -> Self {
            self.inner = self.inner.set_kafka_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn elasticsearch_settings(mut self, inp: crate::model::ElasticsearchSettings) -> Self {
            self.inner = self.inner.elasticsearch_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Elasticsearch endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration">Extra Connection Attributes When Using Elasticsearch as a Target for DMS</a> in
        /// the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_elasticsearch_settings(
            mut self,
            input: std::option::Option<crate::model::ElasticsearchSettings>,
        ) -> Self {
            self.inner = self.inner.set_elasticsearch_settings(input);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn neptune_settings(mut self, inp: crate::model::NeptuneSettings) -> Self {
            self.inner = self.inner.neptune_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the target Amazon Neptune endpoint. For more information
        /// about the available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings">Specifying graph-mapping rules using Gremlin and R2RML for Amazon Neptune as a target</a>
        /// in the <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_neptune_settings(
            mut self,
            input: std::option::Option<crate::model::NeptuneSettings>,
        ) -> Self {
            self.inner = self.inner.set_neptune_settings(input);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn redshift_settings(mut self, inp: crate::model::RedshiftSettings) -> Self {
            self.inner = self.inner.redshift_settings(inp);
            self
        }
        /// <p>Provides information that defines an Amazon Redshift endpoint.</p>
        pub fn set_redshift_settings(
            mut self,
            input: std::option::Option<crate::model::RedshiftSettings>,
        ) -> Self {
            self.inner = self.inner.set_redshift_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn postgre_sql_settings(mut self, inp: crate::model::PostgreSqlSettings) -> Self {
            self.inner = self.inner.postgre_sql_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target PostgreSQL endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra connection
        /// attributes when using PostgreSQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib">
        /// Extra connection attributes when using PostgreSQL as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_postgre_sql_settings(
            mut self,
            input: std::option::Option<crate::model::PostgreSqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_postgre_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection
        /// attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra
        /// connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn my_sql_settings(mut self, inp: crate::model::MySqlSettings) -> Self {
            self.inner = self.inner.my_sql_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target MySQL endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib">Extra connection
        /// attributes when using MySQL as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib">Extra
        /// connection attributes when using a MySQL-compatible database as a target for DMS</a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_my_sql_settings(
            mut self,
            input: std::option::Option<crate::model::MySqlSettings>,
        ) -> Self {
            self.inner = self.inner.set_my_sql_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection
        /// attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn oracle_settings(mut self, inp: crate::model::OracleSettings) -> Self {
            self.inner = self.inner.oracle_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target Oracle endpoint. For information about
        /// other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib">Extra connection
        /// attributes when using Oracle as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib">
        /// Extra connection attributes when using Oracle as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_oracle_settings(
            mut self,
            input: std::option::Option<crate::model::OracleSettings>,
        ) -> Self {
            self.inner = self.inner.set_oracle_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn sybase_settings(mut self, inp: crate::model::SybaseSettings) -> Self {
            self.inner = self.inner.sybase_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target SAP ASE endpoint. For information
        /// about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib">Extra connection attributes
        /// when using SAP ASE as a target for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_sybase_settings(
            mut self,
            input: std::option::Option<crate::model::SybaseSettings>,
        ) -> Self {
            self.inner = self.inner.set_sybase_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn microsoft_sql_server_settings(
            mut self,
            inp: crate::model::MicrosoftSqlServerSettings,
        ) -> Self {
            self.inner = self.inner.microsoft_sql_server_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source and target Microsoft SQL Server endpoint. For
        /// information about other available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib">Extra connection
        /// attributes when using SQL Server as a source for DMS</a> and <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib">
        /// Extra connection attributes when using SQL Server as a target for DMS</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_microsoft_sql_server_settings(
            mut self,
            input: std::option::Option<crate::model::MicrosoftSqlServerSettings>,
        ) -> Self {
            self.inner = self.inner.set_microsoft_sql_server_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn ibm_db2_settings(mut self, inp: crate::model::IbmDb2Settings) -> Self {
            self.inner = self.inner.ibm_db2_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source IBM Db2 LUW endpoint. For information about other
        /// available settings, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib">Extra connection attributes
        /// when using Db2 LUW as a source for DMS</a> in the <i>Database Migration Service
        /// User Guide.</i>
        /// </p>
        pub fn set_ibm_db2_settings(
            mut self,
            input: std::option::Option<crate::model::IbmDb2Settings>,
        ) -> Self {
            self.inner = self.inner.set_ibm_db2_settings(input);
            self
        }
        /// <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service
        /// </a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn doc_db_settings(mut self, inp: crate::model::DocDbSettings) -> Self {
            self.inner = self.inner.doc_db_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the source DocumentDB endpoint. For more information about the
        /// available settings, see the configuration properties section in <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html"> Using DocumentDB as a Target for Database Migration Service
        /// </a> in the <i>Database Migration Service User
        /// Guide.</i>
        /// </p>
        pub fn set_doc_db_settings(
            mut self,
            input: std::option::Option<crate::model::DocDbSettings>,
        ) -> Self {
            self.inner = self.inner.set_doc_db_settings(input);
            self
        }
        /// <p>Settings in JSON format for the Redis target endpoint.</p>
        pub fn redis_settings(mut self, inp: crate::model::RedisSettings) -> Self {
            self.inner = self.inner.redis_settings(inp);
            self
        }
        /// <p>Settings in JSON format for the Redis target endpoint.</p>
        pub fn set_redis_settings(
            mut self,
            input: std::option::Option<crate::model::RedisSettings>,
        ) -> Self {
            self.inner = self.inner.set_redis_settings(input);
            self
        }
        /// <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all
        /// existing endpoint settings with the exact settings that you specify in this call. If this
        /// attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>
        /// <ul>
        /// <li>
        /// <p>It replaces any endpoint settings that already exist with new values, for settings with the
        /// same names.</p>
        /// </li>
        /// <li>
        /// <p>It creates new endpoint settings that you specify in the call, for settings with different
        /// names. </p>
        /// </li>
        /// </ul>
        /// <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}'
        /// ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If
        /// you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the
        /// same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>
        /// <p>However, suppose that you follow this with a call to <code>modify-endpoint ...
        /// --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again.
        /// Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings
        /// are replaced with the exact settings that you specify. </p>
        pub fn exact_settings(mut self, inp: bool) -> Self {
            self.inner = self.inner.exact_settings(inp);
            self
        }
        /// <p>If this attribute is Y, the current call to <code>ModifyEndpoint</code> replaces all
        /// existing endpoint settings with the exact settings that you specify in this call. If this
        /// attribute is N, the current call to <code>ModifyEndpoint</code> does two things: </p>
        /// <ul>
        /// <li>
        /// <p>It replaces any endpoint settings that already exist with new values, for settings with the
        /// same names.</p>
        /// </li>
        /// <li>
        /// <p>It creates new endpoint settings that you specify in the call, for settings with different
        /// names. </p>
        /// </li>
        /// </ul>
        /// <p>For example, if you call <code>create-endpoint ... --endpoint-settings '{"a":1}'
        /// ...</code>, the endpoint has the following endpoint settings: <code>'{"a":1}'</code>. If
        /// you then call <code>modify-endpoint ... --endpoint-settings '{"b":2}' ...</code> for the
        /// same endpoint, the endpoint has the following settings: <code>'{"a":1,"b":2}'</code>. </p>
        /// <p>However, suppose that you follow this with a call to <code>modify-endpoint ...
        /// --endpoint-settings '{"b":2}' --exact-settings ...</code> for that same endpoint again.
        /// Then the endpoint has the following settings: <code>'{"b":2}'</code>. All existing settings
        /// are replaced with the exact settings that you specify. </p>
        pub fn set_exact_settings(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_exact_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEventSubscription`.
    ///
    /// <p>Modifies an existing DMS event notification subscription. </p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_event_subscription_input::Builder,
    }
    impl<C, M, R> ModifyEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyEventSubscriptionInputOperationOutputAlias,
                crate::output::ModifyEventSubscriptionOutput,
                crate::error::ModifyEventSubscriptionError,
                crate::input::ModifyEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DMS event notification subscription to be modified.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the DMS event notification subscription to be modified.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the Amazon SNS topic created for event notification.
        /// The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p> The type of DMS resource that generates the events you want to subscribe to. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p> The type of DMS resource that generates the events you want to subscribe to. </p>
        /// <p>Valid values: replication-instance | replication-task</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p> A list of event categories for a source type that you want to subscribe to. Use the
        /// <code>DescribeEventCategories</code> action to see a list of event categories. </p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p> A list of event categories for a source type that you want to subscribe to. Use the
        /// <code>DescribeEventCategories</code> action to see a list of event categories. </p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription. </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p> A Boolean value; set to <b>true</b> to activate the
        /// subscription. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationInstance`.
    ///
    /// <p>Modifies the replication instance to apply new settings. You can change one or more
    /// parameters by specifying these parameters and the new values in the request.</p>
    /// <p>Some settings are applied during the maintenance window.</p>
    ///
    /// <p></p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyReplicationInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_replication_instance_input::Builder,
    }
    impl<C, M, R> ModifyReplicationInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyReplicationInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyReplicationInstanceInputOperationOutputAlias,
                crate::output::ModifyReplicationInstanceOutput,
                crate::error::ModifyReplicationInstanceError,
                crate::input::ModifyReplicationInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be allocated for the replication
        /// instance.</p>
        pub fn allocated_storage(mut self, inp: i32) -> Self {
            self.inner = self.inner.allocated_storage(inp);
            self
        }
        /// <p>The amount of storage (in gigabytes) to be allocated for the replication
        /// instance.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>Indicates whether the changes should be applied immediately or during the next
        /// maintenance window.</p>
        pub fn apply_immediately(mut self, inp: bool) -> Self {
            self.inner = self.inner.apply_immediately(inp);
            self
        }
        /// <p>Indicates whether the changes should be applied immediately or during the next
        /// maintenance window.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_apply_immediately(input);
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn replication_instance_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_class(inp);
            self
        }
        /// <p>The compute and memory capacity of the replication instance as defined for the specified
        /// replication instance class. For example to specify the instance class dms.c4.large, set this parameter to <code>"dms.c4.large"</code>.</p>
        /// <p>For more information on the settings and capacities for the available replication instance classes, see
        /// <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth">
        /// Selecting the right DMS replication instance for your migration</a>.
        /// </p>
        pub fn set_replication_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_class(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p> Specifies the VPC security group to be used with the replication instance. The VPC
        /// security group must work with the VPC containing the replication instance. </p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter does not result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// moving this window to the current time, there must be at least 30 minutes between the
        /// current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, which might
        /// result in an outage. Changing this parameter does not result in an outage, except in the
        /// following situation, and the change is asynchronously applied as soon as possible. If
        /// moving this window to the current time, there must be at least 30 minutes between the
        /// current time and end of the window to ensure pending changes are applied.</p>
        /// <p>Default: Uses existing setting</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn multi_az(mut self, inp: bool) -> Self {
            self.inner = self.inner.multi_az(inp);
            self
        }
        /// <p> Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
        /// <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to
        /// <code>true</code>. </p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>When modifying a major engine version of an instance, also set
        /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn engine_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(inp);
            self
        }
        /// <p>The engine version number of the replication instance.</p>
        /// <p>When modifying a major engine version of an instance, also set
        /// <code>AllowMajorVersionUpgrade</code> to <code>true</code>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter does not
        /// result in an outage, and the change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter must be set to <code>true</code> when specifying a value for the
        /// <code>EngineVersion</code> parameter that is a different major version than the
        /// replication instance's current version.</p>
        pub fn allow_major_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_major_version_upgrade(inp);
            self
        }
        /// <p>Indicates that major version upgrades are allowed. Changing this parameter does not
        /// result in an outage, and the change is asynchronously applied as soon as possible.</p>
        /// <p>This parameter must be set to <code>true</code> when specifying a value for the
        /// <code>EngineVersion</code> parameter that is a different major version than the
        /// replication instance's current version.</p>
        pub fn set_allow_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_major_version_upgrade(input);
            self
        }
        /// <p>A value that indicates that minor version upgrades are applied automatically to the
        /// replication instance during the maintenance window. Changing this parameter doesn't result
        /// in an outage, except in the case described following. The change is asynchronously applied
        /// as soon as possible. </p>
        /// <p>An outage does result if these factors apply: </p>
        /// <ul>
        /// <li>
        /// <p>This parameter is set to <code>true</code> during the maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>A newer minor version is available. </p>
        /// </li>
        /// <li>
        /// <p>DMS has enabled automatic patching for the given engine version. </p>
        /// </li>
        /// </ul>
        pub fn auto_minor_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(inp);
            self
        }
        /// <p>A value that indicates that minor version upgrades are applied automatically to the
        /// replication instance during the maintenance window. Changing this parameter doesn't result
        /// in an outage, except in the case described following. The change is asynchronously applied
        /// as soon as possible. </p>
        /// <p>An outage does result if these factors apply: </p>
        /// <ul>
        /// <li>
        /// <p>This parameter is set to <code>true</code> during the maintenance window.</p>
        /// </li>
        /// <li>
        /// <p>A newer minor version is available. </p>
        /// </li>
        /// <li>
        /// <p>DMS has enabled automatic patching for the given engine version. </p>
        /// </li>
        /// </ul>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        pub fn replication_instance_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_instance_identifier(inp);
            self
        }
        /// <p>The replication instance identifier. This parameter is stored as a lowercase
        /// string.</p>
        pub fn set_replication_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationSubnetGroup`.
    ///
    /// <p>Modifies the settings for the specified replication subnet group.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyReplicationSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_replication_subnet_group_input::Builder,
    }
    impl<C, M, R> ModifyReplicationSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyReplicationSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyReplicationSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyReplicationSubnetGroupInputOperationOutputAlias,
                crate::output::ModifyReplicationSubnetGroupOutput,
                crate::error::ModifyReplicationSubnetGroupError,
                crate::input::ModifyReplicationSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the replication instance subnet group.</p>
        pub fn replication_subnet_group_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_identifier(inp);
            self
        }
        /// <p>The name of the replication instance subnet group.</p>
        pub fn set_replication_subnet_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_identifier(input);
            self
        }
        /// <p>A description for the replication instance subnet group.</p>
        pub fn replication_subnet_group_description(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_subnet_group_description(inp);
            self
        }
        /// <p>A description for the replication instance subnet group.</p>
        pub fn set_replication_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_subnet_group_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>A list of subnet IDs.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>A list of subnet IDs.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyReplicationTask`.
    ///
    /// <p>Modifies the specified replication task.</p>
    /// <p>You can't modify the task endpoints. The task must be stopped before you can modify it. </p>
    /// <p>For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
    /// <i>Database Migration Service User Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyReplicationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_replication_task_input::Builder,
    }
    impl<C, M, R> ModifyReplicationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyReplicationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyReplicationTaskInputOperationOutputAlias,
                crate::output::ModifyReplicationTaskOutput,
                crate::error::ModifyReplicationTaskError,
                crate::input::ModifyReplicationTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>The replication task identifier.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn replication_task_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_identifier(inp);
            self
        }
        /// <p>The replication task identifier.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1-255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_replication_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_identifier(input);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn migration_type(mut self, inp: crate::model::MigrationTypeValue) -> Self {
            self.inner = self.inner.migration_type(inp);
            self
        }
        /// <p>The migration type. Valid values: <code>full-load</code> | <code>cdc</code> | <code>full-load-and-cdc</code>
        /// </p>
        pub fn set_migration_type(
            mut self,
            input: std::option::Option<crate::model::MigrationTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_migration_type(input);
            self
        }
        /// <p>When using the CLI or boto3, provide the path of the JSON file that contains the
        /// table mappings. Precede the path with <code>file://</code>.  For example,
        /// <code>--table-mappings file://mappingfile.json</code>. When working with the DMS  API,
        /// provide the JSON as the parameter value.
        /// </p>
        pub fn table_mappings(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_mappings(inp);
            self
        }
        /// <p>When using the CLI or boto3, provide the path of the JSON file that contains the
        /// table mappings. Precede the path with <code>file://</code>.  For example,
        /// <code>--table-mappings file://mappingfile.json</code>. When working with the DMS  API,
        /// provide the JSON as the parameter value.
        /// </p>
        pub fn set_table_mappings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_mappings(input);
            self
        }
        /// <p>JSON file that contains settings for the task, such as task metadata settings.</p>
        pub fn replication_task_settings(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_settings(inp);
            self
        }
        /// <p>JSON file that contains settings for the task, such as task metadata settings.</p>
        pub fn set_replication_task_settings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_settings(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.cdc_start_time(inp);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_time(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_start_position(inp);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_position(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_stop_position(inp);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_stop_position(input);
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn task_data(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.task_data(inp);
            self
        }
        /// <p>Supplemental information that the task requires to migrate the data for certain source and target endpoints.
        /// For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html">Specifying Supplemental Data for Task Settings</a> in the
        /// <i>Database Migration Service User Guide.</i>
        /// </p>
        pub fn set_task_data(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_task_data(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MoveReplicationTask`.
    ///
    /// <p>Moves a replication task from its current replication instance to a different target
    /// replication instance using the specified parameters. The target replication instance must
    /// be created with the same or later DMS version as the current replication
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct MoveReplicationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::move_replication_task_input::Builder,
    }
    impl<C, M, R> MoveReplicationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MoveReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MoveReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::MoveReplicationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MoveReplicationTaskInputOperationOutputAlias,
                crate::output::MoveReplicationTaskOutput,
                crate::error::MoveReplicationTaskError,
                crate::input::MoveReplicationTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the task that you want to move.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>The ARN of the replication instance where you want to move the task to.</p>
        pub fn target_replication_instance_arn(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_replication_instance_arn(inp);
            self
        }
        /// <p>The ARN of the replication instance where you want to move the task to.</p>
        pub fn set_target_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootReplicationInstance`.
    ///
    /// <p>Reboots a replication instance. Rebooting results in a momentary outage, until the
    /// replication instance becomes available again.</p>
    #[derive(std::fmt::Debug)]
    pub struct RebootReplicationInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_replication_instance_input::Builder,
    }
    impl<C, M, R> RebootReplicationInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootReplicationInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootReplicationInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootReplicationInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootReplicationInstanceInputOperationOutputAlias,
                crate::output::RebootReplicationInstanceOutput,
                crate::error::RebootReplicationInstanceError,
                crate::input::RebootReplicationInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ
        /// failover. If the instance isn't configured for Multi-AZ, then you can't specify
        /// <code>true</code>.  ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn force_failover(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_failover(inp);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a Multi-AZ
        /// failover. If the instance isn't configured for Multi-AZ, then you can't specify
        /// <code>true</code>.  ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn set_force_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_failover(input);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover
        /// where resources are released and cleaned up prior to conducting the failover.
        /// If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>.
        /// ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn force_planned_failover(mut self, inp: bool) -> Self {
            self.inner = self.inner.force_planned_failover(inp);
            self
        }
        /// <p>If this parameter is <code>true</code>, the reboot is conducted through a planned Multi-AZ failover
        /// where resources are released and cleaned up prior to conducting the failover.
        /// If the instance isn''t configured for Multi-AZ, then you can't specify <code>true</code>.
        /// ( <code>--force-planned-failover</code> and <code>--force-failover</code> can't both be set to <code>true</code>.)</p>
        pub fn set_force_planned_failover(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force_planned_failover(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RefreshSchemas`.
    ///
    /// <p>Populates the schema for the specified endpoint. This is an asynchronous operation and
    /// can take several minutes. You can check the status of this operation by calling the
    /// DescribeRefreshSchemasStatus operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct RefreshSchemas<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::refresh_schemas_input::Builder,
    }
    impl<C, M, R> RefreshSchemas<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RefreshSchemas`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RefreshSchemasOutput,
            aws_smithy_http::result::SdkError<crate::error::RefreshSchemasError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RefreshSchemasInputOperationOutputAlias,
                crate::output::RefreshSchemasOutput,
                crate::error::RefreshSchemasError,
                crate::input::RefreshSchemasInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ReloadTables`.
    ///
    /// <p>Reloads the target database table with the source data. </p>
    /// <p>You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service
    /// will throw an <code>InvalidResourceStateFault</code> exception.</p>
    #[derive(std::fmt::Debug)]
    pub struct ReloadTables<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reload_tables_input::Builder,
    }
    impl<C, M, R> ReloadTables<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ReloadTables`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ReloadTablesOutput,
            aws_smithy_http::result::SdkError<crate::error::ReloadTablesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ReloadTablesInputOperationOutputAlias,
                crate::output::ReloadTablesOutput,
                crate::error::ReloadTablesError,
                crate::input::ReloadTablesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// Appends an item to `TablesToReload`.
        ///
        /// To override the contents of this collection use [`set_tables_to_reload`](Self::set_tables_to_reload).
        ///
        /// <p>The name and schema of the table to be reloaded. </p>
        pub fn tables_to_reload(mut self, inp: impl Into<crate::model::TableToReload>) -> Self {
            self.inner = self.inner.tables_to_reload(inp);
            self
        }
        /// <p>The name and schema of the table to be reloaded. </p>
        pub fn set_tables_to_reload(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableToReload>>,
        ) -> Self {
            self.inner = self.inner.set_tables_to_reload(input);
            self
        }
        /// <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate
        /// it if validation is enabled. Specify <code>validate-only</code> to re-validate the table.
        /// This option applies only when validation is enabled for the task. </p>
        /// <p>Valid values: data-reload, validate-only</p>
        /// <p>Default value is data-reload.</p>
        pub fn reload_option(mut self, inp: crate::model::ReloadOptionValue) -> Self {
            self.inner = self.inner.reload_option(inp);
            self
        }
        /// <p>Options for reload. Specify <code>data-reload</code> to reload the data and re-validate
        /// it if validation is enabled. Specify <code>validate-only</code> to re-validate the table.
        /// This option applies only when validation is enabled for the task. </p>
        /// <p>Valid values: data-reload, validate-only</p>
        /// <p>Default value is data-reload.</p>
        pub fn set_reload_option(
            mut self,
            input: std::option::Option<crate::model::ReloadOptionValue>,
        ) -> Self {
            self.inner = self.inner.set_reload_option(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveTagsFromResource`.
    ///
    /// <p>Removes metadata tags from an DMS resource, including replication instance,
    /// endpoint, security group, and migration task. For more information, see
    /// <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
    /// <code>Tag</code>
    /// </a>
    /// data type description.</p>
    #[derive(std::fmt::Debug)]
    pub struct RemoveTagsFromResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_tags_from_resource_input::Builder,
    }
    impl<C, M, R> RemoveTagsFromResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveTagsFromResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveTagsFromResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveTagsFromResourceInputOperationOutputAlias,
                crate::output::RemoveTagsFromResourceOutput,
                crate::error::RemoveTagsFromResourceError,
                crate::input::RemoveTagsFromResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>An DMS resource from which you want to remove tag(s). The value for this parameter is an Amazon Resource Name (ARN).</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key (name) of the tag to be removed.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplicationTask`.
    ///
    /// <p>Starts the replication task.</p>
    /// <p>For more information about DMS tasks, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
    /// <i>Database Migration Service User Guide.</i>
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct StartReplicationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_replication_task_input::Builder,
    }
    impl<C, M, R> StartReplicationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartReplicationTaskInputOperationOutputAlias,
                crate::output::StartReplicationTaskOutput,
                crate::error::StartReplicationTaskError,
                crate::input::StartReplicationTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication task to be started.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>A type of replication task.</p>
        pub fn start_replication_task_type(
            mut self,
            inp: crate::model::StartReplicationTaskTypeValue,
        ) -> Self {
            self.inner = self.inner.start_replication_task_type(inp);
            self
        }
        /// <p>A type of replication task.</p>
        pub fn set_start_replication_task_type(
            mut self,
            input: std::option::Option<crate::model::StartReplicationTaskTypeValue>,
        ) -> Self {
            self.inner = self.inner.set_start_replication_task_type(input);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn cdc_start_time(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.cdc_start_time(inp);
            self
        }
        /// <p>Indicates the start time for a change data capture (CDC) operation. Use either
        /// CdcStartTime or CdcStartPosition to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p>Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”</p>
        pub fn set_cdc_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_time(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn cdc_start_position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_start_position(inp);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to start. Use either
        /// CdcStartPosition or CdcStartTime to specify when you want a CDC operation to start.
        /// Specifying both values results in an error.</p>
        /// <p> The value can be in date, checkpoint, or LSN/SCN format.</p>
        /// <p>Date Example: --cdc-start-position “2018-03-08T12:12:12”</p>
        /// <p>Checkpoint Example: --cdc-start-position
        /// "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"</p>
        /// <p>LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”</p>
        /// <note>
        /// <p>When you use this task setting with a source PostgreSQL database, a logical
        /// replication slot should already be created and associated with the source endpoint. You
        /// can verify this by setting the <code>slotName</code> extra connection attribute to the
        /// name of this logical replication slot. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib">Extra Connection Attributes When Using PostgreSQL as a Source
        /// for DMS</a>.</p>
        /// </note>
        pub fn set_cdc_start_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_start_position(input);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn cdc_stop_position(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cdc_stop_position(inp);
            self
        }
        /// <p>Indicates when you want a change data capture (CDC) operation to stop. The value can be
        /// either server time or commit time.</p>
        /// <p>Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”</p>
        /// <p>Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “</p>
        pub fn set_cdc_stop_position(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cdc_stop_position(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplicationTaskAssessment`.
    ///
    /// <p> Starts the replication task assessment for unsupported data types in the source
    /// database. </p>
    #[derive(std::fmt::Debug)]
    pub struct StartReplicationTaskAssessment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_replication_task_assessment_input::Builder,
    }
    impl<C, M, R> StartReplicationTaskAssessment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartReplicationTaskAssessment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplicationTaskAssessmentOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskAssessmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartReplicationTaskAssessmentInputOperationOutputAlias,
                crate::output::StartReplicationTaskAssessmentOutput,
                crate::error::StartReplicationTaskAssessmentError,
                crate::input::StartReplicationTaskAssessmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p> The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p> The Amazon Resource Name (ARN) of the replication task. </p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartReplicationTaskAssessmentRun`.
    ///
    /// <p>Starts a new premigration assessment run for one or more individual assessments
    /// of a migration task.</p>
    /// <p>The assessments that you can specify depend on the source and target database engine and
    /// the migration type defined for the given task. To run this operation, your migration task
    /// must already be created. After you run this operation, you can review the status of each
    /// individual assessment. You can also run the migration task manually after the assessment
    /// run and its individual assessments complete.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartReplicationTaskAssessmentRun<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_replication_task_assessment_run_input::Builder,
    }
    impl<C, M, R> StartReplicationTaskAssessmentRun<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartReplicationTaskAssessmentRun`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartReplicationTaskAssessmentRunOutput,
            aws_smithy_http::result::SdkError<crate::error::StartReplicationTaskAssessmentRunError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartReplicationTaskAssessmentRunInputOperationOutputAlias,
                crate::output::StartReplicationTaskAssessmentRunOutput,
                crate::error::StartReplicationTaskAssessmentRunError,
                crate::input::StartReplicationTaskAssessmentRunInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Amazon Resource Name (ARN) of the migration task associated with the premigration
        /// assessment run that you want to start.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>Amazon Resource Name (ARN) of the migration task associated with the premigration
        /// assessment run that you want to start.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
        /// <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn service_access_role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service_access_role_arn(inp);
            self
        }
        /// <p>ARN of the service role needed to start the assessment run. The role must allow the <code>iam:PassRole</code> action.</p>
        pub fn set_service_access_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_service_access_role_arn(input);
            self
        }
        /// <p>Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn result_location_bucket(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_location_bucket(inp);
            self
        }
        /// <p>Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn set_result_location_bucket(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_location_bucket(input);
            self
        }
        /// <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn result_location_folder(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_location_folder(inp);
            self
        }
        /// <p>Folder within an Amazon S3 bucket where you want DMS to store the results of this assessment
        /// run.</p>
        pub fn set_result_location_folder(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_location_folder(input);
            self
        }
        /// <p>Encryption mode that you can specify to encrypt the results of this assessment run. If
        /// you don't specify this request parameter, DMS stores the assessment run results
        /// without encryption. You can specify one of the options following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"SSE_S3"</code> – The server-side encryption provided as a default by
        /// Amazon S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption.
        /// This encryption can use either a custom KMS encryption key that you specify or the
        /// default KMS encryption key that DMS provides.</p>
        /// </li>
        /// </ul>
        pub fn result_encryption_mode(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_encryption_mode(inp);
            self
        }
        /// <p>Encryption mode that you can specify to encrypt the results of this assessment run. If
        /// you don't specify this request parameter, DMS stores the assessment run results
        /// without encryption. You can specify one of the options following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>"SSE_S3"</code> – The server-side encryption provided as a default by
        /// Amazon S3.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>"SSE_KMS"</code> – Key Management Service (KMS) encryption.
        /// This encryption can use either a custom KMS encryption key that you specify or the
        /// default KMS encryption key that DMS provides.</p>
        /// </li>
        /// </ul>
        pub fn set_result_encryption_mode(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_encryption_mode(input);
            self
        }
        /// <p>ARN of a custom KMS encryption key that you specify when you set
        /// <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
        pub fn result_kms_key_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.result_kms_key_arn(inp);
            self
        }
        /// <p>ARN of a custom KMS encryption key that you specify when you set
        /// <code>ResultEncryptionMode</code> to <code>"SSE_KMS</code>".</p>
        pub fn set_result_kms_key_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_result_kms_key_arn(input);
            self
        }
        /// <p>Unique name to identify the assessment run.</p>
        pub fn assessment_run_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.assessment_run_name(inp);
            self
        }
        /// <p>Unique name to identify the assessment run.</p>
        pub fn set_assessment_run_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_assessment_run_name(input);
            self
        }
        /// Appends an item to `IncludeOnly`.
        ///
        /// To override the contents of this collection use [`set_include_only`](Self::set_include_only).
        ///
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// include. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for
        /// <code>Exclude</code> in the API operation. </p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn include_only(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.include_only(inp);
            self
        }
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// include. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>IncludeOnly</code> if you also set a value for
        /// <code>Exclude</code> in the API operation. </p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn set_include_only(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_include_only(input);
            self
        }
        /// Appends an item to `Exclude`.
        ///
        /// To override the contents of this collection use [`set_exclude`](Self::set_exclude).
        ///
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// exclude. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>Exclude</code> if you also set a value for
        /// <code>IncludeOnly</code> in the API operation.</p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn exclude(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.exclude(inp);
            self
        }
        /// <p>Space-separated list of names for specific individual assessments that you want to
        /// exclude. These names come from the default list of individual assessments that DMS
        /// supports for the associated migration task. This task is specified by
        /// <code>ReplicationTaskArn</code>.</p>
        /// <note>
        /// <p>You can't set a value for <code>Exclude</code> if you also set a value for
        /// <code>IncludeOnly</code> in the API operation.</p>
        /// <p>To identify the names of the default individual assessments that DMS
        /// supports for the associated migration task, run the
        /// <code>DescribeApplicableIndividualAssessments</code> operation using its own
        /// <code>ReplicationTaskArn</code> request parameter.</p>
        /// </note>
        pub fn set_exclude(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_exclude(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopReplicationTask`.
    ///
    /// <p>Stops the replication task.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopReplicationTask<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_replication_task_input::Builder,
    }
    impl<C, M, R> StopReplicationTask<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopReplicationTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopReplicationTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::StopReplicationTaskError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopReplicationTaskInputOperationOutputAlias,
                crate::output::StopReplicationTaskOutput,
                crate::error::StopReplicationTaskError,
                crate::input::StopReplicationTaskInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
        pub fn replication_task_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_task_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name(ARN) of the replication task to be stopped.</p>
        pub fn set_replication_task_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_task_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestConnection`.
    ///
    /// <p>Tests the connection between the replication instance and the endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_connection_input::Builder,
    }
    impl<C, M, R> TestConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::TestConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestConnectionInputOperationOutputAlias,
                crate::output::TestConnectionOutput,
                crate::error::TestConnectionError,
                crate::input::TestConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn replication_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.replication_instance_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replication instance.</p>
        pub fn set_replication_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_instance_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn endpoint_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.</p>
        pub fn set_endpoint_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_endpoint_arn(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
