// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Connect Customer Profiles
///
/// Client for invoking operations on Amazon Connect Customer Profiles. Each operation on Amazon Connect Customer Profiles is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_customerprofiles::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_customerprofiles::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_customerprofiles::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddProfileKey` operation.
    ///
    /// See [`AddProfileKey`](crate::client::fluent_builders::AddProfileKey) for more information about the
    /// operation and its arguments.
    pub fn add_profile_key(&self) -> fluent_builders::AddProfileKey<C, M, R> {
        fluent_builders::AddProfileKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDomain` operation.
    ///
    /// See [`CreateDomain`](crate::client::fluent_builders::CreateDomain) for more information about the
    /// operation and its arguments.
    pub fn create_domain(&self) -> fluent_builders::CreateDomain<C, M, R> {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProfile` operation.
    ///
    /// See [`CreateProfile`](crate::client::fluent_builders::CreateProfile) for more information about the
    /// operation and its arguments.
    pub fn create_profile(&self) -> fluent_builders::CreateProfile<C, M, R> {
        fluent_builders::CreateProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDomain` operation.
    ///
    /// See [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) for more information about the
    /// operation and its arguments.
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain<C, M, R> {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIntegration` operation.
    ///
    /// See [`DeleteIntegration`](crate::client::fluent_builders::DeleteIntegration) for more information about the
    /// operation and its arguments.
    pub fn delete_integration(&self) -> fluent_builders::DeleteIntegration<C, M, R> {
        fluent_builders::DeleteIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProfile` operation.
    ///
    /// See [`DeleteProfile`](crate::client::fluent_builders::DeleteProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_profile(&self) -> fluent_builders::DeleteProfile<C, M, R> {
        fluent_builders::DeleteProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProfileKey` operation.
    ///
    /// See [`DeleteProfileKey`](crate::client::fluent_builders::DeleteProfileKey) for more information about the
    /// operation and its arguments.
    pub fn delete_profile_key(&self) -> fluent_builders::DeleteProfileKey<C, M, R> {
        fluent_builders::DeleteProfileKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProfileObject` operation.
    ///
    /// See [`DeleteProfileObject`](crate::client::fluent_builders::DeleteProfileObject) for more information about the
    /// operation and its arguments.
    pub fn delete_profile_object(&self) -> fluent_builders::DeleteProfileObject<C, M, R> {
        fluent_builders::DeleteProfileObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProfileObjectType` operation.
    ///
    /// See [`DeleteProfileObjectType`](crate::client::fluent_builders::DeleteProfileObjectType) for more information about the
    /// operation and its arguments.
    pub fn delete_profile_object_type(&self) -> fluent_builders::DeleteProfileObjectType<C, M, R> {
        fluent_builders::DeleteProfileObjectType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDomain` operation.
    ///
    /// See [`GetDomain`](crate::client::fluent_builders::GetDomain) for more information about the
    /// operation and its arguments.
    pub fn get_domain(&self) -> fluent_builders::GetDomain<C, M, R> {
        fluent_builders::GetDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetIntegration` operation.
    ///
    /// See [`GetIntegration`](crate::client::fluent_builders::GetIntegration) for more information about the
    /// operation and its arguments.
    pub fn get_integration(&self) -> fluent_builders::GetIntegration<C, M, R> {
        fluent_builders::GetIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMatches` operation.
    ///
    /// See [`GetMatches`](crate::client::fluent_builders::GetMatches) for more information about the
    /// operation and its arguments.
    pub fn get_matches(&self) -> fluent_builders::GetMatches<C, M, R> {
        fluent_builders::GetMatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProfileObjectType` operation.
    ///
    /// See [`GetProfileObjectType`](crate::client::fluent_builders::GetProfileObjectType) for more information about the
    /// operation and its arguments.
    pub fn get_profile_object_type(&self) -> fluent_builders::GetProfileObjectType<C, M, R> {
        fluent_builders::GetProfileObjectType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProfileObjectTypeTemplate` operation.
    ///
    /// See [`GetProfileObjectTypeTemplate`](crate::client::fluent_builders::GetProfileObjectTypeTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_profile_object_type_template(
        &self,
    ) -> fluent_builders::GetProfileObjectTypeTemplate<C, M, R> {
        fluent_builders::GetProfileObjectTypeTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAccountIntegrations` operation.
    ///
    /// See [`ListAccountIntegrations`](crate::client::fluent_builders::ListAccountIntegrations) for more information about the
    /// operation and its arguments.
    pub fn list_account_integrations(&self) -> fluent_builders::ListAccountIntegrations<C, M, R> {
        fluent_builders::ListAccountIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDomains` operation.
    ///
    /// See [`ListDomains`](crate::client::fluent_builders::ListDomains) for more information about the
    /// operation and its arguments.
    pub fn list_domains(&self) -> fluent_builders::ListDomains<C, M, R> {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIntegrations` operation.
    ///
    /// See [`ListIntegrations`](crate::client::fluent_builders::ListIntegrations) for more information about the
    /// operation and its arguments.
    pub fn list_integrations(&self) -> fluent_builders::ListIntegrations<C, M, R> {
        fluent_builders::ListIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProfileObjects` operation.
    ///
    /// See [`ListProfileObjects`](crate::client::fluent_builders::ListProfileObjects) for more information about the
    /// operation and its arguments.
    pub fn list_profile_objects(&self) -> fluent_builders::ListProfileObjects<C, M, R> {
        fluent_builders::ListProfileObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProfileObjectTypes` operation.
    ///
    /// See [`ListProfileObjectTypes`](crate::client::fluent_builders::ListProfileObjectTypes) for more information about the
    /// operation and its arguments.
    pub fn list_profile_object_types(&self) -> fluent_builders::ListProfileObjectTypes<C, M, R> {
        fluent_builders::ListProfileObjectTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProfileObjectTypeTemplates` operation.
    ///
    /// See [`ListProfileObjectTypeTemplates`](crate::client::fluent_builders::ListProfileObjectTypeTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_profile_object_type_templates(
        &self,
    ) -> fluent_builders::ListProfileObjectTypeTemplates<C, M, R> {
        fluent_builders::ListProfileObjectTypeTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `MergeProfiles` operation.
    ///
    /// See [`MergeProfiles`](crate::client::fluent_builders::MergeProfiles) for more information about the
    /// operation and its arguments.
    pub fn merge_profiles(&self) -> fluent_builders::MergeProfiles<C, M, R> {
        fluent_builders::MergeProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutIntegration` operation.
    ///
    /// See [`PutIntegration`](crate::client::fluent_builders::PutIntegration) for more information about the
    /// operation and its arguments.
    pub fn put_integration(&self) -> fluent_builders::PutIntegration<C, M, R> {
        fluent_builders::PutIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutProfileObject` operation.
    ///
    /// See [`PutProfileObject`](crate::client::fluent_builders::PutProfileObject) for more information about the
    /// operation and its arguments.
    pub fn put_profile_object(&self) -> fluent_builders::PutProfileObject<C, M, R> {
        fluent_builders::PutProfileObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutProfileObjectType` operation.
    ///
    /// See [`PutProfileObjectType`](crate::client::fluent_builders::PutProfileObjectType) for more information about the
    /// operation and its arguments.
    pub fn put_profile_object_type(&self) -> fluent_builders::PutProfileObjectType<C, M, R> {
        fluent_builders::PutProfileObjectType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchProfiles` operation.
    ///
    /// See [`SearchProfiles`](crate::client::fluent_builders::SearchProfiles) for more information about the
    /// operation and its arguments.
    pub fn search_profiles(&self) -> fluent_builders::SearchProfiles<C, M, R> {
        fluent_builders::SearchProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDomain` operation.
    ///
    /// See [`UpdateDomain`](crate::client::fluent_builders::UpdateDomain) for more information about the
    /// operation and its arguments.
    pub fn update_domain(&self) -> fluent_builders::UpdateDomain<C, M, R> {
        fluent_builders::UpdateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateProfile` operation.
    ///
    /// See [`UpdateProfile`](crate::client::fluent_builders::UpdateProfile) for more information about the
    /// operation and its arguments.
    pub fn update_profile(&self) -> fluent_builders::UpdateProfile<C, M, R> {
        fluent_builders::UpdateProfile::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddProfileKey`.
    ///
    /// <p>Associates a new key value with a specific profile, such as a Contact Trace Record (CTR)
    /// ContactId.</p>
    /// <p>A profile object can have a single unique key and any number of additional keys that can
    /// be used to identify the profile that it belongs to.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddProfileKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_profile_key_input::Builder,
    }
    impl<C, M, R> AddProfileKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddProfileKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddProfileKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::AddProfileKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddProfileKeyInputOperationOutputAlias,
                crate::output::AddProfileKeyOutput,
                crate::error::AddProfileKeyError,
                crate::input::AddProfileKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(inp);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn key_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_name(inp);
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_name(input);
            self
        }
        /// Appends an item to `Values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values(inp);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a domain, which is a container for all customer data, such as customer profile
    /// attributes, object types, profile keys, and encryption keys. You can create multiple
    /// domains, and each domain can have multiple third-party integrations.</p>
    /// <p>Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can
    /// be associated with one domain.</p>
    /// <p>Use this API or <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to
    /// enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
    /// resolution</a>: set <code>Matching</code> to true. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl<C, M, R> CreateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDomainInputOperationOutputAlias,
                crate::output::CreateDomainOutput,
                crate::error::CreateDomainError,
                crate::input::CreateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.default_expiration_days(inp);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_expiration_days(input);
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn default_encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_encryption_key(inp);
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_encryption_key(input);
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications. You must set up a policy on the
        /// DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send
        /// messages to the DeadLetterQueue.</p>
        pub fn dead_letter_queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dead_letter_queue_url(inp);
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications. You must set up a policy on the
        /// DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send
        /// messages to the DeadLetterQueue.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_queue_url(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn matching(mut self, inp: crate::model::MatchingRequest) -> Self {
            self.inner = self.inner.matching(inp);
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingRequest>,
        ) -> Self {
            self.inner = self.inner.set_matching(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProfile`.
    ///
    /// <p>Creates a standard profile.</p>
    /// <p>A standard profile represents the following attributes for a customer profile in a
    /// domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_profile_input::Builder,
    }
    impl<C, M, R> CreateProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProfileInputOperationOutputAlias,
                crate::output::CreateProfileOutput,
                crate::error::CreateProfileError,
                crate::input::CreateProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn account_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_number(inp);
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_number(input);
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn additional_information(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_information(inp);
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_information(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn party_type(mut self, inp: crate::model::PartyType) -> Self {
            self.inner = self.inner.party_type(inp);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn set_party_type(
            mut self,
            input: std::option::Option<crate::model::PartyType>,
        ) -> Self {
            self.inner = self.inner.set_party_type(input);
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn business_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_name(inp);
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_name(input);
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn first_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(inp);
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn middle_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.middle_name(inp);
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_middle_name(input);
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn last_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(inp);
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn birth_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.birth_date(inp);
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_birth_date(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn gender(mut self, inp: crate::model::Gender) -> Self {
            self.inner = self.inner.gender(inp);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.inner = self.inner.set_gender(input);
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business
        /// number. </p>
        pub fn phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number(inp);
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business
        /// number. </p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_phone_number(input);
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn mobile_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mobile_phone_number(inp);
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_phone_number(input);
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn home_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_phone_number(inp);
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_phone_number(input);
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn business_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_phone_number(inp);
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_phone_number(input);
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business
        /// address. </p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business
        /// address. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn personal_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.personal_email_address(inp);
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_personal_email_address(input);
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn business_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_email_address(inp);
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_email_address(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or
        /// billing.</p>
        pub fn address(mut self, inp: crate::model::Address) -> Self {
            self.inner = self.inner.address(inp);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or
        /// billing.</p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn shipping_address(mut self, inp: crate::model::Address) -> Self {
            self.inner = self.inner.shipping_address(inp);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_shipping_address(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn mailing_address(mut self, inp: crate::model::Address) -> Self {
            self.inner = self.inner.mailing_address(inp);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_mailing_address(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn billing_address(mut self, inp: crate::model::Address) -> Self {
            self.inner = self.inner.billing_address(inp);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_billing_address(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Deletes a specific domain and all of its customer data, such as customer profile
    /// attributes and their related objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl<C, M, R> DeleteDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDomainInputOperationOutputAlias,
                crate::output::DeleteDomainOutput,
                crate::error::DeleteDomainError,
                crate::input::DeleteDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegration`.
    ///
    /// <p>Removes an integration from a specific domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_input::Builder,
    }
    impl<C, M, R> DeleteIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationInputOperationOutputAlias,
                crate::output::DeleteIntegrationOutput,
                crate::error::DeleteIntegrationError,
                crate::input::DeleteIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(inp);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfile`.
    ///
    /// <p>Deletes the standard customer profile and all data pertaining to the profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_profile_input::Builder,
    }
    impl<C, M, R> DeleteProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProfileInputOperationOutputAlias,
                crate::output::DeleteProfileOutput,
                crate::error::DeleteProfileError,
                crate::input::DeleteProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(inp);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfileKey`.
    ///
    /// <p>Removes a searchable key from a customer profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProfileKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_profile_key_input::Builder,
    }
    impl<C, M, R> DeleteProfileKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProfileKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProfileKeyInputOperationOutputAlias,
                crate::output::DeleteProfileKeyOutput,
                crate::error::DeleteProfileKeyError,
                crate::input::DeleteProfileKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(inp);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn key_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_name(inp);
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_name(input);
            self
        }
        /// Appends an item to `Values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values(inp);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfileObject`.
    ///
    /// <p>Removes an object associated with a profile of a given ProfileObjectType.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProfileObject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_profile_object_input::Builder,
    }
    impl<C, M, R> DeleteProfileObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProfileObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProfileObjectInputOperationOutputAlias,
                crate::output::DeleteProfileObjectOutput,
                crate::error::DeleteProfileObjectError,
                crate::input::DeleteProfileObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(inp);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn profile_object_unique_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_object_unique_key(inp);
            self
        }
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn set_profile_object_unique_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_object_unique_key(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(inp);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfileObjectType`.
    ///
    /// <p>Removes a ProfileObjectType from a specific domain as well as removes all the
    /// ProfileObjects of that type. It also disables integrations from this specific
    /// ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that
    /// were populated from this ProfileObjectType.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProfileObjectType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_profile_object_type_input::Builder,
    }
    impl<C, M, R> DeleteProfileObjectType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProfileObjectType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileObjectTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileObjectTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProfileObjectTypeInputOperationOutputAlias,
                crate::output::DeleteProfileObjectTypeOutput,
                crate::error::DeleteProfileObjectTypeError,
                crate::input::DeleteProfileObjectTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(inp);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomain`.
    ///
    /// <p>Returns information about a specific domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_domain_input::Builder,
    }
    impl<C, M, R> GetDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDomainInputOperationOutputAlias,
                crate::output::GetDomainOutput,
                crate::error::GetDomainError,
                crate::input::GetDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegration`.
    ///
    /// <p>Returns an integration for a domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_integration_input::Builder,
    }
    impl<C, M, R> GetIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetIntegrationInputOperationOutputAlias,
                crate::output::GetIntegrationOutput,
                crate::error::GetIntegrationError,
                crate::input::GetIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(inp);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMatches`.
    ///
    /// <p>This API is in preview release for Amazon Connect and subject to change.</p>
    /// <p>Before calling this API, use <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or
    /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to
    /// enable identity resolution: set <code>Matching</code> to true.</p>
    /// <p>GetMatches returns potentially matching profiles, based on the results of the latest run
    /// of a machine learning process. </p>
    /// <important>
    /// <p>Amazon Connect starts a batch process every Saturday at 12AM UTC to identify matching profiles.
    /// The results are returned up to seven days after the Saturday run.</p>
    /// </important>
    ///
    /// <p>Amazon Connect uses the following profile attributes to identify matches:</p>
    /// <ul>
    /// <li>
    /// <p>PhoneNumber</p>
    /// </li>
    /// <li>
    /// <p>HomePhoneNumber</p>
    /// </li>
    /// <li>
    /// <p>BusinessPhoneNumber</p>
    /// </li>
    /// <li>
    /// <p>MobilePhoneNumber</p>
    /// </li>
    /// <li>
    /// <p>EmailAddress</p>
    /// </li>
    /// <li>
    /// <p>PersonalEmailAddress</p>
    /// </li>
    /// <li>
    /// <p>BusinessEmailAddress</p>
    /// </li>
    /// <li>
    /// <p>FullName</p>
    /// </li>
    /// <li>
    /// <p>BusinessName</p>
    /// </li>
    /// </ul>
    /// <p>For example, two or more profiles—with spelling mistakes such as <b>John Doe</b> and <b>Jhn Doe</b>, or different casing
    /// email addresses such as <b>JOHN_DOE@ANYCOMPANY.COM</b> and
    /// <b>johndoe@anycompany.com</b>, or different phone number
    /// formats such as <b>555-010-0000</b> and <b>+1-555-010-0000</b>—can be detected as belonging to the same customer <b>John Doe</b> and merged into a unified profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMatches<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_matches_input::Builder,
    }
    impl<C, M, R> GetMatches<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMatchesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMatchesInputOperationOutputAlias,
                crate::output::GetMatchesOutput,
                crate::error::GetMatchesError,
                crate::input::GetMatchesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProfileObjectType`.
    ///
    /// <p>Returns the object types for a specific domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProfileObjectType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_profile_object_type_input::Builder,
    }
    impl<C, M, R> GetProfileObjectType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProfileObjectType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProfileObjectTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProfileObjectTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProfileObjectTypeInputOperationOutputAlias,
                crate::output::GetProfileObjectTypeOutput,
                crate::error::GetProfileObjectTypeError,
                crate::input::GetProfileObjectTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(inp);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProfileObjectTypeTemplate`.
    ///
    /// <p>Returns the template information for a specific object type.</p>
    /// <p>A template is a predefined ProfileObjectType, such as “Salesforce-Account” or
    /// “Salesforce-Contact.” When a user sends a ProfileObject, using the PutProfileObject API,
    /// with an ObjectTypeName that matches one of the TemplateIds, it uses the mappings from the
    /// template.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProfileObjectTypeTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_profile_object_type_template_input::Builder,
    }
    impl<C, M, R> GetProfileObjectTypeTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProfileObjectTypeTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProfileObjectTypeTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProfileObjectTypeTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProfileObjectTypeTemplateInputOperationOutputAlias,
                crate::output::GetProfileObjectTypeTemplateOutput,
                crate::error::GetProfileObjectTypeTemplateError,
                crate::input::GetProfileObjectTypeTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountIntegrations`.
    ///
    /// <p>Lists all of the integrations associated to a specific URI in the AWS account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAccountIntegrations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_account_integrations_input::Builder,
    }
    impl<C, M, R> ListAccountIntegrations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAccountIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountIntegrationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAccountIntegrationsInputOperationOutputAlias,
                crate::output::ListAccountIntegrationsOutput,
                crate::error::ListAccountIntegrationsError,
                crate::input::ListAccountIntegrationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(inp);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Returns a list of all the domains for an AWS account that have been created.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDomains<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl<C, M, R> ListDomains<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDomainsInputOperationOutputAlias,
                crate::output::ListDomainsOutput,
                crate::error::ListDomainsError,
                crate::input::ListDomainsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous ListDomain API call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token from the previous ListDomain API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIntegrations`.
    ///
    /// <p>Lists all of the integrations in your domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIntegrations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_integrations_input::Builder,
    }
    impl<C, M, R> ListIntegrations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIntegrationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIntegrationsInputOperationOutputAlias,
                crate::output::ListIntegrationsOutput,
                crate::error::ListIntegrationsError,
                crate::input::ListIntegrationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfileObjects`.
    ///
    /// <p>Returns a list of objects associated with a profile of a given ProfileObjectType.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProfileObjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_profile_objects_input::Builder,
    }
    impl<C, M, R> ListProfileObjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProfileObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfileObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfileObjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProfileObjectsInputOperationOutputAlias,
                crate::output::ListProfileObjectsOutput,
                crate::error::ListProfileObjectsError,
                crate::input::ListProfileObjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(inp);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(inp);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>Applies a filter to the response to include profile objects with the specified index values.
        /// This filter is only supported for ObjectTypeName _asset and _case.</p>
        pub fn object_filter(mut self, inp: crate::model::ObjectFilter) -> Self {
            self.inner = self.inner.object_filter(inp);
            self
        }
        /// <p>Applies a filter to the response to include profile objects with the specified index values.
        /// This filter is only supported for ObjectTypeName _asset and _case.</p>
        pub fn set_object_filter(
            mut self,
            input: std::option::Option<crate::model::ObjectFilter>,
        ) -> Self {
            self.inner = self.inner.set_object_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfileObjectTypes`.
    ///
    /// <p>Lists all of the templates available within the service.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProfileObjectTypes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_profile_object_types_input::Builder,
    }
    impl<C, M, R> ListProfileObjectTypes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProfileObjectTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfileObjectTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfileObjectTypesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProfileObjectTypesInputOperationOutputAlias,
                crate::output::ListProfileObjectTypesOutput,
                crate::error::ListProfileObjectTypesError,
                crate::input::ListProfileObjectTypesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfileObjectTypeTemplates`.
    ///
    /// <p>Lists all of the template information for object types.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProfileObjectTypeTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_profile_object_type_templates_input::Builder,
    }
    impl<C, M, R> ListProfileObjectTypeTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProfileObjectTypeTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfileObjectTypeTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfileObjectTypeTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProfileObjectTypeTemplatesInputOperationOutputAlias,
                crate::output::ListProfileObjectTypeTemplatesOutput,
                crate::error::ListProfileObjectTypeTemplatesError,
                crate::input::ListProfileObjectTypeTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect
    /// Customer Profiles, domains, profile object types, and integrations can be tagged.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource for which you want to view tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource for which you want to view tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeProfiles`.
    ///
    /// <p>This API is in preview release for Amazon Connect and subject to change.</p>
    /// <p>Runs an AWS Lambda job that does the following:</p>
    /// <ol>
    /// <li>
    /// <p>All the profileKeys in the <code>ProfileToBeMerged</code> will be moved to the
    /// main profile.</p>
    /// </li>
    /// <li>
    /// <p>All the objects in the <code>ProfileToBeMerged</code> will be moved to the main
    /// profile.</p>
    /// </li>
    /// <li>
    /// <p>All the <code>ProfileToBeMerged</code> will be deleted at the end.</p>
    /// </li>
    /// <li>
    /// <p>All the profileKeys in the <code>ProfileIdsToBeMerged</code> will be moved to the
    /// main profile.</p>
    /// </li>
    /// <li>
    /// <p>Standard fields are merged as follows:</p>
    /// <ol>
    /// <li>
    /// <p>Fields are always "union"-ed if there are no conflicts in standard fields or
    /// attributeKeys.</p>
    /// </li>
    /// <li>
    /// <p>When there are conflicting fields:</p>
    ///
    /// <ol>
    /// <li>
    /// <p>If no <code>SourceProfileIds</code> entry is specified, the main
    /// Profile value is always taken. </p>
    /// </li>
    /// <li>
    /// <p>If a <code>SourceProfileIds</code> entry is specified, the specified
    /// profileId is always taken, even if it is a NULL value.</p>
    /// </li>
    /// </ol>
    /// </li>
    /// </ol>
    /// </li>
    /// </ol>
    /// <p>You can use MergeProfiles together with <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>, which
    /// returns potentially matching profiles, or use it with the results of another matching
    /// system. After profiles have been merged, they cannot be separated (unmerged).</p>
    #[derive(std::fmt::Debug)]
    pub struct MergeProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::merge_profiles_input::Builder,
    }
    impl<C, M, R> MergeProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `MergeProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::MergeProfilesInputOperationOutputAlias,
                crate::output::MergeProfilesOutput,
                crate::error::MergeProfilesError,
                crate::input::MergeProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The identifier of the profile to be taken.</p>
        pub fn main_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.main_profile_id(inp);
            self
        }
        /// <p>The identifier of the profile to be taken.</p>
        pub fn set_main_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_main_profile_id(input);
            self
        }
        /// Appends an item to `ProfileIdsToBeMerged`.
        ///
        /// To override the contents of this collection use [`set_profile_ids_to_be_merged`](Self::set_profile_ids_to_be_merged).
        ///
        /// <p>The identifier of the profile to be merged into MainProfileId.</p>
        pub fn profile_ids_to_be_merged(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_ids_to_be_merged(inp);
            self
        }
        /// <p>The identifier of the profile to be merged into MainProfileId.</p>
        pub fn set_profile_ids_to_be_merged(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_profile_ids_to_be_merged(input);
            self
        }
        /// <p>The identifiers of the fields in the profile that has the information you want to apply
        /// to the merge. For example, say you want to merge EmailAddress from Profile1 into
        /// MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
        pub fn field_source_profile_ids(
            mut self,
            inp: crate::model::FieldSourceProfileIds,
        ) -> Self {
            self.inner = self.inner.field_source_profile_ids(inp);
            self
        }
        /// <p>The identifiers of the fields in the profile that has the information you want to apply
        /// to the merge. For example, say you want to merge EmailAddress from Profile1 into
        /// MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
        pub fn set_field_source_profile_ids(
            mut self,
            input: std::option::Option<crate::model::FieldSourceProfileIds>,
        ) -> Self {
            self.inner = self.inner.set_field_source_profile_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIntegration`.
    ///
    /// <p>Adds an integration between the service and a third-party service, which includes
    /// Amazon AppFlow and Amazon Connect.</p>
    /// <p>An integration can belong to only one domain.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutIntegration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_integration_input::Builder,
    }
    impl<C, M, R> PutIntegration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIntegrationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutIntegrationInputOperationOutputAlias,
                crate::output::PutIntegrationOutput,
                crate::error::PutIntegrationError,
                crate::input::PutIntegrationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(inp);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(inp);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the
        /// source.</p>
        pub fn flow_definition(mut self, inp: crate::model::FlowDefinition) -> Self {
            self.inner = self.inner.flow_definition(inp);
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the
        /// source.</p>
        pub fn set_flow_definition(
            mut self,
            input: std::option::Option<crate::model::FlowDefinition>,
        ) -> Self {
            self.inner = self.inner.set_flow_definition(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProfileObject`.
    ///
    /// <p>Adds additional objects to customer profiles of a given ObjectType.</p>
    /// <p>When adding a specific profile object, like a Contact Trace Record (CTR), an inferred
    /// profile can get created if it is not mapped to an existing profile. The resulting profile
    /// will only have a phone number populated in the standard ProfileObject. Any additional CTRs
    /// with the same phone number will be mapped to the same inferred profile.</p>
    /// <p>When a ProfileObject is created and if a ProfileObjectType already exists for the
    /// ProfileObject, it will provide data to a standard profile depending on the
    /// ProfileObjectType definition.</p>
    /// <p>PutProfileObject needs an ObjectType, which can be created using
    /// PutProfileObjectType.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutProfileObject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_profile_object_input::Builder,
    }
    impl<C, M, R> PutProfileObject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutProfileObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProfileObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProfileObjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutProfileObjectInputOperationOutputAlias,
                crate::output::PutProfileObjectOutput,
                crate::error::PutProfileObjectError,
                crate::input::PutProfileObjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(inp);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>A string that is serialized from a JSON object.</p>
        pub fn object(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object(inp);
            self
        }
        /// <p>A string that is serialized from a JSON object.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_object(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProfileObjectType`.
    ///
    /// <p>Defines a ProfileObjectType.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutProfileObjectType<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_profile_object_type_input::Builder,
    }
    impl<C, M, R> PutProfileObjectType<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutProfileObjectType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProfileObjectTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProfileObjectTypeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutProfileObjectTypeInputOperationOutputAlias,
                crate::output::PutProfileObjectTypeOutput,
                crate::error::PutProfileObjectTypeError,
                crate::input::PutProfileObjectTypeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(inp);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(inp);
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn expiration_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.expiration_days(inp);
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn set_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiration_days(input);
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this
        /// profile object type.</p>
        pub fn encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(inp);
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this
        /// profile object type.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn allow_profile_creation(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_profile_creation(inp);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn set_allow_profile_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_profile_creation(input);
            self
        }
        /// Adds a key-value pair to `Fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A map of the name and ObjectType field.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ObjectTypeField>,
        ) -> Self {
            self.inner = self.inner.fields(k, v);
            self
        }
        /// <p>A map of the name and ObjectType field.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
            >,
        ) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// Adds a key-value pair to `Keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ObjectTypeKey>>,
        ) -> Self {
            self.inner = self.inner.keys(k, v);
            self
        }
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ObjectTypeKey>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_keys(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProfiles`.
    ///
    /// <p>Searches for profiles within a specific domain name using name, phone number, email
    /// address, account number, or a custom defined index.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_profiles_input::Builder,
    }
    impl<C, M, R> SearchProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchProfilesInputOperationOutputAlias,
                crate::output::SearchProfilesOutput,
                crate::error::SearchProfilesError,
                crate::input::SearchProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId,
        /// _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId,
        /// _salesforceContactId, _zendeskUserId, _zendeskExternalId, _serviceNowSystemId.</p>
        pub fn key_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_name(inp);
            self
        }
        /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId,
        /// _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId,
        /// _salesforceContactId, _zendeskUserId, _zendeskExternalId, _serviceNowSystemId.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_name(input);
            self
        }
        /// Appends an item to `Values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values(inp);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles
    /// resource. Tags can help you organize and categorize your resources. You can also use them
    /// to scope user permissions by granting a user permission to access or change only resources
    /// with certain tag values. In Connect Customer Profiles, domains, profile object types, and
    /// integrations can be tagged.</p>
    /// <p>Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of
    /// characters.</p>
    /// <p>You can use the TagResource action with a resource that already has tags. If you specify
    /// a new tag key, this tag is appended to the list of tags associated with the resource. If
    /// you specify a tag key that is already associated with the resource, the new tag value that
    /// you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect
    /// Customer Profiles, domains, profile object types, and integrations can be tagged.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource from which you are removing tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The ARN of the resource from which you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomain`.
    ///
    /// <p>Updates the properties of a domain, including creating or selecting a dead letter queue
    /// or an encryption key.</p>
    /// <p>After a domain is created, the name can’t be changed.</p>
    /// <p>Use this API or <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> to
    /// enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
    /// resolution</a>: set <code>Matching</code> to true. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDomain<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_domain_input::Builder,
    }
    impl<C, M, R> UpdateDomain<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDomainInputOperationOutputAlias,
                crate::output::UpdateDomainOutput,
                crate::error::UpdateDomainError,
                crate::input::UpdateDomainInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, inp: i32) -> Self {
            self.inner = self.inner.default_expiration_days(inp);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_expiration_days(input);
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage. If specified as an empty string, it will clear any
        /// existing value.</p>
        pub fn default_encryption_key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_encryption_key(inp);
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage. If specified as an empty string, it will clear any
        /// existing value.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_encryption_key(input);
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications. If specified as an empty string, it will
        /// clear any existing value. You must set up a policy on the DeadLetterQueue for the
        /// SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the
        /// DeadLetterQueue.</p>
        pub fn dead_letter_queue_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dead_letter_queue_url(inp);
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications. If specified as an empty string, it will
        /// clear any existing value. You must set up a policy on the DeadLetterQueue for the
        /// SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the
        /// DeadLetterQueue.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_queue_url(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn matching(mut self, inp: crate::model::MatchingRequest) -> Self {
            self.inner = self.inner.matching(inp);
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingRequest>,
        ) -> Self {
            self.inner = self.inner.set_matching(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProfile`.
    ///
    /// <p>Updates the properties of a profile. The ProfileId is required for updating a customer
    /// profile.</p>
    /// <p>When calling the UpdateProfile API, specifying an empty string value means that any
    /// existing value will be removed. Not specifying a string value means that any value already
    /// there will be kept.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_profile_input::Builder,
    }
    impl<C, M, R> UpdateProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateProfileInputOperationOutputAlias,
                crate::output::UpdateProfileOutput,
                crate::error::UpdateProfileError,
                crate::input::UpdateProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(inp);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(inp);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn additional_information(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_information(inp);
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_information(input);
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn account_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_number(inp);
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_number(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn party_type(mut self, inp: crate::model::PartyType) -> Self {
            self.inner = self.inner.party_type(inp);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn set_party_type(
            mut self,
            input: std::option::Option<crate::model::PartyType>,
        ) -> Self {
            self.inner = self.inner.set_party_type(input);
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn business_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_name(inp);
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_name(input);
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn first_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(inp);
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn middle_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.middle_name(inp);
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_middle_name(input);
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn last_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(inp);
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn birth_date(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.birth_date(inp);
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_birth_date(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn gender(mut self, inp: crate::model::Gender) -> Self {
            self.inner = self.inner.gender(inp);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.inner = self.inner.set_gender(input);
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business
        /// number. </p>
        pub fn phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number(inp);
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business
        /// number. </p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_phone_number(input);
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn mobile_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mobile_phone_number(inp);
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_phone_number(input);
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn home_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_phone_number(inp);
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_phone_number(input);
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn business_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_phone_number(inp);
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_phone_number(input);
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business
        /// address. </p>
        pub fn email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(inp);
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business
        /// address. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn personal_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.personal_email_address(inp);
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_personal_email_address(input);
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn business_email_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_email_address(inp);
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_email_address(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or
        /// billing.</p>
        pub fn address(mut self, inp: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.address(inp);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or
        /// billing.</p>
        pub fn set_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn shipping_address(mut self, inp: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.shipping_address(inp);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_shipping_address(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn mailing_address(mut self, inp: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.mailing_address(inp);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_mailing_address(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn billing_address(mut self, inp: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.billing_address(inp);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_billing_address(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
