// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddProfileKeyInput`](crate::input::AddProfileKeyInput)
pub mod add_profile_key_input {
    /// A builder for [`AddProfileKeyInput`](crate::input::AddProfileKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddProfileKeyInput`](crate::input::AddProfileKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddProfileKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddProfileKeyInput {
                profile_id: self.profile_id,
                key_name: self.key_name,
                values: self.values,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddProfileKeyInputOperationOutputAlias = crate::operation::AddProfileKey;
#[doc(hidden)]
pub type AddProfileKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddProfileKeyInput {
    /// Consumes the builder and constructs an Operation<[`AddProfileKey`](crate::operation::AddProfileKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddProfileKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddProfileKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.domain_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_1, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/keys",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddProfileKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_profile_key(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddProfileKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddProfileKey",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddProfileKeyInput`](crate::input::AddProfileKeyInput)
    pub fn builder() -> crate::input::add_profile_key_input::Builder {
        crate::input::add_profile_key_input::Builder::default()
    }
}

/// See [`CreateDomainInput`](crate::input::CreateDomainInput)
pub mod create_domain_input {
    /// A builder for [`CreateDomainInput`](crate::input::CreateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) default_expiration_days: std::option::Option<i32>,
        pub(crate) default_encryption_key: std::option::Option<std::string::String>,
        pub(crate) dead_letter_queue_url: std::option::Option<std::string::String>,
        pub(crate) matching: std::option::Option<crate::model::MatchingRequest>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, input: i32) -> Self {
            self.default_expiration_days = Some(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.default_expiration_days = input;
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
        pub fn default_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_encryption_key = Some(input.into());
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_encryption_key = input;
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn dead_letter_queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.dead_letter_queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dead_letter_queue_url = input;
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn matching(mut self, input: crate::model::MatchingRequest) -> Self {
            self.matching = Some(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingRequest>,
        ) -> Self {
            self.matching = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainInput`](crate::input::CreateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDomainInput {
                domain_name: self.domain_name,
                default_expiration_days: self.default_expiration_days,
                default_encryption_key: self.default_encryption_key,
                dead_letter_queue_url: self.dead_letter_queue_url,
                matching: self.matching,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDomainInputOperationOutputAlias = crate::operation::CreateDomain;
#[doc(hidden)]
pub type CreateDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDomainInput {
    /// Consumes the builder and constructs an Operation<[`CreateDomain`](crate::operation::CreateDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.domain_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_2, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/domains/{DomainName}", DomainName = domain_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDomain",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
}

/// See [`CreateIntegrationWorkflowInput`](crate::input::CreateIntegrationWorkflowInput)
pub mod create_integration_workflow_input {
    /// A builder for [`CreateIntegrationWorkflowInput`](crate::input::CreateIntegrationWorkflowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) integration_config: std::option::Option<crate::model::IntegrationConfig>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>Configuration data for integration workflow.</p>
        pub fn integration_config(mut self, input: crate::model::IntegrationConfig) -> Self {
            self.integration_config = Some(input);
            self
        }
        /// <p>Configuration data for integration workflow.</p>
        pub fn set_integration_config(
            mut self,
            input: std::option::Option<crate::model::IntegrationConfig>,
        ) -> Self {
            self.integration_config = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your behalf as part of workflow execution.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your behalf as part of workflow execution.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntegrationWorkflowInput`](crate::input::CreateIntegrationWorkflowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIntegrationWorkflowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIntegrationWorkflowInput {
                domain_name: self.domain_name,
                workflow_type: self.workflow_type,
                integration_config: self.integration_config,
                object_type_name: self.object_type_name,
                role_arn: self.role_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIntegrationWorkflowInputOperationOutputAlias =
    crate::operation::CreateIntegrationWorkflow;
#[doc(hidden)]
pub type CreateIntegrationWorkflowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateIntegrationWorkflowInput {
    /// Consumes the builder and constructs an Operation<[`CreateIntegrationWorkflow`](crate::operation::CreateIntegrationWorkflow)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIntegrationWorkflow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateIntegrationWorkflowInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.domain_name;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_3, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/workflows/integrations",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateIntegrationWorkflowInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_integration_workflow(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIntegrationWorkflow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIntegrationWorkflow",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateIntegrationWorkflowInput`](crate::input::CreateIntegrationWorkflowInput)
    pub fn builder() -> crate::input::create_integration_workflow_input::Builder {
        crate::input::create_integration_workflow_input::Builder::default()
    }
}

/// See [`CreateProfileInput`](crate::input::CreateProfileInput)
pub mod create_profile_input {
    /// A builder for [`CreateProfileInput`](crate::input::CreateProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) account_number: std::option::Option<std::string::String>,
        pub(crate) additional_information: std::option::Option<std::string::String>,
        pub(crate) party_type: std::option::Option<crate::model::PartyType>,
        pub(crate) business_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) middle_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) birth_date: std::option::Option<std::string::String>,
        pub(crate) gender: std::option::Option<crate::model::Gender>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) mobile_phone_number: std::option::Option<std::string::String>,
        pub(crate) home_phone_number: std::option::Option<std::string::String>,
        pub(crate) business_phone_number: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) personal_email_address: std::option::Option<std::string::String>,
        pub(crate) business_email_address: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<crate::model::Address>,
        pub(crate) shipping_address: std::option::Option<crate::model::Address>,
        pub(crate) mailing_address: std::option::Option<crate::model::Address>,
        pub(crate) billing_address: std::option::Option<crate::model::Address>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_number = Some(input.into());
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_number = input;
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn additional_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_information = Some(input.into());
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_information = input;
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn party_type(mut self, input: crate::model::PartyType) -> Self {
            self.party_type = Some(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn set_party_type(
            mut self,
            input: std::option::Option<crate::model::PartyType>,
        ) -> Self {
            self.party_type = input;
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn business_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_name = Some(input.into());
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_name = input;
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn middle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.middle_name = Some(input.into());
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.middle_name = input;
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn birth_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.birth_date = Some(input.into());
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.birth_date = input;
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn gender(mut self, input: crate::model::Gender) -> Self {
            self.gender = Some(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.gender = input;
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn mobile_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.mobile_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_phone_number = input;
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn home_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_phone_number = input;
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn business_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_phone_number = input;
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn personal_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.personal_email_address = Some(input.into());
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.personal_email_address = input;
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn business_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_email_address = Some(input.into());
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_email_address = input;
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn address(mut self, input: crate::model::Address) -> Self {
            self.address = Some(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.address = input;
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn shipping_address(mut self, input: crate::model::Address) -> Self {
            self.shipping_address = Some(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.shipping_address = input;
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn mailing_address(mut self, input: crate::model::Address) -> Self {
            self.mailing_address = Some(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.mailing_address = input;
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn billing_address(mut self, input: crate::model::Address) -> Self {
            self.billing_address = Some(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.billing_address = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProfileInput`](crate::input::CreateProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProfileInput {
                domain_name: self.domain_name,
                account_number: self.account_number,
                additional_information: self.additional_information,
                party_type: self.party_type,
                business_name: self.business_name,
                first_name: self.first_name,
                middle_name: self.middle_name,
                last_name: self.last_name,
                birth_date: self.birth_date,
                gender: self.gender,
                phone_number: self.phone_number,
                mobile_phone_number: self.mobile_phone_number,
                home_phone_number: self.home_phone_number,
                business_phone_number: self.business_phone_number,
                email_address: self.email_address,
                personal_email_address: self.personal_email_address,
                business_email_address: self.business_email_address,
                address: self.address,
                shipping_address: self.shipping_address,
                mailing_address: self.mailing_address,
                billing_address: self.billing_address,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProfileInputOperationOutputAlias = crate::operation::CreateProfile;
#[doc(hidden)]
pub type CreateProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateProfile`](crate::operation::CreateProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.domain_name;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_4, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_profile(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProfile",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateProfileInput`](crate::input::CreateProfileInput)
    pub fn builder() -> crate::input::create_profile_input::Builder {
        crate::input::create_profile_input::Builder::default()
    }
}

/// See [`DeleteDomainInput`](crate::input::DeleteDomainInput)
pub mod delete_domain_input {
    /// A builder for [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainInput`](crate::input::DeleteDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDomainInputOperationOutputAlias = crate::operation::DeleteDomain;
#[doc(hidden)]
pub type DeleteDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDomainInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDomain`](crate::operation::DeleteDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.domain_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_5, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/domains/{DomainName}", DomainName = domain_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDomain",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
}

/// See [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
pub mod delete_integration_input {
    /// A builder for [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntegrationInput {
                domain_name: self.domain_name,
                uri: self.uri,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntegrationInputOperationOutputAlias = crate::operation::DeleteIntegration;
#[doc(hidden)]
pub type DeleteIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntegration`](crate::operation::DeleteIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.domain_name;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_6, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/integrations/delete",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_integration(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntegration",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    pub fn builder() -> crate::input::delete_integration_input::Builder {
        crate::input::delete_integration_input::Builder::default()
    }
}

/// See [`DeleteProfileInput`](crate::input::DeleteProfileInput)
pub mod delete_profile_input {
    /// A builder for [`DeleteProfileInput`](crate::input::DeleteProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileInput`](crate::input::DeleteProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProfileInput {
                profile_id: self.profile_id,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProfileInputOperationOutputAlias = crate::operation::DeleteProfile;
#[doc(hidden)]
pub type DeleteProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProfile`](crate::operation::DeleteProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.domain_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_7, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/delete",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_profile(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProfile",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProfileInput`](crate::input::DeleteProfileInput)
    pub fn builder() -> crate::input::delete_profile_input::Builder {
        crate::input::delete_profile_input::Builder::default()
    }
}

/// See [`DeleteProfileKeyInput`](crate::input::DeleteProfileKeyInput)
pub mod delete_profile_key_input {
    /// A builder for [`DeleteProfileKeyInput`](crate::input::DeleteProfileKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileKeyInput`](crate::input::DeleteProfileKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProfileKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProfileKeyInput {
                profile_id: self.profile_id,
                key_name: self.key_name,
                values: self.values,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProfileKeyInputOperationOutputAlias = crate::operation::DeleteProfileKey;
#[doc(hidden)]
pub type DeleteProfileKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProfileKeyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProfileKey`](crate::operation::DeleteProfileKey)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProfileKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProfileKeyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.domain_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_8, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/keys/delete",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProfileKeyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_profile_key(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProfileKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProfileKey",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProfileKeyInput`](crate::input::DeleteProfileKeyInput)
    pub fn builder() -> crate::input::delete_profile_key_input::Builder {
        crate::input::delete_profile_key_input::Builder::default()
    }
}

/// See [`DeleteProfileObjectInput`](crate::input::DeleteProfileObjectInput)
pub mod delete_profile_object_input {
    /// A builder for [`DeleteProfileObjectInput`](crate::input::DeleteProfileObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) profile_object_unique_key: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn profile_object_unique_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_object_unique_key = Some(input.into());
            self
        }
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn set_profile_object_unique_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_object_unique_key = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileObjectInput`](crate::input::DeleteProfileObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProfileObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProfileObjectInput {
                profile_id: self.profile_id,
                profile_object_unique_key: self.profile_object_unique_key,
                object_type_name: self.object_type_name,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProfileObjectInputOperationOutputAlias = crate::operation::DeleteProfileObject;
#[doc(hidden)]
pub type DeleteProfileObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProfileObjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProfileObject`](crate::operation::DeleteProfileObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProfileObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProfileObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.domain_name;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_9, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/objects/delete",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProfileObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_profile_object(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProfileObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProfileObject",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProfileObjectInput`](crate::input::DeleteProfileObjectInput)
    pub fn builder() -> crate::input::delete_profile_object_input::Builder {
        crate::input::delete_profile_object_input::Builder::default()
    }
}

/// See [`DeleteProfileObjectTypeInput`](crate::input::DeleteProfileObjectTypeInput)
pub mod delete_profile_object_type_input {
    /// A builder for [`DeleteProfileObjectTypeInput`](crate::input::DeleteProfileObjectTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileObjectTypeInput`](crate::input::DeleteProfileObjectTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProfileObjectTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProfileObjectTypeInput {
                domain_name: self.domain_name,
                object_type_name: self.object_type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProfileObjectTypeInputOperationOutputAlias =
    crate::operation::DeleteProfileObjectType;
#[doc(hidden)]
pub type DeleteProfileObjectTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProfileObjectTypeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProfileObjectType`](crate::operation::DeleteProfileObjectType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProfileObjectType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProfileObjectTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.domain_name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_10, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.object_type_name;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "object_type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let object_type_name = aws_smithy_http::label::fmt_string(input_11, false);
                if object_type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "object_type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/object-types/{ObjectTypeName}",
                    DomainName = domain_name,
                    ObjectTypeName = object_type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProfileObjectTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProfileObjectType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProfileObjectType",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProfileObjectTypeInput`](crate::input::DeleteProfileObjectTypeInput)
    pub fn builder() -> crate::input::delete_profile_object_type_input::Builder {
        crate::input::delete_profile_object_type_input::Builder::default()
    }
}

/// See [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
pub mod delete_workflow_input {
    /// A builder for [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteWorkflowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteWorkflowInput {
                domain_name: self.domain_name,
                workflow_id: self.workflow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteWorkflowInputOperationOutputAlias = crate::operation::DeleteWorkflow;
#[doc(hidden)]
pub type DeleteWorkflowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteWorkflowInput {
    /// Consumes the builder and constructs an Operation<[`DeleteWorkflow`](crate::operation::DeleteWorkflow)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteWorkflow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteWorkflowInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.domain_name;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_12, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.workflow_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "workflow_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let workflow_id = aws_smithy_http::label::fmt_string(input_13, false);
                if workflow_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workflow_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/workflows/{WorkflowId}",
                    DomainName = domain_name,
                    WorkflowId = workflow_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteWorkflowInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteWorkflow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteWorkflow",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteWorkflowInput`](crate::input::DeleteWorkflowInput)
    pub fn builder() -> crate::input::delete_workflow_input::Builder {
        crate::input::delete_workflow_input::Builder::default()
    }
}

/// See [`GetAutoMergingPreviewInput`](crate::input::GetAutoMergingPreviewInput)
pub mod get_auto_merging_preview_input {
    /// A builder for [`GetAutoMergingPreviewInput`](crate::input::GetAutoMergingPreviewInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) consolidation: std::option::Option<crate::model::Consolidation>,
        pub(crate) conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>A list of matching attributes that represent matching criteria.</p>
        pub fn consolidation(mut self, input: crate::model::Consolidation) -> Self {
            self.consolidation = Some(input);
            self
        }
        /// <p>A list of matching attributes that represent matching criteria.</p>
        pub fn set_consolidation(
            mut self,
            input: std::option::Option<crate::model::Consolidation>,
        ) -> Self {
            self.consolidation = input;
            self
        }
        /// <p>How the auto-merging process should resolve conflicts between different profiles.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.conflict_resolution = Some(input);
            self
        }
        /// <p>How the auto-merging process should resolve conflicts between different profiles.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.conflict_resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAutoMergingPreviewInput`](crate::input::GetAutoMergingPreviewInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAutoMergingPreviewInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAutoMergingPreviewInput {
                domain_name: self.domain_name,
                consolidation: self.consolidation,
                conflict_resolution: self.conflict_resolution,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAutoMergingPreviewInputOperationOutputAlias = crate::operation::GetAutoMergingPreview;
#[doc(hidden)]
pub type GetAutoMergingPreviewInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAutoMergingPreviewInput {
    /// Consumes the builder and constructs an Operation<[`GetAutoMergingPreview`](crate::operation::GetAutoMergingPreview)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAutoMergingPreview,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetAutoMergingPreviewInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.domain_name;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_14, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/identity-resolution-jobs/auto-merging-preview",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetAutoMergingPreviewInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_auto_merging_preview(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAutoMergingPreview::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAutoMergingPreview",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetAutoMergingPreviewInput`](crate::input::GetAutoMergingPreviewInput)
    pub fn builder() -> crate::input::get_auto_merging_preview_input::Builder {
        crate::input::get_auto_merging_preview_input::Builder::default()
    }
}

/// See [`GetDomainInput`](crate::input::GetDomainInput)
pub mod get_domain_input {
    /// A builder for [`GetDomainInput`](crate::input::GetDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainInput`](crate::input::GetDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetDomainInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetDomainInput {
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDomainInputOperationOutputAlias = crate::operation::GetDomain;
#[doc(hidden)]
pub type GetDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDomainInput {
    /// Consumes the builder and constructs an Operation<[`GetDomain`](crate::operation::GetDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.domain_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_15, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/domains/{DomainName}", DomainName = domain_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetDomain::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetDomain",
                    "customerprofiles",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetDomainInput`](crate::input::GetDomainInput)
    pub fn builder() -> crate::input::get_domain_input::Builder {
        crate::input::get_domain_input::Builder::default()
    }
}

/// See [`GetIdentityResolutionJobInput`](crate::input::GetIdentityResolutionJobInput)
pub mod get_identity_resolution_job_input {
    /// A builder for [`GetIdentityResolutionJobInput`](crate::input::GetIdentityResolutionJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The unique identifier of the Identity Resolution Job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Identity Resolution Job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIdentityResolutionJobInput`](crate::input::GetIdentityResolutionJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIdentityResolutionJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIdentityResolutionJobInput {
                domain_name: self.domain_name,
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIdentityResolutionJobInputOperationOutputAlias =
    crate::operation::GetIdentityResolutionJob;
#[doc(hidden)]
pub type GetIdentityResolutionJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIdentityResolutionJobInput {
    /// Consumes the builder and constructs an Operation<[`GetIdentityResolutionJob`](crate::operation::GetIdentityResolutionJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIdentityResolutionJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIdentityResolutionJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_16 = &_input.domain_name;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_16, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_17 = &_input.job_id;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_id = aws_smithy_http::label::fmt_string(input_17, false);
                if job_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/identity-resolution-jobs/{JobId}",
                    DomainName = domain_name,
                    JobId = job_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIdentityResolutionJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIdentityResolutionJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIdentityResolutionJob",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIdentityResolutionJobInput`](crate::input::GetIdentityResolutionJobInput)
    pub fn builder() -> crate::input::get_identity_resolution_job_input::Builder {
        crate::input::get_identity_resolution_job_input::Builder::default()
    }
}

/// See [`GetIntegrationInput`](crate::input::GetIntegrationInput)
pub mod get_integration_input {
    /// A builder for [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationInput`](crate::input::GetIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetIntegrationInput {
                domain_name: self.domain_name,
                uri: self.uri,
            })
        }
    }
}
#[doc(hidden)]
pub type GetIntegrationInputOperationOutputAlias = crate::operation::GetIntegration;
#[doc(hidden)]
pub type GetIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`GetIntegration`](crate::operation::GetIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_18 = &_input.domain_name;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_18, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/integrations",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_get_integration(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetIntegration",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    pub fn builder() -> crate::input::get_integration_input::Builder {
        crate::input::get_integration_input::Builder::default()
    }
}

/// See [`GetMatchesInput`](crate::input::GetMatchesInput)
pub mod get_matches_input {
    /// A builder for [`GetMatchesInput`](crate::input::GetMatchesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMatchesInput`](crate::input::GetMatchesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMatchesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMatchesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMatchesInputOperationOutputAlias = crate::operation::GetMatches;
#[doc(hidden)]
pub type GetMatchesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMatchesInput {
    /// Consumes the builder and constructs an Operation<[`GetMatches`](crate::operation::GetMatches)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMatches,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMatchesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.domain_name;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_19, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/matches",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetMatchesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_20) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_20));
                }
                if let Some(inner_21) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_21).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMatchesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMatches::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMatches",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMatchesInput`](crate::input::GetMatchesInput)
    pub fn builder() -> crate::input::get_matches_input::Builder {
        crate::input::get_matches_input::Builder::default()
    }
}

/// See [`GetProfileObjectTypeInput`](crate::input::GetProfileObjectTypeInput)
pub mod get_profile_object_type_input {
    /// A builder for [`GetProfileObjectTypeInput`](crate::input::GetProfileObjectTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProfileObjectTypeInput`](crate::input::GetProfileObjectTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProfileObjectTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProfileObjectTypeInput {
                domain_name: self.domain_name,
                object_type_name: self.object_type_name,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProfileObjectTypeInputOperationOutputAlias = crate::operation::GetProfileObjectType;
#[doc(hidden)]
pub type GetProfileObjectTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetProfileObjectTypeInput {
    /// Consumes the builder and constructs an Operation<[`GetProfileObjectType`](crate::operation::GetProfileObjectType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProfileObjectType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetProfileObjectTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_22 = &_input.domain_name;
                let input_22 = input_22.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_22, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_23 = &_input.object_type_name;
                let input_23 = input_23.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "object_type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let object_type_name = aws_smithy_http::label::fmt_string(input_23, false);
                if object_type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "object_type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/object-types/{ObjectTypeName}",
                    DomainName = domain_name,
                    ObjectTypeName = object_type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetProfileObjectTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProfileObjectType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProfileObjectType",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetProfileObjectTypeInput`](crate::input::GetProfileObjectTypeInput)
    pub fn builder() -> crate::input::get_profile_object_type_input::Builder {
        crate::input::get_profile_object_type_input::Builder::default()
    }
}

/// See [`GetProfileObjectTypeTemplateInput`](crate::input::GetProfileObjectTypeTemplateInput)
pub mod get_profile_object_type_template_input {
    /// A builder for [`GetProfileObjectTypeTemplateInput`](crate::input::GetProfileObjectTypeTemplateInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProfileObjectTypeTemplateInput`](crate::input::GetProfileObjectTypeTemplateInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProfileObjectTypeTemplateInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProfileObjectTypeTemplateInput {
                template_id: self.template_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProfileObjectTypeTemplateInputOperationOutputAlias =
    crate::operation::GetProfileObjectTypeTemplate;
#[doc(hidden)]
pub type GetProfileObjectTypeTemplateInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetProfileObjectTypeTemplateInput {
    /// Consumes the builder and constructs an Operation<[`GetProfileObjectTypeTemplate`](crate::operation::GetProfileObjectTypeTemplate)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProfileObjectTypeTemplate,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetProfileObjectTypeTemplateInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_24 = &_input.template_id;
                let input_24 = input_24.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let template_id = aws_smithy_http::label::fmt_string(input_24, false);
                if template_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "template_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/templates/{TemplateId}", TemplateId = template_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetProfileObjectTypeTemplateInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProfileObjectTypeTemplate::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProfileObjectTypeTemplate",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetProfileObjectTypeTemplateInput`](crate::input::GetProfileObjectTypeTemplateInput)
    pub fn builder() -> crate::input::get_profile_object_type_template_input::Builder {
        crate::input::get_profile_object_type_template_input::Builder::default()
    }
}

/// See [`GetWorkflowInput`](crate::input::GetWorkflowInput)
pub mod get_workflow_input {
    /// A builder for [`GetWorkflowInput`](crate::input::GetWorkflowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkflowInput`](crate::input::GetWorkflowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkflowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkflowInput {
                domain_name: self.domain_name,
                workflow_id: self.workflow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkflowInputOperationOutputAlias = crate::operation::GetWorkflow;
#[doc(hidden)]
pub type GetWorkflowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWorkflowInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkflow`](crate::operation::GetWorkflow)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkflow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetWorkflowInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_25 = &_input.domain_name;
                let input_25 = input_25.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_25, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_26 = &_input.workflow_id;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "workflow_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let workflow_id = aws_smithy_http::label::fmt_string(input_26, false);
                if workflow_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workflow_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/workflows/{WorkflowId}",
                    DomainName = domain_name,
                    WorkflowId = workflow_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetWorkflowInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkflow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkflow",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetWorkflowInput`](crate::input::GetWorkflowInput)
    pub fn builder() -> crate::input::get_workflow_input::Builder {
        crate::input::get_workflow_input::Builder::default()
    }
}

/// See [`GetWorkflowStepsInput`](crate::input::GetWorkflowStepsInput)
pub mod get_workflow_steps_input {
    /// A builder for [`GetWorkflowStepsInput`](crate::input::GetWorkflowStepsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) workflow_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.workflow_id = Some(input.into());
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.workflow_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetWorkflowStepsInput`](crate::input::GetWorkflowStepsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetWorkflowStepsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetWorkflowStepsInput {
                domain_name: self.domain_name,
                workflow_id: self.workflow_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetWorkflowStepsInputOperationOutputAlias = crate::operation::GetWorkflowSteps;
#[doc(hidden)]
pub type GetWorkflowStepsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetWorkflowStepsInput {
    /// Consumes the builder and constructs an Operation<[`GetWorkflowSteps`](crate::operation::GetWorkflowSteps)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetWorkflowSteps,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetWorkflowStepsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_27 = &_input.domain_name;
                let input_27 = input_27.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_27, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_28 = &_input.workflow_id;
                let input_28 = input_28.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "workflow_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let workflow_id = aws_smithy_http::label::fmt_string(input_28, false);
                if workflow_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "workflow_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/workflows/{WorkflowId}/steps",
                    DomainName = domain_name,
                    WorkflowId = workflow_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetWorkflowStepsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_29) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_29));
                }
                if let Some(inner_30) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_30).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetWorkflowStepsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetWorkflowSteps::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetWorkflowSteps",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetWorkflowStepsInput`](crate::input::GetWorkflowStepsInput)
    pub fn builder() -> crate::input::get_workflow_steps_input::Builder {
        crate::input::get_workflow_steps_input::Builder::default()
    }
}

/// See [`ListAccountIntegrationsInput`](crate::input::ListAccountIntegrationsInput)
pub mod list_account_integrations_input {
    /// A builder for [`ListAccountIntegrationsInput`](crate::input::ListAccountIntegrationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) include_hidden: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn include_hidden(mut self, input: bool) -> Self {
            self.include_hidden = Some(input);
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn set_include_hidden(mut self, input: std::option::Option<bool>) -> Self {
            self.include_hidden = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountIntegrationsInput`](crate::input::ListAccountIntegrationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAccountIntegrationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAccountIntegrationsInput {
                uri: self.uri,
                next_token: self.next_token,
                max_results: self.max_results,
                include_hidden: self.include_hidden,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAccountIntegrationsInputOperationOutputAlias =
    crate::operation::ListAccountIntegrations;
#[doc(hidden)]
pub type ListAccountIntegrationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAccountIntegrationsInput {
    /// Consumes the builder and constructs an Operation<[`ListAccountIntegrations`](crate::operation::ListAccountIntegrations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAccountIntegrations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListAccountIntegrationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/integrations").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListAccountIntegrationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_31) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_31));
                }
                if let Some(inner_32) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_32).encode(),
                    );
                }
                if let Some(inner_33) = &_input.include_hidden {
                    query.push_kv(
                        "include-hidden",
                        aws_smithy_types::primitive::Encoder::from(*inner_33).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListAccountIntegrationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_account_integrations(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAccountIntegrations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAccountIntegrations",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListAccountIntegrationsInput`](crate::input::ListAccountIntegrationsInput)
    pub fn builder() -> crate::input::list_account_integrations_input::Builder {
        crate::input::list_account_integrations_input::Builder::default()
    }
}

/// See [`ListDomainsInput`](crate::input::ListDomainsInput)
pub mod list_domains_input {
    /// A builder for [`ListDomainsInput`](crate::input::ListDomainsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token from the previous ListDomain API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListDomain API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsInput`](crate::input::ListDomainsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDomainsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDomainsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDomainsInputOperationOutputAlias = crate::operation::ListDomains;
#[doc(hidden)]
pub type ListDomainsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDomainsInput {
    /// Consumes the builder and constructs an Operation<[`ListDomains`](crate::operation::ListDomains)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDomains,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDomainsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/domains").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDomainsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_34) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_34));
                }
                if let Some(inner_35) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_35).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDomainsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDomains::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDomains",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
}

/// See [`ListIdentityResolutionJobsInput`](crate::input::ListIdentityResolutionJobsInput)
pub mod list_identity_resolution_jobs_input {
    /// A builder for [`ListIdentityResolutionJobsInput`](crate::input::ListIdentityResolutionJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIdentityResolutionJobsInput`](crate::input::ListIdentityResolutionJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIdentityResolutionJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIdentityResolutionJobsInput {
                domain_name: self.domain_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIdentityResolutionJobsInputOperationOutputAlias =
    crate::operation::ListIdentityResolutionJobs;
#[doc(hidden)]
pub type ListIdentityResolutionJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIdentityResolutionJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListIdentityResolutionJobs`](crate::operation::ListIdentityResolutionJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIdentityResolutionJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListIdentityResolutionJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_36 = &_input.domain_name;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_36, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/identity-resolution-jobs",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListIdentityResolutionJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_37) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_37));
                }
                if let Some(inner_38) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_38).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListIdentityResolutionJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIdentityResolutionJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIdentityResolutionJobs",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListIdentityResolutionJobsInput`](crate::input::ListIdentityResolutionJobsInput)
    pub fn builder() -> crate::input::list_identity_resolution_jobs_input::Builder {
        crate::input::list_identity_resolution_jobs_input::Builder::default()
    }
}

/// See [`ListIntegrationsInput`](crate::input::ListIntegrationsInput)
pub mod list_integrations_input {
    /// A builder for [`ListIntegrationsInput`](crate::input::ListIntegrationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) include_hidden: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn include_hidden(mut self, input: bool) -> Self {
            self.include_hidden = Some(input);
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn set_include_hidden(mut self, input: std::option::Option<bool>) -> Self {
            self.include_hidden = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIntegrationsInput`](crate::input::ListIntegrationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIntegrationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIntegrationsInput {
                domain_name: self.domain_name,
                next_token: self.next_token,
                max_results: self.max_results,
                include_hidden: self.include_hidden,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIntegrationsInputOperationOutputAlias = crate::operation::ListIntegrations;
#[doc(hidden)]
pub type ListIntegrationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIntegrationsInput {
    /// Consumes the builder and constructs an Operation<[`ListIntegrations`](crate::operation::ListIntegrations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIntegrations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListIntegrationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_39 = &_input.domain_name;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_39, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/integrations",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListIntegrationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_40) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_40));
                }
                if let Some(inner_41) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_41).encode(),
                    );
                }
                if let Some(inner_42) = &_input.include_hidden {
                    query.push_kv(
                        "include-hidden",
                        aws_smithy_types::primitive::Encoder::from(*inner_42).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListIntegrationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIntegrations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIntegrations",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListIntegrationsInput`](crate::input::ListIntegrationsInput)
    pub fn builder() -> crate::input::list_integrations_input::Builder {
        crate::input::list_integrations_input::Builder::default()
    }
}

/// See [`ListProfileObjectsInput`](crate::input::ListProfileObjectsInput)
pub mod list_profile_objects_input {
    /// A builder for [`ListProfileObjectsInput`](crate::input::ListProfileObjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) object_filter: std::option::Option<crate::model::ObjectFilter>,
    }
    impl Builder {
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>Applies a filter to the response to include profile objects with the specified index values. This filter is only supported for ObjectTypeName _asset, _case and _order.</p>
        pub fn object_filter(mut self, input: crate::model::ObjectFilter) -> Self {
            self.object_filter = Some(input);
            self
        }
        /// <p>Applies a filter to the response to include profile objects with the specified index values. This filter is only supported for ObjectTypeName _asset, _case and _order.</p>
        pub fn set_object_filter(
            mut self,
            input: std::option::Option<crate::model::ObjectFilter>,
        ) -> Self {
            self.object_filter = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectsInput`](crate::input::ListProfileObjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProfileObjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProfileObjectsInput {
                next_token: self.next_token,
                max_results: self.max_results,
                domain_name: self.domain_name,
                object_type_name: self.object_type_name,
                profile_id: self.profile_id,
                object_filter: self.object_filter,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProfileObjectsInputOperationOutputAlias = crate::operation::ListProfileObjects;
#[doc(hidden)]
pub type ListProfileObjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProfileObjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProfileObjects`](crate::operation::ListProfileObjects)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProfileObjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProfileObjectsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.domain_name;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_43, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/objects",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProfileObjectsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_44) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_44));
                }
                if let Some(inner_45) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_45).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProfileObjectsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_profile_objects(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProfileObjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProfileObjects",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProfileObjectsInput`](crate::input::ListProfileObjectsInput)
    pub fn builder() -> crate::input::list_profile_objects_input::Builder {
        crate::input::list_profile_objects_input::Builder::default()
    }
}

/// See [`ListProfileObjectTypesInput`](crate::input::ListProfileObjectTypesInput)
pub mod list_profile_object_types_input {
    /// A builder for [`ListProfileObjectTypesInput`](crate::input::ListProfileObjectTypesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectTypesInput`](crate::input::ListProfileObjectTypesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProfileObjectTypesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProfileObjectTypesInput {
                domain_name: self.domain_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProfileObjectTypesInputOperationOutputAlias = crate::operation::ListProfileObjectTypes;
#[doc(hidden)]
pub type ListProfileObjectTypesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProfileObjectTypesInput {
    /// Consumes the builder and constructs an Operation<[`ListProfileObjectTypes`](crate::operation::ListProfileObjectTypes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProfileObjectTypes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProfileObjectTypesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_46 = &_input.domain_name;
                let input_46 = input_46.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_46, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/object-types",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProfileObjectTypesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_47) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_47));
                }
                if let Some(inner_48) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_48).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProfileObjectTypesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProfileObjectTypes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProfileObjectTypes",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypesInput`](crate::input::ListProfileObjectTypesInput)
    pub fn builder() -> crate::input::list_profile_object_types_input::Builder {
        crate::input::list_profile_object_types_input::Builder::default()
    }
}

/// See [`ListProfileObjectTypeTemplatesInput`](crate::input::ListProfileObjectTypeTemplatesInput)
pub mod list_profile_object_type_templates_input {
    /// A builder for [`ListProfileObjectTypeTemplatesInput`](crate::input::ListProfileObjectTypeTemplatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectTypeTemplatesInput`](crate::input::ListProfileObjectTypeTemplatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProfileObjectTypeTemplatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProfileObjectTypeTemplatesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProfileObjectTypeTemplatesInputOperationOutputAlias =
    crate::operation::ListProfileObjectTypeTemplates;
#[doc(hidden)]
pub type ListProfileObjectTypeTemplatesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListProfileObjectTypeTemplatesInput {
    /// Consumes the builder and constructs an Operation<[`ListProfileObjectTypeTemplates`](crate::operation::ListProfileObjectTypeTemplates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProfileObjectTypeTemplates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProfileObjectTypeTemplatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/templates").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProfileObjectTypeTemplatesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_49) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_49));
                }
                if let Some(inner_50) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_50).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProfileObjectTypeTemplatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProfileObjectTypeTemplates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProfileObjectTypeTemplates",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypeTemplatesInput`](crate::input::ListProfileObjectTypeTemplatesInput)
    pub fn builder() -> crate::input::list_profile_object_type_templates_input::Builder {
        crate::input::list_profile_object_type_templates_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the resource for which you want to view tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource for which you want to view tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_51 = &_input.resource_arn;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_51, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
pub mod list_workflows_input {
    /// A builder for [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) workflow_type: std::option::Option<crate::model::WorkflowType>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) query_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) query_end_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.workflow_type = Some(input);
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.workflow_type = input;
            self
        }
        /// <p>Status of workflow execution.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Status of workflow execution.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// <p>Retrieve workflows started after timestamp.</p>
        pub fn query_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.query_start_date = Some(input);
            self
        }
        /// <p>Retrieve workflows started after timestamp.</p>
        pub fn set_query_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.query_start_date = input;
            self
        }
        /// <p>Retrieve workflows ended after timestamp.</p>
        pub fn query_end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.query_end_date = Some(input);
            self
        }
        /// <p>Retrieve workflows ended after timestamp.</p>
        pub fn set_query_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.query_end_date = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListWorkflowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListWorkflowsInput {
                domain_name: self.domain_name,
                workflow_type: self.workflow_type,
                status: self.status,
                query_start_date: self.query_start_date,
                query_end_date: self.query_end_date,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListWorkflowsInputOperationOutputAlias = crate::operation::ListWorkflows;
#[doc(hidden)]
pub type ListWorkflowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListWorkflowsInput {
    /// Consumes the builder and constructs an Operation<[`ListWorkflows`](crate::operation::ListWorkflows)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListWorkflows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListWorkflowsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.domain_name;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_52, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/workflows",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListWorkflowsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_53) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_53));
                }
                if let Some(inner_54) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_54).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListWorkflowsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_list_workflows(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListWorkflows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListWorkflows",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListWorkflowsInput`](crate::input::ListWorkflowsInput)
    pub fn builder() -> crate::input::list_workflows_input::Builder {
        crate::input::list_workflows_input::Builder::default()
    }
}

/// See [`MergeProfilesInput`](crate::input::MergeProfilesInput)
pub mod merge_profiles_input {
    /// A builder for [`MergeProfilesInput`](crate::input::MergeProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) main_profile_id: std::option::Option<std::string::String>,
        pub(crate) profile_ids_to_be_merged:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) field_source_profile_ids:
            std::option::Option<crate::model::FieldSourceProfileIds>,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The identifier of the profile to be taken.</p>
        pub fn main_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.main_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the profile to be taken.</p>
        pub fn set_main_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.main_profile_id = input;
            self
        }
        /// Appends an item to `profile_ids_to_be_merged`.
        ///
        /// To override the contents of this collection use [`set_profile_ids_to_be_merged`](Self::set_profile_ids_to_be_merged).
        ///
        /// <p>The identifier of the profile to be merged into MainProfileId.</p>
        pub fn profile_ids_to_be_merged(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.profile_ids_to_be_merged.unwrap_or_default();
            v.push(input.into());
            self.profile_ids_to_be_merged = Some(v);
            self
        }
        /// <p>The identifier of the profile to be merged into MainProfileId.</p>
        pub fn set_profile_ids_to_be_merged(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.profile_ids_to_be_merged = input;
            self
        }
        /// <p>The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
        pub fn field_source_profile_ids(
            mut self,
            input: crate::model::FieldSourceProfileIds,
        ) -> Self {
            self.field_source_profile_ids = Some(input);
            self
        }
        /// <p>The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
        pub fn set_field_source_profile_ids(
            mut self,
            input: std::option::Option<crate::model::FieldSourceProfileIds>,
        ) -> Self {
            self.field_source_profile_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeProfilesInput`](crate::input::MergeProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MergeProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MergeProfilesInput {
                domain_name: self.domain_name,
                main_profile_id: self.main_profile_id,
                profile_ids_to_be_merged: self.profile_ids_to_be_merged,
                field_source_profile_ids: self.field_source_profile_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type MergeProfilesInputOperationOutputAlias = crate::operation::MergeProfiles;
#[doc(hidden)]
pub type MergeProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl MergeProfilesInput {
    /// Consumes the builder and constructs an Operation<[`MergeProfiles`](crate::operation::MergeProfiles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MergeProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::MergeProfilesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_55 = &_input.domain_name;
                let input_55 = input_55.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_55, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/objects/merge",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::MergeProfilesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_merge_profiles(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MergeProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MergeProfiles",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`MergeProfilesInput`](crate::input::MergeProfilesInput)
    pub fn builder() -> crate::input::merge_profiles_input::Builder {
        crate::input::merge_profiles_input::Builder::default()
    }
}

/// See [`PutIntegrationInput`](crate::input::PutIntegrationInput)
pub mod put_integration_input {
    /// A builder for [`PutIntegrationInput`](crate::input::PutIntegrationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) flow_definition: std::option::Option<crate::model::FlowDefinition>,
        pub(crate) object_type_names: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the source.</p>
        pub fn flow_definition(mut self, input: crate::model::FlowDefinition) -> Self {
            self.flow_definition = Some(input);
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the source.</p>
        pub fn set_flow_definition(
            mut self,
            input: std::option::Option<crate::model::FlowDefinition>,
        ) -> Self {
            self.flow_definition = input;
            self
        }
        /// Adds a key-value pair to `object_type_names`.
        ///
        /// To override the contents of this collection use [`set_object_type_names`](Self::set_object_type_names).
        ///
        /// <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
        pub fn object_type_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.object_type_names.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.object_type_names = Some(hash_map);
            self
        }
        /// <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
        pub fn set_object_type_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.object_type_names = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntegrationInput`](crate::input::PutIntegrationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutIntegrationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutIntegrationInput {
                domain_name: self.domain_name,
                uri: self.uri,
                object_type_name: self.object_type_name,
                tags: self.tags,
                flow_definition: self.flow_definition,
                object_type_names: self.object_type_names,
            })
        }
    }
}
#[doc(hidden)]
pub type PutIntegrationInputOperationOutputAlias = crate::operation::PutIntegration;
#[doc(hidden)]
pub type PutIntegrationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutIntegrationInput {
    /// Consumes the builder and constructs an Operation<[`PutIntegration`](crate::operation::PutIntegration)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutIntegration,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutIntegrationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_56 = &_input.domain_name;
                let input_56 = input_56.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_56, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/integrations",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutIntegrationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_integration(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutIntegration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutIntegration",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutIntegrationInput`](crate::input::PutIntegrationInput)
    pub fn builder() -> crate::input::put_integration_input::Builder {
        crate::input::put_integration_input::Builder::default()
    }
}

/// See [`PutProfileObjectInput`](crate::input::PutProfileObjectInput)
pub mod put_profile_object_input {
    /// A builder for [`PutProfileObjectInput`](crate::input::PutProfileObjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>A string that is serialized from a JSON object.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>A string that is serialized from a JSON object.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProfileObjectInput`](crate::input::PutProfileObjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutProfileObjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutProfileObjectInput {
                object_type_name: self.object_type_name,
                object: self.object,
                domain_name: self.domain_name,
            })
        }
    }
}
#[doc(hidden)]
pub type PutProfileObjectInputOperationOutputAlias = crate::operation::PutProfileObject;
#[doc(hidden)]
pub type PutProfileObjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutProfileObjectInput {
    /// Consumes the builder and constructs an Operation<[`PutProfileObject`](crate::operation::PutProfileObject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutProfileObject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutProfileObjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_57 = &_input.domain_name;
                let input_57 = input_57.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_57, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/objects",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutProfileObjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_profile_object(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutProfileObject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutProfileObject",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutProfileObjectInput`](crate::input::PutProfileObjectInput)
    pub fn builder() -> crate::input::put_profile_object_input::Builder {
        crate::input::put_profile_object_input::Builder::default()
    }
}

/// See [`PutProfileObjectTypeInput`](crate::input::PutProfileObjectTypeInput)
pub mod put_profile_object_type_input {
    /// A builder for [`PutProfileObjectTypeInput`](crate::input::PutProfileObjectTypeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) expiration_days: std::option::Option<i32>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) allow_profile_creation: std::option::Option<bool>,
        pub(crate) source_last_updated_timestamp_format: std::option::Option<std::string::String>,
        pub(crate) fields: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
        >,
        pub(crate) keys: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ObjectTypeKey>,
            >,
        >,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn expiration_days(mut self, input: i32) -> Self {
            self.expiration_days = Some(input);
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn set_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.expiration_days = input;
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
        pub fn allow_profile_creation(mut self, input: bool) -> Self {
            self.allow_profile_creation = Some(input);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
        pub fn set_allow_profile_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_profile_creation = input;
            self
        }
        /// <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up. </p>
        pub fn source_last_updated_timestamp_format(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_last_updated_timestamp_format = Some(input.into());
            self
        }
        /// <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up. </p>
        pub fn set_source_last_updated_timestamp_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_last_updated_timestamp_format = input;
            self
        }
        /// Adds a key-value pair to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A map of the name and ObjectType field.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ObjectTypeField,
        ) -> Self {
            let mut hash_map = self.fields.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.fields = Some(hash_map);
            self
        }
        /// <p>A map of the name and ObjectType field.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
            >,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Adds a key-value pair to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn keys(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<crate::model::ObjectTypeKey>,
        ) -> Self {
            let mut hash_map = self.keys.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.keys = Some(hash_map);
            self
        }
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ObjectTypeKey>,
                >,
            >,
        ) -> Self {
            self.keys = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProfileObjectTypeInput`](crate::input::PutProfileObjectTypeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutProfileObjectTypeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutProfileObjectTypeInput {
                domain_name: self.domain_name,
                object_type_name: self.object_type_name,
                description: self.description,
                template_id: self.template_id,
                expiration_days: self.expiration_days,
                encryption_key: self.encryption_key,
                allow_profile_creation: self.allow_profile_creation.unwrap_or_default(),
                source_last_updated_timestamp_format: self.source_last_updated_timestamp_format,
                fields: self.fields,
                keys: self.keys,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type PutProfileObjectTypeInputOperationOutputAlias = crate::operation::PutProfileObjectType;
#[doc(hidden)]
pub type PutProfileObjectTypeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl PutProfileObjectTypeInput {
    /// Consumes the builder and constructs an Operation<[`PutProfileObjectType`](crate::operation::PutProfileObjectType)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutProfileObjectType,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::PutProfileObjectTypeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_58 = &_input.domain_name;
                let input_58 = input_58.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_58, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_59 = &_input.object_type_name;
                let input_59 = input_59.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "object_type_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let object_type_name = aws_smithy_http::label::fmt_string(input_59, false);
                if object_type_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "object_type_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/object-types/{ObjectTypeName}",
                    DomainName = domain_name,
                    ObjectTypeName = object_type_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::PutProfileObjectTypeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_put_profile_object_type(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutProfileObjectType::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutProfileObjectType",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`PutProfileObjectTypeInput`](crate::input::PutProfileObjectTypeInput)
    pub fn builder() -> crate::input::put_profile_object_type_input::Builder {
        crate::input::put_profile_object_type_input::Builder::default()
    }
}

/// See [`SearchProfilesInput`](crate::input::SearchProfilesInput)
pub mod search_profiles_input {
    /// A builder for [`SearchProfilesInput`](crate::input::SearchProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProfilesInput`](crate::input::SearchProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchProfilesInput {
                next_token: self.next_token,
                max_results: self.max_results,
                domain_name: self.domain_name,
                key_name: self.key_name,
                values: self.values,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchProfilesInputOperationOutputAlias = crate::operation::SearchProfiles;
#[doc(hidden)]
pub type SearchProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchProfilesInput {
    /// Consumes the builder and constructs an Operation<[`SearchProfiles`](crate::operation::SearchProfiles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::SearchProfilesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_60 = &_input.domain_name;
                let input_60 = input_60.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_60, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles/search",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::SearchProfilesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_61) = &_input.next_token {
                    query.push_kv("next-token", &aws_smithy_http::query::fmt_string(&inner_61));
                }
                if let Some(inner_62) = &_input.max_results {
                    query.push_kv(
                        "max-results",
                        aws_smithy_types::primitive::Encoder::from(*inner_62).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::SearchProfilesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_search_profiles(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchProfiles",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`SearchProfilesInput`](crate::input::SearchProfilesInput)
    pub fn builder() -> crate::input::search_profiles_input::Builder {
        crate::input::search_profiles_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The ARN of the resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_63 = &_input.resource_arn;
                let input_63 = input_63.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_63, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The ARN of the resource from which you are removing tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the resource from which you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_64 = &_input.resource_arn;
                let input_64 = input_64.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_64, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_65) = &_input.tag_keys {
                    for inner_66 in inner_65 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_66));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDomainInput`](crate::input::UpdateDomainInput)
pub mod update_domain_input {
    /// A builder for [`UpdateDomainInput`](crate::input::UpdateDomainInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) default_expiration_days: std::option::Option<i32>,
        pub(crate) default_encryption_key: std::option::Option<std::string::String>,
        pub(crate) dead_letter_queue_url: std::option::Option<std::string::String>,
        pub(crate) matching: std::option::Option<crate::model::MatchingRequest>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, input: i32) -> Self {
            self.default_expiration_days = Some(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.default_expiration_days = input;
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.</p>
        pub fn default_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_encryption_key = Some(input.into());
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_encryption_key = input;
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn dead_letter_queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.dead_letter_queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dead_letter_queue_url = input;
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn matching(mut self, input: crate::model::MatchingRequest) -> Self {
            self.matching = Some(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingRequest>,
        ) -> Self {
            self.matching = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainInput`](crate::input::UpdateDomainInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDomainInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDomainInput {
                domain_name: self.domain_name,
                default_expiration_days: self.default_expiration_days,
                default_encryption_key: self.default_encryption_key,
                dead_letter_queue_url: self.dead_letter_queue_url,
                matching: self.matching,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDomainInputOperationOutputAlias = crate::operation::UpdateDomain;
#[doc(hidden)]
pub type UpdateDomainInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDomainInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDomain`](crate::operation::UpdateDomain)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDomain,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDomainInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_67 = &_input.domain_name;
                let input_67 = input_67.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_67, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/domains/{DomainName}", DomainName = domain_name)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDomainInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_domain(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDomain::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDomain",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDomainInput`](crate::input::UpdateDomainInput)
    pub fn builder() -> crate::input::update_domain_input::Builder {
        crate::input::update_domain_input::Builder::default()
    }
}

/// See [`UpdateProfileInput`](crate::input::UpdateProfileInput)
pub mod update_profile_input {
    /// A builder for [`UpdateProfileInput`](crate::input::UpdateProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) additional_information: std::option::Option<std::string::String>,
        pub(crate) account_number: std::option::Option<std::string::String>,
        pub(crate) party_type: std::option::Option<crate::model::PartyType>,
        pub(crate) business_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) middle_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) birth_date: std::option::Option<std::string::String>,
        pub(crate) gender: std::option::Option<crate::model::Gender>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) mobile_phone_number: std::option::Option<std::string::String>,
        pub(crate) home_phone_number: std::option::Option<std::string::String>,
        pub(crate) business_phone_number: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) personal_email_address: std::option::Option<std::string::String>,
        pub(crate) business_email_address: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<crate::model::UpdateAddress>,
        pub(crate) shipping_address: std::option::Option<crate::model::UpdateAddress>,
        pub(crate) mailing_address: std::option::Option<crate::model::UpdateAddress>,
        pub(crate) billing_address: std::option::Option<crate::model::UpdateAddress>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn additional_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_information = Some(input.into());
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_information = input;
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_number = Some(input.into());
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_number = input;
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn party_type(mut self, input: crate::model::PartyType) -> Self {
            self.party_type = Some(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn set_party_type(
            mut self,
            input: std::option::Option<crate::model::PartyType>,
        ) -> Self {
            self.party_type = input;
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn business_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_name = Some(input.into());
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_name = input;
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn middle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.middle_name = Some(input.into());
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.middle_name = input;
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn birth_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.birth_date = Some(input.into());
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.birth_date = input;
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn gender(mut self, input: crate::model::Gender) -> Self {
            self.gender = Some(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.gender = input;
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn mobile_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.mobile_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_phone_number = input;
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn home_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_phone_number = input;
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn business_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_phone_number = input;
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn personal_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.personal_email_address = Some(input.into());
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.personal_email_address = input;
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn business_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_email_address = Some(input.into());
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_email_address = input;
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.address = Some(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn set_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.address = input;
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn shipping_address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.shipping_address = Some(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.shipping_address = input;
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn mailing_address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.mailing_address = Some(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.mailing_address = input;
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn billing_address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.billing_address = Some(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.billing_address = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProfileInput`](crate::input::UpdateProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateProfileInput {
                domain_name: self.domain_name,
                profile_id: self.profile_id,
                additional_information: self.additional_information,
                account_number: self.account_number,
                party_type: self.party_type,
                business_name: self.business_name,
                first_name: self.first_name,
                middle_name: self.middle_name,
                last_name: self.last_name,
                birth_date: self.birth_date,
                gender: self.gender,
                phone_number: self.phone_number,
                mobile_phone_number: self.mobile_phone_number,
                home_phone_number: self.home_phone_number,
                business_phone_number: self.business_phone_number,
                email_address: self.email_address,
                personal_email_address: self.personal_email_address,
                business_email_address: self.business_email_address,
                address: self.address,
                shipping_address: self.shipping_address,
                mailing_address: self.mailing_address,
                billing_address: self.billing_address,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateProfileInputOperationOutputAlias = crate::operation::UpdateProfile;
#[doc(hidden)]
pub type UpdateProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateProfileInput {
    /// Consumes the builder and constructs an Operation<[`UpdateProfile`](crate::operation::UpdateProfile)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateProfileInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_68 = &_input.domain_name;
                let input_68 = input_68.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let domain_name = aws_smithy_http::label::fmt_string(input_68, false);
                if domain_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "domain_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/domains/{DomainName}/profiles",
                    DomainName = domain_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateProfileInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PUT").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_profile(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateProfile",
            "customerprofiles",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateProfileInput`](crate::input::UpdateProfileInput)
    pub fn builder() -> crate::input::update_profile_input::Builder {
        crate::input::update_profile_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProfileInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>Any additional information relevant to the customer’s profile.</p>
    pub additional_information: std::option::Option<std::string::String>,
    /// <p>A unique account number that you have given to the customer.</p>
    pub account_number: std::option::Option<std::string::String>,
    /// <p>The type of profile used to describe the customer.</p>
    pub party_type: std::option::Option<crate::model::PartyType>,
    /// <p>The name of the customer’s business.</p>
    pub business_name: std::option::Option<std::string::String>,
    /// <p>The customer’s first name.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The customer’s middle name.</p>
    pub middle_name: std::option::Option<std::string::String>,
    /// <p>The customer’s last name.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The customer’s birth date. </p>
    pub birth_date: std::option::Option<std::string::String>,
    /// <p>The gender with which the customer identifies. </p>
    pub gender: std::option::Option<crate::model::Gender>,
    /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s mobile phone number.</p>
    pub mobile_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s home phone number.</p>
    pub home_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s business phone number.</p>
    pub business_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The customer’s personal email address.</p>
    pub personal_email_address: std::option::Option<std::string::String>,
    /// <p>The customer’s business email address.</p>
    pub business_email_address: std::option::Option<std::string::String>,
    /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
    pub address: std::option::Option<crate::model::UpdateAddress>,
    /// <p>The customer’s shipping address.</p>
    pub shipping_address: std::option::Option<crate::model::UpdateAddress>,
    /// <p>The customer’s mailing address.</p>
    pub mailing_address: std::option::Option<crate::model::UpdateAddress>,
    /// <p>The customer’s billing address.</p>
    pub billing_address: std::option::Option<crate::model::UpdateAddress>,
    /// <p>A key value pair of attributes of a customer profile.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateProfileInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
    /// <p>Any additional information relevant to the customer’s profile.</p>
    pub fn additional_information(&self) -> std::option::Option<&str> {
        self.additional_information.as_deref()
    }
    /// <p>A unique account number that you have given to the customer.</p>
    pub fn account_number(&self) -> std::option::Option<&str> {
        self.account_number.as_deref()
    }
    /// <p>The type of profile used to describe the customer.</p>
    pub fn party_type(&self) -> std::option::Option<&crate::model::PartyType> {
        self.party_type.as_ref()
    }
    /// <p>The name of the customer’s business.</p>
    pub fn business_name(&self) -> std::option::Option<&str> {
        self.business_name.as_deref()
    }
    /// <p>The customer’s first name.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>The customer’s middle name.</p>
    pub fn middle_name(&self) -> std::option::Option<&str> {
        self.middle_name.as_deref()
    }
    /// <p>The customer’s last name.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>The customer’s birth date. </p>
    pub fn birth_date(&self) -> std::option::Option<&str> {
        self.birth_date.as_deref()
    }
    /// <p>The gender with which the customer identifies. </p>
    pub fn gender(&self) -> std::option::Option<&crate::model::Gender> {
        self.gender.as_ref()
    }
    /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The customer’s mobile phone number.</p>
    pub fn mobile_phone_number(&self) -> std::option::Option<&str> {
        self.mobile_phone_number.as_deref()
    }
    /// <p>The customer’s home phone number.</p>
    pub fn home_phone_number(&self) -> std::option::Option<&str> {
        self.home_phone_number.as_deref()
    }
    /// <p>The customer’s business phone number.</p>
    pub fn business_phone_number(&self) -> std::option::Option<&str> {
        self.business_phone_number.as_deref()
    }
    /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The customer’s personal email address.</p>
    pub fn personal_email_address(&self) -> std::option::Option<&str> {
        self.personal_email_address.as_deref()
    }
    /// <p>The customer’s business email address.</p>
    pub fn business_email_address(&self) -> std::option::Option<&str> {
        self.business_email_address.as_deref()
    }
    /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
    pub fn address(&self) -> std::option::Option<&crate::model::UpdateAddress> {
        self.address.as_ref()
    }
    /// <p>The customer’s shipping address.</p>
    pub fn shipping_address(&self) -> std::option::Option<&crate::model::UpdateAddress> {
        self.shipping_address.as_ref()
    }
    /// <p>The customer’s mailing address.</p>
    pub fn mailing_address(&self) -> std::option::Option<&crate::model::UpdateAddress> {
        self.mailing_address.as_ref()
    }
    /// <p>The customer’s billing address.</p>
    pub fn billing_address(&self) -> std::option::Option<&crate::model::UpdateAddress> {
        self.billing_address.as_ref()
    }
    /// <p>A key value pair of attributes of a customer profile.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for UpdateProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProfileInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("profile_id", &self.profile_id);
        formatter.field("additional_information", &self.additional_information);
        formatter.field("account_number", &self.account_number);
        formatter.field("party_type", &self.party_type);
        formatter.field("business_name", &self.business_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("middle_name", &self.middle_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("birth_date", &self.birth_date);
        formatter.field("gender", &self.gender);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("mobile_phone_number", &self.mobile_phone_number);
        formatter.field("home_phone_number", &self.home_phone_number);
        formatter.field("business_phone_number", &self.business_phone_number);
        formatter.field("email_address", &self.email_address);
        formatter.field("personal_email_address", &self.personal_email_address);
        formatter.field("business_email_address", &self.business_email_address);
        formatter.field("address", &self.address);
        formatter.field("shipping_address", &self.shipping_address);
        formatter.field("mailing_address", &self.mailing_address);
        formatter.field("billing_address", &self.billing_address);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The default number of days until the data within the domain expires.</p>
    pub default_expiration_days: std::option::Option<i32>,
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.</p>
    pub default_encryption_key: std::option::Option<std::string::String>,
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
    pub dead_letter_queue_url: std::option::Option<std::string::String>,
    /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
    /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    pub matching: std::option::Option<crate::model::MatchingRequest>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateDomainInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The default number of days until the data within the domain expires.</p>
    pub fn default_expiration_days(&self) -> std::option::Option<i32> {
        self.default_expiration_days
    }
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.</p>
    pub fn default_encryption_key(&self) -> std::option::Option<&str> {
        self.default_encryption_key.as_deref()
    }
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
    pub fn dead_letter_queue_url(&self) -> std::option::Option<&str> {
        self.dead_letter_queue_url.as_deref()
    }
    /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
    /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    pub fn matching(&self) -> std::option::Option<&crate::model::MatchingRequest> {
        self.matching.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("default_expiration_days", &self.default_expiration_days);
        formatter.field("default_encryption_key", &self.default_encryption_key);
        formatter.field("dead_letter_queue_url", &self.dead_letter_queue_url);
        formatter.field("matching", &self.matching);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The ARN of the resource from which you are removing tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The list of tag keys to remove from the resource.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The ARN of the resource from which you are removing tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The list of tag keys to remove from the resource.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The ARN of the resource that you're adding tags to.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The ARN of the resource that you're adding tags to.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProfilesInput {
    /// <p>The pagination token from the previous SearchProfiles API call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects returned per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>A list of key values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SearchProfilesInput {
    /// <p>The pagination token from the previous SearchProfiles API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>A list of key values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for SearchProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProfilesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("key_name", &self.key_name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProfileObjectTypeInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>Description of the profile object type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the object template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The number of days until the data in the object expires.</p>
    pub expiration_days: std::option::Option<i32>,
    /// <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
    pub allow_profile_creation: bool,
    /// <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up. </p>
    pub source_last_updated_timestamp_format: std::option::Option<std::string::String>,
    /// <p>A map of the name and ObjectType field.</p>
    pub fields: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    >,
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub keys: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    >,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutProfileObjectTypeInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>Description of the profile object type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A unique identifier for the object template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The number of days until the data in the object expires.</p>
    pub fn expiration_days(&self) -> std::option::Option<i32> {
        self.expiration_days
    }
    /// <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
    pub fn allow_profile_creation(&self) -> bool {
        self.allow_profile_creation
    }
    /// <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up. </p>
    pub fn source_last_updated_timestamp_format(&self) -> std::option::Option<&str> {
        self.source_last_updated_timestamp_format.as_deref()
    }
    /// <p>A map of the name and ObjectType field.</p>
    pub fn fields(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    > {
        self.fields.as_ref()
    }
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub fn keys(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    > {
        self.keys.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for PutProfileObjectTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProfileObjectTypeInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("description", &self.description);
        formatter.field("template_id", &self.template_id);
        formatter.field("expiration_days", &self.expiration_days);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("allow_profile_creation", &self.allow_profile_creation);
        formatter.field(
            "source_last_updated_timestamp_format",
            &self.source_last_updated_timestamp_format,
        );
        formatter.field("fields", &self.fields);
        formatter.field("keys", &self.keys);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProfileObjectInput {
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>A string that is serialized from a JSON object.</p>
    pub object: std::option::Option<std::string::String>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl PutProfileObjectInput {
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>A string that is serialized from a JSON object.</p>
    pub fn object(&self) -> std::option::Option<&str> {
        self.object.as_deref()
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for PutProfileObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProfileObjectInput");
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("object", &self.object);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIntegrationInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The configuration that controls how Customer Profiles retrieves data from the source.</p>
    pub flow_definition: std::option::Option<crate::model::FlowDefinition>,
    /// <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
    pub object_type_names:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutIntegrationInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The configuration that controls how Customer Profiles retrieves data from the source.</p>
    pub fn flow_definition(&self) -> std::option::Option<&crate::model::FlowDefinition> {
        self.flow_definition.as_ref()
    }
    /// <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
    pub fn object_type_names(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.object_type_names.as_ref()
    }
}
impl std::fmt::Debug for PutIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIntegrationInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("uri", &self.uri);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("tags", &self.tags);
        formatter.field("flow_definition", &self.flow_definition);
        formatter.field("object_type_names", &self.object_type_names);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeProfilesInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the profile to be taken.</p>
    pub main_profile_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the profile to be merged into MainProfileId.</p>
    pub profile_ids_to_be_merged: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
    pub field_source_profile_ids: std::option::Option<crate::model::FieldSourceProfileIds>,
}
impl MergeProfilesInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The identifier of the profile to be taken.</p>
    pub fn main_profile_id(&self) -> std::option::Option<&str> {
        self.main_profile_id.as_deref()
    }
    /// <p>The identifier of the profile to be merged into MainProfileId.</p>
    pub fn profile_ids_to_be_merged(&self) -> std::option::Option<&[std::string::String]> {
        self.profile_ids_to_be_merged.as_deref()
    }
    /// <p>The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
    pub fn field_source_profile_ids(
        &self,
    ) -> std::option::Option<&crate::model::FieldSourceProfileIds> {
        self.field_source_profile_ids.as_ref()
    }
}
impl std::fmt::Debug for MergeProfilesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeProfilesInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("main_profile_id", &self.main_profile_id);
        formatter.field("profile_ids_to_be_merged", &self.profile_ids_to_be_merged);
        formatter.field("field_source_profile_ids", &self.field_source_profile_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListWorkflowsInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>Status of workflow execution.</p>
    pub status: std::option::Option<crate::model::Status>,
    /// <p>Retrieve workflows started after timestamp.</p>
    pub query_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Retrieve workflows ended after timestamp.</p>
    pub query_end_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListWorkflowsInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>Status of workflow execution.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
    /// <p>Retrieve workflows started after timestamp.</p>
    pub fn query_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.query_start_date.as_ref()
    }
    /// <p>Retrieve workflows ended after timestamp.</p>
    pub fn query_end_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.query_end_date.as_ref()
    }
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListWorkflowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListWorkflowsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("status", &self.status);
        formatter.field("query_start_date", &self.query_start_date);
        formatter.field("query_end_date", &self.query_end_date);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The ARN of the resource for which you want to view tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The ARN of the resource for which you want to view tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectTypeTemplatesInput {
    /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects returned per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProfileObjectTypeTemplatesInput {
    /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProfileObjectTypeTemplatesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectTypeTemplatesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectTypesInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects returned per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProfileObjectTypesInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Identifies the next page of results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProfileObjectTypesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectTypesInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectsInput {
    /// <p>The pagination token from the previous call to ListProfileObjects.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects returned per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>Applies a filter to the response to include profile objects with the specified index values. This filter is only supported for ObjectTypeName _asset, _case and _order.</p>
    pub object_filter: std::option::Option<crate::model::ObjectFilter>,
}
impl ListProfileObjectsInput {
    /// <p>The pagination token from the previous call to ListProfileObjects.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
    /// <p>Applies a filter to the response to include profile objects with the specified index values. This filter is only supported for ObjectTypeName _asset, _case and _order.</p>
    pub fn object_filter(&self) -> std::option::Option<&crate::model::ObjectFilter> {
        self.object_filter.as_ref()
    }
}
impl std::fmt::Debug for ListProfileObjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("domain_name", &self.domain_name);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("profile_id", &self.profile_id);
        formatter.field("object_filter", &self.object_filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIntegrationsInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The pagination token from the previous ListIntegrations API call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects returned per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
    pub include_hidden: std::option::Option<bool>,
}
impl ListIntegrationsInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The pagination token from the previous ListIntegrations API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
    pub fn include_hidden(&self) -> std::option::Option<bool> {
        self.include_hidden
    }
}
impl std::fmt::Debug for ListIntegrationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIntegrationsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("include_hidden", &self.include_hidden);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIdentityResolutionJobsInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListIdentityResolutionJobsInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListIdentityResolutionJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIdentityResolutionJobsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsInput {
    /// <p>The pagination token from the previous ListDomain API call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects returned per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListDomainsInput {
    /// <p>The pagination token from the previous ListDomain API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListDomainsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountIntegrationsInput {
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects returned per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
    pub include_hidden: std::option::Option<bool>,
}
impl ListAccountIntegrationsInput {
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of objects returned per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
    pub fn include_hidden(&self) -> std::option::Option<bool> {
        self.include_hidden
    }
}
impl std::fmt::Debug for ListAccountIntegrationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountIntegrationsInput");
        formatter.field("uri", &self.uri);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("include_hidden", &self.include_hidden);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkflowStepsInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetWorkflowStepsInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetWorkflowStepsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkflowStepsInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetWorkflowInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl GetWorkflowInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for GetWorkflowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetWorkflowInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProfileObjectTypeTemplateInput {
    /// <p>A unique identifier for the object template.</p>
    pub template_id: std::option::Option<std::string::String>,
}
impl GetProfileObjectTypeTemplateInput {
    /// <p>A unique identifier for the object template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
}
impl std::fmt::Debug for GetProfileObjectTypeTemplateInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProfileObjectTypeTemplateInput");
        formatter.field("template_id", &self.template_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProfileObjectTypeInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
}
impl GetProfileObjectTypeInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
}
impl std::fmt::Debug for GetProfileObjectTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProfileObjectTypeInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMatchesInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per page.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetMatchesInput {
    /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per page.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetMatchesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMatchesInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub uri: std::option::Option<std::string::String>,
}
impl GetIntegrationInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
}
impl std::fmt::Debug for GetIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("uri", &self.uri);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIdentityResolutionJobInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the Identity Resolution Job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl GetIdentityResolutionJobInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The unique identifier of the Identity Resolution Job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for GetIdentityResolutionJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIdentityResolutionJobInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl GetDomainInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for GetDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAutoMergingPreviewInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A list of matching attributes that represent matching criteria.</p>
    pub consolidation: std::option::Option<crate::model::Consolidation>,
    /// <p>How the auto-merging process should resolve conflicts between different profiles.</p>
    pub conflict_resolution: std::option::Option<crate::model::ConflictResolution>,
}
impl GetAutoMergingPreviewInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A list of matching attributes that represent matching criteria.</p>
    pub fn consolidation(&self) -> std::option::Option<&crate::model::Consolidation> {
        self.consolidation.as_ref()
    }
    /// <p>How the auto-merging process should resolve conflicts between different profiles.</p>
    pub fn conflict_resolution(&self) -> std::option::Option<&crate::model::ConflictResolution> {
        self.conflict_resolution.as_ref()
    }
}
impl std::fmt::Debug for GetAutoMergingPreviewInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAutoMergingPreviewInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("consolidation", &self.consolidation);
        formatter.field("conflict_resolution", &self.conflict_resolution);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteWorkflowInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>Unique identifier for the workflow.</p>
    pub workflow_id: std::option::Option<std::string::String>,
}
impl DeleteWorkflowInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>Unique identifier for the workflow.</p>
    pub fn workflow_id(&self) -> std::option::Option<&str> {
        self.workflow_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteWorkflowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteWorkflowInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("workflow_id", &self.workflow_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileObjectTypeInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
}
impl DeleteProfileObjectTypeInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileObjectTypeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileObjectTypeInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileObjectInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the profile object generated by the service.</p>
    pub profile_object_unique_key: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteProfileObjectInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
    /// <p>The unique identifier of the profile object generated by the service.</p>
    pub fn profile_object_unique_key(&self) -> std::option::Option<&str> {
        self.profile_object_unique_key.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileObjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileObjectInput");
        formatter.field("profile_id", &self.profile_id);
        formatter.field("profile_object_unique_key", &self.profile_object_unique_key);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileKeyInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>A searchable identifier of a customer profile.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>A list of key values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteProfileKeyInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
    /// <p>A searchable identifier of a customer profile.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>A list of key values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileKeyInput");
        formatter.field("profile_id", &self.profile_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("values", &self.values);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteProfileInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileInput");
        formatter.field("profile_id", &self.profile_id);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntegrationInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub uri: std::option::Option<std::string::String>,
}
impl DeleteIntegrationInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
}
impl std::fmt::Debug for DeleteIntegrationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntegrationInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("uri", &self.uri);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DeleteDomainInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProfileInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>A unique account number that you have given to the customer.</p>
    pub account_number: std::option::Option<std::string::String>,
    /// <p>Any additional information relevant to the customer’s profile.</p>
    pub additional_information: std::option::Option<std::string::String>,
    /// <p>The type of profile used to describe the customer.</p>
    pub party_type: std::option::Option<crate::model::PartyType>,
    /// <p>The name of the customer’s business.</p>
    pub business_name: std::option::Option<std::string::String>,
    /// <p>The customer’s first name.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The customer’s middle name.</p>
    pub middle_name: std::option::Option<std::string::String>,
    /// <p>The customer’s last name.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The customer’s birth date. </p>
    pub birth_date: std::option::Option<std::string::String>,
    /// <p>The gender with which the customer identifies. </p>
    pub gender: std::option::Option<crate::model::Gender>,
    /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s mobile phone number.</p>
    pub mobile_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s home phone number.</p>
    pub home_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s business phone number.</p>
    pub business_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The customer’s personal email address.</p>
    pub personal_email_address: std::option::Option<std::string::String>,
    /// <p>The customer’s business email address.</p>
    pub business_email_address: std::option::Option<std::string::String>,
    /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
    pub address: std::option::Option<crate::model::Address>,
    /// <p>The customer’s shipping address.</p>
    pub shipping_address: std::option::Option<crate::model::Address>,
    /// <p>The customer’s mailing address.</p>
    pub mailing_address: std::option::Option<crate::model::Address>,
    /// <p>The customer’s billing address.</p>
    pub billing_address: std::option::Option<crate::model::Address>,
    /// <p>A key value pair of attributes of a customer profile.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateProfileInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>A unique account number that you have given to the customer.</p>
    pub fn account_number(&self) -> std::option::Option<&str> {
        self.account_number.as_deref()
    }
    /// <p>Any additional information relevant to the customer’s profile.</p>
    pub fn additional_information(&self) -> std::option::Option<&str> {
        self.additional_information.as_deref()
    }
    /// <p>The type of profile used to describe the customer.</p>
    pub fn party_type(&self) -> std::option::Option<&crate::model::PartyType> {
        self.party_type.as_ref()
    }
    /// <p>The name of the customer’s business.</p>
    pub fn business_name(&self) -> std::option::Option<&str> {
        self.business_name.as_deref()
    }
    /// <p>The customer’s first name.</p>
    pub fn first_name(&self) -> std::option::Option<&str> {
        self.first_name.as_deref()
    }
    /// <p>The customer’s middle name.</p>
    pub fn middle_name(&self) -> std::option::Option<&str> {
        self.middle_name.as_deref()
    }
    /// <p>The customer’s last name.</p>
    pub fn last_name(&self) -> std::option::Option<&str> {
        self.last_name.as_deref()
    }
    /// <p>The customer’s birth date. </p>
    pub fn birth_date(&self) -> std::option::Option<&str> {
        self.birth_date.as_deref()
    }
    /// <p>The gender with which the customer identifies. </p>
    pub fn gender(&self) -> std::option::Option<&crate::model::Gender> {
        self.gender.as_ref()
    }
    /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
    pub fn phone_number(&self) -> std::option::Option<&str> {
        self.phone_number.as_deref()
    }
    /// <p>The customer’s mobile phone number.</p>
    pub fn mobile_phone_number(&self) -> std::option::Option<&str> {
        self.mobile_phone_number.as_deref()
    }
    /// <p>The customer’s home phone number.</p>
    pub fn home_phone_number(&self) -> std::option::Option<&str> {
        self.home_phone_number.as_deref()
    }
    /// <p>The customer’s business phone number.</p>
    pub fn business_phone_number(&self) -> std::option::Option<&str> {
        self.business_phone_number.as_deref()
    }
    /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
    pub fn email_address(&self) -> std::option::Option<&str> {
        self.email_address.as_deref()
    }
    /// <p>The customer’s personal email address.</p>
    pub fn personal_email_address(&self) -> std::option::Option<&str> {
        self.personal_email_address.as_deref()
    }
    /// <p>The customer’s business email address.</p>
    pub fn business_email_address(&self) -> std::option::Option<&str> {
        self.business_email_address.as_deref()
    }
    /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
    pub fn address(&self) -> std::option::Option<&crate::model::Address> {
        self.address.as_ref()
    }
    /// <p>The customer’s shipping address.</p>
    pub fn shipping_address(&self) -> std::option::Option<&crate::model::Address> {
        self.shipping_address.as_ref()
    }
    /// <p>The customer’s mailing address.</p>
    pub fn mailing_address(&self) -> std::option::Option<&crate::model::Address> {
        self.mailing_address.as_ref()
    }
    /// <p>The customer’s billing address.</p>
    pub fn billing_address(&self) -> std::option::Option<&crate::model::Address> {
        self.billing_address.as_ref()
    }
    /// <p>A key value pair of attributes of a customer profile.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for CreateProfileInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProfileInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("account_number", &self.account_number);
        formatter.field("additional_information", &self.additional_information);
        formatter.field("party_type", &self.party_type);
        formatter.field("business_name", &self.business_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("middle_name", &self.middle_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("birth_date", &self.birth_date);
        formatter.field("gender", &self.gender);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("mobile_phone_number", &self.mobile_phone_number);
        formatter.field("home_phone_number", &self.home_phone_number);
        formatter.field("business_phone_number", &self.business_phone_number);
        formatter.field("email_address", &self.email_address);
        formatter.field("personal_email_address", &self.personal_email_address);
        formatter.field("business_email_address", &self.business_email_address);
        formatter.field("address", &self.address);
        formatter.field("shipping_address", &self.shipping_address);
        formatter.field("mailing_address", &self.mailing_address);
        formatter.field("billing_address", &self.billing_address);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateIntegrationWorkflowInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    pub workflow_type: std::option::Option<crate::model::WorkflowType>,
    /// <p>Configuration data for integration workflow.</p>
    pub integration_config: std::option::Option<crate::model::IntegrationConfig>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your behalf as part of workflow execution.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateIntegrationWorkflowInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    pub fn workflow_type(&self) -> std::option::Option<&crate::model::WorkflowType> {
        self.workflow_type.as_ref()
    }
    /// <p>Configuration data for integration workflow.</p>
    pub fn integration_config(&self) -> std::option::Option<&crate::model::IntegrationConfig> {
        self.integration_config.as_ref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your behalf as part of workflow execution.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateIntegrationWorkflowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateIntegrationWorkflowInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("workflow_type", &self.workflow_type);
        formatter.field("integration_config", &self.integration_config);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainInput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The default number of days until the data within the domain expires.</p>
    pub default_expiration_days: std::option::Option<i32>,
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
    pub default_encryption_key: std::option::Option<std::string::String>,
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
    pub dead_letter_queue_url: std::option::Option<std::string::String>,
    /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
    /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    pub matching: std::option::Option<crate::model::MatchingRequest>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDomainInput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The default number of days until the data within the domain expires.</p>
    pub fn default_expiration_days(&self) -> std::option::Option<i32> {
        self.default_expiration_days
    }
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
    pub fn default_encryption_key(&self) -> std::option::Option<&str> {
        self.default_encryption_key.as_deref()
    }
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
    pub fn dead_letter_queue_url(&self) -> std::option::Option<&str> {
        self.dead_letter_queue_url.as_deref()
    }
    /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
    /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    pub fn matching(&self) -> std::option::Option<&crate::model::MatchingRequest> {
        self.matching.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainInput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("default_expiration_days", &self.default_expiration_days);
        formatter.field("default_encryption_key", &self.default_encryption_key);
        formatter.field("dead_letter_queue_url", &self.dead_letter_queue_url);
        formatter.field("matching", &self.matching);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddProfileKeyInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>A searchable identifier of a customer profile.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>A list of key values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl AddProfileKeyInput {
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
    /// <p>A searchable identifier of a customer profile.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>A list of key values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for AddProfileKeyInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddProfileKeyInput");
        formatter.field("profile_id", &self.profile_id);
        formatter.field("key_name", &self.key_name);
        formatter.field("values", &self.values);
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}
