// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Connect Customer Profiles
///
/// Client for invoking operations on Amazon Connect Customer Profiles. Each operation on Amazon Connect Customer Profiles is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_customerprofiles::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_customerprofiles::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_customerprofiles::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddProfileKey`](crate::client::fluent_builders::AddProfileKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_id(impl Into<String>)`](crate::client::fluent_builders::AddProfileKey::profile_id) / [`set_profile_id(Option<String>)`](crate::client::fluent_builders::AddProfileKey::set_profile_id): <p>The unique identifier of a customer profile.</p>
    ///   - [`key_name(impl Into<String>)`](crate::client::fluent_builders::AddProfileKey::key_name) / [`set_key_name(Option<String>)`](crate::client::fluent_builders::AddProfileKey::set_key_name): <p>A searchable identifier of a customer profile.</p>
    ///   - [`values(Vec<String>)`](crate::client::fluent_builders::AddProfileKey::values) / [`set_values(Option<Vec<String>>)`](crate::client::fluent_builders::AddProfileKey::set_values): <p>A list of key values.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::AddProfileKey::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::AddProfileKey::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`AddProfileKeyOutput`](crate::output::AddProfileKeyOutput) with field(s):
    ///   - [`key_name(Option<String>)`](crate::output::AddProfileKeyOutput::key_name): <p>A searchable identifier of a customer profile.</p>
    ///   - [`values(Option<Vec<String>>)`](crate::output::AddProfileKeyOutput::values): <p>A list of key values.</p>
    /// - On failure, responds with [`SdkError<AddProfileKeyError>`](crate::error::AddProfileKeyError)
    pub fn add_profile_key(&self) -> fluent_builders::AddProfileKey {
        fluent_builders::AddProfileKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDomain`](crate::client::fluent_builders::CreateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`default_expiration_days(i32)`](crate::client::fluent_builders::CreateDomain::default_expiration_days) / [`set_default_expiration_days(Option<i32>)`](crate::client::fluent_builders::CreateDomain::set_default_expiration_days): <p>The default number of days until the data within the domain expires.</p>
    ///   - [`default_encryption_key(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::default_encryption_key) / [`set_default_encryption_key(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_default_encryption_key): <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
    ///   - [`dead_letter_queue_url(impl Into<String>)`](crate::client::fluent_builders::CreateDomain::dead_letter_queue_url) / [`set_dead_letter_queue_url(Option<String>)`](crate::client::fluent_builders::CreateDomain::set_dead_letter_queue_url): <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
    ///   - [`matching(MatchingRequest)`](crate::client::fluent_builders::CreateDomain::matching) / [`set_matching(Option<MatchingRequest>)`](crate::client::fluent_builders::CreateDomain::set_matching): <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>  <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateDomain::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateDomain::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateDomainOutput`](crate::output::CreateDomainOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::CreateDomainOutput::domain_name): <p>The unique name of the domain.</p>
    ///   - [`default_expiration_days(Option<i32>)`](crate::output::CreateDomainOutput::default_expiration_days): <p>The default number of days until the data within the domain expires.</p>
    ///   - [`default_encryption_key(Option<String>)`](crate::output::CreateDomainOutput::default_encryption_key): <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
    ///   - [`dead_letter_queue_url(Option<String>)`](crate::output::CreateDomainOutput::dead_letter_queue_url): <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.</p>
    ///   - [`matching(Option<MatchingResponse>)`](crate::output::CreateDomainOutput::matching): <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>  <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::CreateDomainOutput::created_at): <p>The timestamp of when the domain was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::CreateDomainOutput::last_updated_at): <p>The timestamp of when the domain was most recently edited.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::CreateDomainOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On failure, responds with [`SdkError<CreateDomainError>`](crate::error::CreateDomainError)
    pub fn create_domain(&self) -> fluent_builders::CreateDomain {
        fluent_builders::CreateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIntegrationWorkflow`](crate::client::fluent_builders::CreateIntegrationWorkflow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`workflow_type(WorkflowType)`](crate::client::fluent_builders::CreateIntegrationWorkflow::workflow_type) / [`set_workflow_type(Option<WorkflowType>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::set_workflow_type): <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    ///   - [`integration_config(IntegrationConfig)`](crate::client::fluent_builders::CreateIntegrationWorkflow::integration_config) / [`set_integration_config(Option<IntegrationConfig>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::set_integration_config): <p>Configuration data for integration workflow.</p>
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::set_object_type_name): <p>The name of the profile object type.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your behalf as part of workflow execution.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIntegrationWorkflow::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateIntegrationWorkflowOutput`](crate::output::CreateIntegrationWorkflowOutput) with field(s):
    ///   - [`workflow_id(Option<String>)`](crate::output::CreateIntegrationWorkflowOutput::workflow_id): <p>Unique identifier for the workflow.</p>
    ///   - [`message(Option<String>)`](crate::output::CreateIntegrationWorkflowOutput::message): <p>A message indicating create request was received.</p>
    /// - On failure, responds with [`SdkError<CreateIntegrationWorkflowError>`](crate::error::CreateIntegrationWorkflowError)
    pub fn create_integration_workflow(&self) -> fluent_builders::CreateIntegrationWorkflow {
        fluent_builders::CreateIntegrationWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProfile`](crate::client::fluent_builders::CreateProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`account_number(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::account_number) / [`set_account_number(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_account_number): <p>A unique account number that you have given to the customer.</p>
    ///   - [`additional_information(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::additional_information) / [`set_additional_information(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_additional_information): <p>Any additional information relevant to the customer’s profile.</p>
    ///   - [`party_type(PartyType)`](crate::client::fluent_builders::CreateProfile::party_type) / [`set_party_type(Option<PartyType>)`](crate::client::fluent_builders::CreateProfile::set_party_type): <p>The type of profile used to describe the customer.</p>
    ///   - [`business_name(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::business_name) / [`set_business_name(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_business_name): <p>The name of the customer’s business.</p>
    ///   - [`first_name(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::first_name) / [`set_first_name(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_first_name): <p>The customer’s first name.</p>
    ///   - [`middle_name(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::middle_name) / [`set_middle_name(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_middle_name): <p>The customer’s middle name.</p>
    ///   - [`last_name(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::last_name) / [`set_last_name(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_last_name): <p>The customer’s last name.</p>
    ///   - [`birth_date(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::birth_date) / [`set_birth_date(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_birth_date): <p>The customer’s birth date. </p>
    ///   - [`gender(Gender)`](crate::client::fluent_builders::CreateProfile::gender) / [`set_gender(Option<Gender>)`](crate::client::fluent_builders::CreateProfile::set_gender): <p>The gender with which the customer identifies. </p>
    ///   - [`phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::phone_number) / [`set_phone_number(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_phone_number): <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
    ///   - [`mobile_phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::mobile_phone_number) / [`set_mobile_phone_number(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_mobile_phone_number): <p>The customer’s mobile phone number.</p>
    ///   - [`home_phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::home_phone_number) / [`set_home_phone_number(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_home_phone_number): <p>The customer’s home phone number.</p>
    ///   - [`business_phone_number(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::business_phone_number) / [`set_business_phone_number(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_business_phone_number): <p>The customer’s business phone number.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_email_address): <p>The customer’s email address, which has not been specified as a personal or business address. </p>
    ///   - [`personal_email_address(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::personal_email_address) / [`set_personal_email_address(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_personal_email_address): <p>The customer’s personal email address.</p>
    ///   - [`business_email_address(impl Into<String>)`](crate::client::fluent_builders::CreateProfile::business_email_address) / [`set_business_email_address(Option<String>)`](crate::client::fluent_builders::CreateProfile::set_business_email_address): <p>The customer’s business email address.</p>
    ///   - [`address(Address)`](crate::client::fluent_builders::CreateProfile::address) / [`set_address(Option<Address>)`](crate::client::fluent_builders::CreateProfile::set_address): <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
    ///   - [`shipping_address(Address)`](crate::client::fluent_builders::CreateProfile::shipping_address) / [`set_shipping_address(Option<Address>)`](crate::client::fluent_builders::CreateProfile::set_shipping_address): <p>The customer’s shipping address.</p>
    ///   - [`mailing_address(Address)`](crate::client::fluent_builders::CreateProfile::mailing_address) / [`set_mailing_address(Option<Address>)`](crate::client::fluent_builders::CreateProfile::set_mailing_address): <p>The customer’s mailing address.</p>
    ///   - [`billing_address(Address)`](crate::client::fluent_builders::CreateProfile::billing_address) / [`set_billing_address(Option<Address>)`](crate::client::fluent_builders::CreateProfile::set_billing_address): <p>The customer’s billing address.</p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::CreateProfile::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProfile::set_attributes): <p>A key value pair of attributes of a customer profile.</p>
    /// - On success, responds with [`CreateProfileOutput`](crate::output::CreateProfileOutput) with field(s):
    ///   - [`profile_id(Option<String>)`](crate::output::CreateProfileOutput::profile_id): <p>The unique identifier of a customer profile.</p>
    /// - On failure, responds with [`SdkError<CreateProfileError>`](crate::error::CreateProfileError)
    pub fn create_profile(&self) -> fluent_builders::CreateProfile {
        fluent_builders::CreateProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDomain`](crate::client::fluent_builders::DeleteDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteDomain::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`DeleteDomainOutput`](crate::output::DeleteDomainOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::DeleteDomainOutput::message): <p>A message that indicates the delete request is done.</p>
    /// - On failure, responds with [`SdkError<DeleteDomainError>`](crate::error::DeleteDomainError)
    pub fn delete_domain(&self) -> fluent_builders::DeleteDomain {
        fluent_builders::DeleteDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntegration`](crate::client::fluent_builders::DeleteIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegration::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteIntegration::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`uri(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegration::uri) / [`set_uri(Option<String>)`](crate::client::fluent_builders::DeleteIntegration::set_uri): <p>The URI of the S3 bucket or any other type of data source.</p>
    /// - On success, responds with [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::DeleteIntegrationOutput::message): <p>A message that indicates the delete request is done.</p>
    /// - On failure, responds with [`SdkError<DeleteIntegrationError>`](crate::error::DeleteIntegrationError)
    pub fn delete_integration(&self) -> fluent_builders::DeleteIntegration {
        fluent_builders::DeleteIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProfile`](crate::client::fluent_builders::DeleteProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProfile::profile_id) / [`set_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteProfile::set_profile_id): <p>The unique identifier of a customer profile.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProfile::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteProfile::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`DeleteProfileOutput`](crate::output::DeleteProfileOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::DeleteProfileOutput::message): <p>A message that indicates the delete request is done.</p>
    /// - On failure, responds with [`SdkError<DeleteProfileError>`](crate::error::DeleteProfileError)
    pub fn delete_profile(&self) -> fluent_builders::DeleteProfile {
        fluent_builders::DeleteProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProfileKey`](crate::client::fluent_builders::DeleteProfileKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileKey::profile_id) / [`set_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteProfileKey::set_profile_id): <p>The unique identifier of a customer profile.</p>
    ///   - [`key_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileKey::key_name) / [`set_key_name(Option<String>)`](crate::client::fluent_builders::DeleteProfileKey::set_key_name): <p>A searchable identifier of a customer profile.</p>
    ///   - [`values(Vec<String>)`](crate::client::fluent_builders::DeleteProfileKey::values) / [`set_values(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteProfileKey::set_values): <p>A list of key values.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileKey::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteProfileKey::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`DeleteProfileKeyOutput`](crate::output::DeleteProfileKeyOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::DeleteProfileKeyOutput::message): <p>A message that indicates the delete request is done.</p>
    /// - On failure, responds with [`SdkError<DeleteProfileKeyError>`](crate::error::DeleteProfileKeyError)
    pub fn delete_profile_key(&self) -> fluent_builders::DeleteProfileKey {
        fluent_builders::DeleteProfileKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProfileObject`](crate::client::fluent_builders::DeleteProfileObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileObject::profile_id) / [`set_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteProfileObject::set_profile_id): <p>The unique identifier of a customer profile.</p>
    ///   - [`profile_object_unique_key(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileObject::profile_object_unique_key) / [`set_profile_object_unique_key(Option<String>)`](crate::client::fluent_builders::DeleteProfileObject::set_profile_object_unique_key): <p>The unique identifier of the profile object generated by the service.</p>
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileObject::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::DeleteProfileObject::set_object_type_name): <p>The name of the profile object type.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileObject::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteProfileObject::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`DeleteProfileObjectOutput`](crate::output::DeleteProfileObjectOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::DeleteProfileObjectOutput::message): <p>A message that indicates the delete request is done.</p>
    /// - On failure, responds with [`SdkError<DeleteProfileObjectError>`](crate::error::DeleteProfileObjectError)
    pub fn delete_profile_object(&self) -> fluent_builders::DeleteProfileObject {
        fluent_builders::DeleteProfileObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProfileObjectType`](crate::client::fluent_builders::DeleteProfileObjectType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileObjectType::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteProfileObjectType::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProfileObjectType::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::DeleteProfileObjectType::set_object_type_name): <p>The name of the profile object type.</p>
    /// - On success, responds with [`DeleteProfileObjectTypeOutput`](crate::output::DeleteProfileObjectTypeOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::DeleteProfileObjectTypeOutput::message): <p>A message that indicates the delete request is done.</p>
    /// - On failure, responds with [`SdkError<DeleteProfileObjectTypeError>`](crate::error::DeleteProfileObjectTypeError)
    pub fn delete_profile_object_type(&self) -> fluent_builders::DeleteProfileObjectType {
        fluent_builders::DeleteProfileObjectType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteWorkflow`](crate::client::fluent_builders::DeleteWorkflow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkflow::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::DeleteWorkflow::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::DeleteWorkflow::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::DeleteWorkflow::set_workflow_id): <p>Unique identifier for the workflow.</p>
    /// - On success, responds with [`DeleteWorkflowOutput`](crate::output::DeleteWorkflowOutput)

    /// - On failure, responds with [`SdkError<DeleteWorkflowError>`](crate::error::DeleteWorkflowError)
    pub fn delete_workflow(&self) -> fluent_builders::DeleteWorkflow {
        fluent_builders::DeleteWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAutoMergingPreview`](crate::client::fluent_builders::GetAutoMergingPreview) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetAutoMergingPreview::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetAutoMergingPreview::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`consolidation(Consolidation)`](crate::client::fluent_builders::GetAutoMergingPreview::consolidation) / [`set_consolidation(Option<Consolidation>)`](crate::client::fluent_builders::GetAutoMergingPreview::set_consolidation): <p>A list of matching attributes that represent matching criteria.</p>
    ///   - [`conflict_resolution(ConflictResolution)`](crate::client::fluent_builders::GetAutoMergingPreview::conflict_resolution) / [`set_conflict_resolution(Option<ConflictResolution>)`](crate::client::fluent_builders::GetAutoMergingPreview::set_conflict_resolution): <p>How the auto-merging process should resolve conflicts between different profiles.</p>
    /// - On success, responds with [`GetAutoMergingPreviewOutput`](crate::output::GetAutoMergingPreviewOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::GetAutoMergingPreviewOutput::domain_name): <p>The unique name of the domain.</p>
    ///   - [`number_of_matches_in_sample(i64)`](crate::output::GetAutoMergingPreviewOutput::number_of_matches_in_sample): <p>The number of match groups in the domain that have been reviewed in this preview dry run.</p>
    ///   - [`number_of_profiles_in_sample(i64)`](crate::output::GetAutoMergingPreviewOutput::number_of_profiles_in_sample): <p>The number of profiles found in this preview dry run.</p>
    ///   - [`number_of_profiles_will_be_merged(i64)`](crate::output::GetAutoMergingPreviewOutput::number_of_profiles_will_be_merged): <p>The number of profiles that would be merged if this wasn't a preview dry run.</p>
    /// - On failure, responds with [`SdkError<GetAutoMergingPreviewError>`](crate::error::GetAutoMergingPreviewError)
    pub fn get_auto_merging_preview(&self) -> fluent_builders::GetAutoMergingPreview {
        fluent_builders::GetAutoMergingPreview::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDomain`](crate::client::fluent_builders::GetDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetDomain::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`GetDomainOutput`](crate::output::GetDomainOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::GetDomainOutput::domain_name): <p>The unique name of the domain.</p>
    ///   - [`default_expiration_days(Option<i32>)`](crate::output::GetDomainOutput::default_expiration_days): <p>The default number of days until the data within the domain expires.</p>
    ///   - [`default_encryption_key(Option<String>)`](crate::output::GetDomainOutput::default_encryption_key): <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
    ///   - [`dead_letter_queue_url(Option<String>)`](crate::output::GetDomainOutput::dead_letter_queue_url): <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.</p>
    ///   - [`stats(Option<DomainStats>)`](crate::output::GetDomainOutput::stats): <p>Usage-specific statistics about the domain.</p>
    ///   - [`matching(Option<MatchingResponse>)`](crate::output::GetDomainOutput::matching): <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>  <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetDomainOutput::created_at): <p>The timestamp of when the domain was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetDomainOutput::last_updated_at): <p>The timestamp of when the domain was most recently edited.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetDomainOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On failure, responds with [`SdkError<GetDomainError>`](crate::error::GetDomainError)
    pub fn get_domain(&self) -> fluent_builders::GetDomain {
        fluent_builders::GetDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIdentityResolutionJob`](crate::client::fluent_builders::GetIdentityResolutionJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetIdentityResolutionJob::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetIdentityResolutionJob::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::GetIdentityResolutionJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::GetIdentityResolutionJob::set_job_id): <p>The unique identifier of the Identity Resolution Job.</p>
    /// - On success, responds with [`GetIdentityResolutionJobOutput`](crate::output::GetIdentityResolutionJobOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::GetIdentityResolutionJobOutput::domain_name): <p>The unique name of the domain.</p>
    ///   - [`job_id(Option<String>)`](crate::output::GetIdentityResolutionJobOutput::job_id): <p>The unique identifier of the Identity Resolution Job.</p>
    ///   - [`status(Option<IdentityResolutionJobStatus>)`](crate::output::GetIdentityResolutionJobOutput::status): <p>The status of the Identity Resolution Job.</p>  <ul>   <li> <p> <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.</p> </li>   <li> <p> <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.</p> </li>   <li> <p> <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify profiles that belong to the same matching group.</p> </li>   <li> <p> <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.</p> </li>   <li> <p> <code>COMPLETED</code>: The Identity Resolution Job completed successfully.</p> </li>   <li> <p> <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity Resolution Job writes a message indicating the source of the problem.</p> </li>   <li> <p> <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the source of the problem.</p> </li>  </ul>
    ///   - [`message(Option<String>)`](crate::output::GetIdentityResolutionJobOutput::message): <p>The error messages that are generated when the Identity Resolution Job runs.</p>
    ///   - [`job_start_time(Option<DateTime>)`](crate::output::GetIdentityResolutionJobOutput::job_start_time): <p>The timestamp of when the Identity Resolution Job was started or will be started.</p>
    ///   - [`job_end_time(Option<DateTime>)`](crate::output::GetIdentityResolutionJobOutput::job_end_time): <p>The timestamp of when the Identity Resolution Job was completed.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetIdentityResolutionJobOutput::last_updated_at): <p>The timestamp of when the Identity Resolution Job was most recently edited.</p>
    ///   - [`job_expiration_time(Option<DateTime>)`](crate::output::GetIdentityResolutionJobOutput::job_expiration_time): <p>The timestamp of when the Identity Resolution Job will expire.</p>
    ///   - [`auto_merging(Option<AutoMerging>)`](crate::output::GetIdentityResolutionJobOutput::auto_merging): <p>Configuration settings for how to perform the auto-merging of profiles.</p>
    ///   - [`exporting_location(Option<ExportingLocation>)`](crate::output::GetIdentityResolutionJobOutput::exporting_location): <p>The S3 location where the Identity Resolution Job writes result files.</p>
    ///   - [`job_stats(Option<JobStats>)`](crate::output::GetIdentityResolutionJobOutput::job_stats): <p>Statistics about the Identity Resolution Job.</p>
    /// - On failure, responds with [`SdkError<GetIdentityResolutionJobError>`](crate::error::GetIdentityResolutionJobError)
    pub fn get_identity_resolution_job(&self) -> fluent_builders::GetIdentityResolutionJob {
        fluent_builders::GetIdentityResolutionJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetIntegration`](crate::client::fluent_builders::GetIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetIntegration::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetIntegration::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`uri(impl Into<String>)`](crate::client::fluent_builders::GetIntegration::uri) / [`set_uri(Option<String>)`](crate::client::fluent_builders::GetIntegration::set_uri): <p>The URI of the S3 bucket or any other type of data source.</p>
    /// - On success, responds with [`GetIntegrationOutput`](crate::output::GetIntegrationOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::GetIntegrationOutput::domain_name): <p>The unique name of the domain.</p>
    ///   - [`uri(Option<String>)`](crate::output::GetIntegrationOutput::uri): <p>The URI of the S3 bucket or any other type of data source.</p>
    ///   - [`object_type_name(Option<String>)`](crate::output::GetIntegrationOutput::object_type_name): <p>The name of the profile object type.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetIntegrationOutput::created_at): <p>The timestamp of when the domain was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetIntegrationOutput::last_updated_at): <p>The timestamp of when the domain was most recently edited.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetIntegrationOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    ///   - [`object_type_names(Option<HashMap<String, String>>)`](crate::output::GetIntegrationOutput::object_type_names): <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
    ///   - [`workflow_id(Option<String>)`](crate::output::GetIntegrationOutput::workflow_id): <p>Unique identifier for the workflow.</p>
    /// - On failure, responds with [`SdkError<GetIntegrationError>`](crate::error::GetIntegrationError)
    pub fn get_integration(&self) -> fluent_builders::GetIntegration {
        fluent_builders::GetIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMatches`](crate::client::fluent_builders::GetMatches) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetMatches::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetMatches::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetMatches::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetMatches::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetMatches::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetMatches::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`GetMatchesOutput`](crate::output::GetMatchesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetMatchesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    ///   - [`match_generation_date(Option<DateTime>)`](crate::output::GetMatchesOutput::match_generation_date): <p>The timestamp this version of Match Result generated.</p>
    ///   - [`potential_matches(Option<i32>)`](crate::output::GetMatchesOutput::potential_matches): <p>The number of potential matches found.</p>
    ///   - [`matches(Option<Vec<MatchItem>>)`](crate::output::GetMatchesOutput::matches): <p>The list of matched profiles for this instance.</p>
    /// - On failure, responds with [`SdkError<GetMatchesError>`](crate::error::GetMatchesError)
    pub fn get_matches(&self) -> fluent_builders::GetMatches {
        fluent_builders::GetMatches::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProfileObjectType`](crate::client::fluent_builders::GetProfileObjectType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetProfileObjectType::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetProfileObjectType::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::GetProfileObjectType::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::GetProfileObjectType::set_object_type_name): <p>The name of the profile object type.</p>
    /// - On success, responds with [`GetProfileObjectTypeOutput`](crate::output::GetProfileObjectTypeOutput) with field(s):
    ///   - [`object_type_name(Option<String>)`](crate::output::GetProfileObjectTypeOutput::object_type_name): <p>The name of the profile object type.</p>
    ///   - [`description(Option<String>)`](crate::output::GetProfileObjectTypeOutput::description): <p>The description of the profile object type.</p>
    ///   - [`template_id(Option<String>)`](crate::output::GetProfileObjectTypeOutput::template_id): <p>A unique identifier for the object template.</p>
    ///   - [`expiration_days(Option<i32>)`](crate::output::GetProfileObjectTypeOutput::expiration_days): <p>The number of days until the data in the object expires.</p>
    ///   - [`encryption_key(Option<String>)`](crate::output::GetProfileObjectTypeOutput::encryption_key): <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
    ///   - [`allow_profile_creation(bool)`](crate::output::GetProfileObjectTypeOutput::allow_profile_creation): <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
    ///   - [`source_last_updated_timestamp_format(Option<String>)`](crate::output::GetProfileObjectTypeOutput::source_last_updated_timestamp_format): <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up.</p>
    ///   - [`fields(Option<HashMap<String, ObjectTypeField>>)`](crate::output::GetProfileObjectTypeOutput::fields): <p>A map of the name and ObjectType field.</p>
    ///   - [`keys(Option<HashMap<String, Vec<ObjectTypeKey>>>)`](crate::output::GetProfileObjectTypeOutput::keys): <p>A list of unique keys that can be used to map data to the profile.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetProfileObjectTypeOutput::created_at): <p>The timestamp of when the domain was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetProfileObjectTypeOutput::last_updated_at): <p>The timestamp of when the domain was most recently edited.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetProfileObjectTypeOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On failure, responds with [`SdkError<GetProfileObjectTypeError>`](crate::error::GetProfileObjectTypeError)
    pub fn get_profile_object_type(&self) -> fluent_builders::GetProfileObjectType {
        fluent_builders::GetProfileObjectType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProfileObjectTypeTemplate`](crate::client::fluent_builders::GetProfileObjectTypeTemplate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::GetProfileObjectTypeTemplate::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::GetProfileObjectTypeTemplate::set_template_id): <p>A unique identifier for the object template.</p>
    /// - On success, responds with [`GetProfileObjectTypeTemplateOutput`](crate::output::GetProfileObjectTypeTemplateOutput) with field(s):
    ///   - [`template_id(Option<String>)`](crate::output::GetProfileObjectTypeTemplateOutput::template_id): <p>A unique identifier for the object template.</p>
    ///   - [`source_name(Option<String>)`](crate::output::GetProfileObjectTypeTemplateOutput::source_name): <p>The name of the source of the object template.</p>
    ///   - [`source_object(Option<String>)`](crate::output::GetProfileObjectTypeTemplateOutput::source_object): <p>The source of the object template.</p>
    ///   - [`allow_profile_creation(bool)`](crate::output::GetProfileObjectTypeTemplateOutput::allow_profile_creation): <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
    ///   - [`source_last_updated_timestamp_format(Option<String>)`](crate::output::GetProfileObjectTypeTemplateOutput::source_last_updated_timestamp_format): <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up.</p>
    ///   - [`fields(Option<HashMap<String, ObjectTypeField>>)`](crate::output::GetProfileObjectTypeTemplateOutput::fields): <p>A map of the name and ObjectType field.</p>
    ///   - [`keys(Option<HashMap<String, Vec<ObjectTypeKey>>>)`](crate::output::GetProfileObjectTypeTemplateOutput::keys): <p>A list of unique keys that can be used to map data to the profile.</p>
    /// - On failure, responds with [`SdkError<GetProfileObjectTypeTemplateError>`](crate::error::GetProfileObjectTypeTemplateError)
    pub fn get_profile_object_type_template(
        &self,
    ) -> fluent_builders::GetProfileObjectTypeTemplate {
        fluent_builders::GetProfileObjectTypeTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWorkflow`](crate::client::fluent_builders::GetWorkflow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetWorkflow::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetWorkflow::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::GetWorkflow::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::GetWorkflow::set_workflow_id): <p>Unique identifier for the workflow.</p>
    /// - On success, responds with [`GetWorkflowOutput`](crate::output::GetWorkflowOutput) with field(s):
    ///   - [`workflow_id(Option<String>)`](crate::output::GetWorkflowOutput::workflow_id): <p>Unique identifier for the workflow.</p>
    ///   - [`workflow_type(Option<WorkflowType>)`](crate::output::GetWorkflowOutput::workflow_type): <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    ///   - [`status(Option<Status>)`](crate::output::GetWorkflowOutput::status): <p>Status of workflow execution.</p>
    ///   - [`error_description(Option<String>)`](crate::output::GetWorkflowOutput::error_description): <p>Workflow error messages during execution (if any).</p>
    ///   - [`start_date(Option<DateTime>)`](crate::output::GetWorkflowOutput::start_date): <p>The timestamp that represents when workflow execution started.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetWorkflowOutput::last_updated_at): <p>The timestamp that represents when workflow execution last updated.</p>
    ///   - [`attributes(Option<WorkflowAttributes>)`](crate::output::GetWorkflowOutput::attributes): <p>Attributes provided for workflow execution.</p>
    ///   - [`metrics(Option<WorkflowMetrics>)`](crate::output::GetWorkflowOutput::metrics): <p>Workflow specific execution metrics.</p>
    /// - On failure, responds with [`SdkError<GetWorkflowError>`](crate::error::GetWorkflowError)
    pub fn get_workflow(&self) -> fluent_builders::GetWorkflow {
        fluent_builders::GetWorkflow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetWorkflowSteps`](crate::client::fluent_builders::GetWorkflowSteps) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::GetWorkflowSteps::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::GetWorkflowSteps::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`workflow_id(impl Into<String>)`](crate::client::fluent_builders::GetWorkflowSteps::workflow_id) / [`set_workflow_id(Option<String>)`](crate::client::fluent_builders::GetWorkflowSteps::set_workflow_id): <p>Unique identifier for the workflow.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetWorkflowSteps::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetWorkflowSteps::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetWorkflowSteps::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetWorkflowSteps::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`GetWorkflowStepsOutput`](crate::output::GetWorkflowStepsOutput) with field(s):
    ///   - [`workflow_id(Option<String>)`](crate::output::GetWorkflowStepsOutput::workflow_id): <p>Unique identifier for the workflow.</p>
    ///   - [`workflow_type(Option<WorkflowType>)`](crate::output::GetWorkflowStepsOutput::workflow_type): <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    ///   - [`items(Option<Vec<WorkflowStepItem>>)`](crate::output::GetWorkflowStepsOutput::items): <p>List containing workflow step details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetWorkflowStepsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<GetWorkflowStepsError>`](crate::error::GetWorkflowStepsError)
    pub fn get_workflow_steps(&self) -> fluent_builders::GetWorkflowSteps {
        fluent_builders::GetWorkflowSteps::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAccountIntegrations`](crate::client::fluent_builders::ListAccountIntegrations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`uri(impl Into<String>)`](crate::client::fluent_builders::ListAccountIntegrations::uri) / [`set_uri(Option<String>)`](crate::client::fluent_builders::ListAccountIntegrations::set_uri): <p>The URI of the S3 bucket or any other type of data source.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAccountIntegrations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAccountIntegrations::set_next_token): <p>The pagination token from the previous ListAccountIntegrations API call.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAccountIntegrations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAccountIntegrations::set_max_results): <p>The maximum number of objects returned per page.</p>
    ///   - [`include_hidden(bool)`](crate::client::fluent_builders::ListAccountIntegrations::include_hidden) / [`set_include_hidden(Option<bool>)`](crate::client::fluent_builders::ListAccountIntegrations::set_include_hidden): <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
    /// - On success, responds with [`ListAccountIntegrationsOutput`](crate::output::ListAccountIntegrationsOutput) with field(s):
    ///   - [`items(Option<Vec<ListIntegrationItem>>)`](crate::output::ListAccountIntegrationsOutput::items): <p>The list of ListAccountIntegration instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListAccountIntegrationsOutput::next_token): <p>The pagination token from the previous ListAccountIntegrations API call.</p>
    /// - On failure, responds with [`SdkError<ListAccountIntegrationsError>`](crate::error::ListAccountIntegrationsError)
    pub fn list_account_integrations(&self) -> fluent_builders::ListAccountIntegrations {
        fluent_builders::ListAccountIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDomains`](crate::client::fluent_builders::ListDomains) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDomains::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDomains::set_next_token): <p>The pagination token from the previous ListDomain API call.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDomains::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDomains::set_max_results): <p>The maximum number of objects returned per page.</p>
    /// - On success, responds with [`ListDomainsOutput`](crate::output::ListDomainsOutput) with field(s):
    ///   - [`items(Option<Vec<ListDomainItem>>)`](crate::output::ListDomainsOutput::items): <p>The list of ListDomains instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDomainsOutput::next_token): <p>The pagination token from the previous ListDomains API call.</p>
    /// - On failure, responds with [`SdkError<ListDomainsError>`](crate::error::ListDomainsError)
    pub fn list_domains(&self) -> fluent_builders::ListDomains {
        fluent_builders::ListDomains::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIdentityResolutionJobs`](crate::client::fluent_builders::ListIdentityResolutionJobs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListIdentityResolutionJobs::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListIdentityResolutionJobs::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIdentityResolutionJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIdentityResolutionJobs::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIdentityResolutionJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIdentityResolutionJobs::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListIdentityResolutionJobsOutput`](crate::output::ListIdentityResolutionJobsOutput) with field(s):
    ///   - [`identity_resolution_jobs_list(Option<Vec<IdentityResolutionJob>>)`](crate::output::ListIdentityResolutionJobsOutput::identity_resolution_jobs_list): <p>A list of Identity Resolution Jobs.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIdentityResolutionJobsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListIdentityResolutionJobsError>`](crate::error::ListIdentityResolutionJobsError)
    pub fn list_identity_resolution_jobs(&self) -> fluent_builders::ListIdentityResolutionJobs {
        fluent_builders::ListIdentityResolutionJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIntegrations`](crate::client::fluent_builders::ListIntegrations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListIntegrations::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListIntegrations::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIntegrations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIntegrations::set_next_token): <p>The pagination token from the previous ListIntegrations API call.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIntegrations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIntegrations::set_max_results): <p>The maximum number of objects returned per page.</p>
    ///   - [`include_hidden(bool)`](crate::client::fluent_builders::ListIntegrations::include_hidden) / [`set_include_hidden(Option<bool>)`](crate::client::fluent_builders::ListIntegrations::set_include_hidden): <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
    /// - On success, responds with [`ListIntegrationsOutput`](crate::output::ListIntegrationsOutput) with field(s):
    ///   - [`items(Option<Vec<ListIntegrationItem>>)`](crate::output::ListIntegrationsOutput::items): <p>The list of ListIntegrations instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIntegrationsOutput::next_token): <p>The pagination token from the previous ListIntegrations API call.</p>
    /// - On failure, responds with [`SdkError<ListIntegrationsError>`](crate::error::ListIntegrationsError)
    pub fn list_integrations(&self) -> fluent_builders::ListIntegrations {
        fluent_builders::ListIntegrations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProfileObjects`](crate::client::fluent_builders::ListProfileObjects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProfileObjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProfileObjects::set_next_token): <p>The pagination token from the previous call to ListProfileObjects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProfileObjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProfileObjects::set_max_results): <p>The maximum number of objects returned per page.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListProfileObjects::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListProfileObjects::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::ListProfileObjects::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::ListProfileObjects::set_object_type_name): <p>The name of the profile object type.</p>
    ///   - [`profile_id(impl Into<String>)`](crate::client::fluent_builders::ListProfileObjects::profile_id) / [`set_profile_id(Option<String>)`](crate::client::fluent_builders::ListProfileObjects::set_profile_id): <p>The unique identifier of a customer profile.</p>
    ///   - [`object_filter(ObjectFilter)`](crate::client::fluent_builders::ListProfileObjects::object_filter) / [`set_object_filter(Option<ObjectFilter>)`](crate::client::fluent_builders::ListProfileObjects::set_object_filter): <p>Applies a filter to the response to include profile objects with the specified index values. This filter is only supported for ObjectTypeName _asset, _case and _order.</p>
    /// - On success, responds with [`ListProfileObjectsOutput`](crate::output::ListProfileObjectsOutput) with field(s):
    ///   - [`items(Option<Vec<ListProfileObjectsItem>>)`](crate::output::ListProfileObjectsOutput::items): <p>The list of ListProfileObject instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProfileObjectsOutput::next_token): <p>The pagination token from the previous call to ListProfileObjects.</p>
    /// - On failure, responds with [`SdkError<ListProfileObjectsError>`](crate::error::ListProfileObjectsError)
    pub fn list_profile_objects(&self) -> fluent_builders::ListProfileObjects {
        fluent_builders::ListProfileObjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProfileObjectTypes`](crate::client::fluent_builders::ListProfileObjectTypes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListProfileObjectTypes::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListProfileObjectTypes::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProfileObjectTypes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProfileObjectTypes::set_next_token): <p>Identifies the next page of results to return.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProfileObjectTypes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProfileObjectTypes::set_max_results): <p>The maximum number of objects returned per page.</p>
    /// - On success, responds with [`ListProfileObjectTypesOutput`](crate::output::ListProfileObjectTypesOutput) with field(s):
    ///   - [`items(Option<Vec<ListProfileObjectTypeItem>>)`](crate::output::ListProfileObjectTypesOutput::items): <p>The list of ListProfileObjectTypes instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProfileObjectTypesOutput::next_token): <p>Identifies the next page of results to return.</p>
    /// - On failure, responds with [`SdkError<ListProfileObjectTypesError>`](crate::error::ListProfileObjectTypesError)
    pub fn list_profile_object_types(&self) -> fluent_builders::ListProfileObjectTypes {
        fluent_builders::ListProfileObjectTypes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProfileObjectTypeTemplates`](crate::client::fluent_builders::ListProfileObjectTypeTemplates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProfileObjectTypeTemplates::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProfileObjectTypeTemplates::set_next_token): <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProfileObjectTypeTemplates::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProfileObjectTypeTemplates::set_max_results): <p>The maximum number of objects returned per page.</p>
    /// - On success, responds with [`ListProfileObjectTypeTemplatesOutput`](crate::output::ListProfileObjectTypeTemplatesOutput) with field(s):
    ///   - [`items(Option<Vec<ListProfileObjectTypeTemplateItem>>)`](crate::output::ListProfileObjectTypeTemplatesOutput::items): <p>The list of ListProfileObjectType template instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProfileObjectTypeTemplatesOutput::next_token): <p>The pagination token from the previous ListObjectTypeTemplates API call. </p>
    /// - On failure, responds with [`SdkError<ListProfileObjectTypeTemplatesError>`](crate::error::ListProfileObjectTypeTemplatesError)
    pub fn list_profile_object_type_templates(
        &self,
    ) -> fluent_builders::ListProfileObjectTypeTemplates {
        fluent_builders::ListProfileObjectTypeTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The ARN of the resource for which you want to view tags.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListWorkflows`](crate::client::fluent_builders::ListWorkflows) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::ListWorkflows::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::ListWorkflows::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`workflow_type(WorkflowType)`](crate::client::fluent_builders::ListWorkflows::workflow_type) / [`set_workflow_type(Option<WorkflowType>)`](crate::client::fluent_builders::ListWorkflows::set_workflow_type): <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
    ///   - [`status(Status)`](crate::client::fluent_builders::ListWorkflows::status) / [`set_status(Option<Status>)`](crate::client::fluent_builders::ListWorkflows::set_status): <p>Status of workflow execution.</p>
    ///   - [`query_start_date(DateTime)`](crate::client::fluent_builders::ListWorkflows::query_start_date) / [`set_query_start_date(Option<DateTime>)`](crate::client::fluent_builders::ListWorkflows::set_query_start_date): <p>Retrieve workflows started after timestamp.</p>
    ///   - [`query_end_date(DateTime)`](crate::client::fluent_builders::ListWorkflows::query_end_date) / [`set_query_end_date(Option<DateTime>)`](crate::client::fluent_builders::ListWorkflows::set_query_end_date): <p>Retrieve workflows ended after timestamp.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListWorkflows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListWorkflows::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListWorkflows::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListWorkflows::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListWorkflowsOutput`](crate::output::ListWorkflowsOutput) with field(s):
    ///   - [`items(Option<Vec<ListWorkflowsItem>>)`](crate::output::ListWorkflowsOutput::items): <p>List containing workflow details.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListWorkflowsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListWorkflowsError>`](crate::error::ListWorkflowsError)
    pub fn list_workflows(&self) -> fluent_builders::ListWorkflows {
        fluent_builders::ListWorkflows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`MergeProfiles`](crate::client::fluent_builders::MergeProfiles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::MergeProfiles::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::MergeProfiles::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`main_profile_id(impl Into<String>)`](crate::client::fluent_builders::MergeProfiles::main_profile_id) / [`set_main_profile_id(Option<String>)`](crate::client::fluent_builders::MergeProfiles::set_main_profile_id): <p>The identifier of the profile to be taken.</p>
    ///   - [`profile_ids_to_be_merged(Vec<String>)`](crate::client::fluent_builders::MergeProfiles::profile_ids_to_be_merged) / [`set_profile_ids_to_be_merged(Option<Vec<String>>)`](crate::client::fluent_builders::MergeProfiles::set_profile_ids_to_be_merged): <p>The identifier of the profile to be merged into MainProfileId.</p>
    ///   - [`field_source_profile_ids(FieldSourceProfileIds)`](crate::client::fluent_builders::MergeProfiles::field_source_profile_ids) / [`set_field_source_profile_ids(Option<FieldSourceProfileIds>)`](crate::client::fluent_builders::MergeProfiles::set_field_source_profile_ids): <p>The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
    /// - On success, responds with [`MergeProfilesOutput`](crate::output::MergeProfilesOutput) with field(s):
    ///   - [`message(Option<String>)`](crate::output::MergeProfilesOutput::message): <p>A message that indicates the merge request is complete.</p>
    /// - On failure, responds with [`SdkError<MergeProfilesError>`](crate::error::MergeProfilesError)
    pub fn merge_profiles(&self) -> fluent_builders::MergeProfiles {
        fluent_builders::MergeProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutIntegration`](crate::client::fluent_builders::PutIntegration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`uri(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::uri) / [`set_uri(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_uri): <p>The URI of the S3 bucket or any other type of data source.</p>
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::PutIntegration::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::PutIntegration::set_object_type_name): <p>The name of the profile object type.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::PutIntegration::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutIntegration::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    ///   - [`flow_definition(FlowDefinition)`](crate::client::fluent_builders::PutIntegration::flow_definition) / [`set_flow_definition(Option<FlowDefinition>)`](crate::client::fluent_builders::PutIntegration::set_flow_definition): <p>The configuration that controls how Customer Profiles retrieves data from the source.</p>
    ///   - [`object_type_names(HashMap<String, String>)`](crate::client::fluent_builders::PutIntegration::object_type_names) / [`set_object_type_names(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutIntegration::set_object_type_names): <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
    /// - On success, responds with [`PutIntegrationOutput`](crate::output::PutIntegrationOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::PutIntegrationOutput::domain_name): <p>The unique name of the domain.</p>
    ///   - [`uri(Option<String>)`](crate::output::PutIntegrationOutput::uri): <p>The URI of the S3 bucket or any other type of data source.</p>
    ///   - [`object_type_name(Option<String>)`](crate::output::PutIntegrationOutput::object_type_name): <p>The name of the profile object type.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::PutIntegrationOutput::created_at): <p>The timestamp of when the domain was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::PutIntegrationOutput::last_updated_at): <p>The timestamp of when the domain was most recently edited.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::PutIntegrationOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    ///   - [`object_type_names(Option<HashMap<String, String>>)`](crate::output::PutIntegrationOutput::object_type_names): <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
    ///   - [`workflow_id(Option<String>)`](crate::output::PutIntegrationOutput::workflow_id): <p>Unique identifier for the workflow.</p>
    /// - On failure, responds with [`SdkError<PutIntegrationError>`](crate::error::PutIntegrationError)
    pub fn put_integration(&self) -> fluent_builders::PutIntegration {
        fluent_builders::PutIntegration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutProfileObject`](crate::client::fluent_builders::PutProfileObject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::PutProfileObject::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::PutProfileObject::set_object_type_name): <p>The name of the profile object type.</p>
    ///   - [`object(impl Into<String>)`](crate::client::fluent_builders::PutProfileObject::object) / [`set_object(Option<String>)`](crate::client::fluent_builders::PutProfileObject::set_object): <p>A string that is serialized from a JSON object.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::PutProfileObject::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::PutProfileObject::set_domain_name): <p>The unique name of the domain.</p>
    /// - On success, responds with [`PutProfileObjectOutput`](crate::output::PutProfileObjectOutput) with field(s):
    ///   - [`profile_object_unique_key(Option<String>)`](crate::output::PutProfileObjectOutput::profile_object_unique_key): <p>The unique identifier of the profile object generated by the service.</p>
    /// - On failure, responds with [`SdkError<PutProfileObjectError>`](crate::error::PutProfileObjectError)
    pub fn put_profile_object(&self) -> fluent_builders::PutProfileObject {
        fluent_builders::PutProfileObject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutProfileObjectType`](crate::client::fluent_builders::PutProfileObjectType) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::PutProfileObjectType::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::PutProfileObjectType::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`object_type_name(impl Into<String>)`](crate::client::fluent_builders::PutProfileObjectType::object_type_name) / [`set_object_type_name(Option<String>)`](crate::client::fluent_builders::PutProfileObjectType::set_object_type_name): <p>The name of the profile object type.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::PutProfileObjectType::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::PutProfileObjectType::set_description): <p>Description of the profile object type.</p>
    ///   - [`template_id(impl Into<String>)`](crate::client::fluent_builders::PutProfileObjectType::template_id) / [`set_template_id(Option<String>)`](crate::client::fluent_builders::PutProfileObjectType::set_template_id): <p>A unique identifier for the object template.</p>
    ///   - [`expiration_days(i32)`](crate::client::fluent_builders::PutProfileObjectType::expiration_days) / [`set_expiration_days(Option<i32>)`](crate::client::fluent_builders::PutProfileObjectType::set_expiration_days): <p>The number of days until the data in the object expires.</p>
    ///   - [`encryption_key(impl Into<String>)`](crate::client::fluent_builders::PutProfileObjectType::encryption_key) / [`set_encryption_key(Option<String>)`](crate::client::fluent_builders::PutProfileObjectType::set_encryption_key): <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
    ///   - [`allow_profile_creation(bool)`](crate::client::fluent_builders::PutProfileObjectType::allow_profile_creation) / [`set_allow_profile_creation(bool)`](crate::client::fluent_builders::PutProfileObjectType::set_allow_profile_creation): <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
    ///   - [`source_last_updated_timestamp_format(impl Into<String>)`](crate::client::fluent_builders::PutProfileObjectType::source_last_updated_timestamp_format) / [`set_source_last_updated_timestamp_format(Option<String>)`](crate::client::fluent_builders::PutProfileObjectType::set_source_last_updated_timestamp_format): <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up. </p>
    ///   - [`fields(HashMap<String, ObjectTypeField>)`](crate::client::fluent_builders::PutProfileObjectType::fields) / [`set_fields(Option<HashMap<String, ObjectTypeField>>)`](crate::client::fluent_builders::PutProfileObjectType::set_fields): <p>A map of the name and ObjectType field.</p>
    ///   - [`keys(HashMap<String, Vec<ObjectTypeKey>>)`](crate::client::fluent_builders::PutProfileObjectType::keys) / [`set_keys(Option<HashMap<String, Vec<ObjectTypeKey>>>)`](crate::client::fluent_builders::PutProfileObjectType::set_keys): <p>A list of unique keys that can be used to map data to the profile.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::PutProfileObjectType::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::PutProfileObjectType::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`PutProfileObjectTypeOutput`](crate::output::PutProfileObjectTypeOutput) with field(s):
    ///   - [`object_type_name(Option<String>)`](crate::output::PutProfileObjectTypeOutput::object_type_name): <p>The name of the profile object type.</p>
    ///   - [`description(Option<String>)`](crate::output::PutProfileObjectTypeOutput::description): <p>Description of the profile object type.</p>
    ///   - [`template_id(Option<String>)`](crate::output::PutProfileObjectTypeOutput::template_id): <p>A unique identifier for the object template.</p>
    ///   - [`expiration_days(Option<i32>)`](crate::output::PutProfileObjectTypeOutput::expiration_days): <p>The number of days until the data in the object expires.</p>
    ///   - [`encryption_key(Option<String>)`](crate::output::PutProfileObjectTypeOutput::encryption_key): <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
    ///   - [`allow_profile_creation(bool)`](crate::output::PutProfileObjectTypeOutput::allow_profile_creation): <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
    ///   - [`source_last_updated_timestamp_format(Option<String>)`](crate::output::PutProfileObjectTypeOutput::source_last_updated_timestamp_format): <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up in fields that were parsed using <a href="https://docs.oracle.com/javase/10/docs/api/java/text/SimpleDateFormat.html">SimpleDateFormat</a>. If you have <code>sourceLastUpdatedTimestamp</code> in your field, you must set up <code>sourceLastUpdatedTimestampFormat</code>.</p>
    ///   - [`fields(Option<HashMap<String, ObjectTypeField>>)`](crate::output::PutProfileObjectTypeOutput::fields): <p>A map of the name and ObjectType field.</p>
    ///   - [`keys(Option<HashMap<String, Vec<ObjectTypeKey>>>)`](crate::output::PutProfileObjectTypeOutput::keys): <p>A list of unique keys that can be used to map data to the profile.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::PutProfileObjectTypeOutput::created_at): <p>The timestamp of when the domain was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::PutProfileObjectTypeOutput::last_updated_at): <p>The timestamp of when the domain was most recently edited.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::PutProfileObjectTypeOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On failure, responds with [`SdkError<PutProfileObjectTypeError>`](crate::error::PutProfileObjectTypeError)
    pub fn put_profile_object_type(&self) -> fluent_builders::PutProfileObjectType {
        fluent_builders::PutProfileObjectType::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchProfiles`](crate::client::fluent_builders::SearchProfiles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchProfiles::set_next_token): <p>The pagination token from the previous SearchProfiles API call.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::SearchProfiles::set_max_results): <p>The maximum number of objects returned per page.</p>
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::SearchProfiles::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::SearchProfiles::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`key_name(impl Into<String>)`](crate::client::fluent_builders::SearchProfiles::key_name) / [`set_key_name(Option<String>)`](crate::client::fluent_builders::SearchProfiles::set_key_name): <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.</p>
    ///   - [`values(Vec<String>)`](crate::client::fluent_builders::SearchProfiles::values) / [`set_values(Option<Vec<String>>)`](crate::client::fluent_builders::SearchProfiles::set_values): <p>A list of key values.</p>
    /// - On success, responds with [`SearchProfilesOutput`](crate::output::SearchProfilesOutput) with field(s):
    ///   - [`items(Option<Vec<Profile>>)`](crate::output::SearchProfilesOutput::items): <p>The list of SearchProfiles instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchProfilesOutput::next_token): <p>The pagination token from the previous SearchProfiles API call.</p>
    /// - On failure, responds with [`SdkError<SearchProfilesError>`](crate::error::SearchProfilesError)
    pub fn search_profiles(&self) -> fluent_builders::SearchProfiles {
        fluent_builders::SearchProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The ARN of the resource that you're adding tags to.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The ARN of the resource from which you are removing tags.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The list of tag keys to remove from the resource.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDomain`](crate::client::fluent_builders::UpdateDomain) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDomain::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateDomain::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`default_expiration_days(i32)`](crate::client::fluent_builders::UpdateDomain::default_expiration_days) / [`set_default_expiration_days(Option<i32>)`](crate::client::fluent_builders::UpdateDomain::set_default_expiration_days): <p>The default number of days until the data within the domain expires.</p>
    ///   - [`default_encryption_key(impl Into<String>)`](crate::client::fluent_builders::UpdateDomain::default_encryption_key) / [`set_default_encryption_key(Option<String>)`](crate::client::fluent_builders::UpdateDomain::set_default_encryption_key): <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.</p>
    ///   - [`dead_letter_queue_url(impl Into<String>)`](crate::client::fluent_builders::UpdateDomain::dead_letter_queue_url) / [`set_dead_letter_queue_url(Option<String>)`](crate::client::fluent_builders::UpdateDomain::set_dead_letter_queue_url): <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
    ///   - [`matching(MatchingRequest)`](crate::client::fluent_builders::UpdateDomain::matching) / [`set_matching(Option<MatchingRequest>)`](crate::client::fluent_builders::UpdateDomain::set_matching): <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>  <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::UpdateDomain::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateDomain::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`UpdateDomainOutput`](crate::output::UpdateDomainOutput) with field(s):
    ///   - [`domain_name(Option<String>)`](crate::output::UpdateDomainOutput::domain_name): <p>The unique name of the domain.</p>
    ///   - [`default_expiration_days(Option<i32>)`](crate::output::UpdateDomainOutput::default_expiration_days): <p>The default number of days until the data within the domain expires.</p>
    ///   - [`default_encryption_key(Option<String>)`](crate::output::UpdateDomainOutput::default_encryption_key): <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
    ///   - [`dead_letter_queue_url(Option<String>)`](crate::output::UpdateDomainOutput::dead_letter_queue_url): <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications.</p>
    ///   - [`matching(Option<MatchingResponse>)`](crate::output::UpdateDomainOutput::matching): <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>  <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::UpdateDomainOutput::created_at): <p>The timestamp of when the domain was created.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::UpdateDomainOutput::last_updated_at): <p>The timestamp of when the domain was most recently edited.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::UpdateDomainOutput::tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On failure, responds with [`SdkError<UpdateDomainError>`](crate::error::UpdateDomainError)
    pub fn update_domain(&self) -> fluent_builders::UpdateDomain {
        fluent_builders::UpdateDomain::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateProfile`](crate::client::fluent_builders::UpdateProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`domain_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::domain_name) / [`set_domain_name(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_domain_name): <p>The unique name of the domain.</p>
    ///   - [`profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::profile_id) / [`set_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_profile_id): <p>The unique identifier of a customer profile.</p>
    ///   - [`additional_information(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::additional_information) / [`set_additional_information(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_additional_information): <p>Any additional information relevant to the customer’s profile.</p>
    ///   - [`account_number(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::account_number) / [`set_account_number(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_account_number): <p>A unique account number that you have given to the customer.</p>
    ///   - [`party_type(PartyType)`](crate::client::fluent_builders::UpdateProfile::party_type) / [`set_party_type(Option<PartyType>)`](crate::client::fluent_builders::UpdateProfile::set_party_type): <p>The type of profile used to describe the customer.</p>
    ///   - [`business_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::business_name) / [`set_business_name(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_business_name): <p>The name of the customer’s business.</p>
    ///   - [`first_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::first_name) / [`set_first_name(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_first_name): <p>The customer’s first name.</p>
    ///   - [`middle_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::middle_name) / [`set_middle_name(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_middle_name): <p>The customer’s middle name.</p>
    ///   - [`last_name(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::last_name) / [`set_last_name(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_last_name): <p>The customer’s last name.</p>
    ///   - [`birth_date(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::birth_date) / [`set_birth_date(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_birth_date): <p>The customer’s birth date. </p>
    ///   - [`gender(Gender)`](crate::client::fluent_builders::UpdateProfile::gender) / [`set_gender(Option<Gender>)`](crate::client::fluent_builders::UpdateProfile::set_gender): <p>The gender with which the customer identifies. </p>
    ///   - [`phone_number(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::phone_number) / [`set_phone_number(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_phone_number): <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
    ///   - [`mobile_phone_number(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::mobile_phone_number) / [`set_mobile_phone_number(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_mobile_phone_number): <p>The customer’s mobile phone number.</p>
    ///   - [`home_phone_number(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::home_phone_number) / [`set_home_phone_number(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_home_phone_number): <p>The customer’s home phone number.</p>
    ///   - [`business_phone_number(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::business_phone_number) / [`set_business_phone_number(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_business_phone_number): <p>The customer’s business phone number.</p>
    ///   - [`email_address(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::email_address) / [`set_email_address(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_email_address): <p>The customer’s email address, which has not been specified as a personal or business address. </p>
    ///   - [`personal_email_address(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::personal_email_address) / [`set_personal_email_address(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_personal_email_address): <p>The customer’s personal email address.</p>
    ///   - [`business_email_address(impl Into<String>)`](crate::client::fluent_builders::UpdateProfile::business_email_address) / [`set_business_email_address(Option<String>)`](crate::client::fluent_builders::UpdateProfile::set_business_email_address): <p>The customer’s business email address.</p>
    ///   - [`address(UpdateAddress)`](crate::client::fluent_builders::UpdateProfile::address) / [`set_address(Option<UpdateAddress>)`](crate::client::fluent_builders::UpdateProfile::set_address): <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
    ///   - [`shipping_address(UpdateAddress)`](crate::client::fluent_builders::UpdateProfile::shipping_address) / [`set_shipping_address(Option<UpdateAddress>)`](crate::client::fluent_builders::UpdateProfile::set_shipping_address): <p>The customer’s shipping address.</p>
    ///   - [`mailing_address(UpdateAddress)`](crate::client::fluent_builders::UpdateProfile::mailing_address) / [`set_mailing_address(Option<UpdateAddress>)`](crate::client::fluent_builders::UpdateProfile::set_mailing_address): <p>The customer’s mailing address.</p>
    ///   - [`billing_address(UpdateAddress)`](crate::client::fluent_builders::UpdateProfile::billing_address) / [`set_billing_address(Option<UpdateAddress>)`](crate::client::fluent_builders::UpdateProfile::set_billing_address): <p>The customer’s billing address.</p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::UpdateProfile::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateProfile::set_attributes): <p>A key value pair of attributes of a customer profile.</p>
    /// - On success, responds with [`UpdateProfileOutput`](crate::output::UpdateProfileOutput) with field(s):
    ///   - [`profile_id(Option<String>)`](crate::output::UpdateProfileOutput::profile_id): <p>The unique identifier of a customer profile.</p>
    /// - On failure, responds with [`SdkError<UpdateProfileError>`](crate::error::UpdateProfileError)
    pub fn update_profile(&self) -> fluent_builders::UpdateProfile {
        fluent_builders::UpdateProfile::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddProfileKey`.
    ///
    /// <p>Associates a new key value with a specific profile, such as a Contact Trace Record (CTR) ContactId.</p>
    /// <p>A profile object can have a single unique key and any number of additional keys that can be used to identify the profile that it belongs to.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddProfileKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_profile_key_input::Builder,
    }
    impl AddProfileKey {
        /// Creates a new `AddProfileKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddProfileKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::AddProfileKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_name(input.into());
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_name(input);
            self
        }
        /// Appends an item to `Values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values(input.into());
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDomain`.
    ///
    /// <p>Creates a domain, which is a container for all customer data, such as customer profile attributes, object types, profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party integrations.</p>
    /// <p>Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be associated with one domain.</p>
    /// <p>Use this API or <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity resolution</a>: set <code>Matching</code> to true. </p>
    /// <p>To prevent cross-service impersonation when you call this API, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html">Cross-service confused deputy prevention</a> for sample policies that you should apply. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_domain_input::Builder,
    }
    impl CreateDomain {
        /// Creates a new `CreateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, input: i32) -> Self {
            self.inner = self.inner.default_expiration_days(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_expiration_days(input);
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
        pub fn default_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_encryption_key(input.into());
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_encryption_key(input);
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn dead_letter_queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dead_letter_queue_url(input.into());
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_queue_url(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn matching(mut self, input: crate::model::MatchingRequest) -> Self {
            self.inner = self.inner.matching(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingRequest>,
        ) -> Self {
            self.inner = self.inner.set_matching(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntegrationWorkflow`.
    ///
    /// <p> Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntegrationWorkflow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_integration_workflow_input::Builder,
    }
    impl CreateIntegrationWorkflow {
        /// Creates a new `CreateIntegrationWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntegrationWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntegrationWorkflowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(input);
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
        /// <p>Configuration data for integration workflow.</p>
        pub fn integration_config(mut self, input: crate::model::IntegrationConfig) -> Self {
            self.inner = self.inner.integration_config(input);
            self
        }
        /// <p>Configuration data for integration workflow.</p>
        pub fn set_integration_config(
            mut self,
            input: std::option::Option<crate::model::IntegrationConfig>,
        ) -> Self {
            self.inner = self.inner.set_integration_config(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your behalf as part of workflow execution.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this role to create resources on your behalf as part of workflow execution.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProfile`.
    ///
    /// <p>Creates a standard profile.</p>
    /// <p>A standard profile represents the following attributes for a customer profile in a domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_profile_input::Builder,
    }
    impl CreateProfile {
        /// Creates a new `CreateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_number(input.into());
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_number(input);
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn additional_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_information(input.into());
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_information(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn party_type(mut self, input: crate::model::PartyType) -> Self {
            self.inner = self.inner.party_type(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn set_party_type(
            mut self,
            input: std::option::Option<crate::model::PartyType>,
        ) -> Self {
            self.inner = self.inner.set_party_type(input);
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn business_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_name(input.into());
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_name(input);
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(input.into());
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn middle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.middle_name(input.into());
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_middle_name(input);
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(input.into());
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn birth_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.birth_date(input.into());
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_birth_date(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn gender(mut self, input: crate::model::Gender) -> Self {
            self.inner = self.inner.gender(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.inner = self.inner.set_gender(input);
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number(input.into());
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_phone_number(input);
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn mobile_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mobile_phone_number(input.into());
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_phone_number(input);
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn home_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_phone_number(input.into());
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_phone_number(input);
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn business_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_phone_number(input.into());
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_phone_number(input);
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn personal_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.personal_email_address(input.into());
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_personal_email_address(input);
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn business_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_email_address(input.into());
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_email_address(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.address(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn shipping_address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.shipping_address(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_shipping_address(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn mailing_address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.mailing_address(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_mailing_address(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn billing_address(mut self, input: crate::model::Address) -> Self {
            self.inner = self.inner.billing_address(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.inner = self.inner.set_billing_address(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDomain`.
    ///
    /// <p>Deletes a specific domain and all of its customer data, such as customer profile attributes and their related objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_domain_input::Builder,
    }
    impl DeleteDomain {
        /// Creates a new `DeleteDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegration`.
    ///
    /// <p>Removes an integration from a specific domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_integration_input::Builder,
    }
    impl DeleteIntegration {
        /// Creates a new `DeleteIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfile`.
    ///
    /// <p>Deletes the standard customer profile and all data pertaining to the profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_profile_input::Builder,
    }
    impl DeleteProfile {
        /// Creates a new `DeleteProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfileKey`.
    ///
    /// <p>Removes a searchable key from a customer profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProfileKey {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_profile_key_input::Builder,
    }
    impl DeleteProfileKey {
        /// Creates a new `DeleteProfileKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileKeyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_name(input.into());
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_name(input);
            self
        }
        /// Appends an item to `Values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values(input.into());
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfileObject`.
    ///
    /// <p>Removes an object associated with a profile of a given ProfileObjectType.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProfileObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_profile_object_input::Builder,
    }
    impl DeleteProfileObject {
        /// Creates a new `DeleteProfileObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn profile_object_unique_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_object_unique_key(input.into());
            self
        }
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn set_profile_object_unique_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_profile_object_unique_key(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProfileObjectType`.
    ///
    /// <p>Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that were populated from this ProfileObjectType.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProfileObjectType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_profile_object_type_input::Builder,
    }
    impl DeleteProfileObjectType {
        /// Creates a new `DeleteProfileObjectType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProfileObjectTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProfileObjectTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteWorkflow`.
    ///
    /// <p>Deletes the specified workflow and all its corresponding resources. This is an async process.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteWorkflow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_workflow_input::Builder,
    }
    impl DeleteWorkflow {
        /// Creates a new `DeleteWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteWorkflowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAutoMergingPreview`.
    ///
    /// <p>Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a sample of matching groups from the existing matching results, and applies the automerging settings that you provided. You can then view the number of profiles in the sample, the number of matches, and the number of profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching list. </p>
    /// <p>You can't view which profiles are matched and would be merged.</p> <important>
    /// <p>We strongly recommend you use this API to do a dry run of the automerging process before running the Identity Resolution Job. Include <b>at least</b> two matching attributes. If your matching list includes too few attributes (such as only <code>FirstName</code> or only <code>LastName</code>), there may be a large number of matches. This increases the chances of erroneous merges.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAutoMergingPreview {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_auto_merging_preview_input::Builder,
    }
    impl GetAutoMergingPreview {
        /// Creates a new `GetAutoMergingPreview`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAutoMergingPreviewOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAutoMergingPreviewError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>A list of matching attributes that represent matching criteria.</p>
        pub fn consolidation(mut self, input: crate::model::Consolidation) -> Self {
            self.inner = self.inner.consolidation(input);
            self
        }
        /// <p>A list of matching attributes that represent matching criteria.</p>
        pub fn set_consolidation(
            mut self,
            input: std::option::Option<crate::model::Consolidation>,
        ) -> Self {
            self.inner = self.inner.set_consolidation(input);
            self
        }
        /// <p>How the auto-merging process should resolve conflicts between different profiles.</p>
        pub fn conflict_resolution(mut self, input: crate::model::ConflictResolution) -> Self {
            self.inner = self.inner.conflict_resolution(input);
            self
        }
        /// <p>How the auto-merging process should resolve conflicts between different profiles.</p>
        pub fn set_conflict_resolution(
            mut self,
            input: std::option::Option<crate::model::ConflictResolution>,
        ) -> Self {
            self.inner = self.inner.set_conflict_resolution(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDomain`.
    ///
    /// <p>Returns information about a specific domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_domain_input::Builder,
    }
    impl GetDomain {
        /// Creates a new `GetDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIdentityResolutionJob`.
    ///
    /// <p>Returns information about an Identity Resolution Job in a specific domain. </p>
    /// <p>Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html">Use Identity Resolution to consolidate similar profiles</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIdentityResolutionJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_identity_resolution_job_input::Builder,
    }
    impl GetIdentityResolutionJob {
        /// Creates a new `GetIdentityResolutionJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIdentityResolutionJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIdentityResolutionJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The unique identifier of the Identity Resolution Job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier of the Identity Resolution Job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetIntegration`.
    ///
    /// <p>Returns an integration for a domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_integration_input::Builder,
    }
    impl GetIntegration {
        /// Creates a new `GetIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMatches`.
    ///
    /// <p>Before calling this API, use <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to enable identity resolution: set <code>Matching</code> to true.</p>
    /// <p>GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning process. </p> <important>
    /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
    /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
    /// </important>
    /// <p>Amazon Connect uses the following profile attributes to identify matches:</p>
    /// <ul>
    /// <li> <p>PhoneNumber</p> </li>
    /// <li> <p>HomePhoneNumber</p> </li>
    /// <li> <p>BusinessPhoneNumber</p> </li>
    /// <li> <p>MobilePhoneNumber</p> </li>
    /// <li> <p>EmailAddress</p> </li>
    /// <li> <p>PersonalEmailAddress</p> </li>
    /// <li> <p>BusinessEmailAddress</p> </li>
    /// <li> <p>FullName</p> </li>
    /// </ul>
    /// <p>For example, two or more profiles—with spelling mistakes such as <b>John Doe</b> and <b>Jhn Doe</b>, or different casing email addresses such as <b>JOHN_DOE@ANYCOMPANY.COM</b> and <b>johndoe@anycompany.com</b>, or different phone number formats such as <b>555-010-0000</b> and <b>+1-555-010-0000</b>—can be detected as belonging to the same customer <b>John Doe</b> and merged into a unified profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMatches {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_matches_input::Builder,
    }
    impl GetMatches {
        /// Creates a new `GetMatches`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMatchesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMatchesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProfileObjectType`.
    ///
    /// <p>Returns the object types for a specific domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProfileObjectType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_profile_object_type_input::Builder,
    }
    impl GetProfileObjectType {
        /// Creates a new `GetProfileObjectType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProfileObjectTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProfileObjectTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProfileObjectTypeTemplate`.
    ///
    /// <p>Returns the template information for a specific object type.</p>
    /// <p>A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the TemplateIds, it uses the mappings from the template.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProfileObjectTypeTemplate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_profile_object_type_template_input::Builder,
    }
    impl GetProfileObjectTypeTemplate {
        /// Creates a new `GetProfileObjectTypeTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProfileObjectTypeTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProfileObjectTypeTemplateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflow`.
    ///
    /// <p>Get details of specified workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkflow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_workflow_input::Builder,
    }
    impl GetWorkflow {
        /// Creates a new `GetWorkflow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetWorkflowSteps`.
    ///
    /// <p>Get granular list of steps in workflow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetWorkflowSteps {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_workflow_steps_input::Builder,
    }
    impl GetWorkflowSteps {
        /// Creates a new `GetWorkflowSteps`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetWorkflowStepsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetWorkflowStepsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn workflow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.workflow_id(input.into());
            self
        }
        /// <p>Unique identifier for the workflow.</p>
        pub fn set_workflow_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_workflow_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAccountIntegrations`.
    ///
    /// <p>Lists all of the integrations associated to a specific URI in the AWS account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAccountIntegrations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_account_integrations_input::Builder,
    }
    impl ListAccountIntegrations {
        /// Creates a new `ListAccountIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAccountIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAccountIntegrationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn include_hidden(mut self, input: bool) -> Self {
            self.inner = self.inner.include_hidden(input);
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn set_include_hidden(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_hidden(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDomains`.
    ///
    /// <p>Returns a list of all the domains for an AWS account that have been created.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDomains {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_domains_input::Builder,
    }
    impl ListDomains {
        /// Creates a new `ListDomains`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDomainsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDomainsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous ListDomain API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token from the previous ListDomain API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIdentityResolutionJobs`.
    ///
    /// <p>Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by <code>JobStartTime</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIdentityResolutionJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_identity_resolution_jobs_input::Builder,
    }
    impl ListIdentityResolutionJobs {
        /// Creates a new `ListIdentityResolutionJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIdentityResolutionJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIdentityResolutionJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIntegrations`.
    ///
    /// <p>Lists all of the integrations in your domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIntegrations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_integrations_input::Builder,
    }
    impl ListIntegrations {
        /// Creates a new `ListIntegrations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIntegrationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIntegrationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn include_hidden(mut self, input: bool) -> Self {
            self.inner = self.inner.include_hidden(input);
            self
        }
        /// <p>Boolean to indicate if hidden integration should be returned. Defaults to <code>False</code>.</p>
        pub fn set_include_hidden(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_hidden(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfileObjects`.
    ///
    /// <p>Returns a list of objects associated with a profile of a given ProfileObjectType.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProfileObjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_profile_objects_input::Builder,
    }
    impl ListProfileObjects {
        /// Creates a new `ListProfileObjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfileObjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfileObjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>Applies a filter to the response to include profile objects with the specified index values. This filter is only supported for ObjectTypeName _asset, _case and _order.</p>
        pub fn object_filter(mut self, input: crate::model::ObjectFilter) -> Self {
            self.inner = self.inner.object_filter(input);
            self
        }
        /// <p>Applies a filter to the response to include profile objects with the specified index values. This filter is only supported for ObjectTypeName _asset, _case and _order.</p>
        pub fn set_object_filter(
            mut self,
            input: std::option::Option<crate::model::ObjectFilter>,
        ) -> Self {
            self.inner = self.inner.set_object_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfileObjectTypes`.
    ///
    /// <p>Lists all of the templates available within the service.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProfileObjectTypes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_profile_object_types_input::Builder,
    }
    impl ListProfileObjectTypes {
        /// Creates a new `ListProfileObjectTypes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfileObjectTypesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfileObjectTypesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProfileObjectTypeTemplates`.
    ///
    /// <p>Lists all of the template information for object types.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProfileObjectTypeTemplates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_profile_object_type_templates_input::Builder,
    }
    impl ListProfileObjectTypeTemplates {
        /// Creates a new `ListProfileObjectTypeTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProfileObjectTypeTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProfileObjectTypeTemplatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource for which you want to view tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource for which you want to view tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListWorkflows`.
    ///
    /// <p>Query to list all workflows.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListWorkflows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_workflows_input::Builder,
    }
    impl ListWorkflows {
        /// Creates a new `ListWorkflows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListWorkflowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListWorkflowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn workflow_type(mut self, input: crate::model::WorkflowType) -> Self {
            self.inner = self.inner.workflow_type(input);
            self
        }
        /// <p>The type of workflow. The only supported value is APPFLOW_INTEGRATION.</p>
        pub fn set_workflow_type(
            mut self,
            input: std::option::Option<crate::model::WorkflowType>,
        ) -> Self {
            self.inner = self.inner.set_workflow_type(input);
            self
        }
        /// <p>Status of workflow execution.</p>
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Status of workflow execution.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>Retrieve workflows started after timestamp.</p>
        pub fn query_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.query_start_date(input);
            self
        }
        /// <p>Retrieve workflows started after timestamp.</p>
        pub fn set_query_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_query_start_date(input);
            self
        }
        /// <p>Retrieve workflows ended after timestamp.</p>
        pub fn query_end_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.query_end_date(input);
            self
        }
        /// <p>Retrieve workflows ended after timestamp.</p>
        pub fn set_query_end_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_query_end_date(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `MergeProfiles`.
    ///
    /// <p>Runs an AWS Lambda job that does the following:</p>
    /// <ol>
    /// <li> <p>All the profileKeys in the <code>ProfileToBeMerged</code> will be moved to the main profile.</p> </li>
    /// <li> <p>All the objects in the <code>ProfileToBeMerged</code> will be moved to the main profile.</p> </li>
    /// <li> <p>All the <code>ProfileToBeMerged</code> will be deleted at the end.</p> </li>
    /// <li> <p>All the profileKeys in the <code>ProfileIdsToBeMerged</code> will be moved to the main profile.</p> </li>
    /// <li> <p>Standard fields are merged as follows:</p>
    /// <ol>
    /// <li> <p>Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.</p> </li>
    /// <li> <p>When there are conflicting fields:</p>
    /// <ol>
    /// <li> <p>If no <code>SourceProfileIds</code> entry is specified, the main Profile value is always taken. </p> </li>
    /// <li> <p>If a <code>SourceProfileIds</code> entry is specified, the specified profileId is always taken, even if it is a NULL value.</p> </li>
    /// </ol> </li>
    /// </ol> </li>
    /// </ol>
    /// <p>You can use MergeProfiles together with <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>, which returns potentially matching profiles, or use it with the results of another matching system. After profiles have been merged, they cannot be separated (unmerged).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct MergeProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::merge_profiles_input::Builder,
    }
    impl MergeProfiles {
        /// Creates a new `MergeProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::MergeProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::MergeProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The identifier of the profile to be taken.</p>
        pub fn main_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.main_profile_id(input.into());
            self
        }
        /// <p>The identifier of the profile to be taken.</p>
        pub fn set_main_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_main_profile_id(input);
            self
        }
        /// Appends an item to `ProfileIdsToBeMerged`.
        ///
        /// To override the contents of this collection use [`set_profile_ids_to_be_merged`](Self::set_profile_ids_to_be_merged).
        ///
        /// <p>The identifier of the profile to be merged into MainProfileId.</p>
        pub fn profile_ids_to_be_merged(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_ids_to_be_merged(input.into());
            self
        }
        /// <p>The identifier of the profile to be merged into MainProfileId.</p>
        pub fn set_profile_ids_to_be_merged(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_profile_ids_to_be_merged(input);
            self
        }
        /// <p>The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
        pub fn field_source_profile_ids(
            mut self,
            input: crate::model::FieldSourceProfileIds,
        ) -> Self {
            self.inner = self.inner.field_source_profile_ids(input);
            self
        }
        /// <p>The identifiers of the fields in the profile that has the information you want to apply to the merge. For example, say you want to merge EmailAddress from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in Profile1. </p>
        pub fn set_field_source_profile_ids(
            mut self,
            input: std::option::Option<crate::model::FieldSourceProfileIds>,
        ) -> Self {
            self.inner = self.inner.set_field_source_profile_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutIntegration`.
    ///
    /// <p>Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon Connect.</p>
    /// <p>An integration can belong to only one domain.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutIntegration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_integration_input::Builder,
    }
    impl PutIntegration {
        /// Creates a new `PutIntegration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutIntegrationOutput,
            aws_smithy_http::result::SdkError<crate::error::PutIntegrationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.uri(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_uri(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the source.</p>
        pub fn flow_definition(mut self, input: crate::model::FlowDefinition) -> Self {
            self.inner = self.inner.flow_definition(input);
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the source.</p>
        pub fn set_flow_definition(
            mut self,
            input: std::option::Option<crate::model::FlowDefinition>,
        ) -> Self {
            self.inner = self.inner.set_flow_definition(input);
            self
        }
        /// Adds a key-value pair to `ObjectTypeNames`.
        ///
        /// To override the contents of this collection use [`set_object_type_names`](Self::set_object_type_names).
        ///
        /// <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
        pub fn object_type_names(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.object_type_names(k.into(), v.into());
            self
        }
        /// <p>A map in which each key is an event type from an external application such as Segment or Shopify, and each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.</p>
        pub fn set_object_type_names(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_object_type_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProfileObject`.
    ///
    /// <p>Adds additional objects to customer profiles of a given ObjectType.</p>
    /// <p>When adding a specific profile object, like a Contact Trace Record (CTR), an inferred profile can get created if it is not mapped to an existing profile. The resulting profile will only have a phone number populated in the standard ProfileObject. Any additional CTRs with the same phone number will be mapped to the same inferred profile.</p>
    /// <p>When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide data to a standard profile depending on the ProfileObjectType definition.</p>
    /// <p>PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutProfileObject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_profile_object_input::Builder,
    }
    impl PutProfileObject {
        /// Creates a new `PutProfileObject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProfileObjectOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProfileObjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>A string that is serialized from a JSON object.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object(input.into());
            self
        }
        /// <p>A string that is serialized from a JSON object.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_object(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutProfileObjectType`.
    ///
    /// <p>Defines a ProfileObjectType.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutProfileObjectType {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::put_profile_object_type_input::Builder,
    }
    impl PutProfileObjectType {
        /// Creates a new `PutProfileObjectType`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutProfileObjectTypeOutput,
            aws_smithy_http::result::SdkError<crate::error::PutProfileObjectTypeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.object_type_name(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_object_type_name(input);
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.template_id(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_template_id(input);
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn expiration_days(mut self, input: i32) -> Self {
            self.inner = self.inner.expiration_days(input);
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn set_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_expiration_days(input);
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.encryption_key(input.into());
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this profile object type.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_encryption_key(input);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
        pub fn allow_profile_creation(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_profile_creation(input);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.</p>
        pub fn set_allow_profile_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_profile_creation(input);
            self
        }
        /// <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up. </p>
        pub fn source_last_updated_timestamp_format(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .source_last_updated_timestamp_format(input.into());
            self
        }
        /// <p>The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up. </p>
        pub fn set_source_last_updated_timestamp_format(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_last_updated_timestamp_format(input);
            self
        }
        /// Adds a key-value pair to `Fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A map of the name and ObjectType field.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::ObjectTypeField,
        ) -> Self {
            self.inner = self.inner.fields(k.into(), v);
            self
        }
        /// <p>A map of the name and ObjectType field.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
            >,
        ) -> Self {
            self.inner = self.inner.set_fields(input);
            self
        }
        /// Adds a key-value pair to `Keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn keys(
            mut self,
            k: impl Into<std::string::String>,
            v: std::vec::Vec<crate::model::ObjectTypeKey>,
        ) -> Self {
            self.inner = self.inner.keys(k.into(), v);
            self
        }
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ObjectTypeKey>,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_keys(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchProfiles`.
    ///
    /// <p>Searches for profiles within a specific domain name using name, phone number, email address, account number, or a custom defined index.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::search_profiles_input::Builder,
    }
    impl SearchProfiles {
        /// Creates a new `SearchProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects returned per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key_name(input.into());
            self
        }
        /// <p>A searchable identifier of a customer profile. The predefined keys you can use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId, _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId, _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId, _shopifyOrderId.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key_name(input);
            self
        }
        /// Appends an item to `Values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.values(input.into());
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.</p>
    /// <p>Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.</p>
    /// <p>You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>
    /// <p>You can associate as many as 50 tags with a resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource that you're adding tags to.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource that you're adding tags to.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer Profiles, domains, profile object types, and integrations can be tagged.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the resource from which you are removing tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The ARN of the resource from which you are removing tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The list of tag keys to remove from the resource.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDomain`.
    ///
    /// <p>Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.</p>
    /// <p>After a domain is created, the name can’t be changed.</p>
    /// <p>Use this API or <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> to enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity resolution</a>: set <code>Matching</code> to true. </p>
    /// <p>To prevent cross-service impersonation when you call this API, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html">Cross-service confused deputy prevention</a> for sample policies that you should apply. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDomain {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_domain_input::Builder,
    }
    impl UpdateDomain {
        /// Creates a new `UpdateDomain`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDomainOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDomainError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, input: i32) -> Self {
            self.inner = self.inner.default_expiration_days(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_default_expiration_days(input);
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.</p>
        pub fn default_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_encryption_key(input.into());
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If specified as an empty string, it will clear any existing value.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_encryption_key(input);
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn dead_letter_queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dead_letter_queue_url(input.into());
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from third party applications. If specified as an empty string, it will clear any existing value. You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_dead_letter_queue_url(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn matching(mut self, input: crate::model::MatchingRequest) -> Self {
            self.inner = self.inner.matching(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in your domains. </p>
        /// <p>After the Identity Resolution Job completes, use the <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to return and review the results. Or, if you have configured <code>ExportingConfig</code> in the <code>MatchingRequest</code>, you can download the results from S3.</p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingRequest>,
        ) -> Self {
            self.inner = self.inner.set_matching(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateProfile`.
    ///
    /// <p>Updates the properties of a profile. The ProfileId is required for updating a customer profile.</p>
    /// <p>When calling the UpdateProfile API, specifying an empty string value means that any existing value will be removed. Not specifying a string value means that any value already there will be kept.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_profile_input::Builder,
    }
    impl UpdateProfile {
        /// Creates a new `UpdateProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_name(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain_name(input);
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.profile_id(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_profile_id(input);
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn additional_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_information(input.into());
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_information(input);
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_number(input.into());
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_number(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn party_type(mut self, input: crate::model::PartyType) -> Self {
            self.inner = self.inner.party_type(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn set_party_type(
            mut self,
            input: std::option::Option<crate::model::PartyType>,
        ) -> Self {
            self.inner = self.inner.set_party_type(input);
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn business_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_name(input.into());
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_name(input);
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.first_name(input.into());
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_first_name(input);
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn middle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.middle_name(input.into());
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_middle_name(input);
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.last_name(input.into());
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_last_name(input);
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn birth_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.birth_date(input.into());
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_birth_date(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn gender(mut self, input: crate::model::Gender) -> Self {
            self.inner = self.inner.gender(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.inner = self.inner.set_gender(input);
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.phone_number(input.into());
            self
        }
        /// <p>The customer’s phone number, which has not been specified as a mobile, home, or business number. </p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_phone_number(input);
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn mobile_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.mobile_phone_number(input.into());
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_mobile_phone_number(input);
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn home_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.home_phone_number(input.into());
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_home_phone_number(input);
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn business_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_phone_number(input.into());
            self
        }
        /// <p>The customer’s business phone number.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_phone_number(input);
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.email_address(input.into());
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business address. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_email_address(input);
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn personal_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.personal_email_address(input.into());
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_personal_email_address(input);
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn business_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.business_email_address(input.into());
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_business_email_address(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.address(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or billing.</p>
        pub fn set_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_address(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn shipping_address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.shipping_address(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_shipping_address(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn mailing_address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.mailing_address(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_mailing_address(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn billing_address(mut self, input: crate::model::UpdateAddress) -> Self {
            self.inner = self.inner.billing_address(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<crate::model::UpdateAddress>,
        ) -> Self {
            self.inner = self.inner.set_billing_address(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
