// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateProfileOutput {
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
}
impl UpdateProfileOutput {
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateProfileOutput");
        formatter.field("profile_id", &self.profile_id);
        formatter.finish()
    }
}
/// See [`UpdateProfileOutput`](crate::output::UpdateProfileOutput)
pub mod update_profile_output {
    /// A builder for [`UpdateProfileOutput`](crate::output::UpdateProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateProfileOutput`](crate::output::UpdateProfileOutput)
        pub fn build(self) -> crate::output::UpdateProfileOutput {
            crate::output::UpdateProfileOutput {
                profile_id: self.profile_id,
            }
        }
    }
}
impl UpdateProfileOutput {
    /// Creates a new builder-style object to manufacture [`UpdateProfileOutput`](crate::output::UpdateProfileOutput)
    pub fn builder() -> crate::output::update_profile_output::Builder {
        crate::output::update_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDomainOutput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The default number of days until the data within the domain expires.</p>
    pub default_expiration_days: std::option::Option<i32>,
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
    /// of encryption key is specified. It is used to encrypt all data before it is placed in
    /// permanent or semi-permanent storage.</p>
    pub default_encryption_key: std::option::Option<std::string::String>,
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
    /// ingesting data from third party applications.</p>
    pub dead_letter_queue_url: std::option::Option<std::string::String>,
    /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
    /// After that batch process completes, use the
    /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
    /// API to return and review the results.  </p>
    pub matching: std::option::Option<crate::model::MatchingResponse>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl UpdateDomainOutput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The default number of days until the data within the domain expires.</p>
    pub fn default_expiration_days(&self) -> std::option::Option<i32> {
        self.default_expiration_days
    }
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
    /// of encryption key is specified. It is used to encrypt all data before it is placed in
    /// permanent or semi-permanent storage.</p>
    pub fn default_encryption_key(&self) -> std::option::Option<&str> {
        self.default_encryption_key.as_deref()
    }
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
    /// ingesting data from third party applications.</p>
    pub fn dead_letter_queue_url(&self) -> std::option::Option<&str> {
        self.dead_letter_queue_url.as_deref()
    }
    /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
    /// After that batch process completes, use the
    /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
    /// API to return and review the results.  </p>
    pub fn matching(&self) -> std::option::Option<&crate::model::MatchingResponse> {
        self.matching.as_ref()
    }
    /// <p>The timestamp of when the domain was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for UpdateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDomainOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("default_expiration_days", &self.default_expiration_days);
        formatter.field("default_encryption_key", &self.default_encryption_key);
        formatter.field("dead_letter_queue_url", &self.dead_letter_queue_url);
        formatter.field("matching", &self.matching);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
pub mod update_domain_output {
    /// A builder for [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) default_expiration_days: std::option::Option<i32>,
        pub(crate) default_encryption_key: std::option::Option<std::string::String>,
        pub(crate) dead_letter_queue_url: std::option::Option<std::string::String>,
        pub(crate) matching: std::option::Option<crate::model::MatchingResponse>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, input: i32) -> Self {
            self.default_expiration_days = Some(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.default_expiration_days = input;
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn default_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_encryption_key = Some(input.into());
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_encryption_key = input;
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications.</p>
        pub fn dead_letter_queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.dead_letter_queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dead_letter_queue_url = input;
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn matching(mut self, input: crate::model::MatchingResponse) -> Self {
            self.matching = Some(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingResponse>,
        ) -> Self {
            self.matching = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
        pub fn build(self) -> crate::output::UpdateDomainOutput {
            crate::output::UpdateDomainOutput {
                domain_name: self.domain_name,
                default_expiration_days: self.default_expiration_days,
                default_encryption_key: self.default_encryption_key,
                dead_letter_queue_url: self.dead_letter_queue_url,
                matching: self.matching,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl UpdateDomainOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDomainOutput`](crate::output::UpdateDomainOutput)
    pub fn builder() -> crate::output::update_domain_output::Builder {
        crate::output::update_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchProfilesOutput {
    /// <p>The list of SearchProfiles instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::Profile>>,
    /// <p>The pagination token from the previous SearchProfiles API call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl SearchProfilesOutput {
    /// <p>The list of SearchProfiles instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::Profile]> {
        self.items.as_deref()
    }
    /// <p>The pagination token from the previous SearchProfiles API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for SearchProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchProfilesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`SearchProfilesOutput`](crate::output::SearchProfilesOutput)
pub mod search_profiles_output {
    /// A builder for [`SearchProfilesOutput`](crate::output::SearchProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::Profile>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of SearchProfiles instances.</p>
        pub fn items(mut self, input: impl Into<crate::model::Profile>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of SearchProfiles instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Profile>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous SearchProfiles API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchProfilesOutput`](crate::output::SearchProfilesOutput)
        pub fn build(self) -> crate::output::SearchProfilesOutput {
            crate::output::SearchProfilesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl SearchProfilesOutput {
    /// Creates a new builder-style object to manufacture [`SearchProfilesOutput`](crate::output::SearchProfilesOutput)
    pub fn builder() -> crate::output::search_profiles_output::Builder {
        crate::output::search_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProfileObjectTypeOutput {
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>Description of the profile object type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the object template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The number of days until the data in the object expires.</p>
    pub expiration_days: std::option::Option<i32>,
    /// <p>The customer-provided key to encrypt the profile object that will be created in this
    /// profile object type.</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
    /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
    /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
    /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
    /// is found, then the service creates a new standard profile.</p>
    pub allow_profile_creation: bool,
    /// <p>A map of the name and ObjectType field.</p>
    pub fields: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    >,
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub keys: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    >,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutProfileObjectTypeOutput {
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>Description of the profile object type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A unique identifier for the object template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The number of days until the data in the object expires.</p>
    pub fn expiration_days(&self) -> std::option::Option<i32> {
        self.expiration_days
    }
    /// <p>The customer-provided key to encrypt the profile object that will be created in this
    /// profile object type.</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
    /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
    /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
    /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
    /// is found, then the service creates a new standard profile.</p>
    pub fn allow_profile_creation(&self) -> bool {
        self.allow_profile_creation
    }
    /// <p>A map of the name and ObjectType field.</p>
    pub fn fields(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    > {
        self.fields.as_ref()
    }
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub fn keys(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    > {
        self.keys.as_ref()
    }
    /// <p>The timestamp of when the domain was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for PutProfileObjectTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProfileObjectTypeOutput");
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("description", &self.description);
        formatter.field("template_id", &self.template_id);
        formatter.field("expiration_days", &self.expiration_days);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("allow_profile_creation", &self.allow_profile_creation);
        formatter.field("fields", &self.fields);
        formatter.field("keys", &self.keys);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PutProfileObjectTypeOutput`](crate::output::PutProfileObjectTypeOutput)
pub mod put_profile_object_type_output {
    /// A builder for [`PutProfileObjectTypeOutput`](crate::output::PutProfileObjectTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) expiration_days: std::option::Option<i32>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) allow_profile_creation: std::option::Option<bool>,
        pub(crate) fields: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
        >,
        pub(crate) keys: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ObjectTypeKey>,
            >,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn expiration_days(mut self, input: i32) -> Self {
            self.expiration_days = Some(input);
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn set_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.expiration_days = input;
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this
        /// profile object type.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this
        /// profile object type.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn allow_profile_creation(mut self, input: bool) -> Self {
            self.allow_profile_creation = Some(input);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn set_allow_profile_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_profile_creation = input;
            self
        }
        /// Adds a key-value pair to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A map of the name and ObjectType field.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ObjectTypeField>,
        ) -> Self {
            let mut hash_map = self.fields.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.fields = Some(hash_map);
            self
        }
        /// <p>A map of the name and ObjectType field.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
            >,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Adds a key-value pair to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ObjectTypeKey>>,
        ) -> Self {
            let mut hash_map = self.keys.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.keys = Some(hash_map);
            self
        }
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ObjectTypeKey>,
                >,
            >,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProfileObjectTypeOutput`](crate::output::PutProfileObjectTypeOutput)
        pub fn build(self) -> crate::output::PutProfileObjectTypeOutput {
            crate::output::PutProfileObjectTypeOutput {
                object_type_name: self.object_type_name,
                description: self.description,
                template_id: self.template_id,
                expiration_days: self.expiration_days,
                encryption_key: self.encryption_key,
                allow_profile_creation: self.allow_profile_creation.unwrap_or_default(),
                fields: self.fields,
                keys: self.keys,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl PutProfileObjectTypeOutput {
    /// Creates a new builder-style object to manufacture [`PutProfileObjectTypeOutput`](crate::output::PutProfileObjectTypeOutput)
    pub fn builder() -> crate::output::put_profile_object_type_output::Builder {
        crate::output::put_profile_object_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutProfileObjectOutput {
    /// <p>The unique identifier of the profile object generated by the service.</p>
    pub profile_object_unique_key: std::option::Option<std::string::String>,
}
impl PutProfileObjectOutput {
    /// <p>The unique identifier of the profile object generated by the service.</p>
    pub fn profile_object_unique_key(&self) -> std::option::Option<&str> {
        self.profile_object_unique_key.as_deref()
    }
}
impl std::fmt::Debug for PutProfileObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutProfileObjectOutput");
        formatter.field("profile_object_unique_key", &self.profile_object_unique_key);
        formatter.finish()
    }
}
/// See [`PutProfileObjectOutput`](crate::output::PutProfileObjectOutput)
pub mod put_profile_object_output {
    /// A builder for [`PutProfileObjectOutput`](crate::output::PutProfileObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_object_unique_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn profile_object_unique_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_object_unique_key = Some(input.into());
            self
        }
        /// <p>The unique identifier of the profile object generated by the service.</p>
        pub fn set_profile_object_unique_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_object_unique_key = input;
            self
        }
        /// Consumes the builder and constructs a [`PutProfileObjectOutput`](crate::output::PutProfileObjectOutput)
        pub fn build(self) -> crate::output::PutProfileObjectOutput {
            crate::output::PutProfileObjectOutput {
                profile_object_unique_key: self.profile_object_unique_key,
            }
        }
    }
}
impl PutProfileObjectOutput {
    /// Creates a new builder-style object to manufacture [`PutProfileObjectOutput`](crate::output::PutProfileObjectOutput)
    pub fn builder() -> crate::output::put_profile_object_output::Builder {
        crate::output::put_profile_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutIntegrationOutput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl PutIntegrationOutput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>The timestamp of when the domain was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for PutIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutIntegrationOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("uri", &self.uri);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
pub mod put_integration_output {
    /// A builder for [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
        pub fn build(self) -> crate::output::PutIntegrationOutput {
            crate::output::PutIntegrationOutput {
                domain_name: self.domain_name,
                uri: self.uri,
                object_type_name: self.object_type_name,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl PutIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`PutIntegrationOutput`](crate::output::PutIntegrationOutput)
    pub fn builder() -> crate::output::put_integration_output::Builder {
        crate::output::put_integration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MergeProfilesOutput {
    /// <p>A message that indicates the merge request is complete.</p>
    pub message: std::option::Option<std::string::String>,
}
impl MergeProfilesOutput {
    /// <p>A message that indicates the merge request is complete.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for MergeProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MergeProfilesOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`MergeProfilesOutput`](crate::output::MergeProfilesOutput)
pub mod merge_profiles_output {
    /// A builder for [`MergeProfilesOutput`](crate::output::MergeProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that indicates the merge request is complete.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates the merge request is complete.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`MergeProfilesOutput`](crate::output::MergeProfilesOutput)
        pub fn build(self) -> crate::output::MergeProfilesOutput {
            crate::output::MergeProfilesOutput {
                message: self.message,
            }
        }
    }
}
impl MergeProfilesOutput {
    /// Creates a new builder-style object to manufacture [`MergeProfilesOutput`](crate::output::MergeProfilesOutput)
    pub fn builder() -> crate::output::merge_profiles_output::Builder {
        crate::output::merge_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectTypeTemplatesOutput {
    /// <p>The list of ListProfileObjectType template instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ListProfileObjectTypeTemplateItem>>,
    /// <p>The pagination token from the previous ListObjectTypeTemplates API call. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProfileObjectTypeTemplatesOutput {
    /// <p>The list of ListProfileObjectType template instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ListProfileObjectTypeTemplateItem]> {
        self.items.as_deref()
    }
    /// <p>The pagination token from the previous ListObjectTypeTemplates API call. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProfileObjectTypeTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectTypeTemplatesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProfileObjectTypeTemplatesOutput`](crate::output::ListProfileObjectTypeTemplatesOutput)
pub mod list_profile_object_type_templates_output {
    /// A builder for [`ListProfileObjectTypeTemplatesOutput`](crate::output::ListProfileObjectTypeTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::ListProfileObjectTypeTemplateItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of ListProfileObjectType template instances.</p>
        pub fn items(
            mut self,
            input: impl Into<crate::model::ListProfileObjectTypeTemplateItem>,
        ) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of ListProfileObjectType template instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ListProfileObjectTypeTemplateItem>,
            >,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListObjectTypeTemplates API call. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectTypeTemplatesOutput`](crate::output::ListProfileObjectTypeTemplatesOutput)
        pub fn build(self) -> crate::output::ListProfileObjectTypeTemplatesOutput {
            crate::output::ListProfileObjectTypeTemplatesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProfileObjectTypeTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypeTemplatesOutput`](crate::output::ListProfileObjectTypeTemplatesOutput)
    pub fn builder() -> crate::output::list_profile_object_type_templates_output::Builder {
        crate::output::list_profile_object_type_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectTypesOutput {
    /// <p>The list of ListProfileObjectTypes instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ListProfileObjectTypeItem>>,
    /// <p>Identifies the next page of results to return.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProfileObjectTypesOutput {
    /// <p>The list of ListProfileObjectTypes instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ListProfileObjectTypeItem]> {
        self.items.as_deref()
    }
    /// <p>Identifies the next page of results to return.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProfileObjectTypesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectTypesOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProfileObjectTypesOutput`](crate::output::ListProfileObjectTypesOutput)
pub mod list_profile_object_types_output {
    /// A builder for [`ListProfileObjectTypesOutput`](crate::output::ListProfileObjectTypesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items:
            std::option::Option<std::vec::Vec<crate::model::ListProfileObjectTypeItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of ListProfileObjectTypes instances.</p>
        pub fn items(mut self, input: impl Into<crate::model::ListProfileObjectTypeItem>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of ListProfileObjectTypes instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListProfileObjectTypeItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>Identifies the next page of results to return.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectTypesOutput`](crate::output::ListProfileObjectTypesOutput)
        pub fn build(self) -> crate::output::ListProfileObjectTypesOutput {
            crate::output::ListProfileObjectTypesOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProfileObjectTypesOutput {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypesOutput`](crate::output::ListProfileObjectTypesOutput)
    pub fn builder() -> crate::output::list_profile_object_types_output::Builder {
        crate::output::list_profile_object_types_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectsOutput {
    /// <p>The list of ListProfileObject instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ListProfileObjectsItem>>,
    /// <p>The pagination token from the previous call to ListProfileObjects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProfileObjectsOutput {
    /// <p>The list of ListProfileObject instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ListProfileObjectsItem]> {
        self.items.as_deref()
    }
    /// <p>The pagination token from the previous call to ListProfileObjects.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProfileObjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProfileObjectsOutput`](crate::output::ListProfileObjectsOutput)
pub mod list_profile_objects_output {
    /// A builder for [`ListProfileObjectsOutput`](crate::output::ListProfileObjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::ListProfileObjectsItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of ListProfileObject instances.</p>
        pub fn items(mut self, input: impl Into<crate::model::ListProfileObjectsItem>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of ListProfileObject instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListProfileObjectsItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous call to ListProfileObjects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectsOutput`](crate::output::ListProfileObjectsOutput)
        pub fn build(self) -> crate::output::ListProfileObjectsOutput {
            crate::output::ListProfileObjectsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProfileObjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectsOutput`](crate::output::ListProfileObjectsOutput)
    pub fn builder() -> crate::output::list_profile_objects_output::Builder {
        crate::output::list_profile_objects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIntegrationsOutput {
    /// <p>The list of ListIntegrations instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ListIntegrationItem>>,
    /// <p>The pagination token from the previous ListIntegrations API call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListIntegrationsOutput {
    /// <p>The list of ListIntegrations instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ListIntegrationItem]> {
        self.items.as_deref()
    }
    /// <p>The pagination token from the previous ListIntegrations API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListIntegrationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIntegrationsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListIntegrationsOutput`](crate::output::ListIntegrationsOutput)
pub mod list_integrations_output {
    /// A builder for [`ListIntegrationsOutput`](crate::output::ListIntegrationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::ListIntegrationItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of ListIntegrations instances.</p>
        pub fn items(mut self, input: impl Into<crate::model::ListIntegrationItem>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of ListIntegrations instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListIntegrationItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIntegrationsOutput`](crate::output::ListIntegrationsOutput)
        pub fn build(self) -> crate::output::ListIntegrationsOutput {
            crate::output::ListIntegrationsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListIntegrationsOutput {
    /// Creates a new builder-style object to manufacture [`ListIntegrationsOutput`](crate::output::ListIntegrationsOutput)
    pub fn builder() -> crate::output::list_integrations_output::Builder {
        crate::output::list_integrations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainsOutput {
    /// <p>The list of ListDomains instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ListDomainItem>>,
    /// <p>The pagination token from the previous ListDomains API call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDomainsOutput {
    /// <p>The list of ListDomains instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ListDomainItem]> {
        self.items.as_deref()
    }
    /// <p>The pagination token from the previous ListDomains API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDomainsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDomainsOutput`](crate::output::ListDomainsOutput)
pub mod list_domains_output {
    /// A builder for [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::ListDomainItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of ListDomains instances.</p>
        pub fn items(mut self, input: impl Into<crate::model::ListDomainItem>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of ListDomains instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListDomainItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The pagination token from the previous ListDomains API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListDomains API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainsOutput`](crate::output::ListDomainsOutput)
        pub fn build(self) -> crate::output::ListDomainsOutput {
            crate::output::ListDomainsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDomainsOutput {
    /// Creates a new builder-style object to manufacture [`ListDomainsOutput`](crate::output::ListDomainsOutput)
    pub fn builder() -> crate::output::list_domains_output::Builder {
        crate::output::list_domains_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListAccountIntegrationsOutput {
    /// <p>The list of ListAccountIntegration instances.</p>
    pub items: std::option::Option<std::vec::Vec<crate::model::ListIntegrationItem>>,
    /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListAccountIntegrationsOutput {
    /// <p>The list of ListAccountIntegration instances.</p>
    pub fn items(&self) -> std::option::Option<&[crate::model::ListIntegrationItem]> {
        self.items.as_deref()
    }
    /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListAccountIntegrationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListAccountIntegrationsOutput");
        formatter.field("items", &self.items);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListAccountIntegrationsOutput`](crate::output::ListAccountIntegrationsOutput)
pub mod list_account_integrations_output {
    /// A builder for [`ListAccountIntegrationsOutput`](crate::output::ListAccountIntegrationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) items: std::option::Option<std::vec::Vec<crate::model::ListIntegrationItem>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `items`.
        ///
        /// To override the contents of this collection use [`set_items`](Self::set_items).
        ///
        /// <p>The list of ListAccountIntegration instances.</p>
        pub fn items(mut self, input: impl Into<crate::model::ListIntegrationItem>) -> Self {
            let mut v = self.items.unwrap_or_default();
            v.push(input.into());
            self.items = Some(v);
            self
        }
        /// <p>The list of ListAccountIntegration instances.</p>
        pub fn set_items(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListIntegrationItem>>,
        ) -> Self {
            self.items = input;
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token from the previous ListAccountIntegrations API call.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAccountIntegrationsOutput`](crate::output::ListAccountIntegrationsOutput)
        pub fn build(self) -> crate::output::ListAccountIntegrationsOutput {
            crate::output::ListAccountIntegrationsOutput {
                items: self.items,
                next_token: self.next_token,
            }
        }
    }
}
impl ListAccountIntegrationsOutput {
    /// Creates a new builder-style object to manufacture [`ListAccountIntegrationsOutput`](crate::output::ListAccountIntegrationsOutput)
    pub fn builder() -> crate::output::list_account_integrations_output::Builder {
        crate::output::list_account_integrations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProfileObjectTypeTemplateOutput {
    /// <p>A unique identifier for the object template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The name of the source of the object template.</p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p>The source of the object template.</p>
    pub source_object: std::option::Option<std::string::String>,
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
    /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
    /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
    /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
    /// is found, then the service creates a new standard profile.</p>
    pub allow_profile_creation: bool,
    /// <p>A map of the name and ObjectType field.</p>
    pub fields: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    >,
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub keys: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    >,
}
impl GetProfileObjectTypeTemplateOutput {
    /// <p>A unique identifier for the object template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The name of the source of the object template.</p>
    pub fn source_name(&self) -> std::option::Option<&str> {
        self.source_name.as_deref()
    }
    /// <p>The source of the object template.</p>
    pub fn source_object(&self) -> std::option::Option<&str> {
        self.source_object.as_deref()
    }
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
    /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
    /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
    /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
    /// is found, then the service creates a new standard profile.</p>
    pub fn allow_profile_creation(&self) -> bool {
        self.allow_profile_creation
    }
    /// <p>A map of the name and ObjectType field.</p>
    pub fn fields(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    > {
        self.fields.as_ref()
    }
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub fn keys(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    > {
        self.keys.as_ref()
    }
}
impl std::fmt::Debug for GetProfileObjectTypeTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProfileObjectTypeTemplateOutput");
        formatter.field("template_id", &self.template_id);
        formatter.field("source_name", &self.source_name);
        formatter.field("source_object", &self.source_object);
        formatter.field("allow_profile_creation", &self.allow_profile_creation);
        formatter.field("fields", &self.fields);
        formatter.field("keys", &self.keys);
        formatter.finish()
    }
}
/// See [`GetProfileObjectTypeTemplateOutput`](crate::output::GetProfileObjectTypeTemplateOutput)
pub mod get_profile_object_type_template_output {
    /// A builder for [`GetProfileObjectTypeTemplateOutput`](crate::output::GetProfileObjectTypeTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_object: std::option::Option<std::string::String>,
        pub(crate) allow_profile_creation: std::option::Option<bool>,
        pub(crate) fields: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
        >,
        pub(crate) keys: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ObjectTypeKey>,
            >,
        >,
    }
    impl Builder {
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The name of the source of the object template.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p>The name of the source of the object template.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p>The source of the object template.</p>
        pub fn source_object(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_object = Some(input.into());
            self
        }
        /// <p>The source of the object template.</p>
        pub fn set_source_object(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_object = input;
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn allow_profile_creation(mut self, input: bool) -> Self {
            self.allow_profile_creation = Some(input);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn set_allow_profile_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_profile_creation = input;
            self
        }
        /// Adds a key-value pair to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A map of the name and ObjectType field.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ObjectTypeField>,
        ) -> Self {
            let mut hash_map = self.fields.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.fields = Some(hash_map);
            self
        }
        /// <p>A map of the name and ObjectType field.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
            >,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Adds a key-value pair to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ObjectTypeKey>>,
        ) -> Self {
            let mut hash_map = self.keys.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.keys = Some(hash_map);
            self
        }
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ObjectTypeKey>,
                >,
            >,
        ) -> Self {
            self.keys = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProfileObjectTypeTemplateOutput`](crate::output::GetProfileObjectTypeTemplateOutput)
        pub fn build(self) -> crate::output::GetProfileObjectTypeTemplateOutput {
            crate::output::GetProfileObjectTypeTemplateOutput {
                template_id: self.template_id,
                source_name: self.source_name,
                source_object: self.source_object,
                allow_profile_creation: self.allow_profile_creation.unwrap_or_default(),
                fields: self.fields,
                keys: self.keys,
            }
        }
    }
}
impl GetProfileObjectTypeTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetProfileObjectTypeTemplateOutput`](crate::output::GetProfileObjectTypeTemplateOutput)
    pub fn builder() -> crate::output::get_profile_object_type_template_output::Builder {
        crate::output::get_profile_object_type_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProfileObjectTypeOutput {
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The description of the profile object type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the object template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The number of days until the data in the object expires.</p>
    pub expiration_days: std::option::Option<i32>,
    /// <p>The customer-provided key to encrypt the profile object that will be created in this
    /// profile object type.</p>
    pub encryption_key: std::option::Option<std::string::String>,
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
    /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
    /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
    /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
    /// is found, then the service creates a new standard profile.</p>
    pub allow_profile_creation: bool,
    /// <p>A map of the name and ObjectType field.</p>
    pub fields: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    >,
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub keys: std::option::Option<
        std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    >,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetProfileObjectTypeOutput {
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>The description of the profile object type.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A unique identifier for the object template.</p>
    pub fn template_id(&self) -> std::option::Option<&str> {
        self.template_id.as_deref()
    }
    /// <p>The number of days until the data in the object expires.</p>
    pub fn expiration_days(&self) -> std::option::Option<i32> {
        self.expiration_days
    }
    /// <p>The customer-provided key to encrypt the profile object that will be created in this
    /// profile object type.</p>
    pub fn encryption_key(&self) -> std::option::Option<&str> {
        self.encryption_key.as_deref()
    }
    /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
    /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
    /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
    /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
    /// is found, then the service creates a new standard profile.</p>
    pub fn allow_profile_creation(&self) -> bool {
        self.allow_profile_creation
    }
    /// <p>A map of the name and ObjectType field.</p>
    pub fn fields(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
    > {
        self.fields.as_ref()
    }
    /// <p>A list of unique keys that can be used to map data to the profile.</p>
    pub fn keys(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, std::vec::Vec<crate::model::ObjectTypeKey>>,
    > {
        self.keys.as_ref()
    }
    /// <p>The timestamp of when the domain was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetProfileObjectTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProfileObjectTypeOutput");
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("description", &self.description);
        formatter.field("template_id", &self.template_id);
        formatter.field("expiration_days", &self.expiration_days);
        formatter.field("encryption_key", &self.encryption_key);
        formatter.field("allow_profile_creation", &self.allow_profile_creation);
        formatter.field("fields", &self.fields);
        formatter.field("keys", &self.keys);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetProfileObjectTypeOutput`](crate::output::GetProfileObjectTypeOutput)
pub mod get_profile_object_type_output {
    /// A builder for [`GetProfileObjectTypeOutput`](crate::output::GetProfileObjectTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) expiration_days: std::option::Option<i32>,
        pub(crate) encryption_key: std::option::Option<std::string::String>,
        pub(crate) allow_profile_creation: std::option::Option<bool>,
        pub(crate) fields: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
        >,
        pub(crate) keys: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                std::vec::Vec<crate::model::ObjectTypeKey>,
            >,
        >,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The description of the profile object type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the profile object type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn expiration_days(mut self, input: i32) -> Self {
            self.expiration_days = Some(input);
            self
        }
        /// <p>The number of days until the data in the object expires.</p>
        pub fn set_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.expiration_days = input;
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this
        /// profile object type.</p>
        pub fn encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_key = Some(input.into());
            self
        }
        /// <p>The customer-provided key to encrypt the profile object that will be created in this
        /// profile object type.</p>
        pub fn set_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_key = input;
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn allow_profile_creation(mut self, input: bool) -> Self {
            self.allow_profile_creation = Some(input);
            self
        }
        /// <p>Indicates whether a profile should be created when data is received if one doesn’t exist
        /// for an object of this type. The default is <code>FALSE</code>. If the AllowProfileCreation
        /// flag is set to <code>FALSE</code>, then the service tries to fetch a standard profile and
        /// associate this object with the profile. If it is set to <code>TRUE</code>, and if no match
        /// is found, then the service creates a new standard profile.</p>
        pub fn set_allow_profile_creation(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_profile_creation = input;
            self
        }
        /// Adds a key-value pair to `fields`.
        ///
        /// To override the contents of this collection use [`set_fields`](Self::set_fields).
        ///
        /// <p>A map of the name and ObjectType field.</p>
        pub fn fields(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::ObjectTypeField>,
        ) -> Self {
            let mut hash_map = self.fields.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.fields = Some(hash_map);
            self
        }
        /// <p>A map of the name and ObjectType field.</p>
        pub fn set_fields(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::ObjectTypeField>,
            >,
        ) -> Self {
            self.fields = input;
            self
        }
        /// Adds a key-value pair to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn keys(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::vec::Vec<crate::model::ObjectTypeKey>>,
        ) -> Self {
            let mut hash_map = self.keys.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.keys = Some(hash_map);
            self
        }
        /// <p>A list of unique keys that can be used to map data to the profile.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    std::vec::Vec<crate::model::ObjectTypeKey>,
                >,
            >,
        ) -> Self {
            self.keys = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProfileObjectTypeOutput`](crate::output::GetProfileObjectTypeOutput)
        pub fn build(self) -> crate::output::GetProfileObjectTypeOutput {
            crate::output::GetProfileObjectTypeOutput {
                object_type_name: self.object_type_name,
                description: self.description,
                template_id: self.template_id,
                expiration_days: self.expiration_days,
                encryption_key: self.encryption_key,
                allow_profile_creation: self.allow_profile_creation.unwrap_or_default(),
                fields: self.fields,
                keys: self.keys,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl GetProfileObjectTypeOutput {
    /// Creates a new builder-style object to manufacture [`GetProfileObjectTypeOutput`](crate::output::GetProfileObjectTypeOutput)
    pub fn builder() -> crate::output::get_profile_object_type_output::Builder {
        crate::output::get_profile_object_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMatchesOutput {
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The timestamp this version of Match Result generated.</p>
    pub match_generation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of potential matches found.</p>
    pub potential_matches: std::option::Option<i32>,
    /// <p>The list of matched profiles for this instance.</p>
    pub matches: std::option::Option<std::vec::Vec<crate::model::MatchItem>>,
}
impl GetMatchesOutput {
    /// <p>If there are additional results, this is the token for the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The timestamp this version of Match Result generated.</p>
    pub fn match_generation_date(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.match_generation_date.as_ref()
    }
    /// <p>The number of potential matches found.</p>
    pub fn potential_matches(&self) -> std::option::Option<i32> {
        self.potential_matches
    }
    /// <p>The list of matched profiles for this instance.</p>
    pub fn matches(&self) -> std::option::Option<&[crate::model::MatchItem]> {
        self.matches.as_deref()
    }
}
impl std::fmt::Debug for GetMatchesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMatchesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("match_generation_date", &self.match_generation_date);
        formatter.field("potential_matches", &self.potential_matches);
        formatter.field("matches", &self.matches);
        formatter.finish()
    }
}
/// See [`GetMatchesOutput`](crate::output::GetMatchesOutput)
pub mod get_matches_output {
    /// A builder for [`GetMatchesOutput`](crate::output::GetMatchesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) match_generation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) potential_matches: std::option::Option<i32>,
        pub(crate) matches: std::option::Option<std::vec::Vec<crate::model::MatchItem>>,
    }
    impl Builder {
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If there are additional results, this is the token for the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The timestamp this version of Match Result generated.</p>
        pub fn match_generation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.match_generation_date = Some(input);
            self
        }
        /// <p>The timestamp this version of Match Result generated.</p>
        pub fn set_match_generation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.match_generation_date = input;
            self
        }
        /// <p>The number of potential matches found.</p>
        pub fn potential_matches(mut self, input: i32) -> Self {
            self.potential_matches = Some(input);
            self
        }
        /// <p>The number of potential matches found.</p>
        pub fn set_potential_matches(mut self, input: std::option::Option<i32>) -> Self {
            self.potential_matches = input;
            self
        }
        /// Appends an item to `matches`.
        ///
        /// To override the contents of this collection use [`set_matches`](Self::set_matches).
        ///
        /// <p>The list of matched profiles for this instance.</p>
        pub fn matches(mut self, input: impl Into<crate::model::MatchItem>) -> Self {
            let mut v = self.matches.unwrap_or_default();
            v.push(input.into());
            self.matches = Some(v);
            self
        }
        /// <p>The list of matched profiles for this instance.</p>
        pub fn set_matches(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchItem>>,
        ) -> Self {
            self.matches = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMatchesOutput`](crate::output::GetMatchesOutput)
        pub fn build(self) -> crate::output::GetMatchesOutput {
            crate::output::GetMatchesOutput {
                next_token: self.next_token,
                match_generation_date: self.match_generation_date,
                potential_matches: self.potential_matches,
                matches: self.matches,
            }
        }
    }
}
impl GetMatchesOutput {
    /// Creates a new builder-style object to manufacture [`GetMatchesOutput`](crate::output::GetMatchesOutput)
    pub fn builder() -> crate::output::get_matches_output::Builder {
        crate::output::get_matches_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetIntegrationOutput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetIntegrationOutput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub fn uri(&self) -> std::option::Option<&str> {
        self.uri.as_deref()
    }
    /// <p>The name of the profile object type.</p>
    pub fn object_type_name(&self) -> std::option::Option<&str> {
        self.object_type_name.as_deref()
    }
    /// <p>The timestamp of when the domain was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetIntegrationOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("uri", &self.uri);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
pub mod get_integration_output {
    /// A builder for [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
        pub fn build(self) -> crate::output::GetIntegrationOutput {
            crate::output::GetIntegrationOutput {
                domain_name: self.domain_name,
                uri: self.uri,
                object_type_name: self.object_type_name,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl GetIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`GetIntegrationOutput`](crate::output::GetIntegrationOutput)
    pub fn builder() -> crate::output::get_integration_output::Builder {
        crate::output::get_integration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDomainOutput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The default number of days until the data within the domain expires.</p>
    pub default_expiration_days: std::option::Option<i32>,
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
    /// of encryption key is specified. It is used to encrypt all data before it is placed in
    /// permanent or semi-permanent storage.</p>
    pub default_encryption_key: std::option::Option<std::string::String>,
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
    /// ingesting data from third party applications.</p>
    pub dead_letter_queue_url: std::option::Option<std::string::String>,
    /// <p>Usage-specific statistics about the domain.</p>
    pub stats: std::option::Option<crate::model::DomainStats>,
    /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
    /// After that batch process completes, use the
    /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
    /// API to return and review the results.  </p>
    pub matching: std::option::Option<crate::model::MatchingResponse>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl GetDomainOutput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The default number of days until the data within the domain expires.</p>
    pub fn default_expiration_days(&self) -> std::option::Option<i32> {
        self.default_expiration_days
    }
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
    /// of encryption key is specified. It is used to encrypt all data before it is placed in
    /// permanent or semi-permanent storage.</p>
    pub fn default_encryption_key(&self) -> std::option::Option<&str> {
        self.default_encryption_key.as_deref()
    }
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
    /// ingesting data from third party applications.</p>
    pub fn dead_letter_queue_url(&self) -> std::option::Option<&str> {
        self.dead_letter_queue_url.as_deref()
    }
    /// <p>Usage-specific statistics about the domain.</p>
    pub fn stats(&self) -> std::option::Option<&crate::model::DomainStats> {
        self.stats.as_ref()
    }
    /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
    /// After that batch process completes, use the
    /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
    /// API to return and review the results.  </p>
    pub fn matching(&self) -> std::option::Option<&crate::model::MatchingResponse> {
        self.matching.as_ref()
    }
    /// <p>The timestamp of when the domain was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for GetDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDomainOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("default_expiration_days", &self.default_expiration_days);
        formatter.field("default_encryption_key", &self.default_encryption_key);
        formatter.field("dead_letter_queue_url", &self.dead_letter_queue_url);
        formatter.field("stats", &self.stats);
        formatter.field("matching", &self.matching);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`GetDomainOutput`](crate::output::GetDomainOutput)
pub mod get_domain_output {
    /// A builder for [`GetDomainOutput`](crate::output::GetDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) default_expiration_days: std::option::Option<i32>,
        pub(crate) default_encryption_key: std::option::Option<std::string::String>,
        pub(crate) dead_letter_queue_url: std::option::Option<std::string::String>,
        pub(crate) stats: std::option::Option<crate::model::DomainStats>,
        pub(crate) matching: std::option::Option<crate::model::MatchingResponse>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, input: i32) -> Self {
            self.default_expiration_days = Some(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.default_expiration_days = input;
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn default_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_encryption_key = Some(input.into());
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_encryption_key = input;
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications.</p>
        pub fn dead_letter_queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.dead_letter_queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dead_letter_queue_url = input;
            self
        }
        /// <p>Usage-specific statistics about the domain.</p>
        pub fn stats(mut self, input: crate::model::DomainStats) -> Self {
            self.stats = Some(input);
            self
        }
        /// <p>Usage-specific statistics about the domain.</p>
        pub fn set_stats(mut self, input: std::option::Option<crate::model::DomainStats>) -> Self {
            self.stats = input;
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn matching(mut self, input: crate::model::MatchingResponse) -> Self {
            self.matching = Some(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingResponse>,
        ) -> Self {
            self.matching = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDomainOutput`](crate::output::GetDomainOutput)
        pub fn build(self) -> crate::output::GetDomainOutput {
            crate::output::GetDomainOutput {
                domain_name: self.domain_name,
                default_expiration_days: self.default_expiration_days,
                default_encryption_key: self.default_encryption_key,
                dead_letter_queue_url: self.dead_letter_queue_url,
                stats: self.stats,
                matching: self.matching,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl GetDomainOutput {
    /// Creates a new builder-style object to manufacture [`GetDomainOutput`](crate::output::GetDomainOutput)
    pub fn builder() -> crate::output::get_domain_output::Builder {
        crate::output::get_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileObjectTypeOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DeleteProfileObjectTypeOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileObjectTypeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileObjectTypeOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DeleteProfileObjectTypeOutput`](crate::output::DeleteProfileObjectTypeOutput)
pub mod delete_profile_object_type_output {
    /// A builder for [`DeleteProfileObjectTypeOutput`](crate::output::DeleteProfileObjectTypeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that indicates the delete request is done.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates the delete request is done.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileObjectTypeOutput`](crate::output::DeleteProfileObjectTypeOutput)
        pub fn build(self) -> crate::output::DeleteProfileObjectTypeOutput {
            crate::output::DeleteProfileObjectTypeOutput {
                message: self.message,
            }
        }
    }
}
impl DeleteProfileObjectTypeOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProfileObjectTypeOutput`](crate::output::DeleteProfileObjectTypeOutput)
    pub fn builder() -> crate::output::delete_profile_object_type_output::Builder {
        crate::output::delete_profile_object_type_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileObjectOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DeleteProfileObjectOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileObjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileObjectOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DeleteProfileObjectOutput`](crate::output::DeleteProfileObjectOutput)
pub mod delete_profile_object_output {
    /// A builder for [`DeleteProfileObjectOutput`](crate::output::DeleteProfileObjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that indicates the delete request is done.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates the delete request is done.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileObjectOutput`](crate::output::DeleteProfileObjectOutput)
        pub fn build(self) -> crate::output::DeleteProfileObjectOutput {
            crate::output::DeleteProfileObjectOutput {
                message: self.message,
            }
        }
    }
}
impl DeleteProfileObjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProfileObjectOutput`](crate::output::DeleteProfileObjectOutput)
    pub fn builder() -> crate::output::delete_profile_object_output::Builder {
        crate::output::delete_profile_object_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileKeyOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DeleteProfileKeyOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileKeyOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DeleteProfileKeyOutput`](crate::output::DeleteProfileKeyOutput)
pub mod delete_profile_key_output {
    /// A builder for [`DeleteProfileKeyOutput`](crate::output::DeleteProfileKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that indicates the delete request is done.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates the delete request is done.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileKeyOutput`](crate::output::DeleteProfileKeyOutput)
        pub fn build(self) -> crate::output::DeleteProfileKeyOutput {
            crate::output::DeleteProfileKeyOutput {
                message: self.message,
            }
        }
    }
}
impl DeleteProfileKeyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProfileKeyOutput`](crate::output::DeleteProfileKeyOutput)
    pub fn builder() -> crate::output::delete_profile_key_output::Builder {
        crate::output::delete_profile_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProfileOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DeleteProfileOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DeleteProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProfileOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DeleteProfileOutput`](crate::output::DeleteProfileOutput)
pub mod delete_profile_output {
    /// A builder for [`DeleteProfileOutput`](crate::output::DeleteProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that indicates the delete request is done.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates the delete request is done.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProfileOutput`](crate::output::DeleteProfileOutput)
        pub fn build(self) -> crate::output::DeleteProfileOutput {
            crate::output::DeleteProfileOutput {
                message: self.message,
            }
        }
    }
}
impl DeleteProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProfileOutput`](crate::output::DeleteProfileOutput)
    pub fn builder() -> crate::output::delete_profile_output::Builder {
        crate::output::delete_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteIntegrationOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DeleteIntegrationOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DeleteIntegrationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteIntegrationOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
pub mod delete_integration_output {
    /// A builder for [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that indicates the delete request is done.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates the delete request is done.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
        pub fn build(self) -> crate::output::DeleteIntegrationOutput {
            crate::output::DeleteIntegrationOutput {
                message: self.message,
            }
        }
    }
}
impl DeleteIntegrationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationOutput`](crate::output::DeleteIntegrationOutput)
    pub fn builder() -> crate::output::delete_integration_output::Builder {
        crate::output::delete_integration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDomainOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DeleteDomainOutput {
    /// <p>A message that indicates the delete request is done.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DeleteDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDomainOutput");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
pub mod delete_domain_output {
    /// A builder for [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A message that indicates the delete request is done.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A message that indicates the delete request is done.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
        pub fn build(self) -> crate::output::DeleteDomainOutput {
            crate::output::DeleteDomainOutput {
                message: self.message,
            }
        }
    }
}
impl DeleteDomainOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDomainOutput`](crate::output::DeleteDomainOutput)
    pub fn builder() -> crate::output::delete_domain_output::Builder {
        crate::output::delete_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProfileOutput {
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
}
impl CreateProfileOutput {
    /// <p>The unique identifier of a customer profile.</p>
    pub fn profile_id(&self) -> std::option::Option<&str> {
        self.profile_id.as_deref()
    }
}
impl std::fmt::Debug for CreateProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProfileOutput");
        formatter.field("profile_id", &self.profile_id);
        formatter.finish()
    }
}
/// See [`CreateProfileOutput`](crate::output::CreateProfileOutput)
pub mod create_profile_output {
    /// A builder for [`CreateProfileOutput`](crate::output::CreateProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProfileOutput`](crate::output::CreateProfileOutput)
        pub fn build(self) -> crate::output::CreateProfileOutput {
            crate::output::CreateProfileOutput {
                profile_id: self.profile_id,
            }
        }
    }
}
impl CreateProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateProfileOutput`](crate::output::CreateProfileOutput)
    pub fn builder() -> crate::output::create_profile_output::Builder {
        crate::output::create_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDomainOutput {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The default number of days until the data within the domain expires.</p>
    pub default_expiration_days: std::option::Option<i32>,
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
    /// of encryption key is specified. It is used to encrypt all data before it is placed in
    /// permanent or semi-permanent storage.</p>
    pub default_encryption_key: std::option::Option<std::string::String>,
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
    /// ingesting data from third party applications.</p>
    pub dead_letter_queue_url: std::option::Option<std::string::String>,
    /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
    /// After that batch process completes, use the
    /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
    /// API to return and review the results.  </p>
    pub matching: std::option::Option<crate::model::MatchingResponse>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateDomainOutput {
    /// <p>The unique name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
    /// <p>The default number of days until the data within the domain expires.</p>
    pub fn default_expiration_days(&self) -> std::option::Option<i32> {
        self.default_expiration_days
    }
    /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
    /// of encryption key is specified. It is used to encrypt all data before it is placed in
    /// permanent or semi-permanent storage.</p>
    pub fn default_encryption_key(&self) -> std::option::Option<&str> {
        self.default_encryption_key.as_deref()
    }
    /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
    /// ingesting data from third party applications.</p>
    pub fn dead_letter_queue_url(&self) -> std::option::Option<&str> {
        self.dead_letter_queue_url.as_deref()
    }
    /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
    /// After that batch process completes, use the
    /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
    /// API to return and review the results.  </p>
    pub fn matching(&self) -> std::option::Option<&crate::model::MatchingResponse> {
        self.matching.as_ref()
    }
    /// <p>The timestamp of when the domain was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateDomainOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDomainOutput");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("default_expiration_days", &self.default_expiration_days);
        formatter.field("default_encryption_key", &self.default_encryption_key);
        formatter.field("dead_letter_queue_url", &self.dead_letter_queue_url);
        formatter.field("matching", &self.matching);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateDomainOutput`](crate::output::CreateDomainOutput)
pub mod create_domain_output {
    /// A builder for [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) default_expiration_days: std::option::Option<i32>,
        pub(crate) default_encryption_key: std::option::Option<std::string::String>,
        pub(crate) dead_letter_queue_url: std::option::Option<std::string::String>,
        pub(crate) matching: std::option::Option<crate::model::MatchingResponse>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn default_expiration_days(mut self, input: i32) -> Self {
            self.default_expiration_days = Some(input);
            self
        }
        /// <p>The default number of days until the data within the domain expires.</p>
        pub fn set_default_expiration_days(mut self, input: std::option::Option<i32>) -> Self {
            self.default_expiration_days = input;
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn default_encryption_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_encryption_key = Some(input.into());
            self
        }
        /// <p>The default encryption key, which is an AWS managed key, is used when no specific type
        /// of encryption key is specified. It is used to encrypt all data before it is placed in
        /// permanent or semi-permanent storage.</p>
        pub fn set_default_encryption_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_encryption_key = input;
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications.</p>
        pub fn dead_letter_queue_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.dead_letter_queue_url = Some(input.into());
            self
        }
        /// <p>The URL of the SQS dead letter queue, which is used for reporting errors associated with
        /// ingesting data from third party applications.</p>
        pub fn set_dead_letter_queue_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dead_letter_queue_url = input;
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn matching(mut self, input: crate::model::MatchingResponse) -> Self {
            self.matching = Some(input);
            self
        }
        /// <p>The process of matching duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly batch process every Saturday at 12AM UTC to detect duplicate profiles in your domains.
        /// After that batch process completes, use the
        /// <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>
        /// API to return and review the results.  </p>
        pub fn set_matching(
            mut self,
            input: std::option::Option<crate::model::MatchingResponse>,
        ) -> Self {
            self.matching = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDomainOutput`](crate::output::CreateDomainOutput)
        pub fn build(self) -> crate::output::CreateDomainOutput {
            crate::output::CreateDomainOutput {
                domain_name: self.domain_name,
                default_expiration_days: self.default_expiration_days,
                default_encryption_key: self.default_encryption_key,
                dead_letter_queue_url: self.dead_letter_queue_url,
                matching: self.matching,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl CreateDomainOutput {
    /// Creates a new builder-style object to manufacture [`CreateDomainOutput`](crate::output::CreateDomainOutput)
    pub fn builder() -> crate::output::create_domain_output::Builder {
        crate::output::create_domain_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddProfileKeyOutput {
    /// <p>A searchable identifier of a customer profile.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>A list of key values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl AddProfileKeyOutput {
    /// <p>A searchable identifier of a customer profile.</p>
    pub fn key_name(&self) -> std::option::Option<&str> {
        self.key_name.as_deref()
    }
    /// <p>A list of key values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for AddProfileKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddProfileKeyOutput");
        formatter.field("key_name", &self.key_name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`AddProfileKeyOutput`](crate::output::AddProfileKeyOutput)
pub mod add_profile_key_output {
    /// A builder for [`AddProfileKeyOutput`](crate::output::AddProfileKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>A searchable identifier of a customer profile.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`AddProfileKeyOutput`](crate::output::AddProfileKeyOutput)
        pub fn build(self) -> crate::output::AddProfileKeyOutput {
            crate::output::AddProfileKeyOutput {
                key_name: self.key_name,
                values: self.values,
            }
        }
    }
}
impl AddProfileKeyOutput {
    /// Creates a new builder-style object to manufacture [`AddProfileKeyOutput`](crate::output::AddProfileKeyOutput)
    pub fn builder() -> crate::output::add_profile_key_output::Builder {
        crate::output::add_profile_key_output::Builder::default()
    }
}
