// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddProfileKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_profile_key`](crate::client::Client::add_profile_key).
///
/// See [`crate::client::fluent_builders::AddProfileKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddProfileKey {
    _private: (),
}
impl AddProfileKey {
    /// Creates a new builder-style object to manufacture [`AddProfileKeyInput`](crate::input::AddProfileKeyInput)
    pub fn builder() -> crate::input::add_profile_key_input::Builder {
        crate::input::add_profile_key_input::Builder::default()
    }
    /// Creates a new `AddProfileKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddProfileKey {
    type Output =
        std::result::Result<crate::output::AddProfileKeyOutput, crate::error::AddProfileKeyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_add_profile_key_error(response)
        } else {
            crate::operation_deser::parse_add_profile_key_response(response)
        }
    }
}

/// Operation shape for `CreateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_domain`](crate::client::Client::create_domain).
///
/// See [`crate::client::fluent_builders::CreateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDomain {
    _private: (),
}
impl CreateDomain {
    /// Creates a new builder-style object to manufacture [`CreateDomainInput`](crate::input::CreateDomainInput)
    pub fn builder() -> crate::input::create_domain_input::Builder {
        crate::input::create_domain_input::Builder::default()
    }
    /// Creates a new `CreateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDomain {
    type Output =
        std::result::Result<crate::output::CreateDomainOutput, crate::error::CreateDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_domain_error(response)
        } else {
            crate::operation_deser::parse_create_domain_response(response)
        }
    }
}

/// Operation shape for `CreateProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_profile`](crate::client::Client::create_profile).
///
/// See [`crate::client::fluent_builders::CreateProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProfile {
    _private: (),
}
impl CreateProfile {
    /// Creates a new builder-style object to manufacture [`CreateProfileInput`](crate::input::CreateProfileInput)
    pub fn builder() -> crate::input::create_profile_input::Builder {
        crate::input::create_profile_input::Builder::default()
    }
    /// Creates a new `CreateProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProfile {
    type Output =
        std::result::Result<crate::output::CreateProfileOutput, crate::error::CreateProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_profile_error(response)
        } else {
            crate::operation_deser::parse_create_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_domain`](crate::client::Client::delete_domain).
///
/// See [`crate::client::fluent_builders::DeleteDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDomain {
    _private: (),
}
impl DeleteDomain {
    /// Creates a new builder-style object to manufacture [`DeleteDomainInput`](crate::input::DeleteDomainInput)
    pub fn builder() -> crate::input::delete_domain_input::Builder {
        crate::input::delete_domain_input::Builder::default()
    }
    /// Creates a new `DeleteDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDomain {
    type Output =
        std::result::Result<crate::output::DeleteDomainOutput, crate::error::DeleteDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_domain_error(response)
        } else {
            crate::operation_deser::parse_delete_domain_response(response)
        }
    }
}

/// Operation shape for `DeleteIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_integration`](crate::client::Client::delete_integration).
///
/// See [`crate::client::fluent_builders::DeleteIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteIntegration {
    _private: (),
}
impl DeleteIntegration {
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationInput`](crate::input::DeleteIntegrationInput)
    pub fn builder() -> crate::input::delete_integration_input::Builder {
        crate::input::delete_integration_input::Builder::default()
    }
    /// Creates a new `DeleteIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteIntegration {
    type Output = std::result::Result<
        crate::output::DeleteIntegrationOutput,
        crate::error::DeleteIntegrationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_integration_error(response)
        } else {
            crate::operation_deser::parse_delete_integration_response(response)
        }
    }
}

/// Operation shape for `DeleteProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_profile`](crate::client::Client::delete_profile).
///
/// See [`crate::client::fluent_builders::DeleteProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProfile {
    _private: (),
}
impl DeleteProfile {
    /// Creates a new builder-style object to manufacture [`DeleteProfileInput`](crate::input::DeleteProfileInput)
    pub fn builder() -> crate::input::delete_profile_input::Builder {
        crate::input::delete_profile_input::Builder::default()
    }
    /// Creates a new `DeleteProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProfile {
    type Output =
        std::result::Result<crate::output::DeleteProfileOutput, crate::error::DeleteProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_profile_error(response)
        } else {
            crate::operation_deser::parse_delete_profile_response(response)
        }
    }
}

/// Operation shape for `DeleteProfileKey`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_profile_key`](crate::client::Client::delete_profile_key).
///
/// See [`crate::client::fluent_builders::DeleteProfileKey`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProfileKey {
    _private: (),
}
impl DeleteProfileKey {
    /// Creates a new builder-style object to manufacture [`DeleteProfileKeyInput`](crate::input::DeleteProfileKeyInput)
    pub fn builder() -> crate::input::delete_profile_key_input::Builder {
        crate::input::delete_profile_key_input::Builder::default()
    }
    /// Creates a new `DeleteProfileKey` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProfileKey {
    type Output = std::result::Result<
        crate::output::DeleteProfileKeyOutput,
        crate::error::DeleteProfileKeyError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_profile_key_error(response)
        } else {
            crate::operation_deser::parse_delete_profile_key_response(response)
        }
    }
}

/// Operation shape for `DeleteProfileObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_profile_object`](crate::client::Client::delete_profile_object).
///
/// See [`crate::client::fluent_builders::DeleteProfileObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProfileObject {
    _private: (),
}
impl DeleteProfileObject {
    /// Creates a new builder-style object to manufacture [`DeleteProfileObjectInput`](crate::input::DeleteProfileObjectInput)
    pub fn builder() -> crate::input::delete_profile_object_input::Builder {
        crate::input::delete_profile_object_input::Builder::default()
    }
    /// Creates a new `DeleteProfileObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProfileObject {
    type Output = std::result::Result<
        crate::output::DeleteProfileObjectOutput,
        crate::error::DeleteProfileObjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_profile_object_error(response)
        } else {
            crate::operation_deser::parse_delete_profile_object_response(response)
        }
    }
}

/// Operation shape for `DeleteProfileObjectType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_profile_object_type`](crate::client::Client::delete_profile_object_type).
///
/// See [`crate::client::fluent_builders::DeleteProfileObjectType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProfileObjectType {
    _private: (),
}
impl DeleteProfileObjectType {
    /// Creates a new builder-style object to manufacture [`DeleteProfileObjectTypeInput`](crate::input::DeleteProfileObjectTypeInput)
    pub fn builder() -> crate::input::delete_profile_object_type_input::Builder {
        crate::input::delete_profile_object_type_input::Builder::default()
    }
    /// Creates a new `DeleteProfileObjectType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProfileObjectType {
    type Output = std::result::Result<
        crate::output::DeleteProfileObjectTypeOutput,
        crate::error::DeleteProfileObjectTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_profile_object_type_error(response)
        } else {
            crate::operation_deser::parse_delete_profile_object_type_response(response)
        }
    }
}

/// Operation shape for `GetDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_domain`](crate::client::Client::get_domain).
///
/// See [`crate::client::fluent_builders::GetDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDomain {
    _private: (),
}
impl GetDomain {
    /// Creates a new builder-style object to manufacture [`GetDomainInput`](crate::input::GetDomainInput)
    pub fn builder() -> crate::input::get_domain_input::Builder {
        crate::input::get_domain_input::Builder::default()
    }
    /// Creates a new `GetDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDomain {
    type Output = std::result::Result<crate::output::GetDomainOutput, crate::error::GetDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_domain_error(response)
        } else {
            crate::operation_deser::parse_get_domain_response(response)
        }
    }
}

/// Operation shape for `GetIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_integration`](crate::client::Client::get_integration).
///
/// See [`crate::client::fluent_builders::GetIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetIntegration {
    _private: (),
}
impl GetIntegration {
    /// Creates a new builder-style object to manufacture [`GetIntegrationInput`](crate::input::GetIntegrationInput)
    pub fn builder() -> crate::input::get_integration_input::Builder {
        crate::input::get_integration_input::Builder::default()
    }
    /// Creates a new `GetIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetIntegration {
    type Output =
        std::result::Result<crate::output::GetIntegrationOutput, crate::error::GetIntegrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_integration_error(response)
        } else {
            crate::operation_deser::parse_get_integration_response(response)
        }
    }
}

/// Operation shape for `GetMatches`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_matches`](crate::client::Client::get_matches).
///
/// See [`crate::client::fluent_builders::GetMatches`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMatches {
    _private: (),
}
impl GetMatches {
    /// Creates a new builder-style object to manufacture [`GetMatchesInput`](crate::input::GetMatchesInput)
    pub fn builder() -> crate::input::get_matches_input::Builder {
        crate::input::get_matches_input::Builder::default()
    }
    /// Creates a new `GetMatches` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMatches {
    type Output =
        std::result::Result<crate::output::GetMatchesOutput, crate::error::GetMatchesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_matches_error(response)
        } else {
            crate::operation_deser::parse_get_matches_response(response)
        }
    }
}

/// Operation shape for `GetProfileObjectType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_profile_object_type`](crate::client::Client::get_profile_object_type).
///
/// See [`crate::client::fluent_builders::GetProfileObjectType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProfileObjectType {
    _private: (),
}
impl GetProfileObjectType {
    /// Creates a new builder-style object to manufacture [`GetProfileObjectTypeInput`](crate::input::GetProfileObjectTypeInput)
    pub fn builder() -> crate::input::get_profile_object_type_input::Builder {
        crate::input::get_profile_object_type_input::Builder::default()
    }
    /// Creates a new `GetProfileObjectType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProfileObjectType {
    type Output = std::result::Result<
        crate::output::GetProfileObjectTypeOutput,
        crate::error::GetProfileObjectTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_profile_object_type_error(response)
        } else {
            crate::operation_deser::parse_get_profile_object_type_response(response)
        }
    }
}

/// Operation shape for `GetProfileObjectTypeTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_profile_object_type_template`](crate::client::Client::get_profile_object_type_template).
///
/// See [`crate::client::fluent_builders::GetProfileObjectTypeTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProfileObjectTypeTemplate {
    _private: (),
}
impl GetProfileObjectTypeTemplate {
    /// Creates a new builder-style object to manufacture [`GetProfileObjectTypeTemplateInput`](crate::input::GetProfileObjectTypeTemplateInput)
    pub fn builder() -> crate::input::get_profile_object_type_template_input::Builder {
        crate::input::get_profile_object_type_template_input::Builder::default()
    }
    /// Creates a new `GetProfileObjectTypeTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProfileObjectTypeTemplate {
    type Output = std::result::Result<
        crate::output::GetProfileObjectTypeTemplateOutput,
        crate::error::GetProfileObjectTypeTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_profile_object_type_template_error(response)
        } else {
            crate::operation_deser::parse_get_profile_object_type_template_response(response)
        }
    }
}

/// Operation shape for `ListAccountIntegrations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_account_integrations`](crate::client::Client::list_account_integrations).
///
/// See [`crate::client::fluent_builders::ListAccountIntegrations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListAccountIntegrations {
    _private: (),
}
impl ListAccountIntegrations {
    /// Creates a new builder-style object to manufacture [`ListAccountIntegrationsInput`](crate::input::ListAccountIntegrationsInput)
    pub fn builder() -> crate::input::list_account_integrations_input::Builder {
        crate::input::list_account_integrations_input::Builder::default()
    }
    /// Creates a new `ListAccountIntegrations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListAccountIntegrations {
    type Output = std::result::Result<
        crate::output::ListAccountIntegrationsOutput,
        crate::error::ListAccountIntegrationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_account_integrations_error(response)
        } else {
            crate::operation_deser::parse_list_account_integrations_response(response)
        }
    }
}

/// Operation shape for `ListDomains`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_domains`](crate::client::Client::list_domains).
///
/// See [`crate::client::fluent_builders::ListDomains`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDomains {
    _private: (),
}
impl ListDomains {
    /// Creates a new builder-style object to manufacture [`ListDomainsInput`](crate::input::ListDomainsInput)
    pub fn builder() -> crate::input::list_domains_input::Builder {
        crate::input::list_domains_input::Builder::default()
    }
    /// Creates a new `ListDomains` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDomains {
    type Output =
        std::result::Result<crate::output::ListDomainsOutput, crate::error::ListDomainsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_domains_error(response)
        } else {
            crate::operation_deser::parse_list_domains_response(response)
        }
    }
}

/// Operation shape for `ListIntegrations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_integrations`](crate::client::Client::list_integrations).
///
/// See [`crate::client::fluent_builders::ListIntegrations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListIntegrations {
    _private: (),
}
impl ListIntegrations {
    /// Creates a new builder-style object to manufacture [`ListIntegrationsInput`](crate::input::ListIntegrationsInput)
    pub fn builder() -> crate::input::list_integrations_input::Builder {
        crate::input::list_integrations_input::Builder::default()
    }
    /// Creates a new `ListIntegrations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListIntegrations {
    type Output = std::result::Result<
        crate::output::ListIntegrationsOutput,
        crate::error::ListIntegrationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_integrations_error(response)
        } else {
            crate::operation_deser::parse_list_integrations_response(response)
        }
    }
}

/// Operation shape for `ListProfileObjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_profile_objects`](crate::client::Client::list_profile_objects).
///
/// See [`crate::client::fluent_builders::ListProfileObjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProfileObjects {
    _private: (),
}
impl ListProfileObjects {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectsInput`](crate::input::ListProfileObjectsInput)
    pub fn builder() -> crate::input::list_profile_objects_input::Builder {
        crate::input::list_profile_objects_input::Builder::default()
    }
    /// Creates a new `ListProfileObjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProfileObjects {
    type Output = std::result::Result<
        crate::output::ListProfileObjectsOutput,
        crate::error::ListProfileObjectsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_profile_objects_error(response)
        } else {
            crate::operation_deser::parse_list_profile_objects_response(response)
        }
    }
}

/// Operation shape for `ListProfileObjectTypes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_profile_object_types`](crate::client::Client::list_profile_object_types).
///
/// See [`crate::client::fluent_builders::ListProfileObjectTypes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProfileObjectTypes {
    _private: (),
}
impl ListProfileObjectTypes {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypesInput`](crate::input::ListProfileObjectTypesInput)
    pub fn builder() -> crate::input::list_profile_object_types_input::Builder {
        crate::input::list_profile_object_types_input::Builder::default()
    }
    /// Creates a new `ListProfileObjectTypes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProfileObjectTypes {
    type Output = std::result::Result<
        crate::output::ListProfileObjectTypesOutput,
        crate::error::ListProfileObjectTypesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_profile_object_types_error(response)
        } else {
            crate::operation_deser::parse_list_profile_object_types_response(response)
        }
    }
}

/// Operation shape for `ListProfileObjectTypeTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_profile_object_type_templates`](crate::client::Client::list_profile_object_type_templates).
///
/// See [`crate::client::fluent_builders::ListProfileObjectTypeTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProfileObjectTypeTemplates {
    _private: (),
}
impl ListProfileObjectTypeTemplates {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypeTemplatesInput`](crate::input::ListProfileObjectTypeTemplatesInput)
    pub fn builder() -> crate::input::list_profile_object_type_templates_input::Builder {
        crate::input::list_profile_object_type_templates_input::Builder::default()
    }
    /// Creates a new `ListProfileObjectTypeTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProfileObjectTypeTemplates {
    type Output = std::result::Result<
        crate::output::ListProfileObjectTypeTemplatesOutput,
        crate::error::ListProfileObjectTypeTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_profile_object_type_templates_error(response)
        } else {
            crate::operation_deser::parse_list_profile_object_type_templates_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `MergeProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`merge_profiles`](crate::client::Client::merge_profiles).
///
/// See [`crate::client::fluent_builders::MergeProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct MergeProfiles {
    _private: (),
}
impl MergeProfiles {
    /// Creates a new builder-style object to manufacture [`MergeProfilesInput`](crate::input::MergeProfilesInput)
    pub fn builder() -> crate::input::merge_profiles_input::Builder {
        crate::input::merge_profiles_input::Builder::default()
    }
    /// Creates a new `MergeProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for MergeProfiles {
    type Output =
        std::result::Result<crate::output::MergeProfilesOutput, crate::error::MergeProfilesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_merge_profiles_error(response)
        } else {
            crate::operation_deser::parse_merge_profiles_response(response)
        }
    }
}

/// Operation shape for `PutIntegration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_integration`](crate::client::Client::put_integration).
///
/// See [`crate::client::fluent_builders::PutIntegration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutIntegration {
    _private: (),
}
impl PutIntegration {
    /// Creates a new builder-style object to manufacture [`PutIntegrationInput`](crate::input::PutIntegrationInput)
    pub fn builder() -> crate::input::put_integration_input::Builder {
        crate::input::put_integration_input::Builder::default()
    }
    /// Creates a new `PutIntegration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutIntegration {
    type Output =
        std::result::Result<crate::output::PutIntegrationOutput, crate::error::PutIntegrationError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_integration_error(response)
        } else {
            crate::operation_deser::parse_put_integration_response(response)
        }
    }
}

/// Operation shape for `PutProfileObject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_profile_object`](crate::client::Client::put_profile_object).
///
/// See [`crate::client::fluent_builders::PutProfileObject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutProfileObject {
    _private: (),
}
impl PutProfileObject {
    /// Creates a new builder-style object to manufacture [`PutProfileObjectInput`](crate::input::PutProfileObjectInput)
    pub fn builder() -> crate::input::put_profile_object_input::Builder {
        crate::input::put_profile_object_input::Builder::default()
    }
    /// Creates a new `PutProfileObject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutProfileObject {
    type Output = std::result::Result<
        crate::output::PutProfileObjectOutput,
        crate::error::PutProfileObjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_profile_object_error(response)
        } else {
            crate::operation_deser::parse_put_profile_object_response(response)
        }
    }
}

/// Operation shape for `PutProfileObjectType`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_profile_object_type`](crate::client::Client::put_profile_object_type).
///
/// See [`crate::client::fluent_builders::PutProfileObjectType`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutProfileObjectType {
    _private: (),
}
impl PutProfileObjectType {
    /// Creates a new builder-style object to manufacture [`PutProfileObjectTypeInput`](crate::input::PutProfileObjectTypeInput)
    pub fn builder() -> crate::input::put_profile_object_type_input::Builder {
        crate::input::put_profile_object_type_input::Builder::default()
    }
    /// Creates a new `PutProfileObjectType` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutProfileObjectType {
    type Output = std::result::Result<
        crate::output::PutProfileObjectTypeOutput,
        crate::error::PutProfileObjectTypeError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_profile_object_type_error(response)
        } else {
            crate::operation_deser::parse_put_profile_object_type_response(response)
        }
    }
}

/// Operation shape for `SearchProfiles`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_profiles`](crate::client::Client::search_profiles).
///
/// See [`crate::client::fluent_builders::SearchProfiles`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchProfiles {
    _private: (),
}
impl SearchProfiles {
    /// Creates a new builder-style object to manufacture [`SearchProfilesInput`](crate::input::SearchProfilesInput)
    pub fn builder() -> crate::input::search_profiles_input::Builder {
        crate::input::search_profiles_input::Builder::default()
    }
    /// Creates a new `SearchProfiles` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchProfiles {
    type Output =
        std::result::Result<crate::output::SearchProfilesOutput, crate::error::SearchProfilesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_profiles_error(response)
        } else {
            crate::operation_deser::parse_search_profiles_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDomain`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_domain`](crate::client::Client::update_domain).
///
/// See [`crate::client::fluent_builders::UpdateDomain`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDomain {
    _private: (),
}
impl UpdateDomain {
    /// Creates a new builder-style object to manufacture [`UpdateDomainInput`](crate::input::UpdateDomainInput)
    pub fn builder() -> crate::input::update_domain_input::Builder {
        crate::input::update_domain_input::Builder::default()
    }
    /// Creates a new `UpdateDomain` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDomain {
    type Output =
        std::result::Result<crate::output::UpdateDomainOutput, crate::error::UpdateDomainError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_domain_error(response)
        } else {
            crate::operation_deser::parse_update_domain_response(response)
        }
    }
}

/// Operation shape for `UpdateProfile`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_profile`](crate::client::Client::update_profile).
///
/// See [`crate::client::fluent_builders::UpdateProfile`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateProfile {
    _private: (),
}
impl UpdateProfile {
    /// Creates a new builder-style object to manufacture [`UpdateProfileInput`](crate::input::UpdateProfileInput)
    pub fn builder() -> crate::input::update_profile_input::Builder {
        crate::input::update_profile_input::Builder::default()
    }
    /// Creates a new `UpdateProfile` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateProfile {
    type Output =
        std::result::Result<crate::output::UpdateProfileOutput, crate::error::UpdateProfileError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_profile_error(response)
        } else {
            crate::operation_deser::parse_update_profile_response(response)
        }
    }
}
