// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Updates associated with the address properties of a customer profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAddress {
    /// <p>The first line of a customer address.</p>
    pub address1: std::option::Option<std::string::String>,
    /// <p>The second line of a customer address.</p>
    pub address2: std::option::Option<std::string::String>,
    /// <p>The third line of a customer address.</p>
    pub address3: std::option::Option<std::string::String>,
    /// <p>The fourth line of a customer address.</p>
    pub address4: std::option::Option<std::string::String>,
    /// <p>The city in which a customer lives.</p>
    pub city: std::option::Option<std::string::String>,
    /// <p>The county in which a customer lives.</p>
    pub county: std::option::Option<std::string::String>,
    /// <p>The state in which a customer lives.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The province in which a customer lives.</p>
    pub province: std::option::Option<std::string::String>,
    /// <p>The country in which a customer lives.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The postal code of a customer address.</p>
    pub postal_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateAddress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAddress");
        formatter.field("address1", &self.address1);
        formatter.field("address2", &self.address2);
        formatter.field("address3", &self.address3);
        formatter.field("address4", &self.address4);
        formatter.field("city", &self.city);
        formatter.field("county", &self.county);
        formatter.field("state", &self.state);
        formatter.field("province", &self.province);
        formatter.field("country", &self.country);
        formatter.field("postal_code", &self.postal_code);
        formatter.finish()
    }
}
/// See [`UpdateAddress`](crate::model::UpdateAddress)
pub mod update_address {
    /// A builder for [`UpdateAddress`](crate::model::UpdateAddress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address1: std::option::Option<std::string::String>,
        pub(crate) address2: std::option::Option<std::string::String>,
        pub(crate) address3: std::option::Option<std::string::String>,
        pub(crate) address4: std::option::Option<std::string::String>,
        pub(crate) city: std::option::Option<std::string::String>,
        pub(crate) county: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) province: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) postal_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The first line of a customer address.</p>
        pub fn address1(mut self, input: impl Into<std::string::String>) -> Self {
            self.address1 = Some(input.into());
            self
        }
        /// <p>The first line of a customer address.</p>
        pub fn set_address1(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address1 = input;
            self
        }
        /// <p>The second line of a customer address.</p>
        pub fn address2(mut self, input: impl Into<std::string::String>) -> Self {
            self.address2 = Some(input.into());
            self
        }
        /// <p>The second line of a customer address.</p>
        pub fn set_address2(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address2 = input;
            self
        }
        /// <p>The third line of a customer address.</p>
        pub fn address3(mut self, input: impl Into<std::string::String>) -> Self {
            self.address3 = Some(input.into());
            self
        }
        /// <p>The third line of a customer address.</p>
        pub fn set_address3(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address3 = input;
            self
        }
        /// <p>The fourth line of a customer address.</p>
        pub fn address4(mut self, input: impl Into<std::string::String>) -> Self {
            self.address4 = Some(input.into());
            self
        }
        /// <p>The fourth line of a customer address.</p>
        pub fn set_address4(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address4 = input;
            self
        }
        /// <p>The city in which a customer lives.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.city = Some(input.into());
            self
        }
        /// <p>The city in which a customer lives.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city = input;
            self
        }
        /// <p>The county in which a customer lives.</p>
        pub fn county(mut self, input: impl Into<std::string::String>) -> Self {
            self.county = Some(input.into());
            self
        }
        /// <p>The county in which a customer lives.</p>
        pub fn set_county(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.county = input;
            self
        }
        /// <p>The state in which a customer lives.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state in which a customer lives.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The province in which a customer lives.</p>
        pub fn province(mut self, input: impl Into<std::string::String>) -> Self {
            self.province = Some(input.into());
            self
        }
        /// <p>The province in which a customer lives.</p>
        pub fn set_province(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.province = input;
            self
        }
        /// <p>The country in which a customer lives.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The country in which a customer lives.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The postal code of a customer address.</p>
        pub fn postal_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.postal_code = Some(input.into());
            self
        }
        /// <p>The postal code of a customer address.</p>
        pub fn set_postal_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.postal_code = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAddress`](crate::model::UpdateAddress)
        pub fn build(self) -> crate::model::UpdateAddress {
            crate::model::UpdateAddress {
                address1: self.address1,
                address2: self.address2,
                address3: self.address3,
                address4: self.address4,
                city: self.city,
                county: self.county,
                state: self.state,
                province: self.province,
                country: self.country,
                postal_code: self.postal_code,
            }
        }
    }
}
impl UpdateAddress {
    /// Creates a new builder-style object to manufacture [`UpdateAddress`](crate::model::UpdateAddress)
    pub fn builder() -> crate::model::update_address::Builder {
        crate::model::update_address::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Gender {
    #[allow(missing_docs)] // documentation missing in model
    Female,
    #[allow(missing_docs)] // documentation missing in model
    Male,
    #[allow(missing_docs)] // documentation missing in model
    Unspecified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Gender {
    fn from(s: &str) -> Self {
        match s {
            "FEMALE" => Gender::Female,
            "MALE" => Gender::Male,
            "UNSPECIFIED" => Gender::Unspecified,
            other => Gender::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Gender {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Gender::from(s))
    }
}
impl Gender {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Gender::Female => "FEMALE",
            Gender::Male => "MALE",
            Gender::Unspecified => "UNSPECIFIED",
            Gender::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FEMALE", "MALE", "UNSPECIFIED"]
    }
}
impl AsRef<str> for Gender {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PartyType {
    #[allow(missing_docs)] // documentation missing in model
    Business,
    #[allow(missing_docs)] // documentation missing in model
    Individual,
    #[allow(missing_docs)] // documentation missing in model
    Other,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PartyType {
    fn from(s: &str) -> Self {
        match s {
            "BUSINESS" => PartyType::Business,
            "INDIVIDUAL" => PartyType::Individual,
            "OTHER" => PartyType::Other,
            other => PartyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PartyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PartyType::from(s))
    }
}
impl PartyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PartyType::Business => "BUSINESS",
            PartyType::Individual => "INDIVIDUAL",
            PartyType::Other => "OTHER",
            PartyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BUSINESS", "INDIVIDUAL", "OTHER"]
    }
}
impl AsRef<str> for PartyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The flag that enables the matching process of duplicate profiles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchingResponse {
    /// <p>The flag that enables the matching process of duplicate profiles.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for MatchingResponse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchingResponse");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`MatchingResponse`](crate::model::MatchingResponse)
pub mod matching_response {
    /// A builder for [`MatchingResponse`](crate::model::MatchingResponse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The flag that enables the matching process of duplicate profiles.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>The flag that enables the matching process of duplicate profiles.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchingResponse`](crate::model::MatchingResponse)
        pub fn build(self) -> crate::model::MatchingResponse {
            crate::model::MatchingResponse {
                enabled: self.enabled,
            }
        }
    }
}
impl MatchingResponse {
    /// Creates a new builder-style object to manufacture [`MatchingResponse`](crate::model::MatchingResponse)
    pub fn builder() -> crate::model::matching_response::Builder {
        crate::model::matching_response::Builder::default()
    }
}

/// <p>The flag that enables the matching process of duplicate profiles.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchingRequest {
    /// <p>The flag that enables the matching process of duplicate profiles.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for MatchingRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchingRequest");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`MatchingRequest`](crate::model::MatchingRequest)
pub mod matching_request {
    /// A builder for [`MatchingRequest`](crate::model::MatchingRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The flag that enables the matching process of duplicate profiles.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>The flag that enables the matching process of duplicate profiles.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchingRequest`](crate::model::MatchingRequest)
        pub fn build(self) -> crate::model::MatchingRequest {
            crate::model::MatchingRequest {
                enabled: self.enabled,
            }
        }
    }
}
impl MatchingRequest {
    /// Creates a new builder-style object to manufacture [`MatchingRequest`](crate::model::MatchingRequest)
    pub fn builder() -> crate::model::matching_request::Builder {
        crate::model::matching_request::Builder::default()
    }
}

/// <p>The standard profile of a customer.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Profile {
    /// <p>The unique identifier of a customer profile.</p>
    pub profile_id: std::option::Option<std::string::String>,
    /// <p>A unique account number that you have given to the customer.</p>
    pub account_number: std::option::Option<std::string::String>,
    /// <p>Any additional information relevant to the customer’s profile.</p>
    pub additional_information: std::option::Option<std::string::String>,
    /// <p>The type of profile used to describe the customer.</p>
    pub party_type: std::option::Option<crate::model::PartyType>,
    /// <p>The name of the customer’s business.</p>
    pub business_name: std::option::Option<std::string::String>,
    /// <p>The customer’s first name.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>The customer’s middle name.</p>
    pub middle_name: std::option::Option<std::string::String>,
    /// <p>The customer’s last name.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>The customer’s birth date. </p>
    pub birth_date: std::option::Option<std::string::String>,
    /// <p>The gender with which the customer identifies. </p>
    pub gender: std::option::Option<crate::model::Gender>,
    /// <p>The customer's phone number, which has not been specified as a mobile, home, or business
    /// number.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s mobile phone number.</p>
    pub mobile_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s home phone number.</p>
    pub home_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s home phone number.</p>
    pub business_phone_number: std::option::Option<std::string::String>,
    /// <p>The customer’s email address, which has not been specified as a personal or business
    /// address. </p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>The customer’s personal email address.</p>
    pub personal_email_address: std::option::Option<std::string::String>,
    /// <p>The customer’s business email address.</p>
    pub business_email_address: std::option::Option<std::string::String>,
    /// <p>A generic address associated with the customer that is not mailing, shipping, or
    /// billing.</p>
    pub address: std::option::Option<crate::model::Address>,
    /// <p>The customer’s shipping address.</p>
    pub shipping_address: std::option::Option<crate::model::Address>,
    /// <p>The customer’s mailing address.</p>
    pub mailing_address: std::option::Option<crate::model::Address>,
    /// <p>The customer’s billing address.</p>
    pub billing_address: std::option::Option<crate::model::Address>,
    /// <p>A key value pair of attributes of a customer profile.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Profile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Profile");
        formatter.field("profile_id", &self.profile_id);
        formatter.field("account_number", &self.account_number);
        formatter.field("additional_information", &self.additional_information);
        formatter.field("party_type", &self.party_type);
        formatter.field("business_name", &self.business_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("middle_name", &self.middle_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("birth_date", &self.birth_date);
        formatter.field("gender", &self.gender);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("mobile_phone_number", &self.mobile_phone_number);
        formatter.field("home_phone_number", &self.home_phone_number);
        formatter.field("business_phone_number", &self.business_phone_number);
        formatter.field("email_address", &self.email_address);
        formatter.field("personal_email_address", &self.personal_email_address);
        formatter.field("business_email_address", &self.business_email_address);
        formatter.field("address", &self.address);
        formatter.field("shipping_address", &self.shipping_address);
        formatter.field("mailing_address", &self.mailing_address);
        formatter.field("billing_address", &self.billing_address);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`Profile`](crate::model::Profile)
pub mod profile {
    /// A builder for [`Profile`](crate::model::Profile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_id: std::option::Option<std::string::String>,
        pub(crate) account_number: std::option::Option<std::string::String>,
        pub(crate) additional_information: std::option::Option<std::string::String>,
        pub(crate) party_type: std::option::Option<crate::model::PartyType>,
        pub(crate) business_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) middle_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) birth_date: std::option::Option<std::string::String>,
        pub(crate) gender: std::option::Option<crate::model::Gender>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) mobile_phone_number: std::option::Option<std::string::String>,
        pub(crate) home_phone_number: std::option::Option<std::string::String>,
        pub(crate) business_phone_number: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) personal_email_address: std::option::Option<std::string::String>,
        pub(crate) business_email_address: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<crate::model::Address>,
        pub(crate) shipping_address: std::option::Option<crate::model::Address>,
        pub(crate) mailing_address: std::option::Option<crate::model::Address>,
        pub(crate) billing_address: std::option::Option<crate::model::Address>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique identifier of a customer profile.</p>
        pub fn profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of a customer profile.</p>
        pub fn set_profile_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.profile_id = input;
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_number = Some(input.into());
            self
        }
        /// <p>A unique account number that you have given to the customer.</p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_number = input;
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn additional_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_information = Some(input.into());
            self
        }
        /// <p>Any additional information relevant to the customer’s profile.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_information = input;
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn party_type(mut self, input: crate::model::PartyType) -> Self {
            self.party_type = Some(input);
            self
        }
        /// <p>The type of profile used to describe the customer.</p>
        pub fn set_party_type(
            mut self,
            input: std::option::Option<crate::model::PartyType>,
        ) -> Self {
            self.party_type = input;
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn business_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_name = Some(input.into());
            self
        }
        /// <p>The name of the customer’s business.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_name = input;
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>The customer’s first name.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn middle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.middle_name = Some(input.into());
            self
        }
        /// <p>The customer’s middle name.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.middle_name = input;
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>The customer’s last name.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn birth_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.birth_date = Some(input.into());
            self
        }
        /// <p>The customer’s birth date. </p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.birth_date = input;
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn gender(mut self, input: crate::model::Gender) -> Self {
            self.gender = Some(input);
            self
        }
        /// <p>The gender with which the customer identifies. </p>
        pub fn set_gender(mut self, input: std::option::Option<crate::model::Gender>) -> Self {
            self.gender = input;
            self
        }
        /// <p>The customer's phone number, which has not been specified as a mobile, home, or business
        /// number.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>The customer's phone number, which has not been specified as a mobile, home, or business
        /// number.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn mobile_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.mobile_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s mobile phone number.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_phone_number = input;
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn home_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_phone_number = input;
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn business_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_phone_number = Some(input.into());
            self
        }
        /// <p>The customer’s home phone number.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_phone_number = input;
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business
        /// address. </p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>The customer’s email address, which has not been specified as a personal or business
        /// address. </p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn personal_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.personal_email_address = Some(input.into());
            self
        }
        /// <p>The customer’s personal email address.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.personal_email_address = input;
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn business_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_email_address = Some(input.into());
            self
        }
        /// <p>The customer’s business email address.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_email_address = input;
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or
        /// billing.</p>
        pub fn address(mut self, input: crate::model::Address) -> Self {
            self.address = Some(input);
            self
        }
        /// <p>A generic address associated with the customer that is not mailing, shipping, or
        /// billing.</p>
        pub fn set_address(mut self, input: std::option::Option<crate::model::Address>) -> Self {
            self.address = input;
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn shipping_address(mut self, input: crate::model::Address) -> Self {
            self.shipping_address = Some(input);
            self
        }
        /// <p>The customer’s shipping address.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.shipping_address = input;
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn mailing_address(mut self, input: crate::model::Address) -> Self {
            self.mailing_address = Some(input);
            self
        }
        /// <p>The customer’s mailing address.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.mailing_address = input;
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn billing_address(mut self, input: crate::model::Address) -> Self {
            self.billing_address = Some(input);
            self
        }
        /// <p>The customer’s billing address.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<crate::model::Address>,
        ) -> Self {
            self.billing_address = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A key value pair of attributes of a customer profile.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`Profile`](crate::model::Profile)
        pub fn build(self) -> crate::model::Profile {
            crate::model::Profile {
                profile_id: self.profile_id,
                account_number: self.account_number,
                additional_information: self.additional_information,
                party_type: self.party_type,
                business_name: self.business_name,
                first_name: self.first_name,
                middle_name: self.middle_name,
                last_name: self.last_name,
                birth_date: self.birth_date,
                gender: self.gender,
                phone_number: self.phone_number,
                mobile_phone_number: self.mobile_phone_number,
                home_phone_number: self.home_phone_number,
                business_phone_number: self.business_phone_number,
                email_address: self.email_address,
                personal_email_address: self.personal_email_address,
                business_email_address: self.business_email_address,
                address: self.address,
                shipping_address: self.shipping_address,
                mailing_address: self.mailing_address,
                billing_address: self.billing_address,
                attributes: self.attributes,
            }
        }
    }
}
impl Profile {
    /// Creates a new builder-style object to manufacture [`Profile`](crate::model::Profile)
    pub fn builder() -> crate::model::profile::Builder {
        crate::model::profile::Builder::default()
    }
}

/// <p>A generic address associated with the customer that is not mailing, shipping, or
/// billing.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Address {
    /// <p>The first line of a customer address.</p>
    pub address1: std::option::Option<std::string::String>,
    /// <p>The second line of a customer address.</p>
    pub address2: std::option::Option<std::string::String>,
    /// <p>The third line of a customer address.</p>
    pub address3: std::option::Option<std::string::String>,
    /// <p>The fourth line of a customer address.</p>
    pub address4: std::option::Option<std::string::String>,
    /// <p>The city in which a customer lives.</p>
    pub city: std::option::Option<std::string::String>,
    /// <p>The county in which a customer lives.</p>
    pub county: std::option::Option<std::string::String>,
    /// <p>The state in which a customer lives.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The province in which a customer lives.</p>
    pub province: std::option::Option<std::string::String>,
    /// <p>The country in which a customer lives.</p>
    pub country: std::option::Option<std::string::String>,
    /// <p>The postal code of a customer address.</p>
    pub postal_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Address {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Address");
        formatter.field("address1", &self.address1);
        formatter.field("address2", &self.address2);
        formatter.field("address3", &self.address3);
        formatter.field("address4", &self.address4);
        formatter.field("city", &self.city);
        formatter.field("county", &self.county);
        formatter.field("state", &self.state);
        formatter.field("province", &self.province);
        formatter.field("country", &self.country);
        formatter.field("postal_code", &self.postal_code);
        formatter.finish()
    }
}
/// See [`Address`](crate::model::Address)
pub mod address {
    /// A builder for [`Address`](crate::model::Address)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address1: std::option::Option<std::string::String>,
        pub(crate) address2: std::option::Option<std::string::String>,
        pub(crate) address3: std::option::Option<std::string::String>,
        pub(crate) address4: std::option::Option<std::string::String>,
        pub(crate) city: std::option::Option<std::string::String>,
        pub(crate) county: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) province: std::option::Option<std::string::String>,
        pub(crate) country: std::option::Option<std::string::String>,
        pub(crate) postal_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The first line of a customer address.</p>
        pub fn address1(mut self, input: impl Into<std::string::String>) -> Self {
            self.address1 = Some(input.into());
            self
        }
        /// <p>The first line of a customer address.</p>
        pub fn set_address1(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address1 = input;
            self
        }
        /// <p>The second line of a customer address.</p>
        pub fn address2(mut self, input: impl Into<std::string::String>) -> Self {
            self.address2 = Some(input.into());
            self
        }
        /// <p>The second line of a customer address.</p>
        pub fn set_address2(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address2 = input;
            self
        }
        /// <p>The third line of a customer address.</p>
        pub fn address3(mut self, input: impl Into<std::string::String>) -> Self {
            self.address3 = Some(input.into());
            self
        }
        /// <p>The third line of a customer address.</p>
        pub fn set_address3(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address3 = input;
            self
        }
        /// <p>The fourth line of a customer address.</p>
        pub fn address4(mut self, input: impl Into<std::string::String>) -> Self {
            self.address4 = Some(input.into());
            self
        }
        /// <p>The fourth line of a customer address.</p>
        pub fn set_address4(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address4 = input;
            self
        }
        /// <p>The city in which a customer lives.</p>
        pub fn city(mut self, input: impl Into<std::string::String>) -> Self {
            self.city = Some(input.into());
            self
        }
        /// <p>The city in which a customer lives.</p>
        pub fn set_city(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.city = input;
            self
        }
        /// <p>The county in which a customer lives.</p>
        pub fn county(mut self, input: impl Into<std::string::String>) -> Self {
            self.county = Some(input.into());
            self
        }
        /// <p>The county in which a customer lives.</p>
        pub fn set_county(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.county = input;
            self
        }
        /// <p>The state in which a customer lives.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state in which a customer lives.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The province in which a customer lives.</p>
        pub fn province(mut self, input: impl Into<std::string::String>) -> Self {
            self.province = Some(input.into());
            self
        }
        /// <p>The province in which a customer lives.</p>
        pub fn set_province(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.province = input;
            self
        }
        /// <p>The country in which a customer lives.</p>
        pub fn country(mut self, input: impl Into<std::string::String>) -> Self {
            self.country = Some(input.into());
            self
        }
        /// <p>The country in which a customer lives.</p>
        pub fn set_country(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.country = input;
            self
        }
        /// <p>The postal code of a customer address.</p>
        pub fn postal_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.postal_code = Some(input.into());
            self
        }
        /// <p>The postal code of a customer address.</p>
        pub fn set_postal_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.postal_code = input;
            self
        }
        /// Consumes the builder and constructs a [`Address`](crate::model::Address)
        pub fn build(self) -> crate::model::Address {
            crate::model::Address {
                address1: self.address1,
                address2: self.address2,
                address3: self.address3,
                address4: self.address4,
                city: self.city,
                county: self.county,
                state: self.state,
                province: self.province,
                country: self.country,
                postal_code: self.postal_code,
            }
        }
    }
}
impl Address {
    /// Creates a new builder-style object to manufacture [`Address`](crate::model::Address)
    pub fn builder() -> crate::model::address::Builder {
        crate::model::address::Builder::default()
    }
}

/// <p>An object that defines the Key element of a ProfileObject. A Key is a special element
/// that can be used to search for a customer profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectTypeKey {
    /// <p>The types of keys that a ProfileObject can have. Each ProfileObject can have only 1
    /// UNIQUE key but multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an
    /// object to a PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object.
    /// If a key a is marked as SECONDARY, it will be used to search for profiles after all other
    /// PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is
    /// not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the
    /// profile does not already exist before the object is ingested, otherwise it is only used for
    /// matching objects to profiles.</p>
    pub standard_identifiers: std::option::Option<std::vec::Vec<crate::model::StandardIdentifier>>,
    /// <p>The reference for the key name of the fields map.</p>
    pub field_names: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ObjectTypeKey {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectTypeKey");
        formatter.field("standard_identifiers", &self.standard_identifiers);
        formatter.field("field_names", &self.field_names);
        formatter.finish()
    }
}
/// See [`ObjectTypeKey`](crate::model::ObjectTypeKey)
pub mod object_type_key {
    /// A builder for [`ObjectTypeKey`](crate::model::ObjectTypeKey)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) standard_identifiers:
            std::option::Option<std::vec::Vec<crate::model::StandardIdentifier>>,
        pub(crate) field_names: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `standard_identifiers`.
        ///
        /// To override the contents of this collection use [`set_standard_identifiers`](Self::set_standard_identifiers).
        ///
        /// <p>The types of keys that a ProfileObject can have. Each ProfileObject can have only 1
        /// UNIQUE key but multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an
        /// object to a PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object.
        /// If a key a is marked as SECONDARY, it will be used to search for profiles after all other
        /// PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is
        /// not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the
        /// profile does not already exist before the object is ingested, otherwise it is only used for
        /// matching objects to profiles.</p>
        pub fn standard_identifiers(
            mut self,
            input: impl Into<crate::model::StandardIdentifier>,
        ) -> Self {
            let mut v = self.standard_identifiers.unwrap_or_default();
            v.push(input.into());
            self.standard_identifiers = Some(v);
            self
        }
        /// <p>The types of keys that a ProfileObject can have. Each ProfileObject can have only 1
        /// UNIQUE key but multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an
        /// object to a PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object.
        /// If a key a is marked as SECONDARY, it will be used to search for profiles after all other
        /// PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is
        /// not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the
        /// profile does not already exist before the object is ingested, otherwise it is only used for
        /// matching objects to profiles.</p>
        pub fn set_standard_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::StandardIdentifier>>,
        ) -> Self {
            self.standard_identifiers = input;
            self
        }
        /// Appends an item to `field_names`.
        ///
        /// To override the contents of this collection use [`set_field_names`](Self::set_field_names).
        ///
        /// <p>The reference for the key name of the fields map.</p>
        pub fn field_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.field_names.unwrap_or_default();
            v.push(input.into());
            self.field_names = Some(v);
            self
        }
        /// <p>The reference for the key name of the fields map.</p>
        pub fn set_field_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.field_names = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectTypeKey`](crate::model::ObjectTypeKey)
        pub fn build(self) -> crate::model::ObjectTypeKey {
            crate::model::ObjectTypeKey {
                standard_identifiers: self.standard_identifiers,
                field_names: self.field_names,
            }
        }
    }
}
impl ObjectTypeKey {
    /// Creates a new builder-style object to manufacture [`ObjectTypeKey`](crate::model::ObjectTypeKey)
    pub fn builder() -> crate::model::object_type_key::Builder {
        crate::model::object_type_key::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StandardIdentifier {
    #[allow(missing_docs)] // documentation missing in model
    Asset,
    #[allow(missing_docs)] // documentation missing in model
    Case,
    #[allow(missing_docs)] // documentation missing in model
    LookupOnly,
    #[allow(missing_docs)] // documentation missing in model
    NewOnly,
    #[allow(missing_docs)] // documentation missing in model
    Profile,
    #[allow(missing_docs)] // documentation missing in model
    Secondary,
    #[allow(missing_docs)] // documentation missing in model
    Unique,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StandardIdentifier {
    fn from(s: &str) -> Self {
        match s {
            "ASSET" => StandardIdentifier::Asset,
            "CASE" => StandardIdentifier::Case,
            "LOOKUP_ONLY" => StandardIdentifier::LookupOnly,
            "NEW_ONLY" => StandardIdentifier::NewOnly,
            "PROFILE" => StandardIdentifier::Profile,
            "SECONDARY" => StandardIdentifier::Secondary,
            "UNIQUE" => StandardIdentifier::Unique,
            other => StandardIdentifier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StandardIdentifier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StandardIdentifier::from(s))
    }
}
impl StandardIdentifier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StandardIdentifier::Asset => "ASSET",
            StandardIdentifier::Case => "CASE",
            StandardIdentifier::LookupOnly => "LOOKUP_ONLY",
            StandardIdentifier::NewOnly => "NEW_ONLY",
            StandardIdentifier::Profile => "PROFILE",
            StandardIdentifier::Secondary => "SECONDARY",
            StandardIdentifier::Unique => "UNIQUE",
            StandardIdentifier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ASSET",
            "CASE",
            "LOOKUP_ONLY",
            "NEW_ONLY",
            "PROFILE",
            "SECONDARY",
            "UNIQUE",
        ]
    }
}
impl AsRef<str> for StandardIdentifier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Represents a field in a ProfileObjectType.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectTypeField {
    /// <p>A field of a ProfileObject. For example: _source.FirstName, where “_source” is a
    /// ProfileObjectType of a Zendesk user and “FirstName” is a field in that ObjectType.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The location of the data in the standard ProfileObject model. For example:
    /// _profile.Address.PostalCode.</p>
    pub target: std::option::Option<std::string::String>,
    /// <p>The content type of the field. Used for determining equality when searching.</p>
    pub content_type: std::option::Option<crate::model::FieldContentType>,
}
impl std::fmt::Debug for ObjectTypeField {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectTypeField");
        formatter.field("source", &self.source);
        formatter.field("target", &self.target);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}
/// See [`ObjectTypeField`](crate::model::ObjectTypeField)
pub mod object_type_field {
    /// A builder for [`ObjectTypeField`](crate::model::ObjectTypeField)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) target: std::option::Option<std::string::String>,
        pub(crate) content_type: std::option::Option<crate::model::FieldContentType>,
    }
    impl Builder {
        /// <p>A field of a ProfileObject. For example: _source.FirstName, where “_source” is a
        /// ProfileObjectType of a Zendesk user and “FirstName” is a field in that ObjectType.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>A field of a ProfileObject. For example: _source.FirstName, where “_source” is a
        /// ProfileObjectType of a Zendesk user and “FirstName” is a field in that ObjectType.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The location of the data in the standard ProfileObject model. For example:
        /// _profile.Address.PostalCode.</p>
        pub fn target(mut self, input: impl Into<std::string::String>) -> Self {
            self.target = Some(input.into());
            self
        }
        /// <p>The location of the data in the standard ProfileObject model. For example:
        /// _profile.Address.PostalCode.</p>
        pub fn set_target(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target = input;
            self
        }
        /// <p>The content type of the field. Used for determining equality when searching.</p>
        pub fn content_type(mut self, input: crate::model::FieldContentType) -> Self {
            self.content_type = Some(input);
            self
        }
        /// <p>The content type of the field. Used for determining equality when searching.</p>
        pub fn set_content_type(
            mut self,
            input: std::option::Option<crate::model::FieldContentType>,
        ) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectTypeField`](crate::model::ObjectTypeField)
        pub fn build(self) -> crate::model::ObjectTypeField {
            crate::model::ObjectTypeField {
                source: self.source,
                target: self.target,
                content_type: self.content_type,
            }
        }
    }
}
impl ObjectTypeField {
    /// Creates a new builder-style object to manufacture [`ObjectTypeField`](crate::model::ObjectTypeField)
    pub fn builder() -> crate::model::object_type_field::Builder {
        crate::model::object_type_field::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FieldContentType {
    #[allow(missing_docs)] // documentation missing in model
    EmailAddress,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    #[allow(missing_docs)] // documentation missing in model
    Number,
    #[allow(missing_docs)] // documentation missing in model
    PhoneNumber,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FieldContentType {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL_ADDRESS" => FieldContentType::EmailAddress,
            "NAME" => FieldContentType::Name,
            "NUMBER" => FieldContentType::Number,
            "PHONE_NUMBER" => FieldContentType::PhoneNumber,
            "STRING" => FieldContentType::String,
            other => FieldContentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FieldContentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FieldContentType::from(s))
    }
}
impl FieldContentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FieldContentType::EmailAddress => "EMAIL_ADDRESS",
            FieldContentType::Name => "NAME",
            FieldContentType::Number => "NUMBER",
            FieldContentType::PhoneNumber => "PHONE_NUMBER",
            FieldContentType::String => "STRING",
            FieldContentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMAIL_ADDRESS", "NAME", "NUMBER", "PHONE_NUMBER", "STRING"]
    }
}
impl AsRef<str> for FieldContentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The configurations that control how Customer Profiles retrieves data from the source,
/// Amazon AppFlow. Customer Profiles uses this information to create an AppFlow flow on behalf of
/// customers.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FlowDefinition {
    /// <p>A description of the flow you want to create.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not
    /// allowed.</p>
    pub flow_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.</p>
    pub kms_arn: std::option::Option<std::string::String>,
    /// <p>The configuration that controls how Customer Profiles retrieves data from the
    /// source.</p>
    pub source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
    /// <p>A list of tasks that Customer Profiles performs while transferring the data in the flow
    /// run.</p>
    pub tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
    /// <p>The trigger settings that determine how and when the flow runs.</p>
    pub trigger_config: std::option::Option<crate::model::TriggerConfig>,
}
impl std::fmt::Debug for FlowDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FlowDefinition");
        formatter.field("description", &self.description);
        formatter.field("flow_name", &self.flow_name);
        formatter.field("kms_arn", &self.kms_arn);
        formatter.field("source_flow_config", &self.source_flow_config);
        formatter.field("tasks", &self.tasks);
        formatter.field("trigger_config", &self.trigger_config);
        formatter.finish()
    }
}
/// See [`FlowDefinition`](crate::model::FlowDefinition)
pub mod flow_definition {
    /// A builder for [`FlowDefinition`](crate::model::FlowDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) flow_name: std::option::Option<std::string::String>,
        pub(crate) kms_arn: std::option::Option<std::string::String>,
        pub(crate) source_flow_config: std::option::Option<crate::model::SourceFlowConfig>,
        pub(crate) tasks: std::option::Option<std::vec::Vec<crate::model::Task>>,
        pub(crate) trigger_config: std::option::Option<crate::model::TriggerConfig>,
    }
    impl Builder {
        /// <p>A description of the flow you want to create.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the flow you want to create.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not
        /// allowed.</p>
        pub fn flow_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_name = Some(input.into());
            self
        }
        /// <p>The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not
        /// allowed.</p>
        pub fn set_flow_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_name = input;
            self
        }
        /// <p>The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.</p>
        pub fn kms_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.</p>
        pub fn set_kms_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_arn = input;
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the
        /// source.</p>
        pub fn source_flow_config(mut self, input: crate::model::SourceFlowConfig) -> Self {
            self.source_flow_config = Some(input);
            self
        }
        /// <p>The configuration that controls how Customer Profiles retrieves data from the
        /// source.</p>
        pub fn set_source_flow_config(
            mut self,
            input: std::option::Option<crate::model::SourceFlowConfig>,
        ) -> Self {
            self.source_flow_config = input;
            self
        }
        /// Appends an item to `tasks`.
        ///
        /// To override the contents of this collection use [`set_tasks`](Self::set_tasks).
        ///
        /// <p>A list of tasks that Customer Profiles performs while transferring the data in the flow
        /// run.</p>
        pub fn tasks(mut self, input: impl Into<crate::model::Task>) -> Self {
            let mut v = self.tasks.unwrap_or_default();
            v.push(input.into());
            self.tasks = Some(v);
            self
        }
        /// <p>A list of tasks that Customer Profiles performs while transferring the data in the flow
        /// run.</p>
        pub fn set_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Task>>,
        ) -> Self {
            self.tasks = input;
            self
        }
        /// <p>The trigger settings that determine how and when the flow runs.</p>
        pub fn trigger_config(mut self, input: crate::model::TriggerConfig) -> Self {
            self.trigger_config = Some(input);
            self
        }
        /// <p>The trigger settings that determine how and when the flow runs.</p>
        pub fn set_trigger_config(
            mut self,
            input: std::option::Option<crate::model::TriggerConfig>,
        ) -> Self {
            self.trigger_config = input;
            self
        }
        /// Consumes the builder and constructs a [`FlowDefinition`](crate::model::FlowDefinition)
        pub fn build(self) -> crate::model::FlowDefinition {
            crate::model::FlowDefinition {
                description: self.description,
                flow_name: self.flow_name,
                kms_arn: self.kms_arn,
                source_flow_config: self.source_flow_config,
                tasks: self.tasks,
                trigger_config: self.trigger_config,
            }
        }
    }
}
impl FlowDefinition {
    /// Creates a new builder-style object to manufacture [`FlowDefinition`](crate::model::FlowDefinition)
    pub fn builder() -> crate::model::flow_definition::Builder {
        crate::model::flow_definition::Builder::default()
    }
}

/// <p>The trigger settings that determine how and when Amazon AppFlow runs the specified
/// flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerConfig {
    /// <p>Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.</p>
    pub trigger_type: std::option::Option<crate::model::TriggerType>,
    /// <p>Specifies the configuration details of a schedule-triggered flow that you define.
    /// Currently, these settings only apply to the Scheduled trigger type.</p>
    pub trigger_properties: std::option::Option<crate::model::TriggerProperties>,
}
impl std::fmt::Debug for TriggerConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerConfig");
        formatter.field("trigger_type", &self.trigger_type);
        formatter.field("trigger_properties", &self.trigger_properties);
        formatter.finish()
    }
}
/// See [`TriggerConfig`](crate::model::TriggerConfig)
pub mod trigger_config {
    /// A builder for [`TriggerConfig`](crate::model::TriggerConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) trigger_type: std::option::Option<crate::model::TriggerType>,
        pub(crate) trigger_properties: std::option::Option<crate::model::TriggerProperties>,
    }
    impl Builder {
        /// <p>Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.</p>
        pub fn trigger_type(mut self, input: crate::model::TriggerType) -> Self {
            self.trigger_type = Some(input);
            self
        }
        /// <p>Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.</p>
        pub fn set_trigger_type(
            mut self,
            input: std::option::Option<crate::model::TriggerType>,
        ) -> Self {
            self.trigger_type = input;
            self
        }
        /// <p>Specifies the configuration details of a schedule-triggered flow that you define.
        /// Currently, these settings only apply to the Scheduled trigger type.</p>
        pub fn trigger_properties(mut self, input: crate::model::TriggerProperties) -> Self {
            self.trigger_properties = Some(input);
            self
        }
        /// <p>Specifies the configuration details of a schedule-triggered flow that you define.
        /// Currently, these settings only apply to the Scheduled trigger type.</p>
        pub fn set_trigger_properties(
            mut self,
            input: std::option::Option<crate::model::TriggerProperties>,
        ) -> Self {
            self.trigger_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerConfig`](crate::model::TriggerConfig)
        pub fn build(self) -> crate::model::TriggerConfig {
            crate::model::TriggerConfig {
                trigger_type: self.trigger_type,
                trigger_properties: self.trigger_properties,
            }
        }
    }
}
impl TriggerConfig {
    /// Creates a new builder-style object to manufacture [`TriggerConfig`](crate::model::TriggerConfig)
    pub fn builder() -> crate::model::trigger_config::Builder {
        crate::model::trigger_config::Builder::default()
    }
}

/// <p>Specifies the configuration details that control the trigger for a flow. Currently,
/// these settings only apply to the Scheduled trigger type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TriggerProperties {
    /// <p>Specifies the configuration details of a schedule-triggered flow that you define.</p>
    pub scheduled: std::option::Option<crate::model::ScheduledTriggerProperties>,
}
impl std::fmt::Debug for TriggerProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TriggerProperties");
        formatter.field("scheduled", &self.scheduled);
        formatter.finish()
    }
}
/// See [`TriggerProperties`](crate::model::TriggerProperties)
pub mod trigger_properties {
    /// A builder for [`TriggerProperties`](crate::model::TriggerProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled: std::option::Option<crate::model::ScheduledTriggerProperties>,
    }
    impl Builder {
        /// <p>Specifies the configuration details of a schedule-triggered flow that you define.</p>
        pub fn scheduled(mut self, input: crate::model::ScheduledTriggerProperties) -> Self {
            self.scheduled = Some(input);
            self
        }
        /// <p>Specifies the configuration details of a schedule-triggered flow that you define.</p>
        pub fn set_scheduled(
            mut self,
            input: std::option::Option<crate::model::ScheduledTriggerProperties>,
        ) -> Self {
            self.scheduled = input;
            self
        }
        /// Consumes the builder and constructs a [`TriggerProperties`](crate::model::TriggerProperties)
        pub fn build(self) -> crate::model::TriggerProperties {
            crate::model::TriggerProperties {
                scheduled: self.scheduled,
            }
        }
    }
}
impl TriggerProperties {
    /// Creates a new builder-style object to manufacture [`TriggerProperties`](crate::model::TriggerProperties)
    pub fn builder() -> crate::model::trigger_properties::Builder {
        crate::model::trigger_properties::Builder::default()
    }
}

/// <p>Specifies the configuration details of a scheduled-trigger flow that you define.
/// Currently, these settings only apply to the scheduled-trigger type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledTriggerProperties {
    /// <p>The scheduling expression that determines the rate at which the schedule will run, for
    /// example rate (5 minutes).</p>
    pub schedule_expression: std::option::Option<std::string::String>,
    /// <p>Specifies whether a scheduled flow has an incremental data transfer or a complete data
    /// transfer for each flow run.</p>
    pub data_pull_mode: std::option::Option<crate::model::DataPullMode>,
    /// <p>Specifies the scheduled start time for a scheduled-trigger flow.</p>
    pub schedule_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the scheduled end time for a scheduled-trigger flow.</p>
    pub schedule_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Specifies the time zone used when referring to the date and time of a
    /// scheduled-triggered flow, such as America/New_York.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>Specifies the optional offset that is added to the time interval for a
    /// schedule-triggered flow.</p>
    pub schedule_offset: std::option::Option<i64>,
    /// <p>Specifies the date range for the records to import from the connector in the first flow
    /// run.</p>
    pub first_execution_from: std::option::Option<aws_smithy_types::Instant>,
}
impl std::fmt::Debug for ScheduledTriggerProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledTriggerProperties");
        formatter.field("schedule_expression", &self.schedule_expression);
        formatter.field("data_pull_mode", &self.data_pull_mode);
        formatter.field("schedule_start_time", &self.schedule_start_time);
        formatter.field("schedule_end_time", &self.schedule_end_time);
        formatter.field("timezone", &self.timezone);
        formatter.field("schedule_offset", &self.schedule_offset);
        formatter.field("first_execution_from", &self.first_execution_from);
        formatter.finish()
    }
}
/// See [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
pub mod scheduled_trigger_properties {
    /// A builder for [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_expression: std::option::Option<std::string::String>,
        pub(crate) data_pull_mode: std::option::Option<crate::model::DataPullMode>,
        pub(crate) schedule_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) schedule_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) schedule_offset: std::option::Option<i64>,
        pub(crate) first_execution_from: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The scheduling expression that determines the rate at which the schedule will run, for
        /// example rate (5 minutes).</p>
        pub fn schedule_expression(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_expression = Some(input.into());
            self
        }
        /// <p>The scheduling expression that determines the rate at which the schedule will run, for
        /// example rate (5 minutes).</p>
        pub fn set_schedule_expression(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_expression = input;
            self
        }
        /// <p>Specifies whether a scheduled flow has an incremental data transfer or a complete data
        /// transfer for each flow run.</p>
        pub fn data_pull_mode(mut self, input: crate::model::DataPullMode) -> Self {
            self.data_pull_mode = Some(input);
            self
        }
        /// <p>Specifies whether a scheduled flow has an incremental data transfer or a complete data
        /// transfer for each flow run.</p>
        pub fn set_data_pull_mode(
            mut self,
            input: std::option::Option<crate::model::DataPullMode>,
        ) -> Self {
            self.data_pull_mode = input;
            self
        }
        /// <p>Specifies the scheduled start time for a scheduled-trigger flow.</p>
        pub fn schedule_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.schedule_start_time = Some(input);
            self
        }
        /// <p>Specifies the scheduled start time for a scheduled-trigger flow.</p>
        pub fn set_schedule_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.schedule_start_time = input;
            self
        }
        /// <p>Specifies the scheduled end time for a scheduled-trigger flow.</p>
        pub fn schedule_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.schedule_end_time = Some(input);
            self
        }
        /// <p>Specifies the scheduled end time for a scheduled-trigger flow.</p>
        pub fn set_schedule_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.schedule_end_time = input;
            self
        }
        /// <p>Specifies the time zone used when referring to the date and time of a
        /// scheduled-triggered flow, such as America/New_York.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>Specifies the time zone used when referring to the date and time of a
        /// scheduled-triggered flow, such as America/New_York.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>Specifies the optional offset that is added to the time interval for a
        /// schedule-triggered flow.</p>
        pub fn schedule_offset(mut self, input: i64) -> Self {
            self.schedule_offset = Some(input);
            self
        }
        /// <p>Specifies the optional offset that is added to the time interval for a
        /// schedule-triggered flow.</p>
        pub fn set_schedule_offset(mut self, input: std::option::Option<i64>) -> Self {
            self.schedule_offset = input;
            self
        }
        /// <p>Specifies the date range for the records to import from the connector in the first flow
        /// run.</p>
        pub fn first_execution_from(mut self, input: aws_smithy_types::Instant) -> Self {
            self.first_execution_from = Some(input);
            self
        }
        /// <p>Specifies the date range for the records to import from the connector in the first flow
        /// run.</p>
        pub fn set_first_execution_from(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.first_execution_from = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
        pub fn build(self) -> crate::model::ScheduledTriggerProperties {
            crate::model::ScheduledTriggerProperties {
                schedule_expression: self.schedule_expression,
                data_pull_mode: self.data_pull_mode,
                schedule_start_time: self.schedule_start_time,
                schedule_end_time: self.schedule_end_time,
                timezone: self.timezone,
                schedule_offset: self.schedule_offset,
                first_execution_from: self.first_execution_from,
            }
        }
    }
}
impl ScheduledTriggerProperties {
    /// Creates a new builder-style object to manufacture [`ScheduledTriggerProperties`](crate::model::ScheduledTriggerProperties)
    pub fn builder() -> crate::model::scheduled_trigger_properties::Builder {
        crate::model::scheduled_trigger_properties::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataPullMode {
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Incremental,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataPullMode {
    fn from(s: &str) -> Self {
        match s {
            "Complete" => DataPullMode::Complete,
            "Incremental" => DataPullMode::Incremental,
            other => DataPullMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataPullMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataPullMode::from(s))
    }
}
impl DataPullMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataPullMode::Complete => "Complete",
            DataPullMode::Incremental => "Incremental",
            DataPullMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Complete", "Incremental"]
    }
}
impl AsRef<str> for DataPullMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TriggerType {
    #[allow(missing_docs)] // documentation missing in model
    Event,
    #[allow(missing_docs)] // documentation missing in model
    Ondemand,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TriggerType {
    fn from(s: &str) -> Self {
        match s {
            "Event" => TriggerType::Event,
            "OnDemand" => TriggerType::Ondemand,
            "Scheduled" => TriggerType::Scheduled,
            other => TriggerType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TriggerType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TriggerType::from(s))
    }
}
impl TriggerType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TriggerType::Event => "Event",
            TriggerType::Ondemand => "OnDemand",
            TriggerType::Scheduled => "Scheduled",
            TriggerType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Event", "OnDemand", "Scheduled"]
    }
}
impl AsRef<str> for TriggerType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A class for modeling different type of tasks. Task implementation varies based on the
/// TaskType.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Task {
    /// <p>The operation to be performed on the provided source fields.</p>
    pub connector_operator: std::option::Option<crate::model::ConnectorOperator>,
    /// <p>A field in a destination connector, or a field value against which Amazon AppFlow validates a
    /// source field.</p>
    pub destination_field: std::option::Option<std::string::String>,
    /// <p>The source fields to which a particular task is applied.</p>
    pub source_fields: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A map used to store task-related information. The service looks for particular
    /// information based on the TaskType.</p>
    pub task_properties: std::option::Option<
        std::collections::HashMap<crate::model::OperatorPropertiesKeys, std::string::String>,
    >,
    /// <p>Specifies the particular task implementation that Amazon AppFlow performs.</p>
    pub task_type: std::option::Option<crate::model::TaskType>,
}
impl std::fmt::Debug for Task {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Task");
        formatter.field("connector_operator", &self.connector_operator);
        formatter.field("destination_field", &self.destination_field);
        formatter.field("source_fields", &self.source_fields);
        formatter.field("task_properties", &self.task_properties);
        formatter.field("task_type", &self.task_type);
        formatter.finish()
    }
}
/// See [`Task`](crate::model::Task)
pub mod task {
    /// A builder for [`Task`](crate::model::Task)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_operator: std::option::Option<crate::model::ConnectorOperator>,
        pub(crate) destination_field: std::option::Option<std::string::String>,
        pub(crate) source_fields: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) task_properties: std::option::Option<
            std::collections::HashMap<crate::model::OperatorPropertiesKeys, std::string::String>,
        >,
        pub(crate) task_type: std::option::Option<crate::model::TaskType>,
    }
    impl Builder {
        /// <p>The operation to be performed on the provided source fields.</p>
        pub fn connector_operator(mut self, input: crate::model::ConnectorOperator) -> Self {
            self.connector_operator = Some(input);
            self
        }
        /// <p>The operation to be performed on the provided source fields.</p>
        pub fn set_connector_operator(
            mut self,
            input: std::option::Option<crate::model::ConnectorOperator>,
        ) -> Self {
            self.connector_operator = input;
            self
        }
        /// <p>A field in a destination connector, or a field value against which Amazon AppFlow validates a
        /// source field.</p>
        pub fn destination_field(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_field = Some(input.into());
            self
        }
        /// <p>A field in a destination connector, or a field value against which Amazon AppFlow validates a
        /// source field.</p>
        pub fn set_destination_field(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_field = input;
            self
        }
        /// Appends an item to `source_fields`.
        ///
        /// To override the contents of this collection use [`set_source_fields`](Self::set_source_fields).
        ///
        /// <p>The source fields to which a particular task is applied.</p>
        pub fn source_fields(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_fields.unwrap_or_default();
            v.push(input.into());
            self.source_fields = Some(v);
            self
        }
        /// <p>The source fields to which a particular task is applied.</p>
        pub fn set_source_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_fields = input;
            self
        }
        /// Adds a key-value pair to `task_properties`.
        ///
        /// To override the contents of this collection use [`set_task_properties`](Self::set_task_properties).
        ///
        /// <p>A map used to store task-related information. The service looks for particular
        /// information based on the TaskType.</p>
        pub fn task_properties(
            mut self,
            k: impl Into<crate::model::OperatorPropertiesKeys>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.task_properties.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.task_properties = Some(hash_map);
            self
        }
        /// <p>A map used to store task-related information. The service looks for particular
        /// information based on the TaskType.</p>
        pub fn set_task_properties(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    crate::model::OperatorPropertiesKeys,
                    std::string::String,
                >,
            >,
        ) -> Self {
            self.task_properties = input;
            self
        }
        /// <p>Specifies the particular task implementation that Amazon AppFlow performs.</p>
        pub fn task_type(mut self, input: crate::model::TaskType) -> Self {
            self.task_type = Some(input);
            self
        }
        /// <p>Specifies the particular task implementation that Amazon AppFlow performs.</p>
        pub fn set_task_type(mut self, input: std::option::Option<crate::model::TaskType>) -> Self {
            self.task_type = input;
            self
        }
        /// Consumes the builder and constructs a [`Task`](crate::model::Task)
        pub fn build(self) -> crate::model::Task {
            crate::model::Task {
                connector_operator: self.connector_operator,
                destination_field: self.destination_field,
                source_fields: self.source_fields,
                task_properties: self.task_properties,
                task_type: self.task_type,
            }
        }
    }
}
impl Task {
    /// Creates a new builder-style object to manufacture [`Task`](crate::model::Task)
    pub fn builder() -> crate::model::task::Builder {
        crate::model::task::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TaskType {
    #[allow(missing_docs)] // documentation missing in model
    Arithmetic,
    #[allow(missing_docs)] // documentation missing in model
    Filter,
    #[allow(missing_docs)] // documentation missing in model
    Map,
    #[allow(missing_docs)] // documentation missing in model
    Mask,
    #[allow(missing_docs)] // documentation missing in model
    Merge,
    #[allow(missing_docs)] // documentation missing in model
    Truncate,
    #[allow(missing_docs)] // documentation missing in model
    Validate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TaskType {
    fn from(s: &str) -> Self {
        match s {
            "Arithmetic" => TaskType::Arithmetic,
            "Filter" => TaskType::Filter,
            "Map" => TaskType::Map,
            "Mask" => TaskType::Mask,
            "Merge" => TaskType::Merge,
            "Truncate" => TaskType::Truncate,
            "Validate" => TaskType::Validate,
            other => TaskType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TaskType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TaskType::from(s))
    }
}
impl TaskType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TaskType::Arithmetic => "Arithmetic",
            TaskType::Filter => "Filter",
            TaskType::Map => "Map",
            TaskType::Mask => "Mask",
            TaskType::Merge => "Merge",
            TaskType::Truncate => "Truncate",
            TaskType::Validate => "Validate",
            TaskType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Arithmetic",
            "Filter",
            "Map",
            "Mask",
            "Merge",
            "Truncate",
            "Validate",
        ]
    }
}
impl AsRef<str> for TaskType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperatorPropertiesKeys {
    #[allow(missing_docs)] // documentation missing in model
    ConcatFormat,
    #[allow(missing_docs)] // documentation missing in model
    DataType,
    #[allow(missing_docs)] // documentation missing in model
    DestinationDataType,
    #[allow(missing_docs)] // documentation missing in model
    LowerBound,
    #[allow(missing_docs)] // documentation missing in model
    MaskLength,
    #[allow(missing_docs)] // documentation missing in model
    MaskValue,
    #[allow(missing_docs)] // documentation missing in model
    MathOperationFieldsOrder,
    #[allow(missing_docs)] // documentation missing in model
    SourceDataType,
    #[allow(missing_docs)] // documentation missing in model
    SubfieldCategoryMap,
    #[allow(missing_docs)] // documentation missing in model
    TruncateLength,
    #[allow(missing_docs)] // documentation missing in model
    UpperBound,
    #[allow(missing_docs)] // documentation missing in model
    ValidationAction,
    #[allow(missing_docs)] // documentation missing in model
    Value,
    #[allow(missing_docs)] // documentation missing in model
    Values,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperatorPropertiesKeys {
    fn from(s: &str) -> Self {
        match s {
            "CONCAT_FORMAT" => OperatorPropertiesKeys::ConcatFormat,
            "DATA_TYPE" => OperatorPropertiesKeys::DataType,
            "DESTINATION_DATA_TYPE" => OperatorPropertiesKeys::DestinationDataType,
            "LOWER_BOUND" => OperatorPropertiesKeys::LowerBound,
            "MASK_LENGTH" => OperatorPropertiesKeys::MaskLength,
            "MASK_VALUE" => OperatorPropertiesKeys::MaskValue,
            "MATH_OPERATION_FIELDS_ORDER" => OperatorPropertiesKeys::MathOperationFieldsOrder,
            "SOURCE_DATA_TYPE" => OperatorPropertiesKeys::SourceDataType,
            "SUBFIELD_CATEGORY_MAP" => OperatorPropertiesKeys::SubfieldCategoryMap,
            "TRUNCATE_LENGTH" => OperatorPropertiesKeys::TruncateLength,
            "UPPER_BOUND" => OperatorPropertiesKeys::UpperBound,
            "VALIDATION_ACTION" => OperatorPropertiesKeys::ValidationAction,
            "VALUE" => OperatorPropertiesKeys::Value,
            "VALUES" => OperatorPropertiesKeys::Values,
            other => OperatorPropertiesKeys::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperatorPropertiesKeys {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperatorPropertiesKeys::from(s))
    }
}
impl OperatorPropertiesKeys {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperatorPropertiesKeys::ConcatFormat => "CONCAT_FORMAT",
            OperatorPropertiesKeys::DataType => "DATA_TYPE",
            OperatorPropertiesKeys::DestinationDataType => "DESTINATION_DATA_TYPE",
            OperatorPropertiesKeys::LowerBound => "LOWER_BOUND",
            OperatorPropertiesKeys::MaskLength => "MASK_LENGTH",
            OperatorPropertiesKeys::MaskValue => "MASK_VALUE",
            OperatorPropertiesKeys::MathOperationFieldsOrder => "MATH_OPERATION_FIELDS_ORDER",
            OperatorPropertiesKeys::SourceDataType => "SOURCE_DATA_TYPE",
            OperatorPropertiesKeys::SubfieldCategoryMap => "SUBFIELD_CATEGORY_MAP",
            OperatorPropertiesKeys::TruncateLength => "TRUNCATE_LENGTH",
            OperatorPropertiesKeys::UpperBound => "UPPER_BOUND",
            OperatorPropertiesKeys::ValidationAction => "VALIDATION_ACTION",
            OperatorPropertiesKeys::Value => "VALUE",
            OperatorPropertiesKeys::Values => "VALUES",
            OperatorPropertiesKeys::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONCAT_FORMAT",
            "DATA_TYPE",
            "DESTINATION_DATA_TYPE",
            "LOWER_BOUND",
            "MASK_LENGTH",
            "MASK_VALUE",
            "MATH_OPERATION_FIELDS_ORDER",
            "SOURCE_DATA_TYPE",
            "SUBFIELD_CATEGORY_MAP",
            "TRUNCATE_LENGTH",
            "UPPER_BOUND",
            "VALIDATION_ACTION",
            "VALUE",
            "VALUES",
        ]
    }
}
impl AsRef<str> for OperatorPropertiesKeys {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The operation to be performed on the provided source fields.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectorOperator {
    /// <p>The operation to be performed on the provided Marketo source fields.</p>
    pub marketo: std::option::Option<crate::model::MarketoConnectorOperator>,
    /// <p>The operation to be performed on the provided Amazon S3 source fields.</p>
    pub s3: std::option::Option<crate::model::S3ConnectorOperator>,
    /// <p>The operation to be performed on the provided Salesforce source fields.</p>
    pub salesforce: std::option::Option<crate::model::SalesforceConnectorOperator>,
    /// <p>The operation to be performed on the provided ServiceNow source fields.</p>
    pub service_now: std::option::Option<crate::model::ServiceNowConnectorOperator>,
    /// <p>The operation to be performed on the provided Zendesk source fields.</p>
    pub zendesk: std::option::Option<crate::model::ZendeskConnectorOperator>,
}
impl std::fmt::Debug for ConnectorOperator {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectorOperator");
        formatter.field("marketo", &self.marketo);
        formatter.field("s3", &self.s3);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("service_now", &self.service_now);
        formatter.field("zendesk", &self.zendesk);
        formatter.finish()
    }
}
/// See [`ConnectorOperator`](crate::model::ConnectorOperator)
pub mod connector_operator {
    /// A builder for [`ConnectorOperator`](crate::model::ConnectorOperator)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marketo: std::option::Option<crate::model::MarketoConnectorOperator>,
        pub(crate) s3: std::option::Option<crate::model::S3ConnectorOperator>,
        pub(crate) salesforce: std::option::Option<crate::model::SalesforceConnectorOperator>,
        pub(crate) service_now: std::option::Option<crate::model::ServiceNowConnectorOperator>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskConnectorOperator>,
    }
    impl Builder {
        /// <p>The operation to be performed on the provided Marketo source fields.</p>
        pub fn marketo(mut self, input: crate::model::MarketoConnectorOperator) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p>The operation to be performed on the provided Marketo source fields.</p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoConnectorOperator>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p>The operation to be performed on the provided Amazon S3 source fields.</p>
        pub fn s3(mut self, input: crate::model::S3ConnectorOperator) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>The operation to be performed on the provided Amazon S3 source fields.</p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3ConnectorOperator>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// <p>The operation to be performed on the provided Salesforce source fields.</p>
        pub fn salesforce(mut self, input: crate::model::SalesforceConnectorOperator) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p>The operation to be performed on the provided Salesforce source fields.</p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceConnectorOperator>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p>The operation to be performed on the provided ServiceNow source fields.</p>
        pub fn service_now(mut self, input: crate::model::ServiceNowConnectorOperator) -> Self {
            self.service_now = Some(input);
            self
        }
        /// <p>The operation to be performed on the provided ServiceNow source fields.</p>
        pub fn set_service_now(
            mut self,
            input: std::option::Option<crate::model::ServiceNowConnectorOperator>,
        ) -> Self {
            self.service_now = input;
            self
        }
        /// <p>The operation to be performed on the provided Zendesk source fields.</p>
        pub fn zendesk(mut self, input: crate::model::ZendeskConnectorOperator) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p>The operation to be performed on the provided Zendesk source fields.</p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskConnectorOperator>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectorOperator`](crate::model::ConnectorOperator)
        pub fn build(self) -> crate::model::ConnectorOperator {
            crate::model::ConnectorOperator {
                marketo: self.marketo,
                s3: self.s3,
                salesforce: self.salesforce,
                service_now: self.service_now,
                zendesk: self.zendesk,
            }
        }
    }
}
impl ConnectorOperator {
    /// Creates a new builder-style object to manufacture [`ConnectorOperator`](crate::model::ConnectorOperator)
    pub fn builder() -> crate::model::connector_operator::Builder {
        crate::model::connector_operator::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ZendeskConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ZendeskConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => ZendeskConnectorOperator::Addition,
            "DIVISION" => ZendeskConnectorOperator::Division,
            "GREATER_THAN" => ZendeskConnectorOperator::GreaterThan,
            "MASK_ALL" => ZendeskConnectorOperator::MaskAll,
            "MASK_FIRST_N" => ZendeskConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => ZendeskConnectorOperator::MaskLastN,
            "MULTIPLICATION" => ZendeskConnectorOperator::Multiplication,
            "NO_OP" => ZendeskConnectorOperator::NoOp,
            "PROJECTION" => ZendeskConnectorOperator::Projection,
            "SUBTRACTION" => ZendeskConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => ZendeskConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => ZendeskConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => ZendeskConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => ZendeskConnectorOperator::ValidateNumeric,
            other => ZendeskConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ZendeskConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ZendeskConnectorOperator::from(s))
    }
}
impl ZendeskConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ZendeskConnectorOperator::Addition => "ADDITION",
            ZendeskConnectorOperator::Division => "DIVISION",
            ZendeskConnectorOperator::GreaterThan => "GREATER_THAN",
            ZendeskConnectorOperator::MaskAll => "MASK_ALL",
            ZendeskConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            ZendeskConnectorOperator::MaskLastN => "MASK_LAST_N",
            ZendeskConnectorOperator::Multiplication => "MULTIPLICATION",
            ZendeskConnectorOperator::NoOp => "NO_OP",
            ZendeskConnectorOperator::Projection => "PROJECTION",
            ZendeskConnectorOperator::Subtraction => "SUBTRACTION",
            ZendeskConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            ZendeskConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            ZendeskConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            ZendeskConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            ZendeskConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "DIVISION",
            "GREATER_THAN",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for ZendeskConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ServiceNowConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ServiceNowConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => ServiceNowConnectorOperator::Addition,
            "BETWEEN" => ServiceNowConnectorOperator::Between,
            "CONTAINS" => ServiceNowConnectorOperator::Contains,
            "DIVISION" => ServiceNowConnectorOperator::Division,
            "EQUAL_TO" => ServiceNowConnectorOperator::EqualTo,
            "GREATER_THAN" => ServiceNowConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => ServiceNowConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => ServiceNowConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => ServiceNowConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => ServiceNowConnectorOperator::MaskAll,
            "MASK_FIRST_N" => ServiceNowConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => ServiceNowConnectorOperator::MaskLastN,
            "MULTIPLICATION" => ServiceNowConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => ServiceNowConnectorOperator::NotEqualTo,
            "NO_OP" => ServiceNowConnectorOperator::NoOp,
            "PROJECTION" => ServiceNowConnectorOperator::Projection,
            "SUBTRACTION" => ServiceNowConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => ServiceNowConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => ServiceNowConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => ServiceNowConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => ServiceNowConnectorOperator::ValidateNumeric,
            other => ServiceNowConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ServiceNowConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ServiceNowConnectorOperator::from(s))
    }
}
impl ServiceNowConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ServiceNowConnectorOperator::Addition => "ADDITION",
            ServiceNowConnectorOperator::Between => "BETWEEN",
            ServiceNowConnectorOperator::Contains => "CONTAINS",
            ServiceNowConnectorOperator::Division => "DIVISION",
            ServiceNowConnectorOperator::EqualTo => "EQUAL_TO",
            ServiceNowConnectorOperator::GreaterThan => "GREATER_THAN",
            ServiceNowConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            ServiceNowConnectorOperator::LessThan => "LESS_THAN",
            ServiceNowConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            ServiceNowConnectorOperator::MaskAll => "MASK_ALL",
            ServiceNowConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            ServiceNowConnectorOperator::MaskLastN => "MASK_LAST_N",
            ServiceNowConnectorOperator::Multiplication => "MULTIPLICATION",
            ServiceNowConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            ServiceNowConnectorOperator::NoOp => "NO_OP",
            ServiceNowConnectorOperator::Projection => "PROJECTION",
            ServiceNowConnectorOperator::Subtraction => "SUBTRACTION",
            ServiceNowConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            ServiceNowConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            ServiceNowConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            ServiceNowConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            ServiceNowConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for ServiceNowConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SalesforceConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SalesforceConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => SalesforceConnectorOperator::Addition,
            "BETWEEN" => SalesforceConnectorOperator::Between,
            "CONTAINS" => SalesforceConnectorOperator::Contains,
            "DIVISION" => SalesforceConnectorOperator::Division,
            "EQUAL_TO" => SalesforceConnectorOperator::EqualTo,
            "GREATER_THAN" => SalesforceConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => SalesforceConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => SalesforceConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => SalesforceConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => SalesforceConnectorOperator::MaskAll,
            "MASK_FIRST_N" => SalesforceConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => SalesforceConnectorOperator::MaskLastN,
            "MULTIPLICATION" => SalesforceConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => SalesforceConnectorOperator::NotEqualTo,
            "NO_OP" => SalesforceConnectorOperator::NoOp,
            "PROJECTION" => SalesforceConnectorOperator::Projection,
            "SUBTRACTION" => SalesforceConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => SalesforceConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => SalesforceConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => SalesforceConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => SalesforceConnectorOperator::ValidateNumeric,
            other => SalesforceConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SalesforceConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SalesforceConnectorOperator::from(s))
    }
}
impl SalesforceConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SalesforceConnectorOperator::Addition => "ADDITION",
            SalesforceConnectorOperator::Between => "BETWEEN",
            SalesforceConnectorOperator::Contains => "CONTAINS",
            SalesforceConnectorOperator::Division => "DIVISION",
            SalesforceConnectorOperator::EqualTo => "EQUAL_TO",
            SalesforceConnectorOperator::GreaterThan => "GREATER_THAN",
            SalesforceConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            SalesforceConnectorOperator::LessThan => "LESS_THAN",
            SalesforceConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            SalesforceConnectorOperator::MaskAll => "MASK_ALL",
            SalesforceConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            SalesforceConnectorOperator::MaskLastN => "MASK_LAST_N",
            SalesforceConnectorOperator::Multiplication => "MULTIPLICATION",
            SalesforceConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            SalesforceConnectorOperator::NoOp => "NO_OP",
            SalesforceConnectorOperator::Projection => "PROJECTION",
            SalesforceConnectorOperator::Subtraction => "SUBTRACTION",
            SalesforceConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            SalesforceConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            SalesforceConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            SalesforceConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            SalesforceConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "CONTAINS",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for SalesforceConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    EqualTo,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NotEqualTo,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => S3ConnectorOperator::Addition,
            "BETWEEN" => S3ConnectorOperator::Between,
            "DIVISION" => S3ConnectorOperator::Division,
            "EQUAL_TO" => S3ConnectorOperator::EqualTo,
            "GREATER_THAN" => S3ConnectorOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => S3ConnectorOperator::GreaterThanOrEqualTo,
            "LESS_THAN" => S3ConnectorOperator::LessThan,
            "LESS_THAN_OR_EQUAL_TO" => S3ConnectorOperator::LessThanOrEqualTo,
            "MASK_ALL" => S3ConnectorOperator::MaskAll,
            "MASK_FIRST_N" => S3ConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => S3ConnectorOperator::MaskLastN,
            "MULTIPLICATION" => S3ConnectorOperator::Multiplication,
            "NOT_EQUAL_TO" => S3ConnectorOperator::NotEqualTo,
            "NO_OP" => S3ConnectorOperator::NoOp,
            "PROJECTION" => S3ConnectorOperator::Projection,
            "SUBTRACTION" => S3ConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => S3ConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => S3ConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => S3ConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => S3ConnectorOperator::ValidateNumeric,
            other => S3ConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ConnectorOperator::from(s))
    }
}
impl S3ConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ConnectorOperator::Addition => "ADDITION",
            S3ConnectorOperator::Between => "BETWEEN",
            S3ConnectorOperator::Division => "DIVISION",
            S3ConnectorOperator::EqualTo => "EQUAL_TO",
            S3ConnectorOperator::GreaterThan => "GREATER_THAN",
            S3ConnectorOperator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            S3ConnectorOperator::LessThan => "LESS_THAN",
            S3ConnectorOperator::LessThanOrEqualTo => "LESS_THAN_OR_EQUAL_TO",
            S3ConnectorOperator::MaskAll => "MASK_ALL",
            S3ConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            S3ConnectorOperator::MaskLastN => "MASK_LAST_N",
            S3ConnectorOperator::Multiplication => "MULTIPLICATION",
            S3ConnectorOperator::NotEqualTo => "NOT_EQUAL_TO",
            S3ConnectorOperator::NoOp => "NO_OP",
            S3ConnectorOperator::Projection => "PROJECTION",
            S3ConnectorOperator::Subtraction => "SUBTRACTION",
            S3ConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            S3ConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            S3ConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            S3ConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            S3ConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "EQUAL_TO",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL_TO",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL_TO",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NOT_EQUAL_TO",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for S3ConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MarketoConnectorOperator {
    #[allow(missing_docs)] // documentation missing in model
    Addition,
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Division,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    MaskAll,
    #[allow(missing_docs)] // documentation missing in model
    MaskFirstN,
    #[allow(missing_docs)] // documentation missing in model
    MaskLastN,
    #[allow(missing_docs)] // documentation missing in model
    Multiplication,
    #[allow(missing_docs)] // documentation missing in model
    NoOp,
    #[allow(missing_docs)] // documentation missing in model
    Projection,
    #[allow(missing_docs)] // documentation missing in model
    Subtraction,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNegative,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonNull,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNonZero,
    #[allow(missing_docs)] // documentation missing in model
    ValidateNumeric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MarketoConnectorOperator {
    fn from(s: &str) -> Self {
        match s {
            "ADDITION" => MarketoConnectorOperator::Addition,
            "BETWEEN" => MarketoConnectorOperator::Between,
            "DIVISION" => MarketoConnectorOperator::Division,
            "GREATER_THAN" => MarketoConnectorOperator::GreaterThan,
            "LESS_THAN" => MarketoConnectorOperator::LessThan,
            "MASK_ALL" => MarketoConnectorOperator::MaskAll,
            "MASK_FIRST_N" => MarketoConnectorOperator::MaskFirstN,
            "MASK_LAST_N" => MarketoConnectorOperator::MaskLastN,
            "MULTIPLICATION" => MarketoConnectorOperator::Multiplication,
            "NO_OP" => MarketoConnectorOperator::NoOp,
            "PROJECTION" => MarketoConnectorOperator::Projection,
            "SUBTRACTION" => MarketoConnectorOperator::Subtraction,
            "VALIDATE_NON_NEGATIVE" => MarketoConnectorOperator::ValidateNonNegative,
            "VALIDATE_NON_NULL" => MarketoConnectorOperator::ValidateNonNull,
            "VALIDATE_NON_ZERO" => MarketoConnectorOperator::ValidateNonZero,
            "VALIDATE_NUMERIC" => MarketoConnectorOperator::ValidateNumeric,
            other => MarketoConnectorOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MarketoConnectorOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MarketoConnectorOperator::from(s))
    }
}
impl MarketoConnectorOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MarketoConnectorOperator::Addition => "ADDITION",
            MarketoConnectorOperator::Between => "BETWEEN",
            MarketoConnectorOperator::Division => "DIVISION",
            MarketoConnectorOperator::GreaterThan => "GREATER_THAN",
            MarketoConnectorOperator::LessThan => "LESS_THAN",
            MarketoConnectorOperator::MaskAll => "MASK_ALL",
            MarketoConnectorOperator::MaskFirstN => "MASK_FIRST_N",
            MarketoConnectorOperator::MaskLastN => "MASK_LAST_N",
            MarketoConnectorOperator::Multiplication => "MULTIPLICATION",
            MarketoConnectorOperator::NoOp => "NO_OP",
            MarketoConnectorOperator::Projection => "PROJECTION",
            MarketoConnectorOperator::Subtraction => "SUBTRACTION",
            MarketoConnectorOperator::ValidateNonNegative => "VALIDATE_NON_NEGATIVE",
            MarketoConnectorOperator::ValidateNonNull => "VALIDATE_NON_NULL",
            MarketoConnectorOperator::ValidateNonZero => "VALIDATE_NON_ZERO",
            MarketoConnectorOperator::ValidateNumeric => "VALIDATE_NUMERIC",
            MarketoConnectorOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ADDITION",
            "BETWEEN",
            "DIVISION",
            "GREATER_THAN",
            "LESS_THAN",
            "MASK_ALL",
            "MASK_FIRST_N",
            "MASK_LAST_N",
            "MULTIPLICATION",
            "NO_OP",
            "PROJECTION",
            "SUBTRACTION",
            "VALIDATE_NON_NEGATIVE",
            "VALIDATE_NON_NULL",
            "VALIDATE_NON_ZERO",
            "VALIDATE_NUMERIC",
        ]
    }
}
impl AsRef<str> for MarketoConnectorOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains information about the configuration of the source connector used in the
/// flow.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceFlowConfig {
    /// <p>The name of the AppFlow connector profile. This name must be unique for each connector
    /// profile in the AWS account.</p>
    pub connector_profile_name: std::option::Option<std::string::String>,
    /// <p>The type of connector, such as Salesforce, Marketo, and so on.</p>
    pub connector_type: std::option::Option<crate::model::SourceConnectorType>,
    /// <p>Defines the configuration for a scheduled incremental data pull. If a valid
    /// configuration is provided, the fields specified in the configuration are used when querying
    /// for the incremental data pull.</p>
    pub incremental_pull_config: std::option::Option<crate::model::IncrementalPullConfig>,
    /// <p>Specifies the information that is required to query a particular source
    /// connector.</p>
    pub source_connector_properties: std::option::Option<crate::model::SourceConnectorProperties>,
}
impl std::fmt::Debug for SourceFlowConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceFlowConfig");
        formatter.field("connector_profile_name", &self.connector_profile_name);
        formatter.field("connector_type", &self.connector_type);
        formatter.field("incremental_pull_config", &self.incremental_pull_config);
        formatter.field(
            "source_connector_properties",
            &self.source_connector_properties,
        );
        formatter.finish()
    }
}
/// See [`SourceFlowConfig`](crate::model::SourceFlowConfig)
pub mod source_flow_config {
    /// A builder for [`SourceFlowConfig`](crate::model::SourceFlowConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) connector_profile_name: std::option::Option<std::string::String>,
        pub(crate) connector_type: std::option::Option<crate::model::SourceConnectorType>,
        pub(crate) incremental_pull_config:
            std::option::Option<crate::model::IncrementalPullConfig>,
        pub(crate) source_connector_properties:
            std::option::Option<crate::model::SourceConnectorProperties>,
    }
    impl Builder {
        /// <p>The name of the AppFlow connector profile. This name must be unique for each connector
        /// profile in the AWS account.</p>
        pub fn connector_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.connector_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the AppFlow connector profile. This name must be unique for each connector
        /// profile in the AWS account.</p>
        pub fn set_connector_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.connector_profile_name = input;
            self
        }
        /// <p>The type of connector, such as Salesforce, Marketo, and so on.</p>
        pub fn connector_type(mut self, input: crate::model::SourceConnectorType) -> Self {
            self.connector_type = Some(input);
            self
        }
        /// <p>The type of connector, such as Salesforce, Marketo, and so on.</p>
        pub fn set_connector_type(
            mut self,
            input: std::option::Option<crate::model::SourceConnectorType>,
        ) -> Self {
            self.connector_type = input;
            self
        }
        /// <p>Defines the configuration for a scheduled incremental data pull. If a valid
        /// configuration is provided, the fields specified in the configuration are used when querying
        /// for the incremental data pull.</p>
        pub fn incremental_pull_config(
            mut self,
            input: crate::model::IncrementalPullConfig,
        ) -> Self {
            self.incremental_pull_config = Some(input);
            self
        }
        /// <p>Defines the configuration for a scheduled incremental data pull. If a valid
        /// configuration is provided, the fields specified in the configuration are used when querying
        /// for the incremental data pull.</p>
        pub fn set_incremental_pull_config(
            mut self,
            input: std::option::Option<crate::model::IncrementalPullConfig>,
        ) -> Self {
            self.incremental_pull_config = input;
            self
        }
        /// <p>Specifies the information that is required to query a particular source
        /// connector.</p>
        pub fn source_connector_properties(
            mut self,
            input: crate::model::SourceConnectorProperties,
        ) -> Self {
            self.source_connector_properties = Some(input);
            self
        }
        /// <p>Specifies the information that is required to query a particular source
        /// connector.</p>
        pub fn set_source_connector_properties(
            mut self,
            input: std::option::Option<crate::model::SourceConnectorProperties>,
        ) -> Self {
            self.source_connector_properties = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceFlowConfig`](crate::model::SourceFlowConfig)
        pub fn build(self) -> crate::model::SourceFlowConfig {
            crate::model::SourceFlowConfig {
                connector_profile_name: self.connector_profile_name,
                connector_type: self.connector_type,
                incremental_pull_config: self.incremental_pull_config,
                source_connector_properties: self.source_connector_properties,
            }
        }
    }
}
impl SourceFlowConfig {
    /// Creates a new builder-style object to manufacture [`SourceFlowConfig`](crate::model::SourceFlowConfig)
    pub fn builder() -> crate::model::source_flow_config::Builder {
        crate::model::source_flow_config::Builder::default()
    }
}

/// <p>Specifies the information that is required to query a particular Amazon AppFlow connector.
/// Customer Profiles supports Salesforce, Zendesk, Marketo, ServiceNow and Amazon S3.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceConnectorProperties {
    /// <p>The properties that are applied when Marketo is being used as a source.</p>
    pub marketo: std::option::Option<crate::model::MarketoSourceProperties>,
    /// <p>The properties that are applied when Amazon S3 is being used as the flow source.</p>
    pub s3: std::option::Option<crate::model::S3SourceProperties>,
    /// <p>The properties that are applied when Salesforce is being used as a source.</p>
    pub salesforce: std::option::Option<crate::model::SalesforceSourceProperties>,
    /// <p>The properties that are applied when ServiceNow is being used as a source.</p>
    pub service_now: std::option::Option<crate::model::ServiceNowSourceProperties>,
    /// <p>The properties that are applied when using Zendesk as a flow source.</p>
    pub zendesk: std::option::Option<crate::model::ZendeskSourceProperties>,
}
impl std::fmt::Debug for SourceConnectorProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceConnectorProperties");
        formatter.field("marketo", &self.marketo);
        formatter.field("s3", &self.s3);
        formatter.field("salesforce", &self.salesforce);
        formatter.field("service_now", &self.service_now);
        formatter.field("zendesk", &self.zendesk);
        formatter.finish()
    }
}
/// See [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
pub mod source_connector_properties {
    /// A builder for [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marketo: std::option::Option<crate::model::MarketoSourceProperties>,
        pub(crate) s3: std::option::Option<crate::model::S3SourceProperties>,
        pub(crate) salesforce: std::option::Option<crate::model::SalesforceSourceProperties>,
        pub(crate) service_now: std::option::Option<crate::model::ServiceNowSourceProperties>,
        pub(crate) zendesk: std::option::Option<crate::model::ZendeskSourceProperties>,
    }
    impl Builder {
        /// <p>The properties that are applied when Marketo is being used as a source.</p>
        pub fn marketo(mut self, input: crate::model::MarketoSourceProperties) -> Self {
            self.marketo = Some(input);
            self
        }
        /// <p>The properties that are applied when Marketo is being used as a source.</p>
        pub fn set_marketo(
            mut self,
            input: std::option::Option<crate::model::MarketoSourceProperties>,
        ) -> Self {
            self.marketo = input;
            self
        }
        /// <p>The properties that are applied when Amazon S3 is being used as the flow source.</p>
        pub fn s3(mut self, input: crate::model::S3SourceProperties) -> Self {
            self.s3 = Some(input);
            self
        }
        /// <p>The properties that are applied when Amazon S3 is being used as the flow source.</p>
        pub fn set_s3(
            mut self,
            input: std::option::Option<crate::model::S3SourceProperties>,
        ) -> Self {
            self.s3 = input;
            self
        }
        /// <p>The properties that are applied when Salesforce is being used as a source.</p>
        pub fn salesforce(mut self, input: crate::model::SalesforceSourceProperties) -> Self {
            self.salesforce = Some(input);
            self
        }
        /// <p>The properties that are applied when Salesforce is being used as a source.</p>
        pub fn set_salesforce(
            mut self,
            input: std::option::Option<crate::model::SalesforceSourceProperties>,
        ) -> Self {
            self.salesforce = input;
            self
        }
        /// <p>The properties that are applied when ServiceNow is being used as a source.</p>
        pub fn service_now(mut self, input: crate::model::ServiceNowSourceProperties) -> Self {
            self.service_now = Some(input);
            self
        }
        /// <p>The properties that are applied when ServiceNow is being used as a source.</p>
        pub fn set_service_now(
            mut self,
            input: std::option::Option<crate::model::ServiceNowSourceProperties>,
        ) -> Self {
            self.service_now = input;
            self
        }
        /// <p>The properties that are applied when using Zendesk as a flow source.</p>
        pub fn zendesk(mut self, input: crate::model::ZendeskSourceProperties) -> Self {
            self.zendesk = Some(input);
            self
        }
        /// <p>The properties that are applied when using Zendesk as a flow source.</p>
        pub fn set_zendesk(
            mut self,
            input: std::option::Option<crate::model::ZendeskSourceProperties>,
        ) -> Self {
            self.zendesk = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
        pub fn build(self) -> crate::model::SourceConnectorProperties {
            crate::model::SourceConnectorProperties {
                marketo: self.marketo,
                s3: self.s3,
                salesforce: self.salesforce,
                service_now: self.service_now,
                zendesk: self.zendesk,
            }
        }
    }
}
impl SourceConnectorProperties {
    /// Creates a new builder-style object to manufacture [`SourceConnectorProperties`](crate::model::SourceConnectorProperties)
    pub fn builder() -> crate::model::source_connector_properties::Builder {
        crate::model::source_connector_properties::Builder::default()
    }
}

/// <p>The properties that are applied when using Zendesk as a flow source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ZendeskSourceProperties {
    /// <p>The object specified in the Zendesk flow source.</p>
    pub object: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ZendeskSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ZendeskSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
pub mod zendesk_source_properties {
    /// A builder for [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The object specified in the Zendesk flow source.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>The object specified in the Zendesk flow source.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
        pub fn build(self) -> crate::model::ZendeskSourceProperties {
            crate::model::ZendeskSourceProperties {
                object: self.object,
            }
        }
    }
}
impl ZendeskSourceProperties {
    /// Creates a new builder-style object to manufacture [`ZendeskSourceProperties`](crate::model::ZendeskSourceProperties)
    pub fn builder() -> crate::model::zendesk_source_properties::Builder {
        crate::model::zendesk_source_properties::Builder::default()
    }
}

/// <p>The properties that are applied when ServiceNow is being used as a source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceNowSourceProperties {
    /// <p>The object specified in the ServiceNow flow source.</p>
    pub object: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceNowSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceNowSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
pub mod service_now_source_properties {
    /// A builder for [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The object specified in the ServiceNow flow source.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>The object specified in the ServiceNow flow source.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
        pub fn build(self) -> crate::model::ServiceNowSourceProperties {
            crate::model::ServiceNowSourceProperties {
                object: self.object,
            }
        }
    }
}
impl ServiceNowSourceProperties {
    /// Creates a new builder-style object to manufacture [`ServiceNowSourceProperties`](crate::model::ServiceNowSourceProperties)
    pub fn builder() -> crate::model::service_now_source_properties::Builder {
        crate::model::service_now_source_properties::Builder::default()
    }
}

/// <p>The properties that are applied when Salesforce is being used as a source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SalesforceSourceProperties {
    /// <p>The object specified in the Salesforce flow source.</p>
    pub object: std::option::Option<std::string::String>,
    /// <p>The flag that enables dynamic fetching of new (recently added) fields in the Salesforce
    /// objects while running a flow.</p>
    pub enable_dynamic_field_update: bool,
    /// <p>Indicates whether Amazon AppFlow includes deleted files in the flow run.</p>
    pub include_deleted_records: bool,
}
impl std::fmt::Debug for SalesforceSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SalesforceSourceProperties");
        formatter.field("object", &self.object);
        formatter.field(
            "enable_dynamic_field_update",
            &self.enable_dynamic_field_update,
        );
        formatter.field("include_deleted_records", &self.include_deleted_records);
        formatter.finish()
    }
}
/// See [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
pub mod salesforce_source_properties {
    /// A builder for [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
        pub(crate) enable_dynamic_field_update: std::option::Option<bool>,
        pub(crate) include_deleted_records: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The object specified in the Salesforce flow source.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>The object specified in the Salesforce flow source.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// <p>The flag that enables dynamic fetching of new (recently added) fields in the Salesforce
        /// objects while running a flow.</p>
        pub fn enable_dynamic_field_update(mut self, input: bool) -> Self {
            self.enable_dynamic_field_update = Some(input);
            self
        }
        /// <p>The flag that enables dynamic fetching of new (recently added) fields in the Salesforce
        /// objects while running a flow.</p>
        pub fn set_enable_dynamic_field_update(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_dynamic_field_update = input;
            self
        }
        /// <p>Indicates whether Amazon AppFlow includes deleted files in the flow run.</p>
        pub fn include_deleted_records(mut self, input: bool) -> Self {
            self.include_deleted_records = Some(input);
            self
        }
        /// <p>Indicates whether Amazon AppFlow includes deleted files in the flow run.</p>
        pub fn set_include_deleted_records(mut self, input: std::option::Option<bool>) -> Self {
            self.include_deleted_records = input;
            self
        }
        /// Consumes the builder and constructs a [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
        pub fn build(self) -> crate::model::SalesforceSourceProperties {
            crate::model::SalesforceSourceProperties {
                object: self.object,
                enable_dynamic_field_update: self.enable_dynamic_field_update.unwrap_or_default(),
                include_deleted_records: self.include_deleted_records.unwrap_or_default(),
            }
        }
    }
}
impl SalesforceSourceProperties {
    /// Creates a new builder-style object to manufacture [`SalesforceSourceProperties`](crate::model::SalesforceSourceProperties)
    pub fn builder() -> crate::model::salesforce_source_properties::Builder {
        crate::model::salesforce_source_properties::Builder::default()
    }
}

/// <p>The properties that are applied when Amazon S3 is being used as the flow source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3SourceProperties {
    /// <p>The Amazon S3 bucket name where the source files are stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The object key for the Amazon S3 bucket in which the source files are stored.</p>
    pub bucket_prefix: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for S3SourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3SourceProperties");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("bucket_prefix", &self.bucket_prefix);
        formatter.finish()
    }
}
/// See [`S3SourceProperties`](crate::model::S3SourceProperties)
pub mod s3_source_properties {
    /// A builder for [`S3SourceProperties`](crate::model::S3SourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) bucket_prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon S3 bucket name where the source files are stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket name where the source files are stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The object key for the Amazon S3 bucket in which the source files are stored.</p>
        pub fn bucket_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_prefix = Some(input.into());
            self
        }
        /// <p>The object key for the Amazon S3 bucket in which the source files are stored.</p>
        pub fn set_bucket_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.bucket_prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3SourceProperties`](crate::model::S3SourceProperties)
        pub fn build(self) -> crate::model::S3SourceProperties {
            crate::model::S3SourceProperties {
                bucket_name: self.bucket_name,
                bucket_prefix: self.bucket_prefix,
            }
        }
    }
}
impl S3SourceProperties {
    /// Creates a new builder-style object to manufacture [`S3SourceProperties`](crate::model::S3SourceProperties)
    pub fn builder() -> crate::model::s3_source_properties::Builder {
        crate::model::s3_source_properties::Builder::default()
    }
}

/// <p>The properties that are applied when Marketo is being used as a source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MarketoSourceProperties {
    /// <p>The object specified in the Marketo flow source.</p>
    pub object: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MarketoSourceProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MarketoSourceProperties");
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
pub mod marketo_source_properties {
    /// A builder for [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The object specified in the Marketo flow source.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>The object specified in the Marketo flow source.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
        pub fn build(self) -> crate::model::MarketoSourceProperties {
            crate::model::MarketoSourceProperties {
                object: self.object,
            }
        }
    }
}
impl MarketoSourceProperties {
    /// Creates a new builder-style object to manufacture [`MarketoSourceProperties`](crate::model::MarketoSourceProperties)
    pub fn builder() -> crate::model::marketo_source_properties::Builder {
        crate::model::marketo_source_properties::Builder::default()
    }
}

/// <p>Specifies the configuration used when importing incremental records from the
/// source.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncrementalPullConfig {
    /// <p>A field that specifies the date time or timestamp field as the criteria to use when
    /// importing incremental records from the source.</p>
    pub datetime_type_field_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncrementalPullConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncrementalPullConfig");
        formatter.field("datetime_type_field_name", &self.datetime_type_field_name);
        formatter.finish()
    }
}
/// See [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
pub mod incremental_pull_config {
    /// A builder for [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) datetime_type_field_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A field that specifies the date time or timestamp field as the criteria to use when
        /// importing incremental records from the source.</p>
        pub fn datetime_type_field_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.datetime_type_field_name = Some(input.into());
            self
        }
        /// <p>A field that specifies the date time or timestamp field as the criteria to use when
        /// importing incremental records from the source.</p>
        pub fn set_datetime_type_field_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.datetime_type_field_name = input;
            self
        }
        /// Consumes the builder and constructs a [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
        pub fn build(self) -> crate::model::IncrementalPullConfig {
            crate::model::IncrementalPullConfig {
                datetime_type_field_name: self.datetime_type_field_name,
            }
        }
    }
}
impl IncrementalPullConfig {
    /// Creates a new builder-style object to manufacture [`IncrementalPullConfig`](crate::model::IncrementalPullConfig)
    pub fn builder() -> crate::model::incremental_pull_config::Builder {
        crate::model::incremental_pull_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceConnectorType {
    #[allow(missing_docs)] // documentation missing in model
    Marketo,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    #[allow(missing_docs)] // documentation missing in model
    Salesforce,
    #[allow(missing_docs)] // documentation missing in model
    Servicenow,
    #[allow(missing_docs)] // documentation missing in model
    Zendesk,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceConnectorType {
    fn from(s: &str) -> Self {
        match s {
            "Marketo" => SourceConnectorType::Marketo,
            "S3" => SourceConnectorType::S3,
            "Salesforce" => SourceConnectorType::Salesforce,
            "Servicenow" => SourceConnectorType::Servicenow,
            "Zendesk" => SourceConnectorType::Zendesk,
            other => SourceConnectorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceConnectorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceConnectorType::from(s))
    }
}
impl SourceConnectorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceConnectorType::Marketo => "Marketo",
            SourceConnectorType::S3 => "S3",
            SourceConnectorType::Salesforce => "Salesforce",
            SourceConnectorType::Servicenow => "Servicenow",
            SourceConnectorType::Zendesk => "Zendesk",
            SourceConnectorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Marketo", "S3", "Salesforce", "Servicenow", "Zendesk"]
    }
}
impl AsRef<str> for SourceConnectorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A duplicate customer profile that is to be merged into a main profile. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FieldSourceProfileIds {
    /// <p>A unique identifier for the account number field to be merged. </p>
    pub account_number: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the additional information field to be merged.</p>
    pub additional_information: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the party type field to be merged.</p>
    pub party_type: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the business name field to be merged.</p>
    pub business_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the first name field to be merged.</p>
    pub first_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the middle name field to be merged.</p>
    pub middle_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the last name field to be merged.</p>
    pub last_name: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the birthdate field to be merged.</p>
    pub birth_date: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the gender field to be merged.</p>
    pub gender: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the phone number field to be merged.</p>
    pub phone_number: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the mobile phone number field to be merged.</p>
    pub mobile_phone_number: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the home phone number field to be merged.</p>
    pub home_phone_number: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the business phone number field to be merged.</p>
    pub business_phone_number: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the email address field to be merged.</p>
    pub email_address: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the personal email address field to be merged.</p>
    pub personal_email_address: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the party type field to be merged.</p>
    pub business_email_address: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the party type field to be merged.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the shipping address field to be merged.</p>
    pub shipping_address: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the mailing address field to be merged.</p>
    pub mailing_address: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the billing type field to be merged.</p>
    pub billing_address: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the attributes field to be merged.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for FieldSourceProfileIds {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FieldSourceProfileIds");
        formatter.field("account_number", &self.account_number);
        formatter.field("additional_information", &self.additional_information);
        formatter.field("party_type", &self.party_type);
        formatter.field("business_name", &self.business_name);
        formatter.field("first_name", &self.first_name);
        formatter.field("middle_name", &self.middle_name);
        formatter.field("last_name", &self.last_name);
        formatter.field("birth_date", &self.birth_date);
        formatter.field("gender", &self.gender);
        formatter.field("phone_number", &self.phone_number);
        formatter.field("mobile_phone_number", &self.mobile_phone_number);
        formatter.field("home_phone_number", &self.home_phone_number);
        formatter.field("business_phone_number", &self.business_phone_number);
        formatter.field("email_address", &self.email_address);
        formatter.field("personal_email_address", &self.personal_email_address);
        formatter.field("business_email_address", &self.business_email_address);
        formatter.field("address", &self.address);
        formatter.field("shipping_address", &self.shipping_address);
        formatter.field("mailing_address", &self.mailing_address);
        formatter.field("billing_address", &self.billing_address);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`FieldSourceProfileIds`](crate::model::FieldSourceProfileIds)
pub mod field_source_profile_ids {
    /// A builder for [`FieldSourceProfileIds`](crate::model::FieldSourceProfileIds)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_number: std::option::Option<std::string::String>,
        pub(crate) additional_information: std::option::Option<std::string::String>,
        pub(crate) party_type: std::option::Option<std::string::String>,
        pub(crate) business_name: std::option::Option<std::string::String>,
        pub(crate) first_name: std::option::Option<std::string::String>,
        pub(crate) middle_name: std::option::Option<std::string::String>,
        pub(crate) last_name: std::option::Option<std::string::String>,
        pub(crate) birth_date: std::option::Option<std::string::String>,
        pub(crate) gender: std::option::Option<std::string::String>,
        pub(crate) phone_number: std::option::Option<std::string::String>,
        pub(crate) mobile_phone_number: std::option::Option<std::string::String>,
        pub(crate) home_phone_number: std::option::Option<std::string::String>,
        pub(crate) business_phone_number: std::option::Option<std::string::String>,
        pub(crate) email_address: std::option::Option<std::string::String>,
        pub(crate) personal_email_address: std::option::Option<std::string::String>,
        pub(crate) business_email_address: std::option::Option<std::string::String>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) shipping_address: std::option::Option<std::string::String>,
        pub(crate) mailing_address: std::option::Option<std::string::String>,
        pub(crate) billing_address: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique identifier for the account number field to be merged. </p>
        pub fn account_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_number = Some(input.into());
            self
        }
        /// <p>A unique identifier for the account number field to be merged. </p>
        pub fn set_account_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_number = input;
            self
        }
        /// <p>A unique identifier for the additional information field to be merged.</p>
        pub fn additional_information(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_information = Some(input.into());
            self
        }
        /// <p>A unique identifier for the additional information field to be merged.</p>
        pub fn set_additional_information(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_information = input;
            self
        }
        /// <p>A unique identifier for the party type field to be merged.</p>
        pub fn party_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.party_type = Some(input.into());
            self
        }
        /// <p>A unique identifier for the party type field to be merged.</p>
        pub fn set_party_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.party_type = input;
            self
        }
        /// <p>A unique identifier for the business name field to be merged.</p>
        pub fn business_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the business name field to be merged.</p>
        pub fn set_business_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_name = input;
            self
        }
        /// <p>A unique identifier for the first name field to be merged.</p>
        pub fn first_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.first_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the first name field to be merged.</p>
        pub fn set_first_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.first_name = input;
            self
        }
        /// <p>A unique identifier for the middle name field to be merged.</p>
        pub fn middle_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.middle_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the middle name field to be merged.</p>
        pub fn set_middle_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.middle_name = input;
            self
        }
        /// <p>A unique identifier for the last name field to be merged.</p>
        pub fn last_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_name = Some(input.into());
            self
        }
        /// <p>A unique identifier for the last name field to be merged.</p>
        pub fn set_last_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_name = input;
            self
        }
        /// <p>A unique identifier for the birthdate field to be merged.</p>
        pub fn birth_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.birth_date = Some(input.into());
            self
        }
        /// <p>A unique identifier for the birthdate field to be merged.</p>
        pub fn set_birth_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.birth_date = input;
            self
        }
        /// <p>A unique identifier for the gender field to be merged.</p>
        pub fn gender(mut self, input: impl Into<std::string::String>) -> Self {
            self.gender = Some(input.into());
            self
        }
        /// <p>A unique identifier for the gender field to be merged.</p>
        pub fn set_gender(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gender = input;
            self
        }
        /// <p>A unique identifier for the phone number field to be merged.</p>
        pub fn phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.phone_number = Some(input.into());
            self
        }
        /// <p>A unique identifier for the phone number field to be merged.</p>
        pub fn set_phone_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.phone_number = input;
            self
        }
        /// <p>A unique identifier for the mobile phone number field to be merged.</p>
        pub fn mobile_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.mobile_phone_number = Some(input.into());
            self
        }
        /// <p>A unique identifier for the mobile phone number field to be merged.</p>
        pub fn set_mobile_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mobile_phone_number = input;
            self
        }
        /// <p>A unique identifier for the home phone number field to be merged.</p>
        pub fn home_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.home_phone_number = Some(input.into());
            self
        }
        /// <p>A unique identifier for the home phone number field to be merged.</p>
        pub fn set_home_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.home_phone_number = input;
            self
        }
        /// <p>A unique identifier for the business phone number field to be merged.</p>
        pub fn business_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_phone_number = Some(input.into());
            self
        }
        /// <p>A unique identifier for the business phone number field to be merged.</p>
        pub fn set_business_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_phone_number = input;
            self
        }
        /// <p>A unique identifier for the email address field to be merged.</p>
        pub fn email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.email_address = Some(input.into());
            self
        }
        /// <p>A unique identifier for the email address field to be merged.</p>
        pub fn set_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.email_address = input;
            self
        }
        /// <p>A unique identifier for the personal email address field to be merged.</p>
        pub fn personal_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.personal_email_address = Some(input.into());
            self
        }
        /// <p>A unique identifier for the personal email address field to be merged.</p>
        pub fn set_personal_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.personal_email_address = input;
            self
        }
        /// <p>A unique identifier for the party type field to be merged.</p>
        pub fn business_email_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.business_email_address = Some(input.into());
            self
        }
        /// <p>A unique identifier for the party type field to be merged.</p>
        pub fn set_business_email_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.business_email_address = input;
            self
        }
        /// <p>A unique identifier for the party type field to be merged.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>A unique identifier for the party type field to be merged.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>A unique identifier for the shipping address field to be merged.</p>
        pub fn shipping_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.shipping_address = Some(input.into());
            self
        }
        /// <p>A unique identifier for the shipping address field to be merged.</p>
        pub fn set_shipping_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.shipping_address = input;
            self
        }
        /// <p>A unique identifier for the mailing address field to be merged.</p>
        pub fn mailing_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.mailing_address = Some(input.into());
            self
        }
        /// <p>A unique identifier for the mailing address field to be merged.</p>
        pub fn set_mailing_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.mailing_address = input;
            self
        }
        /// <p>A unique identifier for the billing type field to be merged.</p>
        pub fn billing_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.billing_address = Some(input.into());
            self
        }
        /// <p>A unique identifier for the billing type field to be merged.</p>
        pub fn set_billing_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.billing_address = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A unique identifier for the attributes field to be merged.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A unique identifier for the attributes field to be merged.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`FieldSourceProfileIds`](crate::model::FieldSourceProfileIds)
        pub fn build(self) -> crate::model::FieldSourceProfileIds {
            crate::model::FieldSourceProfileIds {
                account_number: self.account_number,
                additional_information: self.additional_information,
                party_type: self.party_type,
                business_name: self.business_name,
                first_name: self.first_name,
                middle_name: self.middle_name,
                last_name: self.last_name,
                birth_date: self.birth_date,
                gender: self.gender,
                phone_number: self.phone_number,
                mobile_phone_number: self.mobile_phone_number,
                home_phone_number: self.home_phone_number,
                business_phone_number: self.business_phone_number,
                email_address: self.email_address,
                personal_email_address: self.personal_email_address,
                business_email_address: self.business_email_address,
                address: self.address,
                shipping_address: self.shipping_address,
                mailing_address: self.mailing_address,
                billing_address: self.billing_address,
                attributes: self.attributes,
            }
        }
    }
}
impl FieldSourceProfileIds {
    /// Creates a new builder-style object to manufacture [`FieldSourceProfileIds`](crate::model::FieldSourceProfileIds)
    pub fn builder() -> crate::model::field_source_profile_ids::Builder {
        crate::model::field_source_profile_ids::Builder::default()
    }
}

/// <p>A ProfileObjectTypeTemplate in a list of ProfileObjectTypeTemplates.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectTypeTemplateItem {
    /// <p>A unique identifier for the object template.</p>
    pub template_id: std::option::Option<std::string::String>,
    /// <p>The name of the source of the object template.</p>
    pub source_name: std::option::Option<std::string::String>,
    /// <p>The source of the object template.</p>
    pub source_object: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProfileObjectTypeTemplateItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectTypeTemplateItem");
        formatter.field("template_id", &self.template_id);
        formatter.field("source_name", &self.source_name);
        formatter.field("source_object", &self.source_object);
        formatter.finish()
    }
}
/// See [`ListProfileObjectTypeTemplateItem`](crate::model::ListProfileObjectTypeTemplateItem)
pub mod list_profile_object_type_template_item {
    /// A builder for [`ListProfileObjectTypeTemplateItem`](crate::model::ListProfileObjectTypeTemplateItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) template_id: std::option::Option<std::string::String>,
        pub(crate) source_name: std::option::Option<std::string::String>,
        pub(crate) source_object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the object template.</p>
        pub fn template_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.template_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the object template.</p>
        pub fn set_template_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.template_id = input;
            self
        }
        /// <p>The name of the source of the object template.</p>
        pub fn source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_name = Some(input.into());
            self
        }
        /// <p>The name of the source of the object template.</p>
        pub fn set_source_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_name = input;
            self
        }
        /// <p>The source of the object template.</p>
        pub fn source_object(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_object = Some(input.into());
            self
        }
        /// <p>The source of the object template.</p>
        pub fn set_source_object(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_object = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectTypeTemplateItem`](crate::model::ListProfileObjectTypeTemplateItem)
        pub fn build(self) -> crate::model::ListProfileObjectTypeTemplateItem {
            crate::model::ListProfileObjectTypeTemplateItem {
                template_id: self.template_id,
                source_name: self.source_name,
                source_object: self.source_object,
            }
        }
    }
}
impl ListProfileObjectTypeTemplateItem {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypeTemplateItem`](crate::model::ListProfileObjectTypeTemplateItem)
    pub fn builder() -> crate::model::list_profile_object_type_template_item::Builder {
        crate::model::list_profile_object_type_template_item::Builder::default()
    }
}

/// <p>A ProfileObjectType instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectTypeItem {
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>Description of the profile object type.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListProfileObjectTypeItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectTypeItem");
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("description", &self.description);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListProfileObjectTypeItem`](crate::model::ListProfileObjectTypeItem)
pub mod list_profile_object_type_item {
    /// A builder for [`ListProfileObjectTypeItem`](crate::model::ListProfileObjectTypeItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the profile object type.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectTypeItem`](crate::model::ListProfileObjectTypeItem)
        pub fn build(self) -> crate::model::ListProfileObjectTypeItem {
            crate::model::ListProfileObjectTypeItem {
                object_type_name: self.object_type_name,
                description: self.description,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl ListProfileObjectTypeItem {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectTypeItem`](crate::model::ListProfileObjectTypeItem)
    pub fn builder() -> crate::model::list_profile_object_type_item::Builder {
        crate::model::list_profile_object_type_item::Builder::default()
    }
}

/// <p>A ProfileObject in a list of ProfileObjects.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProfileObjectsItem {
    /// <p>Specifies the kind of object being added to a profile, such as
    /// "Salesforce-Account."</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the ProfileObject generated by the service.</p>
    pub profile_object_unique_key: std::option::Option<std::string::String>,
    /// <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
    pub object: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListProfileObjectsItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProfileObjectsItem");
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("profile_object_unique_key", &self.profile_object_unique_key);
        formatter.field("object", &self.object);
        formatter.finish()
    }
}
/// See [`ListProfileObjectsItem`](crate::model::ListProfileObjectsItem)
pub mod list_profile_objects_item {
    /// A builder for [`ListProfileObjectsItem`](crate::model::ListProfileObjectsItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) profile_object_unique_key: std::option::Option<std::string::String>,
        pub(crate) object: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the kind of object being added to a profile, such as
        /// "Salesforce-Account."</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>Specifies the kind of object being added to a profile, such as
        /// "Salesforce-Account."</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The unique identifier of the ProfileObject generated by the service.</p>
        pub fn profile_object_unique_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.profile_object_unique_key = Some(input.into());
            self
        }
        /// <p>The unique identifier of the ProfileObject generated by the service.</p>
        pub fn set_profile_object_unique_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.profile_object_unique_key = input;
            self
        }
        /// <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
        pub fn object(mut self, input: impl Into<std::string::String>) -> Self {
            self.object = Some(input.into());
            self
        }
        /// <p>A JSON representation of a ProfileObject that belongs to a profile.</p>
        pub fn set_object(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.object = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProfileObjectsItem`](crate::model::ListProfileObjectsItem)
        pub fn build(self) -> crate::model::ListProfileObjectsItem {
            crate::model::ListProfileObjectsItem {
                object_type_name: self.object_type_name,
                profile_object_unique_key: self.profile_object_unique_key,
                object: self.object,
            }
        }
    }
}
impl ListProfileObjectsItem {
    /// Creates a new builder-style object to manufacture [`ListProfileObjectsItem`](crate::model::ListProfileObjectsItem)
    pub fn builder() -> crate::model::list_profile_objects_item::Builder {
        crate::model::list_profile_objects_item::Builder::default()
    }
}

/// <p>The filter applied to ListProfileObjects response to include profile objects with the specified index values.
/// This filter is only supported for ObjectTypeName _asset and _case.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectFilter {
    /// <p>A searchable identifier of a standard profile object. The predefined keys you can use to search for _asset include: _assetId, _assetName, _serialNumber.
    /// The predefined keys you can use to search for _case include: _caseId.</p>
    pub key_name: std::option::Option<std::string::String>,
    /// <p>A list of key values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for ObjectFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectFilter");
        formatter.field("key_name", &self.key_name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ObjectFilter`](crate::model::ObjectFilter)
pub mod object_filter {
    /// A builder for [`ObjectFilter`](crate::model::ObjectFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key_name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>A searchable identifier of a standard profile object. The predefined keys you can use to search for _asset include: _assetId, _assetName, _serialNumber.
        /// The predefined keys you can use to search for _case include: _caseId.</p>
        pub fn key_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_name = Some(input.into());
            self
        }
        /// <p>A searchable identifier of a standard profile object. The predefined keys you can use to search for _asset include: _assetId, _assetName, _serialNumber.
        /// The predefined keys you can use to search for _case include: _caseId.</p>
        pub fn set_key_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of key values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of key values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectFilter`](crate::model::ObjectFilter)
        pub fn build(self) -> crate::model::ObjectFilter {
            crate::model::ObjectFilter {
                key_name: self.key_name,
                values: self.values,
            }
        }
    }
}
impl ObjectFilter {
    /// Creates a new builder-style object to manufacture [`ObjectFilter`](crate::model::ObjectFilter)
    pub fn builder() -> crate::model::object_filter::Builder {
        crate::model::object_filter::Builder::default()
    }
}

/// <p>An integration in list of integrations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListIntegrationItem {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The URI of the S3 bucket or any other type of data source.</p>
    pub uri: std::option::Option<std::string::String>,
    /// <p>The name of the profile object type.</p>
    pub object_type_name: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListIntegrationItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListIntegrationItem");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("uri", &self.uri);
        formatter.field("object_type_name", &self.object_type_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListIntegrationItem`](crate::model::ListIntegrationItem)
pub mod list_integration_item {
    /// A builder for [`ListIntegrationItem`](crate::model::ListIntegrationItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) object_type_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// <p>The URI of the S3 bucket or any other type of data source.</p>
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn object_type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.object_type_name = Some(input.into());
            self
        }
        /// <p>The name of the profile object type.</p>
        pub fn set_object_type_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.object_type_name = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIntegrationItem`](crate::model::ListIntegrationItem)
        pub fn build(self) -> crate::model::ListIntegrationItem {
            crate::model::ListIntegrationItem {
                domain_name: self.domain_name,
                uri: self.uri,
                object_type_name: self.object_type_name,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl ListIntegrationItem {
    /// Creates a new builder-style object to manufacture [`ListIntegrationItem`](crate::model::ListIntegrationItem)
    pub fn builder() -> crate::model::list_integration_item::Builder {
        crate::model::list_integration_item::Builder::default()
    }
}

/// <p>An object in a list that represents a domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDomainItem {
    /// <p>The unique name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
    /// <p>The timestamp of when the domain was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of when the domain was most recently edited.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The tags used to organize, track, or control access for this resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for ListDomainItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDomainItem");
        formatter.field("domain_name", &self.domain_name);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListDomainItem`](crate::model::ListDomainItem)
pub mod list_domain_item {
    /// A builder for [`ListDomainItem`](crate::model::ListDomainItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The unique name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The unique name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The timestamp of when the domain was most recently edited.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDomainItem`](crate::model::ListDomainItem)
        pub fn build(self) -> crate::model::ListDomainItem {
            crate::model::ListDomainItem {
                domain_name: self.domain_name,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                tags: self.tags,
            }
        }
    }
}
impl ListDomainItem {
    /// Creates a new builder-style object to manufacture [`ListDomainItem`](crate::model::ListDomainItem)
    pub fn builder() -> crate::model::list_domain_item::Builder {
        crate::model::list_domain_item::Builder::default()
    }
}

/// <p>The Match group object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchItem {
    /// <p>The unique identifiers for this group of profiles that match.</p>
    pub match_id: std::option::Option<std::string::String>,
    /// <p>A list of identifiers for profiles that match.</p>
    pub profile_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for MatchItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchItem");
        formatter.field("match_id", &self.match_id);
        formatter.field("profile_ids", &self.profile_ids);
        formatter.finish()
    }
}
/// See [`MatchItem`](crate::model::MatchItem)
pub mod match_item {
    /// A builder for [`MatchItem`](crate::model::MatchItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) match_id: std::option::Option<std::string::String>,
        pub(crate) profile_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique identifiers for this group of profiles that match.</p>
        pub fn match_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.match_id = Some(input.into());
            self
        }
        /// <p>The unique identifiers for this group of profiles that match.</p>
        pub fn set_match_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.match_id = input;
            self
        }
        /// Appends an item to `profile_ids`.
        ///
        /// To override the contents of this collection use [`set_profile_ids`](Self::set_profile_ids).
        ///
        /// <p>A list of identifiers for profiles that match.</p>
        pub fn profile_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.profile_ids.unwrap_or_default();
            v.push(input.into());
            self.profile_ids = Some(v);
            self
        }
        /// <p>A list of identifiers for profiles that match.</p>
        pub fn set_profile_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.profile_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchItem`](crate::model::MatchItem)
        pub fn build(self) -> crate::model::MatchItem {
            crate::model::MatchItem {
                match_id: self.match_id,
                profile_ids: self.profile_ids,
            }
        }
    }
}
impl MatchItem {
    /// Creates a new builder-style object to manufacture [`MatchItem`](crate::model::MatchItem)
    pub fn builder() -> crate::model::match_item::Builder {
        crate::model::match_item::Builder::default()
    }
}

/// <p>Usage-specific statistics about the domain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainStats {
    /// <p>The total number of profiles currently in the domain.</p>
    pub profile_count: i64,
    /// <p>The number of profiles that you are currently paying for in the domain. If you have more
    /// than 100 objects associated with a single profile, that profile counts as two profiles. If
    /// you have more than 200 objects, that profile counts as three, and so on.</p>
    pub metering_profile_count: i64,
    /// <p>The total number of objects in domain.</p>
    pub object_count: i64,
    /// <p>The total size, in bytes, of all objects in the domain.</p>
    pub total_size: i64,
}
impl std::fmt::Debug for DomainStats {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainStats");
        formatter.field("profile_count", &self.profile_count);
        formatter.field("metering_profile_count", &self.metering_profile_count);
        formatter.field("object_count", &self.object_count);
        formatter.field("total_size", &self.total_size);
        formatter.finish()
    }
}
/// See [`DomainStats`](crate::model::DomainStats)
pub mod domain_stats {
    /// A builder for [`DomainStats`](crate::model::DomainStats)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) profile_count: std::option::Option<i64>,
        pub(crate) metering_profile_count: std::option::Option<i64>,
        pub(crate) object_count: std::option::Option<i64>,
        pub(crate) total_size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of profiles currently in the domain.</p>
        pub fn profile_count(mut self, input: i64) -> Self {
            self.profile_count = Some(input);
            self
        }
        /// <p>The total number of profiles currently in the domain.</p>
        pub fn set_profile_count(mut self, input: std::option::Option<i64>) -> Self {
            self.profile_count = input;
            self
        }
        /// <p>The number of profiles that you are currently paying for in the domain. If you have more
        /// than 100 objects associated with a single profile, that profile counts as two profiles. If
        /// you have more than 200 objects, that profile counts as three, and so on.</p>
        pub fn metering_profile_count(mut self, input: i64) -> Self {
            self.metering_profile_count = Some(input);
            self
        }
        /// <p>The number of profiles that you are currently paying for in the domain. If you have more
        /// than 100 objects associated with a single profile, that profile counts as two profiles. If
        /// you have more than 200 objects, that profile counts as three, and so on.</p>
        pub fn set_metering_profile_count(mut self, input: std::option::Option<i64>) -> Self {
            self.metering_profile_count = input;
            self
        }
        /// <p>The total number of objects in domain.</p>
        pub fn object_count(mut self, input: i64) -> Self {
            self.object_count = Some(input);
            self
        }
        /// <p>The total number of objects in domain.</p>
        pub fn set_object_count(mut self, input: std::option::Option<i64>) -> Self {
            self.object_count = input;
            self
        }
        /// <p>The total size, in bytes, of all objects in the domain.</p>
        pub fn total_size(mut self, input: i64) -> Self {
            self.total_size = Some(input);
            self
        }
        /// <p>The total size, in bytes, of all objects in the domain.</p>
        pub fn set_total_size(mut self, input: std::option::Option<i64>) -> Self {
            self.total_size = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainStats`](crate::model::DomainStats)
        pub fn build(self) -> crate::model::DomainStats {
            crate::model::DomainStats {
                profile_count: self.profile_count.unwrap_or_default(),
                metering_profile_count: self.metering_profile_count.unwrap_or_default(),
                object_count: self.object_count.unwrap_or_default(),
                total_size: self.total_size.unwrap_or_default(),
            }
        }
    }
}
impl DomainStats {
    /// Creates a new builder-style object to manufacture [`DomainStats`](crate::model::DomainStats)
    pub fn builder() -> crate::model::domain_stats::Builder {
        crate::model::domain_stats::Builder::default()
    }
}
