// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddProfileKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddProfileKeyError {
    /// Kind of error that occurred.
    pub kind: AddProfileKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddProfileKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddProfileKeyErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddProfileKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddProfileKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AddProfileKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AddProfileKeyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AddProfileKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddProfileKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AddProfileKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddProfileKeyError {
    fn code(&self) -> Option<&str> {
        AddProfileKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddProfileKeyError {
    /// Creates a new `AddProfileKeyError`.
    pub fn new(kind: AddProfileKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddProfileKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddProfileKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddProfileKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddProfileKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `AddProfileKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, AddProfileKeyErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `AddProfileKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, AddProfileKeyErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `AddProfileKeyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddProfileKeyErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `AddProfileKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddProfileKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `AddProfileKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AddProfileKeyErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for AddProfileKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddProfileKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AddProfileKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            AddProfileKeyErrorKind::InternalServerException(_inner) => Some(_inner),
            AddProfileKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddProfileKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            AddProfileKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDomainError {
    /// Kind of error that occurred.
    pub kind: CreateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDomainErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDomainError {
    fn code(&self) -> Option<&str> {
        CreateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDomainError {
    /// Creates a new `CreateDomainError`.
    pub fn new(kind: CreateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDomainErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDomainErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProfileError {
    /// Kind of error that occurred.
    pub kind: CreateProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProfileErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProfileError {
    fn code(&self) -> Option<&str> {
        CreateProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProfileError {
    /// Creates a new `CreateProfileError`.
    pub fn new(kind: CreateProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateProfileErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateProfileErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateProfileErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateProfileErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDomainError {
    /// Kind of error that occurred.
    pub kind: DeleteDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDomainErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDomainError {
    fn code(&self) -> Option<&str> {
        DeleteDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDomainError {
    /// Creates a new `DeleteDomainError`.
    pub fn new(kind: DeleteDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDomainErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDomainErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntegrationError {
    /// Kind of error that occurred.
    pub kind: DeleteIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntegrationError {
    fn code(&self) -> Option<&str> {
        DeleteIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntegrationError {
    /// Creates a new `DeleteIntegrationError`.
    pub fn new(kind: DeleteIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProfileErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteProfileErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProfileError {
    fn code(&self) -> Option<&str> {
        DeleteProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProfileError {
    /// Creates a new `DeleteProfileError`.
    pub fn new(kind: DeleteProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteProfileErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteProfileErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteProfileErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `DeleteProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteProfileErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteProfileErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProfileKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProfileKeyError {
    /// Kind of error that occurred.
    pub kind: DeleteProfileKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProfileKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProfileKeyErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProfileKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProfileKeyErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteProfileKeyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteProfileKeyErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteProfileKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProfileKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProfileKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProfileKeyError {
    fn code(&self) -> Option<&str> {
        DeleteProfileKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProfileKeyError {
    /// Creates a new `DeleteProfileKeyError`.
    pub fn new(kind: DeleteProfileKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProfileKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProfileKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProfileKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProfileKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProfileKeyErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileKeyErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileKeyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileKeyErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileKeyErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileKeyErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteProfileKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProfileKeyErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteProfileKeyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteProfileKeyErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteProfileKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProfileKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProfileKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProfileObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProfileObjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProfileObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProfileObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProfileObjectErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProfileObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProfileObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteProfileObjectErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteProfileObjectErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteProfileObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProfileObjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProfileObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProfileObjectError {
    fn code(&self) -> Option<&str> {
        DeleteProfileObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProfileObjectError {
    /// Creates a new `DeleteProfileObjectError`.
    pub fn new(kind: DeleteProfileObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProfileObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProfileObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProfileObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProfileObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProfileObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteProfileObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProfileObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteProfileObjectErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteProfileObjectErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteProfileObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProfileObjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProfileObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProfileObjectType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProfileObjectTypeError {
    /// Kind of error that occurred.
    pub kind: DeleteProfileObjectTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProfileObjectType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProfileObjectTypeErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProfileObjectTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProfileObjectTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteProfileObjectTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteProfileObjectTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteProfileObjectTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProfileObjectTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProfileObjectTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProfileObjectTypeError {
    fn code(&self) -> Option<&str> {
        DeleteProfileObjectTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProfileObjectTypeError {
    /// Creates a new `DeleteProfileObjectTypeError`.
    pub fn new(kind: DeleteProfileObjectTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProfileObjectTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProfileObjectTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProfileObjectTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProfileObjectTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProfileObjectTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectTypeErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProfileObjectTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProfileObjectTypeErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteProfileObjectTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProfileObjectTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteProfileObjectTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteProfileObjectTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteProfileObjectTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProfileObjectTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProfileObjectTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDomainError {
    /// Kind of error that occurred.
    pub kind: GetDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDomainErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDomainError {
    fn code(&self) -> Option<&str> {
        GetDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDomainError {
    /// Creates a new `GetDomainError`.
    pub fn new(kind: GetDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetDomainErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `GetDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetDomainErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetDomainErrorKind::BadRequestException(_inner) => Some(_inner),
            GetDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetIntegrationError {
    /// Kind of error that occurred.
    pub kind: GetIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetIntegrationError {
    fn code(&self) -> Option<&str> {
        GetIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetIntegrationError {
    /// Creates a new `GetIntegrationError`.
    pub fn new(kind: GetIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetIntegrationErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetIntegrationErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            GetIntegrationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMatchesError {
    /// Kind of error that occurred.
    pub kind: GetMatchesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMatches` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMatchesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMatchesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMatchesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMatchesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetMatchesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMatchesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMatchesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMatchesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMatchesError {
    fn code(&self) -> Option<&str> {
        GetMatchesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMatchesError {
    /// Creates a new `GetMatchesError`.
    pub fn new(kind: GetMatchesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMatchesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMatchesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMatchesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMatchesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetMatchesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetMatchesErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `GetMatchesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetMatchesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `GetMatchesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetMatchesErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `GetMatchesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMatchesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetMatchesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetMatchesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetMatchesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMatchesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMatchesErrorKind::BadRequestException(_inner) => Some(_inner),
            GetMatchesErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMatchesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMatchesErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMatchesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProfileObjectType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProfileObjectTypeError {
    /// Kind of error that occurred.
    pub kind: GetProfileObjectTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProfileObjectType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProfileObjectTypeErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProfileObjectTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProfileObjectTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProfileObjectTypeError {
    fn code(&self) -> Option<&str> {
        GetProfileObjectTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProfileObjectTypeError {
    /// Creates a new `GetProfileObjectTypeError`.
    pub fn new(kind: GetProfileObjectTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProfileObjectTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProfileObjectTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProfileObjectTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProfileObjectTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetProfileObjectTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetProfileObjectTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProfileObjectTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetProfileObjectTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            GetProfileObjectTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            GetProfileObjectTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetProfileObjectTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetProfileObjectTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProfileObjectTypeTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProfileObjectTypeTemplateError {
    /// Kind of error that occurred.
    pub kind: GetProfileObjectTypeTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProfileObjectTypeTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProfileObjectTypeTemplateErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProfileObjectTypeTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProfileObjectTypeTemplateErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeTemplateErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeTemplateErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetProfileObjectTypeTemplateErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetProfileObjectTypeTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProfileObjectTypeTemplateError {
    fn code(&self) -> Option<&str> {
        GetProfileObjectTypeTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProfileObjectTypeTemplateError {
    /// Creates a new `GetProfileObjectTypeTemplateError`.
    pub fn new(kind: GetProfileObjectTypeTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProfileObjectTypeTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProfileObjectTypeTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProfileObjectTypeTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProfileObjectTypeTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `GetProfileObjectTypeTemplateErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeTemplateErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeTemplateErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeTemplateErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeTemplateErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeTemplateErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `GetProfileObjectTypeTemplateErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProfileObjectTypeTemplateErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetProfileObjectTypeTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProfileObjectTypeTemplateErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetProfileObjectTypeTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetProfileObjectTypeTemplateErrorKind::InternalServerException(_inner) => Some(_inner),
            GetProfileObjectTypeTemplateErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetProfileObjectTypeTemplateErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetProfileObjectTypeTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAccountIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAccountIntegrationsError {
    /// Kind of error that occurred.
    pub kind: ListAccountIntegrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAccountIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAccountIntegrationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAccountIntegrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAccountIntegrationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListAccountIntegrationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListAccountIntegrationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListAccountIntegrationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAccountIntegrationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAccountIntegrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAccountIntegrationsError {
    fn code(&self) -> Option<&str> {
        ListAccountIntegrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAccountIntegrationsError {
    /// Creates a new `ListAccountIntegrationsError`.
    pub fn new(kind: ListAccountIntegrationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAccountIntegrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAccountIntegrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAccountIntegrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAccountIntegrationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListAccountIntegrationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountIntegrationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListAccountIntegrationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountIntegrationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListAccountIntegrationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountIntegrationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListAccountIntegrationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountIntegrationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListAccountIntegrationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAccountIntegrationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAccountIntegrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAccountIntegrationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListAccountIntegrationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListAccountIntegrationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListAccountIntegrationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAccountIntegrationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAccountIntegrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDomainsError {
    /// Kind of error that occurred.
    pub kind: ListDomainsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDomains` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDomainsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDomainsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDomainsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDomainsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDomainsError {
    fn code(&self) -> Option<&str> {
        ListDomainsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDomainsError {
    /// Creates a new `ListDomainsError`.
    pub fn new(kind: ListDomainsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDomainsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDomainsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDomainsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDomainsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListDomainsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `ListDomainsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `ListDomainsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDomainsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListDomainsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListDomainsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListDomainsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDomainsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDomainsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListDomainsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDomainsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDomainsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDomainsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIntegrationsError {
    /// Kind of error that occurred.
    pub kind: ListIntegrationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIntegrations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIntegrationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIntegrationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIntegrationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListIntegrationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListIntegrationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListIntegrationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListIntegrationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIntegrationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIntegrationsError {
    fn code(&self) -> Option<&str> {
        ListIntegrationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIntegrationsError {
    /// Creates a new `ListIntegrationsError`.
    pub fn new(kind: ListIntegrationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIntegrationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIntegrationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIntegrationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIntegrationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListIntegrationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListIntegrationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListIntegrationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListIntegrationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListIntegrationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListIntegrationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIntegrationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListIntegrationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListIntegrationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListIntegrationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIntegrationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIntegrationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProfileObjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProfileObjectsError {
    /// Kind of error that occurred.
    pub kind: ListProfileObjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProfileObjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProfileObjectsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProfileObjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProfileObjectsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProfileObjectsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListProfileObjectsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListProfileObjectsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProfileObjectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProfileObjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProfileObjectsError {
    fn code(&self) -> Option<&str> {
        ListProfileObjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProfileObjectsError {
    /// Creates a new `ListProfileObjectsError`.
    pub fn new(kind: ListProfileObjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProfileObjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProfileObjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProfileObjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProfileObjectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProfileObjectsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectsErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListProfileObjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProfileObjectsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProfileObjectsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListProfileObjectsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListProfileObjectsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProfileObjectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProfileObjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProfileObjectTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProfileObjectTypesError {
    /// Kind of error that occurred.
    pub kind: ListProfileObjectTypesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProfileObjectTypes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProfileObjectTypesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProfileObjectTypesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProfileObjectTypesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProfileObjectTypesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListProfileObjectTypesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListProfileObjectTypesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProfileObjectTypesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProfileObjectTypesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProfileObjectTypesError {
    fn code(&self) -> Option<&str> {
        ListProfileObjectTypesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProfileObjectTypesError {
    /// Creates a new `ListProfileObjectTypesError`.
    pub fn new(kind: ListProfileObjectTypesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProfileObjectTypesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProfileObjectTypesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProfileObjectTypesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProfileObjectTypesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProfileObjectTypesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListProfileObjectTypesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProfileObjectTypesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProfileObjectTypesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListProfileObjectTypesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListProfileObjectTypesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProfileObjectTypesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProfileObjectTypesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProfileObjectTypeTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProfileObjectTypeTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListProfileObjectTypeTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProfileObjectTypeTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProfileObjectTypeTemplatesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProfileObjectTypeTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProfileObjectTypeTemplatesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProfileObjectTypeTemplatesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListProfileObjectTypeTemplatesErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListProfileObjectTypeTemplatesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListProfileObjectTypeTemplatesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProfileObjectTypeTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProfileObjectTypeTemplatesError {
    fn code(&self) -> Option<&str> {
        ListProfileObjectTypeTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProfileObjectTypeTemplatesError {
    /// Creates a new `ListProfileObjectTypeTemplatesError`.
    pub fn new(
        kind: ListProfileObjectTypeTemplatesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProfileObjectTypeTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProfileObjectTypeTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProfileObjectTypeTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProfileObjectTypeTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProfileObjectTypeTemplatesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypeTemplatesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypeTemplatesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypeTemplatesErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypeTemplatesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypeTemplatesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypeTemplatesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypeTemplatesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListProfileObjectTypeTemplatesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProfileObjectTypeTemplatesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListProfileObjectTypeTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProfileObjectTypeTemplatesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProfileObjectTypeTemplatesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListProfileObjectTypeTemplatesErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            ListProfileObjectTypeTemplatesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListProfileObjectTypeTemplatesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProfileObjectTypeTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `MergeProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct MergeProfilesError {
    /// Kind of error that occurred.
    pub kind: MergeProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `MergeProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum MergeProfilesErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for MergeProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            MergeProfilesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            MergeProfilesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            MergeProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            MergeProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            MergeProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for MergeProfilesError {
    fn code(&self) -> Option<&str> {
        MergeProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl MergeProfilesError {
    /// Creates a new `MergeProfilesError`.
    pub fn new(kind: MergeProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `MergeProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: MergeProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `MergeProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: MergeProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `MergeProfilesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, MergeProfilesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `MergeProfilesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeProfilesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `MergeProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            MergeProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `MergeProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, MergeProfilesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for MergeProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            MergeProfilesErrorKind::BadRequestException(_inner) => Some(_inner),
            MergeProfilesErrorKind::InternalServerException(_inner) => Some(_inner),
            MergeProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            MergeProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            MergeProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutIntegrationError {
    /// Kind of error that occurred.
    pub kind: PutIntegrationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutIntegration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutIntegrationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutIntegrationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutIntegrationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutIntegrationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutIntegrationError {
    fn code(&self) -> Option<&str> {
        PutIntegrationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutIntegrationError {
    /// Creates a new `PutIntegrationError`.
    pub fn new(kind: PutIntegrationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutIntegrationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutIntegrationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutIntegrationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutIntegrationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutIntegrationErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutIntegrationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutIntegrationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, PutIntegrationErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for PutIntegrationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutIntegrationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutIntegrationErrorKind::BadRequestException(_inner) => Some(_inner),
            PutIntegrationErrorKind::InternalServerException(_inner) => Some(_inner),
            PutIntegrationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutIntegrationErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutIntegrationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutProfileObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutProfileObjectError {
    /// Kind of error that occurred.
    pub kind: PutProfileObjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutProfileObject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutProfileObjectErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutProfileObjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutProfileObjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutProfileObjectErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutProfileObjectErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutProfileObjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutProfileObjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutProfileObjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutProfileObjectError {
    fn code(&self) -> Option<&str> {
        PutProfileObjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutProfileObjectError {
    /// Creates a new `PutProfileObjectError`.
    pub fn new(kind: PutProfileObjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutProfileObjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutProfileObjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutProfileObjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutProfileObjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutProfileObjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for PutProfileObjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutProfileObjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutProfileObjectErrorKind::BadRequestException(_inner) => Some(_inner),
            PutProfileObjectErrorKind::InternalServerException(_inner) => Some(_inner),
            PutProfileObjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutProfileObjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutProfileObjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutProfileObjectType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutProfileObjectTypeError {
    /// Kind of error that occurred.
    pub kind: PutProfileObjectTypeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutProfileObjectType` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutProfileObjectTypeErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutProfileObjectTypeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutProfileObjectTypeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            PutProfileObjectTypeErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutProfileObjectTypeErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PutProfileObjectTypeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PutProfileObjectTypeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            PutProfileObjectTypeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutProfileObjectTypeError {
    fn code(&self) -> Option<&str> {
        PutProfileObjectTypeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutProfileObjectTypeError {
    /// Creates a new `PutProfileObjectTypeError`.
    pub fn new(kind: PutProfileObjectTypeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutProfileObjectTypeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutProfileObjectTypeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutProfileObjectTypeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutProfileObjectTypeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `PutProfileObjectTypeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectTypeErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectTypeErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectTypeErrorKind::BadRequestException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectTypeErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectTypeErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectTypeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectTypeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `PutProfileObjectTypeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutProfileObjectTypeErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for PutProfileObjectTypeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutProfileObjectTypeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            PutProfileObjectTypeErrorKind::BadRequestException(_inner) => Some(_inner),
            PutProfileObjectTypeErrorKind::InternalServerException(_inner) => Some(_inner),
            PutProfileObjectTypeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PutProfileObjectTypeErrorKind::ThrottlingException(_inner) => Some(_inner),
            PutProfileObjectTypeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SearchProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchProfilesError {
    /// Kind of error that occurred.
    pub kind: SearchProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchProfilesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchProfilesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SearchProfilesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            SearchProfilesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SearchProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SearchProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SearchProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchProfilesError {
    fn code(&self) -> Option<&str> {
        SearchProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchProfilesError {
    /// Creates a new `SearchProfilesError`.
    pub fn new(kind: SearchProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `SearchProfilesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchProfilesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `SearchProfilesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, SearchProfilesErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `SearchProfilesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchProfilesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `SearchProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `SearchProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SearchProfilesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for SearchProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchProfilesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SearchProfilesErrorKind::BadRequestException(_inner) => Some(_inner),
            SearchProfilesErrorKind::InternalServerException(_inner) => Some(_inner),
            SearchProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SearchProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            SearchProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDomainError {
    /// Kind of error that occurred.
    pub kind: UpdateDomainErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDomain` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDomainErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDomainError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDomainErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDomainErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDomainError {
    fn code(&self) -> Option<&str> {
        UpdateDomainError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDomainError {
    /// Creates a new `UpdateDomainError`.
    pub fn new(kind: UpdateDomainErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDomainError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDomainErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDomainError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDomainErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDomainErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateDomainErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateDomainErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDomainErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDomainErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateDomainErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateDomainError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDomainErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDomainErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateDomainErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDomainErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDomainErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDomainErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateProfileErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The input you provided is invalid.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>An internal service error occurred.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The requested resource does not exist, or access was denied.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>You exceeded the maximum number of requests.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateProfileError {
    fn code(&self) -> Option<&str> {
        UpdateProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateProfileError {
    /// Creates a new `UpdateProfileError`.
    pub fn new(kind: UpdateProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateProfileErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateProfileErrorKind::BadRequestException(_))
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfileErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateProfileErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateProfileErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateProfileErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>You exceeded the maximum number of requests.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The requested resource does not exist, or access was denied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An internal service error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The input you provided is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
