// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Use the split charge rule to split the cost of one Cost Category value across several other target values. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategorySplitChargeRule {
    /// <p>The Cost Category value that you want to split. That value can't be used as a source or a target in other split charge rules. To indicate uncategorized costs, you can use an empty string as the source.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules. </p>
    pub targets: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The method that's used to define how to split your source costs across your targets. </p>
    /// <p> <code>Proportional</code> - Allocates charges across your targets based on the proportional weighted cost of each target.</p>
    /// <p> <code>Fixed</code> - Allocates charges across your targets based on your defined allocation percentage.</p>
    /// <p>&gt;<code>Even</code> - Allocates costs evenly across all targets.</p>
    pub method: std::option::Option<crate::model::CostCategorySplitChargeMethod>,
    /// <p>The parameters for a split charge method. This is only required for the <code>FIXED</code> method. </p>
    pub parameters:
        std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRuleParameter>>,
}
impl CostCategorySplitChargeRule {
    /// <p>The Cost Category value that you want to split. That value can't be used as a source or a target in other split charge rules. To indicate uncategorized costs, you can use an empty string as the source.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules. </p>
    pub fn targets(&self) -> std::option::Option<&[std::string::String]> {
        self.targets.as_deref()
    }
    /// <p>The method that's used to define how to split your source costs across your targets. </p>
    /// <p> <code>Proportional</code> - Allocates charges across your targets based on the proportional weighted cost of each target.</p>
    /// <p> <code>Fixed</code> - Allocates charges across your targets based on your defined allocation percentage.</p>
    /// <p>&gt;<code>Even</code> - Allocates costs evenly across all targets.</p>
    pub fn method(&self) -> std::option::Option<&crate::model::CostCategorySplitChargeMethod> {
        self.method.as_ref()
    }
    /// <p>The parameters for a split charge method. This is only required for the <code>FIXED</code> method. </p>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&[crate::model::CostCategorySplitChargeRuleParameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for CostCategorySplitChargeRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategorySplitChargeRule");
        formatter.field("source", &self.source);
        formatter.field("targets", &self.targets);
        formatter.field("method", &self.method);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`CostCategorySplitChargeRule`](crate::model::CostCategorySplitChargeRule)
pub mod cost_category_split_charge_rule {
    /// A builder for [`CostCategorySplitChargeRule`](crate::model::CostCategorySplitChargeRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) targets: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) method: std::option::Option<crate::model::CostCategorySplitChargeMethod>,
        pub(crate) parameters:
            std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRuleParameter>>,
    }
    impl Builder {
        /// <p>The Cost Category value that you want to split. That value can't be used as a source or a target in other split charge rules. To indicate uncategorized costs, you can use an empty string as the source.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The Cost Category value that you want to split. That value can't be used as a source or a target in other split charge rules. To indicate uncategorized costs, you can use an empty string as the source.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>The Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules. </p>
        pub fn targets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>The Cost Category values that you want to split costs across. These values can't be used as a source in other split charge rules. </p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>The method that's used to define how to split your source costs across your targets. </p>
        /// <p> <code>Proportional</code> - Allocates charges across your targets based on the proportional weighted cost of each target.</p>
        /// <p> <code>Fixed</code> - Allocates charges across your targets based on your defined allocation percentage.</p>
        /// <p>&gt;<code>Even</code> - Allocates costs evenly across all targets.</p>
        pub fn method(mut self, input: crate::model::CostCategorySplitChargeMethod) -> Self {
            self.method = Some(input);
            self
        }
        /// <p>The method that's used to define how to split your source costs across your targets. </p>
        /// <p> <code>Proportional</code> - Allocates charges across your targets based on the proportional weighted cost of each target.</p>
        /// <p> <code>Fixed</code> - Allocates charges across your targets based on your defined allocation percentage.</p>
        /// <p>&gt;<code>Even</code> - Allocates costs evenly across all targets.</p>
        pub fn set_method(
            mut self,
            input: std::option::Option<crate::model::CostCategorySplitChargeMethod>,
        ) -> Self {
            self.method = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for a split charge method. This is only required for the <code>FIXED</code> method. </p>
        pub fn parameters(
            mut self,
            input: crate::model::CostCategorySplitChargeRuleParameter,
        ) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>The parameters for a split charge method. This is only required for the <code>FIXED</code> method. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::CostCategorySplitChargeRuleParameter>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategorySplitChargeRule`](crate::model::CostCategorySplitChargeRule)
        pub fn build(self) -> crate::model::CostCategorySplitChargeRule {
            crate::model::CostCategorySplitChargeRule {
                source: self.source,
                targets: self.targets,
                method: self.method,
                parameters: self.parameters,
            }
        }
    }
}
impl CostCategorySplitChargeRule {
    /// Creates a new builder-style object to manufacture [`CostCategorySplitChargeRule`](crate::model::CostCategorySplitChargeRule)
    pub fn builder() -> crate::model::cost_category_split_charge_rule::Builder {
        crate::model::cost_category_split_charge_rule::Builder::default()
    }
}

/// <p>The parameters for a split charge method. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategorySplitChargeRuleParameter {
    /// <p>The parameter type. </p>
    pub r#type: std::option::Option<crate::model::CostCategorySplitChargeRuleParameterType>,
    /// <p>The parameter values. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CostCategorySplitChargeRuleParameter {
    /// <p>The parameter type. </p>
    pub fn r#type(
        &self,
    ) -> std::option::Option<&crate::model::CostCategorySplitChargeRuleParameterType> {
        self.r#type.as_ref()
    }
    /// <p>The parameter values. </p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for CostCategorySplitChargeRuleParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategorySplitChargeRuleParameter");
        formatter.field("r#type", &self.r#type);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`CostCategorySplitChargeRuleParameter`](crate::model::CostCategorySplitChargeRuleParameter)
pub mod cost_category_split_charge_rule_parameter {
    /// A builder for [`CostCategorySplitChargeRuleParameter`](crate::model::CostCategorySplitChargeRuleParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type:
            std::option::Option<crate::model::CostCategorySplitChargeRuleParameterType>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The parameter type. </p>
        pub fn r#type(
            mut self,
            input: crate::model::CostCategorySplitChargeRuleParameterType,
        ) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The parameter type. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CostCategorySplitChargeRuleParameterType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The parameter values. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The parameter values. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategorySplitChargeRuleParameter`](crate::model::CostCategorySplitChargeRuleParameter)
        pub fn build(self) -> crate::model::CostCategorySplitChargeRuleParameter {
            crate::model::CostCategorySplitChargeRuleParameter {
                r#type: self.r#type,
                values: self.values,
            }
        }
    }
}
impl CostCategorySplitChargeRuleParameter {
    /// Creates a new builder-style object to manufacture [`CostCategorySplitChargeRuleParameter`](crate::model::CostCategorySplitChargeRuleParameter)
    pub fn builder() -> crate::model::cost_category_split_charge_rule_parameter::Builder {
        crate::model::cost_category_split_charge_rule_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostCategorySplitChargeRuleParameterType {
    #[allow(missing_docs)] // documentation missing in model
    AllocationPercentages,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostCategorySplitChargeRuleParameterType {
    fn from(s: &str) -> Self {
        match s {
            "ALLOCATION_PERCENTAGES" => {
                CostCategorySplitChargeRuleParameterType::AllocationPercentages
            }
            other => CostCategorySplitChargeRuleParameterType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostCategorySplitChargeRuleParameterType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostCategorySplitChargeRuleParameterType::from(s))
    }
}
impl CostCategorySplitChargeRuleParameterType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostCategorySplitChargeRuleParameterType::AllocationPercentages => {
                "ALLOCATION_PERCENTAGES"
            }
            CostCategorySplitChargeRuleParameterType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALLOCATION_PERCENTAGES"]
    }
}
impl AsRef<str> for CostCategorySplitChargeRuleParameterType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostCategorySplitChargeMethod {
    #[allow(missing_docs)] // documentation missing in model
    Even,
    #[allow(missing_docs)] // documentation missing in model
    Fixed,
    #[allow(missing_docs)] // documentation missing in model
    Proportional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostCategorySplitChargeMethod {
    fn from(s: &str) -> Self {
        match s {
            "EVEN" => CostCategorySplitChargeMethod::Even,
            "FIXED" => CostCategorySplitChargeMethod::Fixed,
            "PROPORTIONAL" => CostCategorySplitChargeMethod::Proportional,
            other => CostCategorySplitChargeMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostCategorySplitChargeMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostCategorySplitChargeMethod::from(s))
    }
}
impl CostCategorySplitChargeMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostCategorySplitChargeMethod::Even => "EVEN",
            CostCategorySplitChargeMethod::Fixed => "FIXED",
            CostCategorySplitChargeMethod::Proportional => "PROPORTIONAL",
            CostCategorySplitChargeMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EVEN", "FIXED", "PROPORTIONAL"]
    }
}
impl AsRef<str> for CostCategorySplitChargeMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategoryRule {
    /// <p>The default value for the cost category.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>An <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>, and <code>LINKED_ACCOUNT_NAME</code>.</p>
    /// <p>Root level <code>OR</code> isn't supported. We recommend that you create a separate rule instead.</p>
    /// <p> <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost Category expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON editor. For a detailed comparison, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms">Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    pub rule: std::option::Option<crate::model::Expression>,
    /// <p>The value the line item is categorized as if the line item contains the matched dimension.</p>
    pub inherited_value: std::option::Option<crate::model::CostCategoryInheritedValueDimension>,
    /// <p>You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility of defining a rule that dynamically inherits the cost category value from the dimension value defined by <code>CostCategoryInheritedValueDimension</code>. For example, if you want to dynamically group costs based on the value of a specific tag key, first choose an inherited value rule type, then choose the tag dimension and specify the tag key to use.</p>
    pub r#type: std::option::Option<crate::model::CostCategoryRuleType>,
}
impl CostCategoryRule {
    /// <p>The default value for the cost category.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>An <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>, and <code>LINKED_ACCOUNT_NAME</code>.</p>
    /// <p>Root level <code>OR</code> isn't supported. We recommend that you create a separate rule instead.</p>
    /// <p> <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost Category expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON editor. For a detailed comparison, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms">Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    pub fn rule(&self) -> std::option::Option<&crate::model::Expression> {
        self.rule.as_ref()
    }
    /// <p>The value the line item is categorized as if the line item contains the matched dimension.</p>
    pub fn inherited_value(
        &self,
    ) -> std::option::Option<&crate::model::CostCategoryInheritedValueDimension> {
        self.inherited_value.as_ref()
    }
    /// <p>You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility of defining a rule that dynamically inherits the cost category value from the dimension value defined by <code>CostCategoryInheritedValueDimension</code>. For example, if you want to dynamically group costs based on the value of a specific tag key, first choose an inherited value rule type, then choose the tag dimension and specify the tag key to use.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::CostCategoryRuleType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for CostCategoryRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategoryRule");
        formatter.field("value", &self.value);
        formatter.field("rule", &self.rule);
        formatter.field("inherited_value", &self.inherited_value);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`CostCategoryRule`](crate::model::CostCategoryRule)
pub mod cost_category_rule {
    /// A builder for [`CostCategoryRule`](crate::model::CostCategoryRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) rule: std::option::Option<crate::model::Expression>,
        pub(crate) inherited_value:
            std::option::Option<crate::model::CostCategoryInheritedValueDimension>,
        pub(crate) r#type: std::option::Option<crate::model::CostCategoryRuleType>,
    }
    impl Builder {
        /// <p>The default value for the cost category.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>An <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>, and <code>LINKED_ACCOUNT_NAME</code>.</p>
        /// <p>Root level <code>OR</code> isn't supported. We recommend that you create a separate rule instead.</p>
        /// <p> <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost Category expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON editor. For a detailed comparison, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms">Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.</p>
        pub fn rule(mut self, input: crate::model::Expression) -> Self {
            self.rule = Some(input);
            self
        }
        /// <p>An <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object used to categorize costs. This supports dimensions, tags, and nested expressions. Currently the only dimensions supported are <code>LINKED_ACCOUNT</code>, <code>SERVICE_CODE</code>, <code>RECORD_TYPE</code>, and <code>LINKED_ACCOUNT_NAME</code>.</p>
        /// <p>Root level <code>OR</code> isn't supported. We recommend that you create a separate rule instead.</p>
        /// <p> <code>RECORD_TYPE</code> is a dimension used for Cost Explorer APIs, and is also supported for Cost Category expressions. This dimension uses different terms, depending on whether you're using the console or API/JSON editor. For a detailed comparison, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/manage-cost-categories.html#cost-categories-terms">Term Comparisons</a> in the <i>Billing and Cost Management User Guide</i>.</p>
        pub fn set_rule(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.rule = input;
            self
        }
        /// <p>The value the line item is categorized as if the line item contains the matched dimension.</p>
        pub fn inherited_value(
            mut self,
            input: crate::model::CostCategoryInheritedValueDimension,
        ) -> Self {
            self.inherited_value = Some(input);
            self
        }
        /// <p>The value the line item is categorized as if the line item contains the matched dimension.</p>
        pub fn set_inherited_value(
            mut self,
            input: std::option::Option<crate::model::CostCategoryInheritedValueDimension>,
        ) -> Self {
            self.inherited_value = input;
            self
        }
        /// <p>You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility of defining a rule that dynamically inherits the cost category value from the dimension value defined by <code>CostCategoryInheritedValueDimension</code>. For example, if you want to dynamically group costs based on the value of a specific tag key, first choose an inherited value rule type, then choose the tag dimension and specify the tag key to use.</p>
        pub fn r#type(mut self, input: crate::model::CostCategoryRuleType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>You can define the <code>CostCategoryRule</code> rule type as either <code>REGULAR</code> or <code>INHERITED_VALUE</code>. The <code>INHERITED_VALUE</code> rule type adds the flexibility of defining a rule that dynamically inherits the cost category value from the dimension value defined by <code>CostCategoryInheritedValueDimension</code>. For example, if you want to dynamically group costs based on the value of a specific tag key, first choose an inherited value rule type, then choose the tag dimension and specify the tag key to use.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::CostCategoryRuleType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategoryRule`](crate::model::CostCategoryRule)
        pub fn build(self) -> crate::model::CostCategoryRule {
            crate::model::CostCategoryRule {
                value: self.value,
                rule: self.rule,
                inherited_value: self.inherited_value,
                r#type: self.r#type,
            }
        }
    }
}
impl CostCategoryRule {
    /// Creates a new builder-style object to manufacture [`CostCategoryRule`](crate::model::CostCategoryRule)
    pub fn builder() -> crate::model::cost_category_rule::Builder {
        crate::model::cost_category_rule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostCategoryRuleType {
    #[allow(missing_docs)] // documentation missing in model
    InheritedValue,
    #[allow(missing_docs)] // documentation missing in model
    Regular,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostCategoryRuleType {
    fn from(s: &str) -> Self {
        match s {
            "INHERITED_VALUE" => CostCategoryRuleType::InheritedValue,
            "REGULAR" => CostCategoryRuleType::Regular,
            other => CostCategoryRuleType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostCategoryRuleType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostCategoryRuleType::from(s))
    }
}
impl CostCategoryRuleType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostCategoryRuleType::InheritedValue => "INHERITED_VALUE",
            CostCategoryRuleType::Regular => "REGULAR",
            CostCategoryRuleType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INHERITED_VALUE", "REGULAR"]
    }
}
impl AsRef<str> for CostCategoryRuleType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>When creating or updating a cost category, you can define the <code>CostCategoryRule</code> rule type as <code>INHERITED_VALUE</code>. This rule type adds the flexibility of defining a rule that dynamically inherits the cost category value from the dimension value defined by <code>CostCategoryInheritedValueDimension</code>. For example, if you want to dynamically group costs that are based on the value of a specific tag key, first choose an inherited value rule type, then choose the tag dimension and specify the tag key to use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategoryInheritedValueDimension {
    /// <p>The name of the dimension that's used to group costs.</p>
    /// <p>If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you specify <code>TAG</code>, the cost category value will be based on the value of the specified tag key.</p>
    pub dimension_name: std::option::Option<crate::model::CostCategoryInheritedValueDimensionName>,
    /// <p>The key to extract cost category values.</p>
    pub dimension_key: std::option::Option<std::string::String>,
}
impl CostCategoryInheritedValueDimension {
    /// <p>The name of the dimension that's used to group costs.</p>
    /// <p>If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you specify <code>TAG</code>, the cost category value will be based on the value of the specified tag key.</p>
    pub fn dimension_name(
        &self,
    ) -> std::option::Option<&crate::model::CostCategoryInheritedValueDimensionName> {
        self.dimension_name.as_ref()
    }
    /// <p>The key to extract cost category values.</p>
    pub fn dimension_key(&self) -> std::option::Option<&str> {
        self.dimension_key.as_deref()
    }
}
impl std::fmt::Debug for CostCategoryInheritedValueDimension {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategoryInheritedValueDimension");
        formatter.field("dimension_name", &self.dimension_name);
        formatter.field("dimension_key", &self.dimension_key);
        formatter.finish()
    }
}
/// See [`CostCategoryInheritedValueDimension`](crate::model::CostCategoryInheritedValueDimension)
pub mod cost_category_inherited_value_dimension {
    /// A builder for [`CostCategoryInheritedValueDimension`](crate::model::CostCategoryInheritedValueDimension)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_name:
            std::option::Option<crate::model::CostCategoryInheritedValueDimensionName>,
        pub(crate) dimension_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the dimension that's used to group costs.</p>
        /// <p>If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you specify <code>TAG</code>, the cost category value will be based on the value of the specified tag key.</p>
        pub fn dimension_name(
            mut self,
            input: crate::model::CostCategoryInheritedValueDimensionName,
        ) -> Self {
            self.dimension_name = Some(input);
            self
        }
        /// <p>The name of the dimension that's used to group costs.</p>
        /// <p>If you specify <code>LINKED_ACCOUNT_NAME</code>, the cost category value is based on account name. If you specify <code>TAG</code>, the cost category value will be based on the value of the specified tag key.</p>
        pub fn set_dimension_name(
            mut self,
            input: std::option::Option<crate::model::CostCategoryInheritedValueDimensionName>,
        ) -> Self {
            self.dimension_name = input;
            self
        }
        /// <p>The key to extract cost category values.</p>
        pub fn dimension_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_key = Some(input.into());
            self
        }
        /// <p>The key to extract cost category values.</p>
        pub fn set_dimension_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_key = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategoryInheritedValueDimension`](crate::model::CostCategoryInheritedValueDimension)
        pub fn build(self) -> crate::model::CostCategoryInheritedValueDimension {
            crate::model::CostCategoryInheritedValueDimension {
                dimension_name: self.dimension_name,
                dimension_key: self.dimension_key,
            }
        }
    }
}
impl CostCategoryInheritedValueDimension {
    /// Creates a new builder-style object to manufacture [`CostCategoryInheritedValueDimension`](crate::model::CostCategoryInheritedValueDimension)
    pub fn builder() -> crate::model::cost_category_inherited_value_dimension::Builder {
        crate::model::cost_category_inherited_value_dimension::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostCategoryInheritedValueDimensionName {
    #[allow(missing_docs)] // documentation missing in model
    LinkedAccountName,
    #[allow(missing_docs)] // documentation missing in model
    Tag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostCategoryInheritedValueDimensionName {
    fn from(s: &str) -> Self {
        match s {
            "LINKED_ACCOUNT_NAME" => CostCategoryInheritedValueDimensionName::LinkedAccountName,
            "TAG" => CostCategoryInheritedValueDimensionName::Tag,
            other => CostCategoryInheritedValueDimensionName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostCategoryInheritedValueDimensionName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostCategoryInheritedValueDimensionName::from(s))
    }
}
impl CostCategoryInheritedValueDimensionName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostCategoryInheritedValueDimensionName::LinkedAccountName => "LINKED_ACCOUNT_NAME",
            CostCategoryInheritedValueDimensionName::Tag => "TAG",
            CostCategoryInheritedValueDimensionName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINKED_ACCOUNT_NAME", "TAG"]
    }
}
impl AsRef<str> for CostCategoryInheritedValueDimensionName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
/// <ul>
/// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
/// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
/// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
/// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
/// </ul> <note>
/// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
/// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Expression {
    /// <p>Return results that match either <code>Dimension</code> object.</p>
    pub or: std::option::Option<std::vec::Vec<crate::model::Expression>>,
    /// <p>Return results that match both <code>Dimension</code> objects.</p>
    pub and: std::option::Option<std::vec::Vec<crate::model::Expression>>,
    /// <p>Return results that don't match a <code>Dimension</code> object.</p>
    pub not: std::option::Option<std::boxed::Box<crate::model::Expression>>,
    /// <p>The specific <code>Dimension</code> to use for <code>Expression</code>.</p>
    pub dimensions: std::option::Option<crate::model::DimensionValues>,
    /// <p>The specific <code>Tag</code> to use for <code>Expression</code>.</p>
    pub tags: std::option::Option<crate::model::TagValues>,
    /// <p>The filter that's based on <code>CostCategory</code> values.</p>
    pub cost_categories: std::option::Option<crate::model::CostCategoryValues>,
}
impl Expression {
    /// <p>Return results that match either <code>Dimension</code> object.</p>
    pub fn or(&self) -> std::option::Option<&[crate::model::Expression]> {
        self.or.as_deref()
    }
    /// <p>Return results that match both <code>Dimension</code> objects.</p>
    pub fn and(&self) -> std::option::Option<&[crate::model::Expression]> {
        self.and.as_deref()
    }
    /// <p>Return results that don't match a <code>Dimension</code> object.</p>
    pub fn not(&self) -> std::option::Option<&crate::model::Expression> {
        self.not.as_deref()
    }
    /// <p>The specific <code>Dimension</code> to use for <code>Expression</code>.</p>
    pub fn dimensions(&self) -> std::option::Option<&crate::model::DimensionValues> {
        self.dimensions.as_ref()
    }
    /// <p>The specific <code>Tag</code> to use for <code>Expression</code>.</p>
    pub fn tags(&self) -> std::option::Option<&crate::model::TagValues> {
        self.tags.as_ref()
    }
    /// <p>The filter that's based on <code>CostCategory</code> values.</p>
    pub fn cost_categories(&self) -> std::option::Option<&crate::model::CostCategoryValues> {
        self.cost_categories.as_ref()
    }
}
impl std::fmt::Debug for Expression {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Expression");
        formatter.field("or", &self.or);
        formatter.field("and", &self.and);
        formatter.field("not", &self.not);
        formatter.field("dimensions", &self.dimensions);
        formatter.field("tags", &self.tags);
        formatter.field("cost_categories", &self.cost_categories);
        formatter.finish()
    }
}
/// See [`Expression`](crate::model::Expression)
pub mod expression {
    /// A builder for [`Expression`](crate::model::Expression)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) or: std::option::Option<std::vec::Vec<crate::model::Expression>>,
        pub(crate) and: std::option::Option<std::vec::Vec<crate::model::Expression>>,
        pub(crate) not: std::option::Option<std::boxed::Box<crate::model::Expression>>,
        pub(crate) dimensions: std::option::Option<crate::model::DimensionValues>,
        pub(crate) tags: std::option::Option<crate::model::TagValues>,
        pub(crate) cost_categories: std::option::Option<crate::model::CostCategoryValues>,
    }
    impl Builder {
        /// Appends an item to `or`.
        ///
        /// To override the contents of this collection use [`set_or`](Self::set_or).
        ///
        /// <p>Return results that match either <code>Dimension</code> object.</p>
        pub fn or(mut self, input: crate::model::Expression) -> Self {
            let mut v = self.or.unwrap_or_default();
            v.push(input);
            self.or = Some(v);
            self
        }
        /// <p>Return results that match either <code>Dimension</code> object.</p>
        pub fn set_or(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Expression>>,
        ) -> Self {
            self.or = input;
            self
        }
        /// Appends an item to `and`.
        ///
        /// To override the contents of this collection use [`set_and`](Self::set_and).
        ///
        /// <p>Return results that match both <code>Dimension</code> objects.</p>
        pub fn and(mut self, input: crate::model::Expression) -> Self {
            let mut v = self.and.unwrap_or_default();
            v.push(input);
            self.and = Some(v);
            self
        }
        /// <p>Return results that match both <code>Dimension</code> objects.</p>
        pub fn set_and(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Expression>>,
        ) -> Self {
            self.and = input;
            self
        }
        /// <p>Return results that don't match a <code>Dimension</code> object.</p>
        pub fn not(mut self, input: impl Into<std::boxed::Box<crate::model::Expression>>) -> Self {
            self.not = Some(input.into());
            self
        }
        /// <p>Return results that don't match a <code>Dimension</code> object.</p>
        pub fn set_not(
            mut self,
            input: std::option::Option<std::boxed::Box<crate::model::Expression>>,
        ) -> Self {
            self.not = input;
            self
        }
        /// <p>The specific <code>Dimension</code> to use for <code>Expression</code>.</p>
        pub fn dimensions(mut self, input: crate::model::DimensionValues) -> Self {
            self.dimensions = Some(input);
            self
        }
        /// <p>The specific <code>Dimension</code> to use for <code>Expression</code>.</p>
        pub fn set_dimensions(
            mut self,
            input: std::option::Option<crate::model::DimensionValues>,
        ) -> Self {
            self.dimensions = input;
            self
        }
        /// <p>The specific <code>Tag</code> to use for <code>Expression</code>.</p>
        pub fn tags(mut self, input: crate::model::TagValues) -> Self {
            self.tags = Some(input);
            self
        }
        /// <p>The specific <code>Tag</code> to use for <code>Expression</code>.</p>
        pub fn set_tags(mut self, input: std::option::Option<crate::model::TagValues>) -> Self {
            self.tags = input;
            self
        }
        /// <p>The filter that's based on <code>CostCategory</code> values.</p>
        pub fn cost_categories(mut self, input: crate::model::CostCategoryValues) -> Self {
            self.cost_categories = Some(input);
            self
        }
        /// <p>The filter that's based on <code>CostCategory</code> values.</p>
        pub fn set_cost_categories(
            mut self,
            input: std::option::Option<crate::model::CostCategoryValues>,
        ) -> Self {
            self.cost_categories = input;
            self
        }
        /// Consumes the builder and constructs a [`Expression`](crate::model::Expression)
        pub fn build(self) -> crate::model::Expression {
            crate::model::Expression {
                or: self.or,
                and: self.and,
                not: self.not,
                dimensions: self.dimensions,
                tags: self.tags,
                cost_categories: self.cost_categories,
            }
        }
    }
}
impl Expression {
    /// Creates a new builder-style object to manufacture [`Expression`](crate::model::Expression)
    pub fn builder() -> crate::model::expression::Builder {
        crate::model::expression::Builder::default()
    }
}

/// <p>The Cost Categories values used for filtering the costs.</p>
/// <p>If <code>Values</code> and <code>Key</code> are not specified, the <code>ABSENT</code> <code>MatchOption</code> is applied to all Cost Categories. That is, it filters on resources that aren't mapped to any Cost Categories.</p>
/// <p>If <code>Values</code> is provided and <code>Key</code> isn't specified, the <code>ABSENT</code> <code>MatchOption</code> is applied to the Cost Categories <code>Key</code> only. That is, it filters on resources without the given Cost Categories key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategoryValues {
    /// <p>The unique name of the Cost Category.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The specific value of the Cost Category.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. </p>
    pub match_options: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
}
impl CostCategoryValues {
    /// <p>The unique name of the Cost Category.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The specific value of the Cost Category.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. </p>
    pub fn match_options(&self) -> std::option::Option<&[crate::model::MatchOption]> {
        self.match_options.as_deref()
    }
}
impl std::fmt::Debug for CostCategoryValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategoryValues");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("match_options", &self.match_options);
        formatter.finish()
    }
}
/// See [`CostCategoryValues`](crate::model::CostCategoryValues)
pub mod cost_category_values {
    /// A builder for [`CostCategoryValues`](crate::model::CostCategoryValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) match_options: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
    }
    impl Builder {
        /// <p>The unique name of the Cost Category.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The specific value of the Cost Category.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The specific value of the Cost Category.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `match_options`.
        ///
        /// To override the contents of this collection use [`set_match_options`](Self::set_match_options).
        ///
        /// <p>The match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. </p>
        pub fn match_options(mut self, input: crate::model::MatchOption) -> Self {
            let mut v = self.match_options.unwrap_or_default();
            v.push(input);
            self.match_options = Some(v);
            self
        }
        /// <p>The match options that you can use to filter your results. MatchOptions is only applicable for actions related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. </p>
        pub fn set_match_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
        ) -> Self {
            self.match_options = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategoryValues`](crate::model::CostCategoryValues)
        pub fn build(self) -> crate::model::CostCategoryValues {
            crate::model::CostCategoryValues {
                key: self.key,
                values: self.values,
                match_options: self.match_options,
            }
        }
    }
}
impl CostCategoryValues {
    /// Creates a new builder-style object to manufacture [`CostCategoryValues`](crate::model::CostCategoryValues)
    pub fn builder() -> crate::model::cost_category_values::Builder {
        crate::model::cost_category_values::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MatchOption {
    #[allow(missing_docs)] // documentation missing in model
    Absent,
    #[allow(missing_docs)] // documentation missing in model
    CaseInsensitive,
    #[allow(missing_docs)] // documentation missing in model
    CaseSensitive,
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    EndsWith,
    #[allow(missing_docs)] // documentation missing in model
    Equals,
    #[allow(missing_docs)] // documentation missing in model
    StartsWith,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MatchOption {
    fn from(s: &str) -> Self {
        match s {
            "ABSENT" => MatchOption::Absent,
            "CASE_INSENSITIVE" => MatchOption::CaseInsensitive,
            "CASE_SENSITIVE" => MatchOption::CaseSensitive,
            "CONTAINS" => MatchOption::Contains,
            "ENDS_WITH" => MatchOption::EndsWith,
            "EQUALS" => MatchOption::Equals,
            "STARTS_WITH" => MatchOption::StartsWith,
            other => MatchOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MatchOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MatchOption::from(s))
    }
}
impl MatchOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MatchOption::Absent => "ABSENT",
            MatchOption::CaseInsensitive => "CASE_INSENSITIVE",
            MatchOption::CaseSensitive => "CASE_SENSITIVE",
            MatchOption::Contains => "CONTAINS",
            MatchOption::EndsWith => "ENDS_WITH",
            MatchOption::Equals => "EQUALS",
            MatchOption::StartsWith => "STARTS_WITH",
            MatchOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ABSENT",
            "CASE_INSENSITIVE",
            "CASE_SENSITIVE",
            "CONTAINS",
            "ENDS_WITH",
            "EQUALS",
            "STARTS_WITH",
        ]
    }
}
impl AsRef<str> for MatchOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The values that are available for a tag.</p>
/// <p>If <code>Values</code> and <code>Key</code> aren't specified, the <code>ABSENT</code> <code>MatchOption</code> is applied to all tags. That is, it's filtered on resources with no tags.</p>
/// <p>If <code>Values</code> is provided and <code>Key</code> isn't specified, the <code>ABSENT</code> <code>MatchOption</code> is applied to the tag <code>Key</code> only. That is, it's filtered on resources without the given tag key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagValues {
    /// <p>The key for the tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The specific value of the tag.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    pub match_options: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
}
impl TagValues {
    /// <p>The key for the tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The specific value of the tag.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    pub fn match_options(&self) -> std::option::Option<&[crate::model::MatchOption]> {
        self.match_options.as_deref()
    }
}
impl std::fmt::Debug for TagValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagValues");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("match_options", &self.match_options);
        formatter.finish()
    }
}
/// See [`TagValues`](crate::model::TagValues)
pub mod tag_values {
    /// A builder for [`TagValues`](crate::model::TagValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) match_options: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
    }
    impl Builder {
        /// <p>The key for the tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for the tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The specific value of the tag.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The specific value of the tag.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `match_options`.
        ///
        /// To override the contents of this collection use [`set_match_options`](Self::set_match_options).
        ///
        /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        pub fn match_options(mut self, input: crate::model::MatchOption) -> Self {
            let mut v = self.match_options.unwrap_or_default();
            v.push(input);
            self.match_options = Some(v);
            self
        }
        /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        pub fn set_match_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
        ) -> Self {
            self.match_options = input;
            self
        }
        /// Consumes the builder and constructs a [`TagValues`](crate::model::TagValues)
        pub fn build(self) -> crate::model::TagValues {
            crate::model::TagValues {
                key: self.key,
                values: self.values,
                match_options: self.match_options,
            }
        }
    }
}
impl TagValues {
    /// Creates a new builder-style object to manufacture [`TagValues`](crate::model::TagValues)
    pub fn builder() -> crate::model::tag_values::Builder {
        crate::model::tag_values::Builder::default()
    }
}

/// <p>The metadata that you can use to filter and group your results. You can use <code>GetDimensionValues</code> to find specific values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionValues {
    /// <p>The names of the metadata types that you can use to filter and group your results. For example, <code>AZ</code> returns a list of Availability Zones.</p>
    pub key: std::option::Option<crate::model::Dimension>,
    /// <p>The metadata values that you can use to filter and group your results. You can use <code>GetDimensionValues</code> to find specific values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    pub match_options: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
}
impl DimensionValues {
    /// <p>The names of the metadata types that you can use to filter and group your results. For example, <code>AZ</code> returns a list of Availability Zones.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::Dimension> {
        self.key.as_ref()
    }
    /// <p>The metadata values that you can use to filter and group your results. You can use <code>GetDimensionValues</code> to find specific values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    pub fn match_options(&self) -> std::option::Option<&[crate::model::MatchOption]> {
        self.match_options.as_deref()
    }
}
impl std::fmt::Debug for DimensionValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionValues");
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.field("match_options", &self.match_options);
        formatter.finish()
    }
}
/// See [`DimensionValues`](crate::model::DimensionValues)
pub mod dimension_values {
    /// A builder for [`DimensionValues`](crate::model::DimensionValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::Dimension>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) match_options: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
    }
    impl Builder {
        /// <p>The names of the metadata types that you can use to filter and group your results. For example, <code>AZ</code> returns a list of Availability Zones.</p>
        pub fn key(mut self, input: crate::model::Dimension) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The names of the metadata types that you can use to filter and group your results. For example, <code>AZ</code> returns a list of Availability Zones.</p>
        pub fn set_key(mut self, input: std::option::Option<crate::model::Dimension>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The metadata values that you can use to filter and group your results. You can use <code>GetDimensionValues</code> to find specific values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The metadata values that you can use to filter and group your results. You can use <code>GetDimensionValues</code> to find specific values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Appends an item to `match_options`.
        ///
        /// To override the contents of this collection use [`set_match_options`](Self::set_match_options).
        ///
        /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        pub fn match_options(mut self, input: crate::model::MatchOption) -> Self {
            let mut v = self.match_options.unwrap_or_default();
            v.push(input);
            self.match_options = Some(v);
            self
        }
        /// <p>The match options that you can use to filter your results. <code>MatchOptions</code> is only applicable for actions related to Cost Category. The default values for <code>MatchOptions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        pub fn set_match_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MatchOption>>,
        ) -> Self {
            self.match_options = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionValues`](crate::model::DimensionValues)
        pub fn build(self) -> crate::model::DimensionValues {
            crate::model::DimensionValues {
                key: self.key,
                values: self.values,
                match_options: self.match_options,
            }
        }
    }
}
impl DimensionValues {
    /// Creates a new builder-style object to manufacture [`DimensionValues`](crate::model::DimensionValues)
    pub fn builder() -> crate::model::dimension_values::Builder {
        crate::model::dimension_values::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Dimension {
    #[allow(missing_docs)] // documentation missing in model
    AgreementEndDateTimeAfter,
    #[allow(missing_docs)] // documentation missing in model
    AgreementEndDateTimeBefore,
    #[allow(missing_docs)] // documentation missing in model
    Az,
    #[allow(missing_docs)] // documentation missing in model
    BillingEntity,
    #[allow(missing_docs)] // documentation missing in model
    CacheEngine,
    #[allow(missing_docs)] // documentation missing in model
    DatabaseEngine,
    #[allow(missing_docs)] // documentation missing in model
    DeploymentOption,
    #[allow(missing_docs)] // documentation missing in model
    InstanceType,
    #[allow(missing_docs)] // documentation missing in model
    InstanceTypeFamily,
    #[allow(missing_docs)] // documentation missing in model
    InvoicingEntity,
    #[allow(missing_docs)] // documentation missing in model
    LegalEntityName,
    #[allow(missing_docs)] // documentation missing in model
    LinkedAccount,
    #[allow(missing_docs)] // documentation missing in model
    LinkedAccountName,
    #[allow(missing_docs)] // documentation missing in model
    OperatingSystem,
    #[allow(missing_docs)] // documentation missing in model
    Operation,
    #[allow(missing_docs)] // documentation missing in model
    PaymentOption,
    #[allow(missing_docs)] // documentation missing in model
    Platform,
    #[allow(missing_docs)] // documentation missing in model
    PurchaseType,
    #[allow(missing_docs)] // documentation missing in model
    RecordType,
    #[allow(missing_docs)] // documentation missing in model
    Region,
    #[allow(missing_docs)] // documentation missing in model
    ReservationId,
    #[allow(missing_docs)] // documentation missing in model
    ResourceId,
    #[allow(missing_docs)] // documentation missing in model
    RightsizingType,
    #[allow(missing_docs)] // documentation missing in model
    SavingsPlansType,
    #[allow(missing_docs)] // documentation missing in model
    SavingsPlanArn,
    #[allow(missing_docs)] // documentation missing in model
    Scope,
    #[allow(missing_docs)] // documentation missing in model
    Service,
    #[allow(missing_docs)] // documentation missing in model
    ServiceCode,
    #[allow(missing_docs)] // documentation missing in model
    SubscriptionId,
    #[allow(missing_docs)] // documentation missing in model
    Tenancy,
    #[allow(missing_docs)] // documentation missing in model
    UsageType,
    #[allow(missing_docs)] // documentation missing in model
    UsageTypeGroup,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Dimension {
    fn from(s: &str) -> Self {
        match s {
            "AGREEMENT_END_DATE_TIME_AFTER" => Dimension::AgreementEndDateTimeAfter,
            "AGREEMENT_END_DATE_TIME_BEFORE" => Dimension::AgreementEndDateTimeBefore,
            "AZ" => Dimension::Az,
            "BILLING_ENTITY" => Dimension::BillingEntity,
            "CACHE_ENGINE" => Dimension::CacheEngine,
            "DATABASE_ENGINE" => Dimension::DatabaseEngine,
            "DEPLOYMENT_OPTION" => Dimension::DeploymentOption,
            "INSTANCE_TYPE" => Dimension::InstanceType,
            "INSTANCE_TYPE_FAMILY" => Dimension::InstanceTypeFamily,
            "INVOICING_ENTITY" => Dimension::InvoicingEntity,
            "LEGAL_ENTITY_NAME" => Dimension::LegalEntityName,
            "LINKED_ACCOUNT" => Dimension::LinkedAccount,
            "LINKED_ACCOUNT_NAME" => Dimension::LinkedAccountName,
            "OPERATING_SYSTEM" => Dimension::OperatingSystem,
            "OPERATION" => Dimension::Operation,
            "PAYMENT_OPTION" => Dimension::PaymentOption,
            "PLATFORM" => Dimension::Platform,
            "PURCHASE_TYPE" => Dimension::PurchaseType,
            "RECORD_TYPE" => Dimension::RecordType,
            "REGION" => Dimension::Region,
            "RESERVATION_ID" => Dimension::ReservationId,
            "RESOURCE_ID" => Dimension::ResourceId,
            "RIGHTSIZING_TYPE" => Dimension::RightsizingType,
            "SAVINGS_PLANS_TYPE" => Dimension::SavingsPlansType,
            "SAVINGS_PLAN_ARN" => Dimension::SavingsPlanArn,
            "SCOPE" => Dimension::Scope,
            "SERVICE" => Dimension::Service,
            "SERVICE_CODE" => Dimension::ServiceCode,
            "SUBSCRIPTION_ID" => Dimension::SubscriptionId,
            "TENANCY" => Dimension::Tenancy,
            "USAGE_TYPE" => Dimension::UsageType,
            "USAGE_TYPE_GROUP" => Dimension::UsageTypeGroup,
            other => Dimension::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Dimension {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Dimension::from(s))
    }
}
impl Dimension {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Dimension::AgreementEndDateTimeAfter => "AGREEMENT_END_DATE_TIME_AFTER",
            Dimension::AgreementEndDateTimeBefore => "AGREEMENT_END_DATE_TIME_BEFORE",
            Dimension::Az => "AZ",
            Dimension::BillingEntity => "BILLING_ENTITY",
            Dimension::CacheEngine => "CACHE_ENGINE",
            Dimension::DatabaseEngine => "DATABASE_ENGINE",
            Dimension::DeploymentOption => "DEPLOYMENT_OPTION",
            Dimension::InstanceType => "INSTANCE_TYPE",
            Dimension::InstanceTypeFamily => "INSTANCE_TYPE_FAMILY",
            Dimension::InvoicingEntity => "INVOICING_ENTITY",
            Dimension::LegalEntityName => "LEGAL_ENTITY_NAME",
            Dimension::LinkedAccount => "LINKED_ACCOUNT",
            Dimension::LinkedAccountName => "LINKED_ACCOUNT_NAME",
            Dimension::OperatingSystem => "OPERATING_SYSTEM",
            Dimension::Operation => "OPERATION",
            Dimension::PaymentOption => "PAYMENT_OPTION",
            Dimension::Platform => "PLATFORM",
            Dimension::PurchaseType => "PURCHASE_TYPE",
            Dimension::RecordType => "RECORD_TYPE",
            Dimension::Region => "REGION",
            Dimension::ReservationId => "RESERVATION_ID",
            Dimension::ResourceId => "RESOURCE_ID",
            Dimension::RightsizingType => "RIGHTSIZING_TYPE",
            Dimension::SavingsPlansType => "SAVINGS_PLANS_TYPE",
            Dimension::SavingsPlanArn => "SAVINGS_PLAN_ARN",
            Dimension::Scope => "SCOPE",
            Dimension::Service => "SERVICE",
            Dimension::ServiceCode => "SERVICE_CODE",
            Dimension::SubscriptionId => "SUBSCRIPTION_ID",
            Dimension::Tenancy => "TENANCY",
            Dimension::UsageType => "USAGE_TYPE",
            Dimension::UsageTypeGroup => "USAGE_TYPE_GROUP",
            Dimension::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AGREEMENT_END_DATE_TIME_AFTER",
            "AGREEMENT_END_DATE_TIME_BEFORE",
            "AZ",
            "BILLING_ENTITY",
            "CACHE_ENGINE",
            "DATABASE_ENGINE",
            "DEPLOYMENT_OPTION",
            "INSTANCE_TYPE",
            "INSTANCE_TYPE_FAMILY",
            "INVOICING_ENTITY",
            "LEGAL_ENTITY_NAME",
            "LINKED_ACCOUNT",
            "LINKED_ACCOUNT_NAME",
            "OPERATING_SYSTEM",
            "OPERATION",
            "PAYMENT_OPTION",
            "PLATFORM",
            "PURCHASE_TYPE",
            "RECORD_TYPE",
            "REGION",
            "RESERVATION_ID",
            "RESOURCE_ID",
            "RIGHTSIZING_TYPE",
            "SAVINGS_PLANS_TYPE",
            "SAVINGS_PLAN_ARN",
            "SCOPE",
            "SERVICE",
            "SERVICE_CODE",
            "SUBSCRIPTION_ID",
            "TENANCY",
            "USAGE_TYPE",
            "USAGE_TYPE_GROUP",
        ]
    }
}
impl AsRef<str> for Dimension {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The rule schema version in this particular Cost Category.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostCategoryRuleVersion {
    #[allow(missing_docs)] // documentation missing in model
    CostCategoryExpressionV1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostCategoryRuleVersion {
    fn from(s: &str) -> Self {
        match s {
            "CostCategoryExpression.v1" => CostCategoryRuleVersion::CostCategoryExpressionV1,
            other => CostCategoryRuleVersion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostCategoryRuleVersion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostCategoryRuleVersion::from(s))
    }
}
impl CostCategoryRuleVersion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostCategoryRuleVersion::CostCategoryExpressionV1 => "CostCategoryExpression.v1",
            CostCategoryRuleVersion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CostCategoryExpression.v1"]
    }
}
impl AsRef<str> for CostCategoryRuleVersion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The recipient of <code>AnomalySubscription</code> notifications. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subscriber {
    /// <p>The email address or SNS Amazon Resource Name (ARN). This depends on the <code>Type</code>. </p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The notification delivery channel. </p>
    pub r#type: std::option::Option<crate::model::SubscriberType>,
    /// <p>Indicates if the subscriber accepts the notifications. </p>
    pub status: std::option::Option<crate::model::SubscriberStatus>,
}
impl Subscriber {
    /// <p>The email address or SNS Amazon Resource Name (ARN). This depends on the <code>Type</code>. </p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The notification delivery channel. </p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::SubscriberType> {
        self.r#type.as_ref()
    }
    /// <p>Indicates if the subscriber accepts the notifications. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::SubscriberStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for Subscriber {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subscriber");
        formatter.field("address", &self.address);
        formatter.field("r#type", &self.r#type);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`Subscriber`](crate::model::Subscriber)
pub mod subscriber {
    /// A builder for [`Subscriber`](crate::model::Subscriber)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::SubscriberType>,
        pub(crate) status: std::option::Option<crate::model::SubscriberStatus>,
    }
    impl Builder {
        /// <p>The email address or SNS Amazon Resource Name (ARN). This depends on the <code>Type</code>. </p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The email address or SNS Amazon Resource Name (ARN). This depends on the <code>Type</code>. </p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The notification delivery channel. </p>
        pub fn r#type(mut self, input: crate::model::SubscriberType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The notification delivery channel. </p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::SubscriberType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>Indicates if the subscriber accepts the notifications. </p>
        pub fn status(mut self, input: crate::model::SubscriberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Indicates if the subscriber accepts the notifications. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::SubscriberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`Subscriber`](crate::model::Subscriber)
        pub fn build(self) -> crate::model::Subscriber {
            crate::model::Subscriber {
                address: self.address,
                r#type: self.r#type,
                status: self.status,
            }
        }
    }
}
impl Subscriber {
    /// Creates a new builder-style object to manufacture [`Subscriber`](crate::model::Subscriber)
    pub fn builder() -> crate::model::subscriber::Builder {
        crate::model::subscriber::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubscriberStatus {
    #[allow(missing_docs)] // documentation missing in model
    Confirmed,
    #[allow(missing_docs)] // documentation missing in model
    Declined,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubscriberStatus {
    fn from(s: &str) -> Self {
        match s {
            "CONFIRMED" => SubscriberStatus::Confirmed,
            "DECLINED" => SubscriberStatus::Declined,
            other => SubscriberStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubscriberStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubscriberStatus::from(s))
    }
}
impl SubscriberStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubscriberStatus::Confirmed => "CONFIRMED",
            SubscriberStatus::Declined => "DECLINED",
            SubscriberStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONFIRMED", "DECLINED"]
    }
}
impl AsRef<str> for SubscriberStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SubscriberType {
    #[allow(missing_docs)] // documentation missing in model
    Email,
    #[allow(missing_docs)] // documentation missing in model
    Sns,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SubscriberType {
    fn from(s: &str) -> Self {
        match s {
            "EMAIL" => SubscriberType::Email,
            "SNS" => SubscriberType::Sns,
            other => SubscriberType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SubscriberType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SubscriberType::from(s))
    }
}
impl SubscriberType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SubscriberType::Email => "EMAIL",
            SubscriberType::Sns => "SNS",
            SubscriberType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMAIL", "SNS"]
    }
}
impl AsRef<str> for SubscriberType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalySubscriptionFrequency {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Immediate,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalySubscriptionFrequency {
    fn from(s: &str) -> Self {
        match s {
            "DAILY" => AnomalySubscriptionFrequency::Daily,
            "IMMEDIATE" => AnomalySubscriptionFrequency::Immediate,
            "WEEKLY" => AnomalySubscriptionFrequency::Weekly,
            other => AnomalySubscriptionFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalySubscriptionFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalySubscriptionFrequency::from(s))
    }
}
impl AnomalySubscriptionFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalySubscriptionFrequency::Daily => "DAILY",
            AnomalySubscriptionFrequency::Immediate => "IMMEDIATE",
            AnomalySubscriptionFrequency::Weekly => "WEEKLY",
            AnomalySubscriptionFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAILY", "IMMEDIATE", "WEEKLY"]
    }
}
impl AsRef<str> for AnomalySubscriptionFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AnomalyFeedbackType {
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    PlannedActivity,
    #[allow(missing_docs)] // documentation missing in model
    Yes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AnomalyFeedbackType {
    fn from(s: &str) -> Self {
        match s {
            "NO" => AnomalyFeedbackType::No,
            "PLANNED_ACTIVITY" => AnomalyFeedbackType::PlannedActivity,
            "YES" => AnomalyFeedbackType::Yes,
            other => AnomalyFeedbackType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AnomalyFeedbackType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AnomalyFeedbackType::from(s))
    }
}
impl AnomalyFeedbackType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AnomalyFeedbackType::No => "NO",
            AnomalyFeedbackType::PlannedActivity => "PLANNED_ACTIVITY",
            AnomalyFeedbackType::Yes => "YES",
            AnomalyFeedbackType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO", "PLANNED_ACTIVITY", "YES"]
    }
}
impl AsRef<str> for AnomalyFeedbackType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A reference to a Cost Category containing only enough information to identify the Cost Category.</p>
/// <p>You can use this information to retrieve the full Cost Category information using <code>DescribeCostCategory</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategoryReference {
    /// <p>The unique identifier for your Cost Category. </p>
    pub cost_category_arn: std::option::Option<std::string::String>,
    /// <p>The unique name of the Cost Category.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The Cost Category's effective start date.</p>
    pub effective_start: std::option::Option<std::string::String>,
    /// <p>The Cost Category's effective end date.</p>
    pub effective_end: std::option::Option<std::string::String>,
    /// <p>The number of rules that are associated with a specific Cost Category. </p>
    pub number_of_rules: i32,
    /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
    pub processing_status:
        std::option::Option<std::vec::Vec<crate::model::CostCategoryProcessingStatus>>,
    /// <p>A list of unique cost category values in a specific cost category. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The default value for the cost category.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl CostCategoryReference {
    /// <p>The unique identifier for your Cost Category. </p>
    pub fn cost_category_arn(&self) -> std::option::Option<&str> {
        self.cost_category_arn.as_deref()
    }
    /// <p>The unique name of the Cost Category.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The Cost Category's effective start date.</p>
    pub fn effective_start(&self) -> std::option::Option<&str> {
        self.effective_start.as_deref()
    }
    /// <p>The Cost Category's effective end date.</p>
    pub fn effective_end(&self) -> std::option::Option<&str> {
        self.effective_end.as_deref()
    }
    /// <p>The number of rules that are associated with a specific Cost Category. </p>
    pub fn number_of_rules(&self) -> i32 {
        self.number_of_rules
    }
    /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
    pub fn processing_status(
        &self,
    ) -> std::option::Option<&[crate::model::CostCategoryProcessingStatus]> {
        self.processing_status.as_deref()
    }
    /// <p>A list of unique cost category values in a specific cost category. </p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
    /// <p>The default value for the cost category.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
}
impl std::fmt::Debug for CostCategoryReference {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategoryReference");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.field("name", &self.name);
        formatter.field("effective_start", &self.effective_start);
        formatter.field("effective_end", &self.effective_end);
        formatter.field("number_of_rules", &self.number_of_rules);
        formatter.field("processing_status", &self.processing_status);
        formatter.field("values", &self.values);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`CostCategoryReference`](crate::model::CostCategoryReference)
pub mod cost_category_reference {
    /// A builder for [`CostCategoryReference`](crate::model::CostCategoryReference)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) effective_start: std::option::Option<std::string::String>,
        pub(crate) effective_end: std::option::Option<std::string::String>,
        pub(crate) number_of_rules: std::option::Option<i32>,
        pub(crate) processing_status:
            std::option::Option<std::vec::Vec<crate::model::CostCategoryProcessingStatus>>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for your Cost Category. </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for your Cost Category. </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The Cost Category's effective start date.</p>
        pub fn effective_start(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_start = Some(input.into());
            self
        }
        /// <p>The Cost Category's effective start date.</p>
        pub fn set_effective_start(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_start = input;
            self
        }
        /// <p>The Cost Category's effective end date.</p>
        pub fn effective_end(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_end = Some(input.into());
            self
        }
        /// <p>The Cost Category's effective end date.</p>
        pub fn set_effective_end(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_end = input;
            self
        }
        /// <p>The number of rules that are associated with a specific Cost Category. </p>
        pub fn number_of_rules(mut self, input: i32) -> Self {
            self.number_of_rules = Some(input);
            self
        }
        /// <p>The number of rules that are associated with a specific Cost Category. </p>
        pub fn set_number_of_rules(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_rules = input;
            self
        }
        /// Appends an item to `processing_status`.
        ///
        /// To override the contents of this collection use [`set_processing_status`](Self::set_processing_status).
        ///
        /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
        pub fn processing_status(
            mut self,
            input: crate::model::CostCategoryProcessingStatus,
        ) -> Self {
            let mut v = self.processing_status.unwrap_or_default();
            v.push(input);
            self.processing_status = Some(v);
            self
        }
        /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
        pub fn set_processing_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryProcessingStatus>>,
        ) -> Self {
            self.processing_status = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>A list of unique cost category values in a specific cost category. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>A list of unique cost category values in a specific cost category. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategoryReference`](crate::model::CostCategoryReference)
        pub fn build(self) -> crate::model::CostCategoryReference {
            crate::model::CostCategoryReference {
                cost_category_arn: self.cost_category_arn,
                name: self.name,
                effective_start: self.effective_start,
                effective_end: self.effective_end,
                number_of_rules: self.number_of_rules.unwrap_or_default(),
                processing_status: self.processing_status,
                values: self.values,
                default_value: self.default_value,
            }
        }
    }
}
impl CostCategoryReference {
    /// Creates a new builder-style object to manufacture [`CostCategoryReference`](crate::model::CostCategoryReference)
    pub fn builder() -> crate::model::cost_category_reference::Builder {
        crate::model::cost_category_reference::Builder::default()
    }
}

/// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategoryProcessingStatus {
    /// <p>The Cost Management product name of the applied status. </p>
    pub component: std::option::Option<crate::model::CostCategoryStatusComponent>,
    /// <p>The process status for a specific cost category. </p>
    pub status: std::option::Option<crate::model::CostCategoryStatus>,
}
impl CostCategoryProcessingStatus {
    /// <p>The Cost Management product name of the applied status. </p>
    pub fn component(&self) -> std::option::Option<&crate::model::CostCategoryStatusComponent> {
        self.component.as_ref()
    }
    /// <p>The process status for a specific cost category. </p>
    pub fn status(&self) -> std::option::Option<&crate::model::CostCategoryStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for CostCategoryProcessingStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategoryProcessingStatus");
        formatter.field("component", &self.component);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`CostCategoryProcessingStatus`](crate::model::CostCategoryProcessingStatus)
pub mod cost_category_processing_status {
    /// A builder for [`CostCategoryProcessingStatus`](crate::model::CostCategoryProcessingStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) component: std::option::Option<crate::model::CostCategoryStatusComponent>,
        pub(crate) status: std::option::Option<crate::model::CostCategoryStatus>,
    }
    impl Builder {
        /// <p>The Cost Management product name of the applied status. </p>
        pub fn component(mut self, input: crate::model::CostCategoryStatusComponent) -> Self {
            self.component = Some(input);
            self
        }
        /// <p>The Cost Management product name of the applied status. </p>
        pub fn set_component(
            mut self,
            input: std::option::Option<crate::model::CostCategoryStatusComponent>,
        ) -> Self {
            self.component = input;
            self
        }
        /// <p>The process status for a specific cost category. </p>
        pub fn status(mut self, input: crate::model::CostCategoryStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The process status for a specific cost category. </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::CostCategoryStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategoryProcessingStatus`](crate::model::CostCategoryProcessingStatus)
        pub fn build(self) -> crate::model::CostCategoryProcessingStatus {
            crate::model::CostCategoryProcessingStatus {
                component: self.component,
                status: self.status,
            }
        }
    }
}
impl CostCategoryProcessingStatus {
    /// Creates a new builder-style object to manufacture [`CostCategoryProcessingStatus`](crate::model::CostCategoryProcessingStatus)
    pub fn builder() -> crate::model::cost_category_processing_status::Builder {
        crate::model::cost_category_processing_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostCategoryStatus {
    #[allow(missing_docs)] // documentation missing in model
    Applied,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostCategoryStatus {
    fn from(s: &str) -> Self {
        match s {
            "APPLIED" => CostCategoryStatus::Applied,
            "PROCESSING" => CostCategoryStatus::Processing,
            other => CostCategoryStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostCategoryStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostCategoryStatus::from(s))
    }
}
impl CostCategoryStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostCategoryStatus::Applied => "APPLIED",
            CostCategoryStatus::Processing => "PROCESSING",
            CostCategoryStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLIED", "PROCESSING"]
    }
}
impl AsRef<str> for CostCategoryStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CostCategoryStatusComponent {
    #[allow(missing_docs)] // documentation missing in model
    CostExplorer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CostCategoryStatusComponent {
    fn from(s: &str) -> Self {
        match s {
            "COST_EXPLORER" => CostCategoryStatusComponent::CostExplorer,
            other => CostCategoryStatusComponent::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CostCategoryStatusComponent {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CostCategoryStatusComponent::from(s))
    }
}
impl CostCategoryStatusComponent {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CostCategoryStatusComponent::CostExplorer => "COST_EXPLORER",
            CostCategoryStatusComponent::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COST_EXPLORER"]
    }
}
impl AsRef<str> for CostCategoryStatusComponent {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The forecast that's created for your query.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForecastResult {
    /// <p>The period of time that the forecast covers.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The mean value of the forecast.</p>
    pub mean_value: std::option::Option<std::string::String>,
    /// <p>The lower limit for the prediction interval. </p>
    pub prediction_interval_lower_bound: std::option::Option<std::string::String>,
    /// <p>The upper limit for the prediction interval. </p>
    pub prediction_interval_upper_bound: std::option::Option<std::string::String>,
}
impl ForecastResult {
    /// <p>The period of time that the forecast covers.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The mean value of the forecast.</p>
    pub fn mean_value(&self) -> std::option::Option<&str> {
        self.mean_value.as_deref()
    }
    /// <p>The lower limit for the prediction interval. </p>
    pub fn prediction_interval_lower_bound(&self) -> std::option::Option<&str> {
        self.prediction_interval_lower_bound.as_deref()
    }
    /// <p>The upper limit for the prediction interval. </p>
    pub fn prediction_interval_upper_bound(&self) -> std::option::Option<&str> {
        self.prediction_interval_upper_bound.as_deref()
    }
}
impl std::fmt::Debug for ForecastResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForecastResult");
        formatter.field("time_period", &self.time_period);
        formatter.field("mean_value", &self.mean_value);
        formatter.field(
            "prediction_interval_lower_bound",
            &self.prediction_interval_lower_bound,
        );
        formatter.field(
            "prediction_interval_upper_bound",
            &self.prediction_interval_upper_bound,
        );
        formatter.finish()
    }
}
/// See [`ForecastResult`](crate::model::ForecastResult)
pub mod forecast_result {
    /// A builder for [`ForecastResult`](crate::model::ForecastResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) mean_value: std::option::Option<std::string::String>,
        pub(crate) prediction_interval_lower_bound: std::option::Option<std::string::String>,
        pub(crate) prediction_interval_upper_bound: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The period of time that the forecast covers.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The period of time that the forecast covers.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>The mean value of the forecast.</p>
        pub fn mean_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.mean_value = Some(input.into());
            self
        }
        /// <p>The mean value of the forecast.</p>
        pub fn set_mean_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mean_value = input;
            self
        }
        /// <p>The lower limit for the prediction interval. </p>
        pub fn prediction_interval_lower_bound(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.prediction_interval_lower_bound = Some(input.into());
            self
        }
        /// <p>The lower limit for the prediction interval. </p>
        pub fn set_prediction_interval_lower_bound(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prediction_interval_lower_bound = input;
            self
        }
        /// <p>The upper limit for the prediction interval. </p>
        pub fn prediction_interval_upper_bound(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.prediction_interval_upper_bound = Some(input.into());
            self
        }
        /// <p>The upper limit for the prediction interval. </p>
        pub fn set_prediction_interval_upper_bound(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.prediction_interval_upper_bound = input;
            self
        }
        /// Consumes the builder and constructs a [`ForecastResult`](crate::model::ForecastResult)
        pub fn build(self) -> crate::model::ForecastResult {
            crate::model::ForecastResult {
                time_period: self.time_period,
                mean_value: self.mean_value,
                prediction_interval_lower_bound: self.prediction_interval_lower_bound,
                prediction_interval_upper_bound: self.prediction_interval_upper_bound,
            }
        }
    }
}
impl ForecastResult {
    /// Creates a new builder-style object to manufacture [`ForecastResult`](crate::model::ForecastResult)
    pub fn builder() -> crate::model::forecast_result::Builder {
        crate::model::forecast_result::Builder::default()
    }
}

/// <p>The time period of the request. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DateInterval {
    /// <p>The beginning of the time period. The start date is inclusive. For example, if <code>start</code> is <code>2017-01-01</code>, Amazon Web Services retrieves cost and usage data starting at <code>2017-01-01</code> up to the end date. The start date must be equal to or no later than the current date to avoid a validation error.</p>
    pub start: std::option::Option<std::string::String>,
    /// <p>The end of the time period. The end date is exclusive. For example, if <code>end</code> is <code>2017-05-01</code>, Amazon Web Services retrieves cost and usage data from the start date up to, but not including, <code>2017-05-01</code>.</p>
    pub end: std::option::Option<std::string::String>,
}
impl DateInterval {
    /// <p>The beginning of the time period. The start date is inclusive. For example, if <code>start</code> is <code>2017-01-01</code>, Amazon Web Services retrieves cost and usage data starting at <code>2017-01-01</code> up to the end date. The start date must be equal to or no later than the current date to avoid a validation error.</p>
    pub fn start(&self) -> std::option::Option<&str> {
        self.start.as_deref()
    }
    /// <p>The end of the time period. The end date is exclusive. For example, if <code>end</code> is <code>2017-05-01</code>, Amazon Web Services retrieves cost and usage data from the start date up to, but not including, <code>2017-05-01</code>.</p>
    pub fn end(&self) -> std::option::Option<&str> {
        self.end.as_deref()
    }
}
impl std::fmt::Debug for DateInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DateInterval");
        formatter.field("start", &self.start);
        formatter.field("end", &self.end);
        formatter.finish()
    }
}
/// See [`DateInterval`](crate::model::DateInterval)
pub mod date_interval {
    /// A builder for [`DateInterval`](crate::model::DateInterval)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start: std::option::Option<std::string::String>,
        pub(crate) end: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The beginning of the time period. The start date is inclusive. For example, if <code>start</code> is <code>2017-01-01</code>, Amazon Web Services retrieves cost and usage data starting at <code>2017-01-01</code> up to the end date. The start date must be equal to or no later than the current date to avoid a validation error.</p>
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// <p>The beginning of the time period. The start date is inclusive. For example, if <code>start</code> is <code>2017-01-01</code>, Amazon Web Services retrieves cost and usage data starting at <code>2017-01-01</code> up to the end date. The start date must be equal to or no later than the current date to avoid a validation error.</p>
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// <p>The end of the time period. The end date is exclusive. For example, if <code>end</code> is <code>2017-05-01</code>, Amazon Web Services retrieves cost and usage data from the start date up to, but not including, <code>2017-05-01</code>.</p>
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// <p>The end of the time period. The end date is exclusive. For example, if <code>end</code> is <code>2017-05-01</code>, Amazon Web Services retrieves cost and usage data from the start date up to, but not including, <code>2017-05-01</code>.</p>
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// Consumes the builder and constructs a [`DateInterval`](crate::model::DateInterval)
        pub fn build(self) -> crate::model::DateInterval {
            crate::model::DateInterval {
                start: self.start,
                end: self.end,
            }
        }
    }
}
impl DateInterval {
    /// Creates a new builder-style object to manufacture [`DateInterval`](crate::model::DateInterval)
    pub fn builder() -> crate::model::date_interval::Builder {
        crate::model::date_interval::Builder::default()
    }
}

/// <p>The aggregated value for a metric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MetricValue {
    /// <p>The actual number that represents the metric.</p>
    pub amount: std::option::Option<std::string::String>,
    /// <p>The unit that the metric is given in.</p>
    pub unit: std::option::Option<std::string::String>,
}
impl MetricValue {
    /// <p>The actual number that represents the metric.</p>
    pub fn amount(&self) -> std::option::Option<&str> {
        self.amount.as_deref()
    }
    /// <p>The unit that the metric is given in.</p>
    pub fn unit(&self) -> std::option::Option<&str> {
        self.unit.as_deref()
    }
}
impl std::fmt::Debug for MetricValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MetricValue");
        formatter.field("amount", &self.amount);
        formatter.field("unit", &self.unit);
        formatter.finish()
    }
}
/// See [`MetricValue`](crate::model::MetricValue)
pub mod metric_value {
    /// A builder for [`MetricValue`](crate::model::MetricValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amount: std::option::Option<std::string::String>,
        pub(crate) unit: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The actual number that represents the metric.</p>
        pub fn amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.amount = Some(input.into());
            self
        }
        /// <p>The actual number that represents the metric.</p>
        pub fn set_amount(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The unit that the metric is given in.</p>
        pub fn unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.unit = Some(input.into());
            self
        }
        /// <p>The unit that the metric is given in.</p>
        pub fn set_unit(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unit = input;
            self
        }
        /// Consumes the builder and constructs a [`MetricValue`](crate::model::MetricValue)
        pub fn build(self) -> crate::model::MetricValue {
            crate::model::MetricValue {
                amount: self.amount,
                unit: self.unit,
            }
        }
    }
}
impl MetricValue {
    /// Creates a new builder-style object to manufacture [`MetricValue`](crate::model::MetricValue)
    pub fn builder() -> crate::model::metric_value::Builder {
        crate::model::metric_value::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Granularity {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Hourly,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Granularity {
    fn from(s: &str) -> Self {
        match s {
            "DAILY" => Granularity::Daily,
            "HOURLY" => Granularity::Hourly,
            "MONTHLY" => Granularity::Monthly,
            other => Granularity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Granularity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Granularity::from(s))
    }
}
impl Granularity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Granularity::Daily => "DAILY",
            Granularity::Hourly => "HOURLY",
            Granularity::Monthly => "MONTHLY",
            Granularity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DAILY", "HOURLY", "MONTHLY"]
    }
}
impl AsRef<str> for Granularity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Metric {
    #[allow(missing_docs)] // documentation missing in model
    AmortizedCost,
    #[allow(missing_docs)] // documentation missing in model
    BlendedCost,
    #[allow(missing_docs)] // documentation missing in model
    NetAmortizedCost,
    #[allow(missing_docs)] // documentation missing in model
    NetUnblendedCost,
    #[allow(missing_docs)] // documentation missing in model
    NormalizedUsageAmount,
    #[allow(missing_docs)] // documentation missing in model
    UnblendedCost,
    #[allow(missing_docs)] // documentation missing in model
    UsageQuantity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Metric {
    fn from(s: &str) -> Self {
        match s {
            "AMORTIZED_COST" => Metric::AmortizedCost,
            "BLENDED_COST" => Metric::BlendedCost,
            "NET_AMORTIZED_COST" => Metric::NetAmortizedCost,
            "NET_UNBLENDED_COST" => Metric::NetUnblendedCost,
            "NORMALIZED_USAGE_AMOUNT" => Metric::NormalizedUsageAmount,
            "UNBLENDED_COST" => Metric::UnblendedCost,
            "USAGE_QUANTITY" => Metric::UsageQuantity,
            other => Metric::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Metric {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Metric::from(s))
    }
}
impl Metric {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Metric::AmortizedCost => "AMORTIZED_COST",
            Metric::BlendedCost => "BLENDED_COST",
            Metric::NetAmortizedCost => "NET_AMORTIZED_COST",
            Metric::NetUnblendedCost => "NET_UNBLENDED_COST",
            Metric::NormalizedUsageAmount => "NORMALIZED_USAGE_AMOUNT",
            Metric::UnblendedCost => "UNBLENDED_COST",
            Metric::UsageQuantity => "USAGE_QUANTITY",
            Metric::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMORTIZED_COST",
            "BLENDED_COST",
            "NET_AMORTIZED_COST",
            "NET_UNBLENDED_COST",
            "NORMALIZED_USAGE_AMOUNT",
            "UNBLENDED_COST",
            "USAGE_QUANTITY",
        ]
    }
}
impl AsRef<str> for Metric {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The details of how to sort the data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortDefinition {
    /// <p>The key that's used to sort the data.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The order that's used to sort the data.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
}
impl SortDefinition {
    /// <p>The key that's used to sort the data.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The order that's used to sort the data.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for SortDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortDefinition");
        formatter.field("key", &self.key);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}
/// See [`SortDefinition`](crate::model::SortDefinition)
pub mod sort_definition {
    /// A builder for [`SortDefinition`](crate::model::SortDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>The key that's used to sort the data.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key that's used to sort the data.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The order that's used to sort the data.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order that's used to sort the data.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`SortDefinition`](crate::model::SortDefinition)
        pub fn build(self) -> crate::model::SortDefinition {
            crate::model::SortDefinition {
                key: self.key,
                sort_order: self.sort_order,
            }
        }
    }
}
impl SortDefinition {
    /// Creates a new builder-style object to manufacture [`SortDefinition`](crate::model::SortDefinition)
    pub fn builder() -> crate::model::sort_definition::Builder {
        crate::model::sort_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The aggregated utilization metrics for your Savings Plans usage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansUtilizationAggregates {
    /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
    pub utilization: std::option::Option<crate::model::SavingsPlansUtilization>,
    /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
    pub savings: std::option::Option<crate::model::SavingsPlansSavings>,
    /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
    pub amortized_commitment: std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
}
impl SavingsPlansUtilizationAggregates {
    /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
    pub fn utilization(&self) -> std::option::Option<&crate::model::SavingsPlansUtilization> {
        self.utilization.as_ref()
    }
    /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
    pub fn savings(&self) -> std::option::Option<&crate::model::SavingsPlansSavings> {
        self.savings.as_ref()
    }
    /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
    pub fn amortized_commitment(
        &self,
    ) -> std::option::Option<&crate::model::SavingsPlansAmortizedCommitment> {
        self.amortized_commitment.as_ref()
    }
}
impl std::fmt::Debug for SavingsPlansUtilizationAggregates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansUtilizationAggregates");
        formatter.field("utilization", &self.utilization);
        formatter.field("savings", &self.savings);
        formatter.field("amortized_commitment", &self.amortized_commitment);
        formatter.finish()
    }
}
/// See [`SavingsPlansUtilizationAggregates`](crate::model::SavingsPlansUtilizationAggregates)
pub mod savings_plans_utilization_aggregates {
    /// A builder for [`SavingsPlansUtilizationAggregates`](crate::model::SavingsPlansUtilizationAggregates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) utilization: std::option::Option<crate::model::SavingsPlansUtilization>,
        pub(crate) savings: std::option::Option<crate::model::SavingsPlansSavings>,
        pub(crate) amortized_commitment:
            std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
    }
    impl Builder {
        /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
        pub fn utilization(mut self, input: crate::model::SavingsPlansUtilization) -> Self {
            self.utilization = Some(input);
            self
        }
        /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
        pub fn set_utilization(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansUtilization>,
        ) -> Self {
            self.utilization = input;
            self
        }
        /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
        pub fn savings(mut self, input: crate::model::SavingsPlansSavings) -> Self {
            self.savings = Some(input);
            self
        }
        /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans, as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
        pub fn set_savings(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansSavings>,
        ) -> Self {
            self.savings = input;
            self
        }
        /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
        pub fn amortized_commitment(
            mut self,
            input: crate::model::SavingsPlansAmortizedCommitment,
        ) -> Self {
            self.amortized_commitment = Some(input);
            self
        }
        /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
        pub fn set_amortized_commitment(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
        ) -> Self {
            self.amortized_commitment = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansUtilizationAggregates`](crate::model::SavingsPlansUtilizationAggregates)
        pub fn build(self) -> crate::model::SavingsPlansUtilizationAggregates {
            crate::model::SavingsPlansUtilizationAggregates {
                utilization: self.utilization,
                savings: self.savings,
                amortized_commitment: self.amortized_commitment,
            }
        }
    }
}
impl SavingsPlansUtilizationAggregates {
    /// Creates a new builder-style object to manufacture [`SavingsPlansUtilizationAggregates`](crate::model::SavingsPlansUtilizationAggregates)
    pub fn builder() -> crate::model::savings_plans_utilization_aggregates::Builder {
        crate::model::savings_plans_utilization_aggregates::Builder::default()
    }
}

/// <p>The amortized amount of Savings Plans purchased in a specific account during a specific time interval.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansAmortizedCommitment {
    /// <p>The amortized amount of your Savings Plans commitment that was purchased with either a <code>Partial</code> or a <code>NoUpfront</code>.</p>
    pub amortized_recurring_commitment: std::option::Option<std::string::String>,
    /// <p>The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code> or <code>PartialUpfront</code> Savings Plans.</p>
    pub amortized_upfront_commitment: std::option::Option<std::string::String>,
    /// <p>The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase method. </p>
    pub total_amortized_commitment: std::option::Option<std::string::String>,
}
impl SavingsPlansAmortizedCommitment {
    /// <p>The amortized amount of your Savings Plans commitment that was purchased with either a <code>Partial</code> or a <code>NoUpfront</code>.</p>
    pub fn amortized_recurring_commitment(&self) -> std::option::Option<&str> {
        self.amortized_recurring_commitment.as_deref()
    }
    /// <p>The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code> or <code>PartialUpfront</code> Savings Plans.</p>
    pub fn amortized_upfront_commitment(&self) -> std::option::Option<&str> {
        self.amortized_upfront_commitment.as_deref()
    }
    /// <p>The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase method. </p>
    pub fn total_amortized_commitment(&self) -> std::option::Option<&str> {
        self.total_amortized_commitment.as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansAmortizedCommitment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansAmortizedCommitment");
        formatter.field(
            "amortized_recurring_commitment",
            &self.amortized_recurring_commitment,
        );
        formatter.field(
            "amortized_upfront_commitment",
            &self.amortized_upfront_commitment,
        );
        formatter.field(
            "total_amortized_commitment",
            &self.total_amortized_commitment,
        );
        formatter.finish()
    }
}
/// See [`SavingsPlansAmortizedCommitment`](crate::model::SavingsPlansAmortizedCommitment)
pub mod savings_plans_amortized_commitment {
    /// A builder for [`SavingsPlansAmortizedCommitment`](crate::model::SavingsPlansAmortizedCommitment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) amortized_recurring_commitment: std::option::Option<std::string::String>,
        pub(crate) amortized_upfront_commitment: std::option::Option<std::string::String>,
        pub(crate) total_amortized_commitment: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The amortized amount of your Savings Plans commitment that was purchased with either a <code>Partial</code> or a <code>NoUpfront</code>.</p>
        pub fn amortized_recurring_commitment(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.amortized_recurring_commitment = Some(input.into());
            self
        }
        /// <p>The amortized amount of your Savings Plans commitment that was purchased with either a <code>Partial</code> or a <code>NoUpfront</code>.</p>
        pub fn set_amortized_recurring_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amortized_recurring_commitment = input;
            self
        }
        /// <p>The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code> or <code>PartialUpfront</code> Savings Plans.</p>
        pub fn amortized_upfront_commitment(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.amortized_upfront_commitment = Some(input.into());
            self
        }
        /// <p>The amortized amount of your Savings Plans commitment that was purchased with an <code>Upfront</code> or <code>PartialUpfront</code> Savings Plans.</p>
        pub fn set_amortized_upfront_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amortized_upfront_commitment = input;
            self
        }
        /// <p>The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase method. </p>
        pub fn total_amortized_commitment(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_amortized_commitment = Some(input.into());
            self
        }
        /// <p>The total amortized amount of your Savings Plans commitment, regardless of your Savings Plans purchase method. </p>
        pub fn set_total_amortized_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_amortized_commitment = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansAmortizedCommitment`](crate::model::SavingsPlansAmortizedCommitment)
        pub fn build(self) -> crate::model::SavingsPlansAmortizedCommitment {
            crate::model::SavingsPlansAmortizedCommitment {
                amortized_recurring_commitment: self.amortized_recurring_commitment,
                amortized_upfront_commitment: self.amortized_upfront_commitment,
                total_amortized_commitment: self.total_amortized_commitment,
            }
        }
    }
}
impl SavingsPlansAmortizedCommitment {
    /// Creates a new builder-style object to manufacture [`SavingsPlansAmortizedCommitment`](crate::model::SavingsPlansAmortizedCommitment)
    pub fn builder() -> crate::model::savings_plans_amortized_commitment::Builder {
        crate::model::savings_plans_amortized_commitment::Builder::default()
    }
}

/// <p>The amount of savings that you're accumulating, against the public On-Demand rate of the usage accrued in an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansSavings {
    /// <p>The savings amount that you're accumulating for the usage that's covered by a Savings Plans, when compared to the On-Demand equivalent of the same usage.</p>
    pub net_savings: std::option::Option<std::string::String>,
    /// <p>How much the amount that the usage would have cost if it was accrued at the On-Demand rate.</p>
    pub on_demand_cost_equivalent: std::option::Option<std::string::String>,
}
impl SavingsPlansSavings {
    /// <p>The savings amount that you're accumulating for the usage that's covered by a Savings Plans, when compared to the On-Demand equivalent of the same usage.</p>
    pub fn net_savings(&self) -> std::option::Option<&str> {
        self.net_savings.as_deref()
    }
    /// <p>How much the amount that the usage would have cost if it was accrued at the On-Demand rate.</p>
    pub fn on_demand_cost_equivalent(&self) -> std::option::Option<&str> {
        self.on_demand_cost_equivalent.as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansSavings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansSavings");
        formatter.field("net_savings", &self.net_savings);
        formatter.field("on_demand_cost_equivalent", &self.on_demand_cost_equivalent);
        formatter.finish()
    }
}
/// See [`SavingsPlansSavings`](crate::model::SavingsPlansSavings)
pub mod savings_plans_savings {
    /// A builder for [`SavingsPlansSavings`](crate::model::SavingsPlansSavings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) net_savings: std::option::Option<std::string::String>,
        pub(crate) on_demand_cost_equivalent: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The savings amount that you're accumulating for the usage that's covered by a Savings Plans, when compared to the On-Demand equivalent of the same usage.</p>
        pub fn net_savings(mut self, input: impl Into<std::string::String>) -> Self {
            self.net_savings = Some(input.into());
            self
        }
        /// <p>The savings amount that you're accumulating for the usage that's covered by a Savings Plans, when compared to the On-Demand equivalent of the same usage.</p>
        pub fn set_net_savings(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.net_savings = input;
            self
        }
        /// <p>How much the amount that the usage would have cost if it was accrued at the On-Demand rate.</p>
        pub fn on_demand_cost_equivalent(mut self, input: impl Into<std::string::String>) -> Self {
            self.on_demand_cost_equivalent = Some(input.into());
            self
        }
        /// <p>How much the amount that the usage would have cost if it was accrued at the On-Demand rate.</p>
        pub fn set_on_demand_cost_equivalent(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_cost_equivalent = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansSavings`](crate::model::SavingsPlansSavings)
        pub fn build(self) -> crate::model::SavingsPlansSavings {
            crate::model::SavingsPlansSavings {
                net_savings: self.net_savings,
                on_demand_cost_equivalent: self.on_demand_cost_equivalent,
            }
        }
    }
}
impl SavingsPlansSavings {
    /// Creates a new builder-style object to manufacture [`SavingsPlansSavings`](crate::model::SavingsPlansSavings)
    pub fn builder() -> crate::model::savings_plans_savings::Builder {
        crate::model::savings_plans_savings::Builder::default()
    }
}

/// <p>The measurement of how well you're using your existing Savings Plans.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansUtilization {
    /// <p>The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).</p>
    pub total_commitment: std::option::Option<std::string::String>,
    /// <p>The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a specific period.</p>
    pub used_commitment: std::option::Option<std::string::String>,
    /// <p>The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in a specific period.</p>
    pub unused_commitment: std::option::Option<std::string::String>,
    /// <p>The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings Plans.</p>
    pub utilization_percentage: std::option::Option<std::string::String>,
}
impl SavingsPlansUtilization {
    /// <p>The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).</p>
    pub fn total_commitment(&self) -> std::option::Option<&str> {
        self.total_commitment.as_deref()
    }
    /// <p>The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a specific period.</p>
    pub fn used_commitment(&self) -> std::option::Option<&str> {
        self.used_commitment.as_deref()
    }
    /// <p>The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in a specific period.</p>
    pub fn unused_commitment(&self) -> std::option::Option<&str> {
        self.unused_commitment.as_deref()
    }
    /// <p>The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings Plans.</p>
    pub fn utilization_percentage(&self) -> std::option::Option<&str> {
        self.utilization_percentage.as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansUtilization");
        formatter.field("total_commitment", &self.total_commitment);
        formatter.field("used_commitment", &self.used_commitment);
        formatter.field("unused_commitment", &self.unused_commitment);
        formatter.field("utilization_percentage", &self.utilization_percentage);
        formatter.finish()
    }
}
/// See [`SavingsPlansUtilization`](crate::model::SavingsPlansUtilization)
pub mod savings_plans_utilization {
    /// A builder for [`SavingsPlansUtilization`](crate::model::SavingsPlansUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_commitment: std::option::Option<std::string::String>,
        pub(crate) used_commitment: std::option::Option<std::string::String>,
        pub(crate) unused_commitment: std::option::Option<std::string::String>,
        pub(crate) utilization_percentage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).</p>
        pub fn total_commitment(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_commitment = Some(input.into());
            self
        }
        /// <p>The total amount of Savings Plans commitment that's been purchased in an account (or set of accounts).</p>
        pub fn set_total_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_commitment = input;
            self
        }
        /// <p>The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a specific period.</p>
        pub fn used_commitment(mut self, input: impl Into<std::string::String>) -> Self {
            self.used_commitment = Some(input.into());
            self
        }
        /// <p>The amount of your Savings Plans commitment that was consumed from Savings Plans eligible usage in a specific period.</p>
        pub fn set_used_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.used_commitment = input;
            self
        }
        /// <p>The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in a specific period.</p>
        pub fn unused_commitment(mut self, input: impl Into<std::string::String>) -> Self {
            self.unused_commitment = Some(input.into());
            self
        }
        /// <p>The amount of your Savings Plans commitment that wasn't consumed from Savings Plans eligible usage in a specific period.</p>
        pub fn set_unused_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unused_commitment = input;
            self
        }
        /// <p>The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings Plans.</p>
        pub fn utilization_percentage(mut self, input: impl Into<std::string::String>) -> Self {
            self.utilization_percentage = Some(input.into());
            self
        }
        /// <p>The amount of <code>UsedCommitment</code> divided by the <code>TotalCommitment</code> for your Savings Plans.</p>
        pub fn set_utilization_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.utilization_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansUtilization`](crate::model::SavingsPlansUtilization)
        pub fn build(self) -> crate::model::SavingsPlansUtilization {
            crate::model::SavingsPlansUtilization {
                total_commitment: self.total_commitment,
                used_commitment: self.used_commitment,
                unused_commitment: self.unused_commitment,
                utilization_percentage: self.utilization_percentage,
            }
        }
    }
}
impl SavingsPlansUtilization {
    /// Creates a new builder-style object to manufacture [`SavingsPlansUtilization`](crate::model::SavingsPlansUtilization)
    pub fn builder() -> crate::model::savings_plans_utilization::Builder {
        crate::model::savings_plans_utilization::Builder::default()
    }
}

/// <p>A single daily or monthly Savings Plans utilization rate, and details for your account. A management account in an organization have access to member accounts. You can use <code>GetDimensionValues</code> to determine the possible dimension values. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansUtilizationDetail {
    /// <p>The unique Amazon Resource Name (ARN) for a particular Savings Plan.</p>
    pub savings_plan_arn: std::option::Option<std::string::String>,
    /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
    pub utilization: std::option::Option<crate::model::SavingsPlansUtilization>,
    /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
    pub savings: std::option::Option<crate::model::SavingsPlansSavings>,
    /// <p>The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings Plans fees.</p>
    pub amortized_commitment: std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
}
impl SavingsPlansUtilizationDetail {
    /// <p>The unique Amazon Resource Name (ARN) for a particular Savings Plan.</p>
    pub fn savings_plan_arn(&self) -> std::option::Option<&str> {
        self.savings_plan_arn.as_deref()
    }
    /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
    pub fn utilization(&self) -> std::option::Option<&crate::model::SavingsPlansUtilization> {
        self.utilization.as_ref()
    }
    /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
    pub fn savings(&self) -> std::option::Option<&crate::model::SavingsPlansSavings> {
        self.savings.as_ref()
    }
    /// <p>The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings Plans fees.</p>
    pub fn amortized_commitment(
        &self,
    ) -> std::option::Option<&crate::model::SavingsPlansAmortizedCommitment> {
        self.amortized_commitment.as_ref()
    }
}
impl std::fmt::Debug for SavingsPlansUtilizationDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansUtilizationDetail");
        formatter.field("savings_plan_arn", &self.savings_plan_arn);
        formatter.field("attributes", &self.attributes);
        formatter.field("utilization", &self.utilization);
        formatter.field("savings", &self.savings);
        formatter.field("amortized_commitment", &self.amortized_commitment);
        formatter.finish()
    }
}
/// See [`SavingsPlansUtilizationDetail`](crate::model::SavingsPlansUtilizationDetail)
pub mod savings_plans_utilization_detail {
    /// A builder for [`SavingsPlansUtilizationDetail`](crate::model::SavingsPlansUtilizationDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plan_arn: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) utilization: std::option::Option<crate::model::SavingsPlansUtilization>,
        pub(crate) savings: std::option::Option<crate::model::SavingsPlansSavings>,
        pub(crate) amortized_commitment:
            std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
    }
    impl Builder {
        /// <p>The unique Amazon Resource Name (ARN) for a particular Savings Plan.</p>
        pub fn savings_plan_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_plan_arn = Some(input.into());
            self
        }
        /// <p>The unique Amazon Resource Name (ARN) for a particular Savings Plan.</p>
        pub fn set_savings_plan_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_plan_arn = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
        pub fn utilization(mut self, input: crate::model::SavingsPlansUtilization) -> Self {
            self.utilization = Some(input);
            self
        }
        /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
        pub fn set_utilization(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansUtilization>,
        ) -> Self {
            self.utilization = input;
            self
        }
        /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
        pub fn savings(mut self, input: crate::model::SavingsPlansSavings) -> Self {
            self.savings = Some(input);
            self
        }
        /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from savings plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
        pub fn set_savings(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansSavings>,
        ) -> Self {
            self.savings = input;
            self
        }
        /// <p>The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings Plans fees.</p>
        pub fn amortized_commitment(
            mut self,
            input: crate::model::SavingsPlansAmortizedCommitment,
        ) -> Self {
            self.amortized_commitment = Some(input);
            self
        }
        /// <p>The total amortized commitment for a Savings Plans. Includes the sum of the upfront and recurring Savings Plans fees.</p>
        pub fn set_amortized_commitment(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
        ) -> Self {
            self.amortized_commitment = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansUtilizationDetail`](crate::model::SavingsPlansUtilizationDetail)
        pub fn build(self) -> crate::model::SavingsPlansUtilizationDetail {
            crate::model::SavingsPlansUtilizationDetail {
                savings_plan_arn: self.savings_plan_arn,
                attributes: self.attributes,
                utilization: self.utilization,
                savings: self.savings,
                amortized_commitment: self.amortized_commitment,
            }
        }
    }
}
impl SavingsPlansUtilizationDetail {
    /// Creates a new builder-style object to manufacture [`SavingsPlansUtilizationDetail`](crate::model::SavingsPlansUtilizationDetail)
    pub fn builder() -> crate::model::savings_plans_utilization_detail::Builder {
        crate::model::savings_plans_utilization_detail::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SavingsPlansDataType {
    #[allow(missing_docs)] // documentation missing in model
    AmortizedCommitment,
    #[allow(missing_docs)] // documentation missing in model
    Attributes,
    #[allow(missing_docs)] // documentation missing in model
    Savings,
    #[allow(missing_docs)] // documentation missing in model
    Utilization,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SavingsPlansDataType {
    fn from(s: &str) -> Self {
        match s {
            "AMORTIZED_COMMITMENT" => SavingsPlansDataType::AmortizedCommitment,
            "ATTRIBUTES" => SavingsPlansDataType::Attributes,
            "SAVINGS" => SavingsPlansDataType::Savings,
            "UTILIZATION" => SavingsPlansDataType::Utilization,
            other => SavingsPlansDataType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SavingsPlansDataType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SavingsPlansDataType::from(s))
    }
}
impl SavingsPlansDataType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SavingsPlansDataType::AmortizedCommitment => "AMORTIZED_COMMITMENT",
            SavingsPlansDataType::Attributes => "ATTRIBUTES",
            SavingsPlansDataType::Savings => "SAVINGS",
            SavingsPlansDataType::Utilization => "UTILIZATION",
            SavingsPlansDataType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AMORTIZED_COMMITMENT",
            "ATTRIBUTES",
            "SAVINGS",
            "UTILIZATION",
        ]
    }
}
impl AsRef<str> for SavingsPlansDataType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The amount of Savings Plans utilization, in hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansUtilizationByTime {
    /// <p>The time period of the request. </p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
    pub utilization: std::option::Option<crate::model::SavingsPlansUtilization>,
    /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
    pub savings: std::option::Option<crate::model::SavingsPlansSavings>,
    /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
    pub amortized_commitment: std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
}
impl SavingsPlansUtilizationByTime {
    /// <p>The time period of the request. </p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
    pub fn utilization(&self) -> std::option::Option<&crate::model::SavingsPlansUtilization> {
        self.utilization.as_ref()
    }
    /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
    pub fn savings(&self) -> std::option::Option<&crate::model::SavingsPlansSavings> {
        self.savings.as_ref()
    }
    /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
    pub fn amortized_commitment(
        &self,
    ) -> std::option::Option<&crate::model::SavingsPlansAmortizedCommitment> {
        self.amortized_commitment.as_ref()
    }
}
impl std::fmt::Debug for SavingsPlansUtilizationByTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansUtilizationByTime");
        formatter.field("time_period", &self.time_period);
        formatter.field("utilization", &self.utilization);
        formatter.field("savings", &self.savings);
        formatter.field("amortized_commitment", &self.amortized_commitment);
        formatter.finish()
    }
}
/// See [`SavingsPlansUtilizationByTime`](crate::model::SavingsPlansUtilizationByTime)
pub mod savings_plans_utilization_by_time {
    /// A builder for [`SavingsPlansUtilizationByTime`](crate::model::SavingsPlansUtilizationByTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) utilization: std::option::Option<crate::model::SavingsPlansUtilization>,
        pub(crate) savings: std::option::Option<crate::model::SavingsPlansSavings>,
        pub(crate) amortized_commitment:
            std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
    }
    impl Builder {
        /// <p>The time period of the request. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period of the request. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
        pub fn utilization(mut self, input: crate::model::SavingsPlansUtilization) -> Self {
            self.utilization = Some(input);
            self
        }
        /// <p>A ratio of your effectiveness of using existing Savings Plans to apply to workloads that are Savings Plans eligible.</p>
        pub fn set_utilization(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansUtilization>,
        ) -> Self {
            self.utilization = input;
            self
        }
        /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
        pub fn savings(mut self, input: crate::model::SavingsPlansSavings) -> Self {
            self.savings = Some(input);
            self
        }
        /// <p>The amount saved by using existing Savings Plans. Savings returns both net savings from Savings Plans as well as the <code>onDemandCostEquivalent</code> of the Savings Plans when considering the utilization rate.</p>
        pub fn set_savings(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansSavings>,
        ) -> Self {
            self.savings = input;
            self
        }
        /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
        pub fn amortized_commitment(
            mut self,
            input: crate::model::SavingsPlansAmortizedCommitment,
        ) -> Self {
            self.amortized_commitment = Some(input);
            self
        }
        /// <p>The total amortized commitment for a Savings Plans. This includes the sum of the upfront and recurring Savings Plans fees.</p>
        pub fn set_amortized_commitment(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansAmortizedCommitment>,
        ) -> Self {
            self.amortized_commitment = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansUtilizationByTime`](crate::model::SavingsPlansUtilizationByTime)
        pub fn build(self) -> crate::model::SavingsPlansUtilizationByTime {
            crate::model::SavingsPlansUtilizationByTime {
                time_period: self.time_period,
                utilization: self.utilization,
                savings: self.savings,
                amortized_commitment: self.amortized_commitment,
            }
        }
    }
}
impl SavingsPlansUtilizationByTime {
    /// Creates a new builder-style object to manufacture [`SavingsPlansUtilizationByTime`](crate::model::SavingsPlansUtilizationByTime)
    pub fn builder() -> crate::model::savings_plans_utilization_by_time::Builder {
        crate::model::savings_plans_utilization_by_time::Builder::default()
    }
}

/// <p>Contains your request parameters, Savings Plan Recommendations Summary, and Details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansPurchaseRecommendation {
    /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations that include the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    pub account_scope: std::option::Option<crate::model::AccountScope>,
    /// <p>The requested Savings Plans recommendation type.</p>
    pub savings_plans_type: std::option::Option<crate::model::SupportedSavingsPlansType>,
    /// <p>The Savings Plans recommendation term in years. It's used to generate the recommendation.</p>
    pub term_in_years: std::option::Option<crate::model::TermInYears>,
    /// <p>The payment option used to generate the recommendation.</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>The lookback period in days, used to generate the recommendation.</p>
    pub lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
    /// <p>Details for the Savings Plans we recommend that you purchase to cover existing Savings Plans eligible workloads.</p>
    pub savings_plans_purchase_recommendation_details:
        std::option::Option<std::vec::Vec<crate::model::SavingsPlansPurchaseRecommendationDetail>>,
    /// <p>Summary metrics for your Savings Plans Recommendations. </p>
    pub savings_plans_purchase_recommendation_summary:
        std::option::Option<crate::model::SavingsPlansPurchaseRecommendationSummary>,
}
impl SavingsPlansPurchaseRecommendation {
    /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations that include the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    pub fn account_scope(&self) -> std::option::Option<&crate::model::AccountScope> {
        self.account_scope.as_ref()
    }
    /// <p>The requested Savings Plans recommendation type.</p>
    pub fn savings_plans_type(
        &self,
    ) -> std::option::Option<&crate::model::SupportedSavingsPlansType> {
        self.savings_plans_type.as_ref()
    }
    /// <p>The Savings Plans recommendation term in years. It's used to generate the recommendation.</p>
    pub fn term_in_years(&self) -> std::option::Option<&crate::model::TermInYears> {
        self.term_in_years.as_ref()
    }
    /// <p>The payment option used to generate the recommendation.</p>
    pub fn payment_option(&self) -> std::option::Option<&crate::model::PaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The lookback period in days, used to generate the recommendation.</p>
    pub fn lookback_period_in_days(
        &self,
    ) -> std::option::Option<&crate::model::LookbackPeriodInDays> {
        self.lookback_period_in_days.as_ref()
    }
    /// <p>Details for the Savings Plans we recommend that you purchase to cover existing Savings Plans eligible workloads.</p>
    pub fn savings_plans_purchase_recommendation_details(
        &self,
    ) -> std::option::Option<&[crate::model::SavingsPlansPurchaseRecommendationDetail]> {
        self.savings_plans_purchase_recommendation_details
            .as_deref()
    }
    /// <p>Summary metrics for your Savings Plans Recommendations. </p>
    pub fn savings_plans_purchase_recommendation_summary(
        &self,
    ) -> std::option::Option<&crate::model::SavingsPlansPurchaseRecommendationSummary> {
        self.savings_plans_purchase_recommendation_summary.as_ref()
    }
}
impl std::fmt::Debug for SavingsPlansPurchaseRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansPurchaseRecommendation");
        formatter.field("account_scope", &self.account_scope);
        formatter.field("savings_plans_type", &self.savings_plans_type);
        formatter.field("term_in_years", &self.term_in_years);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("lookback_period_in_days", &self.lookback_period_in_days);
        formatter.field(
            "savings_plans_purchase_recommendation_details",
            &self.savings_plans_purchase_recommendation_details,
        );
        formatter.field(
            "savings_plans_purchase_recommendation_summary",
            &self.savings_plans_purchase_recommendation_summary,
        );
        formatter.finish()
    }
}
/// See [`SavingsPlansPurchaseRecommendation`](crate::model::SavingsPlansPurchaseRecommendation)
pub mod savings_plans_purchase_recommendation {
    /// A builder for [`SavingsPlansPurchaseRecommendation`](crate::model::SavingsPlansPurchaseRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_scope: std::option::Option<crate::model::AccountScope>,
        pub(crate) savings_plans_type: std::option::Option<crate::model::SupportedSavingsPlansType>,
        pub(crate) term_in_years: std::option::Option<crate::model::TermInYears>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
        pub(crate) savings_plans_purchase_recommendation_details: std::option::Option<
            std::vec::Vec<crate::model::SavingsPlansPurchaseRecommendationDetail>,
        >,
        pub(crate) savings_plans_purchase_recommendation_summary:
            std::option::Option<crate::model::SavingsPlansPurchaseRecommendationSummary>,
    }
    impl Builder {
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations that include the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn account_scope(mut self, input: crate::model::AccountScope) -> Self {
            self.account_scope = Some(input);
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations that include the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn set_account_scope(
            mut self,
            input: std::option::Option<crate::model::AccountScope>,
        ) -> Self {
            self.account_scope = input;
            self
        }
        /// <p>The requested Savings Plans recommendation type.</p>
        pub fn savings_plans_type(
            mut self,
            input: crate::model::SupportedSavingsPlansType,
        ) -> Self {
            self.savings_plans_type = Some(input);
            self
        }
        /// <p>The requested Savings Plans recommendation type.</p>
        pub fn set_savings_plans_type(
            mut self,
            input: std::option::Option<crate::model::SupportedSavingsPlansType>,
        ) -> Self {
            self.savings_plans_type = input;
            self
        }
        /// <p>The Savings Plans recommendation term in years. It's used to generate the recommendation.</p>
        pub fn term_in_years(mut self, input: crate::model::TermInYears) -> Self {
            self.term_in_years = Some(input);
            self
        }
        /// <p>The Savings Plans recommendation term in years. It's used to generate the recommendation.</p>
        pub fn set_term_in_years(
            mut self,
            input: std::option::Option<crate::model::TermInYears>,
        ) -> Self {
            self.term_in_years = input;
            self
        }
        /// <p>The payment option used to generate the recommendation.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option used to generate the recommendation.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The lookback period in days, used to generate the recommendation.</p>
        pub fn lookback_period_in_days(
            mut self,
            input: crate::model::LookbackPeriodInDays,
        ) -> Self {
            self.lookback_period_in_days = Some(input);
            self
        }
        /// <p>The lookback period in days, used to generate the recommendation.</p>
        pub fn set_lookback_period_in_days(
            mut self,
            input: std::option::Option<crate::model::LookbackPeriodInDays>,
        ) -> Self {
            self.lookback_period_in_days = input;
            self
        }
        /// Appends an item to `savings_plans_purchase_recommendation_details`.
        ///
        /// To override the contents of this collection use [`set_savings_plans_purchase_recommendation_details`](Self::set_savings_plans_purchase_recommendation_details).
        ///
        /// <p>Details for the Savings Plans we recommend that you purchase to cover existing Savings Plans eligible workloads.</p>
        pub fn savings_plans_purchase_recommendation_details(
            mut self,
            input: crate::model::SavingsPlansPurchaseRecommendationDetail,
        ) -> Self {
            let mut v = self
                .savings_plans_purchase_recommendation_details
                .unwrap_or_default();
            v.push(input);
            self.savings_plans_purchase_recommendation_details = Some(v);
            self
        }
        /// <p>Details for the Savings Plans we recommend that you purchase to cover existing Savings Plans eligible workloads.</p>
        pub fn set_savings_plans_purchase_recommendation_details(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SavingsPlansPurchaseRecommendationDetail>,
            >,
        ) -> Self {
            self.savings_plans_purchase_recommendation_details = input;
            self
        }
        /// <p>Summary metrics for your Savings Plans Recommendations. </p>
        pub fn savings_plans_purchase_recommendation_summary(
            mut self,
            input: crate::model::SavingsPlansPurchaseRecommendationSummary,
        ) -> Self {
            self.savings_plans_purchase_recommendation_summary = Some(input);
            self
        }
        /// <p>Summary metrics for your Savings Plans Recommendations. </p>
        pub fn set_savings_plans_purchase_recommendation_summary(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansPurchaseRecommendationSummary>,
        ) -> Self {
            self.savings_plans_purchase_recommendation_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansPurchaseRecommendation`](crate::model::SavingsPlansPurchaseRecommendation)
        pub fn build(self) -> crate::model::SavingsPlansPurchaseRecommendation {
            crate::model::SavingsPlansPurchaseRecommendation {
                account_scope: self.account_scope,
                savings_plans_type: self.savings_plans_type,
                term_in_years: self.term_in_years,
                payment_option: self.payment_option,
                lookback_period_in_days: self.lookback_period_in_days,
                savings_plans_purchase_recommendation_details: self
                    .savings_plans_purchase_recommendation_details,
                savings_plans_purchase_recommendation_summary: self
                    .savings_plans_purchase_recommendation_summary,
            }
        }
    }
}
impl SavingsPlansPurchaseRecommendation {
    /// Creates a new builder-style object to manufacture [`SavingsPlansPurchaseRecommendation`](crate::model::SavingsPlansPurchaseRecommendation)
    pub fn builder() -> crate::model::savings_plans_purchase_recommendation::Builder {
        crate::model::savings_plans_purchase_recommendation::Builder::default()
    }
}

/// <p>Summary metrics for your Savings Plans Purchase Recommendations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansPurchaseRecommendationSummary {
    /// <p>The estimated return on investment that's based on the recommended Savings Plans and estimated savings.</p>
    pub estimated_roi: std::option::Option<std::string::String>,
    /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the cost of Savings Plans during this term, and the remaining On-Demand usage.</p>
    pub estimated_total_cost: std::option::Option<std::string::String>,
    /// <p>The current total on demand spend of the applicable usage types over the lookback period.</p>
    pub current_on_demand_spend: std::option::Option<std::string::String>,
    /// <p>The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.</p>
    pub estimated_savings_amount: std::option::Option<std::string::String>,
    /// <p>The aggregate number of Savings Plans recommendations that exist for your account.</p>
    pub total_recommendation_count: std::option::Option<std::string::String>,
    /// <p>The recommended Savings Plans cost on a daily (24 hourly) basis.</p>
    pub daily_commitment_to_purchase: std::option::Option<std::string::String>,
    /// <p>The recommended hourly commitment that's based on the recommendation parameters.</p>
    pub hourly_commitment_to_purchase: std::option::Option<std::string::String>,
    /// <p>The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is calculated as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.</p>
    pub estimated_savings_percentage: std::option::Option<std::string::String>,
    /// <p>The estimated monthly savings amount that's based on the recommended Savings Plans purchase.</p>
    pub estimated_monthly_savings_amount: std::option::Option<std::string::String>,
    /// <p> The estimated On-Demand costs you would expect with no additional commitment. It's based on your usage of the selected time period and the Savings Plans you own. </p>
    pub estimated_on_demand_cost_with_current_commitment: std::option::Option<std::string::String>,
}
impl SavingsPlansPurchaseRecommendationSummary {
    /// <p>The estimated return on investment that's based on the recommended Savings Plans and estimated savings.</p>
    pub fn estimated_roi(&self) -> std::option::Option<&str> {
        self.estimated_roi.as_deref()
    }
    /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the cost of Savings Plans during this term, and the remaining On-Demand usage.</p>
    pub fn estimated_total_cost(&self) -> std::option::Option<&str> {
        self.estimated_total_cost.as_deref()
    }
    /// <p>The current total on demand spend of the applicable usage types over the lookback period.</p>
    pub fn current_on_demand_spend(&self) -> std::option::Option<&str> {
        self.current_on_demand_spend.as_deref()
    }
    /// <p>The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.</p>
    pub fn estimated_savings_amount(&self) -> std::option::Option<&str> {
        self.estimated_savings_amount.as_deref()
    }
    /// <p>The aggregate number of Savings Plans recommendations that exist for your account.</p>
    pub fn total_recommendation_count(&self) -> std::option::Option<&str> {
        self.total_recommendation_count.as_deref()
    }
    /// <p>The recommended Savings Plans cost on a daily (24 hourly) basis.</p>
    pub fn daily_commitment_to_purchase(&self) -> std::option::Option<&str> {
        self.daily_commitment_to_purchase.as_deref()
    }
    /// <p>The recommended hourly commitment that's based on the recommendation parameters.</p>
    pub fn hourly_commitment_to_purchase(&self) -> std::option::Option<&str> {
        self.hourly_commitment_to_purchase.as_deref()
    }
    /// <p>The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is calculated as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.</p>
    pub fn estimated_savings_percentage(&self) -> std::option::Option<&str> {
        self.estimated_savings_percentage.as_deref()
    }
    /// <p>The estimated monthly savings amount that's based on the recommended Savings Plans purchase.</p>
    pub fn estimated_monthly_savings_amount(&self) -> std::option::Option<&str> {
        self.estimated_monthly_savings_amount.as_deref()
    }
    /// <p> The estimated On-Demand costs you would expect with no additional commitment. It's based on your usage of the selected time period and the Savings Plans you own. </p>
    pub fn estimated_on_demand_cost_with_current_commitment(&self) -> std::option::Option<&str> {
        self.estimated_on_demand_cost_with_current_commitment
            .as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansPurchaseRecommendationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansPurchaseRecommendationSummary");
        formatter.field("estimated_roi", &self.estimated_roi);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("estimated_total_cost", &self.estimated_total_cost);
        formatter.field("current_on_demand_spend", &self.current_on_demand_spend);
        formatter.field("estimated_savings_amount", &self.estimated_savings_amount);
        formatter.field(
            "total_recommendation_count",
            &self.total_recommendation_count,
        );
        formatter.field(
            "daily_commitment_to_purchase",
            &self.daily_commitment_to_purchase,
        );
        formatter.field(
            "hourly_commitment_to_purchase",
            &self.hourly_commitment_to_purchase,
        );
        formatter.field(
            "estimated_savings_percentage",
            &self.estimated_savings_percentage,
        );
        formatter.field(
            "estimated_monthly_savings_amount",
            &self.estimated_monthly_savings_amount,
        );
        formatter.field(
            "estimated_on_demand_cost_with_current_commitment",
            &self.estimated_on_demand_cost_with_current_commitment,
        );
        formatter.finish()
    }
}
/// See [`SavingsPlansPurchaseRecommendationSummary`](crate::model::SavingsPlansPurchaseRecommendationSummary)
pub mod savings_plans_purchase_recommendation_summary {
    /// A builder for [`SavingsPlansPurchaseRecommendationSummary`](crate::model::SavingsPlansPurchaseRecommendationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) estimated_roi: std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) estimated_total_cost: std::option::Option<std::string::String>,
        pub(crate) current_on_demand_spend: std::option::Option<std::string::String>,
        pub(crate) estimated_savings_amount: std::option::Option<std::string::String>,
        pub(crate) total_recommendation_count: std::option::Option<std::string::String>,
        pub(crate) daily_commitment_to_purchase: std::option::Option<std::string::String>,
        pub(crate) hourly_commitment_to_purchase: std::option::Option<std::string::String>,
        pub(crate) estimated_savings_percentage: std::option::Option<std::string::String>,
        pub(crate) estimated_monthly_savings_amount: std::option::Option<std::string::String>,
        pub(crate) estimated_on_demand_cost_with_current_commitment:
            std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The estimated return on investment that's based on the recommended Savings Plans and estimated savings.</p>
        pub fn estimated_roi(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_roi = Some(input.into());
            self
        }
        /// <p>The estimated return on investment that's based on the recommended Savings Plans and estimated savings.</p>
        pub fn set_estimated_roi(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_roi = input;
            self
        }
        /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the cost of Savings Plans during this term, and the remaining On-Demand usage.</p>
        pub fn estimated_total_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_total_cost = Some(input.into());
            self
        }
        /// <p>The estimated total cost of the usage after purchasing the recommended Savings Plans. This is a sum of the cost of Savings Plans during this term, and the remaining On-Demand usage.</p>
        pub fn set_estimated_total_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_total_cost = input;
            self
        }
        /// <p>The current total on demand spend of the applicable usage types over the lookback period.</p>
        pub fn current_on_demand_spend(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_on_demand_spend = Some(input.into());
            self
        }
        /// <p>The current total on demand spend of the applicable usage types over the lookback period.</p>
        pub fn set_current_on_demand_spend(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_on_demand_spend = input;
            self
        }
        /// <p>The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.</p>
        pub fn estimated_savings_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_savings_amount = Some(input.into());
            self
        }
        /// <p>The estimated total savings over the lookback period, based on the purchase of the recommended Savings Plans.</p>
        pub fn set_estimated_savings_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_savings_amount = input;
            self
        }
        /// <p>The aggregate number of Savings Plans recommendations that exist for your account.</p>
        pub fn total_recommendation_count(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_recommendation_count = Some(input.into());
            self
        }
        /// <p>The aggregate number of Savings Plans recommendations that exist for your account.</p>
        pub fn set_total_recommendation_count(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_recommendation_count = input;
            self
        }
        /// <p>The recommended Savings Plans cost on a daily (24 hourly) basis.</p>
        pub fn daily_commitment_to_purchase(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.daily_commitment_to_purchase = Some(input.into());
            self
        }
        /// <p>The recommended Savings Plans cost on a daily (24 hourly) basis.</p>
        pub fn set_daily_commitment_to_purchase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.daily_commitment_to_purchase = input;
            self
        }
        /// <p>The recommended hourly commitment that's based on the recommendation parameters.</p>
        pub fn hourly_commitment_to_purchase(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hourly_commitment_to_purchase = Some(input.into());
            self
        }
        /// <p>The recommended hourly commitment that's based on the recommendation parameters.</p>
        pub fn set_hourly_commitment_to_purchase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hourly_commitment_to_purchase = input;
            self
        }
        /// <p>The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is calculated as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.</p>
        pub fn estimated_savings_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_savings_percentage = Some(input.into());
            self
        }
        /// <p>The estimated savings relative to the total cost of On-Demand usage, over the lookback period. This is calculated as <code>estimatedSavingsAmount</code>/ <code>CurrentOnDemandSpend</code>*100.</p>
        pub fn set_estimated_savings_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_savings_percentage = input;
            self
        }
        /// <p>The estimated monthly savings amount that's based on the recommended Savings Plans purchase.</p>
        pub fn estimated_monthly_savings_amount(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_amount = Some(input.into());
            self
        }
        /// <p>The estimated monthly savings amount that's based on the recommended Savings Plans purchase.</p>
        pub fn set_estimated_monthly_savings_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_amount = input;
            self
        }
        /// <p> The estimated On-Demand costs you would expect with no additional commitment. It's based on your usage of the selected time period and the Savings Plans you own. </p>
        pub fn estimated_on_demand_cost_with_current_commitment(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_on_demand_cost_with_current_commitment = Some(input.into());
            self
        }
        /// <p> The estimated On-Demand costs you would expect with no additional commitment. It's based on your usage of the selected time period and the Savings Plans you own. </p>
        pub fn set_estimated_on_demand_cost_with_current_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_on_demand_cost_with_current_commitment = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansPurchaseRecommendationSummary`](crate::model::SavingsPlansPurchaseRecommendationSummary)
        pub fn build(self) -> crate::model::SavingsPlansPurchaseRecommendationSummary {
            crate::model::SavingsPlansPurchaseRecommendationSummary {
                estimated_roi: self.estimated_roi,
                currency_code: self.currency_code,
                estimated_total_cost: self.estimated_total_cost,
                current_on_demand_spend: self.current_on_demand_spend,
                estimated_savings_amount: self.estimated_savings_amount,
                total_recommendation_count: self.total_recommendation_count,
                daily_commitment_to_purchase: self.daily_commitment_to_purchase,
                hourly_commitment_to_purchase: self.hourly_commitment_to_purchase,
                estimated_savings_percentage: self.estimated_savings_percentage,
                estimated_monthly_savings_amount: self.estimated_monthly_savings_amount,
                estimated_on_demand_cost_with_current_commitment: self
                    .estimated_on_demand_cost_with_current_commitment,
            }
        }
    }
}
impl SavingsPlansPurchaseRecommendationSummary {
    /// Creates a new builder-style object to manufacture [`SavingsPlansPurchaseRecommendationSummary`](crate::model::SavingsPlansPurchaseRecommendationSummary)
    pub fn builder() -> crate::model::savings_plans_purchase_recommendation_summary::Builder {
        crate::model::savings_plans_purchase_recommendation_summary::Builder::default()
    }
}

/// <p>Details for your recommended Savings Plans.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansPurchaseRecommendationDetail {
    /// <p>Details for your recommended Savings Plans.</p>
    pub savings_plans_details: std::option::Option<crate::model::SavingsPlansDetails>,
    /// <p>The <code>AccountID</code> the recommendation is generated for.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The upfront cost of the recommended Savings Plans, based on the selected payment option.</p>
    pub upfront_cost: std::option::Option<std::string::String>,
    /// <p>The estimated return on investment that's based on the recommended Savings Plans that you purchased. This is calculated as <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.</p>
    pub estimated_roi: std::option::Option<std::string::String>,
    /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>The cost of the recommended Savings Plans over the length of the lookback period.</p>
    pub estimated_sp_cost: std::option::Option<std::string::String>,
    /// <p>The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of the lookback period.</p>
    pub estimated_on_demand_cost: std::option::Option<std::string::String>,
    /// <p> The estimated On-Demand costs you would expect with no additional commitment, based on your usage of the selected time period and the Savings Plans you own. </p>
    pub estimated_on_demand_cost_with_current_commitment: std::option::Option<std::string::String>,
    /// <p>The estimated savings amount that's based on the recommended Savings Plans over the length of the lookback period.</p>
    pub estimated_savings_amount: std::option::Option<std::string::String>,
    /// <p>The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback period.</p>
    pub estimated_savings_percentage: std::option::Option<std::string::String>,
    /// <p>The recommended hourly commitment level for the Savings Plans type and the configuration that's based on the usage during the lookback period.</p>
    pub hourly_commitment_to_purchase: std::option::Option<std::string::String>,
    /// <p>The estimated utilization of the recommended Savings Plans.</p>
    pub estimated_average_utilization: std::option::Option<std::string::String>,
    /// <p>The estimated monthly savings amount based on the recommended Savings Plans.</p>
    pub estimated_monthly_savings_amount: std::option::Option<std::string::String>,
    /// <p>The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
    pub current_minimum_hourly_on_demand_spend: std::option::Option<std::string::String>,
    /// <p>The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
    pub current_maximum_hourly_on_demand_spend: std::option::Option<std::string::String>,
    /// <p>The average value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
    pub current_average_hourly_on_demand_spend: std::option::Option<std::string::String>,
}
impl SavingsPlansPurchaseRecommendationDetail {
    /// <p>Details for your recommended Savings Plans.</p>
    pub fn savings_plans_details(&self) -> std::option::Option<&crate::model::SavingsPlansDetails> {
        self.savings_plans_details.as_ref()
    }
    /// <p>The <code>AccountID</code> the recommendation is generated for.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The upfront cost of the recommended Savings Plans, based on the selected payment option.</p>
    pub fn upfront_cost(&self) -> std::option::Option<&str> {
        self.upfront_cost.as_deref()
    }
    /// <p>The estimated return on investment that's based on the recommended Savings Plans that you purchased. This is calculated as <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.</p>
    pub fn estimated_roi(&self) -> std::option::Option<&str> {
        self.estimated_roi.as_deref()
    }
    /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>The cost of the recommended Savings Plans over the length of the lookback period.</p>
    pub fn estimated_sp_cost(&self) -> std::option::Option<&str> {
        self.estimated_sp_cost.as_deref()
    }
    /// <p>The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of the lookback period.</p>
    pub fn estimated_on_demand_cost(&self) -> std::option::Option<&str> {
        self.estimated_on_demand_cost.as_deref()
    }
    /// <p> The estimated On-Demand costs you would expect with no additional commitment, based on your usage of the selected time period and the Savings Plans you own. </p>
    pub fn estimated_on_demand_cost_with_current_commitment(&self) -> std::option::Option<&str> {
        self.estimated_on_demand_cost_with_current_commitment
            .as_deref()
    }
    /// <p>The estimated savings amount that's based on the recommended Savings Plans over the length of the lookback period.</p>
    pub fn estimated_savings_amount(&self) -> std::option::Option<&str> {
        self.estimated_savings_amount.as_deref()
    }
    /// <p>The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback period.</p>
    pub fn estimated_savings_percentage(&self) -> std::option::Option<&str> {
        self.estimated_savings_percentage.as_deref()
    }
    /// <p>The recommended hourly commitment level for the Savings Plans type and the configuration that's based on the usage during the lookback period.</p>
    pub fn hourly_commitment_to_purchase(&self) -> std::option::Option<&str> {
        self.hourly_commitment_to_purchase.as_deref()
    }
    /// <p>The estimated utilization of the recommended Savings Plans.</p>
    pub fn estimated_average_utilization(&self) -> std::option::Option<&str> {
        self.estimated_average_utilization.as_deref()
    }
    /// <p>The estimated monthly savings amount based on the recommended Savings Plans.</p>
    pub fn estimated_monthly_savings_amount(&self) -> std::option::Option<&str> {
        self.estimated_monthly_savings_amount.as_deref()
    }
    /// <p>The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
    pub fn current_minimum_hourly_on_demand_spend(&self) -> std::option::Option<&str> {
        self.current_minimum_hourly_on_demand_spend.as_deref()
    }
    /// <p>The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
    pub fn current_maximum_hourly_on_demand_spend(&self) -> std::option::Option<&str> {
        self.current_maximum_hourly_on_demand_spend.as_deref()
    }
    /// <p>The average value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
    pub fn current_average_hourly_on_demand_spend(&self) -> std::option::Option<&str> {
        self.current_average_hourly_on_demand_spend.as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansPurchaseRecommendationDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansPurchaseRecommendationDetail");
        formatter.field("savings_plans_details", &self.savings_plans_details);
        formatter.field("account_id", &self.account_id);
        formatter.field("upfront_cost", &self.upfront_cost);
        formatter.field("estimated_roi", &self.estimated_roi);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("estimated_sp_cost", &self.estimated_sp_cost);
        formatter.field("estimated_on_demand_cost", &self.estimated_on_demand_cost);
        formatter.field(
            "estimated_on_demand_cost_with_current_commitment",
            &self.estimated_on_demand_cost_with_current_commitment,
        );
        formatter.field("estimated_savings_amount", &self.estimated_savings_amount);
        formatter.field(
            "estimated_savings_percentage",
            &self.estimated_savings_percentage,
        );
        formatter.field(
            "hourly_commitment_to_purchase",
            &self.hourly_commitment_to_purchase,
        );
        formatter.field(
            "estimated_average_utilization",
            &self.estimated_average_utilization,
        );
        formatter.field(
            "estimated_monthly_savings_amount",
            &self.estimated_monthly_savings_amount,
        );
        formatter.field(
            "current_minimum_hourly_on_demand_spend",
            &self.current_minimum_hourly_on_demand_spend,
        );
        formatter.field(
            "current_maximum_hourly_on_demand_spend",
            &self.current_maximum_hourly_on_demand_spend,
        );
        formatter.field(
            "current_average_hourly_on_demand_spend",
            &self.current_average_hourly_on_demand_spend,
        );
        formatter.finish()
    }
}
/// See [`SavingsPlansPurchaseRecommendationDetail`](crate::model::SavingsPlansPurchaseRecommendationDetail)
pub mod savings_plans_purchase_recommendation_detail {
    /// A builder for [`SavingsPlansPurchaseRecommendationDetail`](crate::model::SavingsPlansPurchaseRecommendationDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plans_details: std::option::Option<crate::model::SavingsPlansDetails>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) upfront_cost: std::option::Option<std::string::String>,
        pub(crate) estimated_roi: std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) estimated_sp_cost: std::option::Option<std::string::String>,
        pub(crate) estimated_on_demand_cost: std::option::Option<std::string::String>,
        pub(crate) estimated_on_demand_cost_with_current_commitment:
            std::option::Option<std::string::String>,
        pub(crate) estimated_savings_amount: std::option::Option<std::string::String>,
        pub(crate) estimated_savings_percentage: std::option::Option<std::string::String>,
        pub(crate) hourly_commitment_to_purchase: std::option::Option<std::string::String>,
        pub(crate) estimated_average_utilization: std::option::Option<std::string::String>,
        pub(crate) estimated_monthly_savings_amount: std::option::Option<std::string::String>,
        pub(crate) current_minimum_hourly_on_demand_spend: std::option::Option<std::string::String>,
        pub(crate) current_maximum_hourly_on_demand_spend: std::option::Option<std::string::String>,
        pub(crate) current_average_hourly_on_demand_spend: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Details for your recommended Savings Plans.</p>
        pub fn savings_plans_details(mut self, input: crate::model::SavingsPlansDetails) -> Self {
            self.savings_plans_details = Some(input);
            self
        }
        /// <p>Details for your recommended Savings Plans.</p>
        pub fn set_savings_plans_details(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansDetails>,
        ) -> Self {
            self.savings_plans_details = input;
            self
        }
        /// <p>The <code>AccountID</code> the recommendation is generated for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The <code>AccountID</code> the recommendation is generated for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The upfront cost of the recommended Savings Plans, based on the selected payment option.</p>
        pub fn upfront_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.upfront_cost = Some(input.into());
            self
        }
        /// <p>The upfront cost of the recommended Savings Plans, based on the selected payment option.</p>
        pub fn set_upfront_cost(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upfront_cost = input;
            self
        }
        /// <p>The estimated return on investment that's based on the recommended Savings Plans that you purchased. This is calculated as <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.</p>
        pub fn estimated_roi(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_roi = Some(input.into());
            self
        }
        /// <p>The estimated return on investment that's based on the recommended Savings Plans that you purchased. This is calculated as <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.</p>
        pub fn set_estimated_roi(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_roi = input;
            self
        }
        /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code that Amazon Web Services used to generate the recommendations and present potential savings.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>The cost of the recommended Savings Plans over the length of the lookback period.</p>
        pub fn estimated_sp_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_sp_cost = Some(input.into());
            self
        }
        /// <p>The cost of the recommended Savings Plans over the length of the lookback period.</p>
        pub fn set_estimated_sp_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_sp_cost = input;
            self
        }
        /// <p>The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of the lookback period.</p>
        pub fn estimated_on_demand_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_on_demand_cost = Some(input.into());
            self
        }
        /// <p>The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of the lookback period.</p>
        pub fn set_estimated_on_demand_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_on_demand_cost = input;
            self
        }
        /// <p> The estimated On-Demand costs you would expect with no additional commitment, based on your usage of the selected time period and the Savings Plans you own. </p>
        pub fn estimated_on_demand_cost_with_current_commitment(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_on_demand_cost_with_current_commitment = Some(input.into());
            self
        }
        /// <p> The estimated On-Demand costs you would expect with no additional commitment, based on your usage of the selected time period and the Savings Plans you own. </p>
        pub fn set_estimated_on_demand_cost_with_current_commitment(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_on_demand_cost_with_current_commitment = input;
            self
        }
        /// <p>The estimated savings amount that's based on the recommended Savings Plans over the length of the lookback period.</p>
        pub fn estimated_savings_amount(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_savings_amount = Some(input.into());
            self
        }
        /// <p>The estimated savings amount that's based on the recommended Savings Plans over the length of the lookback period.</p>
        pub fn set_estimated_savings_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_savings_amount = input;
            self
        }
        /// <p>The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback period.</p>
        pub fn estimated_savings_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_savings_percentage = Some(input.into());
            self
        }
        /// <p>The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback period.</p>
        pub fn set_estimated_savings_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_savings_percentage = input;
            self
        }
        /// <p>The recommended hourly commitment level for the Savings Plans type and the configuration that's based on the usage during the lookback period.</p>
        pub fn hourly_commitment_to_purchase(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hourly_commitment_to_purchase = Some(input.into());
            self
        }
        /// <p>The recommended hourly commitment level for the Savings Plans type and the configuration that's based on the usage during the lookback period.</p>
        pub fn set_hourly_commitment_to_purchase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hourly_commitment_to_purchase = input;
            self
        }
        /// <p>The estimated utilization of the recommended Savings Plans.</p>
        pub fn estimated_average_utilization(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_average_utilization = Some(input.into());
            self
        }
        /// <p>The estimated utilization of the recommended Savings Plans.</p>
        pub fn set_estimated_average_utilization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_average_utilization = input;
            self
        }
        /// <p>The estimated monthly savings amount based on the recommended Savings Plans.</p>
        pub fn estimated_monthly_savings_amount(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_amount = Some(input.into());
            self
        }
        /// <p>The estimated monthly savings amount based on the recommended Savings Plans.</p>
        pub fn set_estimated_monthly_savings_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_amount = input;
            self
        }
        /// <p>The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
        pub fn current_minimum_hourly_on_demand_spend(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_minimum_hourly_on_demand_spend = Some(input.into());
            self
        }
        /// <p>The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
        pub fn set_current_minimum_hourly_on_demand_spend(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_minimum_hourly_on_demand_spend = input;
            self
        }
        /// <p>The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
        pub fn current_maximum_hourly_on_demand_spend(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_maximum_hourly_on_demand_spend = Some(input.into());
            self
        }
        /// <p>The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
        pub fn set_current_maximum_hourly_on_demand_spend(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_maximum_hourly_on_demand_spend = input;
            self
        }
        /// <p>The average value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
        pub fn current_average_hourly_on_demand_spend(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.current_average_hourly_on_demand_spend = Some(input.into());
            self
        }
        /// <p>The average value of hourly On-Demand spend over the lookback period of the applicable usage type.</p>
        pub fn set_current_average_hourly_on_demand_spend(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_average_hourly_on_demand_spend = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansPurchaseRecommendationDetail`](crate::model::SavingsPlansPurchaseRecommendationDetail)
        pub fn build(self) -> crate::model::SavingsPlansPurchaseRecommendationDetail {
            crate::model::SavingsPlansPurchaseRecommendationDetail {
                savings_plans_details: self.savings_plans_details,
                account_id: self.account_id,
                upfront_cost: self.upfront_cost,
                estimated_roi: self.estimated_roi,
                currency_code: self.currency_code,
                estimated_sp_cost: self.estimated_sp_cost,
                estimated_on_demand_cost: self.estimated_on_demand_cost,
                estimated_on_demand_cost_with_current_commitment: self
                    .estimated_on_demand_cost_with_current_commitment,
                estimated_savings_amount: self.estimated_savings_amount,
                estimated_savings_percentage: self.estimated_savings_percentage,
                hourly_commitment_to_purchase: self.hourly_commitment_to_purchase,
                estimated_average_utilization: self.estimated_average_utilization,
                estimated_monthly_savings_amount: self.estimated_monthly_savings_amount,
                current_minimum_hourly_on_demand_spend: self.current_minimum_hourly_on_demand_spend,
                current_maximum_hourly_on_demand_spend: self.current_maximum_hourly_on_demand_spend,
                current_average_hourly_on_demand_spend: self.current_average_hourly_on_demand_spend,
            }
        }
    }
}
impl SavingsPlansPurchaseRecommendationDetail {
    /// Creates a new builder-style object to manufacture [`SavingsPlansPurchaseRecommendationDetail`](crate::model::SavingsPlansPurchaseRecommendationDetail)
    pub fn builder() -> crate::model::savings_plans_purchase_recommendation_detail::Builder {
        crate::model::savings_plans_purchase_recommendation_detail::Builder::default()
    }
}

/// <p>The attribute details on a specific Savings Plan.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansDetails {
    /// <p>A collection of Amazon Web Services resources in a geographic area. Each Amazon Web Services Region is isolated and independent of the other Regions.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>A group of instance types that Savings Plans applies to.</p>
    pub instance_family: std::option::Option<std::string::String>,
    /// <p>The unique ID that's used to distinguish Savings Plans from one another.</p>
    pub offering_id: std::option::Option<std::string::String>,
}
impl SavingsPlansDetails {
    /// <p>A collection of Amazon Web Services resources in a geographic area. Each Amazon Web Services Region is isolated and independent of the other Regions.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>A group of instance types that Savings Plans applies to.</p>
    pub fn instance_family(&self) -> std::option::Option<&str> {
        self.instance_family.as_deref()
    }
    /// <p>The unique ID that's used to distinguish Savings Plans from one another.</p>
    pub fn offering_id(&self) -> std::option::Option<&str> {
        self.offering_id.as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansDetails");
        formatter.field("region", &self.region);
        formatter.field("instance_family", &self.instance_family);
        formatter.field("offering_id", &self.offering_id);
        formatter.finish()
    }
}
/// See [`SavingsPlansDetails`](crate::model::SavingsPlansDetails)
pub mod savings_plans_details {
    /// A builder for [`SavingsPlansDetails`](crate::model::SavingsPlansDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) instance_family: std::option::Option<std::string::String>,
        pub(crate) offering_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A collection of Amazon Web Services resources in a geographic area. Each Amazon Web Services Region is isolated and independent of the other Regions.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>A collection of Amazon Web Services resources in a geographic area. Each Amazon Web Services Region is isolated and independent of the other Regions.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>A group of instance types that Savings Plans applies to.</p>
        pub fn instance_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_family = Some(input.into());
            self
        }
        /// <p>A group of instance types that Savings Plans applies to.</p>
        pub fn set_instance_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_family = input;
            self
        }
        /// <p>The unique ID that's used to distinguish Savings Plans from one another.</p>
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// <p>The unique ID that's used to distinguish Savings Plans from one another.</p>
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansDetails`](crate::model::SavingsPlansDetails)
        pub fn build(self) -> crate::model::SavingsPlansDetails {
            crate::model::SavingsPlansDetails {
                region: self.region,
                instance_family: self.instance_family,
                offering_id: self.offering_id,
            }
        }
    }
}
impl SavingsPlansDetails {
    /// Creates a new builder-style object to manufacture [`SavingsPlansDetails`](crate::model::SavingsPlansDetails)
    pub fn builder() -> crate::model::savings_plans_details::Builder {
        crate::model::savings_plans_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LookbackPeriodInDays {
    #[allow(missing_docs)] // documentation missing in model
    SevenDays,
    #[allow(missing_docs)] // documentation missing in model
    SixtyDays,
    #[allow(missing_docs)] // documentation missing in model
    ThirtyDays,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LookbackPeriodInDays {
    fn from(s: &str) -> Self {
        match s {
            "SEVEN_DAYS" => LookbackPeriodInDays::SevenDays,
            "SIXTY_DAYS" => LookbackPeriodInDays::SixtyDays,
            "THIRTY_DAYS" => LookbackPeriodInDays::ThirtyDays,
            other => LookbackPeriodInDays::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LookbackPeriodInDays {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LookbackPeriodInDays::from(s))
    }
}
impl LookbackPeriodInDays {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LookbackPeriodInDays::SevenDays => "SEVEN_DAYS",
            LookbackPeriodInDays::SixtyDays => "SIXTY_DAYS",
            LookbackPeriodInDays::ThirtyDays => "THIRTY_DAYS",
            LookbackPeriodInDays::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SEVEN_DAYS", "SIXTY_DAYS", "THIRTY_DAYS"]
    }
}
impl AsRef<str> for LookbackPeriodInDays {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PaymentOption {
    #[allow(missing_docs)] // documentation missing in model
    AllUpfront,
    #[allow(missing_docs)] // documentation missing in model
    HeavyUtilization,
    #[allow(missing_docs)] // documentation missing in model
    LightUtilization,
    #[allow(missing_docs)] // documentation missing in model
    MediumUtilization,
    #[allow(missing_docs)] // documentation missing in model
    NoUpfront,
    #[allow(missing_docs)] // documentation missing in model
    PartialUpfront,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PaymentOption {
    fn from(s: &str) -> Self {
        match s {
            "ALL_UPFRONT" => PaymentOption::AllUpfront,
            "HEAVY_UTILIZATION" => PaymentOption::HeavyUtilization,
            "LIGHT_UTILIZATION" => PaymentOption::LightUtilization,
            "MEDIUM_UTILIZATION" => PaymentOption::MediumUtilization,
            "NO_UPFRONT" => PaymentOption::NoUpfront,
            "PARTIAL_UPFRONT" => PaymentOption::PartialUpfront,
            other => PaymentOption::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PaymentOption {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PaymentOption::from(s))
    }
}
impl PaymentOption {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PaymentOption::AllUpfront => "ALL_UPFRONT",
            PaymentOption::HeavyUtilization => "HEAVY_UTILIZATION",
            PaymentOption::LightUtilization => "LIGHT_UTILIZATION",
            PaymentOption::MediumUtilization => "MEDIUM_UTILIZATION",
            PaymentOption::NoUpfront => "NO_UPFRONT",
            PaymentOption::PartialUpfront => "PARTIAL_UPFRONT",
            PaymentOption::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALL_UPFRONT",
            "HEAVY_UTILIZATION",
            "LIGHT_UTILIZATION",
            "MEDIUM_UTILIZATION",
            "NO_UPFRONT",
            "PARTIAL_UPFRONT",
        ]
    }
}
impl AsRef<str> for PaymentOption {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TermInYears {
    #[allow(missing_docs)] // documentation missing in model
    OneYear,
    #[allow(missing_docs)] // documentation missing in model
    ThreeYears,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TermInYears {
    fn from(s: &str) -> Self {
        match s {
            "ONE_YEAR" => TermInYears::OneYear,
            "THREE_YEARS" => TermInYears::ThreeYears,
            other => TermInYears::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TermInYears {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TermInYears::from(s))
    }
}
impl TermInYears {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TermInYears::OneYear => "ONE_YEAR",
            TermInYears::ThreeYears => "THREE_YEARS",
            TermInYears::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONE_YEAR", "THREE_YEARS"]
    }
}
impl AsRef<str> for TermInYears {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SupportedSavingsPlansType {
    #[allow(missing_docs)] // documentation missing in model
    ComputeSp,
    #[allow(missing_docs)] // documentation missing in model
    Ec2InstanceSp,
    #[allow(missing_docs)] // documentation missing in model
    SagemakerSp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SupportedSavingsPlansType {
    fn from(s: &str) -> Self {
        match s {
            "COMPUTE_SP" => SupportedSavingsPlansType::ComputeSp,
            "EC2_INSTANCE_SP" => SupportedSavingsPlansType::Ec2InstanceSp,
            "SAGEMAKER_SP" => SupportedSavingsPlansType::SagemakerSp,
            other => SupportedSavingsPlansType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SupportedSavingsPlansType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SupportedSavingsPlansType::from(s))
    }
}
impl SupportedSavingsPlansType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SupportedSavingsPlansType::ComputeSp => "COMPUTE_SP",
            SupportedSavingsPlansType::Ec2InstanceSp => "EC2_INSTANCE_SP",
            SupportedSavingsPlansType::SagemakerSp => "SAGEMAKER_SP",
            SupportedSavingsPlansType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COMPUTE_SP", "EC2_INSTANCE_SP", "SAGEMAKER_SP"]
    }
}
impl AsRef<str> for SupportedSavingsPlansType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AccountScope {
    #[allow(missing_docs)] // documentation missing in model
    Linked,
    #[allow(missing_docs)] // documentation missing in model
    Payer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AccountScope {
    fn from(s: &str) -> Self {
        match s {
            "LINKED" => AccountScope::Linked,
            "PAYER" => AccountScope::Payer,
            other => AccountScope::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AccountScope {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AccountScope::from(s))
    }
}
impl AccountScope {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AccountScope::Linked => "LINKED",
            AccountScope::Payer => "PAYER",
            AccountScope::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LINKED", "PAYER"]
    }
}
impl AsRef<str> for AccountScope {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata about your Savings Plans Purchase Recommendations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansPurchaseRecommendationMetadata {
    /// <p>The unique identifier for the recommendation set.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>The timestamp showing when the recommendations were generated.</p>
    pub generation_timestamp: std::option::Option<std::string::String>,
    /// <p>Additional metadata that might be applicable to the recommendation.</p>
    pub additional_metadata: std::option::Option<std::string::String>,
}
impl SavingsPlansPurchaseRecommendationMetadata {
    /// <p>The unique identifier for the recommendation set.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>The timestamp showing when the recommendations were generated.</p>
    pub fn generation_timestamp(&self) -> std::option::Option<&str> {
        self.generation_timestamp.as_deref()
    }
    /// <p>Additional metadata that might be applicable to the recommendation.</p>
    pub fn additional_metadata(&self) -> std::option::Option<&str> {
        self.additional_metadata.as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansPurchaseRecommendationMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansPurchaseRecommendationMetadata");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("generation_timestamp", &self.generation_timestamp);
        formatter.field("additional_metadata", &self.additional_metadata);
        formatter.finish()
    }
}
/// See [`SavingsPlansPurchaseRecommendationMetadata`](crate::model::SavingsPlansPurchaseRecommendationMetadata)
pub mod savings_plans_purchase_recommendation_metadata {
    /// A builder for [`SavingsPlansPurchaseRecommendationMetadata`](crate::model::SavingsPlansPurchaseRecommendationMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) generation_timestamp: std::option::Option<std::string::String>,
        pub(crate) additional_metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the recommendation set.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the recommendation set.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>The timestamp showing when the recommendations were generated.</p>
        pub fn generation_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp showing when the recommendations were generated.</p>
        pub fn set_generation_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_timestamp = input;
            self
        }
        /// <p>Additional metadata that might be applicable to the recommendation.</p>
        pub fn additional_metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_metadata = Some(input.into());
            self
        }
        /// <p>Additional metadata that might be applicable to the recommendation.</p>
        pub fn set_additional_metadata(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansPurchaseRecommendationMetadata`](crate::model::SavingsPlansPurchaseRecommendationMetadata)
        pub fn build(self) -> crate::model::SavingsPlansPurchaseRecommendationMetadata {
            crate::model::SavingsPlansPurchaseRecommendationMetadata {
                recommendation_id: self.recommendation_id,
                generation_timestamp: self.generation_timestamp,
                additional_metadata: self.additional_metadata,
            }
        }
    }
}
impl SavingsPlansPurchaseRecommendationMetadata {
    /// Creates a new builder-style object to manufacture [`SavingsPlansPurchaseRecommendationMetadata`](crate::model::SavingsPlansPurchaseRecommendationMetadata)
    pub fn builder() -> crate::model::savings_plans_purchase_recommendation_metadata::Builder {
        crate::model::savings_plans_purchase_recommendation_metadata::Builder::default()
    }
}

/// <p>The amount of Savings Plans eligible usage that is covered by Savings Plans. All calculations consider the On-Demand equivalent of your Savings Plans usage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansCoverage {
    /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The amount of Savings Plans eligible usage that the Savings Plans covered.</p>
    pub coverage: std::option::Option<crate::model::SavingsPlansCoverageData>,
    /// <p>The time period of the request. </p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
}
impl SavingsPlansCoverage {
    /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>The amount of Savings Plans eligible usage that the Savings Plans covered.</p>
    pub fn coverage(&self) -> std::option::Option<&crate::model::SavingsPlansCoverageData> {
        self.coverage.as_ref()
    }
    /// <p>The time period of the request. </p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
}
impl std::fmt::Debug for SavingsPlansCoverage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansCoverage");
        formatter.field("attributes", &self.attributes);
        formatter.field("coverage", &self.coverage);
        formatter.field("time_period", &self.time_period);
        formatter.finish()
    }
}
/// See [`SavingsPlansCoverage`](crate::model::SavingsPlansCoverage)
pub mod savings_plans_coverage {
    /// A builder for [`SavingsPlansCoverage`](crate::model::SavingsPlansCoverage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) coverage: std::option::Option<crate::model::SavingsPlansCoverageData>,
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The amount of Savings Plans eligible usage that the Savings Plans covered.</p>
        pub fn coverage(mut self, input: crate::model::SavingsPlansCoverageData) -> Self {
            self.coverage = Some(input);
            self
        }
        /// <p>The amount of Savings Plans eligible usage that the Savings Plans covered.</p>
        pub fn set_coverage(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansCoverageData>,
        ) -> Self {
            self.coverage = input;
            self
        }
        /// <p>The time period of the request. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period of the request. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansCoverage`](crate::model::SavingsPlansCoverage)
        pub fn build(self) -> crate::model::SavingsPlansCoverage {
            crate::model::SavingsPlansCoverage {
                attributes: self.attributes,
                coverage: self.coverage,
                time_period: self.time_period,
            }
        }
    }
}
impl SavingsPlansCoverage {
    /// Creates a new builder-style object to manufacture [`SavingsPlansCoverage`](crate::model::SavingsPlansCoverage)
    pub fn builder() -> crate::model::savings_plans_coverage::Builder {
        crate::model::savings_plans_coverage::Builder::default()
    }
}

/// <p>Specific coverage percentage, On-Demand costs, and spend covered by Savings Plans, and total Savings Plans costs for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SavingsPlansCoverageData {
    /// <p>The amount of your Amazon Web Services usage that is covered by a Savings Plans.</p>
    pub spend_covered_by_savings_plans: std::option::Option<std::string::String>,
    /// <p>The cost of your Amazon Web Services usage at the public On-Demand rate.</p>
    pub on_demand_cost: std::option::Option<std::string::String>,
    /// <p>The total cost of your Amazon Web Services usage, regardless of your purchase option.</p>
    pub total_cost: std::option::Option<std::string::String>,
    /// <p>The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings Plans usage in an account (or set of accounts).</p>
    pub coverage_percentage: std::option::Option<std::string::String>,
}
impl SavingsPlansCoverageData {
    /// <p>The amount of your Amazon Web Services usage that is covered by a Savings Plans.</p>
    pub fn spend_covered_by_savings_plans(&self) -> std::option::Option<&str> {
        self.spend_covered_by_savings_plans.as_deref()
    }
    /// <p>The cost of your Amazon Web Services usage at the public On-Demand rate.</p>
    pub fn on_demand_cost(&self) -> std::option::Option<&str> {
        self.on_demand_cost.as_deref()
    }
    /// <p>The total cost of your Amazon Web Services usage, regardless of your purchase option.</p>
    pub fn total_cost(&self) -> std::option::Option<&str> {
        self.total_cost.as_deref()
    }
    /// <p>The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings Plans usage in an account (or set of accounts).</p>
    pub fn coverage_percentage(&self) -> std::option::Option<&str> {
        self.coverage_percentage.as_deref()
    }
}
impl std::fmt::Debug for SavingsPlansCoverageData {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SavingsPlansCoverageData");
        formatter.field(
            "spend_covered_by_savings_plans",
            &self.spend_covered_by_savings_plans,
        );
        formatter.field("on_demand_cost", &self.on_demand_cost);
        formatter.field("total_cost", &self.total_cost);
        formatter.field("coverage_percentage", &self.coverage_percentage);
        formatter.finish()
    }
}
/// See [`SavingsPlansCoverageData`](crate::model::SavingsPlansCoverageData)
pub mod savings_plans_coverage_data {
    /// A builder for [`SavingsPlansCoverageData`](crate::model::SavingsPlansCoverageData)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) spend_covered_by_savings_plans: std::option::Option<std::string::String>,
        pub(crate) on_demand_cost: std::option::Option<std::string::String>,
        pub(crate) total_cost: std::option::Option<std::string::String>,
        pub(crate) coverage_percentage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The amount of your Amazon Web Services usage that is covered by a Savings Plans.</p>
        pub fn spend_covered_by_savings_plans(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.spend_covered_by_savings_plans = Some(input.into());
            self
        }
        /// <p>The amount of your Amazon Web Services usage that is covered by a Savings Plans.</p>
        pub fn set_spend_covered_by_savings_plans(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.spend_covered_by_savings_plans = input;
            self
        }
        /// <p>The cost of your Amazon Web Services usage at the public On-Demand rate.</p>
        pub fn on_demand_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.on_demand_cost = Some(input.into());
            self
        }
        /// <p>The cost of your Amazon Web Services usage at the public On-Demand rate.</p>
        pub fn set_on_demand_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_cost = input;
            self
        }
        /// <p>The total cost of your Amazon Web Services usage, regardless of your purchase option.</p>
        pub fn total_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_cost = Some(input.into());
            self
        }
        /// <p>The total cost of your Amazon Web Services usage, regardless of your purchase option.</p>
        pub fn set_total_cost(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.total_cost = input;
            self
        }
        /// <p>The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings Plans usage in an account (or set of accounts).</p>
        pub fn coverage_percentage(mut self, input: impl Into<std::string::String>) -> Self {
            self.coverage_percentage = Some(input.into());
            self
        }
        /// <p>The percentage of your existing Savings Plans covered usage, divided by all of your eligible Savings Plans usage in an account (or set of accounts).</p>
        pub fn set_coverage_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.coverage_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`SavingsPlansCoverageData`](crate::model::SavingsPlansCoverageData)
        pub fn build(self) -> crate::model::SavingsPlansCoverageData {
            crate::model::SavingsPlansCoverageData {
                spend_covered_by_savings_plans: self.spend_covered_by_savings_plans,
                on_demand_cost: self.on_demand_cost,
                total_cost: self.total_cost,
                coverage_percentage: self.coverage_percentage,
            }
        }
    }
}
impl SavingsPlansCoverageData {
    /// Creates a new builder-style object to manufacture [`SavingsPlansCoverageData`](crate::model::SavingsPlansCoverageData)
    pub fn builder() -> crate::model::savings_plans_coverage_data::Builder {
        crate::model::savings_plans_coverage_data::Builder::default()
    }
}

/// <p>Represents a group when you specify a group by criteria or in the response to a query with a specific grouping.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupDefinition {
    /// <p>The string that represents the type of group.</p>
    pub r#type: std::option::Option<crate::model::GroupDefinitionType>,
    /// <p>The string that represents a key for a specified group.</p>
    pub key: std::option::Option<std::string::String>,
}
impl GroupDefinition {
    /// <p>The string that represents the type of group.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::GroupDefinitionType> {
        self.r#type.as_ref()
    }
    /// <p>The string that represents a key for a specified group.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
}
impl std::fmt::Debug for GroupDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupDefinition");
        formatter.field("r#type", &self.r#type);
        formatter.field("key", &self.key);
        formatter.finish()
    }
}
/// See [`GroupDefinition`](crate::model::GroupDefinition)
pub mod group_definition {
    /// A builder for [`GroupDefinition`](crate::model::GroupDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<crate::model::GroupDefinitionType>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The string that represents the type of group.</p>
        pub fn r#type(mut self, input: crate::model::GroupDefinitionType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The string that represents the type of group.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::GroupDefinitionType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The string that represents a key for a specified group.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The string that represents a key for a specified group.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupDefinition`](crate::model::GroupDefinition)
        pub fn build(self) -> crate::model::GroupDefinition {
            crate::model::GroupDefinition {
                r#type: self.r#type,
                key: self.key,
            }
        }
    }
}
impl GroupDefinition {
    /// Creates a new builder-style object to manufacture [`GroupDefinition`](crate::model::GroupDefinition)
    pub fn builder() -> crate::model::group_definition::Builder {
        crate::model::group_definition::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GroupDefinitionType {
    #[allow(missing_docs)] // documentation missing in model
    CostCategory,
    #[allow(missing_docs)] // documentation missing in model
    Dimension,
    #[allow(missing_docs)] // documentation missing in model
    Tag,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GroupDefinitionType {
    fn from(s: &str) -> Self {
        match s {
            "COST_CATEGORY" => GroupDefinitionType::CostCategory,
            "DIMENSION" => GroupDefinitionType::Dimension,
            "TAG" => GroupDefinitionType::Tag,
            other => GroupDefinitionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GroupDefinitionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GroupDefinitionType::from(s))
    }
}
impl GroupDefinitionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GroupDefinitionType::CostCategory => "COST_CATEGORY",
            GroupDefinitionType::Dimension => "DIMENSION",
            GroupDefinitionType::Tag => "TAG",
            GroupDefinitionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COST_CATEGORY", "DIMENSION", "TAG"]
    }
}
impl AsRef<str> for GroupDefinitionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>You can use <code>RightsizingRecommendationConfiguration</code> to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings that are associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RightsizingRecommendationConfiguration {
    /// <p>The option to see recommendations within the same instance family or recommendations for instances across other families. The default value is <code>SAME_INSTANCE_FAMILY</code>. </p>
    pub recommendation_target: std::option::Option<crate::model::RecommendationTarget>,
    /// <p>The option to consider RI or Savings Plans discount benefits in your savings calculation. The default value is <code>TRUE</code>. </p>
    pub benefits_considered: bool,
}
impl RightsizingRecommendationConfiguration {
    /// <p>The option to see recommendations within the same instance family or recommendations for instances across other families. The default value is <code>SAME_INSTANCE_FAMILY</code>. </p>
    pub fn recommendation_target(
        &self,
    ) -> std::option::Option<&crate::model::RecommendationTarget> {
        self.recommendation_target.as_ref()
    }
    /// <p>The option to consider RI or Savings Plans discount benefits in your savings calculation. The default value is <code>TRUE</code>. </p>
    pub fn benefits_considered(&self) -> bool {
        self.benefits_considered
    }
}
impl std::fmt::Debug for RightsizingRecommendationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RightsizingRecommendationConfiguration");
        formatter.field("recommendation_target", &self.recommendation_target);
        formatter.field("benefits_considered", &self.benefits_considered);
        formatter.finish()
    }
}
/// See [`RightsizingRecommendationConfiguration`](crate::model::RightsizingRecommendationConfiguration)
pub mod rightsizing_recommendation_configuration {
    /// A builder for [`RightsizingRecommendationConfiguration`](crate::model::RightsizingRecommendationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_target: std::option::Option<crate::model::RecommendationTarget>,
        pub(crate) benefits_considered: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The option to see recommendations within the same instance family or recommendations for instances across other families. The default value is <code>SAME_INSTANCE_FAMILY</code>. </p>
        pub fn recommendation_target(mut self, input: crate::model::RecommendationTarget) -> Self {
            self.recommendation_target = Some(input);
            self
        }
        /// <p>The option to see recommendations within the same instance family or recommendations for instances across other families. The default value is <code>SAME_INSTANCE_FAMILY</code>. </p>
        pub fn set_recommendation_target(
            mut self,
            input: std::option::Option<crate::model::RecommendationTarget>,
        ) -> Self {
            self.recommendation_target = input;
            self
        }
        /// <p>The option to consider RI or Savings Plans discount benefits in your savings calculation. The default value is <code>TRUE</code>. </p>
        pub fn benefits_considered(mut self, input: bool) -> Self {
            self.benefits_considered = Some(input);
            self
        }
        /// <p>The option to consider RI or Savings Plans discount benefits in your savings calculation. The default value is <code>TRUE</code>. </p>
        pub fn set_benefits_considered(mut self, input: std::option::Option<bool>) -> Self {
            self.benefits_considered = input;
            self
        }
        /// Consumes the builder and constructs a [`RightsizingRecommendationConfiguration`](crate::model::RightsizingRecommendationConfiguration)
        pub fn build(self) -> crate::model::RightsizingRecommendationConfiguration {
            crate::model::RightsizingRecommendationConfiguration {
                recommendation_target: self.recommendation_target,
                benefits_considered: self.benefits_considered.unwrap_or_default(),
            }
        }
    }
}
impl RightsizingRecommendationConfiguration {
    /// Creates a new builder-style object to manufacture [`RightsizingRecommendationConfiguration`](crate::model::RightsizingRecommendationConfiguration)
    pub fn builder() -> crate::model::rightsizing_recommendation_configuration::Builder {
        crate::model::rightsizing_recommendation_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RecommendationTarget {
    #[allow(missing_docs)] // documentation missing in model
    CrossInstanceFamily,
    #[allow(missing_docs)] // documentation missing in model
    SameInstanceFamily,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RecommendationTarget {
    fn from(s: &str) -> Self {
        match s {
            "CROSS_INSTANCE_FAMILY" => RecommendationTarget::CrossInstanceFamily,
            "SAME_INSTANCE_FAMILY" => RecommendationTarget::SameInstanceFamily,
            other => RecommendationTarget::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RecommendationTarget {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RecommendationTarget::from(s))
    }
}
impl RecommendationTarget {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RecommendationTarget::CrossInstanceFamily => "CROSS_INSTANCE_FAMILY",
            RecommendationTarget::SameInstanceFamily => "SAME_INSTANCE_FAMILY",
            RecommendationTarget::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CROSS_INSTANCE_FAMILY", "SAME_INSTANCE_FAMILY"]
    }
}
impl AsRef<str> for RecommendationTarget {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Recommendations to rightsize resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RightsizingRecommendation {
    /// <p>The account that this recommendation is for.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Context regarding the current instance.</p>
    pub current_instance: std::option::Option<crate::model::CurrentInstance>,
    /// <p>A recommendation to either terminate or modify the resource.</p>
    pub rightsizing_type: std::option::Option<crate::model::RightsizingType>,
    /// <p>The details for the modification recommendations. </p>
    pub modify_recommendation_detail: std::option::Option<crate::model::ModifyRecommendationDetail>,
    /// <p>The details for termination recommendations.</p>
    pub terminate_recommendation_detail:
        std::option::Option<crate::model::TerminateRecommendationDetail>,
    /// <p> The list of possible reasons why the recommendation is generated such as under or over utilization of specific metrics (for example, CPU, Memory, Network). </p>
    pub finding_reason_codes: std::option::Option<std::vec::Vec<crate::model::FindingReasonCode>>,
}
impl RightsizingRecommendation {
    /// <p>The account that this recommendation is for.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Context regarding the current instance.</p>
    pub fn current_instance(&self) -> std::option::Option<&crate::model::CurrentInstance> {
        self.current_instance.as_ref()
    }
    /// <p>A recommendation to either terminate or modify the resource.</p>
    pub fn rightsizing_type(&self) -> std::option::Option<&crate::model::RightsizingType> {
        self.rightsizing_type.as_ref()
    }
    /// <p>The details for the modification recommendations. </p>
    pub fn modify_recommendation_detail(
        &self,
    ) -> std::option::Option<&crate::model::ModifyRecommendationDetail> {
        self.modify_recommendation_detail.as_ref()
    }
    /// <p>The details for termination recommendations.</p>
    pub fn terminate_recommendation_detail(
        &self,
    ) -> std::option::Option<&crate::model::TerminateRecommendationDetail> {
        self.terminate_recommendation_detail.as_ref()
    }
    /// <p> The list of possible reasons why the recommendation is generated such as under or over utilization of specific metrics (for example, CPU, Memory, Network). </p>
    pub fn finding_reason_codes(&self) -> std::option::Option<&[crate::model::FindingReasonCode]> {
        self.finding_reason_codes.as_deref()
    }
}
impl std::fmt::Debug for RightsizingRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RightsizingRecommendation");
        formatter.field("account_id", &self.account_id);
        formatter.field("current_instance", &self.current_instance);
        formatter.field("rightsizing_type", &self.rightsizing_type);
        formatter.field(
            "modify_recommendation_detail",
            &self.modify_recommendation_detail,
        );
        formatter.field(
            "terminate_recommendation_detail",
            &self.terminate_recommendation_detail,
        );
        formatter.field("finding_reason_codes", &self.finding_reason_codes);
        formatter.finish()
    }
}
/// See [`RightsizingRecommendation`](crate::model::RightsizingRecommendation)
pub mod rightsizing_recommendation {
    /// A builder for [`RightsizingRecommendation`](crate::model::RightsizingRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) current_instance: std::option::Option<crate::model::CurrentInstance>,
        pub(crate) rightsizing_type: std::option::Option<crate::model::RightsizingType>,
        pub(crate) modify_recommendation_detail:
            std::option::Option<crate::model::ModifyRecommendationDetail>,
        pub(crate) terminate_recommendation_detail:
            std::option::Option<crate::model::TerminateRecommendationDetail>,
        pub(crate) finding_reason_codes:
            std::option::Option<std::vec::Vec<crate::model::FindingReasonCode>>,
    }
    impl Builder {
        /// <p>The account that this recommendation is for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account that this recommendation is for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Context regarding the current instance.</p>
        pub fn current_instance(mut self, input: crate::model::CurrentInstance) -> Self {
            self.current_instance = Some(input);
            self
        }
        /// <p>Context regarding the current instance.</p>
        pub fn set_current_instance(
            mut self,
            input: std::option::Option<crate::model::CurrentInstance>,
        ) -> Self {
            self.current_instance = input;
            self
        }
        /// <p>A recommendation to either terminate or modify the resource.</p>
        pub fn rightsizing_type(mut self, input: crate::model::RightsizingType) -> Self {
            self.rightsizing_type = Some(input);
            self
        }
        /// <p>A recommendation to either terminate or modify the resource.</p>
        pub fn set_rightsizing_type(
            mut self,
            input: std::option::Option<crate::model::RightsizingType>,
        ) -> Self {
            self.rightsizing_type = input;
            self
        }
        /// <p>The details for the modification recommendations. </p>
        pub fn modify_recommendation_detail(
            mut self,
            input: crate::model::ModifyRecommendationDetail,
        ) -> Self {
            self.modify_recommendation_detail = Some(input);
            self
        }
        /// <p>The details for the modification recommendations. </p>
        pub fn set_modify_recommendation_detail(
            mut self,
            input: std::option::Option<crate::model::ModifyRecommendationDetail>,
        ) -> Self {
            self.modify_recommendation_detail = input;
            self
        }
        /// <p>The details for termination recommendations.</p>
        pub fn terminate_recommendation_detail(
            mut self,
            input: crate::model::TerminateRecommendationDetail,
        ) -> Self {
            self.terminate_recommendation_detail = Some(input);
            self
        }
        /// <p>The details for termination recommendations.</p>
        pub fn set_terminate_recommendation_detail(
            mut self,
            input: std::option::Option<crate::model::TerminateRecommendationDetail>,
        ) -> Self {
            self.terminate_recommendation_detail = input;
            self
        }
        /// Appends an item to `finding_reason_codes`.
        ///
        /// To override the contents of this collection use [`set_finding_reason_codes`](Self::set_finding_reason_codes).
        ///
        /// <p> The list of possible reasons why the recommendation is generated such as under or over utilization of specific metrics (for example, CPU, Memory, Network). </p>
        pub fn finding_reason_codes(mut self, input: crate::model::FindingReasonCode) -> Self {
            let mut v = self.finding_reason_codes.unwrap_or_default();
            v.push(input);
            self.finding_reason_codes = Some(v);
            self
        }
        /// <p> The list of possible reasons why the recommendation is generated such as under or over utilization of specific metrics (for example, CPU, Memory, Network). </p>
        pub fn set_finding_reason_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingReasonCode>>,
        ) -> Self {
            self.finding_reason_codes = input;
            self
        }
        /// Consumes the builder and constructs a [`RightsizingRecommendation`](crate::model::RightsizingRecommendation)
        pub fn build(self) -> crate::model::RightsizingRecommendation {
            crate::model::RightsizingRecommendation {
                account_id: self.account_id,
                current_instance: self.current_instance,
                rightsizing_type: self.rightsizing_type,
                modify_recommendation_detail: self.modify_recommendation_detail,
                terminate_recommendation_detail: self.terminate_recommendation_detail,
                finding_reason_codes: self.finding_reason_codes,
            }
        }
    }
}
impl RightsizingRecommendation {
    /// Creates a new builder-style object to manufacture [`RightsizingRecommendation`](crate::model::RightsizingRecommendation)
    pub fn builder() -> crate::model::rightsizing_recommendation::Builder {
        crate::model::rightsizing_recommendation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingReasonCode {
    #[allow(missing_docs)] // documentation missing in model
    CpuOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    CpuUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskIopsOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskIopsUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskThroughputOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    DiskThroughputUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsIopsOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsIopsUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsThroughputOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    EbsThroughputUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    MemoryOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    MemoryUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkBandwidthOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkBandwidthUnderProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkPpsOverProvisioned,
    #[allow(missing_docs)] // documentation missing in model
    NetworkPpsUnderProvisioned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingReasonCode {
    fn from(s: &str) -> Self {
        match s {
            "CPU_OVER_PROVISIONED" => FindingReasonCode::CpuOverProvisioned,
            "CPU_UNDER_PROVISIONED" => FindingReasonCode::CpuUnderProvisioned,
            "DISK_IOPS_OVER_PROVISIONED" => FindingReasonCode::DiskIopsOverProvisioned,
            "DISK_IOPS_UNDER_PROVISIONED" => FindingReasonCode::DiskIopsUnderProvisioned,
            "DISK_THROUGHPUT_OVER_PROVISIONED" => FindingReasonCode::DiskThroughputOverProvisioned,
            "DISK_THROUGHPUT_UNDER_PROVISIONED" => {
                FindingReasonCode::DiskThroughputUnderProvisioned
            }
            "EBS_IOPS_OVER_PROVISIONED" => FindingReasonCode::EbsIopsOverProvisioned,
            "EBS_IOPS_UNDER_PROVISIONED" => FindingReasonCode::EbsIopsUnderProvisioned,
            "EBS_THROUGHPUT_OVER_PROVISIONED" => FindingReasonCode::EbsThroughputOverProvisioned,
            "EBS_THROUGHPUT_UNDER_PROVISIONED" => FindingReasonCode::EbsThroughputUnderProvisioned,
            "MEMORY_OVER_PROVISIONED" => FindingReasonCode::MemoryOverProvisioned,
            "MEMORY_UNDER_PROVISIONED" => FindingReasonCode::MemoryUnderProvisioned,
            "NETWORK_BANDWIDTH_OVER_PROVISIONED" => {
                FindingReasonCode::NetworkBandwidthOverProvisioned
            }
            "NETWORK_BANDWIDTH_UNDER_PROVISIONED" => {
                FindingReasonCode::NetworkBandwidthUnderProvisioned
            }
            "NETWORK_PPS_OVER_PROVISIONED" => FindingReasonCode::NetworkPpsOverProvisioned,
            "NETWORK_PPS_UNDER_PROVISIONED" => FindingReasonCode::NetworkPpsUnderProvisioned,
            other => FindingReasonCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingReasonCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingReasonCode::from(s))
    }
}
impl FindingReasonCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingReasonCode::CpuOverProvisioned => "CPU_OVER_PROVISIONED",
            FindingReasonCode::CpuUnderProvisioned => "CPU_UNDER_PROVISIONED",
            FindingReasonCode::DiskIopsOverProvisioned => "DISK_IOPS_OVER_PROVISIONED",
            FindingReasonCode::DiskIopsUnderProvisioned => "DISK_IOPS_UNDER_PROVISIONED",
            FindingReasonCode::DiskThroughputOverProvisioned => "DISK_THROUGHPUT_OVER_PROVISIONED",
            FindingReasonCode::DiskThroughputUnderProvisioned => {
                "DISK_THROUGHPUT_UNDER_PROVISIONED"
            }
            FindingReasonCode::EbsIopsOverProvisioned => "EBS_IOPS_OVER_PROVISIONED",
            FindingReasonCode::EbsIopsUnderProvisioned => "EBS_IOPS_UNDER_PROVISIONED",
            FindingReasonCode::EbsThroughputOverProvisioned => "EBS_THROUGHPUT_OVER_PROVISIONED",
            FindingReasonCode::EbsThroughputUnderProvisioned => "EBS_THROUGHPUT_UNDER_PROVISIONED",
            FindingReasonCode::MemoryOverProvisioned => "MEMORY_OVER_PROVISIONED",
            FindingReasonCode::MemoryUnderProvisioned => "MEMORY_UNDER_PROVISIONED",
            FindingReasonCode::NetworkBandwidthOverProvisioned => {
                "NETWORK_BANDWIDTH_OVER_PROVISIONED"
            }
            FindingReasonCode::NetworkBandwidthUnderProvisioned => {
                "NETWORK_BANDWIDTH_UNDER_PROVISIONED"
            }
            FindingReasonCode::NetworkPpsOverProvisioned => "NETWORK_PPS_OVER_PROVISIONED",
            FindingReasonCode::NetworkPpsUnderProvisioned => "NETWORK_PPS_UNDER_PROVISIONED",
            FindingReasonCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CPU_OVER_PROVISIONED",
            "CPU_UNDER_PROVISIONED",
            "DISK_IOPS_OVER_PROVISIONED",
            "DISK_IOPS_UNDER_PROVISIONED",
            "DISK_THROUGHPUT_OVER_PROVISIONED",
            "DISK_THROUGHPUT_UNDER_PROVISIONED",
            "EBS_IOPS_OVER_PROVISIONED",
            "EBS_IOPS_UNDER_PROVISIONED",
            "EBS_THROUGHPUT_OVER_PROVISIONED",
            "EBS_THROUGHPUT_UNDER_PROVISIONED",
            "MEMORY_OVER_PROVISIONED",
            "MEMORY_UNDER_PROVISIONED",
            "NETWORK_BANDWIDTH_OVER_PROVISIONED",
            "NETWORK_BANDWIDTH_UNDER_PROVISIONED",
            "NETWORK_PPS_OVER_PROVISIONED",
            "NETWORK_PPS_UNDER_PROVISIONED",
        ]
    }
}
impl AsRef<str> for FindingReasonCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Details on termination recommendation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TerminateRecommendationDetail {
    /// <p>The estimated savings that result from modification, on a monthly basis.</p>
    pub estimated_monthly_savings: std::option::Option<std::string::String>,
    /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub currency_code: std::option::Option<std::string::String>,
}
impl TerminateRecommendationDetail {
    /// <p>The estimated savings that result from modification, on a monthly basis.</p>
    pub fn estimated_monthly_savings(&self) -> std::option::Option<&str> {
        self.estimated_monthly_savings.as_deref()
    }
    /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
}
impl std::fmt::Debug for TerminateRecommendationDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TerminateRecommendationDetail");
        formatter.field("estimated_monthly_savings", &self.estimated_monthly_savings);
        formatter.field("currency_code", &self.currency_code);
        formatter.finish()
    }
}
/// See [`TerminateRecommendationDetail`](crate::model::TerminateRecommendationDetail)
pub mod terminate_recommendation_detail {
    /// A builder for [`TerminateRecommendationDetail`](crate::model::TerminateRecommendationDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) estimated_monthly_savings: std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The estimated savings that result from modification, on a monthly basis.</p>
        pub fn estimated_monthly_savings(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_monthly_savings = Some(input.into());
            self
        }
        /// <p>The estimated savings that result from modification, on a monthly basis.</p>
        pub fn set_estimated_monthly_savings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings = input;
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Consumes the builder and constructs a [`TerminateRecommendationDetail`](crate::model::TerminateRecommendationDetail)
        pub fn build(self) -> crate::model::TerminateRecommendationDetail {
            crate::model::TerminateRecommendationDetail {
                estimated_monthly_savings: self.estimated_monthly_savings,
                currency_code: self.currency_code,
            }
        }
    }
}
impl TerminateRecommendationDetail {
    /// Creates a new builder-style object to manufacture [`TerminateRecommendationDetail`](crate::model::TerminateRecommendationDetail)
    pub fn builder() -> crate::model::terminate_recommendation_detail::Builder {
        crate::model::terminate_recommendation_detail::Builder::default()
    }
}

/// <p> Details on the modification recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyRecommendationDetail {
    /// <p>Determines whether this instance type is the Amazon Web Services default recommendation.</p>
    pub target_instances: std::option::Option<std::vec::Vec<crate::model::TargetInstance>>,
}
impl ModifyRecommendationDetail {
    /// <p>Determines whether this instance type is the Amazon Web Services default recommendation.</p>
    pub fn target_instances(&self) -> std::option::Option<&[crate::model::TargetInstance]> {
        self.target_instances.as_deref()
    }
}
impl std::fmt::Debug for ModifyRecommendationDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyRecommendationDetail");
        formatter.field("target_instances", &self.target_instances);
        formatter.finish()
    }
}
/// See [`ModifyRecommendationDetail`](crate::model::ModifyRecommendationDetail)
pub mod modify_recommendation_detail {
    /// A builder for [`ModifyRecommendationDetail`](crate::model::ModifyRecommendationDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_instances:
            std::option::Option<std::vec::Vec<crate::model::TargetInstance>>,
    }
    impl Builder {
        /// Appends an item to `target_instances`.
        ///
        /// To override the contents of this collection use [`set_target_instances`](Self::set_target_instances).
        ///
        /// <p>Determines whether this instance type is the Amazon Web Services default recommendation.</p>
        pub fn target_instances(mut self, input: crate::model::TargetInstance) -> Self {
            let mut v = self.target_instances.unwrap_or_default();
            v.push(input);
            self.target_instances = Some(v);
            self
        }
        /// <p>Determines whether this instance type is the Amazon Web Services default recommendation.</p>
        pub fn set_target_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TargetInstance>>,
        ) -> Self {
            self.target_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyRecommendationDetail`](crate::model::ModifyRecommendationDetail)
        pub fn build(self) -> crate::model::ModifyRecommendationDetail {
            crate::model::ModifyRecommendationDetail {
                target_instances: self.target_instances,
            }
        }
    }
}
impl ModifyRecommendationDetail {
    /// Creates a new builder-style object to manufacture [`ModifyRecommendationDetail`](crate::model::ModifyRecommendationDetail)
    pub fn builder() -> crate::model::modify_recommendation_detail::Builder {
        crate::model::modify_recommendation_detail::Builder::default()
    }
}

/// <p>Details on recommended instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetInstance {
    /// <p>The expected cost to operate this instance type on a monthly basis.</p>
    pub estimated_monthly_cost: std::option::Option<std::string::String>,
    /// <p>The estimated savings that result from modification, on a monthly basis.</p>
    pub estimated_monthly_savings: std::option::Option<std::string::String>,
    /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>Determines whether this recommendation is the defaulted Amazon Web Services recommendation.</p>
    pub default_target_instance: bool,
    /// <p>Details on the target instance type. </p>
    pub resource_details: std::option::Option<crate::model::ResourceDetails>,
    /// <p>The expected utilization metrics for target instance type.</p>
    pub expected_resource_utilization: std::option::Option<crate::model::ResourceUtilization>,
    /// <p> Explains the actions you might need to take in order to successfully migrate your workloads from the current instance type to the recommended instance type. </p>
    pub platform_differences: std::option::Option<std::vec::Vec<crate::model::PlatformDifference>>,
}
impl TargetInstance {
    /// <p>The expected cost to operate this instance type on a monthly basis.</p>
    pub fn estimated_monthly_cost(&self) -> std::option::Option<&str> {
        self.estimated_monthly_cost.as_deref()
    }
    /// <p>The estimated savings that result from modification, on a monthly basis.</p>
    pub fn estimated_monthly_savings(&self) -> std::option::Option<&str> {
        self.estimated_monthly_savings.as_deref()
    }
    /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>Determines whether this recommendation is the defaulted Amazon Web Services recommendation.</p>
    pub fn default_target_instance(&self) -> bool {
        self.default_target_instance
    }
    /// <p>Details on the target instance type. </p>
    pub fn resource_details(&self) -> std::option::Option<&crate::model::ResourceDetails> {
        self.resource_details.as_ref()
    }
    /// <p>The expected utilization metrics for target instance type.</p>
    pub fn expected_resource_utilization(
        &self,
    ) -> std::option::Option<&crate::model::ResourceUtilization> {
        self.expected_resource_utilization.as_ref()
    }
    /// <p> Explains the actions you might need to take in order to successfully migrate your workloads from the current instance type to the recommended instance type. </p>
    pub fn platform_differences(&self) -> std::option::Option<&[crate::model::PlatformDifference]> {
        self.platform_differences.as_deref()
    }
}
impl std::fmt::Debug for TargetInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetInstance");
        formatter.field("estimated_monthly_cost", &self.estimated_monthly_cost);
        formatter.field("estimated_monthly_savings", &self.estimated_monthly_savings);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("default_target_instance", &self.default_target_instance);
        formatter.field("resource_details", &self.resource_details);
        formatter.field(
            "expected_resource_utilization",
            &self.expected_resource_utilization,
        );
        formatter.field("platform_differences", &self.platform_differences);
        formatter.finish()
    }
}
/// See [`TargetInstance`](crate::model::TargetInstance)
pub mod target_instance {
    /// A builder for [`TargetInstance`](crate::model::TargetInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) estimated_monthly_cost: std::option::Option<std::string::String>,
        pub(crate) estimated_monthly_savings: std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) default_target_instance: std::option::Option<bool>,
        pub(crate) resource_details: std::option::Option<crate::model::ResourceDetails>,
        pub(crate) expected_resource_utilization:
            std::option::Option<crate::model::ResourceUtilization>,
        pub(crate) platform_differences:
            std::option::Option<std::vec::Vec<crate::model::PlatformDifference>>,
    }
    impl Builder {
        /// <p>The expected cost to operate this instance type on a monthly basis.</p>
        pub fn estimated_monthly_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_monthly_cost = Some(input.into());
            self
        }
        /// <p>The expected cost to operate this instance type on a monthly basis.</p>
        pub fn set_estimated_monthly_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_cost = input;
            self
        }
        /// <p>The estimated savings that result from modification, on a monthly basis.</p>
        pub fn estimated_monthly_savings(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_monthly_savings = Some(input.into());
            self
        }
        /// <p>The estimated savings that result from modification, on a monthly basis.</p>
        pub fn set_estimated_monthly_savings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings = input;
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>Determines whether this recommendation is the defaulted Amazon Web Services recommendation.</p>
        pub fn default_target_instance(mut self, input: bool) -> Self {
            self.default_target_instance = Some(input);
            self
        }
        /// <p>Determines whether this recommendation is the defaulted Amazon Web Services recommendation.</p>
        pub fn set_default_target_instance(mut self, input: std::option::Option<bool>) -> Self {
            self.default_target_instance = input;
            self
        }
        /// <p>Details on the target instance type. </p>
        pub fn resource_details(mut self, input: crate::model::ResourceDetails) -> Self {
            self.resource_details = Some(input);
            self
        }
        /// <p>Details on the target instance type. </p>
        pub fn set_resource_details(
            mut self,
            input: std::option::Option<crate::model::ResourceDetails>,
        ) -> Self {
            self.resource_details = input;
            self
        }
        /// <p>The expected utilization metrics for target instance type.</p>
        pub fn expected_resource_utilization(
            mut self,
            input: crate::model::ResourceUtilization,
        ) -> Self {
            self.expected_resource_utilization = Some(input);
            self
        }
        /// <p>The expected utilization metrics for target instance type.</p>
        pub fn set_expected_resource_utilization(
            mut self,
            input: std::option::Option<crate::model::ResourceUtilization>,
        ) -> Self {
            self.expected_resource_utilization = input;
            self
        }
        /// Appends an item to `platform_differences`.
        ///
        /// To override the contents of this collection use [`set_platform_differences`](Self::set_platform_differences).
        ///
        /// <p> Explains the actions you might need to take in order to successfully migrate your workloads from the current instance type to the recommended instance type. </p>
        pub fn platform_differences(mut self, input: crate::model::PlatformDifference) -> Self {
            let mut v = self.platform_differences.unwrap_or_default();
            v.push(input);
            self.platform_differences = Some(v);
            self
        }
        /// <p> Explains the actions you might need to take in order to successfully migrate your workloads from the current instance type to the recommended instance type. </p>
        pub fn set_platform_differences(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PlatformDifference>>,
        ) -> Self {
            self.platform_differences = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetInstance`](crate::model::TargetInstance)
        pub fn build(self) -> crate::model::TargetInstance {
            crate::model::TargetInstance {
                estimated_monthly_cost: self.estimated_monthly_cost,
                estimated_monthly_savings: self.estimated_monthly_savings,
                currency_code: self.currency_code,
                default_target_instance: self.default_target_instance.unwrap_or_default(),
                resource_details: self.resource_details,
                expected_resource_utilization: self.expected_resource_utilization,
                platform_differences: self.platform_differences,
            }
        }
    }
}
impl TargetInstance {
    /// Creates a new builder-style object to manufacture [`TargetInstance`](crate::model::TargetInstance)
    pub fn builder() -> crate::model::target_instance::Builder {
        crate::model::target_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PlatformDifference {
    #[allow(missing_docs)] // documentation missing in model
    Hypervisor,
    #[allow(missing_docs)] // documentation missing in model
    InstanceStoreAvailability,
    #[allow(missing_docs)] // documentation missing in model
    NetworkInterface,
    #[allow(missing_docs)] // documentation missing in model
    StorageInterface,
    #[allow(missing_docs)] // documentation missing in model
    VirtualizationType,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PlatformDifference {
    fn from(s: &str) -> Self {
        match s {
            "HYPERVISOR" => PlatformDifference::Hypervisor,
            "INSTANCE_STORE_AVAILABILITY" => PlatformDifference::InstanceStoreAvailability,
            "NETWORK_INTERFACE" => PlatformDifference::NetworkInterface,
            "STORAGE_INTERFACE" => PlatformDifference::StorageInterface,
            "VIRTUALIZATION_TYPE" => PlatformDifference::VirtualizationType,
            other => PlatformDifference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PlatformDifference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PlatformDifference::from(s))
    }
}
impl PlatformDifference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PlatformDifference::Hypervisor => "HYPERVISOR",
            PlatformDifference::InstanceStoreAvailability => "INSTANCE_STORE_AVAILABILITY",
            PlatformDifference::NetworkInterface => "NETWORK_INTERFACE",
            PlatformDifference::StorageInterface => "STORAGE_INTERFACE",
            PlatformDifference::VirtualizationType => "VIRTUALIZATION_TYPE",
            PlatformDifference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "HYPERVISOR",
            "INSTANCE_STORE_AVAILABILITY",
            "NETWORK_INTERFACE",
            "STORAGE_INTERFACE",
            "VIRTUALIZATION_TYPE",
        ]
    }
}
impl AsRef<str> for PlatformDifference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Resource utilization of current resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceUtilization {
    /// <p>The utilization of current Amazon EC2 instance. </p>
    pub ec2_resource_utilization: std::option::Option<crate::model::Ec2ResourceUtilization>,
}
impl ResourceUtilization {
    /// <p>The utilization of current Amazon EC2 instance. </p>
    pub fn ec2_resource_utilization(
        &self,
    ) -> std::option::Option<&crate::model::Ec2ResourceUtilization> {
        self.ec2_resource_utilization.as_ref()
    }
}
impl std::fmt::Debug for ResourceUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceUtilization");
        formatter.field("ec2_resource_utilization", &self.ec2_resource_utilization);
        formatter.finish()
    }
}
/// See [`ResourceUtilization`](crate::model::ResourceUtilization)
pub mod resource_utilization {
    /// A builder for [`ResourceUtilization`](crate::model::ResourceUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_resource_utilization:
            std::option::Option<crate::model::Ec2ResourceUtilization>,
    }
    impl Builder {
        /// <p>The utilization of current Amazon EC2 instance. </p>
        pub fn ec2_resource_utilization(
            mut self,
            input: crate::model::Ec2ResourceUtilization,
        ) -> Self {
            self.ec2_resource_utilization = Some(input);
            self
        }
        /// <p>The utilization of current Amazon EC2 instance. </p>
        pub fn set_ec2_resource_utilization(
            mut self,
            input: std::option::Option<crate::model::Ec2ResourceUtilization>,
        ) -> Self {
            self.ec2_resource_utilization = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceUtilization`](crate::model::ResourceUtilization)
        pub fn build(self) -> crate::model::ResourceUtilization {
            crate::model::ResourceUtilization {
                ec2_resource_utilization: self.ec2_resource_utilization,
            }
        }
    }
}
impl ResourceUtilization {
    /// Creates a new builder-style object to manufacture [`ResourceUtilization`](crate::model::ResourceUtilization)
    pub fn builder() -> crate::model::resource_utilization::Builder {
        crate::model::resource_utilization::Builder::default()
    }
}

/// <p>Utilization metrics of the instance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2ResourceUtilization {
    /// <p> The maximum observed or expected CPU utilization of the instance.</p>
    pub max_cpu_utilization_percentage: std::option::Option<std::string::String>,
    /// <p> The maximum observed or expected memory utilization of the instance.</p>
    pub max_memory_utilization_percentage: std::option::Option<std::string::String>,
    /// <p> The maximum observed or expected storage utilization of the instance. This doesn't include EBS storage.</p>
    pub max_storage_utilization_percentage: std::option::Option<std::string::String>,
    /// <p>The EBS field that contains a list of EBS metrics that are associated with the current instance. </p>
    pub ebs_resource_utilization: std::option::Option<crate::model::EbsResourceUtilization>,
    /// <p> The field that contains a list of disk (local storage) metrics that are associated with the current instance. </p>
    pub disk_resource_utilization: std::option::Option<crate::model::DiskResourceUtilization>,
    /// <p> The network field that contains a list of network metrics that are associated with the current instance. </p>
    pub network_resource_utilization: std::option::Option<crate::model::NetworkResourceUtilization>,
}
impl Ec2ResourceUtilization {
    /// <p> The maximum observed or expected CPU utilization of the instance.</p>
    pub fn max_cpu_utilization_percentage(&self) -> std::option::Option<&str> {
        self.max_cpu_utilization_percentage.as_deref()
    }
    /// <p> The maximum observed or expected memory utilization of the instance.</p>
    pub fn max_memory_utilization_percentage(&self) -> std::option::Option<&str> {
        self.max_memory_utilization_percentage.as_deref()
    }
    /// <p> The maximum observed or expected storage utilization of the instance. This doesn't include EBS storage.</p>
    pub fn max_storage_utilization_percentage(&self) -> std::option::Option<&str> {
        self.max_storage_utilization_percentage.as_deref()
    }
    /// <p>The EBS field that contains a list of EBS metrics that are associated with the current instance. </p>
    pub fn ebs_resource_utilization(
        &self,
    ) -> std::option::Option<&crate::model::EbsResourceUtilization> {
        self.ebs_resource_utilization.as_ref()
    }
    /// <p> The field that contains a list of disk (local storage) metrics that are associated with the current instance. </p>
    pub fn disk_resource_utilization(
        &self,
    ) -> std::option::Option<&crate::model::DiskResourceUtilization> {
        self.disk_resource_utilization.as_ref()
    }
    /// <p> The network field that contains a list of network metrics that are associated with the current instance. </p>
    pub fn network_resource_utilization(
        &self,
    ) -> std::option::Option<&crate::model::NetworkResourceUtilization> {
        self.network_resource_utilization.as_ref()
    }
}
impl std::fmt::Debug for Ec2ResourceUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2ResourceUtilization");
        formatter.field(
            "max_cpu_utilization_percentage",
            &self.max_cpu_utilization_percentage,
        );
        formatter.field(
            "max_memory_utilization_percentage",
            &self.max_memory_utilization_percentage,
        );
        formatter.field(
            "max_storage_utilization_percentage",
            &self.max_storage_utilization_percentage,
        );
        formatter.field("ebs_resource_utilization", &self.ebs_resource_utilization);
        formatter.field("disk_resource_utilization", &self.disk_resource_utilization);
        formatter.field(
            "network_resource_utilization",
            &self.network_resource_utilization,
        );
        formatter.finish()
    }
}
/// See [`Ec2ResourceUtilization`](crate::model::Ec2ResourceUtilization)
pub mod ec2_resource_utilization {
    /// A builder for [`Ec2ResourceUtilization`](crate::model::Ec2ResourceUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_cpu_utilization_percentage: std::option::Option<std::string::String>,
        pub(crate) max_memory_utilization_percentage: std::option::Option<std::string::String>,
        pub(crate) max_storage_utilization_percentage: std::option::Option<std::string::String>,
        pub(crate) ebs_resource_utilization:
            std::option::Option<crate::model::EbsResourceUtilization>,
        pub(crate) disk_resource_utilization:
            std::option::Option<crate::model::DiskResourceUtilization>,
        pub(crate) network_resource_utilization:
            std::option::Option<crate::model::NetworkResourceUtilization>,
    }
    impl Builder {
        /// <p> The maximum observed or expected CPU utilization of the instance.</p>
        pub fn max_cpu_utilization_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.max_cpu_utilization_percentage = Some(input.into());
            self
        }
        /// <p> The maximum observed or expected CPU utilization of the instance.</p>
        pub fn set_max_cpu_utilization_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_cpu_utilization_percentage = input;
            self
        }
        /// <p> The maximum observed or expected memory utilization of the instance.</p>
        pub fn max_memory_utilization_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.max_memory_utilization_percentage = Some(input.into());
            self
        }
        /// <p> The maximum observed or expected memory utilization of the instance.</p>
        pub fn set_max_memory_utilization_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_memory_utilization_percentage = input;
            self
        }
        /// <p> The maximum observed or expected storage utilization of the instance. This doesn't include EBS storage.</p>
        pub fn max_storage_utilization_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.max_storage_utilization_percentage = Some(input.into());
            self
        }
        /// <p> The maximum observed or expected storage utilization of the instance. This doesn't include EBS storage.</p>
        pub fn set_max_storage_utilization_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.max_storage_utilization_percentage = input;
            self
        }
        /// <p>The EBS field that contains a list of EBS metrics that are associated with the current instance. </p>
        pub fn ebs_resource_utilization(
            mut self,
            input: crate::model::EbsResourceUtilization,
        ) -> Self {
            self.ebs_resource_utilization = Some(input);
            self
        }
        /// <p>The EBS field that contains a list of EBS metrics that are associated with the current instance. </p>
        pub fn set_ebs_resource_utilization(
            mut self,
            input: std::option::Option<crate::model::EbsResourceUtilization>,
        ) -> Self {
            self.ebs_resource_utilization = input;
            self
        }
        /// <p> The field that contains a list of disk (local storage) metrics that are associated with the current instance. </p>
        pub fn disk_resource_utilization(
            mut self,
            input: crate::model::DiskResourceUtilization,
        ) -> Self {
            self.disk_resource_utilization = Some(input);
            self
        }
        /// <p> The field that contains a list of disk (local storage) metrics that are associated with the current instance. </p>
        pub fn set_disk_resource_utilization(
            mut self,
            input: std::option::Option<crate::model::DiskResourceUtilization>,
        ) -> Self {
            self.disk_resource_utilization = input;
            self
        }
        /// <p> The network field that contains a list of network metrics that are associated with the current instance. </p>
        pub fn network_resource_utilization(
            mut self,
            input: crate::model::NetworkResourceUtilization,
        ) -> Self {
            self.network_resource_utilization = Some(input);
            self
        }
        /// <p> The network field that contains a list of network metrics that are associated with the current instance. </p>
        pub fn set_network_resource_utilization(
            mut self,
            input: std::option::Option<crate::model::NetworkResourceUtilization>,
        ) -> Self {
            self.network_resource_utilization = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2ResourceUtilization`](crate::model::Ec2ResourceUtilization)
        pub fn build(self) -> crate::model::Ec2ResourceUtilization {
            crate::model::Ec2ResourceUtilization {
                max_cpu_utilization_percentage: self.max_cpu_utilization_percentage,
                max_memory_utilization_percentage: self.max_memory_utilization_percentage,
                max_storage_utilization_percentage: self.max_storage_utilization_percentage,
                ebs_resource_utilization: self.ebs_resource_utilization,
                disk_resource_utilization: self.disk_resource_utilization,
                network_resource_utilization: self.network_resource_utilization,
            }
        }
    }
}
impl Ec2ResourceUtilization {
    /// Creates a new builder-style object to manufacture [`Ec2ResourceUtilization`](crate::model::Ec2ResourceUtilization)
    pub fn builder() -> crate::model::ec2_resource_utilization::Builder {
        crate::model::ec2_resource_utilization::Builder::default()
    }
}

/// <p> The network field that contains a list of network metrics that are associated with the current instance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkResourceUtilization {
    /// <p> The network inbound throughput utilization measured in Bytes per second. </p>
    pub network_in_bytes_per_second: std::option::Option<std::string::String>,
    /// <p> The network outbound throughput utilization measured in Bytes per second. </p>
    pub network_out_bytes_per_second: std::option::Option<std::string::String>,
    /// <p> The network ingress packets that are measured in packets per second. </p>
    pub network_packets_in_per_second: std::option::Option<std::string::String>,
    /// <p> The network outgress packets that are measured in packets per second. </p>
    pub network_packets_out_per_second: std::option::Option<std::string::String>,
}
impl NetworkResourceUtilization {
    /// <p> The network inbound throughput utilization measured in Bytes per second. </p>
    pub fn network_in_bytes_per_second(&self) -> std::option::Option<&str> {
        self.network_in_bytes_per_second.as_deref()
    }
    /// <p> The network outbound throughput utilization measured in Bytes per second. </p>
    pub fn network_out_bytes_per_second(&self) -> std::option::Option<&str> {
        self.network_out_bytes_per_second.as_deref()
    }
    /// <p> The network ingress packets that are measured in packets per second. </p>
    pub fn network_packets_in_per_second(&self) -> std::option::Option<&str> {
        self.network_packets_in_per_second.as_deref()
    }
    /// <p> The network outgress packets that are measured in packets per second. </p>
    pub fn network_packets_out_per_second(&self) -> std::option::Option<&str> {
        self.network_packets_out_per_second.as_deref()
    }
}
impl std::fmt::Debug for NetworkResourceUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkResourceUtilization");
        formatter.field(
            "network_in_bytes_per_second",
            &self.network_in_bytes_per_second,
        );
        formatter.field(
            "network_out_bytes_per_second",
            &self.network_out_bytes_per_second,
        );
        formatter.field(
            "network_packets_in_per_second",
            &self.network_packets_in_per_second,
        );
        formatter.field(
            "network_packets_out_per_second",
            &self.network_packets_out_per_second,
        );
        formatter.finish()
    }
}
/// See [`NetworkResourceUtilization`](crate::model::NetworkResourceUtilization)
pub mod network_resource_utilization {
    /// A builder for [`NetworkResourceUtilization`](crate::model::NetworkResourceUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_in_bytes_per_second: std::option::Option<std::string::String>,
        pub(crate) network_out_bytes_per_second: std::option::Option<std::string::String>,
        pub(crate) network_packets_in_per_second: std::option::Option<std::string::String>,
        pub(crate) network_packets_out_per_second: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The network inbound throughput utilization measured in Bytes per second. </p>
        pub fn network_in_bytes_per_second(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_in_bytes_per_second = Some(input.into());
            self
        }
        /// <p> The network inbound throughput utilization measured in Bytes per second. </p>
        pub fn set_network_in_bytes_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_in_bytes_per_second = input;
            self
        }
        /// <p> The network outbound throughput utilization measured in Bytes per second. </p>
        pub fn network_out_bytes_per_second(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_out_bytes_per_second = Some(input.into());
            self
        }
        /// <p> The network outbound throughput utilization measured in Bytes per second. </p>
        pub fn set_network_out_bytes_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_out_bytes_per_second = input;
            self
        }
        /// <p> The network ingress packets that are measured in packets per second. </p>
        pub fn network_packets_in_per_second(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_packets_in_per_second = Some(input.into());
            self
        }
        /// <p> The network ingress packets that are measured in packets per second. </p>
        pub fn set_network_packets_in_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_packets_in_per_second = input;
            self
        }
        /// <p> The network outgress packets that are measured in packets per second. </p>
        pub fn network_packets_out_per_second(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.network_packets_out_per_second = Some(input.into());
            self
        }
        /// <p> The network outgress packets that are measured in packets per second. </p>
        pub fn set_network_packets_out_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_packets_out_per_second = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkResourceUtilization`](crate::model::NetworkResourceUtilization)
        pub fn build(self) -> crate::model::NetworkResourceUtilization {
            crate::model::NetworkResourceUtilization {
                network_in_bytes_per_second: self.network_in_bytes_per_second,
                network_out_bytes_per_second: self.network_out_bytes_per_second,
                network_packets_in_per_second: self.network_packets_in_per_second,
                network_packets_out_per_second: self.network_packets_out_per_second,
            }
        }
    }
}
impl NetworkResourceUtilization {
    /// Creates a new builder-style object to manufacture [`NetworkResourceUtilization`](crate::model::NetworkResourceUtilization)
    pub fn builder() -> crate::model::network_resource_utilization::Builder {
        crate::model::network_resource_utilization::Builder::default()
    }
}

/// <p> The field that contains a list of disk (local storage) metrics that are associated with the current instance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DiskResourceUtilization {
    /// <p> The maximum number of read operations per second. </p>
    pub disk_read_ops_per_second: std::option::Option<std::string::String>,
    /// <p> The maximum number of write operations per second. </p>
    pub disk_write_ops_per_second: std::option::Option<std::string::String>,
    /// <p> The maximum read throughput operations per second. </p>
    pub disk_read_bytes_per_second: std::option::Option<std::string::String>,
    /// <p> The maximum write throughput operations per second. </p>
    pub disk_write_bytes_per_second: std::option::Option<std::string::String>,
}
impl DiskResourceUtilization {
    /// <p> The maximum number of read operations per second. </p>
    pub fn disk_read_ops_per_second(&self) -> std::option::Option<&str> {
        self.disk_read_ops_per_second.as_deref()
    }
    /// <p> The maximum number of write operations per second. </p>
    pub fn disk_write_ops_per_second(&self) -> std::option::Option<&str> {
        self.disk_write_ops_per_second.as_deref()
    }
    /// <p> The maximum read throughput operations per second. </p>
    pub fn disk_read_bytes_per_second(&self) -> std::option::Option<&str> {
        self.disk_read_bytes_per_second.as_deref()
    }
    /// <p> The maximum write throughput operations per second. </p>
    pub fn disk_write_bytes_per_second(&self) -> std::option::Option<&str> {
        self.disk_write_bytes_per_second.as_deref()
    }
}
impl std::fmt::Debug for DiskResourceUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DiskResourceUtilization");
        formatter.field("disk_read_ops_per_second", &self.disk_read_ops_per_second);
        formatter.field("disk_write_ops_per_second", &self.disk_write_ops_per_second);
        formatter.field(
            "disk_read_bytes_per_second",
            &self.disk_read_bytes_per_second,
        );
        formatter.field(
            "disk_write_bytes_per_second",
            &self.disk_write_bytes_per_second,
        );
        formatter.finish()
    }
}
/// See [`DiskResourceUtilization`](crate::model::DiskResourceUtilization)
pub mod disk_resource_utilization {
    /// A builder for [`DiskResourceUtilization`](crate::model::DiskResourceUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) disk_read_ops_per_second: std::option::Option<std::string::String>,
        pub(crate) disk_write_ops_per_second: std::option::Option<std::string::String>,
        pub(crate) disk_read_bytes_per_second: std::option::Option<std::string::String>,
        pub(crate) disk_write_bytes_per_second: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The maximum number of read operations per second. </p>
        pub fn disk_read_ops_per_second(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_read_ops_per_second = Some(input.into());
            self
        }
        /// <p> The maximum number of read operations per second. </p>
        pub fn set_disk_read_ops_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_read_ops_per_second = input;
            self
        }
        /// <p> The maximum number of write operations per second. </p>
        pub fn disk_write_ops_per_second(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_write_ops_per_second = Some(input.into());
            self
        }
        /// <p> The maximum number of write operations per second. </p>
        pub fn set_disk_write_ops_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_write_ops_per_second = input;
            self
        }
        /// <p> The maximum read throughput operations per second. </p>
        pub fn disk_read_bytes_per_second(mut self, input: impl Into<std::string::String>) -> Self {
            self.disk_read_bytes_per_second = Some(input.into());
            self
        }
        /// <p> The maximum read throughput operations per second. </p>
        pub fn set_disk_read_bytes_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_read_bytes_per_second = input;
            self
        }
        /// <p> The maximum write throughput operations per second. </p>
        pub fn disk_write_bytes_per_second(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.disk_write_bytes_per_second = Some(input.into());
            self
        }
        /// <p> The maximum write throughput operations per second. </p>
        pub fn set_disk_write_bytes_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.disk_write_bytes_per_second = input;
            self
        }
        /// Consumes the builder and constructs a [`DiskResourceUtilization`](crate::model::DiskResourceUtilization)
        pub fn build(self) -> crate::model::DiskResourceUtilization {
            crate::model::DiskResourceUtilization {
                disk_read_ops_per_second: self.disk_read_ops_per_second,
                disk_write_ops_per_second: self.disk_write_ops_per_second,
                disk_read_bytes_per_second: self.disk_read_bytes_per_second,
                disk_write_bytes_per_second: self.disk_write_bytes_per_second,
            }
        }
    }
}
impl DiskResourceUtilization {
    /// Creates a new builder-style object to manufacture [`DiskResourceUtilization`](crate::model::DiskResourceUtilization)
    pub fn builder() -> crate::model::disk_resource_utilization::Builder {
        crate::model::disk_resource_utilization::Builder::default()
    }
}

/// <p>The EBS field that contains a list of EBS metrics that are associated with the current instance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EbsResourceUtilization {
    /// <p>The maximum number of read operations per second. </p>
    pub ebs_read_ops_per_second: std::option::Option<std::string::String>,
    /// <p>The maximum number of write operations per second. </p>
    pub ebs_write_ops_per_second: std::option::Option<std::string::String>,
    /// <p>The maximum size of read operations per second </p>
    pub ebs_read_bytes_per_second: std::option::Option<std::string::String>,
    /// <p>The maximum size of write operations per second. </p>
    pub ebs_write_bytes_per_second: std::option::Option<std::string::String>,
}
impl EbsResourceUtilization {
    /// <p>The maximum number of read operations per second. </p>
    pub fn ebs_read_ops_per_second(&self) -> std::option::Option<&str> {
        self.ebs_read_ops_per_second.as_deref()
    }
    /// <p>The maximum number of write operations per second. </p>
    pub fn ebs_write_ops_per_second(&self) -> std::option::Option<&str> {
        self.ebs_write_ops_per_second.as_deref()
    }
    /// <p>The maximum size of read operations per second </p>
    pub fn ebs_read_bytes_per_second(&self) -> std::option::Option<&str> {
        self.ebs_read_bytes_per_second.as_deref()
    }
    /// <p>The maximum size of write operations per second. </p>
    pub fn ebs_write_bytes_per_second(&self) -> std::option::Option<&str> {
        self.ebs_write_bytes_per_second.as_deref()
    }
}
impl std::fmt::Debug for EbsResourceUtilization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EbsResourceUtilization");
        formatter.field("ebs_read_ops_per_second", &self.ebs_read_ops_per_second);
        formatter.field("ebs_write_ops_per_second", &self.ebs_write_ops_per_second);
        formatter.field("ebs_read_bytes_per_second", &self.ebs_read_bytes_per_second);
        formatter.field(
            "ebs_write_bytes_per_second",
            &self.ebs_write_bytes_per_second,
        );
        formatter.finish()
    }
}
/// See [`EbsResourceUtilization`](crate::model::EbsResourceUtilization)
pub mod ebs_resource_utilization {
    /// A builder for [`EbsResourceUtilization`](crate::model::EbsResourceUtilization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ebs_read_ops_per_second: std::option::Option<std::string::String>,
        pub(crate) ebs_write_ops_per_second: std::option::Option<std::string::String>,
        pub(crate) ebs_read_bytes_per_second: std::option::Option<std::string::String>,
        pub(crate) ebs_write_bytes_per_second: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of read operations per second. </p>
        pub fn ebs_read_ops_per_second(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_read_ops_per_second = Some(input.into());
            self
        }
        /// <p>The maximum number of read operations per second. </p>
        pub fn set_ebs_read_ops_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_read_ops_per_second = input;
            self
        }
        /// <p>The maximum number of write operations per second. </p>
        pub fn ebs_write_ops_per_second(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_write_ops_per_second = Some(input.into());
            self
        }
        /// <p>The maximum number of write operations per second. </p>
        pub fn set_ebs_write_ops_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_write_ops_per_second = input;
            self
        }
        /// <p>The maximum size of read operations per second </p>
        pub fn ebs_read_bytes_per_second(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_read_bytes_per_second = Some(input.into());
            self
        }
        /// <p>The maximum size of read operations per second </p>
        pub fn set_ebs_read_bytes_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_read_bytes_per_second = input;
            self
        }
        /// <p>The maximum size of write operations per second. </p>
        pub fn ebs_write_bytes_per_second(mut self, input: impl Into<std::string::String>) -> Self {
            self.ebs_write_bytes_per_second = Some(input.into());
            self
        }
        /// <p>The maximum size of write operations per second. </p>
        pub fn set_ebs_write_bytes_per_second(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ebs_write_bytes_per_second = input;
            self
        }
        /// Consumes the builder and constructs a [`EbsResourceUtilization`](crate::model::EbsResourceUtilization)
        pub fn build(self) -> crate::model::EbsResourceUtilization {
            crate::model::EbsResourceUtilization {
                ebs_read_ops_per_second: self.ebs_read_ops_per_second,
                ebs_write_ops_per_second: self.ebs_write_ops_per_second,
                ebs_read_bytes_per_second: self.ebs_read_bytes_per_second,
                ebs_write_bytes_per_second: self.ebs_write_bytes_per_second,
            }
        }
    }
}
impl EbsResourceUtilization {
    /// Creates a new builder-style object to manufacture [`EbsResourceUtilization`](crate::model::EbsResourceUtilization)
    pub fn builder() -> crate::model::ebs_resource_utilization::Builder {
        crate::model::ebs_resource_utilization::Builder::default()
    }
}

/// <p>Details on the resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceDetails {
    /// <p>Details on the Amazon EC2 resource.</p>
    pub ec2_resource_details: std::option::Option<crate::model::Ec2ResourceDetails>,
}
impl ResourceDetails {
    /// <p>Details on the Amazon EC2 resource.</p>
    pub fn ec2_resource_details(&self) -> std::option::Option<&crate::model::Ec2ResourceDetails> {
        self.ec2_resource_details.as_ref()
    }
}
impl std::fmt::Debug for ResourceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceDetails");
        formatter.field("ec2_resource_details", &self.ec2_resource_details);
        formatter.finish()
    }
}
/// See [`ResourceDetails`](crate::model::ResourceDetails)
pub mod resource_details {
    /// A builder for [`ResourceDetails`](crate::model::ResourceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_resource_details: std::option::Option<crate::model::Ec2ResourceDetails>,
    }
    impl Builder {
        /// <p>Details on the Amazon EC2 resource.</p>
        pub fn ec2_resource_details(mut self, input: crate::model::Ec2ResourceDetails) -> Self {
            self.ec2_resource_details = Some(input);
            self
        }
        /// <p>Details on the Amazon EC2 resource.</p>
        pub fn set_ec2_resource_details(
            mut self,
            input: std::option::Option<crate::model::Ec2ResourceDetails>,
        ) -> Self {
            self.ec2_resource_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceDetails`](crate::model::ResourceDetails)
        pub fn build(self) -> crate::model::ResourceDetails {
            crate::model::ResourceDetails {
                ec2_resource_details: self.ec2_resource_details,
            }
        }
    }
}
impl ResourceDetails {
    /// Creates a new builder-style object to manufacture [`ResourceDetails`](crate::model::ResourceDetails)
    pub fn builder() -> crate::model::resource_details::Builder {
        crate::model::resource_details::Builder::default()
    }
}

/// <p>Details on the Amazon EC2 Resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2ResourceDetails {
    /// <p>The hourly public On-Demand rate for the instance type.</p>
    pub hourly_on_demand_rate: std::option::Option<std::string::String>,
    /// <p>The type of Amazon Web Services instance.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The platform of the Amazon Web Services instance. The platform is the specific combination of operating system, license model, and software on an instance.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region of the instance.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The SKU of the product.</p>
    pub sku: std::option::Option<std::string::String>,
    /// <p>The memory capacity of the Amazon Web Services instance.</p>
    pub memory: std::option::Option<std::string::String>,
    /// <p>The network performance capacity of the Amazon Web Services instance.</p>
    pub network_performance: std::option::Option<std::string::String>,
    /// <p>The disk storage of the Amazon Web Services instance. This doesn't include EBS storage.</p>
    pub storage: std::option::Option<std::string::String>,
    /// <p> The number of VCPU cores in the Amazon Web Services instance type.</p>
    pub vcpu: std::option::Option<std::string::String>,
}
impl Ec2ResourceDetails {
    /// <p>The hourly public On-Demand rate for the instance type.</p>
    pub fn hourly_on_demand_rate(&self) -> std::option::Option<&str> {
        self.hourly_on_demand_rate.as_deref()
    }
    /// <p>The type of Amazon Web Services instance.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The platform of the Amazon Web Services instance. The platform is the specific combination of operating system, license model, and software on an instance.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>The Amazon Web Services Region of the instance.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The SKU of the product.</p>
    pub fn sku(&self) -> std::option::Option<&str> {
        self.sku.as_deref()
    }
    /// <p>The memory capacity of the Amazon Web Services instance.</p>
    pub fn memory(&self) -> std::option::Option<&str> {
        self.memory.as_deref()
    }
    /// <p>The network performance capacity of the Amazon Web Services instance.</p>
    pub fn network_performance(&self) -> std::option::Option<&str> {
        self.network_performance.as_deref()
    }
    /// <p>The disk storage of the Amazon Web Services instance. This doesn't include EBS storage.</p>
    pub fn storage(&self) -> std::option::Option<&str> {
        self.storage.as_deref()
    }
    /// <p> The number of VCPU cores in the Amazon Web Services instance type.</p>
    pub fn vcpu(&self) -> std::option::Option<&str> {
        self.vcpu.as_deref()
    }
}
impl std::fmt::Debug for Ec2ResourceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2ResourceDetails");
        formatter.field("hourly_on_demand_rate", &self.hourly_on_demand_rate);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("platform", &self.platform);
        formatter.field("region", &self.region);
        formatter.field("sku", &self.sku);
        formatter.field("memory", &self.memory);
        formatter.field("network_performance", &self.network_performance);
        formatter.field("storage", &self.storage);
        formatter.field("vcpu", &self.vcpu);
        formatter.finish()
    }
}
/// See [`Ec2ResourceDetails`](crate::model::Ec2ResourceDetails)
pub mod ec2_resource_details {
    /// A builder for [`Ec2ResourceDetails`](crate::model::Ec2ResourceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hourly_on_demand_rate: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) sku: std::option::Option<std::string::String>,
        pub(crate) memory: std::option::Option<std::string::String>,
        pub(crate) network_performance: std::option::Option<std::string::String>,
        pub(crate) storage: std::option::Option<std::string::String>,
        pub(crate) vcpu: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The hourly public On-Demand rate for the instance type.</p>
        pub fn hourly_on_demand_rate(mut self, input: impl Into<std::string::String>) -> Self {
            self.hourly_on_demand_rate = Some(input.into());
            self
        }
        /// <p>The hourly public On-Demand rate for the instance type.</p>
        pub fn set_hourly_on_demand_rate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hourly_on_demand_rate = input;
            self
        }
        /// <p>The type of Amazon Web Services instance.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The type of Amazon Web Services instance.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The platform of the Amazon Web Services instance. The platform is the specific combination of operating system, license model, and software on an instance.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform of the Amazon Web Services instance. The platform is the specific combination of operating system, license model, and software on an instance.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>The Amazon Web Services Region of the instance.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the instance.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The SKU of the product.</p>
        pub fn sku(mut self, input: impl Into<std::string::String>) -> Self {
            self.sku = Some(input.into());
            self
        }
        /// <p>The SKU of the product.</p>
        pub fn set_sku(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sku = input;
            self
        }
        /// <p>The memory capacity of the Amazon Web Services instance.</p>
        pub fn memory(mut self, input: impl Into<std::string::String>) -> Self {
            self.memory = Some(input.into());
            self
        }
        /// <p>The memory capacity of the Amazon Web Services instance.</p>
        pub fn set_memory(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.memory = input;
            self
        }
        /// <p>The network performance capacity of the Amazon Web Services instance.</p>
        pub fn network_performance(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_performance = Some(input.into());
            self
        }
        /// <p>The network performance capacity of the Amazon Web Services instance.</p>
        pub fn set_network_performance(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_performance = input;
            self
        }
        /// <p>The disk storage of the Amazon Web Services instance. This doesn't include EBS storage.</p>
        pub fn storage(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage = Some(input.into());
            self
        }
        /// <p>The disk storage of the Amazon Web Services instance. This doesn't include EBS storage.</p>
        pub fn set_storage(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage = input;
            self
        }
        /// <p> The number of VCPU cores in the Amazon Web Services instance type.</p>
        pub fn vcpu(mut self, input: impl Into<std::string::String>) -> Self {
            self.vcpu = Some(input.into());
            self
        }
        /// <p> The number of VCPU cores in the Amazon Web Services instance type.</p>
        pub fn set_vcpu(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vcpu = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2ResourceDetails`](crate::model::Ec2ResourceDetails)
        pub fn build(self) -> crate::model::Ec2ResourceDetails {
            crate::model::Ec2ResourceDetails {
                hourly_on_demand_rate: self.hourly_on_demand_rate,
                instance_type: self.instance_type,
                platform: self.platform,
                region: self.region,
                sku: self.sku,
                memory: self.memory,
                network_performance: self.network_performance,
                storage: self.storage,
                vcpu: self.vcpu,
            }
        }
    }
}
impl Ec2ResourceDetails {
    /// Creates a new builder-style object to manufacture [`Ec2ResourceDetails`](crate::model::Ec2ResourceDetails)
    pub fn builder() -> crate::model::ec2_resource_details::Builder {
        crate::model::ec2_resource_details::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RightsizingType {
    #[allow(missing_docs)] // documentation missing in model
    Modify,
    #[allow(missing_docs)] // documentation missing in model
    Terminate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RightsizingType {
    fn from(s: &str) -> Self {
        match s {
            "MODIFY" => RightsizingType::Modify,
            "TERMINATE" => RightsizingType::Terminate,
            other => RightsizingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RightsizingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RightsizingType::from(s))
    }
}
impl RightsizingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RightsizingType::Modify => "MODIFY",
            RightsizingType::Terminate => "TERMINATE",
            RightsizingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MODIFY", "TERMINATE"]
    }
}
impl AsRef<str> for RightsizingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Context about the current instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CurrentInstance {
    /// <p>Resource ID of the current instance.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The name that you given an instance. This field shows as blank if you haven't given the instance a name.</p>
    pub instance_name: std::option::Option<std::string::String>,
    /// <p>Cost allocation resource tags that are applied to the instance.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::TagValues>>,
    /// <p>Details about the resource and utilization.</p>
    pub resource_details: std::option::Option<crate::model::ResourceDetails>,
    /// <p>Utilization information of the current instance during the lookback period.</p>
    pub resource_utilization: std::option::Option<crate::model::ResourceUtilization>,
    /// <p> The number of hours during the lookback period that's covered by reservations.</p>
    pub reservation_covered_hours_in_lookback_period: std::option::Option<std::string::String>,
    /// <p>The number of hours during the lookback period that's covered by Savings Plans.</p>
    pub savings_plans_covered_hours_in_lookback_period: std::option::Option<std::string::String>,
    /// <p> The number of hours during the lookback period that's billed at On-Demand rates.</p>
    pub on_demand_hours_in_lookback_period: std::option::Option<std::string::String>,
    /// <p>The total number of hours that the instance ran during the lookback period.</p>
    pub total_running_hours_in_lookback_period: std::option::Option<std::string::String>,
    /// <p>The current On-Demand cost of operating this instance on a monthly basis.</p>
    pub monthly_cost: std::option::Option<std::string::String>,
    /// <p> The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub currency_code: std::option::Option<std::string::String>,
}
impl CurrentInstance {
    /// <p>Resource ID of the current instance.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The name that you given an instance. This field shows as blank if you haven't given the instance a name.</p>
    pub fn instance_name(&self) -> std::option::Option<&str> {
        self.instance_name.as_deref()
    }
    /// <p>Cost allocation resource tags that are applied to the instance.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::TagValues]> {
        self.tags.as_deref()
    }
    /// <p>Details about the resource and utilization.</p>
    pub fn resource_details(&self) -> std::option::Option<&crate::model::ResourceDetails> {
        self.resource_details.as_ref()
    }
    /// <p>Utilization information of the current instance during the lookback period.</p>
    pub fn resource_utilization(&self) -> std::option::Option<&crate::model::ResourceUtilization> {
        self.resource_utilization.as_ref()
    }
    /// <p> The number of hours during the lookback period that's covered by reservations.</p>
    pub fn reservation_covered_hours_in_lookback_period(&self) -> std::option::Option<&str> {
        self.reservation_covered_hours_in_lookback_period.as_deref()
    }
    /// <p>The number of hours during the lookback period that's covered by Savings Plans.</p>
    pub fn savings_plans_covered_hours_in_lookback_period(&self) -> std::option::Option<&str> {
        self.savings_plans_covered_hours_in_lookback_period
            .as_deref()
    }
    /// <p> The number of hours during the lookback period that's billed at On-Demand rates.</p>
    pub fn on_demand_hours_in_lookback_period(&self) -> std::option::Option<&str> {
        self.on_demand_hours_in_lookback_period.as_deref()
    }
    /// <p>The total number of hours that the instance ran during the lookback period.</p>
    pub fn total_running_hours_in_lookback_period(&self) -> std::option::Option<&str> {
        self.total_running_hours_in_lookback_period.as_deref()
    }
    /// <p>The current On-Demand cost of operating this instance on a monthly basis.</p>
    pub fn monthly_cost(&self) -> std::option::Option<&str> {
        self.monthly_cost.as_deref()
    }
    /// <p> The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
}
impl std::fmt::Debug for CurrentInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CurrentInstance");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("instance_name", &self.instance_name);
        formatter.field("tags", &self.tags);
        formatter.field("resource_details", &self.resource_details);
        formatter.field("resource_utilization", &self.resource_utilization);
        formatter.field(
            "reservation_covered_hours_in_lookback_period",
            &self.reservation_covered_hours_in_lookback_period,
        );
        formatter.field(
            "savings_plans_covered_hours_in_lookback_period",
            &self.savings_plans_covered_hours_in_lookback_period,
        );
        formatter.field(
            "on_demand_hours_in_lookback_period",
            &self.on_demand_hours_in_lookback_period,
        );
        formatter.field(
            "total_running_hours_in_lookback_period",
            &self.total_running_hours_in_lookback_period,
        );
        formatter.field("monthly_cost", &self.monthly_cost);
        formatter.field("currency_code", &self.currency_code);
        formatter.finish()
    }
}
/// See [`CurrentInstance`](crate::model::CurrentInstance)
pub mod current_instance {
    /// A builder for [`CurrentInstance`](crate::model::CurrentInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) instance_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::TagValues>>,
        pub(crate) resource_details: std::option::Option<crate::model::ResourceDetails>,
        pub(crate) resource_utilization: std::option::Option<crate::model::ResourceUtilization>,
        pub(crate) reservation_covered_hours_in_lookback_period:
            std::option::Option<std::string::String>,
        pub(crate) savings_plans_covered_hours_in_lookback_period:
            std::option::Option<std::string::String>,
        pub(crate) on_demand_hours_in_lookback_period: std::option::Option<std::string::String>,
        pub(crate) total_running_hours_in_lookback_period: std::option::Option<std::string::String>,
        pub(crate) monthly_cost: std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Resource ID of the current instance.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>Resource ID of the current instance.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The name that you given an instance. This field shows as blank if you haven't given the instance a name.</p>
        pub fn instance_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_name = Some(input.into());
            self
        }
        /// <p>The name that you given an instance. This field shows as blank if you haven't given the instance a name.</p>
        pub fn set_instance_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Cost allocation resource tags that are applied to the instance.</p>
        pub fn tags(mut self, input: crate::model::TagValues) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Cost allocation resource tags that are applied to the instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagValues>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Details about the resource and utilization.</p>
        pub fn resource_details(mut self, input: crate::model::ResourceDetails) -> Self {
            self.resource_details = Some(input);
            self
        }
        /// <p>Details about the resource and utilization.</p>
        pub fn set_resource_details(
            mut self,
            input: std::option::Option<crate::model::ResourceDetails>,
        ) -> Self {
            self.resource_details = input;
            self
        }
        /// <p>Utilization information of the current instance during the lookback period.</p>
        pub fn resource_utilization(mut self, input: crate::model::ResourceUtilization) -> Self {
            self.resource_utilization = Some(input);
            self
        }
        /// <p>Utilization information of the current instance during the lookback period.</p>
        pub fn set_resource_utilization(
            mut self,
            input: std::option::Option<crate::model::ResourceUtilization>,
        ) -> Self {
            self.resource_utilization = input;
            self
        }
        /// <p> The number of hours during the lookback period that's covered by reservations.</p>
        pub fn reservation_covered_hours_in_lookback_period(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reservation_covered_hours_in_lookback_period = Some(input.into());
            self
        }
        /// <p> The number of hours during the lookback period that's covered by reservations.</p>
        pub fn set_reservation_covered_hours_in_lookback_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_covered_hours_in_lookback_period = input;
            self
        }
        /// <p>The number of hours during the lookback period that's covered by Savings Plans.</p>
        pub fn savings_plans_covered_hours_in_lookback_period(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.savings_plans_covered_hours_in_lookback_period = Some(input.into());
            self
        }
        /// <p>The number of hours during the lookback period that's covered by Savings Plans.</p>
        pub fn set_savings_plans_covered_hours_in_lookback_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_plans_covered_hours_in_lookback_period = input;
            self
        }
        /// <p> The number of hours during the lookback period that's billed at On-Demand rates.</p>
        pub fn on_demand_hours_in_lookback_period(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.on_demand_hours_in_lookback_period = Some(input.into());
            self
        }
        /// <p> The number of hours during the lookback period that's billed at On-Demand rates.</p>
        pub fn set_on_demand_hours_in_lookback_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_hours_in_lookback_period = input;
            self
        }
        /// <p>The total number of hours that the instance ran during the lookback period.</p>
        pub fn total_running_hours_in_lookback_period(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.total_running_hours_in_lookback_period = Some(input.into());
            self
        }
        /// <p>The total number of hours that the instance ran during the lookback period.</p>
        pub fn set_total_running_hours_in_lookback_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_running_hours_in_lookback_period = input;
            self
        }
        /// <p>The current On-Demand cost of operating this instance on a monthly basis.</p>
        pub fn monthly_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.monthly_cost = Some(input.into());
            self
        }
        /// <p>The current On-Demand cost of operating this instance on a monthly basis.</p>
        pub fn set_monthly_cost(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monthly_cost = input;
            self
        }
        /// <p> The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p> The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Consumes the builder and constructs a [`CurrentInstance`](crate::model::CurrentInstance)
        pub fn build(self) -> crate::model::CurrentInstance {
            crate::model::CurrentInstance {
                resource_id: self.resource_id,
                instance_name: self.instance_name,
                tags: self.tags,
                resource_details: self.resource_details,
                resource_utilization: self.resource_utilization,
                reservation_covered_hours_in_lookback_period: self
                    .reservation_covered_hours_in_lookback_period,
                savings_plans_covered_hours_in_lookback_period: self
                    .savings_plans_covered_hours_in_lookback_period,
                on_demand_hours_in_lookback_period: self.on_demand_hours_in_lookback_period,
                total_running_hours_in_lookback_period: self.total_running_hours_in_lookback_period,
                monthly_cost: self.monthly_cost,
                currency_code: self.currency_code,
            }
        }
    }
}
impl CurrentInstance {
    /// Creates a new builder-style object to manufacture [`CurrentInstance`](crate::model::CurrentInstance)
    pub fn builder() -> crate::model::current_instance::Builder {
        crate::model::current_instance::Builder::default()
    }
}

/// <p>The summary of rightsizing recommendations </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RightsizingRecommendationSummary {
    /// <p>The total number of instance recommendations.</p>
    pub total_recommendation_count: std::option::Option<std::string::String>,
    /// <p>The estimated total savings resulting from modifications, on a monthly basis.</p>
    pub estimated_total_monthly_savings_amount: std::option::Option<std::string::String>,
    /// <p>The currency code that Amazon Web Services used to calculate the savings.</p>
    pub savings_currency_code: std::option::Option<std::string::String>,
    /// <p> The savings percentage based on the recommended modifications. It's relative to the total On-Demand costs that are associated with these instances.</p>
    pub savings_percentage: std::option::Option<std::string::String>,
}
impl RightsizingRecommendationSummary {
    /// <p>The total number of instance recommendations.</p>
    pub fn total_recommendation_count(&self) -> std::option::Option<&str> {
        self.total_recommendation_count.as_deref()
    }
    /// <p>The estimated total savings resulting from modifications, on a monthly basis.</p>
    pub fn estimated_total_monthly_savings_amount(&self) -> std::option::Option<&str> {
        self.estimated_total_monthly_savings_amount.as_deref()
    }
    /// <p>The currency code that Amazon Web Services used to calculate the savings.</p>
    pub fn savings_currency_code(&self) -> std::option::Option<&str> {
        self.savings_currency_code.as_deref()
    }
    /// <p> The savings percentage based on the recommended modifications. It's relative to the total On-Demand costs that are associated with these instances.</p>
    pub fn savings_percentage(&self) -> std::option::Option<&str> {
        self.savings_percentage.as_deref()
    }
}
impl std::fmt::Debug for RightsizingRecommendationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RightsizingRecommendationSummary");
        formatter.field(
            "total_recommendation_count",
            &self.total_recommendation_count,
        );
        formatter.field(
            "estimated_total_monthly_savings_amount",
            &self.estimated_total_monthly_savings_amount,
        );
        formatter.field("savings_currency_code", &self.savings_currency_code);
        formatter.field("savings_percentage", &self.savings_percentage);
        formatter.finish()
    }
}
/// See [`RightsizingRecommendationSummary`](crate::model::RightsizingRecommendationSummary)
pub mod rightsizing_recommendation_summary {
    /// A builder for [`RightsizingRecommendationSummary`](crate::model::RightsizingRecommendationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_recommendation_count: std::option::Option<std::string::String>,
        pub(crate) estimated_total_monthly_savings_amount: std::option::Option<std::string::String>,
        pub(crate) savings_currency_code: std::option::Option<std::string::String>,
        pub(crate) savings_percentage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total number of instance recommendations.</p>
        pub fn total_recommendation_count(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_recommendation_count = Some(input.into());
            self
        }
        /// <p>The total number of instance recommendations.</p>
        pub fn set_total_recommendation_count(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_recommendation_count = input;
            self
        }
        /// <p>The estimated total savings resulting from modifications, on a monthly basis.</p>
        pub fn estimated_total_monthly_savings_amount(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_total_monthly_savings_amount = Some(input.into());
            self
        }
        /// <p>The estimated total savings resulting from modifications, on a monthly basis.</p>
        pub fn set_estimated_total_monthly_savings_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_total_monthly_savings_amount = input;
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the savings.</p>
        pub fn savings_currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_currency_code = Some(input.into());
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the savings.</p>
        pub fn set_savings_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_currency_code = input;
            self
        }
        /// <p> The savings percentage based on the recommended modifications. It's relative to the total On-Demand costs that are associated with these instances.</p>
        pub fn savings_percentage(mut self, input: impl Into<std::string::String>) -> Self {
            self.savings_percentage = Some(input.into());
            self
        }
        /// <p> The savings percentage based on the recommended modifications. It's relative to the total On-Demand costs that are associated with these instances.</p>
        pub fn set_savings_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.savings_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`RightsizingRecommendationSummary`](crate::model::RightsizingRecommendationSummary)
        pub fn build(self) -> crate::model::RightsizingRecommendationSummary {
            crate::model::RightsizingRecommendationSummary {
                total_recommendation_count: self.total_recommendation_count,
                estimated_total_monthly_savings_amount: self.estimated_total_monthly_savings_amount,
                savings_currency_code: self.savings_currency_code,
                savings_percentage: self.savings_percentage,
            }
        }
    }
}
impl RightsizingRecommendationSummary {
    /// Creates a new builder-style object to manufacture [`RightsizingRecommendationSummary`](crate::model::RightsizingRecommendationSummary)
    pub fn builder() -> crate::model::rightsizing_recommendation_summary::Builder {
        crate::model::rightsizing_recommendation_summary::Builder::default()
    }
}

/// <p>Metadata for this recommendation set.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RightsizingRecommendationMetadata {
    /// <p>The ID for this specific recommendation.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
    pub generation_timestamp: std::option::Option<std::string::String>,
    /// <p>The number of days of previous usage that Amazon Web Services considers when making this recommendation.</p>
    pub lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
    /// <p>Additional metadata that might be applicable to the recommendation.</p>
    pub additional_metadata: std::option::Option<std::string::String>,
}
impl RightsizingRecommendationMetadata {
    /// <p>The ID for this specific recommendation.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
    pub fn generation_timestamp(&self) -> std::option::Option<&str> {
        self.generation_timestamp.as_deref()
    }
    /// <p>The number of days of previous usage that Amazon Web Services considers when making this recommendation.</p>
    pub fn lookback_period_in_days(
        &self,
    ) -> std::option::Option<&crate::model::LookbackPeriodInDays> {
        self.lookback_period_in_days.as_ref()
    }
    /// <p>Additional metadata that might be applicable to the recommendation.</p>
    pub fn additional_metadata(&self) -> std::option::Option<&str> {
        self.additional_metadata.as_deref()
    }
}
impl std::fmt::Debug for RightsizingRecommendationMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RightsizingRecommendationMetadata");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("generation_timestamp", &self.generation_timestamp);
        formatter.field("lookback_period_in_days", &self.lookback_period_in_days);
        formatter.field("additional_metadata", &self.additional_metadata);
        formatter.finish()
    }
}
/// See [`RightsizingRecommendationMetadata`](crate::model::RightsizingRecommendationMetadata)
pub mod rightsizing_recommendation_metadata {
    /// A builder for [`RightsizingRecommendationMetadata`](crate::model::RightsizingRecommendationMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) generation_timestamp: std::option::Option<std::string::String>,
        pub(crate) lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
        pub(crate) additional_metadata: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for this specific recommendation.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>The ID for this specific recommendation.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
        pub fn generation_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
        pub fn set_generation_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_timestamp = input;
            self
        }
        /// <p>The number of days of previous usage that Amazon Web Services considers when making this recommendation.</p>
        pub fn lookback_period_in_days(
            mut self,
            input: crate::model::LookbackPeriodInDays,
        ) -> Self {
            self.lookback_period_in_days = Some(input);
            self
        }
        /// <p>The number of days of previous usage that Amazon Web Services considers when making this recommendation.</p>
        pub fn set_lookback_period_in_days(
            mut self,
            input: std::option::Option<crate::model::LookbackPeriodInDays>,
        ) -> Self {
            self.lookback_period_in_days = input;
            self
        }
        /// <p>Additional metadata that might be applicable to the recommendation.</p>
        pub fn additional_metadata(mut self, input: impl Into<std::string::String>) -> Self {
            self.additional_metadata = Some(input.into());
            self
        }
        /// <p>Additional metadata that might be applicable to the recommendation.</p>
        pub fn set_additional_metadata(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.additional_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`RightsizingRecommendationMetadata`](crate::model::RightsizingRecommendationMetadata)
        pub fn build(self) -> crate::model::RightsizingRecommendationMetadata {
            crate::model::RightsizingRecommendationMetadata {
                recommendation_id: self.recommendation_id,
                generation_timestamp: self.generation_timestamp,
                lookback_period_in_days: self.lookback_period_in_days,
                additional_metadata: self.additional_metadata,
            }
        }
    }
}
impl RightsizingRecommendationMetadata {
    /// Creates a new builder-style object to manufacture [`RightsizingRecommendationMetadata`](crate::model::RightsizingRecommendationMetadata)
    pub fn builder() -> crate::model::rightsizing_recommendation_metadata::Builder {
        crate::model::rightsizing_recommendation_metadata::Builder::default()
    }
}

/// <p>The aggregated numbers for your reservation usage.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationAggregates {
    /// <p>The percentage of reservation time that you used.</p>
    pub utilization_percentage: std::option::Option<std::string::String>,
    /// <p>The percentage of Amazon EC2 reservation time that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub utilization_percentage_in_units: std::option::Option<std::string::String>,
    /// <p>How many reservation hours that you purchased.</p>
    pub purchased_hours: std::option::Option<std::string::String>,
    /// <p>The number of Amazon EC2 reservation hours that you purchased. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub purchased_units: std::option::Option<std::string::String>,
    /// <p>The total number of reservation hours that you used.</p>
    pub total_actual_hours: std::option::Option<std::string::String>,
    /// <p>The total number of Amazon EC2 reservation hours that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub total_actual_units: std::option::Option<std::string::String>,
    /// <p>The number of reservation hours that you didn't use.</p>
    pub unused_hours: std::option::Option<std::string::String>,
    /// <p>The number of Amazon EC2 reservation hours that you didn't use. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub unused_units: std::option::Option<std::string::String>,
    /// <p>How much your reservation costs if charged On-Demand rates.</p>
    pub on_demand_cost_of_ri_hours_used: std::option::Option<std::string::String>,
    /// <p>How much you saved due to purchasing and utilizing reservation. Amazon Web Services calculates this by subtracting <code>TotalAmortizedFee</code> from <code>OnDemandCostOfRIHoursUsed</code>.</p>
    pub net_ri_savings: std::option::Option<std::string::String>,
    /// <p>How much you might save if you use your entire reservation.</p>
    pub total_potential_ri_savings: std::option::Option<std::string::String>,
    /// <p>The upfront cost of your reservation. It's amortized over the reservation period.</p>
    pub amortized_upfront_fee: std::option::Option<std::string::String>,
    /// <p>The monthly cost of your reservation. It's amortized over the reservation period.</p>
    pub amortized_recurring_fee: std::option::Option<std::string::String>,
    /// <p>The total cost of your reservation. It's amortized over the reservation period.</p>
    pub total_amortized_fee: std::option::Option<std::string::String>,
    /// <p>The cost of unused hours for your reservation.</p>
    pub ri_cost_for_unused_hours: std::option::Option<std::string::String>,
    /// <p>The realized savings because of purchasing and using a reservation.</p>
    pub realized_savings: std::option::Option<std::string::String>,
    /// <p>The unrealized savings because of purchasing and using a reservation.</p>
    pub unrealized_savings: std::option::Option<std::string::String>,
}
impl ReservationAggregates {
    /// <p>The percentage of reservation time that you used.</p>
    pub fn utilization_percentage(&self) -> std::option::Option<&str> {
        self.utilization_percentage.as_deref()
    }
    /// <p>The percentage of Amazon EC2 reservation time that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub fn utilization_percentage_in_units(&self) -> std::option::Option<&str> {
        self.utilization_percentage_in_units.as_deref()
    }
    /// <p>How many reservation hours that you purchased.</p>
    pub fn purchased_hours(&self) -> std::option::Option<&str> {
        self.purchased_hours.as_deref()
    }
    /// <p>The number of Amazon EC2 reservation hours that you purchased. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub fn purchased_units(&self) -> std::option::Option<&str> {
        self.purchased_units.as_deref()
    }
    /// <p>The total number of reservation hours that you used.</p>
    pub fn total_actual_hours(&self) -> std::option::Option<&str> {
        self.total_actual_hours.as_deref()
    }
    /// <p>The total number of Amazon EC2 reservation hours that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub fn total_actual_units(&self) -> std::option::Option<&str> {
        self.total_actual_units.as_deref()
    }
    /// <p>The number of reservation hours that you didn't use.</p>
    pub fn unused_hours(&self) -> std::option::Option<&str> {
        self.unused_hours.as_deref()
    }
    /// <p>The number of Amazon EC2 reservation hours that you didn't use. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
    pub fn unused_units(&self) -> std::option::Option<&str> {
        self.unused_units.as_deref()
    }
    /// <p>How much your reservation costs if charged On-Demand rates.</p>
    pub fn on_demand_cost_of_ri_hours_used(&self) -> std::option::Option<&str> {
        self.on_demand_cost_of_ri_hours_used.as_deref()
    }
    /// <p>How much you saved due to purchasing and utilizing reservation. Amazon Web Services calculates this by subtracting <code>TotalAmortizedFee</code> from <code>OnDemandCostOfRIHoursUsed</code>.</p>
    pub fn net_ri_savings(&self) -> std::option::Option<&str> {
        self.net_ri_savings.as_deref()
    }
    /// <p>How much you might save if you use your entire reservation.</p>
    pub fn total_potential_ri_savings(&self) -> std::option::Option<&str> {
        self.total_potential_ri_savings.as_deref()
    }
    /// <p>The upfront cost of your reservation. It's amortized over the reservation period.</p>
    pub fn amortized_upfront_fee(&self) -> std::option::Option<&str> {
        self.amortized_upfront_fee.as_deref()
    }
    /// <p>The monthly cost of your reservation. It's amortized over the reservation period.</p>
    pub fn amortized_recurring_fee(&self) -> std::option::Option<&str> {
        self.amortized_recurring_fee.as_deref()
    }
    /// <p>The total cost of your reservation. It's amortized over the reservation period.</p>
    pub fn total_amortized_fee(&self) -> std::option::Option<&str> {
        self.total_amortized_fee.as_deref()
    }
    /// <p>The cost of unused hours for your reservation.</p>
    pub fn ri_cost_for_unused_hours(&self) -> std::option::Option<&str> {
        self.ri_cost_for_unused_hours.as_deref()
    }
    /// <p>The realized savings because of purchasing and using a reservation.</p>
    pub fn realized_savings(&self) -> std::option::Option<&str> {
        self.realized_savings.as_deref()
    }
    /// <p>The unrealized savings because of purchasing and using a reservation.</p>
    pub fn unrealized_savings(&self) -> std::option::Option<&str> {
        self.unrealized_savings.as_deref()
    }
}
impl std::fmt::Debug for ReservationAggregates {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationAggregates");
        formatter.field("utilization_percentage", &self.utilization_percentage);
        formatter.field(
            "utilization_percentage_in_units",
            &self.utilization_percentage_in_units,
        );
        formatter.field("purchased_hours", &self.purchased_hours);
        formatter.field("purchased_units", &self.purchased_units);
        formatter.field("total_actual_hours", &self.total_actual_hours);
        formatter.field("total_actual_units", &self.total_actual_units);
        formatter.field("unused_hours", &self.unused_hours);
        formatter.field("unused_units", &self.unused_units);
        formatter.field(
            "on_demand_cost_of_ri_hours_used",
            &self.on_demand_cost_of_ri_hours_used,
        );
        formatter.field("net_ri_savings", &self.net_ri_savings);
        formatter.field(
            "total_potential_ri_savings",
            &self.total_potential_ri_savings,
        );
        formatter.field("amortized_upfront_fee", &self.amortized_upfront_fee);
        formatter.field("amortized_recurring_fee", &self.amortized_recurring_fee);
        formatter.field("total_amortized_fee", &self.total_amortized_fee);
        formatter.field("ri_cost_for_unused_hours", &self.ri_cost_for_unused_hours);
        formatter.field("realized_savings", &self.realized_savings);
        formatter.field("unrealized_savings", &self.unrealized_savings);
        formatter.finish()
    }
}
/// See [`ReservationAggregates`](crate::model::ReservationAggregates)
pub mod reservation_aggregates {
    /// A builder for [`ReservationAggregates`](crate::model::ReservationAggregates)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) utilization_percentage: std::option::Option<std::string::String>,
        pub(crate) utilization_percentage_in_units: std::option::Option<std::string::String>,
        pub(crate) purchased_hours: std::option::Option<std::string::String>,
        pub(crate) purchased_units: std::option::Option<std::string::String>,
        pub(crate) total_actual_hours: std::option::Option<std::string::String>,
        pub(crate) total_actual_units: std::option::Option<std::string::String>,
        pub(crate) unused_hours: std::option::Option<std::string::String>,
        pub(crate) unused_units: std::option::Option<std::string::String>,
        pub(crate) on_demand_cost_of_ri_hours_used: std::option::Option<std::string::String>,
        pub(crate) net_ri_savings: std::option::Option<std::string::String>,
        pub(crate) total_potential_ri_savings: std::option::Option<std::string::String>,
        pub(crate) amortized_upfront_fee: std::option::Option<std::string::String>,
        pub(crate) amortized_recurring_fee: std::option::Option<std::string::String>,
        pub(crate) total_amortized_fee: std::option::Option<std::string::String>,
        pub(crate) ri_cost_for_unused_hours: std::option::Option<std::string::String>,
        pub(crate) realized_savings: std::option::Option<std::string::String>,
        pub(crate) unrealized_savings: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The percentage of reservation time that you used.</p>
        pub fn utilization_percentage(mut self, input: impl Into<std::string::String>) -> Self {
            self.utilization_percentage = Some(input.into());
            self
        }
        /// <p>The percentage of reservation time that you used.</p>
        pub fn set_utilization_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.utilization_percentage = input;
            self
        }
        /// <p>The percentage of Amazon EC2 reservation time that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn utilization_percentage_in_units(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.utilization_percentage_in_units = Some(input.into());
            self
        }
        /// <p>The percentage of Amazon EC2 reservation time that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn set_utilization_percentage_in_units(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.utilization_percentage_in_units = input;
            self
        }
        /// <p>How many reservation hours that you purchased.</p>
        pub fn purchased_hours(mut self, input: impl Into<std::string::String>) -> Self {
            self.purchased_hours = Some(input.into());
            self
        }
        /// <p>How many reservation hours that you purchased.</p>
        pub fn set_purchased_hours(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.purchased_hours = input;
            self
        }
        /// <p>The number of Amazon EC2 reservation hours that you purchased. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn purchased_units(mut self, input: impl Into<std::string::String>) -> Self {
            self.purchased_units = Some(input.into());
            self
        }
        /// <p>The number of Amazon EC2 reservation hours that you purchased. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn set_purchased_units(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.purchased_units = input;
            self
        }
        /// <p>The total number of reservation hours that you used.</p>
        pub fn total_actual_hours(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_actual_hours = Some(input.into());
            self
        }
        /// <p>The total number of reservation hours that you used.</p>
        pub fn set_total_actual_hours(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_actual_hours = input;
            self
        }
        /// <p>The total number of Amazon EC2 reservation hours that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn total_actual_units(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_actual_units = Some(input.into());
            self
        }
        /// <p>The total number of Amazon EC2 reservation hours that you used. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn set_total_actual_units(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_actual_units = input;
            self
        }
        /// <p>The number of reservation hours that you didn't use.</p>
        pub fn unused_hours(mut self, input: impl Into<std::string::String>) -> Self {
            self.unused_hours = Some(input.into());
            self
        }
        /// <p>The number of reservation hours that you didn't use.</p>
        pub fn set_unused_hours(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unused_hours = input;
            self
        }
        /// <p>The number of Amazon EC2 reservation hours that you didn't use. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn unused_units(mut self, input: impl Into<std::string::String>) -> Self {
            self.unused_units = Some(input.into());
            self
        }
        /// <p>The number of Amazon EC2 reservation hours that you didn't use. It's converted to normalized units. Normalized units are available only for Amazon EC2 usage after November 11, 2017.</p>
        pub fn set_unused_units(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.unused_units = input;
            self
        }
        /// <p>How much your reservation costs if charged On-Demand rates.</p>
        pub fn on_demand_cost_of_ri_hours_used(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.on_demand_cost_of_ri_hours_used = Some(input.into());
            self
        }
        /// <p>How much your reservation costs if charged On-Demand rates.</p>
        pub fn set_on_demand_cost_of_ri_hours_used(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_cost_of_ri_hours_used = input;
            self
        }
        /// <p>How much you saved due to purchasing and utilizing reservation. Amazon Web Services calculates this by subtracting <code>TotalAmortizedFee</code> from <code>OnDemandCostOfRIHoursUsed</code>.</p>
        pub fn net_ri_savings(mut self, input: impl Into<std::string::String>) -> Self {
            self.net_ri_savings = Some(input.into());
            self
        }
        /// <p>How much you saved due to purchasing and utilizing reservation. Amazon Web Services calculates this by subtracting <code>TotalAmortizedFee</code> from <code>OnDemandCostOfRIHoursUsed</code>.</p>
        pub fn set_net_ri_savings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.net_ri_savings = input;
            self
        }
        /// <p>How much you might save if you use your entire reservation.</p>
        pub fn total_potential_ri_savings(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_potential_ri_savings = Some(input.into());
            self
        }
        /// <p>How much you might save if you use your entire reservation.</p>
        pub fn set_total_potential_ri_savings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_potential_ri_savings = input;
            self
        }
        /// <p>The upfront cost of your reservation. It's amortized over the reservation period.</p>
        pub fn amortized_upfront_fee(mut self, input: impl Into<std::string::String>) -> Self {
            self.amortized_upfront_fee = Some(input.into());
            self
        }
        /// <p>The upfront cost of your reservation. It's amortized over the reservation period.</p>
        pub fn set_amortized_upfront_fee(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amortized_upfront_fee = input;
            self
        }
        /// <p>The monthly cost of your reservation. It's amortized over the reservation period.</p>
        pub fn amortized_recurring_fee(mut self, input: impl Into<std::string::String>) -> Self {
            self.amortized_recurring_fee = Some(input.into());
            self
        }
        /// <p>The monthly cost of your reservation. It's amortized over the reservation period.</p>
        pub fn set_amortized_recurring_fee(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.amortized_recurring_fee = input;
            self
        }
        /// <p>The total cost of your reservation. It's amortized over the reservation period.</p>
        pub fn total_amortized_fee(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_amortized_fee = Some(input.into());
            self
        }
        /// <p>The total cost of your reservation. It's amortized over the reservation period.</p>
        pub fn set_total_amortized_fee(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_amortized_fee = input;
            self
        }
        /// <p>The cost of unused hours for your reservation.</p>
        pub fn ri_cost_for_unused_hours(mut self, input: impl Into<std::string::String>) -> Self {
            self.ri_cost_for_unused_hours = Some(input.into());
            self
        }
        /// <p>The cost of unused hours for your reservation.</p>
        pub fn set_ri_cost_for_unused_hours(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ri_cost_for_unused_hours = input;
            self
        }
        /// <p>The realized savings because of purchasing and using a reservation.</p>
        pub fn realized_savings(mut self, input: impl Into<std::string::String>) -> Self {
            self.realized_savings = Some(input.into());
            self
        }
        /// <p>The realized savings because of purchasing and using a reservation.</p>
        pub fn set_realized_savings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.realized_savings = input;
            self
        }
        /// <p>The unrealized savings because of purchasing and using a reservation.</p>
        pub fn unrealized_savings(mut self, input: impl Into<std::string::String>) -> Self {
            self.unrealized_savings = Some(input.into());
            self
        }
        /// <p>The unrealized savings because of purchasing and using a reservation.</p>
        pub fn set_unrealized_savings(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.unrealized_savings = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationAggregates`](crate::model::ReservationAggregates)
        pub fn build(self) -> crate::model::ReservationAggregates {
            crate::model::ReservationAggregates {
                utilization_percentage: self.utilization_percentage,
                utilization_percentage_in_units: self.utilization_percentage_in_units,
                purchased_hours: self.purchased_hours,
                purchased_units: self.purchased_units,
                total_actual_hours: self.total_actual_hours,
                total_actual_units: self.total_actual_units,
                unused_hours: self.unused_hours,
                unused_units: self.unused_units,
                on_demand_cost_of_ri_hours_used: self.on_demand_cost_of_ri_hours_used,
                net_ri_savings: self.net_ri_savings,
                total_potential_ri_savings: self.total_potential_ri_savings,
                amortized_upfront_fee: self.amortized_upfront_fee,
                amortized_recurring_fee: self.amortized_recurring_fee,
                total_amortized_fee: self.total_amortized_fee,
                ri_cost_for_unused_hours: self.ri_cost_for_unused_hours,
                realized_savings: self.realized_savings,
                unrealized_savings: self.unrealized_savings,
            }
        }
    }
}
impl ReservationAggregates {
    /// Creates a new builder-style object to manufacture [`ReservationAggregates`](crate::model::ReservationAggregates)
    pub fn builder() -> crate::model::reservation_aggregates::Builder {
        crate::model::reservation_aggregates::Builder::default()
    }
}

/// <p>The amount of utilization, in hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UtilizationByTime {
    /// <p>The period of time that this utilization was used for.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The groups that this utilization result uses.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::ReservationUtilizationGroup>>,
    /// <p>The total number of reservation hours that were used.</p>
    pub total: std::option::Option<crate::model::ReservationAggregates>,
}
impl UtilizationByTime {
    /// <p>The period of time that this utilization was used for.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The groups that this utilization result uses.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::ReservationUtilizationGroup]> {
        self.groups.as_deref()
    }
    /// <p>The total number of reservation hours that were used.</p>
    pub fn total(&self) -> std::option::Option<&crate::model::ReservationAggregates> {
        self.total.as_ref()
    }
}
impl std::fmt::Debug for UtilizationByTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UtilizationByTime");
        formatter.field("time_period", &self.time_period);
        formatter.field("groups", &self.groups);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`UtilizationByTime`](crate::model::UtilizationByTime)
pub mod utilization_by_time {
    /// A builder for [`UtilizationByTime`](crate::model::UtilizationByTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) groups:
            std::option::Option<std::vec::Vec<crate::model::ReservationUtilizationGroup>>,
        pub(crate) total: std::option::Option<crate::model::ReservationAggregates>,
    }
    impl Builder {
        /// <p>The period of time that this utilization was used for.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The period of time that this utilization was used for.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The groups that this utilization result uses.</p>
        pub fn groups(mut self, input: crate::model::ReservationUtilizationGroup) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>The groups that this utilization result uses.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservationUtilizationGroup>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The total number of reservation hours that were used.</p>
        pub fn total(mut self, input: crate::model::ReservationAggregates) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total number of reservation hours that were used.</p>
        pub fn set_total(
            mut self,
            input: std::option::Option<crate::model::ReservationAggregates>,
        ) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`UtilizationByTime`](crate::model::UtilizationByTime)
        pub fn build(self) -> crate::model::UtilizationByTime {
            crate::model::UtilizationByTime {
                time_period: self.time_period,
                groups: self.groups,
                total: self.total,
            }
        }
    }
}
impl UtilizationByTime {
    /// Creates a new builder-style object to manufacture [`UtilizationByTime`](crate::model::UtilizationByTime)
    pub fn builder() -> crate::model::utilization_by_time::Builder {
        crate::model::utilization_by_time::Builder::default()
    }
}

/// <p>A group of reservations that share a set of attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationUtilizationGroup {
    /// <p>The key for a specific reservation attribute.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value of a specific reservation attribute.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The attributes for this group of reservations.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>How much you used this group of reservations.</p>
    pub utilization: std::option::Option<crate::model::ReservationAggregates>,
}
impl ReservationUtilizationGroup {
    /// <p>The key for a specific reservation attribute.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value of a specific reservation attribute.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The attributes for this group of reservations.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>How much you used this group of reservations.</p>
    pub fn utilization(&self) -> std::option::Option<&crate::model::ReservationAggregates> {
        self.utilization.as_ref()
    }
}
impl std::fmt::Debug for ReservationUtilizationGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationUtilizationGroup");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.field("attributes", &self.attributes);
        formatter.field("utilization", &self.utilization);
        formatter.finish()
    }
}
/// See [`ReservationUtilizationGroup`](crate::model::ReservationUtilizationGroup)
pub mod reservation_utilization_group {
    /// A builder for [`ReservationUtilizationGroup`](crate::model::ReservationUtilizationGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) utilization: std::option::Option<crate::model::ReservationAggregates>,
    }
    impl Builder {
        /// <p>The key for a specific reservation attribute.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key for a specific reservation attribute.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value of a specific reservation attribute.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a specific reservation attribute.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes for this group of reservations.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The attributes for this group of reservations.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>How much you used this group of reservations.</p>
        pub fn utilization(mut self, input: crate::model::ReservationAggregates) -> Self {
            self.utilization = Some(input);
            self
        }
        /// <p>How much you used this group of reservations.</p>
        pub fn set_utilization(
            mut self,
            input: std::option::Option<crate::model::ReservationAggregates>,
        ) -> Self {
            self.utilization = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationUtilizationGroup`](crate::model::ReservationUtilizationGroup)
        pub fn build(self) -> crate::model::ReservationUtilizationGroup {
            crate::model::ReservationUtilizationGroup {
                key: self.key,
                value: self.value,
                attributes: self.attributes,
                utilization: self.utilization,
            }
        }
    }
}
impl ReservationUtilizationGroup {
    /// Creates a new builder-style object to manufacture [`ReservationUtilizationGroup`](crate::model::ReservationUtilizationGroup)
    pub fn builder() -> crate::model::reservation_utilization_group::Builder {
        crate::model::reservation_utilization_group::Builder::default()
    }
}

/// <p>A specific reservation that Amazon Web Services recommends for purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationPurchaseRecommendation {
    /// <p>The account scope that Amazon Web Services recommends that you purchase this instance for. For example, you can purchase this reservation for an entire organization in Amazon Web Services Organizations.</p>
    pub account_scope: std::option::Option<crate::model::AccountScope>,
    /// <p>How many days of previous usage that Amazon Web Services considers when making this recommendation.</p>
    pub lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
    /// <p>The term of the reservation that you want recommendations for, in years.</p>
    pub term_in_years: std::option::Option<crate::model::TermInYears>,
    /// <p>The payment option for the reservation (for example, <code>AllUpfront</code> or <code>NoUpfront</code>).</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>Hardware specifications for the service that you want recommendations for.</p>
    pub service_specification: std::option::Option<crate::model::ServiceSpecification>,
    /// <p>Details about the recommended purchases.</p>
    pub recommendation_details:
        std::option::Option<std::vec::Vec<crate::model::ReservationPurchaseRecommendationDetail>>,
    /// <p>A summary about the recommended purchase.</p>
    pub recommendation_summary:
        std::option::Option<crate::model::ReservationPurchaseRecommendationSummary>,
}
impl ReservationPurchaseRecommendation {
    /// <p>The account scope that Amazon Web Services recommends that you purchase this instance for. For example, you can purchase this reservation for an entire organization in Amazon Web Services Organizations.</p>
    pub fn account_scope(&self) -> std::option::Option<&crate::model::AccountScope> {
        self.account_scope.as_ref()
    }
    /// <p>How many days of previous usage that Amazon Web Services considers when making this recommendation.</p>
    pub fn lookback_period_in_days(
        &self,
    ) -> std::option::Option<&crate::model::LookbackPeriodInDays> {
        self.lookback_period_in_days.as_ref()
    }
    /// <p>The term of the reservation that you want recommendations for, in years.</p>
    pub fn term_in_years(&self) -> std::option::Option<&crate::model::TermInYears> {
        self.term_in_years.as_ref()
    }
    /// <p>The payment option for the reservation (for example, <code>AllUpfront</code> or <code>NoUpfront</code>).</p>
    pub fn payment_option(&self) -> std::option::Option<&crate::model::PaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>Hardware specifications for the service that you want recommendations for.</p>
    pub fn service_specification(
        &self,
    ) -> std::option::Option<&crate::model::ServiceSpecification> {
        self.service_specification.as_ref()
    }
    /// <p>Details about the recommended purchases.</p>
    pub fn recommendation_details(
        &self,
    ) -> std::option::Option<&[crate::model::ReservationPurchaseRecommendationDetail]> {
        self.recommendation_details.as_deref()
    }
    /// <p>A summary about the recommended purchase.</p>
    pub fn recommendation_summary(
        &self,
    ) -> std::option::Option<&crate::model::ReservationPurchaseRecommendationSummary> {
        self.recommendation_summary.as_ref()
    }
}
impl std::fmt::Debug for ReservationPurchaseRecommendation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationPurchaseRecommendation");
        formatter.field("account_scope", &self.account_scope);
        formatter.field("lookback_period_in_days", &self.lookback_period_in_days);
        formatter.field("term_in_years", &self.term_in_years);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("service_specification", &self.service_specification);
        formatter.field("recommendation_details", &self.recommendation_details);
        formatter.field("recommendation_summary", &self.recommendation_summary);
        formatter.finish()
    }
}
/// See [`ReservationPurchaseRecommendation`](crate::model::ReservationPurchaseRecommendation)
pub mod reservation_purchase_recommendation {
    /// A builder for [`ReservationPurchaseRecommendation`](crate::model::ReservationPurchaseRecommendation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_scope: std::option::Option<crate::model::AccountScope>,
        pub(crate) lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
        pub(crate) term_in_years: std::option::Option<crate::model::TermInYears>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) service_specification: std::option::Option<crate::model::ServiceSpecification>,
        pub(crate) recommendation_details: std::option::Option<
            std::vec::Vec<crate::model::ReservationPurchaseRecommendationDetail>,
        >,
        pub(crate) recommendation_summary:
            std::option::Option<crate::model::ReservationPurchaseRecommendationSummary>,
    }
    impl Builder {
        /// <p>The account scope that Amazon Web Services recommends that you purchase this instance for. For example, you can purchase this reservation for an entire organization in Amazon Web Services Organizations.</p>
        pub fn account_scope(mut self, input: crate::model::AccountScope) -> Self {
            self.account_scope = Some(input);
            self
        }
        /// <p>The account scope that Amazon Web Services recommends that you purchase this instance for. For example, you can purchase this reservation for an entire organization in Amazon Web Services Organizations.</p>
        pub fn set_account_scope(
            mut self,
            input: std::option::Option<crate::model::AccountScope>,
        ) -> Self {
            self.account_scope = input;
            self
        }
        /// <p>How many days of previous usage that Amazon Web Services considers when making this recommendation.</p>
        pub fn lookback_period_in_days(
            mut self,
            input: crate::model::LookbackPeriodInDays,
        ) -> Self {
            self.lookback_period_in_days = Some(input);
            self
        }
        /// <p>How many days of previous usage that Amazon Web Services considers when making this recommendation.</p>
        pub fn set_lookback_period_in_days(
            mut self,
            input: std::option::Option<crate::model::LookbackPeriodInDays>,
        ) -> Self {
            self.lookback_period_in_days = input;
            self
        }
        /// <p>The term of the reservation that you want recommendations for, in years.</p>
        pub fn term_in_years(mut self, input: crate::model::TermInYears) -> Self {
            self.term_in_years = Some(input);
            self
        }
        /// <p>The term of the reservation that you want recommendations for, in years.</p>
        pub fn set_term_in_years(
            mut self,
            input: std::option::Option<crate::model::TermInYears>,
        ) -> Self {
            self.term_in_years = input;
            self
        }
        /// <p>The payment option for the reservation (for example, <code>AllUpfront</code> or <code>NoUpfront</code>).</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option for the reservation (for example, <code>AllUpfront</code> or <code>NoUpfront</code>).</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>Hardware specifications for the service that you want recommendations for.</p>
        pub fn service_specification(mut self, input: crate::model::ServiceSpecification) -> Self {
            self.service_specification = Some(input);
            self
        }
        /// <p>Hardware specifications for the service that you want recommendations for.</p>
        pub fn set_service_specification(
            mut self,
            input: std::option::Option<crate::model::ServiceSpecification>,
        ) -> Self {
            self.service_specification = input;
            self
        }
        /// Appends an item to `recommendation_details`.
        ///
        /// To override the contents of this collection use [`set_recommendation_details`](Self::set_recommendation_details).
        ///
        /// <p>Details about the recommended purchases.</p>
        pub fn recommendation_details(
            mut self,
            input: crate::model::ReservationPurchaseRecommendationDetail,
        ) -> Self {
            let mut v = self.recommendation_details.unwrap_or_default();
            v.push(input);
            self.recommendation_details = Some(v);
            self
        }
        /// <p>Details about the recommended purchases.</p>
        pub fn set_recommendation_details(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReservationPurchaseRecommendationDetail>,
            >,
        ) -> Self {
            self.recommendation_details = input;
            self
        }
        /// <p>A summary about the recommended purchase.</p>
        pub fn recommendation_summary(
            mut self,
            input: crate::model::ReservationPurchaseRecommendationSummary,
        ) -> Self {
            self.recommendation_summary = Some(input);
            self
        }
        /// <p>A summary about the recommended purchase.</p>
        pub fn set_recommendation_summary(
            mut self,
            input: std::option::Option<crate::model::ReservationPurchaseRecommendationSummary>,
        ) -> Self {
            self.recommendation_summary = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationPurchaseRecommendation`](crate::model::ReservationPurchaseRecommendation)
        pub fn build(self) -> crate::model::ReservationPurchaseRecommendation {
            crate::model::ReservationPurchaseRecommendation {
                account_scope: self.account_scope,
                lookback_period_in_days: self.lookback_period_in_days,
                term_in_years: self.term_in_years,
                payment_option: self.payment_option,
                service_specification: self.service_specification,
                recommendation_details: self.recommendation_details,
                recommendation_summary: self.recommendation_summary,
            }
        }
    }
}
impl ReservationPurchaseRecommendation {
    /// Creates a new builder-style object to manufacture [`ReservationPurchaseRecommendation`](crate::model::ReservationPurchaseRecommendation)
    pub fn builder() -> crate::model::reservation_purchase_recommendation::Builder {
        crate::model::reservation_purchase_recommendation::Builder::default()
    }
}

/// <p>A summary about this recommendation, such as the currency code, the amount that Amazon Web Services estimates that you could save, and the total amount of reservation to purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationPurchaseRecommendationSummary {
    /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month.</p>
    pub total_estimated_monthly_savings_amount: std::option::Option<std::string::String>,
    /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month, as a percentage of your costs.</p>
    pub total_estimated_monthly_savings_percentage: std::option::Option<std::string::String>,
    /// <p>The currency code used for this recommendation.</p>
    pub currency_code: std::option::Option<std::string::String>,
}
impl ReservationPurchaseRecommendationSummary {
    /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month.</p>
    pub fn total_estimated_monthly_savings_amount(&self) -> std::option::Option<&str> {
        self.total_estimated_monthly_savings_amount.as_deref()
    }
    /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month, as a percentage of your costs.</p>
    pub fn total_estimated_monthly_savings_percentage(&self) -> std::option::Option<&str> {
        self.total_estimated_monthly_savings_percentage.as_deref()
    }
    /// <p>The currency code used for this recommendation.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
}
impl std::fmt::Debug for ReservationPurchaseRecommendationSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationPurchaseRecommendationSummary");
        formatter.field(
            "total_estimated_monthly_savings_amount",
            &self.total_estimated_monthly_savings_amount,
        );
        formatter.field(
            "total_estimated_monthly_savings_percentage",
            &self.total_estimated_monthly_savings_percentage,
        );
        formatter.field("currency_code", &self.currency_code);
        formatter.finish()
    }
}
/// See [`ReservationPurchaseRecommendationSummary`](crate::model::ReservationPurchaseRecommendationSummary)
pub mod reservation_purchase_recommendation_summary {
    /// A builder for [`ReservationPurchaseRecommendationSummary`](crate::model::ReservationPurchaseRecommendationSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_estimated_monthly_savings_amount: std::option::Option<std::string::String>,
        pub(crate) total_estimated_monthly_savings_percentage:
            std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month.</p>
        pub fn total_estimated_monthly_savings_amount(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.total_estimated_monthly_savings_amount = Some(input.into());
            self
        }
        /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month.</p>
        pub fn set_total_estimated_monthly_savings_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_estimated_monthly_savings_amount = input;
            self
        }
        /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month, as a percentage of your costs.</p>
        pub fn total_estimated_monthly_savings_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.total_estimated_monthly_savings_percentage = Some(input.into());
            self
        }
        /// <p>The total amount that Amazon Web Services estimates that this recommendation could save you in a month, as a percentage of your costs.</p>
        pub fn set_total_estimated_monthly_savings_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_estimated_monthly_savings_percentage = input;
            self
        }
        /// <p>The currency code used for this recommendation.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code used for this recommendation.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationPurchaseRecommendationSummary`](crate::model::ReservationPurchaseRecommendationSummary)
        pub fn build(self) -> crate::model::ReservationPurchaseRecommendationSummary {
            crate::model::ReservationPurchaseRecommendationSummary {
                total_estimated_monthly_savings_amount: self.total_estimated_monthly_savings_amount,
                total_estimated_monthly_savings_percentage: self
                    .total_estimated_monthly_savings_percentage,
                currency_code: self.currency_code,
            }
        }
    }
}
impl ReservationPurchaseRecommendationSummary {
    /// Creates a new builder-style object to manufacture [`ReservationPurchaseRecommendationSummary`](crate::model::ReservationPurchaseRecommendationSummary)
    pub fn builder() -> crate::model::reservation_purchase_recommendation_summary::Builder {
        crate::model::reservation_purchase_recommendation_summary::Builder::default()
    }
}

/// <p>Details about your recommended reservation purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationPurchaseRecommendationDetail {
    /// <p>The account that this RI recommendation is for.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Details about the instances that Amazon Web Services recommends that you purchase.</p>
    pub instance_details: std::option::Option<crate::model::InstanceDetails>,
    /// <p>The number of instances that Amazon Web Services recommends that you purchase.</p>
    pub recommended_number_of_instances_to_purchase: std::option::Option<std::string::String>,
    /// <p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>
    pub recommended_normalized_units_to_purchase: std::option::Option<std::string::String>,
    /// <p>The minimum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub minimum_number_of_instances_used_per_hour: std::option::Option<std::string::String>,
    /// <p>The minimum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub minimum_normalized_units_used_per_hour: std::option::Option<std::string::String>,
    /// <p>The maximum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub maximum_number_of_instances_used_per_hour: std::option::Option<std::string::String>,
    /// <p>The maximum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub maximum_normalized_units_used_per_hour: std::option::Option<std::string::String>,
    /// <p>The average number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub average_number_of_instances_used_per_hour: std::option::Option<std::string::String>,
    /// <p>The average number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub average_normalized_units_used_per_hour: std::option::Option<std::string::String>,
    /// <p>The average utilization of your instances. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub average_utilization: std::option::Option<std::string::String>,
    /// <p>How long Amazon Web Services estimates that it takes for this instance to start saving you money, in months.</p>
    pub estimated_break_even_in_months: std::option::Option<std::string::String>,
    /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month.</p>
    pub estimated_monthly_savings_amount: std::option::Option<std::string::String>,
    /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month, as a percentage of your overall costs.</p>
    pub estimated_monthly_savings_percentage: std::option::Option<std::string::String>,
    /// <p>How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.</p>
    pub estimated_monthly_on_demand_cost: std::option::Option<std::string::String>,
    /// <p>How much Amazon Web Services estimates that you would have spent for all usage during the specified historical period if you had a reservation.</p>
    pub estimated_reservation_cost_for_lookback_period: std::option::Option<std::string::String>,
    /// <p>How much purchasing this instance costs you upfront.</p>
    pub upfront_cost: std::option::Option<std::string::String>,
    /// <p>How much purchasing this instance costs you on a monthly basis.</p>
    pub recurring_standard_monthly_cost: std::option::Option<std::string::String>,
}
impl ReservationPurchaseRecommendationDetail {
    /// <p>The account that this RI recommendation is for.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Details about the instances that Amazon Web Services recommends that you purchase.</p>
    pub fn instance_details(&self) -> std::option::Option<&crate::model::InstanceDetails> {
        self.instance_details.as_ref()
    }
    /// <p>The number of instances that Amazon Web Services recommends that you purchase.</p>
    pub fn recommended_number_of_instances_to_purchase(&self) -> std::option::Option<&str> {
        self.recommended_number_of_instances_to_purchase.as_deref()
    }
    /// <p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>
    pub fn recommended_normalized_units_to_purchase(&self) -> std::option::Option<&str> {
        self.recommended_normalized_units_to_purchase.as_deref()
    }
    /// <p>The minimum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub fn minimum_number_of_instances_used_per_hour(&self) -> std::option::Option<&str> {
        self.minimum_number_of_instances_used_per_hour.as_deref()
    }
    /// <p>The minimum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub fn minimum_normalized_units_used_per_hour(&self) -> std::option::Option<&str> {
        self.minimum_normalized_units_used_per_hour.as_deref()
    }
    /// <p>The maximum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub fn maximum_number_of_instances_used_per_hour(&self) -> std::option::Option<&str> {
        self.maximum_number_of_instances_used_per_hour.as_deref()
    }
    /// <p>The maximum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub fn maximum_normalized_units_used_per_hour(&self) -> std::option::Option<&str> {
        self.maximum_normalized_units_used_per_hour.as_deref()
    }
    /// <p>The average number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub fn average_number_of_instances_used_per_hour(&self) -> std::option::Option<&str> {
        self.average_number_of_instances_used_per_hour.as_deref()
    }
    /// <p>The average number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub fn average_normalized_units_used_per_hour(&self) -> std::option::Option<&str> {
        self.average_normalized_units_used_per_hour.as_deref()
    }
    /// <p>The average utilization of your instances. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
    pub fn average_utilization(&self) -> std::option::Option<&str> {
        self.average_utilization.as_deref()
    }
    /// <p>How long Amazon Web Services estimates that it takes for this instance to start saving you money, in months.</p>
    pub fn estimated_break_even_in_months(&self) -> std::option::Option<&str> {
        self.estimated_break_even_in_months.as_deref()
    }
    /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month.</p>
    pub fn estimated_monthly_savings_amount(&self) -> std::option::Option<&str> {
        self.estimated_monthly_savings_amount.as_deref()
    }
    /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month, as a percentage of your overall costs.</p>
    pub fn estimated_monthly_savings_percentage(&self) -> std::option::Option<&str> {
        self.estimated_monthly_savings_percentage.as_deref()
    }
    /// <p>How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.</p>
    pub fn estimated_monthly_on_demand_cost(&self) -> std::option::Option<&str> {
        self.estimated_monthly_on_demand_cost.as_deref()
    }
    /// <p>How much Amazon Web Services estimates that you would have spent for all usage during the specified historical period if you had a reservation.</p>
    pub fn estimated_reservation_cost_for_lookback_period(&self) -> std::option::Option<&str> {
        self.estimated_reservation_cost_for_lookback_period
            .as_deref()
    }
    /// <p>How much purchasing this instance costs you upfront.</p>
    pub fn upfront_cost(&self) -> std::option::Option<&str> {
        self.upfront_cost.as_deref()
    }
    /// <p>How much purchasing this instance costs you on a monthly basis.</p>
    pub fn recurring_standard_monthly_cost(&self) -> std::option::Option<&str> {
        self.recurring_standard_monthly_cost.as_deref()
    }
}
impl std::fmt::Debug for ReservationPurchaseRecommendationDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationPurchaseRecommendationDetail");
        formatter.field("account_id", &self.account_id);
        formatter.field("instance_details", &self.instance_details);
        formatter.field(
            "recommended_number_of_instances_to_purchase",
            &self.recommended_number_of_instances_to_purchase,
        );
        formatter.field(
            "recommended_normalized_units_to_purchase",
            &self.recommended_normalized_units_to_purchase,
        );
        formatter.field(
            "minimum_number_of_instances_used_per_hour",
            &self.minimum_number_of_instances_used_per_hour,
        );
        formatter.field(
            "minimum_normalized_units_used_per_hour",
            &self.minimum_normalized_units_used_per_hour,
        );
        formatter.field(
            "maximum_number_of_instances_used_per_hour",
            &self.maximum_number_of_instances_used_per_hour,
        );
        formatter.field(
            "maximum_normalized_units_used_per_hour",
            &self.maximum_normalized_units_used_per_hour,
        );
        formatter.field(
            "average_number_of_instances_used_per_hour",
            &self.average_number_of_instances_used_per_hour,
        );
        formatter.field(
            "average_normalized_units_used_per_hour",
            &self.average_normalized_units_used_per_hour,
        );
        formatter.field("average_utilization", &self.average_utilization);
        formatter.field(
            "estimated_break_even_in_months",
            &self.estimated_break_even_in_months,
        );
        formatter.field("currency_code", &self.currency_code);
        formatter.field(
            "estimated_monthly_savings_amount",
            &self.estimated_monthly_savings_amount,
        );
        formatter.field(
            "estimated_monthly_savings_percentage",
            &self.estimated_monthly_savings_percentage,
        );
        formatter.field(
            "estimated_monthly_on_demand_cost",
            &self.estimated_monthly_on_demand_cost,
        );
        formatter.field(
            "estimated_reservation_cost_for_lookback_period",
            &self.estimated_reservation_cost_for_lookback_period,
        );
        formatter.field("upfront_cost", &self.upfront_cost);
        formatter.field(
            "recurring_standard_monthly_cost",
            &self.recurring_standard_monthly_cost,
        );
        formatter.finish()
    }
}
/// See [`ReservationPurchaseRecommendationDetail`](crate::model::ReservationPurchaseRecommendationDetail)
pub mod reservation_purchase_recommendation_detail {
    /// A builder for [`ReservationPurchaseRecommendationDetail`](crate::model::ReservationPurchaseRecommendationDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) instance_details: std::option::Option<crate::model::InstanceDetails>,
        pub(crate) recommended_number_of_instances_to_purchase:
            std::option::Option<std::string::String>,
        pub(crate) recommended_normalized_units_to_purchase:
            std::option::Option<std::string::String>,
        pub(crate) minimum_number_of_instances_used_per_hour:
            std::option::Option<std::string::String>,
        pub(crate) minimum_normalized_units_used_per_hour: std::option::Option<std::string::String>,
        pub(crate) maximum_number_of_instances_used_per_hour:
            std::option::Option<std::string::String>,
        pub(crate) maximum_normalized_units_used_per_hour: std::option::Option<std::string::String>,
        pub(crate) average_number_of_instances_used_per_hour:
            std::option::Option<std::string::String>,
        pub(crate) average_normalized_units_used_per_hour: std::option::Option<std::string::String>,
        pub(crate) average_utilization: std::option::Option<std::string::String>,
        pub(crate) estimated_break_even_in_months: std::option::Option<std::string::String>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) estimated_monthly_savings_amount: std::option::Option<std::string::String>,
        pub(crate) estimated_monthly_savings_percentage: std::option::Option<std::string::String>,
        pub(crate) estimated_monthly_on_demand_cost: std::option::Option<std::string::String>,
        pub(crate) estimated_reservation_cost_for_lookback_period:
            std::option::Option<std::string::String>,
        pub(crate) upfront_cost: std::option::Option<std::string::String>,
        pub(crate) recurring_standard_monthly_cost: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account that this RI recommendation is for.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account that this RI recommendation is for.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Details about the instances that Amazon Web Services recommends that you purchase.</p>
        pub fn instance_details(mut self, input: crate::model::InstanceDetails) -> Self {
            self.instance_details = Some(input);
            self
        }
        /// <p>Details about the instances that Amazon Web Services recommends that you purchase.</p>
        pub fn set_instance_details(
            mut self,
            input: std::option::Option<crate::model::InstanceDetails>,
        ) -> Self {
            self.instance_details = input;
            self
        }
        /// <p>The number of instances that Amazon Web Services recommends that you purchase.</p>
        pub fn recommended_number_of_instances_to_purchase(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommended_number_of_instances_to_purchase = Some(input.into());
            self
        }
        /// <p>The number of instances that Amazon Web Services recommends that you purchase.</p>
        pub fn set_recommended_number_of_instances_to_purchase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_number_of_instances_to_purchase = input;
            self
        }
        /// <p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>
        pub fn recommended_normalized_units_to_purchase(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recommended_normalized_units_to_purchase = Some(input.into());
            self
        }
        /// <p>The number of normalized units that Amazon Web Services recommends that you purchase.</p>
        pub fn set_recommended_normalized_units_to_purchase(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommended_normalized_units_to_purchase = input;
            self
        }
        /// <p>The minimum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn minimum_number_of_instances_used_per_hour(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.minimum_number_of_instances_used_per_hour = Some(input.into());
            self
        }
        /// <p>The minimum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn set_minimum_number_of_instances_used_per_hour(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_number_of_instances_used_per_hour = input;
            self
        }
        /// <p>The minimum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn minimum_normalized_units_used_per_hour(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.minimum_normalized_units_used_per_hour = Some(input.into());
            self
        }
        /// <p>The minimum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn set_minimum_normalized_units_used_per_hour(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_normalized_units_used_per_hour = input;
            self
        }
        /// <p>The maximum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn maximum_number_of_instances_used_per_hour(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.maximum_number_of_instances_used_per_hour = Some(input.into());
            self
        }
        /// <p>The maximum number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn set_maximum_number_of_instances_used_per_hour(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maximum_number_of_instances_used_per_hour = input;
            self
        }
        /// <p>The maximum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn maximum_normalized_units_used_per_hour(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.maximum_normalized_units_used_per_hour = Some(input.into());
            self
        }
        /// <p>The maximum number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn set_maximum_normalized_units_used_per_hour(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maximum_normalized_units_used_per_hour = input;
            self
        }
        /// <p>The average number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn average_number_of_instances_used_per_hour(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.average_number_of_instances_used_per_hour = Some(input.into());
            self
        }
        /// <p>The average number of instances that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn set_average_number_of_instances_used_per_hour(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.average_number_of_instances_used_per_hour = input;
            self
        }
        /// <p>The average number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn average_normalized_units_used_per_hour(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.average_normalized_units_used_per_hour = Some(input.into());
            self
        }
        /// <p>The average number of normalized units that you used in an hour during the historical period. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn set_average_normalized_units_used_per_hour(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.average_normalized_units_used_per_hour = input;
            self
        }
        /// <p>The average utilization of your instances. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn average_utilization(mut self, input: impl Into<std::string::String>) -> Self {
            self.average_utilization = Some(input.into());
            self
        }
        /// <p>The average utilization of your instances. Amazon Web Services uses this to calculate your recommended reservation purchases.</p>
        pub fn set_average_utilization(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.average_utilization = input;
            self
        }
        /// <p>How long Amazon Web Services estimates that it takes for this instance to start saving you money, in months.</p>
        pub fn estimated_break_even_in_months(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_break_even_in_months = Some(input.into());
            self
        }
        /// <p>How long Amazon Web Services estimates that it takes for this instance to start saving you money, in months.</p>
        pub fn set_estimated_break_even_in_months(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_break_even_in_months = input;
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code that Amazon Web Services used to calculate the costs for this instance.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month.</p>
        pub fn estimated_monthly_savings_amount(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_amount = Some(input.into());
            self
        }
        /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month.</p>
        pub fn set_estimated_monthly_savings_amount(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_amount = input;
            self
        }
        /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month, as a percentage of your overall costs.</p>
        pub fn estimated_monthly_savings_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_percentage = Some(input.into());
            self
        }
        /// <p>How much Amazon Web Services estimates that this specific recommendation could save you in a month, as a percentage of your overall costs.</p>
        pub fn set_estimated_monthly_savings_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_savings_percentage = input;
            self
        }
        /// <p>How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.</p>
        pub fn estimated_monthly_on_demand_cost(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_monthly_on_demand_cost = Some(input.into());
            self
        }
        /// <p>How much Amazon Web Services estimates that you spend on On-Demand Instances in a month.</p>
        pub fn set_estimated_monthly_on_demand_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_monthly_on_demand_cost = input;
            self
        }
        /// <p>How much Amazon Web Services estimates that you would have spent for all usage during the specified historical period if you had a reservation.</p>
        pub fn estimated_reservation_cost_for_lookback_period(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.estimated_reservation_cost_for_lookback_period = Some(input.into());
            self
        }
        /// <p>How much Amazon Web Services estimates that you would have spent for all usage during the specified historical period if you had a reservation.</p>
        pub fn set_estimated_reservation_cost_for_lookback_period(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_reservation_cost_for_lookback_period = input;
            self
        }
        /// <p>How much purchasing this instance costs you upfront.</p>
        pub fn upfront_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.upfront_cost = Some(input.into());
            self
        }
        /// <p>How much purchasing this instance costs you upfront.</p>
        pub fn set_upfront_cost(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.upfront_cost = input;
            self
        }
        /// <p>How much purchasing this instance costs you on a monthly basis.</p>
        pub fn recurring_standard_monthly_cost(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.recurring_standard_monthly_cost = Some(input.into());
            self
        }
        /// <p>How much purchasing this instance costs you on a monthly basis.</p>
        pub fn set_recurring_standard_monthly_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recurring_standard_monthly_cost = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationPurchaseRecommendationDetail`](crate::model::ReservationPurchaseRecommendationDetail)
        pub fn build(self) -> crate::model::ReservationPurchaseRecommendationDetail {
            crate::model::ReservationPurchaseRecommendationDetail {
                account_id: self.account_id,
                instance_details: self.instance_details,
                recommended_number_of_instances_to_purchase: self
                    .recommended_number_of_instances_to_purchase,
                recommended_normalized_units_to_purchase: self
                    .recommended_normalized_units_to_purchase,
                minimum_number_of_instances_used_per_hour: self
                    .minimum_number_of_instances_used_per_hour,
                minimum_normalized_units_used_per_hour: self.minimum_normalized_units_used_per_hour,
                maximum_number_of_instances_used_per_hour: self
                    .maximum_number_of_instances_used_per_hour,
                maximum_normalized_units_used_per_hour: self.maximum_normalized_units_used_per_hour,
                average_number_of_instances_used_per_hour: self
                    .average_number_of_instances_used_per_hour,
                average_normalized_units_used_per_hour: self.average_normalized_units_used_per_hour,
                average_utilization: self.average_utilization,
                estimated_break_even_in_months: self.estimated_break_even_in_months,
                currency_code: self.currency_code,
                estimated_monthly_savings_amount: self.estimated_monthly_savings_amount,
                estimated_monthly_savings_percentage: self.estimated_monthly_savings_percentage,
                estimated_monthly_on_demand_cost: self.estimated_monthly_on_demand_cost,
                estimated_reservation_cost_for_lookback_period: self
                    .estimated_reservation_cost_for_lookback_period,
                upfront_cost: self.upfront_cost,
                recurring_standard_monthly_cost: self.recurring_standard_monthly_cost,
            }
        }
    }
}
impl ReservationPurchaseRecommendationDetail {
    /// Creates a new builder-style object to manufacture [`ReservationPurchaseRecommendationDetail`](crate::model::ReservationPurchaseRecommendationDetail)
    pub fn builder() -> crate::model::reservation_purchase_recommendation_detail::Builder {
        crate::model::reservation_purchase_recommendation_detail::Builder::default()
    }
}

/// <p>Details about the instances that Amazon Web Services recommends that you purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceDetails {
    /// <p>The Amazon EC2 instances that Amazon Web Services recommends that you purchase.</p>
    pub ec2_instance_details: std::option::Option<crate::model::Ec2InstanceDetails>,
    /// <p>The Amazon RDS instances that Amazon Web Services recommends that you purchase.</p>
    pub rds_instance_details: std::option::Option<crate::model::RdsInstanceDetails>,
    /// <p>The Amazon Redshift instances that Amazon Web Services recommends that you purchase.</p>
    pub redshift_instance_details: std::option::Option<crate::model::RedshiftInstanceDetails>,
    /// <p>The ElastiCache instances that Amazon Web Services recommends that you purchase.</p>
    pub elasti_cache_instance_details:
        std::option::Option<crate::model::ElastiCacheInstanceDetails>,
    /// <p>The Amazon OpenSearch Service instances that Amazon Web Services recommends that you purchase.</p>
    pub es_instance_details: std::option::Option<crate::model::EsInstanceDetails>,
}
impl InstanceDetails {
    /// <p>The Amazon EC2 instances that Amazon Web Services recommends that you purchase.</p>
    pub fn ec2_instance_details(&self) -> std::option::Option<&crate::model::Ec2InstanceDetails> {
        self.ec2_instance_details.as_ref()
    }
    /// <p>The Amazon RDS instances that Amazon Web Services recommends that you purchase.</p>
    pub fn rds_instance_details(&self) -> std::option::Option<&crate::model::RdsInstanceDetails> {
        self.rds_instance_details.as_ref()
    }
    /// <p>The Amazon Redshift instances that Amazon Web Services recommends that you purchase.</p>
    pub fn redshift_instance_details(
        &self,
    ) -> std::option::Option<&crate::model::RedshiftInstanceDetails> {
        self.redshift_instance_details.as_ref()
    }
    /// <p>The ElastiCache instances that Amazon Web Services recommends that you purchase.</p>
    pub fn elasti_cache_instance_details(
        &self,
    ) -> std::option::Option<&crate::model::ElastiCacheInstanceDetails> {
        self.elasti_cache_instance_details.as_ref()
    }
    /// <p>The Amazon OpenSearch Service instances that Amazon Web Services recommends that you purchase.</p>
    pub fn es_instance_details(&self) -> std::option::Option<&crate::model::EsInstanceDetails> {
        self.es_instance_details.as_ref()
    }
}
impl std::fmt::Debug for InstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceDetails");
        formatter.field("ec2_instance_details", &self.ec2_instance_details);
        formatter.field("rds_instance_details", &self.rds_instance_details);
        formatter.field("redshift_instance_details", &self.redshift_instance_details);
        formatter.field(
            "elasti_cache_instance_details",
            &self.elasti_cache_instance_details,
        );
        formatter.field("es_instance_details", &self.es_instance_details);
        formatter.finish()
    }
}
/// See [`InstanceDetails`](crate::model::InstanceDetails)
pub mod instance_details {
    /// A builder for [`InstanceDetails`](crate::model::InstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_instance_details: std::option::Option<crate::model::Ec2InstanceDetails>,
        pub(crate) rds_instance_details: std::option::Option<crate::model::RdsInstanceDetails>,
        pub(crate) redshift_instance_details:
            std::option::Option<crate::model::RedshiftInstanceDetails>,
        pub(crate) elasti_cache_instance_details:
            std::option::Option<crate::model::ElastiCacheInstanceDetails>,
        pub(crate) es_instance_details: std::option::Option<crate::model::EsInstanceDetails>,
    }
    impl Builder {
        /// <p>The Amazon EC2 instances that Amazon Web Services recommends that you purchase.</p>
        pub fn ec2_instance_details(mut self, input: crate::model::Ec2InstanceDetails) -> Self {
            self.ec2_instance_details = Some(input);
            self
        }
        /// <p>The Amazon EC2 instances that Amazon Web Services recommends that you purchase.</p>
        pub fn set_ec2_instance_details(
            mut self,
            input: std::option::Option<crate::model::Ec2InstanceDetails>,
        ) -> Self {
            self.ec2_instance_details = input;
            self
        }
        /// <p>The Amazon RDS instances that Amazon Web Services recommends that you purchase.</p>
        pub fn rds_instance_details(mut self, input: crate::model::RdsInstanceDetails) -> Self {
            self.rds_instance_details = Some(input);
            self
        }
        /// <p>The Amazon RDS instances that Amazon Web Services recommends that you purchase.</p>
        pub fn set_rds_instance_details(
            mut self,
            input: std::option::Option<crate::model::RdsInstanceDetails>,
        ) -> Self {
            self.rds_instance_details = input;
            self
        }
        /// <p>The Amazon Redshift instances that Amazon Web Services recommends that you purchase.</p>
        pub fn redshift_instance_details(
            mut self,
            input: crate::model::RedshiftInstanceDetails,
        ) -> Self {
            self.redshift_instance_details = Some(input);
            self
        }
        /// <p>The Amazon Redshift instances that Amazon Web Services recommends that you purchase.</p>
        pub fn set_redshift_instance_details(
            mut self,
            input: std::option::Option<crate::model::RedshiftInstanceDetails>,
        ) -> Self {
            self.redshift_instance_details = input;
            self
        }
        /// <p>The ElastiCache instances that Amazon Web Services recommends that you purchase.</p>
        pub fn elasti_cache_instance_details(
            mut self,
            input: crate::model::ElastiCacheInstanceDetails,
        ) -> Self {
            self.elasti_cache_instance_details = Some(input);
            self
        }
        /// <p>The ElastiCache instances that Amazon Web Services recommends that you purchase.</p>
        pub fn set_elasti_cache_instance_details(
            mut self,
            input: std::option::Option<crate::model::ElastiCacheInstanceDetails>,
        ) -> Self {
            self.elasti_cache_instance_details = input;
            self
        }
        /// <p>The Amazon OpenSearch Service instances that Amazon Web Services recommends that you purchase.</p>
        pub fn es_instance_details(mut self, input: crate::model::EsInstanceDetails) -> Self {
            self.es_instance_details = Some(input);
            self
        }
        /// <p>The Amazon OpenSearch Service instances that Amazon Web Services recommends that you purchase.</p>
        pub fn set_es_instance_details(
            mut self,
            input: std::option::Option<crate::model::EsInstanceDetails>,
        ) -> Self {
            self.es_instance_details = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceDetails`](crate::model::InstanceDetails)
        pub fn build(self) -> crate::model::InstanceDetails {
            crate::model::InstanceDetails {
                ec2_instance_details: self.ec2_instance_details,
                rds_instance_details: self.rds_instance_details,
                redshift_instance_details: self.redshift_instance_details,
                elasti_cache_instance_details: self.elasti_cache_instance_details,
                es_instance_details: self.es_instance_details,
            }
        }
    }
}
impl InstanceDetails {
    /// Creates a new builder-style object to manufacture [`InstanceDetails`](crate::model::InstanceDetails)
    pub fn builder() -> crate::model::instance_details::Builder {
        crate::model::instance_details::Builder::default()
    }
}

/// <p>Details about the Amazon OpenSearch Service instances that Amazon Web Services recommends that you purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EsInstanceDetails {
    /// <p>The class of instance that Amazon Web Services recommends.</p>
    pub instance_class: std::option::Option<std::string::String>,
    /// <p>The size of instance that Amazon Web Services recommends.</p>
    pub instance_size: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Determines whether the recommendation is for a current-generation instance.</p>
    pub current_generation: bool,
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub size_flex_eligible: bool,
}
impl EsInstanceDetails {
    /// <p>The class of instance that Amazon Web Services recommends.</p>
    pub fn instance_class(&self) -> std::option::Option<&str> {
        self.instance_class.as_deref()
    }
    /// <p>The size of instance that Amazon Web Services recommends.</p>
    pub fn instance_size(&self) -> std::option::Option<&str> {
        self.instance_size.as_deref()
    }
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>Determines whether the recommendation is for a current-generation instance.</p>
    pub fn current_generation(&self) -> bool {
        self.current_generation
    }
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub fn size_flex_eligible(&self) -> bool {
        self.size_flex_eligible
    }
}
impl std::fmt::Debug for EsInstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EsInstanceDetails");
        formatter.field("instance_class", &self.instance_class);
        formatter.field("instance_size", &self.instance_size);
        formatter.field("region", &self.region);
        formatter.field("current_generation", &self.current_generation);
        formatter.field("size_flex_eligible", &self.size_flex_eligible);
        formatter.finish()
    }
}
/// See [`EsInstanceDetails`](crate::model::EsInstanceDetails)
pub mod es_instance_details {
    /// A builder for [`EsInstanceDetails`](crate::model::EsInstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_class: std::option::Option<std::string::String>,
        pub(crate) instance_size: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) current_generation: std::option::Option<bool>,
        pub(crate) size_flex_eligible: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The class of instance that Amazon Web Services recommends.</p>
        pub fn instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_class = Some(input.into());
            self
        }
        /// <p>The class of instance that Amazon Web Services recommends.</p>
        pub fn set_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_class = input;
            self
        }
        /// <p>The size of instance that Amazon Web Services recommends.</p>
        pub fn instance_size(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_size = Some(input.into());
            self
        }
        /// <p>The size of instance that Amazon Web Services recommends.</p>
        pub fn set_instance_size(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_size = input;
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance.</p>
        pub fn current_generation(mut self, input: bool) -> Self {
            self.current_generation = Some(input);
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance.</p>
        pub fn set_current_generation(mut self, input: std::option::Option<bool>) -> Self {
            self.current_generation = input;
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn size_flex_eligible(mut self, input: bool) -> Self {
            self.size_flex_eligible = Some(input);
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn set_size_flex_eligible(mut self, input: std::option::Option<bool>) -> Self {
            self.size_flex_eligible = input;
            self
        }
        /// Consumes the builder and constructs a [`EsInstanceDetails`](crate::model::EsInstanceDetails)
        pub fn build(self) -> crate::model::EsInstanceDetails {
            crate::model::EsInstanceDetails {
                instance_class: self.instance_class,
                instance_size: self.instance_size,
                region: self.region,
                current_generation: self.current_generation.unwrap_or_default(),
                size_flex_eligible: self.size_flex_eligible.unwrap_or_default(),
            }
        }
    }
}
impl EsInstanceDetails {
    /// Creates a new builder-style object to manufacture [`EsInstanceDetails`](crate::model::EsInstanceDetails)
    pub fn builder() -> crate::model::es_instance_details::Builder {
        crate::model::es_instance_details::Builder::default()
    }
}

/// <p>Details about the Amazon ElastiCache instances that Amazon Web Services recommends that you purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElastiCacheInstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The type of node that Amazon Web Services recommends.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The description of the recommended reservation.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>Determines whether the recommendation is for a current generation instance.</p>
    pub current_generation: bool,
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub size_flex_eligible: bool,
}
impl ElastiCacheInstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub fn family(&self) -> std::option::Option<&str> {
        self.family.as_deref()
    }
    /// <p>The type of node that Amazon Web Services recommends.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The description of the recommended reservation.</p>
    pub fn product_description(&self) -> std::option::Option<&str> {
        self.product_description.as_deref()
    }
    /// <p>Determines whether the recommendation is for a current generation instance.</p>
    pub fn current_generation(&self) -> bool {
        self.current_generation
    }
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub fn size_flex_eligible(&self) -> bool {
        self.size_flex_eligible
    }
}
impl std::fmt::Debug for ElastiCacheInstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElastiCacheInstanceDetails");
        formatter.field("family", &self.family);
        formatter.field("node_type", &self.node_type);
        formatter.field("region", &self.region);
        formatter.field("product_description", &self.product_description);
        formatter.field("current_generation", &self.current_generation);
        formatter.field("size_flex_eligible", &self.size_flex_eligible);
        formatter.finish()
    }
}
/// See [`ElastiCacheInstanceDetails`](crate::model::ElastiCacheInstanceDetails)
pub mod elasti_cache_instance_details {
    /// A builder for [`ElastiCacheInstanceDetails`](crate::model::ElastiCacheInstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) current_generation: std::option::Option<bool>,
        pub(crate) size_flex_eligible: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance family of the recommended reservation.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The instance family of the recommended reservation.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The type of node that Amazon Web Services recommends.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The type of node that Amazon Web Services recommends.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The description of the recommended reservation.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The description of the recommended reservation.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>Determines whether the recommendation is for a current generation instance.</p>
        pub fn current_generation(mut self, input: bool) -> Self {
            self.current_generation = Some(input);
            self
        }
        /// <p>Determines whether the recommendation is for a current generation instance.</p>
        pub fn set_current_generation(mut self, input: std::option::Option<bool>) -> Self {
            self.current_generation = input;
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn size_flex_eligible(mut self, input: bool) -> Self {
            self.size_flex_eligible = Some(input);
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn set_size_flex_eligible(mut self, input: std::option::Option<bool>) -> Self {
            self.size_flex_eligible = input;
            self
        }
        /// Consumes the builder and constructs a [`ElastiCacheInstanceDetails`](crate::model::ElastiCacheInstanceDetails)
        pub fn build(self) -> crate::model::ElastiCacheInstanceDetails {
            crate::model::ElastiCacheInstanceDetails {
                family: self.family,
                node_type: self.node_type,
                region: self.region,
                product_description: self.product_description,
                current_generation: self.current_generation.unwrap_or_default(),
                size_flex_eligible: self.size_flex_eligible.unwrap_or_default(),
            }
        }
    }
}
impl ElastiCacheInstanceDetails {
    /// Creates a new builder-style object to manufacture [`ElastiCacheInstanceDetails`](crate::model::ElastiCacheInstanceDetails)
    pub fn builder() -> crate::model::elasti_cache_instance_details::Builder {
        crate::model::elasti_cache_instance_details::Builder::default()
    }
}

/// <p>Details about the Amazon Redshift instances that Amazon Web Services recommends that you purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RedshiftInstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The type of node that Amazon Web Services recommends.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Determines whether the recommendation is for a current-generation instance.</p>
    pub current_generation: bool,
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub size_flex_eligible: bool,
}
impl RedshiftInstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub fn family(&self) -> std::option::Option<&str> {
        self.family.as_deref()
    }
    /// <p>The type of node that Amazon Web Services recommends.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>Determines whether the recommendation is for a current-generation instance.</p>
    pub fn current_generation(&self) -> bool {
        self.current_generation
    }
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub fn size_flex_eligible(&self) -> bool {
        self.size_flex_eligible
    }
}
impl std::fmt::Debug for RedshiftInstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RedshiftInstanceDetails");
        formatter.field("family", &self.family);
        formatter.field("node_type", &self.node_type);
        formatter.field("region", &self.region);
        formatter.field("current_generation", &self.current_generation);
        formatter.field("size_flex_eligible", &self.size_flex_eligible);
        formatter.finish()
    }
}
/// See [`RedshiftInstanceDetails`](crate::model::RedshiftInstanceDetails)
pub mod redshift_instance_details {
    /// A builder for [`RedshiftInstanceDetails`](crate::model::RedshiftInstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) current_generation: std::option::Option<bool>,
        pub(crate) size_flex_eligible: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance family of the recommended reservation.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The instance family of the recommended reservation.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The type of node that Amazon Web Services recommends.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The type of node that Amazon Web Services recommends.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance.</p>
        pub fn current_generation(mut self, input: bool) -> Self {
            self.current_generation = Some(input);
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance.</p>
        pub fn set_current_generation(mut self, input: std::option::Option<bool>) -> Self {
            self.current_generation = input;
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn size_flex_eligible(mut self, input: bool) -> Self {
            self.size_flex_eligible = Some(input);
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn set_size_flex_eligible(mut self, input: std::option::Option<bool>) -> Self {
            self.size_flex_eligible = input;
            self
        }
        /// Consumes the builder and constructs a [`RedshiftInstanceDetails`](crate::model::RedshiftInstanceDetails)
        pub fn build(self) -> crate::model::RedshiftInstanceDetails {
            crate::model::RedshiftInstanceDetails {
                family: self.family,
                node_type: self.node_type,
                region: self.region,
                current_generation: self.current_generation.unwrap_or_default(),
                size_flex_eligible: self.size_flex_eligible.unwrap_or_default(),
            }
        }
    }
}
impl RedshiftInstanceDetails {
    /// Creates a new builder-style object to manufacture [`RedshiftInstanceDetails`](crate::model::RedshiftInstanceDetails)
    pub fn builder() -> crate::model::redshift_instance_details::Builder {
        crate::model::redshift_instance_details::Builder::default()
    }
}

/// <p>Details about the Amazon RDS instances that Amazon Web Services recommends that you purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RdsInstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The type of instance that Amazon Web Services recommends.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The database engine that the recommended reservation supports.</p>
    pub database_engine: std::option::Option<std::string::String>,
    /// <p>The database edition that the recommended reservation supports.</p>
    pub database_edition: std::option::Option<std::string::String>,
    /// <p>Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a backup in a second Availability Zone.</p>
    pub deployment_option: std::option::Option<std::string::String>,
    /// <p>The license model that the recommended reservation supports.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>Determines whether the recommendation is for a current-generation instance. </p>
    pub current_generation: bool,
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub size_flex_eligible: bool,
}
impl RdsInstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub fn family(&self) -> std::option::Option<&str> {
        self.family.as_deref()
    }
    /// <p>The type of instance that Amazon Web Services recommends.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The database engine that the recommended reservation supports.</p>
    pub fn database_engine(&self) -> std::option::Option<&str> {
        self.database_engine.as_deref()
    }
    /// <p>The database edition that the recommended reservation supports.</p>
    pub fn database_edition(&self) -> std::option::Option<&str> {
        self.database_edition.as_deref()
    }
    /// <p>Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a backup in a second Availability Zone.</p>
    pub fn deployment_option(&self) -> std::option::Option<&str> {
        self.deployment_option.as_deref()
    }
    /// <p>The license model that the recommended reservation supports.</p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>Determines whether the recommendation is for a current-generation instance. </p>
    pub fn current_generation(&self) -> bool {
        self.current_generation
    }
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub fn size_flex_eligible(&self) -> bool {
        self.size_flex_eligible
    }
}
impl std::fmt::Debug for RdsInstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RdsInstanceDetails");
        formatter.field("family", &self.family);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("region", &self.region);
        formatter.field("database_engine", &self.database_engine);
        formatter.field("database_edition", &self.database_edition);
        formatter.field("deployment_option", &self.deployment_option);
        formatter.field("license_model", &self.license_model);
        formatter.field("current_generation", &self.current_generation);
        formatter.field("size_flex_eligible", &self.size_flex_eligible);
        formatter.finish()
    }
}
/// See [`RdsInstanceDetails`](crate::model::RdsInstanceDetails)
pub mod rds_instance_details {
    /// A builder for [`RdsInstanceDetails`](crate::model::RdsInstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) database_engine: std::option::Option<std::string::String>,
        pub(crate) database_edition: std::option::Option<std::string::String>,
        pub(crate) deployment_option: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) current_generation: std::option::Option<bool>,
        pub(crate) size_flex_eligible: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance family of the recommended reservation.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The instance family of the recommended reservation.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The type of instance that Amazon Web Services recommends.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The type of instance that Amazon Web Services recommends.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The database engine that the recommended reservation supports.</p>
        pub fn database_engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_engine = Some(input.into());
            self
        }
        /// <p>The database engine that the recommended reservation supports.</p>
        pub fn set_database_engine(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_engine = input;
            self
        }
        /// <p>The database edition that the recommended reservation supports.</p>
        pub fn database_edition(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_edition = Some(input.into());
            self
        }
        /// <p>The database edition that the recommended reservation supports.</p>
        pub fn set_database_edition(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_edition = input;
            self
        }
        /// <p>Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a backup in a second Availability Zone.</p>
        pub fn deployment_option(mut self, input: impl Into<std::string::String>) -> Self {
            self.deployment_option = Some(input.into());
            self
        }
        /// <p>Determines whether the recommendation is for a reservation in a single Availability Zone or a reservation with a backup in a second Availability Zone.</p>
        pub fn set_deployment_option(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.deployment_option = input;
            self
        }
        /// <p>The license model that the recommended reservation supports.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model that the recommended reservation supports.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance. </p>
        pub fn current_generation(mut self, input: bool) -> Self {
            self.current_generation = Some(input);
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance. </p>
        pub fn set_current_generation(mut self, input: std::option::Option<bool>) -> Self {
            self.current_generation = input;
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn size_flex_eligible(mut self, input: bool) -> Self {
            self.size_flex_eligible = Some(input);
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn set_size_flex_eligible(mut self, input: std::option::Option<bool>) -> Self {
            self.size_flex_eligible = input;
            self
        }
        /// Consumes the builder and constructs a [`RdsInstanceDetails`](crate::model::RdsInstanceDetails)
        pub fn build(self) -> crate::model::RdsInstanceDetails {
            crate::model::RdsInstanceDetails {
                family: self.family,
                instance_type: self.instance_type,
                region: self.region,
                database_engine: self.database_engine,
                database_edition: self.database_edition,
                deployment_option: self.deployment_option,
                license_model: self.license_model,
                current_generation: self.current_generation.unwrap_or_default(),
                size_flex_eligible: self.size_flex_eligible.unwrap_or_default(),
            }
        }
    }
}
impl RdsInstanceDetails {
    /// Creates a new builder-style object to manufacture [`RdsInstanceDetails`](crate::model::RdsInstanceDetails)
    pub fn builder() -> crate::model::rds_instance_details::Builder {
        crate::model::rds_instance_details::Builder::default()
    }
}

/// <p>Details about the Amazon EC2 instances that Amazon Web Services recommends that you purchase.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2InstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub family: std::option::Option<std::string::String>,
    /// <p>The type of instance that Amazon Web Services recommends.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The Availability Zone of the recommended reservation.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The platform of the recommended reservation. The platform is the specific combination of operating system, license model, and software on an instance.</p>
    pub platform: std::option::Option<std::string::String>,
    /// <p>Determines whether the recommended reservation is dedicated or shared.</p>
    pub tenancy: std::option::Option<std::string::String>,
    /// <p>Determines whether the recommendation is for a current-generation instance. </p>
    pub current_generation: bool,
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub size_flex_eligible: bool,
}
impl Ec2InstanceDetails {
    /// <p>The instance family of the recommended reservation.</p>
    pub fn family(&self) -> std::option::Option<&str> {
        self.family.as_deref()
    }
    /// <p>The type of instance that Amazon Web Services recommends.</p>
    pub fn instance_type(&self) -> std::option::Option<&str> {
        self.instance_type.as_deref()
    }
    /// <p>The Amazon Web Services Region of the recommended reservation.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The Availability Zone of the recommended reservation.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The platform of the recommended reservation. The platform is the specific combination of operating system, license model, and software on an instance.</p>
    pub fn platform(&self) -> std::option::Option<&str> {
        self.platform.as_deref()
    }
    /// <p>Determines whether the recommended reservation is dedicated or shared.</p>
    pub fn tenancy(&self) -> std::option::Option<&str> {
        self.tenancy.as_deref()
    }
    /// <p>Determines whether the recommendation is for a current-generation instance. </p>
    pub fn current_generation(&self) -> bool {
        self.current_generation
    }
    /// <p>Determines whether the recommended reservation is size flexible.</p>
    pub fn size_flex_eligible(&self) -> bool {
        self.size_flex_eligible
    }
}
impl std::fmt::Debug for Ec2InstanceDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2InstanceDetails");
        formatter.field("family", &self.family);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("region", &self.region);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("platform", &self.platform);
        formatter.field("tenancy", &self.tenancy);
        formatter.field("current_generation", &self.current_generation);
        formatter.field("size_flex_eligible", &self.size_flex_eligible);
        formatter.finish()
    }
}
/// See [`Ec2InstanceDetails`](crate::model::Ec2InstanceDetails)
pub mod ec2_instance_details {
    /// A builder for [`Ec2InstanceDetails`](crate::model::Ec2InstanceDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) family: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) platform: std::option::Option<std::string::String>,
        pub(crate) tenancy: std::option::Option<std::string::String>,
        pub(crate) current_generation: std::option::Option<bool>,
        pub(crate) size_flex_eligible: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The instance family of the recommended reservation.</p>
        pub fn family(mut self, input: impl Into<std::string::String>) -> Self {
            self.family = Some(input.into());
            self
        }
        /// <p>The instance family of the recommended reservation.</p>
        pub fn set_family(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.family = input;
            self
        }
        /// <p>The type of instance that Amazon Web Services recommends.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The type of instance that Amazon Web Services recommends.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the recommended reservation.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The Availability Zone of the recommended reservation.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone of the recommended reservation.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The platform of the recommended reservation. The platform is the specific combination of operating system, license model, and software on an instance.</p>
        pub fn platform(mut self, input: impl Into<std::string::String>) -> Self {
            self.platform = Some(input.into());
            self
        }
        /// <p>The platform of the recommended reservation. The platform is the specific combination of operating system, license model, and software on an instance.</p>
        pub fn set_platform(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.platform = input;
            self
        }
        /// <p>Determines whether the recommended reservation is dedicated or shared.</p>
        pub fn tenancy(mut self, input: impl Into<std::string::String>) -> Self {
            self.tenancy = Some(input.into());
            self
        }
        /// <p>Determines whether the recommended reservation is dedicated or shared.</p>
        pub fn set_tenancy(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tenancy = input;
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance. </p>
        pub fn current_generation(mut self, input: bool) -> Self {
            self.current_generation = Some(input);
            self
        }
        /// <p>Determines whether the recommendation is for a current-generation instance. </p>
        pub fn set_current_generation(mut self, input: std::option::Option<bool>) -> Self {
            self.current_generation = input;
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn size_flex_eligible(mut self, input: bool) -> Self {
            self.size_flex_eligible = Some(input);
            self
        }
        /// <p>Determines whether the recommended reservation is size flexible.</p>
        pub fn set_size_flex_eligible(mut self, input: std::option::Option<bool>) -> Self {
            self.size_flex_eligible = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2InstanceDetails`](crate::model::Ec2InstanceDetails)
        pub fn build(self) -> crate::model::Ec2InstanceDetails {
            crate::model::Ec2InstanceDetails {
                family: self.family,
                instance_type: self.instance_type,
                region: self.region,
                availability_zone: self.availability_zone,
                platform: self.platform,
                tenancy: self.tenancy,
                current_generation: self.current_generation.unwrap_or_default(),
                size_flex_eligible: self.size_flex_eligible.unwrap_or_default(),
            }
        }
    }
}
impl Ec2InstanceDetails {
    /// Creates a new builder-style object to manufacture [`Ec2InstanceDetails`](crate::model::Ec2InstanceDetails)
    pub fn builder() -> crate::model::ec2_instance_details::Builder {
        crate::model::ec2_instance_details::Builder::default()
    }
}

/// <p>Hardware specifications for the service that you want recommendations for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceSpecification {
    /// <p>The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.</p>
    pub ec2_specification: std::option::Option<crate::model::Ec2Specification>,
}
impl ServiceSpecification {
    /// <p>The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.</p>
    pub fn ec2_specification(&self) -> std::option::Option<&crate::model::Ec2Specification> {
        self.ec2_specification.as_ref()
    }
}
impl std::fmt::Debug for ServiceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceSpecification");
        formatter.field("ec2_specification", &self.ec2_specification);
        formatter.finish()
    }
}
/// See [`ServiceSpecification`](crate::model::ServiceSpecification)
pub mod service_specification {
    /// A builder for [`ServiceSpecification`](crate::model::ServiceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ec2_specification: std::option::Option<crate::model::Ec2Specification>,
    }
    impl Builder {
        /// <p>The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.</p>
        pub fn ec2_specification(mut self, input: crate::model::Ec2Specification) -> Self {
            self.ec2_specification = Some(input);
            self
        }
        /// <p>The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.</p>
        pub fn set_ec2_specification(
            mut self,
            input: std::option::Option<crate::model::Ec2Specification>,
        ) -> Self {
            self.ec2_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceSpecification`](crate::model::ServiceSpecification)
        pub fn build(self) -> crate::model::ServiceSpecification {
            crate::model::ServiceSpecification {
                ec2_specification: self.ec2_specification,
            }
        }
    }
}
impl ServiceSpecification {
    /// Creates a new builder-style object to manufacture [`ServiceSpecification`](crate::model::ServiceSpecification)
    pub fn builder() -> crate::model::service_specification::Builder {
        crate::model::service_specification::Builder::default()
    }
}

/// <p>The Amazon EC2 hardware specifications that you want Amazon Web Services to provide recommendations for.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2Specification {
    /// <p>Indicates whether you want a recommendation for standard or convertible reservations.</p>
    pub offering_class: std::option::Option<crate::model::OfferingClass>,
}
impl Ec2Specification {
    /// <p>Indicates whether you want a recommendation for standard or convertible reservations.</p>
    pub fn offering_class(&self) -> std::option::Option<&crate::model::OfferingClass> {
        self.offering_class.as_ref()
    }
}
impl std::fmt::Debug for Ec2Specification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2Specification");
        formatter.field("offering_class", &self.offering_class);
        formatter.finish()
    }
}
/// See [`Ec2Specification`](crate::model::Ec2Specification)
pub mod ec2_specification {
    /// A builder for [`Ec2Specification`](crate::model::Ec2Specification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_class: std::option::Option<crate::model::OfferingClass>,
    }
    impl Builder {
        /// <p>Indicates whether you want a recommendation for standard or convertible reservations.</p>
        pub fn offering_class(mut self, input: crate::model::OfferingClass) -> Self {
            self.offering_class = Some(input);
            self
        }
        /// <p>Indicates whether you want a recommendation for standard or convertible reservations.</p>
        pub fn set_offering_class(
            mut self,
            input: std::option::Option<crate::model::OfferingClass>,
        ) -> Self {
            self.offering_class = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2Specification`](crate::model::Ec2Specification)
        pub fn build(self) -> crate::model::Ec2Specification {
            crate::model::Ec2Specification {
                offering_class: self.offering_class,
            }
        }
    }
}
impl Ec2Specification {
    /// Creates a new builder-style object to manufacture [`Ec2Specification`](crate::model::Ec2Specification)
    pub fn builder() -> crate::model::ec2_specification::Builder {
        crate::model::ec2_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OfferingClass {
    #[allow(missing_docs)] // documentation missing in model
    Convertible,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OfferingClass {
    fn from(s: &str) -> Self {
        match s {
            "CONVERTIBLE" => OfferingClass::Convertible,
            "STANDARD" => OfferingClass::Standard,
            other => OfferingClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OfferingClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OfferingClass::from(s))
    }
}
impl OfferingClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OfferingClass::Convertible => "CONVERTIBLE",
            OfferingClass::Standard => "STANDARD",
            OfferingClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONVERTIBLE", "STANDARD"]
    }
}
impl AsRef<str> for OfferingClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Information about this specific recommendation, such as the timestamp for when Amazon Web Services made a specific recommendation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationPurchaseRecommendationMetadata {
    /// <p>The ID for this specific recommendation.</p>
    pub recommendation_id: std::option::Option<std::string::String>,
    /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
    pub generation_timestamp: std::option::Option<std::string::String>,
}
impl ReservationPurchaseRecommendationMetadata {
    /// <p>The ID for this specific recommendation.</p>
    pub fn recommendation_id(&self) -> std::option::Option<&str> {
        self.recommendation_id.as_deref()
    }
    /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
    pub fn generation_timestamp(&self) -> std::option::Option<&str> {
        self.generation_timestamp.as_deref()
    }
}
impl std::fmt::Debug for ReservationPurchaseRecommendationMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationPurchaseRecommendationMetadata");
        formatter.field("recommendation_id", &self.recommendation_id);
        formatter.field("generation_timestamp", &self.generation_timestamp);
        formatter.finish()
    }
}
/// See [`ReservationPurchaseRecommendationMetadata`](crate::model::ReservationPurchaseRecommendationMetadata)
pub mod reservation_purchase_recommendation_metadata {
    /// A builder for [`ReservationPurchaseRecommendationMetadata`](crate::model::ReservationPurchaseRecommendationMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recommendation_id: std::option::Option<std::string::String>,
        pub(crate) generation_timestamp: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID for this specific recommendation.</p>
        pub fn recommendation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.recommendation_id = Some(input.into());
            self
        }
        /// <p>The ID for this specific recommendation.</p>
        pub fn set_recommendation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recommendation_id = input;
            self
        }
        /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
        pub fn generation_timestamp(mut self, input: impl Into<std::string::String>) -> Self {
            self.generation_timestamp = Some(input.into());
            self
        }
        /// <p>The timestamp for when Amazon Web Services made this recommendation.</p>
        pub fn set_generation_timestamp(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.generation_timestamp = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationPurchaseRecommendationMetadata`](crate::model::ReservationPurchaseRecommendationMetadata)
        pub fn build(self) -> crate::model::ReservationPurchaseRecommendationMetadata {
            crate::model::ReservationPurchaseRecommendationMetadata {
                recommendation_id: self.recommendation_id,
                generation_timestamp: self.generation_timestamp,
            }
        }
    }
}
impl ReservationPurchaseRecommendationMetadata {
    /// Creates a new builder-style object to manufacture [`ReservationPurchaseRecommendationMetadata`](crate::model::ReservationPurchaseRecommendationMetadata)
    pub fn builder() -> crate::model::reservation_purchase_recommendation_metadata::Builder {
        crate::model::reservation_purchase_recommendation_metadata::Builder::default()
    }
}

/// <p>The amount of instance usage that a reservation covered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Coverage {
    /// <p>The amount of instance usage that the reservation covered, in hours.</p>
    pub coverage_hours: std::option::Option<crate::model::CoverageHours>,
    /// <p>The amount of instance usage that the reservation covered, in normalized units.</p>
    pub coverage_normalized_units: std::option::Option<crate::model::CoverageNormalizedUnits>,
    /// <p>The amount of cost that the reservation covered.</p>
    pub coverage_cost: std::option::Option<crate::model::CoverageCost>,
}
impl Coverage {
    /// <p>The amount of instance usage that the reservation covered, in hours.</p>
    pub fn coverage_hours(&self) -> std::option::Option<&crate::model::CoverageHours> {
        self.coverage_hours.as_ref()
    }
    /// <p>The amount of instance usage that the reservation covered, in normalized units.</p>
    pub fn coverage_normalized_units(
        &self,
    ) -> std::option::Option<&crate::model::CoverageNormalizedUnits> {
        self.coverage_normalized_units.as_ref()
    }
    /// <p>The amount of cost that the reservation covered.</p>
    pub fn coverage_cost(&self) -> std::option::Option<&crate::model::CoverageCost> {
        self.coverage_cost.as_ref()
    }
}
impl std::fmt::Debug for Coverage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Coverage");
        formatter.field("coverage_hours", &self.coverage_hours);
        formatter.field("coverage_normalized_units", &self.coverage_normalized_units);
        formatter.field("coverage_cost", &self.coverage_cost);
        formatter.finish()
    }
}
/// See [`Coverage`](crate::model::Coverage)
pub mod coverage {
    /// A builder for [`Coverage`](crate::model::Coverage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) coverage_hours: std::option::Option<crate::model::CoverageHours>,
        pub(crate) coverage_normalized_units:
            std::option::Option<crate::model::CoverageNormalizedUnits>,
        pub(crate) coverage_cost: std::option::Option<crate::model::CoverageCost>,
    }
    impl Builder {
        /// <p>The amount of instance usage that the reservation covered, in hours.</p>
        pub fn coverage_hours(mut self, input: crate::model::CoverageHours) -> Self {
            self.coverage_hours = Some(input);
            self
        }
        /// <p>The amount of instance usage that the reservation covered, in hours.</p>
        pub fn set_coverage_hours(
            mut self,
            input: std::option::Option<crate::model::CoverageHours>,
        ) -> Self {
            self.coverage_hours = input;
            self
        }
        /// <p>The amount of instance usage that the reservation covered, in normalized units.</p>
        pub fn coverage_normalized_units(
            mut self,
            input: crate::model::CoverageNormalizedUnits,
        ) -> Self {
            self.coverage_normalized_units = Some(input);
            self
        }
        /// <p>The amount of instance usage that the reservation covered, in normalized units.</p>
        pub fn set_coverage_normalized_units(
            mut self,
            input: std::option::Option<crate::model::CoverageNormalizedUnits>,
        ) -> Self {
            self.coverage_normalized_units = input;
            self
        }
        /// <p>The amount of cost that the reservation covered.</p>
        pub fn coverage_cost(mut self, input: crate::model::CoverageCost) -> Self {
            self.coverage_cost = Some(input);
            self
        }
        /// <p>The amount of cost that the reservation covered.</p>
        pub fn set_coverage_cost(
            mut self,
            input: std::option::Option<crate::model::CoverageCost>,
        ) -> Self {
            self.coverage_cost = input;
            self
        }
        /// Consumes the builder and constructs a [`Coverage`](crate::model::Coverage)
        pub fn build(self) -> crate::model::Coverage {
            crate::model::Coverage {
                coverage_hours: self.coverage_hours,
                coverage_normalized_units: self.coverage_normalized_units,
                coverage_cost: self.coverage_cost,
            }
        }
    }
}
impl Coverage {
    /// Creates a new builder-style object to manufacture [`Coverage`](crate::model::Coverage)
    pub fn builder() -> crate::model::coverage::Builder {
        crate::model::coverage::Builder::default()
    }
}

/// <p>How much it costs to run an instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoverageCost {
    /// <p>How much an On-Demand Instance costs.</p>
    pub on_demand_cost: std::option::Option<std::string::String>,
}
impl CoverageCost {
    /// <p>How much an On-Demand Instance costs.</p>
    pub fn on_demand_cost(&self) -> std::option::Option<&str> {
        self.on_demand_cost.as_deref()
    }
}
impl std::fmt::Debug for CoverageCost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoverageCost");
        formatter.field("on_demand_cost", &self.on_demand_cost);
        formatter.finish()
    }
}
/// See [`CoverageCost`](crate::model::CoverageCost)
pub mod coverage_cost {
    /// A builder for [`CoverageCost`](crate::model::CoverageCost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) on_demand_cost: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>How much an On-Demand Instance costs.</p>
        pub fn on_demand_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.on_demand_cost = Some(input.into());
            self
        }
        /// <p>How much an On-Demand Instance costs.</p>
        pub fn set_on_demand_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_cost = input;
            self
        }
        /// Consumes the builder and constructs a [`CoverageCost`](crate::model::CoverageCost)
        pub fn build(self) -> crate::model::CoverageCost {
            crate::model::CoverageCost {
                on_demand_cost: self.on_demand_cost,
            }
        }
    }
}
impl CoverageCost {
    /// Creates a new builder-style object to manufacture [`CoverageCost`](crate::model::CoverageCost)
    pub fn builder() -> crate::model::coverage_cost::Builder {
        crate::model::coverage_cost::Builder::default()
    }
}

/// <p>The amount of instance usage, in normalized units. You can use normalized units to see your EC2 usage for multiple sizes of instances in a uniform way. For example, suppose that you run an xlarge instance and a 2xlarge instance. If you run both instances for the same amount of time, the 2xlarge instance uses twice as much of your reservation as the xlarge instance, even though both instances show only one instance-hour. When you use normalized units instead of instance-hours, the xlarge instance used 8 normalized units, and the 2xlarge instance used 16 normalized units.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying Reserved Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoverageNormalizedUnits {
    /// <p>The number of normalized units that are covered by On-Demand Instances instead of a reservation.</p>
    pub on_demand_normalized_units: std::option::Option<std::string::String>,
    /// <p>The number of normalized units that a reservation covers.</p>
    pub reserved_normalized_units: std::option::Option<std::string::String>,
    /// <p>The total number of normalized units that you used.</p>
    pub total_running_normalized_units: std::option::Option<std::string::String>,
    /// <p>The percentage of your used instance normalized units that a reservation covers.</p>
    pub coverage_normalized_units_percentage: std::option::Option<std::string::String>,
}
impl CoverageNormalizedUnits {
    /// <p>The number of normalized units that are covered by On-Demand Instances instead of a reservation.</p>
    pub fn on_demand_normalized_units(&self) -> std::option::Option<&str> {
        self.on_demand_normalized_units.as_deref()
    }
    /// <p>The number of normalized units that a reservation covers.</p>
    pub fn reserved_normalized_units(&self) -> std::option::Option<&str> {
        self.reserved_normalized_units.as_deref()
    }
    /// <p>The total number of normalized units that you used.</p>
    pub fn total_running_normalized_units(&self) -> std::option::Option<&str> {
        self.total_running_normalized_units.as_deref()
    }
    /// <p>The percentage of your used instance normalized units that a reservation covers.</p>
    pub fn coverage_normalized_units_percentage(&self) -> std::option::Option<&str> {
        self.coverage_normalized_units_percentage.as_deref()
    }
}
impl std::fmt::Debug for CoverageNormalizedUnits {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoverageNormalizedUnits");
        formatter.field(
            "on_demand_normalized_units",
            &self.on_demand_normalized_units,
        );
        formatter.field("reserved_normalized_units", &self.reserved_normalized_units);
        formatter.field(
            "total_running_normalized_units",
            &self.total_running_normalized_units,
        );
        formatter.field(
            "coverage_normalized_units_percentage",
            &self.coverage_normalized_units_percentage,
        );
        formatter.finish()
    }
}
/// See [`CoverageNormalizedUnits`](crate::model::CoverageNormalizedUnits)
pub mod coverage_normalized_units {
    /// A builder for [`CoverageNormalizedUnits`](crate::model::CoverageNormalizedUnits)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) on_demand_normalized_units: std::option::Option<std::string::String>,
        pub(crate) reserved_normalized_units: std::option::Option<std::string::String>,
        pub(crate) total_running_normalized_units: std::option::Option<std::string::String>,
        pub(crate) coverage_normalized_units_percentage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of normalized units that are covered by On-Demand Instances instead of a reservation.</p>
        pub fn on_demand_normalized_units(mut self, input: impl Into<std::string::String>) -> Self {
            self.on_demand_normalized_units = Some(input.into());
            self
        }
        /// <p>The number of normalized units that are covered by On-Demand Instances instead of a reservation.</p>
        pub fn set_on_demand_normalized_units(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_normalized_units = input;
            self
        }
        /// <p>The number of normalized units that a reservation covers.</p>
        pub fn reserved_normalized_units(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_normalized_units = Some(input.into());
            self
        }
        /// <p>The number of normalized units that a reservation covers.</p>
        pub fn set_reserved_normalized_units(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_normalized_units = input;
            self
        }
        /// <p>The total number of normalized units that you used.</p>
        pub fn total_running_normalized_units(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.total_running_normalized_units = Some(input.into());
            self
        }
        /// <p>The total number of normalized units that you used.</p>
        pub fn set_total_running_normalized_units(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_running_normalized_units = input;
            self
        }
        /// <p>The percentage of your used instance normalized units that a reservation covers.</p>
        pub fn coverage_normalized_units_percentage(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.coverage_normalized_units_percentage = Some(input.into());
            self
        }
        /// <p>The percentage of your used instance normalized units that a reservation covers.</p>
        pub fn set_coverage_normalized_units_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.coverage_normalized_units_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`CoverageNormalizedUnits`](crate::model::CoverageNormalizedUnits)
        pub fn build(self) -> crate::model::CoverageNormalizedUnits {
            crate::model::CoverageNormalizedUnits {
                on_demand_normalized_units: self.on_demand_normalized_units,
                reserved_normalized_units: self.reserved_normalized_units,
                total_running_normalized_units: self.total_running_normalized_units,
                coverage_normalized_units_percentage: self.coverage_normalized_units_percentage,
            }
        }
    }
}
impl CoverageNormalizedUnits {
    /// Creates a new builder-style object to manufacture [`CoverageNormalizedUnits`](crate::model::CoverageNormalizedUnits)
    pub fn builder() -> crate::model::coverage_normalized_units::Builder {
        crate::model::coverage_normalized_units::Builder::default()
    }
}

/// <p>How long a running instance either used a reservation or was On-Demand.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoverageHours {
    /// <p>The number of instance running hours that On-Demand Instances covered.</p>
    pub on_demand_hours: std::option::Option<std::string::String>,
    /// <p>The number of instance running hours that reservations covered.</p>
    pub reserved_hours: std::option::Option<std::string::String>,
    /// <p>The total instance usage, in hours.</p>
    pub total_running_hours: std::option::Option<std::string::String>,
    /// <p>The percentage of instance hours that a reservation covered.</p>
    pub coverage_hours_percentage: std::option::Option<std::string::String>,
}
impl CoverageHours {
    /// <p>The number of instance running hours that On-Demand Instances covered.</p>
    pub fn on_demand_hours(&self) -> std::option::Option<&str> {
        self.on_demand_hours.as_deref()
    }
    /// <p>The number of instance running hours that reservations covered.</p>
    pub fn reserved_hours(&self) -> std::option::Option<&str> {
        self.reserved_hours.as_deref()
    }
    /// <p>The total instance usage, in hours.</p>
    pub fn total_running_hours(&self) -> std::option::Option<&str> {
        self.total_running_hours.as_deref()
    }
    /// <p>The percentage of instance hours that a reservation covered.</p>
    pub fn coverage_hours_percentage(&self) -> std::option::Option<&str> {
        self.coverage_hours_percentage.as_deref()
    }
}
impl std::fmt::Debug for CoverageHours {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoverageHours");
        formatter.field("on_demand_hours", &self.on_demand_hours);
        formatter.field("reserved_hours", &self.reserved_hours);
        formatter.field("total_running_hours", &self.total_running_hours);
        formatter.field("coverage_hours_percentage", &self.coverage_hours_percentage);
        formatter.finish()
    }
}
/// See [`CoverageHours`](crate::model::CoverageHours)
pub mod coverage_hours {
    /// A builder for [`CoverageHours`](crate::model::CoverageHours)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) on_demand_hours: std::option::Option<std::string::String>,
        pub(crate) reserved_hours: std::option::Option<std::string::String>,
        pub(crate) total_running_hours: std::option::Option<std::string::String>,
        pub(crate) coverage_hours_percentage: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The number of instance running hours that On-Demand Instances covered.</p>
        pub fn on_demand_hours(mut self, input: impl Into<std::string::String>) -> Self {
            self.on_demand_hours = Some(input.into());
            self
        }
        /// <p>The number of instance running hours that On-Demand Instances covered.</p>
        pub fn set_on_demand_hours(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.on_demand_hours = input;
            self
        }
        /// <p>The number of instance running hours that reservations covered.</p>
        pub fn reserved_hours(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_hours = Some(input.into());
            self
        }
        /// <p>The number of instance running hours that reservations covered.</p>
        pub fn set_reserved_hours(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_hours = input;
            self
        }
        /// <p>The total instance usage, in hours.</p>
        pub fn total_running_hours(mut self, input: impl Into<std::string::String>) -> Self {
            self.total_running_hours = Some(input.into());
            self
        }
        /// <p>The total instance usage, in hours.</p>
        pub fn set_total_running_hours(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.total_running_hours = input;
            self
        }
        /// <p>The percentage of instance hours that a reservation covered.</p>
        pub fn coverage_hours_percentage(mut self, input: impl Into<std::string::String>) -> Self {
            self.coverage_hours_percentage = Some(input.into());
            self
        }
        /// <p>The percentage of instance hours that a reservation covered.</p>
        pub fn set_coverage_hours_percentage(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.coverage_hours_percentage = input;
            self
        }
        /// Consumes the builder and constructs a [`CoverageHours`](crate::model::CoverageHours)
        pub fn build(self) -> crate::model::CoverageHours {
            crate::model::CoverageHours {
                on_demand_hours: self.on_demand_hours,
                reserved_hours: self.reserved_hours,
                total_running_hours: self.total_running_hours,
                coverage_hours_percentage: self.coverage_hours_percentage,
            }
        }
    }
}
impl CoverageHours {
    /// Creates a new builder-style object to manufacture [`CoverageHours`](crate::model::CoverageHours)
    pub fn builder() -> crate::model::coverage_hours::Builder {
        crate::model::coverage_hours::Builder::default()
    }
}

/// <p>Reservation coverage for a specified period, in hours.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CoverageByTime {
    /// <p>The period that this coverage was used over.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The groups of instances that the reservation covered.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::ReservationCoverageGroup>>,
    /// <p>The total reservation coverage, in hours.</p>
    pub total: std::option::Option<crate::model::Coverage>,
}
impl CoverageByTime {
    /// <p>The period that this coverage was used over.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The groups of instances that the reservation covered.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::ReservationCoverageGroup]> {
        self.groups.as_deref()
    }
    /// <p>The total reservation coverage, in hours.</p>
    pub fn total(&self) -> std::option::Option<&crate::model::Coverage> {
        self.total.as_ref()
    }
}
impl std::fmt::Debug for CoverageByTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CoverageByTime");
        formatter.field("time_period", &self.time_period);
        formatter.field("groups", &self.groups);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`CoverageByTime`](crate::model::CoverageByTime)
pub mod coverage_by_time {
    /// A builder for [`CoverageByTime`](crate::model::CoverageByTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) groups:
            std::option::Option<std::vec::Vec<crate::model::ReservationCoverageGroup>>,
        pub(crate) total: std::option::Option<crate::model::Coverage>,
    }
    impl Builder {
        /// <p>The period that this coverage was used over.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The period that this coverage was used over.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The groups of instances that the reservation covered.</p>
        pub fn groups(mut self, input: crate::model::ReservationCoverageGroup) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>The groups of instances that the reservation covered.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservationCoverageGroup>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>The total reservation coverage, in hours.</p>
        pub fn total(mut self, input: crate::model::Coverage) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total reservation coverage, in hours.</p>
        pub fn set_total(mut self, input: std::option::Option<crate::model::Coverage>) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`CoverageByTime`](crate::model::CoverageByTime)
        pub fn build(self) -> crate::model::CoverageByTime {
            crate::model::CoverageByTime {
                time_period: self.time_period,
                groups: self.groups,
                total: self.total,
            }
        }
    }
}
impl CoverageByTime {
    /// Creates a new builder-style object to manufacture [`CoverageByTime`](crate::model::CoverageByTime)
    pub fn builder() -> crate::model::coverage_by_time::Builder {
        crate::model::coverage_by_time::Builder::default()
    }
}

/// <p>A group of reservations that share a set of attributes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationCoverageGroup {
    /// <p>The attributes for this group of reservations.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>How much instance usage this group of reservations covered.</p>
    pub coverage: std::option::Option<crate::model::Coverage>,
}
impl ReservationCoverageGroup {
    /// <p>The attributes for this group of reservations.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
    /// <p>How much instance usage this group of reservations covered.</p>
    pub fn coverage(&self) -> std::option::Option<&crate::model::Coverage> {
        self.coverage.as_ref()
    }
}
impl std::fmt::Debug for ReservationCoverageGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationCoverageGroup");
        formatter.field("attributes", &self.attributes);
        formatter.field("coverage", &self.coverage);
        formatter.finish()
    }
}
/// See [`ReservationCoverageGroup`](crate::model::ReservationCoverageGroup)
pub mod reservation_coverage_group {
    /// A builder for [`ReservationCoverageGroup`](crate::model::ReservationCoverageGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) coverage: std::option::Option<crate::model::Coverage>,
    }
    impl Builder {
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes for this group of reservations.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The attributes for this group of reservations.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>How much instance usage this group of reservations covered.</p>
        pub fn coverage(mut self, input: crate::model::Coverage) -> Self {
            self.coverage = Some(input);
            self
        }
        /// <p>How much instance usage this group of reservations covered.</p>
        pub fn set_coverage(mut self, input: std::option::Option<crate::model::Coverage>) -> Self {
            self.coverage = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationCoverageGroup`](crate::model::ReservationCoverageGroup)
        pub fn build(self) -> crate::model::ReservationCoverageGroup {
            crate::model::ReservationCoverageGroup {
                attributes: self.attributes,
                coverage: self.coverage,
            }
        }
    }
}
impl ReservationCoverageGroup {
    /// Creates a new builder-style object to manufacture [`ReservationCoverageGroup`](crate::model::ReservationCoverageGroup)
    pub fn builder() -> crate::model::reservation_coverage_group::Builder {
        crate::model::reservation_coverage_group::Builder::default()
    }
}

/// <p>The metadata of a specific type that you can use to filter and group your results. You can use <code>GetDimensionValues</code> to find specific values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DimensionValuesWithAttributes {
    /// <p>The value of a dimension with a specific attribute.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
    pub attributes:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl DimensionValuesWithAttributes {
    /// <p>The value of a dimension with a specific attribute.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
    pub fn attributes(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.attributes.as_ref()
    }
}
impl std::fmt::Debug for DimensionValuesWithAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DimensionValuesWithAttributes");
        formatter.field("value", &self.value);
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`DimensionValuesWithAttributes`](crate::model::DimensionValuesWithAttributes)
pub mod dimension_values_with_attributes {
    /// A builder for [`DimensionValuesWithAttributes`](crate::model::DimensionValuesWithAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The value of a dimension with a specific attribute.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a dimension with a specific attribute.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The attribute that applies to a specific <code>Dimension</code>.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DimensionValuesWithAttributes`](crate::model::DimensionValuesWithAttributes)
        pub fn build(self) -> crate::model::DimensionValuesWithAttributes {
            crate::model::DimensionValuesWithAttributes {
                value: self.value,
                attributes: self.attributes,
            }
        }
    }
}
impl DimensionValuesWithAttributes {
    /// Creates a new builder-style object to manufacture [`DimensionValuesWithAttributes`](crate::model::DimensionValuesWithAttributes)
    pub fn builder() -> crate::model::dimension_values_with_attributes::Builder {
        crate::model::dimension_values_with_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Context {
    #[allow(missing_docs)] // documentation missing in model
    CostAndUsage,
    #[allow(missing_docs)] // documentation missing in model
    Reservations,
    #[allow(missing_docs)] // documentation missing in model
    SavingsPlans,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Context {
    fn from(s: &str) -> Self {
        match s {
            "COST_AND_USAGE" => Context::CostAndUsage,
            "RESERVATIONS" => Context::Reservations,
            "SAVINGS_PLANS" => Context::SavingsPlans,
            other => Context::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Context {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Context::from(s))
    }
}
impl Context {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Context::CostAndUsage => "COST_AND_USAGE",
            Context::Reservations => "RESERVATIONS",
            Context::SavingsPlans => "SAVINGS_PLANS",
            Context::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COST_AND_USAGE", "RESERVATIONS", "SAVINGS_PLANS"]
    }
}
impl AsRef<str> for Context {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The result that's associated with a time period.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultByTime {
    /// <p>The time period that the result covers.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The total amount of cost or usage accrued during the time period.</p>
    pub total: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MetricValue>,
    >,
    /// <p>The groups that this time period includes.</p>
    pub groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
    /// <p>Determines whether the result is estimated.</p>
    pub estimated: bool,
}
impl ResultByTime {
    /// <p>The time period that the result covers.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The total amount of cost or usage accrued during the time period.</p>
    pub fn total(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MetricValue>,
    > {
        self.total.as_ref()
    }
    /// <p>The groups that this time period includes.</p>
    pub fn groups(&self) -> std::option::Option<&[crate::model::Group]> {
        self.groups.as_deref()
    }
    /// <p>Determines whether the result is estimated.</p>
    pub fn estimated(&self) -> bool {
        self.estimated
    }
}
impl std::fmt::Debug for ResultByTime {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultByTime");
        formatter.field("time_period", &self.time_period);
        formatter.field("total", &self.total);
        formatter.field("groups", &self.groups);
        formatter.field("estimated", &self.estimated);
        formatter.finish()
    }
}
/// See [`ResultByTime`](crate::model::ResultByTime)
pub mod result_by_time {
    /// A builder for [`ResultByTime`](crate::model::ResultByTime)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) total: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MetricValue>,
        >,
        pub(crate) groups: std::option::Option<std::vec::Vec<crate::model::Group>>,
        pub(crate) estimated: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The time period that the result covers.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period that the result covers.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Adds a key-value pair to `total`.
        ///
        /// To override the contents of this collection use [`set_total`](Self::set_total).
        ///
        /// <p>The total amount of cost or usage accrued during the time period.</p>
        pub fn total(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MetricValue,
        ) -> Self {
            let mut hash_map = self.total.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.total = Some(hash_map);
            self
        }
        /// <p>The total amount of cost or usage accrued during the time period.</p>
        pub fn set_total(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetricValue>,
            >,
        ) -> Self {
            self.total = input;
            self
        }
        /// Appends an item to `groups`.
        ///
        /// To override the contents of this collection use [`set_groups`](Self::set_groups).
        ///
        /// <p>The groups that this time period includes.</p>
        pub fn groups(mut self, input: crate::model::Group) -> Self {
            let mut v = self.groups.unwrap_or_default();
            v.push(input);
            self.groups = Some(v);
            self
        }
        /// <p>The groups that this time period includes.</p>
        pub fn set_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Group>>,
        ) -> Self {
            self.groups = input;
            self
        }
        /// <p>Determines whether the result is estimated.</p>
        pub fn estimated(mut self, input: bool) -> Self {
            self.estimated = Some(input);
            self
        }
        /// <p>Determines whether the result is estimated.</p>
        pub fn set_estimated(mut self, input: std::option::Option<bool>) -> Self {
            self.estimated = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultByTime`](crate::model::ResultByTime)
        pub fn build(self) -> crate::model::ResultByTime {
            crate::model::ResultByTime {
                time_period: self.time_period,
                total: self.total,
                groups: self.groups,
                estimated: self.estimated.unwrap_or_default(),
            }
        }
    }
}
impl ResultByTime {
    /// Creates a new builder-style object to manufacture [`ResultByTime`](crate::model::ResultByTime)
    pub fn builder() -> crate::model::result_by_time::Builder {
        crate::model::result_by_time::Builder::default()
    }
}

/// <p>One level of grouped data in the results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Group {
    /// <p>The keys that are included in this group.</p>
    pub keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The metrics that are included in this group.</p>
    pub metrics: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::MetricValue>,
    >,
}
impl Group {
    /// <p>The keys that are included in this group.</p>
    pub fn keys(&self) -> std::option::Option<&[std::string::String]> {
        self.keys.as_deref()
    }
    /// <p>The metrics that are included in this group.</p>
    pub fn metrics(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<std::string::String, crate::model::MetricValue>,
    > {
        self.metrics.as_ref()
    }
}
impl std::fmt::Debug for Group {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Group");
        formatter.field("keys", &self.keys);
        formatter.field("metrics", &self.metrics);
        formatter.finish()
    }
}
/// See [`Group`](crate::model::Group)
pub mod group {
    /// A builder for [`Group`](crate::model::Group)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) metrics: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::MetricValue>,
        >,
    }
    impl Builder {
        /// Appends an item to `keys`.
        ///
        /// To override the contents of this collection use [`set_keys`](Self::set_keys).
        ///
        /// <p>The keys that are included in this group.</p>
        pub fn keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keys.unwrap_or_default();
            v.push(input.into());
            self.keys = Some(v);
            self
        }
        /// <p>The keys that are included in this group.</p>
        pub fn set_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keys = input;
            self
        }
        /// Adds a key-value pair to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The metrics that are included in this group.</p>
        pub fn metrics(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::MetricValue,
        ) -> Self {
            let mut hash_map = self.metrics.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.metrics = Some(hash_map);
            self
        }
        /// <p>The metrics that are included in this group.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::MetricValue>,
            >,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Consumes the builder and constructs a [`Group`](crate::model::Group)
        pub fn build(self) -> crate::model::Group {
            crate::model::Group {
                keys: self.keys,
                metrics: self.metrics,
            }
        }
    }
}
impl Group {
    /// Creates a new builder-style object to manufacture [`Group`](crate::model::Group)
    pub fn builder() -> crate::model::group::Builder {
        crate::model::group::Builder::default()
    }
}

/// <p>The association between a monitor, threshold, and list of subscribers used to deliver notifications about anomalies detected by a monitor that exceeds a threshold. The content consists of the detailed metadata and the current status of the <code>AnomalySubscription</code> object. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalySubscription {
    /// <p>The <code>AnomalySubscription</code> Amazon Resource Name (ARN). </p>
    pub subscription_arn: std::option::Option<std::string::String>,
    /// <p>Your unique account identifier. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>A list of cost anomaly monitors. </p>
    pub monitor_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of subscribers to notify. </p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    /// <p>The dollar value that triggers a notification if the threshold is exceeded. </p>
    pub threshold: std::option::Option<f64>,
    /// <p>The frequency that anomaly reports are sent over email. </p>
    pub frequency: std::option::Option<crate::model::AnomalySubscriptionFrequency>,
    /// <p>The name for the subscription. </p>
    pub subscription_name: std::option::Option<std::string::String>,
}
impl AnomalySubscription {
    /// <p>The <code>AnomalySubscription</code> Amazon Resource Name (ARN). </p>
    pub fn subscription_arn(&self) -> std::option::Option<&str> {
        self.subscription_arn.as_deref()
    }
    /// <p>Your unique account identifier. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>A list of cost anomaly monitors. </p>
    pub fn monitor_arn_list(&self) -> std::option::Option<&[std::string::String]> {
        self.monitor_arn_list.as_deref()
    }
    /// <p>A list of subscribers to notify. </p>
    pub fn subscribers(&self) -> std::option::Option<&[crate::model::Subscriber]> {
        self.subscribers.as_deref()
    }
    /// <p>The dollar value that triggers a notification if the threshold is exceeded. </p>
    pub fn threshold(&self) -> std::option::Option<f64> {
        self.threshold
    }
    /// <p>The frequency that anomaly reports are sent over email. </p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::AnomalySubscriptionFrequency> {
        self.frequency.as_ref()
    }
    /// <p>The name for the subscription. </p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
}
impl std::fmt::Debug for AnomalySubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalySubscription");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.field("account_id", &self.account_id);
        formatter.field("monitor_arn_list", &self.monitor_arn_list);
        formatter.field("subscribers", &self.subscribers);
        formatter.field("threshold", &self.threshold);
        formatter.field("frequency", &self.frequency);
        formatter.field("subscription_name", &self.subscription_name);
        formatter.finish()
    }
}
/// See [`AnomalySubscription`](crate::model::AnomalySubscription)
pub mod anomaly_subscription {
    /// A builder for [`AnomalySubscription`](crate::model::AnomalySubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) monitor_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        pub(crate) threshold: std::option::Option<f64>,
        pub(crate) frequency: std::option::Option<crate::model::AnomalySubscriptionFrequency>,
        pub(crate) subscription_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The <code>AnomalySubscription</code> Amazon Resource Name (ARN). </p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The <code>AnomalySubscription</code> Amazon Resource Name (ARN). </p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// <p>Your unique account identifier. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>Your unique account identifier. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `monitor_arn_list`.
        ///
        /// To override the contents of this collection use [`set_monitor_arn_list`](Self::set_monitor_arn_list).
        ///
        /// <p>A list of cost anomaly monitors. </p>
        pub fn monitor_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.monitor_arn_list.unwrap_or_default();
            v.push(input.into());
            self.monitor_arn_list = Some(v);
            self
        }
        /// <p>A list of cost anomaly monitors. </p>
        pub fn set_monitor_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.monitor_arn_list = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>A list of subscribers to notify. </p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input);
            self.subscribers = Some(v);
            self
        }
        /// <p>A list of subscribers to notify. </p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// <p>The dollar value that triggers a notification if the threshold is exceeded. </p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The dollar value that triggers a notification if the threshold is exceeded. </p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>The frequency that anomaly reports are sent over email. </p>
        pub fn frequency(mut self, input: crate::model::AnomalySubscriptionFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The frequency that anomaly reports are sent over email. </p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AnomalySubscriptionFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// <p>The name for the subscription. </p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name for the subscription. </p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalySubscription`](crate::model::AnomalySubscription)
        pub fn build(self) -> crate::model::AnomalySubscription {
            crate::model::AnomalySubscription {
                subscription_arn: self.subscription_arn,
                account_id: self.account_id,
                monitor_arn_list: self.monitor_arn_list,
                subscribers: self.subscribers,
                threshold: self.threshold,
                frequency: self.frequency,
                subscription_name: self.subscription_name,
            }
        }
    }
}
impl AnomalySubscription {
    /// Creates a new builder-style object to manufacture [`AnomalySubscription`](crate::model::AnomalySubscription)
    pub fn builder() -> crate::model::anomaly_subscription::Builder {
        crate::model::anomaly_subscription::Builder::default()
    }
}

/// <p>This object continuously inspects your account's cost data for anomalies. It's based on <code>MonitorType</code> and <code>MonitorSpecification</code>. The content consists of detailed metadata and the current status of the monitor object. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyMonitor {
    /// <p>The Amazon Resource Name (ARN) value. </p>
    pub monitor_arn: std::option::Option<std::string::String>,
    /// <p>The name of the monitor. </p>
    pub monitor_name: std::option::Option<std::string::String>,
    /// <p>The date when the monitor was created. </p>
    pub creation_date: std::option::Option<std::string::String>,
    /// <p>The date when the monitor was last updated. </p>
    pub last_updated_date: std::option::Option<std::string::String>,
    /// <p>The date when the monitor last evaluated for anomalies. </p>
    pub last_evaluated_date: std::option::Option<std::string::String>,
    /// <p>The possible type values. </p>
    pub monitor_type: std::option::Option<crate::model::MonitorType>,
    /// <p>The dimensions to evaluate. </p>
    pub monitor_dimension: std::option::Option<crate::model::MonitorDimension>,
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub monitor_specification: std::option::Option<crate::model::Expression>,
    /// <p>The value for evaluated dimensions. </p>
    pub dimensional_value_count: i32,
}
impl AnomalyMonitor {
    /// <p>The Amazon Resource Name (ARN) value. </p>
    pub fn monitor_arn(&self) -> std::option::Option<&str> {
        self.monitor_arn.as_deref()
    }
    /// <p>The name of the monitor. </p>
    pub fn monitor_name(&self) -> std::option::Option<&str> {
        self.monitor_name.as_deref()
    }
    /// <p>The date when the monitor was created. </p>
    pub fn creation_date(&self) -> std::option::Option<&str> {
        self.creation_date.as_deref()
    }
    /// <p>The date when the monitor was last updated. </p>
    pub fn last_updated_date(&self) -> std::option::Option<&str> {
        self.last_updated_date.as_deref()
    }
    /// <p>The date when the monitor last evaluated for anomalies. </p>
    pub fn last_evaluated_date(&self) -> std::option::Option<&str> {
        self.last_evaluated_date.as_deref()
    }
    /// <p>The possible type values. </p>
    pub fn monitor_type(&self) -> std::option::Option<&crate::model::MonitorType> {
        self.monitor_type.as_ref()
    }
    /// <p>The dimensions to evaluate. </p>
    pub fn monitor_dimension(&self) -> std::option::Option<&crate::model::MonitorDimension> {
        self.monitor_dimension.as_ref()
    }
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub fn monitor_specification(&self) -> std::option::Option<&crate::model::Expression> {
        self.monitor_specification.as_ref()
    }
    /// <p>The value for evaluated dimensions. </p>
    pub fn dimensional_value_count(&self) -> i32 {
        self.dimensional_value_count
    }
}
impl std::fmt::Debug for AnomalyMonitor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyMonitor");
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.field("monitor_name", &self.monitor_name);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("last_updated_date", &self.last_updated_date);
        formatter.field("last_evaluated_date", &self.last_evaluated_date);
        formatter.field("monitor_type", &self.monitor_type);
        formatter.field("monitor_dimension", &self.monitor_dimension);
        formatter.field("monitor_specification", &self.monitor_specification);
        formatter.field("dimensional_value_count", &self.dimensional_value_count);
        formatter.finish()
    }
}
/// See [`AnomalyMonitor`](crate::model::AnomalyMonitor)
pub mod anomaly_monitor {
    /// A builder for [`AnomalyMonitor`](crate::model::AnomalyMonitor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
        pub(crate) monitor_name: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<std::string::String>,
        pub(crate) last_updated_date: std::option::Option<std::string::String>,
        pub(crate) last_evaluated_date: std::option::Option<std::string::String>,
        pub(crate) monitor_type: std::option::Option<crate::model::MonitorType>,
        pub(crate) monitor_dimension: std::option::Option<crate::model::MonitorDimension>,
        pub(crate) monitor_specification: std::option::Option<crate::model::Expression>,
        pub(crate) dimensional_value_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) value. </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) value. </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// <p>The name of the monitor. </p>
        pub fn monitor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_name = Some(input.into());
            self
        }
        /// <p>The name of the monitor. </p>
        pub fn set_monitor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_name = input;
            self
        }
        /// <p>The date when the monitor was created. </p>
        pub fn creation_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.creation_date = Some(input.into());
            self
        }
        /// <p>The date when the monitor was created. </p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date when the monitor was last updated. </p>
        pub fn last_updated_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_updated_date = Some(input.into());
            self
        }
        /// <p>The date when the monitor was last updated. </p>
        pub fn set_last_updated_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_updated_date = input;
            self
        }
        /// <p>The date when the monitor last evaluated for anomalies. </p>
        pub fn last_evaluated_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_evaluated_date = Some(input.into());
            self
        }
        /// <p>The date when the monitor last evaluated for anomalies. </p>
        pub fn set_last_evaluated_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_evaluated_date = input;
            self
        }
        /// <p>The possible type values. </p>
        pub fn monitor_type(mut self, input: crate::model::MonitorType) -> Self {
            self.monitor_type = Some(input);
            self
        }
        /// <p>The possible type values. </p>
        pub fn set_monitor_type(
            mut self,
            input: std::option::Option<crate::model::MonitorType>,
        ) -> Self {
            self.monitor_type = input;
            self
        }
        /// <p>The dimensions to evaluate. </p>
        pub fn monitor_dimension(mut self, input: crate::model::MonitorDimension) -> Self {
            self.monitor_dimension = Some(input);
            self
        }
        /// <p>The dimensions to evaluate. </p>
        pub fn set_monitor_dimension(
            mut self,
            input: std::option::Option<crate::model::MonitorDimension>,
        ) -> Self {
            self.monitor_dimension = input;
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn monitor_specification(mut self, input: crate::model::Expression) -> Self {
            self.monitor_specification = Some(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_monitor_specification(
            mut self,
            input: std::option::Option<crate::model::Expression>,
        ) -> Self {
            self.monitor_specification = input;
            self
        }
        /// <p>The value for evaluated dimensions. </p>
        pub fn dimensional_value_count(mut self, input: i32) -> Self {
            self.dimensional_value_count = Some(input);
            self
        }
        /// <p>The value for evaluated dimensions. </p>
        pub fn set_dimensional_value_count(mut self, input: std::option::Option<i32>) -> Self {
            self.dimensional_value_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyMonitor`](crate::model::AnomalyMonitor)
        pub fn build(self) -> crate::model::AnomalyMonitor {
            crate::model::AnomalyMonitor {
                monitor_arn: self.monitor_arn,
                monitor_name: self.monitor_name,
                creation_date: self.creation_date,
                last_updated_date: self.last_updated_date,
                last_evaluated_date: self.last_evaluated_date,
                monitor_type: self.monitor_type,
                monitor_dimension: self.monitor_dimension,
                monitor_specification: self.monitor_specification,
                dimensional_value_count: self.dimensional_value_count.unwrap_or_default(),
            }
        }
    }
}
impl AnomalyMonitor {
    /// Creates a new builder-style object to manufacture [`AnomalyMonitor`](crate::model::AnomalyMonitor)
    pub fn builder() -> crate::model::anomaly_monitor::Builder {
        crate::model::anomaly_monitor::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MonitorDimension {
    #[allow(missing_docs)] // documentation missing in model
    Service,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MonitorDimension {
    fn from(s: &str) -> Self {
        match s {
            "SERVICE" => MonitorDimension::Service,
            other => MonitorDimension::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MonitorDimension {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MonitorDimension::from(s))
    }
}
impl MonitorDimension {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MonitorDimension::Service => "SERVICE",
            MonitorDimension::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SERVICE"]
    }
}
impl AsRef<str> for MonitorDimension {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MonitorType {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    Dimensional,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MonitorType {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => MonitorType::Custom,
            "DIMENSIONAL" => MonitorType::Dimensional,
            other => MonitorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MonitorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MonitorType::from(s))
    }
}
impl MonitorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MonitorType::Custom => "CUSTOM",
            MonitorType::Dimensional => "DIMENSIONAL",
            MonitorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOM", "DIMENSIONAL"]
    }
}
impl AsRef<str> for MonitorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An unusual cost pattern. This consists of the detailed metadata and the current status of the anomaly object. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Anomaly {
    /// <p>The unique identifier for the anomaly. </p>
    pub anomaly_id: std::option::Option<std::string::String>,
    /// <p>The first day the anomaly is detected. </p>
    pub anomaly_start_date: std::option::Option<std::string::String>,
    /// <p>The last day the anomaly is detected. </p>
    pub anomaly_end_date: std::option::Option<std::string::String>,
    /// <p>The dimension for the anomaly (for example, an Amazon Web Services service in a service monitor). </p>
    pub dimension_value: std::option::Option<std::string::String>,
    /// <p>The list of identified root causes for the anomaly. </p>
    pub root_causes: std::option::Option<std::vec::Vec<crate::model::RootCause>>,
    /// <p>The latest and maximum score for the anomaly. </p>
    pub anomaly_score: std::option::Option<crate::model::AnomalyScore>,
    /// <p>The dollar impact for the anomaly. </p>
    pub impact: std::option::Option<crate::model::Impact>,
    /// <p>The Amazon Resource Name (ARN) for the cost monitor that generated this anomaly. </p>
    pub monitor_arn: std::option::Option<std::string::String>,
    /// <p>The feedback value. </p>
    pub feedback: std::option::Option<crate::model::AnomalyFeedbackType>,
}
impl Anomaly {
    /// <p>The unique identifier for the anomaly. </p>
    pub fn anomaly_id(&self) -> std::option::Option<&str> {
        self.anomaly_id.as_deref()
    }
    /// <p>The first day the anomaly is detected. </p>
    pub fn anomaly_start_date(&self) -> std::option::Option<&str> {
        self.anomaly_start_date.as_deref()
    }
    /// <p>The last day the anomaly is detected. </p>
    pub fn anomaly_end_date(&self) -> std::option::Option<&str> {
        self.anomaly_end_date.as_deref()
    }
    /// <p>The dimension for the anomaly (for example, an Amazon Web Services service in a service monitor). </p>
    pub fn dimension_value(&self) -> std::option::Option<&str> {
        self.dimension_value.as_deref()
    }
    /// <p>The list of identified root causes for the anomaly. </p>
    pub fn root_causes(&self) -> std::option::Option<&[crate::model::RootCause]> {
        self.root_causes.as_deref()
    }
    /// <p>The latest and maximum score for the anomaly. </p>
    pub fn anomaly_score(&self) -> std::option::Option<&crate::model::AnomalyScore> {
        self.anomaly_score.as_ref()
    }
    /// <p>The dollar impact for the anomaly. </p>
    pub fn impact(&self) -> std::option::Option<&crate::model::Impact> {
        self.impact.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the cost monitor that generated this anomaly. </p>
    pub fn monitor_arn(&self) -> std::option::Option<&str> {
        self.monitor_arn.as_deref()
    }
    /// <p>The feedback value. </p>
    pub fn feedback(&self) -> std::option::Option<&crate::model::AnomalyFeedbackType> {
        self.feedback.as_ref()
    }
}
impl std::fmt::Debug for Anomaly {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Anomaly");
        formatter.field("anomaly_id", &self.anomaly_id);
        formatter.field("anomaly_start_date", &self.anomaly_start_date);
        formatter.field("anomaly_end_date", &self.anomaly_end_date);
        formatter.field("dimension_value", &self.dimension_value);
        formatter.field("root_causes", &self.root_causes);
        formatter.field("anomaly_score", &self.anomaly_score);
        formatter.field("impact", &self.impact);
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.field("feedback", &self.feedback);
        formatter.finish()
    }
}
/// See [`Anomaly`](crate::model::Anomaly)
pub mod anomaly {
    /// A builder for [`Anomaly`](crate::model::Anomaly)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_id: std::option::Option<std::string::String>,
        pub(crate) anomaly_start_date: std::option::Option<std::string::String>,
        pub(crate) anomaly_end_date: std::option::Option<std::string::String>,
        pub(crate) dimension_value: std::option::Option<std::string::String>,
        pub(crate) root_causes: std::option::Option<std::vec::Vec<crate::model::RootCause>>,
        pub(crate) anomaly_score: std::option::Option<crate::model::AnomalyScore>,
        pub(crate) impact: std::option::Option<crate::model::Impact>,
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
        pub(crate) feedback: std::option::Option<crate::model::AnomalyFeedbackType>,
    }
    impl Builder {
        /// <p>The unique identifier for the anomaly. </p>
        pub fn anomaly_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the anomaly. </p>
        pub fn set_anomaly_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.anomaly_id = input;
            self
        }
        /// <p>The first day the anomaly is detected. </p>
        pub fn anomaly_start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_start_date = Some(input.into());
            self
        }
        /// <p>The first day the anomaly is detected. </p>
        pub fn set_anomaly_start_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_start_date = input;
            self
        }
        /// <p>The last day the anomaly is detected. </p>
        pub fn anomaly_end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_end_date = Some(input.into());
            self
        }
        /// <p>The last day the anomaly is detected. </p>
        pub fn set_anomaly_end_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_end_date = input;
            self
        }
        /// <p>The dimension for the anomaly (for example, an Amazon Web Services service in a service monitor). </p>
        pub fn dimension_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension_value = Some(input.into());
            self
        }
        /// <p>The dimension for the anomaly (for example, an Amazon Web Services service in a service monitor). </p>
        pub fn set_dimension_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dimension_value = input;
            self
        }
        /// Appends an item to `root_causes`.
        ///
        /// To override the contents of this collection use [`set_root_causes`](Self::set_root_causes).
        ///
        /// <p>The list of identified root causes for the anomaly. </p>
        pub fn root_causes(mut self, input: crate::model::RootCause) -> Self {
            let mut v = self.root_causes.unwrap_or_default();
            v.push(input);
            self.root_causes = Some(v);
            self
        }
        /// <p>The list of identified root causes for the anomaly. </p>
        pub fn set_root_causes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RootCause>>,
        ) -> Self {
            self.root_causes = input;
            self
        }
        /// <p>The latest and maximum score for the anomaly. </p>
        pub fn anomaly_score(mut self, input: crate::model::AnomalyScore) -> Self {
            self.anomaly_score = Some(input);
            self
        }
        /// <p>The latest and maximum score for the anomaly. </p>
        pub fn set_anomaly_score(
            mut self,
            input: std::option::Option<crate::model::AnomalyScore>,
        ) -> Self {
            self.anomaly_score = input;
            self
        }
        /// <p>The dollar impact for the anomaly. </p>
        pub fn impact(mut self, input: crate::model::Impact) -> Self {
            self.impact = Some(input);
            self
        }
        /// <p>The dollar impact for the anomaly. </p>
        pub fn set_impact(mut self, input: std::option::Option<crate::model::Impact>) -> Self {
            self.impact = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cost monitor that generated this anomaly. </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the cost monitor that generated this anomaly. </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// <p>The feedback value. </p>
        pub fn feedback(mut self, input: crate::model::AnomalyFeedbackType) -> Self {
            self.feedback = Some(input);
            self
        }
        /// <p>The feedback value. </p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyFeedbackType>,
        ) -> Self {
            self.feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`Anomaly`](crate::model::Anomaly)
        pub fn build(self) -> crate::model::Anomaly {
            crate::model::Anomaly {
                anomaly_id: self.anomaly_id,
                anomaly_start_date: self.anomaly_start_date,
                anomaly_end_date: self.anomaly_end_date,
                dimension_value: self.dimension_value,
                root_causes: self.root_causes,
                anomaly_score: self.anomaly_score,
                impact: self.impact,
                monitor_arn: self.monitor_arn,
                feedback: self.feedback,
            }
        }
    }
}
impl Anomaly {
    /// Creates a new builder-style object to manufacture [`Anomaly`](crate::model::Anomaly)
    pub fn builder() -> crate::model::anomaly::Builder {
        crate::model::anomaly::Builder::default()
    }
}

/// <p>The dollar value of the anomaly. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Impact {
    /// <p>The maximum dollar value that's observed for an anomaly. </p>
    pub max_impact: f64,
    /// <p>The cumulative dollar value that's observed for an anomaly. </p>
    pub total_impact: f64,
}
impl Impact {
    /// <p>The maximum dollar value that's observed for an anomaly. </p>
    pub fn max_impact(&self) -> f64 {
        self.max_impact
    }
    /// <p>The cumulative dollar value that's observed for an anomaly. </p>
    pub fn total_impact(&self) -> f64 {
        self.total_impact
    }
}
impl std::fmt::Debug for Impact {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Impact");
        formatter.field("max_impact", &self.max_impact);
        formatter.field("total_impact", &self.total_impact);
        formatter.finish()
    }
}
/// See [`Impact`](crate::model::Impact)
pub mod impact {
    /// A builder for [`Impact`](crate::model::Impact)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_impact: std::option::Option<f64>,
        pub(crate) total_impact: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The maximum dollar value that's observed for an anomaly. </p>
        pub fn max_impact(mut self, input: f64) -> Self {
            self.max_impact = Some(input);
            self
        }
        /// <p>The maximum dollar value that's observed for an anomaly. </p>
        pub fn set_max_impact(mut self, input: std::option::Option<f64>) -> Self {
            self.max_impact = input;
            self
        }
        /// <p>The cumulative dollar value that's observed for an anomaly. </p>
        pub fn total_impact(mut self, input: f64) -> Self {
            self.total_impact = Some(input);
            self
        }
        /// <p>The cumulative dollar value that's observed for an anomaly. </p>
        pub fn set_total_impact(mut self, input: std::option::Option<f64>) -> Self {
            self.total_impact = input;
            self
        }
        /// Consumes the builder and constructs a [`Impact`](crate::model::Impact)
        pub fn build(self) -> crate::model::Impact {
            crate::model::Impact {
                max_impact: self.max_impact.unwrap_or_default(),
                total_impact: self.total_impact.unwrap_or_default(),
            }
        }
    }
}
impl Impact {
    /// Creates a new builder-style object to manufacture [`Impact`](crate::model::Impact)
    pub fn builder() -> crate::model::impact::Builder {
        crate::model::impact::Builder::default()
    }
}

/// <p>Quantifies the anomaly. The higher score means that it's more anomalous. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyScore {
    /// <p>The maximum score that's observed during the <code>AnomalyDateInterval</code>. </p>
    pub max_score: f64,
    /// <p>The last observed score. </p>
    pub current_score: f64,
}
impl AnomalyScore {
    /// <p>The maximum score that's observed during the <code>AnomalyDateInterval</code>. </p>
    pub fn max_score(&self) -> f64 {
        self.max_score
    }
    /// <p>The last observed score. </p>
    pub fn current_score(&self) -> f64 {
        self.current_score
    }
}
impl std::fmt::Debug for AnomalyScore {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyScore");
        formatter.field("max_score", &self.max_score);
        formatter.field("current_score", &self.current_score);
        formatter.finish()
    }
}
/// See [`AnomalyScore`](crate::model::AnomalyScore)
pub mod anomaly_score {
    /// A builder for [`AnomalyScore`](crate::model::AnomalyScore)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_score: std::option::Option<f64>,
        pub(crate) current_score: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The maximum score that's observed during the <code>AnomalyDateInterval</code>. </p>
        pub fn max_score(mut self, input: f64) -> Self {
            self.max_score = Some(input);
            self
        }
        /// <p>The maximum score that's observed during the <code>AnomalyDateInterval</code>. </p>
        pub fn set_max_score(mut self, input: std::option::Option<f64>) -> Self {
            self.max_score = input;
            self
        }
        /// <p>The last observed score. </p>
        pub fn current_score(mut self, input: f64) -> Self {
            self.current_score = Some(input);
            self
        }
        /// <p>The last observed score. </p>
        pub fn set_current_score(mut self, input: std::option::Option<f64>) -> Self {
            self.current_score = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyScore`](crate::model::AnomalyScore)
        pub fn build(self) -> crate::model::AnomalyScore {
            crate::model::AnomalyScore {
                max_score: self.max_score.unwrap_or_default(),
                current_score: self.current_score.unwrap_or_default(),
            }
        }
    }
}
impl AnomalyScore {
    /// Creates a new builder-style object to manufacture [`AnomalyScore`](crate::model::AnomalyScore)
    pub fn builder() -> crate::model::anomaly_score::Builder {
        crate::model::anomaly_score::Builder::default()
    }
}

/// <p>The combination of Amazon Web Services service, linked account, Region, and usage type where a cost anomaly is observed. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RootCause {
    /// <p>The Amazon Web Services service name that's associated with the cost anomaly. </p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region that's associated with the cost anomaly. </p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The member account value that's associated with the cost anomaly. </p>
    pub linked_account: std::option::Option<std::string::String>,
    /// <p>The <code>UsageType</code> value that's associated with the cost anomaly. </p>
    pub usage_type: std::option::Option<std::string::String>,
}
impl RootCause {
    /// <p>The Amazon Web Services service name that's associated with the cost anomaly. </p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p>The Amazon Web Services Region that's associated with the cost anomaly. </p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The member account value that's associated with the cost anomaly. </p>
    pub fn linked_account(&self) -> std::option::Option<&str> {
        self.linked_account.as_deref()
    }
    /// <p>The <code>UsageType</code> value that's associated with the cost anomaly. </p>
    pub fn usage_type(&self) -> std::option::Option<&str> {
        self.usage_type.as_deref()
    }
}
impl std::fmt::Debug for RootCause {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RootCause");
        formatter.field("service", &self.service);
        formatter.field("region", &self.region);
        formatter.field("linked_account", &self.linked_account);
        formatter.field("usage_type", &self.usage_type);
        formatter.finish()
    }
}
/// See [`RootCause`](crate::model::RootCause)
pub mod root_cause {
    /// A builder for [`RootCause`](crate::model::RootCause)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) linked_account: std::option::Option<std::string::String>,
        pub(crate) usage_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services service name that's associated with the cost anomaly. </p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services service name that's associated with the cost anomaly. </p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The Amazon Web Services Region that's associated with the cost anomaly. </p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region that's associated with the cost anomaly. </p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The member account value that's associated with the cost anomaly. </p>
        pub fn linked_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.linked_account = Some(input.into());
            self
        }
        /// <p>The member account value that's associated with the cost anomaly. </p>
        pub fn set_linked_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.linked_account = input;
            self
        }
        /// <p>The <code>UsageType</code> value that's associated with the cost anomaly. </p>
        pub fn usage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_type = Some(input.into());
            self
        }
        /// <p>The <code>UsageType</code> value that's associated with the cost anomaly. </p>
        pub fn set_usage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.usage_type = input;
            self
        }
        /// Consumes the builder and constructs a [`RootCause`](crate::model::RootCause)
        pub fn build(self) -> crate::model::RootCause {
            crate::model::RootCause {
                service: self.service,
                region: self.region,
                linked_account: self.linked_account,
                usage_type: self.usage_type,
            }
        }
    }
}
impl RootCause {
    /// Creates a new builder-style object to manufacture [`RootCause`](crate::model::RootCause)
    pub fn builder() -> crate::model::root_cause::Builder {
        crate::model::root_cause::Builder::default()
    }
}

/// <p>Filters cost anomalies based on the total impact. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TotalImpactFilter {
    /// <p>The comparing value that's used in the filter. </p>
    pub numeric_operator: std::option::Option<crate::model::NumericOperator>,
    /// <p>The lower bound dollar value that's used in the filter. </p>
    pub start_value: f64,
    /// <p>The upper bound dollar value that's used in the filter. </p>
    pub end_value: f64,
}
impl TotalImpactFilter {
    /// <p>The comparing value that's used in the filter. </p>
    pub fn numeric_operator(&self) -> std::option::Option<&crate::model::NumericOperator> {
        self.numeric_operator.as_ref()
    }
    /// <p>The lower bound dollar value that's used in the filter. </p>
    pub fn start_value(&self) -> f64 {
        self.start_value
    }
    /// <p>The upper bound dollar value that's used in the filter. </p>
    pub fn end_value(&self) -> f64 {
        self.end_value
    }
}
impl std::fmt::Debug for TotalImpactFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TotalImpactFilter");
        formatter.field("numeric_operator", &self.numeric_operator);
        formatter.field("start_value", &self.start_value);
        formatter.field("end_value", &self.end_value);
        formatter.finish()
    }
}
/// See [`TotalImpactFilter`](crate::model::TotalImpactFilter)
pub mod total_impact_filter {
    /// A builder for [`TotalImpactFilter`](crate::model::TotalImpactFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) numeric_operator: std::option::Option<crate::model::NumericOperator>,
        pub(crate) start_value: std::option::Option<f64>,
        pub(crate) end_value: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The comparing value that's used in the filter. </p>
        pub fn numeric_operator(mut self, input: crate::model::NumericOperator) -> Self {
            self.numeric_operator = Some(input);
            self
        }
        /// <p>The comparing value that's used in the filter. </p>
        pub fn set_numeric_operator(
            mut self,
            input: std::option::Option<crate::model::NumericOperator>,
        ) -> Self {
            self.numeric_operator = input;
            self
        }
        /// <p>The lower bound dollar value that's used in the filter. </p>
        pub fn start_value(mut self, input: f64) -> Self {
            self.start_value = Some(input);
            self
        }
        /// <p>The lower bound dollar value that's used in the filter. </p>
        pub fn set_start_value(mut self, input: std::option::Option<f64>) -> Self {
            self.start_value = input;
            self
        }
        /// <p>The upper bound dollar value that's used in the filter. </p>
        pub fn end_value(mut self, input: f64) -> Self {
            self.end_value = Some(input);
            self
        }
        /// <p>The upper bound dollar value that's used in the filter. </p>
        pub fn set_end_value(mut self, input: std::option::Option<f64>) -> Self {
            self.end_value = input;
            self
        }
        /// Consumes the builder and constructs a [`TotalImpactFilter`](crate::model::TotalImpactFilter)
        pub fn build(self) -> crate::model::TotalImpactFilter {
            crate::model::TotalImpactFilter {
                numeric_operator: self.numeric_operator,
                start_value: self.start_value.unwrap_or_default(),
                end_value: self.end_value.unwrap_or_default(),
            }
        }
    }
}
impl TotalImpactFilter {
    /// Creates a new builder-style object to manufacture [`TotalImpactFilter`](crate::model::TotalImpactFilter)
    pub fn builder() -> crate::model::total_impact_filter::Builder {
        crate::model::total_impact_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NumericOperator {
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Equal,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqual,
    #[allow(missing_docs)] // documentation missing in model
    LessThan,
    #[allow(missing_docs)] // documentation missing in model
    LessThanOrEqual,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NumericOperator {
    fn from(s: &str) -> Self {
        match s {
            "BETWEEN" => NumericOperator::Between,
            "EQUAL" => NumericOperator::Equal,
            "GREATER_THAN" => NumericOperator::GreaterThan,
            "GREATER_THAN_OR_EQUAL" => NumericOperator::GreaterThanOrEqual,
            "LESS_THAN" => NumericOperator::LessThan,
            "LESS_THAN_OR_EQUAL" => NumericOperator::LessThanOrEqual,
            other => NumericOperator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NumericOperator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NumericOperator::from(s))
    }
}
impl NumericOperator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NumericOperator::Between => "BETWEEN",
            NumericOperator::Equal => "EQUAL",
            NumericOperator::GreaterThan => "GREATER_THAN",
            NumericOperator::GreaterThanOrEqual => "GREATER_THAN_OR_EQUAL",
            NumericOperator::LessThan => "LESS_THAN",
            NumericOperator::LessThanOrEqual => "LESS_THAN_OR_EQUAL",
            NumericOperator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BETWEEN",
            "EQUAL",
            "GREATER_THAN",
            "GREATER_THAN_OR_EQUAL",
            "LESS_THAN",
            "LESS_THAN_OR_EQUAL",
        ]
    }
}
impl AsRef<str> for NumericOperator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The time period for an anomaly. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AnomalyDateInterval {
    /// <p>The first date an anomaly was observed. </p>
    pub start_date: std::option::Option<std::string::String>,
    /// <p>The last date an anomaly was observed. </p>
    pub end_date: std::option::Option<std::string::String>,
}
impl AnomalyDateInterval {
    /// <p>The first date an anomaly was observed. </p>
    pub fn start_date(&self) -> std::option::Option<&str> {
        self.start_date.as_deref()
    }
    /// <p>The last date an anomaly was observed. </p>
    pub fn end_date(&self) -> std::option::Option<&str> {
        self.end_date.as_deref()
    }
}
impl std::fmt::Debug for AnomalyDateInterval {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AnomalyDateInterval");
        formatter.field("start_date", &self.start_date);
        formatter.field("end_date", &self.end_date);
        formatter.finish()
    }
}
/// See [`AnomalyDateInterval`](crate::model::AnomalyDateInterval)
pub mod anomaly_date_interval {
    /// A builder for [`AnomalyDateInterval`](crate::model::AnomalyDateInterval)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) start_date: std::option::Option<std::string::String>,
        pub(crate) end_date: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The first date an anomaly was observed. </p>
        pub fn start_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_date = Some(input.into());
            self
        }
        /// <p>The first date an anomaly was observed. </p>
        pub fn set_start_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_date = input;
            self
        }
        /// <p>The last date an anomaly was observed. </p>
        pub fn end_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_date = Some(input.into());
            self
        }
        /// <p>The last date an anomaly was observed. </p>
        pub fn set_end_date(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_date = input;
            self
        }
        /// Consumes the builder and constructs a [`AnomalyDateInterval`](crate::model::AnomalyDateInterval)
        pub fn build(self) -> crate::model::AnomalyDateInterval {
            crate::model::AnomalyDateInterval {
                start_date: self.start_date,
                end_date: self.end_date,
            }
        }
    }
}
impl AnomalyDateInterval {
    /// Creates a new builder-style object to manufacture [`AnomalyDateInterval`](crate::model::AnomalyDateInterval)
    pub fn builder() -> crate::model::anomaly_date_interval::Builder {
        crate::model::anomaly_date_interval::Builder::default()
    }
}

/// <p>The structure of Cost Categories. This includes detailed metadata and the set of rules for the <code>CostCategory</code> object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CostCategory {
    /// <p>The unique identifier for your Cost Category. </p>
    pub cost_category_arn: std::option::Option<std::string::String>,
    /// <p>The effective state data of your Cost Category.</p>
    pub effective_start: std::option::Option<std::string::String>,
    /// <p> The effective end data of your Cost Category.</p>
    pub effective_end: std::option::Option<std::string::String>,
    /// <p>The unique name of the Cost Category.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The rule schema version in this particular Cost Category.</p>
    pub rule_version: std::option::Option<crate::model::CostCategoryRuleVersion>,
    /// <p>The rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value. </p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
    /// <p> The split charge rules that are used to allocate your charges between your Cost Category values. </p>
    pub split_charge_rules:
        std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
    /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
    pub processing_status:
        std::option::Option<std::vec::Vec<crate::model::CostCategoryProcessingStatus>>,
    /// <p>The default value for the cost category.</p>
    pub default_value: std::option::Option<std::string::String>,
}
impl CostCategory {
    /// <p>The unique identifier for your Cost Category. </p>
    pub fn cost_category_arn(&self) -> std::option::Option<&str> {
        self.cost_category_arn.as_deref()
    }
    /// <p>The effective state data of your Cost Category.</p>
    pub fn effective_start(&self) -> std::option::Option<&str> {
        self.effective_start.as_deref()
    }
    /// <p> The effective end data of your Cost Category.</p>
    pub fn effective_end(&self) -> std::option::Option<&str> {
        self.effective_end.as_deref()
    }
    /// <p>The unique name of the Cost Category.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The rule schema version in this particular Cost Category.</p>
    pub fn rule_version(&self) -> std::option::Option<&crate::model::CostCategoryRuleVersion> {
        self.rule_version.as_ref()
    }
    /// <p>The rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value. </p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::CostCategoryRule]> {
        self.rules.as_deref()
    }
    /// <p> The split charge rules that are used to allocate your charges between your Cost Category values. </p>
    pub fn split_charge_rules(
        &self,
    ) -> std::option::Option<&[crate::model::CostCategorySplitChargeRule]> {
        self.split_charge_rules.as_deref()
    }
    /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
    pub fn processing_status(
        &self,
    ) -> std::option::Option<&[crate::model::CostCategoryProcessingStatus]> {
        self.processing_status.as_deref()
    }
    /// <p>The default value for the cost category.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
}
impl std::fmt::Debug for CostCategory {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CostCategory");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.field("effective_start", &self.effective_start);
        formatter.field("effective_end", &self.effective_end);
        formatter.field("name", &self.name);
        formatter.field("rule_version", &self.rule_version);
        formatter.field("rules", &self.rules);
        formatter.field("split_charge_rules", &self.split_charge_rules);
        formatter.field("processing_status", &self.processing_status);
        formatter.field("default_value", &self.default_value);
        formatter.finish()
    }
}
/// See [`CostCategory`](crate::model::CostCategory)
pub mod cost_category {
    /// A builder for [`CostCategory`](crate::model::CostCategory)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
        pub(crate) effective_start: std::option::Option<std::string::String>,
        pub(crate) effective_end: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_version: std::option::Option<crate::model::CostCategoryRuleVersion>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        pub(crate) split_charge_rules:
            std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
        pub(crate) processing_status:
            std::option::Option<std::vec::Vec<crate::model::CostCategoryProcessingStatus>>,
        pub(crate) default_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for your Cost Category. </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for your Cost Category. </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// <p>The effective state data of your Cost Category.</p>
        pub fn effective_start(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_start = Some(input.into());
            self
        }
        /// <p>The effective state data of your Cost Category.</p>
        pub fn set_effective_start(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_start = input;
            self
        }
        /// <p> The effective end data of your Cost Category.</p>
        pub fn effective_end(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_end = Some(input.into());
            self
        }
        /// <p> The effective end data of your Cost Category.</p>
        pub fn set_effective_end(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_end = input;
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn rule_version(mut self, input: crate::model::CostCategoryRuleVersion) -> Self {
            self.rule_version = Some(input);
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn set_rule_version(
            mut self,
            input: std::option::Option<crate::model::CostCategoryRuleVersion>,
        ) -> Self {
            self.rule_version = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value. </p>
        pub fn rules(mut self, input: crate::model::CostCategoryRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The rules are processed in order. If there are multiple rules that match the line item, then the first rule to match is used to determine that Cost Category value. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// Appends an item to `split_charge_rules`.
        ///
        /// To override the contents of this collection use [`set_split_charge_rules`](Self::set_split_charge_rules).
        ///
        /// <p> The split charge rules that are used to allocate your charges between your Cost Category values. </p>
        pub fn split_charge_rules(
            mut self,
            input: crate::model::CostCategorySplitChargeRule,
        ) -> Self {
            let mut v = self.split_charge_rules.unwrap_or_default();
            v.push(input);
            self.split_charge_rules = Some(v);
            self
        }
        /// <p> The split charge rules that are used to allocate your charges between your Cost Category values. </p>
        pub fn set_split_charge_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
        ) -> Self {
            self.split_charge_rules = input;
            self
        }
        /// Appends an item to `processing_status`.
        ///
        /// To override the contents of this collection use [`set_processing_status`](Self::set_processing_status).
        ///
        /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
        pub fn processing_status(
            mut self,
            input: crate::model::CostCategoryProcessingStatus,
        ) -> Self {
            let mut v = self.processing_status.unwrap_or_default();
            v.push(input);
            self.processing_status = Some(v);
            self
        }
        /// <p>The list of processing statuses for Cost Management products for a specific cost category. </p>
        pub fn set_processing_status(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryProcessingStatus>>,
        ) -> Self {
            self.processing_status = input;
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Consumes the builder and constructs a [`CostCategory`](crate::model::CostCategory)
        pub fn build(self) -> crate::model::CostCategory {
            crate::model::CostCategory {
                cost_category_arn: self.cost_category_arn,
                effective_start: self.effective_start,
                effective_end: self.effective_end,
                name: self.name,
                rule_version: self.rule_version,
                rules: self.rules,
                split_charge_rules: self.split_charge_rules,
                processing_status: self.processing_status,
                default_value: self.default_value,
            }
        }
    }
}
impl CostCategory {
    /// Creates a new builder-style object to manufacture [`CostCategory`](crate::model::CostCategory)
    pub fn builder() -> crate::model::cost_category::Builder {
        crate::model::cost_category::Builder::default()
    }
}
