// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateAnomalyMonitorInput`](crate::input::CreateAnomalyMonitorInput)
pub mod create_anomaly_monitor_input {
    /// A builder for [`CreateAnomalyMonitorInput`](crate::input::CreateAnomalyMonitorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_monitor: std::option::Option<crate::model::AnomalyMonitor>,
    }
    impl Builder {
        /// <p>The cost anomaly detection monitor object that you want to create.</p>
        pub fn anomaly_monitor(mut self, input: crate::model::AnomalyMonitor) -> Self {
            self.anomaly_monitor = Some(input);
            self
        }
        /// <p>The cost anomaly detection monitor object that you want to create.</p>
        pub fn set_anomaly_monitor(
            mut self,
            input: std::option::Option<crate::model::AnomalyMonitor>,
        ) -> Self {
            self.anomaly_monitor = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnomalyMonitorInput`](crate::input::CreateAnomalyMonitorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAnomalyMonitorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAnomalyMonitorInput {
                anomaly_monitor: self.anomaly_monitor,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAnomalyMonitorInputOperationOutputAlias = crate::operation::CreateAnomalyMonitor;
#[doc(hidden)]
pub type CreateAnomalyMonitorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAnomalyMonitorInput {
    /// Consumes the builder and constructs an Operation<[`CreateAnomalyMonitor`](crate::operation::CreateAnomalyMonitor)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAnomalyMonitor,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAnomalyMonitorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAnomalyMonitorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAnomalyMonitorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.CreateAnomalyMonitor",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_anomaly_monitor(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAnomalyMonitor::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAnomalyMonitor",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAnomalyMonitorInput`](crate::input::CreateAnomalyMonitorInput)
    pub fn builder() -> crate::input::create_anomaly_monitor_input::Builder {
        crate::input::create_anomaly_monitor_input::Builder::default()
    }
}

/// See [`CreateAnomalySubscriptionInput`](crate::input::CreateAnomalySubscriptionInput)
pub mod create_anomaly_subscription_input {
    /// A builder for [`CreateAnomalySubscriptionInput`](crate::input::CreateAnomalySubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_subscription: std::option::Option<crate::model::AnomalySubscription>,
    }
    impl Builder {
        /// <p>The cost anomaly subscription object that you want to create. </p>
        pub fn anomaly_subscription(mut self, input: crate::model::AnomalySubscription) -> Self {
            self.anomaly_subscription = Some(input);
            self
        }
        /// <p>The cost anomaly subscription object that you want to create. </p>
        pub fn set_anomaly_subscription(
            mut self,
            input: std::option::Option<crate::model::AnomalySubscription>,
        ) -> Self {
            self.anomaly_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnomalySubscriptionInput`](crate::input::CreateAnomalySubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAnomalySubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAnomalySubscriptionInput {
                anomaly_subscription: self.anomaly_subscription,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAnomalySubscriptionInputOperationOutputAlias =
    crate::operation::CreateAnomalySubscription;
#[doc(hidden)]
pub type CreateAnomalySubscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAnomalySubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateAnomalySubscription`](crate::operation::CreateAnomalySubscription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAnomalySubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAnomalySubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAnomalySubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAnomalySubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.CreateAnomalySubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_anomaly_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAnomalySubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAnomalySubscription",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAnomalySubscriptionInput`](crate::input::CreateAnomalySubscriptionInput)
    pub fn builder() -> crate::input::create_anomaly_subscription_input::Builder {
        crate::input::create_anomaly_subscription_input::Builder::default()
    }
}

/// See [`CreateCostCategoryDefinitionInput`](crate::input::CreateCostCategoryDefinitionInput)
pub mod create_cost_category_definition_input {
    /// A builder for [`CreateCostCategoryDefinitionInput`](crate::input::CreateCostCategoryDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) rule_version: std::option::Option<crate::model::CostCategoryRuleVersion>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) split_charge_rules:
            std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
    }
    impl Builder {
        /// <p>The unique name of the Cost Category.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn rule_version(mut self, input: crate::model::CostCategoryRuleVersion) -> Self {
            self.rule_version = Some(input);
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn set_rule_version(
            mut self,
            input: std::option::Option<crate::model::CostCategoryRuleVersion>,
        ) -> Self {
            self.rule_version = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The Cost Category rules used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule</a>.</p>
        pub fn rules(mut self, input: crate::model::CostCategoryRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The Cost Category rules used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule</a>.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Appends an item to `split_charge_rules`.
        ///
        /// To override the contents of this collection use [`set_split_charge_rules`](Self::set_split_charge_rules).
        ///
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn split_charge_rules(
            mut self,
            input: crate::model::CostCategorySplitChargeRule,
        ) -> Self {
            let mut v = self.split_charge_rules.unwrap_or_default();
            v.push(input);
            self.split_charge_rules = Some(v);
            self
        }
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn set_split_charge_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
        ) -> Self {
            self.split_charge_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCostCategoryDefinitionInput`](crate::input::CreateCostCategoryDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCostCategoryDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCostCategoryDefinitionInput {
                name: self.name,
                rule_version: self.rule_version,
                rules: self.rules,
                default_value: self.default_value,
                split_charge_rules: self.split_charge_rules,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCostCategoryDefinitionInputOperationOutputAlias =
    crate::operation::CreateCostCategoryDefinition;
#[doc(hidden)]
pub type CreateCostCategoryDefinitionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateCostCategoryDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`CreateCostCategoryDefinition`](crate::operation::CreateCostCategoryDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCostCategoryDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCostCategoryDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCostCategoryDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCostCategoryDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.CreateCostCategoryDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_cost_category_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCostCategoryDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCostCategoryDefinition",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCostCategoryDefinitionInput`](crate::input::CreateCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::create_cost_category_definition_input::Builder {
        crate::input::create_cost_category_definition_input::Builder::default()
    }
}

/// See [`DeleteAnomalyMonitorInput`](crate::input::DeleteAnomalyMonitorInput)
pub mod delete_anomaly_monitor_input {
    /// A builder for [`DeleteAnomalyMonitorInput`](crate::input::DeleteAnomalyMonitorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the cost anomaly monitor that you want to delete. </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cost anomaly monitor that you want to delete. </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAnomalyMonitorInput`](crate::input::DeleteAnomalyMonitorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAnomalyMonitorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAnomalyMonitorInput {
                monitor_arn: self.monitor_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAnomalyMonitorInputOperationOutputAlias = crate::operation::DeleteAnomalyMonitor;
#[doc(hidden)]
pub type DeleteAnomalyMonitorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAnomalyMonitorInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAnomalyMonitor`](crate::operation::DeleteAnomalyMonitor)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAnomalyMonitor,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAnomalyMonitorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAnomalyMonitorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAnomalyMonitorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.DeleteAnomalyMonitor",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_anomaly_monitor(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAnomalyMonitor::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAnomalyMonitor",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAnomalyMonitorInput`](crate::input::DeleteAnomalyMonitorInput)
    pub fn builder() -> crate::input::delete_anomaly_monitor_input::Builder {
        crate::input::delete_anomaly_monitor_input::Builder::default()
    }
}

/// See [`DeleteAnomalySubscriptionInput`](crate::input::DeleteAnomalySubscriptionInput)
pub mod delete_anomaly_subscription_input {
    /// A builder for [`DeleteAnomalySubscriptionInput`](crate::input::DeleteAnomalySubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the cost anomaly subscription that you want to delete. </p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cost anomaly subscription that you want to delete. </p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAnomalySubscriptionInput`](crate::input::DeleteAnomalySubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteAnomalySubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteAnomalySubscriptionInput {
                subscription_arn: self.subscription_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteAnomalySubscriptionInputOperationOutputAlias =
    crate::operation::DeleteAnomalySubscription;
#[doc(hidden)]
pub type DeleteAnomalySubscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteAnomalySubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteAnomalySubscription`](crate::operation::DeleteAnomalySubscription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteAnomalySubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteAnomalySubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteAnomalySubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteAnomalySubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.DeleteAnomalySubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_anomaly_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteAnomalySubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteAnomalySubscription",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteAnomalySubscriptionInput`](crate::input::DeleteAnomalySubscriptionInput)
    pub fn builder() -> crate::input::delete_anomaly_subscription_input::Builder {
        crate::input::delete_anomaly_subscription_input::Builder::default()
    }
}

/// See [`DeleteCostCategoryDefinitionInput`](crate::input::DeleteCostCategoryDefinitionInput)
pub mod delete_cost_category_definition_input {
    /// A builder for [`DeleteCostCategoryDefinitionInput`](crate::input::DeleteCostCategoryDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCostCategoryDefinitionInput`](crate::input::DeleteCostCategoryDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCostCategoryDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCostCategoryDefinitionInput {
                cost_category_arn: self.cost_category_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCostCategoryDefinitionInputOperationOutputAlias =
    crate::operation::DeleteCostCategoryDefinition;
#[doc(hidden)]
pub type DeleteCostCategoryDefinitionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCostCategoryDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCostCategoryDefinition`](crate::operation::DeleteCostCategoryDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCostCategoryDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCostCategoryDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCostCategoryDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCostCategoryDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.DeleteCostCategoryDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_cost_category_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCostCategoryDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCostCategoryDefinition",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCostCategoryDefinitionInput`](crate::input::DeleteCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::delete_cost_category_definition_input::Builder {
        crate::input::delete_cost_category_definition_input::Builder::default()
    }
}

/// See [`DescribeCostCategoryDefinitionInput`](crate::input::DescribeCostCategoryDefinitionInput)
pub mod describe_cost_category_definition_input {
    /// A builder for [`DescribeCostCategoryDefinitionInput`](crate::input::DescribeCostCategoryDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
        pub(crate) effective_on: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// <p> The date when the Cost Category was effective. </p>
        pub fn effective_on(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_on = Some(input.into());
            self
        }
        /// <p> The date when the Cost Category was effective. </p>
        pub fn set_effective_on(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.effective_on = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCostCategoryDefinitionInput`](crate::input::DescribeCostCategoryDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCostCategoryDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCostCategoryDefinitionInput {
                cost_category_arn: self.cost_category_arn,
                effective_on: self.effective_on,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCostCategoryDefinitionInputOperationOutputAlias =
    crate::operation::DescribeCostCategoryDefinition;
#[doc(hidden)]
pub type DescribeCostCategoryDefinitionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCostCategoryDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCostCategoryDefinition`](crate::operation::DescribeCostCategoryDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCostCategoryDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeCostCategoryDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeCostCategoryDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeCostCategoryDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.DescribeCostCategoryDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_cost_category_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCostCategoryDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCostCategoryDefinition",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeCostCategoryDefinitionInput`](crate::input::DescribeCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::describe_cost_category_definition_input::Builder {
        crate::input::describe_cost_category_definition_input::Builder::default()
    }
}

/// See [`GetAnomaliesInput`](crate::input::GetAnomaliesInput)
pub mod get_anomalies_input {
    /// A builder for [`GetAnomaliesInput`](crate::input::GetAnomaliesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
        pub(crate) date_interval: std::option::Option<crate::model::AnomalyDateInterval>,
        pub(crate) feedback: std::option::Option<crate::model::AnomalyFeedbackType>,
        pub(crate) total_impact: std::option::Option<crate::model::TotalImpactFilter>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// <p>Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an <code>AnomalyEndDate</code> in the specified time range. </p>
        pub fn date_interval(mut self, input: crate::model::AnomalyDateInterval) -> Self {
            self.date_interval = Some(input);
            self
        }
        /// <p>Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an <code>AnomalyEndDate</code> in the specified time range. </p>
        pub fn set_date_interval(
            mut self,
            input: std::option::Option<crate::model::AnomalyDateInterval>,
        ) -> Self {
            self.date_interval = input;
            self
        }
        /// <p>Filters anomaly results by the feedback field on the anomaly object. </p>
        pub fn feedback(mut self, input: crate::model::AnomalyFeedbackType) -> Self {
            self.feedback = Some(input);
            self
        }
        /// <p>Filters anomaly results by the feedback field on the anomaly object. </p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyFeedbackType>,
        ) -> Self {
            self.feedback = input;
            self
        }
        /// <p>Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200. </p>
        pub fn total_impact(mut self, input: crate::model::TotalImpactFilter) -> Self {
            self.total_impact = Some(input);
            self
        }
        /// <p>Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200. </p>
        pub fn set_total_impact(
            mut self,
            input: std::option::Option<crate::model::TotalImpactFilter>,
        ) -> Self {
            self.total_impact = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomaliesInput`](crate::input::GetAnomaliesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAnomaliesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAnomaliesInput {
                monitor_arn: self.monitor_arn,
                date_interval: self.date_interval,
                feedback: self.feedback,
                total_impact: self.total_impact,
                next_page_token: self.next_page_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAnomaliesInputOperationOutputAlias = crate::operation::GetAnomalies;
#[doc(hidden)]
pub type GetAnomaliesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAnomaliesInput {
    /// Consumes the builder and constructs an Operation<[`GetAnomalies`](crate::operation::GetAnomalies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAnomalies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAnomaliesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAnomaliesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAnomaliesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetAnomalies",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_anomalies(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAnomalies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAnomalies",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAnomaliesInput`](crate::input::GetAnomaliesInput)
    pub fn builder() -> crate::input::get_anomalies_input::Builder {
        crate::input::get_anomalies_input::Builder::default()
    }
}

/// See [`GetAnomalyMonitorsInput`](crate::input::GetAnomalyMonitorsInput)
pub mod get_anomaly_monitors_input {
    /// A builder for [`GetAnomalyMonitorsInput`](crate::input::GetAnomalyMonitorsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `monitor_arn_list`.
        ///
        /// To override the contents of this collection use [`set_monitor_arn_list`](Self::set_monitor_arn_list).
        ///
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn monitor_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.monitor_arn_list.unwrap_or_default();
            v.push(input.into());
            self.monitor_arn_list = Some(v);
            self
        }
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn set_monitor_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.monitor_arn_list = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The number of entries that a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of entries that a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomalyMonitorsInput`](crate::input::GetAnomalyMonitorsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAnomalyMonitorsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAnomalyMonitorsInput {
                monitor_arn_list: self.monitor_arn_list,
                next_page_token: self.next_page_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAnomalyMonitorsInputOperationOutputAlias = crate::operation::GetAnomalyMonitors;
#[doc(hidden)]
pub type GetAnomalyMonitorsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAnomalyMonitorsInput {
    /// Consumes the builder and constructs an Operation<[`GetAnomalyMonitors`](crate::operation::GetAnomalyMonitors)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAnomalyMonitors,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAnomalyMonitorsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAnomalyMonitorsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAnomalyMonitorsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetAnomalyMonitors",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_anomaly_monitors(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAnomalyMonitors::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAnomalyMonitors",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAnomalyMonitorsInput`](crate::input::GetAnomalyMonitorsInput)
    pub fn builder() -> crate::input::get_anomaly_monitors_input::Builder {
        crate::input::get_anomaly_monitors_input::Builder::default()
    }
}

/// See [`GetAnomalySubscriptionsInput`](crate::input::GetAnomalySubscriptionsInput)
pub mod get_anomaly_subscriptions_input {
    /// A builder for [`GetAnomalySubscriptionsInput`](crate::input::GetAnomalySubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `subscription_arn_list`.
        ///
        /// To override the contents of this collection use [`set_subscription_arn_list`](Self::set_subscription_arn_list).
        ///
        /// <p>A list of cost anomaly subscription ARNs. </p>
        pub fn subscription_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subscription_arn_list.unwrap_or_default();
            v.push(input.into());
            self.subscription_arn_list = Some(v);
            self
        }
        /// <p>A list of cost anomaly subscription ARNs. </p>
        pub fn set_subscription_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subscription_arn_list = input;
            self
        }
        /// <p>Cost anomaly monitor ARNs. </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>Cost anomaly monitor ARNs. </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomalySubscriptionsInput`](crate::input::GetAnomalySubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAnomalySubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAnomalySubscriptionsInput {
                subscription_arn_list: self.subscription_arn_list,
                monitor_arn: self.monitor_arn,
                next_page_token: self.next_page_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetAnomalySubscriptionsInputOperationOutputAlias =
    crate::operation::GetAnomalySubscriptions;
#[doc(hidden)]
pub type GetAnomalySubscriptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetAnomalySubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`GetAnomalySubscriptions`](crate::operation::GetAnomalySubscriptions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAnomalySubscriptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAnomalySubscriptionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAnomalySubscriptionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAnomalySubscriptionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetAnomalySubscriptions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_anomaly_subscriptions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAnomalySubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAnomalySubscriptions",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAnomalySubscriptionsInput`](crate::input::GetAnomalySubscriptionsInput)
    pub fn builder() -> crate::input::get_anomaly_subscriptions_input::Builder {
        crate::input::get_anomaly_subscriptions_input::Builder::default()
    }
}

/// See [`GetCostAndUsageInput`](crate::input::GetCostAndUsageInput)
pub mod get_cost_and_usage_input {
    /// A builder for [`GetCostAndUsageInput`](crate::input::GetCostAndUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) metrics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Sets the start date and end date for retrieving Amazon Web Services costs. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>Sets the start date and end date for retrieving Amazon Web Services costs. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking into account the units. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours and GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsage</code> requests.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking into account the units. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours and GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsage</code> requests.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Appends an item to `group_by`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group Amazon Web Services costs using up to two different groups, either dimensions, tag keys, cost categories, or any two group by types.</p>
        /// <p>Valid values for the <code>DIMENSION</code> type are <code>AZ</code>, <code>INSTANCE_TYPE</code>, <code>LEGAL_ENTITY_NAME</code>, <code>LINKED_ACCOUNT</code>, <code>OPERATION</code>, <code>PLATFORM</code>, <code>PURCHASE_TYPE</code>, <code>SERVICE</code>, <code>TENANCY</code>, <code>RECORD_TYPE</code>, and <code>USAGE_TYPE</code>.</p>
        /// <p>When you group by the <code>TAG</code> type and include a valid tag key, you get all tag values, including empty strings.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            let mut v = self.group_by.unwrap_or_default();
            v.push(input);
            self.group_by = Some(v);
            self
        }
        /// <p>You can group Amazon Web Services costs using up to two different groups, either dimensions, tag keys, cost categories, or any two group by types.</p>
        /// <p>Valid values for the <code>DIMENSION</code> type are <code>AZ</code>, <code>INSTANCE_TYPE</code>, <code>LEGAL_ENTITY_NAME</code>, <code>LINKED_ACCOUNT</code>, <code>OPERATION</code>, <code>PLATFORM</code>, <code>PURCHASE_TYPE</code>, <code>SERVICE</code>, <code>TENANCY</code>, <code>RECORD_TYPE</code>, and <code>USAGE_TYPE</code>.</p>
        /// <p>When you group by the <code>TAG</code> type and include a valid tag key, you get all tag values, including empty strings.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostAndUsageInput`](crate::input::GetCostAndUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCostAndUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCostAndUsageInput {
                time_period: self.time_period,
                granularity: self.granularity,
                filter: self.filter,
                metrics: self.metrics,
                group_by: self.group_by,
                next_page_token: self.next_page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCostAndUsageInputOperationOutputAlias = crate::operation::GetCostAndUsage;
#[doc(hidden)]
pub type GetCostAndUsageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCostAndUsageInput {
    /// Consumes the builder and constructs an Operation<[`GetCostAndUsage`](crate::operation::GetCostAndUsage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCostAndUsage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCostAndUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCostAndUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCostAndUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetCostAndUsage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_cost_and_usage(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCostAndUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCostAndUsage",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCostAndUsageInput`](crate::input::GetCostAndUsageInput)
    pub fn builder() -> crate::input::get_cost_and_usage_input::Builder {
        crate::input::get_cost_and_usage_input::Builder::default()
    }
}

/// See [`GetCostAndUsageWithResourcesInput`](crate::input::GetCostAndUsageWithResourcesInput)
pub mod get_cost_and_usage_with_resources_input {
    /// A builder for [`GetCostAndUsageWithResourcesInput`](crate::input::GetCostAndUsageWithResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) metrics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Sets the start and end dates for retrieving Amazon Web Services costs. The range must be within the last 14 days (the start date cannot be earlier than 14 days ago). The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>Sets the start and end dates for retrieving Amazon Web Services costs. The range must be within the last 14 days (the start date cannot be earlier than 14 days ago). The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The <code>GetCostAndUsageWithResources</code> operation requires that you either group by or filter by a <code>ResourceId</code>. It requires the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> <code>"SERVICE = Amazon Elastic Compute Cloud - Compute"</code> in the filter.</p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The <code>GetCostAndUsageWithResources</code> operation requires that you either group by or filter by a <code>ResourceId</code>. It requires the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> <code>"SERVICE = Amazon Elastic Compute Cloud - Compute"</code> in the filter.</p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking the units into account. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours vs. GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsageWithResources</code> requests.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking the units into account. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours vs. GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsageWithResources</code> requests.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// Appends an item to `group_by`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group Amazon Web Services costs using up to two different groups: <code>DIMENSION</code>, <code>TAG</code>, <code>COST_CATEGORY</code>.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            let mut v = self.group_by.unwrap_or_default();
            v.push(input);
            self.group_by = Some(v);
            self
        }
        /// <p>You can group Amazon Web Services costs using up to two different groups: <code>DIMENSION</code>, <code>TAG</code>, <code>COST_CATEGORY</code>.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostAndUsageWithResourcesInput`](crate::input::GetCostAndUsageWithResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCostAndUsageWithResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCostAndUsageWithResourcesInput {
                time_period: self.time_period,
                granularity: self.granularity,
                filter: self.filter,
                metrics: self.metrics,
                group_by: self.group_by,
                next_page_token: self.next_page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCostAndUsageWithResourcesInputOperationOutputAlias =
    crate::operation::GetCostAndUsageWithResources;
#[doc(hidden)]
pub type GetCostAndUsageWithResourcesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetCostAndUsageWithResourcesInput {
    /// Consumes the builder and constructs an Operation<[`GetCostAndUsageWithResources`](crate::operation::GetCostAndUsageWithResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCostAndUsageWithResources,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCostAndUsageWithResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCostAndUsageWithResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCostAndUsageWithResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetCostAndUsageWithResources",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_cost_and_usage_with_resources(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCostAndUsageWithResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCostAndUsageWithResources",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCostAndUsageWithResourcesInput`](crate::input::GetCostAndUsageWithResourcesInput)
    pub fn builder() -> crate::input::get_cost_and_usage_with_resources_input::Builder {
        crate::input::get_cost_and_usage_with_resources_input::Builder::default()
    }
}

/// See [`GetCostCategoriesInput`](crate::input::GetCostCategoriesInput)
pub mod get_cost_categories_input {
    /// A builder for [`GetCostCategoriesInput`](crate::input::GetCostCategoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) search_string: std::option::Option<std::string::String>,
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) cost_category_name: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) sort_by: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value that you want to search the filter values for.</p>
        /// <p>If you do not specify a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category names that match the <code>SearchString</code> pattern. If you do specifiy a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category values that match the <code>SearchString</code> pattern.</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.search_string = Some(input.into());
            self
        }
        /// <p>The value that you want to search the filter values for.</p>
        /// <p>If you do not specify a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category names that match the <code>SearchString</code> pattern. If you do specifiy a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category values that match the <code>SearchString</code> pattern.</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.search_string = input;
            self
        }
        /// <p>The time period of the request. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period of the request. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn cost_category_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_name = Some(input.into());
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn set_cost_category_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_name = input;
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `sort_by`.
        ///
        /// To override the contents of this collection use [`set_sort_by`](Self::set_sort_by).
        ///
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            let mut v = self.sort_by.unwrap_or_default();
            v.push(input);
            self.sort_by = Some(v);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>This field is only used when <code>SortBy</code> is provided in the request.</p>
        /// <p>The maximum number of objects that to be returned for this request. If <code>MaxResults</code> is not specified with <code>SortBy</code>, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetCostCategories</code>, MaxResults has an upper limit of 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>This field is only used when <code>SortBy</code> is provided in the request.</p>
        /// <p>The maximum number of objects that to be returned for this request. If <code>MaxResults</code> is not specified with <code>SortBy</code>, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetCostCategories</code>, MaxResults has an upper limit of 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the prior call in your next request.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the prior call in your next request.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostCategoriesInput`](crate::input::GetCostCategoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCostCategoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCostCategoriesInput {
                search_string: self.search_string,
                time_period: self.time_period,
                cost_category_name: self.cost_category_name,
                filter: self.filter,
                sort_by: self.sort_by,
                max_results: self.max_results.unwrap_or_default(),
                next_page_token: self.next_page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCostCategoriesInputOperationOutputAlias = crate::operation::GetCostCategories;
#[doc(hidden)]
pub type GetCostCategoriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCostCategoriesInput {
    /// Consumes the builder and constructs an Operation<[`GetCostCategories`](crate::operation::GetCostCategories)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCostCategories,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCostCategoriesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCostCategoriesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCostCategoriesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetCostCategories",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_cost_categories(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCostCategories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCostCategories",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCostCategoriesInput`](crate::input::GetCostCategoriesInput)
    pub fn builder() -> crate::input::get_cost_categories_input::Builder {
        crate::input::get_cost_categories_input::Builder::default()
    }
}

/// See [`GetCostForecastInput`](crate::input::GetCostForecastInput)
pub mod get_cost_forecast_input {
    /// A builder for [`GetCostForecastInput`](crate::input::GetCostForecastInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) metric: std::option::Option<crate::model::Metric>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) prediction_interval_level: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values for a <code>GetCostForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>AMORTIZED_COST</p> </li>
        /// <li> <p>BLENDED_COST</p> </li>
        /// <li> <p>NET_AMORTIZED_COST</p> </li>
        /// <li> <p>NET_UNBLENDED_COST</p> </li>
        /// <li> <p>UNBLENDED_COST</p> </li>
        /// </ul>
        pub fn metric(mut self, input: crate::model::Metric) -> Self {
            self.metric = Some(input);
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values for a <code>GetCostForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>AMORTIZED_COST</p> </li>
        /// <li> <p>BLENDED_COST</p> </li>
        /// <li> <p>NET_AMORTIZED_COST</p> </li>
        /// <li> <p>NET_UNBLENDED_COST</p> </li>
        /// <li> <p>UNBLENDED_COST</p> </li>
        /// </ul>
        pub fn set_metric(mut self, input: std::option::Option<crate::model::Metric>) -> Self {
            self.metric = input;
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn prediction_interval_level(mut self, input: i32) -> Self {
            self.prediction_interval_level = Some(input);
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn set_prediction_interval_level(mut self, input: std::option::Option<i32>) -> Self {
            self.prediction_interval_level = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostForecastInput`](crate::input::GetCostForecastInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCostForecastInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCostForecastInput {
                time_period: self.time_period,
                metric: self.metric,
                granularity: self.granularity,
                filter: self.filter,
                prediction_interval_level: self.prediction_interval_level,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCostForecastInputOperationOutputAlias = crate::operation::GetCostForecast;
#[doc(hidden)]
pub type GetCostForecastInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCostForecastInput {
    /// Consumes the builder and constructs an Operation<[`GetCostForecast`](crate::operation::GetCostForecast)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCostForecast,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCostForecastInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCostForecastInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCostForecastInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetCostForecast",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_cost_forecast(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCostForecast::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCostForecast",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCostForecastInput`](crate::input::GetCostForecastInput)
    pub fn builder() -> crate::input::get_cost_forecast_input::Builder {
        crate::input::get_cost_forecast_input::Builder::default()
    }
}

/// See [`GetDimensionValuesInput`](crate::input::GetDimensionValuesInput)
pub mod get_dimension_values_input {
    /// A builder for [`GetDimensionValuesInput`](crate::input::GetDimensionValuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) search_string: std::option::Option<std::string::String>,
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) dimension: std::option::Option<crate::model::Dimension>,
        pub(crate) context: std::option::Option<crate::model::Context>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) sort_by: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value that you want to search the filter values for.</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.search_string = Some(input.into());
            self
        }
        /// <p>The value that you want to search the filter values for.</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.search_string = input;
            self
        }
        /// <p>The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html#awscostmanagement-GetDimensionValues-request-Context">Context</a>. </p>
        pub fn dimension(mut self, input: crate::model::Dimension) -> Self {
            self.dimension = Some(input);
            self
        }
        /// <p>The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html#awscostmanagement-GetDimensionValues-request-Context">Context</a>. </p>
        pub fn set_dimension(
            mut self,
            input: std::option::Option<crate::model::Dimension>,
        ) -> Self {
            self.dimension = input;
            self
        }
        /// <p>The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to <code>RESERVATIONS</code>, the resulting dimension values can be used in the <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
        /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>
        /// <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>
        /// <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>
        /// <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>
        /// <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>
        /// <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>
        /// <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>
        /// <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>
        /// </ul>
        pub fn context(mut self, input: crate::model::Context) -> Self {
            self.context = Some(input);
            self
        }
        /// <p>The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to <code>RESERVATIONS</code>, the resulting dimension values can be used in the <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
        /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>
        /// <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>
        /// <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>
        /// <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>
        /// <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>
        /// <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>
        /// <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>
        /// <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>
        /// </ul>
        pub fn set_context(mut self, input: std::option::Option<crate::model::Context>) -> Self {
            self.context = input;
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `sort_by`.
        ///
        /// To override the contents of this collection use [`set_sort_by`](Self::set_sort_by).
        ///
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            let mut v = self.sort_by.unwrap_or_default();
            v.push(input);
            self.sort_by = Some(v);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDimensionValuesInput`](crate::input::GetDimensionValuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDimensionValuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDimensionValuesInput {
                search_string: self.search_string,
                time_period: self.time_period,
                dimension: self.dimension,
                context: self.context,
                filter: self.filter,
                sort_by: self.sort_by,
                max_results: self.max_results.unwrap_or_default(),
                next_page_token: self.next_page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetDimensionValuesInputOperationOutputAlias = crate::operation::GetDimensionValues;
#[doc(hidden)]
pub type GetDimensionValuesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetDimensionValuesInput {
    /// Consumes the builder and constructs an Operation<[`GetDimensionValues`](crate::operation::GetDimensionValues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDimensionValues,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDimensionValuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDimensionValuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDimensionValuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetDimensionValues",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_dimension_values(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDimensionValues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDimensionValues",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDimensionValuesInput`](crate::input::GetDimensionValuesInput)
    pub fn builder() -> crate::input::get_dimension_values_input::Builder {
        crate::input::get_dimension_values_input::Builder::default()
    }
}

/// See [`GetReservationCoverageInput`](crate::input::GetReservationCoverageInput)
pub mod get_reservation_coverage_input {
    /// A builder for [`GetReservationCoverageInput`](crate::input::GetReservationCoverageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) metrics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::SortDefinition>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Appends an item to `group_by`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group the data by the following attributes:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            let mut v = self.group_by.unwrap_or_default();
            v.push(input);
            self.group_by = Some(v);
            self
        }
        /// <p>You can group the data by the following attributes:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code> and <code>DAILY</code>.</p>
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code> and <code>DAILY</code>.</p>
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>TAG</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only one level deep.</p>
        /// <p>If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.</p>
        /// <p>Cost category is also supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>TAG</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only one level deep.</p>
        /// <p>If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.</p>
        /// <p>Cost category is also supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The measurement that you want your reservation coverage reported in.</p>
        /// <p>Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a request.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>The measurement that you want your reservation coverage reported in.</p>
        /// <p>Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a request.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoverageHoursPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandHours</code> </p> </li>
        /// <li> <p> <code>ReservedHours</code> </p> </li>
        /// <li> <p> <code>TotalRunningHours</code> </p> </li>
        /// <li> <p> <code>CoverageNormalizedUnitsPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>ReservedNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>TotalRunningNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>Time</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoverageHoursPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandHours</code> </p> </li>
        /// <li> <p> <code>ReservedHours</code> </p> </li>
        /// <li> <p> <code>TotalRunningHours</code> </p> </li>
        /// <li> <p> <code>CoverageNormalizedUnitsPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>ReservedNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>TotalRunningNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>Time</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservationCoverageInput`](crate::input::GetReservationCoverageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReservationCoverageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReservationCoverageInput {
                time_period: self.time_period,
                group_by: self.group_by,
                granularity: self.granularity,
                filter: self.filter,
                metrics: self.metrics,
                next_page_token: self.next_page_token,
                sort_by: self.sort_by,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReservationCoverageInputOperationOutputAlias = crate::operation::GetReservationCoverage;
#[doc(hidden)]
pub type GetReservationCoverageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetReservationCoverageInput {
    /// Consumes the builder and constructs an Operation<[`GetReservationCoverage`](crate::operation::GetReservationCoverage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReservationCoverage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReservationCoverageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReservationCoverageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReservationCoverageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetReservationCoverage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_reservation_coverage(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReservationCoverage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReservationCoverage",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReservationCoverageInput`](crate::input::GetReservationCoverageInput)
    pub fn builder() -> crate::input::get_reservation_coverage_input::Builder {
        crate::input::get_reservation_coverage_input::Builder::default()
    }
}

/// See [`GetReservationPurchaseRecommendationInput`](crate::input::GetReservationPurchaseRecommendationInput)
pub mod get_reservation_purchase_recommendation_input {
    /// A builder for [`GetReservationPurchaseRecommendationInput`](crate::input::GetReservationPurchaseRecommendationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) account_scope: std::option::Option<crate::model::AccountScope>,
        pub(crate) lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
        pub(crate) term_in_years: std::option::Option<crate::model::TermInYears>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) service_specification: std::option::Option<crate::model::ServiceSpecification>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The account ID that is associated with the recommendation. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The account ID that is associated with the recommendation. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The specific service that you want recommendations for.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The specific service that you want recommendations for.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn account_scope(mut self, input: crate::model::AccountScope) -> Self {
            self.account_scope = Some(input);
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn set_account_scope(
            mut self,
            input: std::option::Option<crate::model::AccountScope>,
        ) -> Self {
            self.account_scope = input;
            self
        }
        /// <p>The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.</p>
        pub fn lookback_period_in_days(
            mut self,
            input: crate::model::LookbackPeriodInDays,
        ) -> Self {
            self.lookback_period_in_days = Some(input);
            self
        }
        /// <p>The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.</p>
        pub fn set_lookback_period_in_days(
            mut self,
            input: std::option::Option<crate::model::LookbackPeriodInDays>,
        ) -> Self {
            self.lookback_period_in_days = input;
            self
        }
        /// <p>The reservation term that you want recommendations for.</p>
        pub fn term_in_years(mut self, input: crate::model::TermInYears) -> Self {
            self.term_in_years = Some(input);
            self
        }
        /// <p>The reservation term that you want recommendations for.</p>
        pub fn set_term_in_years(
            mut self,
            input: std::option::Option<crate::model::TermInYears>,
        ) -> Self {
            self.term_in_years = input;
            self
        }
        /// <p>The reservation purchase option that you want recommendations for.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The reservation purchase option that you want recommendations for.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.</p>
        pub fn service_specification(mut self, input: crate::model::ServiceSpecification) -> Self {
            self.service_specification = Some(input);
            self
        }
        /// <p>The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.</p>
        pub fn set_service_specification(
            mut self,
            input: std::option::Option<crate::model::ServiceSpecification>,
        ) -> Self {
            self.service_specification = input;
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservationPurchaseRecommendationInput`](crate::input::GetReservationPurchaseRecommendationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReservationPurchaseRecommendationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReservationPurchaseRecommendationInput {
                account_id: self.account_id,
                service: self.service,
                filter: self.filter,
                account_scope: self.account_scope,
                lookback_period_in_days: self.lookback_period_in_days,
                term_in_years: self.term_in_years,
                payment_option: self.payment_option,
                service_specification: self.service_specification,
                page_size: self.page_size.unwrap_or_default(),
                next_page_token: self.next_page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReservationPurchaseRecommendationInputOperationOutputAlias =
    crate::operation::GetReservationPurchaseRecommendation;
#[doc(hidden)]
pub type GetReservationPurchaseRecommendationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetReservationPurchaseRecommendationInput {
    /// Consumes the builder and constructs an Operation<[`GetReservationPurchaseRecommendation`](crate::operation::GetReservationPurchaseRecommendation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReservationPurchaseRecommendation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReservationPurchaseRecommendationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReservationPurchaseRecommendationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReservationPurchaseRecommendationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetReservationPurchaseRecommendation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_reservation_purchase_recommendation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReservationPurchaseRecommendation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReservationPurchaseRecommendation",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReservationPurchaseRecommendationInput`](crate::input::GetReservationPurchaseRecommendationInput)
    pub fn builder() -> crate::input::get_reservation_purchase_recommendation_input::Builder {
        crate::input::get_reservation_purchase_recommendation_input::Builder::default()
    }
}

/// See [`GetReservationUtilizationInput`](crate::input::GetReservationUtilizationInput)
pub mod get_reservation_utilization_input {
    /// A builder for [`GetReservationUtilizationInput`](crate::input::GetReservationUtilizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) sort_by: std::option::Option<crate::model::SortDefinition>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Sets the start and end dates for retrieving RI utilization. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>Sets the start and end dates for retrieving RI utilization. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Appends an item to `group_by`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>Groups only by <code>SUBSCRIPTION_ID</code>. Metadata is included.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            let mut v = self.group_by.unwrap_or_default();
            v.push(input);
            self.group_by = Some(v);
            self
        }
        /// <p>Groups only by <code>SUBSCRIPTION_ID</code>. Metadata is included.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>. If both <code>GroupBy</code> and <code>Granularity</code> aren't set, <code>GetReservationUtilization</code> defaults to <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>. If both <code>GroupBy</code> and <code>Granularity</code> aren't set, <code>GetReservationUtilization</code> defaults to <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>SCOPE</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension, and nesting is supported up to only one level deep.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>SCOPE</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension, and nesting is supported up to only one level deep.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>UtilizationPercentageInUnits</code> </p> </li>
        /// <li> <p> <code>PurchasedHours</code> </p> </li>
        /// <li> <p> <code>PurchasedUnits</code> </p> </li>
        /// <li> <p> <code>TotalActualHours</code> </p> </li>
        /// <li> <p> <code>TotalActualUnits</code> </p> </li>
        /// <li> <p> <code>UnusedHours</code> </p> </li>
        /// <li> <p> <code>UnusedUnits</code> </p> </li>
        /// <li> <p> <code>OnDemandCostOfRIHoursUsed</code> </p> </li>
        /// <li> <p> <code>NetRISavings</code> </p> </li>
        /// <li> <p> <code>TotalPotentialRISavings</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontFee</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringFee</code> </p> </li>
        /// <li> <p> <code>TotalAmortizedFee</code> </p> </li>
        /// <li> <p> <code>RICostForUnusedHours</code> </p> </li>
        /// <li> <p> <code>RealizedSavings</code> </p> </li>
        /// <li> <p> <code>UnrealizedSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>UtilizationPercentageInUnits</code> </p> </li>
        /// <li> <p> <code>PurchasedHours</code> </p> </li>
        /// <li> <p> <code>PurchasedUnits</code> </p> </li>
        /// <li> <p> <code>TotalActualHours</code> </p> </li>
        /// <li> <p> <code>TotalActualUnits</code> </p> </li>
        /// <li> <p> <code>UnusedHours</code> </p> </li>
        /// <li> <p> <code>UnusedUnits</code> </p> </li>
        /// <li> <p> <code>OnDemandCostOfRIHoursUsed</code> </p> </li>
        /// <li> <p> <code>NetRISavings</code> </p> </li>
        /// <li> <p> <code>TotalPotentialRISavings</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontFee</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringFee</code> </p> </li>
        /// <li> <p> <code>TotalAmortizedFee</code> </p> </li>
        /// <li> <p> <code>RICostForUnusedHours</code> </p> </li>
        /// <li> <p> <code>RealizedSavings</code> </p> </li>
        /// <li> <p> <code>UnrealizedSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservationUtilizationInput`](crate::input::GetReservationUtilizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetReservationUtilizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetReservationUtilizationInput {
                time_period: self.time_period,
                group_by: self.group_by,
                granularity: self.granularity,
                filter: self.filter,
                sort_by: self.sort_by,
                next_page_token: self.next_page_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetReservationUtilizationInputOperationOutputAlias =
    crate::operation::GetReservationUtilization;
#[doc(hidden)]
pub type GetReservationUtilizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetReservationUtilizationInput {
    /// Consumes the builder and constructs an Operation<[`GetReservationUtilization`](crate::operation::GetReservationUtilization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetReservationUtilization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetReservationUtilizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetReservationUtilizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetReservationUtilizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetReservationUtilization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_reservation_utilization(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetReservationUtilization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetReservationUtilization",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetReservationUtilizationInput`](crate::input::GetReservationUtilizationInput)
    pub fn builder() -> crate::input::get_reservation_utilization_input::Builder {
        crate::input::get_reservation_utilization_input::Builder::default()
    }
}

/// See [`GetRightsizingRecommendationInput`](crate::input::GetRightsizingRecommendationInput)
pub mod get_rightsizing_recommendation_input {
    /// A builder for [`GetRightsizingRecommendationInput`](crate::input::GetRightsizingRecommendationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) configuration:
            std::option::Option<crate::model::RightsizingRecommendationConfiguration>,
        pub(crate) service: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
        pub fn configuration(
            mut self,
            input: crate::model::RightsizingRecommendationConfiguration,
        ) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::RightsizingRecommendationConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>The specific service that you want recommendations for. The only valid value for <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.service = Some(input.into());
            self
        }
        /// <p>The specific service that you want recommendations for. The only valid value for <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service = input;
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRightsizingRecommendationInput`](crate::input::GetRightsizingRecommendationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetRightsizingRecommendationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetRightsizingRecommendationInput {
                filter: self.filter,
                configuration: self.configuration,
                service: self.service,
                page_size: self.page_size.unwrap_or_default(),
                next_page_token: self.next_page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetRightsizingRecommendationInputOperationOutputAlias =
    crate::operation::GetRightsizingRecommendation;
#[doc(hidden)]
pub type GetRightsizingRecommendationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetRightsizingRecommendationInput {
    /// Consumes the builder and constructs an Operation<[`GetRightsizingRecommendation`](crate::operation::GetRightsizingRecommendation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetRightsizingRecommendation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetRightsizingRecommendationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetRightsizingRecommendationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetRightsizingRecommendationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetRightsizingRecommendation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_rightsizing_recommendation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetRightsizingRecommendation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetRightsizingRecommendation",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetRightsizingRecommendationInput`](crate::input::GetRightsizingRecommendationInput)
    pub fn builder() -> crate::input::get_rightsizing_recommendation_input::Builder {
        crate::input::get_rightsizing_recommendation_input::Builder::default()
    }
}

/// See [`GetSavingsPlansCoverageInput`](crate::input::GetSavingsPlansCoverageInput)
pub mod get_savings_plans_coverage_input {
    /// A builder for [`GetSavingsPlansCoverageInput`](crate::input::GetSavingsPlansCoverageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) metrics: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) sort_by: std::option::Option<crate::model::SortDefinition>,
    }
    impl Builder {
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// Appends an item to `group_by`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or <code>SERVICE</code>.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            let mut v = self.group_by.unwrap_or_default();
            v.push(input);
            self.group_by = Some(v);
            self
        }
        /// <p>You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or <code>SERVICE</code>.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.group_by = input;
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be set if <code>GroupBy</code> is set.</p>
        /// <p>The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be set if <code>GroupBy</code> is set.</p>
        /// <p>The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Cost category is supported. Tags are not supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Cost category is supported. Tags are not supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The measurement that you want your Savings Plans coverage reported in. The only valid value is <code>SpendCoveredBySavingsPlans</code>.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.metrics.unwrap_or_default();
            v.push(input.into());
            self.metrics = Some(v);
            self
        }
        /// <p>The measurement that you want your Savings Plans coverage reported in. The only valid value is <code>SpendCoveredBySavingsPlans</code>.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.metrics = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>SpendCoveredBySavingsPlan</code> </p> </li>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoveragePercentage</code> </p> </li>
        /// <li> <p> <code>TotalCost</code> </p> </li>
        /// <li> <p> <code>InstanceFamily</code> </p> </li>
        /// <li> <p> <code>Region</code> </p> </li>
        /// <li> <p> <code>Service</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>SpendCoveredBySavingsPlan</code> </p> </li>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoveragePercentage</code> </p> </li>
        /// <li> <p> <code>TotalCost</code> </p> </li>
        /// <li> <p> <code>InstanceFamily</code> </p> </li>
        /// <li> <p> <code>Region</code> </p> </li>
        /// <li> <p> <code>Service</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansCoverageInput`](crate::input::GetSavingsPlansCoverageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSavingsPlansCoverageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSavingsPlansCoverageInput {
                time_period: self.time_period,
                group_by: self.group_by,
                granularity: self.granularity,
                filter: self.filter,
                metrics: self.metrics,
                next_token: self.next_token,
                max_results: self.max_results,
                sort_by: self.sort_by,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSavingsPlansCoverageInputOperationOutputAlias =
    crate::operation::GetSavingsPlansCoverage;
#[doc(hidden)]
pub type GetSavingsPlansCoverageInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSavingsPlansCoverageInput {
    /// Consumes the builder and constructs an Operation<[`GetSavingsPlansCoverage`](crate::operation::GetSavingsPlansCoverage)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSavingsPlansCoverage,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSavingsPlansCoverageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSavingsPlansCoverageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSavingsPlansCoverageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetSavingsPlansCoverage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_savings_plans_coverage(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSavingsPlansCoverage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSavingsPlansCoverage",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansCoverageInput`](crate::input::GetSavingsPlansCoverageInput)
    pub fn builder() -> crate::input::get_savings_plans_coverage_input::Builder {
        crate::input::get_savings_plans_coverage_input::Builder::default()
    }
}

/// See [`GetSavingsPlansPurchaseRecommendationInput`](crate::input::GetSavingsPlansPurchaseRecommendationInput)
pub mod get_savings_plans_purchase_recommendation_input {
    /// A builder for [`GetSavingsPlansPurchaseRecommendationInput`](crate::input::GetSavingsPlansPurchaseRecommendationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plans_type: std::option::Option<crate::model::SupportedSavingsPlansType>,
        pub(crate) term_in_years: std::option::Option<crate::model::TermInYears>,
        pub(crate) payment_option: std::option::Option<crate::model::PaymentOption>,
        pub(crate) account_scope: std::option::Option<crate::model::AccountScope>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) page_size: std::option::Option<i32>,
        pub(crate) lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
    }
    impl Builder {
        /// <p>The Savings Plans recommendation type requested.</p>
        pub fn savings_plans_type(
            mut self,
            input: crate::model::SupportedSavingsPlansType,
        ) -> Self {
            self.savings_plans_type = Some(input);
            self
        }
        /// <p>The Savings Plans recommendation type requested.</p>
        pub fn set_savings_plans_type(
            mut self,
            input: std::option::Option<crate::model::SupportedSavingsPlansType>,
        ) -> Self {
            self.savings_plans_type = input;
            self
        }
        /// <p>The savings plan recommendation term used to generate these recommendations.</p>
        pub fn term_in_years(mut self, input: crate::model::TermInYears) -> Self {
            self.term_in_years = Some(input);
            self
        }
        /// <p>The savings plan recommendation term used to generate these recommendations.</p>
        pub fn set_term_in_years(
            mut self,
            input: std::option::Option<crate::model::TermInYears>,
        ) -> Self {
            self.term_in_years = input;
            self
        }
        /// <p>The payment option used to generate these recommendations.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.payment_option = Some(input);
            self
        }
        /// <p>The payment option used to generate these recommendations.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.payment_option = input;
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn account_scope(mut self, input: crate::model::AccountScope) -> Self {
            self.account_scope = Some(input);
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn set_account_scope(
            mut self,
            input: std::option::Option<crate::model::AccountScope>,
        ) -> Self {
            self.account_scope = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.page_size = Some(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.page_size = input;
            self
        }
        /// <p>The lookback period used to generate the recommendation.</p>
        pub fn lookback_period_in_days(
            mut self,
            input: crate::model::LookbackPeriodInDays,
        ) -> Self {
            self.lookback_period_in_days = Some(input);
            self
        }
        /// <p>The lookback period used to generate the recommendation.</p>
        pub fn set_lookback_period_in_days(
            mut self,
            input: std::option::Option<crate::model::LookbackPeriodInDays>,
        ) -> Self {
            self.lookback_period_in_days = input;
            self
        }
        /// <p>You can filter your recommendations by Account ID with the <code>LINKED_ACCOUNT</code> dimension. To filter your recommendations by Account ID, specify <code>Key</code> as <code>LINKED_ACCOUNT</code> and <code>Value</code> as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations.</p>
        /// <p>For GetSavingsPlansPurchaseRecommendation, the <code>Filter</code> does not include <code>CostCategories</code> or <code>Tags</code>. It only includes <code>Dimensions</code>. With <code>Dimensions</code>, <code>Key</code> must be <code>LINKED_ACCOUNT</code> and <code>Value</code> can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. <code>AND</code> and <code>OR</code> operators are not supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>You can filter your recommendations by Account ID with the <code>LINKED_ACCOUNT</code> dimension. To filter your recommendations by Account ID, specify <code>Key</code> as <code>LINKED_ACCOUNT</code> and <code>Value</code> as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations.</p>
        /// <p>For GetSavingsPlansPurchaseRecommendation, the <code>Filter</code> does not include <code>CostCategories</code> or <code>Tags</code>. It only includes <code>Dimensions</code>. With <code>Dimensions</code>, <code>Key</code> must be <code>LINKED_ACCOUNT</code> and <code>Value</code> can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. <code>AND</code> and <code>OR</code> operators are not supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansPurchaseRecommendationInput`](crate::input::GetSavingsPlansPurchaseRecommendationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSavingsPlansPurchaseRecommendationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSavingsPlansPurchaseRecommendationInput {
                savings_plans_type: self.savings_plans_type,
                term_in_years: self.term_in_years,
                payment_option: self.payment_option,
                account_scope: self.account_scope,
                next_page_token: self.next_page_token,
                page_size: self.page_size.unwrap_or_default(),
                lookback_period_in_days: self.lookback_period_in_days,
                filter: self.filter,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSavingsPlansPurchaseRecommendationInputOperationOutputAlias =
    crate::operation::GetSavingsPlansPurchaseRecommendation;
#[doc(hidden)]
pub type GetSavingsPlansPurchaseRecommendationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetSavingsPlansPurchaseRecommendationInput {
    /// Consumes the builder and constructs an Operation<[`GetSavingsPlansPurchaseRecommendation`](crate::operation::GetSavingsPlansPurchaseRecommendation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSavingsPlansPurchaseRecommendation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSavingsPlansPurchaseRecommendationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSavingsPlansPurchaseRecommendationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSavingsPlansPurchaseRecommendationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetSavingsPlansPurchaseRecommendation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_savings_plans_purchase_recommendation(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSavingsPlansPurchaseRecommendation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSavingsPlansPurchaseRecommendation",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansPurchaseRecommendationInput`](crate::input::GetSavingsPlansPurchaseRecommendationInput)
    pub fn builder() -> crate::input::get_savings_plans_purchase_recommendation_input::Builder {
        crate::input::get_savings_plans_purchase_recommendation_input::Builder::default()
    }
}

/// See [`GetSavingsPlansUtilizationInput`](crate::input::GetSavingsPlansUtilizationInput)
pub mod get_savings_plans_utilization_input {
    /// A builder for [`GetSavingsPlansUtilizationInput`](crate::input::GetSavingsPlansUtilizationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) sort_by: std::option::Option<crate::model::SortDefinition>,
    }
    impl Builder {
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
        /// <p>The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
        /// <p>The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLANS_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLANS_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansUtilizationInput`](crate::input::GetSavingsPlansUtilizationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSavingsPlansUtilizationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSavingsPlansUtilizationInput {
                time_period: self.time_period,
                granularity: self.granularity,
                filter: self.filter,
                sort_by: self.sort_by,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSavingsPlansUtilizationInputOperationOutputAlias =
    crate::operation::GetSavingsPlansUtilization;
#[doc(hidden)]
pub type GetSavingsPlansUtilizationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetSavingsPlansUtilizationInput {
    /// Consumes the builder and constructs an Operation<[`GetSavingsPlansUtilization`](crate::operation::GetSavingsPlansUtilization)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSavingsPlansUtilization,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSavingsPlansUtilizationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSavingsPlansUtilizationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSavingsPlansUtilizationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetSavingsPlansUtilization",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_savings_plans_utilization(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSavingsPlansUtilization::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSavingsPlansUtilization",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansUtilizationInput`](crate::input::GetSavingsPlansUtilizationInput)
    pub fn builder() -> crate::input::get_savings_plans_utilization_input::Builder {
        crate::input::get_savings_plans_utilization_input::Builder::default()
    }
}

/// See [`GetSavingsPlansUtilizationDetailsInput`](crate::input::GetSavingsPlansUtilizationDetailsInput)
pub mod get_savings_plans_utilization_details_input {
    /// A builder for [`GetSavingsPlansUtilizationDetailsInput`](crate::input::GetSavingsPlansUtilizationDetailsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) data_type:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlansDataType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) sort_by: std::option::Option<crate::model::SortDefinition>,
    }
    impl Builder {
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilizationDetails</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilizationDetails</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `data_type`.
        ///
        /// To override the contents of this collection use [`set_data_type`](Self::set_data_type).
        ///
        /// <p>The data type.</p>
        pub fn data_type(mut self, input: crate::model::SavingsPlansDataType) -> Self {
            let mut v = self.data_type.unwrap_or_default();
            v.push(input);
            self.data_type = Some(v);
            self
        }
        /// <p>The data type.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlansDataType>>,
        ) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringCommitment</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontCommitment</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringCommitment</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontCommitment</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansUtilizationDetailsInput`](crate::input::GetSavingsPlansUtilizationDetailsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetSavingsPlansUtilizationDetailsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetSavingsPlansUtilizationDetailsInput {
                time_period: self.time_period,
                filter: self.filter,
                data_type: self.data_type,
                next_token: self.next_token,
                max_results: self.max_results,
                sort_by: self.sort_by,
            })
        }
    }
}
#[doc(hidden)]
pub type GetSavingsPlansUtilizationDetailsInputOperationOutputAlias =
    crate::operation::GetSavingsPlansUtilizationDetails;
#[doc(hidden)]
pub type GetSavingsPlansUtilizationDetailsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl GetSavingsPlansUtilizationDetailsInput {
    /// Consumes the builder and constructs an Operation<[`GetSavingsPlansUtilizationDetails`](crate::operation::GetSavingsPlansUtilizationDetails)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetSavingsPlansUtilizationDetails,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetSavingsPlansUtilizationDetailsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetSavingsPlansUtilizationDetailsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetSavingsPlansUtilizationDetailsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetSavingsPlansUtilizationDetails",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_savings_plans_utilization_details(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetSavingsPlansUtilizationDetails::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetSavingsPlansUtilizationDetails",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansUtilizationDetailsInput`](crate::input::GetSavingsPlansUtilizationDetailsInput)
    pub fn builder() -> crate::input::get_savings_plans_utilization_details_input::Builder {
        crate::input::get_savings_plans_utilization_details_input::Builder::default()
    }
}

/// See [`GetTagsInput`](crate::input::GetTagsInput)
pub mod get_tags_input {
    /// A builder for [`GetTagsInput`](crate::input::GetTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) search_string: std::option::Option<std::string::String>,
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) tag_key: std::option::Option<std::string::String>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) sort_by: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value that you want to search for.</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.search_string = Some(input.into());
            self
        }
        /// <p>The value that you want to search for.</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.search_string = input;
            self
        }
        /// <p>The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>The key of the tag that you want to return values for.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.tag_key = Some(input.into());
            self
        }
        /// <p>The key of the tag that you want to return values for.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.tag_key = input;
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// Appends an item to `sort_by`.
        ///
        /// To override the contents of this collection use [`set_sort_by`](Self::set_sort_by).
        ///
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            let mut v = self.sort_by.unwrap_or_default();
            v.push(input);
            self.sort_by = Some(v);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetTags</code>, MaxResults has an upper limit of 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetTags</code>, MaxResults has an upper limit of 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsInput`](crate::input::GetTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetTagsInput {
                search_string: self.search_string,
                time_period: self.time_period,
                tag_key: self.tag_key,
                filter: self.filter,
                sort_by: self.sort_by,
                max_results: self.max_results.unwrap_or_default(),
                next_page_token: self.next_page_token,
            })
        }
    }
}
#[doc(hidden)]
pub type GetTagsInputOperationOutputAlias = crate::operation::GetTags;
#[doc(hidden)]
pub type GetTagsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetTagsInput {
    /// Consumes the builder and constructs an Operation<[`GetTags`](crate::operation::GetTags)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetTags,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetTags",
                    "costexplorer",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
}

/// See [`GetUsageForecastInput`](crate::input::GetUsageForecastInput)
pub mod get_usage_forecast_input {
    /// A builder for [`GetUsageForecastInput`](crate::input::GetUsageForecastInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) metric: std::option::Option<crate::model::Metric>,
        pub(crate) granularity: std::option::Option<crate::model::Granularity>,
        pub(crate) filter: std::option::Option<crate::model::Expression>,
        pub(crate) prediction_interval_level: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The start and end dates of the period that you want to retrieve usage forecast for. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. The start date must be equal to or later than the current date to avoid a validation error.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The start and end dates of the period that you want to retrieve usage forecast for. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. The start date must be equal to or later than the current date to avoid a validation error.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast.</p>
        /// <p>Valid values for a <code>GetUsageForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>USAGE_QUANTITY</p> </li>
        /// <li> <p>NORMALIZED_USAGE_AMOUNT</p> </li>
        /// </ul>
        pub fn metric(mut self, input: crate::model::Metric) -> Self {
            self.metric = Some(input);
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast.</p>
        /// <p>Valid values for a <code>GetUsageForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>USAGE_QUANTITY</p> </li>
        /// <li> <p>NORMALIZED_USAGE_AMOUNT</p> </li>
        /// </ul>
        pub fn set_metric(mut self, input: std::option::Option<crate::model::Metric>) -> Self {
            self.metric = input;
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetUsageForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.granularity = Some(input);
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetUsageForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.granularity = input;
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetUsageForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.filter = Some(input);
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetUsageForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.filter = input;
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn prediction_interval_level(mut self, input: i32) -> Self {
            self.prediction_interval_level = Some(input);
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn set_prediction_interval_level(mut self, input: std::option::Option<i32>) -> Self {
            self.prediction_interval_level = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsageForecastInput`](crate::input::GetUsageForecastInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsageForecastInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsageForecastInput {
                time_period: self.time_period,
                metric: self.metric,
                granularity: self.granularity,
                filter: self.filter,
                prediction_interval_level: self.prediction_interval_level,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsageForecastInputOperationOutputAlias = crate::operation::GetUsageForecast;
#[doc(hidden)]
pub type GetUsageForecastInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetUsageForecastInput {
    /// Consumes the builder and constructs an Operation<[`GetUsageForecast`](crate::operation::GetUsageForecast)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsageForecast,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsageForecastInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsageForecastInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsageForecastInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.GetUsageForecast",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_usage_forecast(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsageForecast::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsageForecast",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsageForecastInput`](crate::input::GetUsageForecastInput)
    pub fn builder() -> crate::input::get_usage_forecast_input::Builder {
        crate::input::get_usage_forecast_input::Builder::default()
    }
}

/// See [`ListCostCategoryDefinitionsInput`](crate::input::ListCostCategoryDefinitionsInput)
pub mod list_cost_category_definitions_input {
    /// A builder for [`ListCostCategoryDefinitionsInput`](crate::input::ListCostCategoryDefinitionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) effective_on: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The date when the Cost Category was effective. </p>
        pub fn effective_on(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_on = Some(input.into());
            self
        }
        /// <p> The date when the Cost Category was effective. </p>
        pub fn set_effective_on(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.effective_on = input;
            self
        }
        /// <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The number of entries a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The number of entries a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCostCategoryDefinitionsInput`](crate::input::ListCostCategoryDefinitionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCostCategoryDefinitionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCostCategoryDefinitionsInput {
                effective_on: self.effective_on,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCostCategoryDefinitionsInputOperationOutputAlias =
    crate::operation::ListCostCategoryDefinitions;
#[doc(hidden)]
pub type ListCostCategoryDefinitionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListCostCategoryDefinitionsInput {
    /// Consumes the builder and constructs an Operation<[`ListCostCategoryDefinitions`](crate::operation::ListCostCategoryDefinitions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCostCategoryDefinitions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCostCategoryDefinitionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCostCategoryDefinitionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCostCategoryDefinitionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.ListCostCategoryDefinitions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_cost_category_definitions(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCostCategoryDefinitions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCostCategoryDefinitions",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCostCategoryDefinitionsInput`](crate::input::ListCostCategoryDefinitionsInput)
    pub fn builder() -> crate::input::list_cost_category_definitions_input::Builder {
        crate::input::list_cost_category_definitions_input::Builder::default()
    }
}

/// See [`ProvideAnomalyFeedbackInput`](crate::input::ProvideAnomalyFeedbackInput)
pub mod provide_anomaly_feedback_input {
    /// A builder for [`ProvideAnomalyFeedbackInput`](crate::input::ProvideAnomalyFeedbackInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_id: std::option::Option<std::string::String>,
        pub(crate) feedback: std::option::Option<crate::model::AnomalyFeedbackType>,
    }
    impl Builder {
        /// <p>A cost anomaly ID. </p>
        pub fn anomaly_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_id = Some(input.into());
            self
        }
        /// <p>A cost anomaly ID. </p>
        pub fn set_anomaly_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.anomaly_id = input;
            self
        }
        /// <p>Describes whether the cost anomaly was a planned activity or you considered it an anomaly. </p>
        pub fn feedback(mut self, input: crate::model::AnomalyFeedbackType) -> Self {
            self.feedback = Some(input);
            self
        }
        /// <p>Describes whether the cost anomaly was a planned activity or you considered it an anomaly. </p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyFeedbackType>,
        ) -> Self {
            self.feedback = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvideAnomalyFeedbackInput`](crate::input::ProvideAnomalyFeedbackInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ProvideAnomalyFeedbackInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ProvideAnomalyFeedbackInput {
                anomaly_id: self.anomaly_id,
                feedback: self.feedback,
            })
        }
    }
}
#[doc(hidden)]
pub type ProvideAnomalyFeedbackInputOperationOutputAlias = crate::operation::ProvideAnomalyFeedback;
#[doc(hidden)]
pub type ProvideAnomalyFeedbackInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ProvideAnomalyFeedbackInput {
    /// Consumes the builder and constructs an Operation<[`ProvideAnomalyFeedback`](crate::operation::ProvideAnomalyFeedback)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ProvideAnomalyFeedback,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ProvideAnomalyFeedbackInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ProvideAnomalyFeedbackInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ProvideAnomalyFeedbackInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.ProvideAnomalyFeedback",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_provide_anomaly_feedback(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ProvideAnomalyFeedback::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ProvideAnomalyFeedback",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ProvideAnomalyFeedbackInput`](crate::input::ProvideAnomalyFeedbackInput)
    pub fn builder() -> crate::input::provide_anomaly_feedback_input::Builder {
        crate::input::provide_anomaly_feedback_input::Builder::default()
    }
}

/// See [`UpdateAnomalyMonitorInput`](crate::input::UpdateAnomalyMonitorInput)
pub mod update_anomaly_monitor_input {
    /// A builder for [`UpdateAnomalyMonitorInput`](crate::input::UpdateAnomalyMonitorInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
        pub(crate) monitor_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Cost anomaly monitor Amazon Resource Names (ARNs). </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>Cost anomaly monitor Amazon Resource Names (ARNs). </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// <p>The new name for the cost anomaly monitor. </p>
        pub fn monitor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_name = Some(input.into());
            self
        }
        /// <p>The new name for the cost anomaly monitor. </p>
        pub fn set_monitor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnomalyMonitorInput`](crate::input::UpdateAnomalyMonitorInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAnomalyMonitorInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAnomalyMonitorInput {
                monitor_arn: self.monitor_arn,
                monitor_name: self.monitor_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAnomalyMonitorInputOperationOutputAlias = crate::operation::UpdateAnomalyMonitor;
#[doc(hidden)]
pub type UpdateAnomalyMonitorInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAnomalyMonitorInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAnomalyMonitor`](crate::operation::UpdateAnomalyMonitor)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAnomalyMonitor,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAnomalyMonitorInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAnomalyMonitorInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAnomalyMonitorInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.UpdateAnomalyMonitor",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_anomaly_monitor(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAnomalyMonitor::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAnomalyMonitor",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAnomalyMonitorInput`](crate::input::UpdateAnomalyMonitorInput)
    pub fn builder() -> crate::input::update_anomaly_monitor_input::Builder {
        crate::input::update_anomaly_monitor_input::Builder::default()
    }
}

/// See [`UpdateAnomalySubscriptionInput`](crate::input::UpdateAnomalySubscriptionInput)
pub mod update_anomaly_subscription_input {
    /// A builder for [`UpdateAnomalySubscriptionInput`](crate::input::UpdateAnomalySubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
        pub(crate) threshold: std::option::Option<f64>,
        pub(crate) frequency: std::option::Option<crate::model::AnomalySubscriptionFrequency>,
        pub(crate) monitor_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        pub(crate) subscription_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cost anomaly subscription Amazon Resource Name (ARN). </p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>A cost anomaly subscription Amazon Resource Name (ARN). </p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// <p>The update to the threshold value for receiving notifications. </p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.threshold = Some(input);
            self
        }
        /// <p>The update to the threshold value for receiving notifications. </p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.threshold = input;
            self
        }
        /// <p>The update to the frequency value that subscribers receive notifications. </p>
        pub fn frequency(mut self, input: crate::model::AnomalySubscriptionFrequency) -> Self {
            self.frequency = Some(input);
            self
        }
        /// <p>The update to the frequency value that subscribers receive notifications. </p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AnomalySubscriptionFrequency>,
        ) -> Self {
            self.frequency = input;
            self
        }
        /// Appends an item to `monitor_arn_list`.
        ///
        /// To override the contents of this collection use [`set_monitor_arn_list`](Self::set_monitor_arn_list).
        ///
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn monitor_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.monitor_arn_list.unwrap_or_default();
            v.push(input.into());
            self.monitor_arn_list = Some(v);
            self
        }
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn set_monitor_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.monitor_arn_list = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>The update to the subscriber list. </p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input);
            self.subscribers = Some(v);
            self
        }
        /// <p>The update to the subscriber list. </p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// <p>The new name of the subscription. </p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The new name of the subscription. </p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnomalySubscriptionInput`](crate::input::UpdateAnomalySubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAnomalySubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAnomalySubscriptionInput {
                subscription_arn: self.subscription_arn,
                threshold: self.threshold,
                frequency: self.frequency,
                monitor_arn_list: self.monitor_arn_list,
                subscribers: self.subscribers,
                subscription_name: self.subscription_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAnomalySubscriptionInputOperationOutputAlias =
    crate::operation::UpdateAnomalySubscription;
#[doc(hidden)]
pub type UpdateAnomalySubscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAnomalySubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAnomalySubscription`](crate::operation::UpdateAnomalySubscription)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAnomalySubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAnomalySubscriptionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAnomalySubscriptionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAnomalySubscriptionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.UpdateAnomalySubscription",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_anomaly_subscription(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAnomalySubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAnomalySubscription",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAnomalySubscriptionInput`](crate::input::UpdateAnomalySubscriptionInput)
    pub fn builder() -> crate::input::update_anomaly_subscription_input::Builder {
        crate::input::update_anomaly_subscription_input::Builder::default()
    }
}

/// See [`UpdateCostCategoryDefinitionInput`](crate::input::UpdateCostCategoryDefinitionInput)
pub mod update_cost_category_definition_input {
    /// A builder for [`UpdateCostCategoryDefinitionInput`](crate::input::UpdateCostCategoryDefinitionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
        pub(crate) rule_version: std::option::Option<crate::model::CostCategoryRuleVersion>,
        pub(crate) rules: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) split_charge_rules:
            std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
    }
    impl Builder {
        /// <p>The unique identifier for your Cost Category.</p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier for your Cost Category.</p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn rule_version(mut self, input: crate::model::CostCategoryRuleVersion) -> Self {
            self.rule_version = Some(input);
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn set_rule_version(
            mut self,
            input: std::option::Option<crate::model::CostCategoryRuleVersion>,
        ) -> Self {
            self.rule_version = input;
            self
        }
        /// Appends an item to `rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Expression</code> object used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule </a>. </p>
        pub fn rules(mut self, input: crate::model::CostCategoryRule) -> Self {
            let mut v = self.rules.unwrap_or_default();
            v.push(input);
            self.rules = Some(v);
            self
        }
        /// <p>The <code>Expression</code> object used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule </a>. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        ) -> Self {
            self.rules = input;
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// Appends an item to `split_charge_rules`.
        ///
        /// To override the contents of this collection use [`set_split_charge_rules`](Self::set_split_charge_rules).
        ///
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn split_charge_rules(
            mut self,
            input: crate::model::CostCategorySplitChargeRule,
        ) -> Self {
            let mut v = self.split_charge_rules.unwrap_or_default();
            v.push(input);
            self.split_charge_rules = Some(v);
            self
        }
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn set_split_charge_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
        ) -> Self {
            self.split_charge_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCostCategoryDefinitionInput`](crate::input::UpdateCostCategoryDefinitionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateCostCategoryDefinitionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateCostCategoryDefinitionInput {
                cost_category_arn: self.cost_category_arn,
                rule_version: self.rule_version,
                rules: self.rules,
                default_value: self.default_value,
                split_charge_rules: self.split_charge_rules,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateCostCategoryDefinitionInputOperationOutputAlias =
    crate::operation::UpdateCostCategoryDefinition;
#[doc(hidden)]
pub type UpdateCostCategoryDefinitionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl UpdateCostCategoryDefinitionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateCostCategoryDefinition`](crate::operation::UpdateCostCategoryDefinition)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateCostCategoryDefinition,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateCostCategoryDefinitionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateCostCategoryDefinitionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateCostCategoryDefinitionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSInsightsIndexService.UpdateCostCategoryDefinition",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_cost_category_definition(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateCostCategoryDefinition::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateCostCategoryDefinition",
            "costexplorer",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateCostCategoryDefinitionInput`](crate::input::UpdateCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::update_cost_category_definition_input::Builder {
        crate::input::update_cost_category_definition_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCostCategoryDefinitionInput {
    /// <p>The unique identifier for your Cost Category.</p>
    pub cost_category_arn: std::option::Option<std::string::String>,
    /// <p>The rule schema version in this particular Cost Category.</p>
    pub rule_version: std::option::Option<crate::model::CostCategoryRuleVersion>,
    /// <p>The <code>Expression</code> object used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule </a>. </p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
    /// <p>The default value for the cost category.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
    pub split_charge_rules:
        std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
}
impl UpdateCostCategoryDefinitionInput {
    /// <p>The unique identifier for your Cost Category.</p>
    pub fn cost_category_arn(&self) -> std::option::Option<&str> {
        self.cost_category_arn.as_deref()
    }
    /// <p>The rule schema version in this particular Cost Category.</p>
    pub fn rule_version(&self) -> std::option::Option<&crate::model::CostCategoryRuleVersion> {
        self.rule_version.as_ref()
    }
    /// <p>The <code>Expression</code> object used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule </a>. </p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::CostCategoryRule]> {
        self.rules.as_deref()
    }
    /// <p>The default value for the cost category.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
    pub fn split_charge_rules(
        &self,
    ) -> std::option::Option<&[crate::model::CostCategorySplitChargeRule]> {
        self.split_charge_rules.as_deref()
    }
}
impl std::fmt::Debug for UpdateCostCategoryDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCostCategoryDefinitionInput");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.field("rule_version", &self.rule_version);
        formatter.field("rules", &self.rules);
        formatter.field("default_value", &self.default_value);
        formatter.field("split_charge_rules", &self.split_charge_rules);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnomalySubscriptionInput {
    /// <p>A cost anomaly subscription Amazon Resource Name (ARN). </p>
    pub subscription_arn: std::option::Option<std::string::String>,
    /// <p>The update to the threshold value for receiving notifications. </p>
    pub threshold: std::option::Option<f64>,
    /// <p>The update to the frequency value that subscribers receive notifications. </p>
    pub frequency: std::option::Option<crate::model::AnomalySubscriptionFrequency>,
    /// <p>A list of cost anomaly monitor ARNs. </p>
    pub monitor_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The update to the subscriber list. </p>
    pub subscribers: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
    /// <p>The new name of the subscription. </p>
    pub subscription_name: std::option::Option<std::string::String>,
}
impl UpdateAnomalySubscriptionInput {
    /// <p>A cost anomaly subscription Amazon Resource Name (ARN). </p>
    pub fn subscription_arn(&self) -> std::option::Option<&str> {
        self.subscription_arn.as_deref()
    }
    /// <p>The update to the threshold value for receiving notifications. </p>
    pub fn threshold(&self) -> std::option::Option<f64> {
        self.threshold
    }
    /// <p>The update to the frequency value that subscribers receive notifications. </p>
    pub fn frequency(&self) -> std::option::Option<&crate::model::AnomalySubscriptionFrequency> {
        self.frequency.as_ref()
    }
    /// <p>A list of cost anomaly monitor ARNs. </p>
    pub fn monitor_arn_list(&self) -> std::option::Option<&[std::string::String]> {
        self.monitor_arn_list.as_deref()
    }
    /// <p>The update to the subscriber list. </p>
    pub fn subscribers(&self) -> std::option::Option<&[crate::model::Subscriber]> {
        self.subscribers.as_deref()
    }
    /// <p>The new name of the subscription. </p>
    pub fn subscription_name(&self) -> std::option::Option<&str> {
        self.subscription_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateAnomalySubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnomalySubscriptionInput");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.field("threshold", &self.threshold);
        formatter.field("frequency", &self.frequency);
        formatter.field("monitor_arn_list", &self.monitor_arn_list);
        formatter.field("subscribers", &self.subscribers);
        formatter.field("subscription_name", &self.subscription_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnomalyMonitorInput {
    /// <p>Cost anomaly monitor Amazon Resource Names (ARNs). </p>
    pub monitor_arn: std::option::Option<std::string::String>,
    /// <p>The new name for the cost anomaly monitor. </p>
    pub monitor_name: std::option::Option<std::string::String>,
}
impl UpdateAnomalyMonitorInput {
    /// <p>Cost anomaly monitor Amazon Resource Names (ARNs). </p>
    pub fn monitor_arn(&self) -> std::option::Option<&str> {
        self.monitor_arn.as_deref()
    }
    /// <p>The new name for the cost anomaly monitor. </p>
    pub fn monitor_name(&self) -> std::option::Option<&str> {
        self.monitor_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateAnomalyMonitorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnomalyMonitorInput");
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.field("monitor_name", &self.monitor_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvideAnomalyFeedbackInput {
    /// <p>A cost anomaly ID. </p>
    pub anomaly_id: std::option::Option<std::string::String>,
    /// <p>Describes whether the cost anomaly was a planned activity or you considered it an anomaly. </p>
    pub feedback: std::option::Option<crate::model::AnomalyFeedbackType>,
}
impl ProvideAnomalyFeedbackInput {
    /// <p>A cost anomaly ID. </p>
    pub fn anomaly_id(&self) -> std::option::Option<&str> {
        self.anomaly_id.as_deref()
    }
    /// <p>Describes whether the cost anomaly was a planned activity or you considered it an anomaly. </p>
    pub fn feedback(&self) -> std::option::Option<&crate::model::AnomalyFeedbackType> {
        self.feedback.as_ref()
    }
}
impl std::fmt::Debug for ProvideAnomalyFeedbackInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvideAnomalyFeedbackInput");
        formatter.field("anomaly_id", &self.anomaly_id);
        formatter.field("feedback", &self.feedback);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCostCategoryDefinitionsInput {
    /// <p> The date when the Cost Category was effective. </p>
    pub effective_on: std::option::Option<std::string::String>,
    /// <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The number of entries a paginated response contains. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListCostCategoryDefinitionsInput {
    /// <p> The date when the Cost Category was effective. </p>
    pub fn effective_on(&self) -> std::option::Option<&str> {
        self.effective_on.as_deref()
    }
    /// <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The number of entries a paginated response contains. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListCostCategoryDefinitionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCostCategoryDefinitionsInput");
        formatter.field("effective_on", &self.effective_on);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsageForecastInput {
    /// <p>The start and end dates of the period that you want to retrieve usage forecast for. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. The start date must be equal to or later than the current date to avoid a validation error.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>Which metric Cost Explorer uses to create your forecast.</p>
    /// <p>Valid values for a <code>GetUsageForecast</code> call are the following:</p>
    /// <ul>
    /// <li> <p>USAGE_QUANTITY</p> </li>
    /// <li> <p>NORMALIZED_USAGE_AMOUNT</p> </li>
    /// </ul>
    pub metric: std::option::Option<crate::model::Metric>,
    /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
    /// <p>The <code>GetUsageForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>The filters that you want to use to filter your forecast. The <code>GetUsageForecast</code> API supports filtering by the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>AZ</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
    /// <li> <p> <code>OPERATION</code> </p> </li>
    /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>SERVICE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
    /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
    /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
    /// <li> <p> <code>TENANCY</code> </p> </li>
    /// <li> <p> <code>SCOPE</code> </p> </li>
    /// <li> <p> <code>PLATFORM</code> </p> </li>
    /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
    /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
    /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
    /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// </ul>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
    pub prediction_interval_level: std::option::Option<i32>,
}
impl GetUsageForecastInput {
    /// <p>The start and end dates of the period that you want to retrieve usage forecast for. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. The start date must be equal to or later than the current date to avoid a validation error.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>Which metric Cost Explorer uses to create your forecast.</p>
    /// <p>Valid values for a <code>GetUsageForecast</code> call are the following:</p>
    /// <ul>
    /// <li> <p>USAGE_QUANTITY</p> </li>
    /// <li> <p>NORMALIZED_USAGE_AMOUNT</p> </li>
    /// </ul>
    pub fn metric(&self) -> std::option::Option<&crate::model::Metric> {
        self.metric.as_ref()
    }
    /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
    /// <p>The <code>GetUsageForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>The filters that you want to use to filter your forecast. The <code>GetUsageForecast</code> API supports filtering by the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>AZ</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
    /// <li> <p> <code>OPERATION</code> </p> </li>
    /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>SERVICE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
    /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
    /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
    /// <li> <p> <code>TENANCY</code> </p> </li>
    /// <li> <p> <code>SCOPE</code> </p> </li>
    /// <li> <p> <code>PLATFORM</code> </p> </li>
    /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
    /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
    /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
    /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// </ul>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
    pub fn prediction_interval_level(&self) -> std::option::Option<i32> {
        self.prediction_interval_level
    }
}
impl std::fmt::Debug for GetUsageForecastInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsageForecastInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("metric", &self.metric);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("prediction_interval_level", &self.prediction_interval_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsInput {
    /// <p>The value that you want to search for.</p>
    pub search_string: std::option::Option<std::string::String>,
    /// <p>The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The key of the tag that you want to return values for.</p>
    pub tag_key: std::option::Option<std::string::String>,
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The key represents cost and usage metrics. The following values are supported:</p>
    /// <ul>
    /// <li> <p> <code>BlendedCost</code> </p> </li>
    /// <li> <p> <code>UnblendedCost</code> </p> </li>
    /// <li> <p> <code>AmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
    /// <li> <p> <code>UsageQuantity</code> </p> </li>
    /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    pub sort_by: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
    /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
    /// <p>For <code>GetTags</code>, MaxResults has an upper limit of 1000.</p>
    pub max_results: i32,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl GetTagsInput {
    /// <p>The value that you want to search for.</p>
    pub fn search_string(&self) -> std::option::Option<&str> {
        self.search_string.as_deref()
    }
    /// <p>The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The key of the tag that you want to return values for.</p>
    pub fn tag_key(&self) -> std::option::Option<&str> {
        self.tag_key.as_deref()
    }
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The key represents cost and usage metrics. The following values are supported:</p>
    /// <ul>
    /// <li> <p> <code>BlendedCost</code> </p> </li>
    /// <li> <p> <code>UnblendedCost</code> </p> </li>
    /// <li> <p> <code>AmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
    /// <li> <p> <code>UsageQuantity</code> </p> </li>
    /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    pub fn sort_by(&self) -> std::option::Option<&[crate::model::SortDefinition]> {
        self.sort_by.as_deref()
    }
    /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
    /// <p>For <code>GetTags</code>, MaxResults has an upper limit of 1000.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for GetTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsInput");
        formatter.field("search_string", &self.search_string);
        formatter.field("time_period", &self.time_period);
        formatter.field("tag_key", &self.tag_key);
        formatter.field("filter", &self.filter);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansUtilizationDetailsInput {
    /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// </ul>
    /// <p> <code>GetSavingsPlansUtilizationDetails</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
    /// <p>Filtering by tags isn't supported.</p>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The data type.</p>
    pub data_type: std::option::Option<std::vec::Vec<crate::model::SavingsPlansDataType>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
    /// <li> <p> <code>TotalCommitment</code> </p> </li>
    /// <li> <p> <code>UsedCommitment</code> </p> </li>
    /// <li> <p> <code>UnusedCommitment</code> </p> </li>
    /// <li> <p> <code>NetSavings</code> </p> </li>
    /// <li> <p> <code>AmortizedRecurringCommitment</code> </p> </li>
    /// <li> <p> <code>AmortizedUpfrontCommitment</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub sort_by: std::option::Option<crate::model::SortDefinition>,
}
impl GetSavingsPlansUtilizationDetailsInput {
    /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// </ul>
    /// <p> <code>GetSavingsPlansUtilizationDetails</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
    /// <p>Filtering by tags isn't supported.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The data type.</p>
    pub fn data_type(&self) -> std::option::Option<&[crate::model::SavingsPlansDataType]> {
        self.data_type.as_deref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
    /// <li> <p> <code>TotalCommitment</code> </p> </li>
    /// <li> <p> <code>UsedCommitment</code> </p> </li>
    /// <li> <p> <code>UnusedCommitment</code> </p> </li>
    /// <li> <p> <code>NetSavings</code> </p> </li>
    /// <li> <p> <code>AmortizedRecurringCommitment</code> </p> </li>
    /// <li> <p> <code>AmortizedUpfrontCommitment</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SortDefinition> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for GetSavingsPlansUtilizationDetailsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansUtilizationDetailsInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("filter", &self.filter);
        formatter.field("data_type", &self.data_type);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansUtilizationInput {
    /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
    /// <p>The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLANS_TYPE</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// </ul>
    /// <p> <code>GetSavingsPlansUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
    /// <p>Filtering by tags isn't supported.</p>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
    /// <li> <p> <code>TotalCommitment</code> </p> </li>
    /// <li> <p> <code>UsedCommitment</code> </p> </li>
    /// <li> <p> <code>UnusedCommitment</code> </p> </li>
    /// <li> <p> <code>NetSavings</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub sort_by: std::option::Option<crate::model::SortDefinition>,
}
impl GetSavingsPlansUtilizationInput {
    /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
    /// <p>The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLANS_TYPE</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// </ul>
    /// <p> <code>GetSavingsPlansUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
    /// <p>Filtering by tags isn't supported.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
    /// <li> <p> <code>TotalCommitment</code> </p> </li>
    /// <li> <p> <code>UsedCommitment</code> </p> </li>
    /// <li> <p> <code>UnusedCommitment</code> </p> </li>
    /// <li> <p> <code>NetSavings</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SortDefinition> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for GetSavingsPlansUtilizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansUtilizationInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansPurchaseRecommendationInput {
    /// <p>The Savings Plans recommendation type requested.</p>
    pub savings_plans_type: std::option::Option<crate::model::SupportedSavingsPlansType>,
    /// <p>The savings plan recommendation term used to generate these recommendations.</p>
    pub term_in_years: std::option::Option<crate::model::TermInYears>,
    /// <p>The payment option used to generate these recommendations.</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    pub account_scope: std::option::Option<crate::model::AccountScope>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The number of recommendations that you want returned in a single response object.</p>
    pub page_size: i32,
    /// <p>The lookback period used to generate the recommendation.</p>
    pub lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
    /// <p>You can filter your recommendations by Account ID with the <code>LINKED_ACCOUNT</code> dimension. To filter your recommendations by Account ID, specify <code>Key</code> as <code>LINKED_ACCOUNT</code> and <code>Value</code> as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations.</p>
    /// <p>For GetSavingsPlansPurchaseRecommendation, the <code>Filter</code> does not include <code>CostCategories</code> or <code>Tags</code>. It only includes <code>Dimensions</code>. With <code>Dimensions</code>, <code>Key</code> must be <code>LINKED_ACCOUNT</code> and <code>Value</code> can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. <code>AND</code> and <code>OR</code> operators are not supported.</p>
    pub filter: std::option::Option<crate::model::Expression>,
}
impl GetSavingsPlansPurchaseRecommendationInput {
    /// <p>The Savings Plans recommendation type requested.</p>
    pub fn savings_plans_type(
        &self,
    ) -> std::option::Option<&crate::model::SupportedSavingsPlansType> {
        self.savings_plans_type.as_ref()
    }
    /// <p>The savings plan recommendation term used to generate these recommendations.</p>
    pub fn term_in_years(&self) -> std::option::Option<&crate::model::TermInYears> {
        self.term_in_years.as_ref()
    }
    /// <p>The payment option used to generate these recommendations.</p>
    pub fn payment_option(&self) -> std::option::Option<&crate::model::PaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    pub fn account_scope(&self) -> std::option::Option<&crate::model::AccountScope> {
        self.account_scope.as_ref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The number of recommendations that you want returned in a single response object.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The lookback period used to generate the recommendation.</p>
    pub fn lookback_period_in_days(
        &self,
    ) -> std::option::Option<&crate::model::LookbackPeriodInDays> {
        self.lookback_period_in_days.as_ref()
    }
    /// <p>You can filter your recommendations by Account ID with the <code>LINKED_ACCOUNT</code> dimension. To filter your recommendations by Account ID, specify <code>Key</code> as <code>LINKED_ACCOUNT</code> and <code>Value</code> as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations.</p>
    /// <p>For GetSavingsPlansPurchaseRecommendation, the <code>Filter</code> does not include <code>CostCategories</code> or <code>Tags</code>. It only includes <code>Dimensions</code>. With <code>Dimensions</code>, <code>Key</code> must be <code>LINKED_ACCOUNT</code> and <code>Value</code> can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. <code>AND</code> and <code>OR</code> operators are not supported.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
}
impl std::fmt::Debug for GetSavingsPlansPurchaseRecommendationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansPurchaseRecommendationInput");
        formatter.field("savings_plans_type", &self.savings_plans_type);
        formatter.field("term_in_years", &self.term_in_years);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("account_scope", &self.account_scope);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("page_size", &self.page_size);
        formatter.field("lookback_period_in_days", &self.lookback_period_in_days);
        formatter.field("filter", &self.filter);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansCoverageInput {
    /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or <code>SERVICE</code>.</p>
    pub group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
    /// <p>The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be set if <code>GroupBy</code> is set.</p>
    /// <p>The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>SERVICE</code> </p> </li>
    /// <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>
    /// </ul>
    /// <p> <code>GetSavingsPlansCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
    /// <p>Cost category is supported. Tags are not supported.</p>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The measurement that you want your Savings Plans coverage reported in. The only valid value is <code>SpendCoveredBySavingsPlans</code>.</p>
    pub metrics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>SpendCoveredBySavingsPlan</code> </p> </li>
    /// <li> <p> <code>OnDemandCost</code> </p> </li>
    /// <li> <p> <code>CoveragePercentage</code> </p> </li>
    /// <li> <p> <code>TotalCost</code> </p> </li>
    /// <li> <p> <code>InstanceFamily</code> </p> </li>
    /// <li> <p> <code>Region</code> </p> </li>
    /// <li> <p> <code>Service</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub sort_by: std::option::Option<crate::model::SortDefinition>,
}
impl GetSavingsPlansCoverageInput {
    /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or <code>SERVICE</code>.</p>
    pub fn group_by(&self) -> std::option::Option<&[crate::model::GroupDefinition]> {
        self.group_by.as_deref()
    }
    /// <p>The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be set if <code>GroupBy</code> is set.</p>
    /// <p>The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>SERVICE</code> </p> </li>
    /// <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>
    /// </ul>
    /// <p> <code>GetSavingsPlansCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
    /// <p>Cost category is supported. Tags are not supported.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The measurement that you want your Savings Plans coverage reported in. The only valid value is <code>SpendCoveredBySavingsPlans</code>.</p>
    pub fn metrics(&self) -> std::option::Option<&[std::string::String]> {
        self.metrics.as_deref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>SpendCoveredBySavingsPlan</code> </p> </li>
    /// <li> <p> <code>OnDemandCost</code> </p> </li>
    /// <li> <p> <code>CoveragePercentage</code> </p> </li>
    /// <li> <p> <code>TotalCost</code> </p> </li>
    /// <li> <p> <code>InstanceFamily</code> </p> </li>
    /// <li> <p> <code>Region</code> </p> </li>
    /// <li> <p> <code>Service</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SortDefinition> {
        self.sort_by.as_ref()
    }
}
impl std::fmt::Debug for GetSavingsPlansCoverageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansCoverageInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("group_by", &self.group_by);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("metrics", &self.metrics);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("sort_by", &self.sort_by);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRightsizingRecommendationInput {
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
    pub configuration: std::option::Option<crate::model::RightsizingRecommendationConfiguration>,
    /// <p>The specific service that you want recommendations for. The only valid value for <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>The number of recommendations that you want returned in a single response object.</p>
    pub page_size: i32,
    /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl GetRightsizingRecommendationInput {
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::RightsizingRecommendationConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>The specific service that you want recommendations for. The only valid value for <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".</p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p>The number of recommendations that you want returned in a single response object.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for GetRightsizingRecommendationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRightsizingRecommendationInput");
        formatter.field("filter", &self.filter);
        formatter.field("configuration", &self.configuration);
        formatter.field("service", &self.service);
        formatter.field("page_size", &self.page_size);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservationUtilizationInput {
    /// <p>Sets the start and end dates for retrieving RI utilization. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>Groups only by <code>SUBSCRIPTION_ID</code>. Metadata is included.</p>
    pub group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
    /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>. If both <code>GroupBy</code> and <code>Granularity</code> aren't set, <code>GetReservationUtilization</code> defaults to <code>DAILY</code>.</p>
    /// <p>The <code>GetReservationUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
    /// <ul>
    /// <li> <p>AZ</p> </li>
    /// <li> <p>CACHE_ENGINE</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION</p> </li>
    /// <li> <p>INSTANCE_TYPE</p> </li>
    /// <li> <p>LINKED_ACCOUNT</p> </li>
    /// <li> <p>OPERATING_SYSTEM</p> </li>
    /// <li> <p>PLATFORM</p> </li>
    /// <li> <p>REGION</p> </li>
    /// <li> <p>SERVICE</p> </li>
    /// <li> <p>SCOPE</p> </li>
    /// <li> <p>TENANCY</p> </li>
    /// </ul>
    /// <p> <code>GetReservationUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension, and nesting is supported up to only one level deep.</p>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
    /// <li> <p> <code>UtilizationPercentageInUnits</code> </p> </li>
    /// <li> <p> <code>PurchasedHours</code> </p> </li>
    /// <li> <p> <code>PurchasedUnits</code> </p> </li>
    /// <li> <p> <code>TotalActualHours</code> </p> </li>
    /// <li> <p> <code>TotalActualUnits</code> </p> </li>
    /// <li> <p> <code>UnusedHours</code> </p> </li>
    /// <li> <p> <code>UnusedUnits</code> </p> </li>
    /// <li> <p> <code>OnDemandCostOfRIHoursUsed</code> </p> </li>
    /// <li> <p> <code>NetRISavings</code> </p> </li>
    /// <li> <p> <code>TotalPotentialRISavings</code> </p> </li>
    /// <li> <p> <code>AmortizedUpfrontFee</code> </p> </li>
    /// <li> <p> <code>AmortizedRecurringFee</code> </p> </li>
    /// <li> <p> <code>TotalAmortizedFee</code> </p> </li>
    /// <li> <p> <code>RICostForUnusedHours</code> </p> </li>
    /// <li> <p> <code>RealizedSavings</code> </p> </li>
    /// <li> <p> <code>UnrealizedSavings</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub sort_by: std::option::Option<crate::model::SortDefinition>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetReservationUtilizationInput {
    /// <p>Sets the start and end dates for retrieving RI utilization. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>Groups only by <code>SUBSCRIPTION_ID</code>. Metadata is included.</p>
    pub fn group_by(&self) -> std::option::Option<&[crate::model::GroupDefinition]> {
        self.group_by.as_deref()
    }
    /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>. If both <code>GroupBy</code> and <code>Granularity</code> aren't set, <code>GetReservationUtilization</code> defaults to <code>DAILY</code>.</p>
    /// <p>The <code>GetReservationUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
    /// <ul>
    /// <li> <p>AZ</p> </li>
    /// <li> <p>CACHE_ENGINE</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION</p> </li>
    /// <li> <p>INSTANCE_TYPE</p> </li>
    /// <li> <p>LINKED_ACCOUNT</p> </li>
    /// <li> <p>OPERATING_SYSTEM</p> </li>
    /// <li> <p>PLATFORM</p> </li>
    /// <li> <p>REGION</p> </li>
    /// <li> <p>SERVICE</p> </li>
    /// <li> <p>SCOPE</p> </li>
    /// <li> <p>TENANCY</p> </li>
    /// </ul>
    /// <p> <code>GetReservationUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension, and nesting is supported up to only one level deep.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
    /// <li> <p> <code>UtilizationPercentageInUnits</code> </p> </li>
    /// <li> <p> <code>PurchasedHours</code> </p> </li>
    /// <li> <p> <code>PurchasedUnits</code> </p> </li>
    /// <li> <p> <code>TotalActualHours</code> </p> </li>
    /// <li> <p> <code>TotalActualUnits</code> </p> </li>
    /// <li> <p> <code>UnusedHours</code> </p> </li>
    /// <li> <p> <code>UnusedUnits</code> </p> </li>
    /// <li> <p> <code>OnDemandCostOfRIHoursUsed</code> </p> </li>
    /// <li> <p> <code>NetRISavings</code> </p> </li>
    /// <li> <p> <code>TotalPotentialRISavings</code> </p> </li>
    /// <li> <p> <code>AmortizedUpfrontFee</code> </p> </li>
    /// <li> <p> <code>AmortizedRecurringFee</code> </p> </li>
    /// <li> <p> <code>TotalAmortizedFee</code> </p> </li>
    /// <li> <p> <code>RICostForUnusedHours</code> </p> </li>
    /// <li> <p> <code>RealizedSavings</code> </p> </li>
    /// <li> <p> <code>UnrealizedSavings</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SortDefinition> {
        self.sort_by.as_ref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetReservationUtilizationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservationUtilizationInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("group_by", &self.group_by);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservationPurchaseRecommendationInput {
    /// <p>The account ID that is associated with the recommendation. </p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The specific service that you want recommendations for.</p>
    pub service: std::option::Option<std::string::String>,
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    pub account_scope: std::option::Option<crate::model::AccountScope>,
    /// <p>The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.</p>
    pub lookback_period_in_days: std::option::Option<crate::model::LookbackPeriodInDays>,
    /// <p>The reservation term that you want recommendations for.</p>
    pub term_in_years: std::option::Option<crate::model::TermInYears>,
    /// <p>The reservation purchase option that you want recommendations for.</p>
    pub payment_option: std::option::Option<crate::model::PaymentOption>,
    /// <p>The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.</p>
    pub service_specification: std::option::Option<crate::model::ServiceSpecification>,
    /// <p>The number of recommendations that you want returned in a single response object.</p>
    pub page_size: i32,
    /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl GetReservationPurchaseRecommendationInput {
    /// <p>The account ID that is associated with the recommendation. </p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The specific service that you want recommendations for.</p>
    pub fn service(&self) -> std::option::Option<&str> {
        self.service.as_deref()
    }
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    pub fn account_scope(&self) -> std::option::Option<&crate::model::AccountScope> {
        self.account_scope.as_ref()
    }
    /// <p>The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.</p>
    pub fn lookback_period_in_days(
        &self,
    ) -> std::option::Option<&crate::model::LookbackPeriodInDays> {
        self.lookback_period_in_days.as_ref()
    }
    /// <p>The reservation term that you want recommendations for.</p>
    pub fn term_in_years(&self) -> std::option::Option<&crate::model::TermInYears> {
        self.term_in_years.as_ref()
    }
    /// <p>The reservation purchase option that you want recommendations for.</p>
    pub fn payment_option(&self) -> std::option::Option<&crate::model::PaymentOption> {
        self.payment_option.as_ref()
    }
    /// <p>The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.</p>
    pub fn service_specification(
        &self,
    ) -> std::option::Option<&crate::model::ServiceSpecification> {
        self.service_specification.as_ref()
    }
    /// <p>The number of recommendations that you want returned in a single response object.</p>
    pub fn page_size(&self) -> i32 {
        self.page_size
    }
    /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for GetReservationPurchaseRecommendationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservationPurchaseRecommendationInput");
        formatter.field("account_id", &self.account_id);
        formatter.field("service", &self.service);
        formatter.field("filter", &self.filter);
        formatter.field("account_scope", &self.account_scope);
        formatter.field("lookback_period_in_days", &self.lookback_period_in_days);
        formatter.field("term_in_years", &self.term_in_years);
        formatter.field("payment_option", &self.payment_option);
        formatter.field("service_specification", &self.service_specification);
        formatter.field("page_size", &self.page_size);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}

/// <p>You can use the following request parameters to query for how much of your instance usage a reservation covered.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservationCoverageInput {
    /// <p>The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>You can group the data by the following attributes:</p>
    /// <ul>
    /// <li> <p>AZ</p> </li>
    /// <li> <p>CACHE_ENGINE</p> </li>
    /// <li> <p>DATABASE_ENGINE</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION</p> </li>
    /// <li> <p>INSTANCE_TYPE</p> </li>
    /// <li> <p>LINKED_ACCOUNT</p> </li>
    /// <li> <p>OPERATING_SYSTEM</p> </li>
    /// <li> <p>PLATFORM</p> </li>
    /// <li> <p>REGION</p> </li>
    /// <li> <p>TENANCY</p> </li>
    /// </ul>
    pub group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
    /// <p>The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code> and <code>DAILY</code>.</p>
    /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.</p>
    /// <p>The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
    /// <ul>
    /// <li> <p>AZ</p> </li>
    /// <li> <p>CACHE_ENGINE</p> </li>
    /// <li> <p>DATABASE_ENGINE</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION</p> </li>
    /// <li> <p>INSTANCE_TYPE</p> </li>
    /// <li> <p>LINKED_ACCOUNT</p> </li>
    /// <li> <p>OPERATING_SYSTEM</p> </li>
    /// <li> <p>PLATFORM</p> </li>
    /// <li> <p>REGION</p> </li>
    /// <li> <p>SERVICE</p> </li>
    /// <li> <p>TAG</p> </li>
    /// <li> <p>TENANCY</p> </li>
    /// </ul>
    /// <p> <code>GetReservationCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only one level deep.</p>
    /// <p>If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.</p>
    /// <p>Cost category is also supported.</p>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The measurement that you want your reservation coverage reported in.</p>
    /// <p>Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a request.</p>
    pub metrics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>OnDemandCost</code> </p> </li>
    /// <li> <p> <code>CoverageHoursPercentage</code> </p> </li>
    /// <li> <p> <code>OnDemandHours</code> </p> </li>
    /// <li> <p> <code>ReservedHours</code> </p> </li>
    /// <li> <p> <code>TotalRunningHours</code> </p> </li>
    /// <li> <p> <code>CoverageNormalizedUnitsPercentage</code> </p> </li>
    /// <li> <p> <code>OnDemandNormalizedUnits</code> </p> </li>
    /// <li> <p> <code>ReservedNormalizedUnits</code> </p> </li>
    /// <li> <p> <code>TotalRunningNormalizedUnits</code> </p> </li>
    /// <li> <p> <code>Time</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub sort_by: std::option::Option<crate::model::SortDefinition>,
    /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
    pub max_results: std::option::Option<i32>,
}
impl GetReservationCoverageInput {
    /// <p>The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>You can group the data by the following attributes:</p>
    /// <ul>
    /// <li> <p>AZ</p> </li>
    /// <li> <p>CACHE_ENGINE</p> </li>
    /// <li> <p>DATABASE_ENGINE</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION</p> </li>
    /// <li> <p>INSTANCE_TYPE</p> </li>
    /// <li> <p>LINKED_ACCOUNT</p> </li>
    /// <li> <p>OPERATING_SYSTEM</p> </li>
    /// <li> <p>PLATFORM</p> </li>
    /// <li> <p>REGION</p> </li>
    /// <li> <p>TENANCY</p> </li>
    /// </ul>
    pub fn group_by(&self) -> std::option::Option<&[crate::model::GroupDefinition]> {
        self.group_by.as_deref()
    }
    /// <p>The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code> and <code>DAILY</code>.</p>
    /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.</p>
    /// <p>The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
    /// <ul>
    /// <li> <p>AZ</p> </li>
    /// <li> <p>CACHE_ENGINE</p> </li>
    /// <li> <p>DATABASE_ENGINE</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION</p> </li>
    /// <li> <p>INSTANCE_TYPE</p> </li>
    /// <li> <p>LINKED_ACCOUNT</p> </li>
    /// <li> <p>OPERATING_SYSTEM</p> </li>
    /// <li> <p>PLATFORM</p> </li>
    /// <li> <p>REGION</p> </li>
    /// <li> <p>SERVICE</p> </li>
    /// <li> <p>TAG</p> </li>
    /// <li> <p>TENANCY</p> </li>
    /// </ul>
    /// <p> <code>GetReservationCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only one level deep.</p>
    /// <p>If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.</p>
    /// <p>Cost category is also supported.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The measurement that you want your reservation coverage reported in.</p>
    /// <p>Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a request.</p>
    pub fn metrics(&self) -> std::option::Option<&[std::string::String]> {
        self.metrics.as_deref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The following values are supported for <code>Key</code>:</p>
    /// <ul>
    /// <li> <p> <code>OnDemandCost</code> </p> </li>
    /// <li> <p> <code>CoverageHoursPercentage</code> </p> </li>
    /// <li> <p> <code>OnDemandHours</code> </p> </li>
    /// <li> <p> <code>ReservedHours</code> </p> </li>
    /// <li> <p> <code>TotalRunningHours</code> </p> </li>
    /// <li> <p> <code>CoverageNormalizedUnitsPercentage</code> </p> </li>
    /// <li> <p> <code>OnDemandNormalizedUnits</code> </p> </li>
    /// <li> <p> <code>ReservedNormalizedUnits</code> </p> </li>
    /// <li> <p> <code>TotalRunningNormalizedUnits</code> </p> </li>
    /// <li> <p> <code>Time</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::SortDefinition> {
        self.sort_by.as_ref()
    }
    /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetReservationCoverageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservationCoverageInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("group_by", &self.group_by);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("metrics", &self.metrics);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDimensionValuesInput {
    /// <p>The value that you want to search the filter values for.</p>
    pub search_string: std::option::Option<std::string::String>,
    /// <p>The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html#awscostmanagement-GetDimensionValues-request-Context">Context</a>. </p>
    pub dimension: std::option::Option<crate::model::Dimension>,
    /// <p>The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to <code>RESERVATIONS</code>, the resulting dimension values can be used in the <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
    /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>
    /// <ul>
    /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
    /// <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>
    /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
    /// <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>
    /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
    /// <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>
    /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>
    /// <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>
    /// <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>
    /// <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>
    /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
    /// <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>
    /// <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>
    /// </ul>
    /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>
    /// <ul>
    /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
    /// <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>
    /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
    /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
    /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
    /// <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>
    /// <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>
    /// <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>
    /// </ul>
    /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
    /// <ul>
    /// <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>
    /// <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>
    /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
    /// <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>
    /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
    /// <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>
    /// </ul>
    pub context: std::option::Option<crate::model::Context>,
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The key represents cost and usage metrics. The following values are supported:</p>
    /// <ul>
    /// <li> <p> <code>BlendedCost</code> </p> </li>
    /// <li> <p> <code>UnblendedCost</code> </p> </li>
    /// <li> <p> <code>AmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
    /// <li> <p> <code>UsageQuantity</code> </p> </li>
    /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <p>When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    pub sort_by: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
    /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
    /// <p>For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.</p>
    pub max_results: i32,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl GetDimensionValuesInput {
    /// <p>The value that you want to search the filter values for.</p>
    pub fn search_string(&self) -> std::option::Option<&str> {
        self.search_string.as_deref()
    }
    /// <p>The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html#awscostmanagement-GetDimensionValues-request-Context">Context</a>. </p>
    pub fn dimension(&self) -> std::option::Option<&crate::model::Dimension> {
        self.dimension.as_ref()
    }
    /// <p>The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to <code>RESERVATIONS</code>, the resulting dimension values can be used in the <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
    /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>
    /// <ul>
    /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
    /// <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>
    /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
    /// <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>
    /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
    /// <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>
    /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>
    /// <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>
    /// <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>
    /// <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>
    /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
    /// <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>
    /// <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>
    /// </ul>
    /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>
    /// <ul>
    /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
    /// <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>
    /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
    /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
    /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
    /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
    /// <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>
    /// <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>
    /// <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>
    /// </ul>
    /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
    /// <ul>
    /// <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>
    /// <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>
    /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
    /// <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>
    /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
    /// <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>
    /// </ul>
    pub fn context(&self) -> std::option::Option<&crate::model::Context> {
        self.context.as_ref()
    }
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The key represents cost and usage metrics. The following values are supported:</p>
    /// <ul>
    /// <li> <p> <code>BlendedCost</code> </p> </li>
    /// <li> <p> <code>UnblendedCost</code> </p> </li>
    /// <li> <p> <code>AmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
    /// <li> <p> <code>UsageQuantity</code> </p> </li>
    /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <p>When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    pub fn sort_by(&self) -> std::option::Option<&[crate::model::SortDefinition]> {
        self.sort_by.as_deref()
    }
    /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
    /// <p>For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for GetDimensionValuesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDimensionValuesInput");
        formatter.field("search_string", &self.search_string);
        formatter.field("time_period", &self.time_period);
        formatter.field("dimension", &self.dimension);
        formatter.field("context", &self.context);
        formatter.field("filter", &self.filter);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostForecastInput {
    /// <p>The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
    /// <p>Valid values for a <code>GetCostForecast</code> call are the following:</p>
    /// <ul>
    /// <li> <p>AMORTIZED_COST</p> </li>
    /// <li> <p>BLENDED_COST</p> </li>
    /// <li> <p>NET_AMORTIZED_COST</p> </li>
    /// <li> <p>NET_UNBLENDED_COST</p> </li>
    /// <li> <p>UNBLENDED_COST</p> </li>
    /// </ul>
    pub metric: std::option::Option<crate::model::Metric>,
    /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
    /// <p>The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering by the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>AZ</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
    /// <li> <p> <code>OPERATION</code> </p> </li>
    /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>SERVICE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
    /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
    /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
    /// <li> <p> <code>TENANCY</code> </p> </li>
    /// <li> <p> <code>SCOPE</code> </p> </li>
    /// <li> <p> <code>PLATFORM</code> </p> </li>
    /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
    /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
    /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
    /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// </ul>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
    pub prediction_interval_level: std::option::Option<i32>,
}
impl GetCostForecastInput {
    /// <p>The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
    /// <p>Valid values for a <code>GetCostForecast</code> call are the following:</p>
    /// <ul>
    /// <li> <p>AMORTIZED_COST</p> </li>
    /// <li> <p>BLENDED_COST</p> </li>
    /// <li> <p>NET_AMORTIZED_COST</p> </li>
    /// <li> <p>NET_UNBLENDED_COST</p> </li>
    /// <li> <p>UNBLENDED_COST</p> </li>
    /// </ul>
    pub fn metric(&self) -> std::option::Option<&crate::model::Metric> {
        self.metric.as_ref()
    }
    /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
    /// <p>The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering by the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>AZ</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
    /// <li> <p> <code>OPERATION</code> </p> </li>
    /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>SERVICE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
    /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
    /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
    /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
    /// <li> <p> <code>TENANCY</code> </p> </li>
    /// <li> <p> <code>SCOPE</code> </p> </li>
    /// <li> <p> <code>PLATFORM</code> </p> </li>
    /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
    /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
    /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
    /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
    /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
    /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
    /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
    /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
    /// </ul>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
    pub fn prediction_interval_level(&self) -> std::option::Option<i32> {
        self.prediction_interval_level
    }
}
impl std::fmt::Debug for GetCostForecastInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostForecastInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("metric", &self.metric);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("prediction_interval_level", &self.prediction_interval_level);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostCategoriesInput {
    /// <p>The value that you want to search the filter values for.</p>
    /// <p>If you do not specify a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category names that match the <code>SearchString</code> pattern. If you do specifiy a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category values that match the <code>SearchString</code> pattern.</p>
    pub search_string: std::option::Option<std::string::String>,
    /// <p>The time period of the request. </p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The unique name of the Cost Category.</p>
    pub cost_category_name: std::option::Option<std::string::String>,
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The key represents cost and usage metrics. The following values are supported:</p>
    /// <ul>
    /// <li> <p> <code>BlendedCost</code> </p> </li>
    /// <li> <p> <code>UnblendedCost</code> </p> </li>
    /// <li> <p> <code>AmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
    /// <li> <p> <code>UsageQuantity</code> </p> </li>
    /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    pub sort_by: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
    /// <p>This field is only used when <code>SortBy</code> is provided in the request.</p>
    /// <p>The maximum number of objects that to be returned for this request. If <code>MaxResults</code> is not specified with <code>SortBy</code>, the request will return 1000 results as the default value for this parameter.</p>
    /// <p>For <code>GetCostCategories</code>, MaxResults has an upper limit of 1000.</p>
    pub max_results: i32,
    /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the prior call in your next request.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl GetCostCategoriesInput {
    /// <p>The value that you want to search the filter values for.</p>
    /// <p>If you do not specify a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category names that match the <code>SearchString</code> pattern. If you do specifiy a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category values that match the <code>SearchString</code> pattern.</p>
    pub fn search_string(&self) -> std::option::Option<&str> {
        self.search_string.as_deref()
    }
    /// <p>The time period of the request. </p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>The unique name of the Cost Category.</p>
    pub fn cost_category_name(&self) -> std::option::Option<&str> {
        self.cost_category_name.as_deref()
    }
    /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
    /// <ul>
    /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
    /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
    /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
    /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
    /// </ul> <note>
    /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
    /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
    /// </note>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>The value by which you want to sort the data.</p>
    /// <p>The key represents cost and usage metrics. The following values are supported:</p>
    /// <ul>
    /// <li> <p> <code>BlendedCost</code> </p> </li>
    /// <li> <p> <code>UnblendedCost</code> </p> </li>
    /// <li> <p> <code>AmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
    /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
    /// <li> <p> <code>UsageQuantity</code> </p> </li>
    /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
    /// </ul>
    /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    pub fn sort_by(&self) -> std::option::Option<&[crate::model::SortDefinition]> {
        self.sort_by.as_deref()
    }
    /// <p>This field is only used when <code>SortBy</code> is provided in the request.</p>
    /// <p>The maximum number of objects that to be returned for this request. If <code>MaxResults</code> is not specified with <code>SortBy</code>, the request will return 1000 results as the default value for this parameter.</p>
    /// <p>For <code>GetCostCategories</code>, MaxResults has an upper limit of 1000.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the prior call in your next request.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for GetCostCategoriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostCategoriesInput");
        formatter.field("search_string", &self.search_string);
        formatter.field("time_period", &self.time_period);
        formatter.field("cost_category_name", &self.cost_category_name);
        formatter.field("filter", &self.filter);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostAndUsageWithResourcesInput {
    /// <p>Sets the start and end dates for retrieving Amazon Web Services costs. The range must be within the last 14 days (the start date cannot be earlier than 14 days ago). The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. </p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
    /// <p>The <code>GetCostAndUsageWithResources</code> operation requires that you either group by or filter by a <code>ResourceId</code>. It requires the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> <code>"SERVICE = Amazon Elastic Compute Cloud - Compute"</code> in the filter.</p>
    /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
    /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
    /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking the units into account. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours vs. GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
    /// </note>
    /// <p> <code>Metrics</code> is required for <code>GetCostAndUsageWithResources</code> requests.</p>
    pub metrics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>You can group Amazon Web Services costs using up to two different groups: <code>DIMENSION</code>, <code>TAG</code>, <code>COST_CATEGORY</code>.</p>
    pub group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl GetCostAndUsageWithResourcesInput {
    /// <p>Sets the start and end dates for retrieving Amazon Web Services costs. The range must be within the last 14 days (the start date cannot be earlier than 14 days ago). The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. </p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
    /// <p>The <code>GetCostAndUsageWithResources</code> operation requires that you either group by or filter by a <code>ResourceId</code>. It requires the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> <code>"SERVICE = Amazon Elastic Compute Cloud - Compute"</code> in the filter.</p>
    /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
    /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
    /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking the units into account. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours vs. GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
    /// </note>
    /// <p> <code>Metrics</code> is required for <code>GetCostAndUsageWithResources</code> requests.</p>
    pub fn metrics(&self) -> std::option::Option<&[std::string::String]> {
        self.metrics.as_deref()
    }
    /// <p>You can group Amazon Web Services costs using up to two different groups: <code>DIMENSION</code>, <code>TAG</code>, <code>COST_CATEGORY</code>.</p>
    pub fn group_by(&self) -> std::option::Option<&[crate::model::GroupDefinition]> {
        self.group_by.as_deref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for GetCostAndUsageWithResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostAndUsageWithResourcesInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("metrics", &self.metrics);
        formatter.field("group_by", &self.group_by);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostAndUsageInput {
    /// <p>Sets the start date and end date for retrieving Amazon Web Services costs. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. </p>
    pub granularity: std::option::Option<crate::model::Granularity>,
    /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
    /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
    pub filter: std::option::Option<crate::model::Expression>,
    /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
    /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
    /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking into account the units. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours and GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
    /// </note>
    /// <p> <code>Metrics</code> is required for <code>GetCostAndUsage</code> requests.</p>
    pub metrics: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>You can group Amazon Web Services costs using up to two different groups, either dimensions, tag keys, cost categories, or any two group by types.</p>
    /// <p>Valid values for the <code>DIMENSION</code> type are <code>AZ</code>, <code>INSTANCE_TYPE</code>, <code>LEGAL_ENTITY_NAME</code>, <code>LINKED_ACCOUNT</code>, <code>OPERATION</code>, <code>PLATFORM</code>, <code>PURCHASE_TYPE</code>, <code>SERVICE</code>, <code>TENANCY</code>, <code>RECORD_TYPE</code>, and <code>USAGE_TYPE</code>.</p>
    /// <p>When you group by the <code>TAG</code> type and include a valid tag key, you get all tag values, including empty strings.</p>
    pub group_by: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl GetCostAndUsageInput {
    /// <p>Sets the start date and end date for retrieving Amazon Web Services costs. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    pub fn time_period(&self) -> std::option::Option<&crate::model::DateInterval> {
        self.time_period.as_ref()
    }
    /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. </p>
    pub fn granularity(&self) -> std::option::Option<&crate::model::Granularity> {
        self.granularity.as_ref()
    }
    /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
    /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
    /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
    pub fn filter(&self) -> std::option::Option<&crate::model::Expression> {
        self.filter.as_ref()
    }
    /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
    /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
    /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking into account the units. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours and GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
    /// </note>
    /// <p> <code>Metrics</code> is required for <code>GetCostAndUsage</code> requests.</p>
    pub fn metrics(&self) -> std::option::Option<&[std::string::String]> {
        self.metrics.as_deref()
    }
    /// <p>You can group Amazon Web Services costs using up to two different groups, either dimensions, tag keys, cost categories, or any two group by types.</p>
    /// <p>Valid values for the <code>DIMENSION</code> type are <code>AZ</code>, <code>INSTANCE_TYPE</code>, <code>LEGAL_ENTITY_NAME</code>, <code>LINKED_ACCOUNT</code>, <code>OPERATION</code>, <code>PLATFORM</code>, <code>PURCHASE_TYPE</code>, <code>SERVICE</code>, <code>TENANCY</code>, <code>RECORD_TYPE</code>, and <code>USAGE_TYPE</code>.</p>
    /// <p>When you group by the <code>TAG</code> type and include a valid tag key, you get all tag values, including empty strings.</p>
    pub fn group_by(&self) -> std::option::Option<&[crate::model::GroupDefinition]> {
        self.group_by.as_deref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
}
impl std::fmt::Debug for GetCostAndUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostAndUsageInput");
        formatter.field("time_period", &self.time_period);
        formatter.field("granularity", &self.granularity);
        formatter.field("filter", &self.filter);
        formatter.field("metrics", &self.metrics);
        formatter.field("group_by", &self.group_by);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomalySubscriptionsInput {
    /// <p>A list of cost anomaly subscription ARNs. </p>
    pub subscription_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Cost anomaly monitor ARNs. </p>
    pub monitor_arn: std::option::Option<std::string::String>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The number of entries a paginated response contains. </p>
    pub max_results: std::option::Option<i32>,
}
impl GetAnomalySubscriptionsInput {
    /// <p>A list of cost anomaly subscription ARNs. </p>
    pub fn subscription_arn_list(&self) -> std::option::Option<&[std::string::String]> {
        self.subscription_arn_list.as_deref()
    }
    /// <p>Cost anomaly monitor ARNs. </p>
    pub fn monitor_arn(&self) -> std::option::Option<&str> {
        self.monitor_arn.as_deref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The number of entries a paginated response contains. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetAnomalySubscriptionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomalySubscriptionsInput");
        formatter.field("subscription_arn_list", &self.subscription_arn_list);
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomalyMonitorsInput {
    /// <p>A list of cost anomaly monitor ARNs. </p>
    pub monitor_arn_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The number of entries that a paginated response contains. </p>
    pub max_results: std::option::Option<i32>,
}
impl GetAnomalyMonitorsInput {
    /// <p>A list of cost anomaly monitor ARNs. </p>
    pub fn monitor_arn_list(&self) -> std::option::Option<&[std::string::String]> {
        self.monitor_arn_list.as_deref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The number of entries that a paginated response contains. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetAnomalyMonitorsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomalyMonitorsInput");
        formatter.field("monitor_arn_list", &self.monitor_arn_list);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomaliesInput {
    /// <p>Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). </p>
    pub monitor_arn: std::option::Option<std::string::String>,
    /// <p>Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an <code>AnomalyEndDate</code> in the specified time range. </p>
    pub date_interval: std::option::Option<crate::model::AnomalyDateInterval>,
    /// <p>Filters anomaly results by the feedback field on the anomaly object. </p>
    pub feedback: std::option::Option<crate::model::AnomalyFeedbackType>,
    /// <p>Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200. </p>
    pub total_impact: std::option::Option<crate::model::TotalImpactFilter>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The number of entries a paginated response contains. </p>
    pub max_results: std::option::Option<i32>,
}
impl GetAnomaliesInput {
    /// <p>Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). </p>
    pub fn monitor_arn(&self) -> std::option::Option<&str> {
        self.monitor_arn.as_deref()
    }
    /// <p>Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an <code>AnomalyEndDate</code> in the specified time range. </p>
    pub fn date_interval(&self) -> std::option::Option<&crate::model::AnomalyDateInterval> {
        self.date_interval.as_ref()
    }
    /// <p>Filters anomaly results by the feedback field on the anomaly object. </p>
    pub fn feedback(&self) -> std::option::Option<&crate::model::AnomalyFeedbackType> {
        self.feedback.as_ref()
    }
    /// <p>Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200. </p>
    pub fn total_impact(&self) -> std::option::Option<&crate::model::TotalImpactFilter> {
        self.total_impact.as_ref()
    }
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    pub fn next_page_token(&self) -> std::option::Option<&str> {
        self.next_page_token.as_deref()
    }
    /// <p>The number of entries a paginated response contains. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for GetAnomaliesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomaliesInput");
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.field("date_interval", &self.date_interval);
        formatter.field("feedback", &self.feedback);
        formatter.field("total_impact", &self.total_impact);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCostCategoryDefinitionInput {
    /// <p> The unique identifier for your Cost Category. </p>
    pub cost_category_arn: std::option::Option<std::string::String>,
    /// <p> The date when the Cost Category was effective. </p>
    pub effective_on: std::option::Option<std::string::String>,
}
impl DescribeCostCategoryDefinitionInput {
    /// <p> The unique identifier for your Cost Category. </p>
    pub fn cost_category_arn(&self) -> std::option::Option<&str> {
        self.cost_category_arn.as_deref()
    }
    /// <p> The date when the Cost Category was effective. </p>
    pub fn effective_on(&self) -> std::option::Option<&str> {
        self.effective_on.as_deref()
    }
}
impl std::fmt::Debug for DescribeCostCategoryDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCostCategoryDefinitionInput");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.field("effective_on", &self.effective_on);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCostCategoryDefinitionInput {
    /// <p> The unique identifier for your Cost Category. </p>
    pub cost_category_arn: std::option::Option<std::string::String>,
}
impl DeleteCostCategoryDefinitionInput {
    /// <p> The unique identifier for your Cost Category. </p>
    pub fn cost_category_arn(&self) -> std::option::Option<&str> {
        self.cost_category_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteCostCategoryDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCostCategoryDefinitionInput");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnomalySubscriptionInput {
    /// <p>The unique identifier of the cost anomaly subscription that you want to delete. </p>
    pub subscription_arn: std::option::Option<std::string::String>,
}
impl DeleteAnomalySubscriptionInput {
    /// <p>The unique identifier of the cost anomaly subscription that you want to delete. </p>
    pub fn subscription_arn(&self) -> std::option::Option<&str> {
        self.subscription_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAnomalySubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnomalySubscriptionInput");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnomalyMonitorInput {
    /// <p>The unique identifier of the cost anomaly monitor that you want to delete. </p>
    pub monitor_arn: std::option::Option<std::string::String>,
}
impl DeleteAnomalyMonitorInput {
    /// <p>The unique identifier of the cost anomaly monitor that you want to delete. </p>
    pub fn monitor_arn(&self) -> std::option::Option<&str> {
        self.monitor_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteAnomalyMonitorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnomalyMonitorInput");
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCostCategoryDefinitionInput {
    /// <p>The unique name of the Cost Category.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The rule schema version in this particular Cost Category.</p>
    pub rule_version: std::option::Option<crate::model::CostCategoryRuleVersion>,
    /// <p>The Cost Category rules used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule</a>.</p>
    pub rules: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
    /// <p>The default value for the cost category.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
    pub split_charge_rules:
        std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
}
impl CreateCostCategoryDefinitionInput {
    /// <p>The unique name of the Cost Category.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The rule schema version in this particular Cost Category.</p>
    pub fn rule_version(&self) -> std::option::Option<&crate::model::CostCategoryRuleVersion> {
        self.rule_version.as_ref()
    }
    /// <p>The Cost Category rules used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule</a>.</p>
    pub fn rules(&self) -> std::option::Option<&[crate::model::CostCategoryRule]> {
        self.rules.as_deref()
    }
    /// <p>The default value for the cost category.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
    pub fn split_charge_rules(
        &self,
    ) -> std::option::Option<&[crate::model::CostCategorySplitChargeRule]> {
        self.split_charge_rules.as_deref()
    }
}
impl std::fmt::Debug for CreateCostCategoryDefinitionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCostCategoryDefinitionInput");
        formatter.field("name", &self.name);
        formatter.field("rule_version", &self.rule_version);
        formatter.field("rules", &self.rules);
        formatter.field("default_value", &self.default_value);
        formatter.field("split_charge_rules", &self.split_charge_rules);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnomalySubscriptionInput {
    /// <p>The cost anomaly subscription object that you want to create. </p>
    pub anomaly_subscription: std::option::Option<crate::model::AnomalySubscription>,
}
impl CreateAnomalySubscriptionInput {
    /// <p>The cost anomaly subscription object that you want to create. </p>
    pub fn anomaly_subscription(&self) -> std::option::Option<&crate::model::AnomalySubscription> {
        self.anomaly_subscription.as_ref()
    }
}
impl std::fmt::Debug for CreateAnomalySubscriptionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnomalySubscriptionInput");
        formatter.field("anomaly_subscription", &self.anomaly_subscription);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnomalyMonitorInput {
    /// <p>The cost anomaly detection monitor object that you want to create.</p>
    pub anomaly_monitor: std::option::Option<crate::model::AnomalyMonitor>,
}
impl CreateAnomalyMonitorInput {
    /// <p>The cost anomaly detection monitor object that you want to create.</p>
    pub fn anomaly_monitor(&self) -> std::option::Option<&crate::model::AnomalyMonitor> {
        self.anomaly_monitor.as_ref()
    }
}
impl std::fmt::Debug for CreateAnomalyMonitorInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnomalyMonitorInput");
        formatter.field("anomaly_monitor", &self.anomaly_monitor);
        formatter.finish()
    }
}
