// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for AWS Cost Explorer Service
///
/// Client for invoking operations on AWS Cost Explorer Service. Each operation on AWS Cost Explorer Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_costexplorer::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_costexplorer::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_costexplorer::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`CreateAnomalyMonitor`](crate::client::fluent_builders::CreateAnomalyMonitor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`anomaly_monitor(AnomalyMonitor)`](crate::client::fluent_builders::CreateAnomalyMonitor::anomaly_monitor) / [`set_anomaly_monitor(Option<AnomalyMonitor>)`](crate::client::fluent_builders::CreateAnomalyMonitor::set_anomaly_monitor): <p>The cost anomaly detection monitor object that you want to create.</p>
    /// - On success, responds with [`CreateAnomalyMonitorOutput`](crate::output::CreateAnomalyMonitorOutput) with field(s):
    ///   - [`monitor_arn(Option<String>)`](crate::output::CreateAnomalyMonitorOutput::monitor_arn): <p>The unique identifier of your newly created cost anomaly detection monitor.</p>
    /// - On failure, responds with [`SdkError<CreateAnomalyMonitorError>`](crate::error::CreateAnomalyMonitorError)
    pub fn create_anomaly_monitor(&self) -> fluent_builders::CreateAnomalyMonitor<C, M, R> {
        fluent_builders::CreateAnomalyMonitor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAnomalySubscription`](crate::client::fluent_builders::CreateAnomalySubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`anomaly_subscription(AnomalySubscription)`](crate::client::fluent_builders::CreateAnomalySubscription::anomaly_subscription) / [`set_anomaly_subscription(Option<AnomalySubscription>)`](crate::client::fluent_builders::CreateAnomalySubscription::set_anomaly_subscription): <p>The cost anomaly subscription object that you want to create. </p>
    /// - On success, responds with [`CreateAnomalySubscriptionOutput`](crate::output::CreateAnomalySubscriptionOutput) with field(s):
    ///   - [`subscription_arn(Option<String>)`](crate::output::CreateAnomalySubscriptionOutput::subscription_arn): <p>The unique identifier of your newly created cost anomaly subscription. </p>
    /// - On failure, responds with [`SdkError<CreateAnomalySubscriptionError>`](crate::error::CreateAnomalySubscriptionError)
    pub fn create_anomaly_subscription(
        &self,
    ) -> fluent_builders::CreateAnomalySubscription<C, M, R> {
        fluent_builders::CreateAnomalySubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCostCategoryDefinition`](crate::client::fluent_builders::CreateCostCategoryDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::set_name): <p>The unique name of the Cost Category.</p>
    ///   - [`rule_version(CostCategoryRuleVersion)`](crate::client::fluent_builders::CreateCostCategoryDefinition::rule_version) / [`set_rule_version(Option<CostCategoryRuleVersion>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::set_rule_version): <p>The rule schema version in this particular Cost Category.</p>
    ///   - [`rules(Vec<CostCategoryRule>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::rules) / [`set_rules(Option<Vec<CostCategoryRule>>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::set_rules): <p>The Cost Category rules used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule</a>.</p>
    ///   - [`default_value(impl Into<String>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::default_value) / [`set_default_value(Option<String>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::set_default_value): <p>The default value for the cost category.</p>
    ///   - [`split_charge_rules(Vec<CostCategorySplitChargeRule>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::split_charge_rules) / [`set_split_charge_rules(Option<Vec<CostCategorySplitChargeRule>>)`](crate::client::fluent_builders::CreateCostCategoryDefinition::set_split_charge_rules): <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
    /// - On success, responds with [`CreateCostCategoryDefinitionOutput`](crate::output::CreateCostCategoryDefinitionOutput) with field(s):
    ///   - [`cost_category_arn(Option<String>)`](crate::output::CreateCostCategoryDefinitionOutput::cost_category_arn): <p> The unique identifier for your newly created Cost Category. </p>
    ///   - [`effective_start(Option<String>)`](crate::output::CreateCostCategoryDefinitionOutput::effective_start): <p> The Cost Category's effective start date. </p>
    /// - On failure, responds with [`SdkError<CreateCostCategoryDefinitionError>`](crate::error::CreateCostCategoryDefinitionError)
    pub fn create_cost_category_definition(
        &self,
    ) -> fluent_builders::CreateCostCategoryDefinition<C, M, R> {
        fluent_builders::CreateCostCategoryDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAnomalyMonitor`](crate::client::fluent_builders::DeleteAnomalyMonitor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`monitor_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAnomalyMonitor::monitor_arn) / [`set_monitor_arn(Option<String>)`](crate::client::fluent_builders::DeleteAnomalyMonitor::set_monitor_arn): <p>The unique identifier of the cost anomaly monitor that you want to delete. </p>
    /// - On success, responds with [`DeleteAnomalyMonitorOutput`](crate::output::DeleteAnomalyMonitorOutput)

    /// - On failure, responds with [`SdkError<DeleteAnomalyMonitorError>`](crate::error::DeleteAnomalyMonitorError)
    pub fn delete_anomaly_monitor(&self) -> fluent_builders::DeleteAnomalyMonitor<C, M, R> {
        fluent_builders::DeleteAnomalyMonitor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAnomalySubscription`](crate::client::fluent_builders::DeleteAnomalySubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteAnomalySubscription::subscription_arn) / [`set_subscription_arn(Option<String>)`](crate::client::fluent_builders::DeleteAnomalySubscription::set_subscription_arn): <p>The unique identifier of the cost anomaly subscription that you want to delete. </p>
    /// - On success, responds with [`DeleteAnomalySubscriptionOutput`](crate::output::DeleteAnomalySubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteAnomalySubscriptionError>`](crate::error::DeleteAnomalySubscriptionError)
    pub fn delete_anomaly_subscription(
        &self,
    ) -> fluent_builders::DeleteAnomalySubscription<C, M, R> {
        fluent_builders::DeleteAnomalySubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCostCategoryDefinition`](crate::client::fluent_builders::DeleteCostCategoryDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cost_category_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteCostCategoryDefinition::cost_category_arn) / [`set_cost_category_arn(Option<String>)`](crate::client::fluent_builders::DeleteCostCategoryDefinition::set_cost_category_arn): <p> The unique identifier for your Cost Category. </p>
    /// - On success, responds with [`DeleteCostCategoryDefinitionOutput`](crate::output::DeleteCostCategoryDefinitionOutput) with field(s):
    ///   - [`cost_category_arn(Option<String>)`](crate::output::DeleteCostCategoryDefinitionOutput::cost_category_arn): <p> The unique identifier for your Cost Category. </p>
    ///   - [`effective_end(Option<String>)`](crate::output::DeleteCostCategoryDefinitionOutput::effective_end): <p> The effective end date of the Cost Category as a result of deleting it. No costs after this date will be categorized by the deleted Cost Category. </p>
    /// - On failure, responds with [`SdkError<DeleteCostCategoryDefinitionError>`](crate::error::DeleteCostCategoryDefinitionError)
    pub fn delete_cost_category_definition(
        &self,
    ) -> fluent_builders::DeleteCostCategoryDefinition<C, M, R> {
        fluent_builders::DeleteCostCategoryDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCostCategoryDefinition`](crate::client::fluent_builders::DescribeCostCategoryDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cost_category_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeCostCategoryDefinition::cost_category_arn) / [`set_cost_category_arn(Option<String>)`](crate::client::fluent_builders::DescribeCostCategoryDefinition::set_cost_category_arn): <p> The unique identifier for your Cost Category. </p>
    ///   - [`effective_on(impl Into<String>)`](crate::client::fluent_builders::DescribeCostCategoryDefinition::effective_on) / [`set_effective_on(Option<String>)`](crate::client::fluent_builders::DescribeCostCategoryDefinition::set_effective_on): <p> The date when the Cost Category was effective. </p>
    /// - On success, responds with [`DescribeCostCategoryDefinitionOutput`](crate::output::DescribeCostCategoryDefinitionOutput) with field(s):
    ///   - [`cost_category(Option<CostCategory>)`](crate::output::DescribeCostCategoryDefinitionOutput::cost_category): <p>The structure of Cost Categories. This includes detailed metadata and the set of rules for the <code>CostCategory</code> object.</p>
    /// - On failure, responds with [`SdkError<DescribeCostCategoryDefinitionError>`](crate::error::DescribeCostCategoryDefinitionError)
    pub fn describe_cost_category_definition(
        &self,
    ) -> fluent_builders::DescribeCostCategoryDefinition<C, M, R> {
        fluent_builders::DescribeCostCategoryDefinition::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAnomalies`](crate::client::fluent_builders::GetAnomalies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`monitor_arn(impl Into<String>)`](crate::client::fluent_builders::GetAnomalies::monitor_arn) / [`set_monitor_arn(Option<String>)`](crate::client::fluent_builders::GetAnomalies::set_monitor_arn): <p>Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). </p>
    ///   - [`date_interval(AnomalyDateInterval)`](crate::client::fluent_builders::GetAnomalies::date_interval) / [`set_date_interval(Option<AnomalyDateInterval>)`](crate::client::fluent_builders::GetAnomalies::set_date_interval): <p>Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an <code>AnomalyEndDate</code> in the specified time range. </p>
    ///   - [`feedback(AnomalyFeedbackType)`](crate::client::fluent_builders::GetAnomalies::feedback) / [`set_feedback(Option<AnomalyFeedbackType>)`](crate::client::fluent_builders::GetAnomalies::set_feedback): <p>Filters anomaly results by the feedback field on the anomaly object. </p>
    ///   - [`total_impact(TotalImpactFilter)`](crate::client::fluent_builders::GetAnomalies::total_impact) / [`set_total_impact(Option<TotalImpactFilter>)`](crate::client::fluent_builders::GetAnomalies::set_total_impact): <p>Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200. </p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetAnomalies::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetAnomalies::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetAnomalies::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetAnomalies::set_max_results): <p>The number of entries a paginated response contains. </p>
    /// - On success, responds with [`GetAnomaliesOutput`](crate::output::GetAnomaliesOutput) with field(s):
    ///   - [`anomalies(Option<Vec<Anomaly>>)`](crate::output::GetAnomaliesOutput::anomalies): <p>A list of cost anomalies. </p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetAnomaliesOutput::next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    /// - On failure, responds with [`SdkError<GetAnomaliesError>`](crate::error::GetAnomaliesError)
    pub fn get_anomalies(&self) -> fluent_builders::GetAnomalies<C, M, R> {
        fluent_builders::GetAnomalies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAnomalyMonitors`](crate::client::fluent_builders::GetAnomalyMonitors) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`monitor_arn_list(Vec<String>)`](crate::client::fluent_builders::GetAnomalyMonitors::monitor_arn_list) / [`set_monitor_arn_list(Option<Vec<String>>)`](crate::client::fluent_builders::GetAnomalyMonitors::set_monitor_arn_list): <p>A list of cost anomaly monitor ARNs. </p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetAnomalyMonitors::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetAnomalyMonitors::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetAnomalyMonitors::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetAnomalyMonitors::set_max_results): <p>The number of entries that a paginated response contains. </p>
    /// - On success, responds with [`GetAnomalyMonitorsOutput`](crate::output::GetAnomalyMonitorsOutput) with field(s):
    ///   - [`anomaly_monitors(Option<Vec<AnomalyMonitor>>)`](crate::output::GetAnomalyMonitorsOutput::anomaly_monitors): <p>A list of cost anomaly monitors that includes the detailed metadata for each monitor. </p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetAnomalyMonitorsOutput::next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    /// - On failure, responds with [`SdkError<GetAnomalyMonitorsError>`](crate::error::GetAnomalyMonitorsError)
    pub fn get_anomaly_monitors(&self) -> fluent_builders::GetAnomalyMonitors<C, M, R> {
        fluent_builders::GetAnomalyMonitors::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAnomalySubscriptions`](crate::client::fluent_builders::GetAnomalySubscriptions) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_arn_list(Vec<String>)`](crate::client::fluent_builders::GetAnomalySubscriptions::subscription_arn_list) / [`set_subscription_arn_list(Option<Vec<String>>)`](crate::client::fluent_builders::GetAnomalySubscriptions::set_subscription_arn_list): <p>A list of cost anomaly subscription ARNs. </p>
    ///   - [`monitor_arn(impl Into<String>)`](crate::client::fluent_builders::GetAnomalySubscriptions::monitor_arn) / [`set_monitor_arn(Option<String>)`](crate::client::fluent_builders::GetAnomalySubscriptions::set_monitor_arn): <p>Cost anomaly monitor ARNs. </p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetAnomalySubscriptions::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetAnomalySubscriptions::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetAnomalySubscriptions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetAnomalySubscriptions::set_max_results): <p>The number of entries a paginated response contains. </p>
    /// - On success, responds with [`GetAnomalySubscriptionsOutput`](crate::output::GetAnomalySubscriptionsOutput) with field(s):
    ///   - [`anomaly_subscriptions(Option<Vec<AnomalySubscription>>)`](crate::output::GetAnomalySubscriptionsOutput::anomaly_subscriptions): <p>A list of cost anomaly subscriptions that includes the detailed metadata for each one. </p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetAnomalySubscriptionsOutput::next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    /// - On failure, responds with [`SdkError<GetAnomalySubscriptionsError>`](crate::error::GetAnomalySubscriptionsError)
    pub fn get_anomaly_subscriptions(&self) -> fluent_builders::GetAnomalySubscriptions<C, M, R> {
        fluent_builders::GetAnomalySubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCostAndUsage`](crate::client::fluent_builders::GetCostAndUsage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetCostAndUsage::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetCostAndUsage::set_time_period): <p>Sets the start date and end date for retrieving Amazon Web Services costs. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetCostAndUsage::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetCostAndUsage::set_granularity): <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. </p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetCostAndUsage::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetCostAndUsage::set_filter): <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>  <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>  <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
    ///   - [`metrics(Vec<String>)`](crate::client::fluent_builders::GetCostAndUsage::metrics) / [`set_metrics(Option<Vec<String>>)`](crate::client::fluent_builders::GetCostAndUsage::set_metrics): <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>  <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>   <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking into account the units. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours and GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>  </note>  <p> <code>Metrics</code> is required for <code>GetCostAndUsage</code> requests.</p>
    ///   - [`group_by(Vec<GroupDefinition>)`](crate::client::fluent_builders::GetCostAndUsage::group_by) / [`set_group_by(Option<Vec<GroupDefinition>>)`](crate::client::fluent_builders::GetCostAndUsage::set_group_by): <p>You can group Amazon Web Services costs using up to two different groups, either dimensions, tag keys, cost categories, or any two group by types.</p>  <p>Valid values for the <code>DIMENSION</code> type are <code>AZ</code>, <code>INSTANCE_TYPE</code>, <code>LEGAL_ENTITY_NAME</code>, <code>LINKED_ACCOUNT</code>, <code>OPERATION</code>, <code>PLATFORM</code>, <code>PURCHASE_TYPE</code>, <code>SERVICE</code>, <code>TENANCY</code>, <code>RECORD_TYPE</code>, and <code>USAGE_TYPE</code>.</p>  <p>When you group by the <code>TAG</code> type and include a valid tag key, you get all tag values, including empty strings.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetCostAndUsage::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetCostAndUsage::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On success, responds with [`GetCostAndUsageOutput`](crate::output::GetCostAndUsageOutput) with field(s):
    ///   - [`next_page_token(Option<String>)`](crate::output::GetCostAndUsageOutput::next_page_token): <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`group_definitions(Option<Vec<GroupDefinition>>)`](crate::output::GetCostAndUsageOutput::group_definitions): <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.</p>
    ///   - [`results_by_time(Option<Vec<ResultByTime>>)`](crate::output::GetCostAndUsageOutput::results_by_time): <p>The time period that's covered by the results in the response.</p>
    ///   - [`dimension_value_attributes(Option<Vec<DimensionValuesWithAttributes>>)`](crate::output::GetCostAndUsageOutput::dimension_value_attributes): <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
    /// - On failure, responds with [`SdkError<GetCostAndUsageError>`](crate::error::GetCostAndUsageError)
    pub fn get_cost_and_usage(&self) -> fluent_builders::GetCostAndUsage<C, M, R> {
        fluent_builders::GetCostAndUsage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCostAndUsageWithResources`](crate::client::fluent_builders::GetCostAndUsageWithResources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetCostAndUsageWithResources::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::set_time_period): <p>Sets the start and end dates for retrieving Amazon Web Services costs. The range must be within the last 14 days (the start date cannot be earlier than 14 days ago). The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetCostAndUsageWithResources::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::set_granularity): <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. </p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetCostAndUsageWithResources::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::set_filter): <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>  <p>The <code>GetCostAndUsageWithResources</code> operation requires that you either group by or filter by a <code>ResourceId</code>. It requires the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> <code>"SERVICE = Amazon Elastic Compute Cloud - Compute"</code> in the filter.</p>  <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>  <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
    ///   - [`metrics(Vec<String>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::metrics) / [`set_metrics(Option<Vec<String>>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::set_metrics): <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>  <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>   <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking the units into account. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours vs. GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>  </note>  <p> <code>Metrics</code> is required for <code>GetCostAndUsageWithResources</code> requests.</p>
    ///   - [`group_by(Vec<GroupDefinition>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::group_by) / [`set_group_by(Option<Vec<GroupDefinition>>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::set_group_by): <p>You can group Amazon Web Services costs using up to two different groups: <code>DIMENSION</code>, <code>TAG</code>, <code>COST_CATEGORY</code>.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetCostAndUsageWithResources::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On success, responds with [`GetCostAndUsageWithResourcesOutput`](crate::output::GetCostAndUsageWithResourcesOutput) with field(s):
    ///   - [`next_page_token(Option<String>)`](crate::output::GetCostAndUsageWithResourcesOutput::next_page_token): <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`group_definitions(Option<Vec<GroupDefinition>>)`](crate::output::GetCostAndUsageWithResourcesOutput::group_definitions): <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.</p>
    ///   - [`results_by_time(Option<Vec<ResultByTime>>)`](crate::output::GetCostAndUsageWithResourcesOutput::results_by_time): <p>The time period that is covered by the results in the response.</p>
    ///   - [`dimension_value_attributes(Option<Vec<DimensionValuesWithAttributes>>)`](crate::output::GetCostAndUsageWithResourcesOutput::dimension_value_attributes): <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
    /// - On failure, responds with [`SdkError<GetCostAndUsageWithResourcesError>`](crate::error::GetCostAndUsageWithResourcesError)
    pub fn get_cost_and_usage_with_resources(
        &self,
    ) -> fluent_builders::GetCostAndUsageWithResources<C, M, R> {
        fluent_builders::GetCostAndUsageWithResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCostCategories`](crate::client::fluent_builders::GetCostCategories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`search_string(impl Into<String>)`](crate::client::fluent_builders::GetCostCategories::search_string) / [`set_search_string(Option<String>)`](crate::client::fluent_builders::GetCostCategories::set_search_string): <p>The value that you want to search the filter values for.</p>  <p>If you do not specify a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category names that match the <code>SearchString</code> pattern. If you do specifiy a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category values that match the <code>SearchString</code> pattern.</p>
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetCostCategories::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetCostCategories::set_time_period): <p>The time period of the request. </p>
    ///   - [`cost_category_name(impl Into<String>)`](crate::client::fluent_builders::GetCostCategories::cost_category_name) / [`set_cost_category_name(Option<String>)`](crate::client::fluent_builders::GetCostCategories::set_cost_category_name): <p>The unique name of the Cost Category.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetCostCategories::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetCostCategories::set_filter): <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>  <ul>   <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>   <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>     <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>    </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>  </ul> <note>   <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>   <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>  </note>
    ///   - [`sort_by(Vec<SortDefinition>)`](crate::client::fluent_builders::GetCostCategories::sort_by) / [`set_sort_by(Option<Vec<SortDefinition>>)`](crate::client::fluent_builders::GetCostCategories::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The key represents cost and usage metrics. The following values are supported:</p>  <ul>   <li> <p> <code>BlendedCost</code> </p> </li>   <li> <p> <code>UnblendedCost</code> </p> </li>   <li> <p> <code>AmortizedCost</code> </p> </li>   <li> <p> <code>NetAmortizedCost</code> </p> </li>   <li> <p> <code>NetUnblendedCost</code> </p> </li>   <li> <p> <code>UsageQuantity</code> </p> </li>   <li> <p> <code>NormalizedUsageAmount</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>  <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCostCategories::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetCostCategories::set_max_results): <p>This field is only used when <code>SortBy</code> is provided in the request.</p>  <p>The maximum number of objects that to be returned for this request. If <code>MaxResults</code> is not specified with <code>SortBy</code>, the request will return 1000 results as the default value for this parameter.</p>  <p>For <code>GetCostCategories</code>, MaxResults has an upper limit of 1000.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetCostCategories::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetCostCategories::set_next_page_token): <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the prior call in your next request.</p>
    /// - On success, responds with [`GetCostCategoriesOutput`](crate::output::GetCostCategoriesOutput) with field(s):
    ///   - [`next_page_token(Option<String>)`](crate::output::GetCostCategoriesOutput::next_page_token): <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    ///   - [`cost_category_names(Option<Vec<String>>)`](crate::output::GetCostCategoriesOutput::cost_category_names): <p>The names of the Cost Categories.</p>
    ///   - [`cost_category_values(Option<Vec<String>>)`](crate::output::GetCostCategoriesOutput::cost_category_values): <p>The Cost Category values.</p>  <p> <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the request. </p>
    ///   - [`return_size(Option<i32>)`](crate::output::GetCostCategoriesOutput::return_size): <p>The number of objects returned.</p>
    ///   - [`total_size(Option<i32>)`](crate::output::GetCostCategoriesOutput::total_size): <p>The total number of objects.</p>
    /// - On failure, responds with [`SdkError<GetCostCategoriesError>`](crate::error::GetCostCategoriesError)
    pub fn get_cost_categories(&self) -> fluent_builders::GetCostCategories<C, M, R> {
        fluent_builders::GetCostCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCostForecast`](crate::client::fluent_builders::GetCostForecast) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetCostForecast::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetCostForecast::set_time_period): <p>The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.</p>
    ///   - [`metric(Metric)`](crate::client::fluent_builders::GetCostForecast::metric) / [`set_metric(Option<Metric>)`](crate::client::fluent_builders::GetCostForecast::set_metric): <p>Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>  <p>Valid values for a <code>GetCostForecast</code> call are the following:</p>  <ul>   <li> <p>AMORTIZED_COST</p> </li>   <li> <p>BLENDED_COST</p> </li>   <li> <p>NET_AMORTIZED_COST</p> </li>   <li> <p>NET_UNBLENDED_COST</p> </li>   <li> <p>UNBLENDED_COST</p> </li>  </ul>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetCostForecast::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetCostForecast::set_granularity): <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>  <p>The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetCostForecast::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetCostForecast::set_filter): <p>The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering by the following dimensions:</p>  <ul>   <li> <p> <code>AZ</code> </p> </li>   <li> <p> <code>INSTANCE_TYPE</code> </p> </li>   <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>   <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>   <li> <p> <code>OPERATION</code> </p> </li>   <li> <p> <code>PURCHASE_TYPE</code> </p> </li>   <li> <p> <code>REGION</code> </p> </li>   <li> <p> <code>SERVICE</code> </p> </li>   <li> <p> <code>USAGE_TYPE</code> </p> </li>   <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>   <li> <p> <code>RECORD_TYPE</code> </p> </li>   <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>   <li> <p> <code>TENANCY</code> </p> </li>   <li> <p> <code>SCOPE</code> </p> </li>   <li> <p> <code>PLATFORM</code> </p> </li>   <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>   <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>   <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>   <li> <p> <code>DATABASE_ENGINE</code> </p> </li>   <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>   <li> <p> <code>BILLING_ENTITY</code> </p> </li>   <li> <p> <code>RESERVATION_ID</code> </p> </li>   <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>  </ul>
    ///   - [`prediction_interval_level(i32)`](crate::client::fluent_builders::GetCostForecast::prediction_interval_level) / [`set_prediction_interval_level(Option<i32>)`](crate::client::fluent_builders::GetCostForecast::set_prediction_interval_level): <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
    /// - On success, responds with [`GetCostForecastOutput`](crate::output::GetCostForecastOutput) with field(s):
    ///   - [`total(Option<MetricValue>)`](crate::output::GetCostForecastOutput::total): <p>How much you are forecasted to spend over the forecast period, in <code>USD</code>.</p>
    ///   - [`forecast_results_by_time(Option<Vec<ForecastResult>>)`](crate::output::GetCostForecastOutput::forecast_results_by_time): <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts, this is a list of months.</p>
    /// - On failure, responds with [`SdkError<GetCostForecastError>`](crate::error::GetCostForecastError)
    pub fn get_cost_forecast(&self) -> fluent_builders::GetCostForecast<C, M, R> {
        fluent_builders::GetCostForecast::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDimensionValues`](crate::client::fluent_builders::GetDimensionValues) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`search_string(impl Into<String>)`](crate::client::fluent_builders::GetDimensionValues::search_string) / [`set_search_string(Option<String>)`](crate::client::fluent_builders::GetDimensionValues::set_search_string): <p>The value that you want to search the filter values for.</p>
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetDimensionValues::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetDimensionValues::set_time_period): <p>The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    ///   - [`dimension(Dimension)`](crate::client::fluent_builders::GetDimensionValues::dimension) / [`set_dimension(Option<Dimension>)`](crate::client::fluent_builders::GetDimensionValues::set_dimension): <p>The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html#awscostmanagement-GetDimensionValues-request-Context">Context</a>. </p>
    ///   - [`context(Context)`](crate::client::fluent_builders::GetDimensionValues::context) / [`set_context(Option<Context>)`](crate::client::fluent_builders::GetDimensionValues::set_context): <p>The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to <code>RESERVATIONS</code>, the resulting dimension values can be used in the <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>  <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>  <ul>   <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>   <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>   <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>   <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>   <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>   <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>   <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>   <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>   <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>   <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>   <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>   <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>   <li> <p>REGION - The Amazon Web Services Region.</p> </li>   <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>   <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>  </ul>  <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>  <ul>   <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>   <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>   <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>   <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>   <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>   <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>   <li> <p>REGION - The Amazon Web Services Region.</p> </li>   <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>   <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>   <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>  </ul>  <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>  <ul>   <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>   <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>   <li> <p>REGION - The Amazon Web Services Region.</p> </li>   <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>   <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>   <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>  </ul>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetDimensionValues::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetDimensionValues::set_filter): <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>  <ul>   <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>   <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>     <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>    </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>  </ul> <note>   <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>   <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>  </note>
    ///   - [`sort_by(Vec<SortDefinition>)`](crate::client::fluent_builders::GetDimensionValues::sort_by) / [`set_sort_by(Option<Vec<SortDefinition>>)`](crate::client::fluent_builders::GetDimensionValues::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The key represents cost and usage metrics. The following values are supported:</p>  <ul>   <li> <p> <code>BlendedCost</code> </p> </li>   <li> <p> <code>UnblendedCost</code> </p> </li>   <li> <p> <code>AmortizedCost</code> </p> </li>   <li> <p> <code>NetAmortizedCost</code> </p> </li>   <li> <p> <code>NetUnblendedCost</code> </p> </li>   <li> <p> <code>UsageQuantity</code> </p> </li>   <li> <p> <code>NormalizedUsageAmount</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>  <p>When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetDimensionValues::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetDimensionValues::set_max_results): <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>  <p>For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetDimensionValues::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetDimensionValues::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On success, responds with [`GetDimensionValuesOutput`](crate::output::GetDimensionValuesOutput) with field(s):
    ///   - [`dimension_values(Option<Vec<DimensionValuesWithAttributes>>)`](crate::output::GetDimensionValuesOutput::dimension_values): <p>The filters that you used to filter your request. Some dimensions are available only for a specific context.</p>  <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>  <ul>   <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>   <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>   <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>   <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>   <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>   <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>   <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>   <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>   <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>   <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>   <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>   <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>   <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>   <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>  </ul>  <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>  <ul>   <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>   <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>   <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>   <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>   <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>   <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>   <li> <p>REGION - The Amazon Web Services Region.</p> </li>   <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>   <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>   <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>  </ul>  <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>  <ul>   <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>   <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>   <li> <p>REGION - The Amazon Web Services Region.</p> </li>   <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>   <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>   <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>  </ul>
    ///   - [`return_size(Option<i32>)`](crate::output::GetDimensionValuesOutput::return_size): <p>The number of results that Amazon Web Services returned at one time.</p>
    ///   - [`total_size(Option<i32>)`](crate::output::GetDimensionValuesOutput::total_size): <p>The total number of search results.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetDimensionValuesOutput::next_page_token): <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On failure, responds with [`SdkError<GetDimensionValuesError>`](crate::error::GetDimensionValuesError)
    pub fn get_dimension_values(&self) -> fluent_builders::GetDimensionValues<C, M, R> {
        fluent_builders::GetDimensionValues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReservationCoverage`](crate::client::fluent_builders::GetReservationCoverage) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetReservationCoverage::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetReservationCoverage::set_time_period): <p>The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
    ///   - [`group_by(Vec<GroupDefinition>)`](crate::client::fluent_builders::GetReservationCoverage::group_by) / [`set_group_by(Option<Vec<GroupDefinition>>)`](crate::client::fluent_builders::GetReservationCoverage::set_group_by): <p>You can group the data by the following attributes:</p>  <ul>   <li> <p>AZ</p> </li>   <li> <p>CACHE_ENGINE</p> </li>   <li> <p>DATABASE_ENGINE</p> </li>   <li> <p>DEPLOYMENT_OPTION</p> </li>   <li> <p>INSTANCE_TYPE</p> </li>   <li> <p>LINKED_ACCOUNT</p> </li>   <li> <p>OPERATING_SYSTEM</p> </li>   <li> <p>PLATFORM</p> </li>   <li> <p>REGION</p> </li>   <li> <p>TENANCY</p> </li>  </ul>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetReservationCoverage::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetReservationCoverage::set_granularity): <p>The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code> and <code>DAILY</code>.</p>  <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.</p>  <p>The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetReservationCoverage::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetReservationCoverage::set_filter): <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>  <ul>   <li> <p>AZ</p> </li>   <li> <p>CACHE_ENGINE</p> </li>   <li> <p>DATABASE_ENGINE</p> </li>   <li> <p>DEPLOYMENT_OPTION</p> </li>   <li> <p>INSTANCE_TYPE</p> </li>   <li> <p>LINKED_ACCOUNT</p> </li>   <li> <p>OPERATING_SYSTEM</p> </li>   <li> <p>PLATFORM</p> </li>   <li> <p>REGION</p> </li>   <li> <p>SERVICE</p> </li>   <li> <p>TAG</p> </li>   <li> <p>TENANCY</p> </li>  </ul>  <p> <code>GetReservationCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only one level deep.</p>  <p>If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.</p>  <p>Cost category is also supported.</p>
    ///   - [`metrics(Vec<String>)`](crate::client::fluent_builders::GetReservationCoverage::metrics) / [`set_metrics(Option<Vec<String>>)`](crate::client::fluent_builders::GetReservationCoverage::set_metrics): <p>The measurement that you want your reservation coverage reported in.</p>  <p>Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a request.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetReservationCoverage::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetReservationCoverage::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`sort_by(SortDefinition)`](crate::client::fluent_builders::GetReservationCoverage::sort_by) / [`set_sort_by(Option<SortDefinition>)`](crate::client::fluent_builders::GetReservationCoverage::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The following values are supported for <code>Key</code>:</p>  <ul>   <li> <p> <code>OnDemandCost</code> </p> </li>   <li> <p> <code>CoverageHoursPercentage</code> </p> </li>   <li> <p> <code>OnDemandHours</code> </p> </li>   <li> <p> <code>ReservedHours</code> </p> </li>   <li> <p> <code>TotalRunningHours</code> </p> </li>   <li> <p> <code>CoverageNormalizedUnitsPercentage</code> </p> </li>   <li> <p> <code>OnDemandNormalizedUnits</code> </p> </li>   <li> <p> <code>ReservedNormalizedUnits</code> </p> </li>   <li> <p> <code>TotalRunningNormalizedUnits</code> </p> </li>   <li> <p> <code>Time</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetReservationCoverage::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetReservationCoverage::set_max_results): <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`GetReservationCoverageOutput`](crate::output::GetReservationCoverageOutput) with field(s):
    ///   - [`coverages_by_time(Option<Vec<CoverageByTime>>)`](crate::output::GetReservationCoverageOutput::coverages_by_time): <p>The amount of time that your reservations covered.</p>
    ///   - [`total(Option<Coverage>)`](crate::output::GetReservationCoverageOutput::total): <p>The total amount of instance usage that a reservation covered.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetReservationCoverageOutput::next_page_token): <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On failure, responds with [`SdkError<GetReservationCoverageError>`](crate::error::GetReservationCoverageError)
    pub fn get_reservation_coverage(&self) -> fluent_builders::GetReservationCoverage<C, M, R> {
        fluent_builders::GetReservationCoverage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReservationPurchaseRecommendation`](crate::client::fluent_builders::GetReservationPurchaseRecommendation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_account_id): <p>The account ID that is associated with the recommendation. </p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_service): <p>The specific service that you want recommendations for.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_filter): <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>  <ul>   <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>   <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>     <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>    </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>  </ul> <note>   <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>   <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>  </note>
    ///   - [`account_scope(AccountScope)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::account_scope) / [`set_account_scope(Option<AccountScope>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_account_scope): <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    ///   - [`lookback_period_in_days(LookbackPeriodInDays)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::lookback_period_in_days) / [`set_lookback_period_in_days(Option<LookbackPeriodInDays>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_lookback_period_in_days): <p>The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.</p>
    ///   - [`term_in_years(TermInYears)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::term_in_years) / [`set_term_in_years(Option<TermInYears>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_term_in_years): <p>The reservation term that you want recommendations for.</p>
    ///   - [`payment_option(PaymentOption)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::payment_option) / [`set_payment_option(Option<PaymentOption>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_payment_option): <p>The reservation purchase option that you want recommendations for.</p>
    ///   - [`service_specification(ServiceSpecification)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::service_specification) / [`set_service_specification(Option<ServiceSpecification>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_service_specification): <p>The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_page_size): <p>The number of recommendations that you want returned in a single response object.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetReservationPurchaseRecommendation::set_next_page_token): <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
    /// - On success, responds with [`GetReservationPurchaseRecommendationOutput`](crate::output::GetReservationPurchaseRecommendationOutput) with field(s):
    ///   - [`metadata(Option<ReservationPurchaseRecommendationMetadata>)`](crate::output::GetReservationPurchaseRecommendationOutput::metadata): <p>Information about this specific recommendation call, such as the time stamp for when Cost Explorer generated this recommendation.</p>
    ///   - [`recommendations(Option<Vec<ReservationPurchaseRecommendation>>)`](crate::output::GetReservationPurchaseRecommendationOutput::recommendations): <p>Recommendations for reservations to purchase.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetReservationPurchaseRecommendationOutput::next_page_token): <p>The pagination token for the next set of retrievable results.</p>
    /// - On failure, responds with [`SdkError<GetReservationPurchaseRecommendationError>`](crate::error::GetReservationPurchaseRecommendationError)
    pub fn get_reservation_purchase_recommendation(
        &self,
    ) -> fluent_builders::GetReservationPurchaseRecommendation<C, M, R> {
        fluent_builders::GetReservationPurchaseRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReservationUtilization`](crate::client::fluent_builders::GetReservationUtilization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetReservationUtilization::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetReservationUtilization::set_time_period): <p>Sets the start and end dates for retrieving RI utilization. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
    ///   - [`group_by(Vec<GroupDefinition>)`](crate::client::fluent_builders::GetReservationUtilization::group_by) / [`set_group_by(Option<Vec<GroupDefinition>>)`](crate::client::fluent_builders::GetReservationUtilization::set_group_by): <p>Groups only by <code>SUBSCRIPTION_ID</code>. Metadata is included.</p>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetReservationUtilization::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetReservationUtilization::set_granularity): <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>. If both <code>GroupBy</code> and <code>Granularity</code> aren't set, <code>GetReservationUtilization</code> defaults to <code>DAILY</code>.</p>  <p>The <code>GetReservationUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetReservationUtilization::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetReservationUtilization::set_filter): <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>  <ul>   <li> <p>AZ</p> </li>   <li> <p>CACHE_ENGINE</p> </li>   <li> <p>DEPLOYMENT_OPTION</p> </li>   <li> <p>INSTANCE_TYPE</p> </li>   <li> <p>LINKED_ACCOUNT</p> </li>   <li> <p>OPERATING_SYSTEM</p> </li>   <li> <p>PLATFORM</p> </li>   <li> <p>REGION</p> </li>   <li> <p>SERVICE</p> </li>   <li> <p>SCOPE</p> </li>   <li> <p>TENANCY</p> </li>  </ul>  <p> <code>GetReservationUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension, and nesting is supported up to only one level deep.</p>
    ///   - [`sort_by(SortDefinition)`](crate::client::fluent_builders::GetReservationUtilization::sort_by) / [`set_sort_by(Option<SortDefinition>)`](crate::client::fluent_builders::GetReservationUtilization::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The following values are supported for <code>Key</code>:</p>  <ul>   <li> <p> <code>UtilizationPercentage</code> </p> </li>   <li> <p> <code>UtilizationPercentageInUnits</code> </p> </li>   <li> <p> <code>PurchasedHours</code> </p> </li>   <li> <p> <code>PurchasedUnits</code> </p> </li>   <li> <p> <code>TotalActualHours</code> </p> </li>   <li> <p> <code>TotalActualUnits</code> </p> </li>   <li> <p> <code>UnusedHours</code> </p> </li>   <li> <p> <code>UnusedUnits</code> </p> </li>   <li> <p> <code>OnDemandCostOfRIHoursUsed</code> </p> </li>   <li> <p> <code>NetRISavings</code> </p> </li>   <li> <p> <code>TotalPotentialRISavings</code> </p> </li>   <li> <p> <code>AmortizedUpfrontFee</code> </p> </li>   <li> <p> <code>AmortizedRecurringFee</code> </p> </li>   <li> <p> <code>TotalAmortizedFee</code> </p> </li>   <li> <p> <code>RICostForUnusedHours</code> </p> </li>   <li> <p> <code>RealizedSavings</code> </p> </li>   <li> <p> <code>UnrealizedSavings</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetReservationUtilization::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetReservationUtilization::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetReservationUtilization::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetReservationUtilization::set_max_results): <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
    /// - On success, responds with [`GetReservationUtilizationOutput`](crate::output::GetReservationUtilizationOutput) with field(s):
    ///   - [`utilizations_by_time(Option<Vec<UtilizationByTime>>)`](crate::output::GetReservationUtilizationOutput::utilizations_by_time): <p>The amount of time that you used your RIs.</p>
    ///   - [`total(Option<ReservationAggregates>)`](crate::output::GetReservationUtilizationOutput::total): <p>The total amount of time that you used your RIs.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetReservationUtilizationOutput::next_page_token): <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On failure, responds with [`SdkError<GetReservationUtilizationError>`](crate::error::GetReservationUtilizationError)
    pub fn get_reservation_utilization(
        &self,
    ) -> fluent_builders::GetReservationUtilization<C, M, R> {
        fluent_builders::GetReservationUtilization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetRightsizingRecommendation`](crate::client::fluent_builders::GetRightsizingRecommendation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetRightsizingRecommendation::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetRightsizingRecommendation::set_filter): <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>  <ul>   <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>   <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>     <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>    </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>  </ul> <note>   <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>   <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>  </note>
    ///   - [`configuration(RightsizingRecommendationConfiguration)`](crate::client::fluent_builders::GetRightsizingRecommendation::configuration) / [`set_configuration(Option<RightsizingRecommendationConfiguration>)`](crate::client::fluent_builders::GetRightsizingRecommendation::set_configuration): <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
    ///   - [`service(impl Into<String>)`](crate::client::fluent_builders::GetRightsizingRecommendation::service) / [`set_service(Option<String>)`](crate::client::fluent_builders::GetRightsizingRecommendation::set_service): <p>The specific service that you want recommendations for. The only valid value for <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::GetRightsizingRecommendation::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::GetRightsizingRecommendation::set_page_size): <p>The number of recommendations that you want returned in a single response object.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetRightsizingRecommendation::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetRightsizingRecommendation::set_next_page_token): <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
    /// - On success, responds with [`GetRightsizingRecommendationOutput`](crate::output::GetRightsizingRecommendationOutput) with field(s):
    ///   - [`metadata(Option<RightsizingRecommendationMetadata>)`](crate::output::GetRightsizingRecommendationOutput::metadata): <p>Information regarding this specific recommendation set.</p>
    ///   - [`summary(Option<RightsizingRecommendationSummary>)`](crate::output::GetRightsizingRecommendationOutput::summary): <p>Summary of this recommendation set.</p>
    ///   - [`rightsizing_recommendations(Option<Vec<RightsizingRecommendation>>)`](crate::output::GetRightsizingRecommendationOutput::rightsizing_recommendations): <p>Recommendations to rightsize resources.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetRightsizingRecommendationOutput::next_page_token): <p>The token to retrieve the next set of results.</p>
    ///   - [`configuration(Option<RightsizingRecommendationConfiguration>)`](crate::output::GetRightsizingRecommendationOutput::configuration): <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
    /// - On failure, responds with [`SdkError<GetRightsizingRecommendationError>`](crate::error::GetRightsizingRecommendationError)
    pub fn get_rightsizing_recommendation(
        &self,
    ) -> fluent_builders::GetRightsizingRecommendation<C, M, R> {
        fluent_builders::GetRightsizingRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSavingsPlansCoverage`](crate::client::fluent_builders::GetSavingsPlansCoverage) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSavingsPlansCoverage::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetSavingsPlansCoverage::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_time_period): <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    ///   - [`group_by(Vec<GroupDefinition>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::group_by) / [`set_group_by(Option<Vec<GroupDefinition>>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_group_by): <p>You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or <code>SERVICE</code>.</p>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetSavingsPlansCoverage::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_granularity): <p>The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be set if <code>GroupBy</code> is set.</p>  <p>The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetSavingsPlansCoverage::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_filter): <p>Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:</p>  <ul>   <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>   <li> <p> <code>REGION</code> </p> </li>   <li> <p> <code>SERVICE</code> </p> </li>   <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>  </ul>  <p> <code>GetSavingsPlansCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>  <p>Cost category is supported. Tags are not supported.</p>
    ///   - [`metrics(Vec<String>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::metrics) / [`set_metrics(Option<Vec<String>>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_metrics): <p>The measurement that you want your Savings Plans coverage reported in. The only valid value is <code>SpendCoveredBySavingsPlans</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_next_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetSavingsPlansCoverage::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_max_results): <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
    ///   - [`sort_by(SortDefinition)`](crate::client::fluent_builders::GetSavingsPlansCoverage::sort_by) / [`set_sort_by(Option<SortDefinition>)`](crate::client::fluent_builders::GetSavingsPlansCoverage::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The following values are supported for <code>Key</code>:</p>  <ul>   <li> <p> <code>SpendCoveredBySavingsPlan</code> </p> </li>   <li> <p> <code>OnDemandCost</code> </p> </li>   <li> <p> <code>CoveragePercentage</code> </p> </li>   <li> <p> <code>TotalCost</code> </p> </li>   <li> <p> <code>InstanceFamily</code> </p> </li>   <li> <p> <code>Region</code> </p> </li>   <li> <p> <code>Service</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// - On success, responds with [`GetSavingsPlansCoverageOutput`](crate::output::GetSavingsPlansCoverageOutput) with field(s):
    ///   - [`savings_plans_coverages(Option<Vec<SavingsPlansCoverage>>)`](crate::output::GetSavingsPlansCoverageOutput::savings_plans_coverages): <p>The amount of spend that your Savings Plans covered.</p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSavingsPlansCoverageOutput::next_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On failure, responds with [`SdkError<GetSavingsPlansCoverageError>`](crate::error::GetSavingsPlansCoverageError)
    pub fn get_savings_plans_coverage(&self) -> fluent_builders::GetSavingsPlansCoverage<C, M, R> {
        fluent_builders::GetSavingsPlansCoverage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSavingsPlansPurchaseRecommendation`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`savings_plans_type(SupportedSavingsPlansType)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::savings_plans_type) / [`set_savings_plans_type(Option<SupportedSavingsPlansType>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_savings_plans_type): <p>The Savings Plans recommendation type requested.</p>
    ///   - [`term_in_years(TermInYears)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::term_in_years) / [`set_term_in_years(Option<TermInYears>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_term_in_years): <p>The savings plan recommendation term used to generate these recommendations.</p>
    ///   - [`payment_option(PaymentOption)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::payment_option) / [`set_payment_option(Option<PaymentOption>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_payment_option): <p>The payment option used to generate these recommendations.</p>
    ///   - [`account_scope(AccountScope)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::account_scope) / [`set_account_scope(Option<AccountScope>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_account_scope): <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`page_size(i32)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::page_size) / [`set_page_size(i32)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_page_size): <p>The number of recommendations that you want returned in a single response object.</p>
    ///   - [`lookback_period_in_days(LookbackPeriodInDays)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::lookback_period_in_days) / [`set_lookback_period_in_days(Option<LookbackPeriodInDays>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_lookback_period_in_days): <p>The lookback period used to generate the recommendation.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation::set_filter): <p>You can filter your recommendations by Account ID with the <code>LINKED_ACCOUNT</code> dimension. To filter your recommendations by Account ID, specify <code>Key</code> as <code>LINKED_ACCOUNT</code> and <code>Value</code> as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations.</p>  <p>For GetSavingsPlansPurchaseRecommendation, the <code>Filter</code> does not include <code>CostCategories</code> or <code>Tags</code>. It only includes <code>Dimensions</code>. With <code>Dimensions</code>, <code>Key</code> must be <code>LINKED_ACCOUNT</code> and <code>Value</code> can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. <code>AND</code> and <code>OR</code> operators are not supported.</p>
    /// - On success, responds with [`GetSavingsPlansPurchaseRecommendationOutput`](crate::output::GetSavingsPlansPurchaseRecommendationOutput) with field(s):
    ///   - [`metadata(Option<SavingsPlansPurchaseRecommendationMetadata>)`](crate::output::GetSavingsPlansPurchaseRecommendationOutput::metadata): <p>Information regarding this specific recommendation set.</p>
    ///   - [`savings_plans_purchase_recommendation(Option<SavingsPlansPurchaseRecommendation>)`](crate::output::GetSavingsPlansPurchaseRecommendationOutput::savings_plans_purchase_recommendation): <p>Contains your request parameters, Savings Plan Recommendations Summary, and Details.</p>
    ///   - [`next_page_token(Option<String>)`](crate::output::GetSavingsPlansPurchaseRecommendationOutput::next_page_token): <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On failure, responds with [`SdkError<GetSavingsPlansPurchaseRecommendationError>`](crate::error::GetSavingsPlansPurchaseRecommendationError)
    pub fn get_savings_plans_purchase_recommendation(
        &self,
    ) -> fluent_builders::GetSavingsPlansPurchaseRecommendation<C, M, R> {
        fluent_builders::GetSavingsPlansPurchaseRecommendation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSavingsPlansUtilization`](crate::client::fluent_builders::GetSavingsPlansUtilization) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetSavingsPlansUtilization::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetSavingsPlansUtilization::set_time_period): <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetSavingsPlansUtilization::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetSavingsPlansUtilization::set_granularity): <p>The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>  <p>The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetSavingsPlansUtilization::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetSavingsPlansUtilization::set_filter): <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>  <ul>   <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>   <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>   <li> <p> <code>SAVINGS_PLANS_TYPE</code> </p> </li>   <li> <p> <code>REGION</code> </p> </li>   <li> <p> <code>PAYMENT_OPTION</code> </p> </li>   <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>  </ul>  <p> <code>GetSavingsPlansUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>  <p>Filtering by tags isn't supported.</p>
    ///   - [`sort_by(SortDefinition)`](crate::client::fluent_builders::GetSavingsPlansUtilization::sort_by) / [`set_sort_by(Option<SortDefinition>)`](crate::client::fluent_builders::GetSavingsPlansUtilization::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The following values are supported for <code>Key</code>:</p>  <ul>   <li> <p> <code>UtilizationPercentage</code> </p> </li>   <li> <p> <code>TotalCommitment</code> </p> </li>   <li> <p> <code>UsedCommitment</code> </p> </li>   <li> <p> <code>UnusedCommitment</code> </p> </li>   <li> <p> <code>NetSavings</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// - On success, responds with [`GetSavingsPlansUtilizationOutput`](crate::output::GetSavingsPlansUtilizationOutput) with field(s):
    ///   - [`savings_plans_utilizations_by_time(Option<Vec<SavingsPlansUtilizationByTime>>)`](crate::output::GetSavingsPlansUtilizationOutput::savings_plans_utilizations_by_time): <p>The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.</p>
    ///   - [`total(Option<SavingsPlansUtilizationAggregates>)`](crate::output::GetSavingsPlansUtilizationOutput::total): <p>The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.</p>
    /// - On failure, responds with [`SdkError<GetSavingsPlansUtilizationError>`](crate::error::GetSavingsPlansUtilizationError)
    pub fn get_savings_plans_utilization(
        &self,
    ) -> fluent_builders::GetSavingsPlansUtilization<C, M, R> {
        fluent_builders::GetSavingsPlansUtilization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetSavingsPlansUtilizationDetails`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::set_time_period): <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::set_filter): <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>  <ul>   <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>   <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>   <li> <p> <code>REGION</code> </p> </li>   <li> <p> <code>PAYMENT_OPTION</code> </p> </li>   <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>  </ul>  <p> <code>GetSavingsPlansUtilizationDetails</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>  <p>Filtering by tags isn't supported.</p>
    ///   - [`data_type(Vec<SavingsPlansDataType>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::data_type) / [`set_data_type(Option<Vec<SavingsPlansDataType>>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::set_data_type): <p>The data type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::set_next_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::set_max_results): <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
    ///   - [`sort_by(SortDefinition)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::sort_by) / [`set_sort_by(Option<SortDefinition>)`](crate::client::fluent_builders::GetSavingsPlansUtilizationDetails::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The following values are supported for <code>Key</code>:</p>  <ul>   <li> <p> <code>UtilizationPercentage</code> </p> </li>   <li> <p> <code>TotalCommitment</code> </p> </li>   <li> <p> <code>UsedCommitment</code> </p> </li>   <li> <p> <code>UnusedCommitment</code> </p> </li>   <li> <p> <code>NetSavings</code> </p> </li>   <li> <p> <code>AmortizedRecurringCommitment</code> </p> </li>   <li> <p> <code>AmortizedUpfrontCommitment</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
    /// - On success, responds with [`GetSavingsPlansUtilizationDetailsOutput`](crate::output::GetSavingsPlansUtilizationDetailsOutput) with field(s):
    ///   - [`savings_plans_utilization_details(Option<Vec<SavingsPlansUtilizationDetail>>)`](crate::output::GetSavingsPlansUtilizationDetailsOutput::savings_plans_utilization_details): <p>Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.</p>
    ///   - [`total(Option<SavingsPlansUtilizationAggregates>)`](crate::output::GetSavingsPlansUtilizationDetailsOutput::total): <p>The total Savings Plans utilization, regardless of time period.</p>
    ///   - [`time_period(Option<DateInterval>)`](crate::output::GetSavingsPlansUtilizationDetailsOutput::time_period): <p>The time period of the request. </p>
    ///   - [`next_token(Option<String>)`](crate::output::GetSavingsPlansUtilizationDetailsOutput::next_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On failure, responds with [`SdkError<GetSavingsPlansUtilizationDetailsError>`](crate::error::GetSavingsPlansUtilizationDetailsError)
    pub fn get_savings_plans_utilization_details(
        &self,
    ) -> fluent_builders::GetSavingsPlansUtilizationDetails<C, M, R> {
        fluent_builders::GetSavingsPlansUtilizationDetails::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetTags`](crate::client::fluent_builders::GetTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`search_string(impl Into<String>)`](crate::client::fluent_builders::GetTags::search_string) / [`set_search_string(Option<String>)`](crate::client::fluent_builders::GetTags::set_search_string): <p>The value that you want to search for.</p>
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetTags::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetTags::set_time_period): <p>The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
    ///   - [`tag_key(impl Into<String>)`](crate::client::fluent_builders::GetTags::tag_key) / [`set_tag_key(Option<String>)`](crate::client::fluent_builders::GetTags::set_tag_key): <p>The key of the tag that you want to return values for.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetTags::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetTags::set_filter): <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>  <ul>   <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>   <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>     <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>    </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>  </ul> <note>   <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>   <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>  </note>
    ///   - [`sort_by(Vec<SortDefinition>)`](crate::client::fluent_builders::GetTags::sort_by) / [`set_sort_by(Option<Vec<SortDefinition>>)`](crate::client::fluent_builders::GetTags::set_sort_by): <p>The value by which you want to sort the data.</p>  <p>The key represents cost and usage metrics. The following values are supported:</p>  <ul>   <li> <p> <code>BlendedCost</code> </p> </li>   <li> <p> <code>UnblendedCost</code> </p> </li>   <li> <p> <code>AmortizedCost</code> </p> </li>   <li> <p> <code>NetAmortizedCost</code> </p> </li>   <li> <p> <code>NetUnblendedCost</code> </p> </li>   <li> <p> <code>UsageQuantity</code> </p> </li>   <li> <p> <code>NormalizedUsageAmount</code> </p> </li>  </ul>  <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>  <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetTags::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetTags::set_max_results): <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>  <p>For <code>GetTags</code>, MaxResults has an upper limit of 1000.</p>
    ///   - [`next_page_token(impl Into<String>)`](crate::client::fluent_builders::GetTags::next_page_token) / [`set_next_page_token(Option<String>)`](crate::client::fluent_builders::GetTags::set_next_page_token): <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    /// - On success, responds with [`GetTagsOutput`](crate::output::GetTagsOutput) with field(s):
    ///   - [`next_page_token(Option<String>)`](crate::output::GetTagsOutput::next_page_token): <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    ///   - [`tags(Option<Vec<String>>)`](crate::output::GetTagsOutput::tags): <p>The tags that match your request.</p>
    ///   - [`return_size(Option<i32>)`](crate::output::GetTagsOutput::return_size): <p>The number of query results that Amazon Web Services returns at a time.</p>
    ///   - [`total_size(Option<i32>)`](crate::output::GetTagsOutput::total_size): <p>The total number of query results.</p>
    /// - On failure, responds with [`SdkError<GetTagsError>`](crate::error::GetTagsError)
    pub fn get_tags(&self) -> fluent_builders::GetTags<C, M, R> {
        fluent_builders::GetTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsageForecast`](crate::client::fluent_builders::GetUsageForecast) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_period(DateInterval)`](crate::client::fluent_builders::GetUsageForecast::time_period) / [`set_time_period(Option<DateInterval>)`](crate::client::fluent_builders::GetUsageForecast::set_time_period): <p>The start and end dates of the period that you want to retrieve usage forecast for. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. The start date must be equal to or later than the current date to avoid a validation error.</p>
    ///   - [`metric(Metric)`](crate::client::fluent_builders::GetUsageForecast::metric) / [`set_metric(Option<Metric>)`](crate::client::fluent_builders::GetUsageForecast::set_metric): <p>Which metric Cost Explorer uses to create your forecast.</p>  <p>Valid values for a <code>GetUsageForecast</code> call are the following:</p>  <ul>   <li> <p>USAGE_QUANTITY</p> </li>   <li> <p>NORMALIZED_USAGE_AMOUNT</p> </li>  </ul>
    ///   - [`granularity(Granularity)`](crate::client::fluent_builders::GetUsageForecast::granularity) / [`set_granularity(Option<Granularity>)`](crate::client::fluent_builders::GetUsageForecast::set_granularity): <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>  <p>The <code>GetUsageForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
    ///   - [`filter(Expression)`](crate::client::fluent_builders::GetUsageForecast::filter) / [`set_filter(Option<Expression>)`](crate::client::fluent_builders::GetUsageForecast::set_filter): <p>The filters that you want to use to filter your forecast. The <code>GetUsageForecast</code> API supports filtering by the following dimensions:</p>  <ul>   <li> <p> <code>AZ</code> </p> </li>   <li> <p> <code>INSTANCE_TYPE</code> </p> </li>   <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>   <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>   <li> <p> <code>OPERATION</code> </p> </li>   <li> <p> <code>PURCHASE_TYPE</code> </p> </li>   <li> <p> <code>REGION</code> </p> </li>   <li> <p> <code>SERVICE</code> </p> </li>   <li> <p> <code>USAGE_TYPE</code> </p> </li>   <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>   <li> <p> <code>RECORD_TYPE</code> </p> </li>   <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>   <li> <p> <code>TENANCY</code> </p> </li>   <li> <p> <code>SCOPE</code> </p> </li>   <li> <p> <code>PLATFORM</code> </p> </li>   <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>   <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>   <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>   <li> <p> <code>DATABASE_ENGINE</code> </p> </li>   <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>   <li> <p> <code>BILLING_ENTITY</code> </p> </li>   <li> <p> <code>RESERVATION_ID</code> </p> </li>   <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>  </ul>
    ///   - [`prediction_interval_level(i32)`](crate::client::fluent_builders::GetUsageForecast::prediction_interval_level) / [`set_prediction_interval_level(Option<i32>)`](crate::client::fluent_builders::GetUsageForecast::set_prediction_interval_level): <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
    /// - On success, responds with [`GetUsageForecastOutput`](crate::output::GetUsageForecastOutput) with field(s):
    ///   - [`total(Option<MetricValue>)`](crate::output::GetUsageForecastOutput::total): <p>How much you're forecasted to use over the forecast period.</p>
    ///   - [`forecast_results_by_time(Option<Vec<ForecastResult>>)`](crate::output::GetUsageForecastOutput::forecast_results_by_time): <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts, this is a list of months.</p>
    /// - On failure, responds with [`SdkError<GetUsageForecastError>`](crate::error::GetUsageForecastError)
    pub fn get_usage_forecast(&self) -> fluent_builders::GetUsageForecast<C, M, R> {
        fluent_builders::GetUsageForecast::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCostCategoryDefinitions`](crate::client::fluent_builders::ListCostCategoryDefinitions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCostCategoryDefinitions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`effective_on(impl Into<String>)`](crate::client::fluent_builders::ListCostCategoryDefinitions::effective_on) / [`set_effective_on(Option<String>)`](crate::client::fluent_builders::ListCostCategoryDefinitions::set_effective_on): <p> The date when the Cost Category was effective. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCostCategoryDefinitions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCostCategoryDefinitions::set_next_token): <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCostCategoryDefinitions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListCostCategoryDefinitions::set_max_results): <p> The number of entries a paginated response contains. </p>
    /// - On success, responds with [`ListCostCategoryDefinitionsOutput`](crate::output::ListCostCategoryDefinitionsOutput) with field(s):
    ///   - [`cost_category_references(Option<Vec<CostCategoryReference>>)`](crate::output::ListCostCategoryDefinitionsOutput::cost_category_references): <p> A reference to a Cost Category containing enough information to identify the Cost Category. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCostCategoryDefinitionsOutput::next_token): <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
    /// - On failure, responds with [`SdkError<ListCostCategoryDefinitionsError>`](crate::error::ListCostCategoryDefinitionsError)
    pub fn list_cost_category_definitions(
        &self,
    ) -> fluent_builders::ListCostCategoryDefinitions<C, M, R> {
        fluent_builders::ListCostCategoryDefinitions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ProvideAnomalyFeedback`](crate::client::fluent_builders::ProvideAnomalyFeedback) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`anomaly_id(impl Into<String>)`](crate::client::fluent_builders::ProvideAnomalyFeedback::anomaly_id) / [`set_anomaly_id(Option<String>)`](crate::client::fluent_builders::ProvideAnomalyFeedback::set_anomaly_id): <p>A cost anomaly ID. </p>
    ///   - [`feedback(AnomalyFeedbackType)`](crate::client::fluent_builders::ProvideAnomalyFeedback::feedback) / [`set_feedback(Option<AnomalyFeedbackType>)`](crate::client::fluent_builders::ProvideAnomalyFeedback::set_feedback): <p>Describes whether the cost anomaly was a planned activity or you considered it an anomaly. </p>
    /// - On success, responds with [`ProvideAnomalyFeedbackOutput`](crate::output::ProvideAnomalyFeedbackOutput) with field(s):
    ///   - [`anomaly_id(Option<String>)`](crate::output::ProvideAnomalyFeedbackOutput::anomaly_id): <p>The ID of the modified cost anomaly. </p>
    /// - On failure, responds with [`SdkError<ProvideAnomalyFeedbackError>`](crate::error::ProvideAnomalyFeedbackError)
    pub fn provide_anomaly_feedback(&self) -> fluent_builders::ProvideAnomalyFeedback<C, M, R> {
        fluent_builders::ProvideAnomalyFeedback::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAnomalyMonitor`](crate::client::fluent_builders::UpdateAnomalyMonitor) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`monitor_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAnomalyMonitor::monitor_arn) / [`set_monitor_arn(Option<String>)`](crate::client::fluent_builders::UpdateAnomalyMonitor::set_monitor_arn): <p>Cost anomaly monitor Amazon Resource Names (ARNs). </p>
    ///   - [`monitor_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAnomalyMonitor::monitor_name) / [`set_monitor_name(Option<String>)`](crate::client::fluent_builders::UpdateAnomalyMonitor::set_monitor_name): <p>The new name for the cost anomaly monitor. </p>
    /// - On success, responds with [`UpdateAnomalyMonitorOutput`](crate::output::UpdateAnomalyMonitorOutput) with field(s):
    ///   - [`monitor_arn(Option<String>)`](crate::output::UpdateAnomalyMonitorOutput::monitor_arn): <p>A cost anomaly monitor ARN. </p>
    /// - On failure, responds with [`SdkError<UpdateAnomalyMonitorError>`](crate::error::UpdateAnomalyMonitorError)
    pub fn update_anomaly_monitor(&self) -> fluent_builders::UpdateAnomalyMonitor<C, M, R> {
        fluent_builders::UpdateAnomalyMonitor::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAnomalySubscription`](crate::client::fluent_builders::UpdateAnomalySubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateAnomalySubscription::subscription_arn) / [`set_subscription_arn(Option<String>)`](crate::client::fluent_builders::UpdateAnomalySubscription::set_subscription_arn): <p>A cost anomaly subscription Amazon Resource Name (ARN). </p>
    ///   - [`threshold(f64)`](crate::client::fluent_builders::UpdateAnomalySubscription::threshold) / [`set_threshold(Option<f64>)`](crate::client::fluent_builders::UpdateAnomalySubscription::set_threshold): <p>The update to the threshold value for receiving notifications. </p>
    ///   - [`frequency(AnomalySubscriptionFrequency)`](crate::client::fluent_builders::UpdateAnomalySubscription::frequency) / [`set_frequency(Option<AnomalySubscriptionFrequency>)`](crate::client::fluent_builders::UpdateAnomalySubscription::set_frequency): <p>The update to the frequency value that subscribers receive notifications. </p>
    ///   - [`monitor_arn_list(Vec<String>)`](crate::client::fluent_builders::UpdateAnomalySubscription::monitor_arn_list) / [`set_monitor_arn_list(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateAnomalySubscription::set_monitor_arn_list): <p>A list of cost anomaly monitor ARNs. </p>
    ///   - [`subscribers(Vec<Subscriber>)`](crate::client::fluent_builders::UpdateAnomalySubscription::subscribers) / [`set_subscribers(Option<Vec<Subscriber>>)`](crate::client::fluent_builders::UpdateAnomalySubscription::set_subscribers): <p>The update to the subscriber list. </p>
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::UpdateAnomalySubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::UpdateAnomalySubscription::set_subscription_name): <p>The new name of the subscription. </p>
    /// - On success, responds with [`UpdateAnomalySubscriptionOutput`](crate::output::UpdateAnomalySubscriptionOutput) with field(s):
    ///   - [`subscription_arn(Option<String>)`](crate::output::UpdateAnomalySubscriptionOutput::subscription_arn): <p>A cost anomaly subscription ARN. </p>
    /// - On failure, responds with [`SdkError<UpdateAnomalySubscriptionError>`](crate::error::UpdateAnomalySubscriptionError)
    pub fn update_anomaly_subscription(
        &self,
    ) -> fluent_builders::UpdateAnomalySubscription<C, M, R> {
        fluent_builders::UpdateAnomalySubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateCostCategoryDefinition`](crate::client::fluent_builders::UpdateCostCategoryDefinition) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cost_category_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::cost_category_arn) / [`set_cost_category_arn(Option<String>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::set_cost_category_arn): <p>The unique identifier for your Cost Category.</p>
    ///   - [`rule_version(CostCategoryRuleVersion)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::rule_version) / [`set_rule_version(Option<CostCategoryRuleVersion>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::set_rule_version): <p>The rule schema version in this particular Cost Category.</p>
    ///   - [`rules(Vec<CostCategoryRule>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::rules) / [`set_rules(Option<Vec<CostCategoryRule>>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::set_rules): <p>The <code>Expression</code> object used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule </a>. </p>
    ///   - [`default_value(impl Into<String>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::default_value) / [`set_default_value(Option<String>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::set_default_value): <p>The default value for the cost category.</p>
    ///   - [`split_charge_rules(Vec<CostCategorySplitChargeRule>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::split_charge_rules) / [`set_split_charge_rules(Option<Vec<CostCategorySplitChargeRule>>)`](crate::client::fluent_builders::UpdateCostCategoryDefinition::set_split_charge_rules): <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
    /// - On success, responds with [`UpdateCostCategoryDefinitionOutput`](crate::output::UpdateCostCategoryDefinitionOutput) with field(s):
    ///   - [`cost_category_arn(Option<String>)`](crate::output::UpdateCostCategoryDefinitionOutput::cost_category_arn): <p> The unique identifier for your Cost Category. </p>
    ///   - [`effective_start(Option<String>)`](crate::output::UpdateCostCategoryDefinitionOutput::effective_start): <p> The Cost Category's effective start date. </p>
    /// - On failure, responds with [`SdkError<UpdateCostCategoryDefinitionError>`](crate::error::UpdateCostCategoryDefinitionError)
    pub fn update_cost_category_definition(
        &self,
    ) -> fluent_builders::UpdateCostCategoryDefinition<C, M, R> {
        fluent_builders::UpdateCostCategoryDefinition::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateAnomalyMonitor`.
    ///
    /// <p>Creates a new cost anomaly detection monitor with the requested type and monitor specification. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAnomalyMonitor<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_anomaly_monitor_input::Builder,
    }
    impl<C, M, R> CreateAnomalyMonitor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAnomalyMonitor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAnomalyMonitorOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAnomalyMonitorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAnomalyMonitorInputOperationOutputAlias,
                crate::output::CreateAnomalyMonitorOutput,
                crate::error::CreateAnomalyMonitorError,
                crate::input::CreateAnomalyMonitorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cost anomaly detection monitor object that you want to create.</p>
        pub fn anomaly_monitor(mut self, input: crate::model::AnomalyMonitor) -> Self {
            self.inner = self.inner.anomaly_monitor(input);
            self
        }
        /// <p>The cost anomaly detection monitor object that you want to create.</p>
        pub fn set_anomaly_monitor(
            mut self,
            input: std::option::Option<crate::model::AnomalyMonitor>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_monitor(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAnomalySubscription`.
    ///
    /// <p>Adds a subscription to a cost anomaly detection monitor. You can use each subscription to define subscribers with email or SNS notifications. Email subscribers can set a dollar threshold and a time frequency for receiving notifications. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAnomalySubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_anomaly_subscription_input::Builder,
    }
    impl<C, M, R> CreateAnomalySubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAnomalySubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAnomalySubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAnomalySubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAnomalySubscriptionInputOperationOutputAlias,
                crate::output::CreateAnomalySubscriptionOutput,
                crate::error::CreateAnomalySubscriptionError,
                crate::input::CreateAnomalySubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cost anomaly subscription object that you want to create. </p>
        pub fn anomaly_subscription(mut self, input: crate::model::AnomalySubscription) -> Self {
            self.inner = self.inner.anomaly_subscription(input);
            self
        }
        /// <p>The cost anomaly subscription object that you want to create. </p>
        pub fn set_anomaly_subscription(
            mut self,
            input: std::option::Option<crate::model::AnomalySubscription>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_subscription(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCostCategoryDefinition`.
    ///
    /// <p>Creates a new Cost Category with the requested name and rules.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCostCategoryDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cost_category_definition_input::Builder,
    }
    impl<C, M, R> CreateCostCategoryDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCostCategoryDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCostCategoryDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCostCategoryDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCostCategoryDefinitionInputOperationOutputAlias,
                crate::output::CreateCostCategoryDefinitionOutput,
                crate::error::CreateCostCategoryDefinitionError,
                crate::input::CreateCostCategoryDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn rule_version(mut self, input: crate::model::CostCategoryRuleVersion) -> Self {
            self.inner = self.inner.rule_version(input);
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn set_rule_version(
            mut self,
            input: std::option::Option<crate::model::CostCategoryRuleVersion>,
        ) -> Self {
            self.inner = self.inner.set_rule_version(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The Cost Category rules used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule</a>.</p>
        pub fn rules(mut self, input: crate::model::CostCategoryRule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The Cost Category rules used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule</a>.</p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_value(input.into());
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_value(input);
            self
        }
        /// Appends an item to `SplitChargeRules`.
        ///
        /// To override the contents of this collection use [`set_split_charge_rules`](Self::set_split_charge_rules).
        ///
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn split_charge_rules(
            mut self,
            input: crate::model::CostCategorySplitChargeRule,
        ) -> Self {
            self.inner = self.inner.split_charge_rules(input);
            self
        }
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn set_split_charge_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
        ) -> Self {
            self.inner = self.inner.set_split_charge_rules(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAnomalyMonitor`.
    ///
    /// <p>Deletes a cost anomaly monitor. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAnomalyMonitor<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_anomaly_monitor_input::Builder,
    }
    impl<C, M, R> DeleteAnomalyMonitor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAnomalyMonitor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAnomalyMonitorOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAnomalyMonitorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAnomalyMonitorInputOperationOutputAlias,
                crate::output::DeleteAnomalyMonitorOutput,
                crate::error::DeleteAnomalyMonitorError,
                crate::input::DeleteAnomalyMonitorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cost anomaly monitor that you want to delete. </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitor_arn(input.into());
            self
        }
        /// <p>The unique identifier of the cost anomaly monitor that you want to delete. </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_monitor_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAnomalySubscription`.
    ///
    /// <p>Deletes a cost anomaly subscription. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAnomalySubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_anomaly_subscription_input::Builder,
    }
    impl<C, M, R> DeleteAnomalySubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAnomalySubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAnomalySubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAnomalySubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAnomalySubscriptionInputOperationOutputAlias,
                crate::output::DeleteAnomalySubscriptionOutput,
                crate::error::DeleteAnomalySubscriptionError,
                crate::input::DeleteAnomalySubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cost anomaly subscription that you want to delete. </p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_arn(input.into());
            self
        }
        /// <p>The unique identifier of the cost anomaly subscription that you want to delete. </p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCostCategoryDefinition`.
    ///
    /// <p>Deletes a Cost Category. Expenses from this month going forward will no longer be categorized with this Cost Category.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCostCategoryDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cost_category_definition_input::Builder,
    }
    impl<C, M, R> DeleteCostCategoryDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCostCategoryDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCostCategoryDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCostCategoryDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCostCategoryDefinitionInputOperationOutputAlias,
                crate::output::DeleteCostCategoryDefinitionOutput,
                crate::error::DeleteCostCategoryDefinitionError,
                crate::input::DeleteCostCategoryDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cost_category_arn(input.into());
            self
        }
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cost_category_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeCostCategoryDefinition`.
    ///
    /// <p>Returns the name, ARN, rules, definition, and effective dates of a Cost Category that's defined in the account.</p>
    /// <p>You have the option to use <code>EffectiveOn</code> to return a Cost Category that is active on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see a Cost Category that is effective on the current date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the response. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeCostCategoryDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cost_category_definition_input::Builder,
    }
    impl<C, M, R> DescribeCostCategoryDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeCostCategoryDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeCostCategoryDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeCostCategoryDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeCostCategoryDefinitionInputOperationOutputAlias,
                crate::output::DescribeCostCategoryDefinitionOutput,
                crate::error::DescribeCostCategoryDefinitionError,
                crate::input::DescribeCostCategoryDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cost_category_arn(input.into());
            self
        }
        /// <p> The unique identifier for your Cost Category. </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cost_category_arn(input);
            self
        }
        /// <p> The date when the Cost Category was effective. </p>
        pub fn effective_on(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.effective_on(input.into());
            self
        }
        /// <p> The date when the Cost Category was effective. </p>
        pub fn set_effective_on(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_effective_on(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnomalies`.
    ///
    /// <p>Retrieves all of the cost anomalies detected on your account during the time period that's specified by the <code>DateInterval</code> object. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAnomalies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_anomalies_input::Builder,
    }
    impl<C, M, R> GetAnomalies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnomalies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnomaliesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnomaliesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnomaliesInputOperationOutputAlias,
                crate::output::GetAnomaliesOutput,
                crate::error::GetAnomaliesError,
                crate::input::GetAnomaliesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitor_arn(input.into());
            self
        }
        /// <p>Retrieves all of the cost anomalies detected for a specific cost anomaly monitor Amazon Resource Name (ARN). </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_monitor_arn(input);
            self
        }
        /// <p>Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an <code>AnomalyEndDate</code> in the specified time range. </p>
        pub fn date_interval(mut self, input: crate::model::AnomalyDateInterval) -> Self {
            self.inner = self.inner.date_interval(input);
            self
        }
        /// <p>Assigns the start and end dates for retrieving cost anomalies. The returned anomaly object will have an <code>AnomalyEndDate</code> in the specified time range. </p>
        pub fn set_date_interval(
            mut self,
            input: std::option::Option<crate::model::AnomalyDateInterval>,
        ) -> Self {
            self.inner = self.inner.set_date_interval(input);
            self
        }
        /// <p>Filters anomaly results by the feedback field on the anomaly object. </p>
        pub fn feedback(mut self, input: crate::model::AnomalyFeedbackType) -> Self {
            self.inner = self.inner.feedback(input);
            self
        }
        /// <p>Filters anomaly results by the feedback field on the anomaly object. </p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyFeedbackType>,
        ) -> Self {
            self.inner = self.inner.set_feedback(input);
            self
        }
        /// <p>Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200. </p>
        pub fn total_impact(mut self, input: crate::model::TotalImpactFilter) -> Self {
            self.inner = self.inner.total_impact(input);
            self
        }
        /// <p>Filters anomaly results by the total impact field on the anomaly object. For example, you can filter anomalies <code>GREATER_THAN 200.00</code> to retrieve anomalies, with an estimated dollar impact greater than 200. </p>
        pub fn set_total_impact(
            mut self,
            input: std::option::Option<crate::model::TotalImpactFilter>,
        ) -> Self {
            self.inner = self.inner.set_total_impact(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnomalyMonitors`.
    ///
    /// <p>Retrieves the cost anomaly monitor definitions for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAnomalyMonitors<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_anomaly_monitors_input::Builder,
    }
    impl<C, M, R> GetAnomalyMonitors<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnomalyMonitors`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnomalyMonitorsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnomalyMonitorsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnomalyMonitorsInputOperationOutputAlias,
                crate::output::GetAnomalyMonitorsOutput,
                crate::error::GetAnomalyMonitorsError,
                crate::input::GetAnomalyMonitorsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `MonitorArnList`.
        ///
        /// To override the contents of this collection use [`set_monitor_arn_list`](Self::set_monitor_arn_list).
        ///
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn monitor_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitor_arn_list(input.into());
            self
        }
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn set_monitor_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_monitor_arn_list(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The number of entries that a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of entries that a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAnomalySubscriptions`.
    ///
    /// <p>Retrieves the cost anomaly subscription objects for your account. You can filter using a list of cost anomaly monitor Amazon Resource Names (ARNs). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAnomalySubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_anomaly_subscriptions_input::Builder,
    }
    impl<C, M, R> GetAnomalySubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAnomalySubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAnomalySubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAnomalySubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAnomalySubscriptionsInputOperationOutputAlias,
                crate::output::GetAnomalySubscriptionsOutput,
                crate::error::GetAnomalySubscriptionsError,
                crate::input::GetAnomalySubscriptionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SubscriptionArnList`.
        ///
        /// To override the contents of this collection use [`set_subscription_arn_list`](Self::set_subscription_arn_list).
        ///
        /// <p>A list of cost anomaly subscription ARNs. </p>
        pub fn subscription_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_arn_list(input.into());
            self
        }
        /// <p>A list of cost anomaly subscription ARNs. </p>
        pub fn set_subscription_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subscription_arn_list(input);
            self
        }
        /// <p>Cost anomaly monitor ARNs. </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitor_arn(input.into());
            self
        }
        /// <p>Cost anomaly monitor ARNs. </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_monitor_arn(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of entries a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCostAndUsage`.
    ///
    /// <p>Retrieves cost and usage metrics for your account. You can specify which cost and usage-related metric that you want the request to return. For example, you can specify <code>BlendedCosts</code> or <code>UsageQuantity</code>. You can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>, in a specific time range. For a complete list of valid dimensions, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html">GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all member accounts.</p>
    /// <p>For information about filter limitations, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-limits.html">Quotas and restrictions</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCostAndUsage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cost_and_usage_input::Builder,
    }
    impl<C, M, R> GetCostAndUsage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCostAndUsage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCostAndUsageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCostAndUsageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCostAndUsageInputOperationOutputAlias,
                crate::output::GetCostAndUsageOutput,
                crate::error::GetCostAndUsageError,
                crate::input::GetCostAndUsageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Sets the start date and end date for retrieving Amazon Web Services costs. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>Sets the start date and end date for retrieving Amazon Web Services costs. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `Metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking into account the units. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours and GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsage</code> requests.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metrics(input.into());
            self
        }
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking into account the units. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours and GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsage</code> requests.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_metrics(input);
            self
        }
        /// Appends an item to `GroupBy`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group Amazon Web Services costs using up to two different groups, either dimensions, tag keys, cost categories, or any two group by types.</p>
        /// <p>Valid values for the <code>DIMENSION</code> type are <code>AZ</code>, <code>INSTANCE_TYPE</code>, <code>LEGAL_ENTITY_NAME</code>, <code>LINKED_ACCOUNT</code>, <code>OPERATION</code>, <code>PLATFORM</code>, <code>PURCHASE_TYPE</code>, <code>SERVICE</code>, <code>TENANCY</code>, <code>RECORD_TYPE</code>, and <code>USAGE_TYPE</code>.</p>
        /// <p>When you group by the <code>TAG</code> type and include a valid tag key, you get all tag values, including empty strings.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>You can group Amazon Web Services costs using up to two different groups, either dimensions, tag keys, cost categories, or any two group by types.</p>
        /// <p>Valid values for the <code>DIMENSION</code> type are <code>AZ</code>, <code>INSTANCE_TYPE</code>, <code>LEGAL_ENTITY_NAME</code>, <code>LINKED_ACCOUNT</code>, <code>OPERATION</code>, <code>PLATFORM</code>, <code>PURCHASE_TYPE</code>, <code>SERVICE</code>, <code>TENANCY</code>, <code>RECORD_TYPE</code>, and <code>USAGE_TYPE</code>.</p>
        /// <p>When you group by the <code>TAG</code> type and include a valid tag key, you get all tag values, including empty strings.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCostAndUsageWithResources`.
    ///
    /// <p>Retrieves cost and usage metrics with resources for your account. You can specify which cost and usage-related metric, such as <code>BlendedCosts</code> or <code>UsageQuantity</code>, that you want the request to return. You can also filter and group your data by various dimensions, such as <code>SERVICE</code> or <code>AZ</code>, in a specific time range. For a complete list of valid dimensions, see the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html">GetDimensionValues</a> operation. Management account in an organization in Organizations have access to all member accounts. This API is currently available for the Amazon Elastic Compute Cloud – Compute service only.</p> <note>
    /// <p>This is an opt-in only feature. You can enable this feature from the Cost Explorer Settings page. For information on how to access the Settings page, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-access.html">Controlling Access for Cost Explorer</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCostAndUsageWithResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cost_and_usage_with_resources_input::Builder,
    }
    impl<C, M, R> GetCostAndUsageWithResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCostAndUsageWithResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCostAndUsageWithResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCostAndUsageWithResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCostAndUsageWithResourcesInputOperationOutputAlias,
                crate::output::GetCostAndUsageWithResourcesOutput,
                crate::error::GetCostAndUsageWithResourcesError,
                crate::input::GetCostAndUsageWithResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Sets the start and end dates for retrieving Amazon Web Services costs. The range must be within the last 14 days (the start date cannot be earlier than 14 days ago). The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>Sets the start and end dates for retrieving Amazon Web Services costs. The range must be within the last 14 days (the start date cannot be earlier than 14 days ago). The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>Sets the Amazon Web Services cost granularity to <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. If <code>Granularity</code> isn't set, the response object doesn't include the <code>Granularity</code>, <code>MONTHLY</code>, <code>DAILY</code>, or <code>HOURLY</code>. </p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The <code>GetCostAndUsageWithResources</code> operation requires that you either group by or filter by a <code>ResourceId</code>. It requires the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> <code>"SERVICE = Amazon Elastic Compute Cloud - Compute"</code> in the filter.</p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters Amazon Web Services costs by different dimensions. For example, you can specify <code>SERVICE</code> and <code>LINKED_ACCOUNT</code> and get the costs that are associated with that account's usage of that service. You can nest <code>Expression</code> objects to define any combination of dimension filters. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>. </p>
        /// <p>The <code>GetCostAndUsageWithResources</code> operation requires that you either group by or filter by a <code>ResourceId</code>. It requires the <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> <code>"SERVICE = Amazon Elastic Compute Cloud - Compute"</code> in the filter.</p>
        /// <p>The default values are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>. Valid values for <code>MatchOptions</code> for <code>Dimensions</code> are <code>EQUALS</code> and <code>CASE_SENSITIVE</code>.</p>
        /// <p>Valid values for <code>MatchOptions</code> for <code>CostCategories</code> and <code>Tags</code> are <code>EQUALS</code>, <code>ABSENT</code>, and <code>CASE_SENSITIVE</code>.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `Metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking the units into account. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours vs. GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsageWithResources</code> requests.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metrics(input.into());
            self
        }
        /// <p>Which metrics are returned in the query. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values are <code>AmortizedCost</code>, <code>BlendedCost</code>, <code>NetAmortizedCost</code>, <code>NetUnblendedCost</code>, <code>NormalizedUsageAmount</code>, <code>UnblendedCost</code>, and <code>UsageQuantity</code>. </p> <note>
        /// <p>If you return the <code>UsageQuantity</code> metric, the service aggregates all usage numbers without taking the units into account. For example, if you aggregate <code>usageQuantity</code> across all of Amazon EC2, the results aren't meaningful because Amazon EC2 compute hours and data transfer are measured in different units (for example, hours vs. GB). To get more meaningful <code>UsageQuantity</code> metrics, filter by <code>UsageType</code> or <code>UsageTypeGroups</code>. </p>
        /// </note>
        /// <p> <code>Metrics</code> is required for <code>GetCostAndUsageWithResources</code> requests.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_metrics(input);
            self
        }
        /// Appends an item to `GroupBy`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group Amazon Web Services costs using up to two different groups: <code>DIMENSION</code>, <code>TAG</code>, <code>COST_CATEGORY</code>.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>You can group Amazon Web Services costs using up to two different groups: <code>DIMENSION</code>, <code>TAG</code>, <code>COST_CATEGORY</code>.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCostCategories`.
    ///
    /// <p>Retrieves an array of Cost Category names and values incurred cost.</p> <note>
    /// <p>If some Cost Category names and values are not associated with any cost, they will not be returned by this API.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCostCategories<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cost_categories_input::Builder,
    }
    impl<C, M, R> GetCostCategories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCostCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCostCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCostCategoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCostCategoriesInputOperationOutputAlias,
                crate::output::GetCostCategoriesOutput,
                crate::error::GetCostCategoriesError,
                crate::input::GetCostCategoriesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The value that you want to search the filter values for.</p>
        /// <p>If you do not specify a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category names that match the <code>SearchString</code> pattern. If you do specifiy a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category values that match the <code>SearchString</code> pattern.</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.search_string(input.into());
            self
        }
        /// <p>The value that you want to search the filter values for.</p>
        /// <p>If you do not specify a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category names that match the <code>SearchString</code> pattern. If you do specifiy a <code>CostCategoryName</code>, <code>SearchString</code> will be used to filter Cost Category values that match the <code>SearchString</code> pattern.</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_search_string(input);
            self
        }
        /// <p>The time period of the request. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The time period of the request. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn cost_category_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cost_category_name(input.into());
            self
        }
        /// <p>The unique name of the Cost Category.</p>
        pub fn set_cost_category_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cost_category_name(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `SortBy`.
        ///
        /// To override the contents of this collection use [`set_sort_by`](Self::set_sort_by).
        ///
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>This field is only used when <code>SortBy</code> is provided in the request.</p>
        /// <p>The maximum number of objects that to be returned for this request. If <code>MaxResults</code> is not specified with <code>SortBy</code>, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetCostCategories</code>, MaxResults has an upper limit of 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>This field is only used when <code>SortBy</code> is provided in the request.</p>
        /// <p>The maximum number of objects that to be returned for this request. If <code>MaxResults</code> is not specified with <code>SortBy</code>, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetCostCategories</code>, MaxResults has an upper limit of 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the prior call in your next request.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the NextPageToken from the prior call in your next request.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCostForecast`.
    ///
    /// <p>Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCostForecast<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cost_forecast_input::Builder,
    }
    impl<C, M, R> GetCostForecast<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCostForecast`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCostForecastOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCostForecastError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCostForecastInputOperationOutputAlias,
                crate::output::GetCostForecastOutput,
                crate::error::GetCostForecastError,
                crate::input::GetCostForecastInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The period of time that you want the forecast to cover. The start date must be equal to or no later than the current date to avoid a validation error.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values for a <code>GetCostForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>AMORTIZED_COST</p> </li>
        /// <li> <p>BLENDED_COST</p> </li>
        /// <li> <p>NET_AMORTIZED_COST</p> </li>
        /// <li> <p>NET_UNBLENDED_COST</p> </li>
        /// <li> <p>UNBLENDED_COST</p> </li>
        /// </ul>
        pub fn metric(mut self, input: crate::model::Metric) -> Self {
            self.inner = self.inner.metric(input);
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast. For more information about blended and unblended rates, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/">Why does the "blended" annotation appear on some line items in my bill?</a>. </p>
        /// <p>Valid values for a <code>GetCostForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>AMORTIZED_COST</p> </li>
        /// <li> <p>BLENDED_COST</p> </li>
        /// <li> <p>NET_AMORTIZED_COST</p> </li>
        /// <li> <p>NET_UNBLENDED_COST</p> </li>
        /// <li> <p>UNBLENDED_COST</p> </li>
        /// </ul>
        pub fn set_metric(mut self, input: std::option::Option<crate::model::Metric>) -> Self {
            self.inner = self.inner.set_metric(input);
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetCostForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetCostForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn prediction_interval_level(mut self, input: i32) -> Self {
            self.inner = self.inner.prediction_interval_level(input);
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn set_prediction_interval_level(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_prediction_interval_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDimensionValues`.
    ///
    /// <p>Retrieves all available filter values for a specified filter over a period of time. You can search the dimension values for an arbitrary string. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDimensionValues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_dimension_values_input::Builder,
    }
    impl<C, M, R> GetDimensionValues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDimensionValues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDimensionValuesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDimensionValuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDimensionValuesInputOperationOutputAlias,
                crate::output::GetDimensionValuesOutput,
                crate::error::GetDimensionValuesError,
                crate::input::GetDimensionValuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The value that you want to search the filter values for.</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.search_string(input.into());
            self
        }
        /// <p>The value that you want to search the filter values for.</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_search_string(input);
            self
        }
        /// <p>The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The start date and end date for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html#awscostmanagement-GetDimensionValues-request-Context">Context</a>. </p>
        pub fn dimension(mut self, input: crate::model::Dimension) -> Self {
            self.inner = self.inner.dimension(input);
            self
        }
        /// <p>The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetDimensionValues.html#awscostmanagement-GetDimensionValues-request-Context">Context</a>. </p>
        pub fn set_dimension(
            mut self,
            input: std::option::Option<crate::model::Dimension>,
        ) -> Self {
            self.inner = self.inner.set_dimension(input);
            self
        }
        /// <p>The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to <code>RESERVATIONS</code>, the resulting dimension values can be used in the <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
        /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>
        /// <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>
        /// <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>
        /// <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>
        /// <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>
        /// <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>
        /// <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>
        /// <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>
        /// </ul>
        pub fn context(mut self, input: crate::model::Context) -> Self {
            self.inner = self.inner.context(input);
            self
        }
        /// <p>The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to <code>RESERVATIONS</code>, the resulting dimension values can be used in the <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
        /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand Instances and Standard Reserved Instances.</p> </li>
        /// <li> <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p> </li>
        /// <li> <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.</p> </li>
        /// <li> <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this operation includes a unit attribute.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p> </li>
        /// <li> <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p> </li>
        /// <li> <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p> </li>
        /// <li> <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p> </li>
        /// <li> <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p> </li>
        /// <li> <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p> </li>
        /// </ul>
        /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li> <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p> </li>
        /// <li> <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p> </li>
        /// <li> <p>REGION - The Amazon Web Services Region.</p> </li>
        /// <li> <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p> </li>
        /// <li> <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value field contains the Amazon Web Services ID of the member account.</p> </li>
        /// <li> <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p> </li>
        /// </ul>
        pub fn set_context(mut self, input: std::option::Option<crate::model::Context>) -> Self {
            self.inner = self.inner.set_context(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `SortBy`.
        ///
        /// To override the contents of this collection use [`set_sort_by`](Self::set_sort_by).
        ///
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When you specify a <code>SortBy</code> paramater, the context must be <code>COST_AND_USAGE</code>. Further, when using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetDimensionValues</code>, MaxResults has an upper limit of 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReservationCoverage`.
    ///
    /// <p>Retrieves the reservation coverage for your account. This enables you to see how much of your Amazon Elastic Compute Cloud, Amazon ElastiCache, Amazon Relational Database Service, or Amazon Redshift usage is covered by a reservation. An organization's management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data about reservation usage by the following dimensions:</p>
    /// <ul>
    /// <li> <p>AZ</p> </li>
    /// <li> <p>CACHE_ENGINE</p> </li>
    /// <li> <p>DATABASE_ENGINE</p> </li>
    /// <li> <p>DEPLOYMENT_OPTION</p> </li>
    /// <li> <p>INSTANCE_TYPE</p> </li>
    /// <li> <p>LINKED_ACCOUNT</p> </li>
    /// <li> <p>OPERATING_SYSTEM</p> </li>
    /// <li> <p>PLATFORM</p> </li>
    /// <li> <p>REGION</p> </li>
    /// <li> <p>SERVICE</p> </li>
    /// <li> <p>TAG</p> </li>
    /// <li> <p>TENANCY</p> </li>
    /// </ul>
    /// <p>To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReservationCoverage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_reservation_coverage_input::Builder,
    }
    impl<C, M, R> GetReservationCoverage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReservationCoverage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReservationCoverageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReservationCoverageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReservationCoverageInputOperationOutputAlias,
                crate::output::GetReservationCoverageOutput,
                crate::error::GetReservationCoverageError,
                crate::input::GetReservationCoverageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The start and end dates of the period that you want to retrieve data about reservation coverage for. You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// Appends an item to `GroupBy`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group the data by the following attributes:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>You can group the data by the following attributes:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code> and <code>DAILY</code>.</p>
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code> and <code>DAILY</code>.</p>
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>TAG</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only one level deep.</p>
        /// <p>If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.</p>
        /// <p>Cost category is also supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DATABASE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>TAG</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only one level deep.</p>
        /// <p>If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.</p>
        /// <p>Cost category is also supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `Metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The measurement that you want your reservation coverage reported in.</p>
        /// <p>Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a request.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metrics(input.into());
            self
        }
        /// <p>The measurement that you want your reservation coverage reported in.</p>
        /// <p>Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a request.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_metrics(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoverageHoursPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandHours</code> </p> </li>
        /// <li> <p> <code>ReservedHours</code> </p> </li>
        /// <li> <p> <code>TotalRunningHours</code> </p> </li>
        /// <li> <p> <code>CoverageNormalizedUnitsPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>ReservedNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>TotalRunningNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>Time</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoverageHoursPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandHours</code> </p> </li>
        /// <li> <p> <code>ReservedHours</code> </p> </li>
        /// <li> <p> <code>TotalRunningHours</code> </p> </li>
        /// <li> <p> <code>CoverageNormalizedUnitsPercentage</code> </p> </li>
        /// <li> <p> <code>OnDemandNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>ReservedNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>TotalRunningNormalizedUnits</code> </p> </li>
        /// <li> <p> <code>Time</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReservationPurchaseRecommendation`.
    ///
    /// <p>Gets recommendations for which reservations to purchase. These recommendations could help you reduce your costs. Reservations provide a discounted hourly rate (up to 75%) compared to On-Demand pricing.</p>
    /// <p>Amazon Web Services generates your recommendations by identifying your On-Demand usage during a specific time period and collecting your usage into categories that are eligible for a reservation. After Amazon Web Services has these categories, it simulates every combination of reservations in each category of usage to identify the best number of each type of RI to purchase to maximize your estimated savings. </p>
    /// <p>For example, Amazon Web Services automatically aggregates your Amazon EC2 Linux, shared tenancy, and c4 family usage in the US West (Oregon) Region and recommends that you buy size-flexible regional reservations to apply to the c4 family usage. Amazon Web Services recommends the smallest size instance in an instance family. This makes it easier to purchase a size-flexible RI. Amazon Web Services also shows the equal number of normalized units so that you can purchase any instance size that you want. For this example, your RI recommendation would be for <code>c4.large</code> because that is the smallest size instance in the c4 instance family.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReservationPurchaseRecommendation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_reservation_purchase_recommendation_input::Builder,
    }
    impl<C, M, R> GetReservationPurchaseRecommendation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReservationPurchaseRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReservationPurchaseRecommendationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetReservationPurchaseRecommendationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReservationPurchaseRecommendationInputOperationOutputAlias,
                crate::output::GetReservationPurchaseRecommendationOutput,
                crate::error::GetReservationPurchaseRecommendationError,
                crate::input::GetReservationPurchaseRecommendationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The account ID that is associated with the recommendation. </p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The account ID that is associated with the recommendation. </p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The specific service that you want recommendations for.</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The specific service that you want recommendations for.</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn account_scope(mut self, input: crate::model::AccountScope) -> Self {
            self.inner = self.inner.account_scope(input);
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn set_account_scope(
            mut self,
            input: std::option::Option<crate::model::AccountScope>,
        ) -> Self {
            self.inner = self.inner.set_account_scope(input);
            self
        }
        /// <p>The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.</p>
        pub fn lookback_period_in_days(
            mut self,
            input: crate::model::LookbackPeriodInDays,
        ) -> Self {
            self.inner = self.inner.lookback_period_in_days(input);
            self
        }
        /// <p>The number of previous days that you want Amazon Web Services to consider when it calculates your recommendations.</p>
        pub fn set_lookback_period_in_days(
            mut self,
            input: std::option::Option<crate::model::LookbackPeriodInDays>,
        ) -> Self {
            self.inner = self.inner.set_lookback_period_in_days(input);
            self
        }
        /// <p>The reservation term that you want recommendations for.</p>
        pub fn term_in_years(mut self, input: crate::model::TermInYears) -> Self {
            self.inner = self.inner.term_in_years(input);
            self
        }
        /// <p>The reservation term that you want recommendations for.</p>
        pub fn set_term_in_years(
            mut self,
            input: std::option::Option<crate::model::TermInYears>,
        ) -> Self {
            self.inner = self.inner.set_term_in_years(input);
            self
        }
        /// <p>The reservation purchase option that you want recommendations for.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.inner = self.inner.payment_option(input);
            self
        }
        /// <p>The reservation purchase option that you want recommendations for.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.inner = self.inner.set_payment_option(input);
            self
        }
        /// <p>The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.</p>
        pub fn service_specification(mut self, input: crate::model::ServiceSpecification) -> Self {
            self.inner = self.inner.service_specification(input);
            self
        }
        /// <p>The hardware specifications for the service instances that you want recommendations for, such as standard or convertible Amazon EC2 instances.</p>
        pub fn set_service_specification(
            mut self,
            input: std::option::Option<crate::model::ServiceSpecification>,
        ) -> Self {
            self.inner = self.inner.set_service_specification(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReservationUtilization`.
    ///
    /// <p>Retrieves the reservation utilization for your account. Management account in an organization have access to member accounts. You can filter data by dimensions in a time period. You can use <code>GetDimensionValues</code> to determine the possible dimension values. Currently, you can group only by <code>SUBSCRIPTION_ID</code>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReservationUtilization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_reservation_utilization_input::Builder,
    }
    impl<C, M, R> GetReservationUtilization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReservationUtilization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReservationUtilizationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReservationUtilizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReservationUtilizationInputOperationOutputAlias,
                crate::output::GetReservationUtilizationOutput,
                crate::error::GetReservationUtilizationError,
                crate::input::GetReservationUtilizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Sets the start and end dates for retrieving RI utilization. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>Sets the start and end dates for retrieving RI utilization. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// Appends an item to `GroupBy`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>Groups only by <code>SUBSCRIPTION_ID</code>. Metadata is included.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>Groups only by <code>SUBSCRIPTION_ID</code>. Metadata is included.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>. If both <code>GroupBy</code> and <code>Granularity</code> aren't set, <code>GetReservationUtilization</code> defaults to <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>. If both <code>GroupBy</code> and <code>Granularity</code> aren't set, <code>GetReservationUtilization</code> defaults to <code>DAILY</code>.</p>
        /// <p>The <code>GetReservationUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>SCOPE</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension, and nesting is supported up to only one level deep.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters utilization data by dimensions. You can filter by the following dimensions:</p>
        /// <ul>
        /// <li> <p>AZ</p> </li>
        /// <li> <p>CACHE_ENGINE</p> </li>
        /// <li> <p>DEPLOYMENT_OPTION</p> </li>
        /// <li> <p>INSTANCE_TYPE</p> </li>
        /// <li> <p>LINKED_ACCOUNT</p> </li>
        /// <li> <p>OPERATING_SYSTEM</p> </li>
        /// <li> <p>PLATFORM</p> </li>
        /// <li> <p>REGION</p> </li>
        /// <li> <p>SERVICE</p> </li>
        /// <li> <p>SCOPE</p> </li>
        /// <li> <p>TENANCY</p> </li>
        /// </ul>
        /// <p> <code>GetReservationUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension, and nesting is supported up to only one level deep.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>UtilizationPercentageInUnits</code> </p> </li>
        /// <li> <p> <code>PurchasedHours</code> </p> </li>
        /// <li> <p> <code>PurchasedUnits</code> </p> </li>
        /// <li> <p> <code>TotalActualHours</code> </p> </li>
        /// <li> <p> <code>TotalActualUnits</code> </p> </li>
        /// <li> <p> <code>UnusedHours</code> </p> </li>
        /// <li> <p> <code>UnusedUnits</code> </p> </li>
        /// <li> <p> <code>OnDemandCostOfRIHoursUsed</code> </p> </li>
        /// <li> <p> <code>NetRISavings</code> </p> </li>
        /// <li> <p> <code>TotalPotentialRISavings</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontFee</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringFee</code> </p> </li>
        /// <li> <p> <code>TotalAmortizedFee</code> </p> </li>
        /// <li> <p> <code>RICostForUnusedHours</code> </p> </li>
        /// <li> <p> <code>RealizedSavings</code> </p> </li>
        /// <li> <p> <code>UnrealizedSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>UtilizationPercentageInUnits</code> </p> </li>
        /// <li> <p> <code>PurchasedHours</code> </p> </li>
        /// <li> <p> <code>PurchasedUnits</code> </p> </li>
        /// <li> <p> <code>TotalActualHours</code> </p> </li>
        /// <li> <p> <code>TotalActualUnits</code> </p> </li>
        /// <li> <p> <code>UnusedHours</code> </p> </li>
        /// <li> <p> <code>UnusedUnits</code> </p> </li>
        /// <li> <p> <code>OnDemandCostOfRIHoursUsed</code> </p> </li>
        /// <li> <p> <code>NetRISavings</code> </p> </li>
        /// <li> <p> <code>TotalPotentialRISavings</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontFee</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringFee</code> </p> </li>
        /// <li> <p> <code>TotalAmortizedFee</code> </p> </li>
        /// <li> <p> <code>RICostForUnusedHours</code> </p> </li>
        /// <li> <p> <code>RealizedSavings</code> </p> </li>
        /// <li> <p> <code>UnrealizedSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of objects that you returned for this request. If more objects are available, in the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of objects.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetRightsizingRecommendation`.
    ///
    /// <p>Creates recommendations that help you save cost by identifying idle and underutilized Amazon EC2 instances.</p>
    /// <p>Recommendations are generated to either downsize or terminate instances, along with providing savings detail and metrics. For details on calculation and function, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-rightsizing.html">Optimizing Your Cost with Rightsizing Recommendations</a> in the <i>Billing and Cost Management User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetRightsizingRecommendation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_rightsizing_recommendation_input::Builder,
    }
    impl<C, M, R> GetRightsizingRecommendation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetRightsizingRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetRightsizingRecommendationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetRightsizingRecommendationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetRightsizingRecommendationInputOperationOutputAlias,
                crate::output::GetRightsizingRecommendationOutput,
                crate::error::GetRightsizingRecommendationError,
                crate::input::GetRightsizingRecommendationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
        pub fn configuration(
            mut self,
            input: crate::model::RightsizingRecommendationConfiguration,
        ) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p> Enables you to customize recommendations across two attributes. You can choose to view recommendations for instances within the same instance families or across different instance families. You can also choose to view your estimated savings associated with recommendations with consideration of existing Savings Plans or RI benefits, or neither. </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::RightsizingRecommendationConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>The specific service that you want recommendations for. The only valid value for <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".</p>
        pub fn service(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.service(input.into());
            self
        }
        /// <p>The specific service that you want recommendations for. The only valid value for <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".</p>
        pub fn set_service(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_service(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results that you want to retrieve.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSavingsPlansCoverage`.
    ///
    /// <p>Retrieves the Savings Plans covered for your account. This enables you to see how much of your cost is covered by a Savings Plan. An organization’s management account can see the coverage of the associated member accounts. This supports dimensions, Cost Categories, and nested expressions. For any time period, you can filter data for Savings Plans usage with the following dimensions:</p>
    /// <ul>
    /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
    /// <li> <p> <code>REGION</code> </p> </li>
    /// <li> <p> <code>SERVICE</code> </p> </li>
    /// <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>
    /// </ul> <note>
    /// <p> <code>GetSavingsPlansCoverage</code> doesn't support filtering by tags. <code>GetSavingsPlansCoverage</code> also doesn't support the <code>OR</code> operator between filter dimensions. For the full request syntax with supported parameters, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansCoverage.html#API_GetSavingsPlansCoverage_Examples">Examples</a>.</p>
    /// </note>
    /// <p>To determine valid values for a dimension, use the <code>GetDimensionValues</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSavingsPlansCoverage<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_savings_plans_coverage_input::Builder,
    }
    impl<C, M, R> GetSavingsPlansCoverage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSavingsPlansCoverage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSavingsPlansCoverageOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSavingsPlansCoverageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSavingsPlansCoverageInputOperationOutputAlias,
                crate::output::GetSavingsPlansCoverageOutput,
                crate::error::GetSavingsPlansCoverageError,
                crate::input::GetSavingsPlansCoverageInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSavingsPlansCoveragePaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetSavingsPlansCoveragePaginator<C, M, R> {
            crate::paginator::GetSavingsPlansCoveragePaginator::new(self.handle, self.inner)
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// Appends an item to `GroupBy`.
        ///
        /// To override the contents of this collection use [`set_group_by`](Self::set_group_by).
        ///
        /// <p>You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or <code>SERVICE</code>.</p>
        pub fn group_by(mut self, input: crate::model::GroupDefinition) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>You can group the data using the attributes <code>INSTANCE_FAMILY</code>, <code>REGION</code>, or <code>SERVICE</code>.</p>
        pub fn set_group_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be set if <code>GroupBy</code> is set.</p>
        /// <p>The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services cost data for your Savings Plans. <code>Granularity</code> can't be set if <code>GroupBy</code> is set.</p>
        /// <p>The <code>GetSavingsPlansCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Cost category is supported. Tags are not supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters Savings Plans coverage data by dimensions. You can filter data for Savings Plans usage with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansCoverage</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Cost category is supported. Tags are not supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `Metrics`.
        ///
        /// To override the contents of this collection use [`set_metrics`](Self::set_metrics).
        ///
        /// <p>The measurement that you want your Savings Plans coverage reported in. The only valid value is <code>SpendCoveredBySavingsPlans</code>.</p>
        pub fn metrics(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.metrics(input.into());
            self
        }
        /// <p>The measurement that you want your Savings Plans coverage reported in. The only valid value is <code>SpendCoveredBySavingsPlans</code>.</p>
        pub fn set_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_metrics(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>SpendCoveredBySavingsPlan</code> </p> </li>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoveragePercentage</code> </p> </li>
        /// <li> <p> <code>TotalCost</code> </p> </li>
        /// <li> <p> <code>InstanceFamily</code> </p> </li>
        /// <li> <p> <code>Region</code> </p> </li>
        /// <li> <p> <code>Service</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>SpendCoveredBySavingsPlan</code> </p> </li>
        /// <li> <p> <code>OnDemandCost</code> </p> </li>
        /// <li> <p> <code>CoveragePercentage</code> </p> </li>
        /// <li> <p> <code>TotalCost</code> </p> </li>
        /// <li> <p> <code>InstanceFamily</code> </p> </li>
        /// <li> <p> <code>Region</code> </p> </li>
        /// <li> <p> <code>Service</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSavingsPlansPurchaseRecommendation`.
    ///
    /// <p>Retrieves your request parameters, Savings Plan Recommendations Summary and Details. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSavingsPlansPurchaseRecommendation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_savings_plans_purchase_recommendation_input::Builder,
    }
    impl<C, M, R> GetSavingsPlansPurchaseRecommendation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSavingsPlansPurchaseRecommendation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSavingsPlansPurchaseRecommendationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetSavingsPlansPurchaseRecommendationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSavingsPlansPurchaseRecommendationInputOperationOutputAlias,
                crate::output::GetSavingsPlansPurchaseRecommendationOutput,
                crate::error::GetSavingsPlansPurchaseRecommendationError,
                crate::input::GetSavingsPlansPurchaseRecommendationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Savings Plans recommendation type requested.</p>
        pub fn savings_plans_type(
            mut self,
            input: crate::model::SupportedSavingsPlansType,
        ) -> Self {
            self.inner = self.inner.savings_plans_type(input);
            self
        }
        /// <p>The Savings Plans recommendation type requested.</p>
        pub fn set_savings_plans_type(
            mut self,
            input: std::option::Option<crate::model::SupportedSavingsPlansType>,
        ) -> Self {
            self.inner = self.inner.set_savings_plans_type(input);
            self
        }
        /// <p>The savings plan recommendation term used to generate these recommendations.</p>
        pub fn term_in_years(mut self, input: crate::model::TermInYears) -> Self {
            self.inner = self.inner.term_in_years(input);
            self
        }
        /// <p>The savings plan recommendation term used to generate these recommendations.</p>
        pub fn set_term_in_years(
            mut self,
            input: std::option::Option<crate::model::TermInYears>,
        ) -> Self {
            self.inner = self.inner.set_term_in_years(input);
            self
        }
        /// <p>The payment option used to generate these recommendations.</p>
        pub fn payment_option(mut self, input: crate::model::PaymentOption) -> Self {
            self.inner = self.inner.payment_option(input);
            self
        }
        /// <p>The payment option used to generate these recommendations.</p>
        pub fn set_payment_option(
            mut self,
            input: std::option::Option<crate::model::PaymentOption>,
        ) -> Self {
            self.inner = self.inner.set_payment_option(input);
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn account_scope(mut self, input: crate::model::AccountScope) -> Self {
            self.inner = self.inner.account_scope(input);
            self
        }
        /// <p>The account scope that you want your recommendations for. Amazon Web Services calculates recommendations including the management account and member accounts if the value is set to <code>PAYER</code>. If the value is <code>LINKED</code>, recommendations are calculated for individual member accounts only.</p>
        pub fn set_account_scope(
            mut self,
            input: std::option::Option<crate::model::AccountScope>,
        ) -> Self {
            self.inner = self.inner.set_account_scope(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn page_size(mut self, input: i32) -> Self {
            self.inner = self.inner.page_size(input);
            self
        }
        /// <p>The number of recommendations that you want returned in a single response object.</p>
        pub fn set_page_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_page_size(input);
            self
        }
        /// <p>The lookback period used to generate the recommendation.</p>
        pub fn lookback_period_in_days(
            mut self,
            input: crate::model::LookbackPeriodInDays,
        ) -> Self {
            self.inner = self.inner.lookback_period_in_days(input);
            self
        }
        /// <p>The lookback period used to generate the recommendation.</p>
        pub fn set_lookback_period_in_days(
            mut self,
            input: std::option::Option<crate::model::LookbackPeriodInDays>,
        ) -> Self {
            self.inner = self.inner.set_lookback_period_in_days(input);
            self
        }
        /// <p>You can filter your recommendations by Account ID with the <code>LINKED_ACCOUNT</code> dimension. To filter your recommendations by Account ID, specify <code>Key</code> as <code>LINKED_ACCOUNT</code> and <code>Value</code> as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations.</p>
        /// <p>For GetSavingsPlansPurchaseRecommendation, the <code>Filter</code> does not include <code>CostCategories</code> or <code>Tags</code>. It only includes <code>Dimensions</code>. With <code>Dimensions</code>, <code>Key</code> must be <code>LINKED_ACCOUNT</code> and <code>Value</code> can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. <code>AND</code> and <code>OR</code> operators are not supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>You can filter your recommendations by Account ID with the <code>LINKED_ACCOUNT</code> dimension. To filter your recommendations by Account ID, specify <code>Key</code> as <code>LINKED_ACCOUNT</code> and <code>Value</code> as the comma-separated Acount ID(s) for which you want to see Savings Plans purchase recommendations.</p>
        /// <p>For GetSavingsPlansPurchaseRecommendation, the <code>Filter</code> does not include <code>CostCategories</code> or <code>Tags</code>. It only includes <code>Dimensions</code>. With <code>Dimensions</code>, <code>Key</code> must be <code>LINKED_ACCOUNT</code> and <code>Value</code> can be a single Account ID or multiple comma-separated Account IDs for which you want to see Savings Plans Purchase Recommendations. <code>AND</code> and <code>OR</code> operators are not supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSavingsPlansUtilization`.
    ///
    /// <p>Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity. Management account in an organization have access to member accounts. You can use <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.</p> <note>
    /// <p>You cannot group by any dimension values for <code>GetSavingsPlansUtilization</code>.</p>
    /// <p> <code>GetSavingsPlansUtilization</code> doesn't support filtering by tags. <code>GetSavingsPlansUtilization</code> also doesn't support the <code>OR</code> operator between filter dimensions. For the full request syntax with supported parameters, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilization.html#API_GetSavingsPlansUtilization_Examples">Examples</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSavingsPlansUtilization<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_savings_plans_utilization_input::Builder,
    }
    impl<C, M, R> GetSavingsPlansUtilization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSavingsPlansUtilization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSavingsPlansUtilizationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSavingsPlansUtilizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSavingsPlansUtilizationInputOperationOutputAlias,
                crate::output::GetSavingsPlansUtilizationOutput,
                crate::error::GetSavingsPlansUtilizationError,
                crate::input::GetSavingsPlansUtilizationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
        /// <p>The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>The granularity of the Amazon Web Services utillization data for your Savings Plans.</p>
        /// <p>The <code>GetSavingsPlansUtilization</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLANS_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLANS_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilization</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetSavingsPlansUtilizationDetails`.
    ///
    /// <p>Retrieves attribute data along with aggregate utilization and savings data for a given time period. This doesn't support granular or grouped data (daily/monthly) in response. You can't retrieve data by dates in a single response similar to <code>GetSavingsPlanUtilization</code>, but you have the option to make multiple calls to <code>GetSavingsPlanUtilizationDetails</code> by providing individual dates. You can use <code>GetDimensionValues</code> in <code>SAVINGS_PLANS</code> to determine the possible dimension values.</p> <note>
    /// <p> <code>GetSavingsPlanUtilizationDetails</code> internally groups data by <code>SavingsPlansArn</code>.</p>
    /// <p> <code>GetSavingsPlansUtilizationDetails</code> doesn't support filtering by tags. <code>GetSavingsPlansUtilizationDetails</code> also doesn't support the <code>OR</code> operator between filter dimensions. For the full request syntax with supported parameters, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_GetSavingsPlansUtilizationDetails.html#API_GetSavingsPlansUtilizationDetails_Examples">Examples</a>.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetSavingsPlansUtilizationDetails<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_savings_plans_utilization_details_input::Builder,
    }
    impl<C, M, R> GetSavingsPlansUtilizationDetails<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetSavingsPlansUtilizationDetails`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetSavingsPlansUtilizationDetailsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetSavingsPlansUtilizationDetailsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetSavingsPlansUtilizationDetailsInputOperationOutputAlias,
                crate::output::GetSavingsPlansUtilizationDetailsOutput,
                crate::error::GetSavingsPlansUtilizationDetailsError,
                crate::input::GetSavingsPlansUtilizationDetailsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetSavingsPlansUtilizationDetailsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetSavingsPlansUtilizationDetailsPaginator<C, M, R> {
            crate::paginator::GetSavingsPlansUtilizationDetailsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The time period that you want the usage and costs for. The <code>Start</code> date must be within 13 months. The <code>End</code> date must be after the <code>Start</code> date, and before the current date. Future dates can't be used as an <code>End</code> date.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilizationDetails</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Filters Savings Plans utilization coverage data for active Savings Plans dimensions. You can filter data with the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>PAYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// </ul>
        /// <p> <code>GetSavingsPlansUtilizationDetails</code> uses the same <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a> object as the other operations, but only <code>AND</code> is supported among each dimension.</p>
        /// <p>Filtering by tags isn't supported.</p>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `DataType`.
        ///
        /// To override the contents of this collection use [`set_data_type`](Self::set_data_type).
        ///
        /// <p>The data type.</p>
        pub fn data_type(mut self, input: crate::model::SavingsPlansDataType) -> Self {
            self.inner = self.inner.data_type(input);
            self
        }
        /// <p>The data type.</p>
        pub fn set_data_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlansDataType>>,
        ) -> Self {
            self.inner = self.inner.set_data_type(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The number of items to be returned in a response. The default is <code>20</code>, with a minimum value of <code>1</code>.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringCommitment</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontCommitment</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The following values are supported for <code>Key</code>:</p>
        /// <ul>
        /// <li> <p> <code>UtilizationPercentage</code> </p> </li>
        /// <li> <p> <code>TotalCommitment</code> </p> </li>
        /// <li> <p> <code>UsedCommitment</code> </p> </li>
        /// <li> <p> <code>UnusedCommitment</code> </p> </li>
        /// <li> <p> <code>NetSavings</code> </p> </li>
        /// <li> <p> <code>AmortizedRecurringCommitment</code> </p> </li>
        /// <li> <p> <code>AmortizedUpfrontCommitment</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::SortDefinition>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTags`.
    ///
    /// <p>Queries for available tag keys and tag values for a specified period. You can search the tag values for an arbitrary string. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetTags<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_tags_input::Builder,
    }
    impl<C, M, R> GetTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTagsInputOperationOutputAlias,
                crate::output::GetTagsOutput,
                crate::error::GetTagsError,
                crate::input::GetTagsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The value that you want to search for.</p>
        pub fn search_string(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.search_string(input.into());
            self
        }
        /// <p>The value that you want to search for.</p>
        pub fn set_search_string(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_search_string(input);
            self
        }
        /// <p>The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>The key of the tag that you want to return values for.</p>
        pub fn tag_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_key(input.into());
            self
        }
        /// <p>The key of the tag that you want to return values for.</p>
        pub fn set_tag_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_tag_key(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>Use <code>Expression</code> to filter by cost or by usage. There are two patterns: </p>
        /// <ul>
        /// <li> <p>Simple dimension values - You can set the dimension name and values for the filters that you plan to use. For example, you can filter for <code>REGION==us-east-1 OR REGION==us-west-1</code>. For <code>GetRightsizingRecommendation</code>, the Region is a full name (for example, <code>REGION==US East (N. Virginia)</code>. The <code>Expression</code> example is as follows:</p> <p> <code>{ "Dimensions": { "Key": "REGION", "Values": [ "us-east-1", “us-west-1” ] } }</code> </p> <p>The list of dimension values are OR'd together to retrieve cost or usage data. You can create <code>Expression</code> and <code>DimensionValues</code> objects using either <code>with*</code> methods or <code>set*</code> methods in multiple lines. </p> </li>
        /// <li> <p>Compound dimension values with logical operations - You can use multiple <code>Expression</code> types and the logical operators <code>AND/OR/NOT</code> to create a list of one or more <code>Expression</code> objects. By doing this, you can filter on more advanced options. For example, you can filter on <code>((REGION == us-east-1 OR REGION == us-west-1) OR (TAG.Type == Type1)) AND (USAGE_TYPE != DataTransfer)</code>. The <code>Expression</code> for that is as follows:</p> <p> <code>{ "And": [ {"Or": [ {"Dimensions": { "Key": "REGION", "Values": [ "us-east-1", "us-west-1" ] }}, {"Tags": { "Key": "TagName", "Values": ["Value1"] } } ]}, {"Not": {"Dimensions": { "Key": "USAGE_TYPE", "Values": ["DataTransfer"] }}} ] } </code> </p> <note>
        /// <p>Because each <code>Expression</code> can have only one operator, the service returns an error if more than one is specified. The following example shows an <code>Expression</code> object that creates an error.</p>
        /// </note> <p> <code> { "And": [ ... ], "DimensionValues": { "Dimension": "USAGE_TYPE", "Values": [ "DataTransfer" ] } } </code> </p> </li>
        /// </ul> <note>
        /// <p>For the <code>GetRightsizingRecommendation</code> action, a combination of OR and NOT isn't supported. OR isn't supported between different dimensions, or dimensions and tags. NOT operators aren't supported. Dimensions are also limited to <code>LINKED_ACCOUNT</code>, <code>REGION</code>, or <code>RIGHTSIZING_TYPE</code>.</p>
        /// <p>For the <code>GetReservationPurchaseRecommendation</code> action, only NOT is supported. AND and OR aren't supported. Dimensions are limited to <code>LINKED_ACCOUNT</code>.</p>
        /// </note>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// Appends an item to `SortBy`.
        ///
        /// To override the contents of this collection use [`set_sort_by`](Self::set_sort_by).
        ///
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn sort_by(mut self, input: crate::model::SortDefinition) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The value by which you want to sort the data.</p>
        /// <p>The key represents cost and usage metrics. The following values are supported:</p>
        /// <ul>
        /// <li> <p> <code>BlendedCost</code> </p> </li>
        /// <li> <p> <code>UnblendedCost</code> </p> </li>
        /// <li> <p> <code>AmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetAmortizedCost</code> </p> </li>
        /// <li> <p> <code>NetUnblendedCost</code> </p> </li>
        /// <li> <p> <code>UsageQuantity</code> </p> </li>
        /// <li> <p> <code>NormalizedUsageAmount</code> </p> </li>
        /// </ul>
        /// <p>Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.</p>
        /// <p>When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SortDefinition>>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetTags</code>, MaxResults has an upper limit of 1000.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default value for this parameter.</p>
        /// <p>For <code>GetTags</code>, MaxResults has an upper limit of 1000.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_page_token(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_next_page_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsageForecast`.
    ///
    /// <p>Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period that you select, based on your past usage. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsageForecast<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_forecast_input::Builder,
    }
    impl<C, M, R> GetUsageForecast<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsageForecast`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageForecastOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageForecastError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageForecastInputOperationOutputAlias,
                crate::output::GetUsageForecastOutput,
                crate::error::GetUsageForecastError,
                crate::input::GetUsageForecastInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The start and end dates of the period that you want to retrieve usage forecast for. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. The start date must be equal to or later than the current date to avoid a validation error.</p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.inner = self.inner.time_period(input);
            self
        }
        /// <p>The start and end dates of the period that you want to retrieve usage forecast for. The start date is inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>. The start date must be equal to or later than the current date to avoid a validation error.</p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.inner = self.inner.set_time_period(input);
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast.</p>
        /// <p>Valid values for a <code>GetUsageForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>USAGE_QUANTITY</p> </li>
        /// <li> <p>NORMALIZED_USAGE_AMOUNT</p> </li>
        /// </ul>
        pub fn metric(mut self, input: crate::model::Metric) -> Self {
            self.inner = self.inner.metric(input);
            self
        }
        /// <p>Which metric Cost Explorer uses to create your forecast.</p>
        /// <p>Valid values for a <code>GetUsageForecast</code> call are the following:</p>
        /// <ul>
        /// <li> <p>USAGE_QUANTITY</p> </li>
        /// <li> <p>NORMALIZED_USAGE_AMOUNT</p> </li>
        /// </ul>
        pub fn set_metric(mut self, input: std::option::Option<crate::model::Metric>) -> Self {
            self.inner = self.inner.set_metric(input);
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetUsageForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn granularity(mut self, input: crate::model::Granularity) -> Self {
            self.inner = self.inner.granularity(input);
            self
        }
        /// <p>How granular you want the forecast to be. You can get 3 months of <code>DAILY</code> forecasts or 12 months of <code>MONTHLY</code> forecasts.</p>
        /// <p>The <code>GetUsageForecast</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code> granularities.</p>
        pub fn set_granularity(
            mut self,
            input: std::option::Option<crate::model::Granularity>,
        ) -> Self {
            self.inner = self.inner.set_granularity(input);
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetUsageForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn filter(mut self, input: crate::model::Expression) -> Self {
            self.inner = self.inner.filter(input);
            self
        }
        /// <p>The filters that you want to use to filter your forecast. The <code>GetUsageForecast</code> API supports filtering by the following dimensions:</p>
        /// <ul>
        /// <li> <p> <code>AZ</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT</code> </p> </li>
        /// <li> <p> <code>LINKED_ACCOUNT_NAME</code> </p> </li>
        /// <li> <p> <code>OPERATION</code> </p> </li>
        /// <li> <p> <code>PURCHASE_TYPE</code> </p> </li>
        /// <li> <p> <code>REGION</code> </p> </li>
        /// <li> <p> <code>SERVICE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE</code> </p> </li>
        /// <li> <p> <code>USAGE_TYPE_GROUP</code> </p> </li>
        /// <li> <p> <code>RECORD_TYPE</code> </p> </li>
        /// <li> <p> <code>OPERATING_SYSTEM</code> </p> </li>
        /// <li> <p> <code>TENANCY</code> </p> </li>
        /// <li> <p> <code>SCOPE</code> </p> </li>
        /// <li> <p> <code>PLATFORM</code> </p> </li>
        /// <li> <p> <code>SUBSCRIPTION_ID</code> </p> </li>
        /// <li> <p> <code>LEGAL_ENTITY_NAME</code> </p> </li>
        /// <li> <p> <code>DEPLOYMENT_OPTION</code> </p> </li>
        /// <li> <p> <code>DATABASE_ENGINE</code> </p> </li>
        /// <li> <p> <code>INSTANCE_TYPE_FAMILY</code> </p> </li>
        /// <li> <p> <code>BILLING_ENTITY</code> </p> </li>
        /// <li> <p> <code>RESERVATION_ID</code> </p> </li>
        /// <li> <p> <code>SAVINGS_PLAN_ARN</code> </p> </li>
        /// </ul>
        pub fn set_filter(mut self, input: std::option::Option<crate::model::Expression>) -> Self {
            self.inner = self.inner.set_filter(input);
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn prediction_interval_level(mut self, input: i32) -> Self {
            self.inner = self.inner.prediction_interval_level(input);
            self
        }
        /// <p>Cost Explorer always returns the mean forecast as a single point. You can request a prediction interval around the mean by specifying a confidence level. The higher the confidence level, the more confident Cost Explorer is about the actual value falling in the prediction interval. Higher confidence levels result in wider prediction intervals.</p>
        pub fn set_prediction_interval_level(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_prediction_interval_level(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCostCategoryDefinitions`.
    ///
    /// <p>Returns the name, ARN, <code>NumberOfRules</code> and effective dates of all Cost Categories defined in the account. You have the option to use <code>EffectiveOn</code> to return a list of Cost Categories that were active on a specific date. If there is no <code>EffectiveOn</code> specified, you’ll see Cost Categories that are effective on the current date. If Cost Category is still effective, <code>EffectiveEnd</code> is omitted in the response. <code>ListCostCategoryDefinitions</code> supports pagination. The request can have a <code>MaxResults</code> range up to 100.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCostCategoryDefinitions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_cost_category_definitions_input::Builder,
    }
    impl<C, M, R> ListCostCategoryDefinitions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCostCategoryDefinitions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCostCategoryDefinitionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCostCategoryDefinitionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCostCategoryDefinitionsInputOperationOutputAlias,
                crate::output::ListCostCategoryDefinitionsOutput,
                crate::error::ListCostCategoryDefinitionsError,
                crate::input::ListCostCategoryDefinitionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCostCategoryDefinitionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCostCategoryDefinitionsPaginator<C, M, R> {
            crate::paginator::ListCostCategoryDefinitionsPaginator::new(self.handle, self.inner)
        }
        /// <p> The date when the Cost Category was effective. </p>
        pub fn effective_on(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.effective_on(input.into());
            self
        }
        /// <p> The date when the Cost Category was effective. </p>
        pub fn set_effective_on(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_effective_on(input);
            self
        }
        /// <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The number of entries a paginated response contains. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The number of entries a paginated response contains. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ProvideAnomalyFeedback`.
    ///
    /// <p>Modifies the feedback property of a given cost anomaly. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ProvideAnomalyFeedback<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::provide_anomaly_feedback_input::Builder,
    }
    impl<C, M, R> ProvideAnomalyFeedback<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ProvideAnomalyFeedback`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ProvideAnomalyFeedbackOutput,
            aws_smithy_http::result::SdkError<crate::error::ProvideAnomalyFeedbackError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ProvideAnomalyFeedbackInputOperationOutputAlias,
                crate::output::ProvideAnomalyFeedbackOutput,
                crate::error::ProvideAnomalyFeedbackError,
                crate::input::ProvideAnomalyFeedbackInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A cost anomaly ID. </p>
        pub fn anomaly_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_id(input.into());
            self
        }
        /// <p>A cost anomaly ID. </p>
        pub fn set_anomaly_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_anomaly_id(input);
            self
        }
        /// <p>Describes whether the cost anomaly was a planned activity or you considered it an anomaly. </p>
        pub fn feedback(mut self, input: crate::model::AnomalyFeedbackType) -> Self {
            self.inner = self.inner.feedback(input);
            self
        }
        /// <p>Describes whether the cost anomaly was a planned activity or you considered it an anomaly. </p>
        pub fn set_feedback(
            mut self,
            input: std::option::Option<crate::model::AnomalyFeedbackType>,
        ) -> Self {
            self.inner = self.inner.set_feedback(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnomalyMonitor`.
    ///
    /// <p>Updates an existing cost anomaly monitor. The changes made are applied going forward, and doesn'tt change anomalies detected in the past. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAnomalyMonitor<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_anomaly_monitor_input::Builder,
    }
    impl<C, M, R> UpdateAnomalyMonitor<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnomalyMonitor`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnomalyMonitorOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnomalyMonitorError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnomalyMonitorInputOperationOutputAlias,
                crate::output::UpdateAnomalyMonitorOutput,
                crate::error::UpdateAnomalyMonitorError,
                crate::input::UpdateAnomalyMonitorInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Cost anomaly monitor Amazon Resource Names (ARNs). </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitor_arn(input.into());
            self
        }
        /// <p>Cost anomaly monitor Amazon Resource Names (ARNs). </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_monitor_arn(input);
            self
        }
        /// <p>The new name for the cost anomaly monitor. </p>
        pub fn monitor_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitor_name(input.into());
            self
        }
        /// <p>The new name for the cost anomaly monitor. </p>
        pub fn set_monitor_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_monitor_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAnomalySubscription`.
    ///
    /// <p>Updates an existing cost anomaly monitor subscription. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAnomalySubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_anomaly_subscription_input::Builder,
    }
    impl<C, M, R> UpdateAnomalySubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAnomalySubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAnomalySubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAnomalySubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAnomalySubscriptionInputOperationOutputAlias,
                crate::output::UpdateAnomalySubscriptionOutput,
                crate::error::UpdateAnomalySubscriptionError,
                crate::input::UpdateAnomalySubscriptionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A cost anomaly subscription Amazon Resource Name (ARN). </p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_arn(input.into());
            self
        }
        /// <p>A cost anomaly subscription Amazon Resource Name (ARN). </p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_arn(input);
            self
        }
        /// <p>The update to the threshold value for receiving notifications. </p>
        pub fn threshold(mut self, input: f64) -> Self {
            self.inner = self.inner.threshold(input);
            self
        }
        /// <p>The update to the threshold value for receiving notifications. </p>
        pub fn set_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.inner = self.inner.set_threshold(input);
            self
        }
        /// <p>The update to the frequency value that subscribers receive notifications. </p>
        pub fn frequency(mut self, input: crate::model::AnomalySubscriptionFrequency) -> Self {
            self.inner = self.inner.frequency(input);
            self
        }
        /// <p>The update to the frequency value that subscribers receive notifications. </p>
        pub fn set_frequency(
            mut self,
            input: std::option::Option<crate::model::AnomalySubscriptionFrequency>,
        ) -> Self {
            self.inner = self.inner.set_frequency(input);
            self
        }
        /// Appends an item to `MonitorArnList`.
        ///
        /// To override the contents of this collection use [`set_monitor_arn_list`](Self::set_monitor_arn_list).
        ///
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn monitor_arn_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitor_arn_list(input.into());
            self
        }
        /// <p>A list of cost anomaly monitor ARNs. </p>
        pub fn set_monitor_arn_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_monitor_arn_list(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// <p>The update to the subscriber list. </p>
        pub fn subscribers(mut self, input: crate::model::Subscriber) -> Self {
            self.inner = self.inner.subscribers(input);
            self
        }
        /// <p>The update to the subscriber list. </p>
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subscriber>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
        /// <p>The new name of the subscription. </p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The new name of the subscription. </p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateCostCategoryDefinition`.
    ///
    /// <p>Updates an existing Cost Category. Changes made to the Cost Category rules will be used to categorize the current month’s expenses and future expenses. This won’t change categorization for the previous months.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateCostCategoryDefinition<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_cost_category_definition_input::Builder,
    }
    impl<C, M, R> UpdateCostCategoryDefinition<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateCostCategoryDefinition`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateCostCategoryDefinitionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateCostCategoryDefinitionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateCostCategoryDefinitionInputOperationOutputAlias,
                crate::output::UpdateCostCategoryDefinitionOutput,
                crate::error::UpdateCostCategoryDefinitionError,
                crate::input::UpdateCostCategoryDefinitionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for your Cost Category.</p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cost_category_arn(input.into());
            self
        }
        /// <p>The unique identifier for your Cost Category.</p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cost_category_arn(input);
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn rule_version(mut self, input: crate::model::CostCategoryRuleVersion) -> Self {
            self.inner = self.inner.rule_version(input);
            self
        }
        /// <p>The rule schema version in this particular Cost Category.</p>
        pub fn set_rule_version(
            mut self,
            input: std::option::Option<crate::model::CostCategoryRuleVersion>,
        ) -> Self {
            self.inner = self.inner.set_rule_version(input);
            self
        }
        /// Appends an item to `Rules`.
        ///
        /// To override the contents of this collection use [`set_rules`](Self::set_rules).
        ///
        /// <p>The <code>Expression</code> object used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule </a>. </p>
        pub fn rules(mut self, input: crate::model::CostCategoryRule) -> Self {
            self.inner = self.inner.rules(input);
            self
        }
        /// <p>The <code>Expression</code> object used to categorize costs. For more information, see <a href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_CostCategoryRule.html">CostCategoryRule </a>. </p>
        pub fn set_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryRule>>,
        ) -> Self {
            self.inner = self.inner.set_rules(input);
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_value(input.into());
            self
        }
        /// <p>The default value for the cost category.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_value(input);
            self
        }
        /// Appends an item to `SplitChargeRules`.
        ///
        /// To override the contents of this collection use [`set_split_charge_rules`](Self::set_split_charge_rules).
        ///
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn split_charge_rules(
            mut self,
            input: crate::model::CostCategorySplitChargeRule,
        ) -> Self {
            self.inner = self.inner.split_charge_rules(input);
            self
        }
        /// <p> The split charge rules used to allocate your charges between your Cost Category values. </p>
        pub fn set_split_charge_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategorySplitChargeRule>>,
        ) -> Self {
            self.inner = self.inner.set_split_charge_rules(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
