// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateAnomalyMonitor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAnomalyMonitorError {
    /// Kind of error that occurred.
    pub kind: CreateAnomalyMonitorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAnomalyMonitor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAnomalyMonitorErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAnomalyMonitorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAnomalyMonitorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAnomalyMonitorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAnomalyMonitorError {
    fn code(&self) -> Option<&str> {
        CreateAnomalyMonitorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAnomalyMonitorError {
    /// Creates a new `CreateAnomalyMonitorError`.
    pub fn new(kind: CreateAnomalyMonitorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAnomalyMonitorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAnomalyMonitorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAnomalyMonitorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAnomalyMonitorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAnomalyMonitorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalyMonitorErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for CreateAnomalyMonitorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAnomalyMonitorErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAnomalyMonitorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAnomalySubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAnomalySubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateAnomalySubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAnomalySubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAnomalySubscriptionErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The cost anomaly monitor does not exist for the account. </p>
    UnknownMonitorException(crate::error::UnknownMonitorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAnomalySubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAnomalySubscriptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAnomalySubscriptionErrorKind::UnknownMonitorException(_inner) => _inner.fmt(f),
            CreateAnomalySubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAnomalySubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateAnomalySubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAnomalySubscriptionError {
    /// Creates a new `CreateAnomalySubscriptionError`.
    pub fn new(kind: CreateAnomalySubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAnomalySubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAnomalySubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAnomalySubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAnomalySubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAnomalySubscriptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalySubscriptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAnomalySubscriptionErrorKind::UnknownMonitorException`.
    pub fn is_unknown_monitor_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAnomalySubscriptionErrorKind::UnknownMonitorException(_)
        )
    }
}
impl std::error::Error for CreateAnomalySubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAnomalySubscriptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAnomalySubscriptionErrorKind::UnknownMonitorException(_inner) => Some(_inner),
            CreateAnomalySubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCostCategoryDefinitionError {
    /// Kind of error that occurred.
    pub kind: CreateCostCategoryDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCostCategoryDefinitionErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> You've reached the limit on the number of resources you can create, or exceeded the size of an individual resource. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCostCategoryDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateCostCategoryDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCostCategoryDefinitionError {
    fn code(&self) -> Option<&str> {
        CreateCostCategoryDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCostCategoryDefinitionError {
    /// Creates a new `CreateCostCategoryDefinitionError`.
    pub fn new(kind: CreateCostCategoryDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCostCategoryDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCostCategoryDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCostCategoryDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCostCategoryDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCostCategoryDefinitionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCostCategoryDefinitionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(_)
        )
    }
}
impl std::error::Error for CreateCostCategoryDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateCostCategoryDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAnomalyMonitor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAnomalyMonitorError {
    /// Kind of error that occurred.
    pub kind: DeleteAnomalyMonitorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAnomalyMonitor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAnomalyMonitorErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The cost anomaly monitor does not exist for the account. </p>
    UnknownMonitorException(crate::error::UnknownMonitorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAnomalyMonitorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAnomalyMonitorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteAnomalyMonitorErrorKind::UnknownMonitorException(_inner) => _inner.fmt(f),
            DeleteAnomalyMonitorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAnomalyMonitorError {
    fn code(&self) -> Option<&str> {
        DeleteAnomalyMonitorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAnomalyMonitorError {
    /// Creates a new `DeleteAnomalyMonitorError`.
    pub fn new(kind: DeleteAnomalyMonitorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAnomalyMonitorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAnomalyMonitorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAnomalyMonitorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAnomalyMonitorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAnomalyMonitorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyMonitorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalyMonitorErrorKind::UnknownMonitorException`.
    pub fn is_unknown_monitor_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalyMonitorErrorKind::UnknownMonitorException(_)
        )
    }
}
impl std::error::Error for DeleteAnomalyMonitorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAnomalyMonitorErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteAnomalyMonitorErrorKind::UnknownMonitorException(_inner) => Some(_inner),
            DeleteAnomalyMonitorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAnomalySubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAnomalySubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteAnomalySubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAnomalySubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAnomalySubscriptionErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The cost anomaly subscription does not exist for the account. </p>
    UnknownSubscriptionException(crate::error::UnknownSubscriptionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAnomalySubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAnomalySubscriptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteAnomalySubscriptionErrorKind::UnknownSubscriptionException(_inner) => {
                _inner.fmt(f)
            }
            DeleteAnomalySubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAnomalySubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteAnomalySubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAnomalySubscriptionError {
    /// Creates a new `DeleteAnomalySubscriptionError`.
    pub fn new(kind: DeleteAnomalySubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAnomalySubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAnomalySubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAnomalySubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAnomalySubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAnomalySubscriptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalySubscriptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAnomalySubscriptionErrorKind::UnknownSubscriptionException`.
    pub fn is_unknown_subscription_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAnomalySubscriptionErrorKind::UnknownSubscriptionException(_)
        )
    }
}
impl std::error::Error for DeleteAnomalySubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAnomalySubscriptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteAnomalySubscriptionErrorKind::UnknownSubscriptionException(_inner) => {
                Some(_inner)
            }
            DeleteAnomalySubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCostCategoryDefinitionError {
    /// Kind of error that occurred.
    pub kind: DeleteCostCategoryDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCostCategoryDefinitionErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The specified ARN in the request doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCostCategoryDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            DeleteCostCategoryDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCostCategoryDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCostCategoryDefinitionError {
    fn code(&self) -> Option<&str> {
        DeleteCostCategoryDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCostCategoryDefinitionError {
    /// Creates a new `DeleteCostCategoryDefinitionError`.
    pub fn new(kind: DeleteCostCategoryDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCostCategoryDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCostCategoryDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCostCategoryDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCostCategoryDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCostCategoryDefinitionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCostCategoryDefinitionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCostCategoryDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCostCategoryDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteCostCategoryDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DeleteCostCategoryDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteCostCategoryDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCostCategoryDefinitionError {
    /// Kind of error that occurred.
    pub kind: DescribeCostCategoryDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCostCategoryDefinitionErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The specified ARN in the request doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCostCategoryDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCostCategoryDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeCostCategoryDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCostCategoryDefinitionError {
    fn code(&self) -> Option<&str> {
        DescribeCostCategoryDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCostCategoryDefinitionError {
    /// Creates a new `DescribeCostCategoryDefinitionError`.
    pub fn new(
        kind: DescribeCostCategoryDefinitionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCostCategoryDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCostCategoryDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCostCategoryDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCostCategoryDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCostCategoryDefinitionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCostCategoryDefinitionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeCostCategoryDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCostCategoryDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeCostCategoryDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => Some(_inner),
            DescribeCostCategoryDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeCostCategoryDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAnomalies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAnomaliesError {
    /// Kind of error that occurred.
    pub kind: GetAnomaliesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAnomalies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAnomaliesErrorKind {
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAnomaliesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAnomaliesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetAnomaliesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetAnomaliesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAnomaliesError {
    fn code(&self) -> Option<&str> {
        GetAnomaliesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAnomaliesError {
    /// Creates a new `GetAnomaliesError`.
    pub fn new(kind: GetAnomaliesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAnomaliesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAnomaliesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAnomaliesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAnomaliesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAnomaliesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomaliesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomaliesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetAnomaliesErrorKind::LimitExceededException(_))
    }
}
impl std::error::Error for GetAnomaliesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAnomaliesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetAnomaliesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetAnomaliesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAnomalyMonitors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAnomalyMonitorsError {
    /// Kind of error that occurred.
    pub kind: GetAnomalyMonitorsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAnomalyMonitors` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAnomalyMonitorsErrorKind {
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The cost anomaly monitor does not exist for the account. </p>
    UnknownMonitorException(crate::error::UnknownMonitorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAnomalyMonitorsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAnomalyMonitorsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetAnomalyMonitorsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetAnomalyMonitorsErrorKind::UnknownMonitorException(_inner) => _inner.fmt(f),
            GetAnomalyMonitorsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAnomalyMonitorsError {
    fn code(&self) -> Option<&str> {
        GetAnomalyMonitorsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAnomalyMonitorsError {
    /// Creates a new `GetAnomalyMonitorsError`.
    pub fn new(kind: GetAnomalyMonitorsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAnomalyMonitorsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAnomalyMonitorsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAnomalyMonitorsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAnomalyMonitorsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAnomalyMonitorsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalyMonitorsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalyMonitorsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalyMonitorsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalyMonitorsErrorKind::UnknownMonitorException`.
    pub fn is_unknown_monitor_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalyMonitorsErrorKind::UnknownMonitorException(_)
        )
    }
}
impl std::error::Error for GetAnomalyMonitorsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAnomalyMonitorsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetAnomalyMonitorsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetAnomalyMonitorsErrorKind::UnknownMonitorException(_inner) => Some(_inner),
            GetAnomalyMonitorsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAnomalySubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAnomalySubscriptionsError {
    /// Kind of error that occurred.
    pub kind: GetAnomalySubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAnomalySubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAnomalySubscriptionsErrorKind {
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The cost anomaly subscription does not exist for the account. </p>
    UnknownSubscriptionException(crate::error::UnknownSubscriptionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAnomalySubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAnomalySubscriptionsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetAnomalySubscriptionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetAnomalySubscriptionsErrorKind::UnknownSubscriptionException(_inner) => _inner.fmt(f),
            GetAnomalySubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAnomalySubscriptionsError {
    fn code(&self) -> Option<&str> {
        GetAnomalySubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAnomalySubscriptionsError {
    /// Creates a new `GetAnomalySubscriptionsError`.
    pub fn new(kind: GetAnomalySubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAnomalySubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAnomalySubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAnomalySubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAnomalySubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAnomalySubscriptionsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalySubscriptionsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalySubscriptionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalySubscriptionsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAnomalySubscriptionsErrorKind::UnknownSubscriptionException`.
    pub fn is_unknown_subscription_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAnomalySubscriptionsErrorKind::UnknownSubscriptionException(_)
        )
    }
}
impl std::error::Error for GetAnomalySubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAnomalySubscriptionsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetAnomalySubscriptionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetAnomalySubscriptionsErrorKind::UnknownSubscriptionException(_inner) => Some(_inner),
            GetAnomalySubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCostAndUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCostAndUsageError {
    /// Kind of error that occurred.
    pub kind: GetCostAndUsageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCostAndUsage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCostAndUsageErrorKind {
    /// <p>The requested report expired. Update the date interval and try again.</p>
    BillExpirationException(crate::error::BillExpirationException),
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Your request parameters changed between pages. Try again with the old parameters or without a pagination token.</p>
    RequestChangedException(crate::error::RequestChangedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCostAndUsageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCostAndUsageErrorKind::BillExpirationException(_inner) => _inner.fmt(f),
            GetCostAndUsageErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetCostAndUsageErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetCostAndUsageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetCostAndUsageErrorKind::RequestChangedException(_inner) => _inner.fmt(f),
            GetCostAndUsageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCostAndUsageError {
    fn code(&self) -> Option<&str> {
        GetCostAndUsageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCostAndUsageError {
    /// Creates a new `GetCostAndUsageError`.
    pub fn new(kind: GetCostAndUsageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCostAndUsageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCostAndUsageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCostAndUsageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCostAndUsageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCostAndUsageErrorKind::BillExpirationException`.
    pub fn is_bill_expiration_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageErrorKind::BillExpirationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageErrorKind::RequestChangedException`.
    pub fn is_request_changed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageErrorKind::RequestChangedException(_)
        )
    }
}
impl std::error::Error for GetCostAndUsageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCostAndUsageErrorKind::BillExpirationException(_inner) => Some(_inner),
            GetCostAndUsageErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetCostAndUsageErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetCostAndUsageErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetCostAndUsageErrorKind::RequestChangedException(_inner) => Some(_inner),
            GetCostAndUsageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCostAndUsageWithResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCostAndUsageWithResourcesError {
    /// Kind of error that occurred.
    pub kind: GetCostAndUsageWithResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCostAndUsageWithResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCostAndUsageWithResourcesErrorKind {
    /// <p>The requested report expired. Update the date interval and try again.</p>
    BillExpirationException(crate::error::BillExpirationException),
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Your request parameters changed between pages. Try again with the old parameters or without a pagination token.</p>
    RequestChangedException(crate::error::RequestChangedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCostAndUsageWithResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCostAndUsageWithResourcesErrorKind::BillExpirationException(_inner) => _inner.fmt(f),
            GetCostAndUsageWithResourcesErrorKind::DataUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetCostAndUsageWithResourcesErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetCostAndUsageWithResourcesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetCostAndUsageWithResourcesErrorKind::RequestChangedException(_inner) => _inner.fmt(f),
            GetCostAndUsageWithResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCostAndUsageWithResourcesError {
    fn code(&self) -> Option<&str> {
        GetCostAndUsageWithResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCostAndUsageWithResourcesError {
    /// Creates a new `GetCostAndUsageWithResourcesError`.
    pub fn new(kind: GetCostAndUsageWithResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCostAndUsageWithResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCostAndUsageWithResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCostAndUsageWithResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCostAndUsageWithResourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCostAndUsageWithResourcesErrorKind::BillExpirationException`.
    pub fn is_bill_expiration_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageWithResourcesErrorKind::BillExpirationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageWithResourcesErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageWithResourcesErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageWithResourcesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageWithResourcesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageWithResourcesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageWithResourcesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostAndUsageWithResourcesErrorKind::RequestChangedException`.
    pub fn is_request_changed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostAndUsageWithResourcesErrorKind::RequestChangedException(_)
        )
    }
}
impl std::error::Error for GetCostAndUsageWithResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCostAndUsageWithResourcesErrorKind::BillExpirationException(_inner) => Some(_inner),
            GetCostAndUsageWithResourcesErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetCostAndUsageWithResourcesErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetCostAndUsageWithResourcesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetCostAndUsageWithResourcesErrorKind::RequestChangedException(_inner) => Some(_inner),
            GetCostAndUsageWithResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCostCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCostCategoriesError {
    /// Kind of error that occurred.
    pub kind: GetCostCategoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCostCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCostCategoriesErrorKind {
    /// <p>The requested report expired. Update the date interval and try again.</p>
    BillExpirationException(crate::error::BillExpirationException),
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Your request parameters changed between pages. Try again with the old parameters or without a pagination token.</p>
    RequestChangedException(crate::error::RequestChangedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCostCategoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCostCategoriesErrorKind::BillExpirationException(_inner) => _inner.fmt(f),
            GetCostCategoriesErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetCostCategoriesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetCostCategoriesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetCostCategoriesErrorKind::RequestChangedException(_inner) => _inner.fmt(f),
            GetCostCategoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCostCategoriesError {
    fn code(&self) -> Option<&str> {
        GetCostCategoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCostCategoriesError {
    /// Creates a new `GetCostCategoriesError`.
    pub fn new(kind: GetCostCategoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCostCategoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCostCategoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCostCategoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCostCategoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCostCategoriesErrorKind::BillExpirationException`.
    pub fn is_bill_expiration_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostCategoriesErrorKind::BillExpirationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostCategoriesErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostCategoriesErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostCategoriesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostCategoriesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostCategoriesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostCategoriesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostCategoriesErrorKind::RequestChangedException`.
    pub fn is_request_changed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostCategoriesErrorKind::RequestChangedException(_)
        )
    }
}
impl std::error::Error for GetCostCategoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCostCategoriesErrorKind::BillExpirationException(_inner) => Some(_inner),
            GetCostCategoriesErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetCostCategoriesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetCostCategoriesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetCostCategoriesErrorKind::RequestChangedException(_inner) => Some(_inner),
            GetCostCategoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCostForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCostForecastError {
    /// Kind of error that occurred.
    pub kind: GetCostForecastErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCostForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCostForecastErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCostForecastError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCostForecastErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetCostForecastErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetCostForecastErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCostForecastError {
    fn code(&self) -> Option<&str> {
        GetCostForecastError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCostForecastError {
    /// Creates a new `GetCostForecastError`.
    pub fn new(kind: GetCostForecastErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCostForecastError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCostForecastErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCostForecastError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCostForecastErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCostForecastErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostForecastErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCostForecastErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCostForecastErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetCostForecastError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCostForecastErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetCostForecastErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetCostForecastErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDimensionValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDimensionValuesError {
    /// Kind of error that occurred.
    pub kind: GetDimensionValuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDimensionValues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDimensionValuesErrorKind {
    /// <p>The requested report expired. Update the date interval and try again.</p>
    BillExpirationException(crate::error::BillExpirationException),
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Your request parameters changed between pages. Try again with the old parameters or without a pagination token.</p>
    RequestChangedException(crate::error::RequestChangedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDimensionValuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDimensionValuesErrorKind::BillExpirationException(_inner) => _inner.fmt(f),
            GetDimensionValuesErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetDimensionValuesErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetDimensionValuesErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetDimensionValuesErrorKind::RequestChangedException(_inner) => _inner.fmt(f),
            GetDimensionValuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDimensionValuesError {
    fn code(&self) -> Option<&str> {
        GetDimensionValuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDimensionValuesError {
    /// Creates a new `GetDimensionValuesError`.
    pub fn new(kind: GetDimensionValuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDimensionValuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDimensionValuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDimensionValuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDimensionValuesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDimensionValuesErrorKind::BillExpirationException`.
    pub fn is_bill_expiration_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDimensionValuesErrorKind::BillExpirationException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDimensionValuesErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDimensionValuesErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDimensionValuesErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDimensionValuesErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDimensionValuesErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDimensionValuesErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDimensionValuesErrorKind::RequestChangedException`.
    pub fn is_request_changed_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDimensionValuesErrorKind::RequestChangedException(_)
        )
    }
}
impl std::error::Error for GetDimensionValuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDimensionValuesErrorKind::BillExpirationException(_inner) => Some(_inner),
            GetDimensionValuesErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetDimensionValuesErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetDimensionValuesErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetDimensionValuesErrorKind::RequestChangedException(_inner) => Some(_inner),
            GetDimensionValuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReservationCoverage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReservationCoverageError {
    /// Kind of error that occurred.
    pub kind: GetReservationCoverageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReservationCoverage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReservationCoverageErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReservationCoverageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReservationCoverageErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetReservationCoverageErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetReservationCoverageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetReservationCoverageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReservationCoverageError {
    fn code(&self) -> Option<&str> {
        GetReservationCoverageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReservationCoverageError {
    /// Creates a new `GetReservationCoverageError`.
    pub fn new(kind: GetReservationCoverageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReservationCoverageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReservationCoverageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReservationCoverageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReservationCoverageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReservationCoverageErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationCoverageErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservationCoverageErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationCoverageErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservationCoverageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationCoverageErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetReservationCoverageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReservationCoverageErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetReservationCoverageErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetReservationCoverageErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetReservationCoverageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReservationPurchaseRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReservationPurchaseRecommendationError {
    /// Kind of error that occurred.
    pub kind: GetReservationPurchaseRecommendationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReservationPurchaseRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReservationPurchaseRecommendationErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReservationPurchaseRecommendationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReservationPurchaseRecommendationErrorKind::DataUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetReservationPurchaseRecommendationErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetReservationPurchaseRecommendationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetReservationPurchaseRecommendationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReservationPurchaseRecommendationError {
    fn code(&self) -> Option<&str> {
        GetReservationPurchaseRecommendationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReservationPurchaseRecommendationError {
    /// Creates a new `GetReservationPurchaseRecommendationError`.
    pub fn new(
        kind: GetReservationPurchaseRecommendationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReservationPurchaseRecommendationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReservationPurchaseRecommendationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReservationPurchaseRecommendationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReservationPurchaseRecommendationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReservationPurchaseRecommendationErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationPurchaseRecommendationErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservationPurchaseRecommendationErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationPurchaseRecommendationErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservationPurchaseRecommendationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationPurchaseRecommendationErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetReservationPurchaseRecommendationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReservationPurchaseRecommendationErrorKind::DataUnavailableException(_inner) => {
                Some(_inner)
            }
            GetReservationPurchaseRecommendationErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetReservationPurchaseRecommendationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            GetReservationPurchaseRecommendationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetReservationUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReservationUtilizationError {
    /// Kind of error that occurred.
    pub kind: GetReservationUtilizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReservationUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReservationUtilizationErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReservationUtilizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReservationUtilizationErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetReservationUtilizationErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetReservationUtilizationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetReservationUtilizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReservationUtilizationError {
    fn code(&self) -> Option<&str> {
        GetReservationUtilizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReservationUtilizationError {
    /// Creates a new `GetReservationUtilizationError`.
    pub fn new(kind: GetReservationUtilizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReservationUtilizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReservationUtilizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReservationUtilizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReservationUtilizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReservationUtilizationErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationUtilizationErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservationUtilizationErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationUtilizationErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservationUtilizationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetReservationUtilizationErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetReservationUtilizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReservationUtilizationErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetReservationUtilizationErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetReservationUtilizationErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetReservationUtilizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetRightsizingRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetRightsizingRecommendationError {
    /// Kind of error that occurred.
    pub kind: GetRightsizingRecommendationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetRightsizingRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetRightsizingRecommendationErrorKind {
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetRightsizingRecommendationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetRightsizingRecommendationErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetRightsizingRecommendationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetRightsizingRecommendationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetRightsizingRecommendationError {
    fn code(&self) -> Option<&str> {
        GetRightsizingRecommendationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetRightsizingRecommendationError {
    /// Creates a new `GetRightsizingRecommendationError`.
    pub fn new(kind: GetRightsizingRecommendationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetRightsizingRecommendationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetRightsizingRecommendationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetRightsizingRecommendationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetRightsizingRecommendationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetRightsizingRecommendationErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRightsizingRecommendationErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetRightsizingRecommendationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetRightsizingRecommendationErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetRightsizingRecommendationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetRightsizingRecommendationErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetRightsizingRecommendationErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetRightsizingRecommendationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSavingsPlansCoverage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSavingsPlansCoverageError {
    /// Kind of error that occurred.
    pub kind: GetSavingsPlansCoverageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSavingsPlansCoverage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSavingsPlansCoverageErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSavingsPlansCoverageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSavingsPlansCoverageErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetSavingsPlansCoverageErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetSavingsPlansCoverageErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSavingsPlansCoverageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSavingsPlansCoverageError {
    fn code(&self) -> Option<&str> {
        GetSavingsPlansCoverageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSavingsPlansCoverageError {
    /// Creates a new `GetSavingsPlansCoverageError`.
    pub fn new(kind: GetSavingsPlansCoverageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSavingsPlansCoverageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSavingsPlansCoverageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSavingsPlansCoverageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSavingsPlansCoverageErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSavingsPlansCoverageErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansCoverageErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSavingsPlansCoverageErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansCoverageErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSavingsPlansCoverageErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansCoverageErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetSavingsPlansCoverageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSavingsPlansCoverageErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetSavingsPlansCoverageErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetSavingsPlansCoverageErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSavingsPlansCoverageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSavingsPlansPurchaseRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSavingsPlansPurchaseRecommendationError {
    /// Kind of error that occurred.
    pub kind: GetSavingsPlansPurchaseRecommendationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSavingsPlansPurchaseRecommendation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSavingsPlansPurchaseRecommendationErrorKind {
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSavingsPlansPurchaseRecommendationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSavingsPlansPurchaseRecommendationErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetSavingsPlansPurchaseRecommendationErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetSavingsPlansPurchaseRecommendationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSavingsPlansPurchaseRecommendationError {
    fn code(&self) -> Option<&str> {
        GetSavingsPlansPurchaseRecommendationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSavingsPlansPurchaseRecommendationError {
    /// Creates a new `GetSavingsPlansPurchaseRecommendationError`.
    pub fn new(
        kind: GetSavingsPlansPurchaseRecommendationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSavingsPlansPurchaseRecommendationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSavingsPlansPurchaseRecommendationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSavingsPlansPurchaseRecommendationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSavingsPlansPurchaseRecommendationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSavingsPlansPurchaseRecommendationErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansPurchaseRecommendationErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSavingsPlansPurchaseRecommendationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansPurchaseRecommendationErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetSavingsPlansPurchaseRecommendationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSavingsPlansPurchaseRecommendationErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetSavingsPlansPurchaseRecommendationErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            GetSavingsPlansPurchaseRecommendationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetSavingsPlansUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSavingsPlansUtilizationError {
    /// Kind of error that occurred.
    pub kind: GetSavingsPlansUtilizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSavingsPlansUtilization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSavingsPlansUtilizationErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSavingsPlansUtilizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSavingsPlansUtilizationErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetSavingsPlansUtilizationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetSavingsPlansUtilizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSavingsPlansUtilizationError {
    fn code(&self) -> Option<&str> {
        GetSavingsPlansUtilizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSavingsPlansUtilizationError {
    /// Creates a new `GetSavingsPlansUtilizationError`.
    pub fn new(kind: GetSavingsPlansUtilizationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSavingsPlansUtilizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSavingsPlansUtilizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSavingsPlansUtilizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSavingsPlansUtilizationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSavingsPlansUtilizationErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansUtilizationErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSavingsPlansUtilizationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansUtilizationErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetSavingsPlansUtilizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSavingsPlansUtilizationErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetSavingsPlansUtilizationErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetSavingsPlansUtilizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetSavingsPlansUtilizationDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetSavingsPlansUtilizationDetailsError {
    /// Kind of error that occurred.
    pub kind: GetSavingsPlansUtilizationDetailsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetSavingsPlansUtilizationDetails` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetSavingsPlansUtilizationDetailsErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetSavingsPlansUtilizationDetailsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetSavingsPlansUtilizationDetailsErrorKind::DataUnavailableException(_inner) => {
                _inner.fmt(f)
            }
            GetSavingsPlansUtilizationDetailsErrorKind::InvalidNextTokenException(_inner) => {
                _inner.fmt(f)
            }
            GetSavingsPlansUtilizationDetailsErrorKind::LimitExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetSavingsPlansUtilizationDetailsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetSavingsPlansUtilizationDetailsError {
    fn code(&self) -> Option<&str> {
        GetSavingsPlansUtilizationDetailsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetSavingsPlansUtilizationDetailsError {
    /// Creates a new `GetSavingsPlansUtilizationDetailsError`.
    pub fn new(
        kind: GetSavingsPlansUtilizationDetailsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetSavingsPlansUtilizationDetailsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetSavingsPlansUtilizationDetailsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetSavingsPlansUtilizationDetailsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetSavingsPlansUtilizationDetailsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetSavingsPlansUtilizationDetailsErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansUtilizationDetailsErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSavingsPlansUtilizationDetailsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansUtilizationDetailsErrorKind::InvalidNextTokenException(_)
        )
    }
    /// Returns `true` if the error kind is `GetSavingsPlansUtilizationDetailsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetSavingsPlansUtilizationDetailsErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for GetSavingsPlansUtilizationDetailsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetSavingsPlansUtilizationDetailsErrorKind::DataUnavailableException(_inner) => {
                Some(_inner)
            }
            GetSavingsPlansUtilizationDetailsErrorKind::InvalidNextTokenException(_inner) => {
                Some(_inner)
            }
            GetSavingsPlansUtilizationDetailsErrorKind::LimitExceededException(_inner) => {
                Some(_inner)
            }
            GetSavingsPlansUtilizationDetailsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetTagsError {
    /// Kind of error that occurred.
    pub kind: GetTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetTagsErrorKind {
    /// <p>The requested report expired. Update the date interval and try again.</p>
    BillExpirationException(crate::error::BillExpirationException),
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>The pagination token is invalid. Try again without a pagination token.</p>
    InvalidNextTokenException(crate::error::InvalidNextTokenException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Your request parameters changed between pages. Try again with the old parameters or without a pagination token.</p>
    RequestChangedException(crate::error::RequestChangedException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetTagsErrorKind::BillExpirationException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::InvalidNextTokenException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::RequestChangedException(_inner) => _inner.fmt(f),
            GetTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetTagsError {
    fn code(&self) -> Option<&str> {
        GetTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetTagsError {
    /// Creates a new `GetTagsError`.
    pub fn new(kind: GetTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::BillExpirationException`.
    pub fn is_bill_expiration_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::BillExpirationException(_))
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::DataUnavailableException(_))
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::InvalidNextTokenException`.
    pub fn is_invalid_next_token_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::InvalidNextTokenException(_))
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `GetTagsErrorKind::RequestChangedException`.
    pub fn is_request_changed_exception(&self) -> bool {
        matches!(&self.kind, GetTagsErrorKind::RequestChangedException(_))
    }
}
impl std::error::Error for GetTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetTagsErrorKind::BillExpirationException(_inner) => Some(_inner),
            GetTagsErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetTagsErrorKind::InvalidNextTokenException(_inner) => Some(_inner),
            GetTagsErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetTagsErrorKind::RequestChangedException(_inner) => Some(_inner),
            GetTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsageForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsageForecastError {
    /// Kind of error that occurred.
    pub kind: GetUsageForecastErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsageForecast` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsageForecastErrorKind {
    /// <p>The requested data is unavailable.</p>
    DataUnavailableException(crate::error::DataUnavailableException),
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>Cost Explorer was unable to identify the usage unit. Provide <code>UsageType/UsageTypeGroup</code> filter selections that contain matching units, for example: <code>hours</code>.</p>
    UnresolvableUsageUnitException(crate::error::UnresolvableUsageUnitException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsageForecastError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsageForecastErrorKind::DataUnavailableException(_inner) => _inner.fmt(f),
            GetUsageForecastErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            GetUsageForecastErrorKind::UnresolvableUsageUnitException(_inner) => _inner.fmt(f),
            GetUsageForecastErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsageForecastError {
    fn code(&self) -> Option<&str> {
        GetUsageForecastError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsageForecastError {
    /// Creates a new `GetUsageForecastError`.
    pub fn new(kind: GetUsageForecastErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsageForecastError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsageForecastErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsageForecastError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsageForecastErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUsageForecastErrorKind::DataUnavailableException`.
    pub fn is_data_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageForecastErrorKind::DataUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageForecastErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageForecastErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageForecastErrorKind::UnresolvableUsageUnitException`.
    pub fn is_unresolvable_usage_unit_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageForecastErrorKind::UnresolvableUsageUnitException(_)
        )
    }
}
impl std::error::Error for GetUsageForecastError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsageForecastErrorKind::DataUnavailableException(_inner) => Some(_inner),
            GetUsageForecastErrorKind::LimitExceededException(_inner) => Some(_inner),
            GetUsageForecastErrorKind::UnresolvableUsageUnitException(_inner) => Some(_inner),
            GetUsageForecastErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCostCategoryDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCostCategoryDefinitionsError {
    /// Kind of error that occurred.
    pub kind: ListCostCategoryDefinitionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCostCategoryDefinitions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCostCategoryDefinitionsErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCostCategoryDefinitionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCostCategoryDefinitionsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ListCostCategoryDefinitionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCostCategoryDefinitionsError {
    fn code(&self) -> Option<&str> {
        ListCostCategoryDefinitionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCostCategoryDefinitionsError {
    /// Creates a new `ListCostCategoryDefinitionsError`.
    pub fn new(kind: ListCostCategoryDefinitionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCostCategoryDefinitionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCostCategoryDefinitionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCostCategoryDefinitionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCostCategoryDefinitionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCostCategoryDefinitionsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCostCategoryDefinitionsErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for ListCostCategoryDefinitionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCostCategoryDefinitionsErrorKind::LimitExceededException(_inner) => Some(_inner),
            ListCostCategoryDefinitionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ProvideAnomalyFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ProvideAnomalyFeedbackError {
    /// Kind of error that occurred.
    pub kind: ProvideAnomalyFeedbackErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ProvideAnomalyFeedback` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ProvideAnomalyFeedbackErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ProvideAnomalyFeedbackError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ProvideAnomalyFeedbackErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            ProvideAnomalyFeedbackErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ProvideAnomalyFeedbackError {
    fn code(&self) -> Option<&str> {
        ProvideAnomalyFeedbackError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ProvideAnomalyFeedbackError {
    /// Creates a new `ProvideAnomalyFeedbackError`.
    pub fn new(kind: ProvideAnomalyFeedbackErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ProvideAnomalyFeedbackError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ProvideAnomalyFeedbackErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ProvideAnomalyFeedbackError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ProvideAnomalyFeedbackErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ProvideAnomalyFeedbackErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ProvideAnomalyFeedbackErrorKind::LimitExceededException(_)
        )
    }
}
impl std::error::Error for ProvideAnomalyFeedbackError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ProvideAnomalyFeedbackErrorKind::LimitExceededException(_inner) => Some(_inner),
            ProvideAnomalyFeedbackErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAnomalyMonitor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAnomalyMonitorError {
    /// Kind of error that occurred.
    pub kind: UpdateAnomalyMonitorErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAnomalyMonitor` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAnomalyMonitorErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The cost anomaly monitor does not exist for the account. </p>
    UnknownMonitorException(crate::error::UnknownMonitorException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAnomalyMonitorError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAnomalyMonitorErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAnomalyMonitorErrorKind::UnknownMonitorException(_inner) => _inner.fmt(f),
            UpdateAnomalyMonitorErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAnomalyMonitorError {
    fn code(&self) -> Option<&str> {
        UpdateAnomalyMonitorError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAnomalyMonitorError {
    /// Creates a new `UpdateAnomalyMonitorError`.
    pub fn new(kind: UpdateAnomalyMonitorErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAnomalyMonitorError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAnomalyMonitorErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAnomalyMonitorError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAnomalyMonitorErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAnomalyMonitorErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalyMonitorErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnomalyMonitorErrorKind::UnknownMonitorException`.
    pub fn is_unknown_monitor_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalyMonitorErrorKind::UnknownMonitorException(_)
        )
    }
}
impl std::error::Error for UpdateAnomalyMonitorError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAnomalyMonitorErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAnomalyMonitorErrorKind::UnknownMonitorException(_inner) => Some(_inner),
            UpdateAnomalyMonitorErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAnomalySubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAnomalySubscriptionError {
    /// Kind of error that occurred.
    pub kind: UpdateAnomalySubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAnomalySubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAnomalySubscriptionErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The cost anomaly monitor does not exist for the account. </p>
    UnknownMonitorException(crate::error::UnknownMonitorException),
    /// <p>The cost anomaly subscription does not exist for the account. </p>
    UnknownSubscriptionException(crate::error::UnknownSubscriptionException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAnomalySubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAnomalySubscriptionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAnomalySubscriptionErrorKind::UnknownMonitorException(_inner) => _inner.fmt(f),
            UpdateAnomalySubscriptionErrorKind::UnknownSubscriptionException(_inner) => {
                _inner.fmt(f)
            }
            UpdateAnomalySubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAnomalySubscriptionError {
    fn code(&self) -> Option<&str> {
        UpdateAnomalySubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAnomalySubscriptionError {
    /// Creates a new `UpdateAnomalySubscriptionError`.
    pub fn new(kind: UpdateAnomalySubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAnomalySubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAnomalySubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAnomalySubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAnomalySubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAnomalySubscriptionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalySubscriptionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnomalySubscriptionErrorKind::UnknownMonitorException`.
    pub fn is_unknown_monitor_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalySubscriptionErrorKind::UnknownMonitorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAnomalySubscriptionErrorKind::UnknownSubscriptionException`.
    pub fn is_unknown_subscription_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAnomalySubscriptionErrorKind::UnknownSubscriptionException(_)
        )
    }
}
impl std::error::Error for UpdateAnomalySubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAnomalySubscriptionErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAnomalySubscriptionErrorKind::UnknownMonitorException(_inner) => Some(_inner),
            UpdateAnomalySubscriptionErrorKind::UnknownSubscriptionException(_inner) => {
                Some(_inner)
            }
            UpdateAnomalySubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateCostCategoryDefinitionError {
    /// Kind of error that occurred.
    pub kind: UpdateCostCategoryDefinitionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateCostCategoryDefinition` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateCostCategoryDefinitionErrorKind {
    /// <p>You made too many calls in a short period of time. Try again later.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p> The specified ARN in the request doesn't exist. </p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p> You've reached the limit on the number of resources you can create, or exceeded the size of an individual resource. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateCostCategoryDefinitionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateCostCategoryDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateCostCategoryDefinitionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateCostCategoryDefinitionError {
    fn code(&self) -> Option<&str> {
        UpdateCostCategoryDefinitionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateCostCategoryDefinitionError {
    /// Creates a new `UpdateCostCategoryDefinitionError`.
    pub fn new(kind: UpdateCostCategoryDefinitionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateCostCategoryDefinitionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateCostCategoryDefinitionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateCostCategoryDefinitionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateCostCategoryDefinitionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateCostCategoryDefinitionErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCostCategoryDefinitionErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCostCategoryDefinitionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCostCategoryDefinitionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(_)
        )
    }
}
impl std::error::Error for UpdateCostCategoryDefinitionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateCostCategoryDefinitionErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateCostCategoryDefinitionErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            UpdateCostCategoryDefinitionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p> You've reached the limit on the number of resources you can create, or exceeded the size of an individual resource. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p> The specified ARN in the request doesn't exist. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>You made too many calls in a short period of time. Try again later.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The cost anomaly subscription does not exist for the account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnknownSubscriptionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnknownSubscriptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnknownSubscriptionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnknownSubscriptionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnknownSubscriptionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnknownSubscriptionException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnknownSubscriptionException {}
/// See [`UnknownSubscriptionException`](crate::error::UnknownSubscriptionException)
pub mod unknown_subscription_exception {
    /// A builder for [`UnknownSubscriptionException`](crate::error::UnknownSubscriptionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnknownSubscriptionException`](crate::error::UnknownSubscriptionException)
        pub fn build(self) -> crate::error::UnknownSubscriptionException {
            crate::error::UnknownSubscriptionException {
                message: self.message,
            }
        }
    }
}
impl UnknownSubscriptionException {
    /// Creates a new builder-style object to manufacture [`UnknownSubscriptionException`](crate::error::UnknownSubscriptionException)
    pub fn builder() -> crate::error::unknown_subscription_exception::Builder {
        crate::error::unknown_subscription_exception::Builder::default()
    }
}

/// <p>The cost anomaly monitor does not exist for the account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnknownMonitorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnknownMonitorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnknownMonitorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnknownMonitorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnknownMonitorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnknownMonitorException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnknownMonitorException {}
/// See [`UnknownMonitorException`](crate::error::UnknownMonitorException)
pub mod unknown_monitor_exception {
    /// A builder for [`UnknownMonitorException`](crate::error::UnknownMonitorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnknownMonitorException`](crate::error::UnknownMonitorException)
        pub fn build(self) -> crate::error::UnknownMonitorException {
            crate::error::UnknownMonitorException {
                message: self.message,
            }
        }
    }
}
impl UnknownMonitorException {
    /// Creates a new builder-style object to manufacture [`UnknownMonitorException`](crate::error::UnknownMonitorException)
    pub fn builder() -> crate::error::unknown_monitor_exception::Builder {
        crate::error::unknown_monitor_exception::Builder::default()
    }
}

/// <p>Cost Explorer was unable to identify the usage unit. Provide <code>UsageType/UsageTypeGroup</code> filter selections that contain matching units, for example: <code>hours</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnresolvableUsageUnitException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnresolvableUsageUnitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnresolvableUsageUnitException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnresolvableUsageUnitException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnresolvableUsageUnitException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnresolvableUsageUnitException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnresolvableUsageUnitException {}
/// See [`UnresolvableUsageUnitException`](crate::error::UnresolvableUsageUnitException)
pub mod unresolvable_usage_unit_exception {
    /// A builder for [`UnresolvableUsageUnitException`](crate::error::UnresolvableUsageUnitException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnresolvableUsageUnitException`](crate::error::UnresolvableUsageUnitException)
        pub fn build(self) -> crate::error::UnresolvableUsageUnitException {
            crate::error::UnresolvableUsageUnitException {
                message: self.message,
            }
        }
    }
}
impl UnresolvableUsageUnitException {
    /// Creates a new builder-style object to manufacture [`UnresolvableUsageUnitException`](crate::error::UnresolvableUsageUnitException)
    pub fn builder() -> crate::error::unresolvable_usage_unit_exception::Builder {
        crate::error::unresolvable_usage_unit_exception::Builder::default()
    }
}

/// <p>The requested data is unavailable.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataUnavailableException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DataUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DataUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DataUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DataUnavailableException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for DataUnavailableException {}
/// See [`DataUnavailableException`](crate::error::DataUnavailableException)
pub mod data_unavailable_exception {
    /// A builder for [`DataUnavailableException`](crate::error::DataUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DataUnavailableException`](crate::error::DataUnavailableException)
        pub fn build(self) -> crate::error::DataUnavailableException {
            crate::error::DataUnavailableException {
                message: self.message,
            }
        }
    }
}
impl DataUnavailableException {
    /// Creates a new builder-style object to manufacture [`DataUnavailableException`](crate::error::DataUnavailableException)
    pub fn builder() -> crate::error::data_unavailable_exception::Builder {
        crate::error::data_unavailable_exception::Builder::default()
    }
}

/// <p>Your request parameters changed between pages. Try again with the old parameters or without a pagination token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RequestChangedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RequestChangedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RequestChangedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl RequestChangedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for RequestChangedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "RequestChangedException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for RequestChangedException {}
/// See [`RequestChangedException`](crate::error::RequestChangedException)
pub mod request_changed_exception {
    /// A builder for [`RequestChangedException`](crate::error::RequestChangedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`RequestChangedException`](crate::error::RequestChangedException)
        pub fn build(self) -> crate::error::RequestChangedException {
            crate::error::RequestChangedException {
                message: self.message,
            }
        }
    }
}
impl RequestChangedException {
    /// Creates a new builder-style object to manufacture [`RequestChangedException`](crate::error::RequestChangedException)
    pub fn builder() -> crate::error::request_changed_exception::Builder {
        crate::error::request_changed_exception::Builder::default()
    }
}

/// <p>The pagination token is invalid. Try again without a pagination token.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNextTokenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNextTokenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNextTokenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNextTokenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNextTokenException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNextTokenException {}
/// See [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
pub mod invalid_next_token_exception {
    /// A builder for [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
        pub fn build(self) -> crate::error::InvalidNextTokenException {
            crate::error::InvalidNextTokenException {
                message: self.message,
            }
        }
    }
}
impl InvalidNextTokenException {
    /// Creates a new builder-style object to manufacture [`InvalidNextTokenException`](crate::error::InvalidNextTokenException)
    pub fn builder() -> crate::error::invalid_next_token_exception::Builder {
        crate::error::invalid_next_token_exception::Builder::default()
    }
}

/// <p>The requested report expired. Update the date interval and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BillExpirationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BillExpirationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BillExpirationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BillExpirationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BillExpirationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BillExpirationException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for BillExpirationException {}
/// See [`BillExpirationException`](crate::error::BillExpirationException)
pub mod bill_expiration_exception {
    /// A builder for [`BillExpirationException`](crate::error::BillExpirationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BillExpirationException`](crate::error::BillExpirationException)
        pub fn build(self) -> crate::error::BillExpirationException {
            crate::error::BillExpirationException {
                message: self.message,
            }
        }
    }
}
impl BillExpirationException {
    /// Creates a new builder-style object to manufacture [`BillExpirationException`](crate::error::BillExpirationException)
    pub fn builder() -> crate::error::bill_expiration_exception::Builder {
        crate::error::bill_expiration_exception::Builder::default()
    }
}
