// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_anomaly_monitor_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAnomalyMonitorOutput,
    crate::error::CreateAnomalyMonitorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAnomalyMonitorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateAnomalyMonitorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::CreateAnomalyMonitorError {
            meta: generic,
            kind: crate::error::CreateAnomalyMonitorErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAnomalyMonitorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAnomalyMonitorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_anomaly_monitor_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAnomalyMonitorOutput,
    crate::error::CreateAnomalyMonitorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_anomaly_monitor_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_anomaly_monitor(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAnomalyMonitorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_anomaly_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAnomalySubscriptionOutput,
    crate::error::CreateAnomalySubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateAnomalySubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateAnomalySubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::CreateAnomalySubscriptionError {
            meta: generic,
            kind: crate::error::CreateAnomalySubscriptionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAnomalySubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownMonitorException" => crate::error::CreateAnomalySubscriptionError {
            meta: generic,
            kind: crate::error::CreateAnomalySubscriptionErrorKind::UnknownMonitorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unknown_monitor_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_monitor_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateAnomalySubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateAnomalySubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_anomaly_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateAnomalySubscriptionOutput,
    crate::error::CreateAnomalySubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_anomaly_subscription_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_anomaly_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateAnomalySubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cost_category_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCostCategoryDefinitionOutput,
    crate::error::CreateCostCategoryDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCostCategoryDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCostCategoryDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::CreateCostCategoryDefinitionError {
            meta: generic,
            kind: crate::error::CreateCostCategoryDefinitionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCostCategoryDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CreateCostCategoryDefinitionError {
            meta: generic,
            kind:
                crate::error::CreateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_quota_exceeded_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateCostCategoryDefinitionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::CreateCostCategoryDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_cost_category_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCostCategoryDefinitionOutput,
    crate::error::CreateCostCategoryDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_cost_category_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_cost_category_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateCostCategoryDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_anomaly_monitor_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnomalyMonitorOutput,
    crate::error::DeleteAnomalyMonitorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAnomalyMonitorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteAnomalyMonitorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::DeleteAnomalyMonitorError {
            meta: generic,
            kind: crate::error::DeleteAnomalyMonitorErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalyMonitorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownMonitorException" => crate::error::DeleteAnomalyMonitorError {
            meta: generic,
            kind: crate::error::DeleteAnomalyMonitorErrorKind::UnknownMonitorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unknown_monitor_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_monitor_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalyMonitorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAnomalyMonitorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_anomaly_monitor_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnomalyMonitorOutput,
    crate::error::DeleteAnomalyMonitorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_anomaly_monitor_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_anomaly_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnomalySubscriptionOutput,
    crate::error::DeleteAnomalySubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteAnomalySubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteAnomalySubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::DeleteAnomalySubscriptionError {
            meta: generic,
            kind: crate::error::DeleteAnomalySubscriptionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalySubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownSubscriptionException" => crate::error::DeleteAnomalySubscriptionError {
            meta: generic,
            kind: crate::error::DeleteAnomalySubscriptionErrorKind::UnknownSubscriptionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unknown_subscription_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_subscription_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteAnomalySubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteAnomalySubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_anomaly_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteAnomalySubscriptionOutput,
    crate::error::DeleteAnomalySubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_anomaly_subscription_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cost_category_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCostCategoryDefinitionOutput,
    crate::error::DeleteCostCategoryDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCostCategoryDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCostCategoryDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::DeleteCostCategoryDefinitionError {
            meta: generic,
            kind: crate::error::DeleteCostCategoryDefinitionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCostCategoryDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteCostCategoryDefinitionError {
            meta: generic,
            kind: crate::error::DeleteCostCategoryDefinitionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteCostCategoryDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteCostCategoryDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_cost_category_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCostCategoryDefinitionOutput,
    crate::error::DeleteCostCategoryDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_cost_category_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_delete_cost_category_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DeleteCostCategoryDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cost_category_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCostCategoryDefinitionOutput,
    crate::error::DescribeCostCategoryDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCostCategoryDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeCostCategoryDefinitionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::DescribeCostCategoryDefinitionError {
            meta: generic,
            kind: crate::error::DescribeCostCategoryDefinitionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCostCategoryDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeCostCategoryDefinitionError {
            meta: generic,
            kind: crate::error::DescribeCostCategoryDefinitionErrorKind::ResourceNotFoundException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::resource_not_found_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeCostCategoryDefinitionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeCostCategoryDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_cost_category_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCostCategoryDefinitionOutput,
    crate::error::DescribeCostCategoryDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_cost_category_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_describe_cost_category_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeCostCategoryDefinitionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_anomalies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAnomaliesOutput, crate::error::GetAnomaliesError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAnomaliesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAnomaliesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::GetAnomaliesError {
            meta: generic,
            kind: crate::error::GetAnomaliesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomaliesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetAnomaliesError {
            meta: generic,
            kind: crate::error::GetAnomaliesErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomaliesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAnomaliesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_anomalies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAnomaliesOutput, crate::error::GetAnomaliesError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_anomalies_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_anomalies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAnomaliesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_anomaly_monitors_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAnomalyMonitorsOutput,
    crate::error::GetAnomalyMonitorsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAnomalyMonitorsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAnomalyMonitorsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::GetAnomalyMonitorsError {
            meta: generic,
            kind: crate::error::GetAnomalyMonitorsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomalyMonitorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetAnomalyMonitorsError {
            meta: generic,
            kind: crate::error::GetAnomalyMonitorsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomalyMonitorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownMonitorException" => crate::error::GetAnomalyMonitorsError {
            meta: generic,
            kind: crate::error::GetAnomalyMonitorsErrorKind::UnknownMonitorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unknown_monitor_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_monitor_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomalyMonitorsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAnomalyMonitorsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_anomaly_monitors_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAnomalyMonitorsOutput,
    crate::error::GetAnomalyMonitorsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_anomaly_monitors_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_anomaly_monitors(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAnomalyMonitorsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_anomaly_subscriptions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAnomalySubscriptionsOutput,
    crate::error::GetAnomalySubscriptionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAnomalySubscriptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetAnomalySubscriptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::GetAnomalySubscriptionsError {
            meta: generic,
            kind: crate::error::GetAnomalySubscriptionsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomalySubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetAnomalySubscriptionsError {
            meta: generic,
            kind: crate::error::GetAnomalySubscriptionsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomalySubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownSubscriptionException" => crate::error::GetAnomalySubscriptionsError {
            meta: generic,
            kind: crate::error::GetAnomalySubscriptionsErrorKind::UnknownSubscriptionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unknown_subscription_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_subscription_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAnomalySubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAnomalySubscriptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_anomaly_subscriptions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetAnomalySubscriptionsOutput,
    crate::error::GetAnomalySubscriptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_anomaly_subscriptions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_anomaly_subscriptions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAnomalySubscriptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_and_usage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCostAndUsageOutput, crate::error::GetCostAndUsageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCostAndUsageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCostAndUsageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BillExpirationException" => crate::error::GetCostAndUsageError {
            meta: generic,
            kind: crate::error::GetCostAndUsageErrorKind::BillExpirationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bill_expiration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bill_expiration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataUnavailableException" => crate::error::GetCostAndUsageError {
            meta: generic,
            kind: crate::error::GetCostAndUsageErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetCostAndUsageError {
            meta: generic,
            kind: crate::error::GetCostAndUsageErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetCostAndUsageError {
            meta: generic,
            kind: crate::error::GetCostAndUsageErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestChangedException" => crate::error::GetCostAndUsageError {
            meta: generic,
            kind: crate::error::GetCostAndUsageErrorKind::RequestChangedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_changed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_changed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCostAndUsageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_and_usage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCostAndUsageOutput, crate::error::GetCostAndUsageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_cost_and_usage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_cost_and_usage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCostAndUsageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_and_usage_with_resources_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCostAndUsageWithResourcesOutput,
    crate::error::GetCostAndUsageWithResourcesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCostAndUsageWithResourcesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetCostAndUsageWithResourcesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BillExpirationException" => crate::error::GetCostAndUsageWithResourcesError {
            meta: generic,
            kind: crate::error::GetCostAndUsageWithResourcesErrorKind::BillExpirationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bill_expiration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bill_expiration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageWithResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataUnavailableException" => crate::error::GetCostAndUsageWithResourcesError {
            meta: generic,
            kind: crate::error::GetCostAndUsageWithResourcesErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageWithResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetCostAndUsageWithResourcesError {
            meta: generic,
            kind: crate::error::GetCostAndUsageWithResourcesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageWithResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetCostAndUsageWithResourcesError {
            meta: generic,
            kind: crate::error::GetCostAndUsageWithResourcesErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageWithResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestChangedException" => crate::error::GetCostAndUsageWithResourcesError {
            meta: generic,
            kind: crate::error::GetCostAndUsageWithResourcesErrorKind::RequestChangedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_changed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_changed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostAndUsageWithResourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCostAndUsageWithResourcesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_and_usage_with_resources_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetCostAndUsageWithResourcesOutput,
    crate::error::GetCostAndUsageWithResourcesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_cost_and_usage_with_resources_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_get_cost_and_usage_with_resources(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::GetCostAndUsageWithResourcesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_categories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCostCategoriesOutput, crate::error::GetCostCategoriesError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCostCategoriesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCostCategoriesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BillExpirationException" => crate::error::GetCostCategoriesError {
            meta: generic,
            kind: crate::error::GetCostCategoriesErrorKind::BillExpirationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bill_expiration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bill_expiration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostCategoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataUnavailableException" => crate::error::GetCostCategoriesError {
            meta: generic,
            kind: crate::error::GetCostCategoriesErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostCategoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetCostCategoriesError {
            meta: generic,
            kind: crate::error::GetCostCategoriesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostCategoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetCostCategoriesError {
            meta: generic,
            kind: crate::error::GetCostCategoriesErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostCategoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestChangedException" => crate::error::GetCostCategoriesError {
            meta: generic,
            kind: crate::error::GetCostCategoriesErrorKind::RequestChangedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_changed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_changed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostCategoriesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCostCategoriesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_categories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCostCategoriesOutput, crate::error::GetCostCategoriesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_cost_categories_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_cost_categories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCostCategoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_forecast_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCostForecastOutput, crate::error::GetCostForecastError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetCostForecastError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetCostForecastError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetCostForecastError {
            meta: generic,
            kind: crate::error::GetCostForecastErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostForecastError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetCostForecastError {
            meta: generic,
            kind: crate::error::GetCostForecastErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetCostForecastError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetCostForecastError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_cost_forecast_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetCostForecastOutput, crate::error::GetCostForecastError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_cost_forecast_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_cost_forecast(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetCostForecastError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_dimension_values_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDimensionValuesOutput,
    crate::error::GetDimensionValuesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDimensionValuesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDimensionValuesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BillExpirationException" => crate::error::GetDimensionValuesError {
            meta: generic,
            kind: crate::error::GetDimensionValuesErrorKind::BillExpirationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bill_expiration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bill_expiration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDimensionValuesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataUnavailableException" => crate::error::GetDimensionValuesError {
            meta: generic,
            kind: crate::error::GetDimensionValuesErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDimensionValuesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetDimensionValuesError {
            meta: generic,
            kind: crate::error::GetDimensionValuesErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDimensionValuesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetDimensionValuesError {
            meta: generic,
            kind: crate::error::GetDimensionValuesErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDimensionValuesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestChangedException" => crate::error::GetDimensionValuesError {
            meta: generic,
            kind: crate::error::GetDimensionValuesErrorKind::RequestChangedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_changed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_changed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDimensionValuesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDimensionValuesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_dimension_values_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetDimensionValuesOutput,
    crate::error::GetDimensionValuesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_dimension_values_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_dimension_values(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDimensionValuesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reservation_coverage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservationCoverageOutput,
    crate::error::GetReservationCoverageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetReservationCoverageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetReservationCoverageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetReservationCoverageError {
            meta: generic,
            kind: crate::error::GetReservationCoverageErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationCoverageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetReservationCoverageError {
            meta: generic,
            kind: crate::error::GetReservationCoverageErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationCoverageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetReservationCoverageError {
            meta: generic,
            kind: crate::error::GetReservationCoverageErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationCoverageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetReservationCoverageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reservation_coverage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservationCoverageOutput,
    crate::error::GetReservationCoverageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_reservation_coverage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_reservation_coverage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetReservationCoverageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reservation_purchase_recommendation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservationPurchaseRecommendationOutput,
    crate::error::GetReservationPurchaseRecommendationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetReservationPurchaseRecommendationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetReservationPurchaseRecommendationError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetReservationPurchaseRecommendationError { meta: generic, kind: crate::error::GetReservationPurchaseRecommendationErrorKind::DataUnavailableException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationPurchaseRecommendationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidNextTokenException" => crate::error::GetReservationPurchaseRecommendationError { meta: generic, kind: crate::error::GetReservationPurchaseRecommendationErrorKind::InvalidNextTokenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationPurchaseRecommendationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::GetReservationPurchaseRecommendationError { meta: generic, kind: crate::error::GetReservationPurchaseRecommendationErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationPurchaseRecommendationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetReservationPurchaseRecommendationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reservation_purchase_recommendation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservationPurchaseRecommendationOutput,
    crate::error::GetReservationPurchaseRecommendationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_reservation_purchase_recommendation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_reservation_purchase_recommendation(response.body().as_ref(), output).map_err(crate::error::GetReservationPurchaseRecommendationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reservation_utilization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservationUtilizationOutput,
    crate::error::GetReservationUtilizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetReservationUtilizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetReservationUtilizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetReservationUtilizationError {
            meta: generic,
            kind: crate::error::GetReservationUtilizationErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationUtilizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetReservationUtilizationError {
            meta: generic,
            kind: crate::error::GetReservationUtilizationErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationUtilizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetReservationUtilizationError {
            meta: generic,
            kind: crate::error::GetReservationUtilizationErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetReservationUtilizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetReservationUtilizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_reservation_utilization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetReservationUtilizationOutput,
    crate::error::GetReservationUtilizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_reservation_utilization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_reservation_utilization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetReservationUtilizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rightsizing_recommendation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRightsizingRecommendationOutput,
    crate::error::GetRightsizingRecommendationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetRightsizingRecommendationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetRightsizingRecommendationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::GetRightsizingRecommendationError {
            meta: generic,
            kind: crate::error::GetRightsizingRecommendationErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRightsizingRecommendationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetRightsizingRecommendationError {
            meta: generic,
            kind: crate::error::GetRightsizingRecommendationErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetRightsizingRecommendationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetRightsizingRecommendationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_rightsizing_recommendation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetRightsizingRecommendationOutput,
    crate::error::GetRightsizingRecommendationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_rightsizing_recommendation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_rightsizing_recommendation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetRightsizingRecommendationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_coverage_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansCoverageOutput,
    crate::error::GetSavingsPlansCoverageError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSavingsPlansCoverageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetSavingsPlansCoverageError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetSavingsPlansCoverageError {
            meta: generic,
            kind: crate::error::GetSavingsPlansCoverageErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansCoverageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetSavingsPlansCoverageError {
            meta: generic,
            kind: crate::error::GetSavingsPlansCoverageErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansCoverageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetSavingsPlansCoverageError {
            meta: generic,
            kind: crate::error::GetSavingsPlansCoverageErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansCoverageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSavingsPlansCoverageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_coverage_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansCoverageOutput,
    crate::error::GetSavingsPlansCoverageError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_savings_plans_coverage_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_savings_plans_coverage(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSavingsPlansCoverageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_purchase_recommendation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansPurchaseRecommendationOutput,
    crate::error::GetSavingsPlansPurchaseRecommendationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSavingsPlansPurchaseRecommendationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::GetSavingsPlansPurchaseRecommendationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidNextTokenException" => crate::error::GetSavingsPlansPurchaseRecommendationError { meta: generic, kind: crate::error::GetSavingsPlansPurchaseRecommendationErrorKind::InvalidNextTokenException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansPurchaseRecommendationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "LimitExceededException" => crate::error::GetSavingsPlansPurchaseRecommendationError { meta: generic, kind: crate::error::GetSavingsPlansPurchaseRecommendationErrorKind::LimitExceededException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansPurchaseRecommendationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::GetSavingsPlansPurchaseRecommendationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_purchase_recommendation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansPurchaseRecommendationOutput,
    crate::error::GetSavingsPlansPurchaseRecommendationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_savings_plans_purchase_recommendation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_savings_plans_purchase_recommendation(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansPurchaseRecommendationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_utilization_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansUtilizationOutput,
    crate::error::GetSavingsPlansUtilizationError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSavingsPlansUtilizationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetSavingsPlansUtilizationError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetSavingsPlansUtilizationError {
            meta: generic,
            kind: crate::error::GetSavingsPlansUtilizationErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansUtilizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetSavingsPlansUtilizationError {
            meta: generic,
            kind: crate::error::GetSavingsPlansUtilizationErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansUtilizationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetSavingsPlansUtilizationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_utilization_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansUtilizationOutput,
    crate::error::GetSavingsPlansUtilizationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_savings_plans_utilization_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_savings_plans_utilization(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetSavingsPlansUtilizationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_utilization_details_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansUtilizationDetailsOutput,
    crate::error::GetSavingsPlansUtilizationDetailsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetSavingsPlansUtilizationDetailsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::GetSavingsPlansUtilizationDetailsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetSavingsPlansUtilizationDetailsError {
            meta: generic,
            kind:
                crate::error::GetSavingsPlansUtilizationDetailsErrorKind::DataUnavailableException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::data_unavailable_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansUtilizationDetailsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidNextTokenException" => crate::error::GetSavingsPlansUtilizationDetailsError {
            meta: generic,
            kind:
                crate::error::GetSavingsPlansUtilizationDetailsErrorKind::InvalidNextTokenException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_next_token_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansUtilizationDetailsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "LimitExceededException" => crate::error::GetSavingsPlansUtilizationDetailsError {
            meta: generic,
            kind: crate::error::GetSavingsPlansUtilizationDetailsErrorKind::LimitExceededException(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::limit_exceeded_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansUtilizationDetailsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::GetSavingsPlansUtilizationDetailsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_savings_plans_utilization_details_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetSavingsPlansUtilizationDetailsOutput,
    crate::error::GetSavingsPlansUtilizationDetailsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::get_savings_plans_utilization_details_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_savings_plans_utilization_details(response.body().as_ref(), output).map_err(crate::error::GetSavingsPlansUtilizationDetailsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "BillExpirationException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::BillExpirationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::bill_expiration_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_bill_expiration_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DataUnavailableException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidNextTokenException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::InvalidNextTokenException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_next_token_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_next_token_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "RequestChangedException" => crate::error::GetTagsError {
            meta: generic,
            kind: crate::error::GetTagsErrorKind::RequestChangedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::request_changed_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_request_changed_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_usage_forecast_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUsageForecastOutput, crate::error::GetUsageForecastError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetUsageForecastError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetUsageForecastError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DataUnavailableException" => crate::error::GetUsageForecastError {
            meta: generic,
            kind: crate::error::GetUsageForecastErrorKind::DataUnavailableException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::data_unavailable_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_data_unavailable_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUsageForecastError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::GetUsageForecastError {
            meta: generic,
            kind: crate::error::GetUsageForecastErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUsageForecastError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnresolvableUsageUnitException" => crate::error::GetUsageForecastError {
            meta: generic,
            kind: crate::error::GetUsageForecastErrorKind::UnresolvableUsageUnitException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unresolvable_usage_unit_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unresolvable_usage_unit_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetUsageForecastError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetUsageForecastError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_usage_forecast_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetUsageForecastOutput, crate::error::GetUsageForecastError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_usage_forecast_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_usage_forecast(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetUsageForecastError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cost_category_definitions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCostCategoryDefinitionsOutput,
    crate::error::ListCostCategoryDefinitionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListCostCategoryDefinitionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ListCostCategoryDefinitionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::ListCostCategoryDefinitionsError {
            meta: generic,
            kind: crate::error::ListCostCategoryDefinitionsErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListCostCategoryDefinitionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListCostCategoryDefinitionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_cost_category_definitions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListCostCategoryDefinitionsOutput,
    crate::error::ListCostCategoryDefinitionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_cost_category_definitions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_cost_category_definitions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListCostCategoryDefinitionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_provide_anomaly_feedback_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ProvideAnomalyFeedbackOutput,
    crate::error::ProvideAnomalyFeedbackError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::ProvideAnomalyFeedbackError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ProvideAnomalyFeedbackError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::ProvideAnomalyFeedbackError {
            meta: generic,
            kind: crate::error::ProvideAnomalyFeedbackErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::ProvideAnomalyFeedbackError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ProvideAnomalyFeedbackError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_provide_anomaly_feedback_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ProvideAnomalyFeedbackOutput,
    crate::error::ProvideAnomalyFeedbackError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::provide_anomaly_feedback_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_provide_anomaly_feedback(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ProvideAnomalyFeedbackError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::TagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::TagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TooManyTagsException" => crate::error::TagResourceError {
            meta: generic,
            kind: crate::error::TagResourceErrorKind::TooManyTagsException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::too_many_tags_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_too_many_tags_exception_json_err(response.body().as_ref(), output).map_err(crate::error::TagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::TagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_tag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::tag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UntagResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UntagResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UntagResourceError {
            meta: generic,
            kind: crate::error::UntagResourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UntagResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UntagResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_untag_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::untag_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_anomaly_monitor_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAnomalyMonitorOutput,
    crate::error::UpdateAnomalyMonitorError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAnomalyMonitorError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateAnomalyMonitorError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::UpdateAnomalyMonitorError {
            meta: generic,
            kind: crate::error::UpdateAnomalyMonitorErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAnomalyMonitorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownMonitorException" => crate::error::UpdateAnomalyMonitorError {
            meta: generic,
            kind: crate::error::UpdateAnomalyMonitorErrorKind::UnknownMonitorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unknown_monitor_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_monitor_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAnomalyMonitorError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAnomalyMonitorError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_anomaly_monitor_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAnomalyMonitorOutput,
    crate::error::UpdateAnomalyMonitorError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_anomaly_monitor_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_anomaly_monitor(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAnomalyMonitorError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_anomaly_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAnomalySubscriptionOutput,
    crate::error::UpdateAnomalySubscriptionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateAnomalySubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateAnomalySubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::UpdateAnomalySubscriptionError {
            meta: generic,
            kind: crate::error::UpdateAnomalySubscriptionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAnomalySubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownMonitorException" => crate::error::UpdateAnomalySubscriptionError {
            meta: generic,
            kind: crate::error::UpdateAnomalySubscriptionErrorKind::UnknownMonitorException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::unknown_monitor_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_monitor_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAnomalySubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "UnknownSubscriptionException" => crate::error::UpdateAnomalySubscriptionError {
            meta: generic,
            kind: crate::error::UpdateAnomalySubscriptionErrorKind::UnknownSubscriptionException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::unknown_subscription_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_unknown_subscription_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateAnomalySubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateAnomalySubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_anomaly_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateAnomalySubscriptionOutput,
    crate::error::UpdateAnomalySubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_anomaly_subscription_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_anomaly_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateAnomalySubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cost_category_definition_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCostCategoryDefinitionOutput,
    crate::error::UpdateCostCategoryDefinitionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateCostCategoryDefinitionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::UpdateCostCategoryDefinitionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "LimitExceededException" => crate::error::UpdateCostCategoryDefinitionError {
            meta: generic,
            kind: crate::error::UpdateCostCategoryDefinitionErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCostCategoryDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateCostCategoryDefinitionError {
            meta: generic,
            kind: crate::error::UpdateCostCategoryDefinitionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCostCategoryDefinitionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::UpdateCostCategoryDefinitionError {
            meta: generic,
            kind:
                crate::error::UpdateCostCategoryDefinitionErrorKind::ServiceQuotaExceededException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::service_quota_exceeded_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateCostCategoryDefinitionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::UpdateCostCategoryDefinitionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_cost_category_definition_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateCostCategoryDefinitionOutput,
    crate::error::UpdateCostCategoryDefinitionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_cost_category_definition_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_update_cost_category_definition(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::UpdateCostCategoryDefinitionError::unhandled)?;
        output.build()
    })
}
