// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateAnomalyMonitor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_anomaly_monitor`](crate::client::Client::create_anomaly_monitor).
///
/// See [`crate::client::fluent_builders::CreateAnomalyMonitor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAnomalyMonitor {
    _private: (),
}
impl CreateAnomalyMonitor {
    /// Creates a new builder-style object to manufacture [`CreateAnomalyMonitorInput`](crate::input::CreateAnomalyMonitorInput)
    pub fn builder() -> crate::input::create_anomaly_monitor_input::Builder {
        crate::input::create_anomaly_monitor_input::Builder::default()
    }
    /// Creates a new `CreateAnomalyMonitor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAnomalyMonitor {
    type Output = std::result::Result<
        crate::output::CreateAnomalyMonitorOutput,
        crate::error::CreateAnomalyMonitorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_anomaly_monitor_error(response)
        } else {
            crate::operation_deser::parse_create_anomaly_monitor_response(response)
        }
    }
}

/// Operation shape for `CreateAnomalySubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_anomaly_subscription`](crate::client::Client::create_anomaly_subscription).
///
/// See [`crate::client::fluent_builders::CreateAnomalySubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateAnomalySubscription {
    _private: (),
}
impl CreateAnomalySubscription {
    /// Creates a new builder-style object to manufacture [`CreateAnomalySubscriptionInput`](crate::input::CreateAnomalySubscriptionInput)
    pub fn builder() -> crate::input::create_anomaly_subscription_input::Builder {
        crate::input::create_anomaly_subscription_input::Builder::default()
    }
    /// Creates a new `CreateAnomalySubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateAnomalySubscription {
    type Output = std::result::Result<
        crate::output::CreateAnomalySubscriptionOutput,
        crate::error::CreateAnomalySubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_anomaly_subscription_error(response)
        } else {
            crate::operation_deser::parse_create_anomaly_subscription_response(response)
        }
    }
}

/// Operation shape for `CreateCostCategoryDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_cost_category_definition`](crate::client::Client::create_cost_category_definition).
///
/// See [`crate::client::fluent_builders::CreateCostCategoryDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCostCategoryDefinition {
    _private: (),
}
impl CreateCostCategoryDefinition {
    /// Creates a new builder-style object to manufacture [`CreateCostCategoryDefinitionInput`](crate::input::CreateCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::create_cost_category_definition_input::Builder {
        crate::input::create_cost_category_definition_input::Builder::default()
    }
    /// Creates a new `CreateCostCategoryDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCostCategoryDefinition {
    type Output = std::result::Result<
        crate::output::CreateCostCategoryDefinitionOutput,
        crate::error::CreateCostCategoryDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_cost_category_definition_error(response)
        } else {
            crate::operation_deser::parse_create_cost_category_definition_response(response)
        }
    }
}

/// Operation shape for `DeleteAnomalyMonitor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_anomaly_monitor`](crate::client::Client::delete_anomaly_monitor).
///
/// See [`crate::client::fluent_builders::DeleteAnomalyMonitor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAnomalyMonitor {
    _private: (),
}
impl DeleteAnomalyMonitor {
    /// Creates a new builder-style object to manufacture [`DeleteAnomalyMonitorInput`](crate::input::DeleteAnomalyMonitorInput)
    pub fn builder() -> crate::input::delete_anomaly_monitor_input::Builder {
        crate::input::delete_anomaly_monitor_input::Builder::default()
    }
    /// Creates a new `DeleteAnomalyMonitor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAnomalyMonitor {
    type Output = std::result::Result<
        crate::output::DeleteAnomalyMonitorOutput,
        crate::error::DeleteAnomalyMonitorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_anomaly_monitor_error(response)
        } else {
            crate::operation_deser::parse_delete_anomaly_monitor_response(response)
        }
    }
}

/// Operation shape for `DeleteAnomalySubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_anomaly_subscription`](crate::client::Client::delete_anomaly_subscription).
///
/// See [`crate::client::fluent_builders::DeleteAnomalySubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteAnomalySubscription {
    _private: (),
}
impl DeleteAnomalySubscription {
    /// Creates a new builder-style object to manufacture [`DeleteAnomalySubscriptionInput`](crate::input::DeleteAnomalySubscriptionInput)
    pub fn builder() -> crate::input::delete_anomaly_subscription_input::Builder {
        crate::input::delete_anomaly_subscription_input::Builder::default()
    }
    /// Creates a new `DeleteAnomalySubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteAnomalySubscription {
    type Output = std::result::Result<
        crate::output::DeleteAnomalySubscriptionOutput,
        crate::error::DeleteAnomalySubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_anomaly_subscription_error(response)
        } else {
            crate::operation_deser::parse_delete_anomaly_subscription_response(response)
        }
    }
}

/// Operation shape for `DeleteCostCategoryDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_cost_category_definition`](crate::client::Client::delete_cost_category_definition).
///
/// See [`crate::client::fluent_builders::DeleteCostCategoryDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCostCategoryDefinition {
    _private: (),
}
impl DeleteCostCategoryDefinition {
    /// Creates a new builder-style object to manufacture [`DeleteCostCategoryDefinitionInput`](crate::input::DeleteCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::delete_cost_category_definition_input::Builder {
        crate::input::delete_cost_category_definition_input::Builder::default()
    }
    /// Creates a new `DeleteCostCategoryDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCostCategoryDefinition {
    type Output = std::result::Result<
        crate::output::DeleteCostCategoryDefinitionOutput,
        crate::error::DeleteCostCategoryDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_cost_category_definition_error(response)
        } else {
            crate::operation_deser::parse_delete_cost_category_definition_response(response)
        }
    }
}

/// Operation shape for `DescribeCostCategoryDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_cost_category_definition`](crate::client::Client::describe_cost_category_definition).
///
/// See [`crate::client::fluent_builders::DescribeCostCategoryDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeCostCategoryDefinition {
    _private: (),
}
impl DescribeCostCategoryDefinition {
    /// Creates a new builder-style object to manufacture [`DescribeCostCategoryDefinitionInput`](crate::input::DescribeCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::describe_cost_category_definition_input::Builder {
        crate::input::describe_cost_category_definition_input::Builder::default()
    }
    /// Creates a new `DescribeCostCategoryDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeCostCategoryDefinition {
    type Output = std::result::Result<
        crate::output::DescribeCostCategoryDefinitionOutput,
        crate::error::DescribeCostCategoryDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_cost_category_definition_error(response)
        } else {
            crate::operation_deser::parse_describe_cost_category_definition_response(response)
        }
    }
}

/// Operation shape for `GetAnomalies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_anomalies`](crate::client::Client::get_anomalies).
///
/// See [`crate::client::fluent_builders::GetAnomalies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAnomalies {
    _private: (),
}
impl GetAnomalies {
    /// Creates a new builder-style object to manufacture [`GetAnomaliesInput`](crate::input::GetAnomaliesInput)
    pub fn builder() -> crate::input::get_anomalies_input::Builder {
        crate::input::get_anomalies_input::Builder::default()
    }
    /// Creates a new `GetAnomalies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAnomalies {
    type Output =
        std::result::Result<crate::output::GetAnomaliesOutput, crate::error::GetAnomaliesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_anomalies_error(response)
        } else {
            crate::operation_deser::parse_get_anomalies_response(response)
        }
    }
}

/// Operation shape for `GetAnomalyMonitors`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_anomaly_monitors`](crate::client::Client::get_anomaly_monitors).
///
/// See [`crate::client::fluent_builders::GetAnomalyMonitors`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAnomalyMonitors {
    _private: (),
}
impl GetAnomalyMonitors {
    /// Creates a new builder-style object to manufacture [`GetAnomalyMonitorsInput`](crate::input::GetAnomalyMonitorsInput)
    pub fn builder() -> crate::input::get_anomaly_monitors_input::Builder {
        crate::input::get_anomaly_monitors_input::Builder::default()
    }
    /// Creates a new `GetAnomalyMonitors` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAnomalyMonitors {
    type Output = std::result::Result<
        crate::output::GetAnomalyMonitorsOutput,
        crate::error::GetAnomalyMonitorsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_anomaly_monitors_error(response)
        } else {
            crate::operation_deser::parse_get_anomaly_monitors_response(response)
        }
    }
}

/// Operation shape for `GetAnomalySubscriptions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_anomaly_subscriptions`](crate::client::Client::get_anomaly_subscriptions).
///
/// See [`crate::client::fluent_builders::GetAnomalySubscriptions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAnomalySubscriptions {
    _private: (),
}
impl GetAnomalySubscriptions {
    /// Creates a new builder-style object to manufacture [`GetAnomalySubscriptionsInput`](crate::input::GetAnomalySubscriptionsInput)
    pub fn builder() -> crate::input::get_anomaly_subscriptions_input::Builder {
        crate::input::get_anomaly_subscriptions_input::Builder::default()
    }
    /// Creates a new `GetAnomalySubscriptions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAnomalySubscriptions {
    type Output = std::result::Result<
        crate::output::GetAnomalySubscriptionsOutput,
        crate::error::GetAnomalySubscriptionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_anomaly_subscriptions_error(response)
        } else {
            crate::operation_deser::parse_get_anomaly_subscriptions_response(response)
        }
    }
}

/// Operation shape for `GetCostAndUsage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cost_and_usage`](crate::client::Client::get_cost_and_usage).
///
/// See [`crate::client::fluent_builders::GetCostAndUsage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCostAndUsage {
    _private: (),
}
impl GetCostAndUsage {
    /// Creates a new builder-style object to manufacture [`GetCostAndUsageInput`](crate::input::GetCostAndUsageInput)
    pub fn builder() -> crate::input::get_cost_and_usage_input::Builder {
        crate::input::get_cost_and_usage_input::Builder::default()
    }
    /// Creates a new `GetCostAndUsage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCostAndUsage {
    type Output = std::result::Result<
        crate::output::GetCostAndUsageOutput,
        crate::error::GetCostAndUsageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cost_and_usage_error(response)
        } else {
            crate::operation_deser::parse_get_cost_and_usage_response(response)
        }
    }
}

/// Operation shape for `GetCostAndUsageWithResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cost_and_usage_with_resources`](crate::client::Client::get_cost_and_usage_with_resources).
///
/// See [`crate::client::fluent_builders::GetCostAndUsageWithResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCostAndUsageWithResources {
    _private: (),
}
impl GetCostAndUsageWithResources {
    /// Creates a new builder-style object to manufacture [`GetCostAndUsageWithResourcesInput`](crate::input::GetCostAndUsageWithResourcesInput)
    pub fn builder() -> crate::input::get_cost_and_usage_with_resources_input::Builder {
        crate::input::get_cost_and_usage_with_resources_input::Builder::default()
    }
    /// Creates a new `GetCostAndUsageWithResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCostAndUsageWithResources {
    type Output = std::result::Result<
        crate::output::GetCostAndUsageWithResourcesOutput,
        crate::error::GetCostAndUsageWithResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cost_and_usage_with_resources_error(response)
        } else {
            crate::operation_deser::parse_get_cost_and_usage_with_resources_response(response)
        }
    }
}

/// Operation shape for `GetCostCategories`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cost_categories`](crate::client::Client::get_cost_categories).
///
/// See [`crate::client::fluent_builders::GetCostCategories`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCostCategories {
    _private: (),
}
impl GetCostCategories {
    /// Creates a new builder-style object to manufacture [`GetCostCategoriesInput`](crate::input::GetCostCategoriesInput)
    pub fn builder() -> crate::input::get_cost_categories_input::Builder {
        crate::input::get_cost_categories_input::Builder::default()
    }
    /// Creates a new `GetCostCategories` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCostCategories {
    type Output = std::result::Result<
        crate::output::GetCostCategoriesOutput,
        crate::error::GetCostCategoriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cost_categories_error(response)
        } else {
            crate::operation_deser::parse_get_cost_categories_response(response)
        }
    }
}

/// Operation shape for `GetCostForecast`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_cost_forecast`](crate::client::Client::get_cost_forecast).
///
/// See [`crate::client::fluent_builders::GetCostForecast`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCostForecast {
    _private: (),
}
impl GetCostForecast {
    /// Creates a new builder-style object to manufacture [`GetCostForecastInput`](crate::input::GetCostForecastInput)
    pub fn builder() -> crate::input::get_cost_forecast_input::Builder {
        crate::input::get_cost_forecast_input::Builder::default()
    }
    /// Creates a new `GetCostForecast` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCostForecast {
    type Output = std::result::Result<
        crate::output::GetCostForecastOutput,
        crate::error::GetCostForecastError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_cost_forecast_error(response)
        } else {
            crate::operation_deser::parse_get_cost_forecast_response(response)
        }
    }
}

/// Operation shape for `GetDimensionValues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_dimension_values`](crate::client::Client::get_dimension_values).
///
/// See [`crate::client::fluent_builders::GetDimensionValues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetDimensionValues {
    _private: (),
}
impl GetDimensionValues {
    /// Creates a new builder-style object to manufacture [`GetDimensionValuesInput`](crate::input::GetDimensionValuesInput)
    pub fn builder() -> crate::input::get_dimension_values_input::Builder {
        crate::input::get_dimension_values_input::Builder::default()
    }
    /// Creates a new `GetDimensionValues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetDimensionValues {
    type Output = std::result::Result<
        crate::output::GetDimensionValuesOutput,
        crate::error::GetDimensionValuesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_dimension_values_error(response)
        } else {
            crate::operation_deser::parse_get_dimension_values_response(response)
        }
    }
}

/// Operation shape for `GetReservationCoverage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reservation_coverage`](crate::client::Client::get_reservation_coverage).
///
/// See [`crate::client::fluent_builders::GetReservationCoverage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReservationCoverage {
    _private: (),
}
impl GetReservationCoverage {
    /// Creates a new builder-style object to manufacture [`GetReservationCoverageInput`](crate::input::GetReservationCoverageInput)
    pub fn builder() -> crate::input::get_reservation_coverage_input::Builder {
        crate::input::get_reservation_coverage_input::Builder::default()
    }
    /// Creates a new `GetReservationCoverage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReservationCoverage {
    type Output = std::result::Result<
        crate::output::GetReservationCoverageOutput,
        crate::error::GetReservationCoverageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reservation_coverage_error(response)
        } else {
            crate::operation_deser::parse_get_reservation_coverage_response(response)
        }
    }
}

/// Operation shape for `GetReservationPurchaseRecommendation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reservation_purchase_recommendation`](crate::client::Client::get_reservation_purchase_recommendation).
///
/// See [`crate::client::fluent_builders::GetReservationPurchaseRecommendation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReservationPurchaseRecommendation {
    _private: (),
}
impl GetReservationPurchaseRecommendation {
    /// Creates a new builder-style object to manufacture [`GetReservationPurchaseRecommendationInput`](crate::input::GetReservationPurchaseRecommendationInput)
    pub fn builder() -> crate::input::get_reservation_purchase_recommendation_input::Builder {
        crate::input::get_reservation_purchase_recommendation_input::Builder::default()
    }
    /// Creates a new `GetReservationPurchaseRecommendation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReservationPurchaseRecommendation {
    type Output = std::result::Result<
        crate::output::GetReservationPurchaseRecommendationOutput,
        crate::error::GetReservationPurchaseRecommendationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reservation_purchase_recommendation_error(response)
        } else {
            crate::operation_deser::parse_get_reservation_purchase_recommendation_response(response)
        }
    }
}

/// Operation shape for `GetReservationUtilization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_reservation_utilization`](crate::client::Client::get_reservation_utilization).
///
/// See [`crate::client::fluent_builders::GetReservationUtilization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetReservationUtilization {
    _private: (),
}
impl GetReservationUtilization {
    /// Creates a new builder-style object to manufacture [`GetReservationUtilizationInput`](crate::input::GetReservationUtilizationInput)
    pub fn builder() -> crate::input::get_reservation_utilization_input::Builder {
        crate::input::get_reservation_utilization_input::Builder::default()
    }
    /// Creates a new `GetReservationUtilization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetReservationUtilization {
    type Output = std::result::Result<
        crate::output::GetReservationUtilizationOutput,
        crate::error::GetReservationUtilizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_reservation_utilization_error(response)
        } else {
            crate::operation_deser::parse_get_reservation_utilization_response(response)
        }
    }
}

/// Operation shape for `GetRightsizingRecommendation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_rightsizing_recommendation`](crate::client::Client::get_rightsizing_recommendation).
///
/// See [`crate::client::fluent_builders::GetRightsizingRecommendation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetRightsizingRecommendation {
    _private: (),
}
impl GetRightsizingRecommendation {
    /// Creates a new builder-style object to manufacture [`GetRightsizingRecommendationInput`](crate::input::GetRightsizingRecommendationInput)
    pub fn builder() -> crate::input::get_rightsizing_recommendation_input::Builder {
        crate::input::get_rightsizing_recommendation_input::Builder::default()
    }
    /// Creates a new `GetRightsizingRecommendation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetRightsizingRecommendation {
    type Output = std::result::Result<
        crate::output::GetRightsizingRecommendationOutput,
        crate::error::GetRightsizingRecommendationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_rightsizing_recommendation_error(response)
        } else {
            crate::operation_deser::parse_get_rightsizing_recommendation_response(response)
        }
    }
}

/// Operation shape for `GetSavingsPlansCoverage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_savings_plans_coverage`](crate::client::Client::get_savings_plans_coverage).
///
/// See [`crate::client::fluent_builders::GetSavingsPlansCoverage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSavingsPlansCoverage {
    _private: (),
}
impl GetSavingsPlansCoverage {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansCoverageInput`](crate::input::GetSavingsPlansCoverageInput)
    pub fn builder() -> crate::input::get_savings_plans_coverage_input::Builder {
        crate::input::get_savings_plans_coverage_input::Builder::default()
    }
    /// Creates a new `GetSavingsPlansCoverage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSavingsPlansCoverage {
    type Output = std::result::Result<
        crate::output::GetSavingsPlansCoverageOutput,
        crate::error::GetSavingsPlansCoverageError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_savings_plans_coverage_error(response)
        } else {
            crate::operation_deser::parse_get_savings_plans_coverage_response(response)
        }
    }
}

/// Operation shape for `GetSavingsPlansPurchaseRecommendation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_savings_plans_purchase_recommendation`](crate::client::Client::get_savings_plans_purchase_recommendation).
///
/// See [`crate::client::fluent_builders::GetSavingsPlansPurchaseRecommendation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSavingsPlansPurchaseRecommendation {
    _private: (),
}
impl GetSavingsPlansPurchaseRecommendation {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansPurchaseRecommendationInput`](crate::input::GetSavingsPlansPurchaseRecommendationInput)
    pub fn builder() -> crate::input::get_savings_plans_purchase_recommendation_input::Builder {
        crate::input::get_savings_plans_purchase_recommendation_input::Builder::default()
    }
    /// Creates a new `GetSavingsPlansPurchaseRecommendation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSavingsPlansPurchaseRecommendation {
    type Output = std::result::Result<
        crate::output::GetSavingsPlansPurchaseRecommendationOutput,
        crate::error::GetSavingsPlansPurchaseRecommendationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_savings_plans_purchase_recommendation_error(response)
        } else {
            crate::operation_deser::parse_get_savings_plans_purchase_recommendation_response(
                response,
            )
        }
    }
}

/// Operation shape for `GetSavingsPlansUtilization`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_savings_plans_utilization`](crate::client::Client::get_savings_plans_utilization).
///
/// See [`crate::client::fluent_builders::GetSavingsPlansUtilization`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSavingsPlansUtilization {
    _private: (),
}
impl GetSavingsPlansUtilization {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansUtilizationInput`](crate::input::GetSavingsPlansUtilizationInput)
    pub fn builder() -> crate::input::get_savings_plans_utilization_input::Builder {
        crate::input::get_savings_plans_utilization_input::Builder::default()
    }
    /// Creates a new `GetSavingsPlansUtilization` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSavingsPlansUtilization {
    type Output = std::result::Result<
        crate::output::GetSavingsPlansUtilizationOutput,
        crate::error::GetSavingsPlansUtilizationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_savings_plans_utilization_error(response)
        } else {
            crate::operation_deser::parse_get_savings_plans_utilization_response(response)
        }
    }
}

/// Operation shape for `GetSavingsPlansUtilizationDetails`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_savings_plans_utilization_details`](crate::client::Client::get_savings_plans_utilization_details).
///
/// See [`crate::client::fluent_builders::GetSavingsPlansUtilizationDetails`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetSavingsPlansUtilizationDetails {
    _private: (),
}
impl GetSavingsPlansUtilizationDetails {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansUtilizationDetailsInput`](crate::input::GetSavingsPlansUtilizationDetailsInput)
    pub fn builder() -> crate::input::get_savings_plans_utilization_details_input::Builder {
        crate::input::get_savings_plans_utilization_details_input::Builder::default()
    }
    /// Creates a new `GetSavingsPlansUtilizationDetails` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetSavingsPlansUtilizationDetails {
    type Output = std::result::Result<
        crate::output::GetSavingsPlansUtilizationDetailsOutput,
        crate::error::GetSavingsPlansUtilizationDetailsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_savings_plans_utilization_details_error(response)
        } else {
            crate::operation_deser::parse_get_savings_plans_utilization_details_response(response)
        }
    }
}

/// Operation shape for `GetTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_tags`](crate::client::Client::get_tags).
///
/// See [`crate::client::fluent_builders::GetTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTags {
    _private: (),
}
impl GetTags {
    /// Creates a new builder-style object to manufacture [`GetTagsInput`](crate::input::GetTagsInput)
    pub fn builder() -> crate::input::get_tags_input::Builder {
        crate::input::get_tags_input::Builder::default()
    }
    /// Creates a new `GetTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTags {
    type Output = std::result::Result<crate::output::GetTagsOutput, crate::error::GetTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_tags_error(response)
        } else {
            crate::operation_deser::parse_get_tags_response(response)
        }
    }
}

/// Operation shape for `GetUsageForecast`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_forecast`](crate::client::Client::get_usage_forecast).
///
/// See [`crate::client::fluent_builders::GetUsageForecast`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsageForecast {
    _private: (),
}
impl GetUsageForecast {
    /// Creates a new builder-style object to manufacture [`GetUsageForecastInput`](crate::input::GetUsageForecastInput)
    pub fn builder() -> crate::input::get_usage_forecast_input::Builder {
        crate::input::get_usage_forecast_input::Builder::default()
    }
    /// Creates a new `GetUsageForecast` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsageForecast {
    type Output = std::result::Result<
        crate::output::GetUsageForecastOutput,
        crate::error::GetUsageForecastError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_forecast_error(response)
        } else {
            crate::operation_deser::parse_get_usage_forecast_response(response)
        }
    }
}

/// Operation shape for `ListCostCategoryDefinitions`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_cost_category_definitions`](crate::client::Client::list_cost_category_definitions).
///
/// See [`crate::client::fluent_builders::ListCostCategoryDefinitions`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCostCategoryDefinitions {
    _private: (),
}
impl ListCostCategoryDefinitions {
    /// Creates a new builder-style object to manufacture [`ListCostCategoryDefinitionsInput`](crate::input::ListCostCategoryDefinitionsInput)
    pub fn builder() -> crate::input::list_cost_category_definitions_input::Builder {
        crate::input::list_cost_category_definitions_input::Builder::default()
    }
    /// Creates a new `ListCostCategoryDefinitions` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCostCategoryDefinitions {
    type Output = std::result::Result<
        crate::output::ListCostCategoryDefinitionsOutput,
        crate::error::ListCostCategoryDefinitionsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_cost_category_definitions_error(response)
        } else {
            crate::operation_deser::parse_list_cost_category_definitions_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `ProvideAnomalyFeedback`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`provide_anomaly_feedback`](crate::client::Client::provide_anomaly_feedback).
///
/// See [`crate::client::fluent_builders::ProvideAnomalyFeedback`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ProvideAnomalyFeedback {
    _private: (),
}
impl ProvideAnomalyFeedback {
    /// Creates a new builder-style object to manufacture [`ProvideAnomalyFeedbackInput`](crate::input::ProvideAnomalyFeedbackInput)
    pub fn builder() -> crate::input::provide_anomaly_feedback_input::Builder {
        crate::input::provide_anomaly_feedback_input::Builder::default()
    }
    /// Creates a new `ProvideAnomalyFeedback` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ProvideAnomalyFeedback {
    type Output = std::result::Result<
        crate::output::ProvideAnomalyFeedbackOutput,
        crate::error::ProvideAnomalyFeedbackError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_provide_anomaly_feedback_error(response)
        } else {
            crate::operation_deser::parse_provide_anomaly_feedback_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateAnomalyMonitor`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_anomaly_monitor`](crate::client::Client::update_anomaly_monitor).
///
/// See [`crate::client::fluent_builders::UpdateAnomalyMonitor`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAnomalyMonitor {
    _private: (),
}
impl UpdateAnomalyMonitor {
    /// Creates a new builder-style object to manufacture [`UpdateAnomalyMonitorInput`](crate::input::UpdateAnomalyMonitorInput)
    pub fn builder() -> crate::input::update_anomaly_monitor_input::Builder {
        crate::input::update_anomaly_monitor_input::Builder::default()
    }
    /// Creates a new `UpdateAnomalyMonitor` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAnomalyMonitor {
    type Output = std::result::Result<
        crate::output::UpdateAnomalyMonitorOutput,
        crate::error::UpdateAnomalyMonitorError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_anomaly_monitor_error(response)
        } else {
            crate::operation_deser::parse_update_anomaly_monitor_response(response)
        }
    }
}

/// Operation shape for `UpdateAnomalySubscription`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_anomaly_subscription`](crate::client::Client::update_anomaly_subscription).
///
/// See [`crate::client::fluent_builders::UpdateAnomalySubscription`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateAnomalySubscription {
    _private: (),
}
impl UpdateAnomalySubscription {
    /// Creates a new builder-style object to manufacture [`UpdateAnomalySubscriptionInput`](crate::input::UpdateAnomalySubscriptionInput)
    pub fn builder() -> crate::input::update_anomaly_subscription_input::Builder {
        crate::input::update_anomaly_subscription_input::Builder::default()
    }
    /// Creates a new `UpdateAnomalySubscription` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateAnomalySubscription {
    type Output = std::result::Result<
        crate::output::UpdateAnomalySubscriptionOutput,
        crate::error::UpdateAnomalySubscriptionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_anomaly_subscription_error(response)
        } else {
            crate::operation_deser::parse_update_anomaly_subscription_response(response)
        }
    }
}

/// Operation shape for `UpdateCostCategoryDefinition`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_cost_category_definition`](crate::client::Client::update_cost_category_definition).
///
/// See [`crate::client::fluent_builders::UpdateCostCategoryDefinition`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateCostCategoryDefinition {
    _private: (),
}
impl UpdateCostCategoryDefinition {
    /// Creates a new builder-style object to manufacture [`UpdateCostCategoryDefinitionInput`](crate::input::UpdateCostCategoryDefinitionInput)
    pub fn builder() -> crate::input::update_cost_category_definition_input::Builder {
        crate::input::update_cost_category_definition_input::Builder::default()
    }
    /// Creates a new `UpdateCostCategoryDefinition` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateCostCategoryDefinition {
    type Output = std::result::Result<
        crate::output::UpdateCostCategoryDefinitionOutput,
        crate::error::UpdateCostCategoryDefinitionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_cost_category_definition_error(response)
        } else {
            crate::operation_deser::parse_update_cost_category_definition_response(response)
        }
    }
}
