// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateCostCategoryDefinitionOutput {
    /// <p>
    /// The unique identifier for your Cost Category.
    /// </p>
    pub cost_category_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The Cost Category's effective start date.
    /// </p>
    pub effective_start: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateCostCategoryDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCostCategoryDefinitionOutput");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.field("effective_start", &self.effective_start);
        formatter.finish()
    }
}
/// See [`UpdateCostCategoryDefinitionOutput`](crate::output::UpdateCostCategoryDefinitionOutput)
pub mod update_cost_category_definition_output {
    /// A builder for [`UpdateCostCategoryDefinitionOutput`](crate::output::UpdateCostCategoryDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
        pub(crate) effective_start: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The unique identifier for your Cost Category.
        /// </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier for your Cost Category.
        /// </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// <p>
        /// The Cost Category's effective start date.
        /// </p>
        pub fn effective_start(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_start = Some(input.into());
            self
        }
        /// <p>
        /// The Cost Category's effective start date.
        /// </p>
        pub fn set_effective_start(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_start = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateCostCategoryDefinitionOutput`](crate::output::UpdateCostCategoryDefinitionOutput)
        pub fn build(self) -> crate::output::UpdateCostCategoryDefinitionOutput {
            crate::output::UpdateCostCategoryDefinitionOutput {
                cost_category_arn: self.cost_category_arn,
                effective_start: self.effective_start,
            }
        }
    }
}
impl UpdateCostCategoryDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateCostCategoryDefinitionOutput`](crate::output::UpdateCostCategoryDefinitionOutput)
    pub fn builder() -> crate::output::update_cost_category_definition_output::Builder {
        crate::output::update_cost_category_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnomalySubscriptionOutput {
    /// <p>A cost anomaly subscription ARN. </p>
    pub subscription_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateAnomalySubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnomalySubscriptionOutput");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.finish()
    }
}
/// See [`UpdateAnomalySubscriptionOutput`](crate::output::UpdateAnomalySubscriptionOutput)
pub mod update_anomaly_subscription_output {
    /// A builder for [`UpdateAnomalySubscriptionOutput`](crate::output::UpdateAnomalySubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cost anomaly subscription ARN. </p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>A cost anomaly subscription ARN. </p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnomalySubscriptionOutput`](crate::output::UpdateAnomalySubscriptionOutput)
        pub fn build(self) -> crate::output::UpdateAnomalySubscriptionOutput {
            crate::output::UpdateAnomalySubscriptionOutput {
                subscription_arn: self.subscription_arn,
            }
        }
    }
}
impl UpdateAnomalySubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAnomalySubscriptionOutput`](crate::output::UpdateAnomalySubscriptionOutput)
    pub fn builder() -> crate::output::update_anomaly_subscription_output::Builder {
        crate::output::update_anomaly_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateAnomalyMonitorOutput {
    /// <p>A cost anomaly monitor ARN. </p>
    pub monitor_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateAnomalyMonitorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateAnomalyMonitorOutput");
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.finish()
    }
}
/// See [`UpdateAnomalyMonitorOutput`](crate::output::UpdateAnomalyMonitorOutput)
pub mod update_anomaly_monitor_output {
    /// A builder for [`UpdateAnomalyMonitorOutput`](crate::output::UpdateAnomalyMonitorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A cost anomaly monitor ARN. </p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>A cost anomaly monitor ARN. </p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAnomalyMonitorOutput`](crate::output::UpdateAnomalyMonitorOutput)
        pub fn build(self) -> crate::output::UpdateAnomalyMonitorOutput {
            crate::output::UpdateAnomalyMonitorOutput {
                monitor_arn: self.monitor_arn,
            }
        }
    }
}
impl UpdateAnomalyMonitorOutput {
    /// Creates a new builder-style object to manufacture [`UpdateAnomalyMonitorOutput`](crate::output::UpdateAnomalyMonitorOutput)
    pub fn builder() -> crate::output::update_anomaly_monitor_output::Builder {
        crate::output::update_anomaly_monitor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvideAnomalyFeedbackOutput {
    /// <p>The ID of the modified cost anomaly. </p>
    pub anomaly_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvideAnomalyFeedbackOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvideAnomalyFeedbackOutput");
        formatter.field("anomaly_id", &self.anomaly_id);
        formatter.finish()
    }
}
/// See [`ProvideAnomalyFeedbackOutput`](crate::output::ProvideAnomalyFeedbackOutput)
pub mod provide_anomaly_feedback_output {
    /// A builder for [`ProvideAnomalyFeedbackOutput`](crate::output::ProvideAnomalyFeedbackOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the modified cost anomaly. </p>
        pub fn anomaly_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_id = Some(input.into());
            self
        }
        /// <p>The ID of the modified cost anomaly. </p>
        pub fn set_anomaly_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.anomaly_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvideAnomalyFeedbackOutput`](crate::output::ProvideAnomalyFeedbackOutput)
        pub fn build(self) -> crate::output::ProvideAnomalyFeedbackOutput {
            crate::output::ProvideAnomalyFeedbackOutput {
                anomaly_id: self.anomaly_id,
            }
        }
    }
}
impl ProvideAnomalyFeedbackOutput {
    /// Creates a new builder-style object to manufacture [`ProvideAnomalyFeedbackOutput`](crate::output::ProvideAnomalyFeedbackOutput)
    pub fn builder() -> crate::output::provide_anomaly_feedback_output::Builder {
        crate::output::provide_anomaly_feedback_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCostCategoryDefinitionsOutput {
    /// <p>
    /// A reference to a Cost Category containing enough information to identify the Cost Category.
    /// </p>
    pub cost_category_references:
        std::option::Option<std::vec::Vec<crate::model::CostCategoryReference>>,
    /// <p>
    /// The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
    /// </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListCostCategoryDefinitionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCostCategoryDefinitionsOutput");
        formatter.field("cost_category_references", &self.cost_category_references);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListCostCategoryDefinitionsOutput`](crate::output::ListCostCategoryDefinitionsOutput)
pub mod list_cost_category_definitions_output {
    /// A builder for [`ListCostCategoryDefinitionsOutput`](crate::output::ListCostCategoryDefinitionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_references:
            std::option::Option<std::vec::Vec<crate::model::CostCategoryReference>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cost_category_references`.
        ///
        /// To override the contents of this collection use [`set_cost_category_references`](Self::set_cost_category_references).
        ///
        /// <p>
        /// A reference to a Cost Category containing enough information to identify the Cost Category.
        /// </p>
        pub fn cost_category_references(
            mut self,
            input: impl Into<crate::model::CostCategoryReference>,
        ) -> Self {
            let mut v = self.cost_category_references.unwrap_or_default();
            v.push(input.into());
            self.cost_category_references = Some(v);
            self
        }
        /// <p>
        /// A reference to a Cost Category containing enough information to identify the Cost Category.
        /// </p>
        pub fn set_cost_category_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CostCategoryReference>>,
        ) -> Self {
            self.cost_category_references = input;
            self
        }
        /// <p>
        /// The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
        /// </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>
        /// The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCostCategoryDefinitionsOutput`](crate::output::ListCostCategoryDefinitionsOutput)
        pub fn build(self) -> crate::output::ListCostCategoryDefinitionsOutput {
            crate::output::ListCostCategoryDefinitionsOutput {
                cost_category_references: self.cost_category_references,
                next_token: self.next_token,
            }
        }
    }
}
impl ListCostCategoryDefinitionsOutput {
    /// Creates a new builder-style object to manufacture [`ListCostCategoryDefinitionsOutput`](crate::output::ListCostCategoryDefinitionsOutput)
    pub fn builder() -> crate::output::list_cost_category_definitions_output::Builder {
        crate::output::list_cost_category_definitions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsageForecastOutput {
    /// <p>How much you're forecasted to use over the forecast period.</p>
    pub total: std::option::Option<crate::model::MetricValue>,
    /// <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts,
    /// this is a list of months.</p>
    pub forecast_results_by_time: std::option::Option<std::vec::Vec<crate::model::ForecastResult>>,
}
impl std::fmt::Debug for GetUsageForecastOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsageForecastOutput");
        formatter.field("total", &self.total);
        formatter.field("forecast_results_by_time", &self.forecast_results_by_time);
        formatter.finish()
    }
}
/// See [`GetUsageForecastOutput`](crate::output::GetUsageForecastOutput)
pub mod get_usage_forecast_output {
    /// A builder for [`GetUsageForecastOutput`](crate::output::GetUsageForecastOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total: std::option::Option<crate::model::MetricValue>,
        pub(crate) forecast_results_by_time:
            std::option::Option<std::vec::Vec<crate::model::ForecastResult>>,
    }
    impl Builder {
        /// <p>How much you're forecasted to use over the forecast period.</p>
        pub fn total(mut self, input: crate::model::MetricValue) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>How much you're forecasted to use over the forecast period.</p>
        pub fn set_total(mut self, input: std::option::Option<crate::model::MetricValue>) -> Self {
            self.total = input;
            self
        }
        /// Appends an item to `forecast_results_by_time`.
        ///
        /// To override the contents of this collection use [`set_forecast_results_by_time`](Self::set_forecast_results_by_time).
        ///
        /// <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts,
        /// this is a list of months.</p>
        pub fn forecast_results_by_time(
            mut self,
            input: impl Into<crate::model::ForecastResult>,
        ) -> Self {
            let mut v = self.forecast_results_by_time.unwrap_or_default();
            v.push(input.into());
            self.forecast_results_by_time = Some(v);
            self
        }
        /// <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts,
        /// this is a list of months.</p>
        pub fn set_forecast_results_by_time(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ForecastResult>>,
        ) -> Self {
            self.forecast_results_by_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsageForecastOutput`](crate::output::GetUsageForecastOutput)
        pub fn build(self) -> crate::output::GetUsageForecastOutput {
            crate::output::GetUsageForecastOutput {
                total: self.total,
                forecast_results_by_time: self.forecast_results_by_time,
            }
        }
    }
}
impl GetUsageForecastOutput {
    /// Creates a new builder-style object to manufacture [`GetUsageForecastOutput`](crate::output::GetUsageForecastOutput)
    pub fn builder() -> crate::output::get_usage_forecast_output::Builder {
        crate::output::get_usage_forecast_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTagsOutput {
    /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The tags that match your request.</p>
    pub tags: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of query results that Amazon Web Services returns at a time.</p>
    pub return_size: std::option::Option<i32>,
    /// <p>The total number of query results.</p>
    pub total_size: std::option::Option<i32>,
}
impl std::fmt::Debug for GetTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTagsOutput");
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("tags", &self.tags);
        formatter.field("return_size", &self.return_size);
        formatter.field("total_size", &self.total_size);
        formatter.finish()
    }
}
/// See [`GetTagsOutput`](crate::output::GetTagsOutput)
pub mod get_tags_output {
    /// A builder for [`GetTagsOutput`](crate::output::GetTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) return_size: std::option::Option<i32>,
        pub(crate) total_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that match your request.</p>
        pub fn tags(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The tags that match your request.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The number of query results that Amazon Web Services returns at a time.</p>
        pub fn return_size(mut self, input: i32) -> Self {
            self.return_size = Some(input);
            self
        }
        /// <p>The number of query results that Amazon Web Services returns at a time.</p>
        pub fn set_return_size(mut self, input: std::option::Option<i32>) -> Self {
            self.return_size = input;
            self
        }
        /// <p>The total number of query results.</p>
        pub fn total_size(mut self, input: i32) -> Self {
            self.total_size = Some(input);
            self
        }
        /// <p>The total number of query results.</p>
        pub fn set_total_size(mut self, input: std::option::Option<i32>) -> Self {
            self.total_size = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTagsOutput`](crate::output::GetTagsOutput)
        pub fn build(self) -> crate::output::GetTagsOutput {
            crate::output::GetTagsOutput {
                next_page_token: self.next_page_token,
                tags: self.tags,
                return_size: self.return_size,
                total_size: self.total_size,
            }
        }
    }
}
impl GetTagsOutput {
    /// Creates a new builder-style object to manufacture [`GetTagsOutput`](crate::output::GetTagsOutput)
    pub fn builder() -> crate::output::get_tags_output::Builder {
        crate::output::get_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansUtilizationDetailsOutput {
    /// <p>Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.</p>
    pub savings_plans_utilization_details:
        std::option::Option<std::vec::Vec<crate::model::SavingsPlansUtilizationDetail>>,
    /// <p>The total Savings Plans utilization, regardless of time period.</p>
    pub total: std::option::Option<crate::model::SavingsPlansUtilizationAggregates>,
    /// <p>The time period of the request. </p>
    pub time_period: std::option::Option<crate::model::DateInterval>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSavingsPlansUtilizationDetailsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansUtilizationDetailsOutput");
        formatter.field(
            "savings_plans_utilization_details",
            &self.savings_plans_utilization_details,
        );
        formatter.field("total", &self.total);
        formatter.field("time_period", &self.time_period);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSavingsPlansUtilizationDetailsOutput`](crate::output::GetSavingsPlansUtilizationDetailsOutput)
pub mod get_savings_plans_utilization_details_output {
    /// A builder for [`GetSavingsPlansUtilizationDetailsOutput`](crate::output::GetSavingsPlansUtilizationDetailsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plans_utilization_details:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlansUtilizationDetail>>,
        pub(crate) total: std::option::Option<crate::model::SavingsPlansUtilizationAggregates>,
        pub(crate) time_period: std::option::Option<crate::model::DateInterval>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `savings_plans_utilization_details`.
        ///
        /// To override the contents of this collection use [`set_savings_plans_utilization_details`](Self::set_savings_plans_utilization_details).
        ///
        /// <p>Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.</p>
        pub fn savings_plans_utilization_details(
            mut self,
            input: impl Into<crate::model::SavingsPlansUtilizationDetail>,
        ) -> Self {
            let mut v = self.savings_plans_utilization_details.unwrap_or_default();
            v.push(input.into());
            self.savings_plans_utilization_details = Some(v);
            self
        }
        /// <p>Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.</p>
        pub fn set_savings_plans_utilization_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlansUtilizationDetail>>,
        ) -> Self {
            self.savings_plans_utilization_details = input;
            self
        }
        /// <p>The total Savings Plans utilization, regardless of time period.</p>
        pub fn total(mut self, input: crate::model::SavingsPlansUtilizationAggregates) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total Savings Plans utilization, regardless of time period.</p>
        pub fn set_total(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansUtilizationAggregates>,
        ) -> Self {
            self.total = input;
            self
        }
        /// <p>The time period of the request. </p>
        pub fn time_period(mut self, input: crate::model::DateInterval) -> Self {
            self.time_period = Some(input);
            self
        }
        /// <p>The time period of the request. </p>
        pub fn set_time_period(
            mut self,
            input: std::option::Option<crate::model::DateInterval>,
        ) -> Self {
            self.time_period = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansUtilizationDetailsOutput`](crate::output::GetSavingsPlansUtilizationDetailsOutput)
        pub fn build(self) -> crate::output::GetSavingsPlansUtilizationDetailsOutput {
            crate::output::GetSavingsPlansUtilizationDetailsOutput {
                savings_plans_utilization_details: self.savings_plans_utilization_details,
                total: self.total,
                time_period: self.time_period,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSavingsPlansUtilizationDetailsOutput {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansUtilizationDetailsOutput`](crate::output::GetSavingsPlansUtilizationDetailsOutput)
    pub fn builder() -> crate::output::get_savings_plans_utilization_details_output::Builder {
        crate::output::get_savings_plans_utilization_details_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansUtilizationOutput {
    /// <p>The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.</p>
    pub savings_plans_utilizations_by_time:
        std::option::Option<std::vec::Vec<crate::model::SavingsPlansUtilizationByTime>>,
    /// <p>The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.</p>
    pub total: std::option::Option<crate::model::SavingsPlansUtilizationAggregates>,
}
impl std::fmt::Debug for GetSavingsPlansUtilizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansUtilizationOutput");
        formatter.field(
            "savings_plans_utilizations_by_time",
            &self.savings_plans_utilizations_by_time,
        );
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`GetSavingsPlansUtilizationOutput`](crate::output::GetSavingsPlansUtilizationOutput)
pub mod get_savings_plans_utilization_output {
    /// A builder for [`GetSavingsPlansUtilizationOutput`](crate::output::GetSavingsPlansUtilizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plans_utilizations_by_time:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlansUtilizationByTime>>,
        pub(crate) total: std::option::Option<crate::model::SavingsPlansUtilizationAggregates>,
    }
    impl Builder {
        /// Appends an item to `savings_plans_utilizations_by_time`.
        ///
        /// To override the contents of this collection use [`set_savings_plans_utilizations_by_time`](Self::set_savings_plans_utilizations_by_time).
        ///
        /// <p>The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.</p>
        pub fn savings_plans_utilizations_by_time(
            mut self,
            input: impl Into<crate::model::SavingsPlansUtilizationByTime>,
        ) -> Self {
            let mut v = self.savings_plans_utilizations_by_time.unwrap_or_default();
            v.push(input.into());
            self.savings_plans_utilizations_by_time = Some(v);
            self
        }
        /// <p>The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.</p>
        pub fn set_savings_plans_utilizations_by_time(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlansUtilizationByTime>>,
        ) -> Self {
            self.savings_plans_utilizations_by_time = input;
            self
        }
        /// <p>The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.</p>
        pub fn total(mut self, input: crate::model::SavingsPlansUtilizationAggregates) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.</p>
        pub fn set_total(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansUtilizationAggregates>,
        ) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansUtilizationOutput`](crate::output::GetSavingsPlansUtilizationOutput)
        pub fn build(self) -> crate::output::GetSavingsPlansUtilizationOutput {
            crate::output::GetSavingsPlansUtilizationOutput {
                savings_plans_utilizations_by_time: self.savings_plans_utilizations_by_time,
                total: self.total,
            }
        }
    }
}
impl GetSavingsPlansUtilizationOutput {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansUtilizationOutput`](crate::output::GetSavingsPlansUtilizationOutput)
    pub fn builder() -> crate::output::get_savings_plans_utilization_output::Builder {
        crate::output::get_savings_plans_utilization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansPurchaseRecommendationOutput {
    /// <p>Information regarding this specific recommendation set.</p>
    pub metadata: std::option::Option<crate::model::SavingsPlansPurchaseRecommendationMetadata>,
    /// <p>Contains your request parameters, Savings Plan Recommendations Summary, and Details.</p>
    pub savings_plans_purchase_recommendation:
        std::option::Option<crate::model::SavingsPlansPurchaseRecommendation>,
    /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSavingsPlansPurchaseRecommendationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansPurchaseRecommendationOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field(
            "savings_plans_purchase_recommendation",
            &self.savings_plans_purchase_recommendation,
        );
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetSavingsPlansPurchaseRecommendationOutput`](crate::output::GetSavingsPlansPurchaseRecommendationOutput)
pub mod get_savings_plans_purchase_recommendation_output {
    /// A builder for [`GetSavingsPlansPurchaseRecommendationOutput`](crate::output::GetSavingsPlansPurchaseRecommendationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata:
            std::option::Option<crate::model::SavingsPlansPurchaseRecommendationMetadata>,
        pub(crate) savings_plans_purchase_recommendation:
            std::option::Option<crate::model::SavingsPlansPurchaseRecommendation>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information regarding this specific recommendation set.</p>
        pub fn metadata(
            mut self,
            input: crate::model::SavingsPlansPurchaseRecommendationMetadata,
        ) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>Information regarding this specific recommendation set.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansPurchaseRecommendationMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>Contains your request parameters, Savings Plan Recommendations Summary, and Details.</p>
        pub fn savings_plans_purchase_recommendation(
            mut self,
            input: crate::model::SavingsPlansPurchaseRecommendation,
        ) -> Self {
            self.savings_plans_purchase_recommendation = Some(input);
            self
        }
        /// <p>Contains your request parameters, Savings Plan Recommendations Summary, and Details.</p>
        pub fn set_savings_plans_purchase_recommendation(
            mut self,
            input: std::option::Option<crate::model::SavingsPlansPurchaseRecommendation>,
        ) -> Self {
            self.savings_plans_purchase_recommendation = input;
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansPurchaseRecommendationOutput`](crate::output::GetSavingsPlansPurchaseRecommendationOutput)
        pub fn build(self) -> crate::output::GetSavingsPlansPurchaseRecommendationOutput {
            crate::output::GetSavingsPlansPurchaseRecommendationOutput {
                metadata: self.metadata,
                savings_plans_purchase_recommendation: self.savings_plans_purchase_recommendation,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetSavingsPlansPurchaseRecommendationOutput {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansPurchaseRecommendationOutput`](crate::output::GetSavingsPlansPurchaseRecommendationOutput)
    pub fn builder() -> crate::output::get_savings_plans_purchase_recommendation_output::Builder {
        crate::output::get_savings_plans_purchase_recommendation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetSavingsPlansCoverageOutput {
    /// <p>The amount of spend that your Savings Plans covered.</p>
    pub savings_plans_coverages:
        std::option::Option<std::vec::Vec<crate::model::SavingsPlansCoverage>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetSavingsPlansCoverageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetSavingsPlansCoverageOutput");
        formatter.field("savings_plans_coverages", &self.savings_plans_coverages);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetSavingsPlansCoverageOutput`](crate::output::GetSavingsPlansCoverageOutput)
pub mod get_savings_plans_coverage_output {
    /// A builder for [`GetSavingsPlansCoverageOutput`](crate::output::GetSavingsPlansCoverageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) savings_plans_coverages:
            std::option::Option<std::vec::Vec<crate::model::SavingsPlansCoverage>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `savings_plans_coverages`.
        ///
        /// To override the contents of this collection use [`set_savings_plans_coverages`](Self::set_savings_plans_coverages).
        ///
        /// <p>The amount of spend that your Savings Plans covered.</p>
        pub fn savings_plans_coverages(
            mut self,
            input: impl Into<crate::model::SavingsPlansCoverage>,
        ) -> Self {
            let mut v = self.savings_plans_coverages.unwrap_or_default();
            v.push(input.into());
            self.savings_plans_coverages = Some(v);
            self
        }
        /// <p>The amount of spend that your Savings Plans covered.</p>
        pub fn set_savings_plans_coverages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SavingsPlansCoverage>>,
        ) -> Self {
            self.savings_plans_coverages = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetSavingsPlansCoverageOutput`](crate::output::GetSavingsPlansCoverageOutput)
        pub fn build(self) -> crate::output::GetSavingsPlansCoverageOutput {
            crate::output::GetSavingsPlansCoverageOutput {
                savings_plans_coverages: self.savings_plans_coverages,
                next_token: self.next_token,
            }
        }
    }
}
impl GetSavingsPlansCoverageOutput {
    /// Creates a new builder-style object to manufacture [`GetSavingsPlansCoverageOutput`](crate::output::GetSavingsPlansCoverageOutput)
    pub fn builder() -> crate::output::get_savings_plans_coverage_output::Builder {
        crate::output::get_savings_plans_coverage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetRightsizingRecommendationOutput {
    /// <p>Information regarding this specific recommendation set.</p>
    pub metadata: std::option::Option<crate::model::RightsizingRecommendationMetadata>,
    /// <p>Summary of this recommendation set.</p>
    pub summary: std::option::Option<crate::model::RightsizingRecommendationSummary>,
    /// <p>Recommendations to rightsize resources.</p>
    pub rightsizing_recommendations:
        std::option::Option<std::vec::Vec<crate::model::RightsizingRecommendation>>,
    /// <p>The token to retrieve the next set of results.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p> Enables you to customize recommendations across two attributes. You can choose to view
    /// recommendations for instances within the same instance families or across different instance
    /// families. You can also choose to view your estimated savings associated with recommendations
    /// with consideration of existing Savings Plans or RI benefits, or
    /// neither. </p>
    pub configuration: std::option::Option<crate::model::RightsizingRecommendationConfiguration>,
}
impl std::fmt::Debug for GetRightsizingRecommendationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetRightsizingRecommendationOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("summary", &self.summary);
        formatter.field(
            "rightsizing_recommendations",
            &self.rightsizing_recommendations,
        );
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}
/// See [`GetRightsizingRecommendationOutput`](crate::output::GetRightsizingRecommendationOutput)
pub mod get_rightsizing_recommendation_output {
    /// A builder for [`GetRightsizingRecommendationOutput`](crate::output::GetRightsizingRecommendationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata: std::option::Option<crate::model::RightsizingRecommendationMetadata>,
        pub(crate) summary: std::option::Option<crate::model::RightsizingRecommendationSummary>,
        pub(crate) rightsizing_recommendations:
            std::option::Option<std::vec::Vec<crate::model::RightsizingRecommendation>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) configuration:
            std::option::Option<crate::model::RightsizingRecommendationConfiguration>,
    }
    impl Builder {
        /// <p>Information regarding this specific recommendation set.</p>
        pub fn metadata(mut self, input: crate::model::RightsizingRecommendationMetadata) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>Information regarding this specific recommendation set.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::RightsizingRecommendationMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// <p>Summary of this recommendation set.</p>
        pub fn summary(mut self, input: crate::model::RightsizingRecommendationSummary) -> Self {
            self.summary = Some(input);
            self
        }
        /// <p>Summary of this recommendation set.</p>
        pub fn set_summary(
            mut self,
            input: std::option::Option<crate::model::RightsizingRecommendationSummary>,
        ) -> Self {
            self.summary = input;
            self
        }
        /// Appends an item to `rightsizing_recommendations`.
        ///
        /// To override the contents of this collection use [`set_rightsizing_recommendations`](Self::set_rightsizing_recommendations).
        ///
        /// <p>Recommendations to rightsize resources.</p>
        pub fn rightsizing_recommendations(
            mut self,
            input: impl Into<crate::model::RightsizingRecommendation>,
        ) -> Self {
            let mut v = self.rightsizing_recommendations.unwrap_or_default();
            v.push(input.into());
            self.rightsizing_recommendations = Some(v);
            self
        }
        /// <p>Recommendations to rightsize resources.</p>
        pub fn set_rightsizing_recommendations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RightsizingRecommendation>>,
        ) -> Self {
            self.rightsizing_recommendations = input;
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// <p> Enables you to customize recommendations across two attributes. You can choose to view
        /// recommendations for instances within the same instance families or across different instance
        /// families. You can also choose to view your estimated savings associated with recommendations
        /// with consideration of existing Savings Plans or RI benefits, or
        /// neither. </p>
        pub fn configuration(
            mut self,
            input: crate::model::RightsizingRecommendationConfiguration,
        ) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p> Enables you to customize recommendations across two attributes. You can choose to view
        /// recommendations for instances within the same instance families or across different instance
        /// families. You can also choose to view your estimated savings associated with recommendations
        /// with consideration of existing Savings Plans or RI benefits, or
        /// neither. </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::RightsizingRecommendationConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetRightsizingRecommendationOutput`](crate::output::GetRightsizingRecommendationOutput)
        pub fn build(self) -> crate::output::GetRightsizingRecommendationOutput {
            crate::output::GetRightsizingRecommendationOutput {
                metadata: self.metadata,
                summary: self.summary,
                rightsizing_recommendations: self.rightsizing_recommendations,
                next_page_token: self.next_page_token,
                configuration: self.configuration,
            }
        }
    }
}
impl GetRightsizingRecommendationOutput {
    /// Creates a new builder-style object to manufacture [`GetRightsizingRecommendationOutput`](crate::output::GetRightsizingRecommendationOutput)
    pub fn builder() -> crate::output::get_rightsizing_recommendation_output::Builder {
        crate::output::get_rightsizing_recommendation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservationUtilizationOutput {
    /// <p>The amount of time that you used your RIs.</p>
    pub utilizations_by_time: std::option::Option<std::vec::Vec<crate::model::UtilizationByTime>>,
    /// <p>The total amount of time that you used your RIs.</p>
    pub total: std::option::Option<crate::model::ReservationAggregates>,
    /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetReservationUtilizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservationUtilizationOutput");
        formatter.field("utilizations_by_time", &self.utilizations_by_time);
        formatter.field("total", &self.total);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetReservationUtilizationOutput`](crate::output::GetReservationUtilizationOutput)
pub mod get_reservation_utilization_output {
    /// A builder for [`GetReservationUtilizationOutput`](crate::output::GetReservationUtilizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) utilizations_by_time:
            std::option::Option<std::vec::Vec<crate::model::UtilizationByTime>>,
        pub(crate) total: std::option::Option<crate::model::ReservationAggregates>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `utilizations_by_time`.
        ///
        /// To override the contents of this collection use [`set_utilizations_by_time`](Self::set_utilizations_by_time).
        ///
        /// <p>The amount of time that you used your RIs.</p>
        pub fn utilizations_by_time(
            mut self,
            input: impl Into<crate::model::UtilizationByTime>,
        ) -> Self {
            let mut v = self.utilizations_by_time.unwrap_or_default();
            v.push(input.into());
            self.utilizations_by_time = Some(v);
            self
        }
        /// <p>The amount of time that you used your RIs.</p>
        pub fn set_utilizations_by_time(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UtilizationByTime>>,
        ) -> Self {
            self.utilizations_by_time = input;
            self
        }
        /// <p>The total amount of time that you used your RIs.</p>
        pub fn total(mut self, input: crate::model::ReservationAggregates) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total amount of time that you used your RIs.</p>
        pub fn set_total(
            mut self,
            input: std::option::Option<crate::model::ReservationAggregates>,
        ) -> Self {
            self.total = input;
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservationUtilizationOutput`](crate::output::GetReservationUtilizationOutput)
        pub fn build(self) -> crate::output::GetReservationUtilizationOutput {
            crate::output::GetReservationUtilizationOutput {
                utilizations_by_time: self.utilizations_by_time,
                total: self.total,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetReservationUtilizationOutput {
    /// Creates a new builder-style object to manufacture [`GetReservationUtilizationOutput`](crate::output::GetReservationUtilizationOutput)
    pub fn builder() -> crate::output::get_reservation_utilization_output::Builder {
        crate::output::get_reservation_utilization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservationPurchaseRecommendationOutput {
    /// <p>Information about this specific recommendation call, such as the time stamp for when Cost Explorer generated this recommendation.</p>
    pub metadata: std::option::Option<crate::model::ReservationPurchaseRecommendationMetadata>,
    /// <p>Recommendations for reservations to purchase.</p>
    pub recommendations:
        std::option::Option<std::vec::Vec<crate::model::ReservationPurchaseRecommendation>>,
    /// <p>The pagination token for the next set of retrievable results.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetReservationPurchaseRecommendationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservationPurchaseRecommendationOutput");
        formatter.field("metadata", &self.metadata);
        formatter.field("recommendations", &self.recommendations);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetReservationPurchaseRecommendationOutput`](crate::output::GetReservationPurchaseRecommendationOutput)
pub mod get_reservation_purchase_recommendation_output {
    /// A builder for [`GetReservationPurchaseRecommendationOutput`](crate::output::GetReservationPurchaseRecommendationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) metadata:
            std::option::Option<crate::model::ReservationPurchaseRecommendationMetadata>,
        pub(crate) recommendations:
            std::option::Option<std::vec::Vec<crate::model::ReservationPurchaseRecommendation>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Information about this specific recommendation call, such as the time stamp for when Cost Explorer generated this recommendation.</p>
        pub fn metadata(
            mut self,
            input: crate::model::ReservationPurchaseRecommendationMetadata,
        ) -> Self {
            self.metadata = Some(input);
            self
        }
        /// <p>Information about this specific recommendation call, such as the time stamp for when Cost Explorer generated this recommendation.</p>
        pub fn set_metadata(
            mut self,
            input: std::option::Option<crate::model::ReservationPurchaseRecommendationMetadata>,
        ) -> Self {
            self.metadata = input;
            self
        }
        /// Appends an item to `recommendations`.
        ///
        /// To override the contents of this collection use [`set_recommendations`](Self::set_recommendations).
        ///
        /// <p>Recommendations for reservations to purchase.</p>
        pub fn recommendations(
            mut self,
            input: impl Into<crate::model::ReservationPurchaseRecommendation>,
        ) -> Self {
            let mut v = self.recommendations.unwrap_or_default();
            v.push(input.into());
            self.recommendations = Some(v);
            self
        }
        /// <p>Recommendations for reservations to purchase.</p>
        pub fn set_recommendations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReservationPurchaseRecommendation>,
            >,
        ) -> Self {
            self.recommendations = input;
            self
        }
        /// <p>The pagination token for the next set of retrievable results.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The pagination token for the next set of retrievable results.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservationPurchaseRecommendationOutput`](crate::output::GetReservationPurchaseRecommendationOutput)
        pub fn build(self) -> crate::output::GetReservationPurchaseRecommendationOutput {
            crate::output::GetReservationPurchaseRecommendationOutput {
                metadata: self.metadata,
                recommendations: self.recommendations,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetReservationPurchaseRecommendationOutput {
    /// Creates a new builder-style object to manufacture [`GetReservationPurchaseRecommendationOutput`](crate::output::GetReservationPurchaseRecommendationOutput)
    pub fn builder() -> crate::output::get_reservation_purchase_recommendation_output::Builder {
        crate::output::get_reservation_purchase_recommendation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservationCoverageOutput {
    /// <p>The amount of time that your reservations covered.</p>
    pub coverages_by_time: std::option::Option<std::vec::Vec<crate::model::CoverageByTime>>,
    /// <p>The total amount of instance usage that a reservation covered.</p>
    pub total: std::option::Option<crate::model::Coverage>,
    /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetReservationCoverageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservationCoverageOutput");
        formatter.field("coverages_by_time", &self.coverages_by_time);
        formatter.field("total", &self.total);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetReservationCoverageOutput`](crate::output::GetReservationCoverageOutput)
pub mod get_reservation_coverage_output {
    /// A builder for [`GetReservationCoverageOutput`](crate::output::GetReservationCoverageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) coverages_by_time:
            std::option::Option<std::vec::Vec<crate::model::CoverageByTime>>,
        pub(crate) total: std::option::Option<crate::model::Coverage>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `coverages_by_time`.
        ///
        /// To override the contents of this collection use [`set_coverages_by_time`](Self::set_coverages_by_time).
        ///
        /// <p>The amount of time that your reservations covered.</p>
        pub fn coverages_by_time(mut self, input: impl Into<crate::model::CoverageByTime>) -> Self {
            let mut v = self.coverages_by_time.unwrap_or_default();
            v.push(input.into());
            self.coverages_by_time = Some(v);
            self
        }
        /// <p>The amount of time that your reservations covered.</p>
        pub fn set_coverages_by_time(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CoverageByTime>>,
        ) -> Self {
            self.coverages_by_time = input;
            self
        }
        /// <p>The total amount of instance usage that a reservation covered.</p>
        pub fn total(mut self, input: crate::model::Coverage) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total amount of instance usage that a reservation covered.</p>
        pub fn set_total(mut self, input: std::option::Option<crate::model::Coverage>) -> Self {
            self.total = input;
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservationCoverageOutput`](crate::output::GetReservationCoverageOutput)
        pub fn build(self) -> crate::output::GetReservationCoverageOutput {
            crate::output::GetReservationCoverageOutput {
                coverages_by_time: self.coverages_by_time,
                total: self.total,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetReservationCoverageOutput {
    /// Creates a new builder-style object to manufacture [`GetReservationCoverageOutput`](crate::output::GetReservationCoverageOutput)
    pub fn builder() -> crate::output::get_reservation_coverage_output::Builder {
        crate::output::get_reservation_coverage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDimensionValuesOutput {
    /// <p>The filters that you used to filter your request. Some dimensions are available only for a specific context.</p>
    /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following
    /// dimensions for searching:</p>
    /// <ul>
    /// <li>
    /// <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p>
    /// </li>
    /// <li>
    /// <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p>
    /// </li>
    /// <li>
    /// <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p>
    /// </li>
    /// <li>
    /// <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p>
    /// </li>
    /// <li>
    /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
    /// field contains the Amazon Web Services ID of the member account.</p>
    /// </li>
    /// <li>
    /// <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p>
    /// </li>
    /// <li>
    /// <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p>
    /// </li>
    /// <li>
    /// <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p>
    /// </li>
    /// <li>
    /// <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
    /// Instances and Standard Reserved Instances.</p>
    /// </li>
    /// <li>
    /// <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p>
    /// </li>
    /// <li>
    /// <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation
    /// includes a unit attribute. Examples include GB and Hrs.</p>
    /// </li>
    /// <li>
    /// <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this
    /// operation includes a unit attribute.</p>
    /// </li>
    /// <li>
    /// <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p>
    /// </li>
    /// <li>
    /// <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p>
    /// </li>
    /// </ul>
    /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following
    /// dimensions for searching:</p>
    /// <ul>
    /// <li>
    /// <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p>
    /// </li>
    /// <li>
    /// <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p>
    /// </li>
    /// <li>
    /// <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p>
    /// </li>
    /// <li>
    /// <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p>
    /// </li>
    /// <li>
    /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
    /// field contains the Amazon Web Services ID of the member account.</p>
    /// </li>
    /// <li>
    /// <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p>
    /// </li>
    /// <li>
    /// <p>REGION - The Amazon Web Services Region.</p>
    /// </li>
    /// <li>
    /// <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p>
    /// </li>
    /// <li>
    /// <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p>
    /// </li>
    /// <li>
    /// <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p>
    /// </li>
    /// </ul>
    /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
    /// <ul>
    /// <li>
    /// <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p>
    /// </li>
    /// <li>
    /// <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p>
    /// </li>
    /// <li>
    /// <p>REGION - The Amazon Web Services Region.</p>
    /// </li>
    /// <li>
    /// <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p>
    /// </li>
    /// <li>
    /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
    /// field contains the Amazon Web Services ID of the member account.</p>
    /// </li>
    /// <li>
    /// <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p>
    /// </li>
    /// </ul>
    pub dimension_values:
        std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
    /// <p>The number of results that Amazon Web Services returned at one time.</p>
    pub return_size: std::option::Option<i32>,
    /// <p>The total number of search results.</p>
    pub total_size: std::option::Option<i32>,
    /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetDimensionValuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDimensionValuesOutput");
        formatter.field("dimension_values", &self.dimension_values);
        formatter.field("return_size", &self.return_size);
        formatter.field("total_size", &self.total_size);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetDimensionValuesOutput`](crate::output::GetDimensionValuesOutput)
pub mod get_dimension_values_output {
    /// A builder for [`GetDimensionValuesOutput`](crate::output::GetDimensionValuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dimension_values:
            std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
        pub(crate) return_size: std::option::Option<i32>,
        pub(crate) total_size: std::option::Option<i32>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dimension_values`.
        ///
        /// To override the contents of this collection use [`set_dimension_values`](Self::set_dimension_values).
        ///
        /// <p>The filters that you used to filter your request. Some dimensions are available only for a specific context.</p>
        /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following
        /// dimensions for searching:</p>
        /// <ul>
        /// <li>
        /// <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p>
        /// </li>
        /// <li>
        /// <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p>
        /// </li>
        /// <li>
        /// <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
        /// field contains the Amazon Web Services ID of the member account.</p>
        /// </li>
        /// <li>
        /// <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
        /// Instances and Standard Reserved Instances.</p>
        /// </li>
        /// <li>
        /// <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p>
        /// </li>
        /// <li>
        /// <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation
        /// includes a unit attribute. Examples include GB and Hrs.</p>
        /// </li>
        /// <li>
        /// <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this
        /// operation includes a unit attribute.</p>
        /// </li>
        /// <li>
        /// <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p>
        /// </li>
        /// <li>
        /// <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p>
        /// </li>
        /// </ul>
        /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following
        /// dimensions for searching:</p>
        /// <ul>
        /// <li>
        /// <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p>
        /// </li>
        /// <li>
        /// <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p>
        /// </li>
        /// <li>
        /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
        /// field contains the Amazon Web Services ID of the member account.</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>REGION - The Amazon Web Services Region.</p>
        /// </li>
        /// <li>
        /// <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p>
        /// </li>
        /// <li>
        /// <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p>
        /// </li>
        /// <li>
        /// <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p>
        /// </li>
        /// </ul>
        /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li>
        /// <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p>
        /// </li>
        /// <li>
        /// <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p>
        /// </li>
        /// <li>
        /// <p>REGION - The Amazon Web Services Region.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p>
        /// </li>
        /// <li>
        /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
        /// field contains the Amazon Web Services ID of the member account.</p>
        /// </li>
        /// <li>
        /// <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p>
        /// </li>
        /// </ul>
        pub fn dimension_values(
            mut self,
            input: impl Into<crate::model::DimensionValuesWithAttributes>,
        ) -> Self {
            let mut v = self.dimension_values.unwrap_or_default();
            v.push(input.into());
            self.dimension_values = Some(v);
            self
        }
        /// <p>The filters that you used to filter your request. Some dimensions are available only for a specific context.</p>
        /// <p>If you set the context to <code>COST_AND_USAGE</code>, you can use the following
        /// dimensions for searching:</p>
        /// <ul>
        /// <li>
        /// <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p>
        /// </li>
        /// <li>
        /// <p>DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p>
        /// </li>
        /// <li>
        /// <p>LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web Services.</p>
        /// </li>
        /// <li>
        /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
        /// field contains the Amazon Web Services ID of the member account.</p>
        /// </li>
        /// <li>
        /// <p>OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
        /// Instances and Standard Reserved Instances.</p>
        /// </li>
        /// <li>
        /// <p>SERVICE - The Amazon Web Services service such as Amazon DynamoDB.</p>
        /// </li>
        /// <li>
        /// <p>USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the <code>GetDimensionValues</code> operation
        /// includes a unit attribute. Examples include GB and Hrs.</p>
        /// </li>
        /// <li>
        /// <p>USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The response for this
        /// operation includes a unit attribute.</p>
        /// </li>
        /// <li>
        /// <p>RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.</p>
        /// </li>
        /// <li>
        /// <p>RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14 days for EC2-Compute Service.</p>
        /// </li>
        /// </ul>
        /// <p>If you set the context to <code>RESERVATIONS</code>, you can use the following
        /// dimensions for searching:</p>
        /// <ul>
        /// <li>
        /// <p>AZ - The Availability Zone. An example is <code>us-east-1a</code>.</p>
        /// </li>
        /// <li>
        /// <p>CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are <code>SingleAZ</code> and <code>MultiAZ</code>.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.</p>
        /// </li>
        /// <li>
        /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
        /// field contains the Amazon Web Services ID of the member account.</p>
        /// </li>
        /// <li>
        /// <p>PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.</p>
        /// </li>
        /// <li>
        /// <p>REGION - The Amazon Web Services Region.</p>
        /// </li>
        /// <li>
        /// <p>SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability Zone.</p>
        /// </li>
        /// <li>
        /// <p>TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).</p>
        /// </li>
        /// <li>
        /// <p>TENANCY - The tenancy of a resource. Examples are shared or dedicated.</p>
        /// </li>
        /// </ul>
        /// <p>If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:</p>
        /// <ul>
        /// <li>
        /// <p>SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)</p>
        /// </li>
        /// <li>
        /// <p>PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)</p>
        /// </li>
        /// <li>
        /// <p>REGION - The Amazon Web Services Region.</p>
        /// </li>
        /// <li>
        /// <p>INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)</p>
        /// </li>
        /// <li>
        /// <p>LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The value
        /// field contains the Amazon Web Services ID of the member account.</p>
        /// </li>
        /// <li>
        /// <p>SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan</p>
        /// </li>
        /// </ul>
        pub fn set_dimension_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
        ) -> Self {
            self.dimension_values = input;
            self
        }
        /// <p>The number of results that Amazon Web Services returned at one time.</p>
        pub fn return_size(mut self, input: i32) -> Self {
            self.return_size = Some(input);
            self
        }
        /// <p>The number of results that Amazon Web Services returned at one time.</p>
        pub fn set_return_size(mut self, input: std::option::Option<i32>) -> Self {
            self.return_size = input;
            self
        }
        /// <p>The total number of search results.</p>
        pub fn total_size(mut self, input: i32) -> Self {
            self.total_size = Some(input);
            self
        }
        /// <p>The total number of search results.</p>
        pub fn set_total_size(mut self, input: std::option::Option<i32>) -> Self {
            self.total_size = input;
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDimensionValuesOutput`](crate::output::GetDimensionValuesOutput)
        pub fn build(self) -> crate::output::GetDimensionValuesOutput {
            crate::output::GetDimensionValuesOutput {
                dimension_values: self.dimension_values,
                return_size: self.return_size,
                total_size: self.total_size,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetDimensionValuesOutput {
    /// Creates a new builder-style object to manufacture [`GetDimensionValuesOutput`](crate::output::GetDimensionValuesOutput)
    pub fn builder() -> crate::output::get_dimension_values_output::Builder {
        crate::output::get_dimension_values_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostForecastOutput {
    /// <p>How much you are forecasted to spend over the forecast period, in <code>USD</code>.</p>
    pub total: std::option::Option<crate::model::MetricValue>,
    /// <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts,
    /// this is a list of months.</p>
    pub forecast_results_by_time: std::option::Option<std::vec::Vec<crate::model::ForecastResult>>,
}
impl std::fmt::Debug for GetCostForecastOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostForecastOutput");
        formatter.field("total", &self.total);
        formatter.field("forecast_results_by_time", &self.forecast_results_by_time);
        formatter.finish()
    }
}
/// See [`GetCostForecastOutput`](crate::output::GetCostForecastOutput)
pub mod get_cost_forecast_output {
    /// A builder for [`GetCostForecastOutput`](crate::output::GetCostForecastOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total: std::option::Option<crate::model::MetricValue>,
        pub(crate) forecast_results_by_time:
            std::option::Option<std::vec::Vec<crate::model::ForecastResult>>,
    }
    impl Builder {
        /// <p>How much you are forecasted to spend over the forecast period, in <code>USD</code>.</p>
        pub fn total(mut self, input: crate::model::MetricValue) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>How much you are forecasted to spend over the forecast period, in <code>USD</code>.</p>
        pub fn set_total(mut self, input: std::option::Option<crate::model::MetricValue>) -> Self {
            self.total = input;
            self
        }
        /// Appends an item to `forecast_results_by_time`.
        ///
        /// To override the contents of this collection use [`set_forecast_results_by_time`](Self::set_forecast_results_by_time).
        ///
        /// <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts,
        /// this is a list of months.</p>
        pub fn forecast_results_by_time(
            mut self,
            input: impl Into<crate::model::ForecastResult>,
        ) -> Self {
            let mut v = self.forecast_results_by_time.unwrap_or_default();
            v.push(input.into());
            self.forecast_results_by_time = Some(v);
            self
        }
        /// <p>The forecasts for your query, in order. For <code>DAILY</code> forecasts, this is a list of days. For <code>MONTHLY</code> forecasts,
        /// this is a list of months.</p>
        pub fn set_forecast_results_by_time(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ForecastResult>>,
        ) -> Self {
            self.forecast_results_by_time = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostForecastOutput`](crate::output::GetCostForecastOutput)
        pub fn build(self) -> crate::output::GetCostForecastOutput {
            crate::output::GetCostForecastOutput {
                total: self.total,
                forecast_results_by_time: self.forecast_results_by_time,
            }
        }
    }
}
impl GetCostForecastOutput {
    /// Creates a new builder-style object to manufacture [`GetCostForecastOutput`](crate::output::GetCostForecastOutput)
    pub fn builder() -> crate::output::get_cost_forecast_output::Builder {
        crate::output::get_cost_forecast_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostCategoriesOutput {
    /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The names of the Cost Categories.</p>
    pub cost_category_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Cost Category values.</p>
    /// <p>
    /// <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the request. </p>
    pub cost_category_values: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of objects returned.</p>
    pub return_size: std::option::Option<i32>,
    /// <p>The total number of objects.</p>
    pub total_size: std::option::Option<i32>,
}
impl std::fmt::Debug for GetCostCategoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostCategoriesOutput");
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("cost_category_names", &self.cost_category_names);
        formatter.field("cost_category_values", &self.cost_category_values);
        formatter.field("return_size", &self.return_size);
        formatter.field("total_size", &self.total_size);
        formatter.finish()
    }
}
/// See [`GetCostCategoriesOutput`](crate::output::GetCostCategoriesOutput)
pub mod get_cost_categories_output {
    /// A builder for [`GetCostCategoriesOutput`](crate::output::GetCostCategoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) cost_category_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) cost_category_values: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) return_size: std::option::Option<i32>,
        pub(crate) total_size: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>If the number of objects that are still available for retrieval exceeds the limit, Amazon Web Services returns a NextPageToken value in the response. To retrieve the next batch of objects, provide the marker from the prior call in your next request.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Appends an item to `cost_category_names`.
        ///
        /// To override the contents of this collection use [`set_cost_category_names`](Self::set_cost_category_names).
        ///
        /// <p>The names of the Cost Categories.</p>
        pub fn cost_category_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cost_category_names.unwrap_or_default();
            v.push(input.into());
            self.cost_category_names = Some(v);
            self
        }
        /// <p>The names of the Cost Categories.</p>
        pub fn set_cost_category_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cost_category_names = input;
            self
        }
        /// Appends an item to `cost_category_values`.
        ///
        /// To override the contents of this collection use [`set_cost_category_values`](Self::set_cost_category_values).
        ///
        /// <p>The Cost Category values.</p>
        /// <p>
        /// <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the request. </p>
        pub fn cost_category_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cost_category_values.unwrap_or_default();
            v.push(input.into());
            self.cost_category_values = Some(v);
            self
        }
        /// <p>The Cost Category values.</p>
        /// <p>
        /// <code>CostCategoryValues</code> are not returned if <code>CostCategoryName</code> is not specified in the request. </p>
        pub fn set_cost_category_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cost_category_values = input;
            self
        }
        /// <p>The number of objects returned.</p>
        pub fn return_size(mut self, input: i32) -> Self {
            self.return_size = Some(input);
            self
        }
        /// <p>The number of objects returned.</p>
        pub fn set_return_size(mut self, input: std::option::Option<i32>) -> Self {
            self.return_size = input;
            self
        }
        /// <p>The total number of objects.</p>
        pub fn total_size(mut self, input: i32) -> Self {
            self.total_size = Some(input);
            self
        }
        /// <p>The total number of objects.</p>
        pub fn set_total_size(mut self, input: std::option::Option<i32>) -> Self {
            self.total_size = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostCategoriesOutput`](crate::output::GetCostCategoriesOutput)
        pub fn build(self) -> crate::output::GetCostCategoriesOutput {
            crate::output::GetCostCategoriesOutput {
                next_page_token: self.next_page_token,
                cost_category_names: self.cost_category_names,
                cost_category_values: self.cost_category_values,
                return_size: self.return_size,
                total_size: self.total_size,
            }
        }
    }
}
impl GetCostCategoriesOutput {
    /// Creates a new builder-style object to manufacture [`GetCostCategoriesOutput`](crate::output::GetCostCategoriesOutput)
    pub fn builder() -> crate::output::get_cost_categories_output::Builder {
        crate::output::get_cost_categories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostAndUsageWithResourcesOutput {
    /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code>
    /// parameters in the request.</p>
    pub group_definitions: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
    /// <p>The time period that is covered by the results in the response.</p>
    pub results_by_time: std::option::Option<std::vec::Vec<crate::model::ResultByTime>>,
    /// <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
    pub dimension_value_attributes:
        std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
}
impl std::fmt::Debug for GetCostAndUsageWithResourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostAndUsageWithResourcesOutput");
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("group_definitions", &self.group_definitions);
        formatter.field("results_by_time", &self.results_by_time);
        formatter.field(
            "dimension_value_attributes",
            &self.dimension_value_attributes,
        );
        formatter.finish()
    }
}
/// See [`GetCostAndUsageWithResourcesOutput`](crate::output::GetCostAndUsageWithResourcesOutput)
pub mod get_cost_and_usage_with_resources_output {
    /// A builder for [`GetCostAndUsageWithResourcesOutput`](crate::output::GetCostAndUsageWithResourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) group_definitions:
            std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        pub(crate) results_by_time: std::option::Option<std::vec::Vec<crate::model::ResultByTime>>,
        pub(crate) dimension_value_attributes:
            std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
    }
    impl Builder {
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Appends an item to `group_definitions`.
        ///
        /// To override the contents of this collection use [`set_group_definitions`](Self::set_group_definitions).
        ///
        /// <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code>
        /// parameters in the request.</p>
        pub fn group_definitions(
            mut self,
            input: impl Into<crate::model::GroupDefinition>,
        ) -> Self {
            let mut v = self.group_definitions.unwrap_or_default();
            v.push(input.into());
            self.group_definitions = Some(v);
            self
        }
        /// <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code>
        /// parameters in the request.</p>
        pub fn set_group_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.group_definitions = input;
            self
        }
        /// Appends an item to `results_by_time`.
        ///
        /// To override the contents of this collection use [`set_results_by_time`](Self::set_results_by_time).
        ///
        /// <p>The time period that is covered by the results in the response.</p>
        pub fn results_by_time(mut self, input: impl Into<crate::model::ResultByTime>) -> Self {
            let mut v = self.results_by_time.unwrap_or_default();
            v.push(input.into());
            self.results_by_time = Some(v);
            self
        }
        /// <p>The time period that is covered by the results in the response.</p>
        pub fn set_results_by_time(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResultByTime>>,
        ) -> Self {
            self.results_by_time = input;
            self
        }
        /// Appends an item to `dimension_value_attributes`.
        ///
        /// To override the contents of this collection use [`set_dimension_value_attributes`](Self::set_dimension_value_attributes).
        ///
        /// <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
        pub fn dimension_value_attributes(
            mut self,
            input: impl Into<crate::model::DimensionValuesWithAttributes>,
        ) -> Self {
            let mut v = self.dimension_value_attributes.unwrap_or_default();
            v.push(input.into());
            self.dimension_value_attributes = Some(v);
            self
        }
        /// <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
        pub fn set_dimension_value_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
        ) -> Self {
            self.dimension_value_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostAndUsageWithResourcesOutput`](crate::output::GetCostAndUsageWithResourcesOutput)
        pub fn build(self) -> crate::output::GetCostAndUsageWithResourcesOutput {
            crate::output::GetCostAndUsageWithResourcesOutput {
                next_page_token: self.next_page_token,
                group_definitions: self.group_definitions,
                results_by_time: self.results_by_time,
                dimension_value_attributes: self.dimension_value_attributes,
            }
        }
    }
}
impl GetCostAndUsageWithResourcesOutput {
    /// Creates a new builder-style object to manufacture [`GetCostAndUsageWithResourcesOutput`](crate::output::GetCostAndUsageWithResourcesOutput)
    pub fn builder() -> crate::output::get_cost_and_usage_with_resources_output::Builder {
        crate::output::get_cost_and_usage_with_resources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCostAndUsageOutput {
    /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
    pub next_page_token: std::option::Option<std::string::String>,
    /// <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.</p>
    pub group_definitions: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
    /// <p>The time period that's covered by the results in the response.</p>
    pub results_by_time: std::option::Option<std::vec::Vec<crate::model::ResultByTime>>,
    /// <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
    pub dimension_value_attributes:
        std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
}
impl std::fmt::Debug for GetCostAndUsageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCostAndUsageOutput");
        formatter.field("next_page_token", &self.next_page_token);
        formatter.field("group_definitions", &self.group_definitions);
        formatter.field("results_by_time", &self.results_by_time);
        formatter.field(
            "dimension_value_attributes",
            &self.dimension_value_attributes,
        );
        formatter.finish()
    }
}
/// See [`GetCostAndUsageOutput`](crate::output::GetCostAndUsageOutput)
pub mod get_cost_and_usage_output {
    /// A builder for [`GetCostAndUsageOutput`](crate::output::GetCostAndUsageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_page_token: std::option::Option<std::string::String>,
        pub(crate) group_definitions:
            std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        pub(crate) results_by_time: std::option::Option<std::vec::Vec<crate::model::ResultByTime>>,
        pub(crate) dimension_value_attributes:
            std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
    }
    impl Builder {
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of retrievable results. Amazon Web Services provides the token when the response from a previous call has more results than the maximum page size.</p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Appends an item to `group_definitions`.
        ///
        /// To override the contents of this collection use [`set_group_definitions`](Self::set_group_definitions).
        ///
        /// <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.</p>
        pub fn group_definitions(
            mut self,
            input: impl Into<crate::model::GroupDefinition>,
        ) -> Self {
            let mut v = self.group_definitions.unwrap_or_default();
            v.push(input.into());
            self.group_definitions = Some(v);
            self
        }
        /// <p>The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.</p>
        pub fn set_group_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GroupDefinition>>,
        ) -> Self {
            self.group_definitions = input;
            self
        }
        /// Appends an item to `results_by_time`.
        ///
        /// To override the contents of this collection use [`set_results_by_time`](Self::set_results_by_time).
        ///
        /// <p>The time period that's covered by the results in the response.</p>
        pub fn results_by_time(mut self, input: impl Into<crate::model::ResultByTime>) -> Self {
            let mut v = self.results_by_time.unwrap_or_default();
            v.push(input.into());
            self.results_by_time = Some(v);
            self
        }
        /// <p>The time period that's covered by the results in the response.</p>
        pub fn set_results_by_time(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ResultByTime>>,
        ) -> Self {
            self.results_by_time = input;
            self
        }
        /// Appends an item to `dimension_value_attributes`.
        ///
        /// To override the contents of this collection use [`set_dimension_value_attributes`](Self::set_dimension_value_attributes).
        ///
        /// <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
        pub fn dimension_value_attributes(
            mut self,
            input: impl Into<crate::model::DimensionValuesWithAttributes>,
        ) -> Self {
            let mut v = self.dimension_value_attributes.unwrap_or_default();
            v.push(input.into());
            self.dimension_value_attributes = Some(v);
            self
        }
        /// <p>The attributes that apply to a specific dimension value. For example, if the value is a linked account, the attribute is that account name.</p>
        pub fn set_dimension_value_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DimensionValuesWithAttributes>>,
        ) -> Self {
            self.dimension_value_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCostAndUsageOutput`](crate::output::GetCostAndUsageOutput)
        pub fn build(self) -> crate::output::GetCostAndUsageOutput {
            crate::output::GetCostAndUsageOutput {
                next_page_token: self.next_page_token,
                group_definitions: self.group_definitions,
                results_by_time: self.results_by_time,
                dimension_value_attributes: self.dimension_value_attributes,
            }
        }
    }
}
impl GetCostAndUsageOutput {
    /// Creates a new builder-style object to manufacture [`GetCostAndUsageOutput`](crate::output::GetCostAndUsageOutput)
    pub fn builder() -> crate::output::get_cost_and_usage_output::Builder {
        crate::output::get_cost_and_usage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomalySubscriptionsOutput {
    /// <p>A list of cost anomaly subscriptions that includes the detailed metadata for each one. </p>
    pub anomaly_subscriptions:
        std::option::Option<std::vec::Vec<crate::model::AnomalySubscription>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
    /// the response from a previous call has more results than the maximum page size. </p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAnomalySubscriptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomalySubscriptionsOutput");
        formatter.field("anomaly_subscriptions", &self.anomaly_subscriptions);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetAnomalySubscriptionsOutput`](crate::output::GetAnomalySubscriptionsOutput)
pub mod get_anomaly_subscriptions_output {
    /// A builder for [`GetAnomalySubscriptionsOutput`](crate::output::GetAnomalySubscriptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_subscriptions:
            std::option::Option<std::vec::Vec<crate::model::AnomalySubscription>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `anomaly_subscriptions`.
        ///
        /// To override the contents of this collection use [`set_anomaly_subscriptions`](Self::set_anomaly_subscriptions).
        ///
        /// <p>A list of cost anomaly subscriptions that includes the detailed metadata for each one. </p>
        pub fn anomaly_subscriptions(
            mut self,
            input: impl Into<crate::model::AnomalySubscription>,
        ) -> Self {
            let mut v = self.anomaly_subscriptions.unwrap_or_default();
            v.push(input.into());
            self.anomaly_subscriptions = Some(v);
            self
        }
        /// <p>A list of cost anomaly subscriptions that includes the detailed metadata for each one. </p>
        pub fn set_anomaly_subscriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalySubscription>>,
        ) -> Self {
            self.anomaly_subscriptions = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
        /// the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
        /// the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomalySubscriptionsOutput`](crate::output::GetAnomalySubscriptionsOutput)
        pub fn build(self) -> crate::output::GetAnomalySubscriptionsOutput {
            crate::output::GetAnomalySubscriptionsOutput {
                anomaly_subscriptions: self.anomaly_subscriptions,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetAnomalySubscriptionsOutput {
    /// Creates a new builder-style object to manufacture [`GetAnomalySubscriptionsOutput`](crate::output::GetAnomalySubscriptionsOutput)
    pub fn builder() -> crate::output::get_anomaly_subscriptions_output::Builder {
        crate::output::get_anomaly_subscriptions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomalyMonitorsOutput {
    /// <p>A list of cost anomaly monitors that includes the detailed metadata for each monitor. </p>
    pub anomaly_monitors: std::option::Option<std::vec::Vec<crate::model::AnomalyMonitor>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
    /// the response from a previous call has more results than the maximum page size. </p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAnomalyMonitorsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomalyMonitorsOutput");
        formatter.field("anomaly_monitors", &self.anomaly_monitors);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetAnomalyMonitorsOutput`](crate::output::GetAnomalyMonitorsOutput)
pub mod get_anomaly_monitors_output {
    /// A builder for [`GetAnomalyMonitorsOutput`](crate::output::GetAnomalyMonitorsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomaly_monitors:
            std::option::Option<std::vec::Vec<crate::model::AnomalyMonitor>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `anomaly_monitors`.
        ///
        /// To override the contents of this collection use [`set_anomaly_monitors`](Self::set_anomaly_monitors).
        ///
        /// <p>A list of cost anomaly monitors that includes the detailed metadata for each monitor. </p>
        pub fn anomaly_monitors(mut self, input: impl Into<crate::model::AnomalyMonitor>) -> Self {
            let mut v = self.anomaly_monitors.unwrap_or_default();
            v.push(input.into());
            self.anomaly_monitors = Some(v);
            self
        }
        /// <p>A list of cost anomaly monitors that includes the detailed metadata for each monitor. </p>
        pub fn set_anomaly_monitors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AnomalyMonitor>>,
        ) -> Self {
            self.anomaly_monitors = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
        /// the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
        /// the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomalyMonitorsOutput`](crate::output::GetAnomalyMonitorsOutput)
        pub fn build(self) -> crate::output::GetAnomalyMonitorsOutput {
            crate::output::GetAnomalyMonitorsOutput {
                anomaly_monitors: self.anomaly_monitors,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetAnomalyMonitorsOutput {
    /// Creates a new builder-style object to manufacture [`GetAnomalyMonitorsOutput`](crate::output::GetAnomalyMonitorsOutput)
    pub fn builder() -> crate::output::get_anomaly_monitors_output::Builder {
        crate::output::get_anomaly_monitors_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAnomaliesOutput {
    /// <p>A list of cost anomalies. </p>
    pub anomalies: std::option::Option<std::vec::Vec<crate::model::Anomaly>>,
    /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
    /// the response from a previous call has more results than the maximum page size. </p>
    pub next_page_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GetAnomaliesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAnomaliesOutput");
        formatter.field("anomalies", &self.anomalies);
        formatter.field("next_page_token", &self.next_page_token);
        formatter.finish()
    }
}
/// See [`GetAnomaliesOutput`](crate::output::GetAnomaliesOutput)
pub mod get_anomalies_output {
    /// A builder for [`GetAnomaliesOutput`](crate::output::GetAnomaliesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) anomalies: std::option::Option<std::vec::Vec<crate::model::Anomaly>>,
        pub(crate) next_page_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `anomalies`.
        ///
        /// To override the contents of this collection use [`set_anomalies`](Self::set_anomalies).
        ///
        /// <p>A list of cost anomalies. </p>
        pub fn anomalies(mut self, input: impl Into<crate::model::Anomaly>) -> Self {
            let mut v = self.anomalies.unwrap_or_default();
            v.push(input.into());
            self.anomalies = Some(v);
            self
        }
        /// <p>A list of cost anomalies. </p>
        pub fn set_anomalies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Anomaly>>,
        ) -> Self {
            self.anomalies = input;
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
        /// the response from a previous call has more results than the maximum page size. </p>
        pub fn next_page_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_page_token = Some(input.into());
            self
        }
        /// <p>The token to retrieve the next set of results. Amazon Web Services provides the token when
        /// the response from a previous call has more results than the maximum page size. </p>
        pub fn set_next_page_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.next_page_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAnomaliesOutput`](crate::output::GetAnomaliesOutput)
        pub fn build(self) -> crate::output::GetAnomaliesOutput {
            crate::output::GetAnomaliesOutput {
                anomalies: self.anomalies,
                next_page_token: self.next_page_token,
            }
        }
    }
}
impl GetAnomaliesOutput {
    /// Creates a new builder-style object to manufacture [`GetAnomaliesOutput`](crate::output::GetAnomaliesOutput)
    pub fn builder() -> crate::output::get_anomalies_output::Builder {
        crate::output::get_anomalies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCostCategoryDefinitionOutput {
    /// <p>The structure of Cost Categories. This includes detailed metadata and the set of rules
    /// for the <code>CostCategory</code> object.</p>
    pub cost_category: std::option::Option<crate::model::CostCategory>,
}
impl std::fmt::Debug for DescribeCostCategoryDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCostCategoryDefinitionOutput");
        formatter.field("cost_category", &self.cost_category);
        formatter.finish()
    }
}
/// See [`DescribeCostCategoryDefinitionOutput`](crate::output::DescribeCostCategoryDefinitionOutput)
pub mod describe_cost_category_definition_output {
    /// A builder for [`DescribeCostCategoryDefinitionOutput`](crate::output::DescribeCostCategoryDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category: std::option::Option<crate::model::CostCategory>,
    }
    impl Builder {
        /// <p>The structure of Cost Categories. This includes detailed metadata and the set of rules
        /// for the <code>CostCategory</code> object.</p>
        pub fn cost_category(mut self, input: crate::model::CostCategory) -> Self {
            self.cost_category = Some(input);
            self
        }
        /// <p>The structure of Cost Categories. This includes detailed metadata and the set of rules
        /// for the <code>CostCategory</code> object.</p>
        pub fn set_cost_category(
            mut self,
            input: std::option::Option<crate::model::CostCategory>,
        ) -> Self {
            self.cost_category = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCostCategoryDefinitionOutput`](crate::output::DescribeCostCategoryDefinitionOutput)
        pub fn build(self) -> crate::output::DescribeCostCategoryDefinitionOutput {
            crate::output::DescribeCostCategoryDefinitionOutput {
                cost_category: self.cost_category,
            }
        }
    }
}
impl DescribeCostCategoryDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCostCategoryDefinitionOutput`](crate::output::DescribeCostCategoryDefinitionOutput)
    pub fn builder() -> crate::output::describe_cost_category_definition_output::Builder {
        crate::output::describe_cost_category_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCostCategoryDefinitionOutput {
    /// <p>
    /// The unique identifier for your Cost Category.
    /// </p>
    pub cost_category_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The effective end date of the Cost Category as a result of deleting it. No costs after this date will be categorized by the deleted Cost Category.
    /// </p>
    pub effective_end: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DeleteCostCategoryDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCostCategoryDefinitionOutput");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.field("effective_end", &self.effective_end);
        formatter.finish()
    }
}
/// See [`DeleteCostCategoryDefinitionOutput`](crate::output::DeleteCostCategoryDefinitionOutput)
pub mod delete_cost_category_definition_output {
    /// A builder for [`DeleteCostCategoryDefinitionOutput`](crate::output::DeleteCostCategoryDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
        pub(crate) effective_end: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The unique identifier for your Cost Category.
        /// </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier for your Cost Category.
        /// </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// <p>
        /// The effective end date of the Cost Category as a result of deleting it. No costs after this date will be categorized by the deleted Cost Category.
        /// </p>
        pub fn effective_end(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_end = Some(input.into());
            self
        }
        /// <p>
        /// The effective end date of the Cost Category as a result of deleting it. No costs after this date will be categorized by the deleted Cost Category.
        /// </p>
        pub fn set_effective_end(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_end = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCostCategoryDefinitionOutput`](crate::output::DeleteCostCategoryDefinitionOutput)
        pub fn build(self) -> crate::output::DeleteCostCategoryDefinitionOutput {
            crate::output::DeleteCostCategoryDefinitionOutput {
                cost_category_arn: self.cost_category_arn,
                effective_end: self.effective_end,
            }
        }
    }
}
impl DeleteCostCategoryDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCostCategoryDefinitionOutput`](crate::output::DeleteCostCategoryDefinitionOutput)
    pub fn builder() -> crate::output::delete_cost_category_definition_output::Builder {
        crate::output::delete_cost_category_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnomalySubscriptionOutput {}
impl std::fmt::Debug for DeleteAnomalySubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnomalySubscriptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteAnomalySubscriptionOutput`](crate::output::DeleteAnomalySubscriptionOutput)
pub mod delete_anomaly_subscription_output {
    /// A builder for [`DeleteAnomalySubscriptionOutput`](crate::output::DeleteAnomalySubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAnomalySubscriptionOutput`](crate::output::DeleteAnomalySubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteAnomalySubscriptionOutput {
            crate::output::DeleteAnomalySubscriptionOutput {}
        }
    }
}
impl DeleteAnomalySubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAnomalySubscriptionOutput`](crate::output::DeleteAnomalySubscriptionOutput)
    pub fn builder() -> crate::output::delete_anomaly_subscription_output::Builder {
        crate::output::delete_anomaly_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAnomalyMonitorOutput {}
impl std::fmt::Debug for DeleteAnomalyMonitorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAnomalyMonitorOutput");
        formatter.finish()
    }
}
/// See [`DeleteAnomalyMonitorOutput`](crate::output::DeleteAnomalyMonitorOutput)
pub mod delete_anomaly_monitor_output {
    /// A builder for [`DeleteAnomalyMonitorOutput`](crate::output::DeleteAnomalyMonitorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteAnomalyMonitorOutput`](crate::output::DeleteAnomalyMonitorOutput)
        pub fn build(self) -> crate::output::DeleteAnomalyMonitorOutput {
            crate::output::DeleteAnomalyMonitorOutput {}
        }
    }
}
impl DeleteAnomalyMonitorOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAnomalyMonitorOutput`](crate::output::DeleteAnomalyMonitorOutput)
    pub fn builder() -> crate::output::delete_anomaly_monitor_output::Builder {
        crate::output::delete_anomaly_monitor_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCostCategoryDefinitionOutput {
    /// <p>
    /// The unique identifier for your newly created Cost Category.
    /// </p>
    pub cost_category_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The Cost Category's effective start date.
    /// </p>
    pub effective_start: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateCostCategoryDefinitionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCostCategoryDefinitionOutput");
        formatter.field("cost_category_arn", &self.cost_category_arn);
        formatter.field("effective_start", &self.effective_start);
        formatter.finish()
    }
}
/// See [`CreateCostCategoryDefinitionOutput`](crate::output::CreateCostCategoryDefinitionOutput)
pub mod create_cost_category_definition_output {
    /// A builder for [`CreateCostCategoryDefinitionOutput`](crate::output::CreateCostCategoryDefinitionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cost_category_arn: std::option::Option<std::string::String>,
        pub(crate) effective_start: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The unique identifier for your newly created Cost Category.
        /// </p>
        pub fn cost_category_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cost_category_arn = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier for your newly created Cost Category.
        /// </p>
        pub fn set_cost_category_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cost_category_arn = input;
            self
        }
        /// <p>
        /// The Cost Category's effective start date.
        /// </p>
        pub fn effective_start(mut self, input: impl Into<std::string::String>) -> Self {
            self.effective_start = Some(input.into());
            self
        }
        /// <p>
        /// The Cost Category's effective start date.
        /// </p>
        pub fn set_effective_start(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.effective_start = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCostCategoryDefinitionOutput`](crate::output::CreateCostCategoryDefinitionOutput)
        pub fn build(self) -> crate::output::CreateCostCategoryDefinitionOutput {
            crate::output::CreateCostCategoryDefinitionOutput {
                cost_category_arn: self.cost_category_arn,
                effective_start: self.effective_start,
            }
        }
    }
}
impl CreateCostCategoryDefinitionOutput {
    /// Creates a new builder-style object to manufacture [`CreateCostCategoryDefinitionOutput`](crate::output::CreateCostCategoryDefinitionOutput)
    pub fn builder() -> crate::output::create_cost_category_definition_output::Builder {
        crate::output::create_cost_category_definition_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnomalySubscriptionOutput {
    /// <p>The unique identifier of your newly created cost anomaly subscription. </p>
    pub subscription_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAnomalySubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnomalySubscriptionOutput");
        formatter.field("subscription_arn", &self.subscription_arn);
        formatter.finish()
    }
}
/// See [`CreateAnomalySubscriptionOutput`](crate::output::CreateAnomalySubscriptionOutput)
pub mod create_anomaly_subscription_output {
    /// A builder for [`CreateAnomalySubscriptionOutput`](crate::output::CreateAnomalySubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of your newly created cost anomaly subscription. </p>
        pub fn subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of your newly created cost anomaly subscription. </p>
        pub fn set_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnomalySubscriptionOutput`](crate::output::CreateAnomalySubscriptionOutput)
        pub fn build(self) -> crate::output::CreateAnomalySubscriptionOutput {
            crate::output::CreateAnomalySubscriptionOutput {
                subscription_arn: self.subscription_arn,
            }
        }
    }
}
impl CreateAnomalySubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateAnomalySubscriptionOutput`](crate::output::CreateAnomalySubscriptionOutput)
    pub fn builder() -> crate::output::create_anomaly_subscription_output::Builder {
        crate::output::create_anomaly_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAnomalyMonitorOutput {
    /// <p>The unique identifier of your newly created cost anomaly detection monitor.</p>
    pub monitor_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateAnomalyMonitorOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAnomalyMonitorOutput");
        formatter.field("monitor_arn", &self.monitor_arn);
        formatter.finish()
    }
}
/// See [`CreateAnomalyMonitorOutput`](crate::output::CreateAnomalyMonitorOutput)
pub mod create_anomaly_monitor_output {
    /// A builder for [`CreateAnomalyMonitorOutput`](crate::output::CreateAnomalyMonitorOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) monitor_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of your newly created cost anomaly detection monitor.</p>
        pub fn monitor_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitor_arn = Some(input.into());
            self
        }
        /// <p>The unique identifier of your newly created cost anomaly detection monitor.</p>
        pub fn set_monitor_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.monitor_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAnomalyMonitorOutput`](crate::output::CreateAnomalyMonitorOutput)
        pub fn build(self) -> crate::output::CreateAnomalyMonitorOutput {
            crate::output::CreateAnomalyMonitorOutput {
                monitor_arn: self.monitor_arn,
            }
        }
    }
}
impl CreateAnomalyMonitorOutput {
    /// Creates a new builder-style object to manufacture [`CreateAnomalyMonitorOutput`](crate::output::CreateAnomalyMonitorOutput)
    pub fn builder() -> crate::output::create_anomaly_monitor_output::Builder {
        crate::output::create_anomaly_monitor_output::Builder::default()
    }
}
