// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CompleteAttachmentUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`complete_attachment_upload`](crate::client::Client::complete_attachment_upload).
///
/// See [`crate::client::fluent_builders::CompleteAttachmentUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CompleteAttachmentUpload {
    _private: (),
}
impl CompleteAttachmentUpload {
    /// Creates a new builder-style object to manufacture [`CompleteAttachmentUploadInput`](crate::input::CompleteAttachmentUploadInput)
    pub fn builder() -> crate::input::complete_attachment_upload_input::Builder {
        crate::input::complete_attachment_upload_input::Builder::default()
    }
    /// Creates a new `CompleteAttachmentUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CompleteAttachmentUpload {
    type Output = std::result::Result<
        crate::output::CompleteAttachmentUploadOutput,
        crate::error::CompleteAttachmentUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_complete_attachment_upload_error(response)
        } else {
            crate::operation_deser::parse_complete_attachment_upload_response(response)
        }
    }
}

/// Operation shape for `CreateParticipantConnection`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_participant_connection`](crate::client::Client::create_participant_connection).
///
/// See [`crate::client::fluent_builders::CreateParticipantConnection`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateParticipantConnection {
    _private: (),
}
impl CreateParticipantConnection {
    /// Creates a new builder-style object to manufacture [`CreateParticipantConnectionInput`](crate::input::CreateParticipantConnectionInput)
    pub fn builder() -> crate::input::create_participant_connection_input::Builder {
        crate::input::create_participant_connection_input::Builder::default()
    }
    /// Creates a new `CreateParticipantConnection` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateParticipantConnection {
    type Output = std::result::Result<
        crate::output::CreateParticipantConnectionOutput,
        crate::error::CreateParticipantConnectionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_participant_connection_error(response)
        } else {
            crate::operation_deser::parse_create_participant_connection_response(response)
        }
    }
}

/// Operation shape for `DisconnectParticipant`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disconnect_participant`](crate::client::Client::disconnect_participant).
///
/// See [`crate::client::fluent_builders::DisconnectParticipant`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisconnectParticipant {
    _private: (),
}
impl DisconnectParticipant {
    /// Creates a new builder-style object to manufacture [`DisconnectParticipantInput`](crate::input::DisconnectParticipantInput)
    pub fn builder() -> crate::input::disconnect_participant_input::Builder {
        crate::input::disconnect_participant_input::Builder::default()
    }
    /// Creates a new `DisconnectParticipant` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisconnectParticipant {
    type Output = std::result::Result<
        crate::output::DisconnectParticipantOutput,
        crate::error::DisconnectParticipantError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disconnect_participant_error(response)
        } else {
            crate::operation_deser::parse_disconnect_participant_response(response)
        }
    }
}

/// Operation shape for `GetAttachment`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_attachment`](crate::client::Client::get_attachment).
///
/// See [`crate::client::fluent_builders::GetAttachment`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAttachment {
    _private: (),
}
impl GetAttachment {
    /// Creates a new builder-style object to manufacture [`GetAttachmentInput`](crate::input::GetAttachmentInput)
    pub fn builder() -> crate::input::get_attachment_input::Builder {
        crate::input::get_attachment_input::Builder::default()
    }
    /// Creates a new `GetAttachment` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAttachment {
    type Output =
        std::result::Result<crate::output::GetAttachmentOutput, crate::error::GetAttachmentError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_attachment_error(response)
        } else {
            crate::operation_deser::parse_get_attachment_response(response)
        }
    }
}

/// Operation shape for `GetTranscript`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_transcript`](crate::client::Client::get_transcript).
///
/// See [`crate::client::fluent_builders::GetTranscript`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetTranscript {
    _private: (),
}
impl GetTranscript {
    /// Creates a new builder-style object to manufacture [`GetTranscriptInput`](crate::input::GetTranscriptInput)
    pub fn builder() -> crate::input::get_transcript_input::Builder {
        crate::input::get_transcript_input::Builder::default()
    }
    /// Creates a new `GetTranscript` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetTranscript {
    type Output =
        std::result::Result<crate::output::GetTranscriptOutput, crate::error::GetTranscriptError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_transcript_error(response)
        } else {
            crate::operation_deser::parse_get_transcript_response(response)
        }
    }
}

/// Operation shape for `SendEvent`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_event`](crate::client::Client::send_event).
///
/// See [`crate::client::fluent_builders::SendEvent`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendEvent {
    _private: (),
}
impl SendEvent {
    /// Creates a new builder-style object to manufacture [`SendEventInput`](crate::input::SendEventInput)
    pub fn builder() -> crate::input::send_event_input::Builder {
        crate::input::send_event_input::Builder::default()
    }
    /// Creates a new `SendEvent` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendEvent {
    type Output = std::result::Result<crate::output::SendEventOutput, crate::error::SendEventError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_event_error(response)
        } else {
            crate::operation_deser::parse_send_event_response(response)
        }
    }
}

/// Operation shape for `SendMessage`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`send_message`](crate::client::Client::send_message).
///
/// See [`crate::client::fluent_builders::SendMessage`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SendMessage {
    _private: (),
}
impl SendMessage {
    /// Creates a new builder-style object to manufacture [`SendMessageInput`](crate::input::SendMessageInput)
    pub fn builder() -> crate::input::send_message_input::Builder {
        crate::input::send_message_input::Builder::default()
    }
    /// Creates a new `SendMessage` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SendMessage {
    type Output =
        std::result::Result<crate::output::SendMessageOutput, crate::error::SendMessageError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_send_message_error(response)
        } else {
            crate::operation_deser::parse_send_message_response(response)
        }
    }
}

/// Operation shape for `StartAttachmentUpload`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_attachment_upload`](crate::client::Client::start_attachment_upload).
///
/// See [`crate::client::fluent_builders::StartAttachmentUpload`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartAttachmentUpload {
    _private: (),
}
impl StartAttachmentUpload {
    /// Creates a new builder-style object to manufacture [`StartAttachmentUploadInput`](crate::input::StartAttachmentUploadInput)
    pub fn builder() -> crate::input::start_attachment_upload_input::Builder {
        crate::input::start_attachment_upload_input::Builder::default()
    }
    /// Creates a new `StartAttachmentUpload` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartAttachmentUpload {
    type Output = std::result::Result<
        crate::output::StartAttachmentUploadOutput,
        crate::error::StartAttachmentUploadError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_attachment_upload_error(response)
        } else {
            crate::operation_deser::parse_start_attachment_upload_response(response)
        }
    }
}
