// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_attachment_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteAttachmentUploadOutput,
    crate::error::CompleteAttachmentUploadError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CompleteAttachmentUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CompleteAttachmentUploadError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CompleteAttachmentUploadError {
            meta: generic,
            kind: crate::error::CompleteAttachmentUploadErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ConflictException" => {
            crate::error::CompleteAttachmentUploadError {
                meta: generic,
                kind: crate::error::CompleteAttachmentUploadErrorKind::ConflictException({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::conflict_exception::Builder::default();
                        let _ = response;
                        output = crate::json_deser::deser_structure_crate_error_conflict_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteAttachmentUploadError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "InternalServerException" => crate::error::CompleteAttachmentUploadError {
            meta: generic,
            kind: crate::error::CompleteAttachmentUploadErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::CompleteAttachmentUploadError {
            meta: generic,
            kind: crate::error::CompleteAttachmentUploadErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CompleteAttachmentUploadError {
            meta: generic,
            kind: crate::error::CompleteAttachmentUploadErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CompleteAttachmentUploadError {
            meta: generic,
            kind: crate::error::CompleteAttachmentUploadErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CompleteAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CompleteAttachmentUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_complete_attachment_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CompleteAttachmentUploadOutput,
    crate::error::CompleteAttachmentUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::complete_attachment_upload_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_participant_connection_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateParticipantConnectionOutput,
    crate::error::CreateParticipantConnectionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateParticipantConnectionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateParticipantConnectionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::CreateParticipantConnectionError {
            meta: generic,
            kind: crate::error::CreateParticipantConnectionErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateParticipantConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::CreateParticipantConnectionError {
            meta: generic,
            kind: crate::error::CreateParticipantConnectionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateParticipantConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::CreateParticipantConnectionError {
            meta: generic,
            kind: crate::error::CreateParticipantConnectionErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateParticipantConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::CreateParticipantConnectionError {
            meta: generic,
            kind: crate::error::CreateParticipantConnectionErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateParticipantConnectionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateParticipantConnectionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_participant_connection_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateParticipantConnectionOutput,
    crate::error::CreateParticipantConnectionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_participant_connection_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_participant_connection(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateParticipantConnectionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disconnect_participant_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisconnectParticipantOutput,
    crate::error::DisconnectParticipantError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DisconnectParticipantError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DisconnectParticipantError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::DisconnectParticipantError {
            meta: generic,
            kind: crate::error::DisconnectParticipantErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisconnectParticipantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::DisconnectParticipantError {
            meta: generic,
            kind: crate::error::DisconnectParticipantErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisconnectParticipantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::DisconnectParticipantError {
            meta: generic,
            kind: crate::error::DisconnectParticipantErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisconnectParticipantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::DisconnectParticipantError {
            meta: generic,
            kind: crate::error::DisconnectParticipantErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DisconnectParticipantError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DisconnectParticipantError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_disconnect_participant_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DisconnectParticipantOutput,
    crate::error::DisconnectParticipantError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::disconnect_participant_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_attachment_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAttachmentOutput, crate::error::GetAttachmentError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetAttachmentError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetAttachmentError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetAttachmentError {
            meta: generic,
            kind: crate::error::GetAttachmentErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAttachmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetAttachmentError {
            meta: generic,
            kind: crate::error::GetAttachmentErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAttachmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetAttachmentError {
            meta: generic,
            kind: crate::error::GetAttachmentErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAttachmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetAttachmentError {
            meta: generic,
            kind: crate::error::GetAttachmentErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetAttachmentError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetAttachmentError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_attachment_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetAttachmentOutput, crate::error::GetAttachmentError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_attachment_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_attachment(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetAttachmentError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_transcript_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTranscriptOutput, crate::error::GetTranscriptError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetTranscriptError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetTranscriptError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::GetTranscriptError {
            meta: generic,
            kind: crate::error::GetTranscriptErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTranscriptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::GetTranscriptError {
            meta: generic,
            kind: crate::error::GetTranscriptErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTranscriptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::GetTranscriptError {
            meta: generic,
            kind: crate::error::GetTranscriptErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTranscriptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::GetTranscriptError {
            meta: generic,
            kind: crate::error::GetTranscriptErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetTranscriptError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetTranscriptError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_transcript_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetTranscriptOutput, crate::error::GetTranscriptError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_transcript_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_transcript(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetTranscriptError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_event_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendEventOutput, crate::error::SendEventError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendEventError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendEventError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SendEventError {
            meta: generic,
            kind: crate::error::SendEventErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendEventError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::SendEventError {
            meta: generic,
            kind: crate::error::SendEventErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendEventError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::SendEventError {
            meta: generic,
            kind: crate::error::SendEventErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendEventError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::SendEventError {
            meta: generic,
            kind: crate::error::SendEventErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendEventError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendEventError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_event_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendEventOutput, crate::error::SendEventError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_event_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_send_event(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendEventError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_message_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendMessageOutput, crate::error::SendMessageError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::SendMessageError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::SendMessageError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::SendMessageError {
            meta: generic,
            kind: crate::error::SendMessageErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::SendMessageError {
            meta: generic,
            kind: crate::error::SendMessageErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::SendMessageError {
            meta: generic,
            kind: crate::error::SendMessageErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::SendMessageError {
            meta: generic,
            kind: crate::error::SendMessageErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::SendMessageError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::SendMessageError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_send_message_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::SendMessageOutput, crate::error::SendMessageError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::send_message_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_send_message(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::SendMessageError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_attachment_upload_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartAttachmentUploadOutput,
    crate::error::StartAttachmentUploadError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartAttachmentUploadError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartAttachmentUploadError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AccessDeniedException" => crate::error::StartAttachmentUploadError {
            meta: generic,
            kind: crate::error::StartAttachmentUploadErrorKind::AccessDeniedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::access_denied_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_access_denied_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::StartAttachmentUploadError {
            meta: generic,
            kind: crate::error::StartAttachmentUploadErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ServiceQuotaExceededException" => crate::error::StartAttachmentUploadError {
            meta: generic,
            kind: crate::error::StartAttachmentUploadErrorKind::ServiceQuotaExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::service_quota_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_service_quota_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ThrottlingException" => crate::error::StartAttachmentUploadError {
            meta: generic,
            kind: crate::error::StartAttachmentUploadErrorKind::ThrottlingException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::throttling_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_throttling_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ValidationException" => crate::error::StartAttachmentUploadError {
            meta: generic,
            kind: crate::error::StartAttachmentUploadErrorKind::ValidationException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::validation_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_validation_exception_json_err(response.body().as_ref(), output).map_err(crate::error::StartAttachmentUploadError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartAttachmentUploadError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_attachment_upload_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartAttachmentUploadOutput,
    crate::error::StartAttachmentUploadError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_attachment_upload_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_start_attachment_upload(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartAttachmentUploadError::unhandled)?;
        output.build()
    })
}
