// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartAttachmentUploadOutput {
    /// <p>A unique identifier for the attachment.</p>
    pub attachment_id: std::option::Option<std::string::String>,
    /// <p>Fields to be used while uploading the attachment.</p>
    pub upload_metadata: std::option::Option<crate::model::UploadMetadata>,
}
impl StartAttachmentUploadOutput {
    /// <p>A unique identifier for the attachment.</p>
    pub fn attachment_id(&self) -> std::option::Option<&str> {
        self.attachment_id.as_deref()
    }
    /// <p>Fields to be used while uploading the attachment.</p>
    pub fn upload_metadata(&self) -> std::option::Option<&crate::model::UploadMetadata> {
        self.upload_metadata.as_ref()
    }
}
impl std::fmt::Debug for StartAttachmentUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartAttachmentUploadOutput");
        formatter.field("attachment_id", &self.attachment_id);
        formatter.field("upload_metadata", &self.upload_metadata);
        formatter.finish()
    }
}
/// See [`StartAttachmentUploadOutput`](crate::output::StartAttachmentUploadOutput)
pub mod start_attachment_upload_output {
    /// A builder for [`StartAttachmentUploadOutput`](crate::output::StartAttachmentUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attachment_id: std::option::Option<std::string::String>,
        pub(crate) upload_metadata: std::option::Option<crate::model::UploadMetadata>,
    }
    impl Builder {
        /// <p>A unique identifier for the attachment.</p>
        pub fn attachment_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.attachment_id = Some(input.into());
            self
        }
        /// <p>A unique identifier for the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attachment_id = input;
            self
        }
        /// <p>Fields to be used while uploading the attachment.</p>
        pub fn upload_metadata(mut self, input: crate::model::UploadMetadata) -> Self {
            self.upload_metadata = Some(input);
            self
        }
        /// <p>Fields to be used while uploading the attachment.</p>
        pub fn set_upload_metadata(
            mut self,
            input: std::option::Option<crate::model::UploadMetadata>,
        ) -> Self {
            self.upload_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`StartAttachmentUploadOutput`](crate::output::StartAttachmentUploadOutput)
        pub fn build(self) -> crate::output::StartAttachmentUploadOutput {
            crate::output::StartAttachmentUploadOutput {
                attachment_id: self.attachment_id,
                upload_metadata: self.upload_metadata,
            }
        }
    }
}
impl StartAttachmentUploadOutput {
    /// Creates a new builder-style object to manufacture [`StartAttachmentUploadOutput`](crate::output::StartAttachmentUploadOutput)
    pub fn builder() -> crate::output::start_attachment_upload_output::Builder {
        crate::output::start_attachment_upload_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendMessageOutput {
    /// <p>The ID of the message.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The time when the message was sent.</p>
    /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
    /// 2019-11-08T02:41:28.172Z.</p>
    pub absolute_time: std::option::Option<std::string::String>,
}
impl SendMessageOutput {
    /// <p>The ID of the message.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The time when the message was sent.</p>
    /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
    /// 2019-11-08T02:41:28.172Z.</p>
    pub fn absolute_time(&self) -> std::option::Option<&str> {
        self.absolute_time.as_deref()
    }
}
impl std::fmt::Debug for SendMessageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendMessageOutput");
        formatter.field("id", &self.id);
        formatter.field("absolute_time", &self.absolute_time);
        formatter.finish()
    }
}
/// See [`SendMessageOutput`](crate::output::SendMessageOutput)
pub mod send_message_output {
    /// A builder for [`SendMessageOutput`](crate::output::SendMessageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) absolute_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the message.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the message.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The time when the message was sent.</p>
        /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
        /// 2019-11-08T02:41:28.172Z.</p>
        pub fn absolute_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.absolute_time = Some(input.into());
            self
        }
        /// <p>The time when the message was sent.</p>
        /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
        /// 2019-11-08T02:41:28.172Z.</p>
        pub fn set_absolute_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.absolute_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SendMessageOutput`](crate::output::SendMessageOutput)
        pub fn build(self) -> crate::output::SendMessageOutput {
            crate::output::SendMessageOutput {
                id: self.id,
                absolute_time: self.absolute_time,
            }
        }
    }
}
impl SendMessageOutput {
    /// Creates a new builder-style object to manufacture [`SendMessageOutput`](crate::output::SendMessageOutput)
    pub fn builder() -> crate::output::send_message_output::Builder {
        crate::output::send_message_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SendEventOutput {
    /// <p>The ID of the response.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The time when the event was sent.</p>
    /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
    /// 2019-11-08T02:41:28.172Z.</p>
    pub absolute_time: std::option::Option<std::string::String>,
}
impl SendEventOutput {
    /// <p>The ID of the response.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The time when the event was sent.</p>
    /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
    /// 2019-11-08T02:41:28.172Z.</p>
    pub fn absolute_time(&self) -> std::option::Option<&str> {
        self.absolute_time.as_deref()
    }
}
impl std::fmt::Debug for SendEventOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SendEventOutput");
        formatter.field("id", &self.id);
        formatter.field("absolute_time", &self.absolute_time);
        formatter.finish()
    }
}
/// See [`SendEventOutput`](crate::output::SendEventOutput)
pub mod send_event_output {
    /// A builder for [`SendEventOutput`](crate::output::SendEventOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) absolute_time: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the response.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The ID of the response.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The time when the event was sent.</p>
        /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
        /// 2019-11-08T02:41:28.172Z.</p>
        pub fn absolute_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.absolute_time = Some(input.into());
            self
        }
        /// <p>The time when the event was sent.</p>
        /// <p>It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
        /// 2019-11-08T02:41:28.172Z.</p>
        pub fn set_absolute_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.absolute_time = input;
            self
        }
        /// Consumes the builder and constructs a [`SendEventOutput`](crate::output::SendEventOutput)
        pub fn build(self) -> crate::output::SendEventOutput {
            crate::output::SendEventOutput {
                id: self.id,
                absolute_time: self.absolute_time,
            }
        }
    }
}
impl SendEventOutput {
    /// Creates a new builder-style object to manufacture [`SendEventOutput`](crate::output::SendEventOutput)
    pub fn builder() -> crate::output::send_event_output::Builder {
        crate::output::send_event_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetTranscriptOutput {
    /// <p>The initial contact ID for the contact. </p>
    pub initial_contact_id: std::option::Option<std::string::String>,
    /// <p>The list of messages in the session.</p>
    pub transcript: std::option::Option<std::vec::Vec<crate::model::Item>>,
    /// <p>The pagination token. Use the value returned previously in the next subsequent request
    /// to retrieve the next set of results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl GetTranscriptOutput {
    /// <p>The initial contact ID for the contact. </p>
    pub fn initial_contact_id(&self) -> std::option::Option<&str> {
        self.initial_contact_id.as_deref()
    }
    /// <p>The list of messages in the session.</p>
    pub fn transcript(&self) -> std::option::Option<&[crate::model::Item]> {
        self.transcript.as_deref()
    }
    /// <p>The pagination token. Use the value returned previously in the next subsequent request
    /// to retrieve the next set of results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for GetTranscriptOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetTranscriptOutput");
        formatter.field("initial_contact_id", &self.initial_contact_id);
        formatter.field("transcript", &self.transcript);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`GetTranscriptOutput`](crate::output::GetTranscriptOutput)
pub mod get_transcript_output {
    /// A builder for [`GetTranscriptOutput`](crate::output::GetTranscriptOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_contact_id: std::option::Option<std::string::String>,
        pub(crate) transcript: std::option::Option<std::vec::Vec<crate::model::Item>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The initial contact ID for the contact. </p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_contact_id = Some(input.into());
            self
        }
        /// <p>The initial contact ID for the contact. </p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_contact_id = input;
            self
        }
        /// Appends an item to `transcript`.
        ///
        /// To override the contents of this collection use [`set_transcript`](Self::set_transcript).
        ///
        /// <p>The list of messages in the session.</p>
        pub fn transcript(mut self, input: impl Into<crate::model::Item>) -> Self {
            let mut v = self.transcript.unwrap_or_default();
            v.push(input.into());
            self.transcript = Some(v);
            self
        }
        /// <p>The list of messages in the session.</p>
        pub fn set_transcript(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Item>>,
        ) -> Self {
            self.transcript = input;
            self
        }
        /// <p>The pagination token. Use the value returned previously in the next subsequent request
        /// to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token. Use the value returned previously in the next subsequent request
        /// to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`GetTranscriptOutput`](crate::output::GetTranscriptOutput)
        pub fn build(self) -> crate::output::GetTranscriptOutput {
            crate::output::GetTranscriptOutput {
                initial_contact_id: self.initial_contact_id,
                transcript: self.transcript,
                next_token: self.next_token,
            }
        }
    }
}
impl GetTranscriptOutput {
    /// Creates a new builder-style object to manufacture [`GetTranscriptOutput`](crate::output::GetTranscriptOutput)
    pub fn builder() -> crate::output::get_transcript_output::Builder {
        crate::output::get_transcript_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAttachmentOutput {
    /// <p>This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response
    /// to <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html">StartAttachmentUpload</a>.</p>
    pub url: std::option::Option<std::string::String>,
    /// <p>The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>
    pub url_expiry: std::option::Option<std::string::String>,
}
impl GetAttachmentOutput {
    /// <p>This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response
    /// to <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html">StartAttachmentUpload</a>.</p>
    pub fn url(&self) -> std::option::Option<&str> {
        self.url.as_deref()
    }
    /// <p>The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>
    pub fn url_expiry(&self) -> std::option::Option<&str> {
        self.url_expiry.as_deref()
    }
}
impl std::fmt::Debug for GetAttachmentOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAttachmentOutput");
        formatter.field("url", &self.url);
        formatter.field("url_expiry", &self.url_expiry);
        formatter.finish()
    }
}
/// See [`GetAttachmentOutput`](crate::output::GetAttachmentOutput)
pub mod get_attachment_output {
    /// A builder for [`GetAttachmentOutput`](crate::output::GetAttachmentOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) url_expiry: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response
        /// to <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html">StartAttachmentUpload</a>.</p>
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// <p>This is the pre-signed URL that can be used for uploading the file to Amazon S3 when used in response
        /// to <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_StartAttachmentUpload.html">StartAttachmentUpload</a>.</p>
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// <p>The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>
        pub fn url_expiry(mut self, input: impl Into<std::string::String>) -> Self {
            self.url_expiry = Some(input.into());
            self
        }
        /// <p>The expiration time of the URL in ISO timestamp. It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>
        pub fn set_url_expiry(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url_expiry = input;
            self
        }
        /// Consumes the builder and constructs a [`GetAttachmentOutput`](crate::output::GetAttachmentOutput)
        pub fn build(self) -> crate::output::GetAttachmentOutput {
            crate::output::GetAttachmentOutput {
                url: self.url,
                url_expiry: self.url_expiry,
            }
        }
    }
}
impl GetAttachmentOutput {
    /// Creates a new builder-style object to manufacture [`GetAttachmentOutput`](crate::output::GetAttachmentOutput)
    pub fn builder() -> crate::output::get_attachment_output::Builder {
        crate::output::get_attachment_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisconnectParticipantOutput {}
impl std::fmt::Debug for DisconnectParticipantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisconnectParticipantOutput");
        formatter.finish()
    }
}
/// See [`DisconnectParticipantOutput`](crate::output::DisconnectParticipantOutput)
pub mod disconnect_participant_output {
    /// A builder for [`DisconnectParticipantOutput`](crate::output::DisconnectParticipantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisconnectParticipantOutput`](crate::output::DisconnectParticipantOutput)
        pub fn build(self) -> crate::output::DisconnectParticipantOutput {
            crate::output::DisconnectParticipantOutput {}
        }
    }
}
impl DisconnectParticipantOutput {
    /// Creates a new builder-style object to manufacture [`DisconnectParticipantOutput`](crate::output::DisconnectParticipantOutput)
    pub fn builder() -> crate::output::disconnect_participant_output::Builder {
        crate::output::disconnect_participant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateParticipantConnectionOutput {
    /// <p>Creates the participant's websocket connection.</p>
    pub websocket: std::option::Option<crate::model::Websocket>,
    /// <p>Creates the participant's connection credentials. The authentication token associated
    /// with the participant's connection.</p>
    pub connection_credentials: std::option::Option<crate::model::ConnectionCredentials>,
}
impl CreateParticipantConnectionOutput {
    /// <p>Creates the participant's websocket connection.</p>
    pub fn websocket(&self) -> std::option::Option<&crate::model::Websocket> {
        self.websocket.as_ref()
    }
    /// <p>Creates the participant's connection credentials. The authentication token associated
    /// with the participant's connection.</p>
    pub fn connection_credentials(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionCredentials> {
        self.connection_credentials.as_ref()
    }
}
impl std::fmt::Debug for CreateParticipantConnectionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateParticipantConnectionOutput");
        formatter.field("websocket", &self.websocket);
        formatter.field("connection_credentials", &self.connection_credentials);
        formatter.finish()
    }
}
/// See [`CreateParticipantConnectionOutput`](crate::output::CreateParticipantConnectionOutput)
pub mod create_participant_connection_output {
    /// A builder for [`CreateParticipantConnectionOutput`](crate::output::CreateParticipantConnectionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) websocket: std::option::Option<crate::model::Websocket>,
        pub(crate) connection_credentials: std::option::Option<crate::model::ConnectionCredentials>,
    }
    impl Builder {
        /// <p>Creates the participant's websocket connection.</p>
        pub fn websocket(mut self, input: crate::model::Websocket) -> Self {
            self.websocket = Some(input);
            self
        }
        /// <p>Creates the participant's websocket connection.</p>
        pub fn set_websocket(
            mut self,
            input: std::option::Option<crate::model::Websocket>,
        ) -> Self {
            self.websocket = input;
            self
        }
        /// <p>Creates the participant's connection credentials. The authentication token associated
        /// with the participant's connection.</p>
        pub fn connection_credentials(
            mut self,
            input: crate::model::ConnectionCredentials,
        ) -> Self {
            self.connection_credentials = Some(input);
            self
        }
        /// <p>Creates the participant's connection credentials. The authentication token associated
        /// with the participant's connection.</p>
        pub fn set_connection_credentials(
            mut self,
            input: std::option::Option<crate::model::ConnectionCredentials>,
        ) -> Self {
            self.connection_credentials = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateParticipantConnectionOutput`](crate::output::CreateParticipantConnectionOutput)
        pub fn build(self) -> crate::output::CreateParticipantConnectionOutput {
            crate::output::CreateParticipantConnectionOutput {
                websocket: self.websocket,
                connection_credentials: self.connection_credentials,
            }
        }
    }
}
impl CreateParticipantConnectionOutput {
    /// Creates a new builder-style object to manufacture [`CreateParticipantConnectionOutput`](crate::output::CreateParticipantConnectionOutput)
    pub fn builder() -> crate::output::create_participant_connection_output::Builder {
        crate::output::create_participant_connection_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CompleteAttachmentUploadOutput {}
impl std::fmt::Debug for CompleteAttachmentUploadOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CompleteAttachmentUploadOutput");
        formatter.finish()
    }
}
/// See [`CompleteAttachmentUploadOutput`](crate::output::CompleteAttachmentUploadOutput)
pub mod complete_attachment_upload_output {
    /// A builder for [`CompleteAttachmentUploadOutput`](crate::output::CompleteAttachmentUploadOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CompleteAttachmentUploadOutput`](crate::output::CompleteAttachmentUploadOutput)
        pub fn build(self) -> crate::output::CompleteAttachmentUploadOutput {
            crate::output::CompleteAttachmentUploadOutput {}
        }
    }
}
impl CompleteAttachmentUploadOutput {
    /// Creates a new builder-style object to manufacture [`CompleteAttachmentUploadOutput`](crate::output::CompleteAttachmentUploadOutput)
    pub fn builder() -> crate::output::complete_attachment_upload_output::Builder {
        crate::output::complete_attachment_upload_output::Builder::default()
    }
}
