// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonConnectParticipantServiceLambda`.
///
/// This client allows ergonomic access to a `AmazonConnectParticipantServiceLambda`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CompleteAttachmentUpload` operation.
    ///
    /// See [`CompleteAttachmentUpload`](crate::client::fluent_builders::CompleteAttachmentUpload) for more information about the
    /// operation and its arguments.
    pub fn complete_attachment_upload(&self) -> fluent_builders::CompleteAttachmentUpload<C, M, R> {
        fluent_builders::CompleteAttachmentUpload::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateParticipantConnection` operation.
    ///
    /// See [`CreateParticipantConnection`](crate::client::fluent_builders::CreateParticipantConnection) for more information about the
    /// operation and its arguments.
    pub fn create_participant_connection(
        &self,
    ) -> fluent_builders::CreateParticipantConnection<C, M, R> {
        fluent_builders::CreateParticipantConnection::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisconnectParticipant` operation.
    ///
    /// See [`DisconnectParticipant`](crate::client::fluent_builders::DisconnectParticipant) for more information about the
    /// operation and its arguments.
    pub fn disconnect_participant(&self) -> fluent_builders::DisconnectParticipant<C, M, R> {
        fluent_builders::DisconnectParticipant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAttachment` operation.
    ///
    /// See [`GetAttachment`](crate::client::fluent_builders::GetAttachment) for more information about the
    /// operation and its arguments.
    pub fn get_attachment(&self) -> fluent_builders::GetAttachment<C, M, R> {
        fluent_builders::GetAttachment::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetTranscript` operation.
    ///
    /// See [`GetTranscript`](crate::client::fluent_builders::GetTranscript) for more information about the
    /// operation and its arguments.
    pub fn get_transcript(&self) -> fluent_builders::GetTranscript<C, M, R> {
        fluent_builders::GetTranscript::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendEvent` operation.
    ///
    /// See [`SendEvent`](crate::client::fluent_builders::SendEvent) for more information about the
    /// operation and its arguments.
    pub fn send_event(&self) -> fluent_builders::SendEvent<C, M, R> {
        fluent_builders::SendEvent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SendMessage` operation.
    ///
    /// See [`SendMessage`](crate::client::fluent_builders::SendMessage) for more information about the
    /// operation and its arguments.
    pub fn send_message(&self) -> fluent_builders::SendMessage<C, M, R> {
        fluent_builders::SendMessage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartAttachmentUpload` operation.
    ///
    /// See [`StartAttachmentUpload`](crate::client::fluent_builders::StartAttachmentUpload) for more information about the
    /// operation and its arguments.
    pub fn start_attachment_upload(&self) -> fluent_builders::StartAttachmentUpload<C, M, R> {
        fluent_builders::StartAttachmentUpload::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CompleteAttachmentUpload`.
    ///
    /// <p>Allows you to confirm that the attachment has been uploaded using the pre-signed URL
    /// provided in StartAttachmentUpload API. </p>
    #[derive(std::fmt::Debug)]
    pub struct CompleteAttachmentUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::complete_attachment_upload_input::Builder,
    }
    impl<C, M, R> CompleteAttachmentUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CompleteAttachmentUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CompleteAttachmentUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::CompleteAttachmentUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CompleteAttachmentUploadInputOperationOutputAlias,
                crate::output::CompleteAttachmentUploadOutput,
                crate::error::CompleteAttachmentUploadError,
                crate::input::CompleteAttachmentUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AttachmentIds`.
        ///
        /// To override the contents of this collection use [`set_attachment_ids`](Self::set_attachment_ids).
        ///
        /// <p>A list of unique identifiers for the attachments.</p>
        pub fn attachment_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_ids(inp);
            self
        }
        /// <p>A list of unique identifiers for the attachments.</p>
        pub fn set_attachment_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attachment_ids(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn connection_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_token(inp);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn set_connection_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateParticipantConnection`.
    ///
    /// <p>Creates the participant's connection. Note that ParticipantToken is used for invoking
    /// this API instead of ConnectionToken.</p>
    /// <p>The participant token is valid for the lifetime of the participant – until they are
    /// part of a contact.</p>
    /// <p>The response URL for <code>WEBSOCKET</code> Type has a connect expiry timeout of 100s.
    /// Clients must manually connect to the returned websocket URL and subscribe to the desired
    /// topic. </p>
    /// <p>For chat, you need to publish the following on the established websocket
    /// connection:</p>
    ///
    ///
    /// <p>
    /// <code>{"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}</code>
    /// </p>
    ///
    /// <p>Upon websocket URL expiry, as specified in the response ConnectionExpiry parameter,
    /// clients need to call this API again to obtain a new websocket URL and perform the same
    /// steps as before.</p>
    ///
    /// <note>
    /// <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4
    /// authentication</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct CreateParticipantConnection<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_participant_connection_input::Builder,
    }
    impl<C, M, R> CreateParticipantConnection<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateParticipantConnection`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateParticipantConnectionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateParticipantConnectionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateParticipantConnectionInputOperationOutputAlias,
                crate::output::CreateParticipantConnectionOutput,
                crate::error::CreateParticipantConnectionError,
                crate::input::CreateParticipantConnectionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Type`.
        ///
        /// To override the contents of this collection use [`set_type`](Self::set_type).
        ///
        /// <p>Type of connection information required.</p>
        pub fn r#type(mut self, inp: impl Into<crate::model::ConnectionType>) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>Type of connection information required.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ConnectionType>>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>This is a header parameter.</p>
        /// <p>The Participant Token as obtained from <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html">StartChatContact</a>
        /// API response.</p>
        pub fn participant_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.participant_token(inp);
            self
        }
        /// <p>This is a header parameter.</p>
        /// <p>The Participant Token as obtained from <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContact.html">StartChatContact</a>
        /// API response.</p>
        pub fn set_participant_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_participant_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisconnectParticipant`.
    ///
    /// <p>Disconnects a participant. Note that ConnectionToken is used for invoking this API
    /// instead of ParticipantToken.</p>
    /// <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4
    /// authentication</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisconnectParticipant<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disconnect_participant_input::Builder,
    }
    impl<C, M, R> DisconnectParticipant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisconnectParticipant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisconnectParticipantOutput,
            aws_smithy_http::result::SdkError<crate::error::DisconnectParticipantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisconnectParticipantInputOperationOutputAlias,
                crate::output::DisconnectParticipantOutput,
                crate::error::DisconnectParticipantError,
                crate::input::DisconnectParticipantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn connection_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_token(inp);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn set_connection_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAttachment`.
    ///
    /// <p>Provides a pre-signed URL for download of a completed attachment. This is an
    /// asynchronous API for use with active contacts.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAttachment<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_attachment_input::Builder,
    }
    impl<C, M, R> GetAttachment<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAttachment`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAttachmentOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAttachmentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAttachmentInputOperationOutputAlias,
                crate::output::GetAttachmentOutput,
                crate::error::GetAttachmentError,
                crate::input::GetAttachmentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the attachment.</p>
        pub fn attachment_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_id(inp);
            self
        }
        /// <p>A unique identifier for the attachment.</p>
        pub fn set_attachment_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_id(input);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn connection_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_token(inp);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn set_connection_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetTranscript`.
    ///
    /// <p>Retrieves a transcript of the session, including details about any attachments. Note
    /// that ConnectionToken is used for invoking this API instead of ParticipantToken.</p>
    /// <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4
    /// authentication</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetTranscript<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_transcript_input::Builder,
    }
    impl<C, M, R> GetTranscript<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetTranscript`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetTranscriptOutput,
            aws_smithy_http::result::SdkError<crate::error::GetTranscriptError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetTranscriptInputOperationOutputAlias,
                crate::output::GetTranscriptOutput,
                crate::error::GetTranscriptError,
                crate::input::GetTranscriptInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The contactId from the current contact chain for which transcript is needed.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The contactId from the current contact chain for which transcript is needed.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The maximum number of results to return in the page. Default: 10. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return in the page. Default: 10. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token. Use the value returned previously in the next subsequent request
        /// to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token. Use the value returned previously in the next subsequent request
        /// to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The direction from StartPosition from which to retrieve message. Default: BACKWARD
        /// when no StartPosition is provided, FORWARD with StartPosition. </p>
        pub fn scan_direction(mut self, inp: crate::model::ScanDirection) -> Self {
            self.inner = self.inner.scan_direction(inp);
            self
        }
        /// <p>The direction from StartPosition from which to retrieve message. Default: BACKWARD
        /// when no StartPosition is provided, FORWARD with StartPosition. </p>
        pub fn set_scan_direction(
            mut self,
            input: std::option::Option<crate::model::ScanDirection>,
        ) -> Self {
            self.inner = self.inner.set_scan_direction(input);
            self
        }
        /// <p>The sort order for the records. Default: DESCENDING.</p>
        pub fn sort_order(mut self, inp: crate::model::SortKey) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>The sort order for the records. Default: DESCENDING.</p>
        pub fn set_sort_order(mut self, input: std::option::Option<crate::model::SortKey>) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>A filtering option for where to start.</p>
        pub fn start_position(mut self, inp: crate::model::StartPosition) -> Self {
            self.inner = self.inner.start_position(inp);
            self
        }
        /// <p>A filtering option for where to start.</p>
        pub fn set_start_position(
            mut self,
            input: std::option::Option<crate::model::StartPosition>,
        ) -> Self {
            self.inner = self.inner.set_start_position(input);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn connection_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_token(inp);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn set_connection_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendEvent`.
    ///
    /// <p>Sends an event. Note that ConnectionToken is used for invoking this API instead of
    /// ParticipantToken.</p>
    /// <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4
    /// authentication</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct SendEvent<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_event_input::Builder,
    }
    impl<C, M, R> SendEvent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendEvent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendEventOutput,
            aws_smithy_http::result::SdkError<crate::error::SendEventError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendEventInputOperationOutputAlias,
                crate::output::SendEventOutput,
                crate::error::SendEventError,
                crate::input::SendEventInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The content type of the request. Supported types are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>application/vnd.amazonaws.connect.event.typing</p>
        /// </li>
        /// <li>
        /// <p>application/vnd.amazonaws.connect.event.connection.acknowledged</p>
        /// </li>
        /// </ul>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>The content type of the request. Supported types are:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>application/vnd.amazonaws.connect.event.typing</p>
        /// </li>
        /// <li>
        /// <p>application/vnd.amazonaws.connect.event.connection.acknowledged</p>
        /// </li>
        /// </ul>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The content of the event to be sent (for example, message text). This is not yet
        /// supported.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the event to be sent (for example, message text). This is not yet
        /// supported.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn connection_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_token(inp);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn set_connection_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SendMessage`.
    ///
    /// <p>Sends a message. Note that ConnectionToken is used for invoking this API instead of
    /// ParticipantToken.</p>
    /// <note>
    /// <p>The Amazon Connect Participant Service APIs do not use <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4
    /// authentication</a>.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct SendMessage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::send_message_input::Builder,
    }
    impl<C, M, R> SendMessage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SendMessage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SendMessageOutput,
            aws_smithy_http::result::SdkError<crate::error::SendMessageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SendMessageInputOperationOutputAlias,
                crate::output::SendMessageOutput,
                crate::error::SendMessageError,
                crate::input::SendMessageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The type of the content. Supported types are text/plain.</p>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>The type of the content. Supported types are text/plain.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The content of the message.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the message.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The authentication token associated with the connection.</p>
        pub fn connection_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_token(inp);
            self
        }
        /// <p>The authentication token associated with the connection.</p>
        pub fn set_connection_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartAttachmentUpload`.
    ///
    /// <p>Provides a pre-signed Amazon S3 URL in response for uploading the file directly to
    /// S3.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartAttachmentUpload<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_attachment_upload_input::Builder,
    }
    impl<C, M, R> StartAttachmentUpload<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartAttachmentUpload`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartAttachmentUploadOutput,
            aws_smithy_http::result::SdkError<crate::error::StartAttachmentUploadError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartAttachmentUploadInputOperationOutputAlias,
                crate::output::StartAttachmentUploadOutput,
                crate::error::StartAttachmentUploadError,
                crate::input::StartAttachmentUploadInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Describes the MIME file type of the attachment. For a list of supported file types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>Describes the MIME file type of the attachment. For a list of supported file types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
        /// <p>The size of the attachment in bytes.</p>
        pub fn attachment_size_in_bytes(mut self, inp: i64) -> Self {
            self.inner = self.inner.attachment_size_in_bytes(inp);
            self
        }
        /// <p>The size of the attachment in bytes.</p>
        pub fn set_attachment_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_attachment_size_in_bytes(input);
            self
        }
        /// <p>A case-sensitive name of the attachment being uploaded.</p>
        pub fn attachment_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attachment_name(inp);
            self
        }
        /// <p>A case-sensitive name of the attachment being uploaded.</p>
        pub fn set_attachment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_attachment_name(input);
            self
        }
        /// <p>A unique case sensitive identifier to support idempotency of request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique case sensitive identifier to support idempotency of request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn connection_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.connection_token(inp);
            self
        }
        /// <p>The authentication token associated with the participant's connection.</p>
        pub fn set_connection_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_connection_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
