// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AssociateApprovedOriginInput`](crate::input::AssociateApprovedOriginInput)
pub mod associate_approved_origin_input {
    /// A builder for [`AssociateApprovedOriginInput`](crate::input::AssociateApprovedOriginInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The domain to add to your allow list.</p>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin = Some(input.into());
            self
        }
        /// <p>The domain to add to your allow list.</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.origin = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateApprovedOriginInput`](crate::input::AssociateApprovedOriginInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateApprovedOriginInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateApprovedOriginInput {
                instance_id: self.instance_id,
                origin: self.origin,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateApprovedOriginInputOperationOutputAlias =
    crate::operation::AssociateApprovedOrigin;
#[doc(hidden)]
pub type AssociateApprovedOriginInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateApprovedOriginInput {
    /// Consumes the builder and constructs an Operation<[`AssociateApprovedOrigin`](crate::operation::AssociateApprovedOrigin)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateApprovedOrigin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateApprovedOriginInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.instance_id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_1, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/approved-origin",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateApprovedOriginInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateApprovedOriginInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_approved_origin(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateApprovedOrigin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateApprovedOrigin",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateApprovedOriginInput`](crate::input::AssociateApprovedOriginInput)
    pub fn builder() -> crate::input::associate_approved_origin_input::Builder {
        crate::input::associate_approved_origin_input::Builder::default()
    }
}

/// See [`AssociateBotInput`](crate::input::AssociateBotInput)
pub mod associate_bot_input {
    /// A builder for [`AssociateBotInput`](crate::input::AssociateBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) lex_bot: std::option::Option<crate::model::LexBot>,
        pub(crate) lex_v2_bot: std::option::Option<crate::model::LexV2Bot>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn lex_bot(mut self, input: crate::model::LexBot) -> Self {
            self.lex_bot = Some(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.lex_bot = input;
            self
        }
        /// <p>The Amazon Lex V2 bot to associate with the instance.</p>
        pub fn lex_v2_bot(mut self, input: crate::model::LexV2Bot) -> Self {
            self.lex_v2_bot = Some(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to associate with the instance.</p>
        pub fn set_lex_v2_bot(
            mut self,
            input: std::option::Option<crate::model::LexV2Bot>,
        ) -> Self {
            self.lex_v2_bot = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateBotInput`](crate::input::AssociateBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateBotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateBotInput {
                instance_id: self.instance_id,
                lex_bot: self.lex_bot,
                lex_v2_bot: self.lex_v2_bot,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateBotInputOperationOutputAlias = crate::operation::AssociateBot;
#[doc(hidden)]
pub type AssociateBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateBotInput {
    /// Consumes the builder and constructs an Operation<[`AssociateBot`](crate::operation::AssociateBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.instance_id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_2, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/bot",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_associate_bot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateBot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateBot",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateBotInput`](crate::input::AssociateBotInput)
    pub fn builder() -> crate::input::associate_bot_input::Builder {
        crate::input::associate_bot_input::Builder::default()
    }
}

/// See [`AssociateDefaultVocabularyInput`](crate::input::AssociateDefaultVocabularyInput)
pub mod associate_default_vocabulary_input {
    /// A builder for [`AssociateDefaultVocabularyInput`](crate::input::AssociateDefaultVocabularyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::VocabularyLanguageCode>,
        pub(crate) vocabulary_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The identifier of the custom vocabulary. If this is empty, the default is set to none.</p>
        pub fn vocabulary_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_id = Some(input.into());
            self
        }
        /// <p>The identifier of the custom vocabulary. If this is empty, the default is set to none.</p>
        pub fn set_vocabulary_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDefaultVocabularyInput`](crate::input::AssociateDefaultVocabularyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateDefaultVocabularyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateDefaultVocabularyInput {
                instance_id: self.instance_id,
                language_code: self.language_code,
                vocabulary_id: self.vocabulary_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateDefaultVocabularyInputOperationOutputAlias =
    crate::operation::AssociateDefaultVocabulary;
#[doc(hidden)]
pub type AssociateDefaultVocabularyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateDefaultVocabularyInput {
    /// Consumes the builder and constructs an Operation<[`AssociateDefaultVocabulary`](crate::operation::AssociateDefaultVocabulary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateDefaultVocabulary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateDefaultVocabularyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.instance_id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_3, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_4 = &_input.language_code;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "language_code",
                        details: "cannot be empty or unset",
                    })?;
            let language_code = aws_smithy_http::label::fmt_string(input_4, false);
            if language_code.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "language_code",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/default-vocabulary/{InstanceId}/{LanguageCode}",
                InstanceId = instance_id,
                LanguageCode = language_code
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateDefaultVocabularyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateDefaultVocabularyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_default_vocabulary(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateDefaultVocabulary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateDefaultVocabulary",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateDefaultVocabularyInput`](crate::input::AssociateDefaultVocabularyInput)
    pub fn builder() -> crate::input::associate_default_vocabulary_input::Builder {
        crate::input::associate_default_vocabulary_input::Builder::default()
    }
}

/// See [`AssociateInstanceStorageConfigInput`](crate::input::AssociateInstanceStorageConfigInput)
pub mod associate_instance_storage_config_input {
    /// A builder for [`AssociateInstanceStorageConfigInput`](crate::input::AssociateInstanceStorageConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::InstanceStorageResourceType>,
        pub(crate) storage_config: std::option::Option<crate::model::InstanceStorageConfig>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>A valid storage type.</p>
        pub fn storage_config(mut self, input: crate::model::InstanceStorageConfig) -> Self {
            self.storage_config = Some(input);
            self
        }
        /// <p>A valid storage type.</p>
        pub fn set_storage_config(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageConfig>,
        ) -> Self {
            self.storage_config = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateInstanceStorageConfigInput`](crate::input::AssociateInstanceStorageConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateInstanceStorageConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateInstanceStorageConfigInput {
                instance_id: self.instance_id,
                resource_type: self.resource_type,
                storage_config: self.storage_config,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateInstanceStorageConfigInputOperationOutputAlias =
    crate::operation::AssociateInstanceStorageConfig;
#[doc(hidden)]
pub type AssociateInstanceStorageConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateInstanceStorageConfigInput {
    /// Consumes the builder and constructs an Operation<[`AssociateInstanceStorageConfig`](crate::operation::AssociateInstanceStorageConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateInstanceStorageConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateInstanceStorageConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.instance_id;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_5, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/storage-config",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateInstanceStorageConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateInstanceStorageConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_instance_storage_config(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateInstanceStorageConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateInstanceStorageConfig",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateInstanceStorageConfigInput`](crate::input::AssociateInstanceStorageConfigInput)
    pub fn builder() -> crate::input::associate_instance_storage_config_input::Builder {
        crate::input::associate_instance_storage_config_input::Builder::default()
    }
}

/// See [`AssociateLambdaFunctionInput`](crate::input::AssociateLambdaFunctionInput)
pub mod associate_lambda_function_input {
    /// A builder for [`AssociateLambdaFunctionInput`](crate::input::AssociateLambdaFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLambdaFunctionInput`](crate::input::AssociateLambdaFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateLambdaFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateLambdaFunctionInput {
                instance_id: self.instance_id,
                function_arn: self.function_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateLambdaFunctionInputOperationOutputAlias =
    crate::operation::AssociateLambdaFunction;
#[doc(hidden)]
pub type AssociateLambdaFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateLambdaFunctionInput {
    /// Consumes the builder and constructs an Operation<[`AssociateLambdaFunction`](crate::operation::AssociateLambdaFunction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateLambdaFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateLambdaFunctionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.instance_id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_6, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/lambda-function",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateLambdaFunctionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateLambdaFunctionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_lambda_function(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateLambdaFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateLambdaFunction",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateLambdaFunctionInput`](crate::input::AssociateLambdaFunctionInput)
    pub fn builder() -> crate::input::associate_lambda_function_input::Builder {
        crate::input::associate_lambda_function_input::Builder::default()
    }
}

/// See [`AssociateLexBotInput`](crate::input::AssociateLexBotInput)
pub mod associate_lex_bot_input {
    /// A builder for [`AssociateLexBotInput`](crate::input::AssociateLexBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) lex_bot: std::option::Option<crate::model::LexBot>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The Amazon Lex bot to associate with the instance.</p>
        pub fn lex_bot(mut self, input: crate::model::LexBot) -> Self {
            self.lex_bot = Some(input);
            self
        }
        /// <p>The Amazon Lex bot to associate with the instance.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.lex_bot = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateLexBotInput`](crate::input::AssociateLexBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateLexBotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateLexBotInput {
                instance_id: self.instance_id,
                lex_bot: self.lex_bot,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateLexBotInputOperationOutputAlias = crate::operation::AssociateLexBot;
#[doc(hidden)]
pub type AssociateLexBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateLexBotInput {
    /// Consumes the builder and constructs an Operation<[`AssociateLexBot`](crate::operation::AssociateLexBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateLexBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateLexBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.instance_id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_7, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/lex-bot",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateLexBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateLexBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_lex_bot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateLexBot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateLexBot",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateLexBotInput`](crate::input::AssociateLexBotInput)
    pub fn builder() -> crate::input::associate_lex_bot_input::Builder {
        crate::input::associate_lex_bot_input::Builder::default()
    }
}

/// See [`AssociateQueueQuickConnectsInput`](crate::input::AssociateQueueQuickConnectsInput)
pub mod associate_queue_quick_connects_input {
    /// A builder for [`AssociateQueueQuickConnectsInput`](crate::input::AssociateQueueQuickConnectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) quick_connect_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// Appends an item to `quick_connect_ids`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects to associate with this queue.</p>
        pub fn quick_connect_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.quick_connect_ids.unwrap_or_default();
            v.push(input.into());
            self.quick_connect_ids = Some(v);
            self
        }
        /// <p>The quick connects to associate with this queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.quick_connect_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateQueueQuickConnectsInput`](crate::input::AssociateQueueQuickConnectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateQueueQuickConnectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateQueueQuickConnectsInput {
                instance_id: self.instance_id,
                queue_id: self.queue_id,
                quick_connect_ids: self.quick_connect_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateQueueQuickConnectsInputOperationOutputAlias =
    crate::operation::AssociateQueueQuickConnects;
#[doc(hidden)]
pub type AssociateQueueQuickConnectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateQueueQuickConnectsInput {
    /// Consumes the builder and constructs an Operation<[`AssociateQueueQuickConnects`](crate::operation::AssociateQueueQuickConnects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateQueueQuickConnects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateQueueQuickConnectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.instance_id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_8, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_9 = &_input.queue_id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "queue_id",
                        details: "cannot be empty or unset",
                    })?;
            let queue_id = aws_smithy_http::label::fmt_string(input_9, false);
            if queue_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "queue_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/queues/{InstanceId}/{QueueId}/associate-quick-connects",
                InstanceId = instance_id,
                QueueId = queue_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateQueueQuickConnectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateQueueQuickConnectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_queue_quick_connects(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateQueueQuickConnects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateQueueQuickConnects",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateQueueQuickConnectsInput`](crate::input::AssociateQueueQuickConnectsInput)
    pub fn builder() -> crate::input::associate_queue_quick_connects_input::Builder {
        crate::input::associate_queue_quick_connects_input::Builder::default()
    }
}

/// See [`AssociateRoutingProfileQueuesInput`](crate::input::AssociateRoutingProfileQueuesInput)
pub mod associate_routing_profile_queues_input {
    /// A builder for [`AssociateRoutingProfileQueuesInput`](crate::input::AssociateRoutingProfileQueuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) routing_profile_id: std::option::Option<std::string::String>,
        pub(crate) queue_configs:
            std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_id = input;
            self
        }
        /// Appends an item to `queue_configs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The queues to associate with this routing profile.</p>
        pub fn queue_configs(mut self, input: crate::model::RoutingProfileQueueConfig) -> Self {
            let mut v = self.queue_configs.unwrap_or_default();
            v.push(input);
            self.queue_configs = Some(v);
            self
        }
        /// <p>The queues to associate with this routing profile.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.queue_configs = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateRoutingProfileQueuesInput`](crate::input::AssociateRoutingProfileQueuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateRoutingProfileQueuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateRoutingProfileQueuesInput {
                instance_id: self.instance_id,
                routing_profile_id: self.routing_profile_id,
                queue_configs: self.queue_configs,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateRoutingProfileQueuesInputOperationOutputAlias =
    crate::operation::AssociateRoutingProfileQueues;
#[doc(hidden)]
pub type AssociateRoutingProfileQueuesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AssociateRoutingProfileQueuesInput {
    /// Consumes the builder and constructs an Operation<[`AssociateRoutingProfileQueues`](crate::operation::AssociateRoutingProfileQueues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateRoutingProfileQueues,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateRoutingProfileQueuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_10 = &_input.instance_id;
            let input_10 =
                input_10
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_10, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_11 = &_input.routing_profile_id;
            let input_11 =
                input_11
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let routing_profile_id = aws_smithy_http::label::fmt_string(input_11, false);
            if routing_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "routing_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/routing-profiles/{InstanceId}/{RoutingProfileId}/associate-queues",
                InstanceId = instance_id,
                RoutingProfileId = routing_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateRoutingProfileQueuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateRoutingProfileQueuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_routing_profile_queues(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateRoutingProfileQueues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateRoutingProfileQueues",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateRoutingProfileQueuesInput`](crate::input::AssociateRoutingProfileQueuesInput)
    pub fn builder() -> crate::input::associate_routing_profile_queues_input::Builder {
        crate::input::associate_routing_profile_queues_input::Builder::default()
    }
}

/// See [`AssociateSecurityKeyInput`](crate::input::AssociateSecurityKeyInput)
pub mod associate_security_key_input {
    /// A builder for [`AssociateSecurityKeyInput`](crate::input::AssociateSecurityKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A valid security key in PEM format.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A valid security key in PEM format.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateSecurityKeyInput`](crate::input::AssociateSecurityKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AssociateSecurityKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AssociateSecurityKeyInput {
                instance_id: self.instance_id,
                key: self.key,
            })
        }
    }
}
#[doc(hidden)]
pub type AssociateSecurityKeyInputOperationOutputAlias = crate::operation::AssociateSecurityKey;
#[doc(hidden)]
pub type AssociateSecurityKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AssociateSecurityKeyInput {
    /// Consumes the builder and constructs an Operation<[`AssociateSecurityKey`](crate::operation::AssociateSecurityKey)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AssociateSecurityKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AssociateSecurityKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_12 = &_input.instance_id;
            let input_12 =
                input_12
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_12, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/security-key",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AssociateSecurityKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AssociateSecurityKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_associate_security_key(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AssociateSecurityKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AssociateSecurityKey",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AssociateSecurityKeyInput`](crate::input::AssociateSecurityKeyInput)
    pub fn builder() -> crate::input::associate_security_key_input::Builder {
        crate::input::associate_security_key_input::Builder::default()
    }
}

/// See [`CreateAgentStatusInput`](crate::input::CreateAgentStatusInput)
pub mod create_agent_status_input {
    /// A builder for [`CreateAgentStatusInput`](crate::input::CreateAgentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::AgentStatusState>,
        pub(crate) display_order: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the status.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the status.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the status.</p>
        pub fn state(mut self, input: crate::model::AgentStatusState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the status.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AgentStatusState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The display order of the status.</p>
        pub fn display_order(mut self, input: i32) -> Self {
            self.display_order = Some(input);
            self
        }
        /// <p>The display order of the status.</p>
        pub fn set_display_order(mut self, input: std::option::Option<i32>) -> Self {
            self.display_order = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAgentStatusInput`](crate::input::CreateAgentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateAgentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateAgentStatusInput {
                instance_id: self.instance_id,
                name: self.name,
                description: self.description,
                state: self.state,
                display_order: self.display_order,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateAgentStatusInputOperationOutputAlias = crate::operation::CreateAgentStatus;
#[doc(hidden)]
pub type CreateAgentStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateAgentStatusInput {
    /// Consumes the builder and constructs an Operation<[`CreateAgentStatus`](crate::operation::CreateAgentStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateAgentStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateAgentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_13 = &_input.instance_id;
            let input_13 =
                input_13
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_13, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/agent-status/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateAgentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateAgentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_agent_status(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateAgentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateAgentStatus",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateAgentStatusInput`](crate::input::CreateAgentStatusInput)
    pub fn builder() -> crate::input::create_agent_status_input::Builder {
        crate::input::create_agent_status_input::Builder::default()
    }
}

/// See [`CreateContactFlowInput`](crate::input::CreateContactFlowInput)
pub mod create_contact_flow_input {
    /// A builder for [`CreateContactFlowInput`](crate::input::CreateContactFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::ContactFlowType>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::ContactFlowType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ContactFlowType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The description of the contact flow. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the contact flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The content of the contact flow. </p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the contact flow. </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactFlowInput`](crate::input::CreateContactFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactFlowInput {
                instance_id: self.instance_id,
                name: self.name,
                r#type: self.r#type,
                description: self.description,
                content: self.content,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactFlowInputOperationOutputAlias = crate::operation::CreateContactFlow;
#[doc(hidden)]
pub type CreateContactFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContactFlowInput {
    /// Consumes the builder and constructs an Operation<[`CreateContactFlow`](crate::operation::CreateContactFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContactFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateContactFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.instance_id;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_14, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flows/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateContactFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateContactFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_contact_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContactFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContactFlow",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateContactFlowInput`](crate::input::CreateContactFlowInput)
    pub fn builder() -> crate::input::create_contact_flow_input::Builder {
        crate::input::create_contact_flow_input::Builder::default()
    }
}

/// See [`CreateContactFlowModuleInput`](crate::input::CreateContactFlowModuleInput)
pub mod create_contact_flow_module_input {
    /// A builder for [`CreateContactFlowModuleInput`](crate::input::CreateContactFlowModuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the contact flow module. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the contact flow module. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateContactFlowModuleInput`](crate::input::CreateContactFlowModuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateContactFlowModuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateContactFlowModuleInput {
                instance_id: self.instance_id,
                name: self.name,
                description: self.description,
                content: self.content,
                tags: self.tags,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateContactFlowModuleInputOperationOutputAlias =
    crate::operation::CreateContactFlowModule;
#[doc(hidden)]
pub type CreateContactFlowModuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateContactFlowModuleInput {
    /// Consumes the builder and constructs an Operation<[`CreateContactFlowModule`](crate::operation::CreateContactFlowModule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateContactFlowModule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateContactFlowModuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.instance_id;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_15, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flow-modules/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateContactFlowModuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateContactFlowModuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_contact_flow_module(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateContactFlowModule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateContactFlowModule",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateContactFlowModuleInput`](crate::input::CreateContactFlowModuleInput)
    pub fn builder() -> crate::input::create_contact_flow_module_input::Builder {
        crate::input::create_contact_flow_module_input::Builder::default()
    }
}

/// See [`CreateHoursOfOperationInput`](crate::input::CreateHoursOfOperationInput)
pub mod create_hours_of_operation_input {
    /// A builder for [`CreateHoursOfOperationInput`](crate::input::CreateHoursOfOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) time_zone: std::option::Option<std::string::String>,
        pub(crate) config: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_zone = Some(input.into());
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_zone = input;
            self
        }
        /// Appends an item to `config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>Configuration information for the hours of operation: day, start time, and end time.</p>
        pub fn config(mut self, input: crate::model::HoursOfOperationConfig) -> Self {
            let mut v = self.config.unwrap_or_default();
            v.push(input);
            self.config = Some(v);
            self
        }
        /// <p>Configuration information for the hours of operation: day, start time, and end time.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        ) -> Self {
            self.config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHoursOfOperationInput`](crate::input::CreateHoursOfOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateHoursOfOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateHoursOfOperationInput {
                instance_id: self.instance_id,
                name: self.name,
                description: self.description,
                time_zone: self.time_zone,
                config: self.config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateHoursOfOperationInputOperationOutputAlias = crate::operation::CreateHoursOfOperation;
#[doc(hidden)]
pub type CreateHoursOfOperationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateHoursOfOperationInput {
    /// Consumes the builder and constructs an Operation<[`CreateHoursOfOperation`](crate::operation::CreateHoursOfOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateHoursOfOperation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateHoursOfOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.instance_id;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_16, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/hours-of-operations/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateHoursOfOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateHoursOfOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_hours_of_operation(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateHoursOfOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateHoursOfOperation",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateHoursOfOperationInput`](crate::input::CreateHoursOfOperationInput)
    pub fn builder() -> crate::input::create_hours_of_operation_input::Builder {
        crate::input::create_hours_of_operation_input::Builder::default()
    }
}

/// See [`CreateInstanceInput`](crate::input::CreateInstanceInput)
pub mod create_instance_input {
    /// A builder for [`CreateInstanceInput`](crate::input::CreateInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) identity_management_type: std::option::Option<crate::model::DirectoryType>,
        pub(crate) instance_alias: std::option::Option<std::string::String>,
        pub(crate) directory_id: std::option::Option<std::string::String>,
        pub(crate) inbound_calls_enabled: std::option::Option<bool>,
        pub(crate) outbound_calls_enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>The idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The type of identity management for your Amazon Connect users.</p>
        pub fn identity_management_type(mut self, input: crate::model::DirectoryType) -> Self {
            self.identity_management_type = Some(input);
            self
        }
        /// <p>The type of identity management for your Amazon Connect users.</p>
        pub fn set_identity_management_type(
            mut self,
            input: std::option::Option<crate::model::DirectoryType>,
        ) -> Self {
            self.identity_management_type = input;
            self
        }
        /// <p>The name for your instance.</p>
        pub fn instance_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_alias = Some(input.into());
            self
        }
        /// <p>The name for your instance.</p>
        pub fn set_instance_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_alias = input;
            self
        }
        /// <p>The identifier for the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_id = Some(input.into());
            self
        }
        /// <p>The identifier for the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.directory_id = input;
            self
        }
        /// <p>Your contact center handles incoming contacts.</p>
        pub fn inbound_calls_enabled(mut self, input: bool) -> Self {
            self.inbound_calls_enabled = Some(input);
            self
        }
        /// <p>Your contact center handles incoming contacts.</p>
        pub fn set_inbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inbound_calls_enabled = input;
            self
        }
        /// <p>Your contact center allows outbound calls.</p>
        pub fn outbound_calls_enabled(mut self, input: bool) -> Self {
            self.outbound_calls_enabled = Some(input);
            self
        }
        /// <p>Your contact center allows outbound calls.</p>
        pub fn set_outbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.outbound_calls_enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInstanceInput`](crate::input::CreateInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInstanceInput {
                client_token: self.client_token,
                identity_management_type: self.identity_management_type,
                instance_alias: self.instance_alias,
                directory_id: self.directory_id,
                inbound_calls_enabled: self.inbound_calls_enabled,
                outbound_calls_enabled: self.outbound_calls_enabled,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInstanceInputOperationOutputAlias = crate::operation::CreateInstance;
#[doc(hidden)]
pub type CreateInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateInstance`](crate::operation::CreateInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/instance").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_instance(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInstance",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInstanceInput`](crate::input::CreateInstanceInput)
    pub fn builder() -> crate::input::create_instance_input::Builder {
        crate::input::create_instance_input::Builder::default()
    }
}

/// See [`CreateIntegrationAssociationInput`](crate::input::CreateIntegrationAssociationInput)
pub mod create_integration_association_input {
    /// A builder for [`CreateIntegrationAssociationInput`](crate::input::CreateIntegrationAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) integration_arn: std::option::Option<std::string::String>,
        pub(crate) source_application_url: std::option::Option<std::string::String>,
        pub(crate) source_application_name: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The type of information to be ingested.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The type of information to be ingested.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the integration.</p>
        pub fn integration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the integration.</p>
        pub fn set_integration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_arn = input;
            self
        }
        /// <p>The URL for the external application. This field is only required for the EVENT integration type.</p>
        pub fn source_application_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_application_url = Some(input.into());
            self
        }
        /// <p>The URL for the external application. This field is only required for the EVENT integration type.</p>
        pub fn set_source_application_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_application_url = input;
            self
        }
        /// <p>The name of the external application. This field is only required for the EVENT integration type.</p>
        pub fn source_application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_application_name = Some(input.into());
            self
        }
        /// <p>The name of the external application. This field is only required for the EVENT integration type.</p>
        pub fn set_source_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_application_name = input;
            self
        }
        /// <p>The type of the data source. This field is only required for the EVENT integration type.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The type of the data source. This field is only required for the EVENT integration type.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateIntegrationAssociationInput`](crate::input::CreateIntegrationAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateIntegrationAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateIntegrationAssociationInput {
                instance_id: self.instance_id,
                integration_type: self.integration_type,
                integration_arn: self.integration_arn,
                source_application_url: self.source_application_url,
                source_application_name: self.source_application_name,
                source_type: self.source_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateIntegrationAssociationInputOperationOutputAlias =
    crate::operation::CreateIntegrationAssociation;
#[doc(hidden)]
pub type CreateIntegrationAssociationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateIntegrationAssociationInput {
    /// Consumes the builder and constructs an Operation<[`CreateIntegrationAssociation`](crate::operation::CreateIntegrationAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateIntegrationAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateIntegrationAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.instance_id;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_17, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/integration-associations",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateIntegrationAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateIntegrationAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_integration_association(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateIntegrationAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateIntegrationAssociation",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateIntegrationAssociationInput`](crate::input::CreateIntegrationAssociationInput)
    pub fn builder() -> crate::input::create_integration_association_input::Builder {
        crate::input::create_integration_association_input::Builder::default()
    }
}

/// See [`CreateQueueInput`](crate::input::CreateQueueInput)
pub mod create_queue_input {
    /// A builder for [`CreateQueueInput`](crate::input::CreateQueueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) outbound_caller_config: std::option::Option<crate::model::OutboundCallerConfig>,
        pub(crate) hours_of_operation_id: std::option::Option<std::string::String>,
        pub(crate) max_contacts: std::option::Option<i32>,
        pub(crate) quick_connect_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the queue.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the queue.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the queue.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn outbound_caller_config(mut self, input: crate::model::OutboundCallerConfig) -> Self {
            self.outbound_caller_config = Some(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn set_outbound_caller_config(
            mut self,
            input: std::option::Option<crate::model::OutboundCallerConfig>,
        ) -> Self {
            self.outbound_caller_config = input;
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hours_of_operation_id = Some(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hours_of_operation_id = input;
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn max_contacts(mut self, input: i32) -> Self {
            self.max_contacts = Some(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn set_max_contacts(mut self, input: std::option::Option<i32>) -> Self {
            self.max_contacts = input;
            self
        }
        /// Appends an item to `quick_connect_ids`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects available to agents who are working the queue.</p>
        pub fn quick_connect_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.quick_connect_ids.unwrap_or_default();
            v.push(input.into());
            self.quick_connect_ids = Some(v);
            self
        }
        /// <p>The quick connects available to agents who are working the queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.quick_connect_ids = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQueueInput`](crate::input::CreateQueueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateQueueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateQueueInput {
                instance_id: self.instance_id,
                name: self.name,
                description: self.description,
                outbound_caller_config: self.outbound_caller_config,
                hours_of_operation_id: self.hours_of_operation_id,
                max_contacts: self.max_contacts,
                quick_connect_ids: self.quick_connect_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateQueueInputOperationOutputAlias = crate::operation::CreateQueue;
#[doc(hidden)]
pub type CreateQueueInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateQueueInput {
    /// Consumes the builder and constructs an Operation<[`CreateQueue`](crate::operation::CreateQueue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateQueue,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateQueueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.instance_id;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_18, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/queues/{InstanceId}", InstanceId = instance_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateQueueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateQueueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_queue(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateQueue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateQueue",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateQueueInput`](crate::input::CreateQueueInput)
    pub fn builder() -> crate::input::create_queue_input::Builder {
        crate::input::create_queue_input::Builder::default()
    }
}

/// See [`CreateQuickConnectInput`](crate::input::CreateQuickConnectInput)
pub mod create_quick_connect_input {
    /// A builder for [`CreateQuickConnectInput`](crate::input::CreateQuickConnectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) quick_connect_config: std::option::Option<crate::model::QuickConnectConfig>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Configuration settings for the quick connect.</p>
        pub fn quick_connect_config(mut self, input: crate::model::QuickConnectConfig) -> Self {
            self.quick_connect_config = Some(input);
            self
        }
        /// <p>Configuration settings for the quick connect.</p>
        pub fn set_quick_connect_config(
            mut self,
            input: std::option::Option<crate::model::QuickConnectConfig>,
        ) -> Self {
            self.quick_connect_config = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQuickConnectInput`](crate::input::CreateQuickConnectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateQuickConnectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateQuickConnectInput {
                instance_id: self.instance_id,
                name: self.name,
                description: self.description,
                quick_connect_config: self.quick_connect_config,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateQuickConnectInputOperationOutputAlias = crate::operation::CreateQuickConnect;
#[doc(hidden)]
pub type CreateQuickConnectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateQuickConnectInput {
    /// Consumes the builder and constructs an Operation<[`CreateQuickConnect`](crate::operation::CreateQuickConnect)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateQuickConnect,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateQuickConnectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_19 = &_input.instance_id;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_19, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/quick-connects/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateQuickConnectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateQuickConnectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_quick_connect(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateQuickConnect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateQuickConnect",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateQuickConnectInput`](crate::input::CreateQuickConnectInput)
    pub fn builder() -> crate::input::create_quick_connect_input::Builder {
        crate::input::create_quick_connect_input::Builder::default()
    }
}

/// See [`CreateRoutingProfileInput`](crate::input::CreateRoutingProfileInput)
pub mod create_routing_profile_input {
    /// A builder for [`CreateRoutingProfileInput`](crate::input::CreateRoutingProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) default_outbound_queue_id: std::option::Option<std::string::String>,
        pub(crate) queue_configs:
            std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        pub(crate) media_concurrencies:
            std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Description of the routing profile. Must not be more than 250 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Description of the routing profile. Must not be more than 250 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The default outbound queue for the routing profile.</p>
        pub fn default_outbound_queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_outbound_queue_id = Some(input.into());
            self
        }
        /// <p>The default outbound queue for the routing profile.</p>
        pub fn set_default_outbound_queue_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_outbound_queue_id = input;
            self
        }
        /// Appends an item to `queue_configs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.</p>
        pub fn queue_configs(mut self, input: crate::model::RoutingProfileQueueConfig) -> Self {
            let mut v = self.queue_configs.unwrap_or_default();
            v.push(input);
            self.queue_configs = Some(v);
            self
        }
        /// <p>The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.queue_configs = input;
            self
        }
        /// Appends an item to `media_concurrencies`.
        ///
        /// To override the contents of this collection use [`set_media_concurrencies`](Self::set_media_concurrencies).
        ///
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>
        pub fn media_concurrencies(mut self, input: crate::model::MediaConcurrency) -> Self {
            let mut v = self.media_concurrencies.unwrap_or_default();
            v.push(input);
            self.media_concurrencies = Some(v);
            self
        }
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>
        pub fn set_media_concurrencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        ) -> Self {
            self.media_concurrencies = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRoutingProfileInput`](crate::input::CreateRoutingProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRoutingProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRoutingProfileInput {
                instance_id: self.instance_id,
                name: self.name,
                description: self.description,
                default_outbound_queue_id: self.default_outbound_queue_id,
                queue_configs: self.queue_configs,
                media_concurrencies: self.media_concurrencies,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRoutingProfileInputOperationOutputAlias = crate::operation::CreateRoutingProfile;
#[doc(hidden)]
pub type CreateRoutingProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateRoutingProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateRoutingProfile`](crate::operation::CreateRoutingProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRoutingProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRoutingProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.instance_id;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_20, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/routing-profiles/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRoutingProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRoutingProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_routing_profile(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRoutingProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRoutingProfile",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRoutingProfileInput`](crate::input::CreateRoutingProfileInput)
    pub fn builder() -> crate::input::create_routing_profile_input::Builder {
        crate::input::create_routing_profile_input::Builder::default()
    }
}

/// See [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
pub mod create_security_profile_input {
    /// A builder for [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) permissions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_name = input;
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Permissions assigned to the security profile.</p>
        pub fn permissions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.permissions.unwrap_or_default();
            v.push(input.into());
            self.permissions = Some(v);
            self
        }
        /// <p>Permissions assigned to the security profile.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.permissions = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSecurityProfileInput {
                security_profile_name: self.security_profile_name,
                description: self.description,
                permissions: self.permissions,
                instance_id: self.instance_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSecurityProfileInputOperationOutputAlias = crate::operation::CreateSecurityProfile;
#[doc(hidden)]
pub type CreateSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`CreateSecurityProfile`](crate::operation::CreateSecurityProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSecurityProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.instance_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_21, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/security-profiles/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSecurityProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSecurityProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_security_profile(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSecurityProfile",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSecurityProfileInput`](crate::input::CreateSecurityProfileInput)
    pub fn builder() -> crate::input::create_security_profile_input::Builder {
        crate::input::create_security_profile_input::Builder::default()
    }
}

/// See [`CreateUseCaseInput`](crate::input::CreateUseCaseInput)
pub mod create_use_case_input {
    /// A builder for [`CreateUseCaseInput`](crate::input::CreateUseCaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) integration_association_id: std::option::Option<std::string::String>,
        pub(crate) use_case_type: std::option::Option<crate::model::UseCaseType>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_association_id = Some(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_association_id = input;
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>
        pub fn use_case_type(mut self, input: crate::model::UseCaseType) -> Self {
            self.use_case_type = Some(input);
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>
        pub fn set_use_case_type(
            mut self,
            input: std::option::Option<crate::model::UseCaseType>,
        ) -> Self {
            self.use_case_type = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUseCaseInput`](crate::input::CreateUseCaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUseCaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUseCaseInput {
                instance_id: self.instance_id,
                integration_association_id: self.integration_association_id,
                use_case_type: self.use_case_type,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUseCaseInputOperationOutputAlias = crate::operation::CreateUseCase;
#[doc(hidden)]
pub type CreateUseCaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUseCaseInput {
    /// Consumes the builder and constructs an Operation<[`CreateUseCase`](crate::operation::CreateUseCase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUseCase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUseCaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.instance_id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_22, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.integration_association_id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_association_id",
                        details: "cannot be empty or unset",
                    })?;
            let integration_association_id = aws_smithy_http::label::fmt_string(input_23, false);
            if integration_association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "integration_association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases", InstanceId = instance_id, IntegrationAssociationId = integration_association_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUseCaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUseCaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_use_case(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUseCase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUseCase",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUseCaseInput`](crate::input::CreateUseCaseInput)
    pub fn builder() -> crate::input::create_use_case_input::Builder {
        crate::input::create_use_case_input::Builder::default()
    }
}

/// See [`CreateUserInput`](crate::input::CreateUserInput)
pub mod create_user_input {
    /// A builder for [`CreateUserInput`](crate::input::CreateUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) username: std::option::Option<std::string::String>,
        pub(crate) password: std::option::Option<std::string::String>,
        pub(crate) identity_info: std::option::Option<crate::model::UserIdentityInfo>,
        pub(crate) phone_config: std::option::Option<crate::model::UserPhoneConfig>,
        pub(crate) directory_user_id: std::option::Option<std::string::String>,
        pub(crate) security_profile_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) routing_profile_id: std::option::Option<std::string::String>,
        pub(crate) hierarchy_group_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// <p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// <p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.password = Some(input.into());
            self
        }
        /// <p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.password = input;
            self
        }
        /// <p>The information about the identity of the user.</p>
        pub fn identity_info(mut self, input: crate::model::UserIdentityInfo) -> Self {
            self.identity_info = Some(input);
            self
        }
        /// <p>The information about the identity of the user.</p>
        pub fn set_identity_info(
            mut self,
            input: std::option::Option<crate::model::UserIdentityInfo>,
        ) -> Self {
            self.identity_info = input;
            self
        }
        /// <p>The phone settings for the user.</p>
        pub fn phone_config(mut self, input: crate::model::UserPhoneConfig) -> Self {
            self.phone_config = Some(input);
            self
        }
        /// <p>The phone settings for the user.</p>
        pub fn set_phone_config(
            mut self,
            input: std::option::Option<crate::model::UserPhoneConfig>,
        ) -> Self {
            self.phone_config = input;
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p>
        /// <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>
        pub fn directory_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.directory_user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p>
        /// <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>
        pub fn set_directory_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.directory_user_id = input;
            self
        }
        /// Appends an item to `security_profile_ids`.
        ///
        /// To override the contents of this collection use [`set_security_profile_ids`](Self::set_security_profile_ids).
        ///
        /// <p>The identifier of the security profile for the user.</p>
        pub fn security_profile_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_profile_ids.unwrap_or_default();
            v.push(input.into());
            self.security_profile_ids = Some(v);
            self
        }
        /// <p>The identifier of the security profile for the user.</p>
        pub fn set_security_profile_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_profile_ids = input;
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_id = input;
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hierarchy_group_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserInput`](crate::input::CreateUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserInput {
                username: self.username,
                password: self.password,
                identity_info: self.identity_info,
                phone_config: self.phone_config,
                directory_user_id: self.directory_user_id,
                security_profile_ids: self.security_profile_ids,
                routing_profile_id: self.routing_profile_id,
                hierarchy_group_id: self.hierarchy_group_id,
                instance_id: self.instance_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserInputOperationOutputAlias = crate::operation::CreateUser;
#[doc(hidden)]
pub type CreateUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserInput {
    /// Consumes the builder and constructs an Operation<[`CreateUser`](crate::operation::CreateUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.instance_id;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_24, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/users/{InstanceId}", InstanceId = instance_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_user(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUser",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserInput`](crate::input::CreateUserInput)
    pub fn builder() -> crate::input::create_user_input::Builder {
        crate::input::create_user_input::Builder::default()
    }
}

/// See [`CreateUserHierarchyGroupInput`](crate::input::CreateUserHierarchyGroupInput)
pub mod create_user_hierarchy_group_input {
    /// A builder for [`CreateUserHierarchyGroupInput`](crate::input::CreateUserHierarchyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) parent_group_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The name of the user hierarchy group. Must not be more than 100 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the user hierarchy group. Must not be more than 100 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.</p>
        pub fn parent_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.parent_group_id = Some(input.into());
            self
        }
        /// <p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.</p>
        pub fn set_parent_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parent_group_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUserHierarchyGroupInput`](crate::input::CreateUserHierarchyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateUserHierarchyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateUserHierarchyGroupInput {
                name: self.name,
                parent_group_id: self.parent_group_id,
                instance_id: self.instance_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateUserHierarchyGroupInputOperationOutputAlias =
    crate::operation::CreateUserHierarchyGroup;
#[doc(hidden)]
pub type CreateUserHierarchyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateUserHierarchyGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateUserHierarchyGroup`](crate::operation::CreateUserHierarchyGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateUserHierarchyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateUserHierarchyGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_25 = &_input.instance_id;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_25, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/user-hierarchy-groups/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateUserHierarchyGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateUserHierarchyGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_user_hierarchy_group(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateUserHierarchyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateUserHierarchyGroup",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateUserHierarchyGroupInput`](crate::input::CreateUserHierarchyGroupInput)
    pub fn builder() -> crate::input::create_user_hierarchy_group_input::Builder {
        crate::input::create_user_hierarchy_group_input::Builder::default()
    }
}

/// See [`CreateVocabularyInput`](crate::input::CreateVocabularyInput)
pub mod create_vocabulary_input {
    /// A builder for [`CreateVocabularyInput`](crate::input::CreateVocabularyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) vocabulary_name: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::VocabularyLanguageCode>,
        pub(crate) content: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If a create request is received more than once with same client token, subsequent requests return the previous response without creating a vocabulary again.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If a create request is received more than once with same client token, subsequent requests return the previous response without creating a vocabulary again.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A unique name of the custom vocabulary.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_name = Some(input.into());
            self
        }
        /// <p>A unique name of the custom vocabulary.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_name = input;
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with <code>Phrase</code>, <code>IPA</code>, <code>SoundsLike</code>, and <code>DisplayAs</code> fields. Separate the fields with TAB characters. The size limit is 50KB. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table">Create a custom vocabulary using a table</a>.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.content = Some(input.into());
            self
        }
        /// <p>The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with <code>Phrase</code>, <code>IPA</code>, <code>SoundsLike</code>, and <code>DisplayAs</code> fields. Separate the fields with TAB characters. The size limit is 50KB. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table">Create a custom vocabulary using a table</a>.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateVocabularyInput`](crate::input::CreateVocabularyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateVocabularyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateVocabularyInput {
                client_token: self.client_token,
                instance_id: self.instance_id,
                vocabulary_name: self.vocabulary_name,
                language_code: self.language_code,
                content: self.content,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateVocabularyInputOperationOutputAlias = crate::operation::CreateVocabulary;
#[doc(hidden)]
pub type CreateVocabularyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateVocabularyInput {
    /// Consumes the builder and constructs an Operation<[`CreateVocabulary`](crate::operation::CreateVocabulary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateVocabulary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateVocabularyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.instance_id;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_26, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/vocabulary/{InstanceId}", InstanceId = instance_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateVocabularyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateVocabularyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_vocabulary(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateVocabulary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateVocabulary",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateVocabularyInput`](crate::input::CreateVocabularyInput)
    pub fn builder() -> crate::input::create_vocabulary_input::Builder {
        crate::input::create_vocabulary_input::Builder::default()
    }
}

/// See [`DeleteContactFlowInput`](crate::input::DeleteContactFlowInput)
pub mod delete_contact_flow_input {
    /// A builder for [`DeleteContactFlowInput`](crate::input::DeleteContactFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactFlowInput`](crate::input::DeleteContactFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactFlowInput {
                instance_id: self.instance_id,
                contact_flow_id: self.contact_flow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactFlowInputOperationOutputAlias = crate::operation::DeleteContactFlow;
#[doc(hidden)]
pub type DeleteContactFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContactFlowInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContactFlow`](crate::operation::DeleteContactFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContactFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteContactFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.instance_id;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_27, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_28 = &_input.contact_flow_id;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_flow_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_flow_id = aws_smithy_http::label::fmt_string(input_28, false);
            if contact_flow_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_flow_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flows/{InstanceId}/{ContactFlowId}",
                InstanceId = instance_id,
                ContactFlowId = contact_flow_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteContactFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteContactFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContactFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContactFlow",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactFlowInput`](crate::input::DeleteContactFlowInput)
    pub fn builder() -> crate::input::delete_contact_flow_input::Builder {
        crate::input::delete_contact_flow_input::Builder::default()
    }
}

/// See [`DeleteContactFlowModuleInput`](crate::input::DeleteContactFlowModuleInput)
pub mod delete_contact_flow_module_input {
    /// A builder for [`DeleteContactFlowModuleInput`](crate::input::DeleteContactFlowModuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_module_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_module_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_module_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteContactFlowModuleInput`](crate::input::DeleteContactFlowModuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteContactFlowModuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteContactFlowModuleInput {
                instance_id: self.instance_id,
                contact_flow_module_id: self.contact_flow_module_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteContactFlowModuleInputOperationOutputAlias =
    crate::operation::DeleteContactFlowModule;
#[doc(hidden)]
pub type DeleteContactFlowModuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteContactFlowModuleInput {
    /// Consumes the builder and constructs an Operation<[`DeleteContactFlowModule`](crate::operation::DeleteContactFlowModule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteContactFlowModule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteContactFlowModuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.instance_id;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_29, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_30 = &_input.contact_flow_module_id;
            let input_30 =
                input_30
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_flow_module_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_flow_module_id = aws_smithy_http::label::fmt_string(input_30, false);
            if contact_flow_module_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_flow_module_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}",
                InstanceId = instance_id,
                ContactFlowModuleId = contact_flow_module_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteContactFlowModuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteContactFlowModuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteContactFlowModule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteContactFlowModule",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteContactFlowModuleInput`](crate::input::DeleteContactFlowModuleInput)
    pub fn builder() -> crate::input::delete_contact_flow_module_input::Builder {
        crate::input::delete_contact_flow_module_input::Builder::default()
    }
}

/// See [`DeleteHoursOfOperationInput`](crate::input::DeleteHoursOfOperationInput)
pub mod delete_hours_of_operation_input {
    /// A builder for [`DeleteHoursOfOperationInput`](crate::input::DeleteHoursOfOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) hours_of_operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hours_of_operation_id = Some(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hours_of_operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteHoursOfOperationInput`](crate::input::DeleteHoursOfOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteHoursOfOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteHoursOfOperationInput {
                instance_id: self.instance_id,
                hours_of_operation_id: self.hours_of_operation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteHoursOfOperationInputOperationOutputAlias = crate::operation::DeleteHoursOfOperation;
#[doc(hidden)]
pub type DeleteHoursOfOperationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteHoursOfOperationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteHoursOfOperation`](crate::operation::DeleteHoursOfOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteHoursOfOperation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteHoursOfOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_31 = &_input.instance_id;
            let input_31 =
                input_31
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_31, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_32 = &_input.hours_of_operation_id;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hours_of_operation_id",
                        details: "cannot be empty or unset",
                    })?;
            let hours_of_operation_id = aws_smithy_http::label::fmt_string(input_32, false);
            if hours_of_operation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hours_of_operation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
                InstanceId = instance_id,
                HoursOfOperationId = hours_of_operation_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteHoursOfOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteHoursOfOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteHoursOfOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteHoursOfOperation",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteHoursOfOperationInput`](crate::input::DeleteHoursOfOperationInput)
    pub fn builder() -> crate::input::delete_hours_of_operation_input::Builder {
        crate::input::delete_hours_of_operation_input::Builder::default()
    }
}

/// See [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
pub mod delete_instance_input {
    /// A builder for [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInstanceInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInstanceInputOperationOutputAlias = crate::operation::DeleteInstance;
#[doc(hidden)]
pub type DeleteInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInstance`](crate::operation::DeleteInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.instance_id;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_33, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/instance/{InstanceId}", InstanceId = instance_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInstance",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInstanceInput`](crate::input::DeleteInstanceInput)
    pub fn builder() -> crate::input::delete_instance_input::Builder {
        crate::input::delete_instance_input::Builder::default()
    }
}

/// See [`DeleteIntegrationAssociationInput`](crate::input::DeleteIntegrationAssociationInput)
pub mod delete_integration_association_input {
    /// A builder for [`DeleteIntegrationAssociationInput`](crate::input::DeleteIntegrationAssociationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) integration_association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_association_id = Some(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteIntegrationAssociationInput`](crate::input::DeleteIntegrationAssociationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteIntegrationAssociationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteIntegrationAssociationInput {
                instance_id: self.instance_id,
                integration_association_id: self.integration_association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteIntegrationAssociationInputOperationOutputAlias =
    crate::operation::DeleteIntegrationAssociation;
#[doc(hidden)]
pub type DeleteIntegrationAssociationInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteIntegrationAssociationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteIntegrationAssociation`](crate::operation::DeleteIntegrationAssociation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteIntegrationAssociation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteIntegrationAssociationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_34 = &_input.instance_id;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_34, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_35 = &_input.integration_association_id;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_association_id",
                        details: "cannot be empty or unset",
                    })?;
            let integration_association_id = aws_smithy_http::label::fmt_string(input_35, false);
            if integration_association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "integration_association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}",
                InstanceId = instance_id,
                IntegrationAssociationId = integration_association_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteIntegrationAssociationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteIntegrationAssociationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteIntegrationAssociation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteIntegrationAssociation",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteIntegrationAssociationInput`](crate::input::DeleteIntegrationAssociationInput)
    pub fn builder() -> crate::input::delete_integration_association_input::Builder {
        crate::input::delete_integration_association_input::Builder::default()
    }
}

/// See [`DeleteQuickConnectInput`](crate::input::DeleteQuickConnectInput)
pub mod delete_quick_connect_input {
    /// A builder for [`DeleteQuickConnectInput`](crate::input::DeleteQuickConnectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) quick_connect_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.quick_connect_id = Some(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quick_connect_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteQuickConnectInput`](crate::input::DeleteQuickConnectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteQuickConnectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteQuickConnectInput {
                instance_id: self.instance_id,
                quick_connect_id: self.quick_connect_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteQuickConnectInputOperationOutputAlias = crate::operation::DeleteQuickConnect;
#[doc(hidden)]
pub type DeleteQuickConnectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteQuickConnectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteQuickConnect`](crate::operation::DeleteQuickConnect)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteQuickConnect,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteQuickConnectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_36 = &_input.instance_id;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_36, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_37 = &_input.quick_connect_id;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "quick_connect_id",
                        details: "cannot be empty or unset",
                    })?;
            let quick_connect_id = aws_smithy_http::label::fmt_string(input_37, false);
            if quick_connect_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "quick_connect_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/quick-connects/{InstanceId}/{QuickConnectId}",
                InstanceId = instance_id,
                QuickConnectId = quick_connect_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteQuickConnectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteQuickConnectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteQuickConnect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteQuickConnect",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteQuickConnectInput`](crate::input::DeleteQuickConnectInput)
    pub fn builder() -> crate::input::delete_quick_connect_input::Builder {
        crate::input::delete_quick_connect_input::Builder::default()
    }
}

/// See [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
pub mod delete_security_profile_input {
    /// A builder for [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) security_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteSecurityProfileInput {
                instance_id: self.instance_id,
                security_profile_id: self.security_profile_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteSecurityProfileInputOperationOutputAlias = crate::operation::DeleteSecurityProfile;
#[doc(hidden)]
pub type DeleteSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`DeleteSecurityProfile`](crate::operation::DeleteSecurityProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteSecurityProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_38 = &_input.instance_id;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_38, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_39 = &_input.security_profile_id;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let security_profile_id = aws_smithy_http::label::fmt_string(input_39, false);
            if security_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "security_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/security-profiles/{InstanceId}/{SecurityProfileId}",
                InstanceId = instance_id,
                SecurityProfileId = security_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteSecurityProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteSecurityProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteSecurityProfile",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteSecurityProfileInput`](crate::input::DeleteSecurityProfileInput)
    pub fn builder() -> crate::input::delete_security_profile_input::Builder {
        crate::input::delete_security_profile_input::Builder::default()
    }
}

/// See [`DeleteUseCaseInput`](crate::input::DeleteUseCaseInput)
pub mod delete_use_case_input {
    /// A builder for [`DeleteUseCaseInput`](crate::input::DeleteUseCaseInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) integration_association_id: std::option::Option<std::string::String>,
        pub(crate) use_case_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_association_id = Some(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_association_id = input;
            self
        }
        /// <p>The identifier for the use case.</p>
        pub fn use_case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.use_case_id = Some(input.into());
            self
        }
        /// <p>The identifier for the use case.</p>
        pub fn set_use_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.use_case_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUseCaseInput`](crate::input::DeleteUseCaseInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUseCaseInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUseCaseInput {
                instance_id: self.instance_id,
                integration_association_id: self.integration_association_id,
                use_case_id: self.use_case_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUseCaseInputOperationOutputAlias = crate::operation::DeleteUseCase;
#[doc(hidden)]
pub type DeleteUseCaseInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUseCaseInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUseCase`](crate::operation::DeleteUseCase)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUseCase,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUseCaseInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_40 = &_input.instance_id;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_40, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_41 = &_input.integration_association_id;
            let input_41 =
                input_41
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_association_id",
                        details: "cannot be empty or unset",
                    })?;
            let integration_association_id = aws_smithy_http::label::fmt_string(input_41, false);
            if integration_association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "integration_association_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_42 = &_input.use_case_id;
            let input_42 =
                input_42
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "use_case_id",
                        details: "cannot be empty or unset",
                    })?;
            let use_case_id = aws_smithy_http::label::fmt_string(input_42, false);
            if use_case_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "use_case_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases/{UseCaseId}", InstanceId = instance_id, IntegrationAssociationId = integration_association_id, UseCaseId = use_case_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUseCaseInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUseCaseInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUseCase::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUseCase",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUseCaseInput`](crate::input::DeleteUseCaseInput)
    pub fn builder() -> crate::input::delete_use_case_input::Builder {
        crate::input::delete_use_case_input::Builder::default()
    }
}

/// See [`DeleteUserInput`](crate::input::DeleteUserInput)
pub mod delete_user_input {
    /// A builder for [`DeleteUserInput`](crate::input::DeleteUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) user_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserInput`](crate::input::DeleteUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserInput {
                instance_id: self.instance_id,
                user_id: self.user_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserInputOperationOutputAlias = crate::operation::DeleteUser;
#[doc(hidden)]
pub type DeleteUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUser`](crate::operation::DeleteUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_43 = &_input.instance_id;
            let input_43 =
                input_43
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_43, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_44 = &_input.user_id;
            let input_44 =
                input_44
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_44, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/users/{InstanceId}/{UserId}",
                InstanceId = instance_id,
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUser",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserInput`](crate::input::DeleteUserInput)
    pub fn builder() -> crate::input::delete_user_input::Builder {
        crate::input::delete_user_input::Builder::default()
    }
}

/// See [`DeleteUserHierarchyGroupInput`](crate::input::DeleteUserHierarchyGroupInput)
pub mod delete_user_hierarchy_group_input {
    /// A builder for [`DeleteUserHierarchyGroupInput`](crate::input::DeleteUserHierarchyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hierarchy_group_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hierarchy_group_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteUserHierarchyGroupInput`](crate::input::DeleteUserHierarchyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteUserHierarchyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteUserHierarchyGroupInput {
                hierarchy_group_id: self.hierarchy_group_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteUserHierarchyGroupInputOperationOutputAlias =
    crate::operation::DeleteUserHierarchyGroup;
#[doc(hidden)]
pub type DeleteUserHierarchyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteUserHierarchyGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteUserHierarchyGroup`](crate::operation::DeleteUserHierarchyGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteUserHierarchyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteUserHierarchyGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_45 = &_input.instance_id;
            let input_45 =
                input_45
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_45, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_46 = &_input.hierarchy_group_id;
            let input_46 =
                input_46
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hierarchy_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let hierarchy_group_id = aws_smithy_http::label::fmt_string(input_46, false);
            if hierarchy_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hierarchy_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
                InstanceId = instance_id,
                HierarchyGroupId = hierarchy_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteUserHierarchyGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteUserHierarchyGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteUserHierarchyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteUserHierarchyGroup",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteUserHierarchyGroupInput`](crate::input::DeleteUserHierarchyGroupInput)
    pub fn builder() -> crate::input::delete_user_hierarchy_group_input::Builder {
        crate::input::delete_user_hierarchy_group_input::Builder::default()
    }
}

/// See [`DeleteVocabularyInput`](crate::input::DeleteVocabularyInput)
pub mod delete_vocabulary_input {
    /// A builder for [`DeleteVocabularyInput`](crate::input::DeleteVocabularyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) vocabulary_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn vocabulary_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_id = Some(input.into());
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn set_vocabulary_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteVocabularyInput`](crate::input::DeleteVocabularyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteVocabularyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteVocabularyInput {
                instance_id: self.instance_id,
                vocabulary_id: self.vocabulary_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteVocabularyInputOperationOutputAlias = crate::operation::DeleteVocabulary;
#[doc(hidden)]
pub type DeleteVocabularyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteVocabularyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteVocabulary`](crate::operation::DeleteVocabulary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteVocabulary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteVocabularyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_47 = &_input.instance_id;
            let input_47 =
                input_47
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_47, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_48 = &_input.vocabulary_id;
            let input_48 =
                input_48
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vocabulary_id",
                        details: "cannot be empty or unset",
                    })?;
            let vocabulary_id = aws_smithy_http::label::fmt_string(input_48, false);
            if vocabulary_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vocabulary_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/vocabulary-remove/{InstanceId}/{VocabularyId}",
                InstanceId = instance_id,
                VocabularyId = vocabulary_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteVocabularyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteVocabularyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteVocabulary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteVocabulary",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteVocabularyInput`](crate::input::DeleteVocabularyInput)
    pub fn builder() -> crate::input::delete_vocabulary_input::Builder {
        crate::input::delete_vocabulary_input::Builder::default()
    }
}

/// See [`DescribeAgentStatusInput`](crate::input::DescribeAgentStatusInput)
pub mod describe_agent_status_input {
    /// A builder for [`DescribeAgentStatusInput`](crate::input::DescribeAgentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) agent_status_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the agent status.</p>
        pub fn agent_status_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_status_id = Some(input.into());
            self
        }
        /// <p>The identifier for the agent status.</p>
        pub fn set_agent_status_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_status_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAgentStatusInput`](crate::input::DescribeAgentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAgentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAgentStatusInput {
                instance_id: self.instance_id,
                agent_status_id: self.agent_status_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeAgentStatusInputOperationOutputAlias = crate::operation::DescribeAgentStatus;
#[doc(hidden)]
pub type DescribeAgentStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAgentStatusInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAgentStatus`](crate::operation::DescribeAgentStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAgentStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeAgentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_49 = &_input.instance_id;
            let input_49 =
                input_49
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_49, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_50 = &_input.agent_status_id;
            let input_50 =
                input_50
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "agent_status_id",
                        details: "cannot be empty or unset",
                    })?;
            let agent_status_id = aws_smithy_http::label::fmt_string(input_50, false);
            if agent_status_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "agent_status_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/agent-status/{InstanceId}/{AgentStatusId}",
                InstanceId = instance_id,
                AgentStatusId = agent_status_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeAgentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeAgentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAgentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAgentStatus",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeAgentStatusInput`](crate::input::DescribeAgentStatusInput)
    pub fn builder() -> crate::input::describe_agent_status_input::Builder {
        crate::input::describe_agent_status_input::Builder::default()
    }
}

/// See [`DescribeContactInput`](crate::input::DescribeContactInput)
pub mod describe_contact_input {
    /// A builder for [`DescribeContactInput`](crate::input::DescribeContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContactInput`](crate::input::DescribeContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContactInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContactInputOperationOutputAlias = crate::operation::DescribeContact;
#[doc(hidden)]
pub type DescribeContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeContactInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContact`](crate::operation::DescribeContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_51 = &_input.instance_id;
            let input_51 =
                input_51
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_51, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_52 = &_input.contact_id;
            let input_52 =
                input_52
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_id = aws_smithy_http::label::fmt_string(input_52, false);
            if contact_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contacts/{InstanceId}/{ContactId}",
                InstanceId = instance_id,
                ContactId = contact_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContact",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContactInput`](crate::input::DescribeContactInput)
    pub fn builder() -> crate::input::describe_contact_input::Builder {
        crate::input::describe_contact_input::Builder::default()
    }
}

/// See [`DescribeContactFlowInput`](crate::input::DescribeContactFlowInput)
pub mod describe_contact_flow_input {
    /// A builder for [`DescribeContactFlowInput`](crate::input::DescribeContactFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContactFlowInput`](crate::input::DescribeContactFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContactFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContactFlowInput {
                instance_id: self.instance_id,
                contact_flow_id: self.contact_flow_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContactFlowInputOperationOutputAlias = crate::operation::DescribeContactFlow;
#[doc(hidden)]
pub type DescribeContactFlowInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeContactFlowInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContactFlow`](crate::operation::DescribeContactFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContactFlow,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContactFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_53 = &_input.instance_id;
            let input_53 =
                input_53
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_53, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_54 = &_input.contact_flow_id;
            let input_54 =
                input_54
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_flow_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_flow_id = aws_smithy_http::label::fmt_string(input_54, false);
            if contact_flow_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_flow_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flows/{InstanceId}/{ContactFlowId}",
                InstanceId = instance_id,
                ContactFlowId = contact_flow_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContactFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContactFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContactFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContactFlow",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContactFlowInput`](crate::input::DescribeContactFlowInput)
    pub fn builder() -> crate::input::describe_contact_flow_input::Builder {
        crate::input::describe_contact_flow_input::Builder::default()
    }
}

/// See [`DescribeContactFlowModuleInput`](crate::input::DescribeContactFlowModuleInput)
pub mod describe_contact_flow_module_input {
    /// A builder for [`DescribeContactFlowModuleInput`](crate::input::DescribeContactFlowModuleInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_module_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_module_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_module_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeContactFlowModuleInput`](crate::input::DescribeContactFlowModuleInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeContactFlowModuleInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeContactFlowModuleInput {
                instance_id: self.instance_id,
                contact_flow_module_id: self.contact_flow_module_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeContactFlowModuleInputOperationOutputAlias =
    crate::operation::DescribeContactFlowModule;
#[doc(hidden)]
pub type DescribeContactFlowModuleInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeContactFlowModuleInput {
    /// Consumes the builder and constructs an Operation<[`DescribeContactFlowModule`](crate::operation::DescribeContactFlowModule)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeContactFlowModule,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeContactFlowModuleInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_55 = &_input.instance_id;
            let input_55 =
                input_55
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_55, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_56 = &_input.contact_flow_module_id;
            let input_56 =
                input_56
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_flow_module_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_flow_module_id = aws_smithy_http::label::fmt_string(input_56, false);
            if contact_flow_module_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_flow_module_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}",
                InstanceId = instance_id,
                ContactFlowModuleId = contact_flow_module_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeContactFlowModuleInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeContactFlowModuleInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeContactFlowModule::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeContactFlowModule",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeContactFlowModuleInput`](crate::input::DescribeContactFlowModuleInput)
    pub fn builder() -> crate::input::describe_contact_flow_module_input::Builder {
        crate::input::describe_contact_flow_module_input::Builder::default()
    }
}

/// See [`DescribeHoursOfOperationInput`](crate::input::DescribeHoursOfOperationInput)
pub mod describe_hours_of_operation_input {
    /// A builder for [`DescribeHoursOfOperationInput`](crate::input::DescribeHoursOfOperationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) hours_of_operation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hours_of_operation_id = Some(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hours_of_operation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHoursOfOperationInput`](crate::input::DescribeHoursOfOperationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeHoursOfOperationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeHoursOfOperationInput {
                instance_id: self.instance_id,
                hours_of_operation_id: self.hours_of_operation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeHoursOfOperationInputOperationOutputAlias =
    crate::operation::DescribeHoursOfOperation;
#[doc(hidden)]
pub type DescribeHoursOfOperationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeHoursOfOperationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeHoursOfOperation`](crate::operation::DescribeHoursOfOperation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeHoursOfOperation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeHoursOfOperationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_57 = &_input.instance_id;
            let input_57 =
                input_57
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_57, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_58 = &_input.hours_of_operation_id;
            let input_58 =
                input_58
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hours_of_operation_id",
                        details: "cannot be empty or unset",
                    })?;
            let hours_of_operation_id = aws_smithy_http::label::fmt_string(input_58, false);
            if hours_of_operation_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hours_of_operation_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
                InstanceId = instance_id,
                HoursOfOperationId = hours_of_operation_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeHoursOfOperationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeHoursOfOperationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeHoursOfOperation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeHoursOfOperation",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeHoursOfOperationInput`](crate::input::DescribeHoursOfOperationInput)
    pub fn builder() -> crate::input::describe_hours_of_operation_input::Builder {
        crate::input::describe_hours_of_operation_input::Builder::default()
    }
}

/// See [`DescribeInstanceInput`](crate::input::DescribeInstanceInput)
pub mod describe_instance_input {
    /// A builder for [`DescribeInstanceInput`](crate::input::DescribeInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceInput`](crate::input::DescribeInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceInputOperationOutputAlias = crate::operation::DescribeInstance;
#[doc(hidden)]
pub type DescribeInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstance`](crate::operation::DescribeInstance)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstanceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_59 = &_input.instance_id;
            let input_59 =
                input_59
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_59, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/instance/{InstanceId}", InstanceId = instance_id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstanceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstanceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstance",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceInput`](crate::input::DescribeInstanceInput)
    pub fn builder() -> crate::input::describe_instance_input::Builder {
        crate::input::describe_instance_input::Builder::default()
    }
}

/// See [`DescribeInstanceAttributeInput`](crate::input::DescribeInstanceAttributeInput)
pub mod describe_instance_attribute_input {
    /// A builder for [`DescribeInstanceAttributeInput`](crate::input::DescribeInstanceAttributeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) attribute_type: std::option::Option<crate::model::InstanceAttributeType>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The type of attribute.</p>
        pub fn attribute_type(mut self, input: crate::model::InstanceAttributeType) -> Self {
            self.attribute_type = Some(input);
            self
        }
        /// <p>The type of attribute.</p>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::InstanceAttributeType>,
        ) -> Self {
            self.attribute_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceAttributeInput`](crate::input::DescribeInstanceAttributeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceAttributeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceAttributeInput {
                instance_id: self.instance_id,
                attribute_type: self.attribute_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceAttributeInputOperationOutputAlias =
    crate::operation::DescribeInstanceAttribute;
#[doc(hidden)]
pub type DescribeInstanceAttributeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstanceAttributeInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceAttribute`](crate::operation::DescribeInstanceAttribute)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceAttribute,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstanceAttributeInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_60 = &_input.instance_id;
            let input_60 =
                input_60
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_60, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_61 = &_input.attribute_type;
            let input_61 =
                input_61
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "attribute_type",
                        details: "cannot be empty or unset",
                    })?;
            let attribute_type = aws_smithy_http::label::fmt_string(input_61, false);
            if attribute_type.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "attribute_type",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/attribute/{AttributeType}",
                InstanceId = instance_id,
                AttributeType = attribute_type
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstanceAttributeInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstanceAttributeInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceAttribute::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceAttribute",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceAttributeInput`](crate::input::DescribeInstanceAttributeInput)
    pub fn builder() -> crate::input::describe_instance_attribute_input::Builder {
        crate::input::describe_instance_attribute_input::Builder::default()
    }
}

/// See [`DescribeInstanceStorageConfigInput`](crate::input::DescribeInstanceStorageConfigInput)
pub mod describe_instance_storage_config_input {
    /// A builder for [`DescribeInstanceStorageConfigInput`](crate::input::DescribeInstanceStorageConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::InstanceStorageResourceType>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstanceStorageConfigInput`](crate::input::DescribeInstanceStorageConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeInstanceStorageConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeInstanceStorageConfigInput {
                instance_id: self.instance_id,
                association_id: self.association_id,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeInstanceStorageConfigInputOperationOutputAlias =
    crate::operation::DescribeInstanceStorageConfig;
#[doc(hidden)]
pub type DescribeInstanceStorageConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeInstanceStorageConfigInput {
    /// Consumes the builder and constructs an Operation<[`DescribeInstanceStorageConfig`](crate::operation::DescribeInstanceStorageConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeInstanceStorageConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeInstanceStorageConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_62 = &_input.instance_id;
            let input_62 =
                input_62
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_62, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_63 = &_input.association_id;
            let input_63 =
                input_63
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "association_id",
                        details: "cannot be empty or unset",
                    })?;
            let association_id = aws_smithy_http::label::fmt_string(input_63, false);
            if association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/storage-config/{AssociationId}",
                InstanceId = instance_id,
                AssociationId = association_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DescribeInstanceStorageConfigInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_64) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_64),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeInstanceStorageConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeInstanceStorageConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeInstanceStorageConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeInstanceStorageConfig",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeInstanceStorageConfigInput`](crate::input::DescribeInstanceStorageConfigInput)
    pub fn builder() -> crate::input::describe_instance_storage_config_input::Builder {
        crate::input::describe_instance_storage_config_input::Builder::default()
    }
}

/// See [`DescribeQueueInput`](crate::input::DescribeQueueInput)
pub mod describe_queue_input {
    /// A builder for [`DescribeQueueInput`](crate::input::DescribeQueueInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) queue_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeQueueInput`](crate::input::DescribeQueueInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeQueueInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeQueueInput {
                instance_id: self.instance_id,
                queue_id: self.queue_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeQueueInputOperationOutputAlias = crate::operation::DescribeQueue;
#[doc(hidden)]
pub type DescribeQueueInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeQueueInput {
    /// Consumes the builder and constructs an Operation<[`DescribeQueue`](crate::operation::DescribeQueue)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeQueue,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeQueueInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_65 = &_input.instance_id;
            let input_65 =
                input_65
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_65, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_66 = &_input.queue_id;
            let input_66 =
                input_66
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "queue_id",
                        details: "cannot be empty or unset",
                    })?;
            let queue_id = aws_smithy_http::label::fmt_string(input_66, false);
            if queue_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "queue_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/queues/{InstanceId}/{QueueId}",
                InstanceId = instance_id,
                QueueId = queue_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeQueueInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeQueueInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeQueue::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeQueue",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeQueueInput`](crate::input::DescribeQueueInput)
    pub fn builder() -> crate::input::describe_queue_input::Builder {
        crate::input::describe_queue_input::Builder::default()
    }
}

/// See [`DescribeQuickConnectInput`](crate::input::DescribeQuickConnectInput)
pub mod describe_quick_connect_input {
    /// A builder for [`DescribeQuickConnectInput`](crate::input::DescribeQuickConnectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) quick_connect_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.quick_connect_id = Some(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.quick_connect_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeQuickConnectInput`](crate::input::DescribeQuickConnectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeQuickConnectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeQuickConnectInput {
                instance_id: self.instance_id,
                quick_connect_id: self.quick_connect_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeQuickConnectInputOperationOutputAlias = crate::operation::DescribeQuickConnect;
#[doc(hidden)]
pub type DescribeQuickConnectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeQuickConnectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeQuickConnect`](crate::operation::DescribeQuickConnect)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeQuickConnect,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeQuickConnectInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_67 = &_input.instance_id;
            let input_67 =
                input_67
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_67, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_68 = &_input.quick_connect_id;
            let input_68 =
                input_68
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "quick_connect_id",
                        details: "cannot be empty or unset",
                    })?;
            let quick_connect_id = aws_smithy_http::label::fmt_string(input_68, false);
            if quick_connect_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "quick_connect_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/quick-connects/{InstanceId}/{QuickConnectId}",
                InstanceId = instance_id,
                QuickConnectId = quick_connect_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeQuickConnectInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeQuickConnectInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeQuickConnect::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeQuickConnect",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeQuickConnectInput`](crate::input::DescribeQuickConnectInput)
    pub fn builder() -> crate::input::describe_quick_connect_input::Builder {
        crate::input::describe_quick_connect_input::Builder::default()
    }
}

/// See [`DescribeRoutingProfileInput`](crate::input::DescribeRoutingProfileInput)
pub mod describe_routing_profile_input {
    /// A builder for [`DescribeRoutingProfileInput`](crate::input::DescribeRoutingProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) routing_profile_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeRoutingProfileInput`](crate::input::DescribeRoutingProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeRoutingProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeRoutingProfileInput {
                instance_id: self.instance_id,
                routing_profile_id: self.routing_profile_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeRoutingProfileInputOperationOutputAlias = crate::operation::DescribeRoutingProfile;
#[doc(hidden)]
pub type DescribeRoutingProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeRoutingProfileInput {
    /// Consumes the builder and constructs an Operation<[`DescribeRoutingProfile`](crate::operation::DescribeRoutingProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeRoutingProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeRoutingProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_69 = &_input.instance_id;
            let input_69 =
                input_69
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_69, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_70 = &_input.routing_profile_id;
            let input_70 =
                input_70
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let routing_profile_id = aws_smithy_http::label::fmt_string(input_70, false);
            if routing_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "routing_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/routing-profiles/{InstanceId}/{RoutingProfileId}",
                InstanceId = instance_id,
                RoutingProfileId = routing_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeRoutingProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeRoutingProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeRoutingProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeRoutingProfile",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeRoutingProfileInput`](crate::input::DescribeRoutingProfileInput)
    pub fn builder() -> crate::input::describe_routing_profile_input::Builder {
        crate::input::describe_routing_profile_input::Builder::default()
    }
}

/// See [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
pub mod describe_security_profile_input {
    /// A builder for [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeSecurityProfileInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeSecurityProfileInput {
                security_profile_id: self.security_profile_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeSecurityProfileInputOperationOutputAlias =
    crate::operation::DescribeSecurityProfile;
#[doc(hidden)]
pub type DescribeSecurityProfileInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeSecurityProfileInput {
    /// Consumes the builder and constructs an Operation<[`DescribeSecurityProfile`](crate::operation::DescribeSecurityProfile)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeSecurityProfile,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeSecurityProfileInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_71 = &_input.instance_id;
            let input_71 =
                input_71
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_71, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_72 = &_input.security_profile_id;
            let input_72 =
                input_72
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let security_profile_id = aws_smithy_http::label::fmt_string(input_72, false);
            if security_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "security_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/security-profiles/{InstanceId}/{SecurityProfileId}",
                InstanceId = instance_id,
                SecurityProfileId = security_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeSecurityProfileInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeSecurityProfileInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeSecurityProfile::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeSecurityProfile",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeSecurityProfileInput`](crate::input::DescribeSecurityProfileInput)
    pub fn builder() -> crate::input::describe_security_profile_input::Builder {
        crate::input::describe_security_profile_input::Builder::default()
    }
}

/// See [`DescribeUserInput`](crate::input::DescribeUserInput)
pub mod describe_user_input {
    /// A builder for [`DescribeUserInput`](crate::input::DescribeUserInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) user_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_id = Some(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserInput`](crate::input::DescribeUserInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserInput {
                user_id: self.user_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserInputOperationOutputAlias = crate::operation::DescribeUser;
#[doc(hidden)]
pub type DescribeUserInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUser`](crate::operation::DescribeUser)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUser,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_73 = &_input.instance_id;
            let input_73 =
                input_73
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_73, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_74 = &_input.user_id;
            let input_74 =
                input_74
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "user_id",
                        details: "cannot be empty or unset",
                    })?;
            let user_id = aws_smithy_http::label::fmt_string(input_74, false);
            if user_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "user_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/users/{InstanceId}/{UserId}",
                InstanceId = instance_id,
                UserId = user_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUser::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUser",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserInput`](crate::input::DescribeUserInput)
    pub fn builder() -> crate::input::describe_user_input::Builder {
        crate::input::describe_user_input::Builder::default()
    }
}

/// See [`DescribeUserHierarchyGroupInput`](crate::input::DescribeUserHierarchyGroupInput)
pub mod describe_user_hierarchy_group_input {
    /// A builder for [`DescribeUserHierarchyGroupInput`](crate::input::DescribeUserHierarchyGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hierarchy_group_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hierarchy_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hierarchy_group_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserHierarchyGroupInput`](crate::input::DescribeUserHierarchyGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserHierarchyGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserHierarchyGroupInput {
                hierarchy_group_id: self.hierarchy_group_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserHierarchyGroupInputOperationOutputAlias =
    crate::operation::DescribeUserHierarchyGroup;
#[doc(hidden)]
pub type DescribeUserHierarchyGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserHierarchyGroupInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserHierarchyGroup`](crate::operation::DescribeUserHierarchyGroup)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserHierarchyGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserHierarchyGroupInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_75 = &_input.instance_id;
            let input_75 =
                input_75
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_75, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_76 = &_input.hierarchy_group_id;
            let input_76 =
                input_76
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "hierarchy_group_id",
                        details: "cannot be empty or unset",
                    })?;
            let hierarchy_group_id = aws_smithy_http::label::fmt_string(input_76, false);
            if hierarchy_group_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "hierarchy_group_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
                InstanceId = instance_id,
                HierarchyGroupId = hierarchy_group_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserHierarchyGroupInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserHierarchyGroupInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserHierarchyGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserHierarchyGroup",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserHierarchyGroupInput`](crate::input::DescribeUserHierarchyGroupInput)
    pub fn builder() -> crate::input::describe_user_hierarchy_group_input::Builder {
        crate::input::describe_user_hierarchy_group_input::Builder::default()
    }
}

/// See [`DescribeUserHierarchyStructureInput`](crate::input::DescribeUserHierarchyStructureInput)
pub mod describe_user_hierarchy_structure_input {
    /// A builder for [`DescribeUserHierarchyStructureInput`](crate::input::DescribeUserHierarchyStructureInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUserHierarchyStructureInput`](crate::input::DescribeUserHierarchyStructureInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeUserHierarchyStructureInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeUserHierarchyStructureInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeUserHierarchyStructureInputOperationOutputAlias =
    crate::operation::DescribeUserHierarchyStructure;
#[doc(hidden)]
pub type DescribeUserHierarchyStructureInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeUserHierarchyStructureInput {
    /// Consumes the builder and constructs an Operation<[`DescribeUserHierarchyStructure`](crate::operation::DescribeUserHierarchyStructure)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeUserHierarchyStructure,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeUserHierarchyStructureInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_77 = &_input.instance_id;
            let input_77 =
                input_77
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_77, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/user-hierarchy-structure/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeUserHierarchyStructureInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeUserHierarchyStructureInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeUserHierarchyStructure::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeUserHierarchyStructure",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeUserHierarchyStructureInput`](crate::input::DescribeUserHierarchyStructureInput)
    pub fn builder() -> crate::input::describe_user_hierarchy_structure_input::Builder {
        crate::input::describe_user_hierarchy_structure_input::Builder::default()
    }
}

/// See [`DescribeVocabularyInput`](crate::input::DescribeVocabularyInput)
pub mod describe_vocabulary_input {
    /// A builder for [`DescribeVocabularyInput`](crate::input::DescribeVocabularyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) vocabulary_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn vocabulary_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vocabulary_id = Some(input.into());
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn set_vocabulary_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vocabulary_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeVocabularyInput`](crate::input::DescribeVocabularyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeVocabularyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeVocabularyInput {
                instance_id: self.instance_id,
                vocabulary_id: self.vocabulary_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeVocabularyInputOperationOutputAlias = crate::operation::DescribeVocabulary;
#[doc(hidden)]
pub type DescribeVocabularyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeVocabularyInput {
    /// Consumes the builder and constructs an Operation<[`DescribeVocabulary`](crate::operation::DescribeVocabulary)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeVocabulary,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeVocabularyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_78 = &_input.instance_id;
            let input_78 =
                input_78
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_78, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_79 = &_input.vocabulary_id;
            let input_79 =
                input_79
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vocabulary_id",
                        details: "cannot be empty or unset",
                    })?;
            let vocabulary_id = aws_smithy_http::label::fmt_string(input_79, false);
            if vocabulary_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vocabulary_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/vocabulary/{InstanceId}/{VocabularyId}",
                InstanceId = instance_id,
                VocabularyId = vocabulary_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeVocabularyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeVocabularyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeVocabulary::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeVocabulary",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeVocabularyInput`](crate::input::DescribeVocabularyInput)
    pub fn builder() -> crate::input::describe_vocabulary_input::Builder {
        crate::input::describe_vocabulary_input::Builder::default()
    }
}

/// See [`DisassociateApprovedOriginInput`](crate::input::DisassociateApprovedOriginInput)
pub mod disassociate_approved_origin_input {
    /// A builder for [`DisassociateApprovedOriginInput`](crate::input::DisassociateApprovedOriginInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) origin: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The domain URL of the integrated application.</p>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.origin = Some(input.into());
            self
        }
        /// <p>The domain URL of the integrated application.</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.origin = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateApprovedOriginInput`](crate::input::DisassociateApprovedOriginInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateApprovedOriginInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateApprovedOriginInput {
                instance_id: self.instance_id,
                origin: self.origin,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateApprovedOriginInputOperationOutputAlias =
    crate::operation::DisassociateApprovedOrigin;
#[doc(hidden)]
pub type DisassociateApprovedOriginInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateApprovedOriginInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateApprovedOrigin`](crate::operation::DisassociateApprovedOrigin)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateApprovedOrigin,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateApprovedOriginInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_80 = &_input.instance_id;
            let input_80 =
                input_80
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_80, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/approved-origin",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateApprovedOriginInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_81) = &_input.origin {
                query.push_kv("origin", &aws_smithy_http::query::fmt_string(&inner_81));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateApprovedOriginInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateApprovedOriginInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateApprovedOrigin::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateApprovedOrigin",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateApprovedOriginInput`](crate::input::DisassociateApprovedOriginInput)
    pub fn builder() -> crate::input::disassociate_approved_origin_input::Builder {
        crate::input::disassociate_approved_origin_input::Builder::default()
    }
}

/// See [`DisassociateBotInput`](crate::input::DisassociateBotInput)
pub mod disassociate_bot_input {
    /// A builder for [`DisassociateBotInput`](crate::input::DisassociateBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) lex_bot: std::option::Option<crate::model::LexBot>,
        pub(crate) lex_v2_bot: std::option::Option<crate::model::LexV2Bot>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn lex_bot(mut self, input: crate::model::LexBot) -> Self {
            self.lex_bot = Some(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.lex_bot = input;
            self
        }
        /// <p>The Amazon Lex V2 bot to disassociate from the instance.</p>
        pub fn lex_v2_bot(mut self, input: crate::model::LexV2Bot) -> Self {
            self.lex_v2_bot = Some(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to disassociate from the instance.</p>
        pub fn set_lex_v2_bot(
            mut self,
            input: std::option::Option<crate::model::LexV2Bot>,
        ) -> Self {
            self.lex_v2_bot = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateBotInput`](crate::input::DisassociateBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateBotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateBotInput {
                instance_id: self.instance_id,
                lex_bot: self.lex_bot,
                lex_v2_bot: self.lex_v2_bot,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateBotInputOperationOutputAlias = crate::operation::DisassociateBot;
#[doc(hidden)]
pub type DisassociateBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateBotInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateBot`](crate::operation::DisassociateBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_82 = &_input.instance_id;
            let input_82 =
                input_82
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_82, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/bot",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_bot(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateBot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateBot",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateBotInput`](crate::input::DisassociateBotInput)
    pub fn builder() -> crate::input::disassociate_bot_input::Builder {
        crate::input::disassociate_bot_input::Builder::default()
    }
}

/// See [`DisassociateInstanceStorageConfigInput`](crate::input::DisassociateInstanceStorageConfigInput)
pub mod disassociate_instance_storage_config_input {
    /// A builder for [`DisassociateInstanceStorageConfigInput`](crate::input::DisassociateInstanceStorageConfigInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::InstanceStorageResourceType>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateInstanceStorageConfigInput`](crate::input::DisassociateInstanceStorageConfigInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateInstanceStorageConfigInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateInstanceStorageConfigInput {
                instance_id: self.instance_id,
                association_id: self.association_id,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateInstanceStorageConfigInputOperationOutputAlias =
    crate::operation::DisassociateInstanceStorageConfig;
#[doc(hidden)]
pub type DisassociateInstanceStorageConfigInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateInstanceStorageConfigInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateInstanceStorageConfig`](crate::operation::DisassociateInstanceStorageConfig)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateInstanceStorageConfig,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateInstanceStorageConfigInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_83 = &_input.instance_id;
            let input_83 =
                input_83
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_83, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_84 = &_input.association_id;
            let input_84 =
                input_84
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "association_id",
                        details: "cannot be empty or unset",
                    })?;
            let association_id = aws_smithy_http::label::fmt_string(input_84, false);
            if association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/storage-config/{AssociationId}",
                InstanceId = instance_id,
                AssociationId = association_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateInstanceStorageConfigInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_85) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_85),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateInstanceStorageConfigInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateInstanceStorageConfigInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateInstanceStorageConfig::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateInstanceStorageConfig",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateInstanceStorageConfigInput`](crate::input::DisassociateInstanceStorageConfigInput)
    pub fn builder() -> crate::input::disassociate_instance_storage_config_input::Builder {
        crate::input::disassociate_instance_storage_config_input::Builder::default()
    }
}

/// See [`DisassociateLambdaFunctionInput`](crate::input::DisassociateLambdaFunctionInput)
pub mod disassociate_lambda_function_input {
    /// A builder for [`DisassociateLambdaFunctionInput`](crate::input::DisassociateLambdaFunctionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) function_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.function_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.function_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLambdaFunctionInput`](crate::input::DisassociateLambdaFunctionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateLambdaFunctionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateLambdaFunctionInput {
                instance_id: self.instance_id,
                function_arn: self.function_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateLambdaFunctionInputOperationOutputAlias =
    crate::operation::DisassociateLambdaFunction;
#[doc(hidden)]
pub type DisassociateLambdaFunctionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateLambdaFunctionInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateLambdaFunction`](crate::operation::DisassociateLambdaFunction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateLambdaFunction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateLambdaFunctionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_86 = &_input.instance_id;
            let input_86 =
                input_86
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_86, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/lambda-function",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateLambdaFunctionInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_87) = &_input.function_arn {
                query.push_kv(
                    "functionArn",
                    &aws_smithy_http::query::fmt_string(&inner_87),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateLambdaFunctionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateLambdaFunctionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateLambdaFunction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateLambdaFunction",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateLambdaFunctionInput`](crate::input::DisassociateLambdaFunctionInput)
    pub fn builder() -> crate::input::disassociate_lambda_function_input::Builder {
        crate::input::disassociate_lambda_function_input::Builder::default()
    }
}

/// See [`DisassociateLexBotInput`](crate::input::DisassociateLexBotInput)
pub mod disassociate_lex_bot_input {
    /// A builder for [`DisassociateLexBotInput`](crate::input::DisassociateLexBotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) bot_name: std::option::Option<std::string::String>,
        pub(crate) lex_region: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bot_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bot_name = input;
            self
        }
        /// <p>The Region in which the Amazon Lex bot has been created.</p>
        pub fn lex_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.lex_region = Some(input.into());
            self
        }
        /// <p>The Region in which the Amazon Lex bot has been created.</p>
        pub fn set_lex_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lex_region = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateLexBotInput`](crate::input::DisassociateLexBotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateLexBotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateLexBotInput {
                instance_id: self.instance_id,
                bot_name: self.bot_name,
                lex_region: self.lex_region,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateLexBotInputOperationOutputAlias = crate::operation::DisassociateLexBot;
#[doc(hidden)]
pub type DisassociateLexBotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateLexBotInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateLexBot`](crate::operation::DisassociateLexBot)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateLexBot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateLexBotInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_88 = &_input.instance_id;
            let input_88 =
                input_88
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_88, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/lex-bot",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisassociateLexBotInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_89) = &_input.bot_name {
                query.push_kv("botName", &aws_smithy_http::query::fmt_string(&inner_89));
            }
            if let Some(inner_90) = &_input.lex_region {
                query.push_kv("lexRegion", &aws_smithy_http::query::fmt_string(&inner_90));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateLexBotInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateLexBotInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateLexBot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateLexBot",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateLexBotInput`](crate::input::DisassociateLexBotInput)
    pub fn builder() -> crate::input::disassociate_lex_bot_input::Builder {
        crate::input::disassociate_lex_bot_input::Builder::default()
    }
}

/// See [`DisassociateQueueQuickConnectsInput`](crate::input::DisassociateQueueQuickConnectsInput)
pub mod disassociate_queue_quick_connects_input {
    /// A builder for [`DisassociateQueueQuickConnectsInput`](crate::input::DisassociateQueueQuickConnectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) quick_connect_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// Appends an item to `quick_connect_ids`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects to disassociate from the queue.</p>
        pub fn quick_connect_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.quick_connect_ids.unwrap_or_default();
            v.push(input.into());
            self.quick_connect_ids = Some(v);
            self
        }
        /// <p>The quick connects to disassociate from the queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.quick_connect_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateQueueQuickConnectsInput`](crate::input::DisassociateQueueQuickConnectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateQueueQuickConnectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateQueueQuickConnectsInput {
                instance_id: self.instance_id,
                queue_id: self.queue_id,
                quick_connect_ids: self.quick_connect_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateQueueQuickConnectsInputOperationOutputAlias =
    crate::operation::DisassociateQueueQuickConnects;
#[doc(hidden)]
pub type DisassociateQueueQuickConnectsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateQueueQuickConnectsInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateQueueQuickConnects`](crate::operation::DisassociateQueueQuickConnects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateQueueQuickConnects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateQueueQuickConnectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_91 = &_input.instance_id;
            let input_91 =
                input_91
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_91, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_92 = &_input.queue_id;
            let input_92 =
                input_92
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "queue_id",
                        details: "cannot be empty or unset",
                    })?;
            let queue_id = aws_smithy_http::label::fmt_string(input_92, false);
            if queue_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "queue_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/queues/{InstanceId}/{QueueId}/disassociate-quick-connects",
                InstanceId = instance_id,
                QueueId = queue_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateQueueQuickConnectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateQueueQuickConnectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_queue_quick_connects(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateQueueQuickConnects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateQueueQuickConnects",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateQueueQuickConnectsInput`](crate::input::DisassociateQueueQuickConnectsInput)
    pub fn builder() -> crate::input::disassociate_queue_quick_connects_input::Builder {
        crate::input::disassociate_queue_quick_connects_input::Builder::default()
    }
}

/// See [`DisassociateRoutingProfileQueuesInput`](crate::input::DisassociateRoutingProfileQueuesInput)
pub mod disassociate_routing_profile_queues_input {
    /// A builder for [`DisassociateRoutingProfileQueuesInput`](crate::input::DisassociateRoutingProfileQueuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) routing_profile_id: std::option::Option<std::string::String>,
        pub(crate) queue_references:
            std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueReference>>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_id = input;
            self
        }
        /// Appends an item to `queue_references`.
        ///
        /// To override the contents of this collection use [`set_queue_references`](Self::set_queue_references).
        ///
        /// <p>The queues to disassociate from this routing profile.</p>
        pub fn queue_references(
            mut self,
            input: crate::model::RoutingProfileQueueReference,
        ) -> Self {
            let mut v = self.queue_references.unwrap_or_default();
            v.push(input);
            self.queue_references = Some(v);
            self
        }
        /// <p>The queues to disassociate from this routing profile.</p>
        pub fn set_queue_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueReference>>,
        ) -> Self {
            self.queue_references = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateRoutingProfileQueuesInput`](crate::input::DisassociateRoutingProfileQueuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateRoutingProfileQueuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateRoutingProfileQueuesInput {
                instance_id: self.instance_id,
                routing_profile_id: self.routing_profile_id,
                queue_references: self.queue_references,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateRoutingProfileQueuesInputOperationOutputAlias =
    crate::operation::DisassociateRoutingProfileQueues;
#[doc(hidden)]
pub type DisassociateRoutingProfileQueuesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateRoutingProfileQueuesInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateRoutingProfileQueues`](crate::operation::DisassociateRoutingProfileQueues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateRoutingProfileQueues,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateRoutingProfileQueuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_93 = &_input.instance_id;
            let input_93 =
                input_93
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_93, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_94 = &_input.routing_profile_id;
            let input_94 =
                input_94
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let routing_profile_id = aws_smithy_http::label::fmt_string(input_94, false);
            if routing_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "routing_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/routing-profiles/{InstanceId}/{RoutingProfileId}/disassociate-queues",
                InstanceId = instance_id,
                RoutingProfileId = routing_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateRoutingProfileQueuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateRoutingProfileQueuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_disassociate_routing_profile_queues(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateRoutingProfileQueues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateRoutingProfileQueues",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateRoutingProfileQueuesInput`](crate::input::DisassociateRoutingProfileQueuesInput)
    pub fn builder() -> crate::input::disassociate_routing_profile_queues_input::Builder {
        crate::input::disassociate_routing_profile_queues_input::Builder::default()
    }
}

/// See [`DisassociateSecurityKeyInput`](crate::input::DisassociateSecurityKeyInput)
pub mod disassociate_security_key_input {
    /// A builder for [`DisassociateSecurityKeyInput`](crate::input::DisassociateSecurityKeyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) association_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.association_id = Some(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.association_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateSecurityKeyInput`](crate::input::DisassociateSecurityKeyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateSecurityKeyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateSecurityKeyInput {
                instance_id: self.instance_id,
                association_id: self.association_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisassociateSecurityKeyInputOperationOutputAlias =
    crate::operation::DisassociateSecurityKey;
#[doc(hidden)]
pub type DisassociateSecurityKeyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DisassociateSecurityKeyInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateSecurityKey`](crate::operation::DisassociateSecurityKey)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateSecurityKey,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateSecurityKeyInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_95 = &_input.instance_id;
            let input_95 =
                input_95
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_95, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_96 = &_input.association_id;
            let input_96 =
                input_96
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "association_id",
                        details: "cannot be empty or unset",
                    })?;
            let association_id = aws_smithy_http::label::fmt_string(input_96, false);
            if association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/security-key/{AssociationId}",
                InstanceId = instance_id,
                AssociationId = association_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateSecurityKeyInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateSecurityKeyInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateSecurityKey::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateSecurityKey",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateSecurityKeyInput`](crate::input::DisassociateSecurityKeyInput)
    pub fn builder() -> crate::input::disassociate_security_key_input::Builder {
        crate::input::disassociate_security_key_input::Builder::default()
    }
}

/// See [`GetContactAttributesInput`](crate::input::GetContactAttributesInput)
pub mod get_contact_attributes_input {
    /// A builder for [`GetContactAttributesInput`](crate::input::GetContactAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) initial_contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetContactAttributesInput`](crate::input::GetContactAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetContactAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetContactAttributesInput {
                instance_id: self.instance_id,
                initial_contact_id: self.initial_contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetContactAttributesInputOperationOutputAlias = crate::operation::GetContactAttributes;
#[doc(hidden)]
pub type GetContactAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetContactAttributesInput {
    /// Consumes the builder and constructs an Operation<[`GetContactAttributes`](crate::operation::GetContactAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetContactAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetContactAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_97 = &_input.instance_id;
            let input_97 =
                input_97
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_97, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_98 = &_input.initial_contact_id;
            let input_98 =
                input_98
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "initial_contact_id",
                        details: "cannot be empty or unset",
                    })?;
            let initial_contact_id = aws_smithy_http::label::fmt_string(input_98, false);
            if initial_contact_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "initial_contact_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact/attributes/{InstanceId}/{InitialContactId}",
                InstanceId = instance_id,
                InitialContactId = initial_contact_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetContactAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetContactAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetContactAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetContactAttributes",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetContactAttributesInput`](crate::input::GetContactAttributesInput)
    pub fn builder() -> crate::input::get_contact_attributes_input::Builder {
        crate::input::get_contact_attributes_input::Builder::default()
    }
}

/// See [`GetCurrentMetricDataInput`](crate::input::GetCurrentMetricDataInput)
pub mod get_current_metric_data_input {
    /// A builder for [`GetCurrentMetricDataInput`](crate::input::GetCurrentMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<crate::model::Filters>,
        pub(crate) groupings: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        pub(crate) current_metrics: std::option::Option<std::vec::Vec<crate::model::CurrentMetric>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        pub fn filters(mut self, input: crate::model::Filters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        pub fn set_filters(mut self, input: std::option::Option<crate::model::Filters>) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `groupings`.
        ///
        /// To override the contents of this collection use [`set_groupings`](Self::set_groupings).
        ///
        /// <p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.</p>
        /// <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p>
        pub fn groupings(mut self, input: crate::model::Grouping) -> Self {
            let mut v = self.groupings.unwrap_or_default();
            v.push(input);
            self.groupings = Some(v);
            self
        }
        /// <p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.</p>
        /// <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p>
        pub fn set_groupings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        ) -> Self {
            self.groupings = input;
            self
        }
        /// Appends an item to `current_metrics`.
        ///
        /// To override the contents of this collection use [`set_current_metrics`](Self::set_current_metrics).
        ///
        /// <p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        /// <dl>
        /// <dt>
        /// AGENTS_AFTER_CONTACT_WORK
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ERROR
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_NON_PRODUCTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CALL
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CONTACT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ONLINE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_STAFFED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_IN_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In queue</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_SCHEDULED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a> </p>
        /// </dd>
        /// <dt>
        /// OLDEST_CONTACT_AGE
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p>
        /// <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:</p>
        /// <p> <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>}</p>
        /// <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_ACTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a> </p>
        /// </dd>
        /// </dl>
        pub fn current_metrics(mut self, input: crate::model::CurrentMetric) -> Self {
            let mut v = self.current_metrics.unwrap_or_default();
            v.push(input);
            self.current_metrics = Some(v);
            self
        }
        /// <p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        /// <dl>
        /// <dt>
        /// AGENTS_AFTER_CONTACT_WORK
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ERROR
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_NON_PRODUCTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CALL
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CONTACT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ONLINE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_STAFFED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_IN_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In queue</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_SCHEDULED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a> </p>
        /// </dd>
        /// <dt>
        /// OLDEST_CONTACT_AGE
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p>
        /// <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:</p>
        /// <p> <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>}</p>
        /// <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_ACTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a> </p>
        /// </dd>
        /// </dl>
        pub fn set_current_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CurrentMetric>>,
        ) -> Self {
            self.current_metrics = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        /// <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        /// <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCurrentMetricDataInput`](crate::input::GetCurrentMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCurrentMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCurrentMetricDataInput {
                instance_id: self.instance_id,
                filters: self.filters,
                groupings: self.groupings,
                current_metrics: self.current_metrics,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetCurrentMetricDataInputOperationOutputAlias = crate::operation::GetCurrentMetricData;
#[doc(hidden)]
pub type GetCurrentMetricDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetCurrentMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`GetCurrentMetricData`](crate::operation::GetCurrentMetricData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCurrentMetricData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCurrentMetricDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_99 = &_input.instance_id;
            let input_99 =
                input_99
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_99, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/metrics/current/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCurrentMetricDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCurrentMetricDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_current_metric_data(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCurrentMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCurrentMetricData",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCurrentMetricDataInput`](crate::input::GetCurrentMetricDataInput)
    pub fn builder() -> crate::input::get_current_metric_data_input::Builder {
        crate::input::get_current_metric_data_input::Builder::default()
    }
}

/// See [`GetFederationTokenInput`](crate::input::GetFederationTokenInput)
pub mod get_federation_token_input {
    /// A builder for [`GetFederationTokenInput`](crate::input::GetFederationTokenInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFederationTokenInput`](crate::input::GetFederationTokenInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFederationTokenInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFederationTokenInput {
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFederationTokenInputOperationOutputAlias = crate::operation::GetFederationToken;
#[doc(hidden)]
pub type GetFederationTokenInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetFederationTokenInput {
    /// Consumes the builder and constructs an Operation<[`GetFederationToken`](crate::operation::GetFederationToken)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFederationToken,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFederationTokenInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_100 = &_input.instance_id;
            let input_100 =
                input_100
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_100, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/user/federate/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFederationTokenInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFederationTokenInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFederationToken::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFederationToken",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFederationTokenInput`](crate::input::GetFederationTokenInput)
    pub fn builder() -> crate::input::get_federation_token_input::Builder {
        crate::input::get_federation_token_input::Builder::default()
    }
}

/// See [`GetMetricDataInput`](crate::input::GetMetricDataInput)
pub mod get_metric_data_input {
    /// A builder for [`GetMetricDataInput`](crate::input::GetMetricDataInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) filters: std::option::Option<crate::model::Filters>,
        pub(crate) groupings: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        pub(crate) historical_metrics:
            std::option::Option<std::vec::Vec<crate::model::HistoricalMetric>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p>
        /// <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p>
        /// <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p>
        /// <p>The time range between the start and end time must be less than 24 hours.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p>
        /// <p>The time range between the start and end time must be less than 24 hours.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p> <note>
        /// <p>To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::Filters) -> Self {
            self.filters = Some(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p> <note>
        /// <p>To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.</p>
        /// </note>
        pub fn set_filters(mut self, input: std::option::Option<crate::model::Filters>) -> Self {
            self.filters = input;
            self
        }
        /// Appends an item to `groupings`.
        ///
        /// To override the contents of this collection use [`set_groupings`](Self::set_groupings).
        ///
        /// <p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p>
        /// <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>
        pub fn groupings(mut self, input: crate::model::Grouping) -> Self {
            let mut v = self.groupings.unwrap_or_default();
            v.push(input);
            self.groupings = Some(v);
            self
        }
        /// <p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p>
        /// <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>
        pub fn set_groupings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        ) -> Self {
            self.groupings = input;
            self
        }
        /// Appends an item to `historical_metrics`.
        ///
        /// To override the contents of this collection use [`set_historical_metrics`](Self::set_historical_metrics).
        ///
        /// <p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>
        /// <p>This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list). </p>
        /// </note>
        /// <dl>
        /// <dt>
        /// ABANDON_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// AFTER_CONTACT_WORK_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// API_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CALLBACK_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_ABANDONED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_AGENT_HUNG_UP_FIRST
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_CONSULTED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_INCOMING
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_OUTBOUND
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HOLD_ABANDONS
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_MISSED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_QUEUED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// HANDLE_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_AND_HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// OCCUPANCY
        /// </dt>
        /// <dd>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUE_ANSWER_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUED_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: MAX</p>
        /// </dd>
        /// <dt>
        /// SERVICE_LEVEL
        /// </dt>
        /// <dd>
        /// <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p>
        /// </dd>
        /// </dl>
        pub fn historical_metrics(mut self, input: crate::model::HistoricalMetric) -> Self {
            let mut v = self.historical_metrics.unwrap_or_default();
            v.push(input);
            self.historical_metrics = Some(v);
            self
        }
        /// <p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>
        /// <p>This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list). </p>
        /// </note>
        /// <dl>
        /// <dt>
        /// ABANDON_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// AFTER_CONTACT_WORK_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// API_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CALLBACK_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_ABANDONED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_AGENT_HUNG_UP_FIRST
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_CONSULTED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_INCOMING
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_OUTBOUND
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HOLD_ABANDONS
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_MISSED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_QUEUED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// HANDLE_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_AND_HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// OCCUPANCY
        /// </dt>
        /// <dd>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUE_ANSWER_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUED_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: MAX</p>
        /// </dd>
        /// <dt>
        /// SERVICE_LEVEL
        /// </dt>
        /// <dd>
        /// <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p>
        /// </dd>
        /// </dl>
        pub fn set_historical_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistoricalMetric>>,
        ) -> Self {
            self.historical_metrics = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMetricDataInput`](crate::input::GetMetricDataInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMetricDataInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMetricDataInput {
                instance_id: self.instance_id,
                start_time: self.start_time,
                end_time: self.end_time,
                filters: self.filters,
                groupings: self.groupings,
                historical_metrics: self.historical_metrics,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMetricDataInputOperationOutputAlias = crate::operation::GetMetricData;
#[doc(hidden)]
pub type GetMetricDataInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMetricDataInput {
    /// Consumes the builder and constructs an Operation<[`GetMetricData`](crate::operation::GetMetricData)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMetricData,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMetricDataInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_101 = &_input.instance_id;
            let input_101 =
                input_101
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_101, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/metrics/historical/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMetricDataInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMetricDataInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_metric_data(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMetricData::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMetricData",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMetricDataInput`](crate::input::GetMetricDataInput)
    pub fn builder() -> crate::input::get_metric_data_input::Builder {
        crate::input::get_metric_data_input::Builder::default()
    }
}

/// See [`ListAgentStatusesInput`](crate::input::ListAgentStatusesInput)
pub mod list_agent_statuses_input {
    /// A builder for [`ListAgentStatusesInput`](crate::input::ListAgentStatusesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) agent_status_types:
            std::option::Option<std::vec::Vec<crate::model::AgentStatusType>>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `agent_status_types`.
        ///
        /// To override the contents of this collection use [`set_agent_status_types`](Self::set_agent_status_types).
        ///
        /// <p>Available agent status types.</p>
        pub fn agent_status_types(mut self, input: crate::model::AgentStatusType) -> Self {
            let mut v = self.agent_status_types.unwrap_or_default();
            v.push(input);
            self.agent_status_types = Some(v);
            self
        }
        /// <p>Available agent status types.</p>
        pub fn set_agent_status_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentStatusType>>,
        ) -> Self {
            self.agent_status_types = input;
            self
        }
        /// Consumes the builder and constructs a [`ListAgentStatusesInput`](crate::input::ListAgentStatusesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListAgentStatusesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListAgentStatusesInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
                agent_status_types: self.agent_status_types,
            })
        }
    }
}
#[doc(hidden)]
pub type ListAgentStatusesInputOperationOutputAlias = crate::operation::ListAgentStatuses;
#[doc(hidden)]
pub type ListAgentStatusesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListAgentStatusesInput {
    /// Consumes the builder and constructs an Operation<[`ListAgentStatuses`](crate::operation::ListAgentStatuses)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListAgentStatuses,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListAgentStatusesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_102 = &_input.instance_id;
            let input_102 =
                input_102
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_102, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/agent-status/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListAgentStatusesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_103) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_103));
            }
            if let Some(inner_104) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_104).encode(),
                );
            }
            if let Some(inner_105) = &_input.agent_status_types {
                for inner_106 in inner_105 {
                    query.push_kv(
                        "AgentStatusTypes",
                        &aws_smithy_http::query::fmt_string(&inner_106),
                    );
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListAgentStatusesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListAgentStatusesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListAgentStatuses::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListAgentStatuses",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListAgentStatusesInput`](crate::input::ListAgentStatusesInput)
    pub fn builder() -> crate::input::list_agent_statuses_input::Builder {
        crate::input::list_agent_statuses_input::Builder::default()
    }
}

/// See [`ListApprovedOriginsInput`](crate::input::ListApprovedOriginsInput)
pub mod list_approved_origins_input {
    /// A builder for [`ListApprovedOriginsInput`](crate::input::ListApprovedOriginsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListApprovedOriginsInput`](crate::input::ListApprovedOriginsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListApprovedOriginsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListApprovedOriginsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListApprovedOriginsInputOperationOutputAlias = crate::operation::ListApprovedOrigins;
#[doc(hidden)]
pub type ListApprovedOriginsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListApprovedOriginsInput {
    /// Consumes the builder and constructs an Operation<[`ListApprovedOrigins`](crate::operation::ListApprovedOrigins)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListApprovedOrigins,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListApprovedOriginsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_107 = &_input.instance_id;
            let input_107 =
                input_107
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_107, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/approved-origins",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListApprovedOriginsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_108) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_108));
            }
            if let Some(inner_109) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_109).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListApprovedOriginsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListApprovedOriginsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListApprovedOrigins::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListApprovedOrigins",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListApprovedOriginsInput`](crate::input::ListApprovedOriginsInput)
    pub fn builder() -> crate::input::list_approved_origins_input::Builder {
        crate::input::list_approved_origins_input::Builder::default()
    }
}

/// See [`ListBotsInput`](crate::input::ListBotsInput)
pub mod list_bots_input {
    /// A builder for [`ListBotsInput`](crate::input::ListBotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) lex_version: std::option::Option<crate::model::LexVersion>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The version of Amazon Lex or Amazon Lex V2.</p>
        pub fn lex_version(mut self, input: crate::model::LexVersion) -> Self {
            self.lex_version = Some(input);
            self
        }
        /// <p>The version of Amazon Lex or Amazon Lex V2.</p>
        pub fn set_lex_version(
            mut self,
            input: std::option::Option<crate::model::LexVersion>,
        ) -> Self {
            self.lex_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ListBotsInput`](crate::input::ListBotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListBotsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListBotsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
                lex_version: self.lex_version,
            })
        }
    }
}
#[doc(hidden)]
pub type ListBotsInputOperationOutputAlias = crate::operation::ListBots;
#[doc(hidden)]
pub type ListBotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListBotsInput {
    /// Consumes the builder and constructs an Operation<[`ListBots`](crate::operation::ListBots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListBots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListBotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_110 = &_input.instance_id;
            let input_110 =
                input_110
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_110, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/bots",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListBotsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_111) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_111));
            }
            if let Some(inner_112) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_112).encode(),
                );
            }
            if let Some(inner_113) = &_input.lex_version {
                query.push_kv(
                    "lexVersion",
                    &aws_smithy_http::query::fmt_string(&inner_113),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListBotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListBotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListBots::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListBots", "connect",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListBotsInput`](crate::input::ListBotsInput)
    pub fn builder() -> crate::input::list_bots_input::Builder {
        crate::input::list_bots_input::Builder::default()
    }
}

/// See [`ListContactFlowModulesInput`](crate::input::ListContactFlowModulesInput)
pub mod list_contact_flow_modules_input {
    /// A builder for [`ListContactFlowModulesInput`](crate::input::ListContactFlowModulesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) contact_flow_module_state:
            std::option::Option<crate::model::ContactFlowModuleState>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The state of the contact flow module.</p>
        pub fn contact_flow_module_state(
            mut self,
            input: crate::model::ContactFlowModuleState,
        ) -> Self {
            self.contact_flow_module_state = Some(input);
            self
        }
        /// <p>The state of the contact flow module.</p>
        pub fn set_contact_flow_module_state(
            mut self,
            input: std::option::Option<crate::model::ContactFlowModuleState>,
        ) -> Self {
            self.contact_flow_module_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactFlowModulesInput`](crate::input::ListContactFlowModulesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactFlowModulesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactFlowModulesInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
                contact_flow_module_state: self.contact_flow_module_state,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactFlowModulesInputOperationOutputAlias = crate::operation::ListContactFlowModules;
#[doc(hidden)]
pub type ListContactFlowModulesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContactFlowModulesInput {
    /// Consumes the builder and constructs an Operation<[`ListContactFlowModules`](crate::operation::ListContactFlowModules)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContactFlowModules,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContactFlowModulesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_114 = &_input.instance_id;
            let input_114 =
                input_114
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_114, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flow-modules-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListContactFlowModulesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_115) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_115));
            }
            if let Some(inner_116) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_116).encode(),
                );
            }
            if let Some(inner_117) = &_input.contact_flow_module_state {
                query.push_kv("state", &aws_smithy_http::query::fmt_string(&inner_117));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContactFlowModulesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContactFlowModulesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContactFlowModules::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContactFlowModules",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContactFlowModulesInput`](crate::input::ListContactFlowModulesInput)
    pub fn builder() -> crate::input::list_contact_flow_modules_input::Builder {
        crate::input::list_contact_flow_modules_input::Builder::default()
    }
}

/// See [`ListContactFlowsInput`](crate::input::ListContactFlowsInput)
pub mod list_contact_flows_input {
    /// A builder for [`ListContactFlowsInput`](crate::input::ListContactFlowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_types:
            std::option::Option<std::vec::Vec<crate::model::ContactFlowType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `contact_flow_types`.
        ///
        /// To override the contents of this collection use [`set_contact_flow_types`](Self::set_contact_flow_types).
        ///
        /// <p>The type of contact flow.</p>
        pub fn contact_flow_types(mut self, input: crate::model::ContactFlowType) -> Self {
            let mut v = self.contact_flow_types.unwrap_or_default();
            v.push(input);
            self.contact_flow_types = Some(v);
            self
        }
        /// <p>The type of contact flow.</p>
        pub fn set_contact_flow_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactFlowType>>,
        ) -> Self {
            self.contact_flow_types = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactFlowsInput`](crate::input::ListContactFlowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactFlowsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactFlowsInput {
                instance_id: self.instance_id,
                contact_flow_types: self.contact_flow_types,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactFlowsInputOperationOutputAlias = crate::operation::ListContactFlows;
#[doc(hidden)]
pub type ListContactFlowsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContactFlowsInput {
    /// Consumes the builder and constructs an Operation<[`ListContactFlows`](crate::operation::ListContactFlows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContactFlows,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContactFlowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_118 = &_input.instance_id;
            let input_118 =
                input_118
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_118, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact-flows-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListContactFlowsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_119) = &_input.contact_flow_types {
                for inner_120 in inner_119 {
                    query.push_kv(
                        "contactFlowTypes",
                        &aws_smithy_http::query::fmt_string(&inner_120),
                    );
                }
            }
            if let Some(inner_121) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_121));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContactFlowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContactFlowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContactFlows::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContactFlows",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContactFlowsInput`](crate::input::ListContactFlowsInput)
    pub fn builder() -> crate::input::list_contact_flows_input::Builder {
        crate::input::list_contact_flows_input::Builder::default()
    }
}

/// See [`ListContactReferencesInput`](crate::input::ListContactReferencesInput)
pub mod list_contact_references_input {
    /// A builder for [`ListContactReferencesInput`](crate::input::ListContactReferencesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) reference_types: std::option::Option<std::vec::Vec<crate::model::ReferenceType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// Appends an item to `reference_types`.
        ///
        /// To override the contents of this collection use [`set_reference_types`](Self::set_reference_types).
        ///
        /// <p>The type of reference.</p>
        pub fn reference_types(mut self, input: crate::model::ReferenceType) -> Self {
            let mut v = self.reference_types.unwrap_or_default();
            v.push(input);
            self.reference_types = Some(v);
            self
        }
        /// <p>The type of reference.</p>
        pub fn set_reference_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReferenceType>>,
        ) -> Self {
            self.reference_types = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important>
        /// <p>This is not expected to be set, because the value returned in the previous response is always null.</p>
        /// </important>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important>
        /// <p>This is not expected to be set, because the value returned in the previous response is always null.</p>
        /// </important>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListContactReferencesInput`](crate::input::ListContactReferencesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListContactReferencesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListContactReferencesInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                reference_types: self.reference_types,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListContactReferencesInputOperationOutputAlias = crate::operation::ListContactReferences;
#[doc(hidden)]
pub type ListContactReferencesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListContactReferencesInput {
    /// Consumes the builder and constructs an Operation<[`ListContactReferences`](crate::operation::ListContactReferences)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListContactReferences,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListContactReferencesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_122 = &_input.instance_id;
            let input_122 =
                input_122
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_122, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_123 = &_input.contact_id;
            let input_123 =
                input_123
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_id = aws_smithy_http::label::fmt_string(input_123, false);
            if contact_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contact/references/{InstanceId}/{ContactId}",
                InstanceId = instance_id,
                ContactId = contact_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListContactReferencesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_124) = &_input.reference_types {
                for inner_125 in inner_124 {
                    query.push_kv(
                        "referenceTypes",
                        &aws_smithy_http::query::fmt_string(&inner_125),
                    );
                }
            }
            if let Some(inner_126) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_126));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListContactReferencesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListContactReferencesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListContactReferences::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListContactReferences",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListContactReferencesInput`](crate::input::ListContactReferencesInput)
    pub fn builder() -> crate::input::list_contact_references_input::Builder {
        crate::input::list_contact_references_input::Builder::default()
    }
}

/// See [`ListDefaultVocabulariesInput`](crate::input::ListDefaultVocabulariesInput)
pub mod list_default_vocabularies_input {
    /// A builder for [`ListDefaultVocabulariesInput`](crate::input::ListDefaultVocabulariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::VocabularyLanguageCode>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDefaultVocabulariesInput`](crate::input::ListDefaultVocabulariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDefaultVocabulariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDefaultVocabulariesInput {
                instance_id: self.instance_id,
                language_code: self.language_code,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDefaultVocabulariesInputOperationOutputAlias =
    crate::operation::ListDefaultVocabularies;
#[doc(hidden)]
pub type ListDefaultVocabulariesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDefaultVocabulariesInput {
    /// Consumes the builder and constructs an Operation<[`ListDefaultVocabularies`](crate::operation::ListDefaultVocabularies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDefaultVocabularies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListDefaultVocabulariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_127 = &_input.instance_id;
            let input_127 =
                input_127
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_127, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/default-vocabulary-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListDefaultVocabulariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListDefaultVocabulariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_default_vocabularies(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDefaultVocabularies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDefaultVocabularies",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListDefaultVocabulariesInput`](crate::input::ListDefaultVocabulariesInput)
    pub fn builder() -> crate::input::list_default_vocabularies_input::Builder {
        crate::input::list_default_vocabularies_input::Builder::default()
    }
}

/// See [`ListHoursOfOperationsInput`](crate::input::ListHoursOfOperationsInput)
pub mod list_hours_of_operations_input {
    /// A builder for [`ListHoursOfOperationsInput`](crate::input::ListHoursOfOperationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListHoursOfOperationsInput`](crate::input::ListHoursOfOperationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListHoursOfOperationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListHoursOfOperationsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListHoursOfOperationsInputOperationOutputAlias = crate::operation::ListHoursOfOperations;
#[doc(hidden)]
pub type ListHoursOfOperationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListHoursOfOperationsInput {
    /// Consumes the builder and constructs an Operation<[`ListHoursOfOperations`](crate::operation::ListHoursOfOperations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListHoursOfOperations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListHoursOfOperationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_128 = &_input.instance_id;
            let input_128 =
                input_128
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_128, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/hours-of-operations-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListHoursOfOperationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_129) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_129));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListHoursOfOperationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListHoursOfOperationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListHoursOfOperations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListHoursOfOperations",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListHoursOfOperationsInput`](crate::input::ListHoursOfOperationsInput)
    pub fn builder() -> crate::input::list_hours_of_operations_input::Builder {
        crate::input::list_hours_of_operations_input::Builder::default()
    }
}

/// See [`ListInstanceAttributesInput`](crate::input::ListInstanceAttributesInput)
pub mod list_instance_attributes_input {
    /// A builder for [`ListInstanceAttributesInput`](crate::input::ListInstanceAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceAttributesInput`](crate::input::ListInstanceAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceAttributesInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceAttributesInputOperationOutputAlias = crate::operation::ListInstanceAttributes;
#[doc(hidden)]
pub type ListInstanceAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInstanceAttributesInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceAttributes`](crate::operation::ListInstanceAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_130 = &_input.instance_id;
            let input_130 =
                input_130
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_130, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/attributes",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInstanceAttributesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_131) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_131));
            }
            if let Some(inner_132) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_132).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceAttributes",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceAttributesInput`](crate::input::ListInstanceAttributesInput)
    pub fn builder() -> crate::input::list_instance_attributes_input::Builder {
        crate::input::list_instance_attributes_input::Builder::default()
    }
}

/// See [`ListInstancesInput`](crate::input::ListInstancesInput)
pub mod list_instances_input {
    /// A builder for [`ListInstancesInput`](crate::input::ListInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstancesInput`](crate::input::ListInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstancesInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstancesInputOperationOutputAlias = crate::operation::ListInstances;
#[doc(hidden)]
pub type ListInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInstancesInput {
    /// Consumes the builder and constructs an Operation<[`ListInstances`](crate::operation::ListInstances)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstancesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/instance").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInstancesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_133) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_133));
            }
            if let Some(inner_134) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_134).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstancesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstancesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstances",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstancesInput`](crate::input::ListInstancesInput)
    pub fn builder() -> crate::input::list_instances_input::Builder {
        crate::input::list_instances_input::Builder::default()
    }
}

/// See [`ListInstanceStorageConfigsInput`](crate::input::ListInstanceStorageConfigsInput)
pub mod list_instance_storage_configs_input {
    /// A builder for [`ListInstanceStorageConfigsInput`](crate::input::ListInstanceStorageConfigsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::InstanceStorageResourceType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInstanceStorageConfigsInput`](crate::input::ListInstanceStorageConfigsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInstanceStorageConfigsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInstanceStorageConfigsInput {
                instance_id: self.instance_id,
                resource_type: self.resource_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInstanceStorageConfigsInputOperationOutputAlias =
    crate::operation::ListInstanceStorageConfigs;
#[doc(hidden)]
pub type ListInstanceStorageConfigsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInstanceStorageConfigsInput {
    /// Consumes the builder and constructs an Operation<[`ListInstanceStorageConfigs`](crate::operation::ListInstanceStorageConfigs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInstanceStorageConfigs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInstanceStorageConfigsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_135 = &_input.instance_id;
            let input_135 =
                input_135
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_135, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/storage-configs",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInstanceStorageConfigsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_136) = &_input.resource_type {
                query.push_kv(
                    "resourceType",
                    &aws_smithy_http::query::fmt_string(&inner_136),
                );
            }
            if let Some(inner_137) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_137));
            }
            if let Some(inner_138) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_138).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInstanceStorageConfigsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInstanceStorageConfigsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInstanceStorageConfigs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInstanceStorageConfigs",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInstanceStorageConfigsInput`](crate::input::ListInstanceStorageConfigsInput)
    pub fn builder() -> crate::input::list_instance_storage_configs_input::Builder {
        crate::input::list_instance_storage_configs_input::Builder::default()
    }
}

/// See [`ListIntegrationAssociationsInput`](crate::input::ListIntegrationAssociationsInput)
pub mod list_integration_associations_input {
    /// A builder for [`ListIntegrationAssociationsInput`](crate::input::ListIntegrationAssociationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) integration_type: std::option::Option<crate::model::IntegrationType>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The integration type.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.integration_type = Some(input);
            self
        }
        /// <p>The integration type.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.integration_type = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListIntegrationAssociationsInput`](crate::input::ListIntegrationAssociationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListIntegrationAssociationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListIntegrationAssociationsInput {
                instance_id: self.instance_id,
                integration_type: self.integration_type,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListIntegrationAssociationsInputOperationOutputAlias =
    crate::operation::ListIntegrationAssociations;
#[doc(hidden)]
pub type ListIntegrationAssociationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListIntegrationAssociationsInput {
    /// Consumes the builder and constructs an Operation<[`ListIntegrationAssociations`](crate::operation::ListIntegrationAssociations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListIntegrationAssociations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListIntegrationAssociationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_139 = &_input.instance_id;
            let input_139 =
                input_139
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_139, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/integration-associations",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListIntegrationAssociationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_140) = &_input.integration_type {
                query.push_kv(
                    "integrationType",
                    &aws_smithy_http::query::fmt_string(&inner_140),
                );
            }
            if let Some(inner_141) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_141));
            }
            if let Some(inner_142) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_142).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListIntegrationAssociationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListIntegrationAssociationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListIntegrationAssociations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListIntegrationAssociations",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListIntegrationAssociationsInput`](crate::input::ListIntegrationAssociationsInput)
    pub fn builder() -> crate::input::list_integration_associations_input::Builder {
        crate::input::list_integration_associations_input::Builder::default()
    }
}

/// See [`ListLambdaFunctionsInput`](crate::input::ListLambdaFunctionsInput)
pub mod list_lambda_functions_input {
    /// A builder for [`ListLambdaFunctionsInput`](crate::input::ListLambdaFunctionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLambdaFunctionsInput`](crate::input::ListLambdaFunctionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLambdaFunctionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLambdaFunctionsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLambdaFunctionsInputOperationOutputAlias = crate::operation::ListLambdaFunctions;
#[doc(hidden)]
pub type ListLambdaFunctionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLambdaFunctionsInput {
    /// Consumes the builder and constructs an Operation<[`ListLambdaFunctions`](crate::operation::ListLambdaFunctions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLambdaFunctions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLambdaFunctionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_143 = &_input.instance_id;
            let input_143 =
                input_143
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_143, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/lambda-functions",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListLambdaFunctionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_144) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_144));
            }
            if let Some(inner_145) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_145).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLambdaFunctionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLambdaFunctionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLambdaFunctions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLambdaFunctions",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLambdaFunctionsInput`](crate::input::ListLambdaFunctionsInput)
    pub fn builder() -> crate::input::list_lambda_functions_input::Builder {
        crate::input::list_lambda_functions_input::Builder::default()
    }
}

/// See [`ListLexBotsInput`](crate::input::ListLexBotsInput)
pub mod list_lex_bots_input {
    /// A builder for [`ListLexBotsInput`](crate::input::ListLexBotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListLexBotsInput`](crate::input::ListLexBotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListLexBotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListLexBotsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListLexBotsInputOperationOutputAlias = crate::operation::ListLexBots;
#[doc(hidden)]
pub type ListLexBotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListLexBotsInput {
    /// Consumes the builder and constructs an Operation<[`ListLexBots`](crate::operation::ListLexBots)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListLexBots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListLexBotsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_146 = &_input.instance_id;
            let input_146 =
                input_146
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_146, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/lex-bots",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListLexBotsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_147) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_147));
            }
            if let Some(inner_148) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_148).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListLexBotsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListLexBotsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListLexBots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListLexBots",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListLexBotsInput`](crate::input::ListLexBotsInput)
    pub fn builder() -> crate::input::list_lex_bots_input::Builder {
        crate::input::list_lex_bots_input::Builder::default()
    }
}

/// See [`ListPhoneNumbersInput`](crate::input::ListPhoneNumbersInput)
pub mod list_phone_numbers_input {
    /// A builder for [`ListPhoneNumbersInput`](crate::input::ListPhoneNumbersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) phone_number_types:
            std::option::Option<std::vec::Vec<crate::model::PhoneNumberType>>,
        pub(crate) phone_number_country_codes:
            std::option::Option<std::vec::Vec<crate::model::PhoneNumberCountryCode>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `phone_number_types`.
        ///
        /// To override the contents of this collection use [`set_phone_number_types`](Self::set_phone_number_types).
        ///
        /// <p>The type of phone number.</p>
        pub fn phone_number_types(mut self, input: crate::model::PhoneNumberType) -> Self {
            let mut v = self.phone_number_types.unwrap_or_default();
            v.push(input);
            self.phone_number_types = Some(v);
            self
        }
        /// <p>The type of phone number.</p>
        pub fn set_phone_number_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberType>>,
        ) -> Self {
            self.phone_number_types = input;
            self
        }
        /// Appends an item to `phone_number_country_codes`.
        ///
        /// To override the contents of this collection use [`set_phone_number_country_codes`](Self::set_phone_number_country_codes).
        ///
        /// <p>The ISO country code.</p>
        pub fn phone_number_country_codes(
            mut self,
            input: crate::model::PhoneNumberCountryCode,
        ) -> Self {
            let mut v = self.phone_number_country_codes.unwrap_or_default();
            v.push(input);
            self.phone_number_country_codes = Some(v);
            self
        }
        /// <p>The ISO country code.</p>
        pub fn set_phone_number_country_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberCountryCode>>,
        ) -> Self {
            self.phone_number_country_codes = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPhoneNumbersInput`](crate::input::ListPhoneNumbersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPhoneNumbersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPhoneNumbersInput {
                instance_id: self.instance_id,
                phone_number_types: self.phone_number_types,
                phone_number_country_codes: self.phone_number_country_codes,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListPhoneNumbersInputOperationOutputAlias = crate::operation::ListPhoneNumbers;
#[doc(hidden)]
pub type ListPhoneNumbersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPhoneNumbersInput {
    /// Consumes the builder and constructs an Operation<[`ListPhoneNumbers`](crate::operation::ListPhoneNumbers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPhoneNumbers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPhoneNumbersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_149 = &_input.instance_id;
            let input_149 =
                input_149
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_149, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/phone-numbers-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPhoneNumbersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_150) = &_input.phone_number_types {
                for inner_151 in inner_150 {
                    query.push_kv(
                        "phoneNumberTypes",
                        &aws_smithy_http::query::fmt_string(&inner_151),
                    );
                }
            }
            if let Some(inner_152) = &_input.phone_number_country_codes {
                for inner_153 in inner_152 {
                    query.push_kv(
                        "phoneNumberCountryCodes",
                        &aws_smithy_http::query::fmt_string(&inner_153),
                    );
                }
            }
            if let Some(inner_154) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_154));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPhoneNumbersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPhoneNumbersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPhoneNumbers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPhoneNumbers",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPhoneNumbersInput`](crate::input::ListPhoneNumbersInput)
    pub fn builder() -> crate::input::list_phone_numbers_input::Builder {
        crate::input::list_phone_numbers_input::Builder::default()
    }
}

/// See [`ListPromptsInput`](crate::input::ListPromptsInput)
pub mod list_prompts_input {
    /// A builder for [`ListPromptsInput`](crate::input::ListPromptsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPromptsInput`](crate::input::ListPromptsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListPromptsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListPromptsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListPromptsInputOperationOutputAlias = crate::operation::ListPrompts;
#[doc(hidden)]
pub type ListPromptsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListPromptsInput {
    /// Consumes the builder and constructs an Operation<[`ListPrompts`](crate::operation::ListPrompts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListPrompts,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListPromptsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_155 = &_input.instance_id;
            let input_155 =
                input_155
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_155, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/prompts-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListPromptsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_156) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_156));
            }
            if let Some(inner_157) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_157).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListPromptsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListPromptsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListPrompts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListPrompts",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListPromptsInput`](crate::input::ListPromptsInput)
    pub fn builder() -> crate::input::list_prompts_input::Builder {
        crate::input::list_prompts_input::Builder::default()
    }
}

/// See [`ListQueueQuickConnectsInput`](crate::input::ListQueueQuickConnectsInput)
pub mod list_queue_quick_connects_input {
    /// A builder for [`ListQueueQuickConnectsInput`](crate::input::ListQueueQuickConnectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueueQuickConnectsInput`](crate::input::ListQueueQuickConnectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQueueQuickConnectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQueueQuickConnectsInput {
                instance_id: self.instance_id,
                queue_id: self.queue_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQueueQuickConnectsInputOperationOutputAlias = crate::operation::ListQueueQuickConnects;
#[doc(hidden)]
pub type ListQueueQuickConnectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListQueueQuickConnectsInput {
    /// Consumes the builder and constructs an Operation<[`ListQueueQuickConnects`](crate::operation::ListQueueQuickConnects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQueueQuickConnects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQueueQuickConnectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_158 = &_input.instance_id;
            let input_158 =
                input_158
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_158, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_159 = &_input.queue_id;
            let input_159 =
                input_159
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "queue_id",
                        details: "cannot be empty or unset",
                    })?;
            let queue_id = aws_smithy_http::label::fmt_string(input_159, false);
            if queue_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "queue_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/queues/{InstanceId}/{QueueId}/quick-connects",
                InstanceId = instance_id,
                QueueId = queue_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListQueueQuickConnectsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_160) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_160));
            }
            if let Some(inner_161) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_161).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQueueQuickConnectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQueueQuickConnectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQueueQuickConnects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQueueQuickConnects",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQueueQuickConnectsInput`](crate::input::ListQueueQuickConnectsInput)
    pub fn builder() -> crate::input::list_queue_quick_connects_input::Builder {
        crate::input::list_queue_quick_connects_input::Builder::default()
    }
}

/// See [`ListQueuesInput`](crate::input::ListQueuesInput)
pub mod list_queues_input {
    /// A builder for [`ListQueuesInput`](crate::input::ListQueuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) queue_types: std::option::Option<std::vec::Vec<crate::model::QueueType>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Appends an item to `queue_types`.
        ///
        /// To override the contents of this collection use [`set_queue_types`](Self::set_queue_types).
        ///
        /// <p>The type of queue.</p>
        pub fn queue_types(mut self, input: crate::model::QueueType) -> Self {
            let mut v = self.queue_types.unwrap_or_default();
            v.push(input);
            self.queue_types = Some(v);
            self
        }
        /// <p>The type of queue.</p>
        pub fn set_queue_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueueType>>,
        ) -> Self {
            self.queue_types = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueuesInput`](crate::input::ListQueuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQueuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQueuesInput {
                instance_id: self.instance_id,
                queue_types: self.queue_types,
                next_token: self.next_token,
                max_results: self.max_results.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type ListQueuesInputOperationOutputAlias = crate::operation::ListQueues;
#[doc(hidden)]
pub type ListQueuesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListQueuesInput {
    /// Consumes the builder and constructs an Operation<[`ListQueues`](crate::operation::ListQueues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQueues,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQueuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_162 = &_input.instance_id;
            let input_162 =
                input_162
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_162, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/queues-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListQueuesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_163) = &_input.queue_types {
                for inner_164 in inner_163 {
                    query.push_kv(
                        "queueTypes",
                        &aws_smithy_http::query::fmt_string(&inner_164),
                    );
                }
            }
            if let Some(inner_165) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_165));
            }
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQueuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQueuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQueues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQueues",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQueuesInput`](crate::input::ListQueuesInput)
    pub fn builder() -> crate::input::list_queues_input::Builder {
        crate::input::list_queues_input::Builder::default()
    }
}

/// See [`ListQuickConnectsInput`](crate::input::ListQuickConnectsInput)
pub mod list_quick_connects_input {
    /// A builder for [`ListQuickConnectsInput`](crate::input::ListQuickConnectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) quick_connect_types:
            std::option::Option<std::vec::Vec<crate::model::QuickConnectType>>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Appends an item to `quick_connect_types`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_types`](Self::set_quick_connect_types).
        ///
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn quick_connect_types(mut self, input: crate::model::QuickConnectType) -> Self {
            let mut v = self.quick_connect_types.unwrap_or_default();
            v.push(input);
            self.quick_connect_types = Some(v);
            self
        }
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn set_quick_connect_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QuickConnectType>>,
        ) -> Self {
            self.quick_connect_types = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQuickConnectsInput`](crate::input::ListQuickConnectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListQuickConnectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListQuickConnectsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
                quick_connect_types: self.quick_connect_types,
            })
        }
    }
}
#[doc(hidden)]
pub type ListQuickConnectsInputOperationOutputAlias = crate::operation::ListQuickConnects;
#[doc(hidden)]
pub type ListQuickConnectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListQuickConnectsInput {
    /// Consumes the builder and constructs an Operation<[`ListQuickConnects`](crate::operation::ListQuickConnects)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListQuickConnects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListQuickConnectsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_166 = &_input.instance_id;
            let input_166 =
                input_166
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_166, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/quick-connects/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListQuickConnectsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_167) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_167));
            }
            if let Some(inner_168) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_168).encode(),
                );
            }
            if let Some(inner_169) = &_input.quick_connect_types {
                for inner_170 in inner_169 {
                    query.push_kv(
                        "QuickConnectTypes",
                        &aws_smithy_http::query::fmt_string(&inner_170),
                    );
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListQuickConnectsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListQuickConnectsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListQuickConnects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListQuickConnects",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListQuickConnectsInput`](crate::input::ListQuickConnectsInput)
    pub fn builder() -> crate::input::list_quick_connects_input::Builder {
        crate::input::list_quick_connects_input::Builder::default()
    }
}

/// See [`ListRoutingProfileQueuesInput`](crate::input::ListRoutingProfileQueuesInput)
pub mod list_routing_profile_queues_input {
    /// A builder for [`ListRoutingProfileQueuesInput`](crate::input::ListRoutingProfileQueuesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) routing_profile_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.routing_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.routing_profile_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutingProfileQueuesInput`](crate::input::ListRoutingProfileQueuesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRoutingProfileQueuesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRoutingProfileQueuesInput {
                instance_id: self.instance_id,
                routing_profile_id: self.routing_profile_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRoutingProfileQueuesInputOperationOutputAlias =
    crate::operation::ListRoutingProfileQueues;
#[doc(hidden)]
pub type ListRoutingProfileQueuesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRoutingProfileQueuesInput {
    /// Consumes the builder and constructs an Operation<[`ListRoutingProfileQueues`](crate::operation::ListRoutingProfileQueues)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoutingProfileQueues,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRoutingProfileQueuesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_171 = &_input.instance_id;
            let input_171 =
                input_171
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_171, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_172 = &_input.routing_profile_id;
            let input_172 =
                input_172
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "routing_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let routing_profile_id = aws_smithy_http::label::fmt_string(input_172, false);
            if routing_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "routing_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/routing-profiles/{InstanceId}/{RoutingProfileId}/queues",
                InstanceId = instance_id,
                RoutingProfileId = routing_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRoutingProfileQueuesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_173) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_173));
            }
            if let Some(inner_174) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_174).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRoutingProfileQueuesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRoutingProfileQueuesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRoutingProfileQueues::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRoutingProfileQueues",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRoutingProfileQueuesInput`](crate::input::ListRoutingProfileQueuesInput)
    pub fn builder() -> crate::input::list_routing_profile_queues_input::Builder {
        crate::input::list_routing_profile_queues_input::Builder::default()
    }
}

/// See [`ListRoutingProfilesInput`](crate::input::ListRoutingProfilesInput)
pub mod list_routing_profiles_input {
    /// A builder for [`ListRoutingProfilesInput`](crate::input::ListRoutingProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListRoutingProfilesInput`](crate::input::ListRoutingProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListRoutingProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListRoutingProfilesInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListRoutingProfilesInputOperationOutputAlias = crate::operation::ListRoutingProfiles;
#[doc(hidden)]
pub type ListRoutingProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListRoutingProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListRoutingProfiles`](crate::operation::ListRoutingProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListRoutingProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListRoutingProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_175 = &_input.instance_id;
            let input_175 =
                input_175
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_175, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/routing-profiles-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListRoutingProfilesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_176) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_176));
            }
            if let Some(inner_177) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_177).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListRoutingProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListRoutingProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListRoutingProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListRoutingProfiles",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListRoutingProfilesInput`](crate::input::ListRoutingProfilesInput)
    pub fn builder() -> crate::input::list_routing_profiles_input::Builder {
        crate::input::list_routing_profiles_input::Builder::default()
    }
}

/// See [`ListSecurityKeysInput`](crate::input::ListSecurityKeysInput)
pub mod list_security_keys_input {
    /// A builder for [`ListSecurityKeysInput`](crate::input::ListSecurityKeysInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityKeysInput`](crate::input::ListSecurityKeysInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSecurityKeysInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSecurityKeysInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSecurityKeysInputOperationOutputAlias = crate::operation::ListSecurityKeys;
#[doc(hidden)]
pub type ListSecurityKeysInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSecurityKeysInput {
    /// Consumes the builder and constructs an Operation<[`ListSecurityKeys`](crate::operation::ListSecurityKeys)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSecurityKeys,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSecurityKeysInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_178 = &_input.instance_id;
            let input_178 =
                input_178
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_178, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/instance/{InstanceId}/security-keys",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSecurityKeysInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_179) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_179));
            }
            if let Some(inner_180) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_180).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSecurityKeysInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSecurityKeysInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSecurityKeys::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSecurityKeys",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSecurityKeysInput`](crate::input::ListSecurityKeysInput)
    pub fn builder() -> crate::input::list_security_keys_input::Builder {
        crate::input::list_security_keys_input::Builder::default()
    }
}

/// See [`ListSecurityProfilePermissionsInput`](crate::input::ListSecurityProfilePermissionsInput)
pub mod list_security_profile_permissions_input {
    /// A builder for [`ListSecurityProfilePermissionsInput`](crate::input::ListSecurityProfilePermissionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) security_profile_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.security_profile_id = Some(input.into());
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.security_profile_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityProfilePermissionsInput`](crate::input::ListSecurityProfilePermissionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSecurityProfilePermissionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSecurityProfilePermissionsInput {
                security_profile_id: self.security_profile_id,
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSecurityProfilePermissionsInputOperationOutputAlias =
    crate::operation::ListSecurityProfilePermissions;
#[doc(hidden)]
pub type ListSecurityProfilePermissionsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ListSecurityProfilePermissionsInput {
    /// Consumes the builder and constructs an Operation<[`ListSecurityProfilePermissions`](crate::operation::ListSecurityProfilePermissions)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSecurityProfilePermissions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSecurityProfilePermissionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_181 = &_input.instance_id;
            let input_181 =
                input_181
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_181, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_182 = &_input.security_profile_id;
            let input_182 =
                input_182
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "security_profile_id",
                        details: "cannot be empty or unset",
                    })?;
            let security_profile_id = aws_smithy_http::label::fmt_string(input_182, false);
            if security_profile_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "security_profile_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/security-profiles-permissions/{InstanceId}/{SecurityProfileId}",
                InstanceId = instance_id,
                SecurityProfileId = security_profile_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSecurityProfilePermissionsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_183) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_183));
            }
            if let Some(inner_184) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_184).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSecurityProfilePermissionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSecurityProfilePermissionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSecurityProfilePermissions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSecurityProfilePermissions",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSecurityProfilePermissionsInput`](crate::input::ListSecurityProfilePermissionsInput)
    pub fn builder() -> crate::input::list_security_profile_permissions_input::Builder {
        crate::input::list_security_profile_permissions_input::Builder::default()
    }
}

/// See [`ListSecurityProfilesInput`](crate::input::ListSecurityProfilesInput)
pub mod list_security_profiles_input {
    /// A builder for [`ListSecurityProfilesInput`](crate::input::ListSecurityProfilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListSecurityProfilesInput`](crate::input::ListSecurityProfilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListSecurityProfilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListSecurityProfilesInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListSecurityProfilesInputOperationOutputAlias = crate::operation::ListSecurityProfiles;
#[doc(hidden)]
pub type ListSecurityProfilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListSecurityProfilesInput {
    /// Consumes the builder and constructs an Operation<[`ListSecurityProfiles`](crate::operation::ListSecurityProfiles)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListSecurityProfiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListSecurityProfilesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_185 = &_input.instance_id;
            let input_185 =
                input_185
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_185, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/security-profiles-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListSecurityProfilesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_186) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_186));
            }
            if let Some(inner_187) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_187).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListSecurityProfilesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListSecurityProfilesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListSecurityProfiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListSecurityProfiles",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListSecurityProfilesInput`](crate::input::ListSecurityProfilesInput)
    pub fn builder() -> crate::input::list_security_profiles_input::Builder {
        crate::input::list_security_profiles_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_188 = &_input.resource_arn;
            let input_188 =
                input_188
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_188, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`ListUseCasesInput`](crate::input::ListUseCasesInput)
pub mod list_use_cases_input {
    /// A builder for [`ListUseCasesInput`](crate::input::ListUseCasesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) integration_association_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.integration_association_id = Some(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.integration_association_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUseCasesInput`](crate::input::ListUseCasesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUseCasesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUseCasesInput {
                instance_id: self.instance_id,
                integration_association_id: self.integration_association_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUseCasesInputOperationOutputAlias = crate::operation::ListUseCases;
#[doc(hidden)]
pub type ListUseCasesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUseCasesInput {
    /// Consumes the builder and constructs an Operation<[`ListUseCases`](crate::operation::ListUseCases)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUseCases,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUseCasesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_189 = &_input.instance_id;
            let input_189 =
                input_189
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_189, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_190 = &_input.integration_association_id;
            let input_190 =
                input_190
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "integration_association_id",
                        details: "cannot be empty or unset",
                    })?;
            let integration_association_id = aws_smithy_http::label::fmt_string(input_190, false);
            if integration_association_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "integration_association_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases", InstanceId = instance_id, IntegrationAssociationId = integration_association_id).expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListUseCasesInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_191) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_191));
            }
            if let Some(inner_192) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_192).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUseCasesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUseCasesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUseCases::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUseCases",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUseCasesInput`](crate::input::ListUseCasesInput)
    pub fn builder() -> crate::input::list_use_cases_input::Builder {
        crate::input::list_use_cases_input::Builder::default()
    }
}

/// See [`ListUserHierarchyGroupsInput`](crate::input::ListUserHierarchyGroupsInput)
pub mod list_user_hierarchy_groups_input {
    /// A builder for [`ListUserHierarchyGroupsInput`](crate::input::ListUserHierarchyGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUserHierarchyGroupsInput`](crate::input::ListUserHierarchyGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListUserHierarchyGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListUserHierarchyGroupsInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUserHierarchyGroupsInputOperationOutputAlias =
    crate::operation::ListUserHierarchyGroups;
#[doc(hidden)]
pub type ListUserHierarchyGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUserHierarchyGroupsInput {
    /// Consumes the builder and constructs an Operation<[`ListUserHierarchyGroups`](crate::operation::ListUserHierarchyGroups)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUserHierarchyGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUserHierarchyGroupsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_193 = &_input.instance_id;
            let input_193 =
                input_193
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_193, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/user-hierarchy-groups-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListUserHierarchyGroupsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_194) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_194));
            }
            if let Some(inner_195) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_195).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUserHierarchyGroupsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUserHierarchyGroupsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListUserHierarchyGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListUserHierarchyGroups",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUserHierarchyGroupsInput`](crate::input::ListUserHierarchyGroupsInput)
    pub fn builder() -> crate::input::list_user_hierarchy_groups_input::Builder {
        crate::input::list_user_hierarchy_groups_input::Builder::default()
    }
}

/// See [`ListUsersInput`](crate::input::ListUsersInput)
pub mod list_users_input {
    /// A builder for [`ListUsersInput`](crate::input::ListUsersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListUsersInput`](crate::input::ListUsersInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListUsersInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListUsersInput {
                instance_id: self.instance_id,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListUsersInputOperationOutputAlias = crate::operation::ListUsers;
#[doc(hidden)]
pub type ListUsersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListUsersInput {
    /// Consumes the builder and constructs an Operation<[`ListUsers`](crate::operation::ListUsers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListUsers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListUsersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_196 = &_input.instance_id;
            let input_196 =
                input_196
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_196, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/users-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListUsersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_197) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_197));
            }
            if let Some(inner_198) = &_input.max_results {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(*inner_198).encode(),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListUsersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListUsersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListUsers::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListUsers",
                    "connect",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListUsersInput`](crate::input::ListUsersInput)
    pub fn builder() -> crate::input::list_users_input::Builder {
        crate::input::list_users_input::Builder::default()
    }
}

/// See [`ResumeContactRecordingInput`](crate::input::ResumeContactRecordingInput)
pub mod resume_contact_recording_input {
    /// A builder for [`ResumeContactRecordingInput`](crate::input::ResumeContactRecordingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) initial_contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeContactRecordingInput`](crate::input::ResumeContactRecordingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResumeContactRecordingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResumeContactRecordingInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                initial_contact_id: self.initial_contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type ResumeContactRecordingInputOperationOutputAlias = crate::operation::ResumeContactRecording;
#[doc(hidden)]
pub type ResumeContactRecordingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ResumeContactRecordingInput {
    /// Consumes the builder and constructs an Operation<[`ResumeContactRecording`](crate::operation::ResumeContactRecording)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResumeContactRecording,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResumeContactRecordingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/resume-recording").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResumeContactRecordingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResumeContactRecordingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_resume_contact_recording(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResumeContactRecording::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResumeContactRecording",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResumeContactRecordingInput`](crate::input::ResumeContactRecordingInput)
    pub fn builder() -> crate::input::resume_contact_recording_input::Builder {
        crate::input::resume_contact_recording_input::Builder::default()
    }
}

/// See [`SearchVocabulariesInput`](crate::input::SearchVocabulariesInput)
pub mod search_vocabularies_input {
    /// A builder for [`SearchVocabulariesInput`](crate::input::SearchVocabulariesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::VocabularyState>,
        pub(crate) name_starts_with: std::option::Option<std::string::String>,
        pub(crate) language_code: std::option::Option<crate::model::VocabularyLanguageCode>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The current state of the custom vocabulary.</p>
        pub fn state(mut self, input: crate::model::VocabularyState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the custom vocabulary.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::VocabularyState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The starting pattern of the name of the vocabulary.</p>
        pub fn name_starts_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_starts_with = Some(input.into());
            self
        }
        /// <p>The starting pattern of the name of the vocabulary.</p>
        pub fn set_name_starts_with(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_starts_with = input;
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.language_code = Some(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchVocabulariesInput`](crate::input::SearchVocabulariesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchVocabulariesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchVocabulariesInput {
                instance_id: self.instance_id,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                state: self.state,
                name_starts_with: self.name_starts_with,
                language_code: self.language_code,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchVocabulariesInputOperationOutputAlias = crate::operation::SearchVocabularies;
#[doc(hidden)]
pub type SearchVocabulariesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SearchVocabulariesInput {
    /// Consumes the builder and constructs an Operation<[`SearchVocabularies`](crate::operation::SearchVocabularies)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchVocabularies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchVocabulariesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_199 = &_input.instance_id;
            let input_199 =
                input_199
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_199, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/vocabulary-summary/{InstanceId}",
                InstanceId = instance_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchVocabulariesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchVocabulariesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_vocabularies(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchVocabularies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchVocabularies",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchVocabulariesInput`](crate::input::SearchVocabulariesInput)
    pub fn builder() -> crate::input::search_vocabularies_input::Builder {
        crate::input::search_vocabularies_input::Builder::default()
    }
}

/// See [`StartChatContactInput`](crate::input::StartChatContactInput)
pub mod start_chat_contact_input {
    /// A builder for [`StartChatContactInput`](crate::input::StartChatContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) participant_details: std::option::Option<crate::model::ParticipantDetails>,
        pub(crate) initial_message: std::option::Option<crate::model::ChatMessage>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in contact flows just like any other contact attributes. </p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in contact flows just like any other contact attributes. </p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Information identifying the participant.</p>
        pub fn participant_details(mut self, input: crate::model::ParticipantDetails) -> Self {
            self.participant_details = Some(input);
            self
        }
        /// <p>Information identifying the participant.</p>
        pub fn set_participant_details(
            mut self,
            input: std::option::Option<crate::model::ParticipantDetails>,
        ) -> Self {
            self.participant_details = input;
            self
        }
        /// <p>The initial message to be sent to the newly created chat.</p>
        pub fn initial_message(mut self, input: crate::model::ChatMessage) -> Self {
            self.initial_message = Some(input);
            self
        }
        /// <p>The initial message to be sent to the newly created chat.</p>
        pub fn set_initial_message(
            mut self,
            input: std::option::Option<crate::model::ChatMessage>,
        ) -> Self {
            self.initial_message = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChatContactInput`](crate::input::StartChatContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartChatContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartChatContactInput {
                instance_id: self.instance_id,
                contact_flow_id: self.contact_flow_id,
                attributes: self.attributes,
                participant_details: self.participant_details,
                initial_message: self.initial_message,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartChatContactInputOperationOutputAlias = crate::operation::StartChatContact;
#[doc(hidden)]
pub type StartChatContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartChatContactInput {
    /// Consumes the builder and constructs an Operation<[`StartChatContact`](crate::operation::StartChatContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartChatContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartChatContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/chat").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartChatContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartChatContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_chat_contact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartChatContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartChatContact",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartChatContactInput`](crate::input::StartChatContactInput)
    pub fn builder() -> crate::input::start_chat_contact_input::Builder {
        crate::input::start_chat_contact_input::Builder::default()
    }
}

/// See [`StartContactRecordingInput`](crate::input::StartContactRecordingInput)
pub mod start_contact_recording_input {
    /// A builder for [`StartContactRecordingInput`](crate::input::StartContactRecordingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) initial_contact_id: std::option::Option<std::string::String>,
        pub(crate) voice_recording_configuration:
            std::option::Option<crate::model::VoiceRecordingConfiguration>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_contact_id = input;
            self
        }
        /// <p>The person being recorded.</p>
        pub fn voice_recording_configuration(
            mut self,
            input: crate::model::VoiceRecordingConfiguration,
        ) -> Self {
            self.voice_recording_configuration = Some(input);
            self
        }
        /// <p>The person being recorded.</p>
        pub fn set_voice_recording_configuration(
            mut self,
            input: std::option::Option<crate::model::VoiceRecordingConfiguration>,
        ) -> Self {
            self.voice_recording_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`StartContactRecordingInput`](crate::input::StartContactRecordingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartContactRecordingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartContactRecordingInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                initial_contact_id: self.initial_contact_id,
                voice_recording_configuration: self.voice_recording_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type StartContactRecordingInputOperationOutputAlias = crate::operation::StartContactRecording;
#[doc(hidden)]
pub type StartContactRecordingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartContactRecordingInput {
    /// Consumes the builder and constructs an Operation<[`StartContactRecording`](crate::operation::StartContactRecording)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartContactRecording,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartContactRecordingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/start-recording").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartContactRecordingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartContactRecordingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_contact_recording(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartContactRecording::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartContactRecording",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartContactRecordingInput`](crate::input::StartContactRecordingInput)
    pub fn builder() -> crate::input::start_contact_recording_input::Builder {
        crate::input::start_contact_recording_input::Builder::default()
    }
}

/// See [`StartContactStreamingInput`](crate::input::StartContactStreamingInput)
pub mod start_contact_streaming_input {
    /// A builder for [`StartContactStreamingInput`](crate::input::StartContactStreamingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) chat_streaming_configuration:
            std::option::Option<crate::model::ChatStreamingConfiguration>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
        pub fn chat_streaming_configuration(
            mut self,
            input: crate::model::ChatStreamingConfiguration,
        ) -> Self {
            self.chat_streaming_configuration = Some(input);
            self
        }
        /// <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
        pub fn set_chat_streaming_configuration(
            mut self,
            input: std::option::Option<crate::model::ChatStreamingConfiguration>,
        ) -> Self {
            self.chat_streaming_configuration = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartContactStreamingInput`](crate::input::StartContactStreamingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartContactStreamingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartContactStreamingInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                chat_streaming_configuration: self.chat_streaming_configuration,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartContactStreamingInputOperationOutputAlias = crate::operation::StartContactStreaming;
#[doc(hidden)]
pub type StartContactStreamingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartContactStreamingInput {
    /// Consumes the builder and constructs an Operation<[`StartContactStreaming`](crate::operation::StartContactStreaming)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartContactStreaming,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartContactStreamingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/start-streaming").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartContactStreamingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartContactStreamingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_contact_streaming(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartContactStreaming::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartContactStreaming",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartContactStreamingInput`](crate::input::StartContactStreamingInput)
    pub fn builder() -> crate::input::start_contact_streaming_input::Builder {
        crate::input::start_contact_streaming_input::Builder::default()
    }
}

/// See [`StartOutboundVoiceContactInput`](crate::input::StartOutboundVoiceContactInput)
pub mod start_outbound_voice_contact_input {
    /// A builder for [`StartOutboundVoiceContactInput`](crate::input::StartOutboundVoiceContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_phone_number: std::option::Option<std::string::String>,
        pub(crate) contact_flow_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) source_phone_number: std::option::Option<std::string::String>,
        pub(crate) queue_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) answer_machine_detection_config:
            std::option::Option<crate::model::AnswerMachineDetectionConfig>,
        pub(crate) campaign_id: std::option::Option<std::string::String>,
        pub(crate) traffic_type: std::option::Option<crate::model::TrafficType>,
    }
    impl Builder {
        /// <p>The phone number of the customer, in E.164 format.</p>
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number of the customer, in E.164 format.</p>
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_phone_number = input;
            self
        }
        /// <p>The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>
        pub fn source_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_phone_number = Some(input.into());
            self
        }
        /// <p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>
        pub fn set_source_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_phone_number = input;
            self
        }
        /// <p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.queue_id = Some(input.into());
            self
        }
        /// <p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.queue_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>Configuration of the answering machine detection for this outbound call. </p>
        pub fn answer_machine_detection_config(
            mut self,
            input: crate::model::AnswerMachineDetectionConfig,
        ) -> Self {
            self.answer_machine_detection_config = Some(input);
            self
        }
        /// <p>Configuration of the answering machine detection for this outbound call. </p>
        pub fn set_answer_machine_detection_config(
            mut self,
            input: std::option::Option<crate::model::AnswerMachineDetectionConfig>,
        ) -> Self {
            self.answer_machine_detection_config = input;
            self
        }
        /// <p>The campaign identifier of the outbound communication.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.campaign_id = Some(input.into());
            self
        }
        /// <p>The campaign identifier of the outbound communication.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.campaign_id = input;
            self
        }
        /// <p>Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use <code>GENERAL</code>. </p>
        pub fn traffic_type(mut self, input: crate::model::TrafficType) -> Self {
            self.traffic_type = Some(input);
            self
        }
        /// <p>Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use <code>GENERAL</code>. </p>
        pub fn set_traffic_type(
            mut self,
            input: std::option::Option<crate::model::TrafficType>,
        ) -> Self {
            self.traffic_type = input;
            self
        }
        /// Consumes the builder and constructs a [`StartOutboundVoiceContactInput`](crate::input::StartOutboundVoiceContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartOutboundVoiceContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartOutboundVoiceContactInput {
                destination_phone_number: self.destination_phone_number,
                contact_flow_id: self.contact_flow_id,
                instance_id: self.instance_id,
                client_token: self.client_token,
                source_phone_number: self.source_phone_number,
                queue_id: self.queue_id,
                attributes: self.attributes,
                answer_machine_detection_config: self.answer_machine_detection_config,
                campaign_id: self.campaign_id,
                traffic_type: self.traffic_type,
            })
        }
    }
}
#[doc(hidden)]
pub type StartOutboundVoiceContactInputOperationOutputAlias =
    crate::operation::StartOutboundVoiceContact;
#[doc(hidden)]
pub type StartOutboundVoiceContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartOutboundVoiceContactInput {
    /// Consumes the builder and constructs an Operation<[`StartOutboundVoiceContact`](crate::operation::StartOutboundVoiceContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartOutboundVoiceContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartOutboundVoiceContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/outbound-voice").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartOutboundVoiceContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartOutboundVoiceContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_outbound_voice_contact(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartOutboundVoiceContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartOutboundVoiceContact",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartOutboundVoiceContactInput`](crate::input::StartOutboundVoiceContactInput)
    pub fn builder() -> crate::input::start_outbound_voice_contact_input::Builder {
        crate::input::start_outbound_voice_contact_input::Builder::default()
    }
}

/// See [`StartTaskContactInput`](crate::input::StartTaskContactInput)
pub mod start_task_contact_input {
    /// A builder for [`StartTaskContactInput`](crate::input::StartTaskContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) previous_contact_id: std::option::Option<std::string::String>,
        pub(crate) contact_flow_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) references: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Reference>,
        >,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) scheduled_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the previous chat, voice, or task contact. </p>
        pub fn previous_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.previous_contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the previous chat, voice, or task contact. </p>
        pub fn set_previous_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.previous_contact_id = input;
            self
        }
        /// <p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_flow_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.contact_flow_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `references`.
        ///
        /// To override the contents of this collection use [`set_references`](Self::set_references).
        ///
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn references(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Reference,
        ) -> Self {
            let mut hash_map = self.references.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.references = Some(hash_map);
            self
        }
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_references(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Reference>,
            >,
        ) -> Self {
            self.references = input;
            self
        }
        /// <p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn scheduled_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.scheduled_time = Some(input);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.scheduled_time = input;
            self
        }
        /// Consumes the builder and constructs a [`StartTaskContactInput`](crate::input::StartTaskContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartTaskContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartTaskContactInput {
                instance_id: self.instance_id,
                previous_contact_id: self.previous_contact_id,
                contact_flow_id: self.contact_flow_id,
                attributes: self.attributes,
                name: self.name,
                references: self.references,
                description: self.description,
                client_token: self.client_token,
                scheduled_time: self.scheduled_time,
            })
        }
    }
}
#[doc(hidden)]
pub type StartTaskContactInputOperationOutputAlias = crate::operation::StartTaskContact;
#[doc(hidden)]
pub type StartTaskContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartTaskContactInput {
    /// Consumes the builder and constructs an Operation<[`StartTaskContact`](crate::operation::StartTaskContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartTaskContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartTaskContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/task").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartTaskContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartTaskContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_task_contact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartTaskContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartTaskContact",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartTaskContactInput`](crate::input::StartTaskContactInput)
    pub fn builder() -> crate::input::start_task_contact_input::Builder {
        crate::input::start_task_contact_input::Builder::default()
    }
}

/// See [`StopContactInput`](crate::input::StopContactInput)
pub mod stop_contact_input {
    /// A builder for [`StopContactInput`](crate::input::StopContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The ID of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopContactInput`](crate::input::StopContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopContactInput {
                contact_id: self.contact_id,
                instance_id: self.instance_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopContactInputOperationOutputAlias = crate::operation::StopContact;
#[doc(hidden)]
pub type StopContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopContactInput {
    /// Consumes the builder and constructs an Operation<[`StopContact`](crate::operation::StopContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/stop").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_stop_contact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopContact",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopContactInput`](crate::input::StopContactInput)
    pub fn builder() -> crate::input::stop_contact_input::Builder {
        crate::input::stop_contact_input::Builder::default()
    }
}

/// See [`StopContactRecordingInput`](crate::input::StopContactRecordingInput)
pub mod stop_contact_recording_input {
    /// A builder for [`StopContactRecordingInput`](crate::input::StopContactRecordingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) initial_contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopContactRecordingInput`](crate::input::StopContactRecordingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopContactRecordingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopContactRecordingInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                initial_contact_id: self.initial_contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopContactRecordingInputOperationOutputAlias = crate::operation::StopContactRecording;
#[doc(hidden)]
pub type StopContactRecordingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopContactRecordingInput {
    /// Consumes the builder and constructs an Operation<[`StopContactRecording`](crate::operation::StopContactRecording)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopContactRecording,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopContactRecordingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/stop-recording").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopContactRecordingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopContactRecordingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_contact_recording(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopContactRecording::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopContactRecording",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopContactRecordingInput`](crate::input::StopContactRecordingInput)
    pub fn builder() -> crate::input::stop_contact_recording_input::Builder {
        crate::input::stop_contact_recording_input::Builder::default()
    }
}

/// See [`StopContactStreamingInput`](crate::input::StopContactStreamingInput)
pub mod stop_contact_streaming_input {
    /// A builder for [`StopContactStreamingInput`](crate::input::StopContactStreamingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) streaming_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact that is associated with the first interaction with the contact center.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact that is associated with the first interaction with the contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The identifier of the streaming configuration enabled. </p>
        pub fn streaming_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.streaming_id = Some(input.into());
            self
        }
        /// <p>The identifier of the streaming configuration enabled. </p>
        pub fn set_streaming_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.streaming_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StopContactStreamingInput`](crate::input::StopContactStreamingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StopContactStreamingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StopContactStreamingInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                streaming_id: self.streaming_id,
            })
        }
    }
}
#[doc(hidden)]
pub type StopContactStreamingInputOperationOutputAlias = crate::operation::StopContactStreaming;
#[doc(hidden)]
pub type StopContactStreamingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopContactStreamingInput {
    /// Consumes the builder and constructs an Operation<[`StopContactStreaming`](crate::operation::StopContactStreaming)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopContactStreaming,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopContactStreamingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/stop-streaming").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopContactStreamingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopContactStreamingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_stop_contact_streaming(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StopContactStreaming::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StopContactStreaming",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopContactStreamingInput`](crate::input::StopContactStreamingInput)
    pub fn builder() -> crate::input::stop_contact_streaming_input::Builder {
        crate::input::stop_contact_streaming_input::Builder::default()
    }
}

/// See [`SuspendContactRecordingInput`](crate::input::SuspendContactRecordingInput)
pub mod suspend_contact_recording_input {
    /// A builder for [`SuspendContactRecordingInput`](crate::input::SuspendContactRecordingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) initial_contact_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_contact_id = input;
            self
        }
        /// Consumes the builder and constructs a [`SuspendContactRecordingInput`](crate::input::SuspendContactRecordingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SuspendContactRecordingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SuspendContactRecordingInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                initial_contact_id: self.initial_contact_id,
            })
        }
    }
}
#[doc(hidden)]
pub type SuspendContactRecordingInputOperationOutputAlias =
    crate::operation::SuspendContactRecording;
#[doc(hidden)]
pub type SuspendContactRecordingInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl SuspendContactRecordingInput {
    /// Consumes the builder and constructs an Operation<[`SuspendContactRecording`](crate::operation::SuspendContactRecording)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SuspendContactRecording,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SuspendContactRecordingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/suspend-recording").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SuspendContactRecordingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SuspendContactRecordingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_suspend_contact_recording(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SuspendContactRecording::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SuspendContactRecording",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SuspendContactRecordingInput`](crate::input::SuspendContactRecordingInput)
    pub fn builder() -> crate::input::suspend_contact_recording_input::Builder {
        crate::input::suspend_contact_recording_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_200 = &_input.resource_arn;
            let input_200 =
                input_200
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_200, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_201 = &_input.resource_arn;
            let input_201 =
                input_201
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_201, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_202) = &_input.tag_keys {
                for inner_203 in inner_202 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_203));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateAgentStatusInput`](crate::input::UpdateAgentStatusInput)
pub mod update_agent_status_input {
    /// A builder for [`UpdateAgentStatusInput`](crate::input::UpdateAgentStatusInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) agent_status_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::AgentStatusState>,
        pub(crate) display_order: std::option::Option<i32>,
        pub(crate) reset_order_number: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn agent_status_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.agent_status_id = Some(input.into());
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn set_agent_status_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.agent_status_id = input;
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn state(mut self, input: crate::model::AgentStatusState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AgentStatusState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn display_order(mut self, input: i32) -> Self {
            self.display_order = Some(input);
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn set_display_order(mut self, input: std::option::Option<i32>) -> Self {
            self.display_order = input;
            self
        }
        /// <p>A number indicating the reset order of the agent status.</p>
        pub fn reset_order_number(mut self, input: bool) -> Self {
            self.reset_order_number = Some(input);
            self
        }
        /// <p>A number indicating the reset order of the agent status.</p>
        pub fn set_reset_order_number(mut self, input: std::option::Option<bool>) -> Self {
            self.reset_order_number = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateAgentStatusInput`](crate::input::UpdateAgentStatusInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateAgentStatusInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateAgentStatusInput {
                instance_id: self.instance_id,
                agent_status_id: self.agent_status_id,
                name: self.name,
                description: self.description,
                state: self.state,
                display_order: self.display_order,
                reset_order_number: self.reset_order_number.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateAgentStatusInputOperationOutputAlias = crate::operation::UpdateAgentStatus;
#[doc(hidden)]
pub type UpdateAgentStatusInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateAgentStatusInput {
    /// Consumes the builder and constructs an Operation<[`UpdateAgentStatus`](crate::operation::UpdateAgentStatus)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateAgentStatus,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateAgentStatusInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_204 = &_input.instance_id;
            let input_204 =
                input_204
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_204, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_205 = &_input.agent_status_id;
            let input_205 =
                input_205
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "agent_status_id",
                        details: "cannot be empty or unset",
                    })?;
            let agent_status_id = aws_smithy_http::label::fmt_string(input_205, false);
            if agent_status_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "agent_status_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/agent-status/{InstanceId}/{AgentStatusId}",
                InstanceId = instance_id,
                AgentStatusId = agent_status_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateAgentStatusInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateAgentStatusInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_agent_status(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateAgentStatus::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateAgentStatus",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateAgentStatusInput`](crate::input::UpdateAgentStatusInput)
    pub fn builder() -> crate::input::update_agent_status_input::Builder {
        crate::input::update_agent_status_input::Builder::default()
    }
}

/// See [`UpdateContactInput`](crate::input::UpdateContactInput)
pub mod update_contact_input {
    /// A builder for [`UpdateContactInput`](crate::input::UpdateContactInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) contact_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) references: std::option::Option<
            std::collections::HashMap<std::string::String, crate::model::Reference>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.contact_id = input;
            self
        }
        /// <p>The name of the contact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the contact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the contact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the contact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `references`.
        ///
        /// To override the contents of this collection use [`set_references`](Self::set_references).
        ///
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn references(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Reference,
        ) -> Self {
            let mut hash_map = self.references.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.references = Some(hash_map);
            self
        }
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_references(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Reference>,
            >,
        ) -> Self {
            self.references = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContactInput`](crate::input::UpdateContactInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContactInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContactInput {
                instance_id: self.instance_id,
                contact_id: self.contact_id,
                name: self.name,
                description: self.description,
                references: self.references,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContactInputOperationOutputAlias = crate::operation::UpdateContact;
#[doc(hidden)]
pub type UpdateContactInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateContactInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContact`](crate::operation::UpdateContact)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContact,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContactInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_206 = &_input.instance_id;
            let input_206 =
                input_206
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "instance_id",
                        details: "cannot be empty or unset",
                    })?;
            let instance_id = aws_smithy_http::label::fmt_string(input_206, false);
            if instance_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "instance_id",
                    details: "cannot be empty or unset",
                });
            }
            let input_207 = &_input.contact_id;
            let input_207 =
                input_207
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "contact_id",
                        details: "cannot be empty or unset",
                    })?;
            let contact_id = aws_smithy_http::label::fmt_string(input_207, false);
            if contact_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "contact_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/contacts/{InstanceId}/{ContactId}",
                InstanceId = instance_id,
                ContactId = contact_id
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContactInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContactInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_contact(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContact::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContact",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateContactInput`](crate::input::UpdateContactInput)
    pub fn builder() -> crate::input::update_contact_input::Builder {
        crate::input::update_contact_input::Builder::default()
    }
}

/// See [`UpdateContactAttributesInput`](crate::input::UpdateContactAttributesInput)
pub mod update_contact_attributes_input {
    /// A builder for [`UpdateContactAttributesInput`](crate::input::UpdateContactAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) initial_contact_id: std::option::Option<std::string::String>,
        pub(crate) instance_id: std::option::Option<std::string::String>,
        pub(crate) attributes: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.initial_contact_id = Some(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.initial_contact_id = input;
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_id = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.instance_id = input;
            self
        }
        /// Adds a key-value pair to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.attributes.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.attributes = Some(hash_map);
            self
        }
        /// <p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateContactAttributesInput`](crate::input::UpdateContactAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateContactAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateContactAttributesInput {
                initial_contact_id: self.initial_contact_id,
                instance_id: self.instance_id,
                attributes: self.attributes,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateContactAttributesInputOperationOutputAlias =
    crate::operation::UpdateContactAttributes;
#[doc(hidden)]
pub type UpdateContactAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateContactAttributesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateContactAttributes`](crate::operation::UpdateContactAttributes)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateContactAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateContactAttributesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/contact/attributes").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateContactAttributesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateContactAttributesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_contact_attributes(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateContactAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateContactAttributes",
            "connect",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::B