// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Connect Service
///
/// Client for invoking operations on Amazon Connect Service. Each operation on Amazon Connect Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_connect::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_connect::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_connect::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AssociateApprovedOrigin`](crate::client::fluent_builders::AssociateApprovedOrigin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateApprovedOrigin::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateApprovedOrigin::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`origin(impl Into<String>)`](crate::client::fluent_builders::AssociateApprovedOrigin::origin) / [`set_origin(Option<String>)`](crate::client::fluent_builders::AssociateApprovedOrigin::set_origin): <p>The domain to add to your allow list.</p>
    /// - On success, responds with [`AssociateApprovedOriginOutput`](crate::output::AssociateApprovedOriginOutput)

    /// - On failure, responds with [`SdkError<AssociateApprovedOriginError>`](crate::error::AssociateApprovedOriginError)
    pub fn associate_approved_origin(&self) -> fluent_builders::AssociateApprovedOrigin<C, M, R> {
        fluent_builders::AssociateApprovedOrigin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateBot`](crate::client::fluent_builders::AssociateBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateBot::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateBot::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`lex_bot(LexBot)`](crate::client::fluent_builders::AssociateBot::lex_bot) / [`set_lex_bot(Option<LexBot>)`](crate::client::fluent_builders::AssociateBot::set_lex_bot): <p>Configuration information of an Amazon Lex bot.</p>
    ///   - [`lex_v2_bot(LexV2Bot)`](crate::client::fluent_builders::AssociateBot::lex_v2_bot) / [`set_lex_v2_bot(Option<LexV2Bot>)`](crate::client::fluent_builders::AssociateBot::set_lex_v2_bot): <p>The Amazon Lex V2 bot to associate with the instance.</p>
    /// - On success, responds with [`AssociateBotOutput`](crate::output::AssociateBotOutput)

    /// - On failure, responds with [`SdkError<AssociateBotError>`](crate::error::AssociateBotError)
    pub fn associate_bot(&self) -> fluent_builders::AssociateBot<C, M, R> {
        fluent_builders::AssociateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateDefaultVocabulary`](crate::client::fluent_builders::AssociateDefaultVocabulary) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateDefaultVocabulary::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateDefaultVocabulary::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`language_code(VocabularyLanguageCode)`](crate::client::fluent_builders::AssociateDefaultVocabulary::language_code) / [`set_language_code(Option<VocabularyLanguageCode>)`](crate::client::fluent_builders::AssociateDefaultVocabulary::set_language_code): <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
    ///   - [`vocabulary_id(impl Into<String>)`](crate::client::fluent_builders::AssociateDefaultVocabulary::vocabulary_id) / [`set_vocabulary_id(Option<String>)`](crate::client::fluent_builders::AssociateDefaultVocabulary::set_vocabulary_id): <p>The identifier of the custom vocabulary. If this is empty, the default is set to none.</p>
    /// - On success, responds with [`AssociateDefaultVocabularyOutput`](crate::output::AssociateDefaultVocabularyOutput)

    /// - On failure, responds with [`SdkError<AssociateDefaultVocabularyError>`](crate::error::AssociateDefaultVocabularyError)
    pub fn associate_default_vocabulary(
        &self,
    ) -> fluent_builders::AssociateDefaultVocabulary<C, M, R> {
        fluent_builders::AssociateDefaultVocabulary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateInstanceStorageConfig`](crate::client::fluent_builders::AssociateInstanceStorageConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateInstanceStorageConfig::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateInstanceStorageConfig::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`resource_type(InstanceStorageResourceType)`](crate::client::fluent_builders::AssociateInstanceStorageConfig::resource_type) / [`set_resource_type(Option<InstanceStorageResourceType>)`](crate::client::fluent_builders::AssociateInstanceStorageConfig::set_resource_type): <p>A valid resource type.</p>
    ///   - [`storage_config(InstanceStorageConfig)`](crate::client::fluent_builders::AssociateInstanceStorageConfig::storage_config) / [`set_storage_config(Option<InstanceStorageConfig>)`](crate::client::fluent_builders::AssociateInstanceStorageConfig::set_storage_config): <p>A valid storage type.</p>
    /// - On success, responds with [`AssociateInstanceStorageConfigOutput`](crate::output::AssociateInstanceStorageConfigOutput) with field(s):
    ///   - [`association_id(Option<String>)`](crate::output::AssociateInstanceStorageConfigOutput::association_id): <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    /// - On failure, responds with [`SdkError<AssociateInstanceStorageConfigError>`](crate::error::AssociateInstanceStorageConfigError)
    pub fn associate_instance_storage_config(
        &self,
    ) -> fluent_builders::AssociateInstanceStorageConfig<C, M, R> {
        fluent_builders::AssociateInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateLambdaFunction`](crate::client::fluent_builders::AssociateLambdaFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateLambdaFunction::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateLambdaFunction::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`function_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateLambdaFunction::function_arn) / [`set_function_arn(Option<String>)`](crate::client::fluent_builders::AssociateLambdaFunction::set_function_arn): <p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.</p>
    /// - On success, responds with [`AssociateLambdaFunctionOutput`](crate::output::AssociateLambdaFunctionOutput)

    /// - On failure, responds with [`SdkError<AssociateLambdaFunctionError>`](crate::error::AssociateLambdaFunctionError)
    pub fn associate_lambda_function(&self) -> fluent_builders::AssociateLambdaFunction<C, M, R> {
        fluent_builders::AssociateLambdaFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateLexBot`](crate::client::fluent_builders::AssociateLexBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateLexBot::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateLexBot::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`lex_bot(LexBot)`](crate::client::fluent_builders::AssociateLexBot::lex_bot) / [`set_lex_bot(Option<LexBot>)`](crate::client::fluent_builders::AssociateLexBot::set_lex_bot): <p>The Amazon Lex bot to associate with the instance.</p>
    /// - On success, responds with [`AssociateLexBotOutput`](crate::output::AssociateLexBotOutput)

    /// - On failure, responds with [`SdkError<AssociateLexBotError>`](crate::error::AssociateLexBotError)
    pub fn associate_lex_bot(&self) -> fluent_builders::AssociateLexBot<C, M, R> {
        fluent_builders::AssociateLexBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateQueueQuickConnects`](crate::client::fluent_builders::AssociateQueueQuickConnects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateQueueQuickConnects::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateQueueQuickConnects::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::AssociateQueueQuickConnects::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::AssociateQueueQuickConnects::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`quick_connect_ids(Vec<String>)`](crate::client::fluent_builders::AssociateQueueQuickConnects::quick_connect_ids) / [`set_quick_connect_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AssociateQueueQuickConnects::set_quick_connect_ids): <p>The quick connects to associate with this queue.</p>
    /// - On success, responds with [`AssociateQueueQuickConnectsOutput`](crate::output::AssociateQueueQuickConnectsOutput)

    /// - On failure, responds with [`SdkError<AssociateQueueQuickConnectsError>`](crate::error::AssociateQueueQuickConnectsError)
    pub fn associate_queue_quick_connects(
        &self,
    ) -> fluent_builders::AssociateQueueQuickConnects<C, M, R> {
        fluent_builders::AssociateQueueQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateRoutingProfileQueues`](crate::client::fluent_builders::AssociateRoutingProfileQueues) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateRoutingProfileQueues::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateRoutingProfileQueues::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::AssociateRoutingProfileQueues::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::AssociateRoutingProfileQueues::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    ///   - [`queue_configs(Vec<RoutingProfileQueueConfig>)`](crate::client::fluent_builders::AssociateRoutingProfileQueues::queue_configs) / [`set_queue_configs(Option<Vec<RoutingProfileQueueConfig>>)`](crate::client::fluent_builders::AssociateRoutingProfileQueues::set_queue_configs): <p>The queues to associate with this routing profile.</p>
    /// - On success, responds with [`AssociateRoutingProfileQueuesOutput`](crate::output::AssociateRoutingProfileQueuesOutput)

    /// - On failure, responds with [`SdkError<AssociateRoutingProfileQueuesError>`](crate::error::AssociateRoutingProfileQueuesError)
    pub fn associate_routing_profile_queues(
        &self,
    ) -> fluent_builders::AssociateRoutingProfileQueues<C, M, R> {
        fluent_builders::AssociateRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateSecurityKey`](crate::client::fluent_builders::AssociateSecurityKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::AssociateSecurityKey::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::AssociateSecurityKey::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`key(impl Into<String>)`](crate::client::fluent_builders::AssociateSecurityKey::key) / [`set_key(Option<String>)`](crate::client::fluent_builders::AssociateSecurityKey::set_key): <p>A valid security key in PEM format.</p>
    /// - On success, responds with [`AssociateSecurityKeyOutput`](crate::output::AssociateSecurityKeyOutput) with field(s):
    ///   - [`association_id(Option<String>)`](crate::output::AssociateSecurityKeyOutput::association_id): <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    /// - On failure, responds with [`SdkError<AssociateSecurityKeyError>`](crate::error::AssociateSecurityKeyError)
    pub fn associate_security_key(&self) -> fluent_builders::AssociateSecurityKey<C, M, R> {
        fluent_builders::AssociateSecurityKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAgentStatus`](crate::client::fluent_builders::CreateAgentStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateAgentStatus::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateAgentStatus::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateAgentStatus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateAgentStatus::set_name): <p>The name of the status.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateAgentStatus::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateAgentStatus::set_description): <p>The description of the status.</p>
    ///   - [`state(AgentStatusState)`](crate::client::fluent_builders::CreateAgentStatus::state) / [`set_state(Option<AgentStatusState>)`](crate::client::fluent_builders::CreateAgentStatus::set_state): <p>The state of the status.</p>
    ///   - [`display_order(i32)`](crate::client::fluent_builders::CreateAgentStatus::display_order) / [`set_display_order(Option<i32>)`](crate::client::fluent_builders::CreateAgentStatus::set_display_order): <p>The display order of the status.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateAgentStatus::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateAgentStatus::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateAgentStatusOutput`](crate::output::CreateAgentStatusOutput) with field(s):
    ///   - [`agent_status_arn(Option<String>)`](crate::output::CreateAgentStatusOutput::agent_status_arn): <p>The Amazon Resource Name (ARN) of the agent status.</p>
    ///   - [`agent_status_id(Option<String>)`](crate::output::CreateAgentStatusOutput::agent_status_id): <p>The identifier of the agent status.</p>
    /// - On failure, responds with [`SdkError<CreateAgentStatusError>`](crate::error::CreateAgentStatusError)
    pub fn create_agent_status(&self) -> fluent_builders::CreateAgentStatus<C, M, R> {
        fluent_builders::CreateAgentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContactFlow`](crate::client::fluent_builders::CreateContactFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlow::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateContactFlow::set_instance_id): <p>The identifier of the Amazon Connect instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateContactFlow::set_name): <p>The name of the contact flow.</p>
    ///   - [`r#type(ContactFlowType)`](crate::client::fluent_builders::CreateContactFlow::r#type) / [`set_type(Option<ContactFlowType>)`](crate::client::fluent_builders::CreateContactFlow::set_type): <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlow::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateContactFlow::set_description): <p>The description of the contact flow. </p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlow::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::CreateContactFlow::set_content): <p>The content of the contact flow. </p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateContactFlow::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateContactFlow::set_tags): <p>One or more tags.</p>
    /// - On success, responds with [`CreateContactFlowOutput`](crate::output::CreateContactFlowOutput) with field(s):
    ///   - [`contact_flow_id(Option<String>)`](crate::output::CreateContactFlowOutput::contact_flow_id): <p>The identifier of the contact flow.</p>
    ///   - [`contact_flow_arn(Option<String>)`](crate::output::CreateContactFlowOutput::contact_flow_arn): <p>The Amazon Resource Name (ARN) of the contact flow.</p>
    /// - On failure, responds with [`SdkError<CreateContactFlowError>`](crate::error::CreateContactFlowError)
    pub fn create_contact_flow(&self) -> fluent_builders::CreateContactFlow<C, M, R> {
        fluent_builders::CreateContactFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateContactFlowModule`](crate::client::fluent_builders::CreateContactFlowModule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlowModule::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateContactFlowModule::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlowModule::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateContactFlowModule::set_name): <p>The name of the contact flow module.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlowModule::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateContactFlowModule::set_description): <p>The description of the contact flow module. </p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlowModule::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::CreateContactFlowModule::set_content): <p>The content of the contact flow module.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateContactFlowModule::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateContactFlowModule::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateContactFlowModule::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateContactFlowModule::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`CreateContactFlowModuleOutput`](crate::output::CreateContactFlowModuleOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateContactFlowModuleOutput::id): <p>The identifier of the contact flow module.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateContactFlowModuleOutput::arn): <p>The Amazon Resource Name (ARN) of the contact flow module.</p>
    /// - On failure, responds with [`SdkError<CreateContactFlowModuleError>`](crate::error::CreateContactFlowModuleError)
    pub fn create_contact_flow_module(&self) -> fluent_builders::CreateContactFlowModule<C, M, R> {
        fluent_builders::CreateContactFlowModule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHoursOfOperation`](crate::client::fluent_builders::CreateHoursOfOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::set_name): <p>The name of the hours of operation.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::set_description): <p>The description of the hours of operation.</p>
    ///   - [`time_zone(impl Into<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::time_zone) / [`set_time_zone(Option<String>)`](crate::client::fluent_builders::CreateHoursOfOperation::set_time_zone): <p>The time zone of the hours of operation.</p>
    ///   - [`config(Vec<HoursOfOperationConfig>)`](crate::client::fluent_builders::CreateHoursOfOperation::config) / [`set_config(Option<Vec<HoursOfOperationConfig>>)`](crate::client::fluent_builders::CreateHoursOfOperation::set_config): <p>Configuration information for the hours of operation: day, start time, and end time.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateHoursOfOperation::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateHoursOfOperation::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateHoursOfOperationOutput`](crate::output::CreateHoursOfOperationOutput) with field(s):
    ///   - [`hours_of_operation_id(Option<String>)`](crate::output::CreateHoursOfOperationOutput::hours_of_operation_id): <p>The identifier for the hours of operation.</p>
    ///   - [`hours_of_operation_arn(Option<String>)`](crate::output::CreateHoursOfOperationOutput::hours_of_operation_arn): <p>The Amazon Resource Name (ARN) for the hours of operation.</p>
    /// - On failure, responds with [`SdkError<CreateHoursOfOperationError>`](crate::error::CreateHoursOfOperationError)
    pub fn create_hours_of_operation(&self) -> fluent_builders::CreateHoursOfOperation<C, M, R> {
        fluent_builders::CreateHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInstance`](crate::client::fluent_builders::CreateInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateInstance::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateInstance::set_client_token): <p>The idempotency token.</p>
    ///   - [`identity_management_type(DirectoryType)`](crate::client::fluent_builders::CreateInstance::identity_management_type) / [`set_identity_management_type(Option<DirectoryType>)`](crate::client::fluent_builders::CreateInstance::set_identity_management_type): <p>The type of identity management for your Amazon Connect users.</p>
    ///   - [`instance_alias(impl Into<String>)`](crate::client::fluent_builders::CreateInstance::instance_alias) / [`set_instance_alias(Option<String>)`](crate::client::fluent_builders::CreateInstance::set_instance_alias): <p>The name for your instance.</p>
    ///   - [`directory_id(impl Into<String>)`](crate::client::fluent_builders::CreateInstance::directory_id) / [`set_directory_id(Option<String>)`](crate::client::fluent_builders::CreateInstance::set_directory_id): <p>The identifier for the directory.</p>
    ///   - [`inbound_calls_enabled(bool)`](crate::client::fluent_builders::CreateInstance::inbound_calls_enabled) / [`set_inbound_calls_enabled(Option<bool>)`](crate::client::fluent_builders::CreateInstance::set_inbound_calls_enabled): <p>Your contact center handles incoming contacts.</p>
    ///   - [`outbound_calls_enabled(bool)`](crate::client::fluent_builders::CreateInstance::outbound_calls_enabled) / [`set_outbound_calls_enabled(Option<bool>)`](crate::client::fluent_builders::CreateInstance::set_outbound_calls_enabled): <p>Your contact center allows outbound calls.</p>
    /// - On success, responds with [`CreateInstanceOutput`](crate::output::CreateInstanceOutput) with field(s):
    ///   - [`id(Option<String>)`](crate::output::CreateInstanceOutput::id): <p>The identifier for the instance.</p>
    ///   - [`arn(Option<String>)`](crate::output::CreateInstanceOutput::arn): <p>The Amazon Resource Name (ARN) of the instance.</p>
    /// - On failure, responds with [`SdkError<CreateInstanceError>`](crate::error::CreateInstanceError)
    pub fn create_instance(&self) -> fluent_builders::CreateInstance<C, M, R> {
        fluent_builders::CreateInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateIntegrationAssociation`](crate::client::fluent_builders::CreateIntegrationAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`integration_type(IntegrationType)`](crate::client::fluent_builders::CreateIntegrationAssociation::integration_type) / [`set_integration_type(Option<IntegrationType>)`](crate::client::fluent_builders::CreateIntegrationAssociation::set_integration_type): <p>The type of information to be ingested.</p>
    ///   - [`integration_arn(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::integration_arn) / [`set_integration_arn(Option<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::set_integration_arn): <p>The Amazon Resource Name (ARN) of the integration.</p>
    ///   - [`source_application_url(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::source_application_url) / [`set_source_application_url(Option<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::set_source_application_url): <p>The URL for the external application. This field is only required for the EVENT integration type.</p>
    ///   - [`source_application_name(impl Into<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::source_application_name) / [`set_source_application_name(Option<String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::set_source_application_name): <p>The name of the external application. This field is only required for the EVENT integration type.</p>
    ///   - [`source_type(SourceType)`](crate::client::fluent_builders::CreateIntegrationAssociation::source_type) / [`set_source_type(Option<SourceType>)`](crate::client::fluent_builders::CreateIntegrationAssociation::set_source_type): <p>The type of the data source. This field is only required for the EVENT integration type.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateIntegrationAssociation::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateIntegrationAssociation::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateIntegrationAssociationOutput`](crate::output::CreateIntegrationAssociationOutput) with field(s):
    ///   - [`integration_association_id(Option<String>)`](crate::output::CreateIntegrationAssociationOutput::integration_association_id): <p>The identifier for the integration association.</p>
    ///   - [`integration_association_arn(Option<String>)`](crate::output::CreateIntegrationAssociationOutput::integration_association_arn): <p>The Amazon Resource Name (ARN) for the association.</p>
    /// - On failure, responds with [`SdkError<CreateIntegrationAssociationError>`](crate::error::CreateIntegrationAssociationError)
    pub fn create_integration_association(
        &self,
    ) -> fluent_builders::CreateIntegrationAssociation<C, M, R> {
        fluent_builders::CreateIntegrationAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateQueue`](crate::client::fluent_builders::CreateQueue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateQueue::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateQueue::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateQueue::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateQueue::set_name): <p>The name of the queue.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateQueue::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateQueue::set_description): <p>The description of the queue.</p>
    ///   - [`outbound_caller_config(OutboundCallerConfig)`](crate::client::fluent_builders::CreateQueue::outbound_caller_config) / [`set_outbound_caller_config(Option<OutboundCallerConfig>)`](crate::client::fluent_builders::CreateQueue::set_outbound_caller_config): <p>The outbound caller ID name, number, and outbound whisper flow.</p>
    ///   - [`hours_of_operation_id(impl Into<String>)`](crate::client::fluent_builders::CreateQueue::hours_of_operation_id) / [`set_hours_of_operation_id(Option<String>)`](crate::client::fluent_builders::CreateQueue::set_hours_of_operation_id): <p>The identifier for the hours of operation.</p>
    ///   - [`max_contacts(i32)`](crate::client::fluent_builders::CreateQueue::max_contacts) / [`set_max_contacts(Option<i32>)`](crate::client::fluent_builders::CreateQueue::set_max_contacts): <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
    ///   - [`quick_connect_ids(Vec<String>)`](crate::client::fluent_builders::CreateQueue::quick_connect_ids) / [`set_quick_connect_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateQueue::set_quick_connect_ids): <p>The quick connects available to agents who are working the queue.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateQueue::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateQueue::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateQueueOutput`](crate::output::CreateQueueOutput) with field(s):
    ///   - [`queue_arn(Option<String>)`](crate::output::CreateQueueOutput::queue_arn): <p>The Amazon Resource Name (ARN) of the queue.</p>
    ///   - [`queue_id(Option<String>)`](crate::output::CreateQueueOutput::queue_id): <p>The identifier for the queue.</p>
    /// - On failure, responds with [`SdkError<CreateQueueError>`](crate::error::CreateQueueError)
    pub fn create_queue(&self) -> fluent_builders::CreateQueue<C, M, R> {
        fluent_builders::CreateQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateQuickConnect`](crate::client::fluent_builders::CreateQuickConnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateQuickConnect::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateQuickConnect::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateQuickConnect::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateQuickConnect::set_name): <p>The name of the quick connect.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateQuickConnect::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateQuickConnect::set_description): <p>The description of the quick connect.</p>
    ///   - [`quick_connect_config(QuickConnectConfig)`](crate::client::fluent_builders::CreateQuickConnect::quick_connect_config) / [`set_quick_connect_config(Option<QuickConnectConfig>)`](crate::client::fluent_builders::CreateQuickConnect::set_quick_connect_config): <p>Configuration settings for the quick connect.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateQuickConnect::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateQuickConnect::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateQuickConnectOutput`](crate::output::CreateQuickConnectOutput) with field(s):
    ///   - [`quick_connect_arn(Option<String>)`](crate::output::CreateQuickConnectOutput::quick_connect_arn): <p>The Amazon Resource Name (ARN) for the quick connect. </p>
    ///   - [`quick_connect_id(Option<String>)`](crate::output::CreateQuickConnectOutput::quick_connect_id): <p>The identifier for the quick connect. </p>
    /// - On failure, responds with [`SdkError<CreateQuickConnectError>`](crate::error::CreateQuickConnectError)
    pub fn create_quick_connect(&self) -> fluent_builders::CreateQuickConnect<C, M, R> {
        fluent_builders::CreateQuickConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRoutingProfile`](crate::client::fluent_builders::CreateRoutingProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoutingProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateRoutingProfile::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateRoutingProfile::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateRoutingProfile::set_name): <p>The name of the routing profile. Must not be more than 127 characters.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateRoutingProfile::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateRoutingProfile::set_description): <p>Description of the routing profile. Must not be more than 250 characters.</p>
    ///   - [`default_outbound_queue_id(impl Into<String>)`](crate::client::fluent_builders::CreateRoutingProfile::default_outbound_queue_id) / [`set_default_outbound_queue_id(Option<String>)`](crate::client::fluent_builders::CreateRoutingProfile::set_default_outbound_queue_id): <p>The default outbound queue for the routing profile.</p>
    ///   - [`queue_configs(Vec<RoutingProfileQueueConfig>)`](crate::client::fluent_builders::CreateRoutingProfile::queue_configs) / [`set_queue_configs(Option<Vec<RoutingProfileQueueConfig>>)`](crate::client::fluent_builders::CreateRoutingProfile::set_queue_configs): <p>The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.</p>
    ///   - [`media_concurrencies(Vec<MediaConcurrency>)`](crate::client::fluent_builders::CreateRoutingProfile::media_concurrencies) / [`set_media_concurrencies(Option<Vec<MediaConcurrency>>)`](crate::client::fluent_builders::CreateRoutingProfile::set_media_concurrencies): <p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateRoutingProfile::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateRoutingProfile::set_tags): <p>One or more tags.</p>
    /// - On success, responds with [`CreateRoutingProfileOutput`](crate::output::CreateRoutingProfileOutput) with field(s):
    ///   - [`routing_profile_arn(Option<String>)`](crate::output::CreateRoutingProfileOutput::routing_profile_arn): <p>The Amazon Resource Name (ARN) of the routing profile.</p>
    ///   - [`routing_profile_id(Option<String>)`](crate::output::CreateRoutingProfileOutput::routing_profile_id): <p>The identifier of the routing profile.</p>
    /// - On failure, responds with [`SdkError<CreateRoutingProfileError>`](crate::error::CreateRoutingProfileError)
    pub fn create_routing_profile(&self) -> fluent_builders::CreateRoutingProfile<C, M, R> {
        fluent_builders::CreateRoutingProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSecurityProfile`](crate::client::fluent_builders::CreateSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_name(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityProfile::security_profile_name) / [`set_security_profile_name(Option<String>)`](crate::client::fluent_builders::CreateSecurityProfile::set_security_profile_name): <p>The name of the security profile.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityProfile::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateSecurityProfile::set_description): <p>The description of the security profile.</p>
    ///   - [`permissions(Vec<String>)`](crate::client::fluent_builders::CreateSecurityProfile::permissions) / [`set_permissions(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSecurityProfile::set_permissions): <p>Permissions assigned to the security profile.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateSecurityProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateSecurityProfile::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateSecurityProfile::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateSecurityProfile::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateSecurityProfileOutput`](crate::output::CreateSecurityProfileOutput) with field(s):
    ///   - [`security_profile_id(Option<String>)`](crate::output::CreateSecurityProfileOutput::security_profile_id): <p>The identifier for the security profle.</p>
    ///   - [`security_profile_arn(Option<String>)`](crate::output::CreateSecurityProfileOutput::security_profile_arn): <p>The Amazon Resource Name (ARN) for the security profile.</p>
    /// - On failure, responds with [`SdkError<CreateSecurityProfileError>`](crate::error::CreateSecurityProfileError)
    pub fn create_security_profile(&self) -> fluent_builders::CreateSecurityProfile<C, M, R> {
        fluent_builders::CreateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUseCase`](crate::client::fluent_builders::CreateUseCase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateUseCase::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateUseCase::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`integration_association_id(impl Into<String>)`](crate::client::fluent_builders::CreateUseCase::integration_association_id) / [`set_integration_association_id(Option<String>)`](crate::client::fluent_builders::CreateUseCase::set_integration_association_id): <p>The identifier for the integration association.</p>
    ///   - [`use_case_type(UseCaseType)`](crate::client::fluent_builders::CreateUseCase::use_case_type) / [`set_use_case_type(Option<UseCaseType>)`](crate::client::fluent_builders::CreateUseCase::set_use_case_type): <p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateUseCase::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateUseCase::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateUseCaseOutput`](crate::output::CreateUseCaseOutput) with field(s):
    ///   - [`use_case_id(Option<String>)`](crate::output::CreateUseCaseOutput::use_case_id): <p>The identifier of the use case.</p>
    ///   - [`use_case_arn(Option<String>)`](crate::output::CreateUseCaseOutput::use_case_arn): <p>The Amazon Resource Name (ARN) for the use case.</p>
    /// - On failure, responds with [`SdkError<CreateUseCaseError>`](crate::error::CreateUseCaseError)
    pub fn create_use_case(&self) -> fluent_builders::CreateUseCase<C, M, R> {
        fluent_builders::CreateUseCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUser`](crate::client::fluent_builders::CreateUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`username(impl Into<String>)`](crate::client::fluent_builders::CreateUser::username) / [`set_username(Option<String>)`](crate::client::fluent_builders::CreateUser::set_username): <p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.</p>
    ///   - [`password(impl Into<String>)`](crate::client::fluent_builders::CreateUser::password) / [`set_password(Option<String>)`](crate::client::fluent_builders::CreateUser::set_password): <p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>
    ///   - [`identity_info(UserIdentityInfo)`](crate::client::fluent_builders::CreateUser::identity_info) / [`set_identity_info(Option<UserIdentityInfo>)`](crate::client::fluent_builders::CreateUser::set_identity_info): <p>The information about the identity of the user.</p>
    ///   - [`phone_config(UserPhoneConfig)`](crate::client::fluent_builders::CreateUser::phone_config) / [`set_phone_config(Option<UserPhoneConfig>)`](crate::client::fluent_builders::CreateUser::set_phone_config): <p>The phone settings for the user.</p>
    ///   - [`directory_user_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::directory_user_id) / [`set_directory_user_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_directory_user_id): <p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p>  <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>
    ///   - [`security_profile_ids(Vec<String>)`](crate::client::fluent_builders::CreateUser::security_profile_ids) / [`set_security_profile_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateUser::set_security_profile_ids): <p>The identifier of the security profile for the user.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_routing_profile_id): <p>The identifier of the routing profile for the user.</p>
    ///   - [`hierarchy_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::hierarchy_group_id) / [`set_hierarchy_group_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_hierarchy_group_id): <p>The identifier of the hierarchy group for the user.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateUser::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateUser::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateUser::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateUser::set_tags): <p>One or more tags.</p>
    /// - On success, responds with [`CreateUserOutput`](crate::output::CreateUserOutput) with field(s):
    ///   - [`user_id(Option<String>)`](crate::output::CreateUserOutput::user_id): <p>The identifier of the user account.</p>
    ///   - [`user_arn(Option<String>)`](crate::output::CreateUserOutput::user_arn): <p>The Amazon Resource Name (ARN) of the user account.</p>
    /// - On failure, responds with [`SdkError<CreateUserError>`](crate::error::CreateUserError)
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUserHierarchyGroup`](crate::client::fluent_builders::CreateUserHierarchyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::set_name): <p>The name of the user hierarchy group. Must not be more than 100 characters.</p>
    ///   - [`parent_group_id(impl Into<String>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::parent_group_id) / [`set_parent_group_id(Option<String>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::set_parent_group_id): <p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateUserHierarchyGroup::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateUserHierarchyGroupOutput`](crate::output::CreateUserHierarchyGroupOutput) with field(s):
    ///   - [`hierarchy_group_id(Option<String>)`](crate::output::CreateUserHierarchyGroupOutput::hierarchy_group_id): <p>The identifier of the hierarchy group.</p>
    ///   - [`hierarchy_group_arn(Option<String>)`](crate::output::CreateUserHierarchyGroupOutput::hierarchy_group_arn): <p>The Amazon Resource Name (ARN) of the hierarchy group. </p>
    /// - On failure, responds with [`SdkError<CreateUserHierarchyGroupError>`](crate::error::CreateUserHierarchyGroupError)
    pub fn create_user_hierarchy_group(
        &self,
    ) -> fluent_builders::CreateUserHierarchyGroup<C, M, R> {
        fluent_builders::CreateUserHierarchyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateVocabulary`](crate::client::fluent_builders::CreateVocabulary) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateVocabulary::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateVocabulary::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If a create request is received more than once with same client token, subsequent requests return the previous response without creating a vocabulary again.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::CreateVocabulary::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::CreateVocabulary::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`vocabulary_name(impl Into<String>)`](crate::client::fluent_builders::CreateVocabulary::vocabulary_name) / [`set_vocabulary_name(Option<String>)`](crate::client::fluent_builders::CreateVocabulary::set_vocabulary_name): <p>A unique name of the custom vocabulary.</p>
    ///   - [`language_code(VocabularyLanguageCode)`](crate::client::fluent_builders::CreateVocabulary::language_code) / [`set_language_code(Option<VocabularyLanguageCode>)`](crate::client::fluent_builders::CreateVocabulary::set_language_code): <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::CreateVocabulary::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::CreateVocabulary::set_content): <p>The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with <code>Phrase</code>, <code>IPA</code>, <code>SoundsLike</code>, and <code>DisplayAs</code> fields. Separate the fields with TAB characters. The size limit is 50KB. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table">Create a custom vocabulary using a table</a>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateVocabulary::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateVocabulary::set_tags): <p>The tags used to organize, track, or control access for this resource.</p>
    /// - On success, responds with [`CreateVocabularyOutput`](crate::output::CreateVocabularyOutput) with field(s):
    ///   - [`vocabulary_arn(Option<String>)`](crate::output::CreateVocabularyOutput::vocabulary_arn): <p>The Amazon Resource Name (ARN) of the custom vocabulary.</p>
    ///   - [`vocabulary_id(Option<String>)`](crate::output::CreateVocabularyOutput::vocabulary_id): <p>The identifier of the custom vocabulary.</p>
    ///   - [`state(Option<VocabularyState>)`](crate::output::CreateVocabularyOutput::state): <p>The current state of the custom vocabulary.</p>
    /// - On failure, responds with [`SdkError<CreateVocabularyError>`](crate::error::CreateVocabularyError)
    pub fn create_vocabulary(&self) -> fluent_builders::CreateVocabulary<C, M, R> {
        fluent_builders::CreateVocabulary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContactFlow`](crate::client::fluent_builders::DeleteContactFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContactFlow::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteContactFlow::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContactFlow::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::DeleteContactFlow::set_contact_flow_id): <p>The identifier of the contact flow.</p>
    /// - On success, responds with [`DeleteContactFlowOutput`](crate::output::DeleteContactFlowOutput)

    /// - On failure, responds with [`SdkError<DeleteContactFlowError>`](crate::error::DeleteContactFlowError)
    pub fn delete_contact_flow(&self) -> fluent_builders::DeleteContactFlow<C, M, R> {
        fluent_builders::DeleteContactFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteContactFlowModule`](crate::client::fluent_builders::DeleteContactFlowModule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContactFlowModule::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteContactFlowModule::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_module_id(impl Into<String>)`](crate::client::fluent_builders::DeleteContactFlowModule::contact_flow_module_id) / [`set_contact_flow_module_id(Option<String>)`](crate::client::fluent_builders::DeleteContactFlowModule::set_contact_flow_module_id): <p>The identifier of the contact flow module.</p>
    /// - On success, responds with [`DeleteContactFlowModuleOutput`](crate::output::DeleteContactFlowModuleOutput)

    /// - On failure, responds with [`SdkError<DeleteContactFlowModuleError>`](crate::error::DeleteContactFlowModuleError)
    pub fn delete_contact_flow_module(&self) -> fluent_builders::DeleteContactFlowModule<C, M, R> {
        fluent_builders::DeleteContactFlowModule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHoursOfOperation`](crate::client::fluent_builders::DeleteHoursOfOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHoursOfOperation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteHoursOfOperation::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`hours_of_operation_id(impl Into<String>)`](crate::client::fluent_builders::DeleteHoursOfOperation::hours_of_operation_id) / [`set_hours_of_operation_id(Option<String>)`](crate::client::fluent_builders::DeleteHoursOfOperation::set_hours_of_operation_id): <p>The identifier for the hours of operation.</p>
    /// - On success, responds with [`DeleteHoursOfOperationOutput`](crate::output::DeleteHoursOfOperationOutput)

    /// - On failure, responds with [`SdkError<DeleteHoursOfOperationError>`](crate::error::DeleteHoursOfOperationError)
    pub fn delete_hours_of_operation(&self) -> fluent_builders::DeleteHoursOfOperation<C, M, R> {
        fluent_builders::DeleteHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInstance`](crate::client::fluent_builders::DeleteInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteInstance::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`DeleteInstanceOutput`](crate::output::DeleteInstanceOutput)

    /// - On failure, responds with [`SdkError<DeleteInstanceError>`](crate::error::DeleteInstanceError)
    pub fn delete_instance(&self) -> fluent_builders::DeleteInstance<C, M, R> {
        fluent_builders::DeleteInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteIntegrationAssociation`](crate::client::fluent_builders::DeleteIntegrationAssociation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationAssociation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationAssociation::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`integration_association_id(impl Into<String>)`](crate::client::fluent_builders::DeleteIntegrationAssociation::integration_association_id) / [`set_integration_association_id(Option<String>)`](crate::client::fluent_builders::DeleteIntegrationAssociation::set_integration_association_id): <p>The identifier for the integration association.</p>
    /// - On success, responds with [`DeleteIntegrationAssociationOutput`](crate::output::DeleteIntegrationAssociationOutput)

    /// - On failure, responds with [`SdkError<DeleteIntegrationAssociationError>`](crate::error::DeleteIntegrationAssociationError)
    pub fn delete_integration_association(
        &self,
    ) -> fluent_builders::DeleteIntegrationAssociation<C, M, R> {
        fluent_builders::DeleteIntegrationAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteQuickConnect`](crate::client::fluent_builders::DeleteQuickConnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteQuickConnect::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteQuickConnect::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`quick_connect_id(impl Into<String>)`](crate::client::fluent_builders::DeleteQuickConnect::quick_connect_id) / [`set_quick_connect_id(Option<String>)`](crate::client::fluent_builders::DeleteQuickConnect::set_quick_connect_id): <p>The identifier for the quick connect.</p>
    /// - On success, responds with [`DeleteQuickConnectOutput`](crate::output::DeleteQuickConnectOutput)

    /// - On failure, responds with [`SdkError<DeleteQuickConnectError>`](crate::error::DeleteQuickConnectError)
    pub fn delete_quick_connect(&self) -> fluent_builders::DeleteQuickConnect<C, M, R> {
        fluent_builders::DeleteQuickConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSecurityProfile`](crate::client::fluent_builders::DeleteSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSecurityProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteSecurityProfile::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`security_profile_id(impl Into<String>)`](crate::client::fluent_builders::DeleteSecurityProfile::security_profile_id) / [`set_security_profile_id(Option<String>)`](crate::client::fluent_builders::DeleteSecurityProfile::set_security_profile_id): <p>The identifier for the security profle.</p>
    /// - On success, responds with [`DeleteSecurityProfileOutput`](crate::output::DeleteSecurityProfileOutput)

    /// - On failure, responds with [`SdkError<DeleteSecurityProfileError>`](crate::error::DeleteSecurityProfileError)
    pub fn delete_security_profile(&self) -> fluent_builders::DeleteSecurityProfile<C, M, R> {
        fluent_builders::DeleteSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUseCase`](crate::client::fluent_builders::DeleteUseCase) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUseCase::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteUseCase::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`integration_association_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUseCase::integration_association_id) / [`set_integration_association_id(Option<String>)`](crate::client::fluent_builders::DeleteUseCase::set_integration_association_id): <p>The identifier for the integration association.</p>
    ///   - [`use_case_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUseCase::use_case_id) / [`set_use_case_id(Option<String>)`](crate::client::fluent_builders::DeleteUseCase::set_use_case_id): <p>The identifier for the use case.</p>
    /// - On success, responds with [`DeleteUseCaseOutput`](crate::output::DeleteUseCaseOutput)

    /// - On failure, responds with [`SdkError<DeleteUseCaseError>`](crate::error::DeleteUseCaseError)
    pub fn delete_use_case(&self) -> fluent_builders::DeleteUseCase<C, M, R> {
        fluent_builders::DeleteUseCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUser`](crate::client::fluent_builders::DeleteUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DeleteUser::set_user_id): <p>The identifier of the user.</p>
    /// - On success, responds with [`DeleteUserOutput`](crate::output::DeleteUserOutput)

    /// - On failure, responds with [`SdkError<DeleteUserError>`](crate::error::DeleteUserError)
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUserHierarchyGroup`](crate::client::fluent_builders::DeleteUserHierarchyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hierarchy_group_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserHierarchyGroup::hierarchy_group_id) / [`set_hierarchy_group_id(Option<String>)`](crate::client::fluent_builders::DeleteUserHierarchyGroup::set_hierarchy_group_id): <p>The identifier of the hierarchy group.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUserHierarchyGroup::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteUserHierarchyGroup::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`DeleteUserHierarchyGroupOutput`](crate::output::DeleteUserHierarchyGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteUserHierarchyGroupError>`](crate::error::DeleteUserHierarchyGroupError)
    pub fn delete_user_hierarchy_group(
        &self,
    ) -> fluent_builders::DeleteUserHierarchyGroup<C, M, R> {
        fluent_builders::DeleteUserHierarchyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteVocabulary`](crate::client::fluent_builders::DeleteVocabulary) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVocabulary::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DeleteVocabulary::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`vocabulary_id(impl Into<String>)`](crate::client::fluent_builders::DeleteVocabulary::vocabulary_id) / [`set_vocabulary_id(Option<String>)`](crate::client::fluent_builders::DeleteVocabulary::set_vocabulary_id): <p>The identifier of the custom vocabulary.</p>
    /// - On success, responds with [`DeleteVocabularyOutput`](crate::output::DeleteVocabularyOutput) with field(s):
    ///   - [`vocabulary_arn(Option<String>)`](crate::output::DeleteVocabularyOutput::vocabulary_arn): <p>The Amazon Resource Name (ARN) of the custom vocabulary.</p>
    ///   - [`vocabulary_id(Option<String>)`](crate::output::DeleteVocabularyOutput::vocabulary_id): <p>The identifier of the custom vocabulary.</p>
    ///   - [`state(Option<VocabularyState>)`](crate::output::DeleteVocabularyOutput::state): <p>The current state of the custom vocabulary.</p>
    /// - On failure, responds with [`SdkError<DeleteVocabularyError>`](crate::error::DeleteVocabularyError)
    pub fn delete_vocabulary(&self) -> fluent_builders::DeleteVocabulary<C, M, R> {
        fluent_builders::DeleteVocabulary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAgentStatus`](crate::client::fluent_builders::DescribeAgentStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAgentStatus::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeAgentStatus::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`agent_status_id(impl Into<String>)`](crate::client::fluent_builders::DescribeAgentStatus::agent_status_id) / [`set_agent_status_id(Option<String>)`](crate::client::fluent_builders::DescribeAgentStatus::set_agent_status_id): <p>The identifier for the agent status.</p>
    /// - On success, responds with [`DescribeAgentStatusOutput`](crate::output::DescribeAgentStatusOutput) with field(s):
    ///   - [`agent_status(Option<AgentStatus>)`](crate::output::DescribeAgentStatusOutput::agent_status): <p>The agent status.</p>
    /// - On failure, responds with [`SdkError<DescribeAgentStatusError>`](crate::error::DescribeAgentStatusError)
    pub fn describe_agent_status(&self) -> fluent_builders::DescribeAgentStatus<C, M, R> {
        fluent_builders::DescribeAgentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContact`](crate::client::fluent_builders::DescribeContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeContact::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeContact::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::DescribeContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::DescribeContact::set_contact_id): <p>The identifier of the contact.</p>
    /// - On success, responds with [`DescribeContactOutput`](crate::output::DescribeContactOutput) with field(s):
    ///   - [`contact(Option<Contact>)`](crate::output::DescribeContactOutput::contact): <p>Information about the contact.</p>
    /// - On failure, responds with [`SdkError<DescribeContactError>`](crate::error::DescribeContactError)
    pub fn describe_contact(&self) -> fluent_builders::DescribeContact<C, M, R> {
        fluent_builders::DescribeContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContactFlow`](crate::client::fluent_builders::DescribeContactFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeContactFlow::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeContactFlow::set_instance_id): <p>The identifier of the Amazon Connect instance.</p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::DescribeContactFlow::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::DescribeContactFlow::set_contact_flow_id): <p>The identifier of the contact flow.</p>
    /// - On success, responds with [`DescribeContactFlowOutput`](crate::output::DescribeContactFlowOutput) with field(s):
    ///   - [`contact_flow(Option<ContactFlow>)`](crate::output::DescribeContactFlowOutput::contact_flow): <p>Information about the contact flow.</p>
    /// - On failure, responds with [`SdkError<DescribeContactFlowError>`](crate::error::DescribeContactFlowError)
    pub fn describe_contact_flow(&self) -> fluent_builders::DescribeContactFlow<C, M, R> {
        fluent_builders::DescribeContactFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeContactFlowModule`](crate::client::fluent_builders::DescribeContactFlowModule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeContactFlowModule::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeContactFlowModule::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_module_id(impl Into<String>)`](crate::client::fluent_builders::DescribeContactFlowModule::contact_flow_module_id) / [`set_contact_flow_module_id(Option<String>)`](crate::client::fluent_builders::DescribeContactFlowModule::set_contact_flow_module_id): <p>The identifier of the contact flow module.</p>
    /// - On success, responds with [`DescribeContactFlowModuleOutput`](crate::output::DescribeContactFlowModuleOutput) with field(s):
    ///   - [`contact_flow_module(Option<ContactFlowModule>)`](crate::output::DescribeContactFlowModuleOutput::contact_flow_module): <p>Information about the contact flow module.</p>
    /// - On failure, responds with [`SdkError<DescribeContactFlowModuleError>`](crate::error::DescribeContactFlowModuleError)
    pub fn describe_contact_flow_module(
        &self,
    ) -> fluent_builders::DescribeContactFlowModule<C, M, R> {
        fluent_builders::DescribeContactFlowModule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHoursOfOperation`](crate::client::fluent_builders::DescribeHoursOfOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeHoursOfOperation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeHoursOfOperation::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`hours_of_operation_id(impl Into<String>)`](crate::client::fluent_builders::DescribeHoursOfOperation::hours_of_operation_id) / [`set_hours_of_operation_id(Option<String>)`](crate::client::fluent_builders::DescribeHoursOfOperation::set_hours_of_operation_id): <p>The identifier for the hours of operation.</p>
    /// - On success, responds with [`DescribeHoursOfOperationOutput`](crate::output::DescribeHoursOfOperationOutput) with field(s):
    ///   - [`hours_of_operation(Option<HoursOfOperation>)`](crate::output::DescribeHoursOfOperationOutput::hours_of_operation): <p>The hours of operation.</p>
    /// - On failure, responds with [`SdkError<DescribeHoursOfOperationError>`](crate::error::DescribeHoursOfOperationError)
    pub fn describe_hours_of_operation(
        &self,
    ) -> fluent_builders::DescribeHoursOfOperation<C, M, R> {
        fluent_builders::DescribeHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstance`](crate::client::fluent_builders::DescribeInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstance::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeInstance::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`DescribeInstanceOutput`](crate::output::DescribeInstanceOutput) with field(s):
    ///   - [`instance(Option<Instance>)`](crate::output::DescribeInstanceOutput::instance): <p>The name of the instance.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceError>`](crate::error::DescribeInstanceError)
    pub fn describe_instance(&self) -> fluent_builders::DescribeInstance<C, M, R> {
        fluent_builders::DescribeInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceAttribute`](crate::client::fluent_builders::DescribeInstanceAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceAttribute::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeInstanceAttribute::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`attribute_type(InstanceAttributeType)`](crate::client::fluent_builders::DescribeInstanceAttribute::attribute_type) / [`set_attribute_type(Option<InstanceAttributeType>)`](crate::client::fluent_builders::DescribeInstanceAttribute::set_attribute_type): <p>The type of attribute.</p>
    /// - On success, responds with [`DescribeInstanceAttributeOutput`](crate::output::DescribeInstanceAttributeOutput) with field(s):
    ///   - [`attribute(Option<Attribute>)`](crate::output::DescribeInstanceAttributeOutput::attribute): <p>The type of attribute.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceAttributeError>`](crate::error::DescribeInstanceAttributeError)
    pub fn describe_instance_attribute(
        &self,
    ) -> fluent_builders::DescribeInstanceAttribute<C, M, R> {
        fluent_builders::DescribeInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeInstanceStorageConfig`](crate::client::fluent_builders::DescribeInstanceStorageConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceStorageConfig::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeInstanceStorageConfig::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DescribeInstanceStorageConfig::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DescribeInstanceStorageConfig::set_association_id): <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    ///   - [`resource_type(InstanceStorageResourceType)`](crate::client::fluent_builders::DescribeInstanceStorageConfig::resource_type) / [`set_resource_type(Option<InstanceStorageResourceType>)`](crate::client::fluent_builders::DescribeInstanceStorageConfig::set_resource_type): <p>A valid resource type.</p>
    /// - On success, responds with [`DescribeInstanceStorageConfigOutput`](crate::output::DescribeInstanceStorageConfigOutput) with field(s):
    ///   - [`storage_config(Option<InstanceStorageConfig>)`](crate::output::DescribeInstanceStorageConfigOutput::storage_config): <p>A valid storage type.</p>
    /// - On failure, responds with [`SdkError<DescribeInstanceStorageConfigError>`](crate::error::DescribeInstanceStorageConfigError)
    pub fn describe_instance_storage_config(
        &self,
    ) -> fluent_builders::DescribeInstanceStorageConfig<C, M, R> {
        fluent_builders::DescribeInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeQueue`](crate::client::fluent_builders::DescribeQueue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeQueue::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeQueue::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::DescribeQueue::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::DescribeQueue::set_queue_id): <p>The identifier for the queue.</p>
    /// - On success, responds with [`DescribeQueueOutput`](crate::output::DescribeQueueOutput) with field(s):
    ///   - [`queue(Option<Queue>)`](crate::output::DescribeQueueOutput::queue): <p>The name of the queue.</p>
    /// - On failure, responds with [`SdkError<DescribeQueueError>`](crate::error::DescribeQueueError)
    pub fn describe_queue(&self) -> fluent_builders::DescribeQueue<C, M, R> {
        fluent_builders::DescribeQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeQuickConnect`](crate::client::fluent_builders::DescribeQuickConnect) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeQuickConnect::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeQuickConnect::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`quick_connect_id(impl Into<String>)`](crate::client::fluent_builders::DescribeQuickConnect::quick_connect_id) / [`set_quick_connect_id(Option<String>)`](crate::client::fluent_builders::DescribeQuickConnect::set_quick_connect_id): <p>The identifier for the quick connect.</p>
    /// - On success, responds with [`DescribeQuickConnectOutput`](crate::output::DescribeQuickConnectOutput) with field(s):
    ///   - [`quick_connect(Option<QuickConnect>)`](crate::output::DescribeQuickConnectOutput::quick_connect): <p>Information about the quick connect.</p>
    /// - On failure, responds with [`SdkError<DescribeQuickConnectError>`](crate::error::DescribeQuickConnectError)
    pub fn describe_quick_connect(&self) -> fluent_builders::DescribeQuickConnect<C, M, R> {
        fluent_builders::DescribeQuickConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeRoutingProfile`](crate::client::fluent_builders::DescribeRoutingProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRoutingProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeRoutingProfile::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::DescribeRoutingProfile::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::DescribeRoutingProfile::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    /// - On success, responds with [`DescribeRoutingProfileOutput`](crate::output::DescribeRoutingProfileOutput) with field(s):
    ///   - [`routing_profile(Option<RoutingProfile>)`](crate::output::DescribeRoutingProfileOutput::routing_profile): <p>The routing profile.</p>
    /// - On failure, responds with [`SdkError<DescribeRoutingProfileError>`](crate::error::DescribeRoutingProfileError)
    pub fn describe_routing_profile(&self) -> fluent_builders::DescribeRoutingProfile<C, M, R> {
        fluent_builders::DescribeRoutingProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSecurityProfile`](crate::client::fluent_builders::DescribeSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSecurityProfile::security_profile_id) / [`set_security_profile_id(Option<String>)`](crate::client::fluent_builders::DescribeSecurityProfile::set_security_profile_id): <p>The identifier for the security profle.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeSecurityProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeSecurityProfile::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`DescribeSecurityProfileOutput`](crate::output::DescribeSecurityProfileOutput) with field(s):
    ///   - [`security_profile(Option<SecurityProfile>)`](crate::output::DescribeSecurityProfileOutput::security_profile): <p>The security profile.</p>
    /// - On failure, responds with [`SdkError<DescribeSecurityProfileError>`](crate::error::DescribeSecurityProfileError)
    pub fn describe_security_profile(&self) -> fluent_builders::DescribeSecurityProfile<C, M, R> {
        fluent_builders::DescribeSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUser`](crate::client::fluent_builders::DescribeUser) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_user_id): <p>The identifier of the user account.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUser::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeUser::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`DescribeUserOutput`](crate::output::DescribeUserOutput) with field(s):
    ///   - [`user(Option<User>)`](crate::output::DescribeUserOutput::user): <p>Information about the user account and configuration settings.</p>
    /// - On failure, responds with [`SdkError<DescribeUserError>`](crate::error::DescribeUserError)
    pub fn describe_user(&self) -> fluent_builders::DescribeUser<C, M, R> {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserHierarchyGroup`](crate::client::fluent_builders::DescribeUserHierarchyGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hierarchy_group_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserHierarchyGroup::hierarchy_group_id) / [`set_hierarchy_group_id(Option<String>)`](crate::client::fluent_builders::DescribeUserHierarchyGroup::set_hierarchy_group_id): <p>The identifier of the hierarchy group.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserHierarchyGroup::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeUserHierarchyGroup::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`DescribeUserHierarchyGroupOutput`](crate::output::DescribeUserHierarchyGroupOutput) with field(s):
    ///   - [`hierarchy_group(Option<HierarchyGroup>)`](crate::output::DescribeUserHierarchyGroupOutput::hierarchy_group): <p>Information about the hierarchy group.</p>
    /// - On failure, responds with [`SdkError<DescribeUserHierarchyGroupError>`](crate::error::DescribeUserHierarchyGroupError)
    pub fn describe_user_hierarchy_group(
        &self,
    ) -> fluent_builders::DescribeUserHierarchyGroup<C, M, R> {
        fluent_builders::DescribeUserHierarchyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUserHierarchyStructure`](crate::client::fluent_builders::DescribeUserHierarchyStructure) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUserHierarchyStructure::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeUserHierarchyStructure::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`DescribeUserHierarchyStructureOutput`](crate::output::DescribeUserHierarchyStructureOutput) with field(s):
    ///   - [`hierarchy_structure(Option<HierarchyStructure>)`](crate::output::DescribeUserHierarchyStructureOutput::hierarchy_structure): <p>Information about the hierarchy structure.</p>
    /// - On failure, responds with [`SdkError<DescribeUserHierarchyStructureError>`](crate::error::DescribeUserHierarchyStructureError)
    pub fn describe_user_hierarchy_structure(
        &self,
    ) -> fluent_builders::DescribeUserHierarchyStructure<C, M, R> {
        fluent_builders::DescribeUserHierarchyStructure::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeVocabulary`](crate::client::fluent_builders::DescribeVocabulary) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeVocabulary::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeVocabulary::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`vocabulary_id(impl Into<String>)`](crate::client::fluent_builders::DescribeVocabulary::vocabulary_id) / [`set_vocabulary_id(Option<String>)`](crate::client::fluent_builders::DescribeVocabulary::set_vocabulary_id): <p>The identifier of the custom vocabulary.</p>
    /// - On success, responds with [`DescribeVocabularyOutput`](crate::output::DescribeVocabularyOutput) with field(s):
    ///   - [`vocabulary(Option<Vocabulary>)`](crate::output::DescribeVocabularyOutput::vocabulary): <p>A list of specific words that you want Contact Lens for Amazon Connect to recognize in your audio input. They are generally domain-specific words and phrases, words that Contact Lens is not recognizing, or proper nouns.</p>
    /// - On failure, responds with [`SdkError<DescribeVocabularyError>`](crate::error::DescribeVocabularyError)
    pub fn describe_vocabulary(&self) -> fluent_builders::DescribeVocabulary<C, M, R> {
        fluent_builders::DescribeVocabulary::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateApprovedOrigin`](crate::client::fluent_builders::DisassociateApprovedOrigin) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateApprovedOrigin::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateApprovedOrigin::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`origin(impl Into<String>)`](crate::client::fluent_builders::DisassociateApprovedOrigin::origin) / [`set_origin(Option<String>)`](crate::client::fluent_builders::DisassociateApprovedOrigin::set_origin): <p>The domain URL of the integrated application.</p>
    /// - On success, responds with [`DisassociateApprovedOriginOutput`](crate::output::DisassociateApprovedOriginOutput)

    /// - On failure, responds with [`SdkError<DisassociateApprovedOriginError>`](crate::error::DisassociateApprovedOriginError)
    pub fn disassociate_approved_origin(
        &self,
    ) -> fluent_builders::DisassociateApprovedOrigin<C, M, R> {
        fluent_builders::DisassociateApprovedOrigin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateBot`](crate::client::fluent_builders::DisassociateBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateBot::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateBot::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`lex_bot(LexBot)`](crate::client::fluent_builders::DisassociateBot::lex_bot) / [`set_lex_bot(Option<LexBot>)`](crate::client::fluent_builders::DisassociateBot::set_lex_bot): <p>Configuration information of an Amazon Lex bot.</p>
    ///   - [`lex_v2_bot(LexV2Bot)`](crate::client::fluent_builders::DisassociateBot::lex_v2_bot) / [`set_lex_v2_bot(Option<LexV2Bot>)`](crate::client::fluent_builders::DisassociateBot::set_lex_v2_bot): <p>The Amazon Lex V2 bot to disassociate from the instance.</p>
    /// - On success, responds with [`DisassociateBotOutput`](crate::output::DisassociateBotOutput)

    /// - On failure, responds with [`SdkError<DisassociateBotError>`](crate::error::DisassociateBotError)
    pub fn disassociate_bot(&self) -> fluent_builders::DisassociateBot<C, M, R> {
        fluent_builders::DisassociateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateInstanceStorageConfig`](crate::client::fluent_builders::DisassociateInstanceStorageConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateInstanceStorageConfig::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateInstanceStorageConfig::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateInstanceStorageConfig::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DisassociateInstanceStorageConfig::set_association_id): <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    ///   - [`resource_type(InstanceStorageResourceType)`](crate::client::fluent_builders::DisassociateInstanceStorageConfig::resource_type) / [`set_resource_type(Option<InstanceStorageResourceType>)`](crate::client::fluent_builders::DisassociateInstanceStorageConfig::set_resource_type): <p>A valid resource type.</p>
    /// - On success, responds with [`DisassociateInstanceStorageConfigOutput`](crate::output::DisassociateInstanceStorageConfigOutput)

    /// - On failure, responds with [`SdkError<DisassociateInstanceStorageConfigError>`](crate::error::DisassociateInstanceStorageConfigError)
    pub fn disassociate_instance_storage_config(
        &self,
    ) -> fluent_builders::DisassociateInstanceStorageConfig<C, M, R> {
        fluent_builders::DisassociateInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateLambdaFunction`](crate::client::fluent_builders::DisassociateLambdaFunction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateLambdaFunction::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateLambdaFunction::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>
    ///   - [`function_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateLambdaFunction::function_arn) / [`set_function_arn(Option<String>)`](crate::client::fluent_builders::DisassociateLambdaFunction::set_function_arn): <p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>
    /// - On success, responds with [`DisassociateLambdaFunctionOutput`](crate::output::DisassociateLambdaFunctionOutput)

    /// - On failure, responds with [`SdkError<DisassociateLambdaFunctionError>`](crate::error::DisassociateLambdaFunctionError)
    pub fn disassociate_lambda_function(
        &self,
    ) -> fluent_builders::DisassociateLambdaFunction<C, M, R> {
        fluent_builders::DisassociateLambdaFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateLexBot`](crate::client::fluent_builders::DisassociateLexBot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateLexBot::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateLexBot::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`bot_name(impl Into<String>)`](crate::client::fluent_builders::DisassociateLexBot::bot_name) / [`set_bot_name(Option<String>)`](crate::client::fluent_builders::DisassociateLexBot::set_bot_name): <p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>
    ///   - [`lex_region(impl Into<String>)`](crate::client::fluent_builders::DisassociateLexBot::lex_region) / [`set_lex_region(Option<String>)`](crate::client::fluent_builders::DisassociateLexBot::set_lex_region): <p>The Region in which the Amazon Lex bot has been created.</p>
    /// - On success, responds with [`DisassociateLexBotOutput`](crate::output::DisassociateLexBotOutput)

    /// - On failure, responds with [`SdkError<DisassociateLexBotError>`](crate::error::DisassociateLexBotError)
    pub fn disassociate_lex_bot(&self) -> fluent_builders::DisassociateLexBot<C, M, R> {
        fluent_builders::DisassociateLexBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateQueueQuickConnects`](crate::client::fluent_builders::DisassociateQueueQuickConnects) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateQueueQuickConnects::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateQueueQuickConnects::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateQueueQuickConnects::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::DisassociateQueueQuickConnects::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`quick_connect_ids(Vec<String>)`](crate::client::fluent_builders::DisassociateQueueQuickConnects::quick_connect_ids) / [`set_quick_connect_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DisassociateQueueQuickConnects::set_quick_connect_ids): <p>The quick connects to disassociate from the queue.</p>
    /// - On success, responds with [`DisassociateQueueQuickConnectsOutput`](crate::output::DisassociateQueueQuickConnectsOutput)

    /// - On failure, responds with [`SdkError<DisassociateQueueQuickConnectsError>`](crate::error::DisassociateQueueQuickConnectsError)
    pub fn disassociate_queue_quick_connects(
        &self,
    ) -> fluent_builders::DisassociateQueueQuickConnects<C, M, R> {
        fluent_builders::DisassociateQueueQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateRoutingProfileQueues`](crate::client::fluent_builders::DisassociateRoutingProfileQueues) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateRoutingProfileQueues::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateRoutingProfileQueues::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateRoutingProfileQueues::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::DisassociateRoutingProfileQueues::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    ///   - [`queue_references(Vec<RoutingProfileQueueReference>)`](crate::client::fluent_builders::DisassociateRoutingProfileQueues::queue_references) / [`set_queue_references(Option<Vec<RoutingProfileQueueReference>>)`](crate::client::fluent_builders::DisassociateRoutingProfileQueues::set_queue_references): <p>The queues to disassociate from this routing profile.</p>
    /// - On success, responds with [`DisassociateRoutingProfileQueuesOutput`](crate::output::DisassociateRoutingProfileQueuesOutput)

    /// - On failure, responds with [`SdkError<DisassociateRoutingProfileQueuesError>`](crate::error::DisassociateRoutingProfileQueuesError)
    pub fn disassociate_routing_profile_queues(
        &self,
    ) -> fluent_builders::DisassociateRoutingProfileQueues<C, M, R> {
        fluent_builders::DisassociateRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateSecurityKey`](crate::client::fluent_builders::DisassociateSecurityKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateSecurityKey::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::DisassociateSecurityKey::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateSecurityKey::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::DisassociateSecurityKey::set_association_id): <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    /// - On success, responds with [`DisassociateSecurityKeyOutput`](crate::output::DisassociateSecurityKeyOutput)

    /// - On failure, responds with [`SdkError<DisassociateSecurityKeyError>`](crate::error::DisassociateSecurityKeyError)
    pub fn disassociate_security_key(&self) -> fluent_builders::DisassociateSecurityKey<C, M, R> {
        fluent_builders::DisassociateSecurityKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetContactAttributes`](crate::client::fluent_builders::GetContactAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetContactAttributes::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetContactAttributes::set_instance_id): <p>The identifier of the Amazon Connect instance.</p>
    ///   - [`initial_contact_id(impl Into<String>)`](crate::client::fluent_builders::GetContactAttributes::initial_contact_id) / [`set_initial_contact_id(Option<String>)`](crate::client::fluent_builders::GetContactAttributes::set_initial_contact_id): <p>The identifier of the initial contact.</p>
    /// - On success, responds with [`GetContactAttributesOutput`](crate::output::GetContactAttributesOutput) with field(s):
    ///   - [`attributes(Option<HashMap<String, String>>)`](crate::output::GetContactAttributesOutput::attributes): <p>Information about the attributes.</p>
    /// - On failure, responds with [`SdkError<GetContactAttributesError>`](crate::error::GetContactAttributesError)
    pub fn get_contact_attributes(&self) -> fluent_builders::GetContactAttributes<C, M, R> {
        fluent_builders::GetContactAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCurrentMetricData`](crate::client::fluent_builders::GetCurrentMetricData) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetCurrentMetricData::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetCurrentMetricData::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetCurrentMetricData::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`filters(Filters)`](crate::client::fluent_builders::GetCurrentMetricData::filters) / [`set_filters(Option<Filters>)`](crate::client::fluent_builders::GetCurrentMetricData::set_filters): <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
    ///   - [`groupings(Vec<Grouping>)`](crate::client::fluent_builders::GetCurrentMetricData::groupings) / [`set_groupings(Option<Vec<Grouping>>)`](crate::client::fluent_builders::GetCurrentMetricData::set_groupings): <p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.</p>  <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p>
    ///   - [`current_metrics(Vec<CurrentMetric>)`](crate::client::fluent_builders::GetCurrentMetricData::current_metrics) / [`set_current_metrics(Option<Vec<CurrentMetric>>)`](crate::client::fluent_builders::GetCurrentMetricData::set_current_metrics): <p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>  <dl>   <dt>   AGENTS_AFTER_CONTACT_WORK  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a> </p>   </dd>   <dt>   AGENTS_AVAILABLE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a> </p>   </dd>   <dt>   AGENTS_ERROR  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a> </p>   </dd>   <dt>   AGENTS_NON_PRODUCTIVE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a> </p>   </dd>   <dt>   AGENTS_ON_CALL  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>   </dd>   <dt>   AGENTS_ON_CONTACT  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>   </dd>   <dt>   AGENTS_ONLINE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a> </p>   </dd>   <dt>   AGENTS_STAFFED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a> </p>   </dd>   <dt>   CONTACTS_IN_QUEUE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In queue</a> </p>   </dd>   <dt>   CONTACTS_SCHEDULED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a> </p>   </dd>   <dt>   OLDEST_CONTACT_AGE  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p>    <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:</p>    <p> <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>}</p>    <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a> </p>   </dd>   <dt>   SLOTS_ACTIVE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a> </p>   </dd>   <dt>   SLOTS_AVAILABLE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a> </p>   </dd>  </dl>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetCurrentMetricData::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetCurrentMetricData::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>  <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetCurrentMetricData::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetCurrentMetricData::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`GetCurrentMetricDataOutput`](crate::output::GetCurrentMetricDataOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetCurrentMetricDataOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>  <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>
    ///   - [`metric_results(Option<Vec<CurrentMetricResult>>)`](crate::output::GetCurrentMetricDataOutput::metric_results): <p>Information about the real-time metrics.</p>
    ///   - [`data_snapshot_time(Option<DateTime>)`](crate::output::GetCurrentMetricDataOutput::data_snapshot_time): <p>The time at which the metrics were retrieved and cached for pagination.</p>
    /// - On failure, responds with [`SdkError<GetCurrentMetricDataError>`](crate::error::GetCurrentMetricDataError)
    pub fn get_current_metric_data(&self) -> fluent_builders::GetCurrentMetricData<C, M, R> {
        fluent_builders::GetCurrentMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFederationToken`](crate::client::fluent_builders::GetFederationToken) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetFederationToken::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetFederationToken::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`GetFederationTokenOutput`](crate::output::GetFederationTokenOutput) with field(s):
    ///   - [`credentials(Option<Credentials>)`](crate::output::GetFederationTokenOutput::credentials): <p>The credentials to use for federation.</p>
    /// - On failure, responds with [`SdkError<GetFederationTokenError>`](crate::error::GetFederationTokenError)
    pub fn get_federation_token(&self) -> fluent_builders::GetFederationToken<C, M, R> {
        fluent_builders::GetFederationToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMetricData`](crate::client::fluent_builders::GetMetricData) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetMetricData::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::GetMetricData::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::GetMetricData::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::GetMetricData::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::GetMetricData::set_start_time): <p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p>  <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::GetMetricData::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::GetMetricData::set_end_time): <p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p>  <p>The time range between the start and end time must be less than 24 hours.</p>
    ///   - [`filters(Filters)`](crate::client::fluent_builders::GetMetricData::filters) / [`set_filters(Option<Filters>)`](crate::client::fluent_builders::GetMetricData::set_filters): <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p> <note>   <p>To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.</p>  </note>
    ///   - [`groupings(Vec<Grouping>)`](crate::client::fluent_builders::GetMetricData::groupings) / [`set_groupings(Option<Vec<Grouping>>)`](crate::client::fluent_builders::GetMetricData::set_groupings): <p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p>  <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>
    ///   - [`historical_metrics(Vec<HistoricalMetric>)`](crate::client::fluent_builders::GetMetricData::historical_metrics) / [`set_historical_metrics(Option<Vec<HistoricalMetric>>)`](crate::client::fluent_builders::GetMetricData::set_historical_metrics): <p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>   <p>This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list). </p>  </note>  <dl>   <dt>   ABANDON_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: AVG</p>   </dd>   <dt>   AFTER_CONTACT_WORK_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: AVG</p>   </dd>   <dt>   API_CONTACTS_HANDLED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CALLBACK_CONTACTS_HANDLED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_ABANDONED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_AGENT_HUNG_UP_FIRST  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_CONSULTED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_HANDLED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_HANDLED_INCOMING  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_HANDLED_OUTBOUND  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_HOLD_ABANDONS  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_MISSED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_QUEUED  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_TRANSFERRED_IN  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_TRANSFERRED_IN_FROM_QUEUE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_TRANSFERRED_OUT  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   CONTACTS_TRANSFERRED_OUT_FROM_QUEUE  </dt>   <dd>    <p>Unit: COUNT</p>    <p>Statistic: SUM</p>   </dd>   <dt>   HANDLE_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: AVG</p>   </dd>   <dt>   HOLD_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: AVG</p>   </dd>   <dt>   INTERACTION_AND_HOLD_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: AVG</p>   </dd>   <dt>   INTERACTION_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: AVG</p>   </dd>   <dt>   OCCUPANCY  </dt>   <dd>    <p>Unit: PERCENT</p>    <p>Statistic: AVG</p>   </dd>   <dt>   QUEUE_ANSWER_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: AVG</p>   </dd>   <dt>   QUEUED_TIME  </dt>   <dd>    <p>Unit: SECONDS</p>    <p>Statistic: MAX</p>   </dd>   <dt>   SERVICE_LEVEL  </dt>   <dd>    <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p>    <p>Unit: PERCENT</p>    <p>Statistic: AVG</p>    <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p>   </dd>  </dl>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetMetricData::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetMetricData::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetMetricData::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::GetMetricData::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`GetMetricDataOutput`](crate::output::GetMetricDataOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetMetricDataOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>  <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>
    ///   - [`metric_results(Option<Vec<HistoricalMetricResult>>)`](crate::output::GetMetricDataOutput::metric_results): <p>Information about the historical metrics.</p>  <p>If no grouping is specified, a summary of metric data is returned.</p>
    /// - On failure, responds with [`SdkError<GetMetricDataError>`](crate::error::GetMetricDataError)
    pub fn get_metric_data(&self) -> fluent_builders::GetMetricData<C, M, R> {
        fluent_builders::GetMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListAgentStatuses`](crate::client::fluent_builders::ListAgentStatuses) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListAgentStatuses::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListAgentStatuses::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListAgentStatuses::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListAgentStatuses::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListAgentStatuses::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListAgentStatuses::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListAgentStatuses::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`agent_status_types(Vec<AgentStatusType>)`](crate::client::fluent_builders::ListAgentStatuses::agent_status_types) / [`set_agent_status_types(Option<Vec<AgentStatusType>>)`](crate::client::fluent_builders::ListAgentStatuses::set_agent_status_types): <p>Available agent status types.</p>
    /// - On success, responds with [`ListAgentStatusesOutput`](crate::output::ListAgentStatusesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListAgentStatusesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    ///   - [`agent_status_summary_list(Option<Vec<AgentStatusSummary>>)`](crate::output::ListAgentStatusesOutput::agent_status_summary_list): <p>A summary of agent statuses.</p>
    /// - On failure, responds with [`SdkError<ListAgentStatusesError>`](crate::error::ListAgentStatusesError)
    pub fn list_agent_statuses(&self) -> fluent_builders::ListAgentStatuses<C, M, R> {
        fluent_builders::ListAgentStatuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListApprovedOrigins`](crate::client::fluent_builders::ListApprovedOrigins) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListApprovedOrigins::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListApprovedOrigins::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListApprovedOrigins::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListApprovedOrigins::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListApprovedOrigins::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListApprovedOrigins::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListApprovedOrigins::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListApprovedOriginsOutput`](crate::output::ListApprovedOriginsOutput) with field(s):
    ///   - [`origins(Option<Vec<String>>)`](crate::output::ListApprovedOriginsOutput::origins): <p>The approved origins.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListApprovedOriginsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListApprovedOriginsError>`](crate::error::ListApprovedOriginsError)
    pub fn list_approved_origins(&self) -> fluent_builders::ListApprovedOrigins<C, M, R> {
        fluent_builders::ListApprovedOrigins::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListBots`](crate::client::fluent_builders::ListBots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListBots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListBots::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListBots::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListBots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListBots::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListBots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListBots::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`lex_version(LexVersion)`](crate::client::fluent_builders::ListBots::lex_version) / [`set_lex_version(Option<LexVersion>)`](crate::client::fluent_builders::ListBots::set_lex_version): <p>The version of Amazon Lex or Amazon Lex V2.</p>
    /// - On success, responds with [`ListBotsOutput`](crate::output::ListBotsOutput) with field(s):
    ///   - [`lex_bots(Option<Vec<LexBotConfig>>)`](crate::output::ListBotsOutput::lex_bots): <p>The names and Regions of the Amazon Lex or Amazon Lex V2 bots associated with the specified instance.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListBotsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListBotsError>`](crate::error::ListBotsError)
    pub fn list_bots(&self) -> fluent_builders::ListBots<C, M, R> {
        fluent_builders::ListBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContactFlowModules`](crate::client::fluent_builders::ListContactFlowModules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContactFlowModules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListContactFlowModules::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListContactFlowModules::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContactFlowModules::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContactFlowModules::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContactFlowModules::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListContactFlowModules::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`contact_flow_module_state(ContactFlowModuleState)`](crate::client::fluent_builders::ListContactFlowModules::contact_flow_module_state) / [`set_contact_flow_module_state(Option<ContactFlowModuleState>)`](crate::client::fluent_builders::ListContactFlowModules::set_contact_flow_module_state): <p>The state of the contact flow module.</p>
    /// - On success, responds with [`ListContactFlowModulesOutput`](crate::output::ListContactFlowModulesOutput) with field(s):
    ///   - [`contact_flow_modules_summary_list(Option<Vec<ContactFlowModuleSummary>>)`](crate::output::ListContactFlowModulesOutput::contact_flow_modules_summary_list): <p>Information about the contact flow module.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContactFlowModulesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListContactFlowModulesError>`](crate::error::ListContactFlowModulesError)
    pub fn list_contact_flow_modules(&self) -> fluent_builders::ListContactFlowModules<C, M, R> {
        fluent_builders::ListContactFlowModules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContactFlows`](crate::client::fluent_builders::ListContactFlows) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContactFlows::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListContactFlows::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListContactFlows::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_types(Vec<ContactFlowType>)`](crate::client::fluent_builders::ListContactFlows::contact_flow_types) / [`set_contact_flow_types(Option<Vec<ContactFlowType>>)`](crate::client::fluent_builders::ListContactFlows::set_contact_flow_types): <p>The type of contact flow.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContactFlows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContactFlows::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListContactFlows::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListContactFlows::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListContactFlowsOutput`](crate::output::ListContactFlowsOutput) with field(s):
    ///   - [`contact_flow_summary_list(Option<Vec<ContactFlowSummary>>)`](crate::output::ListContactFlowsOutput::contact_flow_summary_list): <p>Information about the contact flows.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContactFlowsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListContactFlowsError>`](crate::error::ListContactFlowsError)
    pub fn list_contact_flows(&self) -> fluent_builders::ListContactFlows<C, M, R> {
        fluent_builders::ListContactFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListContactReferences`](crate::client::fluent_builders::ListContactReferences) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListContactReferences::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListContactReferences::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListContactReferences::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::ListContactReferences::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::ListContactReferences::set_contact_id): <p>The identifier of the initial contact.</p>
    ///   - [`reference_types(Vec<ReferenceType>)`](crate::client::fluent_builders::ListContactReferences::reference_types) / [`set_reference_types(Option<Vec<ReferenceType>>)`](crate::client::fluent_builders::ListContactReferences::set_reference_types): <p>The type of reference.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListContactReferences::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListContactReferences::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important>   <p>This is not expected to be set, because the value returned in the previous response is always null.</p>  </important>
    /// - On success, responds with [`ListContactReferencesOutput`](crate::output::ListContactReferencesOutput) with field(s):
    ///   - [`reference_summary_list(Option<Vec<ReferenceSummary>>)`](crate::output::ListContactReferencesOutput::reference_summary_list): <p>Information about the contact flows.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListContactReferencesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p> <important>   <p>This is always returned as null in the response.</p>  </important>
    /// - On failure, responds with [`SdkError<ListContactReferencesError>`](crate::error::ListContactReferencesError)
    pub fn list_contact_references(&self) -> fluent_builders::ListContactReferences<C, M, R> {
        fluent_builders::ListContactReferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDefaultVocabularies`](crate::client::fluent_builders::ListDefaultVocabularies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDefaultVocabularies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListDefaultVocabularies::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListDefaultVocabularies::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`language_code(VocabularyLanguageCode)`](crate::client::fluent_builders::ListDefaultVocabularies::language_code) / [`set_language_code(Option<VocabularyLanguageCode>)`](crate::client::fluent_builders::ListDefaultVocabularies::set_language_code): <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDefaultVocabularies::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListDefaultVocabularies::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDefaultVocabularies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDefaultVocabularies::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    /// - On success, responds with [`ListDefaultVocabulariesOutput`](crate::output::ListDefaultVocabulariesOutput) with field(s):
    ///   - [`default_vocabulary_list(Option<Vec<DefaultVocabulary>>)`](crate::output::ListDefaultVocabulariesOutput::default_vocabulary_list): <p>A list of default vocabularies.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDefaultVocabulariesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListDefaultVocabulariesError>`](crate::error::ListDefaultVocabulariesError)
    pub fn list_default_vocabularies(&self) -> fluent_builders::ListDefaultVocabularies<C, M, R> {
        fluent_builders::ListDefaultVocabularies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListHoursOfOperations`](crate::client::fluent_builders::ListHoursOfOperations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListHoursOfOperations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListHoursOfOperations::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListHoursOfOperations::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListHoursOfOperations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListHoursOfOperations::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListHoursOfOperations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListHoursOfOperations::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListHoursOfOperationsOutput`](crate::output::ListHoursOfOperationsOutput) with field(s):
    ///   - [`hours_of_operation_summary_list(Option<Vec<HoursOfOperationSummary>>)`](crate::output::ListHoursOfOperationsOutput::hours_of_operation_summary_list): <p>Information about the hours of operation.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListHoursOfOperationsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListHoursOfOperationsError>`](crate::error::ListHoursOfOperationsError)
    pub fn list_hours_of_operations(&self) -> fluent_builders::ListHoursOfOperations<C, M, R> {
        fluent_builders::ListHoursOfOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstanceAttributes`](crate::client::fluent_builders::ListInstanceAttributes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstanceAttributes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListInstanceAttributes::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListInstanceAttributes::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInstanceAttributes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInstanceAttributes::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInstanceAttributes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInstanceAttributes::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListInstanceAttributesOutput`](crate::output::ListInstanceAttributesOutput) with field(s):
    ///   - [`attributes(Option<Vec<Attribute>>)`](crate::output::ListInstanceAttributesOutput::attributes): <p>The attribute types.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInstanceAttributesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListInstanceAttributesError>`](crate::error::ListInstanceAttributesError)
    pub fn list_instance_attributes(&self) -> fluent_builders::ListInstanceAttributes<C, M, R> {
        fluent_builders::ListInstanceAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstances`](crate::client::fluent_builders::ListInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInstances::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInstances::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInstances::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInstances::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListInstancesOutput`](crate::output::ListInstancesOutput) with field(s):
    ///   - [`instance_summary_list(Option<Vec<InstanceSummary>>)`](crate::output::ListInstancesOutput::instance_summary_list): <p>Information about the instances.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInstancesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListInstancesError>`](crate::error::ListInstancesError)
    pub fn list_instances(&self) -> fluent_builders::ListInstances<C, M, R> {
        fluent_builders::ListInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInstanceStorageConfigs`](crate::client::fluent_builders::ListInstanceStorageConfigs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInstanceStorageConfigs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListInstanceStorageConfigs::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListInstanceStorageConfigs::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`resource_type(InstanceStorageResourceType)`](crate::client::fluent_builders::ListInstanceStorageConfigs::resource_type) / [`set_resource_type(Option<InstanceStorageResourceType>)`](crate::client::fluent_builders::ListInstanceStorageConfigs::set_resource_type): <p>A valid resource type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInstanceStorageConfigs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInstanceStorageConfigs::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInstanceStorageConfigs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInstanceStorageConfigs::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListInstanceStorageConfigsOutput`](crate::output::ListInstanceStorageConfigsOutput) with field(s):
    ///   - [`storage_configs(Option<Vec<InstanceStorageConfig>>)`](crate::output::ListInstanceStorageConfigsOutput::storage_configs): <p>A valid storage type.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInstanceStorageConfigsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListInstanceStorageConfigsError>`](crate::error::ListInstanceStorageConfigsError)
    pub fn list_instance_storage_configs(
        &self,
    ) -> fluent_builders::ListInstanceStorageConfigs<C, M, R> {
        fluent_builders::ListInstanceStorageConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListIntegrationAssociations`](crate::client::fluent_builders::ListIntegrationAssociations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListIntegrationAssociations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListIntegrationAssociations::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListIntegrationAssociations::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`integration_type(IntegrationType)`](crate::client::fluent_builders::ListIntegrationAssociations::integration_type) / [`set_integration_type(Option<IntegrationType>)`](crate::client::fluent_builders::ListIntegrationAssociations::set_integration_type): <p>The integration type.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListIntegrationAssociations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListIntegrationAssociations::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListIntegrationAssociations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListIntegrationAssociations::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListIntegrationAssociationsOutput`](crate::output::ListIntegrationAssociationsOutput) with field(s):
    ///   - [`integration_association_summary_list(Option<Vec<IntegrationAssociationSummary>>)`](crate::output::ListIntegrationAssociationsOutput::integration_association_summary_list): <p>The associations.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListIntegrationAssociationsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListIntegrationAssociationsError>`](crate::error::ListIntegrationAssociationsError)
    pub fn list_integration_associations(
        &self,
    ) -> fluent_builders::ListIntegrationAssociations<C, M, R> {
        fluent_builders::ListIntegrationAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLambdaFunctions`](crate::client::fluent_builders::ListLambdaFunctions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLambdaFunctions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListLambdaFunctions::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListLambdaFunctions::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLambdaFunctions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLambdaFunctions::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLambdaFunctions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLambdaFunctions::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListLambdaFunctionsOutput`](crate::output::ListLambdaFunctionsOutput) with field(s):
    ///   - [`lambda_functions(Option<Vec<String>>)`](crate::output::ListLambdaFunctionsOutput::lambda_functions): <p>The Lambdafunction ARNs associated with the specified instance.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLambdaFunctionsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLambdaFunctionsError>`](crate::error::ListLambdaFunctionsError)
    pub fn list_lambda_functions(&self) -> fluent_builders::ListLambdaFunctions<C, M, R> {
        fluent_builders::ListLambdaFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListLexBots`](crate::client::fluent_builders::ListLexBots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListLexBots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListLexBots::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListLexBots::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListLexBots::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListLexBots::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListLexBots::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListLexBots::set_max_results): <p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>
    /// - On success, responds with [`ListLexBotsOutput`](crate::output::ListLexBotsOutput) with field(s):
    ///   - [`lex_bots(Option<Vec<LexBot>>)`](crate::output::ListLexBotsOutput::lex_bots): <p>The names and Regions of the Amazon Lex bots associated with the specified instance.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListLexBotsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListLexBotsError>`](crate::error::ListLexBotsError)
    pub fn list_lex_bots(&self) -> fluent_builders::ListLexBots<C, M, R> {
        fluent_builders::ListLexBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPhoneNumbers`](crate::client::fluent_builders::ListPhoneNumbers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPhoneNumbers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListPhoneNumbers::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListPhoneNumbers::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`phone_number_types(Vec<PhoneNumberType>)`](crate::client::fluent_builders::ListPhoneNumbers::phone_number_types) / [`set_phone_number_types(Option<Vec<PhoneNumberType>>)`](crate::client::fluent_builders::ListPhoneNumbers::set_phone_number_types): <p>The type of phone number.</p>
    ///   - [`phone_number_country_codes(Vec<PhoneNumberCountryCode>)`](crate::client::fluent_builders::ListPhoneNumbers::phone_number_country_codes) / [`set_phone_number_country_codes(Option<Vec<PhoneNumberCountryCode>>)`](crate::client::fluent_builders::ListPhoneNumbers::set_phone_number_country_codes): <p>The ISO country code.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPhoneNumbers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPhoneNumbers::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPhoneNumbers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListPhoneNumbers::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListPhoneNumbersOutput`](crate::output::ListPhoneNumbersOutput) with field(s):
    ///   - [`phone_number_summary_list(Option<Vec<PhoneNumberSummary>>)`](crate::output::ListPhoneNumbersOutput::phone_number_summary_list): <p>Information about the phone numbers.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPhoneNumbersOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListPhoneNumbersError>`](crate::error::ListPhoneNumbersError)
    pub fn list_phone_numbers(&self) -> fluent_builders::ListPhoneNumbers<C, M, R> {
        fluent_builders::ListPhoneNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListPrompts`](crate::client::fluent_builders::ListPrompts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListPrompts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListPrompts::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListPrompts::set_instance_id): <p>The identifier of the Amazon Connect instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListPrompts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListPrompts::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListPrompts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListPrompts::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListPromptsOutput`](crate::output::ListPromptsOutput) with field(s):
    ///   - [`prompt_summary_list(Option<Vec<PromptSummary>>)`](crate::output::ListPromptsOutput::prompt_summary_list): <p>Information about the prompts.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListPromptsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListPromptsError>`](crate::error::ListPromptsError)
    pub fn list_prompts(&self) -> fluent_builders::ListPrompts<C, M, R> {
        fluent_builders::ListPrompts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListQueueQuickConnects`](crate::client::fluent_builders::ListQueueQuickConnects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListQueueQuickConnects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListQueueQuickConnects::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListQueueQuickConnects::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::ListQueueQuickConnects::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::ListQueueQuickConnects::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListQueueQuickConnects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListQueueQuickConnects::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListQueueQuickConnects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListQueueQuickConnects::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListQueueQuickConnectsOutput`](crate::output::ListQueueQuickConnectsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListQueueQuickConnectsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    ///   - [`quick_connect_summary_list(Option<Vec<QuickConnectSummary>>)`](crate::output::ListQueueQuickConnectsOutput::quick_connect_summary_list): <p>Information about the quick connects.</p>
    /// - On failure, responds with [`SdkError<ListQueueQuickConnectsError>`](crate::error::ListQueueQuickConnectsError)
    pub fn list_queue_quick_connects(&self) -> fluent_builders::ListQueueQuickConnects<C, M, R> {
        fluent_builders::ListQueueQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListQueues`](crate::client::fluent_builders::ListQueues) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListQueues::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListQueues::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListQueues::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_types(Vec<QueueType>)`](crate::client::fluent_builders::ListQueues::queue_types) / [`set_queue_types(Option<Vec<QueueType>>)`](crate::client::fluent_builders::ListQueues::set_queue_types): <p>The type of queue.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListQueues::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListQueues::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListQueues::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListQueues::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListQueuesOutput`](crate::output::ListQueuesOutput) with field(s):
    ///   - [`queue_summary_list(Option<Vec<QueueSummary>>)`](crate::output::ListQueuesOutput::queue_summary_list): <p>Information about the queues.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListQueuesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListQueuesError>`](crate::error::ListQueuesError)
    pub fn list_queues(&self) -> fluent_builders::ListQueues<C, M, R> {
        fluent_builders::ListQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListQuickConnects`](crate::client::fluent_builders::ListQuickConnects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListQuickConnects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListQuickConnects::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListQuickConnects::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListQuickConnects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListQuickConnects::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListQuickConnects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListQuickConnects::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`quick_connect_types(Vec<QuickConnectType>)`](crate::client::fluent_builders::ListQuickConnects::quick_connect_types) / [`set_quick_connect_types(Option<Vec<QuickConnectType>>)`](crate::client::fluent_builders::ListQuickConnects::set_quick_connect_types): <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
    /// - On success, responds with [`ListQuickConnectsOutput`](crate::output::ListQuickConnectsOutput) with field(s):
    ///   - [`quick_connect_summary_list(Option<Vec<QuickConnectSummary>>)`](crate::output::ListQuickConnectsOutput::quick_connect_summary_list): <p>Information about the quick connects.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListQuickConnectsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListQuickConnectsError>`](crate::error::ListQuickConnectsError)
    pub fn list_quick_connects(&self) -> fluent_builders::ListQuickConnects<C, M, R> {
        fluent_builders::ListQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRoutingProfileQueues`](crate::client::fluent_builders::ListRoutingProfileQueues) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRoutingProfileQueues::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListRoutingProfileQueues::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListRoutingProfileQueues::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::ListRoutingProfileQueues::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::ListRoutingProfileQueues::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRoutingProfileQueues::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRoutingProfileQueues::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRoutingProfileQueues::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRoutingProfileQueues::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListRoutingProfileQueuesOutput`](crate::output::ListRoutingProfileQueuesOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListRoutingProfileQueuesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    ///   - [`routing_profile_queue_config_summary_list(Option<Vec<RoutingProfileQueueConfigSummary>>)`](crate::output::ListRoutingProfileQueuesOutput::routing_profile_queue_config_summary_list): <p>Information about the routing profiles.</p>
    /// - On failure, responds with [`SdkError<ListRoutingProfileQueuesError>`](crate::error::ListRoutingProfileQueuesError)
    pub fn list_routing_profile_queues(
        &self,
    ) -> fluent_builders::ListRoutingProfileQueues<C, M, R> {
        fluent_builders::ListRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListRoutingProfiles`](crate::client::fluent_builders::ListRoutingProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListRoutingProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListRoutingProfiles::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListRoutingProfiles::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListRoutingProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListRoutingProfiles::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListRoutingProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListRoutingProfiles::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListRoutingProfilesOutput`](crate::output::ListRoutingProfilesOutput) with field(s):
    ///   - [`routing_profile_summary_list(Option<Vec<RoutingProfileSummary>>)`](crate::output::ListRoutingProfilesOutput::routing_profile_summary_list): <p>Information about the routing profiles.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListRoutingProfilesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListRoutingProfilesError>`](crate::error::ListRoutingProfilesError)
    pub fn list_routing_profiles(&self) -> fluent_builders::ListRoutingProfiles<C, M, R> {
        fluent_builders::ListRoutingProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecurityKeys`](crate::client::fluent_builders::ListSecurityKeys) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecurityKeys::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListSecurityKeys::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListSecurityKeys::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecurityKeys::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecurityKeys::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecurityKeys::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecurityKeys::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListSecurityKeysOutput`](crate::output::ListSecurityKeysOutput) with field(s):
    ///   - [`security_keys(Option<Vec<SecurityKey>>)`](crate::output::ListSecurityKeysOutput::security_keys): <p>The security keys.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSecurityKeysOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListSecurityKeysError>`](crate::error::ListSecurityKeysError)
    pub fn list_security_keys(&self) -> fluent_builders::ListSecurityKeys<C, M, R> {
        fluent_builders::ListSecurityKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecurityProfilePermissions`](crate::client::fluent_builders::ListSecurityProfilePermissions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecurityProfilePermissions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_id(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfilePermissions::security_profile_id) / [`set_security_profile_id(Option<String>)`](crate::client::fluent_builders::ListSecurityProfilePermissions::set_security_profile_id): <p>The identifier for the security profle.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfilePermissions::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListSecurityProfilePermissions::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfilePermissions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecurityProfilePermissions::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecurityProfilePermissions::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecurityProfilePermissions::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListSecurityProfilePermissionsOutput`](crate::output::ListSecurityProfilePermissionsOutput) with field(s):
    ///   - [`permissions(Option<Vec<String>>)`](crate::output::ListSecurityProfilePermissionsOutput::permissions): <p>The permissions granted to the security profile.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSecurityProfilePermissionsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListSecurityProfilePermissionsError>`](crate::error::ListSecurityProfilePermissionsError)
    pub fn list_security_profile_permissions(
        &self,
    ) -> fluent_builders::ListSecurityProfilePermissions<C, M, R> {
        fluent_builders::ListSecurityProfilePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListSecurityProfiles`](crate::client::fluent_builders::ListSecurityProfiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListSecurityProfiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfiles::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListSecurityProfiles::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListSecurityProfiles::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListSecurityProfiles::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListSecurityProfiles::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListSecurityProfiles::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListSecurityProfilesOutput`](crate::output::ListSecurityProfilesOutput) with field(s):
    ///   - [`security_profile_summary_list(Option<Vec<SecurityProfileSummary>>)`](crate::output::ListSecurityProfilesOutput::security_profile_summary_list): <p>Information about the security profiles.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListSecurityProfilesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListSecurityProfilesError>`](crate::error::ListSecurityProfilesError)
    pub fn list_security_profiles(&self) -> fluent_builders::ListSecurityProfiles<C, M, R> {
        fluent_builders::ListSecurityProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>Information about the tags.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUseCases`](crate::client::fluent_builders::ListUseCases) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUseCases::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListUseCases::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListUseCases::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`integration_association_id(impl Into<String>)`](crate::client::fluent_builders::ListUseCases::integration_association_id) / [`set_integration_association_id(Option<String>)`](crate::client::fluent_builders::ListUseCases::set_integration_association_id): <p>The identifier for the integration association.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUseCases::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUseCases::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUseCases::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUseCases::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListUseCasesOutput`](crate::output::ListUseCasesOutput) with field(s):
    ///   - [`use_case_summary_list(Option<Vec<UseCase>>)`](crate::output::ListUseCasesOutput::use_case_summary_list): <p>The use cases.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUseCasesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListUseCasesError>`](crate::error::ListUseCasesError)
    pub fn list_use_cases(&self) -> fluent_builders::ListUseCases<C, M, R> {
        fluent_builders::ListUseCases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUserHierarchyGroups`](crate::client::fluent_builders::ListUserHierarchyGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUserHierarchyGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListUserHierarchyGroups::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListUserHierarchyGroups::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUserHierarchyGroups::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUserHierarchyGroups::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUserHierarchyGroups::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUserHierarchyGroups::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListUserHierarchyGroupsOutput`](crate::output::ListUserHierarchyGroupsOutput) with field(s):
    ///   - [`user_hierarchy_group_summary_list(Option<Vec<HierarchyGroupSummary>>)`](crate::output::ListUserHierarchyGroupsOutput::user_hierarchy_group_summary_list): <p>Information about the hierarchy groups.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUserHierarchyGroupsOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListUserHierarchyGroupsError>`](crate::error::ListUserHierarchyGroupsError)
    pub fn list_user_hierarchy_groups(&self) -> fluent_builders::ListUserHierarchyGroups<C, M, R> {
        fluent_builders::ListUserHierarchyGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListUsers`](crate::client::fluent_builders::ListUsers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListUsers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ListUsers::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ListUsers::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListUsers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListUsers::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListUsers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListUsers::set_max_results): <p>The maximum number of results to return per page.</p>
    /// - On success, responds with [`ListUsersOutput`](crate::output::ListUsersOutput) with field(s):
    ///   - [`user_summary_list(Option<Vec<UserSummary>>)`](crate::output::ListUsersOutput::user_summary_list): <p>Information about the users.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListUsersOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<ListUsersError>`](crate::error::ListUsersError)
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResumeContactRecording`](crate::client::fluent_builders::ResumeContactRecording) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::ResumeContactRecording::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::ResumeContactRecording::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::ResumeContactRecording::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::ResumeContactRecording::set_contact_id): <p>The identifier of the contact.</p>
    ///   - [`initial_contact_id(impl Into<String>)`](crate::client::fluent_builders::ResumeContactRecording::initial_contact_id) / [`set_initial_contact_id(Option<String>)`](crate::client::fluent_builders::ResumeContactRecording::set_initial_contact_id): <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
    /// - On success, responds with [`ResumeContactRecordingOutput`](crate::output::ResumeContactRecordingOutput)

    /// - On failure, responds with [`SdkError<ResumeContactRecordingError>`](crate::error::ResumeContactRecordingError)
    pub fn resume_contact_recording(&self) -> fluent_builders::ResumeContactRecording<C, M, R> {
        fluent_builders::ResumeContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchVocabularies`](crate::client::fluent_builders::SearchVocabularies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchVocabularies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::SearchVocabularies::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::SearchVocabularies::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchVocabularies::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::SearchVocabularies::set_max_results): <p>The maximum number of results to return per page.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchVocabularies::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchVocabularies::set_next_token): <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
    ///   - [`state(VocabularyState)`](crate::client::fluent_builders::SearchVocabularies::state) / [`set_state(Option<VocabularyState>)`](crate::client::fluent_builders::SearchVocabularies::set_state): <p>The current state of the custom vocabulary.</p>
    ///   - [`name_starts_with(impl Into<String>)`](crate::client::fluent_builders::SearchVocabularies::name_starts_with) / [`set_name_starts_with(Option<String>)`](crate::client::fluent_builders::SearchVocabularies::set_name_starts_with): <p>The starting pattern of the name of the vocabulary.</p>
    ///   - [`language_code(VocabularyLanguageCode)`](crate::client::fluent_builders::SearchVocabularies::language_code) / [`set_language_code(Option<VocabularyLanguageCode>)`](crate::client::fluent_builders::SearchVocabularies::set_language_code): <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
    /// - On success, responds with [`SearchVocabulariesOutput`](crate::output::SearchVocabulariesOutput) with field(s):
    ///   - [`vocabulary_summary_list(Option<Vec<VocabularySummary>>)`](crate::output::SearchVocabulariesOutput::vocabulary_summary_list): <p>The list of the available custom vocabularies.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchVocabulariesOutput::next_token): <p>If there are additional results, this is the token for the next set of results.</p>
    /// - On failure, responds with [`SdkError<SearchVocabulariesError>`](crate::error::SearchVocabulariesError)
    pub fn search_vocabularies(&self) -> fluent_builders::SearchVocabularies<C, M, R> {
        fluent_builders::SearchVocabularies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartChatContact`](crate::client::fluent_builders::StartChatContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StartChatContact::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StartChatContact::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::StartChatContact::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::StartChatContact::set_contact_flow_id): <p>The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>  <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::StartChatContact::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartChatContact::set_attributes): <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in contact flows just like any other contact attributes. </p>  <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
    ///   - [`participant_details(ParticipantDetails)`](crate::client::fluent_builders::StartChatContact::participant_details) / [`set_participant_details(Option<ParticipantDetails>)`](crate::client::fluent_builders::StartChatContact::set_participant_details): <p>Information identifying the participant.</p>
    ///   - [`initial_message(ChatMessage)`](crate::client::fluent_builders::StartChatContact::initial_message) / [`set_initial_message(Option<ChatMessage>)`](crate::client::fluent_builders::StartChatContact::set_initial_message): <p>The initial message to be sent to the newly created chat.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartChatContact::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartChatContact::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`StartChatContactOutput`](crate::output::StartChatContactOutput) with field(s):
    ///   - [`contact_id(Option<String>)`](crate::output::StartChatContactOutput::contact_id): <p>The identifier of this contact within the Amazon Connect instance. </p>
    ///   - [`participant_id(Option<String>)`](crate::output::StartChatContactOutput::participant_id): <p>The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat lifecycle.</p>
    ///   - [`participant_token(Option<String>)`](crate::output::StartChatContactOutput::participant_token): <p>The token used by the chat participant to call <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.</p>
    /// - On failure, responds with [`SdkError<StartChatContactError>`](crate::error::StartChatContactError)
    pub fn start_chat_contact(&self) -> fluent_builders::StartChatContact<C, M, R> {
        fluent_builders::StartChatContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartContactRecording`](crate::client::fluent_builders::StartContactRecording) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StartContactRecording::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StartContactRecording::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::StartContactRecording::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::StartContactRecording::set_contact_id): <p>The identifier of the contact.</p>
    ///   - [`initial_contact_id(impl Into<String>)`](crate::client::fluent_builders::StartContactRecording::initial_contact_id) / [`set_initial_contact_id(Option<String>)`](crate::client::fluent_builders::StartContactRecording::set_initial_contact_id): <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
    ///   - [`voice_recording_configuration(VoiceRecordingConfiguration)`](crate::client::fluent_builders::StartContactRecording::voice_recording_configuration) / [`set_voice_recording_configuration(Option<VoiceRecordingConfiguration>)`](crate::client::fluent_builders::StartContactRecording::set_voice_recording_configuration): <p>The person being recorded.</p>
    /// - On success, responds with [`StartContactRecordingOutput`](crate::output::StartContactRecordingOutput)

    /// - On failure, responds with [`SdkError<StartContactRecordingError>`](crate::error::StartContactRecordingError)
    pub fn start_contact_recording(&self) -> fluent_builders::StartContactRecording<C, M, R> {
        fluent_builders::StartContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartContactStreaming`](crate::client::fluent_builders::StartContactStreaming) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StartContactStreaming::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StartContactStreaming::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::StartContactStreaming::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::StartContactStreaming::set_contact_id): <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
    ///   - [`chat_streaming_configuration(ChatStreamingConfiguration)`](crate::client::fluent_builders::StartContactStreaming::chat_streaming_configuration) / [`set_chat_streaming_configuration(Option<ChatStreamingConfiguration>)`](crate::client::fluent_builders::StartContactStreaming::set_chat_streaming_configuration): <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartContactStreaming::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartContactStreaming::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`StartContactStreamingOutput`](crate::output::StartContactStreamingOutput) with field(s):
    ///   - [`streaming_id(Option<String>)`](crate::output::StartContactStreamingOutput::streaming_id): <p>The identifier of the streaming configuration enabled. </p>
    /// - On failure, responds with [`SdkError<StartContactStreamingError>`](crate::error::StartContactStreamingError)
    pub fn start_contact_streaming(&self) -> fluent_builders::StartContactStreaming<C, M, R> {
        fluent_builders::StartContactStreaming::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartOutboundVoiceContact`](crate::client::fluent_builders::StartOutboundVoiceContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`destination_phone_number(impl Into<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::destination_phone_number) / [`set_destination_phone_number(Option<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_destination_phone_number): <p>The phone number of the customer, in E.164 format.</p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_contact_flow_id): <p>The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>  <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. </p>
    ///   - [`source_phone_number(impl Into<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::source_phone_number) / [`set_source_phone_number(Option<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_source_phone_number): <p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_queue_id): <p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.</p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_attributes): <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>  <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
    ///   - [`answer_machine_detection_config(AnswerMachineDetectionConfig)`](crate::client::fluent_builders::StartOutboundVoiceContact::answer_machine_detection_config) / [`set_answer_machine_detection_config(Option<AnswerMachineDetectionConfig>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_answer_machine_detection_config): <p>Configuration of the answering machine detection for this outbound call. </p>
    ///   - [`campaign_id(impl Into<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::campaign_id) / [`set_campaign_id(Option<String>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_campaign_id): <p>The campaign identifier of the outbound communication.</p>
    ///   - [`traffic_type(TrafficType)`](crate::client::fluent_builders::StartOutboundVoiceContact::traffic_type) / [`set_traffic_type(Option<TrafficType>)`](crate::client::fluent_builders::StartOutboundVoiceContact::set_traffic_type): <p>Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use <code>GENERAL</code>. </p>
    /// - On success, responds with [`StartOutboundVoiceContactOutput`](crate::output::StartOutboundVoiceContactOutput) with field(s):
    ///   - [`contact_id(Option<String>)`](crate::output::StartOutboundVoiceContactOutput::contact_id): <p>The identifier of this contact within the Amazon Connect instance.</p>
    /// - On failure, responds with [`SdkError<StartOutboundVoiceContactError>`](crate::error::StartOutboundVoiceContactError)
    pub fn start_outbound_voice_contact(
        &self,
    ) -> fluent_builders::StartOutboundVoiceContact<C, M, R> {
        fluent_builders::StartOutboundVoiceContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartTaskContact`](crate::client::fluent_builders::StartTaskContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StartTaskContact::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StartTaskContact::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`previous_contact_id(impl Into<String>)`](crate::client::fluent_builders::StartTaskContact::previous_contact_id) / [`set_previous_contact_id(Option<String>)`](crate::client::fluent_builders::StartTaskContact::set_previous_contact_id): <p>The identifier of the previous chat, voice, or task contact. </p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::StartTaskContact::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::StartTaskContact::set_contact_flow_id): <p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>  <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::StartTaskContact::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::StartTaskContact::set_attributes): <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>  <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::StartTaskContact::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::StartTaskContact::set_name): <p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>
    ///   - [`references(HashMap<String, Reference>)`](crate::client::fluent_builders::StartTaskContact::references) / [`set_references(Option<HashMap<String, Reference>>)`](crate::client::fluent_builders::StartTaskContact::set_references): <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::StartTaskContact::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::StartTaskContact::set_description): <p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartTaskContact::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartTaskContact::set_client_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
    ///   - [`scheduled_time(DateTime)`](crate::client::fluent_builders::StartTaskContact::scheduled_time) / [`set_scheduled_time(Option<DateTime>)`](crate::client::fluent_builders::StartTaskContact::set_scheduled_time): <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
    /// - On success, responds with [`StartTaskContactOutput`](crate::output::StartTaskContactOutput) with field(s):
    ///   - [`contact_id(Option<String>)`](crate::output::StartTaskContactOutput::contact_id): <p>The identifier of this contact within the Amazon Connect instance.</p>
    /// - On failure, responds with [`SdkError<StartTaskContactError>`](crate::error::StartTaskContactError)
    pub fn start_task_contact(&self) -> fluent_builders::StartTaskContact<C, M, R> {
        fluent_builders::StartTaskContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopContact`](crate::client::fluent_builders::StopContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::StopContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::StopContact::set_contact_id): <p>The ID of the contact.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StopContact::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StopContact::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`StopContactOutput`](crate::output::StopContactOutput)

    /// - On failure, responds with [`SdkError<StopContactError>`](crate::error::StopContactError)
    pub fn stop_contact(&self) -> fluent_builders::StopContact<C, M, R> {
        fluent_builders::StopContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopContactRecording`](crate::client::fluent_builders::StopContactRecording) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StopContactRecording::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StopContactRecording::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::StopContactRecording::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::StopContactRecording::set_contact_id): <p>The identifier of the contact.</p>
    ///   - [`initial_contact_id(impl Into<String>)`](crate::client::fluent_builders::StopContactRecording::initial_contact_id) / [`set_initial_contact_id(Option<String>)`](crate::client::fluent_builders::StopContactRecording::set_initial_contact_id): <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
    /// - On success, responds with [`StopContactRecordingOutput`](crate::output::StopContactRecordingOutput)

    /// - On failure, responds with [`SdkError<StopContactRecordingError>`](crate::error::StopContactRecordingError)
    pub fn stop_contact_recording(&self) -> fluent_builders::StopContactRecording<C, M, R> {
        fluent_builders::StopContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopContactStreaming`](crate::client::fluent_builders::StopContactStreaming) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::StopContactStreaming::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::StopContactStreaming::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::StopContactStreaming::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::StopContactStreaming::set_contact_id): <p>The identifier of the contact. This is the identifier of the contact that is associated with the first interaction with the contact center.</p>
    ///   - [`streaming_id(impl Into<String>)`](crate::client::fluent_builders::StopContactStreaming::streaming_id) / [`set_streaming_id(Option<String>)`](crate::client::fluent_builders::StopContactStreaming::set_streaming_id): <p>The identifier of the streaming configuration enabled. </p>
    /// - On success, responds with [`StopContactStreamingOutput`](crate::output::StopContactStreamingOutput)

    /// - On failure, responds with [`SdkError<StopContactStreamingError>`](crate::error::StopContactStreamingError)
    pub fn stop_contact_streaming(&self) -> fluent_builders::StopContactStreaming<C, M, R> {
        fluent_builders::StopContactStreaming::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SuspendContactRecording`](crate::client::fluent_builders::SuspendContactRecording) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::SuspendContactRecording::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::SuspendContactRecording::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::SuspendContactRecording::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::SuspendContactRecording::set_contact_id): <p>The identifier of the contact.</p>
    ///   - [`initial_contact_id(impl Into<String>)`](crate::client::fluent_builders::SuspendContactRecording::initial_contact_id) / [`set_initial_contact_id(Option<String>)`](crate::client::fluent_builders::SuspendContactRecording::set_initial_contact_id): <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
    /// - On success, responds with [`SuspendContactRecordingOutput`](crate::output::SuspendContactRecordingOutput)

    /// - On failure, responds with [`SdkError<SuspendContactRecordingError>`](crate::error::SuspendContactRecordingError)
    pub fn suspend_contact_recording(&self) -> fluent_builders::SuspendContactRecording<C, M, R> {
        fluent_builders::SuspendContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateAgentStatus`](crate::client::fluent_builders::UpdateAgentStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAgentStatus::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateAgentStatus::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`agent_status_id(impl Into<String>)`](crate::client::fluent_builders::UpdateAgentStatus::agent_status_id) / [`set_agent_status_id(Option<String>)`](crate::client::fluent_builders::UpdateAgentStatus::set_agent_status_id): <p>The identifier of the agent status.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateAgentStatus::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateAgentStatus::set_name): <p>The name of the agent status.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateAgentStatus::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateAgentStatus::set_description): <p>The description of the agent status.</p>
    ///   - [`state(AgentStatusState)`](crate::client::fluent_builders::UpdateAgentStatus::state) / [`set_state(Option<AgentStatusState>)`](crate::client::fluent_builders::UpdateAgentStatus::set_state): <p>The state of the agent status.</p>
    ///   - [`display_order(i32)`](crate::client::fluent_builders::UpdateAgentStatus::display_order) / [`set_display_order(Option<i32>)`](crate::client::fluent_builders::UpdateAgentStatus::set_display_order): <p>The display order of the agent status.</p>
    ///   - [`reset_order_number(bool)`](crate::client::fluent_builders::UpdateAgentStatus::reset_order_number) / [`set_reset_order_number(bool)`](crate::client::fluent_builders::UpdateAgentStatus::set_reset_order_number): <p>A number indicating the reset order of the agent status.</p>
    /// - On success, responds with [`UpdateAgentStatusOutput`](crate::output::UpdateAgentStatusOutput)

    /// - On failure, responds with [`SdkError<UpdateAgentStatusError>`](crate::error::UpdateAgentStatusError)
    pub fn update_agent_status(&self) -> fluent_builders::UpdateAgentStatus<C, M, R> {
        fluent_builders::UpdateAgentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContact`](crate::client::fluent_builders::UpdateContact) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_contact_id): <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_name): <p>The name of the contact.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateContact::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateContact::set_description): <p>The description of the contact.</p>
    ///   - [`references(HashMap<String, Reference>)`](crate::client::fluent_builders::UpdateContact::references) / [`set_references(Option<HashMap<String, Reference>>)`](crate::client::fluent_builders::UpdateContact::set_references): <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
    /// - On success, responds with [`UpdateContactOutput`](crate::output::UpdateContactOutput)

    /// - On failure, responds with [`SdkError<UpdateContactError>`](crate::error::UpdateContactError)
    pub fn update_contact(&self) -> fluent_builders::UpdateContact<C, M, R> {
        fluent_builders::UpdateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactAttributes`](crate::client::fluent_builders::UpdateContactAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`initial_contact_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactAttributes::initial_contact_id) / [`set_initial_contact_id(Option<String>)`](crate::client::fluent_builders::UpdateContactAttributes::set_initial_contact_id): <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactAttributes::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContactAttributes::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`attributes(HashMap<String, String>)`](crate::client::fluent_builders::UpdateContactAttributes::attributes) / [`set_attributes(Option<HashMap<String, String>>)`](crate::client::fluent_builders::UpdateContactAttributes::set_attributes): <p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.</p>  <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
    /// - On success, responds with [`UpdateContactAttributesOutput`](crate::output::UpdateContactAttributesOutput)

    /// - On failure, responds with [`SdkError<UpdateContactAttributesError>`](crate::error::UpdateContactAttributesError)
    pub fn update_contact_attributes(&self) -> fluent_builders::UpdateContactAttributes<C, M, R> {
        fluent_builders::UpdateContactAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactFlowContent`](crate::client::fluent_builders::UpdateContactFlowContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowContent::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowContent::set_instance_id): <p>The identifier of the Amazon Connect instance.</p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowContent::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowContent::set_contact_flow_id): <p>The identifier of the contact flow.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowContent::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowContent::set_content): <p>The JSON string that represents contact flow’s content. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language-example.html">Example contact flow in Amazon Connect Flow language</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
    /// - On success, responds with [`UpdateContactFlowContentOutput`](crate::output::UpdateContactFlowContentOutput)

    /// - On failure, responds with [`SdkError<UpdateContactFlowContentError>`](crate::error::UpdateContactFlowContentError)
    pub fn update_contact_flow_content(
        &self,
    ) -> fluent_builders::UpdateContactFlowContent<C, M, R> {
        fluent_builders::UpdateContactFlowContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactFlowMetadata`](crate::client::fluent_builders::UpdateContactFlowMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::set_contact_flow_id): <p>The identifier of the contact flow.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::set_name): <p>The name of the contact flow.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::set_description): <p>The description of the contact flow.</p>
    ///   - [`contact_flow_state(ContactFlowState)`](crate::client::fluent_builders::UpdateContactFlowMetadata::contact_flow_state) / [`set_contact_flow_state(Option<ContactFlowState>)`](crate::client::fluent_builders::UpdateContactFlowMetadata::set_contact_flow_state): <p>The state of contact flow.</p>
    /// - On success, responds with [`UpdateContactFlowMetadataOutput`](crate::output::UpdateContactFlowMetadataOutput)

    /// - On failure, responds with [`SdkError<UpdateContactFlowMetadataError>`](crate::error::UpdateContactFlowMetadataError)
    pub fn update_contact_flow_metadata(
        &self,
    ) -> fluent_builders::UpdateContactFlowMetadata<C, M, R> {
        fluent_builders::UpdateContactFlowMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactFlowModuleContent`](crate::client::fluent_builders::UpdateContactFlowModuleContent) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleContent::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleContent::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_module_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleContent::contact_flow_module_id) / [`set_contact_flow_module_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleContent::set_contact_flow_module_id): <p>The identifier of the contact flow module.</p>
    ///   - [`content(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleContent::content) / [`set_content(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleContent::set_content): <p>The content of the contact flow module.</p>
    /// - On success, responds with [`UpdateContactFlowModuleContentOutput`](crate::output::UpdateContactFlowModuleContentOutput)

    /// - On failure, responds with [`SdkError<UpdateContactFlowModuleContentError>`](crate::error::UpdateContactFlowModuleContentError)
    pub fn update_contact_flow_module_content(
        &self,
    ) -> fluent_builders::UpdateContactFlowModuleContent<C, M, R> {
        fluent_builders::UpdateContactFlowModuleContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactFlowModuleMetadata`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_flow_module_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::contact_flow_module_id) / [`set_contact_flow_module_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::set_contact_flow_module_id): <p>The identifier of the contact flow module.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::set_name): <p>The name of the contact flow module.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::set_description): <p>The description of the contact flow module.</p>
    ///   - [`state(ContactFlowModuleState)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::state) / [`set_state(Option<ContactFlowModuleState>)`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata::set_state): <p>The state of contact flow module.</p>
    /// - On success, responds with [`UpdateContactFlowModuleMetadataOutput`](crate::output::UpdateContactFlowModuleMetadataOutput)

    /// - On failure, responds with [`SdkError<UpdateContactFlowModuleMetadataError>`](crate::error::UpdateContactFlowModuleMetadataError)
    pub fn update_contact_flow_module_metadata(
        &self,
    ) -> fluent_builders::UpdateContactFlowModuleMetadata<C, M, R> {
        fluent_builders::UpdateContactFlowModuleMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactFlowName`](crate::client::fluent_builders::UpdateContactFlowName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowName::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowName::set_instance_id): <p>The identifier of the Amazon Connect instance.</p>
    ///   - [`contact_flow_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowName::contact_flow_id) / [`set_contact_flow_id(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowName::set_contact_flow_id): <p>The identifier of the contact flow.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowName::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowName::set_name): <p>The name of the contact flow.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateContactFlowName::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateContactFlowName::set_description): <p>The description of the contact flow.</p>
    /// - On success, responds with [`UpdateContactFlowNameOutput`](crate::output::UpdateContactFlowNameOutput)

    /// - On failure, responds with [`SdkError<UpdateContactFlowNameError>`](crate::error::UpdateContactFlowNameError)
    pub fn update_contact_flow_name(&self) -> fluent_builders::UpdateContactFlowName<C, M, R> {
        fluent_builders::UpdateContactFlowName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateContactSchedule`](crate::client::fluent_builders::UpdateContactSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactSchedule::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateContactSchedule::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`contact_id(impl Into<String>)`](crate::client::fluent_builders::UpdateContactSchedule::contact_id) / [`set_contact_id(Option<String>)`](crate::client::fluent_builders::UpdateContactSchedule::set_contact_id): <p>The identifier of the contact.</p>
    ///   - [`scheduled_time(DateTime)`](crate::client::fluent_builders::UpdateContactSchedule::scheduled_time) / [`set_scheduled_time(Option<DateTime>)`](crate::client::fluent_builders::UpdateContactSchedule::set_scheduled_time): <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
    /// - On success, responds with [`UpdateContactScheduleOutput`](crate::output::UpdateContactScheduleOutput)

    /// - On failure, responds with [`SdkError<UpdateContactScheduleError>`](crate::error::UpdateContactScheduleError)
    pub fn update_contact_schedule(&self) -> fluent_builders::UpdateContactSchedule<C, M, R> {
        fluent_builders::UpdateContactSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateHoursOfOperation`](crate::client::fluent_builders::UpdateHoursOfOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`hours_of_operation_id(impl Into<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::hours_of_operation_id) / [`set_hours_of_operation_id(Option<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::set_hours_of_operation_id): <p>The identifier of the hours of operation.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::set_name): <p>The name of the hours of operation.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::set_description): <p>The description of the hours of operation.</p>
    ///   - [`time_zone(impl Into<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::time_zone) / [`set_time_zone(Option<String>)`](crate::client::fluent_builders::UpdateHoursOfOperation::set_time_zone): <p>The time zone of the hours of operation.</p>
    ///   - [`config(Vec<HoursOfOperationConfig>)`](crate::client::fluent_builders::UpdateHoursOfOperation::config) / [`set_config(Option<Vec<HoursOfOperationConfig>>)`](crate::client::fluent_builders::UpdateHoursOfOperation::set_config): <p>Configuration information of the hours of operation.</p>
    /// - On success, responds with [`UpdateHoursOfOperationOutput`](crate::output::UpdateHoursOfOperationOutput)

    /// - On failure, responds with [`SdkError<UpdateHoursOfOperationError>`](crate::error::UpdateHoursOfOperationError)
    pub fn update_hours_of_operation(&self) -> fluent_builders::UpdateHoursOfOperation<C, M, R> {
        fluent_builders::UpdateHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInstanceAttribute`](crate::client::fluent_builders::UpdateInstanceAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateInstanceAttribute::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateInstanceAttribute::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`attribute_type(InstanceAttributeType)`](crate::client::fluent_builders::UpdateInstanceAttribute::attribute_type) / [`set_attribute_type(Option<InstanceAttributeType>)`](crate::client::fluent_builders::UpdateInstanceAttribute::set_attribute_type): <p>The type of attribute.</p> <note>   <p>Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access this feature, contact Amazon Web Services Support for allowlisting.</p>  </note>
    ///   - [`value(impl Into<String>)`](crate::client::fluent_builders::UpdateInstanceAttribute::value) / [`set_value(Option<String>)`](crate::client::fluent_builders::UpdateInstanceAttribute::set_value): <p>The value for the attribute. Maximum character limit is 100. </p>
    /// - On success, responds with [`UpdateInstanceAttributeOutput`](crate::output::UpdateInstanceAttributeOutput)

    /// - On failure, responds with [`SdkError<UpdateInstanceAttributeError>`](crate::error::UpdateInstanceAttributeError)
    pub fn update_instance_attribute(&self) -> fluent_builders::UpdateInstanceAttribute<C, M, R> {
        fluent_builders::UpdateInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateInstanceStorageConfig`](crate::client::fluent_builders::UpdateInstanceStorageConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`association_id(impl Into<String>)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::association_id) / [`set_association_id(Option<String>)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::set_association_id): <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
    ///   - [`resource_type(InstanceStorageResourceType)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::resource_type) / [`set_resource_type(Option<InstanceStorageResourceType>)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::set_resource_type): <p>A valid resource type.</p>
    ///   - [`storage_config(InstanceStorageConfig)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::storage_config) / [`set_storage_config(Option<InstanceStorageConfig>)`](crate::client::fluent_builders::UpdateInstanceStorageConfig::set_storage_config): <p>The storage configuration for the instance.</p>
    /// - On success, responds with [`UpdateInstanceStorageConfigOutput`](crate::output::UpdateInstanceStorageConfigOutput)

    /// - On failure, responds with [`SdkError<UpdateInstanceStorageConfigError>`](crate::error::UpdateInstanceStorageConfigError)
    pub fn update_instance_storage_config(
        &self,
    ) -> fluent_builders::UpdateInstanceStorageConfig<C, M, R> {
        fluent_builders::UpdateInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQueueHoursOfOperation`](crate::client::fluent_builders::UpdateQueueHoursOfOperation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueHoursOfOperation::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueHoursOfOperation::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueHoursOfOperation::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueHoursOfOperation::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`hours_of_operation_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueHoursOfOperation::hours_of_operation_id) / [`set_hours_of_operation_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueHoursOfOperation::set_hours_of_operation_id): <p>The identifier for the hours of operation.</p>
    /// - On success, responds with [`UpdateQueueHoursOfOperationOutput`](crate::output::UpdateQueueHoursOfOperationOutput)

    /// - On failure, responds with [`SdkError<UpdateQueueHoursOfOperationError>`](crate::error::UpdateQueueHoursOfOperationError)
    pub fn update_queue_hours_of_operation(
        &self,
    ) -> fluent_builders::UpdateQueueHoursOfOperation<C, M, R> {
        fluent_builders::UpdateQueueHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQueueMaxContacts`](crate::client::fluent_builders::UpdateQueueMaxContacts) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueMaxContacts::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueMaxContacts::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueMaxContacts::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueMaxContacts::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`max_contacts(i32)`](crate::client::fluent_builders::UpdateQueueMaxContacts::max_contacts) / [`set_max_contacts(Option<i32>)`](crate::client::fluent_builders::UpdateQueueMaxContacts::set_max_contacts): <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
    /// - On success, responds with [`UpdateQueueMaxContactsOutput`](crate::output::UpdateQueueMaxContactsOutput)

    /// - On failure, responds with [`SdkError<UpdateQueueMaxContactsError>`](crate::error::UpdateQueueMaxContactsError)
    pub fn update_queue_max_contacts(&self) -> fluent_builders::UpdateQueueMaxContacts<C, M, R> {
        fluent_builders::UpdateQueueMaxContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQueueName`](crate::client::fluent_builders::UpdateQueueName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueName::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueName::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueName::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueName::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueName::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateQueueName::set_name): <p>The name of the queue.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueName::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateQueueName::set_description): <p>The description of the queue.</p>
    /// - On success, responds with [`UpdateQueueNameOutput`](crate::output::UpdateQueueNameOutput)

    /// - On failure, responds with [`SdkError<UpdateQueueNameError>`](crate::error::UpdateQueueNameError)
    pub fn update_queue_name(&self) -> fluent_builders::UpdateQueueName<C, M, R> {
        fluent_builders::UpdateQueueName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQueueOutboundCallerConfig`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`outbound_caller_config(OutboundCallerConfig)`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig::outbound_caller_config) / [`set_outbound_caller_config(Option<OutboundCallerConfig>)`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig::set_outbound_caller_config): <p>The outbound caller ID name, number, and outbound whisper flow.</p>
    /// - On success, responds with [`UpdateQueueOutboundCallerConfigOutput`](crate::output::UpdateQueueOutboundCallerConfigOutput)

    /// - On failure, responds with [`SdkError<UpdateQueueOutboundCallerConfigError>`](crate::error::UpdateQueueOutboundCallerConfigError)
    pub fn update_queue_outbound_caller_config(
        &self,
    ) -> fluent_builders::UpdateQueueOutboundCallerConfig<C, M, R> {
        fluent_builders::UpdateQueueOutboundCallerConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQueueStatus`](crate::client::fluent_builders::UpdateQueueStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueStatus::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueStatus::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`queue_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQueueStatus::queue_id) / [`set_queue_id(Option<String>)`](crate::client::fluent_builders::UpdateQueueStatus::set_queue_id): <p>The identifier for the queue.</p>
    ///   - [`status(QueueStatus)`](crate::client::fluent_builders::UpdateQueueStatus::status) / [`set_status(Option<QueueStatus>)`](crate::client::fluent_builders::UpdateQueueStatus::set_status): <p>The status of the queue.</p>
    /// - On success, responds with [`UpdateQueueStatusOutput`](crate::output::UpdateQueueStatusOutput)

    /// - On failure, responds with [`SdkError<UpdateQueueStatusError>`](crate::error::UpdateQueueStatusError)
    pub fn update_queue_status(&self) -> fluent_builders::UpdateQueueStatus<C, M, R> {
        fluent_builders::UpdateQueueStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQuickConnectConfig`](crate::client::fluent_builders::UpdateQuickConnectConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQuickConnectConfig::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateQuickConnectConfig::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`quick_connect_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQuickConnectConfig::quick_connect_id) / [`set_quick_connect_id(Option<String>)`](crate::client::fluent_builders::UpdateQuickConnectConfig::set_quick_connect_id): <p>The identifier for the quick connect.</p>
    ///   - [`quick_connect_config(QuickConnectConfig)`](crate::client::fluent_builders::UpdateQuickConnectConfig::quick_connect_config) / [`set_quick_connect_config(Option<QuickConnectConfig>)`](crate::client::fluent_builders::UpdateQuickConnectConfig::set_quick_connect_config): <p>Information about the configuration settings for the quick connect.</p>
    /// - On success, responds with [`UpdateQuickConnectConfigOutput`](crate::output::UpdateQuickConnectConfigOutput)

    /// - On failure, responds with [`SdkError<UpdateQuickConnectConfigError>`](crate::error::UpdateQuickConnectConfigError)
    pub fn update_quick_connect_config(
        &self,
    ) -> fluent_builders::UpdateQuickConnectConfig<C, M, R> {
        fluent_builders::UpdateQuickConnectConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateQuickConnectName`](crate::client::fluent_builders::UpdateQuickConnectName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`quick_connect_id(impl Into<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::quick_connect_id) / [`set_quick_connect_id(Option<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::set_quick_connect_id): <p>The identifier for the quick connect.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::set_name): <p>The name of the quick connect.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateQuickConnectName::set_description): <p>The description of the quick connect.</p>
    /// - On success, responds with [`UpdateQuickConnectNameOutput`](crate::output::UpdateQuickConnectNameOutput)

    /// - On failure, responds with [`SdkError<UpdateQuickConnectNameError>`](crate::error::UpdateQuickConnectNameError)
    pub fn update_quick_connect_name(&self) -> fluent_builders::UpdateQuickConnectName<C, M, R> {
        fluent_builders::UpdateQuickConnectName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoutingProfileConcurrency`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    ///   - [`media_concurrencies(Vec<MediaConcurrency>)`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency::media_concurrencies) / [`set_media_concurrencies(Option<Vec<MediaConcurrency>>)`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency::set_media_concurrencies): <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
    /// - On success, responds with [`UpdateRoutingProfileConcurrencyOutput`](crate::output::UpdateRoutingProfileConcurrencyOutput)

    /// - On failure, responds with [`SdkError<UpdateRoutingProfileConcurrencyError>`](crate::error::UpdateRoutingProfileConcurrencyError)
    pub fn update_routing_profile_concurrency(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileConcurrency<C, M, R> {
        fluent_builders::UpdateRoutingProfileConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoutingProfileDefaultOutboundQueue`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    ///   - [`default_outbound_queue_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::default_outbound_queue_id) / [`set_default_outbound_queue_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::set_default_outbound_queue_id): <p>The identifier for the default outbound queue.</p>
    /// - On success, responds with [`UpdateRoutingProfileDefaultOutboundQueueOutput`](crate::output::UpdateRoutingProfileDefaultOutboundQueueOutput)

    /// - On failure, responds with [`SdkError<UpdateRoutingProfileDefaultOutboundQueueError>`](crate::error::UpdateRoutingProfileDefaultOutboundQueueError)
    pub fn update_routing_profile_default_outbound_queue(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileDefaultOutboundQueue<C, M, R> {
        fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoutingProfileName`](crate::client::fluent_builders::UpdateRoutingProfileName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::set_name): <p>The name of the routing profile. Must not be more than 127 characters.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileName::set_description): <p>The description of the routing profile. Must not be more than 250 characters.</p>
    /// - On success, responds with [`UpdateRoutingProfileNameOutput`](crate::output::UpdateRoutingProfileNameOutput)

    /// - On failure, responds with [`SdkError<UpdateRoutingProfileNameError>`](crate::error::UpdateRoutingProfileNameError)
    pub fn update_routing_profile_name(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileName<C, M, R> {
        fluent_builders::UpdateRoutingProfileName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateRoutingProfileQueues`](crate::client::fluent_builders::UpdateRoutingProfileQueues) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileQueues::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileQueues::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateRoutingProfileQueues::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateRoutingProfileQueues::set_routing_profile_id): <p>The identifier of the routing profile.</p>
    ///   - [`queue_configs(Vec<RoutingProfileQueueConfig>)`](crate::client::fluent_builders::UpdateRoutingProfileQueues::queue_configs) / [`set_queue_configs(Option<Vec<RoutingProfileQueueConfig>>)`](crate::client::fluent_builders::UpdateRoutingProfileQueues::set_queue_configs): <p>The queues to be updated for this routing profile. Queues must first be associated to the routing profile. You can do this using AssociateRoutingProfileQueues.</p>
    /// - On success, responds with [`UpdateRoutingProfileQueuesOutput`](crate::output::UpdateRoutingProfileQueuesOutput)

    /// - On failure, responds with [`SdkError<UpdateRoutingProfileQueuesError>`](crate::error::UpdateRoutingProfileQueuesError)
    pub fn update_routing_profile_queues(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileQueues<C, M, R> {
        fluent_builders::UpdateRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateSecurityProfile`](crate::client::fluent_builders::UpdateSecurityProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_description): <p>The description of the security profile.</p>
    ///   - [`permissions(Vec<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::permissions) / [`set_permissions(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_permissions): <p>The permissions granted to a security profile.</p>
    ///   - [`security_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::security_profile_id) / [`set_security_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_security_profile_id): <p>The identifier for the security profle.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateSecurityProfile::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateSecurityProfileOutput`](crate::output::UpdateSecurityProfileOutput)

    /// - On failure, responds with [`SdkError<UpdateSecurityProfileError>`](crate::error::UpdateSecurityProfileError)
    pub fn update_security_profile(&self) -> fluent_builders::UpdateSecurityProfile<C, M, R> {
        fluent_builders::UpdateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserHierarchy`](crate::client::fluent_builders::UpdateUserHierarchy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hierarchy_group_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserHierarchy::hierarchy_group_id) / [`set_hierarchy_group_id(Option<String>)`](crate::client::fluent_builders::UpdateUserHierarchy::set_hierarchy_group_id): <p>The identifier of the hierarchy group.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserHierarchy::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUserHierarchy::set_user_id): <p>The identifier of the user account.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserHierarchy::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateUserHierarchy::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateUserHierarchyOutput`](crate::output::UpdateUserHierarchyOutput)

    /// - On failure, responds with [`SdkError<UpdateUserHierarchyError>`](crate::error::UpdateUserHierarchyError)
    pub fn update_user_hierarchy(&self) -> fluent_builders::UpdateUserHierarchy<C, M, R> {
        fluent_builders::UpdateUserHierarchy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserHierarchyGroupName`](crate::client::fluent_builders::UpdateUserHierarchyGroupName) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateUserHierarchyGroupName::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateUserHierarchyGroupName::set_name): <p>The name of the hierarchy group. Must not be more than 100 characters.</p>
    ///   - [`hierarchy_group_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserHierarchyGroupName::hierarchy_group_id) / [`set_hierarchy_group_id(Option<String>)`](crate::client::fluent_builders::UpdateUserHierarchyGroupName::set_hierarchy_group_id): <p>The identifier of the hierarchy group.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserHierarchyGroupName::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateUserHierarchyGroupName::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateUserHierarchyGroupNameOutput`](crate::output::UpdateUserHierarchyGroupNameOutput)

    /// - On failure, responds with [`SdkError<UpdateUserHierarchyGroupNameError>`](crate::error::UpdateUserHierarchyGroupNameError)
    pub fn update_user_hierarchy_group_name(
        &self,
    ) -> fluent_builders::UpdateUserHierarchyGroupName<C, M, R> {
        fluent_builders::UpdateUserHierarchyGroupName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserHierarchyStructure`](crate::client::fluent_builders::UpdateUserHierarchyStructure) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hierarchy_structure(HierarchyStructureUpdate)`](crate::client::fluent_builders::UpdateUserHierarchyStructure::hierarchy_structure) / [`set_hierarchy_structure(Option<HierarchyStructureUpdate>)`](crate::client::fluent_builders::UpdateUserHierarchyStructure::set_hierarchy_structure): <p>The hierarchy levels to update.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserHierarchyStructure::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateUserHierarchyStructure::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateUserHierarchyStructureOutput`](crate::output::UpdateUserHierarchyStructureOutput)

    /// - On failure, responds with [`SdkError<UpdateUserHierarchyStructureError>`](crate::error::UpdateUserHierarchyStructureError)
    pub fn update_user_hierarchy_structure(
        &self,
    ) -> fluent_builders::UpdateUserHierarchyStructure<C, M, R> {
        fluent_builders::UpdateUserHierarchyStructure::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserIdentityInfo`](crate::client::fluent_builders::UpdateUserIdentityInfo) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identity_info(UserIdentityInfo)`](crate::client::fluent_builders::UpdateUserIdentityInfo::identity_info) / [`set_identity_info(Option<UserIdentityInfo>)`](crate::client::fluent_builders::UpdateUserIdentityInfo::set_identity_info): <p>The identity information for the user.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserIdentityInfo::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUserIdentityInfo::set_user_id): <p>The identifier of the user account.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserIdentityInfo::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateUserIdentityInfo::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateUserIdentityInfoOutput`](crate::output::UpdateUserIdentityInfoOutput)

    /// - On failure, responds with [`SdkError<UpdateUserIdentityInfoError>`](crate::error::UpdateUserIdentityInfoError)
    pub fn update_user_identity_info(&self) -> fluent_builders::UpdateUserIdentityInfo<C, M, R> {
        fluent_builders::UpdateUserIdentityInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserPhoneConfig`](crate::client::fluent_builders::UpdateUserPhoneConfig) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`phone_config(UserPhoneConfig)`](crate::client::fluent_builders::UpdateUserPhoneConfig::phone_config) / [`set_phone_config(Option<UserPhoneConfig>)`](crate::client::fluent_builders::UpdateUserPhoneConfig::set_phone_config): <p>Information about phone configuration settings for the user.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPhoneConfig::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUserPhoneConfig::set_user_id): <p>The identifier of the user account.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserPhoneConfig::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateUserPhoneConfig::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateUserPhoneConfigOutput`](crate::output::UpdateUserPhoneConfigOutput)

    /// - On failure, responds with [`SdkError<UpdateUserPhoneConfigError>`](crate::error::UpdateUserPhoneConfigError)
    pub fn update_user_phone_config(&self) -> fluent_builders::UpdateUserPhoneConfig<C, M, R> {
        fluent_builders::UpdateUserPhoneConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserRoutingProfile`](crate::client::fluent_builders::UpdateUserRoutingProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`routing_profile_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserRoutingProfile::routing_profile_id) / [`set_routing_profile_id(Option<String>)`](crate::client::fluent_builders::UpdateUserRoutingProfile::set_routing_profile_id): <p>The identifier of the routing profile for the user.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserRoutingProfile::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUserRoutingProfile::set_user_id): <p>The identifier of the user account.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserRoutingProfile::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateUserRoutingProfile::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateUserRoutingProfileOutput`](crate::output::UpdateUserRoutingProfileOutput)

    /// - On failure, responds with [`SdkError<UpdateUserRoutingProfileError>`](crate::error::UpdateUserRoutingProfileError)
    pub fn update_user_routing_profile(
        &self,
    ) -> fluent_builders::UpdateUserRoutingProfile<C, M, R> {
        fluent_builders::UpdateUserRoutingProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateUserSecurityProfiles`](crate::client::fluent_builders::UpdateUserSecurityProfiles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`security_profile_ids(Vec<String>)`](crate::client::fluent_builders::UpdateUserSecurityProfiles::security_profile_ids) / [`set_security_profile_ids(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateUserSecurityProfiles::set_security_profile_ids): <p>The identifiers of the security profiles for the user.</p>
    ///   - [`user_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserSecurityProfiles::user_id) / [`set_user_id(Option<String>)`](crate::client::fluent_builders::UpdateUserSecurityProfiles::set_user_id): <p>The identifier of the user account.</p>
    ///   - [`instance_id(impl Into<String>)`](crate::client::fluent_builders::UpdateUserSecurityProfiles::instance_id) / [`set_instance_id(Option<String>)`](crate::client::fluent_builders::UpdateUserSecurityProfiles::set_instance_id): <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
    /// - On success, responds with [`UpdateUserSecurityProfilesOutput`](crate::output::UpdateUserSecurityProfilesOutput)

    /// - On failure, responds with [`SdkError<UpdateUserSecurityProfilesError>`](crate::error::UpdateUserSecurityProfilesError)
    pub fn update_user_security_profiles(
        &self,
    ) -> fluent_builders::UpdateUserSecurityProfiles<C, M, R> {
        fluent_builders::UpdateUserSecurityProfiles::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateApprovedOrigin`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates an approved origin to an Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateApprovedOrigin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_approved_origin_input::Builder,
    }
    impl<C, M, R> AssociateApprovedOrigin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateApprovedOrigin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateApprovedOriginOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateApprovedOriginError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateApprovedOriginInputOperationOutputAlias,
                crate::output::AssociateApprovedOriginOutput,
                crate::error::AssociateApprovedOriginError,
                crate::input::AssociateApprovedOriginInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The domain to add to your allow list.</p>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin(input.into());
            self
        }
        /// <p>The domain to add to your allow list.</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_bot_input::Builder,
    }
    impl<C, M, R> AssociateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateBotInputOperationOutputAlias,
                crate::output::AssociateBotOutput,
                crate::error::AssociateBotError,
                crate::input::AssociateBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn lex_bot(mut self, input: crate::model::LexBot) -> Self {
            self.inner = self.inner.lex_bot(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.inner = self.inner.set_lex_bot(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to associate with the instance.</p>
        pub fn lex_v2_bot(mut self, input: crate::model::LexV2Bot) -> Self {
            self.inner = self.inner.lex_v2_bot(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to associate with the instance.</p>
        pub fn set_lex_v2_bot(
            mut self,
            input: std::option::Option<crate::model::LexV2Bot>,
        ) -> Self {
            self.inner = self.inner.set_lex_v2_bot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDefaultVocabulary`.
    ///
    /// <p>Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDefaultVocabulary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_default_vocabulary_input::Builder,
    }
    impl<C, M, R> AssociateDefaultVocabulary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDefaultVocabulary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDefaultVocabularyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDefaultVocabularyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDefaultVocabularyInputOperationOutputAlias,
                crate::output::AssociateDefaultVocabularyOutput,
                crate::error::AssociateDefaultVocabularyError,
                crate::input::AssociateDefaultVocabularyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>The identifier of the custom vocabulary. If this is empty, the default is set to none.</p>
        pub fn vocabulary_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_id(input.into());
            self
        }
        /// <p>The identifier of the custom vocabulary. If this is empty, the default is set to none.</p>
        pub fn set_vocabulary_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts.</p>
    /// <p>This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_instance_storage_config_input::Builder,
    }
    impl<C, M, R> AssociateInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateInstanceStorageConfigInputOperationOutputAlias,
                crate::output::AssociateInstanceStorageConfigOutput,
                crate::error::AssociateInstanceStorageConfigError,
                crate::input::AssociateInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>A valid storage type.</p>
        pub fn storage_config(mut self, input: crate::model::InstanceStorageConfig) -> Self {
            self.inner = self.inner.storage_config(input);
            self
        }
        /// <p>A valid storage type.</p>
        pub fn set_storage_config(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageConfig>,
        ) -> Self {
            self.inner = self.inner.set_storage_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateLambdaFunction`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Allows the specified Amazon Connect instance to access the specified Lambda function.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateLambdaFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_lambda_function_input::Builder,
    }
    impl<C, M, R> AssociateLambdaFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLambdaFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLambdaFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLambdaFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLambdaFunctionInputOperationOutputAlias,
                crate::output::AssociateLambdaFunctionOutput,
                crate::error::AssociateLambdaFunctionError,
                crate::input::AssociateLambdaFunctionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateLexBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateLexBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_lex_bot_input::Builder,
    }
    impl<C, M, R> AssociateLexBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLexBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLexBotOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLexBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLexBotInputOperationOutputAlias,
                crate::output::AssociateLexBotOutput,
                crate::error::AssociateLexBotError,
                crate::input::AssociateLexBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The Amazon Lex bot to associate with the instance.</p>
        pub fn lex_bot(mut self, input: crate::model::LexBot) -> Self {
            self.inner = self.inner.lex_bot(input);
            self
        }
        /// <p>The Amazon Lex bot to associate with the instance.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.inner = self.inner.set_lex_bot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateQueueQuickConnects`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates a set of quick connects with a queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateQueueQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_queue_quick_connects_input::Builder,
    }
    impl<C, M, R> AssociateQueueQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateQueueQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateQueueQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateQueueQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateQueueQuickConnectsInputOperationOutputAlias,
                crate::output::AssociateQueueQuickConnectsOutput,
                crate::error::AssociateQueueQuickConnectsError,
                crate::input::AssociateQueueQuickConnectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// Appends an item to `QuickConnectIds`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects to associate with this queue.</p>
        pub fn quick_connect_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_ids(input.into());
            self
        }
        /// <p>The quick connects to associate with this queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateRoutingProfileQueues`.
    ///
    /// <p>Associates a set of queues with a routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> AssociateRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::AssociateRoutingProfileQueuesOutput,
                crate::error::AssociateRoutingProfileQueuesError,
                crate::input::AssociateRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `QueueConfigs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The queues to associate with this routing profile.</p>
        pub fn queue_configs(mut self, input: crate::model::RoutingProfileQueueConfig) -> Self {
            self.inner = self.inner.queue_configs(input);
            self
        }
        /// <p>The queues to associate with this routing profile.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.inner = self.inner.set_queue_configs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSecurityKey`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates a security key to the instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateSecurityKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_security_key_input::Builder,
    }
    impl<C, M, R> AssociateSecurityKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSecurityKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSecurityKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSecurityKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSecurityKeyInputOperationOutputAlias,
                crate::output::AssociateSecurityKeyOutput,
                crate::error::AssociateSecurityKeyError,
                crate::input::AssociateSecurityKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A valid security key in PEM format.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(input.into());
            self
        }
        /// <p>A valid security key in PEM format.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAgentStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates an agent status for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAgentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_agent_status_input::Builder,
    }
    impl<C, M, R> CreateAgentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAgentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAgentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAgentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAgentStatusInputOperationOutputAlias,
                crate::output::CreateAgentStatusOutput,
                crate::error::CreateAgentStatusError,
                crate::input::CreateAgentStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the status.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the status.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of the status.</p>
        pub fn state(mut self, input: crate::model::AgentStatusState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the status.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AgentStatusState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The display order of the status.</p>
        pub fn display_order(mut self, input: i32) -> Self {
            self.inner = self.inner.display_order(input);
            self
        }
        /// <p>The display order of the status.</p>
        pub fn set_display_order(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_display_order(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactFlow`.
    ///
    /// <p>Creates a contact flow for the specified Amazon Connect instance.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContactFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_flow_input::Builder,
    }
    impl<C, M, R> CreateContactFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactFlowInputOperationOutputAlias,
                crate::output::CreateContactFlowOutput,
                crate::error::CreateContactFlowError,
                crate::input::CreateContactFlowInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn r#type(mut self, input: crate::model::ContactFlowType) -> Self {
            self.inner = self.inner.r#type(input);
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ContactFlowType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The description of the contact flow. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the contact flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The content of the contact flow. </p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the contact flow. </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactFlowModule`.
    ///
    /// <p>Creates a contact flow module for the specified Amazon Connect instance. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateContactFlowModule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_flow_module_input::Builder,
    }
    impl<C, M, R> CreateContactFlowModule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactFlowModule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactFlowModuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactFlowModuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactFlowModuleInputOperationOutputAlias,
                crate::output::CreateContactFlowModuleOutput,
                crate::error::CreateContactFlowModuleError,
                crate::input::CreateContactFlowModuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow module. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the contact flow module. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates hours of operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hours_of_operation_input::Builder,
    }
    impl<C, M, R> CreateHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHoursOfOperationInputOperationOutputAlias,
                crate::output::CreateHoursOfOperationOutput,
                crate::error::CreateHoursOfOperationError,
                crate::input::CreateHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_zone(input.into());
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_zone(input);
            self
        }
        /// Appends an item to `Config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>Configuration information for the hours of operation: day, start time, and end time.</p>
        pub fn config(mut self, input: crate::model::HoursOfOperationConfig) -> Self {
            self.inner = self.inner.config(input);
            self
        }
        /// <p>Configuration information for the hours of operation: day, start time, and end time.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstance`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect. </p>
    /// <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_input::Builder,
    }
    impl<C, M, R> CreateInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstanceInputOperationOutputAlias,
                crate::output::CreateInstanceOutput,
                crate::error::CreateInstanceError,
                crate::input::CreateInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>The idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The type of identity management for your Amazon Connect users.</p>
        pub fn identity_management_type(mut self, input: crate::model::DirectoryType) -> Self {
            self.inner = self.inner.identity_management_type(input);
            self
        }
        /// <p>The type of identity management for your Amazon Connect users.</p>
        pub fn set_identity_management_type(
            mut self,
            input: std::option::Option<crate::model::DirectoryType>,
        ) -> Self {
            self.inner = self.inner.set_identity_management_type(input);
            self
        }
        /// <p>The name for your instance.</p>
        pub fn instance_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_alias(input.into());
            self
        }
        /// <p>The name for your instance.</p>
        pub fn set_instance_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_alias(input);
            self
        }
        /// <p>The identifier for the directory.</p>
        pub fn directory_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(input.into());
            self
        }
        /// <p>The identifier for the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>Your contact center handles incoming contacts.</p>
        pub fn inbound_calls_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.inbound_calls_enabled(input);
            self
        }
        /// <p>Your contact center handles incoming contacts.</p>
        pub fn set_inbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_inbound_calls_enabled(input);
            self
        }
        /// <p>Your contact center allows outbound calls.</p>
        pub fn outbound_calls_enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.outbound_calls_enabled(input);
            self
        }
        /// <p>Your contact center allows outbound calls.</p>
        pub fn set_outbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_outbound_calls_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntegrationAssociation`.
    ///
    /// <p>Creates an Amazon Web Services resource association with an Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateIntegrationAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_integration_association_input::Builder,
    }
    impl<C, M, R> CreateIntegrationAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIntegrationAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntegrationAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntegrationAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIntegrationAssociationInputOperationOutputAlias,
                crate::output::CreateIntegrationAssociationOutput,
                crate::error::CreateIntegrationAssociationError,
                crate::input::CreateIntegrationAssociationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of information to be ingested.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(input);
            self
        }
        /// <p>The type of information to be ingested.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the integration.</p>
        pub fn integration_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the integration.</p>
        pub fn set_integration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_arn(input);
            self
        }
        /// <p>The URL for the external application. This field is only required for the EVENT integration type.</p>
        pub fn source_application_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_application_url(input.into());
            self
        }
        /// <p>The URL for the external application. This field is only required for the EVENT integration type.</p>
        pub fn set_source_application_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_application_url(input);
            self
        }
        /// <p>The name of the external application. This field is only required for the EVENT integration type.</p>
        pub fn source_application_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_application_name(input.into());
            self
        }
        /// <p>The name of the external application. This field is only required for the EVENT integration type.</p>
        pub fn set_source_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_application_name(input);
            self
        }
        /// <p>The type of the data source. This field is only required for the EVENT integration type.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>The type of the data source. This field is only required for the EVENT integration type.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQueue`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates a new queue for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_queue_input::Builder,
    }
    impl<C, M, R> CreateQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQueueInputOperationOutputAlias,
                crate::output::CreateQueueOutput,
                crate::error::CreateQueueError,
                crate::input::CreateQueueInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the queue.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the queue.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the queue.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn outbound_caller_config(mut self, input: crate::model::OutboundCallerConfig) -> Self {
            self.inner = self.inner.outbound_caller_config(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn set_outbound_caller_config(
            mut self,
            input: std::option::Option<crate::model::OutboundCallerConfig>,
        ) -> Self {
            self.inner = self.inner.set_outbound_caller_config(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn max_contacts(mut self, input: i32) -> Self {
            self.inner = self.inner.max_contacts(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn set_max_contacts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_contacts(input);
            self
        }
        /// Appends an item to `QuickConnectIds`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects available to agents who are working the queue.</p>
        pub fn quick_connect_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_ids(input.into());
            self
        }
        /// <p>The quick connects available to agents who are working the queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_ids(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQuickConnect`.
    ///
    /// <p>Creates a quick connect for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateQuickConnect<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_quick_connect_input::Builder,
    }
    impl<C, M, R> CreateQuickConnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQuickConnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQuickConnectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQuickConnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQuickConnectInputOperationOutputAlias,
                crate::output::CreateQuickConnectOutput,
                crate::error::CreateQuickConnectError,
                crate::input::CreateQuickConnectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Configuration settings for the quick connect.</p>
        pub fn quick_connect_config(mut self, input: crate::model::QuickConnectConfig) -> Self {
            self.inner = self.inner.quick_connect_config(input);
            self
        }
        /// <p>Configuration settings for the quick connect.</p>
        pub fn set_quick_connect_config(
            mut self,
            input: std::option::Option<crate::model::QuickConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoutingProfile`.
    ///
    /// <p>Creates a new routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRoutingProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_routing_profile_input::Builder,
    }
    impl<C, M, R> CreateRoutingProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoutingProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoutingProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoutingProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoutingProfileInputOperationOutputAlias,
                crate::output::CreateRoutingProfileOutput,
                crate::error::CreateRoutingProfileError,
                crate::input::CreateRoutingProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Description of the routing profile. Must not be more than 250 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>Description of the routing profile. Must not be more than 250 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The default outbound queue for the routing profile.</p>
        pub fn default_outbound_queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_outbound_queue_id(input.into());
            self
        }
        /// <p>The default outbound queue for the routing profile.</p>
        pub fn set_default_outbound_queue_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_outbound_queue_id(input);
            self
        }
        /// Appends an item to `QueueConfigs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.</p>
        pub fn queue_configs(mut self, input: crate::model::RoutingProfileQueueConfig) -> Self {
            self.inner = self.inner.queue_configs(input);
            self
        }
        /// <p>The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.inner = self.inner.set_queue_configs(input);
            self
        }
        /// Appends an item to `MediaConcurrencies`.
        ///
        /// To override the contents of this collection use [`set_media_concurrencies`](Self::set_media_concurrencies).
        ///
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>
        pub fn media_concurrencies(mut self, input: crate::model::MediaConcurrency) -> Self {
            self.inner = self.inner.media_concurrencies(input);
            self
        }
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>
        pub fn set_media_concurrencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        ) -> Self {
            self.inner = self.inner.set_media_concurrencies(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates a security profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_security_profile_input::Builder,
    }
    impl<C, M, R> CreateSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSecurityProfileInputOperationOutputAlias,
                crate::output::CreateSecurityProfileOutput,
                crate::error::CreateSecurityProfileError,
                crate::input::CreateSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security profile.</p>
        pub fn security_profile_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(input.into());
            self
        }
        /// <p>The name of the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Permissions assigned to the security profile.</p>
        pub fn permissions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions(input.into());
            self
        }
        /// <p>Permissions assigned to the security profile.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUseCase`.
    ///
    /// <p>Creates a use case for an integration association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUseCase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_use_case_input::Builder,
    }
    impl<C, M, R> CreateUseCase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUseCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUseCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUseCaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUseCaseInputOperationOutputAlias,
                crate::output::CreateUseCaseOutput,
                crate::error::CreateUseCaseError,
                crate::input::CreateUseCaseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>
        pub fn use_case_type(mut self, input: crate::model::UseCaseType) -> Self {
            self.inner = self.inner.use_case_type(input);
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>
        pub fn set_use_case_type(
            mut self,
            input: std::option::Option<crate::model::UseCaseType>,
        ) -> Self {
            self.inner = self.inner.set_use_case_type(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user account for the specified Amazon Connect instance.</p>
    /// <p>For information about how to create user accounts using the Amazon Connect console, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.</p>
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(input.into());
            self
        }
        /// <p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>
        pub fn password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(input.into());
            self
        }
        /// <p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The information about the identity of the user.</p>
        pub fn identity_info(mut self, input: crate::model::UserIdentityInfo) -> Self {
            self.inner = self.inner.identity_info(input);
            self
        }
        /// <p>The information about the identity of the user.</p>
        pub fn set_identity_info(
            mut self,
            input: std::option::Option<crate::model::UserIdentityInfo>,
        ) -> Self {
            self.inner = self.inner.set_identity_info(input);
            self
        }
        /// <p>The phone settings for the user.</p>
        pub fn phone_config(mut self, input: crate::model::UserPhoneConfig) -> Self {
            self.inner = self.inner.phone_config(input);
            self
        }
        /// <p>The phone settings for the user.</p>
        pub fn set_phone_config(
            mut self,
            input: std::option::Option<crate::model::UserPhoneConfig>,
        ) -> Self {
            self.inner = self.inner.set_phone_config(input);
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p>
        /// <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>
        pub fn directory_user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_user_id(input.into());
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p>
        /// <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>
        pub fn set_directory_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_user_id(input);
            self
        }
        /// Appends an item to `SecurityProfileIds`.
        ///
        /// To override the contents of this collection use [`set_security_profile_ids`](Self::set_security_profile_ids).
        ///
        /// <p>The identifier of the security profile for the user.</p>
        pub fn security_profile_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_ids(input.into());
            self
        }
        /// <p>The identifier of the security profile for the user.</p>
        pub fn set_security_profile_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_ids(input);
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserHierarchyGroup`.
    ///
    /// <p>Creates a new user hierarchy group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUserHierarchyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_hierarchy_group_input::Builder,
    }
    impl<C, M, R> CreateUserHierarchyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserHierarchyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserHierarchyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserHierarchyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserHierarchyGroupInputOperationOutputAlias,
                crate::output::CreateUserHierarchyGroupOutput,
                crate::error::CreateUserHierarchyGroupError,
                crate::input::CreateUserHierarchyGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user hierarchy group. Must not be more than 100 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the user hierarchy group. Must not be more than 100 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.</p>
        pub fn parent_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_group_id(input.into());
            self
        }
        /// <p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.</p>
        pub fn set_parent_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateVocabulary`.
    ///
    /// <p>Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateVocabulary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_vocabulary_input::Builder,
    }
    impl<C, M, R> CreateVocabulary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateVocabulary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateVocabularyOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateVocabularyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateVocabularyInputOperationOutputAlias,
                crate::output::CreateVocabularyOutput,
                crate::error::CreateVocabularyError,
                crate::input::CreateVocabularyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If a create request is received more than once with same client token, subsequent requests return the previous response without creating a vocabulary again.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If a create request is received more than once with same client token, subsequent requests return the previous response without creating a vocabulary again.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A unique name of the custom vocabulary.</p>
        pub fn vocabulary_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_name(input.into());
            self
        }
        /// <p>A unique name of the custom vocabulary.</p>
        pub fn set_vocabulary_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_name(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with <code>Phrase</code>, <code>IPA</code>, <code>SoundsLike</code>, and <code>DisplayAs</code> fields. Separate the fields with TAB characters. The size limit is 50KB. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table">Create a custom vocabulary using a table</a>.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with <code>Phrase</code>, <code>IPA</code>, <code>SoundsLike</code>, and <code>DisplayAs</code> fields. Separate the fields with TAB characters. The size limit is 50KB. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table">Create a custom vocabulary using a table</a>.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactFlow`.
    ///
    /// <p>Deletes a contact flow for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContactFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_flow_input::Builder,
    }
    impl<C, M, R> DeleteContactFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactFlowInputOperationOutputAlias,
                crate::output::DeleteContactFlowOutput,
                crate::error::DeleteContactFlowError,
                crate::input::DeleteContactFlowInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactFlowModule`.
    ///
    /// <p>Deletes the specified contact flow module.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteContactFlowModule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_flow_module_input::Builder,
    }
    impl<C, M, R> DeleteContactFlowModule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactFlowModule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactFlowModuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactFlowModuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactFlowModuleInputOperationOutputAlias,
                crate::output::DeleteContactFlowModuleOutput,
                crate::error::DeleteContactFlowModuleError,
                crate::input::DeleteContactFlowModuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes an hours of operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hours_of_operation_input::Builder,
    }
    impl<C, M, R> DeleteHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHoursOfOperationInputOperationOutputAlias,
                crate::output::DeleteHoursOfOperationOutput,
                crate::error::DeleteHoursOfOperationError,
                crate::input::DeleteHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstance`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes the Amazon Connect instance.</p>
    /// <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_instance_input::Builder,
    }
    impl<C, M, R> DeleteInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInstanceInputOperationOutputAlias,
                crate::output::DeleteInstanceOutput,
                crate::error::DeleteInstanceError,
                crate::input::DeleteInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegrationAssociation`.
    ///
    /// <p>Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteIntegrationAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_association_input::Builder,
    }
    impl<C, M, R> DeleteIntegrationAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegrationAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationAssociationInputOperationOutputAlias,
                crate::output::DeleteIntegrationAssociationOutput,
                crate::error::DeleteIntegrationAssociationError,
                crate::input::DeleteIntegrationAssociationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQuickConnect`.
    ///
    /// <p>Deletes a quick connect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteQuickConnect<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_quick_connect_input::Builder,
    }
    impl<C, M, R> DeleteQuickConnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQuickConnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQuickConnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQuickConnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQuickConnectInputOperationOutputAlias,
                crate::output::DeleteQuickConnectOutput,
                crate::error::DeleteQuickConnectError,
                crate::input::DeleteQuickConnectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes a security profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_security_profile_input::Builder,
    }
    impl<C, M, R> DeleteSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSecurityProfileInputOperationOutputAlias,
                crate::output::DeleteSecurityProfileOutput,
                crate::error::DeleteSecurityProfileError,
                crate::input::DeleteSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(input.into());
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUseCase`.
    ///
    /// <p>Deletes a use case from an integration association.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUseCase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_use_case_input::Builder,
    }
    impl<C, M, R> DeleteUseCase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUseCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUseCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUseCaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUseCaseInputOperationOutputAlias,
                crate::output::DeleteUseCaseOutput,
                crate::error::DeleteUseCaseError,
                crate::input::DeleteUseCaseInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
        /// <p>The identifier for the use case.</p>
        pub fn use_case_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.use_case_id(input.into());
            self
        }
        /// <p>The identifier for the use case.</p>
        pub fn set_use_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_use_case_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user account from the specified Amazon Connect instance.</p>
    /// <p>For information about what happens to a user's data when their account is deleted, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserHierarchyGroup`.
    ///
    /// <p>Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUserHierarchyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_hierarchy_group_input::Builder,
    }
    impl<C, M, R> DeleteUserHierarchyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserHierarchyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserHierarchyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserHierarchyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserHierarchyGroupInputOperationOutputAlias,
                crate::output::DeleteUserHierarchyGroupOutput,
                crate::error::DeleteUserHierarchyGroupError,
                crate::input::DeleteUserHierarchyGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteVocabulary`.
    ///
    /// <p>Deletes the vocabulary that has the given identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteVocabulary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_vocabulary_input::Builder,
    }
    impl<C, M, R> DeleteVocabulary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteVocabulary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteVocabularyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteVocabularyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteVocabularyInputOperationOutputAlias,
                crate::output::DeleteVocabularyOutput,
                crate::error::DeleteVocabularyError,
                crate::input::DeleteVocabularyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn vocabulary_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_id(input.into());
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn set_vocabulary_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAgentStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes an agent status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAgentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_agent_status_input::Builder,
    }
    impl<C, M, R> DescribeAgentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAgentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAgentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAgentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAgentStatusInputOperationOutputAlias,
                crate::output::DescribeAgentStatusOutput,
                crate::error::DescribeAgentStatusError,
                crate::input::DescribeAgentStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the agent status.</p>
        pub fn agent_status_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_status_id(input.into());
            self
        }
        /// <p>The identifier for the agent status.</p>
        pub fn set_agent_status_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_agent_status_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContact`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the specified contact. </p> <important>
    /// <p>Contact information remains available in Amazon Connect for 24 months, and then it is deleted.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contact_input::Builder,
    }
    impl<C, M, R> DescribeContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContactInputOperationOutputAlias,
                crate::output::DescribeContactOutput,
                crate::error::DescribeContactError,
                crate::input::DescribeContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContactFlow`.
    ///
    /// <p>Describes the specified contact flow.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContactFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contact_flow_input::Builder,
    }
    impl<C, M, R> DescribeContactFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContactFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContactFlowInputOperationOutputAlias,
                crate::output::DescribeContactFlowOutput,
                crate::error::DescribeContactFlowError,
                crate::input::DescribeContactFlowInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContactFlowModule`.
    ///
    /// <p>Describes the specified contact flow module.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeContactFlowModule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contact_flow_module_input::Builder,
    }
    impl<C, M, R> DescribeContactFlowModule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContactFlowModule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactFlowModuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactFlowModuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContactFlowModuleInputOperationOutputAlias,
                crate::output::DescribeContactFlowModuleOutput,
                crate::error::DescribeContactFlowModuleError,
                crate::input::DescribeContactFlowModuleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the hours of operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hours_of_operation_input::Builder,
    }
    impl<C, M, R> DescribeHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHoursOfOperationInputOperationOutputAlias,
                crate::output::DescribeHoursOfOperationOutput,
                crate::error::DescribeHoursOfOperationError,
                crate::input::DescribeHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstance`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable. </p>
    /// <p>If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_input::Builder,
    }
    impl<C, M, R> DescribeInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceInputOperationOutputAlias,
                crate::output::DescribeInstanceOutput,
                crate::error::DescribeInstanceError,
                crate::input::DescribeInstanceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceAttribute`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the specified instance attribute.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstanceAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_attribute_input::Builder,
    }
    impl<C, M, R> DescribeInstanceAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceAttributeInputOperationOutputAlias,
                crate::output::DescribeInstanceAttributeOutput,
                crate::error::DescribeInstanceAttributeError,
                crate::input::DescribeInstanceAttributeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of attribute.</p>
        pub fn attribute_type(mut self, input: crate::model::InstanceAttributeType) -> Self {
            self.inner = self.inner.attribute_type(input);
            self
        }
        /// <p>The type of attribute.</p>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::InstanceAttributeType>,
        ) -> Self {
            self.inner = self.inner.set_attribute_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_storage_config_input::Builder,
    }
    impl<C, M, R> DescribeInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceStorageConfigInputOperationOutputAlias,
                crate::output::DescribeInstanceStorageConfigOutput,
                crate::error::DescribeInstanceStorageConfigError,
                crate::input::DescribeInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQueue`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the specified queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_queue_input::Builder,
    }
    impl<C, M, R> DescribeQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeQueueInputOperationOutputAlias,
                crate::output::DescribeQueueOutput,
                crate::error::DescribeQueueError,
                crate::input::DescribeQueueInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQuickConnect`.
    ///
    /// <p>Describes the quick connect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeQuickConnect<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_quick_connect_input::Builder,
    }
    impl<C, M, R> DescribeQuickConnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeQuickConnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQuickConnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQuickConnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeQuickConnectInputOperationOutputAlias,
                crate::output::DescribeQuickConnectOutput,
                crate::error::DescribeQuickConnectError,
                crate::input::DescribeQuickConnectInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRoutingProfile`.
    ///
    /// <p>Describes the specified routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeRoutingProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_routing_profile_input::Builder,
    }
    impl<C, M, R> DescribeRoutingProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRoutingProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRoutingProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRoutingProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRoutingProfileInputOperationOutputAlias,
                crate::output::DescribeRoutingProfileOutput,
                crate::error::DescribeRoutingProfileError,
                crate::input::DescribeRoutingProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Gets basic information about the security profle.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_security_profile_input::Builder,
    }
    impl<C, M, R> DescribeSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSecurityProfileInputOperationOutputAlias,
                crate::output::DescribeSecurityProfileOutput,
                crate::error::DescribeSecurityProfileError,
                crate::input::DescribeSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(input.into());
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Describes the specified user account. You can find the instance ID in the console (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl<C, M, R> DescribeUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserInputOperationOutputAlias,
                crate::output::DescribeUserOutput,
                crate::error::DescribeUserError,
                crate::input::DescribeUserInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserHierarchyGroup`.
    ///
    /// <p>Describes the specified hierarchy group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserHierarchyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_hierarchy_group_input::Builder,
    }
    impl<C, M, R> DescribeUserHierarchyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserHierarchyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserHierarchyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserHierarchyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserHierarchyGroupInputOperationOutputAlias,
                crate::output::DescribeUserHierarchyGroupOutput,
                crate::error::DescribeUserHierarchyGroupError,
                crate::input::DescribeUserHierarchyGroupInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserHierarchyStructure`.
    ///
    /// <p>Describes the hierarchy structure of the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUserHierarchyStructure<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_hierarchy_structure_input::Builder,
    }
    impl<C, M, R> DescribeUserHierarchyStructure<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserHierarchyStructure`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserHierarchyStructureOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserHierarchyStructureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserHierarchyStructureInputOperationOutputAlias,
                crate::output::DescribeUserHierarchyStructureOutput,
                crate::error::DescribeUserHierarchyStructureError,
                crate::input::DescribeUserHierarchyStructureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeVocabulary`.
    ///
    /// <p>Describes the specified vocabulary.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeVocabulary<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_vocabulary_input::Builder,
    }
    impl<C, M, R> DescribeVocabulary<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeVocabulary`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeVocabularyOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeVocabularyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeVocabularyInputOperationOutputAlias,
                crate::output::DescribeVocabularyOutput,
                crate::error::DescribeVocabularyError,
                crate::input::DescribeVocabularyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn vocabulary_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vocabulary_id(input.into());
            self
        }
        /// <p>The identifier of the custom vocabulary.</p>
        pub fn set_vocabulary_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vocabulary_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateApprovedOrigin`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Revokes access to integrated applications from Amazon Connect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateApprovedOrigin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_approved_origin_input::Builder,
    }
    impl<C, M, R> DisassociateApprovedOrigin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateApprovedOrigin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateApprovedOriginOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateApprovedOriginError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateApprovedOriginInputOperationOutputAlias,
                crate::output::DisassociateApprovedOriginOutput,
                crate::error::DisassociateApprovedOriginError,
                crate::input::DisassociateApprovedOriginInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The domain URL of the integrated application.</p>
        pub fn origin(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin(input.into());
            self
        }
        /// <p>The domain URL of the integrated application.</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_bot_input::Builder,
    }
    impl<C, M, R> DisassociateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateBotInputOperationOutputAlias,
                crate::output::DisassociateBotOutput,
                crate::error::DisassociateBotError,
                crate::input::DisassociateBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn lex_bot(mut self, input: crate::model::LexBot) -> Self {
            self.inner = self.inner.lex_bot(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.inner = self.inner.set_lex_bot(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to disassociate from the instance.</p>
        pub fn lex_v2_bot(mut self, input: crate::model::LexV2Bot) -> Self {
            self.inner = self.inner.lex_v2_bot(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to disassociate from the instance.</p>
        pub fn set_lex_v2_bot(
            mut self,
            input: std::option::Option<crate::model::LexV2Bot>,
        ) -> Self {
            self.inner = self.inner.set_lex_v2_bot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Removes the storage type configurations for the specified resource type and association ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_instance_storage_config_input::Builder,
    }
    impl<C, M, R> DisassociateInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateInstanceStorageConfigInputOperationOutputAlias,
                crate::output::DisassociateInstanceStorageConfigOutput,
                crate::error::DisassociateInstanceStorageConfigError,
                crate::input::DisassociateInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLambdaFunction`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Remove the Lambda function from the dropdown options available in the relevant contact flow blocks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateLambdaFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_lambda_function_input::Builder,
    }
    impl<C, M, R> DisassociateLambdaFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLambdaFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLambdaFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLambdaFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLambdaFunctionInputOperationOutputAlias,
                crate::output::DisassociateLambdaFunctionOutput,
                crate::error::DisassociateLambdaFunctionError,
                crate::input::DisassociateLambdaFunctionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>
        pub fn function_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLexBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Revokes authorization from the specified instance to access the specified Amazon Lex bot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateLexBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_lex_bot_input::Builder,
    }
    impl<C, M, R> DisassociateLexBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLexBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLexBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLexBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLexBotInputOperationOutputAlias,
                crate::output::DisassociateLexBotOutput,
                crate::error::DisassociateLexBotError,
                crate::input::DisassociateLexBotInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>
        pub fn bot_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(input.into());
            self
        }
        /// <p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>The Region in which the Amazon Lex bot has been created.</p>
        pub fn lex_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lex_region(input.into());
            self
        }
        /// <p>The Region in which the Amazon Lex bot has been created.</p>
        pub fn set_lex_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lex_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateQueueQuickConnects`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Disassociates a set of quick connects from a queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateQueueQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_queue_quick_connects_input::Builder,
    }
    impl<C, M, R> DisassociateQueueQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateQueueQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateQueueQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateQueueQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateQueueQuickConnectsInputOperationOutputAlias,
                crate::output::DisassociateQueueQuickConnectsOutput,
                crate::error::DisassociateQueueQuickConnectsError,
                crate::input::DisassociateQueueQuickConnectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// Appends an item to `QuickConnectIds`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects to disassociate from the queue.</p>
        pub fn quick_connect_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_ids(input.into());
            self
        }
        /// <p>The quick connects to disassociate from the queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateRoutingProfileQueues`.
    ///
    /// <p>Disassociates a set of queues from a routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> DisassociateRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::DisassociateRoutingProfileQueuesOutput,
                crate::error::DisassociateRoutingProfileQueuesError,
                crate::input::DisassociateRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `QueueReferences`.
        ///
        /// To override the contents of this collection use [`set_queue_references`](Self::set_queue_references).
        ///
        /// <p>The queues to disassociate from this routing profile.</p>
        pub fn queue_references(
            mut self,
            input: crate::model::RoutingProfileQueueReference,
        ) -> Self {
            self.inner = self.inner.queue_references(input);
            self
        }
        /// <p>The queues to disassociate from this routing profile.</p>
        pub fn set_queue_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueReference>>,
        ) -> Self {
            self.inner = self.inner.set_queue_references(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSecurityKey`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes the specified security key.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateSecurityKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_security_key_input::Builder,
    }
    impl<C, M, R> DisassociateSecurityKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSecurityKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSecurityKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateSecurityKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSecurityKeyInputOperationOutputAlias,
                crate::output::DisassociateSecurityKeyOutput,
                crate::error::DisassociateSecurityKeyError,
                crate::input::DisassociateSecurityKeyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactAttributes`.
    ///
    /// <p>Retrieves the contact attributes for the specified contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetContactAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_attributes_input::Builder,
    }
    impl<C, M, R> GetContactAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactAttributesInputOperationOutputAlias,
                crate::output::GetContactAttributesOutput,
                crate::error::GetContactAttributesError,
                crate::input::GetContactAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(input.into());
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCurrentMetricData`.
    ///
    /// <p>Gets the real-time metric data from the specified Amazon Connect instance.</p>
    /// <p>For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCurrentMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_current_metric_data_input::Builder,
    }
    impl<C, M, R> GetCurrentMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCurrentMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCurrentMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCurrentMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCurrentMetricDataInputOperationOutputAlias,
                crate::output::GetCurrentMetricDataOutput,
                crate::error::GetCurrentMetricDataError,
                crate::input::GetCurrentMetricDataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetCurrentMetricDataPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetCurrentMetricDataPaginator<C, M, R> {
            crate::paginator::GetCurrentMetricDataPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        pub fn filters(mut self, input: crate::model::Filters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        pub fn set_filters(mut self, input: std::option::Option<crate::model::Filters>) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Groupings`.
        ///
        /// To override the contents of this collection use [`set_groupings`](Self::set_groupings).
        ///
        /// <p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.</p>
        /// <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p>
        pub fn groupings(mut self, input: crate::model::Grouping) -> Self {
            self.inner = self.inner.groupings(input);
            self
        }
        /// <p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.</p>
        /// <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p>
        pub fn set_groupings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        ) -> Self {
            self.inner = self.inner.set_groupings(input);
            self
        }
        /// Appends an item to `CurrentMetrics`.
        ///
        /// To override the contents of this collection use [`set_current_metrics`](Self::set_current_metrics).
        ///
        /// <p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        /// <dl>
        /// <dt>
        /// AGENTS_AFTER_CONTACT_WORK
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ERROR
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_NON_PRODUCTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CALL
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CONTACT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ONLINE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_STAFFED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_IN_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In queue</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_SCHEDULED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a> </p>
        /// </dd>
        /// <dt>
        /// OLDEST_CONTACT_AGE
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p>
        /// <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:</p>
        /// <p> <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>}</p>
        /// <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_ACTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a> </p>
        /// </dd>
        /// </dl>
        pub fn current_metrics(mut self, input: crate::model::CurrentMetric) -> Self {
            self.inner = self.inner.current_metrics(input);
            self
        }
        /// <p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        /// <dl>
        /// <dt>
        /// AGENTS_AFTER_CONTACT_WORK
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ERROR
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_NON_PRODUCTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CALL
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ON_CONTACT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_ONLINE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a> </p>
        /// </dd>
        /// <dt>
        /// AGENTS_STAFFED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_IN_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In queue</a> </p>
        /// </dd>
        /// <dt>
        /// CONTACTS_SCHEDULED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a> </p>
        /// </dd>
        /// <dt>
        /// OLDEST_CONTACT_AGE
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p>
        /// <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:</p>
        /// <p> <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>}</p>
        /// <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_ACTIVE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a> </p>
        /// </dd>
        /// <dt>
        /// SLOTS_AVAILABLE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a> </p>
        /// </dd>
        /// </dl>
        pub fn set_current_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CurrentMetric>>,
        ) -> Self {
            self.inner = self.inner.set_current_metrics(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        /// <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        /// <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFederationToken`.
    ///
    /// <p>Retrieves a token for federation.</p> <note>
    /// <p>This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears: </p>
    /// <p> <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code> </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFederationToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_federation_token_input::Builder,
    }
    impl<C, M, R> GetFederationToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFederationToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFederationTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFederationTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFederationTokenInputOperationOutputAlias,
                crate::output::GetFederationTokenOutput,
                crate::error::GetFederationTokenError,
                crate::input::GetFederationTokenInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMetricData`.
    ///
    /// <p>Gets historical metric data from the specified Amazon Connect instance.</p>
    /// <p>For a description of each historical metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_metric_data_input::Builder,
    }
    impl<C, M, R> GetMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMetricDataInputOperationOutputAlias,
                crate::output::GetMetricDataOutput,
                crate::error::GetMetricDataError,
                crate::input::GetMetricDataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetMetricDataPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetMetricDataPaginator<C, M, R> {
            crate::paginator::GetMetricDataPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p>
        /// <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p>
        /// <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p>
        /// <p>The time range between the start and end time must be less than 24 hours.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p>
        /// <p>The time range between the start and end time must be less than 24 hours.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p> <note>
        /// <p>To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.</p>
        /// </note>
        pub fn filters(mut self, input: crate::model::Filters) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p> <note>
        /// <p>To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.</p>
        /// </note>
        pub fn set_filters(mut self, input: std::option::Option<crate::model::Filters>) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Groupings`.
        ///
        /// To override the contents of this collection use [`set_groupings`](Self::set_groupings).
        ///
        /// <p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p>
        /// <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>
        pub fn groupings(mut self, input: crate::model::Grouping) -> Self {
            self.inner = self.inner.groupings(input);
            self
        }
        /// <p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p>
        /// <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>
        pub fn set_groupings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        ) -> Self {
            self.inner = self.inner.set_groupings(input);
            self
        }
        /// Appends an item to `HistoricalMetrics`.
        ///
        /// To override the contents of this collection use [`set_historical_metrics`](Self::set_historical_metrics).
        ///
        /// <p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>
        /// <p>This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list). </p>
        /// </note>
        /// <dl>
        /// <dt>
        /// ABANDON_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// AFTER_CONTACT_WORK_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// API_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CALLBACK_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_ABANDONED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_AGENT_HUNG_UP_FIRST
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_CONSULTED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_INCOMING
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_OUTBOUND
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HOLD_ABANDONS
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_MISSED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_QUEUED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// HANDLE_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_AND_HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// OCCUPANCY
        /// </dt>
        /// <dd>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUE_ANSWER_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUED_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: MAX</p>
        /// </dd>
        /// <dt>
        /// SERVICE_LEVEL
        /// </dt>
        /// <dd>
        /// <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p>
        /// </dd>
        /// </dl>
        pub fn historical_metrics(mut self, input: crate::model::HistoricalMetric) -> Self {
            self.inner = self.inner.historical_metrics(input);
            self
        }
        /// <p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note>
        /// <p>This API does not support a contacts incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list). </p>
        /// </note>
        /// <dl>
        /// <dt>
        /// ABANDON_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// AFTER_CONTACT_WORK_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// API_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CALLBACK_CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_ABANDONED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_AGENT_HUNG_UP_FIRST
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_CONSULTED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_INCOMING
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HANDLED_OUTBOUND
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_HOLD_ABANDONS
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_MISSED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_QUEUED
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_IN_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
        /// </dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>
        /// HANDLE_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_AND_HOLD_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// INTERACTION_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// OCCUPANCY
        /// </dt>
        /// <dd>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUE_ANSWER_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>
        /// QUEUED_TIME
        /// </dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: MAX</p>
        /// </dd>
        /// <dt>
        /// SERVICE_LEVEL
        /// </dt>
        /// <dd>
        /// <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p>
        /// </dd>
        /// </dl>
        pub fn set_historical_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistoricalMetric>>,
        ) -> Self {
            self.inner = self.inner.set_historical_metrics(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAgentStatuses`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Lists agent statuses.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListAgentStatuses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_agent_statuses_input::Builder,
    }
    impl<C, M, R> ListAgentStatuses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAgentStatuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAgentStatusesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAgentStatusesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAgentStatusesInputOperationOutputAlias,
                crate::output::ListAgentStatusesOutput,
                crate::error::ListAgentStatusesError,
                crate::input::ListAgentStatusesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListAgentStatusesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListAgentStatusesPaginator<C, M, R> {
            crate::paginator::ListAgentStatusesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `AgentStatusTypes`.
        ///
        /// To override the contents of this collection use [`set_agent_status_types`](Self::set_agent_status_types).
        ///
        /// <p>Available agent status types.</p>
        pub fn agent_status_types(mut self, input: crate::model::AgentStatusType) -> Self {
            self.inner = self.inner.agent_status_types(input);
            self
        }
        /// <p>Available agent status types.</p>
        pub fn set_agent_status_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentStatusType>>,
        ) -> Self {
            self.inner = self.inner.set_agent_status_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApprovedOrigins`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all approved origins associated with the instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListApprovedOrigins<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_approved_origins_input::Builder,
    }
    impl<C, M, R> ListApprovedOrigins<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApprovedOrigins`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApprovedOriginsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApprovedOriginsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApprovedOriginsInputOperationOutputAlias,
                crate::output::ListApprovedOriginsOutput,
                crate::error::ListApprovedOriginsError,
                crate::input::ListApprovedOriginsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListApprovedOriginsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListApprovedOriginsPaginator<C, M, R> {
            crate::paginator::ListApprovedOriginsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBots`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListBots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bots_input::Builder,
    }
    impl<C, M, R> ListBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotsInputOperationOutputAlias,
                crate::output::ListBotsOutput,
                crate::error::ListBotsError,
                crate::input::ListBotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListBotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListBotsPaginator<C, M, R> {
            crate::paginator::ListBotsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The version of Amazon Lex or Amazon Lex V2.</p>
        pub fn lex_version(mut self, input: crate::model::LexVersion) -> Self {
            self.inner = self.inner.lex_version(input);
            self
        }
        /// <p>The version of Amazon Lex or Amazon Lex V2.</p>
        pub fn set_lex_version(
            mut self,
            input: std::option::Option<crate::model::LexVersion>,
        ) -> Self {
            self.inner = self.inner.set_lex_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactFlowModules`.
    ///
    /// <p>Provides information about the contact flow modules for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContactFlowModules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_flow_modules_input::Builder,
    }
    impl<C, M, R> ListContactFlowModules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactFlowModules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactFlowModulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactFlowModulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactFlowModulesInputOperationOutputAlias,
                crate::output::ListContactFlowModulesOutput,
                crate::error::ListContactFlowModulesError,
                crate::input::ListContactFlowModulesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactFlowModulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactFlowModulesPaginator<C, M, R> {
            crate::paginator::ListContactFlowModulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The state of the contact flow module.</p>
        pub fn contact_flow_module_state(
            mut self,
            input: crate::model::ContactFlowModuleState,
        ) -> Self {
            self.inner = self.inner.contact_flow_module_state(input);
            self
        }
        /// <p>The state of the contact flow module.</p>
        pub fn set_contact_flow_module_state(
            mut self,
            input: std::option::Option<crate::model::ContactFlowModuleState>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactFlows`.
    ///
    /// <p>Provides information about the contact flows for the specified Amazon Connect instance.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>
    /// <p>For more information about contact flows, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Contact Flows</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContactFlows<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_flows_input::Builder,
    }
    impl<C, M, R> ListContactFlows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactFlowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactFlowsInputOperationOutputAlias,
                crate::output::ListContactFlowsOutput,
                crate::error::ListContactFlowsError,
                crate::input::ListContactFlowsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactFlowsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactFlowsPaginator<C, M, R> {
            crate::paginator::ListContactFlowsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `ContactFlowTypes`.
        ///
        /// To override the contents of this collection use [`set_contact_flow_types`](Self::set_contact_flow_types).
        ///
        /// <p>The type of contact flow.</p>
        pub fn contact_flow_types(mut self, input: crate::model::ContactFlowType) -> Self {
            self.inner = self.inner.contact_flow_types(input);
            self
        }
        /// <p>The type of contact flow.</p>
        pub fn set_contact_flow_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactFlowType>>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_types(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactReferences`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>For the specified <code>referenceTypes</code>, returns a list of references associated with the contact. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListContactReferences<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_references_input::Builder,
    }
    impl<C, M, R> ListContactReferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactReferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactReferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactReferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactReferencesInputOperationOutputAlias,
                crate::output::ListContactReferencesOutput,
                crate::error::ListContactReferencesError,
                crate::input::ListContactReferencesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListContactReferencesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListContactReferencesPaginator<C, M, R> {
            crate::paginator::ListContactReferencesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// Appends an item to `ReferenceTypes`.
        ///
        /// To override the contents of this collection use [`set_reference_types`](Self::set_reference_types).
        ///
        /// <p>The type of reference.</p>
        pub fn reference_types(mut self, input: crate::model::ReferenceType) -> Self {
            self.inner = self.inner.reference_types(input);
            self
        }
        /// <p>The type of reference.</p>
        pub fn set_reference_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReferenceType>>,
        ) -> Self {
            self.inner = self.inner.set_reference_types(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important>
        /// <p>This is not expected to be set, because the value returned in the previous response is always null.</p>
        /// </important>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important>
        /// <p>This is not expected to be set, because the value returned in the previous response is always null.</p>
        /// </important>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDefaultVocabularies`.
    ///
    /// <p>Lists the default vocabularies for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDefaultVocabularies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_default_vocabularies_input::Builder,
    }
    impl<C, M, R> ListDefaultVocabularies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDefaultVocabularies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDefaultVocabulariesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDefaultVocabulariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDefaultVocabulariesInputOperationOutputAlias,
                crate::output::ListDefaultVocabulariesOutput,
                crate::error::ListDefaultVocabulariesError,
                crate::input::ListDefaultVocabulariesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDefaultVocabulariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDefaultVocabulariesPaginator<C, M, R> {
            crate::paginator::ListDefaultVocabulariesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHoursOfOperations`.
    ///
    /// <p>Provides information about the hours of operation for the specified Amazon Connect instance.</p>
    /// <p>For more information about hours of operation, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListHoursOfOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hours_of_operations_input::Builder,
    }
    impl<C, M, R> ListHoursOfOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHoursOfOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHoursOfOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHoursOfOperationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHoursOfOperationsInputOperationOutputAlias,
                crate::output::ListHoursOfOperationsOutput,
                crate::error::ListHoursOfOperationsError,
                crate::input::ListHoursOfOperationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListHoursOfOperationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListHoursOfOperationsPaginator<C, M, R> {
            crate::paginator::ListHoursOfOperationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceAttributes`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all attribute types for the given instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstanceAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_attributes_input::Builder,
    }
    impl<C, M, R> ListInstanceAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceAttributesInputOperationOutputAlias,
                crate::output::ListInstanceAttributesOutput,
                crate::error::ListInstanceAttributesError,
                crate::input::ListInstanceAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstanceAttributesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstanceAttributesPaginator<C, M, R> {
            crate::paginator::ListInstanceAttributesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstances`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instances_input::Builder,
    }
    impl<C, M, R> ListInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstancesInputOperationOutputAlias,
                crate::output::ListInstancesOutput,
                crate::error::ListInstancesError,
                crate::input::ListInstancesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstancesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInstancesPaginator<C, M, R> {
            crate::paginator::ListInstancesPaginator::new(self.handle, self.inner)
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceStorageConfigs`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of storage configs for the identified instance and resource type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInstanceStorageConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_storage_configs_input::Builder,
    }
    impl<C, M, R> ListInstanceStorageConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceStorageConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceStorageConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceStorageConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceStorageConfigsInputOperationOutputAlias,
                crate::output::ListInstanceStorageConfigsOutput,
                crate::error::ListInstanceStorageConfigsError,
                crate::input::ListInstanceStorageConfigsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInstanceStorageConfigsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListInstanceStorageConfigsPaginator<C, M, R> {
            crate::paginator::ListInstanceStorageConfigsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIntegrationAssociations`.
    ///
    /// <p>Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListIntegrationAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_integration_associations_input::Builder,
    }
    impl<C, M, R> ListIntegrationAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIntegrationAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIntegrationAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIntegrationAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIntegrationAssociationsInputOperationOutputAlias,
                crate::output::ListIntegrationAssociationsOutput,
                crate::error::ListIntegrationAssociationsError,
                crate::input::ListIntegrationAssociationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListIntegrationAssociationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListIntegrationAssociationsPaginator<C, M, R> {
            crate::paginator::ListIntegrationAssociationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The integration type.</p>
        pub fn integration_type(mut self, input: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(input);
            self
        }
        /// <p>The integration type.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLambdaFunctions`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact flow blocks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLambdaFunctions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lambda_functions_input::Builder,
    }
    impl<C, M, R> ListLambdaFunctions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLambdaFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLambdaFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLambdaFunctionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLambdaFunctionsInputOperationOutputAlias,
                crate::output::ListLambdaFunctionsOutput,
                crate::error::ListLambdaFunctionsError,
                crate::input::ListLambdaFunctionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLambdaFunctionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLambdaFunctionsPaginator<C, M, R> {
            crate::paginator::ListLambdaFunctionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLexBots`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all the Amazon Lex bots currently associated with the instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListLexBots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lex_bots_input::Builder,
    }
    impl<C, M, R> ListLexBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLexBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLexBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLexBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLexBotsInputOperationOutputAlias,
                crate::output::ListLexBotsOutput,
                crate::error::ListLexBotsError,
                crate::input::ListLexBotsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListLexBotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListLexBotsPaginator<C, M, R> {
            crate::paginator::ListLexBotsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPhoneNumbers`.
    ///
    /// <p>Provides information about the phone numbers for the specified Amazon Connect instance. </p>
    /// <p>For more information about phone numbers, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPhoneNumbers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_phone_numbers_input::Builder,
    }
    impl<C, M, R> ListPhoneNumbers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPhoneNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPhoneNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPhoneNumbersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPhoneNumbersInputOperationOutputAlias,
                crate::output::ListPhoneNumbersOutput,
                crate::error::ListPhoneNumbersError,
                crate::input::ListPhoneNumbersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPhoneNumbersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPhoneNumbersPaginator<C, M, R> {
            crate::paginator::ListPhoneNumbersPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `PhoneNumberTypes`.
        ///
        /// To override the contents of this collection use [`set_phone_number_types`](Self::set_phone_number_types).
        ///
        /// <p>The type of phone number.</p>
        pub fn phone_number_types(mut self, input: crate::model::PhoneNumberType) -> Self {
            self.inner = self.inner.phone_number_types(input);
            self
        }
        /// <p>The type of phone number.</p>
        pub fn set_phone_number_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberType>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_types(input);
            self
        }
        /// Appends an item to `PhoneNumberCountryCodes`.
        ///
        /// To override the contents of this collection use [`set_phone_number_country_codes`](Self::set_phone_number_country_codes).
        ///
        /// <p>The ISO country code.</p>
        pub fn phone_number_country_codes(
            mut self,
            input: crate::model::PhoneNumberCountryCode,
        ) -> Self {
            self.inner = self.inner.phone_number_country_codes(input);
            self
        }
        /// <p>The ISO country code.</p>
        pub fn set_phone_number_country_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberCountryCode>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_country_codes(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrompts`.
    ///
    /// <p>Provides information about the prompts for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListPrompts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_prompts_input::Builder,
    }
    impl<C, M, R> ListPrompts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPrompts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPromptsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPromptsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPromptsInputOperationOutputAlias,
                crate::output::ListPromptsOutput,
                crate::error::ListPromptsError,
                crate::input::ListPromptsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListPromptsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListPromptsPaginator<C, M, R> {
            crate::paginator::ListPromptsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueueQuickConnects`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Lists the quick connects associated with a queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQueueQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queue_quick_connects_input::Builder,
    }
    impl<C, M, R> ListQueueQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueueQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueueQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueueQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueueQuickConnectsInputOperationOutputAlias,
                crate::output::ListQueueQuickConnectsOutput,
                crate::error::ListQueueQuickConnectsError,
                crate::input::ListQueueQuickConnectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQueueQuickConnectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQueueQuickConnectsPaginator<C, M, R> {
            crate::paginator::ListQueueQuickConnectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueues`.
    ///
    /// <p>Provides information about the queues for the specified Amazon Connect instance.</p>
    /// <p>If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.</p>
    /// <p>For more information about queues, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues: Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queues_input::Builder,
    }
    impl<C, M, R> ListQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueuesInputOperationOutputAlias,
                crate::output::ListQueuesOutput,
                crate::error::ListQueuesError,
                crate::input::ListQueuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQueuesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQueuesPaginator<C, M, R> {
            crate::paginator::ListQueuesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `QueueTypes`.
        ///
        /// To override the contents of this collection use [`set_queue_types`](Self::set_queue_types).
        ///
        /// <p>The type of queue.</p>
        pub fn queue_types(mut self, input: crate::model::QueueType) -> Self {
            self.inner = self.inner.queue_types(input);
            self
        }
        /// <p>The type of queue.</p>
        pub fn set_queue_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueueType>>,
        ) -> Self {
            self.inner = self.inner.set_queue_types(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQuickConnects`.
    ///
    /// <p>Provides information about the quick connects for the specified Amazon Connect instance. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_quick_connects_input::Builder,
    }
    impl<C, M, R> ListQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQuickConnectsInputOperationOutputAlias,
                crate::output::ListQuickConnectsOutput,
                crate::error::ListQuickConnectsError,
                crate::input::ListQuickConnectsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListQuickConnectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListQuickConnectsPaginator<C, M, R> {
            crate::paginator::ListQuickConnectsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `QuickConnectTypes`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_types`](Self::set_quick_connect_types).
        ///
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn quick_connect_types(mut self, input: crate::model::QuickConnectType) -> Self {
            self.inner = self.inner.quick_connect_types(input);
            self
        }
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn set_quick_connect_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QuickConnectType>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutingProfileQueues`.
    ///
    /// <p>Lists the queues associated with a routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> ListRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::ListRoutingProfileQueuesOutput,
                crate::error::ListRoutingProfileQueuesError,
                crate::input::ListRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoutingProfileQueuesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListRoutingProfileQueuesPaginator<C, M, R> {
            crate::paginator::ListRoutingProfileQueuesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutingProfiles`.
    ///
    /// <p>Provides summary information about the routing profiles for the specified Amazon Connect instance.</p>
    /// <p>For more information about routing profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing Profile</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListRoutingProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_routing_profiles_input::Builder,
    }
    impl<C, M, R> ListRoutingProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoutingProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutingProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutingProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoutingProfilesInputOperationOutputAlias,
                crate::output::ListRoutingProfilesOutput,
                crate::error::ListRoutingProfilesError,
                crate::input::ListRoutingProfilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListRoutingProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListRoutingProfilesPaginator<C, M, R> {
            crate::paginator::ListRoutingProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityKeys`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all security keys associated with the instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecurityKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_keys_input::Builder,
    }
    impl<C, M, R> ListSecurityKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityKeysInputOperationOutputAlias,
                crate::output::ListSecurityKeysOutput,
                crate::error::ListSecurityKeysError,
                crate::input::ListSecurityKeysInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecurityKeysPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecurityKeysPaginator<C, M, R> {
            crate::paginator::ListSecurityKeysPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityProfilePermissions`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Lists the permissions granted to a security profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecurityProfilePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_profile_permissions_input::Builder,
    }
    impl<C, M, R> ListSecurityProfilePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityProfilePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityProfilePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityProfilePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityProfilePermissionsInputOperationOutputAlias,
                crate::output::ListSecurityProfilePermissionsOutput,
                crate::error::ListSecurityProfilePermissionsError,
                crate::input::ListSecurityProfilePermissionsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecurityProfilePermissionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListSecurityProfilePermissionsPaginator<C, M, R> {
            crate::paginator::ListSecurityProfilePermissionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(input.into());
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityProfiles`.
    ///
    /// <p>Provides summary information about the security profiles for the specified Amazon Connect instance.</p>
    /// <p>For more information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListSecurityProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_profiles_input::Builder,
    }
    impl<C, M, R> ListSecurityProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityProfilesInputOperationOutputAlias,
                crate::output::ListSecurityProfilesOutput,
                crate::error::ListSecurityProfilesError,
                crate::input::ListSecurityProfilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListSecurityProfilesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListSecurityProfilesPaginator<C, M, R> {
            crate::paginator::ListSecurityProfilesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    /// <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUseCases`.
    ///
    /// <p>Lists the use cases for the integration association. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUseCases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_use_cases_input::Builder,
    }
    impl<C, M, R> ListUseCases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUseCases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUseCasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUseCasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUseCasesInputOperationOutputAlias,
                crate::output::ListUseCasesOutput,
                crate::error::ListUseCasesError,
                crate::input::ListUseCasesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUseCasesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUseCasesPaginator<C, M, R> {
            crate::paginator::ListUseCasesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(input.into());
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserHierarchyGroups`.
    ///
    /// <p>Provides summary information about the hierarchy groups for the specified Amazon Connect instance.</p>
    /// <p>For more information about agent hierarchies, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUserHierarchyGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_hierarchy_groups_input::Builder,
    }
    impl<C, M, R> ListUserHierarchyGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserHierarchyGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserHierarchyGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserHierarchyGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserHierarchyGroupsInputOperationOutputAlias,
                crate::output::ListUserHierarchyGroupsOutput,
                crate::error::ListUserHierarchyGroupsError,
                crate::input::ListUserHierarchyGroupsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUserHierarchyGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUserHierarchyGroupsPaginator<C, M, R> {
            crate::paginator::ListUserHierarchyGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Provides summary information about the users for the specified Amazon Connect instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListUsersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListUsersPaginator<C, M, R> {
            crate::paginator::ListUsersPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResumeContactRecording`.
    ///
    /// <p>When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording the call.</p>
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ResumeContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resume_contact_recording_input::Builder,
    }
    impl<C, M, R> ResumeContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResumeContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResumeContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::ResumeContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResumeContactRecordingInputOperationOutputAlias,
                crate::output::ResumeContactRecordingOutput,
                crate::error::ResumeContactRecordingError,
                crate::input::ResumeContactRecordingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchVocabularies`.
    ///
    /// <p>Searches for vocabularies within a specific Amazon Connect instance using <code>State</code>, <code>NameStartsWith</code>, and <code>LanguageCode</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchVocabularies<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_vocabularies_input::Builder,
    }
    impl<C, M, R> SearchVocabularies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchVocabularies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchVocabulariesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchVocabulariesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchVocabulariesInputOperationOutputAlias,
                crate::output::SearchVocabulariesOutput,
                crate::error::SearchVocabulariesError,
                crate::input::SearchVocabulariesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchVocabulariesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchVocabulariesPaginator<C, M, R> {
            crate::paginator::SearchVocabulariesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The current state of the custom vocabulary.</p>
        pub fn state(mut self, input: crate::model::VocabularyState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The current state of the custom vocabulary.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::VocabularyState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The starting pattern of the name of the vocabulary.</p>
        pub fn name_starts_with(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name_starts_with(input.into());
            self
        }
        /// <p>The starting pattern of the name of the vocabulary.</p>
        pub fn set_name_starts_with(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_name_starts_with(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn language_code(mut self, input: crate::model::VocabularyLanguageCode) -> Self {
            self.inner = self.inner.language_code(input);
            self
        }
        /// <p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>
        pub fn set_language_code(
            mut self,
            input: std::option::Option<crate::model::VocabularyLanguageCode>,
        ) -> Self {
            self.inner = self.inner.set_language_code(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartChatContact`.
    ///
    /// <p>Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> API in the Amazon Connect Participant Service.</p>
    /// <p>When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> with WEBSOCKET and CONNECTION_CREDENTIALS. </p>
    /// <p>A 429 error occurs in two situations:</p>
    /// <ul>
    /// <li> <p>API rate limit is exceeded. API TPS throttling returns a <code>TooManyRequests</code> exception.</p> </li>
    /// <li> <p>The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">quota for concurrent active chats</a> is exceeded. Active chat throttling returns a <code>LimitExceededException</code>.</p> </li>
    /// </ul>
    /// <p>For more information about chat, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat.html">Chat</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartChatContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_chat_contact_input::Builder,
    }
    impl<C, M, R> StartChatContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartChatContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartChatContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StartChatContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartChatContactInputOperationOutputAlias,
                crate::output::StartChatContactOutput,
                crate::error::StartChatContactError,
                crate::input::StartChatContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in contact flows just like any other contact attributes. </p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in contact flows just like any other contact attributes. </p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>Information identifying the participant.</p>
        pub fn participant_details(mut self, input: crate::model::ParticipantDetails) -> Self {
            self.inner = self.inner.participant_details(input);
            self
        }
        /// <p>Information identifying the participant.</p>
        pub fn set_participant_details(
            mut self,
            input: std::option::Option<crate::model::ParticipantDetails>,
        ) -> Self {
            self.inner = self.inner.set_participant_details(input);
            self
        }
        /// <p>The initial message to be sent to the newly created chat.</p>
        pub fn initial_message(mut self, input: crate::model::ChatMessage) -> Self {
            self.inner = self.inner.initial_message(input);
            self
        }
        /// <p>The initial message to be sent to the newly created chat.</p>
        pub fn set_initial_message(
            mut self,
            input: std::option::Option<crate::model::ChatMessage>,
        ) -> Self {
            self.inner = self.inner.set_initial_message(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContactRecording`.
    ///
    /// <p>Starts recording the contact when the agent joins the call. StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.</p>
    /// <p>You can use this API to override the recording behavior configured in the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html">Set recording behavior</a> block.</p>
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_contact_recording_input::Builder,
    }
    impl<C, M, R> StartContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartContactRecordingInputOperationOutputAlias,
                crate::output::StartContactRecordingOutput,
                crate::error::StartContactRecordingError,
                crate::input::StartContactRecordingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
        /// <p>The person being recorded.</p>
        pub fn voice_recording_configuration(
            mut self,
            input: crate::model::VoiceRecordingConfiguration,
        ) -> Self {
            self.inner = self.inner.voice_recording_configuration(input);
            self
        }
        /// <p>The person being recorded.</p>
        pub fn set_voice_recording_configuration(
            mut self,
            input: std::option::Option<crate::model::VoiceRecordingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_voice_recording_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContactStreaming`.
    ///
    /// <p> Initiates real-time message streaming for a new chat contact.</p>
    /// <p> For more information about message streaming, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html">Enable real-time chat message streaming</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartContactStreaming<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_contact_streaming_input::Builder,
    }
    impl<C, M, R> StartContactStreaming<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartContactStreaming`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContactStreamingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContactStreamingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartContactStreamingInputOperationOutputAlias,
                crate::output::StartContactStreamingOutput,
                crate::error::StartContactStreamingError,
                crate::input::StartContactStreamingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
        pub fn chat_streaming_configuration(
            mut self,
            input: crate::model::ChatStreamingConfiguration,
        ) -> Self {
            self.inner = self.inner.chat_streaming_configuration(input);
            self
        }
        /// <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
        pub fn set_chat_streaming_configuration(
            mut self,
            input: std::option::Option<crate::model::ChatStreamingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_chat_streaming_configuration(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartOutboundVoiceContact`.
    ///
    /// <p>Places an outbound call to a contact, and then initiates the contact flow. It performs the actions in the contact flow that's specified (in <code>ContactFlowId</code>).</p>
    /// <p>Agents do not initiate the outbound API, which means that they do not dial the contact. If the contact flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.</p>
    /// <p>There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.</p> <note>
    /// <p>UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
    /// </note> <note>
    /// <p>Campaign calls are not allowed by default. Before you can make a call with <code>TrafficType</code> = <code>CAMPAIGN</code>, you must submit a service quota increase request. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartOutboundVoiceContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_outbound_voice_contact_input::Builder,
    }
    impl<C, M, R> StartOutboundVoiceContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartOutboundVoiceContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartOutboundVoiceContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StartOutboundVoiceContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartOutboundVoiceContactInputOperationOutputAlias,
                crate::output::StartOutboundVoiceContactOutput,
                crate::error::StartOutboundVoiceContactError,
                crate::input::StartOutboundVoiceContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number of the customer, in E.164 format.</p>
        pub fn destination_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_phone_number(input.into());
            self
        }
        /// <p>The phone number of the customer, in E.164 format.</p>
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_phone_number(input);
            self
        }
        /// <p>The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>
        pub fn source_phone_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_phone_number(input.into());
            self
        }
        /// <p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>
        pub fn set_source_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_phone_number(input);
            self
        }
        /// <p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>Configuration of the answering machine detection for this outbound call. </p>
        pub fn answer_machine_detection_config(
            mut self,
            input: crate::model::AnswerMachineDetectionConfig,
        ) -> Self {
            self.inner = self.inner.answer_machine_detection_config(input);
            self
        }
        /// <p>Configuration of the answering machine detection for this outbound call. </p>
        pub fn set_answer_machine_detection_config(
            mut self,
            input: std::option::Option<crate::model::AnswerMachineDetectionConfig>,
        ) -> Self {
            self.inner = self.inner.set_answer_machine_detection_config(input);
            self
        }
        /// <p>The campaign identifier of the outbound communication.</p>
        pub fn campaign_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(input.into());
            self
        }
        /// <p>The campaign identifier of the outbound communication.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use <code>GENERAL</code>. </p>
        pub fn traffic_type(mut self, input: crate::model::TrafficType) -> Self {
            self.inner = self.inner.traffic_type(input);
            self
        }
        /// <p>Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use <code>GENERAL</code>. </p>
        pub fn set_traffic_type(
            mut self,
            input: std::option::Option<crate::model::TrafficType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTaskContact`.
    ///
    /// <p>Initiates a contact flow to start a new task.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartTaskContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_task_contact_input::Builder,
    }
    impl<C, M, R> StartTaskContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTaskContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTaskContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTaskContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTaskContactInputOperationOutputAlias,
                crate::output::StartTaskContactOutput,
                crate::error::StartTaskContactError,
                crate::input::StartTaskContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the previous chat, voice, or task contact. </p>
        pub fn previous_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.previous_contact_id(input.into());
            self
        }
        /// <p>The identifier of the previous chat, voice, or task contact. </p>
        pub fn set_previous_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_previous_contact_id(input);
            self
        }
        /// <p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `References`.
        ///
        /// To override the contents of this collection use [`set_references`](Self::set_references).
        ///
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn references(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Reference,
        ) -> Self {
            self.inner = self.inner.references(k.into(), v);
            self
        }
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_references(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Reference>,
            >,
        ) -> Self {
            self.inner = self.inner.set_references(input);
            self
        }
        /// <p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn scheduled_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.scheduled_time(input);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContact`.
    ///
    /// <p>Ends the specified contact.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_contact_input::Builder,
    }
    impl<C, M, R> StopContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopContactInputOperationOutputAlias,
                crate::output::StopContactOutput,
                crate::error::StopContactError,
                crate::input::StopContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The ID of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContactRecording`.
    ///
    /// <p>Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.</p>
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_contact_recording_input::Builder,
    }
    impl<C, M, R> StopContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopContactRecordingInputOperationOutputAlias,
                crate::output::StopContactRecordingOutput,
                crate::error::StopContactRecordingError,
                crate::input::StopContactRecordingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContactStreaming`.
    ///
    /// <p> Ends message streaming on a specified contact. To restart message streaming on that contact, call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html">StartContactStreaming</a> API. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopContactStreaming<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_contact_streaming_input::Builder,
    }
    impl<C, M, R> StopContactStreaming<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopContactStreaming`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContactStreamingOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContactStreamingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopContactStreamingInputOperationOutputAlias,
                crate::output::StopContactStreamingOutput,
                crate::error::StopContactStreamingError,
                crate::input::StopContactStreamingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact that is associated with the first interaction with the contact center.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact that is associated with the first interaction with the contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the streaming configuration enabled. </p>
        pub fn streaming_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_id(input.into());
            self
        }
        /// <p>The identifier of the streaming configuration enabled. </p>
        pub fn set_streaming_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_streaming_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SuspendContactRecording`.
    ///
    /// <p>When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording. </p>
    /// <p>The period of time that the recording is suspended is filled with silence in the final recording. </p>
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SuspendContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::suspend_contact_recording_input::Builder,
    }
    impl<C, M, R> SuspendContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SuspendContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SuspendContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::SuspendContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SuspendContactRecordingInputOperationOutputAlias,
                crate::output::SuspendContactRecordingOutput,
                crate::error::SuspendContactRecordingError,
                crate::input::SuspendContactRecordingInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource.</p>
    /// <p>The supported resource types are users, routing profiles, queues, quick connects, contact flows, agent status, and hours of operation.</p>
    /// <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAgentStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates agent status.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateAgentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_agent_status_input::Builder,
    }
    impl<C, M, R> UpdateAgentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAgentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAgentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAgentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAgentStatusInputOperationOutputAlias,
                crate::output::UpdateAgentStatusOutput,
                crate::error::UpdateAgentStatusError,
                crate::input::UpdateAgentStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn agent_status_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_status_id(input.into());
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn set_agent_status_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_agent_status_id(input);
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn state(mut self, input: crate::model::AgentStatusState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AgentStatusState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn display_order(mut self, input: i32) -> Self {
            self.inner = self.inner.display_order(input);
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn set_display_order(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_display_order(input);
            self
        }
        /// <p>A number indicating the reset order of the agent status.</p>
        pub fn reset_order_number(mut self, input: bool) -> Self {
            self.inner = self.inner.reset_order_number(input);
            self
        }
        /// <p>A number indicating the reset order of the agent status.</p>
        pub fn set_reset_order_number(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_order_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContact`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.</p> <important>
    /// <p>You can add or update user-defined contact information for both ongoing and completed contacts.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_input::Builder,
    }
    impl<C, M, R> UpdateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactInputOperationOutputAlias,
                crate::output::UpdateContactOutput,
                crate::error::UpdateContactError,
                crate::input::UpdateContactInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The name of the contact.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the contact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `References`.
        ///
        /// To override the contents of this collection use [`set_references`](Self::set_references).
        ///
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn references(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::Reference,
        ) -> Self {
            self.inner = self.inner.references(k.into(), v);
            self
        }
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_references(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Reference>,
            >,
        ) -> Self {
            self.inner = self.inner.set_references(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactAttributes`.
    ///
    /// <p>Creates or updates user-defined contact attributes associated with the specified contact.</p>
    /// <p>You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.</p>
    /// <p>Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about CTR retention and the maximum size of the CTR attributes section, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
    /// <p> <b>Important:</b> You cannot use the operation to update attributes for contacts that occurred prior to the release of the API, which was September 12, 2018. You can update attributes only for contacts that started after the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release of the API but are still active in your instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_attributes_input::Builder,
    }
    impl<C, M, R> UpdateContactAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactAttributesInputOperationOutputAlias,
                crate::output::UpdateContactAttributesOutput,
                crate::error::UpdateContactAttributesError,
                crate::input::UpdateContactAttributesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k.into(), v.into());
            self
        }
        /// <p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowContent`.
    ///
    /// <p>Updates the specified contact flow.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactFlowContent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_content_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowContentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowContentInputOperationOutputAlias,
                crate::output::UpdateContactFlowContentOutput,
                crate::error::UpdateContactFlowContentError,
                crate::input::UpdateContactFlowContentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>The JSON string that represents contact flow’s content. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language-example.html">Example contact flow in Amazon Connect Flow language</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The JSON string that represents contact flow’s content. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language-example.html">Example contact flow in Amazon Connect Flow language</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowMetadata`.
    ///
    /// <p>Updates metadata about specified contact flow.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactFlowMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_metadata_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowMetadataInputOperationOutputAlias,
                crate::output::UpdateContactFlowMetadataOutput,
                crate::error::UpdateContactFlowMetadataError,
                crate::input::UpdateContactFlowMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of contact flow.</p>
        pub fn contact_flow_state(mut self, input: crate::model::ContactFlowState) -> Self {
            self.inner = self.inner.contact_flow_state(input);
            self
        }
        /// <p>The state of contact flow.</p>
        pub fn set_contact_flow_state(
            mut self,
            input: std::option::Option<crate::model::ContactFlowState>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowModuleContent`.
    ///
    /// <p>Updates specified contact flow module for the specified Amazon Connect instance. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactFlowModuleContent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_module_content_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowModuleContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowModuleContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowModuleContentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowModuleContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowModuleContentInputOperationOutputAlias,
                crate::output::UpdateContactFlowModuleContentOutput,
                crate::error::UpdateContactFlowModuleContentError,
                crate::input::UpdateContactFlowModuleContentInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn content(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(input.into());
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowModuleMetadata`.
    ///
    /// <p>Updates metadata about specified contact flow module.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactFlowModuleMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_module_metadata_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowModuleMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowModuleMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowModuleMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowModuleMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowModuleMetadataInputOperationOutputAlias,
                crate::output::UpdateContactFlowModuleMetadataOutput,
                crate::error::UpdateContactFlowModuleMetadataError,
                crate::input::UpdateContactFlowModuleMetadataInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow module.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the contact flow module.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of contact flow module.</p>
        pub fn state(mut self, input: crate::model::ContactFlowModuleState) -> Self {
            self.inner = self.inner.state(input);
            self
        }
        /// <p>The state of contact flow module.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ContactFlowModuleState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowName`.
    ///
    /// <p>The name of the contact flow.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect Flow language</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactFlowName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_name_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowNameInputOperationOutputAlias,
                crate::output::UpdateContactFlowNameOutput,
                crate::error::UpdateContactFlowNameError,
                crate::input::UpdateContactFlowNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(input.into());
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactSchedule`.
    ///
    /// <p>Updates the scheduled time of a task contact that is already scheduled.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateContactSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_schedule_input::Builder,
    }
    impl<C, M, R> UpdateContactSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactScheduleInputOperationOutputAlias,
                crate::output::UpdateContactScheduleOutput,
                crate::error::UpdateContactScheduleError,
                crate::input::UpdateContactScheduleInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(input.into());
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn scheduled_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.scheduled_time(input);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the hours of operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_hours_of_operation_input::Builder,
    }
    impl<C, M, R> UpdateHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateHoursOfOperationInputOperationOutputAlias,
                crate::output::UpdateHoursOfOperationOutput,
                crate::error::UpdateHoursOfOperationError,
                crate::input::UpdateHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(input.into());
            self
        }
        /// <p>The identifier of the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn time_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_zone(input.into());
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_zone(input);
            self
        }
        /// Appends an item to `Config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>Configuration information of the hours of operation.</p>
        pub fn config(mut self, input: crate::model::HoursOfOperationConfig) -> Self {
            self.inner = self.inner.config(input);
            self
        }
        /// <p>Configuration information of the hours of operation.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceAttribute`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the value for the specified attribute type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInstanceAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_instance_attribute_input::Builder,
    }
    impl<C, M, R> UpdateInstanceAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInstanceAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInstanceAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInstanceAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInstanceAttributeInputOperationOutputAlias,
                crate::output::UpdateInstanceAttributeOutput,
                crate::error::UpdateInstanceAttributeError,
                crate::input::UpdateInstanceAttributeInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of attribute.</p> <note>
        /// <p>Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access this feature, contact Amazon Web Services Support for allowlisting.</p>
        /// </note>
        pub fn attribute_type(mut self, input: crate::model::InstanceAttributeType) -> Self {
            self.inner = self.inner.attribute_type(input);
            self
        }
        /// <p>The type of attribute.</p> <note>
        /// <p>Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access this feature, contact Amazon Web Services Support for allowlisting.</p>
        /// </note>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::InstanceAttributeType>,
        ) -> Self {
            self.inner = self.inner.set_attribute_type(input);
            self
        }
        /// <p>The value for the attribute. Maximum character limit is 100. </p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(input.into());
            self
        }
        /// <p>The value for the attribute. Maximum character limit is 100. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates an existing configuration for a resource type. This API is idempotent.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_instance_storage_config_input::Builder,
    }
    impl<C, M, R> UpdateInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInstanceStorageConfigInputOperationOutputAlias,
                crate::output::UpdateInstanceStorageConfigOutput,
                crate::error::UpdateInstanceStorageConfigError,
                crate::input::UpdateInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(input.into());
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, input: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The storage configuration for the instance.</p>
        pub fn storage_config(mut self, input: crate::model::InstanceStorageConfig) -> Self {
            self.inner = self.inner.storage_config(input);
            self
        }
        /// <p>The storage configuration for the instance.</p>
        pub fn set_storage_config(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageConfig>,
        ) -> Self {
            self.inner = self.inner.set_storage_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the hours of operation for the specified queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQueueHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_hours_of_operation_input::Builder,
    }
    impl<C, M, R> UpdateQueueHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueHoursOfOperationInputOperationOutputAlias,
                crate::output::UpdateQueueHoursOfOperationOutput,
                crate::error::UpdateQueueHoursOfOperationError,
                crate::input::UpdateQueueHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(input.into());
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueMaxContacts`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the maximum number of contacts allowed in a queue before it is considered full.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQueueMaxContacts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_max_contacts_input::Builder,
    }
    impl<C, M, R> UpdateQueueMaxContacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueMaxContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueMaxContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueMaxContactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueMaxContactsInputOperationOutputAlias,
                crate::output::UpdateQueueMaxContactsOutput,
                crate::error::UpdateQueueMaxContactsError,
                crate::input::UpdateQueueMaxContactsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn max_contacts(mut self, input: i32) -> Self {
            self.inner = self.inner.max_contacts(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn set_max_contacts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_contacts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueName`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the name and description of a queue. At least <code>Name</code> or <code>Description</code> must be provided.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQueueName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_name_input::Builder,
    }
    impl<C, M, R> UpdateQueueName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueNameInputOperationOutputAlias,
                crate::output::UpdateQueueNameOutput,
                crate::error::UpdateQueueNameError,
                crate::input::UpdateQueueNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The name of the queue.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the queue.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the queue.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueOutboundCallerConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQueueOutboundCallerConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_outbound_caller_config_input::Builder,
    }
    impl<C, M, R> UpdateQueueOutboundCallerConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueOutboundCallerConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueOutboundCallerConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueOutboundCallerConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueOutboundCallerConfigInputOperationOutputAlias,
                crate::output::UpdateQueueOutboundCallerConfigOutput,
                crate::error::UpdateQueueOutboundCallerConfigError,
                crate::input::UpdateQueueOutboundCallerConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn outbound_caller_config(mut self, input: crate::model::OutboundCallerConfig) -> Self {
            self.inner = self.inner.outbound_caller_config(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn set_outbound_caller_config(
            mut self,
            input: std::option::Option<crate::model::OutboundCallerConfig>,
        ) -> Self {
            self.inner = self.inner.set_outbound_caller_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the status of the queue.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQueueStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_status_input::Builder,
    }
    impl<C, M, R> UpdateQueueStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueStatusInputOperationOutputAlias,
                crate::output::UpdateQueueStatusOutput,
                crate::error::UpdateQueueStatusError,
                crate::input::UpdateQueueStatusInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(input.into());
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The status of the queue.</p>
        pub fn status(mut self, input: crate::model::QueueStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>The status of the queue.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueueStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQuickConnectConfig`.
    ///
    /// <p>Updates the configuration settings for the specified quick connect.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQuickConnectConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_quick_connect_config_input::Builder,
    }
    impl<C, M, R> UpdateQuickConnectConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQuickConnectConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQuickConnectConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQuickConnectConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQuickConnectConfigInputOperationOutputAlias,
                crate::output::UpdateQuickConnectConfigOutput,
                crate::error::UpdateQuickConnectConfigError,
                crate::input::UpdateQuickConnectConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
        /// <p>Information about the configuration settings for the quick connect.</p>
        pub fn quick_connect_config(mut self, input: crate::model::QuickConnectConfig) -> Self {
            self.inner = self.inner.quick_connect_config(input);
            self
        }
        /// <p>Information about the configuration settings for the quick connect.</p>
        pub fn set_quick_connect_config(
            mut self,
            input: std::option::Option<crate::model::QuickConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQuickConnectName`.
    ///
    /// <p>Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least <code>Name</code> or <code>Description</code> must be provided.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateQuickConnectName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_quick_connect_name_input::Builder,
    }
    impl<C, M, R> UpdateQuickConnectName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQuickConnectName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQuickConnectNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQuickConnectNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQuickConnectNameInputOperationOutputAlias,
                crate::output::UpdateQuickConnectNameOutput,
                crate::error::UpdateQuickConnectNameError,
                crate::input::UpdateQuickConnectNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(input.into());
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileConcurrency`.
    ///
    /// <p>Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoutingProfileConcurrency<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_concurrency_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileConcurrency<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoutingProfileConcurrencyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileConcurrencyInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileConcurrencyOutput,
                crate::error::UpdateRoutingProfileConcurrencyError,
                crate::input::UpdateRoutingProfileConcurrencyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `MediaConcurrencies`.
        ///
        /// To override the contents of this collection use [`set_media_concurrencies`](Self::set_media_concurrencies).
        ///
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
        pub fn media_concurrencies(mut self, input: crate::model::MediaConcurrency) -> Self {
            self.inner = self.inner.media_concurrencies(input);
            self
        }
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
        pub fn set_media_concurrencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        ) -> Self {
            self.inner = self.inner.set_media_concurrencies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileDefaultOutboundQueue`.
    ///
    /// <p>Updates the default outbound queue of a routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoutingProfileDefaultOutboundQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_default_outbound_queue_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileDefaultOutboundQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileDefaultOutboundQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileDefaultOutboundQueueOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateRoutingProfileDefaultOutboundQueueError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileDefaultOutboundQueueInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileDefaultOutboundQueueOutput,
                crate::error::UpdateRoutingProfileDefaultOutboundQueueError,
                crate::input::UpdateRoutingProfileDefaultOutboundQueueInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The identifier for the default outbound queue.</p>
        pub fn default_outbound_queue_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_outbound_queue_id(input.into());
            self
        }
        /// <p>The identifier for the default outbound queue.</p>
        pub fn set_default_outbound_queue_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_outbound_queue_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileName`.
    ///
    /// <p>Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least <code>Name</code> or <code>Description</code> must be provided.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoutingProfileName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_name_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoutingProfileNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileNameInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileNameOutput,
                crate::error::UpdateRoutingProfileNameError,
                crate::input::UpdateRoutingProfileNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the routing profile. Must not be more than 250 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the routing profile. Must not be more than 250 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileQueues`.
    ///
    /// <p>Updates the properties associated with a set of queues for a routing profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileQueuesOutput,
                crate::error::UpdateRoutingProfileQueuesError,
                crate::input::UpdateRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `QueueConfigs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The queues to be updated for this routing profile. Queues must first be associated to the routing profile. You can do this using AssociateRoutingProfileQueues.</p>
        pub fn queue_configs(mut self, input: crate::model::RoutingProfileQueueConfig) -> Self {
            self.inner = self.inner.queue_configs(input);
            self
        }
        /// <p>The queues to be updated for this routing profile. Queues must first be associated to the routing profile. You can do this using AssociateRoutingProfileQueues.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.inner = self.inner.set_queue_configs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates a security profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_security_profile_input::Builder,
    }
    impl<C, M, R> UpdateSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSecurityProfileInputOperationOutputAlias,
                crate::output::UpdateSecurityProfileOutput,
                crate::error::UpdateSecurityProfileError,
                crate::input::UpdateSecurityProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The description of the security profile.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions granted to a security profile.</p>
        pub fn permissions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions(input.into());
            self
        }
        /// <p>The permissions granted to a security profile.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(input.into());
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserHierarchy`.
    ///
    /// <p>Assigns the specified hierarchy group to the specified user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserHierarchy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_hierarchy_input::Builder,
    }
    impl<C, M, R> UpdateUserHierarchy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserHierarchy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserHierarchyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserHierarchyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserHierarchyInputOperationOutputAlias,
                crate::output::UpdateUserHierarchyOutput,
                crate::error::UpdateUserHierarchyError,
                crate::input::UpdateUserHierarchyInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserHierarchyGroupName`.
    ///
    /// <p>Updates the name of the user hierarchy group. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserHierarchyGroupName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_hierarchy_group_name_input::Builder,
    }
    impl<C, M, R> UpdateUserHierarchyGroupName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserHierarchyGroupName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserHierarchyGroupNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserHierarchyGroupNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserHierarchyGroupNameInputOperationOutputAlias,
                crate::output::UpdateUserHierarchyGroupNameOutput,
                crate::error::UpdateUserHierarchyGroupNameError,
                crate::input::UpdateUserHierarchyGroupNameInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the hierarchy group. Must not be more than 100 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the hierarchy group. Must not be more than 100 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(input.into());
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserHierarchyStructure`.
    ///
    /// <p>Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserHierarchyStructure<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_hierarchy_structure_input::Builder,
    }
    impl<C, M, R> UpdateUserHierarchyStructure<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserHierarchyStructure`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserHierarchyStructureOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserHierarchyStructureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserHierarchyStructureInputOperationOutputAlias,
                crate::output::UpdateUserHierarchyStructureOutput,
                crate::error::UpdateUserHierarchyStructureError,
                crate::input::UpdateUserHierarchyStructureInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The hierarchy levels to update.</p>
        pub fn hierarchy_structure(
            mut self,
            input: crate::model::HierarchyStructureUpdate,
        ) -> Self {
            self.inner = self.inner.hierarchy_structure(input);
            self
        }
        /// <p>The hierarchy levels to update.</p>
        pub fn set_hierarchy_structure(
            mut self,
            input: std::option::Option<crate::model::HierarchyStructureUpdate>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_structure(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserIdentityInfo`.
    ///
    /// <p>Updates the identity information for the specified user.</p> <important>
    /// <p>We strongly recommend limiting who has the ability to invoke <code>UpdateUserIdentityInfo</code>. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker's email address, and then reset the password through email. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html">Best Practices for Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserIdentityInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_identity_info_input::Builder,
    }
    impl<C, M, R> UpdateUserIdentityInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserIdentityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserIdentityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserIdentityInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserIdentityInfoInputOperationOutputAlias,
                crate::output::UpdateUserIdentityInfoOutput,
                crate::error::UpdateUserIdentityInfoError,
                crate::input::UpdateUserIdentityInfoInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity information for the user.</p>
        pub fn identity_info(mut self, input: crate::model::UserIdentityInfo) -> Self {
            self.inner = self.inner.identity_info(input);
            self
        }
        /// <p>The identity information for the user.</p>
        pub fn set_identity_info(
            mut self,
            input: std::option::Option<crate::model::UserIdentityInfo>,
        ) -> Self {
            self.inner = self.inner.set_identity_info(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserPhoneConfig`.
    ///
    /// <p>Updates the phone configuration settings for the specified user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserPhoneConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_phone_config_input::Builder,
    }
    impl<C, M, R> UpdateUserPhoneConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserPhoneConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserPhoneConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserPhoneConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserPhoneConfigInputOperationOutputAlias,
                crate::output::UpdateUserPhoneConfigOutput,
                crate::error::UpdateUserPhoneConfigError,
                crate::input::UpdateUserPhoneConfigInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Information about phone configuration settings for the user.</p>
        pub fn phone_config(mut self, input: crate::model::UserPhoneConfig) -> Self {
            self.inner = self.inner.phone_config(input);
            self
        }
        /// <p>Information about phone configuration settings for the user.</p>
        pub fn set_phone_config(
            mut self,
            input: std::option::Option<crate::model::UserPhoneConfig>,
        ) -> Self {
            self.inner = self.inner.set_phone_config(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserRoutingProfile`.
    ///
    /// <p>Assigns the specified routing profile to the specified user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserRoutingProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_routing_profile_input::Builder,
    }
    impl<C, M, R> UpdateUserRoutingProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserRoutingProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserRoutingProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserRoutingProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserRoutingProfileInputOperationOutputAlias,
                crate::output::UpdateUserRoutingProfileOutput,
                crate::error::UpdateUserRoutingProfileError,
                crate::input::UpdateUserRoutingProfileInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn routing_profile_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(input.into());
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserSecurityProfiles`.
    ///
    /// <p>Assigns the specified security profiles to the specified user.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateUserSecurityProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_security_profiles_input::Builder,
    }
    impl<C, M, R> UpdateUserSecurityProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserSecurityProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserSecurityProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserSecurityProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserSecurityProfilesInputOperationOutputAlias,
                crate::output::UpdateUserSecurityProfilesOutput,
                crate::error::UpdateUserSecurityProfilesError,
                crate::input::UpdateUserSecurityProfilesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SecurityProfileIds`.
        ///
        /// To override the contents of this collection use [`set_security_profile_ids`](Self::set_security_profile_ids).
        ///
        /// <p>The identifiers of the security profiles for the user.</p>
        pub fn security_profile_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_ids(input.into());
            self
        }
        /// <p>The identifiers of the security profiles for the user.</p>
        pub fn set_security_profile_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_ids(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(input.into());
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(input.into());
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
