// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Connect Service
///
/// Client for invoking operations on Amazon Connect Service. Each operation on Amazon Connect Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_connect::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_connect::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_connect::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateApprovedOrigin` operation.
    ///
    /// See [`AssociateApprovedOrigin`](crate::client::fluent_builders::AssociateApprovedOrigin) for more information about the
    /// operation and its arguments.
    pub fn associate_approved_origin(&self) -> fluent_builders::AssociateApprovedOrigin<C, M, R> {
        fluent_builders::AssociateApprovedOrigin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateBot` operation.
    ///
    /// See [`AssociateBot`](crate::client::fluent_builders::AssociateBot) for more information about the
    /// operation and its arguments.
    pub fn associate_bot(&self) -> fluent_builders::AssociateBot<C, M, R> {
        fluent_builders::AssociateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateInstanceStorageConfig` operation.
    ///
    /// See [`AssociateInstanceStorageConfig`](crate::client::fluent_builders::AssociateInstanceStorageConfig) for more information about the
    /// operation and its arguments.
    pub fn associate_instance_storage_config(
        &self,
    ) -> fluent_builders::AssociateInstanceStorageConfig<C, M, R> {
        fluent_builders::AssociateInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateLambdaFunction` operation.
    ///
    /// See [`AssociateLambdaFunction`](crate::client::fluent_builders::AssociateLambdaFunction) for more information about the
    /// operation and its arguments.
    pub fn associate_lambda_function(&self) -> fluent_builders::AssociateLambdaFunction<C, M, R> {
        fluent_builders::AssociateLambdaFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateLexBot` operation.
    ///
    /// See [`AssociateLexBot`](crate::client::fluent_builders::AssociateLexBot) for more information about the
    /// operation and its arguments.
    pub fn associate_lex_bot(&self) -> fluent_builders::AssociateLexBot<C, M, R> {
        fluent_builders::AssociateLexBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateQueueQuickConnects` operation.
    ///
    /// See [`AssociateQueueQuickConnects`](crate::client::fluent_builders::AssociateQueueQuickConnects) for more information about the
    /// operation and its arguments.
    pub fn associate_queue_quick_connects(
        &self,
    ) -> fluent_builders::AssociateQueueQuickConnects<C, M, R> {
        fluent_builders::AssociateQueueQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateRoutingProfileQueues` operation.
    ///
    /// See [`AssociateRoutingProfileQueues`](crate::client::fluent_builders::AssociateRoutingProfileQueues) for more information about the
    /// operation and its arguments.
    pub fn associate_routing_profile_queues(
        &self,
    ) -> fluent_builders::AssociateRoutingProfileQueues<C, M, R> {
        fluent_builders::AssociateRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateSecurityKey` operation.
    ///
    /// See [`AssociateSecurityKey`](crate::client::fluent_builders::AssociateSecurityKey) for more information about the
    /// operation and its arguments.
    pub fn associate_security_key(&self) -> fluent_builders::AssociateSecurityKey<C, M, R> {
        fluent_builders::AssociateSecurityKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAgentStatus` operation.
    ///
    /// See [`CreateAgentStatus`](crate::client::fluent_builders::CreateAgentStatus) for more information about the
    /// operation and its arguments.
    pub fn create_agent_status(&self) -> fluent_builders::CreateAgentStatus<C, M, R> {
        fluent_builders::CreateAgentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContactFlow` operation.
    ///
    /// See [`CreateContactFlow`](crate::client::fluent_builders::CreateContactFlow) for more information about the
    /// operation and its arguments.
    pub fn create_contact_flow(&self) -> fluent_builders::CreateContactFlow<C, M, R> {
        fluent_builders::CreateContactFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateContactFlowModule` operation.
    ///
    /// See [`CreateContactFlowModule`](crate::client::fluent_builders::CreateContactFlowModule) for more information about the
    /// operation and its arguments.
    pub fn create_contact_flow_module(&self) -> fluent_builders::CreateContactFlowModule<C, M, R> {
        fluent_builders::CreateContactFlowModule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHoursOfOperation` operation.
    ///
    /// See [`CreateHoursOfOperation`](crate::client::fluent_builders::CreateHoursOfOperation) for more information about the
    /// operation and its arguments.
    pub fn create_hours_of_operation(&self) -> fluent_builders::CreateHoursOfOperation<C, M, R> {
        fluent_builders::CreateHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInstance` operation.
    ///
    /// See [`CreateInstance`](crate::client::fluent_builders::CreateInstance) for more information about the
    /// operation and its arguments.
    pub fn create_instance(&self) -> fluent_builders::CreateInstance<C, M, R> {
        fluent_builders::CreateInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateIntegrationAssociation` operation.
    ///
    /// See [`CreateIntegrationAssociation`](crate::client::fluent_builders::CreateIntegrationAssociation) for more information about the
    /// operation and its arguments.
    pub fn create_integration_association(
        &self,
    ) -> fluent_builders::CreateIntegrationAssociation<C, M, R> {
        fluent_builders::CreateIntegrationAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateQueue` operation.
    ///
    /// See [`CreateQueue`](crate::client::fluent_builders::CreateQueue) for more information about the
    /// operation and its arguments.
    pub fn create_queue(&self) -> fluent_builders::CreateQueue<C, M, R> {
        fluent_builders::CreateQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateQuickConnect` operation.
    ///
    /// See [`CreateQuickConnect`](crate::client::fluent_builders::CreateQuickConnect) for more information about the
    /// operation and its arguments.
    pub fn create_quick_connect(&self) -> fluent_builders::CreateQuickConnect<C, M, R> {
        fluent_builders::CreateQuickConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRoutingProfile` operation.
    ///
    /// See [`CreateRoutingProfile`](crate::client::fluent_builders::CreateRoutingProfile) for more information about the
    /// operation and its arguments.
    pub fn create_routing_profile(&self) -> fluent_builders::CreateRoutingProfile<C, M, R> {
        fluent_builders::CreateRoutingProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSecurityProfile` operation.
    ///
    /// See [`CreateSecurityProfile`](crate::client::fluent_builders::CreateSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn create_security_profile(&self) -> fluent_builders::CreateSecurityProfile<C, M, R> {
        fluent_builders::CreateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUseCase` operation.
    ///
    /// See [`CreateUseCase`](crate::client::fluent_builders::CreateUseCase) for more information about the
    /// operation and its arguments.
    pub fn create_use_case(&self) -> fluent_builders::CreateUseCase<C, M, R> {
        fluent_builders::CreateUseCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUser` operation.
    ///
    /// See [`CreateUser`](crate::client::fluent_builders::CreateUser) for more information about the
    /// operation and its arguments.
    pub fn create_user(&self) -> fluent_builders::CreateUser<C, M, R> {
        fluent_builders::CreateUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUserHierarchyGroup` operation.
    ///
    /// See [`CreateUserHierarchyGroup`](crate::client::fluent_builders::CreateUserHierarchyGroup) for more information about the
    /// operation and its arguments.
    pub fn create_user_hierarchy_group(
        &self,
    ) -> fluent_builders::CreateUserHierarchyGroup<C, M, R> {
        fluent_builders::CreateUserHierarchyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContactFlow` operation.
    ///
    /// See [`DeleteContactFlow`](crate::client::fluent_builders::DeleteContactFlow) for more information about the
    /// operation and its arguments.
    pub fn delete_contact_flow(&self) -> fluent_builders::DeleteContactFlow<C, M, R> {
        fluent_builders::DeleteContactFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteContactFlowModule` operation.
    ///
    /// See [`DeleteContactFlowModule`](crate::client::fluent_builders::DeleteContactFlowModule) for more information about the
    /// operation and its arguments.
    pub fn delete_contact_flow_module(&self) -> fluent_builders::DeleteContactFlowModule<C, M, R> {
        fluent_builders::DeleteContactFlowModule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHoursOfOperation` operation.
    ///
    /// See [`DeleteHoursOfOperation`](crate::client::fluent_builders::DeleteHoursOfOperation) for more information about the
    /// operation and its arguments.
    pub fn delete_hours_of_operation(&self) -> fluent_builders::DeleteHoursOfOperation<C, M, R> {
        fluent_builders::DeleteHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInstance` operation.
    ///
    /// See [`DeleteInstance`](crate::client::fluent_builders::DeleteInstance) for more information about the
    /// operation and its arguments.
    pub fn delete_instance(&self) -> fluent_builders::DeleteInstance<C, M, R> {
        fluent_builders::DeleteInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteIntegrationAssociation` operation.
    ///
    /// See [`DeleteIntegrationAssociation`](crate::client::fluent_builders::DeleteIntegrationAssociation) for more information about the
    /// operation and its arguments.
    pub fn delete_integration_association(
        &self,
    ) -> fluent_builders::DeleteIntegrationAssociation<C, M, R> {
        fluent_builders::DeleteIntegrationAssociation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQuickConnect` operation.
    ///
    /// See [`DeleteQuickConnect`](crate::client::fluent_builders::DeleteQuickConnect) for more information about the
    /// operation and its arguments.
    pub fn delete_quick_connect(&self) -> fluent_builders::DeleteQuickConnect<C, M, R> {
        fluent_builders::DeleteQuickConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSecurityProfile` operation.
    ///
    /// See [`DeleteSecurityProfile`](crate::client::fluent_builders::DeleteSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_security_profile(&self) -> fluent_builders::DeleteSecurityProfile<C, M, R> {
        fluent_builders::DeleteSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUseCase` operation.
    ///
    /// See [`DeleteUseCase`](crate::client::fluent_builders::DeleteUseCase) for more information about the
    /// operation and its arguments.
    pub fn delete_use_case(&self) -> fluent_builders::DeleteUseCase<C, M, R> {
        fluent_builders::DeleteUseCase::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUser` operation.
    ///
    /// See [`DeleteUser`](crate::client::fluent_builders::DeleteUser) for more information about the
    /// operation and its arguments.
    pub fn delete_user(&self) -> fluent_builders::DeleteUser<C, M, R> {
        fluent_builders::DeleteUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUserHierarchyGroup` operation.
    ///
    /// See [`DeleteUserHierarchyGroup`](crate::client::fluent_builders::DeleteUserHierarchyGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_user_hierarchy_group(
        &self,
    ) -> fluent_builders::DeleteUserHierarchyGroup<C, M, R> {
        fluent_builders::DeleteUserHierarchyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAgentStatus` operation.
    ///
    /// See [`DescribeAgentStatus`](crate::client::fluent_builders::DescribeAgentStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_agent_status(&self) -> fluent_builders::DescribeAgentStatus<C, M, R> {
        fluent_builders::DescribeAgentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContact` operation.
    ///
    /// See [`DescribeContact`](crate::client::fluent_builders::DescribeContact) for more information about the
    /// operation and its arguments.
    pub fn describe_contact(&self) -> fluent_builders::DescribeContact<C, M, R> {
        fluent_builders::DescribeContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContactFlow` operation.
    ///
    /// See [`DescribeContactFlow`](crate::client::fluent_builders::DescribeContactFlow) for more information about the
    /// operation and its arguments.
    pub fn describe_contact_flow(&self) -> fluent_builders::DescribeContactFlow<C, M, R> {
        fluent_builders::DescribeContactFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeContactFlowModule` operation.
    ///
    /// See [`DescribeContactFlowModule`](crate::client::fluent_builders::DescribeContactFlowModule) for more information about the
    /// operation and its arguments.
    pub fn describe_contact_flow_module(
        &self,
    ) -> fluent_builders::DescribeContactFlowModule<C, M, R> {
        fluent_builders::DescribeContactFlowModule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHoursOfOperation` operation.
    ///
    /// See [`DescribeHoursOfOperation`](crate::client::fluent_builders::DescribeHoursOfOperation) for more information about the
    /// operation and its arguments.
    pub fn describe_hours_of_operation(
        &self,
    ) -> fluent_builders::DescribeHoursOfOperation<C, M, R> {
        fluent_builders::DescribeHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstance` operation.
    ///
    /// See [`DescribeInstance`](crate::client::fluent_builders::DescribeInstance) for more information about the
    /// operation and its arguments.
    pub fn describe_instance(&self) -> fluent_builders::DescribeInstance<C, M, R> {
        fluent_builders::DescribeInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceAttribute` operation.
    ///
    /// See [`DescribeInstanceAttribute`](crate::client::fluent_builders::DescribeInstanceAttribute) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_attribute(
        &self,
    ) -> fluent_builders::DescribeInstanceAttribute<C, M, R> {
        fluent_builders::DescribeInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeInstanceStorageConfig` operation.
    ///
    /// See [`DescribeInstanceStorageConfig`](crate::client::fluent_builders::DescribeInstanceStorageConfig) for more information about the
    /// operation and its arguments.
    pub fn describe_instance_storage_config(
        &self,
    ) -> fluent_builders::DescribeInstanceStorageConfig<C, M, R> {
        fluent_builders::DescribeInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeQueue` operation.
    ///
    /// See [`DescribeQueue`](crate::client::fluent_builders::DescribeQueue) for more information about the
    /// operation and its arguments.
    pub fn describe_queue(&self) -> fluent_builders::DescribeQueue<C, M, R> {
        fluent_builders::DescribeQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeQuickConnect` operation.
    ///
    /// See [`DescribeQuickConnect`](crate::client::fluent_builders::DescribeQuickConnect) for more information about the
    /// operation and its arguments.
    pub fn describe_quick_connect(&self) -> fluent_builders::DescribeQuickConnect<C, M, R> {
        fluent_builders::DescribeQuickConnect::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeRoutingProfile` operation.
    ///
    /// See [`DescribeRoutingProfile`](crate::client::fluent_builders::DescribeRoutingProfile) for more information about the
    /// operation and its arguments.
    pub fn describe_routing_profile(&self) -> fluent_builders::DescribeRoutingProfile<C, M, R> {
        fluent_builders::DescribeRoutingProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSecurityProfile` operation.
    ///
    /// See [`DescribeSecurityProfile`](crate::client::fluent_builders::DescribeSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn describe_security_profile(&self) -> fluent_builders::DescribeSecurityProfile<C, M, R> {
        fluent_builders::DescribeSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUser` operation.
    ///
    /// See [`DescribeUser`](crate::client::fluent_builders::DescribeUser) for more information about the
    /// operation and its arguments.
    pub fn describe_user(&self) -> fluent_builders::DescribeUser<C, M, R> {
        fluent_builders::DescribeUser::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUserHierarchyGroup` operation.
    ///
    /// See [`DescribeUserHierarchyGroup`](crate::client::fluent_builders::DescribeUserHierarchyGroup) for more information about the
    /// operation and its arguments.
    pub fn describe_user_hierarchy_group(
        &self,
    ) -> fluent_builders::DescribeUserHierarchyGroup<C, M, R> {
        fluent_builders::DescribeUserHierarchyGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUserHierarchyStructure` operation.
    ///
    /// See [`DescribeUserHierarchyStructure`](crate::client::fluent_builders::DescribeUserHierarchyStructure) for more information about the
    /// operation and its arguments.
    pub fn describe_user_hierarchy_structure(
        &self,
    ) -> fluent_builders::DescribeUserHierarchyStructure<C, M, R> {
        fluent_builders::DescribeUserHierarchyStructure::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateApprovedOrigin` operation.
    ///
    /// See [`DisassociateApprovedOrigin`](crate::client::fluent_builders::DisassociateApprovedOrigin) for more information about the
    /// operation and its arguments.
    pub fn disassociate_approved_origin(
        &self,
    ) -> fluent_builders::DisassociateApprovedOrigin<C, M, R> {
        fluent_builders::DisassociateApprovedOrigin::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateBot` operation.
    ///
    /// See [`DisassociateBot`](crate::client::fluent_builders::DisassociateBot) for more information about the
    /// operation and its arguments.
    pub fn disassociate_bot(&self) -> fluent_builders::DisassociateBot<C, M, R> {
        fluent_builders::DisassociateBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateInstanceStorageConfig` operation.
    ///
    /// See [`DisassociateInstanceStorageConfig`](crate::client::fluent_builders::DisassociateInstanceStorageConfig) for more information about the
    /// operation and its arguments.
    pub fn disassociate_instance_storage_config(
        &self,
    ) -> fluent_builders::DisassociateInstanceStorageConfig<C, M, R> {
        fluent_builders::DisassociateInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateLambdaFunction` operation.
    ///
    /// See [`DisassociateLambdaFunction`](crate::client::fluent_builders::DisassociateLambdaFunction) for more information about the
    /// operation and its arguments.
    pub fn disassociate_lambda_function(
        &self,
    ) -> fluent_builders::DisassociateLambdaFunction<C, M, R> {
        fluent_builders::DisassociateLambdaFunction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateLexBot` operation.
    ///
    /// See [`DisassociateLexBot`](crate::client::fluent_builders::DisassociateLexBot) for more information about the
    /// operation and its arguments.
    pub fn disassociate_lex_bot(&self) -> fluent_builders::DisassociateLexBot<C, M, R> {
        fluent_builders::DisassociateLexBot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateQueueQuickConnects` operation.
    ///
    /// See [`DisassociateQueueQuickConnects`](crate::client::fluent_builders::DisassociateQueueQuickConnects) for more information about the
    /// operation and its arguments.
    pub fn disassociate_queue_quick_connects(
        &self,
    ) -> fluent_builders::DisassociateQueueQuickConnects<C, M, R> {
        fluent_builders::DisassociateQueueQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateRoutingProfileQueues` operation.
    ///
    /// See [`DisassociateRoutingProfileQueues`](crate::client::fluent_builders::DisassociateRoutingProfileQueues) for more information about the
    /// operation and its arguments.
    pub fn disassociate_routing_profile_queues(
        &self,
    ) -> fluent_builders::DisassociateRoutingProfileQueues<C, M, R> {
        fluent_builders::DisassociateRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateSecurityKey` operation.
    ///
    /// See [`DisassociateSecurityKey`](crate::client::fluent_builders::DisassociateSecurityKey) for more information about the
    /// operation and its arguments.
    pub fn disassociate_security_key(&self) -> fluent_builders::DisassociateSecurityKey<C, M, R> {
        fluent_builders::DisassociateSecurityKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetContactAttributes` operation.
    ///
    /// See [`GetContactAttributes`](crate::client::fluent_builders::GetContactAttributes) for more information about the
    /// operation and its arguments.
    pub fn get_contact_attributes(&self) -> fluent_builders::GetContactAttributes<C, M, R> {
        fluent_builders::GetContactAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCurrentMetricData` operation.
    ///
    /// See [`GetCurrentMetricData`](crate::client::fluent_builders::GetCurrentMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_current_metric_data(&self) -> fluent_builders::GetCurrentMetricData<C, M, R> {
        fluent_builders::GetCurrentMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFederationToken` operation.
    ///
    /// See [`GetFederationToken`](crate::client::fluent_builders::GetFederationToken) for more information about the
    /// operation and its arguments.
    pub fn get_federation_token(&self) -> fluent_builders::GetFederationToken<C, M, R> {
        fluent_builders::GetFederationToken::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMetricData` operation.
    ///
    /// See [`GetMetricData`](crate::client::fluent_builders::GetMetricData) for more information about the
    /// operation and its arguments.
    pub fn get_metric_data(&self) -> fluent_builders::GetMetricData<C, M, R> {
        fluent_builders::GetMetricData::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListAgentStatuses` operation.
    ///
    /// See [`ListAgentStatuses`](crate::client::fluent_builders::ListAgentStatuses) for more information about the
    /// operation and its arguments.
    pub fn list_agent_statuses(&self) -> fluent_builders::ListAgentStatuses<C, M, R> {
        fluent_builders::ListAgentStatuses::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListApprovedOrigins` operation.
    ///
    /// See [`ListApprovedOrigins`](crate::client::fluent_builders::ListApprovedOrigins) for more information about the
    /// operation and its arguments.
    pub fn list_approved_origins(&self) -> fluent_builders::ListApprovedOrigins<C, M, R> {
        fluent_builders::ListApprovedOrigins::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListBots` operation.
    ///
    /// See [`ListBots`](crate::client::fluent_builders::ListBots) for more information about the
    /// operation and its arguments.
    pub fn list_bots(&self) -> fluent_builders::ListBots<C, M, R> {
        fluent_builders::ListBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContactFlowModules` operation.
    ///
    /// See [`ListContactFlowModules`](crate::client::fluent_builders::ListContactFlowModules) for more information about the
    /// operation and its arguments.
    pub fn list_contact_flow_modules(&self) -> fluent_builders::ListContactFlowModules<C, M, R> {
        fluent_builders::ListContactFlowModules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContactFlows` operation.
    ///
    /// See [`ListContactFlows`](crate::client::fluent_builders::ListContactFlows) for more information about the
    /// operation and its arguments.
    pub fn list_contact_flows(&self) -> fluent_builders::ListContactFlows<C, M, R> {
        fluent_builders::ListContactFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListContactReferences` operation.
    ///
    /// See [`ListContactReferences`](crate::client::fluent_builders::ListContactReferences) for more information about the
    /// operation and its arguments.
    pub fn list_contact_references(&self) -> fluent_builders::ListContactReferences<C, M, R> {
        fluent_builders::ListContactReferences::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListHoursOfOperations` operation.
    ///
    /// See [`ListHoursOfOperations`](crate::client::fluent_builders::ListHoursOfOperations) for more information about the
    /// operation and its arguments.
    pub fn list_hours_of_operations(&self) -> fluent_builders::ListHoursOfOperations<C, M, R> {
        fluent_builders::ListHoursOfOperations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstanceAttributes` operation.
    ///
    /// See [`ListInstanceAttributes`](crate::client::fluent_builders::ListInstanceAttributes) for more information about the
    /// operation and its arguments.
    pub fn list_instance_attributes(&self) -> fluent_builders::ListInstanceAttributes<C, M, R> {
        fluent_builders::ListInstanceAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstances` operation.
    ///
    /// See [`ListInstances`](crate::client::fluent_builders::ListInstances) for more information about the
    /// operation and its arguments.
    pub fn list_instances(&self) -> fluent_builders::ListInstances<C, M, R> {
        fluent_builders::ListInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInstanceStorageConfigs` operation.
    ///
    /// See [`ListInstanceStorageConfigs`](crate::client::fluent_builders::ListInstanceStorageConfigs) for more information about the
    /// operation and its arguments.
    pub fn list_instance_storage_configs(
        &self,
    ) -> fluent_builders::ListInstanceStorageConfigs<C, M, R> {
        fluent_builders::ListInstanceStorageConfigs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListIntegrationAssociations` operation.
    ///
    /// See [`ListIntegrationAssociations`](crate::client::fluent_builders::ListIntegrationAssociations) for more information about the
    /// operation and its arguments.
    pub fn list_integration_associations(
        &self,
    ) -> fluent_builders::ListIntegrationAssociations<C, M, R> {
        fluent_builders::ListIntegrationAssociations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLambdaFunctions` operation.
    ///
    /// See [`ListLambdaFunctions`](crate::client::fluent_builders::ListLambdaFunctions) for more information about the
    /// operation and its arguments.
    pub fn list_lambda_functions(&self) -> fluent_builders::ListLambdaFunctions<C, M, R> {
        fluent_builders::ListLambdaFunctions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListLexBots` operation.
    ///
    /// See [`ListLexBots`](crate::client::fluent_builders::ListLexBots) for more information about the
    /// operation and its arguments.
    pub fn list_lex_bots(&self) -> fluent_builders::ListLexBots<C, M, R> {
        fluent_builders::ListLexBots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPhoneNumbers` operation.
    ///
    /// See [`ListPhoneNumbers`](crate::client::fluent_builders::ListPhoneNumbers) for more information about the
    /// operation and its arguments.
    pub fn list_phone_numbers(&self) -> fluent_builders::ListPhoneNumbers<C, M, R> {
        fluent_builders::ListPhoneNumbers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPrompts` operation.
    ///
    /// See [`ListPrompts`](crate::client::fluent_builders::ListPrompts) for more information about the
    /// operation and its arguments.
    pub fn list_prompts(&self) -> fluent_builders::ListPrompts<C, M, R> {
        fluent_builders::ListPrompts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQueueQuickConnects` operation.
    ///
    /// See [`ListQueueQuickConnects`](crate::client::fluent_builders::ListQueueQuickConnects) for more information about the
    /// operation and its arguments.
    pub fn list_queue_quick_connects(&self) -> fluent_builders::ListQueueQuickConnects<C, M, R> {
        fluent_builders::ListQueueQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQueues` operation.
    ///
    /// See [`ListQueues`](crate::client::fluent_builders::ListQueues) for more information about the
    /// operation and its arguments.
    pub fn list_queues(&self) -> fluent_builders::ListQueues<C, M, R> {
        fluent_builders::ListQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQuickConnects` operation.
    ///
    /// See [`ListQuickConnects`](crate::client::fluent_builders::ListQuickConnects) for more information about the
    /// operation and its arguments.
    pub fn list_quick_connects(&self) -> fluent_builders::ListQuickConnects<C, M, R> {
        fluent_builders::ListQuickConnects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoutingProfileQueues` operation.
    ///
    /// See [`ListRoutingProfileQueues`](crate::client::fluent_builders::ListRoutingProfileQueues) for more information about the
    /// operation and its arguments.
    pub fn list_routing_profile_queues(
        &self,
    ) -> fluent_builders::ListRoutingProfileQueues<C, M, R> {
        fluent_builders::ListRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListRoutingProfiles` operation.
    ///
    /// See [`ListRoutingProfiles`](crate::client::fluent_builders::ListRoutingProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_routing_profiles(&self) -> fluent_builders::ListRoutingProfiles<C, M, R> {
        fluent_builders::ListRoutingProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSecurityKeys` operation.
    ///
    /// See [`ListSecurityKeys`](crate::client::fluent_builders::ListSecurityKeys) for more information about the
    /// operation and its arguments.
    pub fn list_security_keys(&self) -> fluent_builders::ListSecurityKeys<C, M, R> {
        fluent_builders::ListSecurityKeys::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSecurityProfilePermissions` operation.
    ///
    /// See [`ListSecurityProfilePermissions`](crate::client::fluent_builders::ListSecurityProfilePermissions) for more information about the
    /// operation and its arguments.
    pub fn list_security_profile_permissions(
        &self,
    ) -> fluent_builders::ListSecurityProfilePermissions<C, M, R> {
        fluent_builders::ListSecurityProfilePermissions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListSecurityProfiles` operation.
    ///
    /// See [`ListSecurityProfiles`](crate::client::fluent_builders::ListSecurityProfiles) for more information about the
    /// operation and its arguments.
    pub fn list_security_profiles(&self) -> fluent_builders::ListSecurityProfiles<C, M, R> {
        fluent_builders::ListSecurityProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUseCases` operation.
    ///
    /// See [`ListUseCases`](crate::client::fluent_builders::ListUseCases) for more information about the
    /// operation and its arguments.
    pub fn list_use_cases(&self) -> fluent_builders::ListUseCases<C, M, R> {
        fluent_builders::ListUseCases::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUserHierarchyGroups` operation.
    ///
    /// See [`ListUserHierarchyGroups`](crate::client::fluent_builders::ListUserHierarchyGroups) for more information about the
    /// operation and its arguments.
    pub fn list_user_hierarchy_groups(&self) -> fluent_builders::ListUserHierarchyGroups<C, M, R> {
        fluent_builders::ListUserHierarchyGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListUsers` operation.
    ///
    /// See [`ListUsers`](crate::client::fluent_builders::ListUsers) for more information about the
    /// operation and its arguments.
    pub fn list_users(&self) -> fluent_builders::ListUsers<C, M, R> {
        fluent_builders::ListUsers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResumeContactRecording` operation.
    ///
    /// See [`ResumeContactRecording`](crate::client::fluent_builders::ResumeContactRecording) for more information about the
    /// operation and its arguments.
    pub fn resume_contact_recording(&self) -> fluent_builders::ResumeContactRecording<C, M, R> {
        fluent_builders::ResumeContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartChatContact` operation.
    ///
    /// See [`StartChatContact`](crate::client::fluent_builders::StartChatContact) for more information about the
    /// operation and its arguments.
    pub fn start_chat_contact(&self) -> fluent_builders::StartChatContact<C, M, R> {
        fluent_builders::StartChatContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartContactRecording` operation.
    ///
    /// See [`StartContactRecording`](crate::client::fluent_builders::StartContactRecording) for more information about the
    /// operation and its arguments.
    pub fn start_contact_recording(&self) -> fluent_builders::StartContactRecording<C, M, R> {
        fluent_builders::StartContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartContactStreaming` operation.
    ///
    /// See [`StartContactStreaming`](crate::client::fluent_builders::StartContactStreaming) for more information about the
    /// operation and its arguments.
    pub fn start_contact_streaming(&self) -> fluent_builders::StartContactStreaming<C, M, R> {
        fluent_builders::StartContactStreaming::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartOutboundVoiceContact` operation.
    ///
    /// See [`StartOutboundVoiceContact`](crate::client::fluent_builders::StartOutboundVoiceContact) for more information about the
    /// operation and its arguments.
    pub fn start_outbound_voice_contact(
        &self,
    ) -> fluent_builders::StartOutboundVoiceContact<C, M, R> {
        fluent_builders::StartOutboundVoiceContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartTaskContact` operation.
    ///
    /// See [`StartTaskContact`](crate::client::fluent_builders::StartTaskContact) for more information about the
    /// operation and its arguments.
    pub fn start_task_contact(&self) -> fluent_builders::StartTaskContact<C, M, R> {
        fluent_builders::StartTaskContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopContact` operation.
    ///
    /// See [`StopContact`](crate::client::fluent_builders::StopContact) for more information about the
    /// operation and its arguments.
    pub fn stop_contact(&self) -> fluent_builders::StopContact<C, M, R> {
        fluent_builders::StopContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopContactRecording` operation.
    ///
    /// See [`StopContactRecording`](crate::client::fluent_builders::StopContactRecording) for more information about the
    /// operation and its arguments.
    pub fn stop_contact_recording(&self) -> fluent_builders::StopContactRecording<C, M, R> {
        fluent_builders::StopContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopContactStreaming` operation.
    ///
    /// See [`StopContactStreaming`](crate::client::fluent_builders::StopContactStreaming) for more information about the
    /// operation and its arguments.
    pub fn stop_contact_streaming(&self) -> fluent_builders::StopContactStreaming<C, M, R> {
        fluent_builders::StopContactStreaming::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SuspendContactRecording` operation.
    ///
    /// See [`SuspendContactRecording`](crate::client::fluent_builders::SuspendContactRecording) for more information about the
    /// operation and its arguments.
    pub fn suspend_contact_recording(&self) -> fluent_builders::SuspendContactRecording<C, M, R> {
        fluent_builders::SuspendContactRecording::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateAgentStatus` operation.
    ///
    /// See [`UpdateAgentStatus`](crate::client::fluent_builders::UpdateAgentStatus) for more information about the
    /// operation and its arguments.
    pub fn update_agent_status(&self) -> fluent_builders::UpdateAgentStatus<C, M, R> {
        fluent_builders::UpdateAgentStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContact` operation.
    ///
    /// See [`UpdateContact`](crate::client::fluent_builders::UpdateContact) for more information about the
    /// operation and its arguments.
    pub fn update_contact(&self) -> fluent_builders::UpdateContact<C, M, R> {
        fluent_builders::UpdateContact::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactAttributes` operation.
    ///
    /// See [`UpdateContactAttributes`](crate::client::fluent_builders::UpdateContactAttributes) for more information about the
    /// operation and its arguments.
    pub fn update_contact_attributes(&self) -> fluent_builders::UpdateContactAttributes<C, M, R> {
        fluent_builders::UpdateContactAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactFlowContent` operation.
    ///
    /// See [`UpdateContactFlowContent`](crate::client::fluent_builders::UpdateContactFlowContent) for more information about the
    /// operation and its arguments.
    pub fn update_contact_flow_content(
        &self,
    ) -> fluent_builders::UpdateContactFlowContent<C, M, R> {
        fluent_builders::UpdateContactFlowContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactFlowMetadata` operation.
    ///
    /// See [`UpdateContactFlowMetadata`](crate::client::fluent_builders::UpdateContactFlowMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_contact_flow_metadata(
        &self,
    ) -> fluent_builders::UpdateContactFlowMetadata<C, M, R> {
        fluent_builders::UpdateContactFlowMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactFlowModuleContent` operation.
    ///
    /// See [`UpdateContactFlowModuleContent`](crate::client::fluent_builders::UpdateContactFlowModuleContent) for more information about the
    /// operation and its arguments.
    pub fn update_contact_flow_module_content(
        &self,
    ) -> fluent_builders::UpdateContactFlowModuleContent<C, M, R> {
        fluent_builders::UpdateContactFlowModuleContent::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactFlowModuleMetadata` operation.
    ///
    /// See [`UpdateContactFlowModuleMetadata`](crate::client::fluent_builders::UpdateContactFlowModuleMetadata) for more information about the
    /// operation and its arguments.
    pub fn update_contact_flow_module_metadata(
        &self,
    ) -> fluent_builders::UpdateContactFlowModuleMetadata<C, M, R> {
        fluent_builders::UpdateContactFlowModuleMetadata::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactFlowName` operation.
    ///
    /// See [`UpdateContactFlowName`](crate::client::fluent_builders::UpdateContactFlowName) for more information about the
    /// operation and its arguments.
    pub fn update_contact_flow_name(&self) -> fluent_builders::UpdateContactFlowName<C, M, R> {
        fluent_builders::UpdateContactFlowName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateContactSchedule` operation.
    ///
    /// See [`UpdateContactSchedule`](crate::client::fluent_builders::UpdateContactSchedule) for more information about the
    /// operation and its arguments.
    pub fn update_contact_schedule(&self) -> fluent_builders::UpdateContactSchedule<C, M, R> {
        fluent_builders::UpdateContactSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateHoursOfOperation` operation.
    ///
    /// See [`UpdateHoursOfOperation`](crate::client::fluent_builders::UpdateHoursOfOperation) for more information about the
    /// operation and its arguments.
    pub fn update_hours_of_operation(&self) -> fluent_builders::UpdateHoursOfOperation<C, M, R> {
        fluent_builders::UpdateHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInstanceAttribute` operation.
    ///
    /// See [`UpdateInstanceAttribute`](crate::client::fluent_builders::UpdateInstanceAttribute) for more information about the
    /// operation and its arguments.
    pub fn update_instance_attribute(&self) -> fluent_builders::UpdateInstanceAttribute<C, M, R> {
        fluent_builders::UpdateInstanceAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateInstanceStorageConfig` operation.
    ///
    /// See [`UpdateInstanceStorageConfig`](crate::client::fluent_builders::UpdateInstanceStorageConfig) for more information about the
    /// operation and its arguments.
    pub fn update_instance_storage_config(
        &self,
    ) -> fluent_builders::UpdateInstanceStorageConfig<C, M, R> {
        fluent_builders::UpdateInstanceStorageConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQueueHoursOfOperation` operation.
    ///
    /// See [`UpdateQueueHoursOfOperation`](crate::client::fluent_builders::UpdateQueueHoursOfOperation) for more information about the
    /// operation and its arguments.
    pub fn update_queue_hours_of_operation(
        &self,
    ) -> fluent_builders::UpdateQueueHoursOfOperation<C, M, R> {
        fluent_builders::UpdateQueueHoursOfOperation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQueueMaxContacts` operation.
    ///
    /// See [`UpdateQueueMaxContacts`](crate::client::fluent_builders::UpdateQueueMaxContacts) for more information about the
    /// operation and its arguments.
    pub fn update_queue_max_contacts(&self) -> fluent_builders::UpdateQueueMaxContacts<C, M, R> {
        fluent_builders::UpdateQueueMaxContacts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQueueName` operation.
    ///
    /// See [`UpdateQueueName`](crate::client::fluent_builders::UpdateQueueName) for more information about the
    /// operation and its arguments.
    pub fn update_queue_name(&self) -> fluent_builders::UpdateQueueName<C, M, R> {
        fluent_builders::UpdateQueueName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQueueOutboundCallerConfig` operation.
    ///
    /// See [`UpdateQueueOutboundCallerConfig`](crate::client::fluent_builders::UpdateQueueOutboundCallerConfig) for more information about the
    /// operation and its arguments.
    pub fn update_queue_outbound_caller_config(
        &self,
    ) -> fluent_builders::UpdateQueueOutboundCallerConfig<C, M, R> {
        fluent_builders::UpdateQueueOutboundCallerConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQueueStatus` operation.
    ///
    /// See [`UpdateQueueStatus`](crate::client::fluent_builders::UpdateQueueStatus) for more information about the
    /// operation and its arguments.
    pub fn update_queue_status(&self) -> fluent_builders::UpdateQueueStatus<C, M, R> {
        fluent_builders::UpdateQueueStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQuickConnectConfig` operation.
    ///
    /// See [`UpdateQuickConnectConfig`](crate::client::fluent_builders::UpdateQuickConnectConfig) for more information about the
    /// operation and its arguments.
    pub fn update_quick_connect_config(
        &self,
    ) -> fluent_builders::UpdateQuickConnectConfig<C, M, R> {
        fluent_builders::UpdateQuickConnectConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQuickConnectName` operation.
    ///
    /// See [`UpdateQuickConnectName`](crate::client::fluent_builders::UpdateQuickConnectName) for more information about the
    /// operation and its arguments.
    pub fn update_quick_connect_name(&self) -> fluent_builders::UpdateQuickConnectName<C, M, R> {
        fluent_builders::UpdateQuickConnectName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoutingProfileConcurrency` operation.
    ///
    /// See [`UpdateRoutingProfileConcurrency`](crate::client::fluent_builders::UpdateRoutingProfileConcurrency) for more information about the
    /// operation and its arguments.
    pub fn update_routing_profile_concurrency(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileConcurrency<C, M, R> {
        fluent_builders::UpdateRoutingProfileConcurrency::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoutingProfileDefaultOutboundQueue` operation.
    ///
    /// See [`UpdateRoutingProfileDefaultOutboundQueue`](crate::client::fluent_builders::UpdateRoutingProfileDefaultOutboundQueue) for more information about the
    /// operation and its arguments.
    pub fn update_routing_profile_default_outbound_queue(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileDefaultOutboundQueue<C, M, R> {
        fluent_builders::UpdateRoutingProfileDefaultOutboundQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoutingProfileName` operation.
    ///
    /// See [`UpdateRoutingProfileName`](crate::client::fluent_builders::UpdateRoutingProfileName) for more information about the
    /// operation and its arguments.
    pub fn update_routing_profile_name(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileName<C, M, R> {
        fluent_builders::UpdateRoutingProfileName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateRoutingProfileQueues` operation.
    ///
    /// See [`UpdateRoutingProfileQueues`](crate::client::fluent_builders::UpdateRoutingProfileQueues) for more information about the
    /// operation and its arguments.
    pub fn update_routing_profile_queues(
        &self,
    ) -> fluent_builders::UpdateRoutingProfileQueues<C, M, R> {
        fluent_builders::UpdateRoutingProfileQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateSecurityProfile` operation.
    ///
    /// See [`UpdateSecurityProfile`](crate::client::fluent_builders::UpdateSecurityProfile) for more information about the
    /// operation and its arguments.
    pub fn update_security_profile(&self) -> fluent_builders::UpdateSecurityProfile<C, M, R> {
        fluent_builders::UpdateSecurityProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserHierarchy` operation.
    ///
    /// See [`UpdateUserHierarchy`](crate::client::fluent_builders::UpdateUserHierarchy) for more information about the
    /// operation and its arguments.
    pub fn update_user_hierarchy(&self) -> fluent_builders::UpdateUserHierarchy<C, M, R> {
        fluent_builders::UpdateUserHierarchy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserHierarchyGroupName` operation.
    ///
    /// See [`UpdateUserHierarchyGroupName`](crate::client::fluent_builders::UpdateUserHierarchyGroupName) for more information about the
    /// operation and its arguments.
    pub fn update_user_hierarchy_group_name(
        &self,
    ) -> fluent_builders::UpdateUserHierarchyGroupName<C, M, R> {
        fluent_builders::UpdateUserHierarchyGroupName::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserHierarchyStructure` operation.
    ///
    /// See [`UpdateUserHierarchyStructure`](crate::client::fluent_builders::UpdateUserHierarchyStructure) for more information about the
    /// operation and its arguments.
    pub fn update_user_hierarchy_structure(
        &self,
    ) -> fluent_builders::UpdateUserHierarchyStructure<C, M, R> {
        fluent_builders::UpdateUserHierarchyStructure::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserIdentityInfo` operation.
    ///
    /// See [`UpdateUserIdentityInfo`](crate::client::fluent_builders::UpdateUserIdentityInfo) for more information about the
    /// operation and its arguments.
    pub fn update_user_identity_info(&self) -> fluent_builders::UpdateUserIdentityInfo<C, M, R> {
        fluent_builders::UpdateUserIdentityInfo::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserPhoneConfig` operation.
    ///
    /// See [`UpdateUserPhoneConfig`](crate::client::fluent_builders::UpdateUserPhoneConfig) for more information about the
    /// operation and its arguments.
    pub fn update_user_phone_config(&self) -> fluent_builders::UpdateUserPhoneConfig<C, M, R> {
        fluent_builders::UpdateUserPhoneConfig::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserRoutingProfile` operation.
    ///
    /// See [`UpdateUserRoutingProfile`](crate::client::fluent_builders::UpdateUserRoutingProfile) for more information about the
    /// operation and its arguments.
    pub fn update_user_routing_profile(
        &self,
    ) -> fluent_builders::UpdateUserRoutingProfile<C, M, R> {
        fluent_builders::UpdateUserRoutingProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateUserSecurityProfiles` operation.
    ///
    /// See [`UpdateUserSecurityProfiles`](crate::client::fluent_builders::UpdateUserSecurityProfiles) for more information about the
    /// operation and its arguments.
    pub fn update_user_security_profiles(
        &self,
    ) -> fluent_builders::UpdateUserSecurityProfiles<C, M, R> {
        fluent_builders::UpdateUserSecurityProfiles::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateApprovedOrigin`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates an approved origin to an Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateApprovedOrigin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_approved_origin_input::Builder,
    }
    impl<C, M, R> AssociateApprovedOrigin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateApprovedOrigin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateApprovedOriginOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateApprovedOriginError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateApprovedOriginInputOperationOutputAlias,
                crate::output::AssociateApprovedOriginOutput,
                crate::error::AssociateApprovedOriginError,
                crate::input::AssociateApprovedOriginInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The domain to add to your allow list.</p>
        pub fn origin(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin(inp);
            self
        }
        /// <p>The domain to add to your allow list.</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_bot_input::Builder,
    }
    impl<C, M, R> AssociateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateBotInputOperationOutputAlias,
                crate::output::AssociateBotOutput,
                crate::error::AssociateBotError,
                crate::input::AssociateBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn lex_bot(mut self, inp: crate::model::LexBot) -> Self {
            self.inner = self.inner.lex_bot(inp);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.inner = self.inner.set_lex_bot(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to associate with the instance.</p>
        pub fn lex_v2_bot(mut self, inp: crate::model::LexV2Bot) -> Self {
            self.inner = self.inner.lex_v2_bot(inp);
            self
        }
        /// <p>The Amazon Lex V2 bot to associate with the instance.</p>
        pub fn set_lex_v2_bot(
            mut self,
            input: std::option::Option<crate::model::LexV2Bot>,
        ) -> Self {
            self.inner = self.inner.set_lex_v2_bot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates a storage resource type for the first time. You can only associate one type of
    /// storage configuration in a single call. This means, for example, that you can't define an
    /// instance with multiple S3 buckets for storing chat transcripts.</p>
    /// <p>This API does not create a resource that doesn't exist. It only associates it to the
    /// instance. Ensure that the resource being specified in the storage configuration, like an S3
    /// bucket, exists when being used for association.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_instance_storage_config_input::Builder,
    }
    impl<C, M, R> AssociateInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateInstanceStorageConfigInputOperationOutputAlias,
                crate::output::AssociateInstanceStorageConfigOutput,
                crate::error::AssociateInstanceStorageConfigError,
                crate::input::AssociateInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, inp: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>A valid storage type.</p>
        pub fn storage_config(mut self, inp: crate::model::InstanceStorageConfig) -> Self {
            self.inner = self.inner.storage_config(inp);
            self
        }
        /// <p>A valid storage type.</p>
        pub fn set_storage_config(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageConfig>,
        ) -> Self {
            self.inner = self.inner.set_storage_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateLambdaFunction`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Allows the specified Amazon Connect instance to access the specified Lambda function.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateLambdaFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_lambda_function_input::Builder,
    }
    impl<C, M, R> AssociateLambdaFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLambdaFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLambdaFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLambdaFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLambdaFunctionInputOperationOutputAlias,
                crate::output::AssociateLambdaFunctionOutput,
                crate::error::AssociateLambdaFunctionError,
                crate::input::AssociateLambdaFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is
        /// 140.</p>
        pub fn function_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is
        /// 140.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateLexBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateLexBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_lex_bot_input::Builder,
    }
    impl<C, M, R> AssociateLexBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateLexBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateLexBotOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateLexBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateLexBotInputOperationOutputAlias,
                crate::output::AssociateLexBotOutput,
                crate::error::AssociateLexBotError,
                crate::input::AssociateLexBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The Amazon Lex bot to associate with the instance.</p>
        pub fn lex_bot(mut self, inp: crate::model::LexBot) -> Self {
            self.inner = self.inner.lex_bot(inp);
            self
        }
        /// <p>The Amazon Lex bot to associate with the instance.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.inner = self.inner.set_lex_bot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateQueueQuickConnects`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates a set of quick connects with a queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateQueueQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_queue_quick_connects_input::Builder,
    }
    impl<C, M, R> AssociateQueueQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateQueueQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateQueueQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateQueueQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateQueueQuickConnectsInputOperationOutputAlias,
                crate::output::AssociateQueueQuickConnectsOutput,
                crate::error::AssociateQueueQuickConnectsError,
                crate::input::AssociateQueueQuickConnectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// Appends an item to `QuickConnectIds`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects to associate with this queue.</p>
        pub fn quick_connect_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_ids(inp);
            self
        }
        /// <p>The quick connects to associate with this queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateRoutingProfileQueues`.
    ///
    /// <p>Associates a set of queues with a routing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> AssociateRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::AssociateRoutingProfileQueuesOutput,
                crate::error::AssociateRoutingProfileQueuesError,
                crate::input::AssociateRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `QueueConfigs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The queues to associate with this routing profile.</p>
        pub fn queue_configs(
            mut self,
            inp: impl Into<crate::model::RoutingProfileQueueConfig>,
        ) -> Self {
            self.inner = self.inner.queue_configs(inp);
            self
        }
        /// <p>The queues to associate with this routing profile.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.inner = self.inner.set_queue_configs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateSecurityKey`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Associates a security key to the instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateSecurityKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_security_key_input::Builder,
    }
    impl<C, M, R> AssociateSecurityKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateSecurityKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateSecurityKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateSecurityKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateSecurityKeyInputOperationOutputAlias,
                crate::output::AssociateSecurityKeyOutput,
                crate::error::AssociateSecurityKeyError,
                crate::input::AssociateSecurityKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A valid security key in PEM format.</p>
        pub fn key(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.key(inp);
            self
        }
        /// <p>A valid security key in PEM format.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_key(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAgentStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates an agent status for the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAgentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_agent_status_input::Builder,
    }
    impl<C, M, R> CreateAgentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAgentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAgentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAgentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAgentStatusInputOperationOutputAlias,
                crate::output::CreateAgentStatusOutput,
                crate::error::CreateAgentStatusError,
                crate::input::CreateAgentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the status.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the status.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of the status.</p>
        pub fn state(mut self, inp: crate::model::AgentStatusState) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The state of the status.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AgentStatusState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The display order of the status.</p>
        pub fn display_order(mut self, inp: i32) -> Self {
            self.inner = self.inner.display_order(inp);
            self
        }
        /// <p>The display order of the status.</p>
        pub fn set_display_order(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_display_order(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactFlow`.
    ///
    /// <p>Creates a contact flow for the specified Amazon Connect instance.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect
    /// Flow language</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContactFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_flow_input::Builder,
    }
    impl<C, M, R> CreateContactFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactFlowInputOperationOutputAlias,
                crate::output::CreateContactFlowOutput,
                crate::error::CreateContactFlowError,
                crate::input::CreateContactFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator
        /// Guide</i>.</p>
        pub fn r#type(mut self, inp: crate::model::ContactFlowType) -> Self {
            self.inner = self.inner.r#type(inp);
            self
        }
        /// <p>The type of the contact flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a Contact Flow Type</a> in the <i>Amazon Connect Administrator
        /// Guide</i>.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::ContactFlowType>,
        ) -> Self {
            self.inner = self.inner.set_type(input);
            self
        }
        /// <p>The description of the contact flow. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the contact flow. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The content of the contact flow. </p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the contact flow. </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateContactFlowModule`.
    ///
    /// <p>Creates a contact flow module for the specified Amazon Connect instance. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateContactFlowModule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_contact_flow_module_input::Builder,
    }
    impl<C, M, R> CreateContactFlowModule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateContactFlowModule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateContactFlowModuleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateContactFlowModuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateContactFlowModuleInputOperationOutputAlias,
                crate::output::CreateContactFlowModuleOutput,
                crate::error::CreateContactFlowModuleError,
                crate::input::CreateContactFlowModuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow module. </p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the contact flow module. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates hours of operation. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hours_of_operation_input::Builder,
    }
    impl<C, M, R> CreateHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHoursOfOperationInputOperationOutputAlias,
                crate::output::CreateHoursOfOperationOutput,
                crate::error::CreateHoursOfOperationError,
                crate::input::CreateHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn time_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_zone(inp);
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_zone(input);
            self
        }
        /// Appends an item to `Config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>Configuration information for the hours of operation: day, start time, and end time.</p>
        pub fn config(mut self, inp: impl Into<crate::model::HoursOfOperationConfig>) -> Self {
            self.inner = self.inner.config(inp);
            self
        }
        /// <p>Configuration information for the hours of operation: day, start time, and end time.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInstance`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any
    /// storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not
    /// allow for any configurations on features, such as Contact Lens for Amazon Connect. </p>
    /// <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days.
    /// If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances.
    /// You must wait 30 days before you can restart creating and deleting instances in your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_instance_input::Builder,
    }
    impl<C, M, R> CreateInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInstanceInputOperationOutputAlias,
                crate::output::CreateInstanceOutput,
                crate::error::CreateInstanceError,
                crate::input::CreateInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The idempotency token.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>The idempotency token.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The type of identity management for your Amazon Connect users.</p>
        pub fn identity_management_type(mut self, inp: crate::model::DirectoryType) -> Self {
            self.inner = self.inner.identity_management_type(inp);
            self
        }
        /// <p>The type of identity management for your Amazon Connect users.</p>
        pub fn set_identity_management_type(
            mut self,
            input: std::option::Option<crate::model::DirectoryType>,
        ) -> Self {
            self.inner = self.inner.set_identity_management_type(input);
            self
        }
        /// <p>The name for your instance.</p>
        pub fn instance_alias(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_alias(inp);
            self
        }
        /// <p>The name for your instance.</p>
        pub fn set_instance_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_instance_alias(input);
            self
        }
        /// <p>The identifier for the directory.</p>
        pub fn directory_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_id(inp);
            self
        }
        /// <p>The identifier for the directory.</p>
        pub fn set_directory_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_directory_id(input);
            self
        }
        /// <p>Your contact center handles incoming contacts.</p>
        pub fn inbound_calls_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.inbound_calls_enabled(inp);
            self
        }
        /// <p>Your contact center handles incoming contacts.</p>
        pub fn set_inbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_inbound_calls_enabled(input);
            self
        }
        /// <p>Your contact center allows outbound calls.</p>
        pub fn outbound_calls_enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.outbound_calls_enabled(inp);
            self
        }
        /// <p>Your contact center allows outbound calls.</p>
        pub fn set_outbound_calls_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_outbound_calls_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateIntegrationAssociation`.
    ///
    /// <p>Creates an AWS resource association with an Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateIntegrationAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_integration_association_input::Builder,
    }
    impl<C, M, R> CreateIntegrationAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateIntegrationAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateIntegrationAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateIntegrationAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateIntegrationAssociationInputOperationOutputAlias,
                crate::output::CreateIntegrationAssociationOutput,
                crate::error::CreateIntegrationAssociationError,
                crate::input::CreateIntegrationAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of information to be ingested.</p>
        pub fn integration_type(mut self, inp: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(inp);
            self
        }
        /// <p>The type of information to be ingested.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the integration.</p>
        pub fn integration_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the integration.</p>
        pub fn set_integration_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_arn(input);
            self
        }
        /// <p>The URL for the external application. This field is only required for the EVENT integration type.</p>
        pub fn source_application_url(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_application_url(inp);
            self
        }
        /// <p>The URL for the external application. This field is only required for the EVENT integration type.</p>
        pub fn set_source_application_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_application_url(input);
            self
        }
        /// <p>The name of the external application. This field is only required for the EVENT integration type.</p>
        pub fn source_application_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_application_name(inp);
            self
        }
        /// <p>The name of the external application. This field is only required for the EVENT integration type.</p>
        pub fn set_source_application_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_application_name(input);
            self
        }
        /// <p>The type of the data source. This field is only required for the EVENT integration type.</p>
        pub fn source_type(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of the data source. This field is only required for the EVENT integration type.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQueue`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates a new queue for the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_queue_input::Builder,
    }
    impl<C, M, R> CreateQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQueueInputOperationOutputAlias,
                crate::output::CreateQueueOutput,
                crate::error::CreateQueueError,
                crate::input::CreateQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the queue.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the queue.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the queue.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn outbound_caller_config(mut self, inp: crate::model::OutboundCallerConfig) -> Self {
            self.inner = self.inner.outbound_caller_config(inp);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn set_outbound_caller_config(
            mut self,
            input: std::option::Option<crate::model::OutboundCallerConfig>,
        ) -> Self {
            self.inner = self.inner.set_outbound_caller_config(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(inp);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn max_contacts(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_contacts(inp);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn set_max_contacts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_contacts(input);
            self
        }
        /// Appends an item to `QuickConnectIds`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects available to agents who are working the queue.</p>
        pub fn quick_connect_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_ids(inp);
            self
        }
        /// <p>The quick connects available to agents who are working the queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_ids(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQuickConnect`.
    ///
    /// <p>Creates a quick connect for the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateQuickConnect<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_quick_connect_input::Builder,
    }
    impl<C, M, R> CreateQuickConnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQuickConnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQuickConnectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQuickConnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQuickConnectInputOperationOutputAlias,
                crate::output::CreateQuickConnectOutput,
                crate::error::CreateQuickConnectError,
                crate::input::CreateQuickConnectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>Configuration settings for the quick connect.</p>
        pub fn quick_connect_config(mut self, inp: crate::model::QuickConnectConfig) -> Self {
            self.inner = self.inner.quick_connect_config(inp);
            self
        }
        /// <p>Configuration settings for the quick connect.</p>
        pub fn set_quick_connect_config(
            mut self,
            input: std::option::Option<crate::model::QuickConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_config(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRoutingProfile`.
    ///
    /// <p>Creates a new routing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRoutingProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_routing_profile_input::Builder,
    }
    impl<C, M, R> CreateRoutingProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRoutingProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRoutingProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRoutingProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRoutingProfileInputOperationOutputAlias,
                crate::output::CreateRoutingProfileOutput,
                crate::error::CreateRoutingProfileError,
                crate::input::CreateRoutingProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>Description of the routing profile. Must not be more than 250 characters.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>Description of the routing profile. Must not be more than 250 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The default outbound queue for the routing profile.</p>
        pub fn default_outbound_queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_outbound_queue_id(inp);
            self
        }
        /// <p>The default outbound queue for the routing profile.</p>
        pub fn set_default_outbound_queue_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_outbound_queue_id(input);
            self
        }
        /// Appends an item to `QueueConfigs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The inbound queues associated with the routing profile. If no queue is added, the agent can
        /// make only outbound calls.</p>
        pub fn queue_configs(
            mut self,
            inp: impl Into<crate::model::RoutingProfileQueueConfig>,
        ) -> Self {
            self.inner = self.inner.queue_configs(inp);
            self
        }
        /// <p>The inbound queues associated with the routing profile. If no queue is added, the agent can
        /// make only outbound calls.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.inner = self.inner.set_queue_configs(input);
            self
        }
        /// Appends an item to `MediaConcurrencies`.
        ///
        /// To override the contents of this collection use [`set_media_concurrencies`](Self::set_media_concurrencies).
        ///
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing
        /// profile.</p>
        pub fn media_concurrencies(
            mut self,
            inp: impl Into<crate::model::MediaConcurrency>,
        ) -> Self {
            self.inner = self.inner.media_concurrencies(inp);
            self
        }
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing
        /// profile.</p>
        pub fn set_media_concurrencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        ) -> Self {
            self.inner = self.inner.set_media_concurrencies(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Creates a security profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_security_profile_input::Builder,
    }
    impl<C, M, R> CreateSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSecurityProfileInputOperationOutputAlias,
                crate::output::CreateSecurityProfileOutput,
                crate::error::CreateSecurityProfileError,
                crate::input::CreateSecurityProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security profile.</p>
        pub fn security_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_name(inp);
            self
        }
        /// <p>The name of the security profile.</p>
        pub fn set_security_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_name(input);
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>Permissions assigned to the security profile.</p>
        pub fn permissions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>Permissions assigned to the security profile.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUseCase`.
    ///
    /// <p>Creates a use case for an integration association.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUseCase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_use_case_input::Builder,
    }
    impl<C, M, R> CreateUseCase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUseCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUseCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUseCaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUseCaseInputOperationOutputAlias,
                crate::output::CreateUseCaseOutput,
                crate::error::CreateUseCaseError,
                crate::input::CreateUseCaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(inp);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration
        /// association can have only one of each use case type.</p>
        pub fn use_case_type(mut self, inp: crate::model::UseCaseType) -> Self {
            self.inner = self.inner.use_case_type(inp);
            self
        }
        /// <p>The type of use case to associate to the integration association. Each integration
        /// association can have only one of each use case type.</p>
        pub fn set_use_case_type(
            mut self,
            input: std::option::Option<crate::model::UseCaseType>,
        ) -> Self {
            self.inner = self.inner.set_use_case_type(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags used to organize, track, or control access for this resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUser`.
    ///
    /// <p>Creates a user account for the specified Amazon Connect instance.</p>
    /// <p>For information about how to create user accounts using the Amazon Connect console, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in
    /// the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_input::Builder,
    }
    impl<C, M, R> CreateUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserInputOperationOutputAlias,
                crate::output::CreateUserOutput,
                crate::error::CreateUserError,
                crate::input::CreateUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The user name for the account. For instances not using SAML for identity management, the
        /// user name can include up to 20 characters. If you are using SAML for identity management, the
        /// user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.</p>
        pub fn username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.username(inp);
            self
        }
        /// <p>The user name for the account. For instances not using SAML for identity management, the
        /// user name can include up to 20 characters. If you are using SAML for identity management, the
        /// user name can include up to 64 characters from [a-zA-Z0-9_-.\@]+.</p>
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_username(input);
            self
        }
        /// <p>The password for the user account. A password is required if you are using Amazon Connect for
        /// identity management. Otherwise, it is an error to include a password.</p>
        pub fn password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.password(inp);
            self
        }
        /// <p>The password for the user account. A password is required if you are using Amazon Connect for
        /// identity management. Otherwise, it is an error to include a password.</p>
        pub fn set_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_password(input);
            self
        }
        /// <p>The information about the identity of the user.</p>
        pub fn identity_info(mut self, inp: crate::model::UserIdentityInfo) -> Self {
            self.inner = self.inner.identity_info(inp);
            self
        }
        /// <p>The information about the identity of the user.</p>
        pub fn set_identity_info(
            mut self,
            input: std::option::Option<crate::model::UserIdentityInfo>,
        ) -> Self {
            self.inner = self.inner.set_identity_info(input);
            self
        }
        /// <p>The phone settings for the user.</p>
        pub fn phone_config(mut self, inp: crate::model::UserPhoneConfig) -> Self {
            self.inner = self.inner.phone_config(inp);
            self
        }
        /// <p>The phone settings for the user.</p>
        pub fn set_phone_config(
            mut self,
            input: std::option::Option<crate::model::UserPhoneConfig>,
        ) -> Self {
            self.inner = self.inner.set_phone_config(input);
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management. If Amazon Connect
        /// cannot access the directory, you can specify this identifier to authenticate users. If you
        /// include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity
        /// information is used to authenticate users from your directory.</p>
        /// <p>This parameter is required if you are using an existing directory for identity management in
        /// Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for
        /// identity management and include this parameter, an error is returned.</p>
        pub fn directory_user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.directory_user_id(inp);
            self
        }
        /// <p>The identifier of the user account in the directory used for identity management. If Amazon Connect
        /// cannot access the directory, you can specify this identifier to authenticate users. If you
        /// include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity
        /// information is used to authenticate users from your directory.</p>
        /// <p>This parameter is required if you are using an existing directory for identity management in
        /// Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for
        /// identity management and include this parameter, an error is returned.</p>
        pub fn set_directory_user_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_directory_user_id(input);
            self
        }
        /// Appends an item to `SecurityProfileIds`.
        ///
        /// To override the contents of this collection use [`set_security_profile_ids`](Self::set_security_profile_ids).
        ///
        /// <p>The identifier of the security profile for the user.</p>
        pub fn security_profile_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_ids(inp);
            self
        }
        /// <p>The identifier of the security profile for the user.</p>
        pub fn set_security_profile_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_ids(input);
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn hierarchy_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(inp);
            self
        }
        /// <p>The identifier of the hierarchy group for the user.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUserHierarchyGroup`.
    ///
    /// <p>Creates a new user hierarchy group.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUserHierarchyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_user_hierarchy_group_input::Builder,
    }
    impl<C, M, R> CreateUserHierarchyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUserHierarchyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUserHierarchyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUserHierarchyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUserHierarchyGroupInputOperationOutputAlias,
                crate::output::CreateUserHierarchyGroupOutput,
                crate::error::CreateUserHierarchyGroupError,
                crate::input::CreateUserHierarchyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the user hierarchy group. Must not be more than 100 characters.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the user hierarchy group. Must not be more than 100 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if
        /// the parent group ID is null.</p>
        pub fn parent_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parent_group_id(inp);
            self
        }
        /// <p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if
        /// the parent group ID is null.</p>
        pub fn set_parent_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parent_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactFlow`.
    ///
    /// <p>Deletes a contact flow for the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContactFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_flow_input::Builder,
    }
    impl<C, M, R> DeleteContactFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactFlowInputOperationOutputAlias,
                crate::output::DeleteContactFlowOutput,
                crate::error::DeleteContactFlowError,
                crate::input::DeleteContactFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteContactFlowModule`.
    ///
    /// <p>Deletes the specified contact flow module.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteContactFlowModule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_contact_flow_module_input::Builder,
    }
    impl<C, M, R> DeleteContactFlowModule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteContactFlowModule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteContactFlowModuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteContactFlowModuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteContactFlowModuleInputOperationOutputAlias,
                crate::output::DeleteContactFlowModuleOutput,
                crate::error::DeleteContactFlowModuleError,
                crate::input::DeleteContactFlowModuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(inp);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes an hours of operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hours_of_operation_input::Builder,
    }
    impl<C, M, R> DeleteHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHoursOfOperationInputOperationOutputAlias,
                crate::output::DeleteHoursOfOperationOutput,
                crate::error::DeleteHoursOfOperationError,
                crate::input::DeleteHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(inp);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInstance`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes the Amazon Connect instance.</p>
    /// <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days.
    /// If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances.
    /// You must wait 30 days before you can restart creating and deleting instances in your account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_instance_input::Builder,
    }
    impl<C, M, R> DeleteInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInstanceInputOperationOutputAlias,
                crate::output::DeleteInstanceOutput,
                crate::error::DeleteInstanceError,
                crate::input::DeleteInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteIntegrationAssociation`.
    ///
    /// <p>Deletes an AWS resource association from an Amazon Connect instance. The association must not have
    /// any use cases associated with it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteIntegrationAssociation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_integration_association_input::Builder,
    }
    impl<C, M, R> DeleteIntegrationAssociation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteIntegrationAssociation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteIntegrationAssociationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteIntegrationAssociationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteIntegrationAssociationInputOperationOutputAlias,
                crate::output::DeleteIntegrationAssociationOutput,
                crate::error::DeleteIntegrationAssociationError,
                crate::input::DeleteIntegrationAssociationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(inp);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQuickConnect`.
    ///
    /// <p>Deletes a quick connect.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteQuickConnect<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_quick_connect_input::Builder,
    }
    impl<C, M, R> DeleteQuickConnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQuickConnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQuickConnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQuickConnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQuickConnectInputOperationOutputAlias,
                crate::output::DeleteQuickConnectOutput,
                crate::error::DeleteQuickConnectError,
                crate::input::DeleteQuickConnectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(inp);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes a security profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_security_profile_input::Builder,
    }
    impl<C, M, R> DeleteSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSecurityProfileInputOperationOutputAlias,
                crate::output::DeleteSecurityProfileOutput,
                crate::error::DeleteSecurityProfileError,
                crate::input::DeleteSecurityProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(inp);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUseCase`.
    ///
    /// <p>Deletes a use case from an integration association.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUseCase<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_use_case_input::Builder,
    }
    impl<C, M, R> DeleteUseCase<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUseCase`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUseCaseOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUseCaseError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUseCaseInputOperationOutputAlias,
                crate::output::DeleteUseCaseOutput,
                crate::error::DeleteUseCaseError,
                crate::input::DeleteUseCaseInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(inp);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
        /// <p>The identifier for the use case.</p>
        pub fn use_case_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.use_case_id(inp);
            self
        }
        /// <p>The identifier for the use case.</p>
        pub fn set_use_case_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_use_case_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUser`.
    ///
    /// <p>Deletes a user account from the specified Amazon Connect instance.</p>
    /// <p>For information about what happens to a user's data when their account is deleted, see
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from
    /// Your Amazon Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_input::Builder,
    }
    impl<C, M, R> DeleteUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserInputOperationOutputAlias,
                crate::output::DeleteUserOutput,
                crate::error::DeleteUserError,
                crate::input::DeleteUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUserHierarchyGroup`.
    ///
    /// <p>Deletes an existing user hierarchy group. It must not be associated with any agents or have
    /// any active child groups.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUserHierarchyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_user_hierarchy_group_input::Builder,
    }
    impl<C, M, R> DeleteUserHierarchyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUserHierarchyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUserHierarchyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUserHierarchyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUserHierarchyGroupInputOperationOutputAlias,
                crate::output::DeleteUserHierarchyGroupOutput,
                crate::error::DeleteUserHierarchyGroupError,
                crate::input::DeleteUserHierarchyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(inp);
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAgentStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes an agent status.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAgentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_agent_status_input::Builder,
    }
    impl<C, M, R> DescribeAgentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAgentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAgentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAgentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAgentStatusInputOperationOutputAlias,
                crate::output::DescribeAgentStatusOutput,
                crate::error::DescribeAgentStatusError,
                crate::input::DescribeAgentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the agent status.</p>
        pub fn agent_status_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_status_id(inp);
            self
        }
        /// <p>The identifier for the agent status.</p>
        pub fn set_agent_status_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_agent_status_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContact`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the specified contact. </p>
    /// <important>
    /// <p>Contact information remains available in Amazon Connect for 24 months, and then it is
    /// deleted.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct DescribeContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contact_input::Builder,
    }
    impl<C, M, R> DescribeContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContactInputOperationOutputAlias,
                crate::output::DescribeContactOutput,
                crate::error::DescribeContactError,
                crate::input::DescribeContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContactFlow`.
    ///
    /// <p>Describes the specified contact flow.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect
    /// Flow language</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeContactFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contact_flow_input::Builder,
    }
    impl<C, M, R> DescribeContactFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContactFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContactFlowInputOperationOutputAlias,
                crate::output::DescribeContactFlowOutput,
                crate::error::DescribeContactFlowError,
                crate::input::DescribeContactFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeContactFlowModule`.
    ///
    /// <p>Describes the specified contact flow module.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeContactFlowModule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_contact_flow_module_input::Builder,
    }
    impl<C, M, R> DescribeContactFlowModule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeContactFlowModule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeContactFlowModuleOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeContactFlowModuleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeContactFlowModuleInputOperationOutputAlias,
                crate::output::DescribeContactFlowModuleOutput,
                crate::error::DescribeContactFlowModuleError,
                crate::input::DescribeContactFlowModuleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(inp);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the hours of operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hours_of_operation_input::Builder,
    }
    impl<C, M, R> DescribeHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHoursOfOperationInputOperationOutputAlias,
                crate::output::DescribeHoursOfOperationOutput,
                crate::error::DescribeHoursOfOperationError,
                crate::input::DescribeHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(inp);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstance`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns the current state of the specified instance identifier. It tracks the instance while
    /// it is being created and returns an error status, if applicable. </p>
    /// <p>If an instance is not created successfully, the instance status reason field returns details
    /// relevant to the reason. The instance in a failed state is returned only for 24 hours after the
    /// CreateInstance API was invoked.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstance<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_input::Builder,
    }
    impl<C, M, R> DescribeInstance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceInputOperationOutputAlias,
                crate::output::DescribeInstanceOutput,
                crate::error::DescribeInstanceError,
                crate::input::DescribeInstanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceAttribute`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the specified instance attribute.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstanceAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_attribute_input::Builder,
    }
    impl<C, M, R> DescribeInstanceAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceAttributeInputOperationOutputAlias,
                crate::output::DescribeInstanceAttributeOutput,
                crate::error::DescribeInstanceAttributeError,
                crate::input::DescribeInstanceAttributeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of attribute.</p>
        pub fn attribute_type(mut self, inp: crate::model::InstanceAttributeType) -> Self {
            self.inner = self.inner.attribute_type(inp);
            self
        }
        /// <p>The type of attribute.</p>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::InstanceAttributeType>,
        ) -> Self {
            self.inner = self.inner.set_attribute_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Retrieves the current storage configurations for the specified resource type, association
    /// ID, and instance ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_instance_storage_config_input::Builder,
    }
    impl<C, M, R> DescribeInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeInstanceStorageConfigInputOperationOutputAlias,
                crate::output::DescribeInstanceStorageConfigOutput,
                crate::error::DescribeInstanceStorageConfigError,
                crate::input::DescribeInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, inp: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQueue`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Describes the specified queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_queue_input::Builder,
    }
    impl<C, M, R> DescribeQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeQueueInputOperationOutputAlias,
                crate::output::DescribeQueueOutput,
                crate::error::DescribeQueueError,
                crate::input::DescribeQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeQuickConnect`.
    ///
    /// <p>Describes the quick connect.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeQuickConnect<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_quick_connect_input::Builder,
    }
    impl<C, M, R> DescribeQuickConnect<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeQuickConnect`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeQuickConnectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeQuickConnectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeQuickConnectInputOperationOutputAlias,
                crate::output::DescribeQuickConnectOutput,
                crate::error::DescribeQuickConnectError,
                crate::input::DescribeQuickConnectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(inp);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeRoutingProfile`.
    ///
    /// <p>Describes the specified routing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeRoutingProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_routing_profile_input::Builder,
    }
    impl<C, M, R> DescribeRoutingProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeRoutingProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeRoutingProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeRoutingProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeRoutingProfileInputOperationOutputAlias,
                crate::output::DescribeRoutingProfileOutput,
                crate::error::DescribeRoutingProfileError,
                crate::input::DescribeRoutingProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Gets basic information about the security profle.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_security_profile_input::Builder,
    }
    impl<C, M, R> DescribeSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSecurityProfileInputOperationOutputAlias,
                crate::output::DescribeSecurityProfileOutput,
                crate::error::DescribeSecurityProfileError,
                crate::input::DescribeSecurityProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(inp);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUser`.
    ///
    /// <p>Describes the specified user account. You can find the instance ID in the console (it’s the
    /// final part of the ARN). The console does not display the user IDs. Instead, list the users and
    /// note the IDs provided in the output.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUser<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_input::Builder,
    }
    impl<C, M, R> DescribeUser<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUser`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserInputOperationOutputAlias,
                crate::output::DescribeUserOutput,
                crate::error::DescribeUserError,
                crate::input::DescribeUserInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserHierarchyGroup`.
    ///
    /// <p>Describes the specified hierarchy group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUserHierarchyGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_hierarchy_group_input::Builder,
    }
    impl<C, M, R> DescribeUserHierarchyGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserHierarchyGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserHierarchyGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserHierarchyGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserHierarchyGroupInputOperationOutputAlias,
                crate::output::DescribeUserHierarchyGroupOutput,
                crate::error::DescribeUserHierarchyGroupError,
                crate::input::DescribeUserHierarchyGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(inp);
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUserHierarchyStructure`.
    ///
    /// <p>Describes the hierarchy structure of the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUserHierarchyStructure<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_user_hierarchy_structure_input::Builder,
    }
    impl<C, M, R> DescribeUserHierarchyStructure<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUserHierarchyStructure`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUserHierarchyStructureOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUserHierarchyStructureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUserHierarchyStructureInputOperationOutputAlias,
                crate::output::DescribeUserHierarchyStructureOutput,
                crate::error::DescribeUserHierarchyStructureError,
                crate::input::DescribeUserHierarchyStructureInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateApprovedOrigin`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Revokes access to integrated applications from Amazon Connect.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateApprovedOrigin<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_approved_origin_input::Builder,
    }
    impl<C, M, R> DisassociateApprovedOrigin<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateApprovedOrigin`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateApprovedOriginOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateApprovedOriginError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateApprovedOriginInputOperationOutputAlias,
                crate::output::DisassociateApprovedOriginOutput,
                crate::error::DisassociateApprovedOriginError,
                crate::input::DisassociateApprovedOriginInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The domain URL of the integrated application.</p>
        pub fn origin(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.origin(inp);
            self
        }
        /// <p>The domain URL of the integrated application.</p>
        pub fn set_origin(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_origin(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2
    /// bot. </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_bot_input::Builder,
    }
    impl<C, M, R> DisassociateBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateBotInputOperationOutputAlias,
                crate::output::DisassociateBotOutput,
                crate::error::DisassociateBotError,
                crate::input::DisassociateBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn lex_bot(mut self, inp: crate::model::LexBot) -> Self {
            self.inner = self.inner.lex_bot(inp);
            self
        }
        /// <p>Configuration information of an Amazon Lex bot.</p>
        pub fn set_lex_bot(mut self, input: std::option::Option<crate::model::LexBot>) -> Self {
            self.inner = self.inner.set_lex_bot(input);
            self
        }
        /// <p>The Amazon Lex V2 bot to disassociate from the instance.</p>
        pub fn lex_v2_bot(mut self, inp: crate::model::LexV2Bot) -> Self {
            self.inner = self.inner.lex_v2_bot(inp);
            self
        }
        /// <p>The Amazon Lex V2 bot to disassociate from the instance.</p>
        pub fn set_lex_v2_bot(
            mut self,
            input: std::option::Option<crate::model::LexV2Bot>,
        ) -> Self {
            self.inner = self.inner.set_lex_v2_bot(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Removes the storage type configurations for the specified resource type and association
    /// ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_instance_storage_config_input::Builder,
    }
    impl<C, M, R> DisassociateInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateInstanceStorageConfigInputOperationOutputAlias,
                crate::output::DisassociateInstanceStorageConfigOutput,
                crate::error::DisassociateInstanceStorageConfigError,
                crate::input::DisassociateInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, inp: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLambdaFunction`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Remove the Lambda function from the dropdown options available in the relevant contact flow
    /// blocks.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateLambdaFunction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_lambda_function_input::Builder,
    }
    impl<C, M, R> DisassociateLambdaFunction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLambdaFunction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLambdaFunctionOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLambdaFunctionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLambdaFunctionInputOperationOutputAlias,
                crate::output::DisassociateLambdaFunctionOutput,
                crate::error::DisassociateLambdaFunctionError,
                crate::input::DisassociateLambdaFunctionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance..</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>
        pub fn function_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.function_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>
        pub fn set_function_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_function_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateLexBot`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Revokes authorization from the specified instance to access the specified Amazon Lex bot.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateLexBot<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_lex_bot_input::Builder,
    }
    impl<C, M, R> DisassociateLexBot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateLexBot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateLexBotOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateLexBotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateLexBotInputOperationOutputAlias,
                crate::output::DisassociateLexBotOutput,
                crate::error::DisassociateLexBotError,
                crate::input::DisassociateLexBotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>
        pub fn bot_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bot_name(inp);
            self
        }
        /// <p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>
        pub fn set_bot_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bot_name(input);
            self
        }
        /// <p>The Region in which the Amazon Lex bot has been created.</p>
        pub fn lex_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lex_region(inp);
            self
        }
        /// <p>The Region in which the Amazon Lex bot has been created.</p>
        pub fn set_lex_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lex_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateQueueQuickConnects`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Disassociates a set of quick connects from a queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateQueueQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_queue_quick_connects_input::Builder,
    }
    impl<C, M, R> DisassociateQueueQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateQueueQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateQueueQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateQueueQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateQueueQuickConnectsInputOperationOutputAlias,
                crate::output::DisassociateQueueQuickConnectsOutput,
                crate::error::DisassociateQueueQuickConnectsError,
                crate::input::DisassociateQueueQuickConnectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// Appends an item to `QuickConnectIds`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_ids`](Self::set_quick_connect_ids).
        ///
        /// <p>The quick connects to disassociate from the queue.</p>
        pub fn quick_connect_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_ids(inp);
            self
        }
        /// <p>The quick connects to disassociate from the queue.</p>
        pub fn set_quick_connect_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateRoutingProfileQueues`.
    ///
    /// <p>Disassociates a set of queues from a routing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> DisassociateRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::DisassociateRoutingProfileQueuesOutput,
                crate::error::DisassociateRoutingProfileQueuesError,
                crate::input::DisassociateRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `QueueReferences`.
        ///
        /// To override the contents of this collection use [`set_queue_references`](Self::set_queue_references).
        ///
        /// <p>The queues to disassociate from this routing profile.</p>
        pub fn queue_references(
            mut self,
            inp: impl Into<crate::model::RoutingProfileQueueReference>,
        ) -> Self {
            self.inner = self.inner.queue_references(inp);
            self
        }
        /// <p>The queues to disassociate from this routing profile.</p>
        pub fn set_queue_references(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueReference>>,
        ) -> Self {
            self.inner = self.inner.set_queue_references(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateSecurityKey`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Deletes the specified security key.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateSecurityKey<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_security_key_input::Builder,
    }
    impl<C, M, R> DisassociateSecurityKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateSecurityKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateSecurityKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateSecurityKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateSecurityKeyInputOperationOutputAlias,
                crate::output::DisassociateSecurityKeyOutput,
                crate::error::DisassociateSecurityKeyError,
                crate::input::DisassociateSecurityKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetContactAttributes`.
    ///
    /// <p>Retrieves the contact attributes for the specified contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetContactAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_contact_attributes_input::Builder,
    }
    impl<C, M, R> GetContactAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetContactAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetContactAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::GetContactAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetContactAttributesInputOperationOutputAlias,
                crate::output::GetContactAttributesOutput,
                crate::error::GetContactAttributesError,
                crate::input::GetContactAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn initial_contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(inp);
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetCurrentMetricData`.
    ///
    /// <p>Gets the real-time metric data from the specified Amazon Connect instance.</p>
    /// <p>For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
    /// Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCurrentMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_current_metric_data_input::Builder,
    }
    impl<C, M, R> GetCurrentMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCurrentMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCurrentMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCurrentMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCurrentMetricDataInputOperationOutputAlias,
                crate::output::GetCurrentMetricDataOutput,
                crate::error::GetCurrentMetricDataError,
                crate::input::GetCurrentMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is
        /// retrieved only for the resources associated with the queues or channels included in the filter.
        /// You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        pub fn filters(mut self, inp: crate::model::Filters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is
        /// retrieved only for the resources associated with the queues or channels included in the filter.
        /// You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        pub fn set_filters(mut self, input: std::option::Option<crate::model::Filters>) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Groupings`.
        ///
        /// To override the contents of this collection use [`set_groupings`](Self::set_groupings).
        ///
        /// <p>The grouping applied to the metrics returned. For example, when grouped by
        /// <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all
        /// queues. If you group by <code>CHANNEL</code>, you should include a Channels filter.
        /// VOICE, CHAT, and TASK channels are supported.</p>
        /// <p>If no <code>Grouping</code> is included in the request, a summary of metrics is
        /// returned.</p>
        pub fn groupings(mut self, inp: impl Into<crate::model::Grouping>) -> Self {
            self.inner = self.inner.groupings(inp);
            self
        }
        /// <p>The grouping applied to the metrics returned. For example, when grouped by
        /// <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all
        /// queues. If you group by <code>CHANNEL</code>, you should include a Channels filter.
        /// VOICE, CHAT, and TASK channels are supported.</p>
        /// <p>If no <code>Grouping</code> is included in the request, a summary of metrics is
        /// returned.</p>
        pub fn set_groupings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        ) -> Self {
            self.inner = self.inner.set_groupings(input);
            self
        }
        /// Appends an item to `CurrentMetrics`.
        ///
        /// To override the contents of this collection use [`set_current_metrics`](Self::set_current_metrics).
        ///
        /// <p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics
        /// are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
        /// Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        /// <dl>
        /// <dt>AGENTS_AFTER_CONTACT_WORK</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a>
        /// </p>
        ///
        /// </dd>
        /// <dt>AGENTS_AVAILABLE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ERROR</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_NON_PRODUCTIVE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ON_CALL</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On
        /// contact</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ON_CONTACT</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On
        /// contact</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ONLINE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_STAFFED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a>
        /// </p>
        /// </dd>
        /// <dt>CONTACTS_IN_QUEUE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In
        /// queue</a>
        /// </p>
        /// </dd>
        /// <dt>CONTACTS_SCHEDULED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a>
        /// </p>
        /// </dd>
        /// <dt>OLDEST_CONTACT_AGE</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p>
        /// <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For
        /// example, if you get a response like this:</p>
        /// <p>
        /// <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0
        /// </code>}</p>
        /// <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p>
        ///
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a>
        /// </p>
        /// </dd>
        /// <dt>SLOTS_ACTIVE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a>
        /// </p>
        /// </dd>
        /// <dt>SLOTS_AVAILABLE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a>
        /// </p>
        /// </dd>
        /// </dl>
        pub fn current_metrics(mut self, inp: impl Into<crate::model::CurrentMetric>) -> Self {
            self.inner = self.inner.current_metrics(inp);
            self
        }
        /// <p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics
        /// are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics
        /// Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
        /// <dl>
        /// <dt>AGENTS_AFTER_CONTACT_WORK</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a>
        /// </p>
        ///
        /// </dd>
        /// <dt>AGENTS_AVAILABLE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ERROR</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_NON_PRODUCTIVE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ON_CALL</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On
        /// contact</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ON_CONTACT</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On
        /// contact</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_ONLINE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a>
        /// </p>
        /// </dd>
        /// <dt>AGENTS_STAFFED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a>
        /// </p>
        /// </dd>
        /// <dt>CONTACTS_IN_QUEUE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In
        /// queue</a>
        /// </p>
        /// </dd>
        /// <dt>CONTACTS_SCHEDULED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a>
        /// </p>
        /// </dd>
        /// <dt>OLDEST_CONTACT_AGE</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p>
        /// <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For
        /// example, if you get a response like this:</p>
        /// <p>
        /// <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0
        /// </code>}</p>
        /// <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p>
        ///
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a>
        /// </p>
        /// </dd>
        /// <dt>SLOTS_ACTIVE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a>
        /// </p>
        /// </dd>
        /// <dt>SLOTS_AVAILABLE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a>
        /// </p>
        /// </dd>
        /// </dl>
        pub fn set_current_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CurrentMetric>>,
        ) -> Self {
            self.inner = self.inner.set_current_metrics(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        /// <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use
        /// the token must use the same request parameters as the request that generated the token.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        /// <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use
        /// the token must use the same request parameters as the request that generated the token.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFederationToken`.
    ///
    /// <p>Retrieves a token for federation.</p>
    /// <note>
    /// <p>This API doesn't support root users. If you try to invoke GetFederationToken with root
    /// credentials, an error message similar to the following one appears: </p>
    /// <p>
    /// <code>Provided identity: Principal: .... User: .... cannot be used for federation with
    /// Amazon Connect</code>
    /// </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct GetFederationToken<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_federation_token_input::Builder,
    }
    impl<C, M, R> GetFederationToken<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFederationToken`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFederationTokenOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFederationTokenError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFederationTokenInputOperationOutputAlias,
                crate::output::GetFederationTokenOutput,
                crate::error::GetFederationTokenError,
                crate::input::GetFederationTokenInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMetricData`.
    ///
    /// <p>Gets historical metric data from the specified Amazon Connect instance.</p>
    ///
    /// <p>For a description of each historical metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics
    /// Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMetricData<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_metric_data_input::Builder,
    }
    impl<C, M, R> GetMetricData<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMetricData`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMetricDataOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMetricDataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMetricDataInputOperationOutputAlias,
                crate::output::GetMetricDataOutput,
                crate::error::GetMetricDataError,
                crate::input::GetMetricDataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the
        /// retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes,
        /// such as 10:05, 10:10, 10:15.</p>
        /// <p>The start time cannot be earlier than 24 hours before the time of the request. Historical
        /// metrics are available only for 24 hours.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the
        /// retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes,
        /// such as 10:05, 10:10, 10:15.</p>
        /// <p>The start time cannot be earlier than 24 hours before the time of the request. Historical
        /// metrics are available only for 24 hours.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the
        /// retrieval of historical metrics data. The time must be specified using an interval of 5 minutes,
        /// such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p>
        /// <p>The time range between the start and end time must be less than 24 hours.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the
        /// retrieval of historical metrics data. The time must be specified using an interval of 5 minutes,
        /// such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p>
        /// <p>The time range between the start and end time must be less than 24 hours.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is
        /// retrieved only for the resources associated with the queues or channels included in the filter.
        /// You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        /// <note>
        /// <p>To filter by <code>Queues</code>, enter the queue
        /// ID/ARN, not the name of the queue.</p>
        /// </note>
        pub fn filters(mut self, inp: crate::model::Filters) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is
        /// retrieved only for the resources associated with the queues or channels included in the filter.
        /// You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p>
        /// <note>
        /// <p>To filter by <code>Queues</code>, enter the queue
        /// ID/ARN, not the name of the queue.</p>
        /// </note>
        pub fn set_filters(mut self, input: std::option::Option<crate::model::Filters>) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// Appends an item to `Groupings`.
        ///
        /// To override the contents of this collection use [`set_groupings`](Self::set_groupings).
        ///
        /// <p>The grouping applied to the metrics returned. For example, when results are grouped by
        /// queue, the metrics returned are grouped by queue. The values returned apply to the metrics for
        /// each queue rather than aggregated for all queues.</p>
        ///
        /// <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>
        pub fn groupings(mut self, inp: impl Into<crate::model::Grouping>) -> Self {
            self.inner = self.inner.groupings(inp);
            self
        }
        /// <p>The grouping applied to the metrics returned. For example, when results are grouped by
        /// queue, the metrics returned are grouped by queue. The values returned apply to the metrics for
        /// each queue rather than aggregated for all queues.</p>
        ///
        /// <p>If no grouping is specified, a summary of metrics for all queues is returned.</p>
        pub fn set_groupings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Grouping>>,
        ) -> Self {
            self.inner = self.inner.set_groupings(input);
            self
        }
        /// Appends an item to `HistoricalMetrics`.
        ///
        /// To override the contents of this collection use [`set_historical_metrics`](Self::set_historical_metrics).
        ///
        /// <p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The
        /// following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator
        /// Guide</i>.</p>
        /// <note>
        /// <p>This API does not support a contacts
        /// incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list). </p>
        /// </note>
        ///
        /// <dl>
        /// <dt>ABANDON_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>AFTER_CONTACT_WORK_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>API_CONTACTS_HANDLED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CALLBACK_CONTACTS_HANDLED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_ABANDONED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_CONSULTED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HANDLED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HANDLED_INCOMING</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HANDLED_OUTBOUND</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HOLD_ABANDONS</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_MISSED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_QUEUED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_IN</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_OUT</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>HANDLE_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>HOLD_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>INTERACTION_AND_HOLD_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>INTERACTION_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>OCCUPANCY</dt>
        /// <dd>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>QUEUE_ANSWER_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>QUEUED_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: MAX</p>
        /// </dd>
        /// <dt>SERVICE_LEVEL</dt>
        /// <dd>
        /// <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800
        /// (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for
        /// "Less than"). </p>
        /// </dd>
        /// </dl>
        pub fn historical_metrics(
            mut self,
            inp: impl Into<crate::model::HistoricalMetric>,
        ) -> Self {
            self.inner = self.inner.historical_metrics(inp);
            self
        }
        /// <p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The
        /// following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator
        /// Guide</i>.</p>
        /// <note>
        /// <p>This API does not support a contacts
        /// incoming metric (there's no CONTACTS_INCOMING metric missing from the documented list). </p>
        /// </note>
        ///
        /// <dl>
        /// <dt>ABANDON_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>AFTER_CONTACT_WORK_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>API_CONTACTS_HANDLED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CALLBACK_CONTACTS_HANDLED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_ABANDONED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_CONSULTED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HANDLED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HANDLED_INCOMING</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HANDLED_OUTBOUND</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_HOLD_ABANDONS</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_MISSED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_QUEUED</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_IN</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_OUT</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
        /// <dd>
        /// <p>Unit: COUNT</p>
        /// <p>Statistic: SUM</p>
        /// </dd>
        /// <dt>HANDLE_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>HOLD_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>INTERACTION_AND_HOLD_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>INTERACTION_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>OCCUPANCY</dt>
        /// <dd>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>QUEUE_ANSWER_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: AVG</p>
        /// </dd>
        /// <dt>QUEUED_TIME</dt>
        /// <dd>
        /// <p>Unit: SECONDS</p>
        /// <p>Statistic: MAX</p>
        /// </dd>
        /// <dt>SERVICE_LEVEL</dt>
        /// <dd>
        /// <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p>
        /// <p>Unit: PERCENT</p>
        /// <p>Statistic: AVG</p>
        /// <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800
        /// (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for
        /// "Less than"). </p>
        /// </dd>
        /// </dl>
        pub fn set_historical_metrics(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HistoricalMetric>>,
        ) -> Self {
            self.inner = self.inner.set_historical_metrics(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListAgentStatuses`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Lists agent statuses.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListAgentStatuses<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_agent_statuses_input::Builder,
    }
    impl<C, M, R> ListAgentStatuses<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListAgentStatuses`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListAgentStatusesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListAgentStatusesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListAgentStatusesInputOperationOutputAlias,
                crate::output::ListAgentStatusesOutput,
                crate::error::ListAgentStatusesError,
                crate::input::ListAgentStatusesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `AgentStatusTypes`.
        ///
        /// To override the contents of this collection use [`set_agent_status_types`](Self::set_agent_status_types).
        ///
        /// <p>Available agent status types.</p>
        pub fn agent_status_types(mut self, inp: impl Into<crate::model::AgentStatusType>) -> Self {
            self.inner = self.inner.agent_status_types(inp);
            self
        }
        /// <p>Available agent status types.</p>
        pub fn set_agent_status_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AgentStatusType>>,
        ) -> Self {
            self.inner = self.inner.set_agent_status_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListApprovedOrigins`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all approved origins associated with the instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListApprovedOrigins<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_approved_origins_input::Builder,
    }
    impl<C, M, R> ListApprovedOrigins<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListApprovedOrigins`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListApprovedOriginsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListApprovedOriginsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListApprovedOriginsInputOperationOutputAlias,
                crate::output::ListApprovedOriginsOutput,
                crate::error::ListApprovedOriginsError,
                crate::input::ListApprovedOriginsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListBots`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the
    /// instance. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListBots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_bots_input::Builder,
    }
    impl<C, M, R> ListBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListBotsInputOperationOutputAlias,
                crate::output::ListBotsOutput,
                crate::error::ListBotsError,
                crate::input::ListBotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The version of Amazon Lex or Amazon Lex V2.</p>
        pub fn lex_version(mut self, inp: crate::model::LexVersion) -> Self {
            self.inner = self.inner.lex_version(inp);
            self
        }
        /// <p>The version of Amazon Lex or Amazon Lex V2.</p>
        pub fn set_lex_version(
            mut self,
            input: std::option::Option<crate::model::LexVersion>,
        ) -> Self {
            self.inner = self.inner.set_lex_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactFlowModules`.
    ///
    /// <p>Provides information about the contact flow modules for the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContactFlowModules<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_flow_modules_input::Builder,
    }
    impl<C, M, R> ListContactFlowModules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactFlowModules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactFlowModulesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactFlowModulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactFlowModulesInputOperationOutputAlias,
                crate::output::ListContactFlowModulesOutput,
                crate::error::ListContactFlowModulesError,
                crate::input::ListContactFlowModulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The state of the contact flow module.</p>
        pub fn contact_flow_module_state(
            mut self,
            inp: crate::model::ContactFlowModuleState,
        ) -> Self {
            self.inner = self.inner.contact_flow_module_state(inp);
            self
        }
        /// <p>The state of the contact flow module.</p>
        pub fn set_contact_flow_module_state(
            mut self,
            input: std::option::Option<crate::model::ContactFlowModuleState>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactFlows`.
    ///
    /// <p>Provides information about the contact flows for the specified Amazon Connect instance.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect
    /// Flow language</a>.</p>
    /// <p>For more information about contact flows, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Contact Flows</a> in the
    /// <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListContactFlows<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_flows_input::Builder,
    }
    impl<C, M, R> ListContactFlows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactFlowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactFlowsInputOperationOutputAlias,
                crate::output::ListContactFlowsOutput,
                crate::error::ListContactFlowsError,
                crate::input::ListContactFlowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `ContactFlowTypes`.
        ///
        /// To override the contents of this collection use [`set_contact_flow_types`](Self::set_contact_flow_types).
        ///
        /// <p>The type of contact flow.</p>
        pub fn contact_flow_types(mut self, inp: impl Into<crate::model::ContactFlowType>) -> Self {
            self.inner = self.inner.contact_flow_types(inp);
            self
        }
        /// <p>The type of contact flow.</p>
        pub fn set_contact_flow_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ContactFlowType>>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_types(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListContactReferences`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>For the specified <code>referenceTypes</code>, returns a list of references associated with
    /// the contact. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListContactReferences<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_contact_references_input::Builder,
    }
    impl<C, M, R> ListContactReferences<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListContactReferences`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListContactReferencesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListContactReferencesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListContactReferencesInputOperationOutputAlias,
                crate::output::ListContactReferencesOutput,
                crate::error::ListContactReferencesError,
                crate::input::ListContactReferencesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the initial contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// Appends an item to `ReferenceTypes`.
        ///
        /// To override the contents of this collection use [`set_reference_types`](Self::set_reference_types).
        ///
        /// <p>The type of reference.</p>
        pub fn reference_types(mut self, inp: impl Into<crate::model::ReferenceType>) -> Self {
            self.inner = self.inner.reference_types(inp);
            self
        }
        /// <p>The type of reference.</p>
        pub fn set_reference_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReferenceType>>,
        ) -> Self {
            self.inner = self.inner.set_reference_types(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        /// <important>
        /// <p>This is not expected to be set, because the value returned in the previous response is
        /// always null.</p>
        /// </important>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        /// <important>
        /// <p>This is not expected to be set, because the value returned in the previous response is
        /// always null.</p>
        /// </important>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListHoursOfOperations`.
    ///
    /// <p>Provides information about the hours of operation for the specified Amazon Connect instance.</p>
    /// <p>For more information about hours of operation, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation for a
    /// Queue</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListHoursOfOperations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_hours_of_operations_input::Builder,
    }
    impl<C, M, R> ListHoursOfOperations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListHoursOfOperations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListHoursOfOperationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListHoursOfOperationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListHoursOfOperationsInputOperationOutputAlias,
                crate::output::ListHoursOfOperationsOutput,
                crate::error::ListHoursOfOperationsError,
                crate::input::ListHoursOfOperationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceAttributes`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all attribute types for the given instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstanceAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_attributes_input::Builder,
    }
    impl<C, M, R> ListInstanceAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceAttributesInputOperationOutputAlias,
                crate::output::ListInstanceAttributesOutput,
                crate::error::ListInstanceAttributesError,
                crate::input::ListInstanceAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstances`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Return a list of instances which are in active state, creation-in-progress state, and failed
    /// state. Instances that aren't successfully created (they are in a failed state) are returned only
    /// for 24 hours after the CreateInstance API was invoked.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstances<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instances_input::Builder,
    }
    impl<C, M, R> ListInstances<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstances`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstancesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstancesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstancesInputOperationOutputAlias,
                crate::output::ListInstancesOutput,
                crate::error::ListInstancesError,
                crate::input::ListInstancesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInstanceStorageConfigs`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    ///
    /// <p>Returns a paginated list of storage configs for the identified instance and resource
    /// type.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInstanceStorageConfigs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_instance_storage_configs_input::Builder,
    }
    impl<C, M, R> ListInstanceStorageConfigs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInstanceStorageConfigs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInstanceStorageConfigsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInstanceStorageConfigsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInstanceStorageConfigsInputOperationOutputAlias,
                crate::output::ListInstanceStorageConfigsOutput,
                crate::error::ListInstanceStorageConfigsError,
                crate::input::ListInstanceStorageConfigsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, inp: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListIntegrationAssociations`.
    ///
    /// <p>Provides summary information about the AWS resource associations for the specified Amazon Connect
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListIntegrationAssociations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_integration_associations_input::Builder,
    }
    impl<C, M, R> ListIntegrationAssociations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListIntegrationAssociations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListIntegrationAssociationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListIntegrationAssociationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListIntegrationAssociationsInputOperationOutputAlias,
                crate::output::ListIntegrationAssociationsOutput,
                crate::error::ListIntegrationAssociationsError,
                crate::input::ListIntegrationAssociationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The integration type.</p>
        pub fn integration_type(mut self, inp: crate::model::IntegrationType) -> Self {
            self.inner = self.inner.integration_type(inp);
            self
        }
        /// <p>The integration type.</p>
        pub fn set_integration_type(
            mut self,
            input: std::option::Option<crate::model::IntegrationType>,
        ) -> Self {
            self.inner = self.inner.set_integration_type(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLambdaFunctions`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all Lambda functions that display in the dropdown options in the
    /// relevant contact flow blocks.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLambdaFunctions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lambda_functions_input::Builder,
    }
    impl<C, M, R> ListLambdaFunctions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLambdaFunctions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLambdaFunctionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLambdaFunctionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLambdaFunctionsInputOperationOutputAlias,
                crate::output::ListLambdaFunctionsOutput,
                crate::error::ListLambdaFunctionsError,
                crate::input::ListLambdaFunctionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListLexBots`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all the Amazon Lex bots currently associated with the
    /// instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListLexBots<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_lex_bots_input::Builder,
    }
    impl<C, M, R> ListLexBots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListLexBots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListLexBotsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListLexBotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListLexBotsInputOperationOutputAlias,
                crate::output::ListLexBotsOutput,
                crate::error::ListLexBotsError,
                crate::input::ListLexBotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPhoneNumbers`.
    ///
    /// <p>Provides information about the phone numbers for the specified Amazon Connect instance. </p>
    /// <p>For more information about phone numbers, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone Numbers for Your
    /// Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPhoneNumbers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_phone_numbers_input::Builder,
    }
    impl<C, M, R> ListPhoneNumbers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPhoneNumbers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPhoneNumbersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPhoneNumbersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPhoneNumbersInputOperationOutputAlias,
                crate::output::ListPhoneNumbersOutput,
                crate::error::ListPhoneNumbersError,
                crate::input::ListPhoneNumbersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `PhoneNumberTypes`.
        ///
        /// To override the contents of this collection use [`set_phone_number_types`](Self::set_phone_number_types).
        ///
        /// <p>The type of phone number.</p>
        pub fn phone_number_types(mut self, inp: impl Into<crate::model::PhoneNumberType>) -> Self {
            self.inner = self.inner.phone_number_types(inp);
            self
        }
        /// <p>The type of phone number.</p>
        pub fn set_phone_number_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberType>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_types(input);
            self
        }
        /// Appends an item to `PhoneNumberCountryCodes`.
        ///
        /// To override the contents of this collection use [`set_phone_number_country_codes`](Self::set_phone_number_country_codes).
        ///
        /// <p>The ISO country code.</p>
        pub fn phone_number_country_codes(
            mut self,
            inp: impl Into<crate::model::PhoneNumberCountryCode>,
        ) -> Self {
            self.inner = self.inner.phone_number_country_codes(inp);
            self
        }
        /// <p>The ISO country code.</p>
        pub fn set_phone_number_country_codes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PhoneNumberCountryCode>>,
        ) -> Self {
            self.inner = self.inner.set_phone_number_country_codes(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPrompts`.
    ///
    /// <p>Provides information about the prompts for the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListPrompts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_prompts_input::Builder,
    }
    impl<C, M, R> ListPrompts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPrompts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPromptsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPromptsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPromptsInputOperationOutputAlias,
                crate::output::ListPromptsOutput,
                crate::error::ListPromptsError,
                crate::input::ListPromptsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in
        /// the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous response in
        /// the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueueQuickConnects`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Lists the quick connects associated with a queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListQueueQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queue_quick_connects_input::Builder,
    }
    impl<C, M, R> ListQueueQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueueQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueueQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueueQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueueQuickConnectsInputOperationOutputAlias,
                crate::output::ListQueueQuickConnectsOutput,
                crate::error::ListQueueQuickConnectsError,
                crate::input::ListQueueQuickConnectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueues`.
    ///
    /// <p>Provides information about the queues for the specified Amazon Connect instance.</p>
    /// <p>If you do not specify a <code>QueueTypes</code>
    /// parameter, both standard and agent queues are returned. This might cause an unexpected truncation
    /// of results if you have more than 1000 agents and you limit the number of results of the API call
    /// in code.</p>
    /// <p>For more information about queues, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues: Standard and
    /// Agent</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queues_input::Builder,
    }
    impl<C, M, R> ListQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueuesInputOperationOutputAlias,
                crate::output::ListQueuesOutput,
                crate::error::ListQueuesError,
                crate::input::ListQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Appends an item to `QueueTypes`.
        ///
        /// To override the contents of this collection use [`set_queue_types`](Self::set_queue_types).
        ///
        /// <p>The type of queue.</p>
        pub fn queue_types(mut self, inp: impl Into<crate::model::QueueType>) -> Self {
            self.inner = self.inner.queue_types(inp);
            self
        }
        /// <p>The type of queue.</p>
        pub fn set_queue_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QueueType>>,
        ) -> Self {
            self.inner = self.inner.set_queue_types(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQuickConnects`.
    ///
    /// <p>Provides information about the quick connects for the specified Amazon Connect instance. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListQuickConnects<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_quick_connects_input::Builder,
    }
    impl<C, M, R> ListQuickConnects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQuickConnects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQuickConnectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQuickConnectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQuickConnectsInputOperationOutputAlias,
                crate::output::ListQuickConnectsOutput,
                crate::error::ListQuickConnectsError,
                crate::input::ListQuickConnectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Appends an item to `QuickConnectTypes`.
        ///
        /// To override the contents of this collection use [`set_quick_connect_types`](Self::set_quick_connect_types).
        ///
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
        /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn quick_connect_types(
            mut self,
            inp: impl Into<crate::model::QuickConnectType>,
        ) -> Self {
            self.inner = self.inner.quick_connect_types(inp);
            self
        }
        /// <p>The type of quick connect. In the Amazon Connect console, when you create a quick connect, you are
        /// prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>
        pub fn set_quick_connect_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::QuickConnectType>>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutingProfileQueues`.
    ///
    /// <p>Lists the queues associated with a routing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> ListRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::ListRoutingProfileQueuesOutput,
                crate::error::ListRoutingProfileQueuesError,
                crate::input::ListRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListRoutingProfiles`.
    ///
    /// <p>Provides summary information about the routing profiles for the specified Amazon Connect
    /// instance.</p>
    /// <p>For more information about routing profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing
    /// Profile</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListRoutingProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_routing_profiles_input::Builder,
    }
    impl<C, M, R> ListRoutingProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListRoutingProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListRoutingProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListRoutingProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListRoutingProfilesInputOperationOutputAlias,
                crate::output::ListRoutingProfilesOutput,
                crate::error::ListRoutingProfilesError,
                crate::input::ListRoutingProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityKeys`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Returns a paginated list of all security keys associated with the instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSecurityKeys<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_keys_input::Builder,
    }
    impl<C, M, R> ListSecurityKeys<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityKeys`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityKeysOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityKeysError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityKeysInputOperationOutputAlias,
                crate::output::ListSecurityKeysOutput,
                crate::error::ListSecurityKeysError,
                crate::input::ListSecurityKeysInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityProfilePermissions`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Lists the permissions granted to a security profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSecurityProfilePermissions<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_profile_permissions_input::Builder,
    }
    impl<C, M, R> ListSecurityProfilePermissions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityProfilePermissions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityProfilePermissionsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityProfilePermissionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityProfilePermissionsInputOperationOutputAlias,
                crate::output::ListSecurityProfilePermissionsOutput,
                crate::error::ListSecurityProfilePermissionsError,
                crate::input::ListSecurityProfilePermissionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(inp);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListSecurityProfiles`.
    ///
    /// <p>Provides summary information about the security profiles for the specified Amazon Connect
    /// instance.</p>
    /// <p>For more information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the
    /// <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListSecurityProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_security_profiles_input::Builder,
    }
    impl<C, M, R> ListSecurityProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListSecurityProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListSecurityProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListSecurityProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListSecurityProfilesInputOperationOutputAlias,
                crate::output::ListSecurityProfilesOutput,
                crate::error::ListSecurityProfilesError,
                crate::input::ListSecurityProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Lists the tags for the specified resource.</p>
    /// <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based
    /// Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUseCases`.
    ///
    /// <p>Lists the use cases for the integration association. </p>
    #[derive(std::fmt::Debug)]
    pub struct ListUseCases<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_use_cases_input::Builder,
    }
    impl<C, M, R> ListUseCases<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUseCases`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUseCasesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUseCasesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUseCasesInputOperationOutputAlias,
                crate::output::ListUseCasesOutput,
                crate::error::ListUseCasesError,
                crate::input::ListUseCasesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn integration_association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.integration_association_id(inp);
            self
        }
        /// <p>The identifier for the integration association.</p>
        pub fn set_integration_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_integration_association_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUserHierarchyGroups`.
    ///
    /// <p>Provides summary information about the hierarchy groups for the specified Amazon Connect
    /// instance.</p>
    /// <p>For more information about agent hierarchies, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in the
    /// <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUserHierarchyGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_user_hierarchy_groups_input::Builder,
    }
    impl<C, M, R> ListUserHierarchyGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUserHierarchyGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUserHierarchyGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUserHierarchyGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUserHierarchyGroupsInputOperationOutputAlias,
                crate::output::ListUserHierarchyGroupsOutput,
                crate::error::ListUserHierarchyGroupsError,
                crate::input::ListUserHierarchyGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListUsers`.
    ///
    /// <p>Provides summary information about the users for the specified Amazon Connect instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListUsers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_users_input::Builder,
    }
    impl<C, M, R> ListUsers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListUsers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListUsersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListUsersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListUsersInputOperationOutputAlias,
                crate::output::ListUsersOutput,
                crate::error::ListUsersError,
                crate::input::ListUsersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token for the next set of results. Use the value returned in the previous
        /// response in the next request to retrieve the next set of results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per page.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResumeContactRecording`.
    ///
    /// <p>When a contact is being recorded, and the recording has been suspended using
    /// SuspendContactRecording, this API resumes recording the call.</p>
    ///
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResumeContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resume_contact_recording_input::Builder,
    }
    impl<C, M, R> ResumeContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResumeContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResumeContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::ResumeContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResumeContactRecordingInputOperationOutputAlias,
                crate::output::ResumeContactRecordingOutput,
                crate::error::ResumeContactRecordingError,
                crate::input::ResumeContactRecordingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartChatContact`.
    ///
    /// <p>Initiates a contact flow to start a new chat for the customer. Response of this API provides
    /// a token required to obtain credentials from the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> API in the Amazon Connect Participant Service.</p>
    ///
    /// <p>When a new chat contact is successfully created, clients must subscribe to the participant’s
    /// connection for the created chat within 5 minutes. This is achieved by invoking <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> with WEBSOCKET and CONNECTION_CREDENTIALS. </p>
    ///
    /// <p>A 429 error occurs in two situations:</p>
    /// <ul>
    /// <li>
    /// <p>API rate limit is exceeded. API TPS throttling returns a <code>TooManyRequests</code>
    /// exception.</p>
    /// </li>
    /// <li>
    /// <p>The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">quota for concurrent active
    /// chats</a> is exceeded. Active chat throttling returns a
    /// <code>LimitExceededException</code>.</p>
    /// </li>
    /// </ul>
    ///
    /// <p>For more information about chat, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat.html">Chat</a> in the <i>Amazon Connect Administrator
    /// Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartChatContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_chat_contact_input::Builder,
    }
    impl<C, M, R> StartChatContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartChatContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartChatContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StartChatContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartChatContactInputOperationOutputAlias,
                crate::output::StartChatContactOutput,
                crate::error::StartChatContactError,
                crate::input::StartChatContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow for initiating the chat.
        /// To
        /// see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the
        /// contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of
        /// the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
        /// </p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The identifier of the contact flow for initiating the chat.
        /// To
        /// see the ContactFlowId in the Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the
        /// contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of
        /// the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
        /// </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect
        /// attributes. They can be accessed in contact flows just like any other contact attributes. </p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect
        /// attributes. They can be accessed in contact flows just like any other contact attributes. </p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>Information identifying the participant.</p>
        pub fn participant_details(mut self, inp: crate::model::ParticipantDetails) -> Self {
            self.inner = self.inner.participant_details(inp);
            self
        }
        /// <p>Information identifying the participant.</p>
        pub fn set_participant_details(
            mut self,
            input: std::option::Option<crate::model::ParticipantDetails>,
        ) -> Self {
            self.inner = self.inner.set_participant_details(input);
            self
        }
        /// <p>The initial message to be sent to the newly created chat.</p>
        pub fn initial_message(mut self, inp: crate::model::ChatMessage) -> Self {
            self.inner = self.inner.initial_message(inp);
            self
        }
        /// <p>The initial message to be sent to the newly created chat.</p>
        pub fn set_initial_message(
            mut self,
            input: std::option::Option<crate::model::ChatMessage>,
        ) -> Self {
            self.inner = self.inner.set_initial_message(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContactRecording`.
    ///
    /// <p>Starts recording the contact when the agent joins the call. StartContactRecording is a
    /// one-time action. For example, if you use StopContactRecording to stop recording an ongoing call,
    /// you can't use StartContactRecording to restart it. For scenarios where the recording has started
    /// and you want to suspend and resume it, such as when collecting sensitive information (for
    /// example, a credit card number), use SuspendContactRecording and ResumeContactRecording.</p>
    /// <p>You can use this API to override the recording behavior configured in the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html">Set recording
    /// behavior</a> block.</p>
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_contact_recording_input::Builder,
    }
    impl<C, M, R> StartContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartContactRecordingInputOperationOutputAlias,
                crate::output::StartContactRecordingOutput,
                crate::error::StartContactRecordingError,
                crate::input::StartContactRecordingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
        /// <p>The person being recorded.</p>
        pub fn voice_recording_configuration(
            mut self,
            inp: crate::model::VoiceRecordingConfiguration,
        ) -> Self {
            self.inner = self.inner.voice_recording_configuration(inp);
            self
        }
        /// <p>The person being recorded.</p>
        pub fn set_voice_recording_configuration(
            mut self,
            input: std::option::Option<crate::model::VoiceRecordingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_voice_recording_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartContactStreaming`.
    ///
    /// <p> Initiates real-time message streaming for a new chat contact.</p>
    /// <p> For more information about message streaming, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html">Enable real-time chat message
    /// streaming</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartContactStreaming<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_contact_streaming_input::Builder,
    }
    impl<C, M, R> StartContactStreaming<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartContactStreaming`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartContactStreamingOutput,
            aws_smithy_http::result::SdkError<crate::error::StartContactStreamingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartContactStreamingInputOperationOutputAlias,
                crate::output::StartContactStreamingOutput,
                crate::error::StartContactStreamingError,
                crate::input::StartContactStreamingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
        pub fn chat_streaming_configuration(
            mut self,
            inp: crate::model::ChatStreamingConfiguration,
        ) -> Self {
            self.inner = self.inner.chat_streaming_configuration(inp);
            self
        }
        /// <p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>
        pub fn set_chat_streaming_configuration(
            mut self,
            input: std::option::Option<crate::model::ChatStreamingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_chat_streaming_configuration(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartOutboundVoiceContact`.
    ///
    /// <p>Places an outbound call to a contact, and then initiates the contact flow. It performs the
    /// actions in the contact flow that's specified (in <code>ContactFlowId</code>).</p>
    ///
    /// <p>Agents do not initiate the outbound API, which means that they do not dial the contact. If
    /// the contact flow places an outbound call to a contact, and then puts the contact in queue, the
    /// call is then routed to the agent, like any other inbound case.</p>
    ///
    /// <p>There is a 60-second dialing timeout for this operation. If the call is not connected after
    /// 60 seconds, it fails.</p>
    /// <note>
    /// <p>UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK
    /// mobile numbers, you must submit a service quota increase request. For more information, see
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
    /// </note>
    /// <note>
    /// <p>Campaign calls are not allowed by default. Before you can make a call with
    /// <code>TrafficType</code> = <code>CAMPAIGN</code>, you must submit a service quota increase request. For more information, see
    /// <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct StartOutboundVoiceContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_outbound_voice_contact_input::Builder,
    }
    impl<C, M, R> StartOutboundVoiceContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartOutboundVoiceContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartOutboundVoiceContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StartOutboundVoiceContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartOutboundVoiceContactInputOperationOutputAlias,
                crate::output::StartOutboundVoiceContactOutput,
                crate::error::StartOutboundVoiceContactError,
                crate::input::StartOutboundVoiceContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The phone number of the customer, in E.164 format.</p>
        pub fn destination_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_phone_number(inp);
            self
        }
        /// <p>The phone number of the customer, in E.164 format.</p>
        pub fn set_destination_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_phone_number(input);
            self
        }
        /// <p>The
        /// identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect
        /// console user interface, on the navigation menu go to <b>Routing</b>,
        /// <b>Contact Flows</b>. Choose the contact flow. On the contact flow
        /// page, under the name of the contact flow, choose <b>Show additional flow
        /// information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
        /// </p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The
        /// identifier of the contact flow for the outbound call. To see the ContactFlowId in the Amazon Connect
        /// console user interface, on the navigation menu go to <b>Routing</b>,
        /// <b>Contact Flows</b>. Choose the contact flow. On the contact flow
        /// page, under the name of the contact flow, choose <b>Show additional flow
        /// information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
        /// </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. The token is valid for 7 days after creation. If a contact is already started, the
        /// contact ID is returned.
        /// </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request. The token is valid for 7 days after creation. If a contact is already started, the
        /// contact ID is returned.
        /// </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify
        /// a source phone number, you must specify a queue.</p>
        pub fn source_phone_number(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_phone_number(inp);
            self
        }
        /// <p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify
        /// a source phone number, you must specify a queue.</p>
        pub fn set_source_phone_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_phone_number(input);
            self
        }
        /// <p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the
        /// phone number specified in the queue. If you do not specify a queue, the queue defined in the
        /// contact flow is used. If you do not specify a queue, you must specify a source phone
        /// number.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the
        /// phone number specified in the queue. If you do not specify a queue, the queue defined in the
        /// contact flow is used. If you do not specify a queue, you must specify a source phone
        /// number.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect
        /// attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect
        /// attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>Configuration of the answering machine detection for this outbound call. </p>
        pub fn answer_machine_detection_config(
            mut self,
            inp: crate::model::AnswerMachineDetectionConfig,
        ) -> Self {
            self.inner = self.inner.answer_machine_detection_config(inp);
            self
        }
        /// <p>Configuration of the answering machine detection for this outbound call. </p>
        pub fn set_answer_machine_detection_config(
            mut self,
            input: std::option::Option<crate::model::AnswerMachineDetectionConfig>,
        ) -> Self {
            self.inner = self.inner.set_answer_machine_detection_config(input);
            self
        }
        /// <p>The campaign identifier of the outbound communication.</p>
        pub fn campaign_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.campaign_id(inp);
            self
        }
        /// <p>The campaign identifier of the outbound communication.</p>
        pub fn set_campaign_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_campaign_id(input);
            self
        }
        /// <p>Denotes the class of traffic. Calls with different traffic types are handled differently by
        /// Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
        /// <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
        /// <code>GENERAL</code>. </p>
        pub fn traffic_type(mut self, inp: crate::model::TrafficType) -> Self {
            self.inner = self.inner.traffic_type(inp);
            self
        }
        /// <p>Denotes the class of traffic. Calls with different traffic types are handled differently by
        /// Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if
        /// <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use
        /// <code>GENERAL</code>. </p>
        pub fn set_traffic_type(
            mut self,
            input: std::option::Option<crate::model::TrafficType>,
        ) -> Self {
            self.inner = self.inner.set_traffic_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartTaskContact`.
    ///
    /// <p>Initiates a contact flow to start a new task.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartTaskContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_task_contact_input::Builder,
    }
    impl<C, M, R> StartTaskContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartTaskContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartTaskContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StartTaskContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartTaskContactInputOperationOutputAlias,
                crate::output::StartTaskContactOutput,
                crate::error::StartTaskContactError,
                crate::input::StartTaskContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the previous chat, voice, or task contact. </p>
        pub fn previous_contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.previous_contact_id(inp);
            self
        }
        /// <p>The identifier of the previous chat, voice, or task contact. </p>
        pub fn set_previous_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_previous_contact_id(input);
            self
        }
        /// <p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the
        /// Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On
        /// the contact flow page, under the name of the contact flow, choose <b>Show
        /// additional flow information</b>. The ContactFlowId is the last part of the ARN, shown
        /// here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
        /// </p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The identifier of the contact flow for initiating the tasks. To see the ContactFlowId in the
        /// Amazon Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact flow. On
        /// the contact flow page, under the name of the contact flow, choose <b>Show
        /// additional flow information</b>. The ContactFlowId is the last part of the ARN, shown
        /// here in bold: </p>
        /// <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
        /// </p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect
        /// attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect
        /// attributes, and can be accessed in contact flows just like any other contact attributes.</p>
        /// <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// <p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Adds a key-value pair to `References`.
        ///
        /// To override the contents of this collection use [`set_references`](Self::set_references).
        ///
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn references(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Reference>,
        ) -> Self {
            self.inner = self.inner.references(k, v);
            self
        }
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_references(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Reference>,
            >,
        ) -> Self {
            self.inner = self.inner.set_references(input);
            self
        }
        /// <p>A description of the task that is shown to an agent in the Contact Control Panel
        /// (CCP).</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the task that is shown to an agent in the Contact Control Panel
        /// (CCP).</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the
        /// request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn scheduled_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.scheduled_time(inp);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContact`.
    ///
    /// <p>Ends the specified contact.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_contact_input::Builder,
    }
    impl<C, M, R> StopContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContactOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopContactInputOperationOutputAlias,
                crate::output::StopContactOutput,
                crate::error::StopContactError,
                crate::input::StopContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The ID of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContactRecording`.
    ///
    /// <p>Stops recording a call when a contact is being recorded. StopContactRecording is a one-time
    /// action. If you use StopContactRecording to stop recording an ongoing call, you can't use
    /// StartContactRecording to restart it. For scenarios where the recording has started and you want
    /// to suspend it for sensitive information (for example, to collect a credit card number), and then
    /// restart it, use SuspendContactRecording and ResumeContactRecording.</p>
    ///
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_contact_recording_input::Builder,
    }
    impl<C, M, R> StopContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopContactRecordingInputOperationOutputAlias,
                crate::output::StopContactRecordingOutput,
                crate::error::StopContactRecordingError,
                crate::input::StopContactRecordingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopContactStreaming`.
    ///
    /// <p> Ends message streaming on a specified contact. To restart message streaming on that
    /// contact, call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html">StartContactStreaming</a>
    /// API. </p>
    #[derive(std::fmt::Debug)]
    pub struct StopContactStreaming<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_contact_streaming_input::Builder,
    }
    impl<C, M, R> StopContactStreaming<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopContactStreaming`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopContactStreamingOutput,
            aws_smithy_http::result::SdkError<crate::error::StopContactStreamingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopContactStreamingInputOperationOutputAlias,
                crate::output::StopContactStreamingOutput,
                crate::error::StopContactStreamingError,
                crate::input::StopContactStreamingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact that is associated with
        /// the first interaction with the contact center.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact that is associated with
        /// the first interaction with the contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the streaming configuration enabled. </p>
        pub fn streaming_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.streaming_id(inp);
            self
        }
        /// <p>The identifier of the streaming configuration enabled. </p>
        pub fn set_streaming_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_streaming_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SuspendContactRecording`.
    ///
    /// <p>When a contact is being recorded, this API suspends recording the call. For example, you
    /// might suspend the call recording while collecting sensitive information, such as a credit card
    /// number. Then use ResumeContactRecording to restart recording. </p>
    /// <p>The period of time that the recording is suspended is filled with silence in the final
    /// recording. </p>
    /// <p>Only voice recordings are supported at this time.</p>
    #[derive(std::fmt::Debug)]
    pub struct SuspendContactRecording<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::suspend_contact_recording_input::Builder,
    }
    impl<C, M, R> SuspendContactRecording<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SuspendContactRecording`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SuspendContactRecordingOutput,
            aws_smithy_http::result::SdkError<crate::error::SuspendContactRecordingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SuspendContactRecordingInputOperationOutputAlias,
                crate::output::SuspendContactRecordingOutput,
                crate::error::SuspendContactRecordingError,
                crate::input::SuspendContactRecordingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds the specified tags to the specified resource.</p>
    /// <p>The supported resource types are users, routing profiles, queues, quick connects,
    /// contact flows, agent status, and hours of operation.</p>
    /// <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based
    /// Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>One or more tags. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the specified resource.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateAgentStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates agent status.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateAgentStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_agent_status_input::Builder,
    }
    impl<C, M, R> UpdateAgentStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateAgentStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateAgentStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateAgentStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateAgentStatusInputOperationOutputAlias,
                crate::output::UpdateAgentStatusOutput,
                crate::error::UpdateAgentStatusError,
                crate::input::UpdateAgentStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn agent_status_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.agent_status_id(inp);
            self
        }
        /// <p>The identifier of the agent status.</p>
        pub fn set_agent_status_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_agent_status_id(input);
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the agent status.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the agent status.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn state(mut self, inp: crate::model::AgentStatusState) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The state of the agent status.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::AgentStatusState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn display_order(mut self, inp: i32) -> Self {
            self.inner = self.inner.display_order(inp);
            self
        }
        /// <p>The display order of the agent status.</p>
        pub fn set_display_order(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_display_order(input);
            self
        }
        /// <p>A number indicating the reset order of the agent status.</p>
        pub fn reset_order_number(mut self, inp: bool) -> Self {
            self.inner = self.inner.reset_order_number(inp);
            self
        }
        /// <p>A number indicating the reset order of the agent status.</p>
        pub fn set_reset_order_number(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_order_number(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContact`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Adds or updates user-defined contact information associated with the specified contact. At
    /// least one field to be updated must be present in the request.</p>
    /// <important>
    /// <p>You can add or update user-defined contact information for both ongoing and completed
    /// contacts.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContact<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_input::Builder,
    }
    impl<C, M, R> UpdateContact<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContact`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactInputOperationOutputAlias,
                crate::output::UpdateContactOutput,
                crate::error::UpdateContactError,
                crate::input::UpdateContactInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with your contact center.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with your contact center.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The name of the contact.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the contact.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the contact.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `References`.
        ///
        /// To override the contents of this collection use [`set_references`](Self::set_references).
        ///
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn references(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::Reference>,
        ) -> Self {
            self.inner = self.inner.references(k, v);
            self
        }
        /// <p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP).</p>
        pub fn set_references(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, crate::model::Reference>,
            >,
        ) -> Self {
            self.inner = self.inner.set_references(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactAttributes`.
    ///
    /// <p>Creates or updates
    /// user-defined contact attributes
    /// associated with the specified contact.</p>
    /// <p>You can create or update user-defined attributes for both ongoing and completed contacts.
    /// For example, while the call is active, you can update the customer's name or the reason the
    /// customer called. You can add notes about steps that the agent took during the call that display
    /// to the next agent that takes the call. You can also update attributes for a contact using data
    /// from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls
    /// for additional analysis, such as legal review or to identify abusive callers.</p>
    /// <p>Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For
    /// information about CTR retention and the maximum size of the CTR attributes section, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature
    /// specifications</a> in the <i>Amazon Connect Administrator Guide</i>. </p>
    ///
    /// <p>
    /// <b>Important:</b> You cannot use the operation to update
    /// attributes for contacts that occurred prior to the release of the API, which was September 12,
    /// 2018. You can update attributes only for contacts that started after the release of the API. If
    /// you attempt to update attributes for a contact that occurred prior to the release of the API, a
    /// 400 error is returned. This applies also to queued callbacks that were initiated prior to the
    /// release of the API but are still active in your instance.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_attributes_input::Builder,
    }
    impl<C, M, R> UpdateContactAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactAttributesInputOperationOutputAlias,
                crate::output::UpdateContactAttributesOutput,
                crate::error::UpdateContactAttributesError,
                crate::input::UpdateContactAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn initial_contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.initial_contact_id(inp);
            self
        }
        /// <p>The identifier of the contact. This is the identifier of the contact associated with the
        /// first interaction with the contact center.</p>
        pub fn set_initial_contact_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_initial_contact_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// Adds a key-value pair to `Attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other
        /// contact attributes.</p>
        /// <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn attributes(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.attributes(k, v);
            self
        }
        /// <p>The Amazon Connect attributes. These attributes can be accessed in contact flows just like any other
        /// contact attributes.</p>
        /// <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys
        /// can include only alphanumeric, dash, and underscore characters.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowContent`.
    ///
    /// <p>Updates the specified contact flow.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect
    /// Flow language</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactFlowContent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_content_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowContentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowContentInputOperationOutputAlias,
                crate::output::UpdateContactFlowContentOutput,
                crate::error::UpdateContactFlowContentError,
                crate::input::UpdateContactFlowContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>The JSON string that represents contact flow’s content. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language-example.html">Example contact
        /// flow in Amazon Connect Flow language</a> in the <i>Amazon Connect Administrator Guide</i>.
        /// </p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The JSON string that represents contact flow’s content. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language-example.html">Example contact
        /// flow in Amazon Connect Flow language</a> in the <i>Amazon Connect Administrator Guide</i>.
        /// </p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowMetadata`.
    ///
    /// <p>Updates metadata about specified contact flow.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactFlowMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_metadata_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowMetadataInputOperationOutputAlias,
                crate::output::UpdateContactFlowMetadataOutput,
                crate::error::UpdateContactFlowMetadataError,
                crate::input::UpdateContactFlowMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>TThe name of the contact flow.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>TThe name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of contact flow.</p>
        pub fn contact_flow_state(mut self, inp: crate::model::ContactFlowState) -> Self {
            self.inner = self.inner.contact_flow_state(inp);
            self
        }
        /// <p>The state of contact flow.</p>
        pub fn set_contact_flow_state(
            mut self,
            input: std::option::Option<crate::model::ContactFlowState>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowModuleContent`.
    ///
    /// <p>Updates specified contact flow module for the specified Amazon Connect instance. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactFlowModuleContent<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_module_content_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowModuleContent<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowModuleContent`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowModuleContentOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowModuleContentError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowModuleContentInputOperationOutputAlias,
                crate::output::UpdateContactFlowModuleContentOutput,
                crate::error::UpdateContactFlowModuleContentError,
                crate::input::UpdateContactFlowModuleContentInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(inp);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn content(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content(inp);
            self
        }
        /// <p>The content of the contact flow module.</p>
        pub fn set_content(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowModuleMetadata`.
    ///
    /// <p>Updates metadata about specified contact flow module.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactFlowModuleMetadata<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_module_metadata_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowModuleMetadata<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowModuleMetadata`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowModuleMetadataOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowModuleMetadataError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowModuleMetadataInputOperationOutputAlias,
                crate::output::UpdateContactFlowModuleMetadataOutput,
                crate::error::UpdateContactFlowModuleMetadataError,
                crate::input::UpdateContactFlowModuleMetadataInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn contact_flow_module_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_module_id(inp);
            self
        }
        /// <p>The identifier of the contact flow module.</p>
        pub fn set_contact_flow_module_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_module_id(input);
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the contact flow module.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow module.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the contact flow module.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The state of contact flow module.</p>
        pub fn state(mut self, inp: crate::model::ContactFlowModuleState) -> Self {
            self.inner = self.inner.state(inp);
            self
        }
        /// <p>The state of contact flow module.</p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ContactFlowModuleState>,
        ) -> Self {
            self.inner = self.inner.set_state(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactFlowName`.
    ///
    /// <p>The name of the contact flow.</p>
    /// <p>You can also create and update contact flows using the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html">Amazon Connect
    /// Flow language</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactFlowName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_flow_name_input::Builder,
    }
    impl<C, M, R> UpdateContactFlowName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactFlowName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactFlowNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactFlowNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactFlowNameInputOperationOutputAlias,
                crate::output::UpdateContactFlowNameOutput,
                crate::error::UpdateContactFlowNameError,
                crate::input::UpdateContactFlowNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn contact_flow_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_flow_id(inp);
            self
        }
        /// <p>The identifier of the contact flow.</p>
        pub fn set_contact_flow_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_contact_flow_id(input);
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the contact flow.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the contact flow.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateContactSchedule`.
    ///
    /// <p>Updates the scheduled time of a task contact that is already scheduled.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateContactSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_contact_schedule_input::Builder,
    }
    impl<C, M, R> UpdateContactSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateContactSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateContactScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateContactScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateContactScheduleInputOperationOutputAlias,
                crate::output::UpdateContactScheduleOutput,
                crate::error::UpdateContactScheduleError,
                crate::input::UpdateContactScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn contact_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.contact_id(inp);
            self
        }
        /// <p>The identifier of the contact.</p>
        pub fn set_contact_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_contact_id(input);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn scheduled_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.scheduled_time(inp);
            self
        }
        /// <p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound contact flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>
        pub fn set_scheduled_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_time(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the hours of operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_hours_of_operation_input::Builder,
    }
    impl<C, M, R> UpdateHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateHoursOfOperationInputOperationOutputAlias,
                crate::output::UpdateHoursOfOperationOutput,
                crate::error::UpdateHoursOfOperationError,
                crate::input::UpdateHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(inp);
            self
        }
        /// <p>The identifier of the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the hours of operation.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the hours of operation.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn time_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_zone(inp);
            self
        }
        /// <p>The time zone of the hours of operation.</p>
        pub fn set_time_zone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_zone(input);
            self
        }
        /// Appends an item to `Config`.
        ///
        /// To override the contents of this collection use [`set_config`](Self::set_config).
        ///
        /// <p>Configuration information of the hours of operation.</p>
        pub fn config(mut self, inp: impl Into<crate::model::HoursOfOperationConfig>) -> Self {
            self.inner = self.inner.config(inp);
            self
        }
        /// <p>Configuration information of the hours of operation.</p>
        pub fn set_config(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HoursOfOperationConfig>>,
        ) -> Self {
            self.inner = self.inner.set_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceAttribute`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the value for the specified attribute type.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateInstanceAttribute<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_instance_attribute_input::Builder,
    }
    impl<C, M, R> UpdateInstanceAttribute<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInstanceAttribute`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInstanceAttributeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInstanceAttributeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInstanceAttributeInputOperationOutputAlias,
                crate::output::UpdateInstanceAttributeOutput,
                crate::error::UpdateInstanceAttributeError,
                crate::input::UpdateInstanceAttributeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The type of attribute.</p>
        /// <note>
        /// <p>Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access this feature, contact AWS Support for allowlisting.</p>
        /// </note>
        pub fn attribute_type(mut self, inp: crate::model::InstanceAttributeType) -> Self {
            self.inner = self.inner.attribute_type(inp);
            self
        }
        /// <p>The type of attribute.</p>
        /// <note>
        /// <p>Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access this feature, contact AWS Support for allowlisting.</p>
        /// </note>
        pub fn set_attribute_type(
            mut self,
            input: std::option::Option<crate::model::InstanceAttributeType>,
        ) -> Self {
            self.inner = self.inner.set_attribute_type(input);
            self
        }
        /// <p>The value for the attribute. Maximum character limit is 100. </p>
        pub fn value(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.value(inp);
            self
        }
        /// <p>The value for the attribute. Maximum character limit is 100. </p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_value(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateInstanceStorageConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates an existing configuration for a resource type. This API is idempotent.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateInstanceStorageConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_instance_storage_config_input::Builder,
    }
    impl<C, M, R> UpdateInstanceStorageConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateInstanceStorageConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateInstanceStorageConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateInstanceStorageConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateInstanceStorageConfigInputOperationOutputAlias,
                crate::output::UpdateInstanceStorageConfigOutput,
                crate::error::UpdateInstanceStorageConfigError,
                crate::input::UpdateInstanceStorageConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn association_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.association_id(inp);
            self
        }
        /// <p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>
        pub fn set_association_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_association_id(input);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn resource_type(mut self, inp: crate::model::InstanceStorageResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>A valid resource type.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The storage configuration for the instance.</p>
        pub fn storage_config(mut self, inp: crate::model::InstanceStorageConfig) -> Self {
            self.inner = self.inner.storage_config(inp);
            self
        }
        /// <p>The storage configuration for the instance.</p>
        pub fn set_storage_config(
            mut self,
            input: std::option::Option<crate::model::InstanceStorageConfig>,
        ) -> Self {
            self.inner = self.inner.set_storage_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueHoursOfOperation`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the hours of operation for the specified queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQueueHoursOfOperation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_hours_of_operation_input::Builder,
    }
    impl<C, M, R> UpdateQueueHoursOfOperation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueHoursOfOperation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueHoursOfOperationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueHoursOfOperationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueHoursOfOperationInputOperationOutputAlias,
                crate::output::UpdateQueueHoursOfOperationOutput,
                crate::error::UpdateQueueHoursOfOperationError,
                crate::input::UpdateQueueHoursOfOperationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn hours_of_operation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hours_of_operation_id(inp);
            self
        }
        /// <p>The identifier for the hours of operation.</p>
        pub fn set_hours_of_operation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hours_of_operation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueMaxContacts`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the maximum number of contacts allowed in a queue before it is considered
    /// full.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQueueMaxContacts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_max_contacts_input::Builder,
    }
    impl<C, M, R> UpdateQueueMaxContacts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueMaxContacts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueMaxContactsOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueMaxContactsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueMaxContactsInputOperationOutputAlias,
                crate::output::UpdateQueueMaxContactsOutput,
                crate::error::UpdateQueueMaxContactsError,
                crate::input::UpdateQueueMaxContactsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn max_contacts(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_contacts(inp);
            self
        }
        /// <p>The maximum number of contacts that can be in the queue before it is considered full.</p>
        pub fn set_max_contacts(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_contacts(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueName`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the name and description of a queue. At least <code>Name</code> or <code>Description</code> must be provided.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQueueName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_name_input::Builder,
    }
    impl<C, M, R> UpdateQueueName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueNameInputOperationOutputAlias,
                crate::output::UpdateQueueNameOutput,
                crate::error::UpdateQueueNameError,
                crate::input::UpdateQueueNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The name of the queue.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the queue.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the queue.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the queue.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueOutboundCallerConfig`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the outbound caller ID name, number, and outbound whisper flow for a specified
    /// queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQueueOutboundCallerConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_outbound_caller_config_input::Builder,
    }
    impl<C, M, R> UpdateQueueOutboundCallerConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueOutboundCallerConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueOutboundCallerConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueOutboundCallerConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueOutboundCallerConfigInputOperationOutputAlias,
                crate::output::UpdateQueueOutboundCallerConfigOutput,
                crate::error::UpdateQueueOutboundCallerConfigError,
                crate::input::UpdateQueueOutboundCallerConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn outbound_caller_config(mut self, inp: crate::model::OutboundCallerConfig) -> Self {
            self.inner = self.inner.outbound_caller_config(inp);
            self
        }
        /// <p>The outbound caller ID name, number, and outbound whisper flow.</p>
        pub fn set_outbound_caller_config(
            mut self,
            input: std::option::Option<crate::model::OutboundCallerConfig>,
        ) -> Self {
            self.inner = self.inner.set_outbound_caller_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueueStatus`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates the status of the queue.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQueueStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_status_input::Builder,
    }
    impl<C, M, R> UpdateQueueStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueueStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueStatusInputOperationOutputAlias,
                crate::output::UpdateQueueStatusOutput,
                crate::error::UpdateQueueStatusError,
                crate::input::UpdateQueueStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue_id(inp);
            self
        }
        /// <p>The identifier for the queue.</p>
        pub fn set_queue_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue_id(input);
            self
        }
        /// <p>The status of the queue.</p>
        pub fn status(mut self, inp: crate::model::QueueStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The status of the queue.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueueStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQuickConnectConfig`.
    ///
    /// <p>Updates the configuration settings for the specified quick connect.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQuickConnectConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_quick_connect_config_input::Builder,
    }
    impl<C, M, R> UpdateQuickConnectConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQuickConnectConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQuickConnectConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQuickConnectConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQuickConnectConfigInputOperationOutputAlias,
                crate::output::UpdateQuickConnectConfigOutput,
                crate::error::UpdateQuickConnectConfigError,
                crate::input::UpdateQuickConnectConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(inp);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
        /// <p>Information about the configuration settings for the quick connect.</p>
        pub fn quick_connect_config(mut self, inp: crate::model::QuickConnectConfig) -> Self {
            self.inner = self.inner.quick_connect_config(inp);
            self
        }
        /// <p>Information about the configuration settings for the quick connect.</p>
        pub fn set_quick_connect_config(
            mut self,
            input: std::option::Option<crate::model::QuickConnectConfig>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQuickConnectName`.
    ///
    /// <p>Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least <code>Name</code> or <code>Description</code> must be provided.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateQuickConnectName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_quick_connect_name_input::Builder,
    }
    impl<C, M, R> UpdateQuickConnectName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQuickConnectName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQuickConnectNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQuickConnectNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQuickConnectNameInputOperationOutputAlias,
                crate::output::UpdateQuickConnectNameOutput,
                crate::error::UpdateQuickConnectNameError,
                crate::input::UpdateQuickConnectNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn quick_connect_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.quick_connect_id(inp);
            self
        }
        /// <p>The identifier for the quick connect.</p>
        pub fn set_quick_connect_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_quick_connect_id(input);
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the quick connect.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the quick connect.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileConcurrency`.
    ///
    /// <p>Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing
    /// profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoutingProfileConcurrency<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_concurrency_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileConcurrency<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileConcurrency`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileConcurrencyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoutingProfileConcurrencyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileConcurrencyInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileConcurrencyOutput,
                crate::error::UpdateRoutingProfileConcurrencyError,
                crate::input::UpdateRoutingProfileConcurrencyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `MediaConcurrencies`.
        ///
        /// To override the contents of this collection use [`set_media_concurrencies`](Self::set_media_concurrencies).
        ///
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
        pub fn media_concurrencies(
            mut self,
            inp: impl Into<crate::model::MediaConcurrency>,
        ) -> Self {
            self.inner = self.inner.media_concurrencies(inp);
            self
        }
        /// <p>The channels that agents can handle in the Contact Control Panel (CCP).</p>
        pub fn set_media_concurrencies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConcurrency>>,
        ) -> Self {
            self.inner = self.inner.set_media_concurrencies(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileDefaultOutboundQueue`.
    ///
    /// <p>Updates the default outbound queue of a routing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoutingProfileDefaultOutboundQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_default_outbound_queue_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileDefaultOutboundQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileDefaultOutboundQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileDefaultOutboundQueueOutput,
            aws_smithy_http::result::SdkError<
                crate::error::UpdateRoutingProfileDefaultOutboundQueueError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileDefaultOutboundQueueInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileDefaultOutboundQueueOutput,
                crate::error::UpdateRoutingProfileDefaultOutboundQueueError,
                crate::input::UpdateRoutingProfileDefaultOutboundQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The identifier for the default outbound queue.</p>
        pub fn default_outbound_queue_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_outbound_queue_id(inp);
            self
        }
        /// <p>The identifier for the default outbound queue.</p>
        pub fn set_default_outbound_queue_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_outbound_queue_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileName`.
    ///
    /// <p>Updates the name and description of a routing profile. The request accepts the following data in JSON format.
    /// At least <code>Name</code> or <code>Description</code> must be provided.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoutingProfileName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_name_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoutingProfileNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileNameInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileNameOutput,
                crate::error::UpdateRoutingProfileNameError,
                crate::input::UpdateRoutingProfileNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the routing profile. Must not be more than 127 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The description of the routing profile. Must not be more than 250 characters.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the routing profile. Must not be more than 250 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateRoutingProfileQueues`.
    ///
    /// <p>Updates the properties associated with a set of queues for a routing profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateRoutingProfileQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_routing_profile_queues_input::Builder,
    }
    impl<C, M, R> UpdateRoutingProfileQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateRoutingProfileQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateRoutingProfileQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateRoutingProfileQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateRoutingProfileQueuesInputOperationOutputAlias,
                crate::output::UpdateRoutingProfileQueuesOutput,
                crate::error::UpdateRoutingProfileQueuesError,
                crate::input::UpdateRoutingProfileQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// Appends an item to `QueueConfigs`.
        ///
        /// To override the contents of this collection use [`set_queue_configs`](Self::set_queue_configs).
        ///
        /// <p>The queues to be updated for this routing profile.
        /// Queues must first be associated to the routing
        /// profile. You can do this using AssociateRoutingProfileQueues.</p>
        pub fn queue_configs(
            mut self,
            inp: impl Into<crate::model::RoutingProfileQueueConfig>,
        ) -> Self {
            self.inner = self.inner.queue_configs(inp);
            self
        }
        /// <p>The queues to be updated for this routing profile.
        /// Queues must first be associated to the routing
        /// profile. You can do this using AssociateRoutingProfileQueues.</p>
        pub fn set_queue_configs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RoutingProfileQueueConfig>>,
        ) -> Self {
            self.inner = self.inner.set_queue_configs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateSecurityProfile`.
    ///
    /// <p>This API is in preview release for Amazon Connect and is subject to change.</p>
    /// <p>Updates a security profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateSecurityProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_security_profile_input::Builder,
    }
    impl<C, M, R> UpdateSecurityProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateSecurityProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateSecurityProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateSecurityProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateSecurityProfileInputOperationOutputAlias,
                crate::output::UpdateSecurityProfileOutput,
                crate::error::UpdateSecurityProfileError,
                crate::input::UpdateSecurityProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The description of the security profile.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>The description of the security profile.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Permissions`.
        ///
        /// To override the contents of this collection use [`set_permissions`](Self::set_permissions).
        ///
        /// <p>The permissions granted to a security profile.</p>
        pub fn permissions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.permissions(inp);
            self
        }
        /// <p>The permissions granted to a security profile.</p>
        pub fn set_permissions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_permissions(input);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn security_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_id(inp);
            self
        }
        /// <p>The identifier for the security profle.</p>
        pub fn set_security_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserHierarchy`.
    ///
    /// <p>Assigns the specified hierarchy group to the specified user.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserHierarchy<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_hierarchy_input::Builder,
    }
    impl<C, M, R> UpdateUserHierarchy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserHierarchy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserHierarchyOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserHierarchyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserHierarchyInputOperationOutputAlias,
                crate::output::UpdateUserHierarchyOutput,
                crate::error::UpdateUserHierarchyError,
                crate::input::UpdateUserHierarchyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(inp);
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserHierarchyGroupName`.
    ///
    /// <p>Updates the name of the user hierarchy group. </p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserHierarchyGroupName<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_hierarchy_group_name_input::Builder,
    }
    impl<C, M, R> UpdateUserHierarchyGroupName<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserHierarchyGroupName`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserHierarchyGroupNameOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserHierarchyGroupNameError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserHierarchyGroupNameInputOperationOutputAlias,
                crate::output::UpdateUserHierarchyGroupNameOutput,
                crate::error::UpdateUserHierarchyGroupNameError,
                crate::input::UpdateUserHierarchyGroupNameInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the hierarchy group. Must not be more than 100 characters.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the hierarchy group. Must not be more than 100 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn hierarchy_group_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hierarchy_group_id(inp);
            self
        }
        /// <p>The identifier of the hierarchy group.</p>
        pub fn set_hierarchy_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_group_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserHierarchyStructure`.
    ///
    /// <p>Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserHierarchyStructure<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_hierarchy_structure_input::Builder,
    }
    impl<C, M, R> UpdateUserHierarchyStructure<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserHierarchyStructure`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserHierarchyStructureOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserHierarchyStructureError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserHierarchyStructureInputOperationOutputAlias,
                crate::output::UpdateUserHierarchyStructureOutput,
                crate::error::UpdateUserHierarchyStructureError,
                crate::input::UpdateUserHierarchyStructureInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The hierarchy levels to update.</p>
        pub fn hierarchy_structure(mut self, inp: crate::model::HierarchyStructureUpdate) -> Self {
            self.inner = self.inner.hierarchy_structure(inp);
            self
        }
        /// <p>The hierarchy levels to update.</p>
        pub fn set_hierarchy_structure(
            mut self,
            input: std::option::Option<crate::model::HierarchyStructureUpdate>,
        ) -> Self {
            self.inner = self.inner.set_hierarchy_structure(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserIdentityInfo`.
    ///
    /// <p>Updates the identity information for the specified user.</p>
    /// <important>
    /// <p>We strongly recommend limiting who has the ability to invoke
    /// <code>UpdateUserIdentityInfo</code>. Someone with that ability can change the login credentials
    /// of other users by changing their email address. This poses a security risk to your organization.
    /// They can change the email address of a user to the attacker's email address, and then reset the
    /// password through email. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html">Best Practices for
    /// Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserIdentityInfo<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_identity_info_input::Builder,
    }
    impl<C, M, R> UpdateUserIdentityInfo<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserIdentityInfo`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserIdentityInfoOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserIdentityInfoError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserIdentityInfoInputOperationOutputAlias,
                crate::output::UpdateUserIdentityInfoOutput,
                crate::error::UpdateUserIdentityInfoError,
                crate::input::UpdateUserIdentityInfoInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identity information for the user.</p>
        pub fn identity_info(mut self, inp: crate::model::UserIdentityInfo) -> Self {
            self.inner = self.inner.identity_info(inp);
            self
        }
        /// <p>The identity information for the user.</p>
        pub fn set_identity_info(
            mut self,
            input: std::option::Option<crate::model::UserIdentityInfo>,
        ) -> Self {
            self.inner = self.inner.set_identity_info(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserPhoneConfig`.
    ///
    /// <p>Updates the phone configuration settings for the specified user.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserPhoneConfig<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_phone_config_input::Builder,
    }
    impl<C, M, R> UpdateUserPhoneConfig<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserPhoneConfig`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserPhoneConfigOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserPhoneConfigError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserPhoneConfigInputOperationOutputAlias,
                crate::output::UpdateUserPhoneConfigOutput,
                crate::error::UpdateUserPhoneConfigError,
                crate::input::UpdateUserPhoneConfigInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Information about phone configuration settings for the user.</p>
        pub fn phone_config(mut self, inp: crate::model::UserPhoneConfig) -> Self {
            self.inner = self.inner.phone_config(inp);
            self
        }
        /// <p>Information about phone configuration settings for the user.</p>
        pub fn set_phone_config(
            mut self,
            input: std::option::Option<crate::model::UserPhoneConfig>,
        ) -> Self {
            self.inner = self.inner.set_phone_config(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserRoutingProfile`.
    ///
    /// <p>Assigns the specified routing profile to the specified user.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserRoutingProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_routing_profile_input::Builder,
    }
    impl<C, M, R> UpdateUserRoutingProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserRoutingProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserRoutingProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserRoutingProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserRoutingProfileInputOperationOutputAlias,
                crate::output::UpdateUserRoutingProfileOutput,
                crate::error::UpdateUserRoutingProfileError,
                crate::input::UpdateUserRoutingProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn routing_profile_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.routing_profile_id(inp);
            self
        }
        /// <p>The identifier of the routing profile for the user.</p>
        pub fn set_routing_profile_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_routing_profile_id(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateUserSecurityProfiles`.
    ///
    /// <p>Assigns the specified security profiles to the specified user.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateUserSecurityProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_user_security_profiles_input::Builder,
    }
    impl<C, M, R> UpdateUserSecurityProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateUserSecurityProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateUserSecurityProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateUserSecurityProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateUserSecurityProfilesInputOperationOutputAlias,
                crate::output::UpdateUserSecurityProfilesOutput,
                crate::error::UpdateUserSecurityProfilesError,
                crate::input::UpdateUserSecurityProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SecurityProfileIds`.
        ///
        /// To override the contents of this collection use [`set_security_profile_ids`](Self::set_security_profile_ids).
        ///
        /// <p>The identifiers of the security profiles for the user.</p>
        pub fn security_profile_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.security_profile_ids(inp);
            self
        }
        /// <p>The identifiers of the security profiles for the user.</p>
        pub fn set_security_profile_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_security_profile_ids(input);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn user_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.user_id(inp);
            self
        }
        /// <p>The identifier of the user account.</p>
        pub fn set_user_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_user_id(input);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn instance_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.instance_id(inp);
            self
        }
        /// <p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>
        pub fn set_instance_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_instance_id(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
