// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateApprovedOrigin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateApprovedOriginError {
    /// Kind of error that occurred.
    pub kind: AssociateApprovedOriginErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateApprovedOrigin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateApprovedOriginErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource already has that name.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateApprovedOriginError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateApprovedOriginErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AssociateApprovedOriginErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateApprovedOriginErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateApprovedOriginErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            AssociateApprovedOriginErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateApprovedOriginErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateApprovedOriginErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateApprovedOriginErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateApprovedOriginError {
    fn code(&self) -> Option<&str> {
        AssociateApprovedOriginError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateApprovedOriginError {
    /// Creates a new `AssociateApprovedOriginError`.
    pub fn new(kind: AssociateApprovedOriginErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateApprovedOriginError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateApprovedOriginErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateApprovedOriginError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateApprovedOriginErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateApprovedOriginErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovedOriginErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovedOriginErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovedOriginErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovedOriginErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovedOriginErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovedOriginErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovedOriginErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovedOriginErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovedOriginErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovedOriginErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovedOriginErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateApprovedOriginErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateApprovedOriginErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateApprovedOriginError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateApprovedOriginErrorKind::InternalServiceException(_inner) => Some(_inner),
            AssociateApprovedOriginErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateApprovedOriginErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateApprovedOriginErrorKind::ResourceConflictException(_inner) => Some(_inner),
            AssociateApprovedOriginErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateApprovedOriginErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AssociateApprovedOriginErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateApprovedOriginErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateBotError {
    /// Kind of error that occurred.
    pub kind: AssociateBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateBotErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>A resource already has that name.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateBotErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AssociateBotErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateBotErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateBotErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            AssociateBotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateBotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AssociateBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateBotError {
    fn code(&self) -> Option<&str> {
        AssociateBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateBotError {
    /// Creates a new `AssociateBotError`.
    pub fn new(kind: AssociateBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateBotErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBotErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBotErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBotErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBotErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AssociateBotErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `AssociateBotErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBotErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateBotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AssociateBotErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for AssociateBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateBotErrorKind::InternalServiceException(_inner) => Some(_inner),
            AssociateBotErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateBotErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateBotErrorKind::ResourceConflictException(_inner) => Some(_inner),
            AssociateBotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateBotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AssociateBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateInstanceStorageConfigError {
    /// Kind of error that occurred.
    pub kind: AssociateInstanceStorageConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateInstanceStorageConfigErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource already has that name.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateInstanceStorageConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateInstanceStorageConfigErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            AssociateInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociateInstanceStorageConfigErrorKind::ResourceConflictException(_inner) => {
                _inner.fmt(f)
            }
            AssociateInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateInstanceStorageConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateInstanceStorageConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateInstanceStorageConfigError {
    fn code(&self) -> Option<&str> {
        AssociateInstanceStorageConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateInstanceStorageConfigError {
    /// Creates a new `AssociateInstanceStorageConfigError`.
    pub fn new(
        kind: AssociateInstanceStorageConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateInstanceStorageConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateInstanceStorageConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateInstanceStorageConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateInstanceStorageConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateInstanceStorageConfigErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateInstanceStorageConfigErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateInstanceStorageConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateInstanceStorageConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateInstanceStorageConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateInstanceStorageConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateInstanceStorageConfigErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateInstanceStorageConfigErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateInstanceStorageConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateInstanceStorageConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateInstanceStorageConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateInstanceStorageConfigErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateInstanceStorageConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateInstanceStorageConfigErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            AssociateInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            AssociateInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            AssociateInstanceStorageConfigErrorKind::ResourceConflictException(_inner) => {
                Some(_inner)
            }
            AssociateInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateInstanceStorageConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateInstanceStorageConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateLambdaFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateLambdaFunctionError {
    /// Kind of error that occurred.
    pub kind: AssociateLambdaFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateLambdaFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateLambdaFunctionErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource already has that name.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateLambdaFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateLambdaFunctionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AssociateLambdaFunctionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateLambdaFunctionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateLambdaFunctionErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            AssociateLambdaFunctionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateLambdaFunctionErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            AssociateLambdaFunctionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateLambdaFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateLambdaFunctionError {
    fn code(&self) -> Option<&str> {
        AssociateLambdaFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateLambdaFunctionError {
    /// Creates a new `AssociateLambdaFunctionError`.
    pub fn new(kind: AssociateLambdaFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateLambdaFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateLambdaFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateLambdaFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateLambdaFunctionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateLambdaFunctionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLambdaFunctionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLambdaFunctionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLambdaFunctionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLambdaFunctionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLambdaFunctionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLambdaFunctionErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLambdaFunctionErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLambdaFunctionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLambdaFunctionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLambdaFunctionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLambdaFunctionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLambdaFunctionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLambdaFunctionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateLambdaFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateLambdaFunctionErrorKind::InternalServiceException(_inner) => Some(_inner),
            AssociateLambdaFunctionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateLambdaFunctionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateLambdaFunctionErrorKind::ResourceConflictException(_inner) => Some(_inner),
            AssociateLambdaFunctionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateLambdaFunctionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AssociateLambdaFunctionErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateLambdaFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateLexBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateLexBotError {
    /// Kind of error that occurred.
    pub kind: AssociateLexBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateLexBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateLexBotErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource already has that name.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateLexBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateLexBotErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AssociateLexBotErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateLexBotErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateLexBotErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            AssociateLexBotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateLexBotErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AssociateLexBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateLexBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateLexBotError {
    fn code(&self) -> Option<&str> {
        AssociateLexBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateLexBotError {
    /// Creates a new `AssociateLexBotError`.
    pub fn new(kind: AssociateLexBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateLexBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateLexBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateLexBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateLexBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateLexBotErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLexBotErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLexBotErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLexBotErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLexBotErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLexBotErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLexBotErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLexBotErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLexBotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLexBotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLexBotErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateLexBotErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateLexBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, AssociateLexBotErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for AssociateLexBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateLexBotErrorKind::InternalServiceException(_inner) => Some(_inner),
            AssociateLexBotErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateLexBotErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateLexBotErrorKind::ResourceConflictException(_inner) => Some(_inner),
            AssociateLexBotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateLexBotErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AssociateLexBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateLexBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateQueueQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateQueueQuickConnectsError {
    /// Kind of error that occurred.
    pub kind: AssociateQueueQuickConnectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateQueueQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateQueueQuickConnectsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateQueueQuickConnectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateQueueQuickConnectsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AssociateQueueQuickConnectsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateQueueQuickConnectsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateQueueQuickConnectsErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            AssociateQueueQuickConnectsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateQueueQuickConnectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateQueueQuickConnectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateQueueQuickConnectsError {
    fn code(&self) -> Option<&str> {
        AssociateQueueQuickConnectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateQueueQuickConnectsError {
    /// Creates a new `AssociateQueueQuickConnectsError`.
    pub fn new(kind: AssociateQueueQuickConnectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateQueueQuickConnectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateQueueQuickConnectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateQueueQuickConnectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateQueueQuickConnectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateQueueQuickConnectsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQueueQuickConnectsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateQueueQuickConnectsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQueueQuickConnectsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateQueueQuickConnectsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQueueQuickConnectsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateQueueQuickConnectsErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQueueQuickConnectsErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateQueueQuickConnectsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQueueQuickConnectsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateQueueQuickConnectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateQueueQuickConnectsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateQueueQuickConnectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateQueueQuickConnectsErrorKind::InternalServiceException(_inner) => Some(_inner),
            AssociateQueueQuickConnectsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateQueueQuickConnectsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateQueueQuickConnectsErrorKind::LimitExceededException(_inner) => Some(_inner),
            AssociateQueueQuickConnectsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateQueueQuickConnectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateQueueQuickConnectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateRoutingProfileQueuesError {
    /// Kind of error that occurred.
    pub kind: AssociateRoutingProfileQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateRoutingProfileQueuesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateRoutingProfileQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            AssociateRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            AssociateRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            AssociateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            AssociateRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateRoutingProfileQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateRoutingProfileQueuesError {
    fn code(&self) -> Option<&str> {
        AssociateRoutingProfileQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateRoutingProfileQueuesError {
    /// Creates a new `AssociateRoutingProfileQueuesError`.
    pub fn new(
        kind: AssociateRoutingProfileQueuesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateRoutingProfileQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateRoutingProfileQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateRoutingProfileQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateRoutingProfileQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateRoutingProfileQueuesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateRoutingProfileQueuesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateRoutingProfileQueuesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateRoutingProfileQueuesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateRoutingProfileQueuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateRoutingProfileQueuesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateRoutingProfileQueuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateRoutingProfileQueuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateRoutingProfileQueuesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateRoutingProfileQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            AssociateRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            AssociateRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            AssociateRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateRoutingProfileQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateSecurityKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateSecurityKeyError {
    /// Kind of error that occurred.
    pub kind: AssociateSecurityKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateSecurityKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateSecurityKeyErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource already has that name.</p>
    ResourceConflictException(crate::error::ResourceConflictException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateSecurityKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateSecurityKeyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            AssociateSecurityKeyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            AssociateSecurityKeyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            AssociateSecurityKeyErrorKind::ResourceConflictException(_inner) => _inner.fmt(f),
            AssociateSecurityKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AssociateSecurityKeyErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AssociateSecurityKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AssociateSecurityKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateSecurityKeyError {
    fn code(&self) -> Option<&str> {
        AssociateSecurityKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateSecurityKeyError {
    /// Creates a new `AssociateSecurityKeyError`.
    pub fn new(kind: AssociateSecurityKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateSecurityKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateSecurityKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateSecurityKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateSecurityKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateSecurityKeyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSecurityKeyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSecurityKeyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSecurityKeyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSecurityKeyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSecurityKeyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSecurityKeyErrorKind::ResourceConflictException`.
    pub fn is_resource_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSecurityKeyErrorKind::ResourceConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSecurityKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSecurityKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSecurityKeyErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSecurityKeyErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateSecurityKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateSecurityKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for AssociateSecurityKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateSecurityKeyErrorKind::InternalServiceException(_inner) => Some(_inner),
            AssociateSecurityKeyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            AssociateSecurityKeyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            AssociateSecurityKeyErrorKind::ResourceConflictException(_inner) => Some(_inner),
            AssociateSecurityKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AssociateSecurityKeyErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AssociateSecurityKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            AssociateSecurityKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAgentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAgentStatusError {
    /// Kind of error that occurred.
    pub kind: CreateAgentStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAgentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAgentStatusErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAgentStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAgentStatusErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateAgentStatusErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateAgentStatusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateAgentStatusErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateAgentStatusErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateAgentStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateAgentStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateAgentStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAgentStatusError {
    fn code(&self) -> Option<&str> {
        CreateAgentStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAgentStatusError {
    /// Creates a new `CreateAgentStatusError`.
    pub fn new(kind: CreateAgentStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAgentStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAgentStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAgentStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAgentStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAgentStatusErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAgentStatusErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAgentStatusErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAgentStatusErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAgentStatusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAgentStatusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAgentStatusErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAgentStatusErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAgentStatusErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAgentStatusErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAgentStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAgentStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAgentStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateAgentStatusErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateAgentStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAgentStatusErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateAgentStatusErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateAgentStatusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateAgentStatusErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateAgentStatusErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateAgentStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateAgentStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateAgentStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateContactFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateContactFlowError {
    /// Kind of error that occurred.
    pub kind: CreateContactFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateContactFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateContactFlowErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The contact flow is not valid.</p>
    InvalidContactFlowException(crate::error::InvalidContactFlowException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateContactFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateContactFlowErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::InvalidContactFlowException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateContactFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateContactFlowError {
    fn code(&self) -> Option<&str> {
        CreateContactFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateContactFlowError {
    /// Creates a new `CreateContactFlowError`.
    pub fn new(kind: CreateContactFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateContactFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateContactFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateContactFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateContactFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::InvalidContactFlowException`.
    pub fn is_invalid_contact_flow_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::InvalidContactFlowException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateContactFlowErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateContactFlowErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateContactFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateContactFlowErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::InvalidContactFlowException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateContactFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHoursOfOperationError {
    /// Kind of error that occurred.
    pub kind: CreateHoursOfOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHoursOfOperationErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHoursOfOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHoursOfOperationErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateHoursOfOperationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateHoursOfOperationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateHoursOfOperationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateHoursOfOperationErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateHoursOfOperationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateHoursOfOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHoursOfOperationError {
    fn code(&self) -> Option<&str> {
        CreateHoursOfOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHoursOfOperationError {
    /// Creates a new `CreateHoursOfOperationError`.
    pub fn new(kind: CreateHoursOfOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHoursOfOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHoursOfOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHoursOfOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHoursOfOperationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHoursOfOperationErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHoursOfOperationErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHoursOfOperationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHoursOfOperationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHoursOfOperationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHoursOfOperationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHoursOfOperationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHoursOfOperationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHoursOfOperationErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHoursOfOperationErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHoursOfOperationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHoursOfOperationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHoursOfOperationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateHoursOfOperationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateHoursOfOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHoursOfOperationErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateHoursOfOperationErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateHoursOfOperationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateHoursOfOperationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateHoursOfOperationErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateHoursOfOperationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateHoursOfOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInstanceError {
    /// Kind of error that occurred.
    pub kind: CreateInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInstanceErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInstanceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateInstanceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateInstanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateInstanceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateInstanceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInstanceError {
    fn code(&self) -> Option<&str> {
        CreateInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInstanceError {
    /// Creates a new `CreateInstanceError`.
    pub fn new(kind: CreateInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInstanceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInstanceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInstanceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateInstanceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInstanceErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateInstanceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateInstanceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateInstanceErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateIntegrationAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateIntegrationAssociationError {
    /// Kind of error that occurred.
    pub kind: CreateIntegrationAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateIntegrationAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateIntegrationAssociationErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateIntegrationAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateIntegrationAssociationErrorKind::DuplicateResourceException(_inner) => {
                _inner.fmt(f)
            }
            CreateIntegrationAssociationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            CreateIntegrationAssociationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateIntegrationAssociationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            CreateIntegrationAssociationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateIntegrationAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateIntegrationAssociationError {
    fn code(&self) -> Option<&str> {
        CreateIntegrationAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateIntegrationAssociationError {
    /// Creates a new `CreateIntegrationAssociationError`.
    pub fn new(kind: CreateIntegrationAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateIntegrationAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateIntegrationAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateIntegrationAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateIntegrationAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateIntegrationAssociationErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationAssociationErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntegrationAssociationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationAssociationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntegrationAssociationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationAssociationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntegrationAssociationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationAssociationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateIntegrationAssociationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateIntegrationAssociationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateIntegrationAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateIntegrationAssociationErrorKind::DuplicateResourceException(_inner) => {
                Some(_inner)
            }
            CreateIntegrationAssociationErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateIntegrationAssociationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateIntegrationAssociationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            CreateIntegrationAssociationErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateIntegrationAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateQueueError {
    /// Kind of error that occurred.
    pub kind: CreateQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateQueueErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateQueueErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateQueueError {
    fn code(&self) -> Option<&str> {
        CreateQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateQueueError {
    /// Creates a new `CreateQueueError`.
    pub fn new(kind: CreateQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueueErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueueErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueueErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueueErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateQueueErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateQueueErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateQueueErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateQueueErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateQueueErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateQueueErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateQueueErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateQuickConnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateQuickConnectError {
    /// Kind of error that occurred.
    pub kind: CreateQuickConnectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateQuickConnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateQuickConnectErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateQuickConnectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateQuickConnectErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateQuickConnectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateQuickConnectErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateQuickConnectErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateQuickConnectErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateQuickConnectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateQuickConnectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateQuickConnectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateQuickConnectError {
    fn code(&self) -> Option<&str> {
        CreateQuickConnectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateQuickConnectError {
    /// Creates a new `CreateQuickConnectError`.
    pub fn new(kind: CreateQuickConnectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateQuickConnectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateQuickConnectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateQuickConnectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateQuickConnectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateQuickConnectErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuickConnectErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuickConnectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuickConnectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuickConnectErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuickConnectErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuickConnectErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuickConnectErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuickConnectErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuickConnectErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuickConnectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuickConnectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQuickConnectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQuickConnectErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateQuickConnectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateQuickConnectErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateQuickConnectErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateQuickConnectErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateQuickConnectErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateQuickConnectErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateQuickConnectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateQuickConnectErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateQuickConnectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRoutingProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRoutingProfileError {
    /// Kind of error that occurred.
    pub kind: CreateRoutingProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRoutingProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRoutingProfileErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRoutingProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRoutingProfileErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateRoutingProfileErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateRoutingProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateRoutingProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateRoutingProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateRoutingProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRoutingProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateRoutingProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRoutingProfileError {
    fn code(&self) -> Option<&str> {
        CreateRoutingProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRoutingProfileError {
    /// Creates a new `CreateRoutingProfileError`.
    pub fn new(kind: CreateRoutingProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRoutingProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRoutingProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRoutingProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRoutingProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRoutingProfileErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingProfileErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingProfileErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingProfileErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRoutingProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRoutingProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateRoutingProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRoutingProfileErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateRoutingProfileErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateRoutingProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateRoutingProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateRoutingProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateRoutingProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRoutingProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateRoutingProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: CreateSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSecurityProfileErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSecurityProfileErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSecurityProfileError {
    fn code(&self) -> Option<&str> {
        CreateSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSecurityProfileError {
    /// Creates a new `CreateSecurityProfileError`.
    pub fn new(kind: CreateSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSecurityProfileErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUseCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUseCaseError {
    /// Kind of error that occurred.
    pub kind: CreateUseCaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUseCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUseCaseErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUseCaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUseCaseErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateUseCaseErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateUseCaseErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateUseCaseErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUseCaseErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateUseCaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUseCaseError {
    fn code(&self) -> Option<&str> {
        CreateUseCaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUseCaseError {
    /// Creates a new `CreateUseCaseError`.
    pub fn new(kind: CreateUseCaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUseCaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUseCaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUseCaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUseCaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUseCaseErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUseCaseErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUseCaseErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUseCaseErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUseCaseErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUseCaseErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUseCaseErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUseCaseErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUseCaseErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateUseCaseErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateUseCaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUseCaseErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateUseCaseErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateUseCaseErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateUseCaseErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUseCaseErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateUseCaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserError {
    /// Kind of error that occurred.
    pub kind: CreateUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserError {
    fn code(&self) -> Option<&str> {
        CreateUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserError {
    /// Creates a new `CreateUserError`.
    pub fn new(kind: CreateUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for CreateUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateUserErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateUserErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUserHierarchyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUserHierarchyGroupError {
    /// Kind of error that occurred.
    pub kind: CreateUserHierarchyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUserHierarchyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUserHierarchyGroupErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUserHierarchyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUserHierarchyGroupErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            CreateUserHierarchyGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            CreateUserHierarchyGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            CreateUserHierarchyGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateUserHierarchyGroupErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            CreateUserHierarchyGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateUserHierarchyGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateUserHierarchyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUserHierarchyGroupError {
    fn code(&self) -> Option<&str> {
        CreateUserHierarchyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUserHierarchyGroupError {
    /// Creates a new `CreateUserHierarchyGroupError`.
    pub fn new(kind: CreateUserHierarchyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUserHierarchyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUserHierarchyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUserHierarchyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUserHierarchyGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUserHierarchyGroupErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserHierarchyGroupErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserHierarchyGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserHierarchyGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserHierarchyGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserHierarchyGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserHierarchyGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserHierarchyGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserHierarchyGroupErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserHierarchyGroupErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserHierarchyGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserHierarchyGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUserHierarchyGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateUserHierarchyGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for CreateUserHierarchyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUserHierarchyGroupErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            CreateUserHierarchyGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            CreateUserHierarchyGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            CreateUserHierarchyGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateUserHierarchyGroupErrorKind::LimitExceededException(_inner) => Some(_inner),
            CreateUserHierarchyGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateUserHierarchyGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateUserHierarchyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHoursOfOperationError {
    /// Kind of error that occurred.
    pub kind: DeleteHoursOfOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHoursOfOperationErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHoursOfOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHoursOfOperationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteHoursOfOperationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteHoursOfOperationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteHoursOfOperationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteHoursOfOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHoursOfOperationError {
    fn code(&self) -> Option<&str> {
        DeleteHoursOfOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHoursOfOperationError {
    /// Creates a new `DeleteHoursOfOperationError`.
    pub fn new(kind: DeleteHoursOfOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHoursOfOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHoursOfOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHoursOfOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHoursOfOperationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHoursOfOperationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHoursOfOperationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHoursOfOperationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHoursOfOperationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHoursOfOperationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHoursOfOperationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHoursOfOperationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHoursOfOperationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHoursOfOperationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHoursOfOperationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteHoursOfOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHoursOfOperationErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteHoursOfOperationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteHoursOfOperationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteHoursOfOperationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteHoursOfOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInstanceErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInstanceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInstanceError {
    /// Creates a new `DeleteInstanceError`.
    pub fn new(kind: DeleteInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInstanceErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteIntegrationAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteIntegrationAssociationError {
    /// Kind of error that occurred.
    pub kind: DeleteIntegrationAssociationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteIntegrationAssociation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteIntegrationAssociationErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteIntegrationAssociationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteIntegrationAssociationErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DeleteIntegrationAssociationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteIntegrationAssociationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DeleteIntegrationAssociationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteIntegrationAssociationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteIntegrationAssociationError {
    fn code(&self) -> Option<&str> {
        DeleteIntegrationAssociationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteIntegrationAssociationError {
    /// Creates a new `DeleteIntegrationAssociationError`.
    pub fn new(kind: DeleteIntegrationAssociationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteIntegrationAssociationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteIntegrationAssociationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteIntegrationAssociationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteIntegrationAssociationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteIntegrationAssociationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationAssociationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntegrationAssociationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationAssociationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntegrationAssociationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationAssociationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteIntegrationAssociationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteIntegrationAssociationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteIntegrationAssociationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteIntegrationAssociationErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteIntegrationAssociationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteIntegrationAssociationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DeleteIntegrationAssociationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteIntegrationAssociationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQuickConnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQuickConnectError {
    /// Kind of error that occurred.
    pub kind: DeleteQuickConnectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQuickConnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQuickConnectErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQuickConnectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQuickConnectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteQuickConnectErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteQuickConnectErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteQuickConnectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteQuickConnectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteQuickConnectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQuickConnectError {
    fn code(&self) -> Option<&str> {
        DeleteQuickConnectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQuickConnectError {
    /// Creates a new `DeleteQuickConnectError`.
    pub fn new(kind: DeleteQuickConnectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQuickConnectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQuickConnectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQuickConnectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQuickConnectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteQuickConnectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuickConnectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuickConnectErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuickConnectErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuickConnectErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuickConnectErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuickConnectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuickConnectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQuickConnectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQuickConnectErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteQuickConnectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQuickConnectErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteQuickConnectErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteQuickConnectErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteQuickConnectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteQuickConnectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteQuickConnectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSecurityProfileErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>That resource is already in use. Please try another.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSecurityProfileErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSecurityProfileError {
    fn code(&self) -> Option<&str> {
        DeleteSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSecurityProfileError {
    /// Creates a new `DeleteSecurityProfileError`.
    pub fn new(kind: DeleteSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSecurityProfileErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUseCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUseCaseError {
    /// Kind of error that occurred.
    pub kind: DeleteUseCaseErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUseCase` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUseCaseErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUseCaseError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUseCaseErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteUseCaseErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteUseCaseErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUseCaseErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteUseCaseErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUseCaseError {
    fn code(&self) -> Option<&str> {
        DeleteUseCaseError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUseCaseError {
    /// Creates a new `DeleteUseCaseError`.
    pub fn new(kind: DeleteUseCaseErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUseCaseError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUseCaseErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUseCaseError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUseCaseErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUseCaseErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUseCaseErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUseCaseErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUseCaseErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUseCaseErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUseCaseErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUseCaseErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteUseCaseErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteUseCaseError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUseCaseErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteUseCaseErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteUseCaseErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUseCaseErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteUseCaseErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserError {
    /// Kind of error that occurred.
    pub kind: DeleteUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserError {
    fn code(&self) -> Option<&str> {
        DeleteUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserError {
    /// Creates a new `DeleteUserError`.
    pub fn new(kind: DeleteUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUserHierarchyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUserHierarchyGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteUserHierarchyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUserHierarchyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUserHierarchyGroupErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>That resource is already in use. Please try another.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUserHierarchyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUserHierarchyGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DeleteUserHierarchyGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DeleteUserHierarchyGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteUserHierarchyGroupErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            DeleteUserHierarchyGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteUserHierarchyGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteUserHierarchyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUserHierarchyGroupError {
    fn code(&self) -> Option<&str> {
        DeleteUserHierarchyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUserHierarchyGroupError {
    /// Creates a new `DeleteUserHierarchyGroupError`.
    pub fn new(kind: DeleteUserHierarchyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUserHierarchyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUserHierarchyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUserHierarchyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUserHierarchyGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUserHierarchyGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserHierarchyGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserHierarchyGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserHierarchyGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserHierarchyGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserHierarchyGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserHierarchyGroupErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserHierarchyGroupErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserHierarchyGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserHierarchyGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUserHierarchyGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUserHierarchyGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DeleteUserHierarchyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUserHierarchyGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            DeleteUserHierarchyGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DeleteUserHierarchyGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteUserHierarchyGroupErrorKind::ResourceInUseException(_inner) => Some(_inner),
            DeleteUserHierarchyGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteUserHierarchyGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteUserHierarchyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAgentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAgentStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeAgentStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAgentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAgentStatusErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAgentStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAgentStatusErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeAgentStatusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeAgentStatusErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeAgentStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeAgentStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeAgentStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAgentStatusError {
    fn code(&self) -> Option<&str> {
        DescribeAgentStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAgentStatusError {
    /// Creates a new `DescribeAgentStatusError`.
    pub fn new(kind: DescribeAgentStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAgentStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAgentStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAgentStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAgentStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAgentStatusErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAgentStatusErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAgentStatusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAgentStatusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAgentStatusErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAgentStatusErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAgentStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAgentStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAgentStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAgentStatusErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeAgentStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAgentStatusErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeAgentStatusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeAgentStatusErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeAgentStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeAgentStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeAgentStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeContactError {
    /// Kind of error that occurred.
    pub kind: DescribeContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeContactErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeContactErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeContactError {
    fn code(&self) -> Option<&str> {
        DescribeContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeContactError {
    /// Creates a new `DescribeContactError`.
    pub fn new(kind: DescribeContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeContactErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeContactErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeContactErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeContactFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeContactFlowError {
    /// Kind of error that occurred.
    pub kind: DescribeContactFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeContactFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeContactFlowErrorKind {
    /// <p>The contact flow has not been published.</p>
    ContactFlowNotPublishedException(crate::error::ContactFlowNotPublishedException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeContactFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeContactFlowErrorKind::ContactFlowNotPublishedException(_inner) => _inner.fmt(f),
            DescribeContactFlowErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeContactFlowErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeContactFlowErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeContactFlowErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeContactFlowErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeContactFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeContactFlowError {
    fn code(&self) -> Option<&str> {
        DescribeContactFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeContactFlowError {
    /// Creates a new `DescribeContactFlowError`.
    pub fn new(kind: DescribeContactFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeContactFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeContactFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeContactFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeContactFlowErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeContactFlowErrorKind::ContactFlowNotPublishedException`.
    pub fn is_contact_flow_not_published_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactFlowErrorKind::ContactFlowNotPublishedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactFlowErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactFlowErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactFlowErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactFlowErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactFlowErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactFlowErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactFlowErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactFlowErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeContactFlowErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeContactFlowErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeContactFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeContactFlowErrorKind::ContactFlowNotPublishedException(_inner) => Some(_inner),
            DescribeContactFlowErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeContactFlowErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeContactFlowErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeContactFlowErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeContactFlowErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeContactFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHoursOfOperationError {
    /// Kind of error that occurred.
    pub kind: DescribeHoursOfOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHoursOfOperationErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHoursOfOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHoursOfOperationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeHoursOfOperationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeHoursOfOperationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeHoursOfOperationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeHoursOfOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHoursOfOperationError {
    fn code(&self) -> Option<&str> {
        DescribeHoursOfOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHoursOfOperationError {
    /// Creates a new `DescribeHoursOfOperationError`.
    pub fn new(kind: DescribeHoursOfOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHoursOfOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHoursOfOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHoursOfOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHoursOfOperationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeHoursOfOperationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHoursOfOperationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHoursOfOperationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHoursOfOperationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHoursOfOperationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHoursOfOperationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHoursOfOperationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHoursOfOperationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHoursOfOperationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHoursOfOperationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeHoursOfOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHoursOfOperationErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeHoursOfOperationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeHoursOfOperationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeHoursOfOperationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeHoursOfOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeInstanceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeInstanceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceError {
    /// Creates a new `DescribeInstanceError`.
    pub fn new(kind: DescribeInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeInstanceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeInstanceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstanceAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceAttributeError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceAttributeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceAttributeErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceAttributeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceAttributeErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeInstanceAttributeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeInstanceAttributeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeInstanceAttributeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeInstanceAttributeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeInstanceAttributeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceAttributeError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceAttributeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceAttributeError {
    /// Creates a new `DescribeInstanceAttributeError`.
    pub fn new(kind: DescribeInstanceAttributeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceAttributeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceAttributeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceAttributeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceAttributeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceAttributeErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAttributeErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAttributeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAttributeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAttributeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAttributeErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAttributeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAttributeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceAttributeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceAttributeErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeInstanceAttributeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceAttributeErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeInstanceAttributeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeInstanceAttributeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeInstanceAttributeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeInstanceAttributeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeInstanceAttributeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstanceStorageConfigError {
    /// Kind of error that occurred.
    pub kind: DescribeInstanceStorageConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstanceStorageConfigErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstanceStorageConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstanceStorageConfigErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstanceStorageConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeInstanceStorageConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstanceStorageConfigError {
    fn code(&self) -> Option<&str> {
        DescribeInstanceStorageConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstanceStorageConfigError {
    /// Creates a new `DescribeInstanceStorageConfigError`.
    pub fn new(
        kind: DescribeInstanceStorageConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstanceStorageConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstanceStorageConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstanceStorageConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstanceStorageConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstanceStorageConfigErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceStorageConfigErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceStorageConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceStorageConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceStorageConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceStorageConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceStorageConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceStorageConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeInstanceStorageConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstanceStorageConfigErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeInstanceStorageConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstanceStorageConfigErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeInstanceStorageConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeInstanceStorageConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeQueueError {
    /// Kind of error that occurred.
    pub kind: DescribeQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeQueueErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeQueueErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeQueueErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeQueueErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeQueueErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeQueueErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeQueueError {
    fn code(&self) -> Option<&str> {
        DescribeQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeQueueError {
    /// Creates a new `DescribeQueueError`.
    pub fn new(kind: DescribeQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeQueueErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueueErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueueErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueueErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueueErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueueErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQueueErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQueueErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeQueueErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeQueueErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeQueueErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeQueueErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeQueueErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeQueueErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeQuickConnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeQuickConnectError {
    /// Kind of error that occurred.
    pub kind: DescribeQuickConnectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeQuickConnect` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeQuickConnectErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeQuickConnectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeQuickConnectErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeQuickConnectErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeQuickConnectErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeQuickConnectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeQuickConnectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeQuickConnectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeQuickConnectError {
    fn code(&self) -> Option<&str> {
        DescribeQuickConnectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeQuickConnectError {
    /// Creates a new `DescribeQuickConnectError`.
    pub fn new(kind: DescribeQuickConnectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeQuickConnectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeQuickConnectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeQuickConnectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeQuickConnectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeQuickConnectErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuickConnectErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuickConnectErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuickConnectErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuickConnectErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuickConnectErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuickConnectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuickConnectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeQuickConnectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeQuickConnectErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeQuickConnectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeQuickConnectErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeQuickConnectErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeQuickConnectErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeQuickConnectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeQuickConnectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeQuickConnectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeRoutingProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeRoutingProfileError {
    /// Kind of error that occurred.
    pub kind: DescribeRoutingProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeRoutingProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeRoutingProfileErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeRoutingProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeRoutingProfileErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeRoutingProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeRoutingProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeRoutingProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeRoutingProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeRoutingProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeRoutingProfileError {
    fn code(&self) -> Option<&str> {
        DescribeRoutingProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeRoutingProfileError {
    /// Creates a new `DescribeRoutingProfileError`.
    pub fn new(kind: DescribeRoutingProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeRoutingProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeRoutingProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeRoutingProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeRoutingProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeRoutingProfileErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingProfileErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeRoutingProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeRoutingProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeRoutingProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeRoutingProfileErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeRoutingProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeRoutingProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeRoutingProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeRoutingProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeRoutingProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: DescribeSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSecurityProfileErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSecurityProfileErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSecurityProfileError {
    fn code(&self) -> Option<&str> {
        DescribeSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSecurityProfileError {
    /// Creates a new `DescribeSecurityProfileError`.
    pub fn new(kind: DescribeSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSecurityProfileErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserError {
    /// Kind of error that occurred.
    pub kind: DescribeUserErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUser` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeUserErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserError {
    fn code(&self) -> Option<&str> {
        DescribeUserError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserError {
    /// Creates a new `DescribeUserError`.
    pub fn new(kind: DescribeUserErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeUserErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DescribeUserError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeUserErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUserErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeUserErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeUserErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserHierarchyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserHierarchyGroupError {
    /// Kind of error that occurred.
    pub kind: DescribeUserHierarchyGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserHierarchyGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserHierarchyGroupErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserHierarchyGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserHierarchyGroupErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DescribeUserHierarchyGroupErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DescribeUserHierarchyGroupErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DescribeUserHierarchyGroupErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeUserHierarchyGroupErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeUserHierarchyGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserHierarchyGroupError {
    fn code(&self) -> Option<&str> {
        DescribeUserHierarchyGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserHierarchyGroupError {
    /// Creates a new `DescribeUserHierarchyGroupError`.
    pub fn new(kind: DescribeUserHierarchyGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserHierarchyGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserHierarchyGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserHierarchyGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserHierarchyGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyGroupErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyGroupErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyGroupErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyGroupErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyGroupErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyGroupErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyGroupErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyGroupErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyGroupErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyGroupErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeUserHierarchyGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserHierarchyGroupErrorKind::InternalServiceException(_inner) => Some(_inner),
            DescribeUserHierarchyGroupErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DescribeUserHierarchyGroupErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DescribeUserHierarchyGroupErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeUserHierarchyGroupErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeUserHierarchyGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUserHierarchyStructure` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUserHierarchyStructureError {
    /// Kind of error that occurred.
    pub kind: DescribeUserHierarchyStructureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUserHierarchyStructure` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUserHierarchyStructureErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUserHierarchyStructureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUserHierarchyStructureErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DescribeUserHierarchyStructureErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DescribeUserHierarchyStructureErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DescribeUserHierarchyStructureErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeUserHierarchyStructureErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeUserHierarchyStructureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUserHierarchyStructureError {
    fn code(&self) -> Option<&str> {
        DescribeUserHierarchyStructureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUserHierarchyStructureError {
    /// Creates a new `DescribeUserHierarchyStructureError`.
    pub fn new(
        kind: DescribeUserHierarchyStructureErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUserHierarchyStructureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUserHierarchyStructureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUserHierarchyStructureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUserHierarchyStructureErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyStructureErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyStructureErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyStructureErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyStructureErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyStructureErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyStructureErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyStructureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyStructureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUserHierarchyStructureErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUserHierarchyStructureErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DescribeUserHierarchyStructureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUserHierarchyStructureErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DescribeUserHierarchyStructureErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DescribeUserHierarchyStructureErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DescribeUserHierarchyStructureErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeUserHierarchyStructureErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeUserHierarchyStructureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateApprovedOrigin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateApprovedOriginError {
    /// Kind of error that occurred.
    pub kind: DisassociateApprovedOriginErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateApprovedOrigin` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateApprovedOriginErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateApprovedOriginError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateApprovedOriginErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DisassociateApprovedOriginErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateApprovedOriginErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateApprovedOriginErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateApprovedOriginErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateApprovedOriginErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateApprovedOriginError {
    fn code(&self) -> Option<&str> {
        DisassociateApprovedOriginError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateApprovedOriginError {
    /// Creates a new `DisassociateApprovedOriginError`.
    pub fn new(kind: DisassociateApprovedOriginErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateApprovedOriginError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateApprovedOriginErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateApprovedOriginError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateApprovedOriginErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateApprovedOriginErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovedOriginErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateApprovedOriginErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovedOriginErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateApprovedOriginErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovedOriginErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateApprovedOriginErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovedOriginErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateApprovedOriginErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateApprovedOriginErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateApprovedOriginError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateApprovedOriginErrorKind::InternalServiceException(_inner) => Some(_inner),
            DisassociateApprovedOriginErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateApprovedOriginErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateApprovedOriginErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateApprovedOriginErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateApprovedOriginErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateBotError {
    /// Kind of error that occurred.
    pub kind: DisassociateBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateBotErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateBotErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DisassociateBotErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateBotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateBotError {
    fn code(&self) -> Option<&str> {
        DisassociateBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateBotError {
    /// Creates a new `DisassociateBotError`.
    pub fn new(kind: DisassociateBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateBotErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBotErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateBotErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBotErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateBotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateBotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DisassociateBotErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DisassociateBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateBotErrorKind::InternalServiceException(_inner) => Some(_inner),
            DisassociateBotErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateBotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateInstanceStorageConfigError {
    /// Kind of error that occurred.
    pub kind: DisassociateInstanceStorageConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateInstanceStorageConfigErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateInstanceStorageConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateInstanceStorageConfigErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateInstanceStorageConfigErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateInstanceStorageConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateInstanceStorageConfigError {
    fn code(&self) -> Option<&str> {
        DisassociateInstanceStorageConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateInstanceStorageConfigError {
    /// Creates a new `DisassociateInstanceStorageConfigError`.
    pub fn new(
        kind: DisassociateInstanceStorageConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateInstanceStorageConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateInstanceStorageConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateInstanceStorageConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateInstanceStorageConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateInstanceStorageConfigErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateInstanceStorageConfigErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateInstanceStorageConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateInstanceStorageConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateInstanceStorageConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateInstanceStorageConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateInstanceStorageConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateInstanceStorageConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateInstanceStorageConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateInstanceStorageConfigErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateInstanceStorageConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateInstanceStorageConfigErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DisassociateInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DisassociateInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DisassociateInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateInstanceStorageConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateInstanceStorageConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateLambdaFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateLambdaFunctionError {
    /// Kind of error that occurred.
    pub kind: DisassociateLambdaFunctionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateLambdaFunction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateLambdaFunctionErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateLambdaFunctionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateLambdaFunctionErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DisassociateLambdaFunctionErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateLambdaFunctionErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateLambdaFunctionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateLambdaFunctionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateLambdaFunctionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateLambdaFunctionError {
    fn code(&self) -> Option<&str> {
        DisassociateLambdaFunctionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateLambdaFunctionError {
    /// Creates a new `DisassociateLambdaFunctionError`.
    pub fn new(kind: DisassociateLambdaFunctionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateLambdaFunctionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateLambdaFunctionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateLambdaFunctionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateLambdaFunctionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateLambdaFunctionErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLambdaFunctionErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLambdaFunctionErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLambdaFunctionErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLambdaFunctionErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLambdaFunctionErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLambdaFunctionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLambdaFunctionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLambdaFunctionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLambdaFunctionErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateLambdaFunctionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateLambdaFunctionErrorKind::InternalServiceException(_inner) => Some(_inner),
            DisassociateLambdaFunctionErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateLambdaFunctionErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateLambdaFunctionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateLambdaFunctionErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateLambdaFunctionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateLexBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateLexBotError {
    /// Kind of error that occurred.
    pub kind: DisassociateLexBotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateLexBot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateLexBotErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateLexBotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateLexBotErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DisassociateLexBotErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateLexBotErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateLexBotErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateLexBotErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateLexBotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateLexBotError {
    fn code(&self) -> Option<&str> {
        DisassociateLexBotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateLexBotError {
    /// Creates a new `DisassociateLexBotError`.
    pub fn new(kind: DisassociateLexBotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateLexBotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateLexBotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateLexBotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateLexBotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateLexBotErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLexBotErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLexBotErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLexBotErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLexBotErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLexBotErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLexBotErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLexBotErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateLexBotErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateLexBotErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateLexBotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateLexBotErrorKind::InternalServiceException(_inner) => Some(_inner),
            DisassociateLexBotErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateLexBotErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateLexBotErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateLexBotErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateLexBotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateQueueQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateQueueQuickConnectsError {
    /// Kind of error that occurred.
    pub kind: DisassociateQueueQuickConnectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateQueueQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateQueueQuickConnectsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateQueueQuickConnectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateQueueQuickConnectsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateQueueQuickConnectsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateQueueQuickConnectsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateQueueQuickConnectsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateQueueQuickConnectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateQueueQuickConnectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateQueueQuickConnectsError {
    fn code(&self) -> Option<&str> {
        DisassociateQueueQuickConnectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateQueueQuickConnectsError {
    /// Creates a new `DisassociateQueueQuickConnectsError`.
    pub fn new(
        kind: DisassociateQueueQuickConnectsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateQueueQuickConnectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateQueueQuickConnectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateQueueQuickConnectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateQueueQuickConnectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateQueueQuickConnectsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateQueueQuickConnectsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateQueueQuickConnectsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateQueueQuickConnectsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateQueueQuickConnectsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateQueueQuickConnectsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateQueueQuickConnectsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateQueueQuickConnectsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateQueueQuickConnectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateQueueQuickConnectsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateQueueQuickConnectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateQueueQuickConnectsErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DisassociateQueueQuickConnectsErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DisassociateQueueQuickConnectsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DisassociateQueueQuickConnectsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateQueueQuickConnectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateQueueQuickConnectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateRoutingProfileQueuesError {
    /// Kind of error that occurred.
    pub kind: DisassociateRoutingProfileQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateRoutingProfileQueuesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateRoutingProfileQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateRoutingProfileQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateRoutingProfileQueuesError {
    fn code(&self) -> Option<&str> {
        DisassociateRoutingProfileQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateRoutingProfileQueuesError {
    /// Creates a new `DisassociateRoutingProfileQueuesError`.
    pub fn new(
        kind: DisassociateRoutingProfileQueuesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateRoutingProfileQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateRoutingProfileQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateRoutingProfileQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateRoutingProfileQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateRoutingProfileQueuesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRoutingProfileQueuesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRoutingProfileQueuesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRoutingProfileQueuesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRoutingProfileQueuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRoutingProfileQueuesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRoutingProfileQueuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateRoutingProfileQueuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateRoutingProfileQueuesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateRoutingProfileQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            DisassociateRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            DisassociateRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            DisassociateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateRoutingProfileQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateSecurityKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateSecurityKeyError {
    /// Kind of error that occurred.
    pub kind: DisassociateSecurityKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateSecurityKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateSecurityKeyErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateSecurityKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateSecurityKeyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            DisassociateSecurityKeyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            DisassociateSecurityKeyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DisassociateSecurityKeyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateSecurityKeyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateSecurityKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateSecurityKeyError {
    fn code(&self) -> Option<&str> {
        DisassociateSecurityKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateSecurityKeyError {
    /// Creates a new `DisassociateSecurityKeyError`.
    pub fn new(kind: DisassociateSecurityKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateSecurityKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateSecurityKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateSecurityKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateSecurityKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateSecurityKeyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSecurityKeyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSecurityKeyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSecurityKeyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSecurityKeyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSecurityKeyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSecurityKeyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSecurityKeyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateSecurityKeyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateSecurityKeyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for DisassociateSecurityKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateSecurityKeyErrorKind::InternalServiceException(_inner) => Some(_inner),
            DisassociateSecurityKeyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            DisassociateSecurityKeyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DisassociateSecurityKeyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateSecurityKeyErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateSecurityKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetContactAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetContactAttributesError {
    /// Kind of error that occurred.
    pub kind: GetContactAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetContactAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetContactAttributesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetContactAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetContactAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetContactAttributesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetContactAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetContactAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetContactAttributesError {
    fn code(&self) -> Option<&str> {
        GetContactAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetContactAttributesError {
    /// Creates a new `GetContactAttributesError`.
    pub fn new(kind: GetContactAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetContactAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetContactAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetContactAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetContactAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetContactAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactAttributesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactAttributesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetContactAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetContactAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetContactAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetContactAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetContactAttributesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetContactAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetContactAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetCurrentMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCurrentMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetCurrentMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCurrentMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCurrentMetricDataErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCurrentMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCurrentMetricDataErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetCurrentMetricDataErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetCurrentMetricDataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetCurrentMetricDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCurrentMetricDataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCurrentMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCurrentMetricDataError {
    fn code(&self) -> Option<&str> {
        GetCurrentMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCurrentMetricDataError {
    /// Creates a new `GetCurrentMetricDataError`.
    pub fn new(kind: GetCurrentMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCurrentMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCurrentMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCurrentMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCurrentMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCurrentMetricDataErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCurrentMetricDataErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCurrentMetricDataErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCurrentMetricDataErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCurrentMetricDataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCurrentMetricDataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCurrentMetricDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCurrentMetricDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCurrentMetricDataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCurrentMetricDataErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for GetCurrentMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCurrentMetricDataErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetCurrentMetricDataErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetCurrentMetricDataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetCurrentMetricDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCurrentMetricDataErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCurrentMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFederationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFederationTokenError {
    /// Kind of error that occurred.
    pub kind: GetFederationTokenErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFederationToken` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFederationTokenErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>No user with the specified credentials was found in the Amazon Connect instance.</p>
    UserNotFoundException(crate::error::UserNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFederationTokenError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFederationTokenErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::UserNotFoundException(_inner) => _inner.fmt(f),
            GetFederationTokenErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFederationTokenError {
    fn code(&self) -> Option<&str> {
        GetFederationTokenError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFederationTokenError {
    /// Creates a new `GetFederationTokenError`.
    pub fn new(kind: GetFederationTokenErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFederationTokenError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFederationTokenErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFederationTokenError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFederationTokenErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFederationTokenErrorKind::UserNotFoundException`.
    pub fn is_user_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFederationTokenErrorKind::UserNotFoundException(_)
        )
    }
}
impl std::error::Error for GetFederationTokenError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFederationTokenErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::UserNotFoundException(_inner) => Some(_inner),
            GetFederationTokenErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMetricDataError {
    /// Kind of error that occurred.
    pub kind: GetMetricDataErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMetricData` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMetricDataErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMetricDataError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMetricDataErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            GetMetricDataErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            GetMetricDataErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetMetricDataErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMetricDataErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMetricDataErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMetricDataError {
    fn code(&self) -> Option<&str> {
        GetMetricDataError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMetricDataError {
    /// Creates a new `GetMetricDataError`.
    pub fn new(kind: GetMetricDataErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMetricDataError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMetricDataErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMetricDataError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMetricDataErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMetricDataErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricDataErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricDataErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricDataErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricDataErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricDataErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricDataErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMetricDataErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMetricDataErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetMetricDataErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetMetricDataError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMetricDataErrorKind::InternalServiceException(_inner) => Some(_inner),
            GetMetricDataErrorKind::InvalidParameterException(_inner) => Some(_inner),
            GetMetricDataErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetMetricDataErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMetricDataErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMetricDataErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListAgentStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListAgentStatusesError {
    /// Kind of error that occurred.
    pub kind: ListAgentStatusesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListAgentStatuses` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListAgentStatusesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListAgentStatusesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListAgentStatusesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListAgentStatusesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListAgentStatusesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListAgentStatusesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListAgentStatusesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListAgentStatusesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListAgentStatusesError {
    fn code(&self) -> Option<&str> {
        ListAgentStatusesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListAgentStatusesError {
    /// Creates a new `ListAgentStatusesError`.
    pub fn new(kind: ListAgentStatusesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListAgentStatusesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListAgentStatusesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListAgentStatusesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListAgentStatusesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListAgentStatusesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAgentStatusesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAgentStatusesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAgentStatusesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAgentStatusesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAgentStatusesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAgentStatusesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAgentStatusesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListAgentStatusesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListAgentStatusesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListAgentStatusesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListAgentStatusesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListAgentStatusesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListAgentStatusesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListAgentStatusesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListAgentStatusesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListAgentStatusesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListApprovedOrigins` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListApprovedOriginsError {
    /// Kind of error that occurred.
    pub kind: ListApprovedOriginsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListApprovedOrigins` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListApprovedOriginsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListApprovedOriginsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListApprovedOriginsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListApprovedOriginsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListApprovedOriginsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListApprovedOriginsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListApprovedOriginsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListApprovedOriginsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListApprovedOriginsError {
    fn code(&self) -> Option<&str> {
        ListApprovedOriginsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListApprovedOriginsError {
    /// Creates a new `ListApprovedOriginsError`.
    pub fn new(kind: ListApprovedOriginsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListApprovedOriginsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListApprovedOriginsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListApprovedOriginsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListApprovedOriginsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListApprovedOriginsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApprovedOriginsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApprovedOriginsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApprovedOriginsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApprovedOriginsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApprovedOriginsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApprovedOriginsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApprovedOriginsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListApprovedOriginsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListApprovedOriginsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListApprovedOriginsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListApprovedOriginsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListApprovedOriginsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListApprovedOriginsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListApprovedOriginsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListApprovedOriginsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListApprovedOriginsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListBotsError {
    /// Kind of error that occurred.
    pub kind: ListBotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListBotsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListBotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListBotsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListBotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListBotsError {
    fn code(&self) -> Option<&str> {
        ListBotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListBotsError {
    /// Creates a new `ListBotsError`.
    pub fn new(kind: ListBotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListBotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListBotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListBotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListBotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListBotsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListBotsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListBotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListBotsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListBotsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListBotsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListBotsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListBotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContactFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContactFlowsError {
    /// Kind of error that occurred.
    pub kind: ListContactFlowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContactFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContactFlowsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContactFlowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContactFlowsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListContactFlowsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListContactFlowsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListContactFlowsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListContactFlowsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListContactFlowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContactFlowsError {
    fn code(&self) -> Option<&str> {
        ListContactFlowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContactFlowsError {
    /// Creates a new `ListContactFlowsError`.
    pub fn new(kind: ListContactFlowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContactFlowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContactFlowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContactFlowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContactFlowsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListContactFlowsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactFlowsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactFlowsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactFlowsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactFlowsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactFlowsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactFlowsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactFlowsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactFlowsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactFlowsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListContactFlowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContactFlowsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListContactFlowsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListContactFlowsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListContactFlowsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListContactFlowsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListContactFlowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListContactReferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListContactReferencesError {
    /// Kind of error that occurred.
    pub kind: ListContactReferencesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListContactReferences` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListContactReferencesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListContactReferencesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListContactReferencesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListContactReferencesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListContactReferencesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListContactReferencesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListContactReferencesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListContactReferencesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListContactReferencesError {
    fn code(&self) -> Option<&str> {
        ListContactReferencesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListContactReferencesError {
    /// Creates a new `ListContactReferencesError`.
    pub fn new(kind: ListContactReferencesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListContactReferencesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListContactReferencesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListContactReferencesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListContactReferencesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListContactReferencesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactReferencesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactReferencesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactReferencesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactReferencesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactReferencesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactReferencesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactReferencesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListContactReferencesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListContactReferencesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListContactReferencesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListContactReferencesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListContactReferencesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListContactReferencesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListContactReferencesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListContactReferencesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListContactReferencesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListHoursOfOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListHoursOfOperationsError {
    /// Kind of error that occurred.
    pub kind: ListHoursOfOperationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListHoursOfOperations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListHoursOfOperationsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListHoursOfOperationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListHoursOfOperationsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListHoursOfOperationsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListHoursOfOperationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListHoursOfOperationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListHoursOfOperationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListHoursOfOperationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListHoursOfOperationsError {
    fn code(&self) -> Option<&str> {
        ListHoursOfOperationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListHoursOfOperationsError {
    /// Creates a new `ListHoursOfOperationsError`.
    pub fn new(kind: ListHoursOfOperationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListHoursOfOperationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListHoursOfOperationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListHoursOfOperationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListHoursOfOperationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListHoursOfOperationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHoursOfOperationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHoursOfOperationsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHoursOfOperationsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHoursOfOperationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHoursOfOperationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHoursOfOperationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHoursOfOperationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListHoursOfOperationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListHoursOfOperationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListHoursOfOperationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListHoursOfOperationsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListHoursOfOperationsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListHoursOfOperationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListHoursOfOperationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListHoursOfOperationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListHoursOfOperationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceAttributesError {
    /// Kind of error that occurred.
    pub kind: ListInstanceAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceAttributesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListInstanceAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListInstanceAttributesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListInstanceAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListInstanceAttributesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListInstanceAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceAttributesError {
    fn code(&self) -> Option<&str> {
        ListInstanceAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceAttributesError {
    /// Creates a new `ListInstanceAttributesError`.
    pub fn new(kind: ListInstanceAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstanceAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceAttributesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceAttributesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceAttributesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceAttributesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListInstanceAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListInstanceAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListInstanceAttributesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListInstanceAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListInstanceAttributesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListInstanceAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstancesError {
    /// Kind of error that occurred.
    pub kind: ListInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstancesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstancesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstancesError {
    fn code(&self) -> Option<&str> {
        ListInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstancesError {
    /// Creates a new `ListInstancesError`.
    pub fn new(kind: ListInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstancesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstancesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstancesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstancesErrorKind::InvalidRequestException(_)
        )
    }
}
impl std::error::Error for ListInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstancesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListInstancesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInstanceStorageConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInstanceStorageConfigsError {
    /// Kind of error that occurred.
    pub kind: ListInstanceStorageConfigsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInstanceStorageConfigs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInstanceStorageConfigsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInstanceStorageConfigsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInstanceStorageConfigsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListInstanceStorageConfigsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListInstanceStorageConfigsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListInstanceStorageConfigsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListInstanceStorageConfigsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListInstanceStorageConfigsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInstanceStorageConfigsError {
    fn code(&self) -> Option<&str> {
        ListInstanceStorageConfigsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInstanceStorageConfigsError {
    /// Creates a new `ListInstanceStorageConfigsError`.
    pub fn new(kind: ListInstanceStorageConfigsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInstanceStorageConfigsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInstanceStorageConfigsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInstanceStorageConfigsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInstanceStorageConfigsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInstanceStorageConfigsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceStorageConfigsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceStorageConfigsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceStorageConfigsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceStorageConfigsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceStorageConfigsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceStorageConfigsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceStorageConfigsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInstanceStorageConfigsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInstanceStorageConfigsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListInstanceStorageConfigsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInstanceStorageConfigsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListInstanceStorageConfigsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListInstanceStorageConfigsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListInstanceStorageConfigsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListInstanceStorageConfigsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListInstanceStorageConfigsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListIntegrationAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListIntegrationAssociationsError {
    /// Kind of error that occurred.
    pub kind: ListIntegrationAssociationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListIntegrationAssociations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListIntegrationAssociationsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListIntegrationAssociationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListIntegrationAssociationsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListIntegrationAssociationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListIntegrationAssociationsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListIntegrationAssociationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListIntegrationAssociationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListIntegrationAssociationsError {
    fn code(&self) -> Option<&str> {
        ListIntegrationAssociationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListIntegrationAssociationsError {
    /// Creates a new `ListIntegrationAssociationsError`.
    pub fn new(kind: ListIntegrationAssociationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListIntegrationAssociationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListIntegrationAssociationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListIntegrationAssociationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListIntegrationAssociationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListIntegrationAssociationsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationAssociationsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIntegrationAssociationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationAssociationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIntegrationAssociationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationAssociationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListIntegrationAssociationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListIntegrationAssociationsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListIntegrationAssociationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListIntegrationAssociationsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListIntegrationAssociationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListIntegrationAssociationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListIntegrationAssociationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListIntegrationAssociationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLambdaFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLambdaFunctionsError {
    /// Kind of error that occurred.
    pub kind: ListLambdaFunctionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLambdaFunctions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLambdaFunctionsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLambdaFunctionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLambdaFunctionsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListLambdaFunctionsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListLambdaFunctionsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListLambdaFunctionsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLambdaFunctionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLambdaFunctionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLambdaFunctionsError {
    fn code(&self) -> Option<&str> {
        ListLambdaFunctionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLambdaFunctionsError {
    /// Creates a new `ListLambdaFunctionsError`.
    pub fn new(kind: ListLambdaFunctionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLambdaFunctionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLambdaFunctionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLambdaFunctionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLambdaFunctionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLambdaFunctionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLambdaFunctionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLambdaFunctionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLambdaFunctionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLambdaFunctionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLambdaFunctionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLambdaFunctionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLambdaFunctionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLambdaFunctionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLambdaFunctionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListLambdaFunctionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLambdaFunctionsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListLambdaFunctionsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListLambdaFunctionsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListLambdaFunctionsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLambdaFunctionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLambdaFunctionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListLexBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListLexBotsError {
    /// Kind of error that occurred.
    pub kind: ListLexBotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListLexBots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListLexBotsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListLexBotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListLexBotsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListLexBotsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListLexBotsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListLexBotsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListLexBotsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListLexBotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListLexBotsError {
    fn code(&self) -> Option<&str> {
        ListLexBotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListLexBotsError {
    /// Creates a new `ListLexBotsError`.
    pub fn new(kind: ListLexBotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListLexBotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListLexBotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListLexBotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListLexBotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListLexBotsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLexBotsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLexBotsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLexBotsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLexBotsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListLexBotsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListLexBotsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListLexBotsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListLexBotsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListLexBotsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListLexBotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListLexBotsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListLexBotsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListLexBotsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListLexBotsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListLexBotsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListLexBotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPhoneNumbersError {
    /// Kind of error that occurred.
    pub kind: ListPhoneNumbersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPhoneNumbers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPhoneNumbersErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPhoneNumbersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPhoneNumbersErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPhoneNumbersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPhoneNumbersError {
    fn code(&self) -> Option<&str> {
        ListPhoneNumbersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPhoneNumbersError {
    /// Creates a new `ListPhoneNumbersError`.
    pub fn new(kind: ListPhoneNumbersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPhoneNumbersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPhoneNumbersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPhoneNumbersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPhoneNumbersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPhoneNumbersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPhoneNumbersErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListPhoneNumbersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPhoneNumbersErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPhoneNumbersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPrompts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPromptsError {
    /// Kind of error that occurred.
    pub kind: ListPromptsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPrompts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPromptsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPromptsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPromptsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListPromptsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListPromptsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListPromptsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListPromptsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListPromptsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPromptsError {
    fn code(&self) -> Option<&str> {
        ListPromptsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPromptsError {
    /// Creates a new `ListPromptsError`.
    pub fn new(kind: ListPromptsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPromptsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPromptsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPromptsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPromptsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPromptsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPromptsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPromptsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPromptsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPromptsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListPromptsErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListPromptsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPromptsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPromptsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListPromptsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListPromptsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPromptsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListPromptsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListPromptsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListPromptsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListPromptsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListPromptsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueueQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueueQuickConnectsError {
    /// Kind of error that occurred.
    pub kind: ListQueueQuickConnectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueueQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueueQuickConnectsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueueQuickConnectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueueQuickConnectsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListQueueQuickConnectsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListQueueQuickConnectsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListQueueQuickConnectsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListQueueQuickConnectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListQueueQuickConnectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueueQuickConnectsError {
    fn code(&self) -> Option<&str> {
        ListQueueQuickConnectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueueQuickConnectsError {
    /// Creates a new `ListQueueQuickConnectsError`.
    pub fn new(kind: ListQueueQuickConnectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueueQuickConnectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueueQuickConnectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueueQuickConnectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueueQuickConnectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQueueQuickConnectsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueueQuickConnectsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueueQuickConnectsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueueQuickConnectsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueueQuickConnectsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueueQuickConnectsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueueQuickConnectsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueueQuickConnectsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueueQuickConnectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueueQuickConnectsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListQueueQuickConnectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueueQuickConnectsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListQueueQuickConnectsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListQueueQuickConnectsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListQueueQuickConnectsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListQueueQuickConnectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListQueueQuickConnectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueuesError {
    /// Kind of error that occurred.
    pub kind: ListQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueuesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueuesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueuesError {
    fn code(&self) -> Option<&str> {
        ListQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueuesError {
    /// Creates a new `ListQueuesError`.
    pub fn new(kind: ListQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueuesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListQueuesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListQueuesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListQueuesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListQueuesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQuickConnectsError {
    /// Kind of error that occurred.
    pub kind: ListQuickConnectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQuickConnects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQuickConnectsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQuickConnectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQuickConnectsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListQuickConnectsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListQuickConnectsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListQuickConnectsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListQuickConnectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListQuickConnectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQuickConnectsError {
    fn code(&self) -> Option<&str> {
        ListQuickConnectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQuickConnectsError {
    /// Creates a new `ListQuickConnectsError`.
    pub fn new(kind: ListQuickConnectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQuickConnectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQuickConnectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQuickConnectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQuickConnectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQuickConnectsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuickConnectsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuickConnectsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuickConnectsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuickConnectsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuickConnectsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuickConnectsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuickConnectsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQuickConnectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQuickConnectsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListQuickConnectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQuickConnectsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListQuickConnectsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListQuickConnectsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListQuickConnectsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListQuickConnectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListQuickConnectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoutingProfileQueuesError {
    /// Kind of error that occurred.
    pub kind: ListRoutingProfileQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoutingProfileQueuesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoutingProfileQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRoutingProfileQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoutingProfileQueuesError {
    fn code(&self) -> Option<&str> {
        ListRoutingProfileQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoutingProfileQueuesError {
    /// Creates a new `ListRoutingProfileQueuesError`.
    pub fn new(kind: ListRoutingProfileQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoutingProfileQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoutingProfileQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoutingProfileQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoutingProfileQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoutingProfileQueuesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfileQueuesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfileQueuesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfileQueuesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfileQueuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfileQueuesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfileQueuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfileQueuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfileQueuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfileQueuesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListRoutingProfileQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRoutingProfileQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListRoutingProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListRoutingProfilesError {
    /// Kind of error that occurred.
    pub kind: ListRoutingProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListRoutingProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListRoutingProfilesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListRoutingProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListRoutingProfilesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListRoutingProfilesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListRoutingProfilesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListRoutingProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListRoutingProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListRoutingProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListRoutingProfilesError {
    fn code(&self) -> Option<&str> {
        ListRoutingProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListRoutingProfilesError {
    /// Creates a new `ListRoutingProfilesError`.
    pub fn new(kind: ListRoutingProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListRoutingProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListRoutingProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListRoutingProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListRoutingProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListRoutingProfilesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfilesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfilesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfilesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfilesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfilesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListRoutingProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListRoutingProfilesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListRoutingProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListRoutingProfilesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListRoutingProfilesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListRoutingProfilesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListRoutingProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListRoutingProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListRoutingProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSecurityKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSecurityKeysError {
    /// Kind of error that occurred.
    pub kind: ListSecurityKeysErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSecurityKeys` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSecurityKeysErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSecurityKeysError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSecurityKeysErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListSecurityKeysErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListSecurityKeysErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListSecurityKeysErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSecurityKeysErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSecurityKeysErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSecurityKeysError {
    fn code(&self) -> Option<&str> {
        ListSecurityKeysError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSecurityKeysError {
    /// Creates a new `ListSecurityKeysError`.
    pub fn new(kind: ListSecurityKeysErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSecurityKeysError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSecurityKeysErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSecurityKeysError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSecurityKeysErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSecurityKeysErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityKeysErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityKeysErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityKeysErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityKeysErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityKeysErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityKeysErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityKeysErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityKeysErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityKeysErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListSecurityKeysError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSecurityKeysErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListSecurityKeysErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListSecurityKeysErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListSecurityKeysErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSecurityKeysErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSecurityKeysErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSecurityProfilePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSecurityProfilePermissionsError {
    /// Kind of error that occurred.
    pub kind: ListSecurityProfilePermissionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSecurityProfilePermissions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSecurityProfilePermissionsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSecurityProfilePermissionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSecurityProfilePermissionsErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            ListSecurityProfilePermissionsErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            ListSecurityProfilePermissionsErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            ListSecurityProfilePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListSecurityProfilePermissionsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSecurityProfilePermissionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSecurityProfilePermissionsError {
    fn code(&self) -> Option<&str> {
        ListSecurityProfilePermissionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSecurityProfilePermissionsError {
    /// Creates a new `ListSecurityProfilePermissionsError`.
    pub fn new(
        kind: ListSecurityProfilePermissionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSecurityProfilePermissionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSecurityProfilePermissionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSecurityProfilePermissionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSecurityProfilePermissionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSecurityProfilePermissionsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilePermissionsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilePermissionsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilePermissionsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilePermissionsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilePermissionsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilePermissionsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilePermissionsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilePermissionsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilePermissionsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListSecurityProfilePermissionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSecurityProfilePermissionsErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            ListSecurityProfilePermissionsErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            ListSecurityProfilePermissionsErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            ListSecurityProfilePermissionsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListSecurityProfilePermissionsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSecurityProfilePermissionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListSecurityProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListSecurityProfilesError {
    /// Kind of error that occurred.
    pub kind: ListSecurityProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListSecurityProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListSecurityProfilesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListSecurityProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListSecurityProfilesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListSecurityProfilesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListSecurityProfilesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListSecurityProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListSecurityProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListSecurityProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListSecurityProfilesError {
    fn code(&self) -> Option<&str> {
        ListSecurityProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListSecurityProfilesError {
    /// Creates a new `ListSecurityProfilesError`.
    pub fn new(kind: ListSecurityProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListSecurityProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListSecurityProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListSecurityProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListSecurityProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListSecurityProfilesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListSecurityProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListSecurityProfilesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListSecurityProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListSecurityProfilesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListSecurityProfilesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListSecurityProfilesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListSecurityProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListSecurityProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListSecurityProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUseCases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUseCasesError {
    /// Kind of error that occurred.
    pub kind: ListUseCasesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUseCases` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUseCasesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUseCasesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUseCasesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListUseCasesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListUseCasesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUseCasesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUseCasesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUseCasesError {
    fn code(&self) -> Option<&str> {
        ListUseCasesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUseCasesError {
    /// Creates a new `ListUseCasesError`.
    pub fn new(kind: ListUseCasesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUseCasesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUseCasesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUseCasesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUseCasesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUseCasesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUseCasesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUseCasesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUseCasesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUseCasesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUseCasesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUseCasesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListUseCasesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListUseCasesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUseCasesErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListUseCasesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListUseCasesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUseCasesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUseCasesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUserHierarchyGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUserHierarchyGroupsError {
    /// Kind of error that occurred.
    pub kind: ListUserHierarchyGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUserHierarchyGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUserHierarchyGroupsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUserHierarchyGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUserHierarchyGroupsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListUserHierarchyGroupsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUserHierarchyGroupsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListUserHierarchyGroupsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUserHierarchyGroupsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUserHierarchyGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUserHierarchyGroupsError {
    fn code(&self) -> Option<&str> {
        ListUserHierarchyGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUserHierarchyGroupsError {
    /// Creates a new `ListUserHierarchyGroupsError`.
    pub fn new(kind: ListUserHierarchyGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUserHierarchyGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUserHierarchyGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUserHierarchyGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUserHierarchyGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUserHierarchyGroupsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserHierarchyGroupsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserHierarchyGroupsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserHierarchyGroupsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserHierarchyGroupsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserHierarchyGroupsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserHierarchyGroupsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserHierarchyGroupsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListUserHierarchyGroupsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListUserHierarchyGroupsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListUserHierarchyGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUserHierarchyGroupsErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListUserHierarchyGroupsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUserHierarchyGroupsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListUserHierarchyGroupsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUserHierarchyGroupsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUserHierarchyGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListUsersError {
    /// Kind of error that occurred.
    pub kind: ListUsersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListUsers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListUsersErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListUsersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListUsersErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListUsersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListUsersError {
    fn code(&self) -> Option<&str> {
        ListUsersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListUsersError {
    /// Creates a new `ListUsersError`.
    pub fn new(kind: ListUsersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListUsersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListUsersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListUsersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListUsersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InternalServiceException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InvalidParameterException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListUsersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListUsersErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListUsersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListUsersErrorKind::InternalServiceException(_inner) => Some(_inner),
            ListUsersErrorKind::InvalidParameterException(_inner) => Some(_inner),
            ListUsersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListUsersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListUsersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListUsersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResumeContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResumeContactRecordingError {
    /// Kind of error that occurred.
    pub kind: ResumeContactRecordingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResumeContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResumeContactRecordingErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResumeContactRecordingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResumeContactRecordingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            ResumeContactRecordingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ResumeContactRecordingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ResumeContactRecordingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResumeContactRecordingError {
    fn code(&self) -> Option<&str> {
        ResumeContactRecordingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResumeContactRecordingError {
    /// Creates a new `ResumeContactRecordingError`.
    pub fn new(kind: ResumeContactRecordingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResumeContactRecordingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResumeContactRecordingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResumeContactRecordingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResumeContactRecordingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResumeContactRecordingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeContactRecordingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeContactRecordingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeContactRecordingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeContactRecordingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ResumeContactRecordingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for ResumeContactRecordingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResumeContactRecordingErrorKind::InternalServiceException(_inner) => Some(_inner),
            ResumeContactRecordingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ResumeContactRecordingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ResumeContactRecordingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartChatContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartChatContactError {
    /// Kind of error that occurred.
    pub kind: StartChatContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartChatContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartChatContactErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartChatContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartChatContactErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartChatContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartChatContactErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartChatContactErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartChatContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartChatContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartChatContactError {
    fn code(&self) -> Option<&str> {
        StartChatContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartChatContactError {
    /// Creates a new `StartChatContactError`.
    pub fn new(kind: StartChatContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartChatContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartChatContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartChatContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartChatContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartChatContactErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChatContactErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChatContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChatContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChatContactErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChatContactErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChatContactErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChatContactErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartChatContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartChatContactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartChatContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartChatContactErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartChatContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartChatContactErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartChatContactErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartChatContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartChatContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartContactRecordingError {
    /// Kind of error that occurred.
    pub kind: StartContactRecordingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartContactRecordingErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartContactRecordingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartContactRecordingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartContactRecordingErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartContactRecordingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartContactRecordingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartContactRecordingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartContactRecordingError {
    fn code(&self) -> Option<&str> {
        StartContactRecordingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartContactRecordingError {
    /// Creates a new `StartContactRecordingError`.
    pub fn new(kind: StartContactRecordingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartContactRecordingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartContactRecordingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartContactRecordingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartContactRecordingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartContactRecordingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactRecordingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartContactRecordingErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactRecordingErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartContactRecordingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactRecordingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartContactRecordingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactRecordingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartContactRecordingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartContactRecordingErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartContactRecordingErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartContactRecordingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartContactRecordingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartContactRecordingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartContactStreaming` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartContactStreamingError {
    /// Kind of error that occurred.
    pub kind: StartContactStreamingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartContactStreaming` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartContactStreamingErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartContactStreamingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartContactStreamingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartContactStreamingErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartContactStreamingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartContactStreamingErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartContactStreamingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartContactStreamingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartContactStreamingError {
    fn code(&self) -> Option<&str> {
        StartContactStreamingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartContactStreamingError {
    /// Creates a new `StartContactStreamingError`.
    pub fn new(kind: StartContactStreamingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartContactStreamingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartContactStreamingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartContactStreamingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartContactStreamingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartContactStreamingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactStreamingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartContactStreamingErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactStreamingErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartContactStreamingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactStreamingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartContactStreamingErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactStreamingErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartContactStreamingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartContactStreamingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartContactStreamingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartContactStreamingErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartContactStreamingErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartContactStreamingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartContactStreamingErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartContactStreamingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartContactStreamingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartOutboundVoiceContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartOutboundVoiceContactError {
    /// Kind of error that occurred.
    pub kind: StartOutboundVoiceContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartOutboundVoiceContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartOutboundVoiceContactErrorKind {
    /// <p>Outbound calls to the destination number are not allowed.</p>
    DestinationNotAllowedException(crate::error::DestinationNotAllowedException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The contact is not permitted.</p>
    OutboundContactNotPermittedException(crate::error::OutboundContactNotPermittedException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartOutboundVoiceContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartOutboundVoiceContactErrorKind::DestinationNotAllowedException(_inner) => {
                _inner.fmt(f)
            }
            StartOutboundVoiceContactErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartOutboundVoiceContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartOutboundVoiceContactErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartOutboundVoiceContactErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            StartOutboundVoiceContactErrorKind::OutboundContactNotPermittedException(_inner) => {
                _inner.fmt(f)
            }
            StartOutboundVoiceContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartOutboundVoiceContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartOutboundVoiceContactError {
    fn code(&self) -> Option<&str> {
        StartOutboundVoiceContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartOutboundVoiceContactError {
    /// Creates a new `StartOutboundVoiceContactError`.
    pub fn new(kind: StartOutboundVoiceContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartOutboundVoiceContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartOutboundVoiceContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartOutboundVoiceContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartOutboundVoiceContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartOutboundVoiceContactErrorKind::DestinationNotAllowedException`.
    pub fn is_destination_not_allowed_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOutboundVoiceContactErrorKind::DestinationNotAllowedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartOutboundVoiceContactErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOutboundVoiceContactErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartOutboundVoiceContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOutboundVoiceContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartOutboundVoiceContactErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOutboundVoiceContactErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartOutboundVoiceContactErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOutboundVoiceContactErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartOutboundVoiceContactErrorKind::OutboundContactNotPermittedException`.
    pub fn is_outbound_contact_not_permitted_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOutboundVoiceContactErrorKind::OutboundContactNotPermittedException(_)
        )
    }
    /// Returns `true` if the error kind is `StartOutboundVoiceContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartOutboundVoiceContactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StartOutboundVoiceContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartOutboundVoiceContactErrorKind::DestinationNotAllowedException(_inner) => {
                Some(_inner)
            }
            StartOutboundVoiceContactErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartOutboundVoiceContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartOutboundVoiceContactErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartOutboundVoiceContactErrorKind::LimitExceededException(_inner) => Some(_inner),
            StartOutboundVoiceContactErrorKind::OutboundContactNotPermittedException(_inner) => {
                Some(_inner)
            }
            StartOutboundVoiceContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartOutboundVoiceContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartTaskContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartTaskContactError {
    /// Kind of error that occurred.
    pub kind: StartTaskContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartTaskContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartTaskContactErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The service quota has been exceeded.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartTaskContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartTaskContactErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StartTaskContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StartTaskContactErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StartTaskContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartTaskContactErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartTaskContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartTaskContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartTaskContactError {
    fn code(&self) -> Option<&str> {
        StartTaskContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartTaskContactError {
    /// Creates a new `StartTaskContactError`.
    pub fn new(kind: StartTaskContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartTaskContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartTaskContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartTaskContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartTaskContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartTaskContactErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskContactErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTaskContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTaskContactErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskContactErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTaskContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskContactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTaskContactErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskContactErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `StartTaskContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartTaskContactErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for StartTaskContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartTaskContactErrorKind::InternalServiceException(_inner) => Some(_inner),
            StartTaskContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StartTaskContactErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StartTaskContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartTaskContactErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartTaskContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartTaskContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopContactError {
    /// Kind of error that occurred.
    pub kind: StopContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopContactErrorKind {
    /// <p>The contact with the specified ID is not active or does not exist.</p>
    ContactNotFoundException(crate::error::ContactNotFoundException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopContactErrorKind::ContactNotFoundException(_inner) => _inner.fmt(f),
            StopContactErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StopContactErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopContactError {
    fn code(&self) -> Option<&str> {
        StopContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopContactError {
    /// Creates a new `StopContactError`.
    pub fn new(kind: StopContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopContactErrorKind::ContactNotFoundException`.
    pub fn is_contact_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactErrorKind::ContactNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, StopContactErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `StopContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopContactErrorKind::ContactNotFoundException(_inner) => Some(_inner),
            StopContactErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StopContactErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopContactRecordingError {
    /// Kind of error that occurred.
    pub kind: StopContactRecordingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopContactRecordingErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopContactRecordingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopContactRecordingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopContactRecordingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopContactRecordingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopContactRecordingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopContactRecordingError {
    fn code(&self) -> Option<&str> {
        StopContactRecordingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopContactRecordingError {
    /// Creates a new `StopContactRecordingError`.
    pub fn new(kind: StopContactRecordingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopContactRecordingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopContactRecordingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopContactRecordingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopContactRecordingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopContactRecordingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactRecordingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactRecordingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactRecordingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactRecordingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactRecordingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopContactRecordingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopContactRecordingErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopContactRecordingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopContactRecordingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopContactRecordingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopContactStreaming` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopContactStreamingError {
    /// Kind of error that occurred.
    pub kind: StopContactStreamingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopContactStreaming` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopContactStreamingErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopContactStreamingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopContactStreamingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            StopContactStreamingErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            StopContactStreamingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            StopContactStreamingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopContactStreamingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopContactStreamingError {
    fn code(&self) -> Option<&str> {
        StopContactStreamingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopContactStreamingError {
    /// Creates a new `StopContactStreamingError`.
    pub fn new(kind: StopContactStreamingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopContactStreamingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopContactStreamingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopContactStreamingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopContactStreamingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopContactStreamingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactStreamingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactStreamingErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactStreamingErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactStreamingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactStreamingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `StopContactStreamingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopContactStreamingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for StopContactStreamingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopContactStreamingErrorKind::InternalServiceException(_inner) => Some(_inner),
            StopContactStreamingErrorKind::InvalidParameterException(_inner) => Some(_inner),
            StopContactStreamingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            StopContactStreamingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopContactStreamingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `SuspendContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SuspendContactRecordingError {
    /// Kind of error that occurred.
    pub kind: SuspendContactRecordingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SuspendContactRecording` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SuspendContactRecordingErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SuspendContactRecordingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SuspendContactRecordingErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            SuspendContactRecordingErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            SuspendContactRecordingErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SuspendContactRecordingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SuspendContactRecordingError {
    fn code(&self) -> Option<&str> {
        SuspendContactRecordingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SuspendContactRecordingError {
    /// Creates a new `SuspendContactRecordingError`.
    pub fn new(kind: SuspendContactRecordingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SuspendContactRecordingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SuspendContactRecordingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SuspendContactRecordingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SuspendContactRecordingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SuspendContactRecordingErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            SuspendContactRecordingErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `SuspendContactRecordingErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            SuspendContactRecordingErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `SuspendContactRecordingErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SuspendContactRecordingErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for SuspendContactRecordingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SuspendContactRecordingErrorKind::InternalServiceException(_inner) => Some(_inner),
            SuspendContactRecordingErrorKind::InvalidRequestException(_inner) => Some(_inner),
            SuspendContactRecordingErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SuspendContactRecordingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateAgentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateAgentStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateAgentStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateAgentStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateAgentStatusErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateAgentStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateAgentStatusErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            UpdateAgentStatusErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateAgentStatusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateAgentStatusErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateAgentStatusErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateAgentStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateAgentStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateAgentStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateAgentStatusError {
    fn code(&self) -> Option<&str> {
        UpdateAgentStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateAgentStatusError {
    /// Creates a new `UpdateAgentStatusError`.
    pub fn new(kind: UpdateAgentStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateAgentStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateAgentStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateAgentStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateAgentStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateAgentStatusErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAgentStatusErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAgentStatusErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAgentStatusErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAgentStatusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAgentStatusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAgentStatusErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAgentStatusErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAgentStatusErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAgentStatusErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAgentStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAgentStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateAgentStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateAgentStatusErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateAgentStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateAgentStatusErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            UpdateAgentStatusErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateAgentStatusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateAgentStatusErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateAgentStatusErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateAgentStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateAgentStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateAgentStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactError {
    /// Kind of error that occurred.
    pub kind: UpdateContactErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContact` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateContactErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactError {
    fn code(&self) -> Option<&str> {
        UpdateContactError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactError {
    /// Creates a new `UpdateContactError`.
    pub fn new(kind: UpdateContactErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateContactErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateContactError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateContactErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateContactErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateContactErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContactErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateContactErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContactAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactAttributesError {
    /// Kind of error that occurred.
    pub kind: UpdateContactAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContactAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactAttributesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactAttributesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateContactAttributesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateContactAttributesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateContactAttributesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContactAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactAttributesError {
    fn code(&self) -> Option<&str> {
        UpdateContactAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactAttributesError {
    /// Creates a new `UpdateContactAttributesError`.
    pub fn new(kind: UpdateContactAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContactAttributesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactAttributesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactAttributesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactAttributesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactAttributesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactAttributesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactAttributesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactAttributesErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateContactAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactAttributesErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateContactAttributesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateContactAttributesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateContactAttributesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContactAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContactFlowContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactFlowContentError {
    /// Kind of error that occurred.
    pub kind: UpdateContactFlowContentErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContactFlowContent` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactFlowContentErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>The contact flow is not valid.</p>
    InvalidContactFlowException(crate::error::InvalidContactFlowException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactFlowContentError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactFlowContentErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateContactFlowContentErrorKind::InvalidContactFlowException(_inner) => _inner.fmt(f),
            UpdateContactFlowContentErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateContactFlowContentErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateContactFlowContentErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContactFlowContentErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateContactFlowContentErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactFlowContentError {
    fn code(&self) -> Option<&str> {
        UpdateContactFlowContentError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactFlowContentError {
    /// Creates a new `UpdateContactFlowContentError`.
    pub fn new(kind: UpdateContactFlowContentErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactFlowContentError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactFlowContentErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactFlowContentError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactFlowContentErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContactFlowContentErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowContentErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowContentErrorKind::InvalidContactFlowException`.
    pub fn is_invalid_contact_flow_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowContentErrorKind::InvalidContactFlowException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowContentErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowContentErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowContentErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowContentErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowContentErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowContentErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowContentErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowContentErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateContactFlowContentError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactFlowContentErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateContactFlowContentErrorKind::InvalidContactFlowException(_inner) => Some(_inner),
            UpdateContactFlowContentErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateContactFlowContentErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateContactFlowContentErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContactFlowContentErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateContactFlowContentErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContactFlowName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactFlowNameError {
    /// Kind of error that occurred.
    pub kind: UpdateContactFlowNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContactFlowName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactFlowNameErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactFlowNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactFlowNameErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            UpdateContactFlowNameErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateContactFlowNameErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateContactFlowNameErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateContactFlowNameErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContactFlowNameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateContactFlowNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactFlowNameError {
    fn code(&self) -> Option<&str> {
        UpdateContactFlowNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactFlowNameError {
    /// Creates a new `UpdateContactFlowNameError`.
    pub fn new(kind: UpdateContactFlowNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactFlowNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactFlowNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactFlowNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactFlowNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContactFlowNameErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowNameErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowNameErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowNameErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowNameErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowNameErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowNameErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowNameErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowNameErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowNameErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactFlowNameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactFlowNameErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateContactFlowNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactFlowNameErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            UpdateContactFlowNameErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateContactFlowNameErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateContactFlowNameErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateContactFlowNameErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContactFlowNameErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateContactFlowNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateContactSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateContactScheduleError {
    /// Kind of error that occurred.
    pub kind: UpdateContactScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateContactSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateContactScheduleErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The allowed limit for the resource has been exceeded.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateContactScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateContactScheduleErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateContactScheduleErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateContactScheduleErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateContactScheduleErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            UpdateContactScheduleErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateContactScheduleErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateContactScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateContactScheduleError {
    fn code(&self) -> Option<&str> {
        UpdateContactScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateContactScheduleError {
    /// Creates a new `UpdateContactScheduleError`.
    pub fn new(kind: UpdateContactScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateContactScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateContactScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateContactScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateContactScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateContactScheduleErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactScheduleErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactScheduleErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactScheduleErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactScheduleErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactScheduleErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactScheduleErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactScheduleErrorKind::LimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactScheduleErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactScheduleErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateContactScheduleErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateContactScheduleErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateContactScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateContactScheduleErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateContactScheduleErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateContactScheduleErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateContactScheduleErrorKind::LimitExceededException(_inner) => Some(_inner),
            UpdateContactScheduleErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateContactScheduleErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateContactScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateHoursOfOperationError {
    /// Kind of error that occurred.
    pub kind: UpdateHoursOfOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateHoursOfOperationErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateHoursOfOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateHoursOfOperationErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            UpdateHoursOfOperationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateHoursOfOperationErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateHoursOfOperationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateHoursOfOperationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateHoursOfOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateHoursOfOperationError {
    fn code(&self) -> Option<&str> {
        UpdateHoursOfOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateHoursOfOperationError {
    /// Creates a new `UpdateHoursOfOperationError`.
    pub fn new(kind: UpdateHoursOfOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateHoursOfOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateHoursOfOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateHoursOfOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateHoursOfOperationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateHoursOfOperationErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHoursOfOperationErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHoursOfOperationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHoursOfOperationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHoursOfOperationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHoursOfOperationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHoursOfOperationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHoursOfOperationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHoursOfOperationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHoursOfOperationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateHoursOfOperationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateHoursOfOperationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateHoursOfOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateHoursOfOperationErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            UpdateHoursOfOperationErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateHoursOfOperationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateHoursOfOperationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateHoursOfOperationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateHoursOfOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInstanceAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInstanceAttributeError {
    /// Kind of error that occurred.
    pub kind: UpdateInstanceAttributeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInstanceAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInstanceAttributeErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInstanceAttributeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInstanceAttributeErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateInstanceAttributeErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateInstanceAttributeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateInstanceAttributeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateInstanceAttributeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateInstanceAttributeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInstanceAttributeError {
    fn code(&self) -> Option<&str> {
        UpdateInstanceAttributeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInstanceAttributeError {
    /// Creates a new `UpdateInstanceAttributeError`.
    pub fn new(kind: UpdateInstanceAttributeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInstanceAttributeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInstanceAttributeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInstanceAttributeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInstanceAttributeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInstanceAttributeErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAttributeErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAttributeErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAttributeErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAttributeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAttributeErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAttributeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAttributeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceAttributeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceAttributeErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateInstanceAttributeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInstanceAttributeErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateInstanceAttributeErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateInstanceAttributeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateInstanceAttributeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateInstanceAttributeErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateInstanceAttributeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateInstanceStorageConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateInstanceStorageConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateInstanceStorageConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateInstanceStorageConfigErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateInstanceStorageConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateInstanceStorageConfigErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateInstanceStorageConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateInstanceStorageConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateInstanceStorageConfigError {
    fn code(&self) -> Option<&str> {
        UpdateInstanceStorageConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateInstanceStorageConfigError {
    /// Creates a new `UpdateInstanceStorageConfigError`.
    pub fn new(kind: UpdateInstanceStorageConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateInstanceStorageConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateInstanceStorageConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateInstanceStorageConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateInstanceStorageConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateInstanceStorageConfigErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceStorageConfigErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceStorageConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceStorageConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceStorageConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceStorageConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceStorageConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceStorageConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateInstanceStorageConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateInstanceStorageConfigErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateInstanceStorageConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateInstanceStorageConfigErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateInstanceStorageConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateInstanceStorageConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateInstanceStorageConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateInstanceStorageConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateInstanceStorageConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQueueHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQueueHoursOfOperationError {
    /// Kind of error that occurred.
    pub kind: UpdateQueueHoursOfOperationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQueueHoursOfOperation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQueueHoursOfOperationErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQueueHoursOfOperationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQueueHoursOfOperationErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateQueueHoursOfOperationErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQueueHoursOfOperationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateQueueHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQueueHoursOfOperationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQueueHoursOfOperationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQueueHoursOfOperationError {
    fn code(&self) -> Option<&str> {
        UpdateQueueHoursOfOperationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQueueHoursOfOperationError {
    /// Creates a new `UpdateQueueHoursOfOperationError`.
    pub fn new(kind: UpdateQueueHoursOfOperationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQueueHoursOfOperationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQueueHoursOfOperationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQueueHoursOfOperationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQueueHoursOfOperationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQueueHoursOfOperationErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueHoursOfOperationErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueHoursOfOperationErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueHoursOfOperationErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueHoursOfOperationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueHoursOfOperationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueHoursOfOperationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueHoursOfOperationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueHoursOfOperationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueHoursOfOperationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateQueueHoursOfOperationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQueueHoursOfOperationErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateQueueHoursOfOperationErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateQueueHoursOfOperationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateQueueHoursOfOperationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateQueueHoursOfOperationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQueueHoursOfOperationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQueueMaxContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQueueMaxContactsError {
    /// Kind of error that occurred.
    pub kind: UpdateQueueMaxContactsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQueueMaxContacts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQueueMaxContactsErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQueueMaxContactsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQueueMaxContactsErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateQueueMaxContactsErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateQueueMaxContactsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateQueueMaxContactsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateQueueMaxContactsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQueueMaxContactsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQueueMaxContactsError {
    fn code(&self) -> Option<&str> {
        UpdateQueueMaxContactsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQueueMaxContactsError {
    /// Creates a new `UpdateQueueMaxContactsError`.
    pub fn new(kind: UpdateQueueMaxContactsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQueueMaxContactsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQueueMaxContactsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQueueMaxContactsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQueueMaxContactsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQueueMaxContactsErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueMaxContactsErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueMaxContactsErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueMaxContactsErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueMaxContactsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueMaxContactsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueMaxContactsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueMaxContactsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueMaxContactsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueMaxContactsErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateQueueMaxContactsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQueueMaxContactsErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateQueueMaxContactsErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateQueueMaxContactsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateQueueMaxContactsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateQueueMaxContactsErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQueueMaxContactsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQueueName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQueueNameError {
    /// Kind of error that occurred.
    pub kind: UpdateQueueNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQueueName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQueueNameErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQueueNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQueueNameErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            UpdateQueueNameErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateQueueNameErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateQueueNameErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateQueueNameErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateQueueNameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQueueNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQueueNameError {
    fn code(&self) -> Option<&str> {
        UpdateQueueNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQueueNameError {
    /// Creates a new `UpdateQueueNameError`.
    pub fn new(kind: UpdateQueueNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQueueNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQueueNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQueueNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQueueNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQueueNameErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueNameErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueNameErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueNameErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueNameErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueNameErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueNameErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueNameErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueNameErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueNameErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueNameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateQueueNameErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateQueueNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQueueNameErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            UpdateQueueNameErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateQueueNameErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateQueueNameErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateQueueNameErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateQueueNameErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQueueNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQueueOutboundCallerConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQueueOutboundCallerConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateQueueOutboundCallerConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQueueOutboundCallerConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQueueOutboundCallerConfigErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQueueOutboundCallerConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQueueOutboundCallerConfigErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQueueOutboundCallerConfigErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQueueOutboundCallerConfigErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQueueOutboundCallerConfigErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateQueueOutboundCallerConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQueueOutboundCallerConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQueueOutboundCallerConfigError {
    fn code(&self) -> Option<&str> {
        UpdateQueueOutboundCallerConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQueueOutboundCallerConfigError {
    /// Creates a new `UpdateQueueOutboundCallerConfigError`.
    pub fn new(
        kind: UpdateQueueOutboundCallerConfigErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQueueOutboundCallerConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQueueOutboundCallerConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQueueOutboundCallerConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQueueOutboundCallerConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQueueOutboundCallerConfigErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueOutboundCallerConfigErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueOutboundCallerConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueOutboundCallerConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueOutboundCallerConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueOutboundCallerConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueOutboundCallerConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueOutboundCallerConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueOutboundCallerConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueOutboundCallerConfigErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateQueueOutboundCallerConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQueueOutboundCallerConfigErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            UpdateQueueOutboundCallerConfigErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateQueueOutboundCallerConfigErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateQueueOutboundCallerConfigErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateQueueOutboundCallerConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQueueOutboundCallerConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQueueStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQueueStatusError {
    /// Kind of error that occurred.
    pub kind: UpdateQueueStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQueueStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQueueStatusErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQueueStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQueueStatusErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateQueueStatusErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateQueueStatusErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateQueueStatusErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateQueueStatusErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQueueStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQueueStatusError {
    fn code(&self) -> Option<&str> {
        UpdateQueueStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQueueStatusError {
    /// Creates a new `UpdateQueueStatusError`.
    pub fn new(kind: UpdateQueueStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQueueStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQueueStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQueueStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQueueStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQueueStatusErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueStatusErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueStatusErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueStatusErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueStatusErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueStatusErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueStatusErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueStatusErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueStatusErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueStatusErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateQueueStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQueueStatusErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateQueueStatusErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateQueueStatusErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateQueueStatusErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateQueueStatusErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQueueStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQuickConnectConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQuickConnectConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateQuickConnectConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQuickConnectConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQuickConnectConfigErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQuickConnectConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQuickConnectConfigErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateQuickConnectConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateQuickConnectConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateQuickConnectConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateQuickConnectConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQuickConnectConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQuickConnectConfigError {
    fn code(&self) -> Option<&str> {
        UpdateQuickConnectConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQuickConnectConfigError {
    /// Creates a new `UpdateQuickConnectConfigError`.
    pub fn new(kind: UpdateQuickConnectConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQuickConnectConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQuickConnectConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQuickConnectConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQuickConnectConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectConfigErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectConfigErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectConfigErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateQuickConnectConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQuickConnectConfigErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateQuickConnectConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateQuickConnectConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateQuickConnectConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateQuickConnectConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQuickConnectConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQuickConnectName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQuickConnectNameError {
    /// Kind of error that occurred.
    pub kind: UpdateQuickConnectNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQuickConnectName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQuickConnectNameErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQuickConnectNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQuickConnectNameErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateQuickConnectNameErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateQuickConnectNameErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateQuickConnectNameErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateQuickConnectNameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateQuickConnectNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQuickConnectNameError {
    fn code(&self) -> Option<&str> {
        UpdateQuickConnectNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQuickConnectNameError {
    /// Creates a new `UpdateQuickConnectNameError`.
    pub fn new(kind: UpdateQuickConnectNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQuickConnectNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQuickConnectNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQuickConnectNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQuickConnectNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectNameErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectNameErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectNameErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectNameErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectNameErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectNameErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectNameErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectNameErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQuickConnectNameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQuickConnectNameErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateQuickConnectNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQuickConnectNameErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateQuickConnectNameErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateQuickConnectNameErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateQuickConnectNameErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateQuickConnectNameErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateQuickConnectNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoutingProfileConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoutingProfileConcurrencyError {
    /// Kind of error that occurred.
    pub kind: UpdateRoutingProfileConcurrencyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoutingProfileConcurrency` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoutingProfileConcurrencyErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoutingProfileConcurrencyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoutingProfileConcurrencyErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingProfileConcurrencyErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingProfileConcurrencyErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingProfileConcurrencyErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingProfileConcurrencyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileConcurrencyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoutingProfileConcurrencyError {
    fn code(&self) -> Option<&str> {
        UpdateRoutingProfileConcurrencyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoutingProfileConcurrencyError {
    /// Creates a new `UpdateRoutingProfileConcurrencyError`.
    pub fn new(
        kind: UpdateRoutingProfileConcurrencyErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoutingProfileConcurrencyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoutingProfileConcurrencyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoutingProfileConcurrencyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoutingProfileConcurrencyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileConcurrencyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileConcurrencyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileConcurrencyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileConcurrencyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileConcurrencyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileConcurrencyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileConcurrencyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileConcurrencyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileConcurrencyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileConcurrencyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateRoutingProfileConcurrencyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoutingProfileConcurrencyErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingProfileConcurrencyErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingProfileConcurrencyErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingProfileConcurrencyErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingProfileConcurrencyErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRoutingProfileConcurrencyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoutingProfileDefaultOutboundQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoutingProfileDefaultOutboundQueueError {
    /// Kind of error that occurred.
    pub kind: UpdateRoutingProfileDefaultOutboundQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoutingProfileDefaultOutboundQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoutingProfileDefaultOutboundQueueErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoutingProfileDefaultOutboundQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidParameterException(
                _inner,
            ) => _inner.fmt(f),
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidRequestException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::ResourceNotFoundException(
                _inner,
            ) => _inner.fmt(f),
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoutingProfileDefaultOutboundQueueError {
    fn code(&self) -> Option<&str> {
        UpdateRoutingProfileDefaultOutboundQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoutingProfileDefaultOutboundQueueError {
    /// Creates a new `UpdateRoutingProfileDefaultOutboundQueueError`.
    pub fn new(
        kind: UpdateRoutingProfileDefaultOutboundQueueErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoutingProfileDefaultOutboundQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoutingProfileDefaultOutboundQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoutingProfileDefaultOutboundQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoutingProfileDefaultOutboundQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileDefaultOutboundQueueErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileDefaultOutboundQueueErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileDefaultOutboundQueueErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateRoutingProfileDefaultOutboundQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InternalServiceException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidParameterException(
                _inner,
            ) => Some(_inner),
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::InvalidRequestException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::ResourceNotFoundException(
                _inner,
            ) => Some(_inner),
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            UpdateRoutingProfileDefaultOutboundQueueErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `UpdateRoutingProfileName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoutingProfileNameError {
    /// Kind of error that occurred.
    pub kind: UpdateRoutingProfileNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoutingProfileName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoutingProfileNameErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoutingProfileNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoutingProfileNameErrorKind::DuplicateResourceException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileNameErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileNameErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileNameErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileNameErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileNameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoutingProfileNameError {
    fn code(&self) -> Option<&str> {
        UpdateRoutingProfileNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoutingProfileNameError {
    /// Creates a new `UpdateRoutingProfileNameError`.
    pub fn new(kind: UpdateRoutingProfileNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoutingProfileNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoutingProfileNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoutingProfileNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoutingProfileNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileNameErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileNameErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileNameErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileNameErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileNameErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileNameErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileNameErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileNameErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileNameErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileNameErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileNameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileNameErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateRoutingProfileNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoutingProfileNameErrorKind::DuplicateResourceException(_inner) => Some(_inner),
            UpdateRoutingProfileNameErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateRoutingProfileNameErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateRoutingProfileNameErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateRoutingProfileNameErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRoutingProfileNameErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRoutingProfileNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateRoutingProfileQueuesError {
    /// Kind of error that occurred.
    pub kind: UpdateRoutingProfileQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateRoutingProfileQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateRoutingProfileQueuesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateRoutingProfileQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateRoutingProfileQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateRoutingProfileQueuesError {
    fn code(&self) -> Option<&str> {
        UpdateRoutingProfileQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateRoutingProfileQueuesError {
    /// Creates a new `UpdateRoutingProfileQueuesError`.
    pub fn new(kind: UpdateRoutingProfileQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateRoutingProfileQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateRoutingProfileQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateRoutingProfileQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateRoutingProfileQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileQueuesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileQueuesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileQueuesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileQueuesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileQueuesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileQueuesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileQueuesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateRoutingProfileQueuesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateRoutingProfileQueuesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateRoutingProfileQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateRoutingProfileQueuesErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateRoutingProfileQueuesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateRoutingProfileQueuesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateRoutingProfileQueuesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateRoutingProfileQueuesErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateRoutingProfileQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateSecurityProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateSecurityProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateSecurityProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateSecurityProfileErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateSecurityProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateSecurityProfileErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateSecurityProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateSecurityProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateSecurityProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateSecurityProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateSecurityProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateSecurityProfileError {
    fn code(&self) -> Option<&str> {
        UpdateSecurityProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateSecurityProfileError {
    /// Creates a new `UpdateSecurityProfileError`.
    pub fn new(kind: UpdateSecurityProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateSecurityProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateSecurityProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateSecurityProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateSecurityProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateSecurityProfileErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSecurityProfileErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSecurityProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSecurityProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSecurityProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSecurityProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSecurityProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSecurityProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateSecurityProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateSecurityProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateSecurityProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateSecurityProfileErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateSecurityProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateSecurityProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateSecurityProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateSecurityProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateSecurityProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserHierarchy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserHierarchyError {
    /// Kind of error that occurred.
    pub kind: UpdateUserHierarchyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserHierarchy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserHierarchyErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserHierarchyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserHierarchyErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserHierarchyError {
    fn code(&self) -> Option<&str> {
        UpdateUserHierarchyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserHierarchyError {
    /// Creates a new `UpdateUserHierarchyError`.
    pub fn new(kind: UpdateUserHierarchyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserHierarchyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserHierarchyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserHierarchyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserHierarchyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateUserHierarchyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserHierarchyErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserHierarchyErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserHierarchyErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserHierarchyErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserHierarchyErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserHierarchyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserHierarchyGroupName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserHierarchyGroupNameError {
    /// Kind of error that occurred.
    pub kind: UpdateUserHierarchyGroupNameErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserHierarchyGroupName` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserHierarchyGroupNameErrorKind {
    /// <p>A resource with the specified name already exists.</p>
    DuplicateResourceException(crate::error::DuplicateResourceException),
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserHierarchyGroupNameError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserHierarchyGroupNameErrorKind::DuplicateResourceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserHierarchyGroupNameErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserHierarchyGroupNameErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserHierarchyGroupNameErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyGroupNameErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserHierarchyGroupNameErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyGroupNameErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserHierarchyGroupNameError {
    fn code(&self) -> Option<&str> {
        UpdateUserHierarchyGroupNameError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserHierarchyGroupNameError {
    /// Creates a new `UpdateUserHierarchyGroupNameError`.
    pub fn new(kind: UpdateUserHierarchyGroupNameErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserHierarchyGroupNameError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserHierarchyGroupNameErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserHierarchyGroupNameError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserHierarchyGroupNameErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyGroupNameErrorKind::DuplicateResourceException`.
    pub fn is_duplicate_resource_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyGroupNameErrorKind::DuplicateResourceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyGroupNameErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyGroupNameErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyGroupNameErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyGroupNameErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyGroupNameErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyGroupNameErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyGroupNameErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyGroupNameErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyGroupNameErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyGroupNameErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateUserHierarchyGroupNameError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserHierarchyGroupNameErrorKind::DuplicateResourceException(_inner) => {
                Some(_inner)
            }
            UpdateUserHierarchyGroupNameErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserHierarchyGroupNameErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateUserHierarchyGroupNameErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserHierarchyGroupNameErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateUserHierarchyGroupNameErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserHierarchyGroupNameErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserHierarchyStructure` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserHierarchyStructureError {
    /// Kind of error that occurred.
    pub kind: UpdateUserHierarchyStructureErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserHierarchyStructure` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserHierarchyStructureErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>That resource is already in use. Please try another.</p>
    ResourceInUseException(crate::error::ResourceInUseException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserHierarchyStructureError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserHierarchyStructureErrorKind::InternalServiceException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserHierarchyStructureErrorKind::InvalidParameterException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserHierarchyStructureErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyStructureErrorKind::ResourceInUseException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyStructureErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateUserHierarchyStructureErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserHierarchyStructureErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserHierarchyStructureError {
    fn code(&self) -> Option<&str> {
        UpdateUserHierarchyStructureError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserHierarchyStructureError {
    /// Creates a new `UpdateUserHierarchyStructureError`.
    pub fn new(kind: UpdateUserHierarchyStructureErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserHierarchyStructureError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserHierarchyStructureErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserHierarchyStructureError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserHierarchyStructureErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyStructureErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyStructureErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyStructureErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyStructureErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyStructureErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyStructureErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyStructureErrorKind::ResourceInUseException`.
    pub fn is_resource_in_use_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyStructureErrorKind::ResourceInUseException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyStructureErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyStructureErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserHierarchyStructureErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserHierarchyStructureErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateUserHierarchyStructureError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserHierarchyStructureErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserHierarchyStructureErrorKind::InvalidParameterException(_inner) => {
                Some(_inner)
            }
            UpdateUserHierarchyStructureErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserHierarchyStructureErrorKind::ResourceInUseException(_inner) => Some(_inner),
            UpdateUserHierarchyStructureErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateUserHierarchyStructureErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserHierarchyStructureErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserIdentityInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserIdentityInfoError {
    /// Kind of error that occurred.
    pub kind: UpdateUserIdentityInfoErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserIdentityInfo` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserIdentityInfoErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserIdentityInfoError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserIdentityInfoErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateUserIdentityInfoErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserIdentityInfoErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserIdentityInfoErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserIdentityInfoErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserIdentityInfoErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserIdentityInfoError {
    fn code(&self) -> Option<&str> {
        UpdateUserIdentityInfoError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserIdentityInfoError {
    /// Creates a new `UpdateUserIdentityInfoError`.
    pub fn new(kind: UpdateUserIdentityInfoErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserIdentityInfoError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserIdentityInfoErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserIdentityInfoError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserIdentityInfoErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserIdentityInfoErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserIdentityInfoErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserIdentityInfoErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserIdentityInfoErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserIdentityInfoErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserIdentityInfoErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserIdentityInfoErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserIdentityInfoErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserIdentityInfoErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserIdentityInfoErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateUserIdentityInfoError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserIdentityInfoErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserIdentityInfoErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserIdentityInfoErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserIdentityInfoErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserIdentityInfoErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserIdentityInfoErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserPhoneConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserPhoneConfigError {
    /// Kind of error that occurred.
    pub kind: UpdateUserPhoneConfigErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserPhoneConfig` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserPhoneConfigErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserPhoneConfigError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserPhoneConfigErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateUserPhoneConfigErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserPhoneConfigErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserPhoneConfigErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserPhoneConfigErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserPhoneConfigErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserPhoneConfigError {
    fn code(&self) -> Option<&str> {
        UpdateUserPhoneConfigError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserPhoneConfigError {
    /// Creates a new `UpdateUserPhoneConfigError`.
    pub fn new(kind: UpdateUserPhoneConfigErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserPhoneConfigError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserPhoneConfigErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserPhoneConfigError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserPhoneConfigErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserPhoneConfigErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPhoneConfigErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPhoneConfigErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPhoneConfigErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPhoneConfigErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPhoneConfigErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPhoneConfigErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPhoneConfigErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserPhoneConfigErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserPhoneConfigErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateUserPhoneConfigError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserPhoneConfigErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserPhoneConfigErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserPhoneConfigErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserPhoneConfigErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserPhoneConfigErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserPhoneConfigErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserRoutingProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserRoutingProfileError {
    /// Kind of error that occurred.
    pub kind: UpdateUserRoutingProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserRoutingProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserRoutingProfileErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserRoutingProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserRoutingProfileErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateUserRoutingProfileErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserRoutingProfileErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserRoutingProfileErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserRoutingProfileErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserRoutingProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserRoutingProfileError {
    fn code(&self) -> Option<&str> {
        UpdateUserRoutingProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserRoutingProfileError {
    /// Creates a new `UpdateUserRoutingProfileError`.
    pub fn new(kind: UpdateUserRoutingProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserRoutingProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserRoutingProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserRoutingProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserRoutingProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserRoutingProfileErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserRoutingProfileErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserRoutingProfileErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserRoutingProfileErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserRoutingProfileErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserRoutingProfileErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserRoutingProfileErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserRoutingProfileErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserRoutingProfileErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserRoutingProfileErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateUserRoutingProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserRoutingProfileErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserRoutingProfileErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserRoutingProfileErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserRoutingProfileErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserRoutingProfileErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserRoutingProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateUserSecurityProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateUserSecurityProfilesError {
    /// Kind of error that occurred.
    pub kind: UpdateUserSecurityProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateUserSecurityProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateUserSecurityProfilesErrorKind {
    /// <p>Request processing failed because of an error or failure with the service.</p>
    InternalServiceException(crate::error::InternalServiceException),
    /// <p>One or more of the specified parameters are not valid.</p>
    InvalidParameterException(crate::error::InvalidParameterException),
    /// <p>The request is not valid.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The specified resource was not found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The throttling limit has been exceeded.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateUserSecurityProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateUserSecurityProfilesErrorKind::InternalServiceException(_inner) => _inner.fmt(f),
            UpdateUserSecurityProfilesErrorKind::InvalidParameterException(_inner) => _inner.fmt(f),
            UpdateUserSecurityProfilesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateUserSecurityProfilesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateUserSecurityProfilesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateUserSecurityProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateUserSecurityProfilesError {
    fn code(&self) -> Option<&str> {
        UpdateUserSecurityProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateUserSecurityProfilesError {
    /// Creates a new `UpdateUserSecurityProfilesError`.
    pub fn new(kind: UpdateUserSecurityProfilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateUserSecurityProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateUserSecurityProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateUserSecurityProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateUserSecurityProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateUserSecurityProfilesErrorKind::InternalServiceException`.
    pub fn is_internal_service_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSecurityProfilesErrorKind::InternalServiceException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSecurityProfilesErrorKind::InvalidParameterException`.
    pub fn is_invalid_parameter_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSecurityProfilesErrorKind::InvalidParameterException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSecurityProfilesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSecurityProfilesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSecurityProfilesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSecurityProfilesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateUserSecurityProfilesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateUserSecurityProfilesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for UpdateUserSecurityProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateUserSecurityProfilesErrorKind::InternalServiceException(_inner) => Some(_inner),
            UpdateUserSecurityProfilesErrorKind::InvalidParameterException(_inner) => Some(_inner),
            UpdateUserSecurityProfilesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateUserSecurityProfilesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateUserSecurityProfilesErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateUserSecurityProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The throttling limit has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The specified resource was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The message about the resource.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message about the resource.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message about the resource.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The request is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    /// <p>The message about the request.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message about the request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message about the request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>One or more of the specified parameters are not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidParameterException {
    /// <p>The message about the parameters.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidParameterException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidParameterException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidParameterException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidParameterException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidParameterException {}
/// See [`InvalidParameterException`](crate::error::InvalidParameterException)
pub mod invalid_parameter_exception {
    /// A builder for [`InvalidParameterException`](crate::error::InvalidParameterException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message about the parameters.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message about the parameters.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidParameterException`](crate::error::InvalidParameterException)
        pub fn build(self) -> crate::error::InvalidParameterException {
            crate::error::InvalidParameterException {
                message: self.message,
            }
        }
    }
}
impl InvalidParameterException {
    /// Creates a new builder-style object to manufacture [`InvalidParameterException`](crate::error::InvalidParameterException)
    pub fn builder() -> crate::error::invalid_parameter_exception::Builder {
        crate::error::invalid_parameter_exception::Builder::default()
    }
}

/// <p>Request processing failed because of an error or failure with the service.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceException {
    /// <p>The message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceException {}
/// See [`InternalServiceException`](crate::error::InternalServiceException)
pub mod internal_service_exception {
    /// A builder for [`InternalServiceException`](crate::error::InternalServiceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceException`](crate::error::InternalServiceException)
        pub fn build(self) -> crate::error::InternalServiceException {
            crate::error::InternalServiceException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceException {
    /// Creates a new builder-style object to manufacture [`InternalServiceException`](crate::error::InternalServiceException)
    pub fn builder() -> crate::error::internal_service_exception::Builder {
        crate::error::internal_service_exception::Builder::default()
    }
}

/// <p>That resource is already in use. Please try another.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceInUseException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The identifier for the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
}
impl ResourceInUseException {
    /// <p>The type of resource.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::ResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>The identifier for the resource.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
}
impl std::fmt::Debug for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceInUseException");
        formatter.field("message", &self.message);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("resource_id", &self.resource_id);
        formatter.finish()
    }
}
impl ResourceInUseException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceInUseException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceInUseException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceInUseException {}
/// See [`ResourceInUseException`](crate::error::ResourceInUseException)
pub mod resource_in_use_exception {
    /// A builder for [`ResourceInUseException`](crate::error::ResourceInUseException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The identifier for the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The identifier for the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceInUseException`](crate::error::ResourceInUseException)
        pub fn build(self) -> crate::error::ResourceInUseException {
            crate::error::ResourceInUseException {
                message: self.message,
                resource_type: self.resource_type,
                resource_id: self.resource_id,
            }
        }
    }
}
impl ResourceInUseException {
    /// Creates a new builder-style object to manufacture [`ResourceInUseException`](crate::error::ResourceInUseException)
    pub fn builder() -> crate::error::resource_in_use_exception::Builder {
        crate::error::resource_in_use_exception::Builder::default()
    }
}

/// <p>A resource with the specified name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DuplicateResourceException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DuplicateResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DuplicateResourceException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DuplicateResourceException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DuplicateResourceException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DuplicateResourceException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for DuplicateResourceException {}
/// See [`DuplicateResourceException`](crate::error::DuplicateResourceException)
pub mod duplicate_resource_exception {
    /// A builder for [`DuplicateResourceException`](crate::error::DuplicateResourceException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DuplicateResourceException`](crate::error::DuplicateResourceException)
        pub fn build(self) -> crate::error::DuplicateResourceException {
            crate::error::DuplicateResourceException {
                message: self.message,
            }
        }
    }
}
impl DuplicateResourceException {
    /// Creates a new builder-style object to manufacture [`DuplicateResourceException`](crate::error::DuplicateResourceException)
    pub fn builder() -> crate::error::duplicate_resource_exception::Builder {
        crate::error::duplicate_resource_exception::Builder::default()
    }
}

/// <p>The allowed limit for the resource has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    /// <p>The message about the limit.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message about the limit.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message about the limit.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

/// <p>The contact flow is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidContactFlowException {
    /// <p>The problems with the contact flow. Please fix before trying again.</p>
    pub problems: std::option::Option<std::vec::Vec<crate::model::ProblemDetail>>,
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl InvalidContactFlowException {
    /// <p>The problems with the contact flow. Please fix before trying again.</p>
    pub fn problems(&self) -> std::option::Option<&[crate::model::ProblemDetail]> {
        self.problems.as_deref()
    }
}
impl std::fmt::Debug for InvalidContactFlowException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidContactFlowException");
        formatter.field("problems", &self.problems);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidContactFlowException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidContactFlowException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidContactFlowException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidContactFlowException {}
/// See [`InvalidContactFlowException`](crate::error::InvalidContactFlowException)
pub mod invalid_contact_flow_exception {
    /// A builder for [`InvalidContactFlowException`](crate::error::InvalidContactFlowException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) problems: std::option::Option<std::vec::Vec<crate::model::ProblemDetail>>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `problems`.
        ///
        /// To override the contents of this collection use [`set_problems`](Self::set_problems).
        ///
        /// <p>The problems with the contact flow. Please fix before trying again.</p>
        pub fn problems(mut self, input: impl Into<crate::model::ProblemDetail>) -> Self {
            let mut v = self.problems.unwrap_or_default();
            v.push(input.into());
            self.problems = Some(v);
            self
        }
        /// <p>The problems with the contact flow. Please fix before trying again.</p>
        pub fn set_problems(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProblemDetail>>,
        ) -> Self {
            self.problems = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidContactFlowException`](crate::error::InvalidContactFlowException)
        pub fn build(self) -> crate::error::InvalidContactFlowException {
            crate::error::InvalidContactFlowException {
                problems: self.problems,
                message: self.message,
            }
        }
    }
}
impl InvalidContactFlowException {
    /// Creates a new builder-style object to manufacture [`InvalidContactFlowException`](crate::error::InvalidContactFlowException)
    pub fn builder() -> crate::error::invalid_contact_flow_exception::Builder {
        crate::error::invalid_contact_flow_exception::Builder::default()
    }
}

/// <p>The contact with the specified ID is not active or does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactNotFoundException {
    /// <p>The message.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContactNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ContactNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ContactNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ContactNotFoundException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ContactNotFoundException {}
/// See [`ContactNotFoundException`](crate::error::ContactNotFoundException)
pub mod contact_not_found_exception {
    /// A builder for [`ContactNotFoundException`](crate::error::ContactNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactNotFoundException`](crate::error::ContactNotFoundException)
        pub fn build(self) -> crate::error::ContactNotFoundException {
            crate::error::ContactNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ContactNotFoundException {
    /// Creates a new builder-style object to manufacture [`ContactNotFoundException`](crate::error::ContactNotFoundException)
    pub fn builder() -> crate::error::contact_not_found_exception::Builder {
        crate::error::contact_not_found_exception::Builder::default()
    }
}

/// <p>The service quota has been exceeded.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>The contact is not permitted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutboundContactNotPermittedException {
    /// <p>The message about the contact.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OutboundContactNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutboundContactNotPermittedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OutboundContactNotPermittedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OutboundContactNotPermittedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OutboundContactNotPermittedException")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for OutboundContactNotPermittedException {}
/// See [`OutboundContactNotPermittedException`](crate::error::OutboundContactNotPermittedException)
pub mod outbound_contact_not_permitted_exception {
    /// A builder for [`OutboundContactNotPermittedException`](crate::error::OutboundContactNotPermittedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message about the contact.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message about the contact.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OutboundContactNotPermittedException`](crate::error::OutboundContactNotPermittedException)
        pub fn build(self) -> crate::error::OutboundContactNotPermittedException {
            crate::error::OutboundContactNotPermittedException {
                message: self.message,
            }
        }
    }
}
impl OutboundContactNotPermittedException {
    /// Creates a new builder-style object to manufacture [`OutboundContactNotPermittedException`](crate::error::OutboundContactNotPermittedException)
    pub fn builder() -> crate::error::outbound_contact_not_permitted_exception::Builder {
        crate::error::outbound_contact_not_permitted_exception::Builder::default()
    }
}

/// <p>Outbound calls to the destination number are not allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationNotAllowedException {
    /// <p>The message about the outbound calls.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DestinationNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationNotAllowedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DestinationNotAllowedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DestinationNotAllowedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DestinationNotAllowedException")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for DestinationNotAllowedException {}
/// See [`DestinationNotAllowedException`](crate::error::DestinationNotAllowedException)
pub mod destination_not_allowed_exception {
    /// A builder for [`DestinationNotAllowedException`](crate::error::DestinationNotAllowedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The message about the outbound calls.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The message about the outbound calls.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationNotAllowedException`](crate::error::DestinationNotAllowedException)
        pub fn build(self) -> crate::error::DestinationNotAllowedException {
            crate::error::DestinationNotAllowedException {
                message: self.message,
            }
        }
    }
}
impl DestinationNotAllowedException {
    /// Creates a new builder-style object to manufacture [`DestinationNotAllowedException`](crate::error::DestinationNotAllowedException)
    pub fn builder() -> crate::error::destination_not_allowed_exception::Builder {
        crate::error::destination_not_allowed_exception::Builder::default()
    }
}

/// <p>No user with the specified credentials was found in the Amazon Connect instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UserNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UserNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UserNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UserNotFoundException")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for UserNotFoundException {}
/// See [`UserNotFoundException`](crate::error::UserNotFoundException)
pub mod user_not_found_exception {
    /// A builder for [`UserNotFoundException`](crate::error::UserNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UserNotFoundException`](crate::error::UserNotFoundException)
        pub fn build(self) -> crate::error::UserNotFoundException {
            crate::error::UserNotFoundException {
                message: self.message,
            }
        }
    }
}
impl UserNotFoundException {
    /// Creates a new builder-style object to manufacture [`UserNotFoundException`](crate::error::UserNotFoundException)
    pub fn builder() -> crate::error::user_not_found_exception::Builder {
        crate::error::user_not_found_exception::Builder::default()
    }
}

/// <p>The contact flow has not been published.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ContactFlowNotPublishedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ContactFlowNotPublishedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ContactFlowNotPublishedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ContactFlowNotPublishedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ContactFlowNotPublishedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ContactFlowNotPublishedException")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for ContactFlowNotPublishedException {}
/// See [`ContactFlowNotPublishedException`](crate::error::ContactFlowNotPublishedException)
pub mod contact_flow_not_published_exception {
    /// A builder for [`ContactFlowNotPublishedException`](crate::error::ContactFlowNotPublishedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ContactFlowNotPublishedException`](crate::error::ContactFlowNotPublishedException)
        pub fn build(self) -> crate::error::ContactFlowNotPublishedException {
            crate::error::ContactFlowNotPublishedException {
                message: self.message,
            }
        }
    }
}
impl ContactFlowNotPublishedException {
    /// Creates a new builder-style object to manufacture [`ContactFlowNotPublishedException`](crate::error::ContactFlowNotPublishedException)
    pub fn builder() -> crate::error::contact_flow_not_published_exception::Builder {
        crate::error::contact_flow_not_published_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>A resource already has that name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceConflictException")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceConflictException {}
/// See [`ResourceConflictException`](crate::error::ResourceConflictException)
pub mod resource_conflict_exception {
    /// A builder for [`ResourceConflictException`](crate::error::ResourceConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceConflictException`](crate::error::ResourceConflictException)
        pub fn build(self) -> crate::error::ResourceConflictException {
            crate::error::ResourceConflictException {
                message: self.message,
            }
        }
    }
}
impl ResourceConflictException {
    /// Creates a new builder-style object to manufacture [`ResourceConflictException`](crate::error::ResourceConflictException)
    pub fn builder() -> crate::error::resource_conflict_exception::Builder {
        crate::error::resource_conflict_exception::Builder::default()
    }
}
